/* VolumeItem.c generated by valac 0.56.14, the Vala compiler
 * generated from VolumeItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

enum  {
	VOLUME_ITEM_0_PROPERTY,
	VOLUME_ITEM_NUM_PROPERTIES
};
static GParamSpec* volume_item_properties[VOLUME_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _VolumeItemPrivate {
	MountHelper* operation;
	GtkRevealer* unlock_revealer;
	GVolume* volume;
	gboolean first_try;
};

static gint VolumeItem_private_offset;
static gpointer volume_item_parent_class = NULL;
static GType volume_item_type_id = 0;

static void __lambda8_ (VolumeItem* self,
                 const gchar* message);
static void ___lambda8__mount_helper_send_message (MountHelper* _sender,
                                            const gchar* message,
                                            gpointer self);
static void volume_item_on_password_asked (VolumeItem* self);
static void _volume_item_on_password_asked_mount_helper_password_asked (MountHelper* _sender,
                                                                 gpointer self);
static void volume_item_do_mount (VolumeItem* self);
static void _volume_item_do_mount_mount_helper_request_mount (MountHelper* _sender,
                                                       gpointer self);
static void volume_item_on_eject_button_clicked (VolumeItem* self);
static void _volume_item_on_eject_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void volume_item_on_name_button_clicked (VolumeItem* self);
static void _volume_item_on_name_button_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                  gpointer self);
static void volume_item_on_eject (VolumeItem* self,
                           GObject* obj,
                           GAsyncResult* res);
static void _volume_item_on_eject_gasync_ready_callback (GObject* source_object,
                                                  GAsyncResult* res,
                                                  gpointer self);
static void volume_item_on_mount (VolumeItem* self,
                           GObject* obj,
                           GAsyncResult* res);
static void _volume_item_on_mount_gasync_ready_callback (GObject* source_object,
                                                  GAsyncResult* res,
                                                  gpointer self);
static void volume_item_real_cancel_operation (ListItem* base);
static void volume_item_finalize (GObject * obj);

static inline gpointer
volume_item_get_instance_private (VolumeItem* self)
{
	return G_STRUCT_MEMBER_P (self, VolumeItem_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda8_ (VolumeItem* self,
            const gchar* message)
{
	g_return_if_fail (message != NULL);
	g_signal_emit_by_name ((ListItem*) self, "send-message", message);
}

static void
___lambda8__mount_helper_send_message (MountHelper* _sender,
                                       const gchar* message,
                                       gpointer self)
{
	__lambda8_ ((VolumeItem*) self, message);
}

static void
_volume_item_on_password_asked_mount_helper_password_asked (MountHelper* _sender,
                                                            gpointer self)
{
	volume_item_on_password_asked ((VolumeItem*) self);
}

static void
_volume_item_do_mount_mount_helper_request_mount (MountHelper* _sender,
                                                  gpointer self)
{
	volume_item_do_mount ((VolumeItem*) self);
}

static void
_volume_item_on_eject_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	volume_item_on_eject_button_clicked ((VolumeItem*) self);
}

static void
_volume_item_on_name_button_clicked_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                             gpointer self)
{
	volume_item_on_name_button_clicked ((VolumeItem*) self);
}

VolumeItem*
volume_item_construct (GType object_type,
                       GVolume* volume)
{
	VolumeItem * self = NULL;
	gchar* _tmp0_;
	GVolume* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GIcon* _tmp12_;
	GIcon* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkToolButton* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	MountHelper* _tmp21_;
	MountHelper* _tmp22_;
	MountHelper* _tmp23_;
	MountHelper* _tmp24_;
	GtkToolButton* _tmp35_;
	g_return_val_if_fail (volume != NULL, NULL);
	self = (VolumeItem*) list_item_construct (object_type);
	_tmp0_ = g_volume_get_identifier (volume, "class");
	_g_free0 (((ListItem*) self)->item_class);
	((ListItem*) self)->item_class = _tmp0_;
	_tmp1_ = _g_object_ref0 (volume);
	_g_object_unref0 (self->priv->volume);
	self->priv->volume = _tmp1_;
	_tmp2_ = ((ListItem*) self)->item_class;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				if (g_volume_can_eject (volume)) {
					gchar* _tmp6_;
					_tmp6_ = g_strdup (_ ("Removable devices"));
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp6_;
				} else {
					gchar* _tmp7_;
					_tmp7_ = g_strdup (_ ("Local volumes"));
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp7_;
				}
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup (_ ("Network folders"));
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp8_;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (_ ("Other"));
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp9_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp10_ = g_volume_get_name (volume);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_volume_get_symbolic_icon (volume);
	_tmp13_ = _tmp12_;
	_tmp14_ = list_item_get_icon ((ListItem*) self, _tmp13_);
	_tmp15_ = _tmp14_;
	list_item_set_button ((ListItem*) self, _tmp11_, _tmp15_, TRUE, g_volume_can_eject (volume));
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp16_ = ((ListItem*) self)->name_button;
	_tmp17_ = g_volume_get_name (volume);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup_printf (_ ("Mount and open \"%s\""), _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp16_, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_tmp21_ = mount_helper_new ();
	_g_object_unref0 (self->priv->operation);
	self->priv->operation = _tmp21_;
	_tmp22_ = self->priv->operation;
	g_signal_connect_object (_tmp22_, "send-message", (GCallback) ___lambda8__mount_helper_send_message, self, 0);
	_tmp23_ = self->priv->operation;
	g_signal_connect_object (_tmp23_, "password-asked", (GCallback) _volume_item_on_password_asked_mount_helper_password_asked, self, 0);
	_tmp24_ = self->priv->operation;
	g_signal_connect_object (_tmp24_, "request-mount", (GCallback) _volume_item_do_mount_mount_helper_request_mount, self, 0);
	if (g_volume_can_eject (volume)) {
		GtkButton* eject_button = NULL;
		GtkButton* _tmp25_;
		GtkButton* _tmp26_;
		GtkStyleContext* _tmp27_;
		GtkButton* _tmp28_;
		GtkButton* _tmp29_;
		GtkButton* _tmp30_;
		GtkButton* _tmp31_;
		GtkOverlay* _tmp32_;
		GtkButton* _tmp33_;
		GtkButton* _tmp34_;
		_tmp25_ = (GtkButton*) gtk_button_new_from_icon_name ("media-eject-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp25_);
		eject_button = _tmp25_;
		_tmp26_ = eject_button;
		_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
		gtk_style_context_add_class (_tmp27_, "unmount-button");
		_tmp28_ = eject_button;
		gtk_button_set_relief (_tmp28_, GTK_RELIEF_NONE);
		_tmp29_ = eject_button;
		gtk_widget_set_can_focus ((GtkWidget*) _tmp29_, FALSE);
		_tmp30_ = eject_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp30_, GTK_ALIGN_END);
		_tmp31_ = eject_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _ ("Eject"));
		_tmp32_ = ((ListItem*) self)->overlay;
		_tmp33_ = eject_button;
		gtk_overlay_add_overlay (_tmp32_, (GtkWidget*) _tmp33_);
		_tmp34_ = eject_button;
		g_signal_connect_object (_tmp34_, "clicked", (GCallback) _volume_item_on_eject_button_clicked_gtk_button_clicked, self, 0);
		_g_object_unref0 (eject_button);
	}
	_tmp35_ = ((ListItem*) self)->name_button;
	g_signal_connect_object (_tmp35_, "clicked", (GCallback) _volume_item_on_name_button_clicked_gtk_tool_button_clicked, self, 0);
	return self;
}

VolumeItem*
volume_item_new (GVolume* volume)
{
	return volume_item_construct (TYPE_VOLUME_ITEM, volume);
}

static void
_volume_item_on_eject_gasync_ready_callback (GObject* source_object,
                                             GAsyncResult* res,
                                             gpointer self)
{
	volume_item_on_eject ((VolumeItem*) self, source_object, res);
	g_object_unref (self);
}

static void
volume_item_on_eject_button_clicked (VolumeItem* self)
{
	GVolume* _tmp0_;
	MountHelper* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->volume;
	_tmp1_ = self->priv->operation;
	g_volume_eject_with_operation (_tmp0_, G_MOUNT_UNMOUNT_NONE, (GMountOperation*) _tmp1_, NULL, _volume_item_on_eject_gasync_ready_callback, g_object_ref (self));
}

static void
volume_item_on_name_button_clicked (VolumeItem* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unlock_revealer;
	if (_tmp0_ == NULL) {
		volume_item_do_mount (self);
	} else {
		GtkRevealer* _tmp1_;
		GtkRevealer* _tmp2_;
		GtkRevealer* _tmp3_;
		MountHelper* _tmp4_;
		GtkEntry* _tmp5_;
		GtkEntry* _tmp6_;
		_tmp1_ = self->priv->unlock_revealer;
		if (!gtk_revealer_get_child_revealed (_tmp1_)) {
			g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("Enter the encryption passphrase to unlock this volume"));
		}
		_tmp2_ = self->priv->unlock_revealer;
		_tmp3_ = self->priv->unlock_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, !gtk_revealer_get_child_revealed (_tmp3_));
		_tmp4_ = self->priv->operation;
		_tmp5_ = mount_helper_get_password_entry (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
volume_item_on_eject (VolumeItem* self,
                      GObject* obj,
                      GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	{
		GVolume* _tmp0_;
		gchar* safe_remove = NULL;
		gchar* _tmp1_;
		gchar* device_name = NULL;
		GVolume* _tmp2_;
		GDrive* _tmp3_;
		GDrive* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp0_ = self->priv->volume;
		g_volume_eject_with_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_strdup (_ ("You can now safely remove"));
		safe_remove = _tmp1_;
		_tmp2_ = self->priv->volume;
		_tmp3_ = g_volume_get_drive (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_drive_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		device_name = _tmp6_;
		_tmp7_ = safe_remove;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = device_name;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat (_tmp8_, " \"", _tmp10_, "\"", NULL);
		_tmp12_ = _tmp11_;
		g_signal_emit_by_name ((ListItem*) self, "send-message", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (device_name);
		_g_free0 (safe_remove);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_signal_emit_by_name ((ListItem*) self, "send-message", _tmp14_);
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("VolumeItem.vala:88: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
volume_item_on_password_asked (VolumeItem* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp4_;
	MountHelper* _tmp5_;
	GtkEntry* _tmp6_;
	GtkEntry* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unlock_revealer;
	if (_tmp0_ == NULL) {
		MountHelper* _tmp1_;
		GtkRevealer* _tmp2_;
		GtkRevealer* _tmp3_;
		_tmp1_ = self->priv->operation;
		_tmp2_ = mount_helper_get_encryption_form (_tmp1_);
		_g_object_unref0 (self->priv->unlock_revealer);
		self->priv->unlock_revealer = _tmp2_;
		_tmp3_ = self->priv->unlock_revealer;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp3_, TRUE, TRUE, (guint) 0);
	}
	_tmp4_ = self->priv->unlock_revealer;
	gtk_revealer_set_reveal_child (_tmp4_, TRUE);
	_tmp5_ = self->priv->operation;
	_tmp6_ = mount_helper_get_password_entry (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
}

static void
_volume_item_on_mount_gasync_ready_callback (GObject* source_object,
                                             GAsyncResult* res,
                                             gpointer self)
{
	volume_item_on_mount ((VolumeItem*) self, source_object, res);
	g_object_unref (self);
}

static void
volume_item_do_mount (VolumeItem* self)
{
	GtkSpinner* _tmp0_;
	GVolume* _tmp1_;
	MountHelper* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((ListItem*) self)->spin;
	gtk_spinner_start (_tmp0_);
	_tmp1_ = self->priv->volume;
	_tmp2_ = self->priv->operation;
	g_volume_mount (_tmp1_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _tmp2_, NULL, _volume_item_on_mount_gasync_ready_callback, g_object_ref (self));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
volume_item_on_mount (VolumeItem* self,
                      GObject* obj,
                      GAsyncResult* res)
{
	GtkSpinner* _tmp12_;
	GtkRevealer* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	{
		GVolume* _tmp0_;
		GVolume* _tmp1_;
		GMount* _tmp2_;
		GMount* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp0_ = self->priv->volume;
		g_volume_mount_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->volume;
		_tmp2_ = g_volume_get_mount (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_mount_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		list_item_open_directory ((ListItem*) self, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		if (string_contains (_tmp7_, "No key available with this passphrase")) {
			g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("The password you entered is incorrect"));
		} else {
			gboolean _tmp8_ = FALSE;
			if (self->priv->first_try) {
				GtkRevealer* _tmp9_;
				_tmp9_ = self->priv->unlock_revealer;
				_tmp8_ = _tmp9_ != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("Enter the encryption passphrase to unlock this volume"));
			} else {
				g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("An unknown error occurred while attempting to mount this volume"));
			}
		}
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_message ("VolumeItem.vala:118: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = ((ListItem*) self)->spin;
	gtk_spinner_stop (_tmp12_);
	_tmp13_ = self->priv->unlock_revealer;
	if (_tmp13_ != NULL) {
		GtkRevealer* _tmp14_;
		MountHelper* _tmp15_;
		GtkEntry* _tmp16_;
		GtkEntry* _tmp17_;
		_tmp14_ = self->priv->unlock_revealer;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
		_tmp15_ = self->priv->operation;
		_tmp16_ = mount_helper_get_password_entry (_tmp15_);
		_tmp17_ = _tmp16_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp17_);
		_g_object_unref0 (_tmp17_);
	}
	self->priv->first_try = FALSE;
}

static void
volume_item_real_cancel_operation (ListItem* base)
{
	VolumeItem * self;
	GtkRevealer* _tmp0_;
	GtkEntry* entry = NULL;
	MountHelper* _tmp1_;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkRevealer* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkRevealer* _tmp6_;
	self = (VolumeItem*) base;
	_tmp0_ = self->priv->unlock_revealer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->operation;
	_tmp2_ = mount_helper_get_password_entry (_tmp1_);
	entry = _tmp2_;
	_tmp3_ = entry;
	gtk_entry_set_text (_tmp3_, "");
	_tmp4_ = self->priv->unlock_revealer;
	gtk_revealer_set_transition_type (_tmp4_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp5_ = self->priv->unlock_revealer;
	gtk_revealer_set_reveal_child (_tmp5_, FALSE);
	_tmp6_ = self->priv->unlock_revealer;
	gtk_revealer_set_transition_type (_tmp6_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	_g_object_unref0 (entry);
}

static void
volume_item_class_init (VolumeItemClass * klass,
                        gpointer klass_data)
{
	volume_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VolumeItem_private_offset);
	((ListItemClass *) klass)->cancel_operation = (void (*) (ListItem*)) volume_item_real_cancel_operation;
	G_OBJECT_CLASS (klass)->finalize = volume_item_finalize;
}

static void
volume_item_instance_init (VolumeItem * self,
                           gpointer klass)
{
	self->priv = volume_item_get_instance_private (self);
	self->priv->unlock_revealer = NULL;
	self->priv->first_try = TRUE;
}

static void
volume_item_finalize (GObject * obj)
{
	VolumeItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VOLUME_ITEM, VolumeItem);
	_g_object_unref0 (self->priv->operation);
	_g_object_unref0 (self->priv->unlock_revealer);
	_g_object_unref0 (self->priv->volume);
	G_OBJECT_CLASS (volume_item_parent_class)->finalize (obj);
}

GType
volume_item_get_type (void)
{
	return volume_item_type_id;
}

GType
volume_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (VolumeItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) volume_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VolumeItem), 0, (GInstanceInitFunc) volume_item_instance_init, NULL };
	volume_item_type_id = g_type_module_register_type (module, TYPE_LIST_ITEM, "VolumeItem", &g_define_type_info, 0);
	VolumeItem_private_offset = sizeof (VolumeItemPrivate);
	return volume_item_type_id;
}

