/* UserButton.c generated by valac 0.56.14, the Vala compiler
 * generated from UserButton.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define USER_BUTTON_ACCOUNTSSERVICE_ACC "org.freedesktop.Accounts"
#define USER_BUTTON_ACCOUNTSSERVICE_USER "org.freedesktop.Accounts.User"

#define TYPE_ACCOUNTS_REMOTE (accounts_remote_get_type ())
#define ACCOUNTS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNTS_REMOTE, AccountsRemote))
#define IS_ACCOUNTS_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNTS_REMOTE))
#define ACCOUNTS_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNTS_REMOTE, AccountsRemoteIface))

typedef struct _AccountsRemote AccountsRemote;
typedef struct _AccountsRemoteIface AccountsRemoteIface;

#define TYPE_ACCOUNTS_REMOTE_PROXY (accounts_remote_proxy_get_type ())

#define TYPE_ACCOUNT_USER_REMOTE (account_user_remote_get_type ())
#define ACCOUNT_USER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_USER_REMOTE, AccountUserRemote))
#define IS_ACCOUNT_USER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_USER_REMOTE))
#define ACCOUNT_USER_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ACCOUNT_USER_REMOTE, AccountUserRemoteIface))

typedef struct _AccountUserRemote AccountUserRemote;
typedef struct _AccountUserRemoteIface AccountUserRemoteIface;

#define TYPE_ACCOUNT_USER_REMOTE_PROXY (account_user_remote_proxy_get_type ())

#define TYPE_PROPERTIES_REMOTE (properties_remote_get_type ())
#define PROPERTIES_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTIES_REMOTE, PropertiesRemote))
#define IS_PROPERTIES_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTIES_REMOTE))
#define PROPERTIES_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PROPERTIES_REMOTE, PropertiesRemoteIface))

typedef struct _PropertiesRemote PropertiesRemote;
typedef struct _PropertiesRemoteIface PropertiesRemoteIface;

#define TYPE_PROPERTIES_REMOTE_PROXY (properties_remote_proxy_get_type ())
enum  {
	USER_BUTTON_0_PROPERTY,
	USER_BUTTON_NUM_PROPERTIES
};
static GParamSpec* user_button_properties[USER_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UserButtonSetupDbusData UserButtonSetupDbusData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _AccountsRemoteIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (AccountsRemote* self, const gchar* username, GError** error);
};

struct _AccountUserRemoteIface {
	GTypeInterface parent_iface;
};

struct _PropertiesRemoteIface {
	GTypeInterface parent_iface;
	GVariant* (*get) (PropertiesRemote* self, const gchar* interface, const gchar* property, GError** error);
};

struct _UserButtonPrivate {
	AccountsRemote* user_manager;
	AccountUserRemote* current_user;
	gchar* current_username;
	PropertiesRemote* current_user_props;
};

struct _UserButtonSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UserButton* self;
	AccountsRemote* _tmp0_;
	AccountsRemote* _tmp1_;
	AccountsRemote* _tmp2_;
	gchar* uid;
	AccountsRemote* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	PropertiesRemote* _tmp6_;
	const gchar* _tmp7_;
	PropertiesRemote* _tmp8_;
	PropertiesRemote* _tmp9_;
	GError* e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	AccountUserRemote* _tmp12_;
	const gchar* _tmp13_;
	AccountUserRemote* _tmp14_;
	AccountUserRemote* _tmp15_;
	AccountUserRemote* _tmp16_;
	GError* _vala1_e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	GError* _vala2_e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_;
};

static gint UserButton_private_offset;
static gpointer user_button_parent_class = NULL;
static GType user_button_type_id = 0;

VALA_EXTERN GType accounts_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void accounts_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint accounts_remote_register_object (void* object,
                                       GDBusConnection* connection,
                                       const gchar* path,
                                       GError** error);
GType accounts_remote_register_type (GTypeModule * module);
VALA_EXTERN GType accounts_remote_get_type (void) G_GNUC_CONST ;
GType account_user_remote_register_type (GTypeModule * module);
VALA_EXTERN GType account_user_remote_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType account_user_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void account_user_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint account_user_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType properties_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void properties_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint properties_remote_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
GType properties_remote_register_type (GTypeModule * module);
VALA_EXTERN GType properties_remote_get_type (void) G_GNUC_CONST ;
static void user_button_setup_dbus_data_free (gpointer _data);
static void user_button_setup_dbus (UserButton* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static void user_button_setup_dbus_finish (UserButton* self,
                                    GAsyncResult* _res_);
static gboolean user_button_setup_dbus_co (UserButtonSetupDbusData* _data_);
static void user_button_setup_dbus_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN gchar* accounts_remote_find_user_by_name (AccountsRemote* self,
                                          const gchar* username,
                                          GError** error);
static void user_button_update_userinfo (UserButton* self);
static void _user_button_update_userinfo_account_user_remote_changed (AccountUserRemote* _sender,
                                                               gpointer self);
static gchar* user_button_get_user_image (UserButton* self);
static gchar* user_button_get_user_name (UserButton* self);
static void user_button_set_user_image (UserButton* self,
                                 const gchar* source);
VALA_EXTERN GVariant* properties_remote_get (PropertiesRemote* self,
                                 const gchar* interface,
                                 const gchar* property,
                                 GError** error);
static cairo_surface_t* user_button_render_rounded (UserButton* self,
                                             GdkPixbuf* source,
                                             gint scale);
static GObject * user_button_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void user_button_finalize (GObject * obj);

static inline gpointer
user_button_get_instance_private (UserButton* self)
{
	return G_STRUCT_MEMBER_P (self, UserButton_private_offset);
}

UserButton*
user_button_construct (GType object_type)
{
	UserButton * self = NULL;
	self = (UserButton*) g_object_new (object_type, "always-show-image", TRUE, "relief", GTK_RELIEF_NONE, NULL);
	return self;
}

UserButton*
user_button_new (void)
{
	return user_button_construct (TYPE_USER_BUTTON);
}

static void
user_button_setup_dbus_data_free (gpointer _data)
{
	UserButtonSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UserButtonSetupDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
user_button_setup_dbus (UserButton* self,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	UserButtonSetupDbusData* _data_;
	UserButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UserButtonSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, user_button_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	user_button_setup_dbus_co (_data_);
}

static void
user_button_setup_dbus_finish (UserButton* self,
                               GAsyncResult* _res_)
{
	UserButtonSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
user_button_setup_dbus_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	UserButtonSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	user_button_setup_dbus_co (_data_);
}

static void
_user_button_update_userinfo_account_user_remote_changed (AccountUserRemote* _sender,
                                                          gpointer self)
{
	user_button_update_userinfo ((UserButton*) self);
}

static gboolean
user_button_setup_dbus_co (UserButtonSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_ACCOUNTS_REMOTE_PROXY, 0, NULL, user_button_setup_dbus_ready, _data_, "g-flags", 0, "g-name", USER_BUTTON_ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (AccountsRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (AccountsRemote*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->user_manager);
		_data_->self->priv->user_manager = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->user_manager;
		_data_->_tmp4_ = _data_->self->priv->current_username;
		_data_->_tmp5_ = accounts_remote_find_user_by_name (_data_->_tmp3_, _data_->_tmp4_, &_data_->_inner_error0_);
		_data_->uid = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp7_ = _data_->uid;
			_data_->_state_ = 2;
			g_async_initable_new_async (TYPE_PROPERTIES_REMOTE_PROXY, 0, NULL, user_button_setup_dbus_ready, _data_, "g-flags", 0, "g-name", USER_BUTTON_ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp7_, "g-interface-name", "org.freedesktop.DBus.Properties", NULL);
			return FALSE;
			_state_2:
			_data_->_tmp8_ = (PropertiesRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp6_ = (PropertiesRemote*) _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp9_ = _data_->_tmp6_;
			_data_->_tmp6_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user_props);
			_data_->self->priv->current_user_props = _data_->_tmp9_;
			user_button_update_userinfo (_data_->self);
			_g_object_unref0 (_data_->_tmp6_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp10_ = _data_->e;
			_data_->_tmp11_ = _data_->_tmp10_->message;
			g_warning ("UserButton.vala:48: Unable to connect to Account User Service: %s", _data_->_tmp11_);
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		{
			_data_->_tmp13_ = _data_->uid;
			_data_->_state_ = 3;
			g_async_initable_new_async (TYPE_ACCOUNT_USER_REMOTE_PROXY, 0, NULL, user_button_setup_dbus_ready, _data_, "g-flags", 0, "g-name", USER_BUTTON_ACCOUNTSSERVICE_ACC, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp13_, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
			return FALSE;
			_state_3:
			_data_->_tmp14_ = (AccountUserRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp12_ = (AccountUserRemote*) _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_data_->_tmp15_ = _data_->_tmp12_;
			_data_->_tmp12_ = NULL;
			_g_object_unref0 (_data_->self->priv->current_user);
			_data_->self->priv->current_user = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->self->priv->current_user;
			g_signal_connect_object (_data_->_tmp16_, "changed", (GCallback) _user_button_update_userinfo_account_user_remote_changed, _data_->self, 0);
			_g_object_unref0 (_data_->_tmp12_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->_vala1_e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp17_ = _data_->_vala1_e;
			_data_->_tmp18_ = _data_->_tmp17_->message;
			g_warning ("UserButton.vala:55: Unable to connect to Account User Service: %s", _data_->_tmp18_);
			_g_error_free0 (_data_->_vala1_e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->uid);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->uid);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->_vala2_e;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("UserButton.vala:58: Unable to connect to Accounts Service: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
 * Sets the user name and profile picture from DBus.
 */
static void
user_button_update_userinfo (UserButton* self)
{
	gchar* user_image = NULL;
	gchar* _tmp0_;
	gchar* user_name = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = user_button_get_user_image (self);
	user_image = _tmp0_;
	_tmp1_ = user_button_get_user_name (self);
	user_name = _tmp1_;
	user_button_set_user_image (self, user_image);
	gtk_button_set_label ((GtkButton*) self, user_name);
	_g_free0 (user_name);
	_g_free0 (user_image);
}

/**
 * Get the User's profile picture if set, falling back to a
 * generic icon if not.
 */
static gchar*
user_button_get_user_image (UserButton* self)
{
	gchar* source = NULL;
	gchar* _tmp0_;
	PropertiesRemote* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (USER_ICON);
	source = _tmp0_;
	_tmp1_ = self->priv->current_user_props;
	if (_tmp1_ != NULL) {
		{
			GVariant* _tmp2_ = NULL;
			PropertiesRemote* _tmp3_;
			GVariant* _tmp4_;
			gchar* icon_file = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp3_ = self->priv->current_user_props;
			_tmp4_ = properties_remote_get (_tmp3_, USER_BUTTON_ACCOUNTSSERVICE_USER, "IconFile", &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = g_variant_get_string (_tmp2_, NULL);
			_tmp6_ = g_strdup (_tmp5_);
			icon_file = _tmp6_;
			_tmp7_ = icon_file;
			if (g_strcmp0 (_tmp7_, "") != 0) {
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = icon_file;
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (source);
				source = _tmp9_;
			}
			_g_free0 (icon_file);
			_g_variant_unref0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("UserButton.vala:87: Failed to fetch IconFile: %s", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = source;
	return result;
}

/**
 * Get the User's name.
 */
static gchar*
user_button_get_user_name (UserButton* self)
{
	gchar* user_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PropertiesRemote* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_username;
	_tmp1_ = g_strdup (_tmp0_);
	user_name = _tmp1_;
	_tmp2_ = self->priv->current_user_props;
	if (_tmp2_ != NULL) {
		{
			GVariant* _tmp3_ = NULL;
			PropertiesRemote* _tmp4_;
			GVariant* _tmp5_;
			gchar* real_name = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp4_ = self->priv->current_user_props;
			_tmp5_ = properties_remote_get (_tmp4_, USER_BUTTON_ACCOUNTSSERVICE_USER, "RealName", &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = g_variant_get_string (_tmp3_, NULL);
			_tmp7_ = g_strdup (_tmp6_);
			real_name = _tmp7_;
			_tmp8_ = real_name;
			if (g_strcmp0 (_tmp8_, "") != 0) {
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = real_name;
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (user_name);
				user_name = _tmp10_;
			}
			_g_free0 (real_name);
			_g_variant_unref0 (_tmp3_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("UserButton.vala:107: Failed to fetch RealName: %s", _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (user_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = user_name;
	return result;
}

/**
 * Try to set the user image from a file. If this fails,
 * fallback to a generic user icon.
 */
static void
user_button_set_user_image (UserButton* self,
                            const gchar* source)
{
	gboolean has_slash_prefix = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean is_user_image = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkImage* user_image = NULL;
	GtkImage* _tmp3_ = NULL;
	GtkImage* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	has_slash_prefix = g_str_has_prefix (source, "/");
	if (has_slash_prefix) {
		_tmp0_ = !g_str_has_suffix (source, ".face");
	} else {
		_tmp0_ = FALSE;
	}
	is_user_image = _tmp0_;
	if (has_slash_prefix) {
		_tmp2_ = !is_user_image;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = USER_ICON;
	} else {
		_tmp1_ = source;
	}
	source = _tmp1_;
	_tmp3_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	g_object_ref_sink (_tmp3_);
	user_image = _tmp3_;
	if (is_user_image) {
		{
			GdkPixbuf* pixbuf = NULL;
			GdkPixbuf* _tmp4_;
			cairo_surface_t* surface = NULL;
			GdkPixbuf* _tmp5_;
			cairo_surface_t* _tmp6_;
			GtkImage* _tmp7_;
			cairo_surface_t* _tmp8_;
			_tmp4_ = gdk_pixbuf_new_from_file_at_size (source, 24, 24, &_inner_error0_);
			pixbuf = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = pixbuf;
			_tmp6_ = user_button_render_rounded (self, _tmp5_, 1);
			surface = _tmp6_;
			_tmp7_ = user_image;
			_tmp8_ = surface;
			gtk_image_set_from_surface (_tmp7_, _tmp8_);
			_cairo_surface_destroy0 (surface);
			_g_object_unref0 (pixbuf);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("UserButton.vala:134: File for user image does not exist: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (user_image);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GtkImage* _tmp11_;
		_tmp11_ = user_image;
		gtk_image_set_from_icon_name (_tmp11_, source, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	}
	_tmp12_ = user_image;
	gtk_button_set_image ((GtkButton*) self, (GtkWidget*) _tmp12_);
	_g_object_unref0 (user_image);
}

/**
 * Takes a `Gdk.Pixbuf` and turns it into a circle.
 *
 * This was ported from the C functions to do the same thing in
 * Budgie Control Center.
 */
static cairo_surface_t*
user_button_render_rounded (UserButton* self,
                            GdkPixbuf* source,
                            gint scale)
{
	gint size = 0;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* context = NULL;
	cairo_t* _tmp1_;
	GdkPixbuf* rounded = NULL;
	GdkPixbuf* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	size = gdk_pixbuf_get_width (source);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
	surface = _tmp0_;
	_tmp1_ = cairo_create (surface);
	context = _tmp1_;
	cairo_arc (context, (gdouble) (size / 2), (gdouble) (size / 2), (gdouble) (size / 2), (gdouble) 0, 2 * G_PI);
	cairo_clip (context);
	cairo_new_path (context);
	gdk_cairo_set_source_pixbuf (context, source, (gdouble) 0, (gdouble) 0);
	cairo_paint (context);
	_tmp2_ = gdk_pixbuf_get_from_surface (surface, 0, 0, size, size);
	rounded = _tmp2_;
	_tmp3_ = gdk_cairo_surface_create_from_pixbuf (rounded, scale, NULL);
	result = _tmp3_;
	_g_object_unref0 (rounded);
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	return result;
}

static GObject *
user_button_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UserButton * self;
	GtkStyleContext* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (user_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_BUTTON, UserButton);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "user-icon-button");
	_tmp1_ = g_get_user_name ();
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->current_username);
	self->priv->current_username = _tmp2_;
	user_button_setup_dbus (self, NULL, NULL);
	return obj;
}

static void
user_button_class_init (UserButtonClass * klass,
                        gpointer klass_data)
{
	user_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UserButton_private_offset);
	G_OBJECT_CLASS (klass)->constructor = user_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = user_button_finalize;
}

static void
user_button_instance_init (UserButton * self,
                           gpointer klass)
{
	self->priv = user_button_get_instance_private (self);
	self->priv->user_manager = NULL;
	self->priv->current_user = NULL;
	self->priv->current_username = NULL;
	self->priv->current_user_props = NULL;
}

static void
user_button_finalize (GObject * obj)
{
	UserButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_BUTTON, UserButton);
	_g_object_unref0 (self->priv->user_manager);
	_g_object_unref0 (self->priv->current_user);
	_g_free0 (self->priv->current_username);
	_g_object_unref0 (self->priv->current_user_props);
	G_OBJECT_CLASS (user_button_parent_class)->finalize (obj);
}

/**
 * Creates a button using the current user's profile picture, if they
 * have one set, falling back to a generic user icon.
 */
GType
user_button_get_type (void)
{
	return user_button_type_id;
}

GType
user_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (UserButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserButton), 0, (GInstanceInitFunc) user_button_instance_init, NULL };
	user_button_type_id = g_type_module_register_type (module, gtk_button_get_type (), "UserButton", &g_define_type_info, 0);
	UserButton_private_offset = sizeof (UserButtonPrivate);
	return user_button_type_id;
}

