/* OverlayMenus.c generated by valac 0.56.14, the Vala compiler
 * generated from OverlayMenus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>

#define OVERLAY_MENUS_LOGIND_LOGIN "org.freedesktop.login1"
#define OVERLAY_MENUS_G_SESSION "org.gnome.SessionManager"

enum  {
	OVERLAY_MENUS_0_PROPERTY,
	OVERLAY_MENUS_NUM_PROPERTIES
};
static GParamSpec* overlay_menus_properties[OVERLAY_MENUS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _OverlayMenusSetupDbusData OverlayMenusSetupDbusData;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	OVERLAY_MENUS_ITEM_CLICKED_SIGNAL,
	OVERLAY_MENUS_NUM_SIGNALS
};
static guint overlay_menus_signals[OVERLAY_MENUS_NUM_SIGNALS] = {0};

struct _OverlayMenusPrivate {
	GtkStack* stack;
	GtkListBox* folder_items;
	XDGDirTrackerRemote* xdgtracker;
	GList* items_to_show;
	GHashTable* user_directory_buttons;
};

struct _OverlayMenusSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OverlayMenus* self;
	XDGDirTrackerRemote* _tmp0_;
	XDGDirTrackerRemote* _tmp1_;
	XDGDirTrackerRemote* _tmp2_;
	XDGDirTrackerRemote* _tmp3_;
	GUserDirectory* _tmp4_;
	XDGDirTrackerRemote* _tmp5_;
	gint _tmp6_;
	GUserDirectory* _tmp7_;
	gint _tmp4__length1;
	gint __tmp4__size_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

static gint OverlayMenus_private_offset;
static gpointer overlay_menus_parent_class = NULL;
static GType overlay_menus_type_id = 0;

static gboolean overlay_menus_filter_list_box_item (OverlayMenus* self,
                                             GtkListBoxRow* row);
static void overlay_menus_handle_xdg_dir_clicked (OverlayMenus* self,
                                           GtkButton* item);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void overlay_menus_setup_dbus_data_free (gpointer _data);
static void overlay_menus_setup_dbus (OverlayMenus* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void overlay_menus_setup_dbus_finish (OverlayMenus* self,
                                      GAsyncResult* _res_);
static gboolean overlay_menus_setup_dbus_co (OverlayMenusSetupDbusData* _data_);
static void overlay_menus_setup_dbus_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static void overlay_menus_handle_xdg_dirs_changed (OverlayMenus* self,
                                            GUserDirectory* dirs,
                                            gint dirs_length1);
static void _overlay_menus_handle_xdg_dirs_changed_xdg_dir_tracker_remote_xdg_dirs_exist (XDGDirTrackerRemote* _sender,
                                                                                   GUserDirectory* dirs,
                                                                                   gint dirs_length1,
                                                                                   gpointer self);
static gint overlay_menus_sort_xdg_menu_items (OverlayMenus* self,
                                        GtkListBoxRow* row1,
                                        GtkListBoxRow* row2);
static GObject * overlay_menus_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static gboolean _overlay_menus_filter_list_box_item_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                       gpointer self);
static gint _overlay_menus_sort_xdg_menu_items_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                GtkListBoxRow* row2,
                                                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _overlay_menus___lambda5_ (OverlayMenus* self,
                                GUserDirectory key,
                                MenuItem* val);
static void __lambda6_ (OverlayMenus* self,
                 GtkButton* val);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __overlay_menus___lambda5__gh_func (gconstpointer key,
                                         gconstpointer value,
                                         gpointer self);
static void overlay_menus_finalize (GObject * obj);

static inline gpointer
overlay_menus_get_instance_private (OverlayMenus* self)
{
	return G_STRUCT_MEMBER_P (self, OverlayMenus_private_offset);
}

OverlayMenus*
overlay_menus_construct (GType object_type)
{
	OverlayMenus * self = NULL;
	self = (OverlayMenus*) g_object_new (object_type, "valign", GTK_ALIGN_END, "halign", GTK_ALIGN_START, "transition-duration", 250, "transition-type", GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT, NULL);
	return self;
}

OverlayMenus*
overlay_menus_new (void)
{
	return overlay_menus_construct (TYPE_OVERLAY_MENUS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
overlay_menus_filter_list_box_item (OverlayMenus* self,
                                    GtkListBoxRow* row)
{
	MenuItem* menu_item = NULL;
	GtkWidget* _tmp0_;
	MenuItem* _tmp1_;
	GUserDirectory xdg_dir = 0;
	gconstpointer _tmp2_;
	GList* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MENU_ITEM, MenuItem));
	menu_item = _tmp1_;
	_tmp2_ = g_object_get_data ((GObject*) menu_item, "user-directory");
	xdg_dir = (GUserDirectory) ((gintptr) _tmp2_);
	_tmp3_ = self->priv->items_to_show;
	result = g_list_index (_tmp3_, (gpointer) ((gintptr) xdg_dir)) != -1;
	_g_object_unref0 (menu_item);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
overlay_menus_handle_xdg_dir_clicked (OverlayMenus* self,
                                      GtkButton* item)
{
	GUserDirectory xdg_dir = 0;
	gconstpointer _tmp0_;
	const gchar* path = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GdkAppLaunchContext* launch_context = NULL;
	GdkDisplay* _tmp3_;
	GdkAppLaunchContext* _tmp4_;
	GdkAppLaunchContext* _tmp5_;
	GdkScreen* _tmp6_;
	GdkAppLaunchContext* _tmp7_;
	GDesktopAppInfo* appinfo = NULL;
	GAppInfo* _tmp8_;
	GList* files = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = g_object_get_data ((GObject*) item, "user-directory");
	xdg_dir = (GUserDirectory) ((gintptr) _tmp0_);
	_tmp1_ = g_get_user_special_dir (xdg_dir);
	path = _tmp1_;
	_tmp2_ = path;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = gdk_display_get_app_launch_context (_tmp3_);
	launch_context = _tmp4_;
	_tmp5_ = launch_context;
	_tmp6_ = gdk_screen_get_default ();
	gdk_app_launch_context_set_screen (_tmp5_, _tmp6_);
	_tmp7_ = launch_context;
	gdk_app_launch_context_set_timestamp (_tmp7_, (guint32) GDK_CURRENT_TIME);
	_tmp8_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
	appinfo = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo);
	files = NULL;
	_tmp9_ = path;
	_tmp10_ = g_strconcat ("file://", _tmp9_, NULL);
	files = g_list_append (files, _tmp10_);
	{
		GDesktopAppInfo* _tmp11_;
		GList* _tmp12_;
		GdkAppLaunchContext* _tmp13_;
		_tmp11_ = appinfo;
		_tmp12_ = files;
		_tmp13_ = launch_context;
		g_app_info_launch_uris ((GAppInfo*) _tmp11_, _tmp12_, (GAppLaunchContext*) _tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = path;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("OverlayMenus.vala:116: Failed to open %s: %s", _tmp14_, _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
		_g_object_unref0 (appinfo);
		_g_object_unref0 (launch_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(files == NULL) ? NULL : (files = (_g_list_free__g_free0_ (files), NULL));
	_g_object_unref0 (appinfo);
	_g_object_unref0 (launch_context);
}

static void
overlay_menus_setup_dbus_data_free (gpointer _data)
{
	OverlayMenusSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (OverlayMenusSetupDbusData, _data_);
}

static void
overlay_menus_setup_dbus (OverlayMenus* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	OverlayMenusSetupDbusData* _data_;
	OverlayMenus* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (OverlayMenusSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, overlay_menus_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	overlay_menus_setup_dbus_co (_data_);
}

static void
overlay_menus_setup_dbus_finish (OverlayMenus* self,
                                 GAsyncResult* _res_)
{
	OverlayMenusSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Set up all of the DBus bits to make all the items work.
 */
static void
overlay_menus_setup_dbus_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	OverlayMenusSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	overlay_menus_setup_dbus_co (_data_);
}

static void
_overlay_menus_handle_xdg_dirs_changed_xdg_dir_tracker_remote_xdg_dirs_exist (XDGDirTrackerRemote* _sender,
                                                                              GUserDirectory* dirs,
                                                                              gint dirs_length1,
                                                                              gpointer self)
{
	overlay_menus_handle_xdg_dirs_changed ((OverlayMenus*) self, dirs, dirs_length1);
}

static gboolean
overlay_menus_setup_dbus_co (OverlayMenusSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_XDG_DIR_TRACKER_REMOTE_PROXY, 0, NULL, overlay_menus_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.buddiesofbudgie.XDGDirTracker", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/buddiesofbudgie/XDGDirTracker", "g-interface-name", "org.buddiesofbudgie.XDGDirTracker", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (XDGDirTrackerRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (XDGDirTrackerRemote*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->xdgtracker);
		_data_->self->priv->xdgtracker = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->xdgtracker;
		g_signal_connect_object (_data_->_tmp3_, "xdg-dirs-exist", (GCallback) _overlay_menus_handle_xdg_dirs_changed_xdg_dir_tracker_remote_xdg_dirs_exist, _data_->self, 0);
		_data_->_tmp5_ = _data_->self->priv->xdgtracker;
		_data_->_tmp6_ = 0;
		_data_->_tmp7_ = xdg_dir_tracker_remote_get_dirs (_data_->_tmp5_, &_data_->_tmp6_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp7_;
		_data_->_tmp4__length1 = _data_->_tmp6_;
		_data_->__tmp4__size_ = _data_->_tmp4__length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		overlay_menus_handle_xdg_dirs_changed (_data_->self, _data_->_tmp4_, (gint) _data_->_tmp4__length1);
		_data_->_tmp4_ = (g_free (_data_->_tmp4_), NULL);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("OverlayMenus.vala:129: Unable to connect to Budgie XDGDirTracker: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
overlay_menus_handle_xdg_dirs_changed (OverlayMenus* self,
                                       GUserDirectory* dirs,
                                       gint dirs_length1)
{
	GtkListBox* _tmp3_;
	g_return_if_fail (self != NULL);
	(self->priv->items_to_show == NULL) ? NULL : (self->priv->items_to_show = (g_list_free (self->priv->items_to_show), NULL));
	self->priv->items_to_show = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GUserDirectory _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < dirs_length1)) {
					break;
				}
				_tmp2_ = dirs[i];
				self->priv->items_to_show = g_list_append (self->priv->items_to_show, (gpointer) ((gintptr) _tmp2_));
			}
		}
	}
	_tmp3_ = self->priv->folder_items;
	gtk_list_box_invalidate_filter (_tmp3_);
}

static gint
overlay_menus_sort_xdg_menu_items (OverlayMenus* self,
                                   GtkListBoxRow* row1,
                                   GtkListBoxRow* row2)
{
	MenuItem* row1_menu = NULL;
	GtkWidget* _tmp0_;
	MenuItem* _tmp1_;
	MenuItem* row2_menu = NULL;
	GtkWidget* _tmp2_;
	MenuItem* _tmp3_;
	gboolean _tmp4_ = FALSE;
	MenuItem* _tmp5_;
	MenuItem* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	MenuItem* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MENU_ITEM, MenuItem));
	row1_menu = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MENU_ITEM, MenuItem));
	row2_menu = _tmp3_;
	_tmp5_ = row1_menu;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = row2 == NULL;
	}
	if (_tmp4_) {
		result = 0;
		_g_object_unref0 (row2_menu);
		_g_object_unref0 (row1_menu);
		return result;
	}
	_tmp6_ = row1_menu;
	_tmp7_ = menu_item_get_label_text (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = row2_menu;
	_tmp10_ = menu_item_get_label_text (_tmp9_);
	_tmp11_ = _tmp10_;
	result = g_utf8_collate (_tmp8_, _tmp11_);
	_g_object_unref0 (row2_menu);
	_g_object_unref0 (row1_menu);
	return result;
}

void
overlay_menus_set_visible_menu (OverlayMenus* self,
                                const gchar* vis)
{
	GtkAlign _tmp0_ = 0;
	GtkRevealerTransitionType _tmp1_ = 0;
	GtkStack* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vis != NULL);
	if (g_strcmp0 (vis, "xdg") == 0) {
		_tmp0_ = GTK_ALIGN_START;
	} else {
		_tmp0_ = GTK_ALIGN_END;
	}
	gtk_widget_set_halign ((GtkWidget*) self, _tmp0_);
	if (g_strcmp0 (vis, "xdg") == 0) {
		_tmp1_ = GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT;
	} else {
		_tmp1_ = GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT;
	}
	gtk_revealer_set_transition_type ((GtkRevealer*) self, _tmp1_);
	_tmp2_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp2_, vis);
}

static gboolean
_overlay_menus_filter_list_box_item_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                              gpointer self)
{
	gboolean result;
	result = overlay_menus_filter_list_box_item ((OverlayMenus*) self, row);
	return result;
}

static gint
_overlay_menus_sort_xdg_menu_items_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                           GtkListBoxRow* row2,
                                                           gpointer self)
{
	gint result;
	result = overlay_menus_sort_xdg_menu_items ((OverlayMenus*) self, row1, row2);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
__lambda6_ (OverlayMenus* self,
            GtkButton* val)
{
	g_return_if_fail (val != NULL);
	overlay_menus_handle_xdg_dir_clicked (self, val);
	g_signal_emit (self, overlay_menus_signals[OVERLAY_MENUS_ITEM_CLICKED_SIGNAL], 0);
}

static void
___lambda6__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda6_ ((OverlayMenus*) self, _sender);
}

static void
_overlay_menus___lambda5_ (OverlayMenus* self,
                           GUserDirectory key,
                           MenuItem* val)
{
	const gchar* dir = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkListBox* _tmp5_;
	g_return_if_fail (val != NULL);
	_tmp0_ = g_get_user_special_dir (key);
	dir = _tmp0_;
	_tmp1_ = dir;
	if (_tmp1_ != NULL) {
		gchar* dir_base = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = dir;
		_tmp3_ = g_path_get_basename (_tmp2_);
		dir_base = _tmp3_;
		_tmp4_ = dir_base;
		menu_item_set_label_text (val, _tmp4_);
		_g_free0 (dir_base);
	}
	g_object_set_data_full ((GObject*) val, "user-directory", (gpointer) ((gintptr) key), NULL);
	_tmp5_ = self->priv->folder_items;
	gtk_list_box_insert (_tmp5_, (GtkWidget*) val, -1);
	g_signal_connect_object ((GtkButton*) val, "clicked", (GCallback) ___lambda6__gtk_button_clicked, self, 0);
}

static void
__overlay_menus___lambda5__gh_func (gconstpointer key,
                                    gconstpointer value,
                                    gpointer self)
{
	_overlay_menus___lambda5_ ((OverlayMenus*) self, (GUserDirectory) ((gintptr) key), (MenuItem*) value);
}

static GObject *
overlay_menus_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	OverlayMenus * self;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	GtkListBox* _tmp5_ = NULL;
	GtkListBox* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	MenuItem* _tmp14_;
	GHashTable* _tmp15_;
	MenuItem* _tmp16_;
	GHashTable* _tmp17_;
	MenuItem* _tmp18_;
	GHashTable* _tmp19_;
	MenuItem* _tmp20_;
	GHashTable* _tmp21_;
	MenuItem* _tmp22_;
	GHashTable* _tmp23_;
	MenuItem* _tmp24_;
	GHashTable* _tmp25_;
	GList* _tmp26_;
	GHashTable* _tmp27_;
	GtkStack* _tmp28_;
	GtkListBox* _tmp29_;
	GtkStack* _tmp30_;
	parent_class = G_OBJECT_CLASS (overlay_menus_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OVERLAY_MENUS, OverlayMenus);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp0_;
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "budgie-menu-overlay");
	_tmp3_ = self->priv->stack;
	gtk_stack_set_homogeneous (_tmp3_, FALSE);
	_tmp4_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp5_, FALSE);
	gtk_list_box_set_selection_mode (_tmp5_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->folder_items);
	self->priv->folder_items = _tmp5_;
	_tmp6_ = self->priv->folder_items;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, "left-overlay-menu");
	_tmp8_ = self->priv->folder_items;
	gtk_list_box_set_filter_func (_tmp8_, _overlay_menus_filter_list_box_item_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp9_ = self->priv->folder_items;
	gtk_list_box_set_sort_func (_tmp9_, _overlay_menus_sort_xdg_menu_items_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp10_ = g_direct_hash;
	_tmp11_ = g_direct_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->user_directory_buttons);
	self->priv->user_directory_buttons = _tmp12_;
	_tmp13_ = self->priv->user_directory_buttons;
	_tmp14_ = menu_item_new ("Desktop", "user-desktop-symbolic");
	g_object_ref_sink (_tmp14_);
	g_hash_table_insert (_tmp13_, (gpointer) ((gintptr) G_USER_DIRECTORY_DESKTOP), _tmp14_);
	_tmp15_ = self->priv->user_directory_buttons;
	_tmp16_ = menu_item_new ("Documents", "folder-documents-symbolic");
	g_object_ref_sink (_tmp16_);
	g_hash_table_insert (_tmp15_, (gpointer) ((gintptr) G_USER_DIRECTORY_DOCUMENTS), _tmp16_);
	_tmp17_ = self->priv->user_directory_buttons;
	_tmp18_ = menu_item_new ("Downloads", "folder-downloads-symbolic");
	g_object_ref_sink (_tmp18_);
	g_hash_table_insert (_tmp17_, (gpointer) ((gintptr) G_USER_DIRECTORY_DOWNLOAD), _tmp18_);
	_tmp19_ = self->priv->user_directory_buttons;
	_tmp20_ = menu_item_new ("Music", "folder-music-symbolic");
	g_object_ref_sink (_tmp20_);
	g_hash_table_insert (_tmp19_, (gpointer) ((gintptr) G_USER_DIRECTORY_MUSIC), _tmp20_);
	_tmp21_ = self->priv->user_directory_buttons;
	_tmp22_ = menu_item_new ("Pictures", "folder-pictures-symbolic");
	g_object_ref_sink (_tmp22_);
	g_hash_table_insert (_tmp21_, (gpointer) ((gintptr) G_USER_DIRECTORY_PICTURES), _tmp22_);
	_tmp23_ = self->priv->user_directory_buttons;
	_tmp24_ = menu_item_new ("Videos", "folder-videos-symbolic");
	g_object_ref_sink (_tmp24_);
	g_hash_table_insert (_tmp23_, (gpointer) ((gintptr) G_USER_DIRECTORY_VIDEOS), _tmp24_);
	_tmp25_ = self->priv->user_directory_buttons;
	_tmp26_ = g_hash_table_get_keys (_tmp25_);
	(self->priv->items_to_show == NULL) ? NULL : (self->priv->items_to_show = (g_list_free (self->priv->items_to_show), NULL));
	self->priv->items_to_show = _tmp26_;
	_tmp27_ = self->priv->user_directory_buttons;
	g_hash_table_foreach (_tmp27_, __overlay_menus___lambda5__gh_func, self);
	overlay_menus_setup_dbus (self, NULL, NULL);
	_tmp28_ = self->priv->stack;
	_tmp29_ = self->priv->folder_items;
	gtk_stack_add_named (_tmp28_, (GtkWidget*) _tmp29_, "xdg");
	_tmp30_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
	return obj;
}

static void
overlay_menus_class_init (OverlayMenusClass * klass,
                          gpointer klass_data)
{
	overlay_menus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OverlayMenus_private_offset);
	G_OBJECT_CLASS (klass)->constructor = overlay_menus_constructor;
	G_OBJECT_CLASS (klass)->finalize = overlay_menus_finalize;
	/**
	 * Emitted when an item in the menu has been clicked.
	 */
	overlay_menus_signals[OVERLAY_MENUS_ITEM_CLICKED_SIGNAL] = g_signal_new ("item-clicked", TYPE_OVERLAY_MENUS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
overlay_menus_instance_init (OverlayMenus * self,
                             gpointer klass)
{
	self->priv = overlay_menus_get_instance_private (self);
	self->priv->stack = NULL;
	self->priv->folder_items = NULL;
	self->priv->xdgtracker = NULL;
	self->priv->items_to_show = NULL;
	self->priv->user_directory_buttons = NULL;
}

static void
overlay_menus_finalize (GObject * obj)
{
	OverlayMenus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OVERLAY_MENUS, OverlayMenus);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->folder_items);
	_g_object_unref0 (self->priv->xdgtracker);
	(self->priv->items_to_show == NULL) ? NULL : (self->priv->items_to_show = (g_list_free (self->priv->items_to_show), NULL));
	_g_hash_table_unref0 (self->priv->user_directory_buttons);
	G_OBJECT_CLASS (overlay_menus_parent_class)->finalize (obj);
}

/**
 * Class to contain our overlay menu items
 */
GType
overlay_menus_get_type (void)
{
	return overlay_menus_type_id;
}

GType
overlay_menus_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (OverlayMenusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) overlay_menus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OverlayMenus), 0, (GInstanceInitFunc) overlay_menus_instance_init, NULL };
	overlay_menus_type_id = g_type_module_register_type (module, gtk_revealer_get_type (), "OverlayMenus", &g_define_type_info, 0);
	OverlayMenus_private_offset = sizeof (OverlayMenusPrivate);
	return overlay_menus_type_id;
}

