/* BudgieMenuWindow.c generated by valac 0.56.14, the Vala compiler
 * generated from BudgieMenuWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "budgie-appindexer.h"
#include <gio/gdesktopappinfo.h>

#define TYPE_POWER_DIALOG_REMOTE (power_dialog_remote_get_type ())
#define POWER_DIALOG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POWER_DIALOG_REMOTE, PowerDialogRemote))
#define IS_POWER_DIALOG_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POWER_DIALOG_REMOTE))
#define POWER_DIALOG_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POWER_DIALOG_REMOTE, PowerDialogRemoteIface))

typedef struct _PowerDialogRemote PowerDialogRemote;
typedef struct _PowerDialogRemoteIface PowerDialogRemoteIface;

#define TYPE_POWER_DIALOG_REMOTE_PROXY (power_dialog_remote_proxy_get_type ())
enum  {
	BUDGIE_MENU_WINDOW_0_PROPERTY,
	BUDGIE_MENU_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_menu_window_properties[BUDGIE_MENU_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PowerDialogRemoteIface {
	GTypeInterface parent_iface;
	void (*Toggle) (PowerDialogRemote* self, GError** error);
};

struct _BudgieMenuWindowPrivate {
	GtkOverlay* overlay;
	UserButton* user_indicator;
	GtkButton* budgie_desktop_prefs_button;
	GtkButton* system_settings_button;
	GtkButton* power_button;
	OverlayMenus* overlay_menu;
	PowerDialogRemote* power_dialog;
};

static gint BudgieMenuWindow_private_offset;
static gpointer budgie_menu_window_parent_class = NULL;
static GType budgie_menu_window_type_id = 0;

VALA_EXTERN GType power_dialog_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void power_dialog_remote_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint power_dialog_remote_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
GType power_dialog_remote_register_type (GTypeModule * module);
VALA_EXTERN GType power_dialog_remote_get_type (void) G_GNUC_CONST ;
static GtkButton* budgie_menu_window_create_icon_button (BudgieMenuWindow* self,
                                                  const gchar* icon_name);
static void budgie_menu_window_on_power_dialog_get (BudgieMenuWindow* self,
                                             GObject* obj,
                                             GAsyncResult* res);
static void _budgie_menu_window_on_power_dialog_get_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static gboolean __lambda14_ (BudgieMenuWindow* self,
                      GdkEventButton* event);
static gboolean ___lambda14__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void __lambda15_ (BudgieMenuWindow* self);
static void ___lambda15__gtk_editable_changed (GtkEditable* _sender,
                                        gpointer self);
static void __lambda16_ (BudgieMenuWindow* self);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda17_ (BudgieMenuWindow* self);
static void ___lambda17__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda18_ (BudgieMenuWindow* self);
static void ___lambda18__gtk_entry_activate (GtkEntry* _sender,
                                      gpointer self);
static void __lambda19_ (BudgieMenuWindow* self);
static void budgie_menu_window_open_overlay_menu (BudgieMenuWindow* self,
                                           const gchar* vis);
static void ___lambda19__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda20_ (BudgieMenuWindow* self);
VALA_EXTERN void power_dialog_remote_Toggle (PowerDialogRemote* self,
                                 GError** error);
static void ___lambda20__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _gtk_widget_hide_overlay_menus_item_clicked (OverlayMenus* _sender,
                                                  gpointer self);
static void _gtk_widget_hide_application_view_app_launched (ApplicationView* _sender,
                                                     gpointer self);
static void budgie_menu_window_real_show (GtkWidget* base);
static void budgie_menu_window_finalize (GObject * obj);

static inline gpointer
budgie_menu_window_get_instance_private (BudgieMenuWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMenuWindow_private_offset);
}

static void
_budgie_menu_window_on_power_dialog_get_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	budgie_menu_window_on_power_dialog_get ((BudgieMenuWindow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
__lambda14_ (BudgieMenuWindow* self,
             GdkEventButton* event)
{
	OverlayMenus* _tmp0_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->overlay_menu;
	if (!gtk_revealer_get_reveal_child ((GtkRevealer*) _tmp0_)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	budgie_menu_window_reset (self, FALSE);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda14__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda14_ ((BudgieMenuWindow*) self, event);
	return result;
}

static void
__lambda15_ (BudgieMenuWindow* self)
{
	gchar* search_term = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	ApplicationView* _tmp4_;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_relevancy_service_searchable_string (_tmp2_);
	search_term = _tmp3_;
	_tmp4_ = self->view;
	application_view_search_changed (_tmp4_, search_term);
	_g_free0 (search_term);
}

static void
___lambda15__gtk_editable_changed (GtkEditable* _sender,
                                   gpointer self)
{
	__lambda15_ ((BudgieMenuWindow*) self);
}

static void
__lambda16_ (BudgieMenuWindow* self)
{
	budgie_menu_window_open_desktop_entry (self, "budgie-control-center.desktop");
	gtk_widget_hide ((GtkWidget*) self);
}

static void
___lambda16__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda16_ ((BudgieMenuWindow*) self);
}

static void
__lambda17_ (BudgieMenuWindow* self)
{
	budgie_menu_window_open_desktop_entry (self, "org.buddiesofbudgie.BudgieDesktopSettings.desktop");
	gtk_widget_hide ((GtkWidget*) self);
}

static void
___lambda17__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda17_ ((BudgieMenuWindow*) self);
}

static void
__lambda18_ (BudgieMenuWindow* self)
{
	gchar* search_term = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	ApplicationView* _tmp4_;
	ApplicationView* _tmp5_;
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_relevancy_service_searchable_string (_tmp2_);
	search_term = _tmp3_;
	_tmp4_ = self->view;
	application_view_search_changed (_tmp4_, search_term);
	_tmp5_ = self->view;
	application_view_on_search_entry_activated (_tmp5_);
	_g_free0 (search_term);
}

static void
___lambda18__gtk_entry_activate (GtkEntry* _sender,
                                 gpointer self)
{
	__lambda18_ ((BudgieMenuWindow*) self);
}

static void
__lambda19_ (BudgieMenuWindow* self)
{
	OverlayMenus* _tmp0_;
	_tmp0_ = self->priv->overlay_menu;
	if (gtk_revealer_get_reveal_child ((GtkRevealer*) _tmp0_)) {
		budgie_menu_window_reset (self, FALSE);
	} else {
		budgie_menu_window_open_overlay_menu (self, "xdg");
	}
}

static void
___lambda19__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda19_ ((BudgieMenuWindow*) self);
}

static void
__lambda20_ (BudgieMenuWindow* self)
{
	PowerDialogRemote* _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->power_dialog;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_widget_hide ((GtkWidget*) self);
	{
		PowerDialogRemote* _tmp1_;
		_tmp1_ = self->priv->power_dialog;
		power_dialog_remote_Toggle (_tmp1_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("BudgieMenuWindow.vala:149: Error trying to show PowerDialog: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda20__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda20_ ((BudgieMenuWindow*) self);
}

static void
_gtk_widget_hide_overlay_menus_item_clicked (OverlayMenus* _sender,
                                             gpointer self)
{
	gtk_widget_hide ((GtkWidget*) self);
}

static void
_gtk_widget_hide_application_view_app_launched (ApplicationView* _sender,
                                                gpointer self)
{
	gtk_widget_hide ((GtkWidget*) self);
}

BudgieMenuWindow*
budgie_menu_window_construct (GType object_type,
                              GSettings* settings,
                              GtkWidget* leparent)
{
	BudgieMenuWindow * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* header = NULL;
	GtkBox* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	GtkBox* _tmp8_;
	GtkOverlay* _tmp9_;
	GtkBox* view_container = NULL;
	GtkBox* _tmp10_;
	OverlayMenus* _tmp11_;
	GtkOverlay* _tmp12_;
	GtkOverlay* _tmp13_;
	OverlayMenus* _tmp14_;
	ApplicationListView* _tmp15_;
	ApplicationView* _tmp16_;
	GtkBox* _tmp17_;
	GtkOverlay* _tmp18_;
	GtkBox* footer = NULL;
	GtkBox* _tmp19_;
	GtkStyleContext* _tmp20_;
	UserButton* _tmp21_;
	UserButton* _tmp22_;
	UserButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	UserButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GtkBox* _tmp34_;
	GtkSearchEntry* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkSearchEntry* _tmp38_;
	UserButton* _tmp39_;
	GtkButton* _tmp40_;
	OverlayMenus* _tmp41_;
	ApplicationView* _tmp42_;
	GError* _inner_error0_ = NULL;
	self = (BudgieMenuWindow*) g_object_new (object_type, "relative-to", leparent, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "budgie-menu");
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->main_layout);
	self->main_layout = _tmp1_;
	_tmp2_ = self->main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 4);
	g_object_ref_sink (_tmp3_);
	header = _tmp3_;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_add_class (_tmp4_, "budgie-menu-header");
	_tmp5_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp5_;
	_tmp6_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	_tmp7_ = self->search_entry;
	gtk_box_pack_start (header, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	_tmp8_ = self->main_layout;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) header, FALSE, FALSE, (guint) 0);
	_tmp9_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp9_;
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp10_);
	view_container = _tmp10_;
	_tmp11_ = overlay_menus_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->overlay_menu);
	self->priv->overlay_menu = _tmp11_;
	_tmp12_ = self->priv->overlay;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) view_container);
	_tmp13_ = self->priv->overlay;
	_tmp14_ = self->priv->overlay_menu;
	gtk_overlay_add_overlay (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = application_list_view_new (settings);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->view);
	self->view = (ApplicationView*) _tmp15_;
	_tmp16_ = self->view;
	gtk_box_pack_end (view_container, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	_tmp17_ = self->main_layout;
	_tmp18_ = self->priv->overlay;
	gtk_box_pack_start (_tmp17_, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp19_);
	footer = _tmp19_;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) footer);
	gtk_style_context_add_class (_tmp20_, "budgie-menu-footer");
	_tmp21_ = user_button_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->user_indicator);
	self->priv->user_indicator = _tmp21_;
	_tmp22_ = self->priv->user_indicator;
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	_tmp23_ = self->priv->user_indicator;
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_START);
	_tmp24_ = budgie_menu_window_create_icon_button (self, "preferences-desktop");
	_g_object_unref0 (self->priv->budgie_desktop_prefs_button);
	self->priv->budgie_desktop_prefs_button = _tmp24_;
	_tmp25_ = self->priv->budgie_desktop_prefs_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _ ("Budgie Desktop Settings"));
	_tmp26_ = budgie_menu_window_create_icon_button (self, "preferences-system");
	_g_object_unref0 (self->priv->system_settings_button);
	self->priv->system_settings_button = _tmp26_;
	_tmp27_ = self->priv->system_settings_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("System Settings"));
	_tmp28_ = budgie_menu_window_create_icon_button (self, "system-shutdown-symbolic");
	_g_object_unref0 (self->priv->power_button);
	self->priv->power_button = _tmp28_;
	_tmp29_ = self->priv->power_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp29_, _ ("Power"));
	_tmp30_ = self->priv->user_indicator;
	gtk_box_pack_start (footer, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
	_tmp31_ = self->priv->power_button;
	gtk_box_pack_end (footer, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
	_tmp32_ = self->priv->system_settings_button;
	gtk_box_pack_end (footer, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	_tmp33_ = self->priv->budgie_desktop_prefs_button;
	gtk_box_pack_end (footer, (GtkWidget*) _tmp33_, FALSE, FALSE, (guint) 0);
	_tmp34_ = self->main_layout;
	gtk_box_pack_end (_tmp34_, (GtkWidget*) footer, FALSE, FALSE, (guint) 0);
	g_async_initable_new_async (TYPE_POWER_DIALOG_REMOTE_PROXY, 0, NULL, _budgie_menu_window_on_power_dialog_get_gasync_ready_callback, g_object_ref (self), "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.buddiesofbudgie.PowerDialog", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/buddiesofbudgie/PowerDialog", "g-interface-name", "org.buddiesofbudgie.PowerDialog", NULL);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda14__gtk_widget_button_press_event, self, 0);
	_tmp35_ = self->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp35_, "changed", (GCallback) ___lambda15__gtk_editable_changed, self, 0);
	_tmp36_ = self->priv->system_settings_button;
	g_signal_connect_object (_tmp36_, "clicked", (GCallback) ___lambda16__gtk_button_clicked, self, 0);
	_tmp37_ = self->priv->budgie_desktop_prefs_button;
	g_signal_connect_object (_tmp37_, "clicked", (GCallback) ___lambda17__gtk_button_clicked, self, 0);
	_tmp38_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp38_, "activate", (GCallback) ___lambda18__gtk_entry_activate, self, 0);
	_tmp39_ = self->priv->user_indicator;
	g_signal_connect_object ((GtkButton*) _tmp39_, "clicked", (GCallback) ___lambda19__gtk_button_clicked, self, 0);
	_tmp40_ = self->priv->power_button;
	g_signal_connect_object (_tmp40_, "clicked", (GCallback) ___lambda20__gtk_button_clicked, self, 0);
	_tmp41_ = self->priv->overlay_menu;
	g_signal_connect_object (_tmp41_, "item-clicked", (GCallback) _gtk_widget_hide_overlay_menus_item_clicked, (GtkWidget*) self, 0);
	_tmp42_ = self->view;
	g_signal_connect_object (_tmp42_, "app-launched", (GCallback) _gtk_widget_hide_application_view_app_launched, (GtkWidget*) self, 0);
	_g_object_unref0 (footer);
	_g_object_unref0 (view_container);
	_g_object_unref0 (header);
	return self;
}

BudgieMenuWindow*
budgie_menu_window_new (GSettings* settings,
                        GtkWidget* leparent)
{
	return budgie_menu_window_construct (TYPE_BUDGIE_MENU_WINDOW, settings, leparent);
}

static void
budgie_menu_window_on_power_dialog_get (BudgieMenuWindow* self,
                                        GObject* obj,
                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		PowerDialogRemote* _tmp0_ = NULL;
		PowerDialogRemote* _tmp1_;
		PowerDialogRemote* _tmp2_;
		PowerDialogRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (PowerDialogRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (PowerDialogRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->power_dialog);
		self->priv->power_dialog = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("BudgieMenuWindow.vala:164: Unable to get PowerDialog DBus remote: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static GtkButton*
budgie_menu_window_create_icon_button (BudgieMenuWindow* self,
                                       const gchar* icon_name)
{
	GtkButton* btn = NULL;
	GtkButton* _tmp0_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp0_);
	btn = _tmp0_;
	gtk_button_set_relief (btn, GTK_RELIEF_NONE);
	gtk_widget_set_valign ((GtkWidget*) btn, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) btn, GTK_ALIGN_END);
	result = btn;
	return result;
}

void
budgie_menu_window_open_desktop_entry (BudgieMenuWindow* self,
                                       const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	{
		GDesktopAppInfo* info = NULL;
		GDesktopAppInfo* _tmp0_;
		GDesktopAppInfo* _tmp1_;
		_tmp0_ = g_desktop_app_info_new (name);
		info = _tmp0_;
		_tmp1_ = info;
		if (_tmp1_ != NULL) {
			GDesktopAppInfo* _tmp2_;
			_tmp2_ = info;
			g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("BudgieMenuWindow.vala:186: Unable to launch %s: %s", name, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * Refresh the category and application views.
 */
void
budgie_menu_window_refresh (BudgieMenuWindow* self,
                            BudgieAppIndex* app_index,
                            gboolean now)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_index != NULL);
	if (now) {
		ApplicationView* _tmp0_;
		_tmp0_ = self->view;
		application_view_refresh (_tmp0_, app_index);
	} else {
		ApplicationView* _tmp1_;
		_tmp1_ = self->view;
		application_view_queue_refresh (_tmp1_, app_index, 1);
	}
}

/**
 * Reset the popover UI to the base state.
 *
 * If `clear_search` is set to true, the search entry text will be cleared.
 */
void
budgie_menu_window_reset (BudgieMenuWindow* self,
                          gboolean clear_search)
{
	ApplicationView* _tmp0_;
	OverlayMenus* _tmp1_;
	GtkSearchEntry* _tmp2_;
	GtkSearchEntry* _tmp3_;
	ApplicationView* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->view;
	application_view_on_show (_tmp0_);
	_tmp1_ = self->priv->overlay_menu;
	gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp1_, FALSE);
	_tmp2_ = self->search_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	_tmp4_ = self->view;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	if (clear_search) {
		GtkSearchEntry* _tmp5_;
		_tmp5_ = self->search_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp5_, "");
	}
}

static void
budgie_menu_window_real_show (GtkWidget* base)
{
	BudgieMenuWindow * self;
	self = (BudgieMenuWindow*) base;
	budgie_menu_window_reset (self, TRUE);
	GTK_WIDGET_CLASS (budgie_menu_window_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, budgie_popover_get_type (), BudgiePopover));
}

/**
 * Opens our overlay menu and makes all other widgets insensitive.
 */
static void
budgie_menu_window_open_overlay_menu (BudgieMenuWindow* self,
                                      const gchar* vis)
{
	OverlayMenus* _tmp0_;
	OverlayMenus* _tmp1_;
	GtkSearchEntry* _tmp2_;
	ApplicationView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vis != NULL);
	_tmp0_ = self->priv->overlay_menu;
	overlay_menus_set_visible_menu (_tmp0_, vis);
	_tmp1_ = self->priv->overlay_menu;
	gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp1_, TRUE);
	_tmp2_ = self->search_entry;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = self->view;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
}

static void
budgie_menu_window_class_init (BudgieMenuWindowClass * klass,
                               gpointer klass_data)
{
	budgie_menu_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieMenuWindow_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) budgie_menu_window_real_show;
	G_OBJECT_CLASS (klass)->finalize = budgie_menu_window_finalize;
}

static void
budgie_menu_window_instance_init (BudgieMenuWindow * self,
                                  gpointer klass)
{
	self->priv = budgie_menu_window_get_instance_private (self);
	self->priv->power_dialog = NULL;
}

static void
budgie_menu_window_finalize (GObject * obj)
{
	BudgieMenuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUDGIE_MENU_WINDOW, BudgieMenuWindow);
	_g_object_unref0 (self->main_layout);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->view);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->user_indicator);
	_g_object_unref0 (self->priv->budgie_desktop_prefs_button);
	_g_object_unref0 (self->priv->system_settings_button);
	_g_object_unref0 (self->priv->power_button);
	_g_object_unref0 (self->priv->overlay_menu);
	_g_object_unref0 (self->priv->power_dialog);
	G_OBJECT_CLASS (budgie_menu_window_parent_class)->finalize (obj);
}

GType
budgie_menu_window_get_type (void)
{
	return budgie_menu_window_type_id;
}

GType
budgie_menu_window_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuWindow), 0, (GInstanceInitFunc) budgie_menu_window_instance_init, NULL };
	budgie_menu_window_type_id = g_type_module_register_type (module, budgie_popover_get_type (), "BudgieMenuWindow", &g_define_type_info, 0);
	BudgieMenuWindow_private_offset = sizeof (BudgieMenuWindowPrivate);
	return budgie_menu_window_type_id;
}

