/* BudgieMenuButtons.c generated by valac 0.56.14, the Vala compiler
 * generated from BudgieMenuButtons.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include "budgie-appindexer.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

enum  {
	CATEGORY_BUTTON_0_PROPERTY,
	CATEGORY_BUTTON_CATEGORY_PROPERTY,
	CATEGORY_BUTTON_NUM_PROPERTIES
};
static GParamSpec* category_button_properties[CATEGORY_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MENU_BUTTON_0_PROPERTY,
	MENU_BUTTON_APP_PROPERTY,
	MENU_BUTTON_CATEGORY_PROPERTY,
	MENU_BUTTON_NUM_PROPERTIES
};
static GParamSpec* menu_button_properties[MENU_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CategoryButtonPrivate {
	BudgieCategory* _category;
};

struct _MenuButtonPrivate {
	BudgieApplication* _app;
	BudgieCategory* _category;
};

static gint CategoryButton_private_offset;
static gpointer category_button_parent_class = NULL;
static GType category_button_type_id = 0;
static gint MenuButton_private_offset;
static gpointer menu_button_parent_class = NULL;
static GType menu_button_type_id = 0;

static GObject * category_button_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void category_button_finalize (GObject * obj);
static void _vala_category_button_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_category_button_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void menu_button_set_app (MenuButton* self,
                          BudgieApplication* value);
static void menu_button_set_category (MenuButton* self,
                               BudgieCategory* value);
static void menu_button_drag_begin (MenuButton* self,
                             GdkDragContext* context);
static void _menu_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                    GdkDragContext* context,
                                                    gpointer self);
static void menu_button_drag_end (MenuButton* self,
                           GdkDragContext* context);
static void _menu_button_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                GdkDragContext* context,
                                                gpointer self);
static void menu_button_drag_data_get (MenuButton* self,
                                GdkDragContext* context,
                                GtkSelectionData* data,
                                guint info,
                                guint timestamp);
static void _menu_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          GtkSelectionData* selection_data,
                                                          guint info,
                                                          guint time_,
                                                          gpointer self);
static gboolean menu_button_hide_toplevel (MenuButton* self);
static gboolean _menu_button_hide_toplevel_gsource_func (gpointer self);
static void menu_button_finalize (GObject * obj);
static void _vala_menu_button_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_menu_button_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
category_button_get_instance_private (CategoryButton* self)
{
	return G_STRUCT_MEMBER_P (self, CategoryButton_private_offset);
}

CategoryButton*
category_button_construct (GType object_type,
                           BudgieCategory* category)
{
	CategoryButton * self = NULL;
	self = (CategoryButton*) g_object_new (object_type, "category", category, NULL);
	return self;
}

CategoryButton*
category_button_new (BudgieCategory* category)
{
	return category_button_construct (TYPE_CATEGORY_BUTTON, category);
}

BudgieCategory*
category_button_get_category (CategoryButton* self)
{
	BudgieCategory* result;
	BudgieCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
category_button_set_category (CategoryButton* self,
                              BudgieCategory* value)
{
	BudgieCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = category_button_get_category (self);
	if (old_value != value) {
		BudgieCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, category_button_properties[CATEGORY_BUTTON_CATEGORY_PROPERTY]);
	}
}

static GObject *
category_button_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CategoryButton * self;
	GtkBox* layout = NULL;
	GtkBox* _tmp0_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp1_ = NULL;
	BudgieCategory* _tmp2_;
	GtkBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkStyleContext* _tmp11_;
	GValue _tmp12_ = {0};
	GtkBox* _tmp13_;
	parent_class = G_OBJECT_CLASS (category_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CATEGORY_BUTTON, CategoryButton);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	layout = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp1_, 10);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 15);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = self->priv->_category;
	if (_tmp2_ == NULL) {
		GtkLabel* _tmp3_;
		_tmp3_ = label;
		gtk_label_set_label (_tmp3_, _ ("All"));
	} else {
		GtkLabel* _tmp4_;
		BudgieCategory* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = label;
		_tmp5_ = self->priv->_category;
		_tmp6_ = budgie_category_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp4_, _tmp7_);
	}
	_tmp8_ = layout;
	_tmp9_ = label;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp10_, "flat");
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp11_, "category-button");
	g_value_init (&_tmp12_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp12_, FALSE);
	g_object_set_property ((GObject*) self, "draw-indicator", &_tmp12_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	_tmp13_ = layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_g_object_unref0 (label);
	_g_object_unref0 (layout);
	return obj;
}

static void
category_button_class_init (CategoryButtonClass * klass,
                            gpointer klass_data)
{
	category_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CategoryButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_category_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_category_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = category_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = category_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CATEGORY_BUTTON_CATEGORY_PROPERTY, category_button_properties[CATEGORY_BUTTON_CATEGORY_PROPERTY] = g_param_spec_object ("category", "category", "category", BUDGIE_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
category_button_instance_init (CategoryButton * self,
                               gpointer klass)
{
	self->priv = category_button_get_instance_private (self);
	self->priv->_category = NULL;
}

static void
category_button_finalize (GObject * obj)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CATEGORY_BUTTON, CategoryButton);
	_g_object_unref0 (self->priv->_category);
	G_OBJECT_CLASS (category_button_parent_class)->finalize (obj);
}

/**
 * Factory widget to represent a category
 */
GType
category_button_get_type (void)
{
	return category_button_type_id;
}

GType
category_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CategoryButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) category_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CategoryButton), 0, (GInstanceInitFunc) category_button_instance_init, NULL };
	category_button_type_id = g_type_module_register_type (module, gtk_radio_button_get_type (), "CategoryButton", &g_define_type_info, 0);
	CategoryButton_private_offset = sizeof (CategoryButtonPrivate);
	return category_button_type_id;
}

static void
_vala_category_button_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_CATEGORY_PROPERTY:
		g_value_set_object (value, category_button_get_category (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_category_button_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_CATEGORY_PROPERTY:
		category_button_set_category (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
menu_button_get_instance_private (MenuButton* self)
{
	return G_STRUCT_MEMBER_P (self, MenuButton_private_offset);
}

static void
_menu_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               gpointer self)
{
	menu_button_drag_begin ((MenuButton*) self, context);
}

static void
_menu_button_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                           GdkDragContext* context,
                                           gpointer self)
{
	menu_button_drag_end ((MenuButton*) self, context);
}

static void
_menu_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                     GdkDragContext* context,
                                                     GtkSelectionData* selection_data,
                                                     guint info,
                                                     guint time_,
                                                     gpointer self)
{
	menu_button_drag_data_get ((MenuButton*) self, context, selection_data, info, time_);
}

MenuButton*
menu_button_construct (GType object_type,
                       BudgieApplication* app,
                       BudgieCategory* category,
                       gint icon_size)
{
	MenuButton * self = NULL;
	GtkImage* img = NULL;
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	GtkImage* _tmp2_ = NULL;
	GtkLabel* lab = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	static const GtkTargetEntry drag_targets[2] = {{"text/uri-list", (guint) 0, (guint) 0}, {"application/x-desktop", (guint) 0, (guint) 0}};
	GtkBox* layout = NULL;
	GtkBox* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkStyleContext* _tmp9_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (category != NULL, NULL);
	self = (MenuButton*) g_object_new (object_type, NULL);
	menu_button_set_app (self, app);
	menu_button_set_category (self, category);
	_tmp0_ = budgie_application_get_icon (app);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkImage*) gtk_image_new_from_gicon (_tmp1_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
	gtk_image_set_pixel_size (_tmp2_, icon_size);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp2_, 7);
	g_object_ref_sink (_tmp2_);
	img = _tmp2_;
	_tmp3_ = budgie_application_get_name (app);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp5_, 0.0f);
	gtk_label_set_max_width_chars (_tmp5_, 1);
	gtk_label_set_ellipsize (_tmp5_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	g_object_ref_sink (_tmp5_);
	lab = _tmp5_;
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, drag_targets, (gint) G_N_ELEMENTS (drag_targets), GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-begin", (GCallback) _menu_button_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-end", (GCallback) _menu_button_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-data-get", (GCallback) _menu_button_drag_data_get_gtk_widget_drag_data_get, self, 0);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	layout = _tmp6_;
	gtk_widget_set_size_request ((GtkWidget*) layout, 250, -1);
	gtk_box_pack_start (layout, (GtkWidget*) img, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (layout, (GtkWidget*) lab, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp7_ = budgie_application_get_description (app);
	_tmp8_ = _tmp7_;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp8_);
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp9_, "flat");
	_g_object_unref0 (layout);
	_g_object_unref0 (lab);
	_g_object_unref0 (img);
	return self;
}

MenuButton*
menu_button_new (BudgieApplication* app,
                 BudgieCategory* category,
                 gint icon_size)
{
	return menu_button_construct (TYPE_MENU_BUTTON, app, category, icon_size);
}

/**
 * Check if this item is for a control center panel.
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
menu_button_is_control_center_panel (MenuButton* self)
{
	gchar* control_center = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BudgieApplication* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("budgie-control-center");
	control_center = _tmp0_;
	_tmp2_ = self->priv->_app;
	_tmp3_ = budgie_application_get_exec (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = control_center;
	if (string_contains (_tmp4_, _tmp5_)) {
		BudgieApplication* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp6_ = self->priv->_app;
		_tmp7_ = budgie_application_get_exec (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = control_center;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp1_ = _tmp10_ != _tmp13_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_free0 (control_center);
	return result;
}

static gboolean
menu_button_hide_toplevel (MenuButton* self)
{
	GtkWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_hide (_tmp0_);
	result = FALSE;
	return result;
}

static void
menu_button_drag_begin (MenuButton* self,
                        GdkDragContext* context)
{
	BudgieApplication* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_app;
	_tmp1_ = budgie_application_get_icon (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_drag_set_icon_gicon (context, _tmp2_, 0, 0);
}

static gboolean
_menu_button_hide_toplevel_gsource_func (gpointer self)
{
	gboolean result;
	result = menu_button_hide_toplevel ((MenuButton*) self);
	return result;
}

static void
menu_button_drag_end (MenuButton* self,
                      GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _menu_button_hide_toplevel_gsource_func, g_object_ref (self), g_object_unref);
}

static void
menu_button_drag_data_get (MenuButton* self,
                           GdkDragContext* context,
                           GtkSelectionData* data,
                           guint info,
                           guint timestamp)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	{
		gchar* _tmp0_ = NULL;
		BudgieApplication* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** urls = NULL;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint urls_length1;
		gint _urls_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp1_ = self->priv->_app;
		_tmp2_ = budgie_application_get_desktop_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_filename_to_uri (_tmp3_, NULL, &_inner_error0_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_tmp6_ = g_new0 (gchar*, 1 + 1);
		_tmp6_[0] = _tmp5_;
		urls = _tmp6_;
		urls_length1 = 1;
		_urls_size_ = urls_length1;
		_tmp7_ = urls;
		_tmp7__length1 = urls_length1;
		gtk_selection_data_set_uris (data, _tmp7_);
		urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BudgieMenuButtons.vala:120: Failed to set copy data: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

BudgieApplication*
menu_button_get_app (MenuButton* self)
{
	BudgieApplication* result;
	BudgieApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app;
	result = _tmp0_;
	return result;
}

static void
menu_button_set_app (MenuButton* self,
                     BudgieApplication* value)
{
	BudgieApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = menu_button_get_app (self);
	if (old_value != value) {
		BudgieApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app);
		self->priv->_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, menu_button_properties[MENU_BUTTON_APP_PROPERTY]);
	}
}

BudgieCategory*
menu_button_get_category (MenuButton* self)
{
	BudgieCategory* result;
	BudgieCategory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

static void
menu_button_set_category (MenuButton* self,
                          BudgieCategory* value)
{
	BudgieCategory* old_value;
	g_return_if_fail (self != NULL);
	old_value = menu_button_get_category (self);
	if (old_value != value) {
		BudgieCategory* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, menu_button_properties[MENU_BUTTON_CATEGORY_PROPERTY]);
	}
}

static void
menu_button_class_init (MenuButtonClass * klass,
                        gpointer klass_data)
{
	menu_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MenuButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_menu_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_menu_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = menu_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_APP_PROPERTY, menu_button_properties[MENU_BUTTON_APP_PROPERTY] = g_param_spec_object ("app", "app", "app", BUDGIE_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_CATEGORY_PROPERTY, menu_button_properties[MENU_BUTTON_CATEGORY_PROPERTY] = g_param_spec_object ("category", "category", "category", BUDGIE_TYPE_CATEGORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
menu_button_instance_init (MenuButton * self,
                           gpointer klass)
{
	self->priv = menu_button_get_instance_private (self);
}

static void
menu_button_finalize (GObject * obj)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MENU_BUTTON, MenuButton);
	_g_object_unref0 (self->priv->_app);
	_g_object_unref0 (self->priv->_category);
	G_OBJECT_CLASS (menu_button_parent_class)->finalize (obj);
}

/**
 * Factory widget to represent a menu item
 */
GType
menu_button_get_type (void)
{
	return menu_button_type_id;
}

GType
menu_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MenuButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) menu_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MenuButton), 0, (GInstanceInitFunc) menu_button_instance_init, NULL };
	menu_button_type_id = g_type_module_register_type (module, gtk_button_get_type (), "MenuButton", &g_define_type_info, 0);
	MenuButton_private_offset = sizeof (MenuButtonPrivate);
	return menu_button_type_id;
}

static void
_vala_menu_button_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_APP_PROPERTY:
		g_value_set_object (value, menu_button_get_app (self));
		break;
		case MENU_BUTTON_CATEGORY_PROPERTY:
		g_value_set_object (value, menu_button_get_category (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_menu_button_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_APP_PROPERTY:
		menu_button_set_app (self, g_value_get_object (value));
		break;
		case MENU_BUTTON_CATEGORY_PROPERTY:
		menu_button_set_category (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

