/* notification.c generated by valac 0.56.14, the Vala compiler
 * generated from notification.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-private.h"
#include <gio/gdesktopappinfo.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

enum  {
	BUDGIE_NOTIFICATION_0_PROPERTY,
	BUDGIE_NOTIFICATION_APP_INFO_PROPERTY,
	BUDGIE_NOTIFICATION_APP_ID_PROPERTY,
	BUDGIE_NOTIFICATION_URGENCY_PROPERTY,
	BUDGIE_NOTIFICATION_ID_PROPERTY,
	BUDGIE_NOTIFICATION_APP_NAME_PROPERTY,
	BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY,
	BUDGIE_NOTIFICATION_HINTS_PROPERTY,
	BUDGIE_NOTIFICATION_ACTIONS_PROPERTY,
	BUDGIE_NOTIFICATION_BODY_PROPERTY,
	BUDGIE_NOTIFICATION_SUMMARY_PROPERTY,
	BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY,
	BUDGIE_NOTIFICATION_CATEGORY_PROPERTY,
	BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY,
	BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY,
	BUDGIE_NOTIFICATION_IMAGE_PROPERTY,
	BUDGIE_NOTIFICATION_NUM_PROPERTIES
};
static GParamSpec* budgie_notification_properties[BUDGIE_NOTIFICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BudgieNotificationPrivate {
	GDesktopAppInfo* _app_info;
	gchar* _app_id;
	GNotificationPriority _urgency;
	guint32 _id;
	gchar* _app_name;
	gchar* _notification_icon;
	GHashTable* _hints;
	gchar** _actions;
	gint _actions_length1;
	gint __actions_size_;
	gchar* _body;
	gchar* _summary;
	guint _expire_timeout;
	gchar* _category;
	gint64 _timestamp;
	GtkImage* _app_image;
	GtkImage* _image;
};

static gint BudgieNotification_private_offset;
static gpointer budgie_notification_parent_class = NULL;
static GRegex* budgie_notification_entity_regex;
static GRegex* budgie_notification_entity_regex = NULL;
static GRegex* budgie_notification_tag_regex;
static GRegex* budgie_notification_tag_regex = NULL;

static GdkPixbuf* budgie_notification_decode_image (BudgieNotification* self,
                                             GVariant* img);
static gchar* budgie_notification_fix_markup (BudgieNotification* self,
                                       const gchar* markup);
static GtkImage* budgie_notification_get_appinfo_image (BudgieNotification* self,
                                                 GtkIconSize size,
                                                 const gchar* fallback);
static void budgie_notification_set_app_info (BudgieNotification* self,
                                       GDesktopAppInfo* value);
static void budgie_notification_set_app_id (BudgieNotification* self,
                                     const gchar* value);
static void budgie_notification_set_urgency (BudgieNotification* self,
                                      GNotificationPriority value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GObject * budgie_notification_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void budgie_notification_finalize (GObject * obj);
static GType budgie_notification_get_type_once (void);
static void _vala_budgie_notification_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_budgie_notification_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
 * Enumeration of why a notification was closed.
 */
static GType
budgie_notification_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED, "BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED", "expired"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED", "dismissed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED, "BUDGIE_NOTIFICATION_CLOSE_REASON_CLOSED", "closed"}, {BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED, "BUDGIE_NOTIFICATION_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
	GType budgie_notification_close_reason_type_id;
	budgie_notification_close_reason_type_id = g_enum_register_static ("BudgieNotificationCloseReason", values);
	return budgie_notification_close_reason_type_id;
}

GType
budgie_notification_close_reason_get_type (void)
{
	static volatile gsize budgie_notification_close_reason_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_close_reason_type_id__once)) {
		GType budgie_notification_close_reason_type_id;
		budgie_notification_close_reason_type_id = budgie_notification_close_reason_get_type_once ();
		g_once_init_leave (&budgie_notification_close_reason_type_id__once, budgie_notification_close_reason_type_id);
	}
	return budgie_notification_close_reason_type_id__once;
}

/**
 * Enumeration of where notification popups will be shown.
 */
static GType
budgie_notification_position_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_NOTIFICATION_POSITION_TOP_LEFT, "BUDGIE_NOTIFICATION_POSITION_TOP_LEFT", "top-left"}, {BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT, "BUDGIE_NOTIFICATION_POSITION_TOP_RIGHT", "top-right"}, {BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT, "BUDGIE_NOTIFICATION_POSITION_BOTTOM_LEFT", "bottom-left"}, {BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT, "BUDGIE_NOTIFICATION_POSITION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
	GType budgie_notification_position_type_id;
	budgie_notification_position_type_id = g_enum_register_static ("BudgieNotificationPosition", values);
	return budgie_notification_position_type_id;
}

GType
budgie_notification_position_get_type (void)
{
	static volatile gsize budgie_notification_position_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_position_type_id__once)) {
		GType budgie_notification_position_type_id;
		budgie_notification_position_type_id = budgie_notification_position_get_type_once ();
		g_once_init_leave (&budgie_notification_position_type_id__once, budgie_notification_position_type_id);
	}
	return budgie_notification_position_type_id__once;
}

static inline gpointer
budgie_notification_get_instance_private (BudgieNotification* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotification_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

BudgieNotification*
budgie_notification_construct (GType object_type,
                               guint32 id,
                               const gchar* app_name,
                               const gchar* notification_icon,
                               const gchar* summary,
                               const gchar* body,
                               gchar** actions,
                               gint actions_length1,
                               GHashTable* hints,
                               guint expire_timeout)
{
	BudgieNotification * self = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	g_return_val_if_fail (app_name != NULL, NULL);
	g_return_val_if_fail (notification_icon != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (hints != NULL, NULL);
	_tmp0_ = g_strdup (app_name);
	name = _tmp0_;
	_tmp2_ = name;
	if (string_contains (_tmp2_, "budgie")) {
		_tmp1_ = string_contains (notification_icon, "caffeine");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Caffeine Mode"));
		_g_free0 (name);
		name = _tmp3_;
	}
	_tmp4_ = name;
	self = (BudgieNotification*) g_object_new (object_type, "id", id, "app-name", _tmp4_, "notification-icon", notification_icon, "summary", summary, "body", body, "actions", actions, "hints", hints, "expire-timeout", expire_timeout, NULL);
	_g_free0 (name);
	return self;
}

BudgieNotification*
budgie_notification_new (guint32 id,
                         const gchar* app_name,
                         const gchar* notification_icon,
                         const gchar* summary,
                         const gchar* body,
                         gchar** actions,
                         gint actions_length1,
                         GHashTable* hints,
                         guint expire_timeout)
{
	return budgie_notification_construct (BUDGIE_TYPE_NOTIFICATION, id, app_name, notification_icon, summary, body, actions, actions_length1, hints, expire_timeout);
}

static GdkPixbuf*
budgie_notification_decode_image (BudgieNotification* self,
                                  GVariant* img)
{
	gint width = 0;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gint _tmp2_;
	gint height = 0;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	gint _tmp5_;
	gint rowstride = 0;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	gint _tmp8_;
	gboolean has_alpha = FALSE;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gboolean _tmp11_;
	gint bits_per_sample = 0;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gint _tmp14_;
	guint8* raw = NULL;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	void* _tmp17_;
	guint8* _tmp18_;
	gint _tmp18__length1;
	gint raw_length1;
	gint _raw_size_;
	GdkPixbuf* pixbuf = NULL;
	guint8* _tmp19_;
	gint _tmp19__length1;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (img != NULL, NULL);
	_tmp0_ = g_variant_get_child_value (img, (gsize) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = (gint) g_variant_get_int32 (_tmp1_);
	_g_variant_unref0 (_tmp1_);
	width = _tmp2_;
	_tmp3_ = g_variant_get_child_value (img, (gsize) 1);
	_tmp4_ = _tmp3_;
	_tmp5_ = (gint) g_variant_get_int32 (_tmp4_);
	_g_variant_unref0 (_tmp4_);
	height = _tmp5_;
	_tmp6_ = g_variant_get_child_value (img, (gsize) 2);
	_tmp7_ = _tmp6_;
	_tmp8_ = (gint) g_variant_get_int32 (_tmp7_);
	_g_variant_unref0 (_tmp7_);
	rowstride = _tmp8_;
	_tmp9_ = g_variant_get_child_value (img, (gsize) 3);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_get_boolean (_tmp10_);
	_g_variant_unref0 (_tmp10_);
	has_alpha = _tmp11_;
	_tmp12_ = g_variant_get_child_value (img, (gsize) 4);
	_tmp13_ = _tmp12_;
	_tmp14_ = (gint) g_variant_get_int32 (_tmp13_);
	_g_variant_unref0 (_tmp13_);
	bits_per_sample = _tmp14_;
	_tmp15_ = g_variant_get_child_value (img, (gsize) 6);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_get_data (_tmp16_);
	_tmp18_ = (guint8*) _tmp17_;
	_tmp18__length1 = -1;
	_g_variant_unref0 (_tmp16_);
	raw = _tmp18_;
	raw_length1 = _tmp18__length1;
	_raw_size_ = raw_length1;
	_tmp19_ = raw;
	_tmp19__length1 = raw_length1;
	_tmp20_ = gdk_pixbuf_new_from_data (_tmp19_, GDK_COLORSPACE_RGB, has_alpha, bits_per_sample, width, height, rowstride, (GdkPixbufDestroyNotify) NULL, NULL);
	pixbuf = _tmp20_;
	if (height != 48) {
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		_tmp21_ = pixbuf;
		_tmp22_ = gdk_pixbuf_scale_simple (_tmp21_, 48, 48, GDK_INTERP_BILINEAR);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp22_;
	}
	_tmp23_ = pixbuf;
	_tmp24_ = gdk_pixbuf_copy (_tmp23_);
	result = _tmp24_;
	_g_object_unref0 (pixbuf);
	return result;
}

/**
 * Taken from gnome-shell. Notification markup is always a mess, and this is cleaner
 * than our previous solution.
 */
static gchar*
budgie_notification_fix_markup (BudgieNotification* self,
                                const gchar* markup)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup != NULL, NULL);
	_tmp0_ = g_strdup (markup);
	text = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp2_ = budgie_notification_entity_regex;
		_tmp3_ = strlen (markup);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_replace (_tmp2_, markup, (gssize) _tmp4_, 0, "&amp;", 0, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (text);
		text = _tmp6_;
		_tmp8_ = budgie_notification_tag_regex;
		_tmp9_ = text;
		_tmp10_ = text;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_regex_replace (_tmp8_, _tmp9_, (gssize) _tmp12_, 0, "&lt;", 0, &_inner_error0_);
		_tmp7_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp1_);
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (text);
		text = _tmp14_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("notification.vala:262: Invalid regex: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = text;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkImage*
budgie_notification_get_appinfo_image (BudgieNotification* self,
                                       GtkIconSize size,
                                       const gchar* fallback)
{
	GDesktopAppInfo* _tmp0_;
	gchar* app_icon_name = NULL;
	GDesktopAppInfo* _tmp5_;
	gchar* _tmp6_;
	GIcon* app_icon = NULL;
	GDesktopAppInfo* _tmp7_;
	GIcon* _tmp8_;
	GIcon* _tmp9_;
	const gchar* _tmp10_;
	GtkImage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	if (_tmp0_ == NULL) {
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkIconTheme* _tmp3_;
		GtkImage* _tmp4_;
		_tmp1_ = gtk_icon_theme_get_default ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		theme = _tmp2_;
		_tmp3_ = theme;
		if (!gtk_icon_theme_has_icon (_tmp3_, fallback)) {
			result = NULL;
			_g_object_unref0 (theme);
			return result;
		}
		_tmp4_ = (GtkImage*) gtk_image_new_from_icon_name (fallback, (GtkIconSize) size);
		g_object_ref_sink (_tmp4_);
		result = _tmp4_;
		_g_object_unref0 (theme);
		return result;
	}
	_tmp5_ = self->priv->_app_info;
	_tmp6_ = g_desktop_app_info_get_string (_tmp5_, "Icon");
	app_icon_name = _tmp6_;
	_tmp7_ = self->priv->_app_info;
	_tmp8_ = g_app_info_get_icon ((GAppInfo*) _tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	app_icon = _tmp9_;
	_tmp10_ = app_icon_name;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		GtkImage* _tmp12_;
		_tmp11_ = app_icon_name;
		_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp11_, (GtkIconSize) size);
		g_object_ref_sink (_tmp12_);
		result = _tmp12_;
		_g_object_unref0 (app_icon);
		_g_free0 (app_icon_name);
		return result;
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp14_ = app_icon_name;
		if (_tmp14_ == NULL) {
			GIcon* _tmp15_;
			_tmp15_ = app_icon;
			_tmp13_ = _tmp15_ != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GIcon* _tmp16_;
			GtkImage* _tmp17_;
			_tmp16_ = app_icon;
			_tmp17_ = (GtkImage*) gtk_image_new_from_gicon (_tmp16_, (GtkIconSize) size);
			g_object_ref_sink (_tmp17_);
			result = _tmp17_;
			_g_object_unref0 (app_icon);
			_g_free0 (app_icon_name);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (app_icon);
	_g_free0 (app_icon_name);
	return result;
}

GDesktopAppInfo*
budgie_notification_get_app_info (BudgieNotification* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_info (BudgieNotification* self,
                                  GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_INFO_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_app_id (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_id;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_id (BudgieNotification* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ID_PROPERTY]);
	}
}

GNotificationPriority
budgie_notification_get_urgency (BudgieNotification* self)
{
	GNotificationPriority result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_urgency;
	return result;
}

static void
budgie_notification_set_urgency (BudgieNotification* self,
                                 GNotificationPriority value)
{
	GNotificationPriority old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_urgency (self);
	if (old_value != value) {
		self->priv->_urgency = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_URGENCY_PROPERTY]);
	}
}

guint32
budgie_notification_get_id (BudgieNotification* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_id;
	return result;
}

static void
budgie_notification_set_id (BudgieNotification* self,
                            guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_ID_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_app_name (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_name;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_app_name (BudgieNotification* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_app_name);
		self->priv->_app_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_NAME_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_notification_icon (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notification_icon;
	result = _tmp0_;
	return result;
}

static void
budgie_notification_set_notification_icon (BudgieNotification* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_notification_icon (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_notification_icon);
		self->priv->_notification_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY]);
	}
}

GHashTable*
budgie_notification_get_hints (BudgieNotification* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hints;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
budgie_notification_set_hints (BudgieNotification* self,
                               GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_hints (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_hints);
		self->priv->_hints = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_HINTS_PROPERTY]);
	}
}

gchar**
budgie_notification_get_actions (BudgieNotification* self,
                                 gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	_tmp0__length1 = self->priv->_actions_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
budgie_notification_set_actions (BudgieNotification* self,
                                 gchar** value,
                                 gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_actions (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_actions = _tmp0_;
		self->priv->_actions_length1 = _tmp0__length1;
		self->priv->__actions_size_ = self->priv->_actions_length1;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_ACTIONS_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_body (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_body (BudgieNotification* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_body (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_body);
		self->priv->_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_BODY_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_summary (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_summary;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_summary (BudgieNotification* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_summary (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_summary);
		self->priv->_summary = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_SUMMARY_PROPERTY]);
	}
}

guint
budgie_notification_get_expire_timeout (BudgieNotification* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_expire_timeout;
	return result;
}

void
budgie_notification_set_expire_timeout (BudgieNotification* self,
                                        guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_expire_timeout (self);
	if (old_value != value) {
		self->priv->_expire_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY]);
	}
}

const gchar*
budgie_notification_get_category (BudgieNotification* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_category (BudgieNotification* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_category (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_category);
		self->priv->_category = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_CATEGORY_PROPERTY]);
	}
}

gint64
budgie_notification_get_timestamp (BudgieNotification* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_timestamp;
	return result;
}

void
budgie_notification_set_timestamp (BudgieNotification* self,
                                   gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_timestamp (self);
	if (old_value != value) {
		self->priv->_timestamp = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY]);
	}
}

GtkImage*
budgie_notification_get_app_image (BudgieNotification* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_image;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_app_image (BudgieNotification* self,
                                   GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_app_image (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_image);
		self->priv->_app_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY]);
	}
}

GtkImage*
budgie_notification_get_image (BudgieNotification* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image;
	result = _tmp0_;
	return result;
}

void
budgie_notification_set_image (BudgieNotification* self,
                               GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notification_get_image (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_image);
		self->priv->_image = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notification_properties[BUDGIE_NOTIFICATION_IMAGE_PROPERTY]);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GObject *
budgie_notification_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotification * self;
	GVariant* variant = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GHashTable* _tmp5_;
	gconstpointer _tmp6_;
	GVariant* _tmp7_;
	gboolean _tmp11_ = FALSE;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	GVariant* _tmp14_;
	gboolean _tmp19_ = FALSE;
	GHashTable* _tmp20_;
	gconstpointer _tmp21_;
	GVariant* _tmp22_;
	GDesktopAppInfo* _tmp35_;
	GDesktopAppInfo* _tmp46_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GtkImage* _tmp55_;
	GtkImage* _tmp56_;
	gboolean image_found = FALSE;
	gboolean _tmp57_ = FALSE;
	GHashTable* _tmp58_;
	gconstpointer _tmp59_;
	GVariant* _tmp60_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp121_ = FALSE;
	const gchar* _tmp133_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_notification_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	variant = NULL;
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	budgie_notification_set_timestamp (self, g_date_time_to_unix (_tmp3_));
	_g_date_time_unref0 (_tmp3_);
	_g_time_zone_unref0 (_tmp1_);
	_tmp5_ = self->priv->_hints;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "urgency");
	variant = (GVariant*) _tmp6_;
	_tmp7_ = variant;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_;
		const GVariantType* _tmp9_;
		_tmp8_ = variant;
		_tmp9_ = G_VARIANT_TYPE_BYTE;
		_tmp4_ = g_variant_is_of_type (_tmp8_, _tmp9_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GVariant* _tmp10_;
		_tmp10_ = variant;
		budgie_notification_set_urgency (self, (GNotificationPriority) g_variant_get_byte (_tmp10_));
	}
	_tmp12_ = self->priv->_hints;
	_tmp13_ = g_hash_table_lookup (_tmp12_, "category");
	variant = (GVariant*) _tmp13_;
	_tmp14_ = variant;
	if (_tmp14_ != NULL) {
		GVariant* _tmp15_;
		const GVariantType* _tmp16_;
		_tmp15_ = variant;
		_tmp16_ = G_VARIANT_TYPE_STRING;
		_tmp11_ = g_variant_is_of_type (_tmp15_, _tmp16_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GVariant* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = variant;
		_tmp18_ = g_variant_get_string (_tmp17_, NULL);
		budgie_notification_set_category (self, _tmp18_);
	}
	_tmp20_ = self->priv->_hints;
	_tmp21_ = g_hash_table_lookup (_tmp20_, "desktop-entry");
	variant = (GVariant*) _tmp21_;
	_tmp22_ = variant;
	if (_tmp22_ != NULL) {
		GVariant* _tmp23_;
		const GVariantType* _tmp24_;
		_tmp23_ = variant;
		_tmp24_ = G_VARIANT_TYPE_STRING;
		_tmp19_ = g_variant_is_of_type (_tmp23_, _tmp24_);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GVariant* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GDesktopAppInfo* _tmp33_;
		GDesktopAppInfo* _tmp34_;
		_tmp25_ = variant;
		_tmp26_ = g_variant_get_string (_tmp25_, NULL);
		budgie_notification_set_app_id (self, _tmp26_);
		_tmp27_ = self->priv->_app_id;
		_tmp28_ = string_replace (_tmp27_, ".desktop", "");
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp29_);
		_tmp30_ = self->priv->_app_id;
		_tmp31_ = g_strdup_printf ("%s.desktop", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_desktop_app_info_new (_tmp32_);
		_tmp34_ = _tmp33_;
		budgie_notification_set_app_info (self, _tmp34_);
		_g_object_unref0 (_tmp34_);
		_g_free0 (_tmp32_);
	}
	_tmp35_ = self->priv->_app_info;
	if (_tmp35_ == NULL) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GDesktopAppInfo* _tmp44_;
		GDesktopAppInfo* _tmp45_;
		_tmp36_ = self->priv->_app_name;
		_tmp37_ = string_replace (_tmp36_, " ", "-");
		_tmp38_ = _tmp37_;
		_tmp39_ = g_utf8_strdown (_tmp38_, (gssize) -1);
		_tmp40_ = _tmp39_;
		budgie_notification_set_app_id (self, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_tmp41_ = self->priv->_app_id;
		_tmp42_ = g_strdup_printf ("%s.desktop", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_desktop_app_info_new (_tmp43_);
		_tmp45_ = _tmp44_;
		budgie_notification_set_app_info (self, _tmp45_);
		_g_object_unref0 (_tmp45_);
		_g_free0 (_tmp43_);
	}
	_tmp46_ = self->priv->_app_info;
	if (_tmp46_ != NULL) {
		gchar* _tmp47_ = NULL;
		GDesktopAppInfo* _tmp48_;
		gchar* _tmp49_;
		_tmp48_ = self->priv->_app_info;
		_tmp49_ = g_desktop_app_info_get_string (_tmp48_, "Name");
		_tmp47_ = _tmp49_;
		if (_tmp47_ == NULL) {
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp50_ = self->priv->_app_name;
			_tmp51_ = g_strdup (_tmp50_);
			_g_free0 (_tmp47_);
			_tmp47_ = _tmp51_;
		}
		budgie_notification_set_app_name (self, _tmp47_);
		_g_free0 (_tmp47_);
	}
	_tmp52_ = self->priv->_app_id;
	_tmp53_ = g_utf8_strdown (_tmp52_, (gssize) -1);
	_tmp54_ = _tmp53_;
	_tmp55_ = budgie_notification_get_appinfo_image (self, GTK_ICON_SIZE_DND, _tmp54_);
	_tmp56_ = _tmp55_;
	budgie_notification_set_app_image (self, _tmp56_);
	_g_object_unref0 (_tmp56_);
	_g_free0 (_tmp54_);
	image_found = FALSE;
	_tmp58_ = self->priv->_hints;
	_tmp59_ = g_hash_table_lookup (_tmp58_, "image-data");
	variant = (GVariant*) _tmp59_;
	_tmp60_ = variant;
	if (_tmp60_ != NULL) {
		_tmp57_ = TRUE;
	} else {
		GHashTable* _tmp61_;
		gconstpointer _tmp62_;
		GVariant* _tmp63_;
		_tmp61_ = self->priv->_hints;
		_tmp62_ = g_hash_table_lookup (_tmp61_, "image_data");
		variant = (GVariant*) _tmp62_;
		_tmp63_ = variant;
		_tmp57_ = _tmp63_ != NULL;
	}
	if (_tmp57_) {
		GdkPixbuf* pixbuf = NULL;
		GVariant* _tmp64_;
		GdkPixbuf* _tmp65_;
		GdkPixbuf* _tmp66_;
		_tmp64_ = variant;
		_tmp65_ = budgie_notification_decode_image (self, _tmp64_);
		pixbuf = _tmp65_;
		_tmp66_ = pixbuf;
		if (_tmp66_ != NULL) {
			GdkPixbuf* _tmp67_;
			GtkImage* _tmp68_;
			GtkImage* _tmp69_;
			_tmp67_ = pixbuf;
			_tmp68_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp67_);
			g_object_ref_sink (_tmp68_);
			_tmp69_ = _tmp68_;
			budgie_notification_set_image (self, _tmp69_);
			_g_object_unref0 (_tmp69_);
			image_found = TRUE;
		}
		_g_object_unref0 (pixbuf);
	}
	if (!image_found) {
		gboolean _tmp71_ = FALSE;
		GHashTable* _tmp72_;
		gconstpointer _tmp73_;
		GVariant* _tmp74_;
		_tmp72_ = self->priv->_hints;
		_tmp73_ = g_hash_table_lookup (_tmp72_, "image-path");
		variant = (GVariant*) _tmp73_;
		_tmp74_ = variant;
		if (_tmp74_ != NULL) {
			_tmp71_ = TRUE;
		} else {
			GHashTable* _tmp75_;
			gconstpointer _tmp76_;
			GVariant* _tmp77_;
			_tmp75_ = self->priv->_hints;
			_tmp76_ = g_hash_table_lookup (_tmp75_, "image_path");
			variant = (GVariant*) _tmp76_;
			_tmp77_ = variant;
			_tmp71_ = _tmp77_ != NULL;
		}
		_tmp70_ = _tmp71_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		gchar* path = NULL;
		GVariant* _tmp78_;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		gboolean _tmp81_ = FALSE;
		GtkIconTheme* _tmp82_;
		const gchar* _tmp83_;
		_tmp78_ = variant;
		_tmp79_ = g_variant_get_string (_tmp78_, NULL);
		_tmp80_ = g_strdup (_tmp79_);
		path = _tmp80_;
		_tmp82_ = gtk_icon_theme_get_default ();
		_tmp83_ = path;
		if (gtk_icon_theme_has_icon (_tmp82_, _tmp83_)) {
			const gchar* _tmp84_;
			const gchar* _tmp85_;
			_tmp84_ = path;
			_tmp85_ = self->priv->_notification_icon;
			_tmp81_ = g_strcmp0 (_tmp84_, _tmp85_) != 0;
		} else {
			_tmp81_ = FALSE;
		}
		if (_tmp81_) {
			GThemedIcon* icon = NULL;
			const gchar* _tmp86_;
			GThemedIcon* _tmp87_;
			GThemedIcon* _tmp88_;
			GtkImage* _tmp89_;
			GtkImage* _tmp90_;
			_tmp86_ = path;
			_tmp87_ = (GThemedIcon*) g_themed_icon_new (_tmp86_);
			icon = _tmp87_;
			_tmp88_ = icon;
			_tmp89_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp88_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
			g_object_ref_sink (_tmp89_);
			_tmp90_ = _tmp89_;
			budgie_notification_set_image (self, _tmp90_);
			_g_object_unref0 (_tmp90_);
			image_found = TRUE;
			_g_object_unref0 (icon);
		} else {
			gboolean _tmp91_ = FALSE;
			const gchar* _tmp92_;
			_tmp92_ = path;
			if (g_str_has_prefix (_tmp92_, "/")) {
				_tmp91_ = TRUE;
			} else {
				const gchar* _tmp93_;
				_tmp93_ = path;
				_tmp91_ = g_str_has_prefix (_tmp93_, "file://");
			}
			if (_tmp91_) {
				{
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp94_;
					GdkPixbuf* _tmp95_;
					GdkPixbuf* _tmp96_;
					GtkImage* _tmp97_;
					GtkImage* _tmp98_;
					_tmp94_ = path;
					_tmp95_ = gdk_pixbuf_new_from_file_at_size (_tmp94_, 48, 48, &_inner_error0_);
					pixbuf = _tmp95_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp96_ = pixbuf;
					_tmp97_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp96_);
					g_object_ref_sink (_tmp97_);
					_tmp98_ = _tmp97_;
					budgie_notification_set_image (self, _tmp98_);
					_g_object_unref0 (_tmp98_);
					image_found = TRUE;
					_g_object_unref0 (pixbuf);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp99_;
					const gchar* _tmp100_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp99_ = e;
					_tmp100_ = _tmp99_->message;
					g_critical ("notification.vala:174: Unable to get pixbuf from path: %s", _tmp100_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (path);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
				}
			}
		}
		_g_free0 (path);
	}
	if (!image_found) {
		gboolean _tmp101_ = FALSE;
		const gchar* _tmp102_;
		_tmp102_ = self->priv->_notification_icon;
		if (g_strcmp0 (_tmp102_, "") != 0) {
			const gchar* _tmp103_;
			_tmp103_ = self->priv->_notification_icon;
			_tmp101_ = !string_contains (_tmp103_, "/");
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			const gchar* _tmp104_;
			GtkImage* _tmp105_;
			GtkImage* _tmp106_;
			_tmp104_ = self->priv->_notification_icon;
			_tmp105_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp104_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
			g_object_ref_sink (_tmp105_);
			_tmp106_ = _tmp105_;
			budgie_notification_set_image (self, _tmp106_);
			_g_object_unref0 (_tmp106_);
			image_found = TRUE;
		} else {
			gboolean _tmp107_ = FALSE;
			const gchar* _tmp108_;
			_tmp108_ = self->priv->_notification_icon;
			if (g_strcmp0 (_tmp108_, "") == 0) {
				GDesktopAppInfo* _tmp109_;
				_tmp109_ = self->priv->_app_info;
				_tmp107_ = _tmp109_ != NULL;
			} else {
				_tmp107_ = FALSE;
			}
			if (_tmp107_) {
				GtkImage* _tmp110_;
				GtkImage* _tmp111_;
				_tmp110_ = budgie_notification_get_appinfo_image (self, GTK_ICON_SIZE_DIALOG, "mail-unread-symbolic");
				_tmp111_ = _tmp110_;
				budgie_notification_set_image (self, _tmp111_);
				_g_object_unref0 (_tmp111_);
				image_found = TRUE;
			} else {
				const gchar* _tmp112_;
				_tmp112_ = self->priv->_notification_icon;
				if (string_contains (_tmp112_, "/")) {
					GFile* file = NULL;
					const gchar* _tmp113_;
					GFile* _tmp114_;
					GFile* _tmp115_;
					_tmp113_ = self->priv->_notification_icon;
					_tmp114_ = g_file_new_for_uri (_tmp113_);
					file = _tmp114_;
					_tmp115_ = file;
					if (g_file_query_exists (_tmp115_, NULL)) {
						GFileIcon* icon = NULL;
						GFile* _tmp116_;
						GFileIcon* _tmp117_;
						GFileIcon* _tmp118_;
						GtkImage* _tmp119_;
						GtkImage* _tmp120_;
						_tmp116_ = file;
						_tmp117_ = (GFileIcon*) g_file_icon_new (_tmp116_);
						icon = _tmp117_;
						_tmp118_ = icon;
						_tmp119_ = (GtkImage*) gtk_image_new_from_gicon ((GIcon*) _tmp118_, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
						g_object_ref_sink (_tmp119_);
						_tmp120_ = _tmp119_;
						budgie_notification_set_image (self, _tmp120_);
						_g_object_unref0 (_tmp120_);
						image_found = TRUE;
						_g_object_unref0 (icon);
					}
					_g_object_unref0 (file);
				}
			}
		}
	}
	if (!image_found) {
		GHashTable* _tmp122_;
		gconstpointer _tmp123_;
		GVariant* _tmp124_;
		_tmp122_ = self->priv->_hints;
		_tmp123_ = g_hash_table_lookup (_tmp122_, "icon_data");
		variant = (GVariant*) _tmp123_;
		_tmp124_ = variant;
		_tmp121_ = _tmp124_ != NULL;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		GdkPixbuf* pixbuf = NULL;
		GVariant* _tmp125_;
		GdkPixbuf* _tmp126_;
		GdkPixbuf* _tmp127_;
		_tmp125_ = variant;
		_tmp126_ = budgie_notification_decode_image (self, _tmp125_);
		pixbuf = _tmp126_;
		_tmp127_ = pixbuf;
		if (_tmp127_ != NULL) {
			GdkPixbuf* _tmp128_;
			GtkImage* _tmp129_;
			GtkImage* _tmp130_;
			_tmp128_ = pixbuf;
			_tmp129_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp128_);
			g_object_ref_sink (_tmp129_);
			_tmp130_ = _tmp129_;
			budgie_notification_set_image (self, _tmp130_);
			_g_object_unref0 (_tmp130_);
			image_found = TRUE;
		}
		_g_object_unref0 (pixbuf);
	}
	if (!image_found) {
		GtkImage* _tmp131_;
		GtkImage* _tmp132_;
		_tmp131_ = (GtkImage*) gtk_image_new_from_icon_name ("mail-unread-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
		g_object_ref_sink (_tmp131_);
		_tmp132_ = _tmp131_;
		budgie_notification_set_image (self, _tmp132_);
		_g_object_unref0 (_tmp132_);
	}
	_tmp133_ = self->priv->_body;
	if (g_strcmp0 (_tmp133_, "") == 0) {
		const gchar* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		const gchar* _tmp137_;
		_tmp134_ = self->priv->_summary;
		_tmp135_ = budgie_notification_fix_markup (self, _tmp134_);
		_tmp136_ = _tmp135_;
		budgie_notification_set_body (self, _tmp136_);
		_g_free0 (_tmp136_);
		_tmp137_ = self->priv->_app_name;
		budgie_notification_set_summary (self, _tmp137_);
	} else {
		const gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		const gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		_tmp138_ = self->priv->_body;
		_tmp139_ = budgie_notification_fix_markup (self, _tmp138_);
		_tmp140_ = _tmp139_;
		budgie_notification_set_body (self, _tmp140_);
		_g_free0 (_tmp140_);
		_tmp141_ = self->priv->_summary;
		_tmp142_ = budgie_notification_fix_markup (self, _tmp141_);
		_tmp143_ = _tmp142_;
		budgie_notification_set_summary (self, _tmp143_);
		_g_free0 (_tmp143_);
	}
	return obj;
}

static void
budgie_notification_class_init (BudgieNotificationClass * klass,
                                gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	budgie_notification_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotification_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notification_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notification_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notification_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notification_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_INFO_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_ID_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_URGENCY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_URGENCY_PROPERTY] = g_param_spec_enum ("urgency", "urgency", "urgency", g_notification_priority_get_type (), G_NOTIFICATION_PRIORITY_NORMAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_ID_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_NAME_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY] = g_param_spec_string ("notification-icon", "notification-icon", "notification-icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_HINTS_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_HINTS_PROPERTY] = g_param_spec_boxed ("hints", "hints", "hints", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_ACTIONS_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_ACTIONS_PROPERTY] = g_param_spec_boxed ("actions", "actions", "actions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_BODY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_BODY_PROPERTY] = g_param_spec_string ("body", "body", "body", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_SUMMARY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY] = g_param_spec_uint ("expire-timeout", "expire-timeout", "expire-timeout", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_CATEGORY_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_CATEGORY_PROPERTY] = g_param_spec_string ("category", "category", "category", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY] = g_param_spec_object ("app-image", "app-image", "app-image", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATION_IMAGE_PROPERTY, budgie_notification_properties[BUDGIE_NOTIFICATION_IMAGE_PROPERTY] = g_param_spec_object ("image", "image", "image", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("&(?!amp;|quot;|apos;|lt;|gt;|#39;|nbsp;)", 0, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (budgie_notification_entity_regex);
		budgie_notification_entity_regex = _tmp2_;
		_tmp4_ = g_regex_new ("<(?!\\/?[biu]>)", 0, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (budgie_notification_tag_regex);
		budgie_notification_tag_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("notification.vala:100: Invalid notification regex: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
budgie_notification_instance_init (BudgieNotification * self,
                                   gpointer klass)
{
	self->priv = budgie_notification_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_urgency = G_NOTIFICATION_PRIORITY_NORMAL;
	self->priv->_app_image = NULL;
	self->priv->_image = NULL;
}

static void
budgie_notification_finalize (GObject * obj)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_app_id);
	_g_free0 (self->priv->_app_name);
	_g_free0 (self->priv->_notification_icon);
	_g_hash_table_unref0 (self->priv->_hints);
	self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_body);
	_g_free0 (self->priv->_summary);
	_g_free0 (self->priv->_category);
	_g_object_unref0 (self->priv->_app_image);
	_g_object_unref0 (self->priv->_image);
	G_OBJECT_CLASS (budgie_notification_parent_class)->finalize (obj);
}

/**
 * This is our wrapper class for a FreeDesktop notification.
 */
static GType
budgie_notification_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notification_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotification), 0, (GInstanceInitFunc) budgie_notification_instance_init, NULL };
	GType budgie_notification_type_id;
	budgie_notification_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieNotification", &g_define_type_info, 0);
	BudgieNotification_private_offset = g_type_add_instance_private (budgie_notification_type_id, sizeof (BudgieNotificationPrivate));
	return budgie_notification_type_id;
}

GType
budgie_notification_get_type (void)
{
	static volatile gsize budgie_notification_type_id__once = 0;
	if (g_once_init_enter (&budgie_notification_type_id__once)) {
		GType budgie_notification_type_id;
		budgie_notification_type_id = budgie_notification_get_type_once ();
		g_once_init_leave (&budgie_notification_type_id__once, budgie_notification_type_id);
	}
	return budgie_notification_type_id__once;
}

static void
_vala_budgie_notification_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_APP_INFO_PROPERTY:
		g_value_set_object (value, budgie_notification_get_app_info (self));
		break;
		case BUDGIE_NOTIFICATION_APP_ID_PROPERTY:
		g_value_set_string (value, budgie_notification_get_app_id (self));
		break;
		case BUDGIE_NOTIFICATION_URGENCY_PROPERTY:
		g_value_set_enum (value, budgie_notification_get_urgency (self));
		break;
		case BUDGIE_NOTIFICATION_ID_PROPERTY:
		g_value_set_uint (value, budgie_notification_get_id (self));
		break;
		case BUDGIE_NOTIFICATION_APP_NAME_PROPERTY:
		g_value_set_string (value, budgie_notification_get_app_name (self));
		break;
		case BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY:
		g_value_set_string (value, budgie_notification_get_notification_icon (self));
		break;
		case BUDGIE_NOTIFICATION_HINTS_PROPERTY:
		g_value_set_boxed (value, budgie_notification_get_hints (self));
		break;
		case BUDGIE_NOTIFICATION_ACTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, budgie_notification_get_actions (self, &length));
		}
		break;
		case BUDGIE_NOTIFICATION_BODY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_body (self));
		break;
		case BUDGIE_NOTIFICATION_SUMMARY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_summary (self));
		break;
		case BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY:
		g_value_set_uint (value, budgie_notification_get_expire_timeout (self));
		break;
		case BUDGIE_NOTIFICATION_CATEGORY_PROPERTY:
		g_value_set_string (value, budgie_notification_get_category (self));
		break;
		case BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, budgie_notification_get_timestamp (self));
		break;
		case BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY:
		g_value_set_object (value, budgie_notification_get_app_image (self));
		break;
		case BUDGIE_NOTIFICATION_IMAGE_PROPERTY:
		g_value_set_object (value, budgie_notification_get_image (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notification_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BudgieNotification * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_NOTIFICATION, BudgieNotification);
	switch (property_id) {
		case BUDGIE_NOTIFICATION_APP_INFO_PROPERTY:
		budgie_notification_set_app_info (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATION_APP_ID_PROPERTY:
		budgie_notification_set_app_id (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_URGENCY_PROPERTY:
		budgie_notification_set_urgency (self, g_value_get_enum (value));
		break;
		case BUDGIE_NOTIFICATION_ID_PROPERTY:
		budgie_notification_set_id (self, g_value_get_uint (value));
		break;
		case BUDGIE_NOTIFICATION_APP_NAME_PROPERTY:
		budgie_notification_set_app_name (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_NOTIFICATION_ICON_PROPERTY:
		budgie_notification_set_notification_icon (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_HINTS_PROPERTY:
		budgie_notification_set_hints (self, g_value_get_boxed (value));
		break;
		case BUDGIE_NOTIFICATION_ACTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			budgie_notification_set_actions (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BUDGIE_NOTIFICATION_BODY_PROPERTY:
		budgie_notification_set_body (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_SUMMARY_PROPERTY:
		budgie_notification_set_summary (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_EXPIRE_TIMEOUT_PROPERTY:
		budgie_notification_set_expire_timeout (self, g_value_get_uint (value));
		break;
		case BUDGIE_NOTIFICATION_CATEGORY_PROPERTY:
		budgie_notification_set_category (self, g_value_get_string (value));
		break;
		case BUDGIE_NOTIFICATION_TIMESTAMP_PROPERTY:
		budgie_notification_set_timestamp (self, g_value_get_int64 (value));
		break;
		case BUDGIE_NOTIFICATION_APP_IMAGE_PROPERTY:
		budgie_notification_set_app_image (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATION_IMAGE_PROPERTY:
		budgie_notification_set_image (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

