/* Device.c generated by valac 0.56.14, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())
typedef GDBusProxy BluetoothDeviceProxy;
typedef GDBusProxyClass BluetoothDeviceProxyClass;
typedef struct _BluetoothDeviceConnectReadyData BluetoothDeviceConnectReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BluetoothDeviceDisconnectReadyData BluetoothDeviceDisconnectReadyData;

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BluetoothDeviceConnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BluetoothDeviceDisconnectReadyData {
	GDBusMethodInvocation* _invocation_;
};

VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN void bluetooth_device_cancel_pairing (BluetoothDevice* self,
                                      GError** error);
VALA_EXTERN void bluetooth_device_connect (BluetoothDevice* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void bluetooth_device_connect_finish (BluetoothDevice* self,
                                      GAsyncResult* _res_,
                                      GError** error);
VALA_EXTERN void bluetooth_device_connect_profile (BluetoothDevice* self,
                                       const gchar* UUID,
                                       GError** error);
VALA_EXTERN void bluetooth_device_disconnect (BluetoothDevice* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void bluetooth_device_disconnect_finish (BluetoothDevice* self,
                                         GAsyncResult* _res_,
                                         GError** error);
VALA_EXTERN void bluetooth_device_disconnect_profile (BluetoothDevice* self,
                                          const gchar* UUID,
                                          GError** error);
VALA_EXTERN void bluetooth_device_pair (BluetoothDevice* self,
                            GError** error);
VALA_EXTERN gchar** bluetooth_device_get_UUIDs (BluetoothDevice* self,
                                    gint* result_length1);
VALA_EXTERN gboolean bluetooth_device_get_blocked (BluetoothDevice* self);
VALA_EXTERN void bluetooth_device_set_blocked (BluetoothDevice* self,
                                   gboolean value);
VALA_EXTERN gboolean bluetooth_device_get_connected (BluetoothDevice* self);
VALA_EXTERN gboolean bluetooth_device_get_legacy_pairing (BluetoothDevice* self);
VALA_EXTERN gboolean bluetooth_device_get_paired (BluetoothDevice* self);
VALA_EXTERN gboolean bluetooth_device_get_trusted (BluetoothDevice* self);
VALA_EXTERN void bluetooth_device_set_trusted (BluetoothDevice* self,
                                   gboolean value);
VALA_EXTERN gint16 bluetooth_device_get_RSSI (BluetoothDevice* self);
VALA_EXTERN char* bluetooth_device_get_adapter (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_alias (BluetoothDevice* self);
VALA_EXTERN void bluetooth_device_set_alias (BluetoothDevice* self,
                                 const gchar* value);
VALA_EXTERN gchar* bluetooth_device_get_icon (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_modalias (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_name (BluetoothDevice* self);
VALA_EXTERN guint16 bluetooth_device_get_appearance (BluetoothDevice* self);
VALA_EXTERN guint32 bluetooth_device_get_class (BluetoothDevice* self);
static GType bluetooth_device_get_type_once (void);
static void bluetooth_device_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void bluetooth_device_proxy_cancel_pairing (BluetoothDevice* self,
                                            GError** error);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void bluetooth_device_proxy_connect_async (BluetoothDevice* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void bluetooth_device_proxy_connect_finish (BluetoothDevice* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void bluetooth_device_proxy_connect_profile (BluetoothDevice* self,
                                             const gchar* UUID,
                                             GError** error);
static void bluetooth_device_proxy_disconnect_async (BluetoothDevice* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void bluetooth_device_proxy_disconnect_finish (BluetoothDevice* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void bluetooth_device_proxy_disconnect_profile (BluetoothDevice* self,
                                                const gchar* UUID,
                                                GError** error);
static void bluetooth_device_proxy_pair (BluetoothDevice* self,
                                  GError** error);
static gchar** bluetooth_device_dbus_proxy_get_UUIDs (BluetoothDevice* self,
                                               gint* result_length1);
static gboolean bluetooth_device_dbus_proxy_get_blocked (BluetoothDevice* self);
static void bluetooth_device_dbus_proxy_set_blocked (BluetoothDevice* self,
                                              gboolean value);
static gboolean bluetooth_device_dbus_proxy_get_connected (BluetoothDevice* self);
static gboolean bluetooth_device_dbus_proxy_get_legacy_pairing (BluetoothDevice* self);
static gboolean bluetooth_device_dbus_proxy_get_paired (BluetoothDevice* self);
static gboolean bluetooth_device_dbus_proxy_get_trusted (BluetoothDevice* self);
static void bluetooth_device_dbus_proxy_set_trusted (BluetoothDevice* self,
                                              gboolean value);
static gint16 bluetooth_device_dbus_proxy_get_RSSI (BluetoothDevice* self);
static char* bluetooth_device_dbus_proxy_get_adapter (BluetoothDevice* self);
static gchar* bluetooth_device_dbus_proxy_get_address (BluetoothDevice* self);
static gchar* bluetooth_device_dbus_proxy_get_alias (BluetoothDevice* self);
static void bluetooth_device_dbus_proxy_set_alias (BluetoothDevice* self,
                                            const gchar* value);
static gchar* bluetooth_device_dbus_proxy_get_icon (BluetoothDevice* self);
static gchar* bluetooth_device_dbus_proxy_get_modalias (BluetoothDevice* self);
static gchar* bluetooth_device_dbus_proxy_get_name (BluetoothDevice* self);
static guint16 bluetooth_device_dbus_proxy_get_appearance (BluetoothDevice* self);
static guint32 bluetooth_device_dbus_proxy_get_class (BluetoothDevice* self);
static void bluetooth_device_proxy_bluetooth_device_interface_init (BluetoothDeviceIface* iface);
static void _dbus_bluetooth_device_cancel_pairing (BluetoothDevice* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_device_connect (BluetoothDevice* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_device_connect_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_bluetooth_device_connect_profile (BluetoothDevice* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_device_disconnect (BluetoothDevice* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_device_disconnect_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_);
static void _dbus_bluetooth_device_disconnect_profile (BluetoothDevice* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_device_pair (BluetoothDevice* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation);
static void bluetooth_device_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* bluetooth_device_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static GVariant* _dbus_bluetooth_device_get_UUIDs (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_blocked (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_connected (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_legacy_pairing (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_paired (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_trusted (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_RSSI (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_adapter (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_address (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_alias (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_icon (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_modalias (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_name (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_appearance (BluetoothDevice* self);
static GVariant* _dbus_bluetooth_device_get_class (BluetoothDevice* self);
static gboolean bluetooth_device_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _dbus_bluetooth_device_set_blocked (BluetoothDevice* self,
                                         GVariant* _value);
static void _dbus_bluetooth_device_set_trusted (BluetoothDevice* self,
                                         GVariant* _value);
static void _dbus_bluetooth_device_set_alias (BluetoothDevice* self,
                                       GVariant* _value);
static void _bluetooth_device_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_cancel_pairing_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_cancel_pairing_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_cancel_pairing = {-1, "CancelPairing", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_cancel_pairing_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_cancel_pairing_out), NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_connect_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_connect_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_connect = {-1, "Connect", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_connect_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_connect_out), NULL};
static const GDBusArgInfo _bluetooth_device_dbus_arg_info_connect_profile_UUID = {-1, "UUID", "s", NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_connect_profile_in[] = {&_bluetooth_device_dbus_arg_info_connect_profile_UUID, NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_connect_profile_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_connect_profile = {-1, "ConnectProfile", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_connect_profile_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_connect_profile_out), NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_disconnect_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_disconnect_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_disconnect = {-1, "Disconnect", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_disconnect_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_disconnect_out), NULL};
static const GDBusArgInfo _bluetooth_device_dbus_arg_info_disconnect_profile_UUID = {-1, "UUID", "s", NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_disconnect_profile_in[] = {&_bluetooth_device_dbus_arg_info_disconnect_profile_UUID, NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_disconnect_profile_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_disconnect_profile = {-1, "DisconnectProfile", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_disconnect_profile_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_disconnect_profile_out), NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_pair_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_device_dbus_arg_info_pair_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_device_dbus_method_info_pair = {-1, "Pair", (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_pair_in), (GDBusArgInfo **) (&_bluetooth_device_dbus_arg_info_pair_out), NULL};
static const GDBusMethodInfo * const _bluetooth_device_dbus_method_info[] = {&_bluetooth_device_dbus_method_info_cancel_pairing, &_bluetooth_device_dbus_method_info_connect, &_bluetooth_device_dbus_method_info_connect_profile, &_bluetooth_device_dbus_method_info_disconnect, &_bluetooth_device_dbus_method_info_disconnect_profile, &_bluetooth_device_dbus_method_info_pair, NULL};
static const GDBusSignalInfo * const _bluetooth_device_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_UUIDs = {-1, "UUIDs", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_blocked = {-1, "Blocked", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_connected = {-1, "Connected", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_legacy_pairing = {-1, "LegacyPairing", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_paired = {-1, "Paired", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_trusted = {-1, "Trusted", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_RSSI = {-1, "RSSI", "n", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_adapter = {-1, "Adapter", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_address = {-1, "Address", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_icon = {-1, "Icon", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_modalias = {-1, "Modalias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_appearance = {-1, "Appearance", "q", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _bluetooth_device_dbus_property_info_class = {-1, "Class", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _bluetooth_device_dbus_property_info[] = {&_bluetooth_device_dbus_property_info_UUIDs, &_bluetooth_device_dbus_property_info_blocked, &_bluetooth_device_dbus_property_info_connected, &_bluetooth_device_dbus_property_info_legacy_pairing, &_bluetooth_device_dbus_property_info_paired, &_bluetooth_device_dbus_property_info_trusted, &_bluetooth_device_dbus_property_info_RSSI, &_bluetooth_device_dbus_property_info_adapter, &_bluetooth_device_dbus_property_info_address, &_bluetooth_device_dbus_property_info_alias, &_bluetooth_device_dbus_property_info_icon, &_bluetooth_device_dbus_property_info_modalias, &_bluetooth_device_dbus_property_info_name, &_bluetooth_device_dbus_property_info_appearance, &_bluetooth_device_dbus_property_info_class, NULL};
static const GDBusInterfaceInfo _bluetooth_device_dbus_interface_info = {-1, "org.bluez.Device1", (GDBusMethodInfo **) (&_bluetooth_device_dbus_method_info), (GDBusSignalInfo **) (&_bluetooth_device_dbus_signal_info), (GDBusPropertyInfo **) (&_bluetooth_device_dbus_property_info), NULL};
static const GDBusInterfaceVTable _bluetooth_device_dbus_interface_vtable = {bluetooth_device_dbus_interface_method_call, bluetooth_device_dbus_interface_get_property, bluetooth_device_dbus_interface_set_property};

void
bluetooth_device_cancel_pairing (BluetoothDevice* self,
                                 GError** error)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->cancel_pairing) {
		_iface_->cancel_pairing (self, error);
	}
}

void
bluetooth_device_connect (BluetoothDevice* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	BluetoothDeviceIface* _iface_;
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect) {
		_iface_->connect (self, _callback_, _user_data_);
	}
}

void
bluetooth_device_connect_finish (BluetoothDevice* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	BluetoothDeviceIface* _iface_;
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect_finish) {
		_iface_->connect_finish (self, _res_, error);
	}
}

void
bluetooth_device_connect_profile (BluetoothDevice* self,
                                  const gchar* UUID,
                                  GError** error)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->connect_profile) {
		_iface_->connect_profile (self, UUID, error);
	}
}

void
bluetooth_device_disconnect (BluetoothDevice* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	BluetoothDeviceIface* _iface_;
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect) {
		_iface_->disconnect (self, _callback_, _user_data_);
	}
}

void
bluetooth_device_disconnect_finish (BluetoothDevice* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	BluetoothDeviceIface* _iface_;
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect_finish) {
		_iface_->disconnect_finish (self, _res_, error);
	}
}

void
bluetooth_device_disconnect_profile (BluetoothDevice* self,
                                     const gchar* UUID,
                                     GError** error)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->disconnect_profile) {
		_iface_->disconnect_profile (self, UUID, error);
	}
}

void
bluetooth_device_pair (BluetoothDevice* self,
                       GError** error)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->pair) {
		_iface_->pair (self, error);
	}
}

gchar**
bluetooth_device_get_UUIDs (BluetoothDevice* self,
                            gint* result_length1)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_UUIDs) {
		return _iface_->get_UUIDs (self, result_length1);
	}
	return NULL;
}

gboolean
bluetooth_device_get_blocked (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_blocked) {
		return _iface_->get_blocked (self);
	}
	return FALSE;
}

void
bluetooth_device_set_blocked (BluetoothDevice* self,
                              gboolean value)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_blocked) {
		_iface_->set_blocked (self, value);
	}
}

gboolean
bluetooth_device_get_connected (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_connected) {
		return _iface_->get_connected (self);
	}
	return FALSE;
}

gboolean
bluetooth_device_get_legacy_pairing (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_legacy_pairing) {
		return _iface_->get_legacy_pairing (self);
	}
	return FALSE;
}

gboolean
bluetooth_device_get_paired (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_paired) {
		return _iface_->get_paired (self);
	}
	return FALSE;
}

gboolean
bluetooth_device_get_trusted (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_trusted) {
		return _iface_->get_trusted (self);
	}
	return FALSE;
}

void
bluetooth_device_set_trusted (BluetoothDevice* self,
                              gboolean value)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_trusted) {
		_iface_->set_trusted (self, value);
	}
}

gint16
bluetooth_device_get_RSSI (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_RSSI) {
		return _iface_->get_RSSI (self);
	}
	return -1;
}

char*
bluetooth_device_get_adapter (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_adapter) {
		return _iface_->get_adapter (self);
	}
	return NULL;
}

gchar*
bluetooth_device_get_address (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_address) {
		return _iface_->get_address (self);
	}
	return NULL;
}

gchar*
bluetooth_device_get_alias (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_alias) {
		return _iface_->get_alias (self);
	}
	return NULL;
}

void
bluetooth_device_set_alias (BluetoothDevice* self,
                            const gchar* value)
{
	BluetoothDeviceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->set_alias) {
		_iface_->set_alias (self, value);
	}
}

gchar*
bluetooth_device_get_icon (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_icon) {
		return _iface_->get_icon (self);
	}
	return NULL;
}

gchar*
bluetooth_device_get_modalias (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_modalias) {
		return _iface_->get_modalias (self);
	}
	return NULL;
}

gchar*
bluetooth_device_get_name (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_name) {
		return _iface_->get_name (self);
	}
	return NULL;
}

guint16
bluetooth_device_get_appearance (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_appearance) {
		return _iface_->get_appearance (self);
	}
	return 0U;
}

guint32
bluetooth_device_get_class (BluetoothDevice* self)
{
	BluetoothDeviceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = BLUETOOTH_DEVICE_GET_INTERFACE (self);
	if (_iface_->get_class) {
		return _iface_->get_class (self);
	}
	return 0U;
}

static void
bluetooth_device_default_init (BluetoothDeviceIface * iface,
                               gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
bluetooth_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothDeviceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_device_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType bluetooth_device_type_id;
	bluetooth_device_type_id = g_type_register_static (G_TYPE_INTERFACE, "BluetoothDevice", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (bluetooth_device_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (bluetooth_device_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) bluetooth_device_proxy_get_type);
	g_type_set_qdata (bluetooth_device_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Device1");
	g_type_set_qdata (bluetooth_device_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_bluetooth_device_dbus_interface_info));
	g_type_set_qdata (bluetooth_device_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) bluetooth_device_register_object);
	return bluetooth_device_type_id;
}

GType
bluetooth_device_get_type (void)
{
	static volatile gsize bluetooth_device_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_device_type_id__once)) {
		GType bluetooth_device_type_id;
		bluetooth_device_type_id = bluetooth_device_get_type_once ();
		g_once_init_leave (&bluetooth_device_type_id__once, bluetooth_device_type_id);
	}
	return bluetooth_device_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BluetoothDeviceProxy, bluetooth_device_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BLUETOOTH_TYPE_DEVICE, bluetooth_device_proxy_bluetooth_device_interface_init) )
static void
bluetooth_device_proxy_class_init (BluetoothDeviceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = bluetooth_device_proxy_g_signal;
}

static void
bluetooth_device_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
}

static void
bluetooth_device_proxy_init (BluetoothDeviceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_bluetooth_device_dbus_interface_info));
}

static void
bluetooth_device_proxy_cancel_pairing (BluetoothDevice* self,
                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "CancelPairing");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
bluetooth_device_proxy_connect_async (BluetoothDevice* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Connect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
bluetooth_device_proxy_connect_finish (BluetoothDevice* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_device_proxy_connect_profile (BluetoothDevice* self,
                                        const gchar* UUID,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "ConnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (UUID));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_device_proxy_disconnect_async (BluetoothDevice* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Disconnect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
bluetooth_device_proxy_disconnect_finish (BluetoothDevice* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_device_proxy_disconnect_profile (BluetoothDevice* self,
                                           const gchar* UUID,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "DisconnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (UUID));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_device_proxy_pair (BluetoothDevice* self,
                             GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Pair");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar**
bluetooth_device_dbus_proxy_get_UUIDs (BluetoothDevice* self,
                                       gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp23_;
	gint _tmp23__length;
	gint _tmp23__size;
	gint _tmp23__length1;
	GVariantIter _tmp24_;
	GVariant* _tmp25_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UUIDs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UUIDs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp23_ = g_new (gchar*, 5);
	_tmp23__length = 0;
	_tmp23__size = 4;
	_tmp23__length1 = 0;
	g_variant_iter_init (&_tmp24_, _inner_reply);
	for (; (_tmp25_ = g_variant_iter_next_value (&_tmp24_)) != NULL; _tmp23__length1++) {
		if (_tmp23__size == _tmp23__length) {
			_tmp23__size = 2 * _tmp23__size;
			_tmp23_ = g_renew (gchar*, _tmp23_, _tmp23__size + 1);
		}
		_tmp23_[_tmp23__length++] = g_variant_dup_string (_tmp25_, NULL);
		g_variant_unref (_tmp25_);
	}
	_result_length1 = _tmp23__length1;
	_tmp23_[_tmp23__length] = NULL;
	_result = _tmp23_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_device_dbus_proxy_get_blocked (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Blocked");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp26_ = FALSE;
			return _tmp26_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_device_dbus_proxy_set_blocked (BluetoothDevice* self,
                                         gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gboolean
bluetooth_device_dbus_proxy_get_connected (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Connected");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Connected"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp27_ = FALSE;
			return _tmp27_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_device_dbus_proxy_get_legacy_pairing (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LegacyPairing");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LegacyPairing"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp28_ = FALSE;
			return _tmp28_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_device_dbus_proxy_get_paired (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Paired");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Paired"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp29_ = FALSE;
			return _tmp29_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
bluetooth_device_dbus_proxy_get_trusted (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Trusted");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp30_ = FALSE;
			return _tmp30_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_device_dbus_proxy_set_trusted (BluetoothDevice* self,
                                         gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gint16
bluetooth_device_dbus_proxy_get_RSSI (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RSSI");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RSSI"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint16 _tmp31_ = 0;
			return _tmp31_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static char*
bluetooth_device_dbus_proxy_get_adapter (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Adapter");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Adapter"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_device_dbus_proxy_get_address (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Address");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Address"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_device_dbus_proxy_get_alias (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_device_dbus_proxy_set_alias (BluetoothDevice* self,
                                       const gchar* value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static gchar*
bluetooth_device_dbus_proxy_get_icon (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Icon");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Icon"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_device_dbus_proxy_get_modalias (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Modalias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Modalias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
bluetooth_device_dbus_proxy_get_name (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint16
bluetooth_device_dbus_proxy_get_appearance (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	guint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Appearance");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Appearance"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint16 _tmp32_ = 0U;
			return _tmp32_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint32
bluetooth_device_dbus_proxy_get_class (BluetoothDevice* self)
{
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Class");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Class"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp33_ = 0U;
			return _tmp33_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
bluetooth_device_proxy_bluetooth_device_interface_init (BluetoothDeviceIface* iface)
{
	iface->cancel_pairing = bluetooth_device_proxy_cancel_pairing;
	iface->connect = bluetooth_device_proxy_connect_async;
	iface->connect_finish = bluetooth_device_proxy_connect_finish;
	iface->connect_profile = bluetooth_device_proxy_connect_profile;
	iface->disconnect = bluetooth_device_proxy_disconnect_async;
	iface->disconnect_finish = bluetooth_device_proxy_disconnect_finish;
	iface->disconnect_profile = bluetooth_device_proxy_disconnect_profile;
	iface->pair = bluetooth_device_proxy_pair;
	iface->get_UUIDs = bluetooth_device_dbus_proxy_get_UUIDs;
	iface->get_blocked = bluetooth_device_dbus_proxy_get_blocked;
	iface->set_blocked = bluetooth_device_dbus_proxy_set_blocked;
	iface->get_connected = bluetooth_device_dbus_proxy_get_connected;
	iface->get_legacy_pairing = bluetooth_device_dbus_proxy_get_legacy_pairing;
	iface->get_paired = bluetooth_device_dbus_proxy_get_paired;
	iface->get_trusted = bluetooth_device_dbus_proxy_get_trusted;
	iface->set_trusted = bluetooth_device_dbus_proxy_set_trusted;
	iface->get_RSSI = bluetooth_device_dbus_proxy_get_RSSI;
	iface->get_adapter = bluetooth_device_dbus_proxy_get_adapter;
	iface->get_address = bluetooth_device_dbus_proxy_get_address;
	iface->get_alias = bluetooth_device_dbus_proxy_get_alias;
	iface->set_alias = bluetooth_device_dbus_proxy_set_alias;
	iface->get_icon = bluetooth_device_dbus_proxy_get_icon;
	iface->get_modalias = bluetooth_device_dbus_proxy_get_modalias;
	iface->get_name = bluetooth_device_dbus_proxy_get_name;
	iface->get_appearance = bluetooth_device_dbus_proxy_get_appearance;
	iface->get_class = bluetooth_device_dbus_proxy_get_class;
}

static void
_dbus_bluetooth_device_cancel_pairing (BluetoothDevice* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_device_cancel_pairing (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_bluetooth_device_connect (BluetoothDevice* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothDeviceConnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothDeviceConnectReadyData);
	_ready_data->_invocation_ = invocation;
	bluetooth_device_connect (self, (GAsyncReadyCallback) _dbus_bluetooth_device_connect_ready, _ready_data);
}

static void
_dbus_bluetooth_device_connect_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	BluetoothDeviceConnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_device_connect_finish ((BluetoothDevice*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BluetoothDeviceConnectReadyData, _ready_data);
}

static void
_dbus_bluetooth_device_connect_profile (BluetoothDevice* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* UUID = NULL;
	GVariant* _tmp34_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	UUID = g_variant_dup_string (_tmp34_, NULL);
	g_variant_unref (_tmp34_);
	bluetooth_device_connect_profile (self, UUID, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (UUID);
	;
}

static void
_dbus_bluetooth_device_disconnect (BluetoothDevice* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothDeviceDisconnectReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothDeviceDisconnectReadyData);
	_ready_data->_invocation_ = invocation;
	bluetooth_device_disconnect (self, (GAsyncReadyCallback) _dbus_bluetooth_device_disconnect_ready, _ready_data);
}

static void
_dbus_bluetooth_device_disconnect_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_)
{
	BluetoothDeviceDisconnectReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_device_disconnect_finish ((BluetoothDevice*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BluetoothDeviceDisconnectReadyData, _ready_data);
}

static void
_dbus_bluetooth_device_disconnect_profile (BluetoothDevice* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* UUID = NULL;
	GVariant* _tmp35_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp35_ = g_variant_iter_next_value (&_arguments_iter);
	UUID = g_variant_dup_string (_tmp35_, NULL);
	g_variant_unref (_tmp35_);
	bluetooth_device_disconnect_profile (self, UUID, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (UUID);
	;
}

static void
_dbus_bluetooth_device_pair (BluetoothDevice* self,
                             GVariant* _parameters_,
                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_device_pair (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
bluetooth_device_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "CancelPairing") == 0) {
		_dbus_bluetooth_device_cancel_pairing (object, parameters, invocation);
	} else if (strcmp (method_name, "Connect") == 0) {
		_dbus_bluetooth_device_connect (object, parameters, invocation);
	} else if (strcmp (method_name, "ConnectProfile") == 0) {
		_dbus_bluetooth_device_connect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Disconnect") == 0) {
		_dbus_bluetooth_device_disconnect (object, parameters, invocation);
	} else if (strcmp (method_name, "DisconnectProfile") == 0) {
		_dbus_bluetooth_device_disconnect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Pair") == 0) {
		_dbus_bluetooth_device_pair (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_bluetooth_device_get_UUIDs (BluetoothDevice* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp36_;
	GVariantBuilder _tmp37_;
	gint _tmp38_;
	result = bluetooth_device_get_UUIDs (self, &result_length1);
	_tmp36_ = result;
	g_variant_builder_init (&_tmp37_, G_VARIANT_TYPE ("as"));
	for (_tmp38_ = 0; _tmp38_ < result_length1; _tmp38_++) {
		g_variant_builder_add_value (&_tmp37_, g_variant_new_string (*_tmp36_));
		_tmp36_++;
	}
	_reply = g_variant_builder_end (&_tmp37_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_blocked (BluetoothDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_device_get_blocked (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_connected (BluetoothDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_device_get_connected (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_legacy_pairing (BluetoothDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_device_get_legacy_pairing (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_paired (BluetoothDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_device_get_paired (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_trusted (BluetoothDevice* self)
{
	gboolean result;
	GVariant* _reply;
	result = bluetooth_device_get_trusted (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_RSSI (BluetoothDevice* self)
{
	gint16 result;
	GVariant* _reply;
	result = bluetooth_device_get_RSSI (self);
	_reply = g_variant_new_int16 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_adapter (BluetoothDevice* self)
{
	char* result;
	GVariant* _reply;
	result = bluetooth_device_get_adapter (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_address (BluetoothDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_device_get_address (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_alias (BluetoothDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_device_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_icon (BluetoothDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_device_get_icon (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_modalias (BluetoothDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_device_get_modalias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_name (BluetoothDevice* self)
{
	gchar* result;
	GVariant* _reply;
	result = bluetooth_device_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_appearance (BluetoothDevice* self)
{
	guint16 result;
	GVariant* _reply;
	result = bluetooth_device_get_appearance (self);
	_reply = g_variant_new_uint16 (result);
	return _reply;
}

static GVariant*
_dbus_bluetooth_device_get_class (BluetoothDevice* self)
{
	guint32 result;
	GVariant* _reply;
	result = bluetooth_device_get_class (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
bluetooth_device_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "UUIDs") == 0) {
		return _dbus_bluetooth_device_get_UUIDs (object);
	} else if (strcmp (property_name, "Blocked") == 0) {
		return _dbus_bluetooth_device_get_blocked (object);
	} else if (strcmp (property_name, "Connected") == 0) {
		return _dbus_bluetooth_device_get_connected (object);
	} else if (strcmp (property_name, "LegacyPairing") == 0) {
		return _dbus_bluetooth_device_get_legacy_pairing (object);
	} else if (strcmp (property_name, "Paired") == 0) {
		return _dbus_bluetooth_device_get_paired (object);
	} else if (strcmp (property_name, "Trusted") == 0) {
		return _dbus_bluetooth_device_get_trusted (object);
	} else if (strcmp (property_name, "RSSI") == 0) {
		return _dbus_bluetooth_device_get_RSSI (object);
	} else if (strcmp (property_name, "Adapter") == 0) {
		return _dbus_bluetooth_device_get_adapter (object);
	} else if (strcmp (property_name, "Address") == 0) {
		return _dbus_bluetooth_device_get_address (object);
	} else if (strcmp (property_name, "Alias") == 0) {
		return _dbus_bluetooth_device_get_alias (object);
	} else if (strcmp (property_name, "Icon") == 0) {
		return _dbus_bluetooth_device_get_icon (object);
	} else if (strcmp (property_name, "Modalias") == 0) {
		return _dbus_bluetooth_device_get_modalias (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_bluetooth_device_get_name (object);
	} else if (strcmp (property_name, "Appearance") == 0) {
		return _dbus_bluetooth_device_get_appearance (object);
	} else if (strcmp (property_name, "Class") == 0) {
		return _dbus_bluetooth_device_get_class (object);
	}
	return NULL;
}

static void
_dbus_bluetooth_device_set_blocked (BluetoothDevice* self,
                                    GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	bluetooth_device_set_blocked (self, value);
}

static void
_dbus_bluetooth_device_set_trusted (BluetoothDevice* self,
                                    GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	bluetooth_device_set_trusted (self, value);
}

static void
_dbus_bluetooth_device_set_alias (BluetoothDevice* self,
                                  GVariant* _value)
{
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	bluetooth_device_set_alias (self, value);
	_g_free0 (value);
}

static gboolean
bluetooth_device_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Blocked") == 0) {
		_dbus_bluetooth_device_set_blocked (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Trusted") == 0) {
		_dbus_bluetooth_device_set_trusted (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Alias") == 0) {
		_dbus_bluetooth_device_set_alias (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
bluetooth_device_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_bluetooth_device_dbus_interface_info), &_bluetooth_device_dbus_interface_vtable, data, _bluetooth_device_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_bluetooth_device_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

