/* ScanDialog.c generated by valac 0.56.14, the Vala compiler
 * generated from ScanDialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCAN_DIALOG (scan_dialog_get_type ())
#define SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DIALOG, ScanDialog))
#define SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DIALOG, ScanDialogClass))
#define IS_SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DIALOG))
#define IS_SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DIALOG))
#define SCAN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DIALOG, ScanDialogClass))

typedef struct _ScanDialog ScanDialog;
typedef struct _ScanDialogClass ScanDialogClass;
typedef struct _ScanDialogPrivate ScanDialogPrivate;

#define BLUETOOTH_TYPE_OBJECT_MANAGER (bluetooth_object_manager_get_type ())
#define BLUETOOTH_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager))
#define BLUETOOTH_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))
#define BLUETOOTH_IS_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_IS_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_OBJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))

typedef struct _BluetoothObjectManager BluetoothObjectManager;
typedef struct _BluetoothObjectManagerClass BluetoothObjectManagerClass;
enum  {
	SCAN_DIALOG_0_PROPERTY,
	SCAN_DIALOG_MANAGER_PROPERTY,
	SCAN_DIALOG_NUM_PROPERTIES
};
static GParamSpec* scan_dialog_properties[SCAN_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())

#define TYPE_DEVICE_ROW (device_row_get_type ())
#define DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_ROW, DeviceRow))
#define DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_ROW, DeviceRowClass))
#define IS_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_ROW))
#define IS_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_ROW))
#define DEVICE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_ROW, DeviceRowClass))

typedef struct _DeviceRow DeviceRow;
typedef struct _DeviceRowClass DeviceRowClass;

#define BLUETOOTH_TYPE_ADAPTER (bluetooth_adapter_get_type ())
#define BLUETOOTH_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter))
#define BLUETOOTH_IS_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_ADAPTER))
#define BLUETOOTH_ADAPTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapterIface))

typedef struct _BluetoothAdapter BluetoothAdapter;
typedef struct _BluetoothAdapterIface BluetoothAdapterIface;

#define BLUETOOTH_TYPE_ADAPTER_PROXY (bluetooth_adapter_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	SCAN_DIALOG_SEND_FILE_SIGNAL,
	SCAN_DIALOG_NUM_SIGNALS
};
static guint scan_dialog_signals[SCAN_DIALOG_NUM_SIGNALS] = {0};

struct _ScanDialog {
	GtkDialog parent_instance;
	ScanDialogPrivate * priv;
};

struct _ScanDialogClass {
	GtkDialogClass parent_class;
};

struct _ScanDialogPrivate {
	BluetoothObjectManager* _manager;
	GtkRevealer* status_revealer;
	GtkSpinner* spinner;
	GtkListBox* devices_box;
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BluetoothAdapterIface {
	GTypeInterface parent_iface;
	void (*remove_device) (BluetoothAdapter* self, const char* device, GError** error);
	void (*set_discovery_filter) (BluetoothAdapter* self, GHashTable* properties, GError** error);
	void (*start_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	void (*stop_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_UUIDs) (BluetoothAdapter* self, gint* result_length1);
	gboolean (*get_discoverable) (BluetoothAdapter* self);
	void (*set_discoverable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_discovering) (BluetoothAdapter* self);
	gboolean (*get_pairable) (BluetoothAdapter* self);
	void (*set_pairable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_powered) (BluetoothAdapter* self);
	void (*set_powered) (BluetoothAdapter* self, gboolean value);
	gchar* (*get_address) (BluetoothAdapter* self);
	gchar* (*get_alias) (BluetoothAdapter* self);
	void (*set_alias) (BluetoothAdapter* self, const gchar* value);
	gchar* (*get_modalias) (BluetoothAdapter* self);
	gchar* (*get_name) (BluetoothAdapter* self);
	guint (*get_class) (BluetoothAdapter* self);
	guint (*get_discoverable_timeout) (BluetoothAdapter* self);
	guint (*get_pairable_timeout) (BluetoothAdapter* self);
};

static gint ScanDialog_private_offset;
static gpointer scan_dialog_parent_class = NULL;

VALA_EXTERN GType scan_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDialog, g_object_unref)
VALA_EXTERN GType bluetooth_object_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObjectManager, g_object_unref)
VALA_EXTERN ScanDialog* scan_dialog_new (GtkApplication* application,
                             BluetoothObjectManager* manager);
VALA_EXTERN ScanDialog* scan_dialog_construct (GType object_type,
                                   GtkApplication* application,
                                   BluetoothObjectManager* manager);
static void scan_dialog_real_show (GtkWidget* base);
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN BluetoothObjectManager* scan_dialog_get_manager (ScanDialog* self);
VALA_EXTERN GeeCollection* bluetooth_object_manager_get_devices (BluetoothObjectManager* self);
static void scan_dialog_add_device (ScanDialog* self,
                             BluetoothDevice* device);
VALA_EXTERN void bluetooth_object_manager_start_discovery (BluetoothObjectManager* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void bluetooth_object_manager_start_discovery_finish (BluetoothObjectManager* self,
                                                      GAsyncResult* _res_);
static void scan_dialog_update_status (ScanDialog* self);
VALA_EXTERN gboolean bluetooth_object_manager_check_discovering (BluetoothObjectManager* self);
VALA_EXTERN GType device_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeviceRow, g_object_unref)
VALA_EXTERN BluetoothDevice* device_row_get_device (DeviceRow* self);
VALA_EXTERN GType bluetooth_adapter_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_adapter_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType bluetooth_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothAdapter, g_object_unref)
VALA_EXTERN BluetoothAdapter* bluetooth_object_manager_get_adapter_from_path (BluetoothObjectManager* self,
                                                                  const gchar* path);
VALA_EXTERN char* bluetooth_device_get_adapter (BluetoothDevice* self);
VALA_EXTERN DeviceRow* device_row_new (BluetoothDevice* device,
                           BluetoothAdapter* adapter);
VALA_EXTERN DeviceRow* device_row_construct (GType object_type,
                                 BluetoothDevice* device,
                                 BluetoothAdapter* adapter);
static void __lambda27_ (ScanDialog* self,
                  BluetoothDevice* device);
VALA_EXTERN void bluetooth_object_manager_stop_discovery (BluetoothObjectManager* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN void bluetooth_object_manager_stop_discovery_finish (BluetoothObjectManager* self,
                                                     GAsyncResult* _res_);
static void ___lambda27__device_row_send_clicked (DeviceRow* _sender,
                                           BluetoothDevice* device,
                                           gpointer self);
static void __lambda28_ (ScanDialog* self,
                  GVariant* changed,
                  gchar** invalid);
static void scan_dialog_invalidate_filters (ScanDialog* self);
static void ___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void scan_dialog_device_removed (ScanDialog* self,
                                 BluetoothDevice* device);
static gint scan_dialog_compare_rows (DeviceRow* row1,
                               DeviceRow* row2,
                               ScanDialog* self);
VALA_EXTERN gboolean bluetooth_device_get_paired (BluetoothDevice* self);
VALA_EXTERN gboolean bluetooth_device_get_connected (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_name (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
static void scan_dialog_title_rows (DeviceRow* row1,
                             DeviceRow* row2,
                             ScanDialog* self);
static gboolean scan_dialog_filter_row (DeviceRow* row,
                                 ScanDialog* self);
static void scan_dialog_set_manager (ScanDialog* self,
                              BluetoothObjectManager* value);
static GObject * scan_dialog_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _scan_dialog___lambda29_ (ScanDialog* self,
                               gint response_id);
static void __scan_dialog___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                                    gint response_id,
                                                    gpointer self);
static void _scan_dialog_add_device_bluetooth_object_manager_device_added (BluetoothObjectManager* _sender,
                                                                    BluetoothDevice* device,
                                                                    gpointer self);
static void _scan_dialog_device_removed_bluetooth_object_manager_device_removed (BluetoothObjectManager* _sender,
                                                                          BluetoothDevice* device,
                                                                          gpointer self);
static void _scan_dialog_update_status_bluetooth_object_manager_status_discovering (BluetoothObjectManager* _sender,
                                                                             gpointer self);
static void scan_dialog_finalize (GObject * obj);
static GType scan_dialog_get_type_once (void);
static void _vala_scan_dialog_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_scan_dialog_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static inline gpointer
scan_dialog_get_instance_private (ScanDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScanDialog_private_offset);
}

ScanDialog*
scan_dialog_construct (GType object_type,
                       GtkApplication* application,
                       BluetoothObjectManager* manager)
{
	ScanDialog * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	self = (ScanDialog*) g_object_new (object_type, "application", application, "manager", manager, "resizable", FALSE, NULL);
	return self;
}

ScanDialog*
scan_dialog_new (GtkApplication* application,
                 BluetoothObjectManager* manager)
{
	return scan_dialog_construct (TYPE_SCAN_DIALOG, application, manager);
}

static void
scan_dialog_real_show (GtkWidget* base)
{
	ScanDialog * self;
	GeeCollection* devices = NULL;
	BluetoothObjectManager* _tmp0_;
	GeeCollection* _tmp1_;
	BluetoothObjectManager* _tmp8_;
	self = (ScanDialog*) base;
	GTK_WIDGET_CLASS (scan_dialog_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	_tmp0_ = self->priv->_manager;
	_tmp1_ = bluetooth_object_manager_get_devices (_tmp0_);
	devices = _tmp1_;
	{
		GeeIterator* _device_it = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = devices;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_device_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			BluetoothDevice* device = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			BluetoothDevice* _tmp7_;
			_tmp4_ = _device_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _device_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			device = (BluetoothDevice*) _tmp6_;
			_tmp7_ = device;
			scan_dialog_add_device (self, _tmp7_);
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	_tmp8_ = self->priv->_manager;
	bluetooth_object_manager_start_discovery (_tmp8_, NULL, NULL);
	scan_dialog_update_status (self);
	_g_object_unref0 (devices);
}

static void
scan_dialog_update_status (ScanDialog* self)
{
	BluetoothObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_manager;
	if (bluetooth_object_manager_check_discovering (_tmp0_)) {
		GtkSpinner* _tmp1_;
		GtkRevealer* _tmp2_;
		_tmp1_ = self->priv->spinner;
		gtk_spinner_start (_tmp1_);
		_tmp2_ = self->priv->status_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, TRUE);
	} else {
		GtkSpinner* _tmp3_;
		GtkRevealer* _tmp4_;
		_tmp3_ = self->priv->spinner;
		gtk_spinner_stop (_tmp3_);
		_tmp4_ = self->priv->status_revealer;
		gtk_revealer_set_reveal_child (_tmp4_, FALSE);
	}
}

static void
__lambda27_ (ScanDialog* self,
             BluetoothDevice* device)
{
	BluetoothObjectManager* _tmp0_;
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->_manager;
	bluetooth_object_manager_stop_discovery (_tmp0_, NULL, NULL);
	g_signal_emit (self, scan_dialog_signals[SCAN_DIALOG_SEND_FILE_SIGNAL], 0, device);
}

static void
___lambda27__device_row_send_clicked (DeviceRow* _sender,
                                      BluetoothDevice* device,
                                      gpointer self)
{
	__lambda27_ ((ScanDialog*) self, device);
}

static void
__lambda28_ (ScanDialog* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* paired = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* connected = NULL;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Paired", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	paired = _tmp3_;
	_tmp4_ = paired;
	if (_tmp4_ != NULL) {
		scan_dialog_invalidate_filters (self);
	}
	_tmp5_ = g_variant_type_new ("b");
	_tmp6_ = _tmp5_;
	_tmp7_ = g_variant_lookup_value (changed, "Connected", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_variant_type_free0 (_tmp6_);
	connected = _tmp8_;
	_tmp9_ = connected;
	if (_tmp9_ != NULL) {
		scan_dialog_invalidate_filters (self);
	}
	_g_variant_unref0 (connected);
	_g_variant_unref0 (paired);
}

static void
___lambda28__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	__lambda28_ ((ScanDialog*) self, changed_properties, invalidated_properties);
}

static void
scan_dialog_add_device (ScanDialog* self,
                        BluetoothDevice* device)
{
	gboolean exists = FALSE;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	DeviceRow* row = NULL;
	BluetoothObjectManager* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	BluetoothAdapter* _tmp9_;
	BluetoothAdapter* _tmp10_;
	DeviceRow* _tmp11_;
	DeviceRow* _tmp12_;
	GtkListBox* _tmp13_;
	DeviceRow* _tmp14_;
	GtkListBox* _tmp15_;
	GtkListBoxRow* _tmp16_;
	DeviceRow* _tmp21_;
	DeviceRow* _tmp22_;
	BluetoothDevice* _tmp23_;
	BluetoothDevice* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	exists = FALSE;
	_tmp0_ = self->priv->devices_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GtkWidget* _tmp2_;
				BluetoothDevice* _tmp3_;
				BluetoothDevice* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DEVICE_ROW, DeviceRow));
				_tmp4_ = _tmp3_;
				if (_tmp4_ == device) {
					exists = TRUE;
					break;
				}
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	if (exists) {
		return;
	}
	_tmp5_ = self->priv->_manager;
	_tmp6_ = bluetooth_device_get_adapter (device);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = bluetooth_object_manager_get_adapter_from_path (_tmp5_, (const gchar*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = device_row_new (device, _tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	row = _tmp12_;
	_tmp13_ = self->priv->devices_box;
	_tmp14_ = row;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->devices_box;
	_tmp16_ = gtk_list_box_get_selected_row (_tmp15_);
	if (_tmp16_ == NULL) {
		GtkListBox* _tmp17_;
		DeviceRow* _tmp18_;
		GtkListBox* _tmp19_;
		DeviceRow* _tmp20_;
		_tmp17_ = self->priv->devices_box;
		_tmp18_ = row;
		gtk_list_box_select_row (_tmp17_, (GtkListBoxRow*) _tmp18_);
		_tmp19_ = self->priv->devices_box;
		_tmp20_ = row;
		g_signal_emit_by_name (_tmp19_, "row-activated", (GtkListBoxRow*) _tmp20_);
	}
	_tmp21_ = row;
	g_signal_connect_object (_tmp21_, "send-clicked", (GCallback) ___lambda27__device_row_send_clicked, self, 0);
	_tmp22_ = row;
	_tmp23_ = device_row_get_device (_tmp22_);
	_tmp24_ = _tmp23_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ___lambda28__g_dbus_proxy_g_properties_changed, self, 0);
	scan_dialog_invalidate_filters (self);
	_g_object_unref0 (row);
}

static void
scan_dialog_device_removed (ScanDialog* self,
                            BluetoothDevice* device)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = self->priv->devices_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp1_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GtkWidget* _tmp2_;
				BluetoothDevice* _tmp3_;
				BluetoothDevice* _tmp4_;
				_tmp2_ = row;
				_tmp3_ = device_row_get_device (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DEVICE_ROW, DeviceRow));
				_tmp4_ = _tmp3_;
				if (_tmp4_ == device) {
					GtkListBox* _tmp5_;
					GtkWidget* _tmp6_;
					_tmp5_ = self->priv->devices_box;
					_tmp6_ = row;
					gtk_container_remove ((GtkContainer*) _tmp5_, _tmp6_);
					break;
				}
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	scan_dialog_invalidate_filters (self);
}

static void
scan_dialog_invalidate_filters (ScanDialog* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->devices_box;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp1_ = self->priv->devices_box;
	gtk_list_box_invalidate_headers (_tmp1_);
	_tmp2_ = self->priv->devices_box;
	gtk_list_box_invalidate_sort (_tmp2_);
}

static gint
scan_dialog_compare_rows (DeviceRow* row1,
                          DeviceRow* row2,
                          ScanDialog* self)
{
	BluetoothDevice* device1 = NULL;
	BluetoothDevice* _tmp0_;
	BluetoothDevice* _tmp1_;
	BluetoothDevice* device2 = NULL;
	BluetoothDevice* _tmp2_;
	BluetoothDevice* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BluetoothDevice* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp11_ = FALSE;
	BluetoothDevice* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp18_ = FALSE;
	BluetoothDevice* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp25_ = FALSE;
	BluetoothDevice* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp32_ = FALSE;
	BluetoothDevice* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp42_ = FALSE;
	BluetoothDevice* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gboolean _tmp47_;
	gchar* _tmp52_ = NULL;
	BluetoothDevice* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* name1 = NULL;
	gchar* _tmp59_;
	gchar* _tmp60_ = NULL;
	BluetoothDevice* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* name2 = NULL;
	gchar* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = device_row_get_device (row1);
	_tmp1_ = _tmp0_;
	device1 = _tmp1_;
	_tmp2_ = device_row_get_device (row2);
	_tmp3_ = _tmp2_;
	device2 = _tmp3_;
	_tmp5_ = device1;
	_tmp6_ = bluetooth_device_get_paired (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		BluetoothDevice* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = device2;
		_tmp9_ = bluetooth_device_get_paired (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = !_tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = -1;
		return result;
	}
	_tmp12_ = device1;
	_tmp13_ = bluetooth_device_get_paired (_tmp12_);
	_tmp14_ = _tmp13_;
	if (!_tmp14_) {
		BluetoothDevice* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = device2;
		_tmp16_ = bluetooth_device_get_paired (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = _tmp17_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = 1;
		return result;
	}
	_tmp19_ = device1;
	_tmp20_ = bluetooth_device_get_connected (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		BluetoothDevice* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp22_ = device2;
		_tmp23_ = bluetooth_device_get_connected (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp18_ = !_tmp24_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		result = -1;
		return result;
	}
	_tmp26_ = device1;
	_tmp27_ = bluetooth_device_get_connected (_tmp26_);
	_tmp28_ = _tmp27_;
	if (!_tmp28_) {
		BluetoothDevice* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp29_ = device2;
		_tmp30_ = bluetooth_device_get_connected (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp25_ = _tmp31_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		result = 1;
		return result;
	}
	_tmp33_ = device1;
	_tmp34_ = bluetooth_device_get_name (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_ != NULL;
	_g_free0 (_tmp36_);
	if (_tmp37_) {
		BluetoothDevice* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		_tmp38_ = device2;
		_tmp39_ = bluetooth_device_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		_tmp32_ = _tmp41_ == NULL;
		_g_free0 (_tmp41_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		result = -1;
		return result;
	}
	_tmp43_ = device1;
	_tmp44_ = bluetooth_device_get_name (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp47_ = _tmp46_ == NULL;
	_g_free0 (_tmp46_);
	if (_tmp47_) {
		BluetoothDevice* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		_tmp48_ = device2;
		_tmp49_ = bluetooth_device_get_name (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_;
		_tmp42_ = _tmp51_ != NULL;
		_g_free0 (_tmp51_);
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		result = 1;
		return result;
	}
	_tmp53_ = device1;
	_tmp54_ = bluetooth_device_get_name (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp52_ = _tmp55_;
	if (_tmp52_ == NULL) {
		BluetoothDevice* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp56_ = device1;
		_tmp57_ = bluetooth_device_get_address (_tmp56_);
		_tmp58_ = _tmp57_;
		_g_free0 (_tmp52_);
		_tmp52_ = _tmp58_;
	}
	_tmp59_ = _tmp52_;
	_tmp52_ = NULL;
	name1 = _tmp59_;
	_tmp61_ = device2;
	_tmp62_ = bluetooth_device_get_name (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp60_ = _tmp63_;
	if (_tmp60_ == NULL) {
		BluetoothDevice* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp64_ = device2;
		_tmp65_ = bluetooth_device_get_address (_tmp64_);
		_tmp66_ = _tmp65_;
		_g_free0 (_tmp60_);
		_tmp60_ = _tmp66_;
	}
	_tmp67_ = _tmp60_;
	_tmp60_ = NULL;
	name2 = _tmp67_;
	_tmp68_ = name1;
	_tmp69_ = name2;
	result = g_utf8_collate (_tmp68_, _tmp69_);
	_g_free0 (name2);
	_g_free0 (_tmp60_);
	_g_free0 (name1);
	_g_free0 (_tmp52_);
	return result;
}

static void
scan_dialog_title_rows (DeviceRow* row1,
                        DeviceRow* row2,
                        ScanDialog* self)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (row1 != NULL);
	if (row2 == NULL) {
		GtkLabel* label = NULL;
		GtkLabel* _tmp0_ = NULL;
		GtkLabel* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Available Devices"));
		g_object_set ((GtkWidget*) _tmp0_, "margin", 3, NULL);
		gtk_label_set_xalign (_tmp0_, (gfloat) 0);
		g_object_ref_sink (_tmp0_);
		label = _tmp0_;
		_tmp1_ = label;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_TITLE);
		_tmp3_ = label;
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, (GtkWidget*) _tmp3_);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header ((GtkListBoxRow*) row1, NULL);
	}
}

static gboolean
scan_dialog_filter_row (DeviceRow* row,
                        ScanDialog* self)
{
	BluetoothDevice* device = NULL;
	BluetoothDevice* _tmp0_;
	BluetoothDevice* _tmp1_;
	gboolean _tmp2_ = FALSE;
	BluetoothDevice* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = device_row_get_device (row);
	_tmp1_ = _tmp0_;
	device = _tmp1_;
	_tmp3_ = device;
	_tmp4_ = bluetooth_device_get_paired (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		BluetoothDevice* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = device;
		_tmp7_ = bluetooth_device_get_connected (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

BluetoothObjectManager*
scan_dialog_get_manager (ScanDialog* self)
{
	BluetoothObjectManager* result;
	BluetoothObjectManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manager;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scan_dialog_set_manager (ScanDialog* self,
                         BluetoothObjectManager* value)
{
	BluetoothObjectManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = scan_dialog_get_manager (self);
	if (old_value != value) {
		BluetoothObjectManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manager);
		self->priv->_manager = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scan_dialog_properties[SCAN_DIALOG_MANAGER_PROPERTY]);
	}
}

static void
_scan_dialog___lambda29_ (ScanDialog* self,
                          gint response_id)
{
	BluetoothObjectManager* _tmp0_;
	_tmp0_ = self->priv->_manager;
	bluetooth_object_manager_stop_discovery (_tmp0_, NULL, NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__scan_dialog___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                               gint response_id,
                                               gpointer self)
{
	_scan_dialog___lambda29_ ((ScanDialog*) self, response_id);
}

static void
_scan_dialog_add_device_bluetooth_object_manager_device_added (BluetoothObjectManager* _sender,
                                                               BluetoothDevice* device,
                                                               gpointer self)
{
	scan_dialog_add_device ((ScanDialog*) self, device);
}

static void
_scan_dialog_device_removed_bluetooth_object_manager_device_removed (BluetoothObjectManager* _sender,
                                                                     BluetoothDevice* device,
                                                                     gpointer self)
{
	scan_dialog_device_removed ((ScanDialog*) self, device);
}

static void
_scan_dialog_update_status_bluetooth_object_manager_status_discovering (BluetoothObjectManager* _sender,
                                                                        gpointer self)
{
	scan_dialog_update_status ((ScanDialog*) self);
}

static GObject *
scan_dialog_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScanDialog * self;
	GtkImage* icon_image = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* info_label = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkRevealer* _tmp2_ = NULL;
	GtkSpinner* _tmp3_ = NULL;
	GtkLabel* status_label = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkGrid* status_grid = NULL;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkGrid* _tmp8_;
	GtkLabel* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkGrid* _tmp11_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkLabel* placeholder_title = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkLabel* placeholder_text = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkBox* _tmp19_;
	GtkLabel* _tmp20_;
	GtkBox* _tmp21_;
	GtkLabel* _tmp22_;
	GtkBox* _tmp23_;
	GtkListBox* _tmp24_ = NULL;
	GtkListBox* _tmp25_;
	GtkListBox* _tmp26_;
	GtkListBox* _tmp27_;
	GtkListBox* _tmp28_;
	GtkBox* _tmp29_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp30_ = NULL;
	GtkScrolledWindow* _tmp31_;
	GtkListBox* _tmp32_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp33_ = NULL;
	GtkGrid* _tmp34_;
	GtkImage* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkGrid* _tmp38_;
	GtkRevealer* _tmp39_;
	GtkGrid* devices_grid = NULL;
	GtkGrid* _tmp40_ = NULL;
	GtkGrid* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkBox* _tmp43_;
	GtkGrid* _tmp44_;
	GtkBox* _tmp45_;
	GtkGrid* _tmp46_;
	BluetoothObjectManager* _tmp47_;
	BluetoothObjectManager* _tmp48_;
	BluetoothObjectManager* _tmp49_;
	parent_class = G_OBJECT_CLASS (scan_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DIALOG, ScanDialog);
	gtk_window_set_title ((GtkWindow*) self, _ ("Bluetooth File Transfer"));
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("bluetooth-active", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp0_);
	icon_image = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Select a Bluetooth device to send files to"));
	gtk_label_set_max_width_chars (_tmp1_, 45);
	gtk_label_set_use_markup (_tmp1_, TRUE);
	g_object_set (_tmp1_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	info_label = _tmp1_;
	_tmp2_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp2_, FALSE);
	gtk_revealer_set_transition_type (_tmp2_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->status_revealer);
	self->priv->status_revealer = _tmp2_;
	_tmp3_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_set ((GtkWidget*) _tmp3_, "margin", 4, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Discovering…"));
	gtk_label_set_max_width_chars (_tmp4_, 45);
	g_object_set (_tmp4_, "wrap", TRUE, NULL);
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	g_object_ref_sink (_tmp4_);
	status_label = _tmp4_;
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	status_grid = _tmp5_;
	_tmp6_ = status_grid;
	_tmp7_ = self->priv->spinner;
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 0, 0, 1, 1);
	_tmp8_ = status_grid;
	_tmp9_ = status_label;
	gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp9_, 1, 0, 1, 1);
	_tmp10_ = self->priv->status_revealer;
	_tmp11_ = status_grid;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 18);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 125);
	g_object_ref_sink (_tmp12_);
	placeholder = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_ ("<b>No devices found</b>"));
	gtk_label_set_use_markup (_tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	placeholder_title = _tmp13_;
	_tmp14_ = placeholder_title;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Ensure that your devices are visable and ready for pairing"));
	g_object_ref_sink (_tmp16_);
	placeholder_text = _tmp16_;
	_tmp17_ = placeholder_text;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
	gtk_style_context_add_class (_tmp18_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp19_ = placeholder;
	_tmp20_ = placeholder_title;
	gtk_box_pack_start (_tmp19_, (GtkWidget*) _tmp20_, FALSE, TRUE, (guint) 0);
	_tmp21_ = placeholder;
	_tmp22_ = placeholder_text;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, FALSE, TRUE, (guint) 0);
	_tmp23_ = placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	_tmp24_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp24_, TRUE);
	gtk_list_box_set_selection_mode (_tmp24_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->devices_box);
	self->priv->devices_box = _tmp24_;
	_tmp25_ = self->priv->devices_box;
	gtk_list_box_set_header_func (_tmp25_, (GtkListBoxUpdateHeaderFunc) scan_dialog_title_rows, g_object_ref (self), g_object_unref);
	_tmp26_ = self->priv->devices_box;
	gtk_list_box_set_sort_func (_tmp26_, (GtkListBoxSortFunc) scan_dialog_compare_rows, g_object_ref (self), g_object_unref);
	_tmp27_ = self->priv->devices_box;
	gtk_list_box_set_filter_func (_tmp27_, (GtkListBoxFilterFunc) scan_dialog_filter_row, g_object_ref (self), g_object_unref);
	_tmp28_ = self->priv->devices_box;
	_tmp29_ = placeholder;
	gtk_list_box_set_placeholder (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkWidget*) _tmp30_, "expand", TRUE, NULL);
	g_object_ref_sink (_tmp30_);
	scrolled_window = _tmp30_;
	_tmp31_ = scrolled_window;
	_tmp32_ = self->priv->devices_box;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp33_, 10);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp33_, 10);
	g_object_ref_sink (_tmp33_);
	grid = _tmp33_;
	_tmp34_ = grid;
	_tmp35_ = icon_image;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 0, 1, 2);
	_tmp36_ = grid;
	_tmp37_ = info_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 0, 1, 1);
	_tmp38_ = grid;
	_tmp39_ = self->priv->status_revealer;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 1, 1, 1, 1);
	_tmp40_ = (GtkGrid*) gtk_grid_new ();
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp40_, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_valign ((GtkWidget*) _tmp40_, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_left ((GtkWidget*) _tmp40_, 10);
	gtk_widget_set_margin_right ((GtkWidget*) _tmp40_, 10);
	g_object_set ((GtkWidget*) _tmp40_, "width-request", 350, NULL);
	g_object_set ((GtkWidget*) _tmp40_, "height-request", 350, NULL);
	g_object_ref_sink (_tmp40_);
	devices_grid = _tmp40_;
	_tmp41_ = devices_grid;
	_tmp42_ = scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp44_ = grid;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp46_ = devices_grid;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __scan_dialog___lambda29__gtk_dialog_response, self, 0);
	_tmp47_ = self->priv->_manager;
	g_signal_connect_object (_tmp47_, "device-added", (GCallback) _scan_dialog_add_device_bluetooth_object_manager_device_added, self, 0);
	_tmp48_ = self->priv->_manager;
	g_signal_connect_object (_tmp48_, "device-removed", (GCallback) _scan_dialog_device_removed_bluetooth_object_manager_device_removed, self, 0);
	_tmp49_ = self->priv->_manager;
	g_signal_connect_object (_tmp49_, "status-discovering", (GCallback) _scan_dialog_update_status_bluetooth_object_manager_status_discovering, self, 0);
	_g_object_unref0 (devices_grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholder_text);
	_g_object_unref0 (placeholder_title);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (status_grid);
	_g_object_unref0 (status_label);
	_g_object_unref0 (info_label);
	_g_object_unref0 (icon_image);
	return obj;
}

static void
scan_dialog_class_init (ScanDialogClass * klass,
                        gpointer klass_data)
{
	scan_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScanDialog_private_offset);
	((GtkWidgetClass *) klass)->show = (void (*) (GtkWidget*)) scan_dialog_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_scan_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scan_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = scan_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = scan_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCAN_DIALOG_MANAGER_PROPERTY, scan_dialog_properties[SCAN_DIALOG_MANAGER_PROPERTY] = g_param_spec_object ("manager", "manager", "manager", BLUETOOTH_TYPE_OBJECT_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	scan_dialog_signals[SCAN_DIALOG_SEND_FILE_SIGNAL] = g_signal_new ("send-file", TYPE_SCAN_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_TYPE_DEVICE);
}

static void
scan_dialog_instance_init (ScanDialog * self,
                           gpointer klass)
{
	self->priv = scan_dialog_get_instance_private (self);
}

static void
scan_dialog_finalize (GObject * obj)
{
	ScanDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DIALOG, ScanDialog);
	_g_object_unref0 (self->priv->_manager);
	_g_object_unref0 (self->priv->status_revealer);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->priv->devices_box);
	G_OBJECT_CLASS (scan_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scan_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScanDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDialog), 0, (GInstanceInitFunc) scan_dialog_instance_init, NULL };
	GType scan_dialog_type_id;
	scan_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ScanDialog", &g_define_type_info, 0);
	ScanDialog_private_offset = g_type_add_instance_private (scan_dialog_type_id, sizeof (ScanDialogPrivate));
	return scan_dialog_type_id;
}

GType
scan_dialog_get_type (void)
{
	static volatile gsize scan_dialog_type_id__once = 0;
	if (g_once_init_enter (&scan_dialog_type_id__once)) {
		GType scan_dialog_type_id;
		scan_dialog_type_id = scan_dialog_get_type_once ();
		g_once_init_leave (&scan_dialog_type_id__once, scan_dialog_type_id);
	}
	return scan_dialog_type_id__once;
}

static void
_vala_scan_dialog_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	ScanDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCAN_DIALOG, ScanDialog);
	switch (property_id) {
		case SCAN_DIALOG_MANAGER_PROPERTY:
		g_value_set_object (value, scan_dialog_get_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scan_dialog_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	ScanDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCAN_DIALOG, ScanDialog);
	switch (property_id) {
		case SCAN_DIALOG_MANAGER_PROPERTY:
		scan_dialog_set_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

