/* FileSender.c generated by valac 0.56.14, the Vala compiler
 * generated from FileSender.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_DIALOG (base_dialog_get_type ())
#define BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_DIALOG, BaseDialog))
#define BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_DIALOG, BaseDialogClass))
#define IS_BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_DIALOG))
#define IS_BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_DIALOG))
#define BASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_DIALOG, BaseDialogClass))

typedef struct _BaseDialog BaseDialog;
typedef struct _BaseDialogClass BaseDialogClass;
typedef struct _BaseDialogPrivate BaseDialogPrivate;

#define BLUETOOTH_OBEX_TYPE_TRANSFER (bluetooth_obex_transfer_get_type ())
#define BLUETOOTH_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransfer))
#define BLUETOOTH_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER))
#define BLUETOOTH_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransferIface))

typedef struct _BluetoothObexTransfer BluetoothObexTransfer;
typedef struct _BluetoothObexTransferIface BluetoothObexTransferIface;

#define BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY (bluetooth_obex_transfer_proxy_get_type ())

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())

#define TYPE_FILE_SENDER (file_sender_get_type ())
#define FILE_SENDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_SENDER, FileSender))
#define FILE_SENDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_SENDER, FileSenderClass))
#define IS_FILE_SENDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_SENDER))
#define IS_FILE_SENDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_SENDER))
#define FILE_SENDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_SENDER, FileSenderClass))

typedef struct _FileSender FileSender;
typedef struct _FileSenderClass FileSenderClass;
typedef struct _FileSenderPrivate FileSenderPrivate;
enum  {
	FILE_SENDER_0_PROPERTY,
	FILE_SENDER_NUM_PROPERTIES
};
static GParamSpec* file_sender_properties[FILE_SENDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FileSenderCreateSessionData FileSenderCreateSessionData;
typedef struct _FileSenderRemoveSessionData FileSenderRemoveSessionData;
typedef struct _FileSenderSendFileData FileSenderSendFileData;
typedef struct _Block7Data Block7Data;

struct _BluetoothObexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (BluetoothObexTransfer* self, GError** error);
	void (*resume) (BluetoothObexTransfer* self, GError** error);
	void (*suspend) (BluetoothObexTransfer* self, GError** error);
	gchar* (*get_status) (BluetoothObexTransfer* self);
	char* (*get_session) (BluetoothObexTransfer* self);
	gchar* (*get_name) (BluetoothObexTransfer* self);
	gchar* (*get_Type) (BluetoothObexTransfer* self);
	guint64 (*get_time) (BluetoothObexTransfer* self);
	guint64 (*get_size) (BluetoothObexTransfer* self);
	guint64 (*get_transferred) (BluetoothObexTransfer* self);
	gchar* (*get_filename) (BluetoothObexTransfer* self);
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BaseDialog {
	GtkDialog parent_instance;
	BaseDialogPrivate * priv;
	BluetoothObexTransfer* transfer;
	BluetoothDevice* device;
	gint start_time;
	guint64 total_size;
	GtkProgressBar* progress_bar;
	GtkLabel* device_label;
	GtkLabel* directory_label;
	GtkLabel* progress_label;
	GtkLabel* filename_label;
	GtkLabel* rate_label;
	GtkImage* device_image;
};

struct _BaseDialogClass {
	GtkDialogClass parent_class;
};

struct _FileSender {
	BaseDialog parent_instance;
	FileSenderPrivate * priv;
};

struct _FileSenderClass {
	BaseDialogClass parent_class;
};

struct _FileSenderPrivate {
	gint current_file;
	gint total_files;
	GDBusConnection* connection;
	GDBusProxy* client_proxy;
	GDBusProxy* session;
	GFile* file_path;
	char* session_path;
	GtkListStore* file_store;
};

struct _Block5Data {
	int _ref_count_;
	FileSender* self;
	gint current;
};

struct _Block6Data {
	int _ref_count_;
	FileSender* self;
	GtkMessageDialog* retry_dialog;
};

struct _FileSenderCreateSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FileSender* self;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	GDBusProxy* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusProxy* _tmp5_;
	GDBusProxy* _tmp6_;
	GtkLabel* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkLabel* _tmp15_;
	BluetoothDevice* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	BluetoothDevice* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gchar* _tmp28_;
	BluetoothDevice* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkImage* _tmp32_;
	GThemedIcon* _tmp33_;
	GThemedIcon* _tmp34_;
	GtkLabel* _tmp35_;
	BluetoothDevice* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GVariantBuilder* builder;
	const GVariantType* _tmp42_;
	GVariantBuilder* _tmp43_;
	GVariantBuilder* _tmp44_;
	GVariant* _tmp45_;
	GVariant* _tmp46_;
	GVariant* parameters;
	BluetoothDevice* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GVariantBuilder* _tmp51_;
	GVariant* _tmp52_;
	GVariant* _tmp53_;
	GVariant* variant_client;
	GDBusProxy* _tmp54_;
	GVariant* _tmp55_;
	GVariant* _tmp56_;
	GVariant* _tmp57_;
	char* _tmp58_;
	GDBusProxy* _tmp59_;
	GDBusConnection* _tmp60_;
	const char* _tmp61_;
	GDBusProxy* _tmp62_;
	GDBusProxy* _tmp63_;
	GError* e;
	Block6Data* _data6_;
	BluetoothDevice* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GFile* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GtkMessageDialog* _tmp75_;
	GtkMessageDialog* _tmp76_;
	GtkMessageDialog* _tmp77_;
	GtkWidget* suggested_button;
	GtkMessageDialog* _tmp78_;
	GtkWidget* _tmp79_;
	GtkWidget* _tmp80_;
	GtkWidget* _tmp81_;
	GtkStyleContext* _tmp82_;
	GtkMessageDialog* _tmp83_;
	GtkMessageDialog* _tmp84_;
	GtkLabel* _tmp85_;
	GError* _tmp86_;
	const gchar* _tmp87_;
	gchar** _tmp88_;
	gchar** _tmp89_;
	gchar** _tmp90_;
	gint _tmp90__length1;
	const gchar* _tmp91_;
	GFile* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	BluetoothDevice* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	GError* _tmp99_;
	const gchar* _tmp100_;
	GError* _inner_error0_;
};

struct _FileSenderRemoveSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FileSender* self;
	GDBusProxy* _tmp0_;
	const char* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _FileSenderSendFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FileSender* self;
	GtkLabel* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	BluetoothDevice* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	BluetoothDevice* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GtkImage* _tmp20_;
	GThemedIcon* _tmp21_;
	GThemedIcon* _tmp22_;
	GtkLabel* _tmp23_;
	BluetoothDevice* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GVariant* variant;
	GDBusProxy* _tmp30_;
	GFile* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	char* object_path;
	GVariant* _tmp38_;
	char* _tmp39_;
	BluetoothObexTransfer* _tmp40_;
	const char* _tmp41_;
	BluetoothObexTransfer* _tmp42_;
	BluetoothObexTransfer* _tmp43_;
	GtkLabel* _tmp44_;
	BluetoothObexTransfer* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	BluetoothObexTransfer* _tmp51_;
	guint64 _tmp52_;
	guint64 _tmp53_;
	BluetoothObexTransfer* _tmp54_;
	GError* e;
	BluetoothObexTransfer* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	BluetoothDevice* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GError* _tmp63_;
	const gchar* _tmp64_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	FileSender* self;
	GtkMessageDialog* retry_dialog;
};

static gint FileSender_private_offset;
static gpointer file_sender_parent_class = NULL;

VALA_EXTERN GType base_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseDialog, g_object_unref)
VALA_EXTERN GType bluetooth_obex_transfer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_transfer_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexTransfer, g_object_unref)
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN GType file_sender_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileSender, g_object_unref)
VALA_EXTERN FileSender* file_sender_new (GtkApplication* application);
VALA_EXTERN FileSender* file_sender_construct (GType object_type,
                                   GtkApplication* application);
VALA_EXTERN void file_sender_add_files (FileSender* self,
                            GFile** files,
                            gint files_length1,
                            BluetoothDevice* device);
static void file_sender_total_n_current (FileSender* self,
                                  gboolean total);
static void file_sender_create_session (FileSender* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void file_sender_create_session_finish (FileSender* self,
                                        GAsyncResult* _res_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda19_ (Block5Data* _data5_,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      GtkTreeIter* iter);
static gboolean ___lambda19__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
static void file_sender_create_session_data_free (gpointer _data);
static gboolean file_sender_create_session_co (FileSenderCreateSessionData* _data_);
static void file_sender_create_session_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
VALA_EXTERN gchar* bluetooth_device_get_alias (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_icon (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
static void file_sender_send_file (FileSender* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
static void file_sender_send_file_finish (FileSender* self,
                                   GAsyncResult* _res_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda22_ (Block6Data* _data6_,
                   gint response_id);
static void ____lambda22__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void file_sender_remove_session_data_free (gpointer _data);
static void file_sender_remove_session (FileSender* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void file_sender_remove_session_finish (FileSender* self,
                                        GAsyncResult* _res_);
static gboolean file_sender_remove_session_co (FileSenderRemoveSessionData* _data_);
static void file_sender_remove_session_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void file_sender_send_file_data_free (gpointer _data);
static gboolean file_sender_send_file_co (FileSenderSendFileData* _data_);
static void file_sender_send_file_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_name (BluetoothObexTransfer* self);
VALA_EXTERN guint64 bluetooth_obex_transfer_get_size (BluetoothObexTransfer* self);
static void ___lambda20_ (FileSender* self,
                   GVariant* changed,
                   gchar** invalid);
static void file_sender_update_progress (FileSender* self);
static void ____lambda20__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_status (BluetoothObexTransfer* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda21_ (Block7Data* _data7_,
                   gint response_id);
static void ____lambda21__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN void base_dialog_on_transfer_progress (BaseDialog* self,
                                       guint64 transferred);
VALA_EXTERN guint64 bluetooth_obex_transfer_get_transferred (BluetoothObexTransfer* self);
static void file_sender_send_notify (FileSender* self);
static gboolean file_sender_try_next_file (FileSender* self);
static GObject * file_sender_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties);
static void _file_sender___lambda23_ (FileSender* self,
                               gint response_id);
static void __file_sender___lambda23__gtk_dialog_response (GtkDialog* _sender,
                                                    gint response_id,
                                                    gpointer self);
static void file_sender_finalize (GObject * obj);
static GType file_sender_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
file_sender_get_instance_private (FileSender* self)
{
	return G_STRUCT_MEMBER_P (self, FileSender_private_offset);
}

FileSender*
file_sender_construct (GType object_type,
                       GtkApplication* application)
{
	FileSender * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (FileSender*) g_object_new (object_type, "application", application, "resizable", FALSE, NULL);
	return self;
}

FileSender*
file_sender_new (GtkApplication* application)
{
	return file_sender_construct (TYPE_FILE_SENDER, application);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
file_sender_add_files (FileSender* self,
                       GFile** files,
                       gint files_length1,
                       BluetoothDevice* device)
{
	BluetoothDevice* _tmp6_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	GFile* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp0_;
			GFile* file = NULL;
			_tmp0_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp0_;
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp1_;
				GtkTreeIter _tmp2_ = {0};
				GtkListStore* _tmp3_;
				GtkTreeIter _tmp4_;
				GFile* _tmp5_;
				_tmp1_ = self->priv->file_store;
				gtk_list_store_append (_tmp1_, &_tmp2_);
				iter = _tmp2_;
				_tmp3_ = self->priv->file_store;
				_tmp4_ = iter;
				_tmp5_ = file;
				gtk_list_store_set (_tmp3_, &_tmp4_, 0, _tmp5_, -1);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp6_ = _g_object_ref0 (device);
	_g_object_unref0 (((BaseDialog*) self)->device);
	((BaseDialog*) self)->device = _tmp6_;
	_tmp7_ = self->priv->file_store;
	gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp7_, &_tmp8_);
	iter = _tmp8_;
	_tmp9_ = self->priv->file_store;
	_tmp10_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp9_, &_tmp10_, 0, &_tmp11_, -1);
	_g_object_unref0 (self->priv->file_path);
	self->priv->file_path = _tmp11_;
	file_sender_total_n_current (self, FALSE);
	file_sender_create_session (self, NULL, NULL);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FileSender* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda19_ (Block5Data* _data5_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	FileSender* self;
	GFile* file = NULL;
	GtkTreeIter _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gint _tmp4_;
	gboolean result;
	self = _data5_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1);
	_g_object_unref0 (file);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = self->priv->file_path;
	if (_tmp2_ == _tmp3_) {
		_data5_->current = self->priv->total_files;
	}
	_tmp4_ = self->priv->total_files;
	self->priv->total_files = _tmp4_ + 1;
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}

static gboolean
___lambda19__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                          GtkTreePath* path,
                                          GtkTreeIter* iter,
                                          gpointer self)
{
	gboolean result;
	result = __lambda19_ (self, model, path, iter);
	return result;
}

static void
file_sender_total_n_current (FileSender* self,
                             gboolean total)
{
	Block5Data* _data5_;
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	self->priv->total_files = 0;
	_data5_->current = 0;
	_tmp0_ = self->priv->file_store;
	gtk_tree_model_foreach ((GtkTreeModel*) _tmp0_, ___lambda19__gtk_tree_model_foreach_func, _data5_);
	if (!total) {
		self->priv->current_file = _data5_->current + 1;
	}
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
file_sender_create_session_data_free (gpointer _data)
{
	FileSenderCreateSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FileSenderCreateSessionData, _data_);
}

static void
file_sender_create_session (FileSender* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	FileSenderCreateSessionData* _data_;
	FileSender* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FileSenderCreateSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, file_sender_create_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	file_sender_create_session_co (_data_);
}

static void
file_sender_create_session_finish (FileSender* self,
                                   GAsyncResult* _res_)
{
	FileSenderCreateSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
file_sender_create_session_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	FileSenderCreateSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	file_sender_create_session_co (_data_);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FileSender* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->retry_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda22_ (Block6Data* _data6_,
              gint response_id)
{
	FileSender* self;
	GtkMessageDialog* _tmp0_;
	self = _data6_->self;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		file_sender_create_session (self, NULL, NULL);
		gtk_window_present ((GtkWindow*) self);
	} else {
		gtk_widget_destroy ((GtkWidget*) self);
	}
	_tmp0_ = _data6_->retry_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda22__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda22_ (self, response_id);
}

static gboolean
file_sender_create_session_co (FileSenderCreateSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SESSION, NULL, file_sender_create_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->connection);
		_data_->self->priv->connection = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->connection;
		_data_->_state_ = 2;
		g_dbus_proxy_new (_data_->_tmp4_, G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, NULL, "org.bluez.obex", "/org/bluez/obex", "org.bluez.obex.Client1", NULL, file_sender_create_session_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = g_dbus_proxy_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->client_proxy);
		_data_->self->priv->client_proxy = _data_->_tmp6_;
		_data_->_tmp7_ = ((BaseDialog*) _data_->self)->directory_label;
		_data_->_tmp8_ = _data_->self->priv->file_path;
		_data_->_tmp9_ = g_file_get_parent (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = g_file_get_path (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = g_markup_printf_escaped (_ ("<b>From</b>: %s"), _data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		gtk_label_set_markup (_data_->_tmp7_, _data_->_tmp14_);
		_g_free0 (_data_->_tmp14_);
		_g_free0 (_data_->_tmp12_);
		_g_object_unref0 (_data_->_tmp10_);
		_data_->_tmp15_ = ((BaseDialog*) _data_->self)->device_label;
		_data_->_tmp16_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp17_ = bluetooth_device_get_alias (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = g_markup_printf_escaped (_ ("<b>To</b>: %s"), _data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		gtk_label_set_markup (_data_->_tmp15_, _data_->_tmp21_);
		_g_free0 (_data_->_tmp21_);
		_g_free0 (_data_->_tmp19_);
		_data_->_tmp23_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp24_ = bluetooth_device_get_icon (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->_tmp26_ == NULL;
		_g_free0 (_data_->_tmp26_);
		if (_data_->_tmp27_) {
			_data_->_tmp28_ = g_strdup ("bluetooth-active");
			_g_free0 (_data_->_tmp22_);
			_data_->_tmp22_ = _data_->_tmp28_;
		} else {
			_data_->_tmp29_ = ((BaseDialog*) _data_->self)->device;
			_data_->_tmp30_ = bluetooth_device_get_icon (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_g_free0 (_data_->_tmp22_);
			_data_->_tmp22_ = _data_->_tmp31_;
		}
		_data_->_tmp32_ = ((BaseDialog*) _data_->self)->device_image;
		_data_->_tmp33_ = (GThemedIcon*) g_themed_icon_new (_data_->_tmp22_);
		_data_->_tmp34_ = _data_->_tmp33_;
		gtk_image_set_from_gicon (_data_->_tmp32_, (GIcon*) _data_->_tmp34_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
		_g_object_unref0 (_data_->_tmp34_);
		_data_->_tmp35_ = ((BaseDialog*) _data_->self)->progress_label;
		_data_->_tmp36_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp37_ = bluetooth_device_get_alias (_data_->_tmp36_);
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = g_strdup_printf (_ ("Trying to connect to %s…"), _data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		gtk_label_set_label (_data_->_tmp35_, _data_->_tmp41_);
		_g_free0 (_data_->_tmp41_);
		_g_free0 (_data_->_tmp39_);
		_data_->_tmp42_ = G_VARIANT_TYPE_DICTIONARY;
		_data_->_tmp43_ = g_variant_builder_new (_data_->_tmp42_);
		_data_->builder = _data_->_tmp43_;
		_data_->_tmp44_ = _data_->builder;
		_data_->_tmp45_ = g_variant_new_string ("opp");
		g_variant_ref_sink (_data_->_tmp45_);
		_data_->_tmp46_ = _data_->_tmp45_;
		g_variant_builder_add (_data_->_tmp44_, "{sv}", "Target", _data_->_tmp46_, NULL);
		_g_variant_unref0 (_data_->_tmp46_);
		_data_->_tmp47_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp48_ = bluetooth_device_get_address (_data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = _data_->_tmp49_;
		_data_->_tmp51_ = _data_->builder;
		_data_->_tmp52_ = g_variant_new ("(sa{sv})", _data_->_tmp50_, _data_->_tmp51_, NULL);
		g_variant_ref_sink (_data_->_tmp52_);
		_data_->_tmp53_ = _data_->_tmp52_;
		_g_free0 (_data_->_tmp50_);
		_data_->parameters = _data_->_tmp53_;
		_data_->_tmp54_ = _data_->self->priv->client_proxy;
		_data_->_tmp55_ = _data_->parameters;
		_data_->_state_ = 3;
		g_dbus_proxy_call (_data_->_tmp54_, "CreateSession", _data_->_tmp55_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, file_sender_create_session_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp56_ = g_dbus_proxy_call_finish (_data_->_tmp54_, _data_->_res_, &_data_->_inner_error0_);
		_data_->variant_client = _data_->_tmp56_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_variant_unref0 (_data_->parameters);
			_g_variant_builder_unref0 (_data_->builder);
			_g_free0 (_data_->_tmp22_);
			_g_object_unref0 (_data_->_tmp3_);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp57_ = _data_->variant_client;
		_data_->_tmp58_ = NULL;
		g_variant_get (_data_->_tmp57_, "(o)", &_data_->_tmp58_, NULL);
		_g_free0 (_data_->self->priv->session_path);
		_data_->self->priv->session_path = _data_->_tmp58_;
		_data_->_tmp60_ = _data_->self->priv->connection;
		_data_->_tmp61_ = _data_->self->priv->session_path;
		_data_->_state_ = 4;
		g_dbus_proxy_new (_data_->_tmp60_, G_DBUS_PROXY_FLAGS_NONE, NULL, "org.bluez.obex", (const gchar*) _data_->_tmp61_, "org.bluez.obex.ObjectPush1", NULL, file_sender_create_session_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp62_ = g_dbus_proxy_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp59_ = _data_->_tmp62_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_variant_unref0 (_data_->variant_client);
			_g_variant_unref0 (_data_->parameters);
			_g_variant_builder_unref0 (_data_->builder);
			_g_free0 (_data_->_tmp22_);
			_g_object_unref0 (_data_->_tmp3_);
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp63_ = _data_->_tmp59_;
		_data_->_tmp59_ = NULL;
		_g_object_unref0 (_data_->self->priv->session);
		_data_->self->priv->session = _data_->_tmp63_;
		file_sender_send_file (_data_->self, NULL, NULL);
		_g_object_unref0 (_data_->_tmp59_);
		_g_variant_unref0 (_data_->variant_client);
		_g_variant_unref0 (_data_->parameters);
		_g_variant_builder_unref0 (_data_->builder);
		_g_free0 (_data_->_tmp22_);
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_data6_ = g_slice_new0 (Block6Data);
		_data_->_data6_->_ref_count_ = 1;
		_data_->_data6_->self = g_object_ref (_data_->self);
		gtk_widget_hide_on_delete ((GtkWidget*) _data_->self);
		_data_->_tmp64_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp65_ = bluetooth_device_get_alias (_data_->_tmp64_);
		_data_->_tmp66_ = _data_->_tmp65_;
		_data_->_tmp67_ = _data_->_tmp66_;
		_data_->_tmp68_ = g_strdup_printf (_ ("Connecting to '%s' failed"), _data_->_tmp67_);
		_data_->_tmp69_ = _data_->self->priv->file_path;
		_data_->_tmp70_ = g_file_get_basename (_data_->_tmp69_);
		_data_->_tmp71_ = _data_->_tmp70_;
		_data_->_tmp72_ = g_strdup_printf ("Transferring file '%s' failed.", _data_->_tmp71_);
		_data_->_tmp73_ = _data_->_tmp72_;
		_data_->_tmp74_ = g_strdup_printf ("%s\n%s", _data_->_tmp73_, _ ("The file has not been transferred."));
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data_->self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, NULL);
		g_object_set (_data_->_tmp75_, "text", _data_->_tmp68_, NULL);
		_g_free0 (_data_->_tmp68_);
		g_object_set (_data_->_tmp75_, "secondary-text", _data_->_tmp74_, NULL);
		_g_free0 (_data_->_tmp74_);
		g_object_ref_sink (_data_->_tmp75_);
		_data_->_tmp76_ = _data_->_tmp75_;
		_g_free0 (_data_->_tmp73_);
		_g_free0 (_data_->_tmp71_);
		_g_free0 (_data_->_tmp67_);
		_data_->_data6_->retry_dialog = _data_->_tmp76_;
		_data_->_tmp77_ = _data_->_data6_->retry_dialog;
		gtk_dialog_add_button ((GtkDialog*) _data_->_tmp77_, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
		_data_->_tmp78_ = _data_->_data6_->retry_dialog;
		_data_->_tmp79_ = gtk_dialog_add_button ((GtkDialog*) _data_->_tmp78_, _ ("Retry"), (gint) GTK_RESPONSE_ACCEPT);
		_data_->_tmp80_ = _g_object_ref0 (_data_->_tmp79_);
		_data_->suggested_button = _data_->_tmp80_;
		_data_->_tmp81_ = _data_->suggested_button;
		_data_->_tmp82_ = gtk_widget_get_style_context (_data_->_tmp81_);
		gtk_style_context_add_class (_data_->_tmp82_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
		_data_->_tmp83_ = _data_->_data6_->retry_dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp83_, "response", (GCallback) ____lambda22__gtk_dialog_response, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
		_data_->_tmp84_ = _data_->_data6_->retry_dialog;
		gtk_widget_show_all ((GtkWidget*) _data_->_tmp84_);
		_data_->_tmp85_ = ((BaseDialog*) _data_->self)->progress_label;
		_data_->_tmp86_ = _data_->e;
		_data_->_tmp87_ = _data_->_tmp86_->message;
		_data_->_tmp89_ = _data_->_tmp88_ = g_strsplit (_data_->_tmp87_, "org.bluez.obex.Error.Failed:", 0);
		_data_->_tmp90_ = _data_->_tmp89_;
		_data_->_tmp90__length1 = _vala_array_length (_data_->_tmp88_);
		_data_->_tmp91_ = _data_->_tmp90_[1];
		gtk_label_set_label (_data_->_tmp85_, _data_->_tmp91_);
		_data_->_tmp90_ = (_vala_array_free (_data_->_tmp90_, _data_->_tmp90__length1, (GDestroyNotify) g_free), NULL);
		_data_->_tmp92_ = _data_->self->priv->file_path;
		_data_->_tmp93_ = g_file_get_basename (_data_->_tmp92_);
		_data_->_tmp94_ = _data_->_tmp93_;
		_data_->_tmp95_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp96_ = bluetooth_device_get_alias (_data_->_tmp95_);
		_data_->_tmp97_ = _data_->_tmp96_;
		_data_->_tmp98_ = _data_->_tmp97_;
		_data_->_tmp99_ = _data_->e;
		_data_->_tmp100_ = _data_->_tmp99_->message;
		g_warning ("FileSender.vala:160: Error transferring '%s' to '%s': %s", _data_->_tmp94_, _data_->_tmp98_, _data_->_tmp100_);
		_g_free0 (_data_->_tmp98_);
		_g_free0 (_data_->_tmp94_);
		_g_object_unref0 (_data_->suggested_button);
		_g_error_free0 (_data_->e);
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
file_sender_remove_session_data_free (gpointer _data)
{
	FileSenderRemoveSessionData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FileSenderRemoveSessionData, _data_);
}

static void
file_sender_remove_session (FileSender* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	FileSenderRemoveSessionData* _data_;
	FileSender* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FileSenderRemoveSessionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, file_sender_remove_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	file_sender_remove_session_co (_data_);
}

static void
file_sender_remove_session_finish (FileSender* self,
                                   GAsyncResult* _res_)
{
	FileSenderRemoveSessionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
file_sender_remove_session_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	FileSenderRemoveSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	file_sender_remove_session_co (_data_);
}

static gboolean
file_sender_remove_session_co (FileSenderRemoveSessionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->client_proxy;
		_data_->_tmp1_ = _data_->self->priv->session_path;
		_data_->_tmp2_ = g_variant_new ("(o)", _data_->_tmp1_, NULL);
		g_variant_ref_sink (_data_->_tmp2_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		g_dbus_proxy_call (_data_->_tmp0_, "RemoveSession", _data_->_tmp3_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, file_sender_remove_session_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = g_dbus_proxy_call_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_variant_unref0 (_data_->_tmp5_);
		_g_variant_unref0 (_data_->_tmp3_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("FileSender.vala:168: Error removing Obex transfer session: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
file_sender_send_file_data_free (gpointer _data)
{
	FileSenderSendFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FileSenderSendFileData, _data_);
}

static void
file_sender_send_file (FileSender* self,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	FileSenderSendFileData* _data_;
	FileSender* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FileSenderSendFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, file_sender_send_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	file_sender_send_file_co (_data_);
}

static void
file_sender_send_file_finish (FileSender* self,
                              GAsyncResult* _res_)
{
	FileSenderSendFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
file_sender_send_file_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	FileSenderSendFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	file_sender_send_file_co (_data_);
}

static void
___lambda20_ (FileSender* self,
              GVariant* changed,
              gchar** invalid)
{
	g_return_if_fail (changed != NULL);
	file_sender_update_progress (self);
}

static void
____lambda20__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	___lambda20_ ((FileSender*) self, changed_properties, invalidated_properties);
}

static gboolean
file_sender_send_file_co (FileSenderSendFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((BaseDialog*) _data_->self)->directory_label;
	_data_->_tmp1_ = _data_->self->priv->file_path;
	_data_->_tmp2_ = g_file_get_parent (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_markup_printf_escaped (_ ("<b>From</b>: %s"), _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	gtk_label_set_markup (_data_->_tmp0_, _data_->_tmp7_);
	_g_free0 (_data_->_tmp7_);
	_g_free0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->_tmp8_ = ((BaseDialog*) _data_->self)->device_label;
	_data_->_tmp9_ = ((BaseDialog*) _data_->self)->device;
	_data_->_tmp10_ = bluetooth_device_get_alias (_data_->_tmp9_);
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_markup_printf_escaped (_ ("<b>To</b>: %s"), _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	gtk_label_set_markup (_data_->_tmp8_, _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp16_ = ((BaseDialog*) _data_->self)->device;
	_data_->_tmp17_ = bluetooth_device_get_icon (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp15_ = _data_->_tmp18_;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp19_ = g_strdup ("bluetooth-active");
		_g_free0 (_data_->_tmp15_);
		_data_->_tmp15_ = _data_->_tmp19_;
	}
	_data_->_tmp20_ = ((BaseDialog*) _data_->self)->device_image;
	_data_->_tmp21_ = (GThemedIcon*) g_themed_icon_new (_data_->_tmp15_);
	_data_->_tmp22_ = _data_->_tmp21_;
	gtk_image_set_from_gicon (_data_->_tmp20_, (GIcon*) _data_->_tmp22_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	_g_object_unref0 (_data_->_tmp22_);
	_data_->_tmp23_ = ((BaseDialog*) _data_->self)->progress_label;
	_data_->_tmp24_ = ((BaseDialog*) _data_->self)->device;
	_data_->_tmp25_ = bluetooth_device_get_alias (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = g_strdup_printf (_ ("Waiting for acceptance on %s…"), _data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	gtk_label_set_label (_data_->_tmp23_, _data_->_tmp29_);
	_g_free0 (_data_->_tmp29_);
	_g_free0 (_data_->_tmp27_);
	{
		_data_->_tmp30_ = _data_->self->priv->session;
		_data_->_tmp31_ = _data_->self->priv->file_path;
		_data_->_tmp32_ = g_file_get_path (_data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = g_variant_new ("(s)", _data_->_tmp33_, NULL);
		g_variant_ref_sink (_data_->_tmp34_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->_state_ = 1;
		g_dbus_proxy_call (_data_->_tmp30_, "SendFile", _data_->_tmp35_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, file_sender_send_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp36_ = g_dbus_proxy_call_finish (_data_->_tmp30_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp37_ = _data_->_tmp36_;
		_g_variant_unref0 (_data_->_tmp35_);
		_g_free0 (_data_->_tmp33_);
		_data_->variant = _data_->_tmp37_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		((BaseDialog*) _data_->self)->start_time = (gint) g_get_real_time ();
		_data_->_tmp38_ = _data_->variant;
		_data_->_tmp39_ = NULL;
		g_variant_get (_data_->_tmp38_, "(oa{sv})", &_data_->_tmp39_, NULL, NULL);
		_g_free0 (_data_->object_path);
		_data_->object_path = _data_->_tmp39_;
		_data_->_tmp41_ = _data_->object_path;
		_data_->_tmp42_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_data_->_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp41_, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		_data_->_tmp40_ = (BluetoothObexTransfer*) _data_->_tmp42_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->object_path);
			_g_variant_unref0 (_data_->variant);
			goto __catch0_g_error;
		}
		_data_->_tmp43_ = _data_->_tmp40_;
		_data_->_tmp40_ = NULL;
		_g_object_unref0 (((BaseDialog*) _data_->self)->transfer);
		((BaseDialog*) _data_->self)->transfer = _data_->_tmp43_;
		_data_->_tmp44_ = ((BaseDialog*) _data_->self)->filename_label;
		_data_->_tmp45_ = ((BaseDialog*) _data_->self)->transfer;
		_data_->_tmp46_ = bluetooth_obex_transfer_get_name (_data_->_tmp45_);
		_data_->_tmp47_ = _data_->_tmp46_;
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = g_markup_printf_escaped ("<b>File name</b>: %s", _data_->_tmp48_);
		_data_->_tmp50_ = _data_->_tmp49_;
		gtk_label_set_markup (_data_->_tmp44_, _data_->_tmp50_);
		_g_free0 (_data_->_tmp50_);
		_g_free0 (_data_->_tmp48_);
		_data_->_tmp51_ = ((BaseDialog*) _data_->self)->transfer;
		_data_->_tmp52_ = bluetooth_obex_transfer_get_size (_data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		((BaseDialog*) _data_->self)->total_size = _data_->_tmp53_;
		_data_->_tmp54_ = ((BaseDialog*) _data_->self)->transfer;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda20__g_dbus_proxy_g_properties_changed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp40_);
		_g_free0 (_data_->object_path);
		_g_variant_unref0 (_data_->variant);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp55_ = ((BaseDialog*) _data_->self)->transfer;
		_data_->_tmp56_ = bluetooth_obex_transfer_get_name (_data_->_tmp55_);
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = ((BaseDialog*) _data_->self)->device;
		_data_->_tmp60_ = bluetooth_device_get_alias (_data_->_tmp59_);
		_data_->_tmp61_ = _data_->_tmp60_;
		_data_->_tmp62_ = _data_->_tmp61_;
		_data_->_tmp63_ = _data_->e;
		_data_->_tmp64_ = _data_->_tmp63_->message;
		g_warning ("FileSender.vala:200: Error transferring file '%s' to '%s': %s", _data_->_tmp58_, _data_->_tmp62_, _data_->_tmp64_);
		_g_free0 (_data_->_tmp62_);
		_g_free0 (_data_->_tmp58_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->_tmp15_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->_tmp15_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		FileSender* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->retry_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda21_ (Block7Data* _data7_,
              gint response_id)
{
	FileSender* self;
	GtkMessageDialog* _tmp0_;
	self = _data7_->self;
	if (response_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		file_sender_create_session (self, NULL, NULL);
		gtk_window_present ((GtkWindow*) self);
	} else {
		gtk_widget_destroy ((GtkWidget*) self);
	}
	_tmp0_ = _data7_->retry_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda21__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda21_ (self, response_id);
}

static void
file_sender_update_progress (FileSender* self)
{
	BluetoothObexTransfer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((BaseDialog*) self)->transfer;
	_tmp1_ = bluetooth_obex_transfer_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("error")))) {
		switch (0) {
			default:
			{
				Block7Data* _data7_;
				GFile* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				BluetoothDevice* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GtkMessageDialog* _tmp17_ = NULL;
				GtkMessageDialog* _tmp18_;
				GtkMessageDialog* _tmp19_;
				GtkWidget* suggested_button = NULL;
				GtkMessageDialog* _tmp20_;
				GtkWidget* _tmp21_;
				GtkWidget* _tmp22_;
				GtkWidget* _tmp23_;
				GtkStyleContext* _tmp24_;
				GtkMessageDialog* _tmp25_;
				GtkMessageDialog* _tmp26_;
				GtkProgressBar* _tmp27_;
				_data7_ = g_slice_new0 (Block7Data);
				_data7_->_ref_count_ = 1;
				_data7_->self = g_object_ref (self);
				gtk_widget_hide_on_delete ((GtkWidget*) self);
				_tmp6_ = self->priv->file_path;
				_tmp7_ = g_file_get_basename (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strdup_printf (_ ("Transferring '%s' failed"), _tmp8_);
				_tmp10_ = ((BaseDialog*) self)->device;
				_tmp11_ = bluetooth_device_get_alias (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf (_ ("The transfer was interrupted or declined by %s."), _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strdup_printf ("%s\n%s", _tmp15_, _ ("The file has not been transferred."));
				_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, NULL);
				g_object_set (_tmp17_, "text", _tmp9_, NULL);
				_g_free0 (_tmp9_);
				g_object_set (_tmp17_, "secondary-text", _tmp16_, NULL);
				_g_free0 (_tmp16_);
				g_object_ref_sink (_tmp17_);
				_tmp18_ = _tmp17_;
				_g_free0 (_tmp15_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp8_);
				_data7_->retry_dialog = _tmp18_;
				_tmp19_ = _data7_->retry_dialog;
				gtk_dialog_add_button ((GtkDialog*) _tmp19_, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
				_tmp20_ = _data7_->retry_dialog;
				_tmp21_ = gtk_dialog_add_button ((GtkDialog*) _tmp20_, _ ("Retry"), (gint) GTK_RESPONSE_ACCEPT);
				_tmp22_ = _g_object_ref0 (_tmp21_);
				suggested_button = _tmp22_;
				_tmp23_ = suggested_button;
				_tmp24_ = gtk_widget_get_style_context (_tmp23_);
				gtk_style_context_add_class (_tmp24_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
				_tmp25_ = _data7_->retry_dialog;
				g_signal_connect_data ((GtkDialog*) _tmp25_, "response", (GCallback) ____lambda21__gtk_dialog_response, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
				_tmp26_ = _data7_->retry_dialog;
				gtk_widget_show_all ((GtkWidget*) _tmp26_);
				_tmp27_ = ((BaseDialog*) self)->progress_bar;
				gtk_progress_bar_set_fraction (_tmp27_, 0.0);
				file_sender_remove_session (self, NULL, NULL);
				_g_object_unref0 (suggested_button);
				block7_data_unref (_data7_);
				_data7_ = NULL;
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("active")))) {
		switch (0) {
			default:
			{
				BluetoothObexTransfer* _tmp28_;
				guint64 _tmp29_;
				guint64 _tmp30_;
				_tmp28_ = ((BaseDialog*) self)->transfer;
				_tmp29_ = bluetooth_obex_transfer_get_transferred (_tmp28_);
				_tmp30_ = _tmp29_;
				base_dialog_on_transfer_progress ((BaseDialog*) self, _tmp30_);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("complete")))) {
		switch (0) {
			default:
			{
				file_sender_send_notify (self);
				if (!file_sender_try_next_file (self)) {
					file_sender_remove_session (self, NULL, NULL);
					gtk_widget_destroy ((GtkWidget*) self);
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static gboolean
file_sender_try_next_file (FileSender* self)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file_store;
	_tmp1_ = g_strdup_printf ("%i", self->priv->current_file);
	_tmp2_ = _tmp1_;
	_tmp4_ = gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp3_, _tmp2_);
	iter = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		GFile* _tmp8_ = NULL;
		_tmp6_ = self->priv->file_store;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 0, &_tmp8_, -1);
		_g_object_unref0 (self->priv->file_path);
		self->priv->file_path = _tmp8_;
		file_sender_send_file (self, NULL, NULL);
		file_sender_total_n_current (self, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
file_sender_send_notify (FileSender* self)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	gchar* _tmp1_ = NULL;
	BluetoothDevice* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GNotification* _tmp6_;
	GThemedIcon* _tmp7_;
	GThemedIcon* _tmp8_;
	GNotification* _tmp9_;
	GNotification* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	BluetoothDevice* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GNotification* _tmp20_;
	GtkWidget* _tmp21_;
	GtkApplication* _tmp22_;
	GtkApplication* _tmp23_;
	GNotification* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_notification_new ("Bluetooth");
	notification = _tmp0_;
	_tmp2_ = ((BaseDialog*) self)->device;
	_tmp3_ = bluetooth_device_get_icon (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = _tmp4_;
	if (_tmp1_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("bluetooth-active");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = notification;
	_tmp7_ = (GThemedIcon*) g_themed_icon_new (_tmp1_);
	_tmp8_ = _tmp7_;
	g_notification_set_icon (_tmp6_, (GIcon*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = notification;
	g_notification_set_title (_tmp9_, _ ("File transferred successfully"));
	_tmp10_ = notification;
	_tmp11_ = self->priv->file_path;
	_tmp12_ = g_file_get_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = ((BaseDialog*) self)->device;
	_tmp15_ = bluetooth_device_get_alias (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = g_markup_printf_escaped ("<b>From:</b> %s <b>Sent to:</b> %s", _tmp13_, _tmp17_);
	_tmp19_ = _tmp18_;
	g_notification_set_body (_tmp10_, _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp13_);
	_tmp20_ = notification;
	g_notification_set_priority (_tmp20_, G_NOTIFICATION_PRIORITY_NORMAL);
	_tmp21_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp22_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_window_get_type (), GtkWindow));
	_tmp23_ = _tmp22_;
	_tmp24_ = notification;
	g_application_send_notification ((GApplication*) _tmp23_, "org.buddiesofbudgie.bluetooth", _tmp24_);
	_g_free0 (_tmp1_);
	_g_object_unref0 (notification);
}

static void
_file_sender___lambda23_ (FileSender* self,
                          gint response_id)
{
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		gboolean _tmp0_ = FALSE;
		BluetoothObexTransfer* _tmp1_;
		_tmp1_ = ((BaseDialog*) self)->transfer;
		if (_tmp1_ != NULL) {
			BluetoothObexTransfer* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp2_ = ((BaseDialog*) self)->transfer;
			_tmp3_ = bluetooth_obex_transfer_get_status (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp0_ = g_strcmp0 (_tmp5_, "active") == 0;
			_g_free0 (_tmp5_);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			file_sender_remove_session (self, NULL, NULL);
		}
	}
}

static void
__file_sender___lambda23__gtk_dialog_response (GtkDialog* _sender,
                                               gint response_id,
                                               gpointer self)
{
	_file_sender___lambda23_ ((FileSender*) self, response_id);
}

static GObject *
file_sender_constructor (GType type,
                         guint n_construct_properties,
                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FileSender * self;
	GtkListStore* _tmp0_;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	parent_class = G_OBJECT_CLASS (file_sender_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_SENDER, FileSender);
	gtk_window_set_title ((GtkWindow*) self, _ ("Bluetooth File Transfer"));
	_tmp0_ = gtk_list_store_new (1, g_file_get_type (), -1);
	_g_object_unref0 (self->priv->file_store);
	self->priv->file_store = _tmp0_;
	_tmp1_ = ((BaseDialog*) self)->directory_label;
	_tmp2_ = g_markup_printf_escaped ("<b>%s</b>:", _ ("From"));
	_tmp3_ = _tmp2_;
	gtk_label_set_markup (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = ((BaseDialog*) self)->device_label;
	_tmp5_ = g_markup_printf_escaped ("<b>%s</b>:", _ ("To"));
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) __file_sender___lambda23__gtk_dialog_response, self, 0);
	return obj;
}

static void
file_sender_class_init (FileSenderClass * klass,
                        gpointer klass_data)
{
	file_sender_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileSender_private_offset);
	G_OBJECT_CLASS (klass)->constructor = file_sender_constructor;
	G_OBJECT_CLASS (klass)->finalize = file_sender_finalize;
}

static void
file_sender_instance_init (FileSender * self,
                           gpointer klass)
{
	self->priv = file_sender_get_instance_private (self);
	self->priv->current_file = 0;
	self->priv->total_files = 0;
}

static void
file_sender_finalize (GObject * obj)
{
	FileSender * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_SENDER, FileSender);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->client_proxy);
	_g_object_unref0 (self->priv->session);
	_g_object_unref0 (self->priv->file_path);
	_g_free0 (self->priv->session_path);
	_g_object_unref0 (self->priv->file_store);
	G_OBJECT_CLASS (file_sender_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_sender_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileSenderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_sender_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileSender), 0, (GInstanceInitFunc) file_sender_instance_init, NULL };
	GType file_sender_type_id;
	file_sender_type_id = g_type_register_static (TYPE_BASE_DIALOG, "FileSender", &g_define_type_info, 0);
	FileSender_private_offset = g_type_add_instance_private (file_sender_type_id, sizeof (FileSenderPrivate));
	return file_sender_type_id;
}

GType
file_sender_get_type (void)
{
	static volatile gsize file_sender_type_id__once = 0;
	if (g_once_init_enter (&file_sender_type_id__once)) {
		GType file_sender_type_id;
		file_sender_type_id = file_sender_get_type_once ();
		g_once_init_leave (&file_sender_type_id__once, file_sender_type_id);
	}
	return file_sender_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

