/* FileReceiver.c generated by valac 0.56.14, the Vala compiler
 * generated from FileReceiver.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BASE_DIALOG (base_dialog_get_type ())
#define BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_DIALOG, BaseDialog))
#define BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_DIALOG, BaseDialogClass))
#define IS_BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_DIALOG))
#define IS_BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_DIALOG))
#define BASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_DIALOG, BaseDialogClass))

typedef struct _BaseDialog BaseDialog;
typedef struct _BaseDialogClass BaseDialogClass;
typedef struct _BaseDialogPrivate BaseDialogPrivate;

#define BLUETOOTH_OBEX_TYPE_TRANSFER (bluetooth_obex_transfer_get_type ())
#define BLUETOOTH_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransfer))
#define BLUETOOTH_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER))
#define BLUETOOTH_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransferIface))

typedef struct _BluetoothObexTransfer BluetoothObexTransfer;
typedef struct _BluetoothObexTransferIface BluetoothObexTransferIface;

#define BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY (bluetooth_obex_transfer_proxy_get_type ())

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())

#define TYPE_FILE_RECEIVER (file_receiver_get_type ())
#define FILE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_RECEIVER, FileReceiver))
#define FILE_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_RECEIVER, FileReceiverClass))
#define IS_FILE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_RECEIVER))
#define IS_FILE_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_RECEIVER))
#define FILE_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_RECEIVER, FileReceiverClass))

typedef struct _FileReceiver FileReceiver;
typedef struct _FileReceiverClass FileReceiverClass;
typedef struct _FileReceiverPrivate FileReceiverPrivate;
enum  {
	FILE_RECEIVER_0_PROPERTY,
	FILE_RECEIVER_SESSION_PATH_PROPERTY,
	FILE_RECEIVER_NUM_PROPERTIES
};
static GParamSpec* file_receiver_properties[FILE_RECEIVER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _BluetoothObexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (BluetoothObexTransfer* self, GError** error);
	void (*resume) (BluetoothObexTransfer* self, GError** error);
	void (*suspend) (BluetoothObexTransfer* self, GError** error);
	gchar* (*get_status) (BluetoothObexTransfer* self);
	char* (*get_session) (BluetoothObexTransfer* self);
	gchar* (*get_name) (BluetoothObexTransfer* self);
	gchar* (*get_Type) (BluetoothObexTransfer* self);
	guint64 (*get_time) (BluetoothObexTransfer* self);
	guint64 (*get_size) (BluetoothObexTransfer* self);
	guint64 (*get_transferred) (BluetoothObexTransfer* self);
	gchar* (*get_filename) (BluetoothObexTransfer* self);
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _BaseDialog {
	GtkDialog parent_instance;
	BaseDialogPrivate * priv;
	BluetoothObexTransfer* transfer;
	BluetoothDevice* device;
	gint start_time;
	guint64 total_size;
	GtkProgressBar* progress_bar;
	GtkLabel* device_label;
	GtkLabel* directory_label;
	GtkLabel* progress_label;
	GtkLabel* filename_label;
	GtkLabel* rate_label;
	GtkImage* device_image;
};

struct _BaseDialogClass {
	GtkDialogClass parent_class;
};

struct _FileReceiver {
	BaseDialog parent_instance;
	FileReceiverPrivate * priv;
};

struct _FileReceiverClass {
	BaseDialogClass parent_class;
};

struct _FileReceiverPrivate {
	gchar* _session_path;
	GNotification* notification;
	gchar* file_name;
};

static gint FileReceiver_private_offset;
static gpointer file_receiver_parent_class = NULL;

VALA_EXTERN GType base_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseDialog, g_object_unref)
VALA_EXTERN GType bluetooth_obex_transfer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_transfer_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexTransfer, g_object_unref)
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN GType file_receiver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileReceiver, g_object_unref)
VALA_EXTERN FileReceiver* file_receiver_new (GtkApplication* application);
VALA_EXTERN FileReceiver* file_receiver_construct (GType object_type,
                                       GtkApplication* application);
VALA_EXTERN void file_receiver_set_transfer (FileReceiver* self,
                                 BluetoothDevice* device,
                                 const gchar* path);
VALA_EXTERN gchar* bluetooth_device_get_alias (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_icon (BluetoothDevice* self);
static void ___lambda18_ (FileReceiver* self,
                   GVariant* changed,
                   gchar** invalid);
static void file_receiver_transfer_progress (FileReceiver* self);
static void ____lambda18__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
VALA_EXTERN guint64 bluetooth_obex_transfer_get_size (BluetoothObexTransfer* self);
VALA_EXTERN char* bluetooth_obex_transfer_get_session (BluetoothObexTransfer* self);
VALA_EXTERN void file_receiver_set_session_path (FileReceiver* self,
                                     const gchar* value);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_name (BluetoothObexTransfer* self);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_status (BluetoothObexTransfer* self);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_filename (BluetoothObexTransfer* self);
VALA_EXTERN void base_dialog_on_transfer_progress (BaseDialog* self,
                                       guint64 transferred);
VALA_EXTERN guint64 bluetooth_obex_transfer_get_transferred (BluetoothObexTransfer* self);
static void file_receiver_move_to_downloads (FileReceiver* self,
                                      const gchar* path,
                                      GError** error);
static GFile* file_receiver_get_save_name (FileReceiver* self,
                                    const gchar* uri);
VALA_EXTERN const gchar* file_receiver_get_session_path (FileReceiver* self);
static GObject * file_receiver_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void file_receiver_finalize (GObject * obj);
static GType file_receiver_get_type_once (void);
static void _vala_file_receiver_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_file_receiver_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
file_receiver_get_instance_private (FileReceiver* self)
{
	return G_STRUCT_MEMBER_P (self, FileReceiver_private_offset);
}

FileReceiver*
file_receiver_construct (GType object_type,
                         GtkApplication* application)
{
	FileReceiver * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (FileReceiver*) g_object_new (object_type, "application", application, "resizable", FALSE, NULL);
	return self;
}

FileReceiver*
file_receiver_new (GtkApplication* application)
{
	return file_receiver_construct (TYPE_FILE_RECEIVER, application);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda18_ (FileReceiver* self,
              GVariant* changed,
              gchar** invalid)
{
	g_return_if_fail (changed != NULL);
	file_receiver_transfer_progress (self);
}

static void
____lambda18__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	___lambda18_ ((FileReceiver*) self, changed_properties, invalidated_properties);
}

void
file_receiver_set_transfer (FileReceiver* self,
                            BluetoothDevice* device,
                            const gchar* path)
{
	BluetoothDevice* _tmp0_;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkImage* _tmp15_;
	GThemedIcon* _tmp16_;
	GThemedIcon* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (((BaseDialog*) self)->device);
	((BaseDialog*) self)->device = _tmp0_;
	_tmp1_ = ((BaseDialog*) self)->device_label;
	_tmp2_ = bluetooth_device_get_alias (device);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_markup_printf_escaped (_ ("<b>From</b>: %s"), _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = ((BaseDialog*) self)->directory_label;
	_tmp8_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp9_ = g_markup_printf_escaped (_ ("<b>To</b>: %s"), _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp12_ = bluetooth_device_get_icon (device);
	_tmp13_ = _tmp12_;
	_tmp11_ = _tmp13_;
	if (_tmp11_ == NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("bluetooth-active");
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp14_;
	}
	_tmp15_ = ((BaseDialog*) self)->device_image;
	_tmp16_ = (GThemedIcon*) g_themed_icon_new (_tmp11_);
	_tmp17_ = _tmp16_;
	gtk_image_set_from_gicon (_tmp15_, (GIcon*) _tmp17_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	_g_object_unref0 (_tmp17_);
	((BaseDialog*) self)->start_time = (gint) g_get_real_time ();
	{
		BluetoothObexTransfer* _tmp18_ = NULL;
		BluetoothObexTransfer* _tmp19_;
		BluetoothObexTransfer* _tmp20_;
		BluetoothObexTransfer* _tmp21_;
		BluetoothObexTransfer* _tmp22_;
		guint64 _tmp23_;
		guint64 _tmp24_;
		BluetoothObexTransfer* _tmp25_;
		char* _tmp26_;
		char* _tmp27_;
		char* _tmp28_;
		GtkLabel* _tmp29_;
		BluetoothObexTransfer* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp19_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		_tmp18_ = (BluetoothObexTransfer*) _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp20_ = _tmp18_;
		_tmp18_ = NULL;
		_g_object_unref0 (((BaseDialog*) self)->transfer);
		((BaseDialog*) self)->transfer = _tmp20_;
		_tmp21_ = ((BaseDialog*) self)->transfer;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda18__g_dbus_proxy_g_properties_changed, self, 0);
		_tmp22_ = ((BaseDialog*) self)->transfer;
		_tmp23_ = bluetooth_obex_transfer_get_size (_tmp22_);
		_tmp24_ = _tmp23_;
		((BaseDialog*) self)->total_size = _tmp24_;
		_tmp25_ = ((BaseDialog*) self)->transfer;
		_tmp26_ = bluetooth_obex_transfer_get_session (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		file_receiver_set_session_path (self, (const gchar*) _tmp28_);
		_g_free0 (_tmp28_);
		_tmp29_ = ((BaseDialog*) self)->filename_label;
		_tmp30_ = ((BaseDialog*) self)->transfer;
		_tmp31_ = bluetooth_obex_transfer_get_name (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp34_ = g_markup_printf_escaped (_ ("<b>File name</b>: %s"), _tmp33_);
		_tmp35_ = _tmp34_;
		gtk_label_set_markup (_tmp29_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_object_unref0 (_tmp18_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("FileReceiver.vala:45: Error accepting Bluetooth file transfer: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_tmp11_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (_tmp11_);
}

static void
file_receiver_transfer_progress (FileReceiver* self)
{
	BluetoothObexTransfer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((BaseDialog*) self)->transfer;
	_tmp1_ = bluetooth_obex_transfer_get_status (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("error")))) {
		switch (0) {
			default:
			{
				GNotification* _tmp6_;
				GtkImage* _tmp7_;
				GIcon* _tmp8_;
				GIcon* _tmp9_;
				GIcon* _tmp10_;
				GNotification* _tmp11_;
				GNotification* _tmp12_;
				BluetoothObexTransfer* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				BluetoothDevice* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GtkWidget* _tmp23_;
				GtkApplication* _tmp24_;
				GtkApplication* _tmp25_;
				GNotification* _tmp26_;
				_tmp6_ = self->priv->notification;
				_tmp7_ = ((BaseDialog*) self)->device_image;
				g_object_get (_tmp7_, "gicon", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				g_notification_set_icon (_tmp6_, _tmp10_);
				_g_object_unref0 (_tmp10_);
				_tmp11_ = self->priv->notification;
				g_notification_set_title (_tmp11_, _ ("File transfer failed"));
				_tmp12_ = self->priv->notification;
				_tmp13_ = ((BaseDialog*) self)->transfer;
				_tmp14_ = bluetooth_obex_transfer_get_name (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				_tmp17_ = ((BaseDialog*) self)->device;
				_tmp18_ = bluetooth_device_get_alias (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strdup_printf (_ ("File '%s' not received from %s"), _tmp16_, _tmp20_);
				_tmp22_ = _tmp21_;
				g_notification_set_body (_tmp12_, _tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp16_);
				_tmp23_ = gtk_widget_get_toplevel ((GtkWidget*) self);
				_tmp24_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_window_get_type (), GtkWindow));
				_tmp25_ = _tmp24_;
				_tmp26_ = self->priv->notification;
				g_application_send_notification ((GApplication*) _tmp25_, "org.buddiesofbudgie.bluetooth", _tmp26_);
				gtk_widget_destroy ((GtkWidget*) self);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("queued")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("active")))) {
		switch (0) {
			default:
			{
				gchar* name = NULL;
				BluetoothObexTransfer* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				BluetoothObexTransfer* _tmp33_;
				guint64 _tmp34_;
				guint64 _tmp35_;
				_tmp27_ = ((BaseDialog*) self)->transfer;
				_tmp28_ = bluetooth_obex_transfer_get_filename (_tmp27_);
				_tmp29_ = _tmp28_;
				name = _tmp29_;
				_tmp30_ = name;
				if (_tmp30_ != NULL) {
					const gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp31_ = name;
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (self->priv->file_name);
					self->priv->file_name = _tmp32_;
				}
				_tmp33_ = ((BaseDialog*) self)->transfer;
				_tmp34_ = bluetooth_obex_transfer_get_transferred (_tmp33_);
				_tmp35_ = _tmp34_;
				base_dialog_on_transfer_progress ((BaseDialog*) self, _tmp35_);
				_g_free0 (name);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("complete")))) {
		switch (0) {
			default:
			{
				{
					const gchar* _tmp36_;
					_tmp36_ = self->priv->file_name;
					file_receiver_move_to_downloads (self, _tmp36_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GNotification* _tmp37_;
					GtkImage* _tmp38_;
					GIcon* _tmp39_;
					GIcon* _tmp40_;
					GIcon* _tmp41_;
					GNotification* _tmp42_;
					GNotification* _tmp43_;
					BluetoothObexTransfer* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					BluetoothDevice* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					GError* _tmp52_;
					const gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					GtkWidget* _tmp56_;
					GtkApplication* _tmp57_;
					GtkApplication* _tmp58_;
					GNotification* _tmp59_;
					GError* _tmp60_;
					const gchar* _tmp61_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp37_ = self->priv->notification;
					_tmp38_ = ((BaseDialog*) self)->device_image;
					g_object_get (_tmp38_, "gicon", &_tmp39_, NULL);
					_tmp40_ = _tmp39_;
					_tmp41_ = _tmp40_;
					g_notification_set_icon (_tmp37_, _tmp41_);
					_g_object_unref0 (_tmp41_);
					_tmp42_ = self->priv->notification;
					g_notification_set_title (_tmp42_, _ ("File transfer failed"));
					_tmp43_ = self->priv->notification;
					_tmp44_ = ((BaseDialog*) self)->transfer;
					_tmp45_ = bluetooth_obex_transfer_get_name (_tmp44_);
					_tmp46_ = _tmp45_;
					_tmp47_ = _tmp46_;
					_tmp48_ = ((BaseDialog*) self)->device;
					_tmp49_ = bluetooth_device_get_alias (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = _tmp50_;
					_tmp52_ = e;
					_tmp53_ = _tmp52_->message;
					_tmp54_ = g_strdup_printf ("File '%s' from %s not received: %s", _tmp47_, _tmp51_, _tmp53_);
					_tmp55_ = _tmp54_;
					g_notification_set_body (_tmp43_, _ (_tmp55_));
					_g_free0 (_tmp55_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp47_);
					_tmp56_ = gtk_widget_get_toplevel ((GtkWidget*) self);
					_tmp57_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_window_get_type (), GtkWindow));
					_tmp58_ = _tmp57_;
					_tmp59_ = self->priv->notification;
					g_application_send_notification ((GApplication*) _tmp58_, "org.buddiesofbudgie.bluetooth", _tmp59_);
					_tmp60_ = e;
					_tmp61_ = _tmp60_->message;
					g_warning ("FileReceiver.vala:77: Error saving transferred file: %s", _tmp61_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				gtk_widget_destroy ((GtkWidget*) self);
				break;
			}
		}
	}
}

static void
file_receiver_move_to_downloads (FileReceiver* self,
                                 const gchar* path,
                                 GError** error)
{
	GFile* source = NULL;
	GFile* _tmp0_;
	gchar* file_name = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* dest = NULL;
	GFile* _tmp6_;
	GNotification* _tmp7_;
	GtkImage* _tmp8_;
	GIcon* _tmp9_;
	GIcon* _tmp10_;
	GIcon* _tmp11_;
	GNotification* _tmp12_;
	GNotification* _tmp13_;
	BluetoothDevice* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkWidget* _tmp22_;
	GtkApplication* _tmp23_;
	GtkApplication* _tmp24_;
	GNotification* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	source = _tmp0_;
	_tmp1_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp2_ = g_file_get_basename (source);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp1_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file_name = _tmp5_;
	_tmp6_ = file_receiver_get_save_name (self, file_name);
	dest = _tmp6_;
	g_file_move (source, dest, G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_g_free0 (file_name);
		_g_object_unref0 (source);
		return;
	}
	_tmp7_ = self->priv->notification;
	_tmp8_ = ((BaseDialog*) self)->device_image;
	g_object_get (_tmp8_, "gicon", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	g_notification_set_icon (_tmp7_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->notification;
	g_notification_set_title (_tmp12_, _ ("File transferred successfully"));
	_tmp13_ = self->priv->notification;
	_tmp14_ = ((BaseDialog*) self)->device;
	_tmp15_ = bluetooth_device_get_alias (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_get_path (dest);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf (_ ("Saved file from %s to '%s'"), _tmp17_, _tmp19_);
	_tmp21_ = _tmp20_;
	g_notification_set_body (_tmp13_, _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_tmp22_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp23_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_window_get_type (), GtkWindow));
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->notification;
	g_application_send_notification ((GApplication*) _tmp24_, "org.buddiesofbudgie.bluetooth", _tmp25_);
	_g_object_unref0 (dest);
	_g_free0 (file_name);
	_g_object_unref0 (source);
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GFile*
file_receiver_get_save_name (FileReceiver* self,
                             const gchar* uri)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* base_name = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gint ext_index = 0;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* name = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* ext = NULL;
	gchar* _tmp15_;
	gchar* time = NULL;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_file_new_for_path (uri);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		result = file;
		return result;
	}
	_tmp2_ = file;
	_tmp3_ = g_file_get_basename (_tmp2_);
	base_name = _tmp3_;
	_tmp4_ = base_name;
	ext_index = string_last_index_of (_tmp4_, ".", 0);
	if (ext_index == -1) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = base_name;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp7_;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = base_name;
		_tmp9_ = string_substring (_tmp8_, (glong) 0, (glong) ext_index);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = g_strdup (_tmp5_);
	name = _tmp10_;
	if (ext_index == -1) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp12_;
	} else {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = base_name;
		_tmp14_ = string_substring (_tmp13_, (glong) (ext_index + 1), (glong) -1);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp14_;
	}
	_tmp15_ = g_strdup (_tmp11_);
	ext = _tmp15_;
	_tmp16_ = g_date_time_new_now_local ();
	_tmp17_ = _tmp16_;
	_tmp18_ = g_date_time_format_iso8601 (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_date_time_unref0 (_tmp17_);
	time = _tmp19_;
	_tmp20_ = name;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = time;
	_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = ext;
	_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_file_new_for_path (_tmp28_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	result = _tmp30_;
	_g_free0 (time);
	_g_free0 (ext);
	_g_free0 (_tmp11_);
	_g_free0 (name);
	_g_free0 (_tmp5_);
	_g_free0 (base_name);
	_g_object_unref0 (file);
	return result;
}

const gchar*
file_receiver_get_session_path (FileReceiver* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session_path;
	result = _tmp0_;
	return result;
}

void
file_receiver_set_session_path (FileReceiver* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = file_receiver_get_session_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_session_path);
		self->priv->_session_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, file_receiver_properties[FILE_RECEIVER_SESSION_PATH_PROPERTY]);
	}
}

static GObject *
file_receiver_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FileReceiver * self;
	parent_class = G_OBJECT_CLASS (file_receiver_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_RECEIVER, FileReceiver);
	gtk_window_set_title ((GtkWindow*) self, _ ("Bluetooth File Transfer"));
	return obj;
}

static void
file_receiver_class_init (FileReceiverClass * klass,
                          gpointer klass_data)
{
	file_receiver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileReceiver_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_receiver_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_file_receiver_set_property;
	G_OBJECT_CLASS (klass)->constructor = file_receiver_constructor;
	G_OBJECT_CLASS (klass)->finalize = file_receiver_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_RECEIVER_SESSION_PATH_PROPERTY, file_receiver_properties[FILE_RECEIVER_SESSION_PATH_PROPERTY] = g_param_spec_string ("session-path", "session-path", "session-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
file_receiver_instance_init (FileReceiver * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	self->priv = file_receiver_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->file_name = _tmp0_;
}

static void
file_receiver_finalize (GObject * obj)
{
	FileReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_RECEIVER, FileReceiver);
	_g_free0 (self->priv->_session_path);
	_g_object_unref0 (self->priv->notification);
	_g_free0 (self->priv->file_name);
	G_OBJECT_CLASS (file_receiver_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
file_receiver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileReceiverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_receiver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileReceiver), 0, (GInstanceInitFunc) file_receiver_instance_init, NULL };
	GType file_receiver_type_id;
	file_receiver_type_id = g_type_register_static (TYPE_BASE_DIALOG, "FileReceiver", &g_define_type_info, 0);
	FileReceiver_private_offset = g_type_add_instance_private (file_receiver_type_id, sizeof (FileReceiverPrivate));
	return file_receiver_type_id;
}

GType
file_receiver_get_type (void)
{
	static volatile gsize file_receiver_type_id__once = 0;
	if (g_once_init_enter (&file_receiver_type_id__once)) {
		GType file_receiver_type_id;
		file_receiver_type_id = file_receiver_get_type_once ();
		g_once_init_leave (&file_receiver_type_id__once, file_receiver_type_id);
	}
	return file_receiver_type_id__once;
}

static void
_vala_file_receiver_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	FileReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_RECEIVER, FileReceiver);
	switch (property_id) {
		case FILE_RECEIVER_SESSION_PATH_PROPERTY:
		g_value_set_string (value, file_receiver_get_session_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_file_receiver_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	FileReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_RECEIVER, FileReceiver);
	switch (property_id) {
		case FILE_RECEIVER_SESSION_PATH_PROPERTY:
		file_receiver_set_session_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

