/* DeviceRow.c generated by valac 0.56.14, the Vala compiler
 * generated from DeviceRow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DEVICE_ROW (device_row_get_type ())
#define DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_ROW, DeviceRow))
#define DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_ROW, DeviceRowClass))
#define IS_DEVICE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_ROW))
#define IS_DEVICE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_ROW))
#define DEVICE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_ROW, DeviceRowClass))

typedef struct _DeviceRow DeviceRow;
typedef struct _DeviceRowClass DeviceRowClass;
typedef struct _DeviceRowPrivate DeviceRowPrivate;

#define BLUETOOTH_TYPE_ADAPTER (bluetooth_adapter_get_type ())
#define BLUETOOTH_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapter))
#define BLUETOOTH_IS_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_ADAPTER))
#define BLUETOOTH_ADAPTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_ADAPTER, BluetoothAdapterIface))

typedef struct _BluetoothAdapter BluetoothAdapter;
typedef struct _BluetoothAdapterIface BluetoothAdapterIface;

#define BLUETOOTH_TYPE_ADAPTER_PROXY (bluetooth_adapter_proxy_get_type ())

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())
enum  {
	DEVICE_ROW_0_PROPERTY,
	DEVICE_ROW_ADAPTER_PROPERTY,
	DEVICE_ROW_DEVICE_PROPERTY,
	DEVICE_ROW_NUM_PROPERTIES
};
static GParamSpec* device_row_properties[DEVICE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	DEVICE_ROW_SEND_CLICKED_SIGNAL,
	DEVICE_ROW_NUM_SIGNALS
};
static guint device_row_signals[DEVICE_ROW_NUM_SIGNALS] = {0};

struct _DeviceRow {
	GtkListBoxRow parent_instance;
	DeviceRowPrivate * priv;
};

struct _DeviceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BluetoothAdapterIface {
	GTypeInterface parent_iface;
	void (*remove_device) (BluetoothAdapter* self, const char* device, GError** error);
	void (*set_discovery_filter) (BluetoothAdapter* self, GHashTable* properties, GError** error);
	void (*start_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	void (*stop_discovery) (BluetoothAdapter* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_discovery_finish) (BluetoothAdapter* self, GAsyncResult* _res_, GError** error);
	gchar** (*get_UUIDs) (BluetoothAdapter* self, gint* result_length1);
	gboolean (*get_discoverable) (BluetoothAdapter* self);
	void (*set_discoverable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_discovering) (BluetoothAdapter* self);
	gboolean (*get_pairable) (BluetoothAdapter* self);
	void (*set_pairable) (BluetoothAdapter* self, gboolean value);
	gboolean (*get_powered) (BluetoothAdapter* self);
	void (*set_powered) (BluetoothAdapter* self, gboolean value);
	gchar* (*get_address) (BluetoothAdapter* self);
	gchar* (*get_alias) (BluetoothAdapter* self);
	void (*set_alias) (BluetoothAdapter* self, const gchar* value);
	gchar* (*get_modalias) (BluetoothAdapter* self);
	gchar* (*get_name) (BluetoothAdapter* self);
	guint (*get_class) (BluetoothAdapter* self);
	guint (*get_discoverable_timeout) (BluetoothAdapter* self);
	guint (*get_pairable_timeout) (BluetoothAdapter* self);
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _DeviceRowPrivate {
	BluetoothAdapter* _adapter;
	BluetoothDevice* _device;
	GtkButton* send_button;
	GtkLabel* state_label;
};

struct _Block4Data {
	int _ref_count_;
	DeviceRow* self;
	GtkImage* image;
	GtkLabel* label;
};

static gint DeviceRow_private_offset;
static gpointer device_row_parent_class = NULL;
static GtkSizeGroup* device_row_size_group;
static GtkSizeGroup* device_row_size_group = NULL;

VALA_EXTERN GType device_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeviceRow, g_object_unref)
VALA_EXTERN GType bluetooth_adapter_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_adapter_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
VALA_EXTERN GType bluetooth_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothAdapter, g_object_unref)
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
VALA_EXTERN DeviceRow* device_row_new (BluetoothDevice* device,
                           BluetoothAdapter* adapter);
VALA_EXTERN DeviceRow* device_row_construct (GType object_type,
                                 BluetoothDevice* device,
                                 BluetoothAdapter* adapter);
static gchar* device_row_get_name_from_icon (DeviceRow* self);
VALA_EXTERN BluetoothDevice* device_row_get_device (DeviceRow* self);
VALA_EXTERN gchar* bluetooth_device_get_icon (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
VALA_EXTERN BluetoothAdapter* device_row_get_adapter (DeviceRow* self);
static void device_row_set_adapter (DeviceRow* self,
                             BluetoothAdapter* value);
static void device_row_set_device (DeviceRow* self,
                            BluetoothDevice* value);
static GObject * device_row_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN gchar* bluetooth_device_get_alias (BluetoothDevice* self);
VALA_EXTERN gchar* bluetooth_device_get_name (BluetoothDevice* self);
VALA_EXTERN gboolean bluetooth_adapter_get_powered (BluetoothAdapter* self);
static void _device_row___lambda24_ (DeviceRow* self,
                              GVariant* changed,
                              gchar** invalid);
static void __device_row___lambda24__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                 GVariant* changed_properties,
                                                                 gchar** invalidated_properties,
                                                                 gpointer self);
static void _device_row___lambda25_ (Block4Data* _data4_,
                              GVariant* changed,
                              gchar** invalid);
static void __device_row___lambda25__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                 GVariant* changed_properties,
                                                                 gchar** invalidated_properties,
                                                                 gpointer self);
static void _device_row___lambda26_ (DeviceRow* self);
static void __device_row___lambda26__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void device_row_finalize (GObject * obj);
static GType device_row_get_type_once (void);
static void _vala_device_row_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_device_row_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static inline gpointer
device_row_get_instance_private (DeviceRow* self)
{
	return G_STRUCT_MEMBER_P (self, DeviceRow_private_offset);
}

DeviceRow*
device_row_construct (GType object_type,
                      BluetoothDevice* device,
                      BluetoothAdapter* adapter)
{
	DeviceRow * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (adapter != NULL, NULL);
	self = (DeviceRow*) g_object_new (object_type, "device", device, "adapter", adapter, NULL);
	return self;
}

DeviceRow*
device_row_new (BluetoothDevice* device,
                BluetoothAdapter* adapter)
{
	return device_row_construct (TYPE_DEVICE_ROW, device, adapter);
}

static gchar*
device_row_get_name_from_icon (DeviceRow* self)
{
	BluetoothDevice* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	static GQuark _tmp4_label3 = 0;
	static GQuark _tmp4_label4 = 0;
	static GQuark _tmp4_label5 = 0;
	static GQuark _tmp4_label6 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = bluetooth_device_get_icon (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	g_free (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("audio-card")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup (_ ("Speaker"));
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("input-gaming")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (_ ("Controller"));
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("input-keyboard")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup (_ ("Keyboard"));
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label3) ? _tmp4_label3 : (_tmp4_label3 = g_quark_from_static_string ("input-mouse")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (_ ("Mouse"));
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label4) ? _tmp4_label4 : (_tmp4_label4 = g_quark_from_static_string ("input-tablet")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup (_ ("Tablet"));
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label5) ? _tmp4_label5 : (_tmp4_label5 = g_quark_from_static_string ("input-touchpad")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup (_ ("Touchpad"));
				result = _tmp11_;
				return result;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label6) ? _tmp4_label6 : (_tmp4_label6 = g_quark_from_static_string ("phone")))) {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				_tmp12_ = g_strdup (_ ("Phone"));
				result = _tmp12_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				BluetoothDevice* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = self->priv->_device;
				_tmp14_ = bluetooth_device_get_address (_tmp13_);
				_tmp15_ = _tmp14_;
				result = _tmp15_;
				return result;
			}
		}
	}
}

BluetoothAdapter*
device_row_get_adapter (DeviceRow* self)
{
	BluetoothAdapter* result;
	BluetoothAdapter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_adapter;
	result = _tmp0_;
	return result;
}

static void
device_row_set_adapter (DeviceRow* self,
                        BluetoothAdapter* value)
{
	BluetoothAdapter* old_value;
	g_return_if_fail (self != NULL);
	old_value = device_row_get_adapter (self);
	if (old_value != value) {
		self->priv->_adapter = value;
		g_object_notify_by_pspec ((GObject *) self, device_row_properties[DEVICE_ROW_ADAPTER_PROPERTY]);
	}
}

BluetoothDevice*
device_row_get_device (DeviceRow* self)
{
	BluetoothDevice* result;
	BluetoothDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
device_row_set_device (DeviceRow* self,
                       BluetoothDevice* value)
{
	BluetoothDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = device_row_get_device (self);
	if (old_value != value) {
		BluetoothDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, device_row_properties[DEVICE_ROW_DEVICE_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		DeviceRow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->label);
		_g_object_unref0 (_data4_->image);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_device_row___lambda24_ (DeviceRow* self,
                         GVariant* changed,
                         gchar** invalid)
{
	GVariant* powered = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Powered", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	powered = _tmp3_;
	_tmp4_ = powered;
	if (_tmp4_ != NULL) {
		BluetoothAdapter* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->_adapter;
		_tmp6_ = bluetooth_adapter_get_powered (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_widget_set_sensitive ((GtkWidget*) self, _tmp7_);
	}
	_g_variant_unref0 (powered);
}

static void
__device_row___lambda24__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                            GVariant* changed_properties,
                                                            gchar** invalidated_properties,
                                                            gpointer self)
{
	_device_row___lambda24_ ((DeviceRow*) self, changed_properties, invalidated_properties);
}

static void
_device_row___lambda25_ (Block4Data* _data4_,
                         GVariant* changed,
                         gchar** invalid)
{
	DeviceRow* self;
	GVariant* name = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* icon = NULL;
	GVariantType* _tmp10_;
	GVariantType* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	self = _data4_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("s");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Alias", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ != NULL) {
		GtkLabel* _tmp5_;
		BluetoothDevice* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = _data4_->label;
		_tmp6_ = self->priv->_device;
		_tmp7_ = bluetooth_device_get_alias (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = g_variant_type_new ("s");
	_tmp11_ = _tmp10_;
	_tmp12_ = g_variant_lookup_value (changed, "Icon", _tmp11_);
	_tmp13_ = _tmp12_;
	_g_variant_type_free0 (_tmp11_);
	icon = _tmp13_;
	_tmp14_ = icon;
	if (_tmp14_ != NULL) {
		gchar* _tmp15_ = NULL;
		BluetoothDevice* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GtkImage* _tmp20_;
		_tmp16_ = self->priv->_device;
		_tmp17_ = bluetooth_device_get_icon (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp15_ = _tmp18_;
		if (_tmp15_ == NULL) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("bluetooth-active");
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp19_;
		}
		_tmp20_ = _data4_->image;
		g_object_set (_tmp20_, "icon-name", _tmp15_, NULL);
		_g_free0 (_tmp15_);
	}
	_g_variant_unref0 (icon);
	_g_variant_unref0 (name);
}

static void
__device_row___lambda25__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                            GVariant* changed_properties,
                                                            gchar** invalidated_properties,
                                                            gpointer self)
{
	_device_row___lambda25_ (self, changed_properties, invalidated_properties);
}

static void
_device_row___lambda26_ (DeviceRow* self)
{
	BluetoothDevice* _tmp0_;
	GtkWidget* _tmp1_;
	_tmp0_ = self->priv->_device;
	g_signal_emit (self, device_row_signals[DEVICE_ROW_SEND_CLICKED_SIGNAL], 0, _tmp0_);
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_destroy (_tmp1_);
}

static void
__device_row___lambda26__gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	_device_row___lambda26_ ((DeviceRow*) self);
}

static GObject *
device_row_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DeviceRow * self;
	Block4Data* _data4_;
	gchar* _tmp0_ = NULL;
	BluetoothDevice* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkImage* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	gchar* device_name = NULL;
	BluetoothDevice* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp28_;
	GtkLabel* _tmp29_ = NULL;
	gchar* _tmp30_;
	GtkButton* _tmp31_ = NULL;
	GtkSizeGroup* _tmp32_;
	GtkButton* _tmp33_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp34_ = NULL;
	GtkGrid* _tmp35_;
	GtkImage* _tmp36_;
	GtkGrid* _tmp37_;
	GtkLabel* _tmp38_;
	GtkGrid* _tmp39_;
	GtkLabel* _tmp40_;
	GtkGrid* _tmp41_;
	GtkButton* _tmp42_;
	GtkGrid* _tmp43_;
	BluetoothAdapter* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	BluetoothAdapter* _tmp47_;
	BluetoothDevice* _tmp48_;
	GtkLabel* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GtkButton* _tmp54_;
	parent_class = G_OBJECT_CLASS (device_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEVICE_ROW, DeviceRow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp1_ = self->priv->_device;
	_tmp2_ = bluetooth_device_get_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("bluetooth-active");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp5_);
	_data4_->image = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_use_markup (_tmp6_, TRUE);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->state_label);
	self->priv->state_label = _tmp6_;
	_tmp7_ = self->priv->_device;
	_tmp8_ = bluetooth_device_get_alias (_tmp7_);
	_tmp9_ = _tmp8_;
	device_name = _tmp9_;
	_tmp10_ = device_name;
	if (_tmp10_ == NULL) {
		BluetoothDevice* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
		_tmp11_ = self->priv->_device;
		_tmp12_ = bluetooth_device_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_ != NULL;
		_g_free0 (_tmp14_);
		if (_tmp15_) {
			BluetoothDevice* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = self->priv->_device;
			_tmp17_ = bluetooth_device_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (device_name);
			device_name = _tmp18_;
		} else {
			BluetoothDevice* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			_tmp19_ = self->priv->_device;
			_tmp20_ = bluetooth_device_get_icon (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_ != NULL;
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				gchar* _tmp24_;
				_tmp24_ = device_row_get_name_from_icon (self);
				_g_free0 (device_name);
				device_name = _tmp24_;
			} else {
				BluetoothDevice* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp25_ = self->priv->_device;
				_tmp26_ = bluetooth_device_get_address (_tmp25_);
				_tmp27_ = _tmp26_;
				_g_free0 (device_name);
				device_name = _tmp27_;
			}
		}
	}
	_tmp28_ = device_name;
	_tmp29_ = (GtkLabel*) gtk_label_new (_tmp28_);
	gtk_label_set_ellipsize (_tmp29_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp29_, TRUE);
	gtk_label_set_xalign (_tmp29_, (gfloat) 0);
	g_object_ref_sink (_tmp29_);
	_data4_->label = _tmp29_;
	_tmp30_ = g_strdup (_ ("Send"));
	_tmp31_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp31_, GTK_ALIGN_CENTER);
	gtk_button_set_label (_tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->send_button);
	self->priv->send_button = _tmp31_;
	_tmp32_ = device_row_size_group;
	_tmp33_ = self->priv->send_button;
	gtk_size_group_add_widget (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
	g_object_set ((GtkWidget*) _tmp34_, "margin", 6, NULL);
	gtk_grid_set_column_spacing (_tmp34_, 6);
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp34_, GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp34_);
	grid = _tmp34_;
	_tmp35_ = grid;
	_tmp36_ = _data4_->image;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 0, 0, 1, 2);
	_tmp37_ = grid;
	_tmp38_ = _data4_->label;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 1, 0, 1, 1);
	_tmp39_ = grid;
	_tmp40_ = self->priv->state_label;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 1, 1, 1, 1);
	_tmp41_ = grid;
	_tmp42_ = self->priv->send_button;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 4, 0, 1, 2);
	_tmp43_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp43_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp44_ = self->priv->_adapter;
	_tmp45_ = bluetooth_adapter_get_powered (_tmp44_);
	_tmp46_ = _tmp45_;
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp46_);
	_tmp47_ = self->priv->_adapter;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __device_row___lambda24__g_dbus_proxy_g_properties_changed, self, 0);
	_tmp48_ = self->priv->_device;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) __device_row___lambda25__g_dbus_proxy_g_properties_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp49_ = self->priv->state_label;
	_tmp50_ = device_row_get_name_from_icon (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_markup_printf_escaped ("<span font_size='small'>%s</span>", _tmp51_);
	_tmp53_ = _tmp52_;
	gtk_label_set_label (_tmp49_, _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp54_ = self->priv->send_button;
	g_signal_connect_object (_tmp54_, "clicked", (GCallback) __device_row___lambda26__gtk_button_clicked, self, 0);
	_g_object_unref0 (grid);
	_g_free0 (device_name);
	_g_free0 (_tmp0_);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
device_row_class_init (DeviceRowClass * klass,
                       gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	device_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DeviceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_device_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_device_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = device_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = device_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_ROW_ADAPTER_PROPERTY, device_row_properties[DEVICE_ROW_ADAPTER_PROPERTY] = g_param_spec_object ("adapter", "adapter", "adapter", BLUETOOTH_TYPE_ADAPTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_ROW_DEVICE_PROPERTY, device_row_properties[DEVICE_ROW_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", BLUETOOTH_TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	device_row_signals[DEVICE_ROW_SEND_CLICKED_SIGNAL] = g_signal_new ("send-clicked", TYPE_DEVICE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_TYPE_DEVICE);
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (device_row_size_group);
	device_row_size_group = _tmp0_;
}

static void
device_row_instance_init (DeviceRow * self,
                          gpointer klass)
{
	self->priv = device_row_get_instance_private (self);
}

static void
device_row_finalize (GObject * obj)
{
	DeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEVICE_ROW, DeviceRow);
	_g_object_unref0 (self->priv->_device);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->state_label);
	G_OBJECT_CLASS (device_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
device_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeviceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeviceRow), 0, (GInstanceInitFunc) device_row_instance_init, NULL };
	GType device_row_type_id;
	device_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "DeviceRow", &g_define_type_info, 0);
	DeviceRow_private_offset = g_type_add_instance_private (device_row_type_id, sizeof (DeviceRowPrivate));
	return device_row_type_id;
}

GType
device_row_get_type (void)
{
	static volatile gsize device_row_type_id__once = 0;
	if (g_once_init_enter (&device_row_type_id__once)) {
		GType device_row_type_id;
		device_row_type_id = device_row_get_type_once ();
		g_once_init_leave (&device_row_type_id__once, device_row_type_id);
	}
	return device_row_type_id__once;
}

static void
_vala_device_row_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	DeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEVICE_ROW, DeviceRow);
	switch (property_id) {
		case DEVICE_ROW_ADAPTER_PROPERTY:
		g_value_set_object (value, device_row_get_adapter (self));
		break;
		case DEVICE_ROW_DEVICE_PROPERTY:
		g_value_set_object (value, device_row_get_device (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_device_row_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	DeviceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DEVICE_ROW, DeviceRow);
	switch (property_id) {
		case DEVICE_ROW_ADAPTER_PROPERTY:
		device_row_set_adapter (self, g_value_get_object (value));
		break;
		case DEVICE_ROW_DEVICE_PROPERTY:
		device_row_set_device (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

