/* RunDialog.c generated by valac 0.56.14, the Vala compiler
 * generated from RunDialog.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "budgie-appindexer.h"
#include <theme-manager.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <budgie-config.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_DBUS_IMPL (budgie_dbus_impl_get_type ())
#define BUDGIE_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DBUS_IMPL, BudgieDBusImpl))
#define BUDGIE_IS_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DBUS_IMPL))
#define BUDGIE_DBUS_IMPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_DBUS_IMPL, BudgieDBusImplIface))

typedef struct _BudgieDBusImpl BudgieDBusImpl;
typedef struct _BudgieDBusImplIface BudgieDBusImplIface;

#define BUDGIE_TYPE_DBUS_IMPL_PROXY (budgie_dbus_impl_proxy_get_type ())
enum  {
	BUDGIE_DBUS_IMPL_NAME_OWNER_CHANGED_SIGNAL,
	BUDGIE_DBUS_IMPL_NUM_SIGNALS
};
static guint budgie_dbus_impl_signals[BUDGIE_DBUS_IMPL_NUM_SIGNALS] = {0};
typedef GDBusProxy BudgieDBusImplProxy;
typedef GDBusProxyClass BudgieDBusImplProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BudgieDbusImplListNamesReadyData BudgieDbusImplListNamesReadyData;

#define BUDGIE_TYPE_RUN_DIALOG (budgie_run_dialog_get_type ())
#define BUDGIE_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog))
#define BUDGIE_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))
#define BUDGIE_IS_RUN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_IS_RUN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG))
#define BUDGIE_RUN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialogClass))

typedef struct _BudgieRunDialog BudgieRunDialog;
typedef struct _BudgieRunDialogClass BudgieRunDialogClass;
typedef struct _BudgieRunDialogPrivate BudgieRunDialogPrivate;
enum  {
	BUDGIE_RUN_DIALOG_0_PROPERTY,
	BUDGIE_RUN_DIALOG_NUM_PROPERTIES
};
static GParamSpec* budgie_run_dialog_properties[BUDGIE_RUN_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_LAUNCHER_BUTTON (launcher_button_get_type ())
#define LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAUNCHER_BUTTON, LauncherButton))
#define LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAUNCHER_BUTTON, LauncherButtonClass))
#define IS_LAUNCHER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAUNCHER_BUTTON))
#define IS_LAUNCHER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAUNCHER_BUTTON))
#define LAUNCHER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAUNCHER_BUTTON, LauncherButtonClass))

typedef struct _LauncherButton LauncherButton;
typedef struct _LauncherButtonClass LauncherButtonClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgieRunDialogSetupDbusData BudgieRunDialogSetupDbusData;

#define BUDGIE_TYPE_RUN_DIALOG_APP (budgie_run_dialog_app_get_type ())
#define BUDGIE_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp))
#define BUDGIE_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))
#define BUDGIE_IS_RUN_DIALOG_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_IS_RUN_DIALOG_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RUN_DIALOG_APP))
#define BUDGIE_RUN_DIALOG_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogAppClass))

typedef struct _BudgieRunDialogApp BudgieRunDialogApp;
typedef struct _BudgieRunDialogAppClass BudgieRunDialogAppClass;
typedef struct _BudgieRunDialogAppPrivate BudgieRunDialogAppPrivate;
enum  {
	BUDGIE_RUN_DIALOG_APP_0_PROPERTY,
	BUDGIE_RUN_DIALOG_APP_NUM_PROPERTIES
};
static GParamSpec* budgie_run_dialog_app_properties[BUDGIE_RUN_DIALOG_APP_NUM_PROPERTIES];

struct _BudgieDBusImplIface {
	GTypeInterface parent_iface;
	void (*list_names) (BudgieDBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (BudgieDBusImpl* self, GAsyncResult* _res_, gint* result_length1, GError** error);
};

struct _BudgieDbusImplListNamesReadyData {
	GDBusMethodInvocation* _invocation_;
};

struct _BudgieRunDialog {
	GtkApplicationWindow parent_instance;
	BudgieRunDialogPrivate * priv;
};

struct _BudgieRunDialogClass {
	GtkApplicationWindowClass parent_class;
};

struct _BudgieRunDialogPrivate {
	GtkRevealer* bottom_revealer;
	GtkListBox* app_box;
	GtkSearchEntry* entry;
	gboolean focus_quit;
	BudgieDBusImpl* impl;
	gchar* search_term;
	BudgieRelevancyService* relevancy;
	BudgieThemeManager* theme_manager;
	gchar* wanted_dbus_id;
	GHashTable* active_names;
};

struct _BudgieRunDialogSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieRunDialog* self;
	BudgieDBusImpl* _tmp0_;
	BudgieDBusImpl* _tmp1_;
	BudgieDBusImpl* _tmp2_;
	gchar** _tmp3_;
	BudgieDBusImpl* _tmp4_;
	gint _tmp5_;
	gchar** _tmp6_;
	gint _tmp3__length1;
	gint __tmp3__size_;
	gchar** name_collection;
	gint name_collection_length1;
	gint _name_collection_size_;
	gint name_it;
	gchar* _tmp7_;
	gchar* name;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	BudgieDBusImpl* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _BudgieRunDialogApp {
	GtkApplication parent_instance;
	BudgieRunDialogAppPrivate * priv;
};

struct _BudgieRunDialogAppClass {
	GtkApplicationClass parent_class;
};

struct _BudgieRunDialogAppPrivate {
	BudgieRunDialog* rd;
};

static gint BudgieRunDialog_private_offset;
static gpointer budgie_run_dialog_parent_class = NULL;
static gint BudgieRunDialogApp_private_offset;
static gpointer budgie_run_dialog_app_parent_class = NULL;

VALA_EXTERN GType budgie_dbus_impl_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_dbus_impl_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType budgie_dbus_impl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieDBusImpl, g_object_unref)
VALA_EXTERN void budgie_dbus_impl_list_names (BudgieDBusImpl* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN gchar** budgie_dbus_impl_list_names_finish (BudgieDBusImpl* self,
                                            GAsyncResult* _res_,
                                            gint* result_length1,
                                            GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static GType budgie_dbus_impl_get_type_once (void);
static void budgie_dbus_impl_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static void _dbus_handle_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* self,
                                                       GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void budgie_dbus_impl_proxy_list_names_async (BudgieDBusImpl* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gchar** budgie_dbus_impl_proxy_list_names_finish (BudgieDBusImpl* self,
                                                  GAsyncResult* _res_,
                                                  gint* result_length1,
                                                  GError** error);
static void budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init (BudgieDBusImplIface* iface);
static void _dbus_budgie_dbus_impl_list_names (BudgieDBusImpl* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_dbus_impl_list_names_ready (GObject * source_object,
                                              GAsyncResult * _res_,
                                              gpointer _user_data_);
static void budgie_dbus_impl_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* budgie_dbus_impl_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean budgie_dbus_impl_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _dbus_budgie_dbus_impl_name_owner_changed (GObject* _sender,
                                                const gchar* name,
                                                const gchar* old_owner,
                                                const gchar* new_owner,
                                                gpointer* _data);
static void _budgie_dbus_impl_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_run_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRunDialog, g_object_unref)
VALA_EXTERN BudgieRunDialog* budgie_run_dialog_new (GtkApplication* app);
VALA_EXTERN BudgieRunDialog* budgie_run_dialog_construct (GType object_type,
                                              GtkApplication* app);
static void budgie_run_dialog_load_buttons (BudgieRunDialog* self);
VALA_EXTERN GType launcher_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LauncherButton, g_object_unref)
VALA_EXTERN LauncherButton* launcher_button_new (BudgieApplication* app);
VALA_EXTERN LauncherButton* launcher_button_construct (GType object_type,
                                           BudgieApplication* app);
VALA_EXTERN BudgieApplication* launcher_button_get_application (LauncherButton* self);
static void budgie_run_dialog_on_launched (BudgieRunDialog* self,
                                    GAppInfo* info,
                                    GVariant* v);
static void _budgie_run_dialog_on_launched_budgie_application_launched (BudgieApplication* _sender,
                                                                 GAppInfo* info,
                                                                 GVariant* platform_data,
                                                                 gpointer self);
static void budgie_run_dialog_on_launch_failed (BudgieRunDialog* self,
                                         const gchar* id);
static void _budgie_run_dialog_on_launch_failed_budgie_application_launch_failed (BudgieApplication* _sender,
                                                                           const gchar* startup_notify_id,
                                                                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void budgie_run_dialog_launch_button (BudgieRunDialog* self,
                                      LauncherButton* button);
static void budgie_run_dialog_check_dbus_name (BudgieRunDialog* self);
static void budgie_run_dialog_on_row_activate (BudgieRunDialog* self,
                                        GtkListBoxRow* row);
static void budgie_run_dialog_on_search_activate (BudgieRunDialog* self);
static void budgie_run_dialog_on_search_changed (BudgieRunDialog* self);
static gboolean budgie_run_dialog_on_filter (BudgieRunDialog* self,
                                      GtkListBoxRow* row);
static gint budgie_run_dialog_on_sort (BudgieRunDialog* self,
                                GtkListBoxRow* row1,
                                GtkListBoxRow* row2);
static gboolean budgie_run_dialog_on_key_release (BudgieRunDialog* self,
                                           GdkEventKey* btn);
static gboolean ___lambda4_ (BudgieRunDialog* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void budgie_run_dialog_on_name_owner_changed (BudgieRunDialog* self,
                                              const gchar* n,
                                              const gchar* o,
                                              const gchar* ne);
static void budgie_run_dialog_setup_dbus_data_free (gpointer _data);
VALA_EXTERN void budgie_run_dialog_setup_dbus (BudgieRunDialog* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void budgie_run_dialog_setup_dbus_finish (BudgieRunDialog* self,
                                          GAsyncResult* _res_);
static gboolean budgie_run_dialog_setup_dbus_co (BudgieRunDialogSetupDbusData* _data_);
static void budgie_run_dialog_setup_dbus_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void _budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* _sender,
                                                                                   const gchar* name,
                                                                                   const gchar* old_owner,
                                                                                   const gchar* new_owner,
                                                                                   gpointer self);
static GObject * budgie_run_dialog_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                gpointer self);
static void _budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender,
                                                               gpointer self);
static void _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self);
static gboolean _budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                gpointer self);
static gint _budgie_run_dialog_on_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                        GtkListBoxRow* row2,
                                                        gpointer self);
static gboolean _budgie_run_dialog___lambda5_ (BudgieRunDialog* self);
static gboolean __budgie_run_dialog___lambda5__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                    GdkEventFocus* event,
                                                                    gpointer self);
static gboolean _budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                         GdkEventKey* event,
                                                                         gpointer self);
static void budgie_run_dialog_finalize (GObject * obj);
static GType budgie_run_dialog_get_type_once (void);
VALA_EXTERN GType budgie_run_dialog_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRunDialogApp, g_object_unref)
VALA_EXTERN BudgieRunDialogApp* budgie_run_dialog_app_new (void);
VALA_EXTERN BudgieRunDialogApp* budgie_run_dialog_app_construct (GType object_type);
static void budgie_run_dialog_app_real_activate (GApplication* base);
static void budgie_run_dialog_app_finalize (GObject * obj);
static GType budgie_run_dialog_app_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_list_names_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_list_names_out[] = {&_budgie_dbus_impl_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _budgie_dbus_impl_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_list_names_out), NULL};
static const GDBusMethodInfo * const _budgie_dbus_impl_dbus_method_info[] = {&_budgie_dbus_impl_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_name = {-1, "name", "s", NULL};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s", NULL};
static const GDBusArgInfo _budgie_dbus_impl_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s", NULL};
static const GDBusArgInfo * const _budgie_dbus_impl_dbus_arg_info_name_owner_changed[] = {&_budgie_dbus_impl_dbus_arg_info_name_owner_changed_name, &_budgie_dbus_impl_dbus_arg_info_name_owner_changed_old_owner, &_budgie_dbus_impl_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _budgie_dbus_impl_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_budgie_dbus_impl_dbus_arg_info_name_owner_changed), NULL};
static const GDBusSignalInfo * const _budgie_dbus_impl_dbus_signal_info[] = {&_budgie_dbus_impl_dbus_signal_info_name_owner_changed, NULL};
static const GDBusPropertyInfo * const _budgie_dbus_impl_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_dbus_impl_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_budgie_dbus_impl_dbus_method_info), (GDBusSignalInfo **) (&_budgie_dbus_impl_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_dbus_impl_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_dbus_impl_dbus_interface_vtable = {budgie_dbus_impl_dbus_interface_method_call, budgie_dbus_impl_dbus_interface_get_property, budgie_dbus_impl_dbus_interface_set_property};

void
budgie_dbus_impl_list_names (BudgieDBusImpl* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	BudgieDBusImplIface* _iface_;
	_iface_ = BUDGIE_DBUS_IMPL_GET_INTERFACE (self);
	if (_iface_->list_names) {
		_iface_->list_names (self, _callback_, _user_data_);
	}
}

gchar**
budgie_dbus_impl_list_names_finish (BudgieDBusImpl* self,
                                    GAsyncResult* _res_,
                                    gint* result_length1,
                                    GError** error)
{
	BudgieDBusImplIface* _iface_;
	_iface_ = BUDGIE_DBUS_IMPL_GET_INTERFACE (self);
	if (_iface_->list_names_finish) {
		return _iface_->list_names_finish (self, _res_, result_length1, error);
	}
	return NULL;
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}

static void
budgie_dbus_impl_default_init (BudgieDBusImplIface * iface,
                               gpointer iface_data)
{
	budgie_dbus_impl_signals[BUDGIE_DBUS_IMPL_NAME_OWNER_CHANGED_SIGNAL] = g_signal_new ("name-owner-changed", BUDGIE_TYPE_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}

/**
* We need to probe the dbus daemon directly, hence this interface
*/
static GType
budgie_dbus_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieDBusImplIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_dbus_impl_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_dbus_impl_type_id;
	budgie_dbus_impl_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieDBusImpl", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_dbus_impl_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_dbus_impl_proxy_get_type);
	g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
	g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_dbus_impl_dbus_interface_info));
	g_type_set_qdata (budgie_dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_dbus_impl_register_object);
	return budgie_dbus_impl_type_id;
}

GType
budgie_dbus_impl_get_type (void)
{
	static volatile gsize budgie_dbus_impl_type_id__once = 0;
	if (g_once_init_enter (&budgie_dbus_impl_type_id__once)) {
		GType budgie_dbus_impl_type_id;
		budgie_dbus_impl_type_id = budgie_dbus_impl_get_type_once ();
		g_once_init_leave (&budgie_dbus_impl_type_id__once, budgie_dbus_impl_type_id);
	}
	return budgie_dbus_impl_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieDBusImplProxy, budgie_dbus_impl_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_DBUS_IMPL, budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init) )
static void
budgie_dbus_impl_proxy_class_init (BudgieDBusImplProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_dbus_impl_proxy_g_signal;
}

static void
_dbus_handle_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp0_;
	gchar* old_owner = NULL;
	GVariant* _tmp1_;
	gchar* new_owner = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}

static void
budgie_dbus_impl_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_budgie_dbus_impl_name_owner_changed ((BudgieDBusImpl*) proxy, parameters);
	}
}

static void
budgie_dbus_impl_proxy_init (BudgieDBusImplProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_dbus_impl_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
budgie_dbus_impl_proxy_list_names_async (BudgieDBusImpl* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar**
budgie_dbus_impl_proxy_list_names_finish (BudgieDBusImpl* self,
                                          GAsyncResult* _res_,
                                          gint* result_length1,
                                          GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length;
	gint _tmp4__size;
	gint _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, _tmp3_);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	_result_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	_result = _tmp4_;
	g_variant_unref (_tmp3_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
budgie_dbus_impl_proxy_budgie_dbus_impl_interface_init (BudgieDBusImplIface* iface)
{
	iface->list_names = budgie_dbus_impl_proxy_list_names_async;
	iface->list_names_finish = budgie_dbus_impl_proxy_list_names_finish;
}

static void
_dbus_budgie_dbus_impl_list_names (BudgieDBusImpl* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieDbusImplListNamesReadyData* _ready_data;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieDbusImplListNamesReadyData);
	_ready_data->_invocation_ = invocation;
	budgie_dbus_impl_list_names (self, (GAsyncReadyCallback) _dbus_budgie_dbus_impl_list_names_ready, _ready_data);
}

static void
_dbus_budgie_dbus_impl_list_names_ready (GObject * source_object,
                                         GAsyncResult * _res_,
                                         gpointer _user_data_)
{
	BudgieDbusImplListNamesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	gint _tmp9_;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = budgie_dbus_impl_list_names_finish ((BudgieDBusImpl*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("as"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		g_variant_builder_add_value (&_tmp8_, g_variant_new_string (*_tmp7_));
		_tmp7_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (BudgieDbusImplListNamesReadyData, _ready_data);
}

static void
budgie_dbus_impl_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_budgie_dbus_impl_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_dbus_impl_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_dbus_impl_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_dbus_impl_name_owner_changed (GObject* _sender,
                                           const gchar* name,
                                           const gchar* old_owner,
                                           const gchar* new_owner,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}

guint
budgie_dbus_impl_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_dbus_impl_dbus_interface_info), &_budgie_dbus_impl_dbus_interface_vtable, data, _budgie_dbus_impl_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_budgie_dbus_impl_name_owner_changed, data);
	return result;
}

static void
_budgie_dbus_impl_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_dbus_impl_name_owner_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_run_dialog_get_instance_private (BudgieRunDialog* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRunDialog_private_offset);
}

/**
 * Create a new budgie-run-dialog application window.
 */
BudgieRunDialog*
budgie_run_dialog_construct (GType object_type,
                             GtkApplication* app)
{
	BudgieRunDialog * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (BudgieRunDialog*) g_object_new (object_type, "application", app, "border-width", 0, "resizable", FALSE, "skip-pager-hint", TRUE, "skip-taskbar-hint", TRUE, "type-hint", GDK_WINDOW_TYPE_HINT_DIALOG, NULL);
	return self;
}

BudgieRunDialog*
budgie_run_dialog_new (GtkApplication* app)
{
	return budgie_run_dialog_construct (BUDGIE_TYPE_RUN_DIALOG, app);
}

/**
 * Create our launcher buttons from the Budgie AppIndexer.
 */
static void
_budgie_run_dialog_on_launched_budgie_application_launched (BudgieApplication* _sender,
                                                            GAppInfo* info,
                                                            GVariant* platform_data,
                                                            gpointer self)
{
	budgie_run_dialog_on_launched ((BudgieRunDialog*) self, info, platform_data);
}

static void
_budgie_run_dialog_on_launch_failed_budgie_application_launch_failed (BudgieApplication* _sender,
                                                                      const gchar* startup_notify_id,
                                                                      gpointer self)
{
	budgie_run_dialog_on_launch_failed ((BudgieRunDialog*) self, startup_notify_id);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
budgie_run_dialog_load_buttons (BudgieRunDialog* self)
{
	GList* added = NULL;
	BudgieAppIndex* index = NULL;
	BudgieAppIndex* _tmp0_;
	GeeArrayList* categories = NULL;
	BudgieAppIndex* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	added = NULL;
	_tmp0_ = budgie_app_index_get ();
	index = _tmp0_;
	_tmp1_ = index;
	_tmp2_ = budgie_app_index_get_categories (_tmp1_);
	categories = _tmp2_;
	{
		GeeArrayList* _category_list = NULL;
		GeeArrayList* _tmp3_;
		gint _category_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _category_index = 0;
		_tmp3_ = categories;
		_category_list = _tmp3_;
		_tmp4_ = _category_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_category_size = _tmp6_;
		_category_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BudgieCategory* category = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			_category_index = _category_index + 1;
			_tmp7_ = _category_index;
			_tmp8_ = _category_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _category_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _category_index);
			category = (BudgieCategory*) _tmp10_;
			{
				GeeArrayList* _a_list = NULL;
				BudgieCategory* _tmp11_;
				GeeArrayList* _tmp12_;
				GeeArrayList* _tmp13_;
				gint _a_size = 0;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _a_index = 0;
				_tmp11_ = category;
				_tmp12_ = budgie_category_get_apps (_tmp11_);
				_tmp13_ = _tmp12_;
				_a_list = _tmp13_;
				_tmp14_ = _a_list;
				_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_a_size = _tmp16_;
				_a_index = -1;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					BudgieApplication* a = NULL;
					GeeArrayList* _tmp19_;
					gpointer _tmp20_;
					BudgieApplication* _tmp21_;
					gboolean _tmp22_;
					gboolean _tmp23_;
					GList* _tmp24_;
					BudgieApplication* _tmp25_;
					GList* _tmp26_;
					LauncherButton* button = NULL;
					BudgieApplication* _tmp27_;
					LauncherButton* _tmp28_;
					LauncherButton* _tmp29_;
					BudgieApplication* _tmp30_;
					BudgieApplication* _tmp31_;
					LauncherButton* _tmp32_;
					BudgieApplication* _tmp33_;
					BudgieApplication* _tmp34_;
					BudgieApplication* _tmp35_;
					BudgieApplication* _tmp36_;
					GtkListBox* _tmp37_;
					LauncherButton* _tmp38_;
					_a_index = _a_index + 1;
					_tmp17_ = _a_index;
					_tmp18_ = _a_size;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = _a_list;
					_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _a_index);
					a = (BudgieApplication*) _tmp20_;
					_tmp21_ = a;
					_tmp22_ = budgie_application_get_should_show (_tmp21_);
					_tmp23_ = _tmp22_;
					if (!_tmp23_) {
						_g_object_unref0 (a);
						continue;
					}
					_tmp24_ = added;
					_tmp25_ = a;
					_tmp26_ = g_list_find (_tmp24_, _tmp25_);
					if (_tmp26_ != NULL) {
						_g_object_unref0 (a);
						continue;
					}
					_tmp27_ = a;
					_tmp28_ = launcher_button_new (_tmp27_);
					g_object_ref_sink (_tmp28_);
					button = _tmp28_;
					_tmp29_ = button;
					_tmp30_ = launcher_button_get_application (_tmp29_);
					_tmp31_ = _tmp30_;
					g_signal_connect_object (_tmp31_, "launched", (GCallback) _budgie_run_dialog_on_launched_budgie_application_launched, self, 0);
					_tmp32_ = button;
					_tmp33_ = launcher_button_get_application (_tmp32_);
					_tmp34_ = _tmp33_;
					g_signal_connect_object (_tmp34_, "launch-failed", (GCallback) _budgie_run_dialog_on_launch_failed_budgie_application_launch_failed, self, 0);
					_tmp35_ = a;
					_tmp36_ = _g_object_ref0 (_tmp35_);
					added = g_list_append (added, _tmp36_);
					_tmp37_ = self->priv->app_box;
					_tmp38_ = button;
					gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
					_g_object_unref0 (button);
					_g_object_unref0 (a);
				}
			}
			_g_object_unref0 (category);
		}
	}
	_g_object_unref0 (categories);
	_g_object_unref0 (index);
	(added == NULL) ? NULL : (added = (_g_list_free__g_object_unref0_ (added), NULL));
}

/**
 * Launch the given preconfigured button.
 *
 * This does additional DBus checking for apps to try to make
 * sure they actually launched. That is because some apps are
 * activated by DBus and the API lies about when the application
 * starts, causing us to not actually launch the app before
 * quitting.
 */
static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
budgie_run_dialog_launch_button (BudgieRunDialog* self,
                                 LauncherButton* button)
{
	BudgieApplication* app = NULL;
	BudgieApplication* _tmp0_;
	BudgieApplication* _tmp1_;
	BudgieApplication* _tmp2_;
	gchar** splits = NULL;
	BudgieApplication* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint splits_length1;
	gint _splits_size_;
	BudgieApplication* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	BudgieApplication* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = launcher_button_get_application (button);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	app = _tmp2_;
	self->priv->focus_quit = FALSE;
	_tmp3_ = app;
	_tmp4_ = budgie_application_get_desktop_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ".desktop", 0);
	splits = _tmp7_;
	splits_length1 = _vala_array_length (_tmp6_);
	_splits_size_ = splits_length1;
	_tmp8_ = app;
	_tmp9_ = budgie_application_get_dbus_activatable (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		_tmp11_ = splits;
		_tmp11__length1 = splits_length1;
		_tmp12_ = splits;
		_tmp12__length1 = splits_length1;
		_tmp13_ = _vala_g_strjoinv (".desktop", _tmp11_ + 0, (gint) ((_tmp12__length1 - 1) - 0));
		_g_free0 (self->priv->wanted_dbus_id);
		self->priv->wanted_dbus_id = _tmp13_;
	}
	_tmp14_ = app;
	if (budgie_application_launch (_tmp14_)) {
		budgie_run_dialog_check_dbus_name (self);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		BudgieApplication* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GtkApplication* _tmp18_;
		GtkApplication* _tmp19_;
		_tmp15_ = app;
		_tmp16_ = budgie_application_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		g_warning ("RunDialog.vala:209: Failed to launch application '%s'", _tmp17_);
		_tmp18_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp19_ = _tmp18_;
		g_application_quit ((GApplication*) _tmp19_);
	}
	splits = (_vala_array_free (splits, splits_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (app);
}

/**
* Handle click/<enter> activation on the main list
*/
static void
budgie_run_dialog_on_row_activate (BudgieRunDialog* self,
                                   GtkListBoxRow* row)
{
	LauncherButton* child = NULL;
	GtkWidget* _tmp0_;
	LauncherButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (row, gtk_bin_get_type (), GtkBin));
	_tmp1_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp0_) ? ((LauncherButton*) _tmp0_) : NULL);
	child = _tmp1_;
	budgie_run_dialog_launch_button (self, child);
	_g_object_unref0 (child);
}

/**
* Handle <enter> activation on the search
*/
static void
budgie_run_dialog_on_search_activate (BudgieRunDialog* self)
{
	LauncherButton* button = NULL;
	GtkListBoxRow* selected = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	LauncherButton* _tmp15_;
	LauncherButton* _tmp16_;
	BudgieApplication* _tmp17_;
	BudgieApplication* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	LauncherButton* _tmp21_;
	g_return_if_fail (self != NULL);
	budgie_run_dialog_on_search_changed (self);
	button = NULL;
	_tmp0_ = self->priv->app_box;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selected = _tmp2_;
	_tmp3_ = selected;
	if (_tmp3_ != NULL) {
		GtkListBoxRow* _tmp4_;
		GtkWidget* _tmp5_;
		LauncherButton* _tmp6_;
		_tmp4_ = selected;
		_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
		_tmp6_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp5_) ? ((LauncherButton*) _tmp5_) : NULL);
		_g_object_unref0 (button);
		button = _tmp6_;
	} else {
		GtkListBox* _tmp7_;
		GList* _tmp8_;
		_tmp7_ = self->priv->app_box;
		_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
		{
			GList* row_collection = NULL;
			GList* row_it = NULL;
			row_collection = _tmp8_;
			for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
				GtkWidget* row = NULL;
				row = (GtkWidget*) row_it->data;
				{
					gboolean _tmp9_ = FALSE;
					GtkWidget* _tmp10_;
					_tmp10_ = row;
					if (gtk_widget_get_visible (_tmp10_)) {
						GtkWidget* _tmp11_;
						_tmp11_ = row;
						_tmp9_ = gtk_widget_get_child_visible (_tmp11_);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						GtkWidget* _tmp12_;
						GtkWidget* _tmp13_;
						LauncherButton* _tmp14_;
						_tmp12_ = row;
						_tmp13_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_bin_get_type (), GtkBin));
						_tmp14_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp13_) ? ((LauncherButton*) _tmp13_) : NULL);
						_g_object_unref0 (button);
						button = _tmp14_;
						break;
					}
				}
			}
			(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
		}
	}
	_tmp15_ = button;
	if (_tmp15_ == NULL) {
		_g_object_unref0 (selected);
		_g_object_unref0 (button);
		return;
	}
	_tmp16_ = button;
	_tmp17_ = launcher_button_get_application (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = budgie_application_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	g_debug ("RunDialog.vala:247: launching '%s'", _tmp20_);
	_tmp21_ = button;
	budgie_run_dialog_launch_button (self, _tmp21_);
	_g_object_unref0 (selected);
	_g_object_unref0 (button);
}

static void
budgie_run_dialog_on_search_changed (BudgieRunDialog* self)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkListBox* _tmp3_;
	GList* _tmp4_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	GtkWidget* active_row = NULL;
	GtkListBox* _tmp15_;
	GList* _tmp16_;
	GtkWidget* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->search_term);
	self->priv->search_term = _tmp2_;
	_tmp3_ = self->priv->app_box;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp4_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				LauncherButton* button = NULL;
				GtkWidget* _tmp5_;
				GtkWidget* _tmp6_;
				LauncherButton* _tmp7_;
				BudgieRelevancyService* _tmp8_;
				LauncherButton* _tmp9_;
				BudgieApplication* _tmp10_;
				BudgieApplication* _tmp11_;
				const gchar* _tmp12_;
				_tmp5_ = row;
				_tmp6_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_bin_get_type (), GtkBin));
				_tmp7_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp6_) ? ((LauncherButton*) _tmp6_) : NULL);
				button = _tmp7_;
				_tmp8_ = self->priv->relevancy;
				_tmp9_ = button;
				_tmp10_ = launcher_button_get_application (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = self->priv->search_term;
				budgie_relevancy_service_update_relevancy (_tmp8_, _tmp11_, _tmp12_);
				_g_object_unref0 (button);
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	_tmp13_ = self->priv->app_box;
	gtk_list_box_invalidate_filter (_tmp13_);
	_tmp14_ = self->priv->app_box;
	gtk_list_box_invalidate_sort (_tmp14_);
	active_row = NULL;
	_tmp15_ = self->priv->app_box;
	_tmp16_ = gtk_container_get_children ((GtkContainer*) _tmp15_);
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp16_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				gboolean _tmp17_ = FALSE;
				GtkWidget* _tmp18_;
				_tmp18_ = row;
				if (gtk_widget_get_visible (_tmp18_)) {
					GtkWidget* _tmp19_;
					_tmp19_ = row;
					_tmp17_ = gtk_widget_get_child_visible (_tmp19_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					GtkWidget* _tmp20_;
					GtkWidget* _tmp21_;
					_tmp20_ = row;
					_tmp21_ = _g_object_ref0 (_tmp20_);
					_g_object_unref0 (active_row);
					active_row = _tmp21_;
					break;
				}
			}
		}
		(row_collection == NULL) ? NULL : (row_collection = (g_list_free (row_collection), NULL));
	}
	_tmp22_ = active_row;
	if (_tmp22_ == NULL) {
		GtkRevealer* _tmp23_;
		_tmp23_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp23_, FALSE);
	} else {
		GtkRevealer* _tmp24_;
		GtkListBox* _tmp25_;
		GtkWidget* _tmp26_;
		_tmp24_ = self->priv->bottom_revealer;
		gtk_revealer_set_reveal_child (_tmp24_, TRUE);
		_tmp25_ = self->priv->app_box;
		_tmp26_ = active_row;
		gtk_list_box_select_row (_tmp25_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gtk_list_box_row_get_type ()) ? ((GtkListBoxRow*) _tmp26_) : NULL);
	}
	_g_object_unref0 (active_row);
}

/**
* Filter the list based on the application's relevancy to
* the current search, if one is ongoing.
*/
static gboolean
budgie_run_dialog_on_filter (BudgieRunDialog* self,
                             GtkListBoxRow* row)
{
	LauncherButton* button = NULL;
	GtkWidget* _tmp0_;
	LauncherButton* _tmp1_;
	const gchar* _tmp2_;
	BudgieRelevancyService* _tmp3_;
	LauncherButton* _tmp4_;
	BudgieApplication* _tmp5_;
	BudgieApplication* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp0_) ? ((LauncherButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = self->priv->search_term;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		result = FALSE;
		_g_object_unref0 (button);
		return result;
	}
	_tmp3_ = self->priv->relevancy;
	_tmp4_ = button;
	_tmp5_ = launcher_button_get_application (_tmp4_);
	_tmp6_ = _tmp5_;
	result = budgie_relevancy_service_is_app_relevant (_tmp3_, _tmp6_);
	_g_object_unref0 (button);
	return result;
}

/**
 * Sort rows based on their relevancy score.
 *
 * Copied from BudgieMenu.
 */
static gint
budgie_run_dialog_on_sort (BudgieRunDialog* self,
                           GtkListBoxRow* row1,
                           GtkListBoxRow* row2)
{
	LauncherButton* btn1 = NULL;
	GtkWidget* _tmp0_;
	LauncherButton* _tmp1_;
	LauncherButton* btn2 = NULL;
	GtkWidget* _tmp2_;
	LauncherButton* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp0_) ? ((LauncherButton*) _tmp0_) : NULL);
	btn1 = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp3_ = _g_object_ref0 (IS_LAUNCHER_BUTTON (_tmp2_) ? ((LauncherButton*) _tmp2_) : NULL);
	btn2 = _tmp3_;
	_tmp4_ = self->priv->search_term;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		gint sc1 = 0;
		BudgieRelevancyService* _tmp7_;
		LauncherButton* _tmp8_;
		BudgieApplication* _tmp9_;
		BudgieApplication* _tmp10_;
		gint sc2 = 0;
		BudgieRelevancyService* _tmp11_;
		LauncherButton* _tmp12_;
		BudgieApplication* _tmp13_;
		BudgieApplication* _tmp14_;
		_tmp7_ = self->priv->relevancy;
		_tmp8_ = btn1;
		_tmp9_ = launcher_button_get_application (_tmp8_);
		_tmp10_ = _tmp9_;
		sc1 = budgie_relevancy_service_get_score (_tmp7_, _tmp10_);
		_tmp11_ = self->priv->relevancy;
		_tmp12_ = btn2;
		_tmp13_ = launcher_button_get_application (_tmp12_);
		_tmp14_ = _tmp13_;
		sc2 = budgie_relevancy_service_get_score (_tmp11_, _tmp14_);
		if (sc1 < sc2) {
			result = -1;
			_g_object_unref0 (btn2);
			_g_object_unref0 (btn1);
			return result;
		} else {
			if (sc1 > sc2) {
				result = 1;
				_g_object_unref0 (btn2);
				_g_object_unref0 (btn1);
				return result;
			}
		}
		result = 0;
		_g_object_unref0 (btn2);
		_g_object_unref0 (btn1);
		return result;
	}
	result = 0;
	_g_object_unref0 (btn2);
	_g_object_unref0 (btn1);
	return result;
}

/**
* Be a good citizen and pretend to be a dialog.
*/
static gboolean
___lambda4_ (BudgieRunDialog* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((BudgieRunDialog*) self);
	return result;
}

static gboolean
budgie_run_dialog_on_key_release (BudgieRunDialog* self,
                                  GdkEventKey* btn)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (btn != NULL, FALSE);
	if (btn->keyval == GDK_KEY_Escape) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

/**
* Handle startup notification, mark it done, quit
* We may not get the ID but we'll be told it's launched
*/
static void
budgie_run_dialog_on_launched (BudgieRunDialog* self,
                               GAppInfo* info,
                               GVariant* v)
{
	GVariant* elem = NULL;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp0_;
	GtkApplication* _tmp14_;
	GtkApplication* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (v != NULL);
	g_debug ("RunDialog.vala:347: on_launched called");
	_tmp0_ = g_variant_iter_new (v);
	iter = _tmp0_;
	while (TRUE) {
		GVariantIter* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		gchar* key = NULL;
		GVariant* val = NULL;
		GVariant* _tmp4_;
		gchar* _tmp5_ = NULL;
		GVariant* _tmp6_ = NULL;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		const GVariantType* _tmp9_;
		const gchar* _tmp10_;
		GdkDisplay* _tmp11_;
		GVariant* _tmp12_;
		const gchar* _tmp13_;
		_tmp1_ = iter;
		_tmp2_ = g_variant_iter_next_value (_tmp1_);
		_g_variant_unref0 (elem);
		elem = _tmp2_;
		_tmp3_ = elem;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		key = NULL;
		val = NULL;
		_tmp4_ = elem;
		g_variant_get (_tmp4_, "{sv}", &_tmp5_, &_tmp6_, NULL);
		_g_free0 (key);
		key = _tmp5_;
		_g_variant_unref0 (val);
		val = _tmp6_;
		_tmp7_ = key;
		if (_tmp7_ == NULL) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp8_ = val;
		_tmp9_ = G_VARIANT_TYPE_STRING;
		if (!g_variant_is_of_type (_tmp8_, _tmp9_)) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp10_ = key;
		if (g_strcmp0 (_tmp10_, "startup-notification-id") != 0) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp11_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp12_ = val;
		_tmp13_ = g_variant_get_string (_tmp12_, NULL);
		gdk_display_notify_startup_complete (_tmp11_, _tmp13_);
		_g_variant_unref0 (val);
		_g_free0 (key);
	}
	_tmp14_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp15_ = _tmp14_;
	g_application_quit ((GApplication*) _tmp15_);
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (elem);
}

/**
* Set the ID if it exists, quit regardless
*/
static void
budgie_run_dialog_on_launch_failed (BudgieRunDialog* self,
                                    const gchar* id)
{
	GdkDisplay* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	gdk_display_notify_startup_complete (_tmp0_, id);
	_tmp1_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	g_application_quit ((GApplication*) _tmp2_);
}

static void
budgie_run_dialog_on_name_owner_changed (BudgieRunDialog* self,
                                         const gchar* n,
                                         const gchar* o,
                                         const gchar* ne)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (o, "") == 0) {
		GHashTable* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->active_names;
		_tmp1_ = g_strdup (n);
		g_hash_table_insert (_tmp0_, _tmp1_, (gpointer) ((gintptr) TRUE));
		budgie_run_dialog_check_dbus_name (self);
	} else {
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->active_names;
		if (g_hash_table_contains (_tmp2_, n)) {
			GHashTable* _tmp3_;
			_tmp3_ = self->priv->active_names;
			g_hash_table_remove (_tmp3_, n);
		}
	}
}

/**
* Check if our dbus name appeared. if it did, bugger off.
*/
static void
budgie_run_dialog_check_dbus_name (BudgieRunDialog* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->wanted_dbus_id;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GHashTable* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->active_names;
		_tmp3_ = self->priv->wanted_dbus_id;
		_tmp0_ = g_hash_table_contains (_tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkApplication* _tmp4_;
		GtkApplication* _tmp5_;
		_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp5_ = _tmp4_;
		g_application_quit ((GApplication*) _tmp5_);
	}
}

static void
budgie_run_dialog_setup_dbus_data_free (gpointer _data)
{
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieRunDialogSetupDbusData, _data_);
}

void
budgie_run_dialog_setup_dbus (BudgieRunDialog* self,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BudgieRunDialogSetupDbusData* _data_;
	BudgieRunDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgieRunDialogSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_run_dialog_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_run_dialog_setup_dbus_co (_data_);
}

void
budgie_run_dialog_setup_dbus_finish (BudgieRunDialog* self,
                                     GAsyncResult* _res_)
{
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
* Do basic dbus initialisation
*/
static void
budgie_run_dialog_setup_dbus_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BudgieRunDialogSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_run_dialog_setup_dbus_co (_data_);
}

static void
_budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed (BudgieDBusImpl* _sender,
                                                                              const gchar* name,
                                                                              const gchar* old_owner,
                                                                              const gchar* new_owner,
                                                                              gpointer self)
{
	budgie_run_dialog_on_name_owner_changed ((BudgieRunDialog*) self, name, old_owner, new_owner);
}

static gboolean
budgie_run_dialog_setup_dbus_co (BudgieRunDialogSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_DBUS_IMPL_PROXY, 0, NULL, budgie_run_dialog_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.DBus", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/freedesktop/DBus", "g-interface-name", "org.freedesktop.DBus", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (BudgieDBusImpl*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (BudgieDBusImpl*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->impl);
		_data_->self->priv->impl = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->impl;
		_data_->_tmp5_ = 0;
		_data_->_state_ = 2;
		budgie_dbus_impl_list_names (_data_->_tmp4_, budgie_run_dialog_setup_dbus_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = budgie_dbus_impl_list_names_finish (_data_->_tmp4_, _data_->_res_, &_data_->_tmp5_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp6_;
		_data_->_tmp3__length1 = _data_->_tmp5_;
		_data_->__tmp3__size_ = _data_->_tmp3__length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		{
			_data_->name_collection_length1 = 0;
			_data_->_name_collection_size_ = 0;
			_data_->name_collection = _data_->_tmp3_;
			_data_->name_collection_length1 = _data_->_tmp3__length1;
			for (_data_->name_it = 0; _data_->name_it < _data_->name_collection_length1; _data_->name_it = _data_->name_it + 1) {
				_data_->_tmp7_ = g_strdup (_data_->name_collection[_data_->name_it]);
				_data_->name = _data_->_tmp7_;
				{
					_data_->_tmp8_ = _data_->self->priv->active_names;
					_data_->_tmp9_ = _data_->name;
					_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
					g_hash_table_insert (_data_->_tmp8_, _data_->_tmp10_, (gpointer) ((gintptr) TRUE));
					_g_free0 (_data_->name);
				}
			}
		}
		_data_->_tmp11_ = _data_->self->priv->impl;
		g_signal_connect_object (_data_->_tmp11_, "name-owner-changed", (GCallback) _budgie_run_dialog_on_name_owner_changed_budgie_dbus_impl_name_owner_changed, _data_->self, 0);
		_data_->_tmp3_ = (_vala_array_free (_data_->_tmp3_, _data_->_tmp3__length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp12_ = _data_->e;
		_data_->_tmp13_ = _data_->_tmp12_->message;
		g_warning ("RunDialog.vala:417: Failed to initialise dbus: %s", _data_->_tmp13_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_budgie_run_dialog_on_search_changed_gtk_editable_changed (GtkEditable* _sender,
                                                           gpointer self)
{
	budgie_run_dialog_on_search_changed ((BudgieRunDialog*) self);
}

static void
_budgie_run_dialog_on_search_activate_gtk_entry_activate (GtkEntry* _sender,
                                                          gpointer self)
{
	budgie_run_dialog_on_search_activate ((BudgieRunDialog*) self);
}

static void
_budgie_run_dialog_on_row_activate_gtk_list_box_row_activated (GtkListBox* _sender,
                                                               GtkListBoxRow* row,
                                                               gpointer self)
{
	budgie_run_dialog_on_row_activate ((BudgieRunDialog*) self, row);
}

static gboolean
_budgie_run_dialog_on_filter_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                       gpointer self)
{
	gboolean result;
	result = budgie_run_dialog_on_filter ((BudgieRunDialog*) self, row);
	return result;
}

static gint
_budgie_run_dialog_on_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                   GtkListBoxRow* row2,
                                                   gpointer self)
{
	gint result;
	result = budgie_run_dialog_on_sort ((BudgieRunDialog*) self, row1, row2);
	return result;
}

static gboolean
_budgie_run_dialog___lambda5_ (BudgieRunDialog* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	if (!self->priv->focus_quit) {
		result = GDK_EVENT_STOP;
		return result;
	}
	g_debug ("RunDialog.vala:124: quiting from focus_out_event");
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_quit ((GApplication*) _tmp1_);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__budgie_run_dialog___lambda5__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                           GdkEventFocus* event,
                                                           gpointer self)
{
	gboolean result;
	result = _budgie_run_dialog___lambda5_ ((BudgieRunDialog*) self);
	return result;
}

static gboolean
_budgie_run_dialog_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self)
{
	gboolean result;
	result = budgie_run_dialog_on_key_release ((BudgieRunDialog*) self, event);
	return result;
}

static GObject *
budgie_run_dialog_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieRunDialog * self;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	GtkStyleContext* _tmp6_;
	BudgieRelevancyService* _tmp7_;
	BudgieThemeManager* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp12_;
	GtkEventBox* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkEventBox* _tmp15_;
	GtkBox* main_layout = NULL;
	GtkBox* _tmp16_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkSearchEntry* _tmp20_;
	GtkSearchEntry* _tmp21_;
	GtkSearchEntry* _tmp22_;
	GtkSearchEntry* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkBox* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtkRevealer* _tmp27_ = NULL;
	GtkListBox* _tmp28_ = NULL;
	GtkListBox* _tmp29_;
	GtkListBox* _tmp30_;
	GtkListBox* _tmp31_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp32_ = NULL;
	GtkScrolledWindow* _tmp33_;
	GtkStyleContext* _tmp34_;
	GtkScrolledWindow* _tmp35_;
	GtkListBox* _tmp36_;
	GtkRevealer* _tmp37_;
	GtkScrolledWindow* _tmp38_;
	GtkBox* _tmp39_;
	GtkRevealer* _tmp40_;
	GtkBox* _tmp41_;
	GtkRevealer* _tmp42_;
	gint x = 0;
	gint y = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	GdkMonitor* monitor = NULL;
	GdkScreen* _tmp45_;
	GdkDisplay* _tmp46_;
	GdkMonitor* _tmp47_;
	GdkMonitor* _tmp48_;
	GdkRectangle rect = {0};
	GdkMonitor* _tmp49_;
	GdkRectangle _tmp50_ = {0};
	gint width = 0;
	GdkRectangle _tmp51_;
	parent_class = G_OBJECT_CLASS (budgie_run_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "budgie-run-dialog");
	_tmp7_ = budgie_relevancy_service_new ();
	_g_object_unref0 (self->priv->relevancy);
	self->priv->relevancy = _tmp7_;
	_tmp8_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->active_names);
	self->priv->active_names = _tmp11_;
	_tmp12_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp12_);
	header = _tmp12_;
	_tmp13_ = header;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	gtk_style_context_remove_class (_tmp14_, "titlebar");
	_tmp15_ = header;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp16_);
	main_layout = _tmp16_;
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp17_);
	hbox = _tmp17_;
	_tmp18_ = main_layout;
	_tmp19_ = hbox;
	gtk_box_pack_start (_tmp18_, (GtkWidget*) _tmp19_, FALSE, FALSE, (guint) 0);
	_tmp20_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp20_;
	_tmp21_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp21_, "changed", (GCallback) _budgie_run_dialog_on_search_changed_gtk_editable_changed, self, 0);
	_tmp22_ = self->priv->entry;
	g_signal_connect_object ((GtkEntry*) _tmp22_, "activate", (GCallback) _budgie_run_dialog_on_search_activate_gtk_entry_activate, self, 0);
	_tmp23_ = self->priv->entry;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_set_junction_sides (_tmp24_, GTK_JUNCTION_BOTTOM);
	_tmp25_ = hbox;
	_tmp26_ = self->priv->entry;
	gtk_box_pack_start (_tmp25_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp27_, FALSE);
	gtk_revealer_set_transition_duration (_tmp27_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp27_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->bottom_revealer);
	self->priv->bottom_revealer = _tmp27_;
	_tmp28_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp28_, GTK_SELECTION_SINGLE);
	gtk_list_box_set_activate_on_single_click (_tmp28_, TRUE);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->app_box);
	self->priv->app_box = _tmp28_;
	_tmp29_ = self->priv->app_box;
	g_signal_connect_object (_tmp29_, "row-activated", (GCallback) _budgie_run_dialog_on_row_activate_gtk_list_box_row_activated, self, 0);
	_tmp30_ = self->priv->app_box;
	gtk_list_box_set_filter_func (_tmp30_, _budgie_run_dialog_on_filter_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp31_ = self->priv->app_box;
	gtk_list_box_set_sort_func (_tmp31_, _budgie_run_dialog_on_sort_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp32_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp32_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (_tmp32_, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_scrolled_window_set_max_content_height (_tmp32_, 300);
	gtk_scrolled_window_set_propagate_natural_height (_tmp32_, TRUE);
	g_object_ref_sink (_tmp32_);
	scroll = _tmp32_;
	_tmp33_ = scroll;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
	gtk_style_context_set_junction_sides (_tmp34_, GTK_JUNCTION_TOP);
	_tmp35_ = scroll;
	_tmp36_ = self->priv->app_box;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->bottom_revealer;
	_tmp38_ = scroll;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = main_layout;
	_tmp40_ = self->priv->bottom_revealer;
	gtk_box_pack_start (_tmp39_, (GtkWidget*) _tmp40_, TRUE, TRUE, (guint) 0);
	_tmp41_ = main_layout;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->bottom_revealer;
	gtk_revealer_set_reveal_child (_tmp42_, FALSE);
	budgie_run_dialog_load_buttons (self);
	gtk_window_get_position ((GtkWindow*) self, &_tmp43_, &_tmp44_);
	x = _tmp43_;
	y = _tmp44_;
	_tmp45_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp46_ = gdk_screen_get_display (_tmp45_);
	_tmp47_ = gdk_display_get_monitor_at_point (_tmp46_, x, y);
	_tmp48_ = _g_object_ref0 (_tmp47_);
	monitor = _tmp48_;
	_tmp49_ = monitor;
	gdk_monitor_get_workarea (_tmp49_, &_tmp50_);
	rect = _tmp50_;
	_tmp51_ = rect;
	width = CLAMP (_tmp51_.width / 3, 420, 840);
	gtk_widget_set_size_request ((GtkWidget*) self, width, -1);
	gtk_window_set_default_size ((GtkWindow*) self, width, -1);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __budgie_run_dialog___lambda5__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _budgie_run_dialog_on_key_release_gtk_widget_key_release_event, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	budgie_run_dialog_setup_dbus (self, NULL, NULL);
	_g_object_unref0 (monitor);
	_g_object_unref0 (scroll);
	_g_object_unref0 (hbox);
	_g_object_unref0 (main_layout);
	_g_object_unref0 (header);
	_g_object_unref0 (visual);
	return obj;
}

static void
budgie_run_dialog_class_init (BudgieRunDialogClass * klass,
                              gpointer klass_data)
{
	budgie_run_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRunDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = budgie_run_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_finalize;
}

static void
budgie_run_dialog_instance_init (BudgieRunDialog * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = budgie_run_dialog_get_instance_private (self);
	self->priv->focus_quit = TRUE;
	self->priv->impl = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->search_term = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->wanted_dbus_id = _tmp1_;
	self->priv->active_names = NULL;
}

static void
budgie_run_dialog_finalize (GObject * obj)
{
	BudgieRunDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG, BudgieRunDialog);
	_g_object_unref0 (self->priv->bottom_revealer);
	_g_object_unref0 (self->priv->app_box);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->impl);
	_g_free0 (self->priv->search_term);
	_g_object_unref0 (self->priv->relevancy);
	_g_object_unref0 (self->priv->theme_manager);
	_g_free0 (self->priv->wanted_dbus_id);
	_g_hash_table_unref0 (self->priv->active_names);
	G_OBJECT_CLASS (budgie_run_dialog_parent_class)->finalize (obj);
}

/**
* The meat of the operation
*/
static GType
budgie_run_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialog), 0, (GInstanceInitFunc) budgie_run_dialog_instance_init, NULL };
	GType budgie_run_dialog_type_id;
	budgie_run_dialog_type_id = g_type_register_static (gtk_application_window_get_type (), "BudgieRunDialog", &g_define_type_info, 0);
	BudgieRunDialog_private_offset = g_type_add_instance_private (budgie_run_dialog_type_id, sizeof (BudgieRunDialogPrivate));
	return budgie_run_dialog_type_id;
}

GType
budgie_run_dialog_get_type (void)
{
	static volatile gsize budgie_run_dialog_type_id__once = 0;
	if (g_once_init_enter (&budgie_run_dialog_type_id__once)) {
		GType budgie_run_dialog_type_id;
		budgie_run_dialog_type_id = budgie_run_dialog_get_type_once ();
		g_once_init_leave (&budgie_run_dialog_type_id__once, budgie_run_dialog_type_id);
	}
	return budgie_run_dialog_type_id__once;
}

static inline gpointer
budgie_run_dialog_app_get_instance_private (BudgieRunDialogApp* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieRunDialogApp_private_offset);
}

BudgieRunDialogApp*
budgie_run_dialog_app_construct (GType object_type)
{
	BudgieRunDialogApp * self = NULL;
	self = (BudgieRunDialogApp*) g_object_new (object_type, "application-id", "org.budgie_desktop.BudgieRunDialog", "flags", 0, NULL);
	return self;
}

BudgieRunDialogApp*
budgie_run_dialog_app_new (void)
{
	return budgie_run_dialog_app_construct (BUDGIE_TYPE_RUN_DIALOG_APP);
}

static void
budgie_run_dialog_app_real_activate (GApplication* base)
{
	BudgieRunDialogApp * self;
	BudgieRunDialog* _tmp0_;
	BudgieRunDialog* _tmp2_;
	self = (BudgieRunDialogApp*) base;
	_tmp0_ = self->priv->rd;
	if (_tmp0_ == NULL) {
		BudgieRunDialog* _tmp1_;
		_tmp1_ = budgie_run_dialog_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->rd);
		self->priv->rd = _tmp1_;
	}
	_tmp2_ = self->priv->rd;
	gtk_widget_show ((GtkWidget*) _tmp2_);
}

static void
budgie_run_dialog_app_class_init (BudgieRunDialogAppClass * klass,
                                  gpointer klass_data)
{
	budgie_run_dialog_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieRunDialogApp_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) budgie_run_dialog_app_real_activate;
	G_OBJECT_CLASS (klass)->finalize = budgie_run_dialog_app_finalize;
}

static void
budgie_run_dialog_app_instance_init (BudgieRunDialogApp * self,
                                     gpointer klass)
{
	self->priv = budgie_run_dialog_app_get_instance_private (self);
	self->priv->rd = NULL;
}

static void
budgie_run_dialog_app_finalize (GObject * obj)
{
	BudgieRunDialogApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_RUN_DIALOG_APP, BudgieRunDialogApp);
	_g_object_unref0 (self->priv->rd);
	G_OBJECT_CLASS (budgie_run_dialog_app_parent_class)->finalize (obj);
}

/**
* GtkApplication for single instance wonderness
*/
static GType
budgie_run_dialog_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieRunDialogAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_run_dialog_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieRunDialogApp), 0, (GInstanceInitFunc) budgie_run_dialog_app_instance_init, NULL };
	GType budgie_run_dialog_app_type_id;
	budgie_run_dialog_app_type_id = g_type_register_static (gtk_application_get_type (), "BudgieRunDialogApp", &g_define_type_info, 0);
	BudgieRunDialogApp_private_offset = g_type_add_instance_private (budgie_run_dialog_app_type_id, sizeof (BudgieRunDialogAppPrivate));
	return budgie_run_dialog_app_type_id;
}

GType
budgie_run_dialog_app_get_type (void)
{
	static volatile gsize budgie_run_dialog_app_type_id__once = 0;
	if (g_once_init_enter (&budgie_run_dialog_app_type_id__once)) {
		GType budgie_run_dialog_app_type_id;
		budgie_run_dialog_app_type_id = budgie_run_dialog_app_get_type_once ();
		g_once_init_leave (&budgie_run_dialog_app_type_id__once, budgie_run_dialog_app_type_id);
	}
	return budgie_run_dialog_app_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	BudgieRunDialogApp* rd = NULL;
	BudgieRunDialogApp* _tmp0_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (BUDGIE_GETTEXT_PACKAGE, BUDGIE_LOCALEDIR);
	bind_textdomain_codeset (BUDGIE_GETTEXT_PACKAGE, "UTF-8");
	textdomain (BUDGIE_GETTEXT_PACKAGE);
	_tmp0_ = budgie_run_dialog_app_new ();
	rd = _tmp0_;
	result = g_application_run ((GApplication*) rd, (gint) args_length1, args);
	_g_object_unref0 (rd);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

