/* window.c generated by valac 0.56.14, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <theme-manager.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#define BUDGIE_LOGIND_LOGIN "org.freedesktop.login1"
#define BUDGIE_G_SESSION "org.gnome.SessionManager"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_POWER_WINDOW (budgie_power_window_get_type ())
#define BUDGIE_POWER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_POWER_WINDOW, BudgiePowerWindow))
#define BUDGIE_POWER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_POWER_WINDOW, BudgiePowerWindowClass))
#define BUDGIE_IS_POWER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_POWER_WINDOW))
#define BUDGIE_IS_POWER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_POWER_WINDOW))
#define BUDGIE_POWER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_POWER_WINDOW, BudgiePowerWindowClass))

typedef struct _BudgiePowerWindow BudgiePowerWindow;
typedef struct _BudgiePowerWindowClass BudgiePowerWindowClass;
typedef struct _BudgiePowerWindowPrivate BudgiePowerWindowPrivate;

#define BUDGIE_TYPE_DIALOG_BUTTON (budgie_dialog_button_get_type ())
#define BUDGIE_DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton))
#define BUDGIE_DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButtonClass))
#define BUDGIE_IS_DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DIALOG_BUTTON))
#define BUDGIE_IS_DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_DIALOG_BUTTON))
#define BUDGIE_DIALOG_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButtonClass))

typedef struct _BudgieDialogButton BudgieDialogButton;
typedef struct _BudgieDialogButtonClass BudgieDialogButtonClass;

#define BUDGIE_TYPE_LOGIND_REMOTE (budgie_logind_remote_get_type ())
#define BUDGIE_LOGIND_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_LOGIND_REMOTE, BudgieLogindRemote))
#define BUDGIE_IS_LOGIND_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_LOGIND_REMOTE))
#define BUDGIE_LOGIND_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_LOGIND_REMOTE, BudgieLogindRemoteIface))

typedef struct _BudgieLogindRemote BudgieLogindRemote;
typedef struct _BudgieLogindRemoteIface BudgieLogindRemoteIface;

#define BUDGIE_TYPE_LOGIND_REMOTE_PROXY (budgie_logind_remote_proxy_get_type ())

#define BUDGIE_TYPE_SESSION_MANAGER_REMOTE (budgie_session_manager_remote_get_type ())
#define BUDGIE_SESSION_MANAGER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SESSION_MANAGER_REMOTE, BudgieSessionManagerRemote))
#define BUDGIE_IS_SESSION_MANAGER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SESSION_MANAGER_REMOTE))
#define BUDGIE_SESSION_MANAGER_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SESSION_MANAGER_REMOTE, BudgieSessionManagerRemoteIface))

typedef struct _BudgieSessionManagerRemote BudgieSessionManagerRemote;
typedef struct _BudgieSessionManagerRemoteIface BudgieSessionManagerRemoteIface;

#define BUDGIE_TYPE_SESSION_MANAGER_REMOTE_PROXY (budgie_session_manager_remote_proxy_get_type ())

#define BUDGIE_TYPE_SCREENSAVER_REMOTE (budgie_screensaver_remote_get_type ())
#define BUDGIE_SCREENSAVER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENSAVER_REMOTE, BudgieScreensaverRemote))
#define BUDGIE_IS_SCREENSAVER_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENSAVER_REMOTE))
#define BUDGIE_SCREENSAVER_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_SCREENSAVER_REMOTE, BudgieScreensaverRemoteIface))

typedef struct _BudgieScreensaverRemote BudgieScreensaverRemote;
typedef struct _BudgieScreensaverRemoteIface BudgieScreensaverRemoteIface;

#define BUDGIE_TYPE_SCREENSAVER_REMOTE_PROXY (budgie_screensaver_remote_proxy_get_type ())
enum  {
	BUDGIE_POWER_WINDOW_0_PROPERTY,
	BUDGIE_POWER_WINDOW_NUM_PROPERTIES
};
static GParamSpec* budgie_power_window_properties[BUDGIE_POWER_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BudgiePowerWindowSetupDbusData BudgiePowerWindowSetupDbusData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;

struct _BudgiePowerWindow {
	GtkApplicationWindow parent_instance;
	BudgiePowerWindowPrivate * priv;
};

struct _BudgiePowerWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _BudgieLogindRemoteIface {
	GTypeInterface parent_iface;
	gchar* (*can_hibernate) (BudgieLogindRemote* self, GError** error);
	void (*suspend) (BudgieLogindRemote* self, gboolean interactive, GError** error);
	void (*hibernate) (BudgieLogindRemote* self, gboolean interactive, GError** error);
};

struct _BudgieSessionManagerRemoteIface {
	GTypeInterface parent_iface;
	void (*Logout) (BudgieSessionManagerRemote* self, guint mode, GError** error);
	void (*Reboot) (BudgieSessionManagerRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Reboot_finish) (BudgieSessionManagerRemote* self, GAsyncResult* _res_, GError** error);
	void (*Shutdown) (BudgieSessionManagerRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*Shutdown_finish) (BudgieSessionManagerRemote* self, GAsyncResult* _res_, GError** error);
};

struct _BudgieScreensaverRemoteIface {
	GTypeInterface parent_iface;
	void (*lock) (BudgieScreensaverRemote* self, GError** error);
};

struct _BudgiePowerWindowPrivate {
	BudgieDialogButton* lock_button;
	BudgieDialogButton* suspend_button;
	BudgieDialogButton* hibernate_button;
	BudgieDialogButton* reboot_button;
	BudgieDialogButton* shutdown_button;
	BudgieDialogButton* logout_button;
	BudgieLogindRemote* logind;
	BudgieSessionManagerRemote* session_manager;
	BudgieScreensaverRemote* screensaver;
	GtkEventControllerKey* event_controller;
	BudgieThemeManager* theme_manager;
};

struct _BudgiePowerWindowSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgiePowerWindow* self;
	BudgieLogindRemote* _tmp0_;
	BudgieLogindRemote* _tmp1_;
	BudgieLogindRemote* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	BudgieScreensaverRemote* _tmp5_;
	BudgieScreensaverRemote* _tmp6_;
	BudgieScreensaverRemote* _tmp7_;
	GError* _vala1_e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	BudgieSessionManagerRemote* _tmp10_;
	BudgieSessionManagerRemote* _tmp11_;
	BudgieSessionManagerRemote* _tmp12_;
	GError* _vala2_e;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	BudgiePowerWindow* self;
	GtkBox* box;
};

static gint BudgiePowerWindow_private_offset;
static gpointer budgie_power_window_parent_class = NULL;

VALA_EXTERN GType budgie_power_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePowerWindow, g_object_unref)
VALA_EXTERN GType budgie_dialog_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieDialogButton, g_object_unref)
VALA_EXTERN GType budgie_logind_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_logind_remote_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType budgie_logind_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieLogindRemote, g_object_unref)
VALA_EXTERN GType budgie_session_manager_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_session_manager_remote_register_object (void* object,
                                                     GDBusConnection* connection,
                                                     const gchar* path,
                                                     GError** error);
VALA_EXTERN GType budgie_session_manager_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSessionManagerRemote, g_object_unref)
VALA_EXTERN GType budgie_screensaver_remote_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_screensaver_remote_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN GType budgie_screensaver_remote_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreensaverRemote, g_object_unref)
VALA_EXTERN BudgiePowerWindow* budgie_power_window_new (GtkApplication* app);
VALA_EXTERN BudgiePowerWindow* budgie_power_window_construct (GType object_type,
                                                  GtkApplication* app);
static void budgie_power_window_setup_dbus_data_free (gpointer _data);
static void budgie_power_window_setup_dbus (BudgiePowerWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void budgie_power_window_setup_dbus_finish (BudgiePowerWindow* self,
                                            GAsyncResult* _res_);
static gboolean budgie_power_window_setup_dbus_co (BudgiePowerWindowSetupDbusData* _data_);
static void budgie_power_window_setup_dbus_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void budgie_power_window_on_key_release (BudgiePowerWindow* self,
                                         guint keyval,
                                         guint keycode,
                                         GdkModifierType state);
VALA_EXTERN void budgie_power_window_reset_focus (BudgiePowerWindow* self);
static void budgie_power_window_logout (BudgiePowerWindow* self);
static gboolean __lambda4_ (BudgiePowerWindow* self);
VALA_EXTERN void budgie_session_manager_remote_Logout (BudgieSessionManagerRemote* self,
                                           guint mode,
                                           GError** error);
static gboolean ___lambda4__gsource_func (gpointer self);
static gboolean budgie_power_window_can_hibernate (BudgiePowerWindow* self);
VALA_EXTERN gchar* budgie_logind_remote_can_hibernate (BudgieLogindRemote* self,
                                           GError** error);
static void budgie_power_window_hibernate (BudgiePowerWindow* self);
static gboolean __lambda5_ (BudgiePowerWindow* self);
static void budgie_power_window_lock_screen (BudgiePowerWindow* self);
VALA_EXTERN void budgie_logind_remote_hibernate (BudgieLogindRemote* self,
                                     gboolean interactive,
                                     GError** error);
static gboolean ___lambda5__gsource_func (gpointer self);
static void budgie_power_window_reboot (BudgiePowerWindow* self);
static gboolean __lambda7_ (BudgiePowerWindow* self);
VALA_EXTERN void budgie_session_manager_remote_Reboot (BudgieSessionManagerRemote* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void budgie_session_manager_remote_Reboot_finish (BudgieSessionManagerRemote* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static gboolean ___lambda7__gsource_func (gpointer self);
static void budgie_power_window_shutdown (BudgiePowerWindow* self);
static gboolean __lambda8_ (BudgiePowerWindow* self);
VALA_EXTERN void budgie_session_manager_remote_Shutdown (BudgieSessionManagerRemote* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void budgie_session_manager_remote_Shutdown_finish (BudgieSessionManagerRemote* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static gboolean ___lambda8__gsource_func (gpointer self);
static void budgie_power_window_suspend (BudgiePowerWindow* self);
static gboolean __lambda9_ (BudgiePowerWindow* self);
VALA_EXTERN void budgie_logind_remote_suspend (BudgieLogindRemote* self,
                                   gboolean interactive,
                                   GError** error);
static gboolean ___lambda9__gsource_func (gpointer self);
static gboolean __lambda6_ (BudgiePowerWindow* self);
VALA_EXTERN void budgie_screensaver_remote_lock (BudgieScreensaverRemote* self,
                                     GError** error);
static gboolean ___lambda6__gsource_func (gpointer self);
static GObject * budgie_power_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN BudgieDialogButton* budgie_dialog_button_new (const gchar* label_text,
                                              const gchar* image_source);
VALA_EXTERN BudgieDialogButton* budgie_dialog_button_construct (GType object_type,
                                                    const gchar* label_text,
                                                    const gchar* image_source);
static void _budgie_power_window_lock_screen_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _budgie_power_window_logout_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _budgie_power_window_suspend_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void _budgie_power_window_hibernate_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _budgie_power_window_reboot_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _budgie_power_window_shutdown_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static gboolean _budgie_power_window___lambda10_ (Block1Data* _data1_,
                                           GdkEventButton* event);
static gboolean __budgie_power_window___lambda10__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self);
static gboolean _budgie_power_window___lambda11_ (BudgiePowerWindow* self);
static gboolean __budgie_power_window___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                       GdkEventFocus* event,
                                                                       gpointer self);
static void _budgie_power_window___lambda12_ (BudgiePowerWindow* self);
static void __budgie_power_window___lambda12__gtk_widget_show (GtkWidget* _sender,
                                                        gpointer self);
static void _budgie_power_window_on_key_release_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                GdkModifierType state,
                                                                                gpointer self);
static void budgie_power_window_finalize (GObject * obj);
static GType budgie_power_window_get_type_once (void);

static inline gpointer
budgie_power_window_get_instance_private (BudgiePowerWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePowerWindow_private_offset);
}

BudgiePowerWindow*
budgie_power_window_construct (GType object_type,
                               GtkApplication* app)
{
	BudgiePowerWindow * self = NULL;
	g_return_val_if_fail (app != NULL, NULL);
	self = (BudgiePowerWindow*) g_object_new (object_type, "application", app, "resizable", FALSE, "skip-pager-hint", TRUE, "skip-taskbar-hint", TRUE, "type-hint", GDK_WINDOW_TYPE_HINT_DIALOG, NULL);
	return self;
}

BudgiePowerWindow*
budgie_power_window_new (GtkApplication* app)
{
	return budgie_power_window_construct (BUDGIE_TYPE_POWER_WINDOW, app);
}

static void
budgie_power_window_setup_dbus_data_free (gpointer _data)
{
	BudgiePowerWindowSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgiePowerWindowSetupDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_power_window_setup_dbus (BudgiePowerWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BudgiePowerWindowSetupDbusData* _data_;
	BudgiePowerWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BudgiePowerWindowSetupDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_power_window_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	budgie_power_window_setup_dbus_co (_data_);
}

static void
budgie_power_window_setup_dbus_finish (BudgiePowerWindow* self,
                                       GAsyncResult* _res_)
{
	BudgiePowerWindowSetupDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
 * Set up all of the DBus bits to make all the items work.
 */
static void
budgie_power_window_setup_dbus_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	BudgiePowerWindowSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	budgie_power_window_setup_dbus_co (_data_);
}

static gboolean
budgie_power_window_setup_dbus_co (BudgiePowerWindowSetupDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (BUDGIE_TYPE_LOGIND_REMOTE_PROXY, 0, NULL, budgie_power_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", BUDGIE_LOGIND_LOGIN, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = (BudgieLogindRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (BudgieLogindRemote*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->logind);
		_data_->self->priv->logind = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("window.vala:181: Unable to connect to logind: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 2;
		g_async_initable_new_async (BUDGIE_TYPE_SCREENSAVER_REMOTE_PROXY, 0, NULL, budgie_power_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.ScreenSaver", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/ScreenSaver", "g-interface-name", "org.gnome.ScreenSaver", NULL);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = (BudgieScreensaverRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp5_ = (BudgieScreensaverRemote*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_object_unref0 (_data_->self->priv->screensaver);
		_data_->self->priv->screensaver = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->_vala1_e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("window.vala:190: Unable to connect to budgie-screensaver: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->_vala1_e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 3;
		g_async_initable_new_async (BUDGIE_TYPE_SESSION_MANAGER_REMOTE_PROXY, 0, NULL, budgie_power_window_setup_dbus_ready, _data_, "g-flags", 0, "g-name", BUDGIE_G_SESSION, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp11_ = (BudgieSessionManagerRemote*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp10_ = (BudgieSessionManagerRemote*) _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp12_ = _data_->_tmp10_;
		_data_->_tmp10_ = NULL;
		_g_object_unref0 (_data_->self->priv->session_manager);
		_data_->self->priv->session_manager = _data_->_tmp12_;
		_g_object_unref0 (_data_->_tmp10_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_vala2_e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("window.vala:198: Unable to connect to GNOME Session: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
 * Handles key release events.
 */
static void
budgie_power_window_on_key_release (BudgiePowerWindow* self,
                                    guint keyval,
                                    guint keycode,
                                    GdkModifierType state)
{
	g_return_if_fail (self != NULL);
	if (keyval != GDK_KEY_Escape) {
		return;
	}
	gtk_widget_hide ((GtkWidget*) self);
}

/**
 * Gives keyboard focus back to the lock button.
 */
void
budgie_power_window_reset_focus (BudgiePowerWindow* self)
{
	BudgieDialogButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lock_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static gboolean
__lambda4_ (BudgiePowerWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		BudgieSessionManagerRemote* _tmp0_;
		_tmp0_ = self->priv->session_manager;
		budgie_session_manager_remote_Logout (_tmp0_, (guint) 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:227: Failed to logout: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda4_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_logout (BudgiePowerWindow* self)
{
	BudgieSessionManagerRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session_manager;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda4__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
budgie_power_window_can_hibernate (BudgiePowerWindow* self)
{
	gboolean can_hibernate = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	can_hibernate = TRUE;
	{
		gchar* _tmp0_ = NULL;
		BudgieLogindRemote* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->logind;
		_tmp2_ = budgie_logind_remote_can_hibernate (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		can_hibernate = g_strcmp0 (_tmp0_, "yes") == 0;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("window.vala:239: Failed to check if hibernation is supported: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = can_hibernate;
	return result;
}

static gboolean
__lambda5_ (BudgiePowerWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		BudgieLogindRemote* _tmp0_;
		budgie_power_window_lock_screen (self);
		_tmp0_ = self->priv->logind;
		budgie_logind_remote_hibernate (_tmp0_, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:253: Cannot hibernate: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_hibernate (BudgiePowerWindow* self)
{
	BudgieLogindRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda7_ (BudgiePowerWindow* self)
{
	BudgieSessionManagerRemote* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->session_manager;
	budgie_session_manager_remote_Reboot (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_reboot (BudgiePowerWindow* self)
{
	BudgieSessionManagerRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session_manager;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda8_ (BudgiePowerWindow* self)
{
	BudgieSessionManagerRemote* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->session_manager;
	budgie_session_manager_remote_Shutdown (_tmp0_, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_shutdown (BudgiePowerWindow* self)
{
	BudgieSessionManagerRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->session_manager;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda9_ (BudgiePowerWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		BudgieLogindRemote* _tmp0_;
		budgie_power_window_lock_screen (self);
		_tmp0_ = self->priv->logind;
		budgie_logind_remote_suspend (_tmp0_, FALSE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:289: Cannot suspend: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_suspend (BudgiePowerWindow* self)
{
	BudgieLogindRemote* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = self->priv->logind;
	if (_tmp0_ == NULL) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda6_ (BudgiePowerWindow* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		BudgieScreensaverRemote* _tmp0_;
		_tmp0_ = self->priv->screensaver;
		budgie_screensaver_remote_lock (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("window.vala:306: Cannot lock screen: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((BudgiePowerWindow*) self);
	return result;
}

static void
budgie_power_window_lock_screen (BudgiePowerWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgiePowerWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->box);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_budgie_power_window_lock_screen_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	budgie_power_window_lock_screen ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_logout_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	budgie_power_window_logout ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_suspend_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	budgie_power_window_suspend ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_hibernate_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	budgie_power_window_hibernate ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_reboot_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	budgie_power_window_reboot ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_shutdown_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	budgie_power_window_shutdown ((BudgiePowerWindow*) self);
}

static gboolean
_budgie_power_window___lambda10_ (Block1Data* _data1_,
                                  GdkEventButton* event)
{
	BudgiePowerWindow* self;
	GtkAllocation allocation = {0};
	GtkBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkAllocation _tmp3_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) GDK_BUTTON_PRIMARY)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = _data1_->box;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	allocation = _tmp1_;
	_tmp3_ = allocation;
	if (event->x >= ((gdouble) _tmp3_.x)) {
		GtkAllocation _tmp4_;
		GtkAllocation _tmp5_;
		_tmp4_ = allocation;
		_tmp5_ = allocation;
		_tmp2_ = event->x <= ((gdouble) (_tmp4_.x + _tmp5_.width));
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp6_ = FALSE;
		GtkAllocation _tmp7_;
		_tmp7_ = allocation;
		if (event->y >= ((gdouble) _tmp7_.y)) {
			GtkAllocation _tmp8_;
			GtkAllocation _tmp9_;
			_tmp8_ = allocation;
			_tmp9_ = allocation;
			_tmp6_ = event->y <= ((gdouble) (_tmp8_.y + _tmp9_.height));
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
	}
	g_debug ("window.vala:141: hiding due to button_release_event");
	gtk_widget_hide ((GtkWidget*) self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__budgie_power_window___lambda10__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                   GdkEventButton* event,
                                                                   gpointer self)
{
	gboolean result;
	result = _budgie_power_window___lambda10_ (self, event);
	return result;
}

static gboolean
_budgie_power_window___lambda11_ (BudgiePowerWindow* self)
{
	gboolean result;
	g_debug ("window.vala:147: hiding due to focus_out_event");
	gtk_widget_hide ((GtkWidget*) self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__budgie_power_window___lambda11__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                              GdkEventFocus* event,
                                                              gpointer self)
{
	gboolean result;
	result = _budgie_power_window___lambda11_ ((BudgiePowerWindow*) self);
	return result;
}

static void
_budgie_power_window___lambda12_ (BudgiePowerWindow* self)
{
	gboolean can_hibernate = FALSE;
	BudgieDialogButton* _tmp0_;
	const gchar* _tmp1_ = NULL;
	BudgieDialogButton* _tmp2_;
	can_hibernate = budgie_power_window_can_hibernate (self);
	_tmp0_ = self->priv->hibernate_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, can_hibernate);
	if (can_hibernate) {
		_tmp1_ = NULL;
	} else {
		_tmp1_ = _ ("This system does not support hibernation.");
	}
	_tmp2_ = self->priv->hibernate_button;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp2_, _tmp1_);
}

static void
__budgie_power_window___lambda12__gtk_widget_show (GtkWidget* _sender,
                                                   gpointer self)
{
	_budgie_power_window___lambda12_ ((BudgiePowerWindow*) self);
}

static void
_budgie_power_window_on_key_release_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self)
{
	budgie_power_window_on_key_release ((BudgiePowerWindow*) self, keyval, keycode, state);
}

static GObject *
budgie_power_window_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgiePowerWindow * self;
	Block1Data* _data1_;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	GtkStyleContext* _tmp6_;
	BudgieThemeManager* _tmp7_;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp8_;
	GtkEventBox* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkEventBox* _tmp11_;
	GtkBox* _tmp12_ = NULL;
	GtkGrid* button_grid = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_;
	GtkStyleContext* _tmp15_;
	BudgieDialogButton* _tmp16_;
	BudgieDialogButton* _tmp17_;
	BudgieDialogButton* _tmp18_;
	BudgieDialogButton* _tmp19_;
	BudgieDialogButton* _tmp20_;
	BudgieDialogButton* _tmp21_;
	BudgieDialogButton* _tmp22_;
	BudgieDialogButton* _tmp23_;
	BudgieDialogButton* _tmp24_;
	BudgieDialogButton* _tmp25_;
	BudgieDialogButton* _tmp26_;
	BudgieDialogButton* _tmp27_;
	GtkGrid* _tmp28_;
	BudgieDialogButton* _tmp29_;
	GtkGrid* _tmp30_;
	BudgieDialogButton* _tmp31_;
	GtkGrid* _tmp32_;
	BudgieDialogButton* _tmp33_;
	GtkGrid* _tmp34_;
	BudgieDialogButton* _tmp35_;
	GtkGrid* _tmp36_;
	BudgieDialogButton* _tmp37_;
	GtkGrid* _tmp38_;
	BudgieDialogButton* _tmp39_;
	GtkBox* _tmp40_;
	GtkGrid* _tmp41_;
	GtkBox* _tmp42_;
	GtkEventControllerKey* _tmp43_;
	GtkEventControllerKey* _tmp44_;
	parent_class = G_OBJECT_CLASS (budgie_power_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_POWER_WINDOW, BudgiePowerWindow);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_position ((GtkWindow*) self, GTK_WIN_POS_CENTER_ALWAYS);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "budgie-power-dialog");
	_tmp7_ = budgie_theme_manager_new ();
	_g_object_unref0 (self->priv->theme_manager);
	self->priv->theme_manager = _tmp7_;
	budgie_power_window_setup_dbus (self, NULL, NULL);
	_tmp8_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp8_);
	header = _tmp8_;
	_tmp9_ = header;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_remove_class (_tmp10_, "titlebar");
	_tmp11_ = header;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp12_);
	_data1_->box = _tmp12_;
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_homogeneous (_tmp13_, TRUE);
	gtk_grid_set_row_homogeneous (_tmp13_, TRUE);
	gtk_grid_set_column_spacing (_tmp13_, 8);
	gtk_grid_set_row_spacing (_tmp13_, 8);
	g_object_set ((GtkWidget*) _tmp13_, "margin", 12, NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, FALSE);
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, FALSE);
	g_object_ref_sink (_tmp13_);
	button_grid = _tmp13_;
	_tmp14_ = button_grid;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	gtk_style_context_add_class (_tmp15_, "power-button-grid");
	_tmp16_ = budgie_dialog_button_new (_ ("_Lock"), "system-lock-screen-symbolic");
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->lock_button);
	self->priv->lock_button = _tmp16_;
	_tmp17_ = self->priv->lock_button;
	g_signal_connect_object ((GtkButton*) _tmp17_, "clicked", (GCallback) _budgie_power_window_lock_screen_gtk_button_clicked, self, 0);
	_tmp18_ = budgie_dialog_button_new (_ ("L_og Out"), "system-log-out-symbolic");
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->logout_button);
	self->priv->logout_button = _tmp18_;
	_tmp19_ = self->priv->logout_button;
	g_signal_connect_object ((GtkButton*) _tmp19_, "clicked", (GCallback) _budgie_power_window_logout_gtk_button_clicked, self, 0);
	_tmp20_ = budgie_dialog_button_new (_ ("_Suspend"), "system-suspend-symbolic");
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->suspend_button);
	self->priv->suspend_button = _tmp20_;
	_tmp21_ = self->priv->suspend_button;
	g_signal_connect_object ((GtkButton*) _tmp21_, "clicked", (GCallback) _budgie_power_window_suspend_gtk_button_clicked, self, 0);
	_tmp22_ = budgie_dialog_button_new (_ ("_Hibernate"), "system-hibernate-symbolic");
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->hibernate_button);
	self->priv->hibernate_button = _tmp22_;
	_tmp23_ = self->priv->hibernate_button;
	g_signal_connect_object ((GtkButton*) _tmp23_, "clicked", (GCallback) _budgie_power_window_hibernate_gtk_button_clicked, self, 0);
	_tmp24_ = budgie_dialog_button_new (_ ("_Reboot"), "system-restart-symbolic");
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->reboot_button);
	self->priv->reboot_button = _tmp24_;
	_tmp25_ = self->priv->reboot_button;
	g_signal_connect_object ((GtkButton*) _tmp25_, "clicked", (GCallback) _budgie_power_window_reboot_gtk_button_clicked, self, 0);
	_tmp26_ = budgie_dialog_button_new (_ ("Shut_down"), "system-shutdown-symbolic");
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->shutdown_button);
	self->priv->shutdown_button = _tmp26_;
	_tmp27_ = self->priv->shutdown_button;
	g_signal_connect_object ((GtkButton*) _tmp27_, "clicked", (GCallback) _budgie_power_window_shutdown_gtk_button_clicked, self, 0);
	_tmp28_ = button_grid;
	_tmp29_ = self->priv->lock_button;
	gtk_grid_attach (_tmp28_, (GtkWidget*) _tmp29_, 0, 0, 2, 2);
	_tmp30_ = button_grid;
	_tmp31_ = self->priv->logout_button;
	gtk_grid_attach (_tmp30_, (GtkWidget*) _tmp31_, 2, 0, 2, 2);
	_tmp32_ = button_grid;
	_tmp33_ = self->priv->suspend_button;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp33_, 4, 0, 2, 2);
	_tmp34_ = button_grid;
	_tmp35_ = self->priv->hibernate_button;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 2, 2, 2);
	_tmp36_ = button_grid;
	_tmp37_ = self->priv->reboot_button;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 2, 2, 2, 2);
	_tmp38_ = button_grid;
	_tmp39_ = self->priv->shutdown_button;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 4, 2, 2, 2);
	_tmp40_ = _data1_->box;
	_tmp41_ = button_grid;
	gtk_box_pack_start (_tmp40_, (GtkWidget*) _tmp41_, TRUE, FALSE, (guint) 0);
	_tmp42_ = _data1_->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp42_);
	g_signal_connect_data ((GtkWidget*) self, "button-release-event", (GCallback) __budgie_power_window___lambda10__gtk_widget_button_release_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) __budgie_power_window___lambda11__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) __budgie_power_window___lambda12__gtk_widget_show, self, 0);
	_tmp43_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->event_controller);
	self->priv->event_controller = _tmp43_;
	_tmp44_ = self->priv->event_controller;
	g_signal_connect_object (_tmp44_, "key-released", (GCallback) _budgie_power_window_on_key_release_gtk_event_controller_key_key_released, self, 0);
	_g_object_unref0 (button_grid);
	_g_object_unref0 (header);
	_g_object_unref0 (visual);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
budgie_power_window_class_init (BudgiePowerWindowClass * klass,
                                gpointer klass_data)
{
	budgie_power_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePowerWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = budgie_power_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_power_window_finalize;
}

static void
budgie_power_window_instance_init (BudgiePowerWindow * self,
                                   gpointer klass)
{
	self->priv = budgie_power_window_get_instance_private (self);
	self->priv->lock_button = NULL;
	self->priv->suspend_button = NULL;
	self->priv->hibernate_button = NULL;
	self->priv->reboot_button = NULL;
	self->priv->shutdown_button = NULL;
	self->priv->logout_button = NULL;
	self->priv->logind = NULL;
	self->priv->session_manager = NULL;
	self->priv->screensaver = NULL;
	self->priv->event_controller = NULL;
	self->priv->theme_manager = NULL;
}

static void
budgie_power_window_finalize (GObject * obj)
{
	BudgiePowerWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_POWER_WINDOW, BudgiePowerWindow);
	_g_object_unref0 (self->priv->lock_button);
	_g_object_unref0 (self->priv->suspend_button);
	_g_object_unref0 (self->priv->hibernate_button);
	_g_object_unref0 (self->priv->reboot_button);
	_g_object_unref0 (self->priv->shutdown_button);
	_g_object_unref0 (self->priv->logout_button);
	_g_object_unref0 (self->priv->logind);
	_g_object_unref0 (self->priv->session_manager);
	_g_object_unref0 (self->priv->screensaver);
	_g_object_unref0 (self->priv->event_controller);
	_g_object_unref0 (self->priv->theme_manager);
	G_OBJECT_CLASS (budgie_power_window_parent_class)->finalize (obj);
}

/**
 * This widget is the meat of the application. It contains
 * a grid of buttons, and handles all of the necessary events.
 *
 * There are a few CSS classes to better fascilitate theming:
 * GtkWindow: budgie-power-dialog
 *   GtkBox: background, drop-shadow
 *     GtkGrid: power-button-grid
 *       DialogButtons: power-dialog-button
 */
static GType
budgie_power_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePowerWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_power_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePowerWindow), 0, (GInstanceInitFunc) budgie_power_window_instance_init, NULL };
	GType budgie_power_window_type_id;
	budgie_power_window_type_id = g_type_register_static (gtk_application_window_get_type (), "BudgiePowerWindow", &g_define_type_info, 0);
	BudgiePowerWindow_private_offset = g_type_add_instance_private (budgie_power_window_type_id, sizeof (BudgiePowerWindowPrivate));
	return budgie_power_window_type_id;
}

GType
budgie_power_window_get_type (void)
{
	static volatile gsize budgie_power_window_type_id__once = 0;
	if (g_once_init_enter (&budgie_power_window_type_id__once)) {
		GType budgie_power_window_type_id;
		budgie_power_window_type_id = budgie_power_window_get_type_once ();
		g_once_init_leave (&budgie_power_window_type_id__once, budgie_power_window_type_id);
	}
	return budgie_power_window_type_id__once;
}

