/* dialog_button.c generated by valac 0.56.14, the Vala compiler
 * generated from dialog_button.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_DIALOG_BUTTON (budgie_dialog_button_get_type ())
#define BUDGIE_DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton))
#define BUDGIE_DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButtonClass))
#define BUDGIE_IS_DIALOG_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_DIALOG_BUTTON))
#define BUDGIE_IS_DIALOG_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_DIALOG_BUTTON))
#define BUDGIE_DIALOG_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButtonClass))

typedef struct _BudgieDialogButton BudgieDialogButton;
typedef struct _BudgieDialogButtonClass BudgieDialogButtonClass;
typedef struct _BudgieDialogButtonPrivate BudgieDialogButtonPrivate;
enum  {
	BUDGIE_DIALOG_BUTTON_0_PROPERTY,
	BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY,
	BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY,
	BUDGIE_DIALOG_BUTTON_NUM_PROPERTIES
};
static GParamSpec* budgie_dialog_button_properties[BUDGIE_DIALOG_BUTTON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BudgieDialogButton {
	GtkButton parent_instance;
	BudgieDialogButtonPrivate * priv;
};

struct _BudgieDialogButtonClass {
	GtkButtonClass parent_class;
};

struct _BudgieDialogButtonPrivate {
	GtkBox* menu_item;
	GtkImage* button_image;
	GtkLabel* button_label;
	gchar* _image_source;
	gchar* _label_text;
};

static gint BudgieDialogButton_private_offset;
static gpointer budgie_dialog_button_parent_class = NULL;

VALA_EXTERN GType budgie_dialog_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieDialogButton, g_object_unref)
VALA_EXTERN BudgieDialogButton* budgie_dialog_button_new (const gchar* label_text,
                                              const gchar* image_source);
VALA_EXTERN BudgieDialogButton* budgie_dialog_button_construct (GType object_type,
                                                    const gchar* label_text,
                                                    const gchar* image_source);
VALA_EXTERN void budgie_dialog_button_set_image (BudgieDialogButton* self,
                                     const gchar* source);
VALA_EXTERN void budgie_dialog_button_set_label (BudgieDialogButton* self,
                                     const gchar* text);
VALA_EXTERN const gchar* budgie_dialog_button_get_image_source (BudgieDialogButton* self);
VALA_EXTERN void budgie_dialog_button_set_image_source (BudgieDialogButton* self,
                                            const gchar* value);
VALA_EXTERN const gchar* budgie_dialog_button_get_label_text (BudgieDialogButton* self);
VALA_EXTERN void budgie_dialog_button_set_label_text (BudgieDialogButton* self,
                                          const gchar* value);
static GObject * budgie_dialog_button_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void budgie_dialog_button_finalize (GObject * obj);
static GType budgie_dialog_button_get_type_once (void);
static void _vala_budgie_dialog_button_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_budgie_dialog_button_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
budgie_dialog_button_get_instance_private (BudgieDialogButton* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieDialogButton_private_offset);
}

/**
 * Creates a new [DialogButton].
 *
 * If characters in `label_text` are preceded by an underscore, they are underlined.
 * If you need a literal underscore character in a label, use '__' (two underscores).
 * The first underlined character represents a keyboard accelerator called a mnemonic.
 * The mnemonic key can be used to activate this button.
 */
BudgieDialogButton*
budgie_dialog_button_construct (GType object_type,
                                const gchar* label_text,
                                const gchar* image_source)
{
	BudgieDialogButton * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkImage* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	g_return_val_if_fail (label_text != NULL, NULL);
	g_return_val_if_fail (image_source != NULL, NULL);
	self = (BudgieDialogButton*) g_object_new (object_type, "can-focus", TRUE, "use-underline", TRUE, NULL);
	budgie_dialog_button_set_image (self, image_source);
	budgie_dialog_button_set_label (self, label_text);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->menu_item);
	self->priv->menu_item = _tmp0_;
	_tmp1_ = self->priv->menu_item;
	_tmp2_ = self->priv->button_image;
	gtk_box_pack_start (_tmp1_, (GtkWidget*) _tmp2_, FALSE, FALSE, (guint) 0);
	_tmp3_ = self->priv->menu_item;
	_tmp4_ = self->priv->button_label;
	gtk_box_pack_end (_tmp3_, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	_tmp5_ = self->priv->menu_item;
	g_object_set ((GtkWidget*) _tmp5_, "margin", 8, NULL);
	_tmp6_ = self->priv->menu_item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	return self;
}

BudgieDialogButton*
budgie_dialog_button_new (const gchar* label_text,
                          const gchar* image_source)
{
	return budgie_dialog_button_construct (BUDGIE_TYPE_DIALOG_BUTTON, label_text, image_source);
}

/**
 * Set the image for this item.
 */
void
budgie_dialog_button_set_image (BudgieDialogButton* self,
                                const gchar* source)
{
	GtkImage* _tmp0_;
	GtkImage* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->button_image;
	if (_tmp0_ == NULL) {
		GtkImage* _tmp1_;
		_tmp1_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->button_image);
		self->priv->button_image = _tmp1_;
	}
	_tmp2_ = self->priv->button_image;
	gtk_image_set_from_icon_name (_tmp2_, source, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
}

/**
 * Sets the label for this item.
 *
 * If characters in `text` are preceded by an underscore, they are underlined.
 * If you need a literal underscore character in a label, use '__' (two underscores).
 * The first underlined character represents a keyboard accelerator called a mnemonic.
 * The mnemonic key can be used to activate this button.
 */
void
budgie_dialog_button_set_label (BudgieDialogButton* self,
                                const gchar* text)
{
	gchar* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (self->priv->_label_text);
	self->priv->_label_text = _tmp0_;
	_tmp1_ = self->priv->button_label;
	if (_tmp1_ == NULL) {
		GtkLabel* _tmp2_ = NULL;
		_tmp2_ = (GtkLabel*) gtk_label_new_with_mnemonic (NULL);
		gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->button_label);
		self->priv->button_label = _tmp2_;
	}
	_tmp3_ = self->priv->button_label;
	_tmp4_ = self->priv->_label_text;
	_tmp5_ = g_strdup_printf ("<big>%s</big>", _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup_with_mnemonic (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
}

const gchar*
budgie_dialog_button_get_image_source (BudgieDialogButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_image_source;
	result = _tmp0_;
	return result;
}

void
budgie_dialog_button_set_image_source (BudgieDialogButton* self,
                                       const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_dialog_button_get_image_source (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->_image_source);
	self->priv->_image_source = _tmp2_;
	_tmp3_ = budgie_dialog_button_get_image_source (self);
	_tmp4_ = _tmp3_;
	budgie_dialog_button_set_image (self, _tmp4_);
	g_object_notify_by_pspec ((GObject *) self, budgie_dialog_button_properties[BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY]);
}

const gchar*
budgie_dialog_button_get_label_text (BudgieDialogButton* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	result = _tmp0_;
	return result;
}

void
budgie_dialog_button_set_label_text (BudgieDialogButton* self,
                                     const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_dialog_button_get_label_text (self);
	_tmp1_ = _tmp0_;
	budgie_dialog_button_set_label (self, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, budgie_dialog_button_properties[BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY]);
}

static GObject *
budgie_dialog_button_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieDialogButton * self;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	parent_class = G_OBJECT_CLASS (budgie_dialog_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "flat");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "power-dialog-button");
	gtk_widget_show_all ((GtkWidget*) self);
	return obj;
}

static void
budgie_dialog_button_class_init (BudgieDialogButtonClass * klass,
                                 gpointer klass_data)
{
	budgie_dialog_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieDialogButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_dialog_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_dialog_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_dialog_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_dialog_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY, budgie_dialog_button_properties[BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY] = g_param_spec_string ("image-source", "image-source", "image-source", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY, budgie_dialog_button_properties[BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY] = g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
budgie_dialog_button_instance_init (BudgieDialogButton * self,
                                    gpointer klass)
{
	self->priv = budgie_dialog_button_get_instance_private (self);
	self->priv->menu_item = NULL;
	self->priv->button_image = NULL;
	self->priv->button_label = NULL;
	self->priv->_image_source = NULL;
	self->priv->_label_text = NULL;
}

static void
budgie_dialog_button_finalize (GObject * obj)
{
	BudgieDialogButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton);
	_g_object_unref0 (self->priv->menu_item);
	_g_object_unref0 (self->priv->button_image);
	_g_object_unref0 (self->priv->button_label);
	_g_free0 (self->priv->_image_source);
	_g_free0 (self->priv->_label_text);
	G_OBJECT_CLASS (budgie_dialog_button_parent_class)->finalize (obj);
}

/**
 * Wraps a `Gtk.Button` for use in the Budgie PowerDialog.
 *
 * It has a CSS class named power-dialog-button.
 */
static GType
budgie_dialog_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieDialogButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_dialog_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieDialogButton), 0, (GInstanceInitFunc) budgie_dialog_button_instance_init, NULL };
	GType budgie_dialog_button_type_id;
	budgie_dialog_button_type_id = g_type_register_static (gtk_button_get_type (), "BudgieDialogButton", &g_define_type_info, 0);
	BudgieDialogButton_private_offset = g_type_add_instance_private (budgie_dialog_button_type_id, sizeof (BudgieDialogButtonPrivate));
	return budgie_dialog_button_type_id;
}

GType
budgie_dialog_button_get_type (void)
{
	static volatile gsize budgie_dialog_button_type_id__once = 0;
	if (g_once_init_enter (&budgie_dialog_button_type_id__once)) {
		GType budgie_dialog_button_type_id;
		budgie_dialog_button_type_id = budgie_dialog_button_get_type_once ();
		g_once_init_leave (&budgie_dialog_button_type_id__once, budgie_dialog_button_type_id);
	}
	return budgie_dialog_button_type_id__once;
}

static void
_vala_budgie_dialog_button_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	BudgieDialogButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton);
	switch (property_id) {
		case BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY:
		g_value_set_string (value, budgie_dialog_button_get_image_source (self));
		break;
		case BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY:
		g_value_set_string (value, budgie_dialog_button_get_label_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_dialog_button_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	BudgieDialogButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_DIALOG_BUTTON, BudgieDialogButton);
	switch (property_id) {
		case BUDGIE_DIALOG_BUTTON_IMAGE_SOURCE_PROPERTY:
		budgie_dialog_button_set_image_source (self, g_value_get_string (value));
		break;
		case BUDGIE_DIALOG_BUTTON_LABEL_TEXT_PROPERTY:
		budgie_dialog_button_set_label_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

