/* popup.c generated by valac 0.56.14, the Vala compiler
 * generated from popup.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "budgie-private.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH 400
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE (budgie_notifications_popup_base_get_type ())
#define BUDGIE_NOTIFICATIONS_POPUP_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase))
#define BUDGIE_NOTIFICATIONS_POPUP_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBaseClass))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE))
#define BUDGIE_NOTIFICATIONS_POPUP_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBaseClass))

typedef struct _BudgieNotificationsPopupBase BudgieNotificationsPopupBase;
typedef struct _BudgieNotificationsPopupBaseClass BudgieNotificationsPopupBaseClass;
typedef struct _BudgieNotificationsPopupBasePrivate BudgieNotificationsPopupBasePrivate;
enum  {
	BUDGIE_NOTIFICATIONS_POPUP_BASE_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_BASE_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_popup_base_properties[BUDGIE_NOTIFICATIONS_POPUP_BASE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BUDGIE_NOTIFICATIONS_POPUP_BASE_CLOSED_SIGNAL,
	BUDGIE_NOTIFICATIONS_POPUP_BASE_NUM_SIGNALS
};
static guint budgie_notifications_popup_base_signals[BUDGIE_NOTIFICATIONS_POPUP_BASE_NUM_SIGNALS] = {0};

#define BUDGIE_NOTIFICATIONS_TYPE_POPUP (budgie_notifications_popup_get_type ())
#define BUDGIE_NOTIFICATIONS_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup))
#define BUDGIE_NOTIFICATIONS_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopupClass))
#define BUDGIE_NOTIFICATIONS_IS_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP))
#define BUDGIE_NOTIFICATIONS_IS_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_POPUP))
#define BUDGIE_NOTIFICATIONS_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopupClass))

typedef struct _BudgieNotificationsPopup BudgieNotificationsPopup;
typedef struct _BudgieNotificationsPopupClass BudgieNotificationsPopupClass;
typedef struct _BudgieNotificationsPopupPrivate BudgieNotificationsPopupPrivate;

#define BUDGIE_NOTIFICATIONS_TYPE_SERVER (budgie_notifications_server_get_type ())
#define BUDGIE_NOTIFICATIONS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServer))
#define BUDGIE_NOTIFICATIONS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))
#define BUDGIE_NOTIFICATIONS_IS_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_IS_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_SERVER))
#define BUDGIE_NOTIFICATIONS_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_SERVER, BudgieNotificationsServerClass))

typedef struct _BudgieNotificationsServer BudgieNotificationsServer;
typedef struct _BudgieNotificationsServerClass BudgieNotificationsServerClass;

#define BUDGIE_NOTIFICATIONS_TYPE_BODY (budgie_notifications_body_get_type ())
#define BUDGIE_NOTIFICATIONS_BODY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBody))
#define BUDGIE_NOTIFICATIONS_BODY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBodyClass))
#define BUDGIE_NOTIFICATIONS_IS_BODY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_BODY))
#define BUDGIE_NOTIFICATIONS_IS_BODY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_BODY))
#define BUDGIE_NOTIFICATIONS_BODY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBodyClass))

typedef struct _BudgieNotificationsBody BudgieNotificationsBody;
typedef struct _BudgieNotificationsBodyClass BudgieNotificationsBodyClass;
enum  {
	BUDGIE_NOTIFICATIONS_POPUP_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY,
	BUDGIE_NOTIFICATIONS_POPUP_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_NUM_PROPERTIES];

#define BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX (budgie_notifications_action_box_get_type ())
#define BUDGIE_NOTIFICATIONS_ACTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBox))
#define BUDGIE_NOTIFICATIONS_ACTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBoxClass))
#define BUDGIE_NOTIFICATIONS_IS_ACTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX))
#define BUDGIE_NOTIFICATIONS_IS_ACTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX))
#define BUDGIE_NOTIFICATIONS_ACTION_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBoxClass))

typedef struct _BudgieNotificationsActionBox BudgieNotificationsActionBox;
typedef struct _BudgieNotificationsActionBoxClass BudgieNotificationsActionBoxClass;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_NOTIFICATIONS_POPUP_ACTION_INVOKED_SIGNAL,
	BUDGIE_NOTIFICATIONS_POPUP_NUM_SIGNALS
};
static guint budgie_notifications_popup_signals[BUDGIE_NOTIFICATIONS_POPUP_NUM_SIGNALS] = {0};
typedef struct _BudgieNotificationsBodyPrivate BudgieNotificationsBodyPrivate;
enum  {
	BUDGIE_NOTIFICATIONS_BODY_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY,
	BUDGIE_NOTIFICATIONS_BODY_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_body_properties[BUDGIE_NOTIFICATIONS_BODY_NUM_PROPERTIES];
typedef struct _BudgieNotificationsActionBoxPrivate BudgieNotificationsActionBoxPrivate;
enum  {
	BUDGIE_NOTIFICATIONS_ACTION_BOX_0_PROPERTY,
	BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY,
	BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY,
	BUDGIE_NOTIFICATIONS_ACTION_BOX_NUM_PROPERTIES
};
static GParamSpec* budgie_notifications_action_box_properties[BUDGIE_NOTIFICATIONS_ACTION_BOX_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;
enum  {
	BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTION_INVOKED_SIGNAL,
	BUDGIE_NOTIFICATIONS_ACTION_BOX_NUM_SIGNALS
};
static guint budgie_notifications_action_box_signals[BUDGIE_NOTIFICATIONS_ACTION_BOX_NUM_SIGNALS] = {0};

struct _BudgieNotificationsPopupBase {
	GtkWindow parent_instance;
	BudgieNotificationsPopupBasePrivate * priv;
	GtkStack* content_stack;
	GtkRevealer* revealer;
};

struct _BudgieNotificationsPopupBaseClass {
	GtkWindowClass parent_class;
};

struct _BudgieNotificationsPopupBasePrivate {
	guint _expire_id;
	gboolean _destroying;
};

struct _BudgieNotificationsPopup {
	BudgieNotificationsPopupBase parent_instance;
	BudgieNotificationsPopupPrivate * priv;
};

struct _BudgieNotificationsPopupClass {
	BudgieNotificationsPopupBaseClass parent_class;
};

struct _BudgieNotificationsPopupPrivate {
	BudgieNotificationsServer* _owner;
	BudgieNotification* _notification;
	gboolean _did_interact;
	BudgieNotificationsBody* body;
};

struct _Block3Data {
	int _ref_count_;
	BudgieNotificationsPopup* self;
	gboolean has_actions;
	gboolean has_default_action;
};

struct _BudgieNotificationsBody {
	GtkGrid parent_instance;
	BudgieNotificationsBodyPrivate * priv;
};

struct _BudgieNotificationsBodyClass {
	GtkGridClass parent_class;
};

struct _BudgieNotificationsBodyPrivate {
	BudgieNotification* _notification;
	GtkRevealer* body_revealer;
};

struct _BudgieNotificationsActionBox {
	GtkButtonBox parent_instance;
	BudgieNotificationsActionBoxPrivate * priv;
};

struct _BudgieNotificationsActionBoxClass {
	GtkButtonBoxClass parent_class;
};

struct _BudgieNotificationsActionBoxPrivate {
	gchar** _actions;
	gint _actions_length1;
	gint __actions_size_;
	gboolean _has_icons;
};

struct _Block4Data {
	int _ref_count_;
	BudgieNotificationsActionBox* self;
	gchar* action;
};

static gint BudgieNotificationsPopupBase_private_offset;
static gpointer budgie_notifications_popup_base_parent_class = NULL;
static gint BudgieNotificationsPopup_private_offset;
static gpointer budgie_notifications_popup_parent_class = NULL;
static gint BudgieNotificationsBody_private_offset;
static gpointer budgie_notifications_body_parent_class = NULL;
static gint BudgieNotificationsActionBox_private_offset;
static gpointer budgie_notifications_action_box_parent_class = NULL;

VALA_EXTERN GType budgie_notifications_popup_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsPopupBase, g_object_unref)
VALA_EXTERN void budgie_notifications_popup_base_dismiss (BudgieNotificationsPopupBase* self);
static void budgie_notifications_popup_base_set_destroying (BudgieNotificationsPopupBase* self,
                                                     gboolean value);
static gboolean __lambda7_ (BudgieNotificationsPopupBase* self);
static gboolean ___lambda7__gsource_func (gpointer self);
VALA_EXTERN void budgie_notifications_popup_base_begin_decay (BudgieNotificationsPopupBase* self,
                                                  guint timeout);
static guint budgie_notifications_popup_base_get_expire_id (BudgieNotificationsPopupBase* self);
static gboolean __lambda8_ (BudgieNotificationsPopupBase* self);
static void budgie_notifications_popup_base_set_expire_id (BudgieNotificationsPopupBase* self,
                                                    guint value);
static gboolean ___lambda8__gsource_func (gpointer self);
VALA_EXTERN void budgie_notifications_popup_base_stop_decay (BudgieNotificationsPopupBase* self);
static void budgie_notifications_popup_base_real_get_preferred_width (GtkWidget* base,
                                                               gint* min,
                                                               gint* nat);
static void budgie_notifications_popup_base_real_get_preferred_width_for_height (GtkWidget* base,
                                                                          gint h,
                                                                          gint* min,
                                                                          gint* nat);
VALA_EXTERN BudgieNotificationsPopupBase* budgie_notifications_popup_base_new (void);
VALA_EXTERN BudgieNotificationsPopupBase* budgie_notifications_popup_base_construct (GType object_type);
VALA_EXTERN gboolean budgie_notifications_popup_base_get_destroying (BudgieNotificationsPopupBase* self);
static GObject * budgie_notifications_popup_base_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static void _budgie_notifications_popup_base___lambda9_ (BudgieNotificationsPopupBase* self);
static void __budgie_notifications_popup_base___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self);
static void budgie_notifications_popup_base_finalize (GObject * obj);
static GType budgie_notifications_popup_base_get_type_once (void);
static void _vala_budgie_notifications_popup_base_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_budgie_notifications_popup_base_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
VALA_EXTERN GType budgie_notifications_popup_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsPopup, g_object_unref)
VALA_EXTERN GType budgie_notifications_server_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsServer, g_object_unref)
VALA_EXTERN guint budgie_notifications_server_register_object (void* object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error);
VALA_EXTERN GType budgie_notifications_body_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsBody, g_object_unref)
VALA_EXTERN BudgieNotificationsPopup* budgie_notifications_popup_new (BudgieNotificationsServer* owner,
                                                          BudgieNotification* notification);
VALA_EXTERN BudgieNotificationsPopup* budgie_notifications_popup_construct (GType object_type,
                                                                BudgieNotificationsServer* owner,
                                                                BudgieNotification* notification);
VALA_EXTERN void budgie_notifications_popup_replace (BudgieNotificationsPopup* self,
                                         BudgieNotification* new_notif);
VALA_EXTERN BudgieNotificationsBody* budgie_notifications_body_new (BudgieNotification* notification);
VALA_EXTERN BudgieNotificationsBody* budgie_notifications_body_construct (GType object_type,
                                                              BudgieNotification* notification);
VALA_EXTERN GType budgie_notifications_action_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieNotificationsActionBox, g_object_unref)
VALA_EXTERN BudgieNotificationsActionBox* budgie_notifications_action_box_new (gchar** actions,
                                                                   gint actions_length1,
                                                                   gboolean has_icons);
VALA_EXTERN BudgieNotificationsActionBox* budgie_notifications_action_box_construct (GType object_type,
                                                                         gchar** actions,
                                                                         gint actions_length1,
                                                                         gboolean has_icons);
static void ___lambda11_ (BudgieNotificationsPopup* self,
                   const gchar* action_key);
static void ____lambda11__budgie_notifications_action_box_action_invoked (BudgieNotificationsActionBox* _sender,
                                                                   const gchar* action_key,
                                                                   gpointer self);
VALA_EXTERN void budgie_notifications_popup_toggle_body_text (BudgieNotificationsPopup* self);
VALA_EXTERN void budgie_notifications_body_toggle_body_text (BudgieNotificationsBody* self);
VALA_EXTERN BudgieNotificationsServer* budgie_notifications_popup_get_owner (BudgieNotificationsPopup* self);
static void budgie_notifications_popup_set_owner (BudgieNotificationsPopup* self,
                                           BudgieNotificationsServer* value);
VALA_EXTERN BudgieNotification* budgie_notifications_popup_get_notification (BudgieNotificationsPopup* self);
static void budgie_notifications_popup_set_notification (BudgieNotificationsPopup* self,
                                                  BudgieNotification* value);
VALA_EXTERN gboolean budgie_notifications_popup_get_did_interact (BudgieNotificationsPopup* self);
static void budgie_notifications_popup_set_did_interact (BudgieNotificationsPopup* self,
                                                  gboolean value);
static GObject * budgie_notifications_popup_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _budgie_notifications_popup____lambda12_ (BudgieNotificationsPopup* self,
                                               const gchar* action_key);
static void __budgie_notifications_popup____lambda12__budgie_notifications_action_box_action_invoked (BudgieNotificationsActionBox* _sender,
                                                                                               const gchar* action_key,
                                                                                               gpointer self);
static gboolean _budgie_notifications_popup___lambda13_ (BudgieNotificationsPopup* self);
static gboolean __budgie_notifications_popup___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                                 GdkEventCrossing* event,
                                                                                 gpointer self);
static gboolean _budgie_notifications_popup___lambda14_ (BudgieNotificationsPopup* self,
                                                  GdkEventCrossing* event);
static gboolean __budgie_notifications_popup___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                                 GdkEventCrossing* event,
                                                                                 gpointer self);
static gboolean _budgie_notifications_popup___lambda15_ (Block3Data* _data3_);
static gboolean __budgie_notifications_popup___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self);
static void budgie_notifications_popup_finalize (GObject * obj);
static GType budgie_notifications_popup_get_type_once (void);
static void _vala_budgie_notifications_popup_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_budgie_notifications_popup_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
VALA_EXTERN BudgieNotification* budgie_notifications_body_get_notification (BudgieNotificationsBody* self);
static void budgie_notifications_body_set_notification (BudgieNotificationsBody* self,
                                                 BudgieNotification* value);
static GObject * budgie_notifications_body_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static void budgie_notifications_body_finalize (GObject * obj);
static GType budgie_notifications_body_get_type_once (void);
static void _vala_budgie_notifications_body_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_budgie_notifications_body_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
VALA_EXTERN gchar** budgie_notifications_action_box_get_actions (BudgieNotificationsActionBox* self,
                                                     gint* result_length1);
VALA_EXTERN void budgie_notifications_action_box_set_actions (BudgieNotificationsActionBox* self,
                                                  gchar** value,
                                                  gint value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN gboolean budgie_notifications_action_box_get_has_icons (BudgieNotificationsActionBox* self);
VALA_EXTERN void budgie_notifications_action_box_set_has_icons (BudgieNotificationsActionBox* self,
                                                    gboolean value);
static GObject * budgie_notifications_action_box_constructor (GType type,
                                                       guint n_construct_properties,
                                                       GObjectConstructParam * construct_properties);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _budgie_notifications_action_box_______lambda10_ (Block4Data* _data4_);
static void __budgie_notifications_action_box_______lambda10__gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
static void budgie_notifications_action_box_finalize (GObject * obj);
static GType budgie_notifications_action_box_get_type_once (void);
static void _vala_budgie_notifications_action_box_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_budgie_notifications_action_box_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
budgie_notifications_popup_base_get_instance_private (BudgieNotificationsPopupBase* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsPopupBase_private_offset);
}

/**
 * Destroy this notification popup.
 */
static gboolean
__lambda7_ (BudgieNotificationsPopupBase* self)
{
	gboolean result;
	gtk_widget_destroy ((GtkWidget*) self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((BudgieNotificationsPopupBase*) self);
	return result;
}

void
budgie_notifications_popup_base_dismiss (BudgieNotificationsPopupBase* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	budgie_notifications_popup_base_set_destroying (self, TRUE);
	_tmp0_ = self->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->revealer;
	_tmp2_ = gtk_revealer_get_transition_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp3_, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}

/**
 * Start the decay timer for this notification. At the end of the decay, the notification is closed.
 */
static gboolean
__lambda8_ (BudgieNotificationsPopupBase* self)
{
	gboolean result;
	budgie_notifications_popup_base_set_expire_id (self, (guint) 0);
	g_signal_emit (self, budgie_notifications_popup_base_signals[BUDGIE_NOTIFICATIONS_POPUP_BASE_CLOSED_SIGNAL], 0, BUDGIE_NOTIFICATION_CLOSE_REASON_EXPIRED);
	budgie_notifications_popup_base_dismiss (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((BudgieNotificationsPopupBase*) self);
	return result;
}

void
budgie_notifications_popup_base_begin_decay (BudgieNotificationsPopupBase* self,
                                             guint timeout)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_expire_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_expire_id;
		g_source_remove (_tmp1_);
	}
	if (timeout > ((guint) 0)) {
		GtkRevealer* _tmp2_;
		_tmp2_ = self->revealer;
		gtk_revealer_set_reveal_child (_tmp2_, TRUE);
	}
	budgie_notifications_popup_base_set_expire_id (self, g_timeout_add_full (G_PRIORITY_HIGH, timeout, ___lambda8__gsource_func, g_object_ref (self), g_object_unref));
}

/**
 * Stop the decay timer for this notification.
 */
void
budgie_notifications_popup_base_stop_decay (BudgieNotificationsPopupBase* self)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_expire_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_expire_id;
		g_source_remove (_tmp1_);
		budgie_notifications_popup_base_set_expire_id (self, (guint) 0);
	}
}

static void
budgie_notifications_popup_base_real_get_preferred_width (GtkWidget* base,
                                                          gint* min,
                                                          gint* nat)
{
	BudgieNotificationsPopupBase * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieNotificationsPopupBase*) base;
	_vala_nat = BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
budgie_notifications_popup_base_real_get_preferred_width_for_height (GtkWidget* base,
                                                                     gint h,
                                                                     gint* min,
                                                                     gint* nat)
{
	BudgieNotificationsPopupBase * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	self = (BudgieNotificationsPopupBase*) base;
	_vala_nat = BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

BudgieNotificationsPopupBase*
budgie_notifications_popup_base_construct (GType object_type)
{
	BudgieNotificationsPopupBase * self = NULL;
	self = (BudgieNotificationsPopupBase*) g_object_new (object_type, NULL);
	return self;
}

BudgieNotificationsPopupBase*
budgie_notifications_popup_base_new (void)
{
	return budgie_notifications_popup_base_construct (BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE);
}

static guint
budgie_notifications_popup_base_get_expire_id (BudgieNotificationsPopupBase* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_expire_id;
	return result;
}

static void
budgie_notifications_popup_base_set_expire_id (BudgieNotificationsPopupBase* self,
                                               guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_expire_id = value;
}

gboolean
budgie_notifications_popup_base_get_destroying (BudgieNotificationsPopupBase* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_destroying;
	return result;
}

static void
budgie_notifications_popup_base_set_destroying (BudgieNotificationsPopupBase* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_popup_base_get_destroying (self);
	if (old_value != value) {
		self->priv->_destroying = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_popup_base_properties[BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_notifications_popup_base___lambda9_ (BudgieNotificationsPopupBase* self)
{
	g_signal_emit (self, budgie_notifications_popup_base_signals[BUDGIE_NOTIFICATIONS_POPUP_BASE_CLOSED_SIGNAL], 0, BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED);
	budgie_notifications_popup_base_dismiss (self);
}

static void
__budgie_notifications_popup_base___lambda9__gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self)
{
	_budgie_notifications_popup_base___lambda9_ ((BudgieNotificationsPopupBase*) self);
}

static GObject *
budgie_notifications_popup_base_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsPopupBase * self;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	GtkStyleContext* _tmp6_;
	GtkStack* _tmp7_ = NULL;
	GtkButton* close_button = NULL;
	GtkButton* _tmp8_ = NULL;
	GtkButton* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp11_;
	GtkOverlay* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkOverlay* _tmp14_;
	GtkStack* _tmp15_;
	GtkOverlay* _tmp16_;
	GtkButton* _tmp17_;
	GtkBox* box = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkBox* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkBox* _tmp21_;
	GtkOverlay* _tmp22_;
	GtkRevealer* _tmp23_ = NULL;
	GtkRevealer* _tmp24_;
	GtkBox* _tmp25_;
	GtkRevealer* _tmp26_;
	GtkButton* _tmp27_;
	parent_class = G_OBJECT_CLASS (budgie_notifications_popup_base_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_pager_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_window_set_decorated ((GtkWindow*) self, FALSE);
	gtk_window_set_accept_focus ((GtkWindow*) self, FALSE);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	gtk_window_set_default_size ((GtkWindow*) self, BUDGIE_NOTIFICATIONS_NOTIFICATION_WIDTH, -1);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "budgie-notification-window");
	_tmp7_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp7_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	g_object_set ((GtkWidget*) _tmp7_, "margin", 4, NULL);
	gtk_stack_set_vhomogeneous (_tmp7_, FALSE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->content_stack);
	self->content_stack = _tmp7_;
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp8_);
	close_button = _tmp8_;
	_tmp9_ = close_button;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, "close");
	_tmp11_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp11_);
	overlay = _tmp11_;
	_tmp12_ = overlay;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "btn");
	_tmp14_ = overlay;
	_tmp15_ = self->content_stack;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = overlay;
	_tmp17_ = close_button;
	gtk_overlay_add_overlay (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_set ((GtkWidget*) _tmp18_, "margin", 8, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, 2);
	g_object_ref_sink (_tmp18_);
	box = _tmp18_;
	_tmp19_ = box;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	gtk_style_context_add_class (_tmp20_, "drop-shadow");
	_tmp21_ = box;
	_tmp22_ = overlay;
	gtk_box_pack_start (_tmp21_, (GtkWidget*) _tmp22_, TRUE, TRUE, (guint) 0);
	_tmp23_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp23_, FALSE);
	gtk_revealer_set_transition_duration (_tmp23_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp23_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->revealer);
	self->revealer = _tmp23_;
	_tmp24_ = self->revealer;
	_tmp25_ = box;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp26_);
	_tmp27_ = close_button;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) __budgie_notifications_popup_base___lambda9__gtk_button_clicked, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (overlay);
	_g_object_unref0 (close_button);
	_g_object_unref0 (visual);
	return obj;
}

static void
budgie_notifications_popup_base_class_init (BudgieNotificationsPopupBaseClass * klass,
                                            gpointer klass_data)
{
	budgie_notifications_popup_base_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsPopupBase_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) budgie_notifications_popup_base_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = (void (*) (GtkWidget*, gint, gint*, gint*)) budgie_notifications_popup_base_real_get_preferred_width_for_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_popup_base_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_popup_base_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_popup_base_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_popup_base_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY, budgie_notifications_popup_base_properties[BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY] = g_param_spec_boolean ("destroying", "destroying", "destroying", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	budgie_notifications_popup_base_signals[BUDGIE_NOTIFICATIONS_POPUP_BASE_CLOSED_SIGNAL] = g_signal_new ("closed", BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, BUDGIE_TYPE_NOTIFICATION_CLOSE_REASON);
}

static void
budgie_notifications_popup_base_instance_init (BudgieNotificationsPopupBase * self,
                                               gpointer klass)
{
	self->priv = budgie_notifications_popup_base_get_instance_private (self);
	self->priv->_destroying = FALSE;
}

static void
budgie_notifications_popup_base_finalize (GObject * obj)
{
	BudgieNotificationsPopupBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase);
	_g_object_unref0 (self->content_stack);
	_g_object_unref0 (self->revealer);
	G_OBJECT_CLASS (budgie_notifications_popup_base_parent_class)->finalize (obj);
}

/**
 * This class is a notification popup with no content in it.
 *
 * Widget Structure & GTK Classes:
 * - GtkWindow (class: budgie-notification-window)
 *   - GtkRevealer
 *     - GtkBox (class: drop-shadow)
 *       - GtkOverlay
 *         - GtkStack (holds the notification body/content)
 *           - ...
 *         - GtkButton (class: close)
 */
static GType
budgie_notifications_popup_base_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsPopupBaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_popup_base_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsPopupBase), 0, (GInstanceInitFunc) budgie_notifications_popup_base_instance_init, NULL };
	GType budgie_notifications_popup_base_type_id;
	budgie_notifications_popup_base_type_id = g_type_register_static (gtk_window_get_type (), "BudgieNotificationsPopupBase", &g_define_type_info, 0);
	BudgieNotificationsPopupBase_private_offset = g_type_add_instance_private (budgie_notifications_popup_base_type_id, sizeof (BudgieNotificationsPopupBasePrivate));
	return budgie_notifications_popup_base_type_id;
}

GType
budgie_notifications_popup_base_get_type (void)
{
	static volatile gsize budgie_notifications_popup_base_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_popup_base_type_id__once)) {
		GType budgie_notifications_popup_base_type_id;
		budgie_notifications_popup_base_type_id = budgie_notifications_popup_base_get_type_once ();
		g_once_init_leave (&budgie_notifications_popup_base_type_id__once, budgie_notifications_popup_base_type_id);
	}
	return budgie_notifications_popup_base_type_id__once;
}

static void
_vala_budgie_notifications_popup_base_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsPopupBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY:
		g_value_set_boolean (value, budgie_notifications_popup_base_get_destroying (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_popup_base_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsPopupBase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, BudgieNotificationsPopupBase);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_POPUP_BASE_DESTROYING_PROPERTY:
		budgie_notifications_popup_base_set_destroying (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_notifications_popup_get_instance_private (BudgieNotificationsPopup* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsPopup_private_offset);
}

BudgieNotificationsPopup*
budgie_notifications_popup_construct (GType object_type,
                                      BudgieNotificationsServer* owner,
                                      BudgieNotification* notification)
{
	BudgieNotificationsPopup * self = NULL;
	g_return_val_if_fail (notification != NULL, NULL);
	self = (BudgieNotificationsPopup*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "type-hint", GDK_WINDOW_TYPE_HINT_NOTIFICATION, "owner", owner, "notification", notification, NULL);
	return self;
}

BudgieNotificationsPopup*
budgie_notifications_popup_new (BudgieNotificationsServer* owner,
                                BudgieNotification* notification)
{
	return budgie_notifications_popup_construct (BUDGIE_NOTIFICATIONS_TYPE_POPUP, owner, notification);
}

/**
 * Replace the content of this notification with a new notification.
 */
static void
___lambda11_ (BudgieNotificationsPopup* self,
              const gchar* action_key)
{
	g_return_if_fail (action_key != NULL);
	g_signal_emit (self, budgie_notifications_popup_signals[BUDGIE_NOTIFICATIONS_POPUP_ACTION_INVOKED_SIGNAL], 0, action_key);
}

static void
____lambda11__budgie_notifications_action_box_action_invoked (BudgieNotificationsActionBox* _sender,
                                                              const gchar* action_key,
                                                              gpointer self)
{
	___lambda11_ ((BudgieNotificationsPopup*) self, action_key);
}

void
budgie_notifications_popup_replace (BudgieNotificationsPopup* self,
                                    BudgieNotification* new_notif)
{
	GtkBox* content_box = NULL;
	GtkBox* _tmp0_ = NULL;
	BudgieNotificationsBody* new_contents = NULL;
	BudgieNotificationsBody* _tmp1_;
	GtkBox* _tmp2_;
	BudgieNotificationsBody* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkBox* _tmp16_;
	GtkStack* _tmp17_;
	GtkBox* _tmp18_;
	GtkStack* _tmp19_;
	GtkBox* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_notif != NULL);
	budgie_notifications_popup_base_stop_decay ((BudgieNotificationsPopupBase*) self);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_set_baseline_position (_tmp0_, GTK_BASELINE_POSITION_CENTER);
	g_object_ref_sink (_tmp0_);
	content_box = _tmp0_;
	_tmp1_ = budgie_notifications_body_new (new_notif);
	g_object_ref_sink (_tmp1_);
	new_contents = _tmp1_;
	_tmp2_ = content_box;
	_tmp3_ = new_contents;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	_tmp4_ = budgie_notification_get_actions (new_notif, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	if (_tmp6__length1 > 0) {
		BudgieNotificationsActionBox* actions = NULL;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		gchar** _tmp9_;
		gint _tmp9__length1;
		GHashTable* _tmp10_;
		GHashTable* _tmp11_;
		BudgieNotificationsActionBox* _tmp12_;
		BudgieNotificationsActionBox* _tmp13_;
		GtkBox* _tmp14_;
		BudgieNotificationsActionBox* _tmp15_;
		_tmp7_ = budgie_notification_get_actions (new_notif, &_tmp8_);
		_tmp7__length1 = _tmp8_;
		_tmp9_ = _tmp7_;
		_tmp9__length1 = _tmp7__length1;
		_tmp10_ = budgie_notification_get_hints (new_notif);
		_tmp11_ = _tmp10_;
		_tmp12_ = budgie_notifications_action_box_new (_tmp9_, _tmp9__length1, g_hash_table_contains (_tmp11_, "action-icons"));
		g_object_ref_sink (_tmp12_);
		actions = _tmp12_;
		_tmp13_ = actions;
		g_signal_connect_object (_tmp13_, "action-invoked", (GCallback) ____lambda11__budgie_notifications_action_box_action_invoked, self, 0);
		_tmp14_ = content_box;
		_tmp15_ = actions;
		gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (actions);
	}
	_tmp16_ = content_box;
	gtk_widget_show_all ((GtkWidget*) _tmp16_);
	_tmp17_ = ((BudgieNotificationsPopupBase*) self)->content_stack;
	_tmp18_ = content_box;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = ((BudgieNotificationsPopupBase*) self)->content_stack;
	_tmp20_ = content_box;
	gtk_stack_set_visible_child (_tmp19_, (GtkWidget*) _tmp20_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp21_ = budgie_notification_get_expire_timeout (new_notif);
	_tmp22_ = _tmp21_;
	budgie_notifications_popup_base_begin_decay ((BudgieNotificationsPopupBase*) self, _tmp22_);
	_g_object_unref0 (new_contents);
	_g_object_unref0 (content_box);
}

void
budgie_notifications_popup_toggle_body_text (BudgieNotificationsPopup* self)
{
	BudgieNotificationsBody* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->body;
	budgie_notifications_body_toggle_body_text (_tmp0_);
}

BudgieNotificationsServer*
budgie_notifications_popup_get_owner (BudgieNotificationsPopup* self)
{
	BudgieNotificationsServer* result;
	BudgieNotificationsServer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}

static void
budgie_notifications_popup_set_owner (BudgieNotificationsPopup* self,
                                      BudgieNotificationsServer* value)
{
	BudgieNotificationsServer* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_popup_get_owner (self);
	if (old_value != value) {
		BudgieNotificationsServer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_owner);
		self->priv->_owner = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY]);
	}
}

BudgieNotification*
budgie_notifications_popup_get_notification (BudgieNotificationsPopup* self)
{
	BudgieNotification* result;
	BudgieNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notification;
	result = _tmp0_;
	return result;
}

static void
budgie_notifications_popup_set_notification (BudgieNotificationsPopup* self,
                                             BudgieNotification* value)
{
	BudgieNotification* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_popup_get_notification (self);
	if (old_value != value) {
		BudgieNotification* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notification);
		self->priv->_notification = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY]);
	}
}

gboolean
budgie_notifications_popup_get_did_interact (BudgieNotificationsPopup* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_did_interact;
	return result;
}

static void
budgie_notifications_popup_set_did_interact (BudgieNotificationsPopup* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_popup_get_did_interact (self);
	if (old_value != value) {
		self->priv->_did_interact = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY]);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieNotificationsPopup* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_budgie_notifications_popup____lambda12_ (BudgieNotificationsPopup* self,
                                          const gchar* action_key)
{
	g_return_if_fail (action_key != NULL);
	g_signal_emit (self, budgie_notifications_popup_signals[BUDGIE_NOTIFICATIONS_POPUP_ACTION_INVOKED_SIGNAL], 0, action_key);
	budgie_notifications_popup_base_dismiss ((BudgieNotificationsPopupBase*) self);
}

static void
__budgie_notifications_popup____lambda12__budgie_notifications_action_box_action_invoked (BudgieNotificationsActionBox* _sender,
                                                                                          const gchar* action_key,
                                                                                          gpointer self)
{
	_budgie_notifications_popup____lambda12_ ((BudgieNotificationsPopup*) self, action_key);
}

static gboolean
_budgie_notifications_popup___lambda13_ (BudgieNotificationsPopup* self)
{
	gboolean result;
	budgie_notifications_popup_base_stop_decay ((BudgieNotificationsPopupBase*) self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__budgie_notifications_popup___lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                                        GdkEventCrossing* event,
                                                                        gpointer self)
{
	gboolean result;
	result = _budgie_notifications_popup___lambda13_ ((BudgieNotificationsPopup*) self);
	return result;
}

static gboolean
_budgie_notifications_popup___lambda14_ (BudgieNotificationsPopup* self,
                                         GdkEventCrossing* event)
{
	BudgieNotification* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail == GDK_NOTIFY_INFERIOR) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp0_ = self->priv->_notification;
	_tmp1_ = budgie_notification_get_expire_timeout (_tmp0_);
	_tmp2_ = _tmp1_;
	budgie_notifications_popup_base_begin_decay ((BudgieNotificationsPopupBase*) self, _tmp2_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__budgie_notifications_popup___lambda14__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                        GdkEventCrossing* event,
                                                                        gpointer self)
{
	gboolean result;
	result = _budgie_notifications_popup___lambda14_ ((BudgieNotificationsPopup*) self, event);
	return result;
}

static gboolean
_budgie_notifications_popup___lambda15_ (Block3Data* _data3_)
{
	BudgieNotificationsPopup* self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data3_->self;
	if (_data3_->has_default_action) {
		g_signal_emit (self, budgie_notifications_popup_signals[BUDGIE_NOTIFICATIONS_POPUP_ACTION_INVOKED_SIGNAL], 0, "default");
	} else {
		gboolean _tmp0_ = FALSE;
		BudgieNotification* _tmp1_;
		GDesktopAppInfo* _tmp2_;
		GDesktopAppInfo* _tmp3_;
		_tmp1_ = self->priv->_notification;
		_tmp2_ = budgie_notification_get_app_info (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			_tmp0_ = !_data3_->has_actions;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			{
				BudgieNotification* _tmp4_;
				GDesktopAppInfo* _tmp5_;
				GDesktopAppInfo* _tmp6_;
				_tmp4_ = self->priv->_notification;
				_tmp5_ = budgie_notification_get_app_info (_tmp4_);
				_tmp6_ = _tmp5_;
				g_app_info_launch ((GAppInfo*) _tmp6_, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				g_critical ("popup.vala:226: Unable to launch app: %s", _tmp8_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp9_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp9_;
			}
		}
	}
	g_signal_emit ((BudgieNotificationsPopupBase*) self, budgie_notifications_popup_base_signals[BUDGIE_NOTIFICATIONS_POPUP_BASE_CLOSED_SIGNAL], 0, BUDGIE_NOTIFICATION_CLOSE_REASON_DISMISSED);
	budgie_notifications_popup_base_dismiss ((BudgieNotificationsPopupBase*) self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__budgie_notifications_popup___lambda15__gtk_widget_button_release_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self)
{
	gboolean result;
	result = _budgie_notifications_popup___lambda15_ (self);
	return result;
}

static GObject *
budgie_notifications_popup_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsPopup * self;
	Block3Data* _data3_;
	BudgieNotification* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	BudgieNotification* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GtkBox* content_box = NULL;
	GtkBox* _tmp10_ = NULL;
	BudgieNotification* _tmp11_;
	BudgieNotificationsBody* _tmp12_;
	GtkStack* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	BudgieNotificationsBody* _tmp16_;
	BudgieNotification* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_ = 0;
	gchar** _tmp20_;
	gint _tmp20__length1;
	parent_class = G_OBJECT_CLASS (budgie_notifications_popup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->_notification;
	_tmp1_ = budgie_notification_get_actions (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	_data3_->has_actions = _tmp3__length1 > 0;
	_data3_->has_default_action = FALSE;
	_tmp4_ = self->priv->_notification;
	_tmp5_ = budgie_notification_get_actions (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	{
		gchar** action_collection = NULL;
		gint action_collection_length1 = 0;
		gint _action_collection_size_ = 0;
		gint action_it = 0;
		action_collection = _tmp7_;
		action_collection_length1 = _tmp7__length1;
		for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
			gchar* _tmp8_;
			gchar* action = NULL;
			_tmp8_ = g_strdup (action_collection[action_it]);
			action = _tmp8_;
			{
				const gchar* _tmp9_;
				_tmp9_ = action;
				if (g_strcmp0 (_tmp9_, "default") == 0) {
					_data3_->has_default_action = TRUE;
					_g_free0 (action);
					break;
				}
				_g_free0 (action);
			}
		}
	}
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_box_set_baseline_position (_tmp10_, GTK_BASELINE_POSITION_CENTER);
	g_object_ref_sink (_tmp10_);
	content_box = _tmp10_;
	_tmp11_ = self->priv->_notification;
	_tmp12_ = budgie_notifications_body_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->body);
	self->priv->body = _tmp12_;
	_tmp13_ = ((BudgieNotificationsPopupBase*) self)->content_stack;
	_tmp14_ = content_box;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = content_box;
	_tmp16_ = self->priv->body;
	gtk_box_pack_start (_tmp15_, (GtkWidget*) _tmp16_, FALSE, FALSE, (guint) 0);
	_tmp17_ = self->priv->_notification;
	_tmp18_ = budgie_notification_get_actions (_tmp17_, &_tmp19_);
	_tmp18__length1 = _tmp19_;
	_tmp20_ = _tmp18_;
	_tmp20__length1 = _tmp18__length1;
	if (_tmp20__length1 > 0) {
		BudgieNotificationsActionBox* actions = NULL;
		BudgieNotification* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_ = 0;
		gchar** _tmp24_;
		gint _tmp24__length1;
		BudgieNotification* _tmp25_;
		GHashTable* _tmp26_;
		GHashTable* _tmp27_;
		BudgieNotificationsActionBox* _tmp28_;
		BudgieNotificationsActionBox* _tmp29_;
		GtkBox* _tmp30_;
		BudgieNotificationsActionBox* _tmp31_;
		_tmp21_ = self->priv->_notification;
		_tmp22_ = budgie_notification_get_actions (_tmp21_, &_tmp23_);
		_tmp22__length1 = _tmp23_;
		_tmp24_ = _tmp22_;
		_tmp24__length1 = _tmp22__length1;
		_tmp25_ = self->priv->_notification;
		_tmp26_ = budgie_notification_get_hints (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = budgie_notifications_action_box_new (_tmp24_, _tmp24__length1, g_hash_table_contains (_tmp27_, "action-icons"));
		g_object_ref_sink (_tmp28_);
		actions = _tmp28_;
		_tmp29_ = actions;
		g_signal_connect_object (_tmp29_, "action-invoked", (GCallback) __budgie_notifications_popup____lambda12__budgie_notifications_action_box_action_invoked, self, 0);
		_tmp30_ = content_box;
		_tmp31_ = actions;
		gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
		_g_object_unref0 (actions);
	}
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) __budgie_notifications_popup___lambda13__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) __budgie_notifications_popup___lambda14__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "button-release-event", (GCallback) __budgie_notifications_popup___lambda15__gtk_widget_button_release_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (content_box);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
budgie_notifications_popup_class_init (BudgieNotificationsPopupClass * klass,
                                       gpointer klass_data)
{
	budgie_notifications_popup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsPopup_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_popup_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_popup_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_popup_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_popup_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY] = g_param_spec_object ("owner", "owner", "owner", BUDGIE_NOTIFICATIONS_TYPE_SERVER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY] = g_param_spec_object ("notification", "notification", "notification", BUDGIE_TYPE_NOTIFICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY, budgie_notifications_popup_properties[BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY] = g_param_spec_boolean ("did-interact", "did-interact", "did-interact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Signal emitted when an action is clicked.
	 */
	budgie_notifications_popup_signals[BUDGIE_NOTIFICATIONS_POPUP_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", BUDGIE_NOTIFICATIONS_TYPE_POPUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
budgie_notifications_popup_instance_init (BudgieNotificationsPopup * self,
                                          gpointer klass)
{
	self->priv = budgie_notifications_popup_get_instance_private (self);
	self->priv->_did_interact = FALSE;
}

static void
budgie_notifications_popup_finalize (GObject * obj)
{
	BudgieNotificationsPopup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup);
	_g_object_unref0 (self->priv->_owner);
	_g_object_unref0 (self->priv->_notification);
	_g_object_unref0 (self->priv->body);
	G_OBJECT_CLASS (budgie_notifications_popup_parent_class)->finalize (obj);
}

static GType
budgie_notifications_popup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsPopupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_popup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsPopup), 0, (GInstanceInitFunc) budgie_notifications_popup_instance_init, NULL };
	GType budgie_notifications_popup_type_id;
	budgie_notifications_popup_type_id = g_type_register_static (BUDGIE_NOTIFICATIONS_TYPE_POPUP_BASE, "BudgieNotificationsPopup", &g_define_type_info, 0);
	BudgieNotificationsPopup_private_offset = g_type_add_instance_private (budgie_notifications_popup_type_id, sizeof (BudgieNotificationsPopupPrivate));
	return budgie_notifications_popup_type_id;
}

GType
budgie_notifications_popup_get_type (void)
{
	static volatile gsize budgie_notifications_popup_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_popup_type_id__once)) {
		GType budgie_notifications_popup_type_id;
		budgie_notifications_popup_type_id = budgie_notifications_popup_get_type_once ();
		g_once_init_leave (&budgie_notifications_popup_type_id__once, budgie_notifications_popup_type_id);
	}
	return budgie_notifications_popup_type_id__once;
}

static void
_vala_budgie_notifications_popup_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BudgieNotificationsPopup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY:
		g_value_set_object (value, budgie_notifications_popup_get_owner (self));
		break;
		case BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY:
		g_value_set_object (value, budgie_notifications_popup_get_notification (self));
		break;
		case BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY:
		g_value_set_boolean (value, budgie_notifications_popup_get_did_interact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_popup_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BudgieNotificationsPopup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_POPUP, BudgieNotificationsPopup);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_POPUP_OWNER_PROPERTY:
		budgie_notifications_popup_set_owner (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATIONS_POPUP_NOTIFICATION_PROPERTY:
		budgie_notifications_popup_set_notification (self, g_value_get_object (value));
		break;
		case BUDGIE_NOTIFICATIONS_POPUP_DID_INTERACT_PROPERTY:
		budgie_notifications_popup_set_did_interact (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_notifications_body_get_instance_private (BudgieNotificationsBody* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsBody_private_offset);
}

BudgieNotificationsBody*
budgie_notifications_body_construct (GType object_type,
                                     BudgieNotification* notification)
{
	BudgieNotificationsBody * self = NULL;
	g_return_val_if_fail (notification != NULL, NULL);
	self = (BudgieNotificationsBody*) g_object_new (object_type, "notification", notification, NULL);
	return self;
}

BudgieNotificationsBody*
budgie_notifications_body_new (BudgieNotification* notification)
{
	return budgie_notifications_body_construct (BUDGIE_NOTIFICATIONS_TYPE_BODY, notification);
}

void
budgie_notifications_body_toggle_body_text (BudgieNotificationsBody* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->body_revealer;
	_tmp1_ = self->priv->body_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, !gtk_revealer_get_reveal_child (_tmp1_));
}

BudgieNotification*
budgie_notifications_body_get_notification (BudgieNotificationsBody* self)
{
	BudgieNotification* result;
	BudgieNotification* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_notification;
	result = _tmp0_;
	return result;
}

static void
budgie_notifications_body_set_notification (BudgieNotificationsBody* self,
                                            BudgieNotification* value)
{
	BudgieNotification* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_body_get_notification (self);
	if (old_value != value) {
		BudgieNotification* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notification);
		self->priv->_notification = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_body_properties[BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY]);
	}
}

static GObject *
budgie_notifications_body_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsBody * self;
	GtkStyleContext* _tmp0_;
	GtkImage* app_icon = NULL;
	BudgieNotification* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkLabel* title_label = NULL;
	BudgieNotification* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkRevealer* _tmp17_ = NULL;
	GtkLabel* body_label = NULL;
	BudgieNotification* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkRevealer* _tmp25_;
	GtkLabel* _tmp26_;
	GtkImage* _tmp27_;
	GtkLabel* _tmp28_;
	GtkRevealer* _tmp29_;
	parent_class = G_OBJECT_CLASS (budgie_notifications_body_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBody);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkWidget*) self, "margin", 4, NULL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "budgie-notification");
	_tmp1_ = self->priv->_notification;
	_tmp2_ = budgie_notification_get_image (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	app_icon = _tmp4_;
	_tmp5_ = app_icon;
	gtk_image_set_pixel_size (_tmp5_, 48);
	_tmp6_ = app_icon;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 8);
	_tmp7_ = app_icon;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_FILL);
	_tmp8_ = app_icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	_tmp9_ = app_icon;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, "notification-icon");
	_tmp11_ = self->priv->_notification;
	_tmp12_ = budgie_notification_get_summary (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
	gtk_label_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_END);
	gtk_label_set_max_width_chars (_tmp14_, 35);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp14_, 5);
	gtk_widget_set_margin_right ((GtkWidget*) _tmp14_, 16);
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	gtk_label_set_use_markup (_tmp14_, TRUE);
	g_object_ref_sink (_tmp14_);
	title_label = _tmp14_;
	_tmp15_ = title_label;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	gtk_style_context_add_class (_tmp16_, "notification-title");
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp17_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	gtk_revealer_set_transition_duration (_tmp17_, (guint) 250);
	gtk_revealer_set_reveal_child (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->body_revealer);
	self->priv->body_revealer = _tmp17_;
	_tmp18_ = self->priv->_notification;
	_tmp19_ = budgie_notification_get_body (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	gtk_label_set_ellipsize (_tmp21_, PANGO_ELLIPSIZE_END);
	gtk_label_set_use_markup (_tmp21_, TRUE);
	g_object_set (_tmp21_, "wrap", TRUE, NULL);
	g_object_set (_tmp21_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp21_, 33);
	gtk_label_set_lines (_tmp21_, 2);
	gtk_widget_set_valign ((GtkWidget*) _tmp21_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp21_, (gfloat) 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	body_label = _tmp21_;
	_tmp22_ = body_label;
	gtk_widget_set_size_request ((GtkWidget*) _tmp22_, 33, -1);
	_tmp23_ = body_label;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "notification-body");
	_tmp25_ = self->priv->body_revealer;
	_tmp26_ = body_label;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = app_icon;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp27_, 0, 0, 1, 2);
	_tmp28_ = title_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp28_, 1, 0, 1, 1);
	_tmp29_ = self->priv->body_revealer;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp29_, 1, 1, 1, 1);
	_g_object_unref0 (body_label);
	_g_object_unref0 (title_label);
	_g_object_unref0 (app_icon);
	return obj;
}

static void
budgie_notifications_body_class_init (BudgieNotificationsBodyClass * klass,
                                      gpointer klass_data)
{
	budgie_notifications_body_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsBody_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_body_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_body_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_body_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_body_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY, budgie_notifications_body_properties[BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY] = g_param_spec_object ("notification", "notification", "notification", BUDGIE_TYPE_NOTIFICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
budgie_notifications_body_instance_init (BudgieNotificationsBody * self,
                                         gpointer klass)
{
	self->priv = budgie_notifications_body_get_instance_private (self);
}

static void
budgie_notifications_body_finalize (GObject * obj)
{
	BudgieNotificationsBody * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBody);
	_g_object_unref0 (self->priv->_notification);
	_g_object_unref0 (self->priv->body_revealer);
	G_OBJECT_CLASS (budgie_notifications_body_parent_class)->finalize (obj);
}

/**
 * This class holds the widgets for all of the parts of a notification popup.
 */
static GType
budgie_notifications_body_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsBodyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_body_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsBody), 0, (GInstanceInitFunc) budgie_notifications_body_instance_init, NULL };
	GType budgie_notifications_body_type_id;
	budgie_notifications_body_type_id = g_type_register_static (gtk_grid_get_type (), "BudgieNotificationsBody", &g_define_type_info, 0);
	BudgieNotificationsBody_private_offset = g_type_add_instance_private (budgie_notifications_body_type_id, sizeof (BudgieNotificationsBodyPrivate));
	return budgie_notifications_body_type_id;
}

GType
budgie_notifications_body_get_type (void)
{
	static volatile gsize budgie_notifications_body_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_body_type_id__once)) {
		GType budgie_notifications_body_type_id;
		budgie_notifications_body_type_id = budgie_notifications_body_get_type_once ();
		g_once_init_leave (&budgie_notifications_body_type_id__once, budgie_notifications_body_type_id);
	}
	return budgie_notifications_body_type_id__once;
}

static void
_vala_budgie_notifications_body_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationsBody * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBody);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY:
		g_value_set_object (value, budgie_notifications_body_get_notification (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_body_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	BudgieNotificationsBody * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_BODY, BudgieNotificationsBody);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_BODY_NOTIFICATION_PROPERTY:
		budgie_notifications_body_set_notification (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_notifications_action_box_get_instance_private (BudgieNotificationsActionBox* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieNotificationsActionBox_private_offset);
}

BudgieNotificationsActionBox*
budgie_notifications_action_box_construct (GType object_type,
                                           gchar** actions,
                                           gint actions_length1,
                                           gboolean has_icons)
{
	BudgieNotificationsActionBox * self = NULL;
	self = (BudgieNotificationsActionBox*) g_object_new (object_type, "actions", actions, "has-icons", has_icons, NULL);
	return self;
}

BudgieNotificationsActionBox*
budgie_notifications_action_box_new (gchar** actions,
                                     gint actions_length1,
                                     gboolean has_icons)
{
	return budgie_notifications_action_box_construct (BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, actions, actions_length1, has_icons);
}

gchar**
budgie_notifications_action_box_get_actions (BudgieNotificationsActionBox* self,
                                             gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	_tmp0__length1 = self->priv->_actions_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
budgie_notifications_action_box_set_actions (BudgieNotificationsActionBox* self,
                                             gchar** value,
                                             gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_action_box_get_actions (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_actions = _tmp0_;
		self->priv->_actions_length1 = _tmp0__length1;
		self->priv->__actions_size_ = self->priv->_actions_length1;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_action_box_properties[BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY]);
	}
}

gboolean
budgie_notifications_action_box_get_has_icons (BudgieNotificationsActionBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_icons;
	return result;
}

void
budgie_notifications_action_box_set_has_icons (BudgieNotificationsActionBox* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_notifications_action_box_get_has_icons (self);
	if (old_value != value) {
		self->priv->_has_icons = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_notifications_action_box_properties[BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY]);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieNotificationsActionBox* self;
		self = _data4_->self;
		_g_free0 (_data4_->action);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_budgie_notifications_action_box_______lambda10_ (Block4Data* _data4_)
{
	BudgieNotificationsActionBox* self;
	const gchar* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->action;
	g_signal_emit (self, budgie_notifications_action_box_signals[BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTION_INVOKED_SIGNAL], 0, _tmp0_);
}

static void
__budgie_notifications_action_box_______lambda10__gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	_budgie_notifications_action_box_______lambda10_ (self);
}

static GObject *
budgie_notifications_action_box_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieNotificationsActionBox * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (budgie_notifications_action_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBox);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkButtonBox*) self, "layout-style", GTK_BUTTONBOX_CENTER, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) self, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 3);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "linked");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar** _tmp2_;
				gint _tmp2__length1;
				gint _tmp3_ = 0;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_ = 0;
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				if (!_tmp1_) {
					i += 2;
				}
				_tmp1_ = FALSE;
				_tmp2_ = budgie_notifications_action_box_get_actions (self, &_tmp3_);
				_tmp2__length1 = _tmp3_;
				_tmp4_ = _tmp2_;
				_tmp4__length1 = _tmp2__length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = budgie_notifications_action_box_get_actions (self, &_tmp6_);
				_tmp5__length1 = _tmp6_;
				_tmp7_ = _tmp5_;
				_tmp7__length1 = _tmp5__length1;
				_tmp8_ = _tmp7_[i];
				if (g_strcmp0 (_tmp8_, "default") != 0) {
					Block4Data* _data4_;
					GtkButton* button = NULL;
					gchar** _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_ = 0;
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gboolean _tmp14_;
					GtkButton* _tmp29_;
					GtkButton* _tmp30_;
					_data4_ = g_slice_new0 (Block4Data);
					_data4_->_ref_count_ = 1;
					_data4_->self = g_object_ref (self);
					button = NULL;
					_tmp9_ = budgie_notifications_action_box_get_actions (self, &_tmp10_);
					_tmp9__length1 = _tmp10_;
					_tmp11_ = _tmp9_;
					_tmp11__length1 = _tmp9__length1;
					_tmp12_ = _tmp11_[i];
					_tmp13_ = g_strdup (_tmp12_);
					_data4_->action = _tmp13_;
					_tmp14_ = self->priv->_has_icons;
					if (_tmp14_) {
						const gchar* _tmp15_;
						_tmp15_ = _data4_->action;
						if (!g_str_has_suffix (_tmp15_, "-symbolic")) {
							const gchar* _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							GtkButton* _tmp19_;
							_tmp16_ = _data4_->action;
							_tmp17_ = g_strdup_printf ("%s-symbolic", _tmp16_);
							_tmp18_ = _tmp17_;
							_tmp19_ = (GtkButton*) gtk_button_new_from_icon_name (_tmp18_, (GtkIconSize) GTK_ICON_SIZE_MENU);
							g_object_ref_sink (_tmp19_);
							_g_object_unref0 (button);
							button = _tmp19_;
							_g_free0 (_tmp18_);
						} else {
							const gchar* _tmp20_;
							GtkButton* _tmp21_;
							_tmp20_ = _data4_->action;
							_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name (_tmp20_, (GtkIconSize) GTK_ICON_SIZE_MENU);
							g_object_ref_sink (_tmp21_);
							_g_object_unref0 (button);
							button = _tmp21_;
						}
					} else {
						gchar** _tmp22_;
						gint _tmp22__length1;
						gint _tmp23_ = 0;
						gchar** _tmp24_;
						gint _tmp24__length1;
						const gchar* _tmp25_;
						GtkButton* _tmp26_;
						GtkButton* _tmp27_;
						GtkButton* _tmp28_;
						_tmp22_ = budgie_notifications_action_box_get_actions (self, &_tmp23_);
						_tmp22__length1 = _tmp23_;
						_tmp24_ = _tmp22_;
						_tmp24__length1 = _tmp22__length1;
						_tmp25_ = _tmp24_[i + 1];
						_tmp26_ = (GtkButton*) gtk_button_new_with_label (_tmp25_);
						g_object_ref_sink (_tmp26_);
						_g_object_unref0 (button);
						button = _tmp26_;
						_tmp27_ = button;
						gtk_widget_set_can_focus ((GtkWidget*) _tmp27_, FALSE);
						_tmp28_ = button;
						gtk_widget_set_can_default ((GtkWidget*) _tmp28_, FALSE);
					}
					_tmp29_ = button;
					g_signal_connect_data (_tmp29_, "clicked", (GCallback) __budgie_notifications_action_box_______lambda10__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
					_tmp30_ = button;
					gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp30_);
					_g_object_unref0 (button);
					block4_data_unref (_data4_);
					_data4_ = NULL;
				} else {
					i += 2;
				}
			}
		}
	}
	return obj;
}

static void
budgie_notifications_action_box_class_init (BudgieNotificationsActionBoxClass * klass,
                                            gpointer klass_data)
{
	budgie_notifications_action_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieNotificationsActionBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_notifications_action_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_notifications_action_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_notifications_action_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_notifications_action_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY, budgie_notifications_action_box_properties[BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY] = g_param_spec_boxed ("actions", "actions", "actions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY, budgie_notifications_action_box_properties[BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY] = g_param_spec_boolean ("has-icons", "has-icons", "has-icons", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * Signal emitted when an action button is clicked.
	 */
	budgie_notifications_action_box_signals[BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTION_INVOKED_SIGNAL] = g_signal_new ("action-invoked", BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
budgie_notifications_action_box_instance_init (BudgieNotificationsActionBox * self,
                                               gpointer klass)
{
	self->priv = budgie_notifications_action_box_get_instance_private (self);
}

static void
budgie_notifications_action_box_finalize (GObject * obj)
{
	BudgieNotificationsActionBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBox);
	self->priv->_actions = (_vala_array_free (self->priv->_actions, self->priv->_actions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (budgie_notifications_action_box_parent_class)->finalize (obj);
}

/**
 * Holds the buttons for notification action buttons.
 */
static GType
budgie_notifications_action_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieNotificationsActionBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_notifications_action_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieNotificationsActionBox), 0, (GInstanceInitFunc) budgie_notifications_action_box_instance_init, NULL };
	GType budgie_notifications_action_box_type_id;
	budgie_notifications_action_box_type_id = g_type_register_static (gtk_button_box_get_type (), "BudgieNotificationsActionBox", &g_define_type_info, 0);
	BudgieNotificationsActionBox_private_offset = g_type_add_instance_private (budgie_notifications_action_box_type_id, sizeof (BudgieNotificationsActionBoxPrivate));
	return budgie_notifications_action_box_type_id;
}

GType
budgie_notifications_action_box_get_type (void)
{
	static volatile gsize budgie_notifications_action_box_type_id__once = 0;
	if (g_once_init_enter (&budgie_notifications_action_box_type_id__once)) {
		GType budgie_notifications_action_box_type_id;
		budgie_notifications_action_box_type_id = budgie_notifications_action_box_get_type_once ();
		g_once_init_leave (&budgie_notifications_action_box_type_id__once, budgie_notifications_action_box_type_id);
	}
	return budgie_notifications_action_box_type_id__once;
}

static void
_vala_budgie_notifications_action_box_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsActionBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBox);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, budgie_notifications_action_box_get_actions (self, &length));
		}
		break;
		case BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY:
		g_value_set_boolean (value, budgie_notifications_action_box_get_has_icons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_notifications_action_box_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	BudgieNotificationsActionBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_NOTIFICATIONS_TYPE_ACTION_BOX, BudgieNotificationsActionBox);
	switch (property_id) {
		case BUDGIE_NOTIFICATIONS_ACTION_BOX_ACTIONS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			budgie_notifications_action_box_set_actions (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BUDGIE_NOTIFICATIONS_ACTION_BOX_HAS_ICONS_PROPERTY:
		budgie_notifications_action_box_set_has_icons (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

