/* menus.c generated by valac 0.56.14, the Vala compiler
 * generated from menus.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#define BUDGIE_MENU_DBUS_NAME "org.budgie_desktop.MenuManager"
#define BUDGIE_MENU_DBUS_OBJECT_PATH "/org/budgie_desktop/MenuManager"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_MENU_MANAGER (budgie_menu_manager_get_type ())
#define BUDGIE_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManager))
#define BUDGIE_MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManagerClass))
#define BUDGIE_IS_MENU_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_MENU_MANAGER))
#define BUDGIE_IS_MENU_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_MENU_MANAGER))
#define BUDGIE_MENU_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManagerClass))

typedef struct _BudgieMenuManager BudgieMenuManager;
typedef struct _BudgieMenuManagerClass BudgieMenuManagerClass;
typedef struct _BudgieMenuManagerPrivate BudgieMenuManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block15Data Block15Data;
#define _budgie_menu_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_menu_manager_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _BudgieParamSpecMenuManager BudgieParamSpecMenuManager;

struct _BudgieMenuManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieMenuManagerPrivate * priv;
};

struct _BudgieMenuManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieMenuManager *self);
};

struct _BudgieMenuManagerPrivate {
	GtkMenu* desktop_menu;
	WnckWindow* active_window;
	WnckActionMenu* action_menu;
	guint32 xid;
};

struct _Block15Data {
	int _ref_count_;
	BudgieMenuManager* self;
	guint button;
	guint32 timestamp;
};

struct _Block16Data {
	int _ref_count_;
	BudgieMenuManager* self;
	guint button;
	guint32 timestamp;
};

struct _BudgieParamSpecMenuManager {
	GParamSpec parent_instance;
};

static gint BudgieMenuManager_private_offset;
static gpointer budgie_menu_manager_parent_class = NULL;
VALA_EXTERN gboolean budgie_setup;

VALA_EXTERN gpointer budgie_menu_manager_ref (gpointer instance);
VALA_EXTERN void budgie_menu_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_menu_manager (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void budgie_value_set_menu_manager (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void budgie_value_take_menu_manager (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_menu_manager (const GValue* value);
VALA_EXTERN GType budgie_menu_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieMenuManager, budgie_menu_manager_unref)
VALA_EXTERN guint budgie_menu_manager_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN BudgieMenuManager* budgie_menu_manager_new (void);
VALA_EXTERN BudgieMenuManager* budgie_menu_manager_construct (GType object_type);
static void budgie_menu_manager_init_desktop_menu (BudgieMenuManager* self);
static void budgie_menu_manager_budgie_activate (BudgieMenuManager* self);
static void _budgie_menu_manager_budgie_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self);
static void budgie_menu_manager_settings_activate (BudgieMenuManager* self);
static void _budgie_menu_manager_settings_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                    gpointer self);
static void budgie_menu_manager_launch_desktop_name (BudgieMenuManager* self,
                                              const gchar* desktop_name);
VALA_EXTERN void budgie_menu_manager_setup_dbus (BudgieMenuManager* self,
                                     gboolean replace);
static void budgie_menu_manager_on_bus_acquired (BudgieMenuManager* self,
                                          GDBusConnection* conn);
static void _budgie_menu_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  gpointer self);
static void __lambda59_ (BudgieMenuManager* self);
static void ___lambda59__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
VALA_EXTERN void budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                          guint button,
                                          guint32 timestamp,
                                          GError** error);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean __lambda60_ (Block15Data* _data15_);
static void budgie_menu_manager_popup_menu (BudgieMenuManager* self,
                                     GtkMenu* menu,
                                     guint button,
                                     guint32 timestamp);
static gboolean ___lambda60__gsource_func (gpointer self);
VALA_EXTERN void budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                         guint32 xid,
                                         guint button,
                                         guint32 timestamp,
                                         GError** error);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static gboolean __lambda61_ (Block16Data* _data16_);
static gboolean ___lambda61__gsource_func (gpointer self);
static void budgie_menu_manager_finalize (BudgieMenuManager * obj);
static GType budgie_menu_manager_get_type_once (void);
static void _dbus_budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void budgie_menu_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* budgie_menu_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean budgie_menu_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _budgie_menu_manager_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_button = {-1, "button", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_in[] = {&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_button, &_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_timestamp, NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_out[] = {NULL};
static const GDBusMethodInfo _budgie_menu_manager_dbus_method_info_ShowDesktopMenu = {-1, "ShowDesktopMenu", (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_in), (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowDesktopMenu_out), NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_xid = {-1, "xid", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_button = {-1, "button", "u", NULL};
static const GDBusArgInfo _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_in[] = {&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_xid, &_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_button, &_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_timestamp, NULL};
static const GDBusArgInfo * const _budgie_menu_manager_dbus_arg_info_ShowWindowMenu_out[] = {NULL};
static const GDBusMethodInfo _budgie_menu_manager_dbus_method_info_ShowWindowMenu = {-1, "ShowWindowMenu", (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_in), (GDBusArgInfo **) (&_budgie_menu_manager_dbus_arg_info_ShowWindowMenu_out), NULL};
static const GDBusMethodInfo * const _budgie_menu_manager_dbus_method_info[] = {&_budgie_menu_manager_dbus_method_info_ShowDesktopMenu, &_budgie_menu_manager_dbus_method_info_ShowWindowMenu, NULL};
static const GDBusSignalInfo * const _budgie_menu_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_menu_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_menu_manager_dbus_interface_info = {-1, "org.budgie_desktop.MenuManager", (GDBusMethodInfo **) (&_budgie_menu_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_menu_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_menu_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_menu_manager_dbus_interface_vtable = {budgie_menu_manager_dbus_interface_method_call, budgie_menu_manager_dbus_interface_get_property, budgie_menu_manager_dbus_interface_set_property};

static inline gpointer
budgie_menu_manager_get_instance_private (BudgieMenuManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieMenuManager_private_offset);
}

BudgieMenuManager*
budgie_menu_manager_construct (GType object_type)
{
	BudgieMenuManager* self = NULL;
	self = (BudgieMenuManager*) g_type_create_instance (object_type);
	budgie_menu_manager_init_desktop_menu (self);
	return self;
}

BudgieMenuManager*
budgie_menu_manager_new (void)
{
	return budgie_menu_manager_construct (BUDGIE_TYPE_MENU_MANAGER);
}

/**
* Construct the root level desktop menu (right click on wallpaper
*/
static void
_budgie_menu_manager_budgie_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                             gpointer self)
{
	budgie_menu_manager_budgie_activate ((BudgieMenuManager*) self);
}

static void
_budgie_menu_manager_settings_activate_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self)
{
	budgie_menu_manager_settings_activate ((BudgieMenuManager*) self);
}

static void
budgie_menu_manager_init_desktop_menu (BudgieMenuManager* self)
{
	GtkMenu* _tmp0_;
	GtkMenu* _tmp1_;
	GtkMenuItem* item = NULL;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkMenu* _tmp5_;
	GtkMenuItem* _tmp6_;
	GtkMenuItem* _tmp7_;
	GtkMenuItem* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkMenu* _tmp10_;
	GtkMenuItem* _tmp11_;
	GtkMenu* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->desktop_menu);
	self->priv->desktop_menu = _tmp0_;
	_tmp1_ = self->priv->desktop_menu;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Budgie Desktop Settings"));
	g_object_ref_sink (_tmp2_);
	item = _tmp2_;
	_tmp3_ = item;
	g_signal_connect (_tmp3_, "activate", (GCallback) _budgie_menu_manager_budgie_activate_gtk_menu_item_activate, self);
	_tmp4_ = item;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->desktop_menu;
	_tmp6_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp5_, _tmp6_);
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("System Settings"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (item);
	item = _tmp7_;
	_tmp8_ = item;
	g_signal_connect (_tmp8_, "activate", (GCallback) _budgie_menu_manager_settings_activate_gtk_menu_item_activate, self);
	_tmp9_ = item;
	gtk_widget_show ((GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->desktop_menu;
	_tmp11_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->desktop_menu;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	_g_object_unref0 (item);
}

/**
* Launch a .desktop name in a fail safe fashion
*/
static void
budgie_menu_manager_launch_desktop_name (BudgieMenuManager* self,
                                         const gchar* desktop_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desktop_name != NULL);
	{
		GDesktopAppInfo* info = NULL;
		GDesktopAppInfo* _tmp0_;
		GDesktopAppInfo* _tmp1_;
		_tmp0_ = g_desktop_app_info_new (desktop_name);
		info = _tmp0_;
		_tmp1_ = info;
		if (_tmp1_ != NULL) {
			GDesktopAppInfo* _tmp2_;
			_tmp2_ = info;
			g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("menus.vala:70: Unable to launch %s: %s", desktop_name, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
* Launch Budgie Desktop Settings
*/
static void
budgie_menu_manager_budgie_activate (BudgieMenuManager* self)
{
	g_return_if_fail (self != NULL);
	budgie_menu_manager_launch_desktop_name (self, "org.buddiesofbudgie.BudgieDesktopSettings.desktop");
}

/**
* Launch main settings (gnome control center)
*/
static void
budgie_menu_manager_settings_activate (BudgieMenuManager* self)
{
	g_return_if_fail (self != NULL);
	budgie_menu_manager_launch_desktop_name (self, "budgie-control-center.desktop");
}

/**
* Own the MENU_DBUS_NAME
*/
static void
_budgie_menu_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                             const gchar* name,
                                                             gpointer self)
{
	budgie_menu_manager_on_bus_acquired ((BudgieMenuManager*) self, connection);
}

static void
__lambda59_ (BudgieMenuManager* self)
{
}

static void
___lambda59__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda59_ ((BudgieMenuManager*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

void
budgie_menu_manager_setup_dbus (BudgieMenuManager* self,
                                gboolean replace)
{
	GBusNameOwnerFlags flags = 0U;
	g_return_if_fail (self != NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_MENU_DBUS_NAME, flags, (GClosure*) ((_budgie_menu_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_menu_manager_on_bus_acquired_gbus_acquired_callback, budgie_menu_manager_ref (self), (GClosureNotify) budgie_menu_manager_unref)), (GClosure*) ((___lambda59__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda59__gbus_name_acquired_callback, budgie_menu_manager_ref (self), (GClosureNotify) budgie_menu_manager_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
}

/**
* Acquired MENU_DBUS_NAME, register ourselves on the bus
*/
static void
budgie_menu_manager_on_bus_acquired (BudgieMenuManager* self,
                                     GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_menu_manager_register_object (self, conn, BUDGIE_MENU_DBUS_OBJECT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Error registering BudgieMenuManager: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	budgie_setup = TRUE;
}

/**
* We've been asked to display the root menu for the desktop itself,
* which contains actions for launching the settings, etc.
*/
static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		BudgieMenuManager* self;
		self = _data15_->self;
		_budgie_menu_manager_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
__lambda60_ (Block15Data* _data15_)
{
	BudgieMenuManager* self;
	GtkMenu* _tmp0_;
	gboolean result;
	self = _data15_->self;
	_tmp0_ = self->priv->desktop_menu;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		GtkMenu* _tmp1_;
		_tmp1_ = self->priv->desktop_menu;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		GtkMenu* _tmp2_;
		_tmp2_ = self->priv->desktop_menu;
		budgie_menu_manager_popup_menu (self, _tmp2_, _data15_->button, _data15_->timestamp);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda60__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda60_ (self);
	return result;
}

void
budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                     guint button,
                                     guint32 timestamp,
                                     GError** error)
{
	Block15Data* _data15_;
	g_return_if_fail (self != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = budgie_menu_manager_ref (self);
	_data15_->button = button;
	_data15_->timestamp = timestamp;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda60__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

/**
* Show a window menu for the given window ID
*/
static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		BudgieMenuManager* self;
		self = _data16_->self;
		_budgie_menu_manager_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static gboolean
__lambda61_ (Block16Data* _data16_)
{
	BudgieMenuManager* self;
	WnckWindow* _tmp0_;
	WnckActionMenu* _tmp1_;
	WnckActionMenu* _tmp2_;
	WnckActionMenu* _tmp3_;
	gboolean result;
	self = _data16_->self;
	_tmp0_ = self->priv->active_window;
	_tmp1_ = (WnckActionMenu*) wnck_action_menu_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->action_menu);
	self->priv->action_menu = _tmp1_;
	_tmp2_ = self->priv->action_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->action_menu;
	budgie_menu_manager_popup_menu (self, (GtkMenu*) _tmp3_, _data16_->button, _data16_->timestamp);
	result = FALSE;
	return result;
}

static gboolean
___lambda61__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda61_ (self);
	return result;
}

void
budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                    guint32 xid,
                                    guint button,
                                    guint32 timestamp,
                                    GError** error)
{
	Block16Data* _data16_;
	WnckWindow* _tmp0_;
	WnckWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = budgie_menu_manager_ref (self);
	_data16_->button = button;
	_data16_->timestamp = timestamp;
	_tmp0_ = wnck_window_get ((gulong) xid);
	self->priv->active_window = _tmp0_;
	_tmp1_ = self->priv->active_window;
	if (_tmp1_ == NULL) {
		g_warning ("menus.vala:134: invalid active_window");
		block16_data_unref (_data16_);
		_data16_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda61__gsource_func, block16_data_ref (_data16_), block16_data_unref);
	self->priv->xid = xid;
	block16_data_unref (_data16_);
	_data16_ = NULL;
}

static void
budgie_menu_manager_popup_menu (BudgieMenuManager* self,
                                GtkMenu* menu,
                                guint button,
                                guint32 timestamp)
{
	guint32 _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	if (timestamp == ((guint32) 0)) {
		_tmp0_ = (guint32) GDK_CURRENT_TIME;
	} else {
		_tmp0_ = timestamp;
	}
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, button, _tmp0_);
}

static void
budgie_value_menu_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_menu_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_menu_manager_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_menu_manager_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_menu_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_menu_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_menu_manager_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgieMenuManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_menu_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_menu_manager_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	BudgieMenuManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_menu_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_menu_manager (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	BudgieParamSpecMenuManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_MENU_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_menu_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MENU_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_menu_manager (GValue* value,
                               gpointer v_object)
{
	BudgieMenuManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MENU_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_MENU_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_menu_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_menu_manager_unref (old);
	}
}

void
budgie_value_take_menu_manager (GValue* value,
                                gpointer v_object)
{
	BudgieMenuManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_MENU_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_MENU_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_menu_manager_unref (old);
	}
}

static void
budgie_menu_manager_class_init (BudgieMenuManagerClass * klass,
                                gpointer klass_data)
{
	budgie_menu_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgieMenuManagerClass *) klass)->finalize = budgie_menu_manager_finalize;
	g_type_class_adjust_private_offset (klass, &BudgieMenuManager_private_offset);
}

static void
budgie_menu_manager_instance_init (BudgieMenuManager * self,
                                   gpointer klass)
{
	self->priv = budgie_menu_manager_get_instance_private (self);
	self->priv->desktop_menu = NULL;
	self->priv->active_window = NULL;
	self->priv->action_menu = NULL;
	self->priv->xid = (guint32) 0;
	self->ref_count = 1;
}

static void
budgie_menu_manager_finalize (BudgieMenuManager * obj)
{
	BudgieMenuManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_MENU_MANAGER, BudgieMenuManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->desktop_menu);
	_g_object_unref0 (self->priv->action_menu);
}

/**
* BudgieMenuManager is responsible for managing the right click menus of
* the budgie desktop over dbus, so that GTK+ isn't used inside the WM process
*/
static GType
budgie_menu_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_menu_manager_init, budgie_value_menu_manager_free_value, budgie_value_menu_manager_copy_value, budgie_value_menu_manager_peek_pointer, "p", budgie_value_menu_manager_collect_value, "p", budgie_value_menu_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgieMenuManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_menu_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieMenuManager), 0, (GInstanceInitFunc) budgie_menu_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_menu_manager_type_id;
	budgie_menu_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieMenuManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_set_qdata (budgie_menu_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_menu_manager_register_object);
	BudgieMenuManager_private_offset = g_type_add_instance_private (budgie_menu_manager_type_id, sizeof (BudgieMenuManagerPrivate));
	return budgie_menu_manager_type_id;
}

GType
budgie_menu_manager_get_type (void)
{
	static volatile gsize budgie_menu_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_menu_manager_type_id__once)) {
		GType budgie_menu_manager_type_id;
		budgie_menu_manager_type_id = budgie_menu_manager_get_type_once ();
		g_once_init_leave (&budgie_menu_manager_type_id__once, budgie_menu_manager_type_id);
	}
	return budgie_menu_manager_type_id__once;
}

gpointer
budgie_menu_manager_ref (gpointer instance)
{
	BudgieMenuManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_menu_manager_unref (gpointer instance)
{
	BudgieMenuManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_MENU_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_dbus_budgie_menu_manager_ShowDesktopMenu (BudgieMenuManager* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint button = 0U;
	GVariant* _tmp69_;
	guint32 timestamp = 0U;
	GVariant* _tmp70_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp69_ = g_variant_iter_next_value (&_arguments_iter);
	button = g_variant_get_uint32 (_tmp69_);
	g_variant_unref (_tmp69_);
	_tmp70_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp70_);
	g_variant_unref (_tmp70_);
	budgie_menu_manager_ShowDesktopMenu (self, button, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_menu_manager_ShowWindowMenu (BudgieMenuManager* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 xid = 0U;
	GVariant* _tmp71_;
	guint button = 0U;
	GVariant* _tmp72_;
	guint32 timestamp = 0U;
	GVariant* _tmp73_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp71_ = g_variant_iter_next_value (&_arguments_iter);
	xid = g_variant_get_uint32 (_tmp71_);
	g_variant_unref (_tmp71_);
	_tmp72_ = g_variant_iter_next_value (&_arguments_iter);
	button = g_variant_get_uint32 (_tmp72_);
	g_variant_unref (_tmp72_);
	_tmp73_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp73_);
	g_variant_unref (_tmp73_);
	budgie_menu_manager_ShowWindowMenu (self, xid, button, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_menu_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowDesktopMenu") == 0) {
		_dbus_budgie_menu_manager_ShowDesktopMenu (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowWindowMenu") == 0) {
		_dbus_budgie_menu_manager_ShowWindowMenu (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_menu_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_menu_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_menu_manager_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = budgie_menu_manager_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_menu_manager_dbus_interface_info), &_budgie_menu_manager_dbus_interface_vtable, data, _budgie_menu_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_menu_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	budgie_menu_manager_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

