/* endsession.c generated by valac 0.56.14, the Vala compiler
 * generated from endsession.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_INHIBITOR (budgie_inhibitor_get_type ())
#define BUDGIE_INHIBITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_INHIBITOR, BudgieInhibitor))
#define BUDGIE_IS_INHIBITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_INHIBITOR))
#define BUDGIE_INHIBITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_INHIBITOR, BudgieInhibitorIface))

typedef struct _BudgieInhibitor BudgieInhibitor;
typedef struct _BudgieInhibitorIface BudgieInhibitorIface;

#define BUDGIE_TYPE_INHIBITOR_PROXY (budgie_inhibitor_proxy_get_type ())
typedef GDBusProxy BudgieInhibitorProxy;
typedef GDBusProxyClass BudgieInhibitorProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	BUDGIE_DIALOG_TYPE_LOGOUT = 0,
	BUDGIE_DIALOG_TYPE_SHUTDOWN = 1,
	BUDGIE_DIALOG_TYPE_RESTART = 2,
	BUDGIE_DIALOG_TYPE_UPDATE_RESTART = 3
} BudgieDialogType;

#define BUDGIE_TYPE_DIALOG_TYPE (budgie_dialog_type_get_type ())

#define BUDGIE_TYPE_END_SESSION_DIALOG (budgie_end_session_dialog_get_type ())
#define BUDGIE_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog))
#define BUDGIE_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))
#define BUDGIE_IS_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_IS_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_END_SESSION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))

typedef struct _BudgieEndSessionDialog BudgieEndSessionDialog;
typedef struct _BudgieEndSessionDialogClass BudgieEndSessionDialogClass;
typedef struct _BudgieEndSessionDialogPrivate BudgieEndSessionDialogPrivate;
enum  {
	BUDGIE_END_SESSION_DIALOG_0_PROPERTY,
	BUDGIE_END_SESSION_DIALOG_NUM_PROPERTIES
};
static GParamSpec* budgie_end_session_dialog_properties[BUDGIE_END_SESSION_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BUDGIE_END_SESSION_DIALOG_CONFIRMED_LOGOUT_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_CONFIRMED_REBOOT_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_CONFIRMED_SHUTDOWN_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_CANCELED_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_OPENED_SIGNAL,
	BUDGIE_END_SESSION_DIALOG_NUM_SIGNALS
};
static guint budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_NUM_SIGNALS] = {0};

struct _BudgieInhibitorIface {
	GTypeInterface parent_iface;
	gchar* (*GetAppId) (BudgieInhibitor* self, GError** error);
	gchar* (*GetReason) (BudgieInhibitor* self, GError** error);
};

struct _BudgieEndSessionDialog {
	GtkWindow parent_instance;
	BudgieEndSessionDialogPrivate * priv;
};

struct _BudgieEndSessionDialogClass {
	GtkWindowClass parent_class;
};

struct _BudgieEndSessionDialogPrivate {
	GtkButton* button_logout;
	GtkButton* button_restart;
	GtkButton* button_shutdown;
	GtkLabel* label_end_title;
};

static gint BudgieEndSessionDialog_private_offset;
static gpointer budgie_end_session_dialog_parent_class = NULL;
VALA_EXTERN gboolean budgie_setup;

VALA_EXTERN GType budgie_inhibitor_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint budgie_inhibitor_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType budgie_inhibitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieInhibitor, g_object_unref)
VALA_EXTERN gchar* budgie_inhibitor_GetAppId (BudgieInhibitor* self,
                                  GError** error);
VALA_EXTERN gchar* budgie_inhibitor_GetReason (BudgieInhibitor* self,
                                   GError** error);
static GType budgie_inhibitor_get_type_once (void);
static void budgie_inhibitor_proxy_g_signal (GDBusProxy* proxy,
                                      const gchar* sender_name,
                                      const gchar* signal_name,
                                      GVariant* parameters);
static gchar* budgie_inhibitor_proxy_GetAppId (BudgieInhibitor* self,
                                        GError** error);
static gchar* budgie_inhibitor_proxy_GetReason (BudgieInhibitor* self,
                                         GError** error);
static void budgie_inhibitor_proxy_budgie_inhibitor_interface_init (BudgieInhibitorIface* iface);
static void _dbus_budgie_inhibitor_GetAppId (BudgieInhibitor* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_budgie_inhibitor_GetReason (BudgieInhibitor* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void budgie_inhibitor_dbus_interface_method_call (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* method_name,
                                                  GVariant* parameters,
                                                  GDBusMethodInvocation* invocation,
                                                  gpointer user_data);
static GVariant* budgie_inhibitor_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data);
static gboolean budgie_inhibitor_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data);
static void _budgie_inhibitor_unregister_object (gpointer user_data);
VALA_EXTERN GType budgie_dialog_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType budgie_end_session_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieEndSessionDialog, g_object_unref)
VALA_EXTERN guint budgie_end_session_dialog_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
static void budgie_end_session_dialog_cancel_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void budgie_end_session_dialog_logout_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_logout_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void budgie_end_session_dialog_restart_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_restart_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void budgie_end_session_dialog_shutdown_clicked (BudgieEndSessionDialog* self);
static void _budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void budgie_end_session_dialog_on_bus_acquired (BudgieEndSessionDialog* self,
                                                GDBusConnection* conn);
static void budgie_end_session_dialog_on_realized (BudgieEndSessionDialog* self);
static void budgie_end_session_dialog_on_composite_changed (BudgieEndSessionDialog* self);
VALA_EXTERN BudgieEndSessionDialog* budgie_end_session_dialog_new (gboolean replace);
VALA_EXTERN BudgieEndSessionDialog* budgie_end_session_dialog_construct (GType object_type,
                                                             gboolean replace);
static void _budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self);
static void __lambda4_ (BudgieEndSessionDialog* self);
static void ___lambda4__gbus_name_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static void _budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                     const gchar* name,
                                                     gpointer self);
static void _budgie_end_session_dialog_on_realized_gtk_widget_realize (GtkWidget* _sender,
                                                                gpointer self);
static void _budgie_end_session_dialog_on_composite_changed_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                                    gpointer self);
static gboolean __lambda5_ (BudgieEndSessionDialog* self);
static gboolean ___lambda5__gtk_widget_delete_event (GtkWidget* _sender,
                                              GdkEventAny* event,
                                              gpointer self);
VALA_EXTERN void budgie_end_session_dialog_Open (BudgieEndSessionDialog* self,
                                     guint type,
                                     guint timestamp,
                                     guint open_length,
                                     char** inhibiters,
                                     gint inhibiters_length1,
                                     GError** error);
VALA_EXTERN void budgie_end_session_dialog_Close (BudgieEndSessionDialog* self,
                                      GError** error);
static void budgie_end_session_dialog_finalize (GObject * obj);
static GType budgie_end_session_dialog_get_type_once (void);
static void _dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender,
                                                       gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender,
                                                       gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender,
                                                         gpointer* _data);
static void _dbus_budgie_end_session_dialog_canceled (GObject* _sender,
                                               gpointer* _data);
static void _dbus_budgie_end_session_dialog_closed (GObject* _sender,
                                             gpointer* _data);
static void _dbus_budgie_end_session_dialog_opened (GObject* _sender,
                                             gpointer* _data);
static void _budgie_end_session_dialog_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _budgie_inhibitor_dbus_arg_info_GetAppId_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetAppId_in[] = {NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetAppId_out[] = {&_budgie_inhibitor_dbus_arg_info_GetAppId_result, NULL};
static const GDBusMethodInfo _budgie_inhibitor_dbus_method_info_GetAppId = {-1, "GetAppId", (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetAppId_in), (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetAppId_out), NULL};
static const GDBusArgInfo _budgie_inhibitor_dbus_arg_info_GetReason_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetReason_in[] = {NULL};
static const GDBusArgInfo * const _budgie_inhibitor_dbus_arg_info_GetReason_out[] = {&_budgie_inhibitor_dbus_arg_info_GetReason_result, NULL};
static const GDBusMethodInfo _budgie_inhibitor_dbus_method_info_GetReason = {-1, "GetReason", (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetReason_in), (GDBusArgInfo **) (&_budgie_inhibitor_dbus_arg_info_GetReason_out), NULL};
static const GDBusMethodInfo * const _budgie_inhibitor_dbus_method_info[] = {&_budgie_inhibitor_dbus_method_info_GetAppId, &_budgie_inhibitor_dbus_method_info_GetReason, NULL};
static const GDBusSignalInfo * const _budgie_inhibitor_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_inhibitor_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_inhibitor_dbus_interface_info = {-1, "org.gnome.SessionManager.Inhibitor", (GDBusMethodInfo **) (&_budgie_inhibitor_dbus_method_info), (GDBusSignalInfo **) (&_budgie_inhibitor_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_inhibitor_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_inhibitor_dbus_interface_vtable = {budgie_inhibitor_dbus_interface_method_call, budgie_inhibitor_dbus_interface_get_property, budgie_inhibitor_dbus_interface_set_property};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_type = {-1, "type", "u", NULL};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_timestamp = {-1, "timestamp", "u", NULL};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_open_length = {-1, "open_length", "u", NULL};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_inhibiters = {-1, "inhibiters", "ao", NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_in[] = {&_budgie_end_session_dialog_dbus_arg_info_Open_type, &_budgie_end_session_dialog_dbus_arg_info_Open_timestamp, &_budgie_end_session_dialog_dbus_arg_info_Open_open_length, &_budgie_end_session_dialog_dbus_arg_info_Open_inhibiters, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Open = {-1, "Open", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_out), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_out), NULL};
static const GDBusMethodInfo * const _budgie_end_session_dialog_dbus_method_info[] = {&_budgie_end_session_dialog_dbus_method_info_Open, &_budgie_end_session_dialog_dbus_method_info_Close, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_logout[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_logout = {-1, "ConfirmedLogout", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_logout), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_reboot[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_reboot = {-1, "ConfirmedReboot", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_reboot), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown = {-1, "ConfirmedShutdown", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_canceled[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_canceled = {-1, "Canceled", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_canceled), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_closed[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_closed = {-1, "Closed", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_closed), NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_opened[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_opened = {-1, "Opened", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_opened), NULL};
static const GDBusSignalInfo * const _budgie_end_session_dialog_dbus_signal_info[] = {&_budgie_end_session_dialog_dbus_signal_info_confirmed_logout, &_budgie_end_session_dialog_dbus_signal_info_confirmed_reboot, &_budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown, &_budgie_end_session_dialog_dbus_signal_info_canceled, &_budgie_end_session_dialog_dbus_signal_info_closed, &_budgie_end_session_dialog_dbus_signal_info_opened, NULL};
static const GDBusPropertyInfo * const _budgie_end_session_dialog_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_end_session_dialog_dbus_interface_info = {-1, "org.budgie_desktop.Session.EndSessionDialog", (GDBusMethodInfo **) (&_budgie_end_session_dialog_dbus_method_info), (GDBusSignalInfo **) (&_budgie_end_session_dialog_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_end_session_dialog_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_end_session_dialog_dbus_interface_vtable = {budgie_end_session_dialog_dbus_interface_method_call, budgie_end_session_dialog_dbus_interface_get_property, budgie_end_session_dialog_dbus_interface_set_property};

gchar*
budgie_inhibitor_GetAppId (BudgieInhibitor* self,
                           GError** error)
{
	BudgieInhibitorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BUDGIE_INHIBITOR_GET_INTERFACE (self);
	if (_iface_->GetAppId) {
		return _iface_->GetAppId (self, error);
	}
	return NULL;
}

gchar*
budgie_inhibitor_GetReason (BudgieInhibitor* self,
                            GError** error)
{
	BudgieInhibitorIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BUDGIE_INHIBITOR_GET_INTERFACE (self);
	if (_iface_->GetReason) {
		return _iface_->GetReason (self, error);
	}
	return NULL;
}

static void
budgie_inhibitor_default_init (BudgieInhibitorIface * iface,
                               gpointer iface_data)
{
}

static GType
budgie_inhibitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieInhibitorIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_inhibitor_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_inhibitor_type_id;
	budgie_inhibitor_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieInhibitor", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_inhibitor_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_inhibitor_proxy_get_type);
	g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.Inhibitor");
	g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_inhibitor_dbus_interface_info));
	g_type_set_qdata (budgie_inhibitor_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_inhibitor_register_object);
	return budgie_inhibitor_type_id;
}

GType
budgie_inhibitor_get_type (void)
{
	static volatile gsize budgie_inhibitor_type_id__once = 0;
	if (g_once_init_enter (&budgie_inhibitor_type_id__once)) {
		GType budgie_inhibitor_type_id;
		budgie_inhibitor_type_id = budgie_inhibitor_get_type_once ();
		g_once_init_leave (&budgie_inhibitor_type_id__once, budgie_inhibitor_type_id);
	}
	return budgie_inhibitor_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieInhibitorProxy, budgie_inhibitor_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_INHIBITOR, budgie_inhibitor_proxy_budgie_inhibitor_interface_init) )
static void
budgie_inhibitor_proxy_class_init (BudgieInhibitorProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_inhibitor_proxy_g_signal;
}

static void
budgie_inhibitor_proxy_g_signal (GDBusProxy* proxy,
                                 const gchar* sender_name,
                                 const gchar* signal_name,
                                 GVariant* parameters)
{
}

static void
budgie_inhibitor_proxy_init (BudgieInhibitorProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_inhibitor_dbus_interface_info));
}

static gchar*
budgie_inhibitor_proxy_GetAppId (BudgieInhibitor* self,
                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp0_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.Inhibitor", "GetAppId");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}

static gchar*
budgie_inhibitor_proxy_GetReason (BudgieInhibitor* self,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp1_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.Inhibitor", "GetReason");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_object_unref (_reply_message);
	return _result;
}

static void
budgie_inhibitor_proxy_budgie_inhibitor_interface_init (BudgieInhibitorIface* iface)
{
	iface->GetAppId = budgie_inhibitor_proxy_GetAppId;
	iface->GetReason = budgie_inhibitor_proxy_GetReason;
}

static void
_dbus_budgie_inhibitor_GetAppId (BudgieInhibitor* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_inhibitor_GetAppId (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_inhibitor_GetReason (BudgieInhibitor* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_inhibitor_GetReason (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_inhibitor_dbus_interface_method_call (GDBusConnection* connection,
                                             const gchar* sender,
                                             const gchar* object_path,
                                             const gchar* interface_name,
                                             const gchar* method_name,
                                             GVariant* parameters,
                                             GDBusMethodInvocation* invocation,
                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetAppId") == 0) {
		_dbus_budgie_inhibitor_GetAppId (object, parameters, invocation);
	} else if (strcmp (method_name, "GetReason") == 0) {
		_dbus_budgie_inhibitor_GetReason (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_inhibitor_dbus_interface_get_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_inhibitor_dbus_interface_set_property (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* property_name,
                                              GVariant* value,
                                              GError** error,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_inhibitor_register_object (gpointer object,
                                  GDBusConnection* connection,
                                  const gchar* path,
                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_inhibitor_dbus_interface_info), &_budgie_inhibitor_dbus_interface_vtable, data, _budgie_inhibitor_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_inhibitor_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static GType
budgie_dialog_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BUDGIE_DIALOG_TYPE_LOGOUT, "BUDGIE_DIALOG_TYPE_LOGOUT", "logout"}, {BUDGIE_DIALOG_TYPE_SHUTDOWN, "BUDGIE_DIALOG_TYPE_SHUTDOWN", "shutdown"}, {BUDGIE_DIALOG_TYPE_RESTART, "BUDGIE_DIALOG_TYPE_RESTART", "restart"}, {BUDGIE_DIALOG_TYPE_UPDATE_RESTART, "BUDGIE_DIALOG_TYPE_UPDATE_RESTART", "update-restart"}, {0, NULL, NULL}};
	GType budgie_dialog_type_type_id;
	budgie_dialog_type_type_id = g_enum_register_static ("BudgieDialogType", values);
	return budgie_dialog_type_type_id;
}

GType
budgie_dialog_type_get_type (void)
{
	static volatile gsize budgie_dialog_type_type_id__once = 0;
	if (g_once_init_enter (&budgie_dialog_type_type_id__once)) {
		GType budgie_dialog_type_type_id;
		budgie_dialog_type_type_id = budgie_dialog_type_get_type_once ();
		g_once_init_leave (&budgie_dialog_type_type_id__once, budgie_dialog_type_type_id);
	}
	return budgie_dialog_type_type_id__once;
}

static inline gpointer
budgie_end_session_dialog_get_instance_private (BudgieEndSessionDialog* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieEndSessionDialog_private_offset);
}

static void
budgie_end_session_dialog_cancel_clicked (BudgieEndSessionDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CANCELED_SIGNAL], 0);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL], 0);
	gtk_widget_hide ((GtkWidget*) self);
}

static void
_budgie_end_session_dialog_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	budgie_end_session_dialog_cancel_clicked ((BudgieEndSessionDialog*) self);
}

static void
budgie_end_session_dialog_logout_clicked (BudgieEndSessionDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL], 0);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_LOGOUT_SIGNAL], 0);
}

static void
_budgie_end_session_dialog_logout_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	budgie_end_session_dialog_logout_clicked ((BudgieEndSessionDialog*) self);
}

static void
budgie_end_session_dialog_restart_clicked (BudgieEndSessionDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL], 0);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_REBOOT_SIGNAL], 0);
}

static void
_budgie_end_session_dialog_restart_clicked_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	budgie_end_session_dialog_restart_clicked ((BudgieEndSessionDialog*) self);
}

static void
budgie_end_session_dialog_shutdown_clicked (BudgieEndSessionDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL], 0);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_SHUTDOWN_SIGNAL], 0);
}

static void
_budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	budgie_end_session_dialog_shutdown_clicked ((BudgieEndSessionDialog*) self);
}

static void
budgie_end_session_dialog_on_bus_acquired (BudgieEndSessionDialog* self,
                                           GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_end_session_dialog_register_object (self, conn, "/org/budgie_desktop/Session/EndSessionDialog", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("endsession.vala:83: Cannot register EndSessionDialog");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	budgie_setup = TRUE;
}

/**
* Attempt to set the RGBA visual
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
budgie_end_session_dialog_on_realized (BudgieEndSessionDialog* self)
{
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	}
	_g_object_unref0 (visual);
}

/**
* Update the RGBA visual if its available when compositing changes
* This is required as we may be constructed before the window manager
* springs into life
*/
static void
budgie_end_session_dialog_on_composite_changed (BudgieEndSessionDialog* self)
{
	GdkVisual* visual = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gdk_screen_get_rgba_visual (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	visual = _tmp3_;
	_tmp4_ = visual;
	if (_tmp4_ != NULL) {
		GdkVisual* _tmp5_;
		_tmp5_ = visual;
		gtk_widget_set_visual ((GtkWidget*) self, _tmp5_);
	} else {
		GdkScreen* _tmp6_;
		GdkScreen* _tmp7_;
		GdkVisual* _tmp8_;
		_tmp6_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gdk_screen_get_system_visual (_tmp7_);
		gtk_widget_set_visual ((GtkWidget*) self, _tmp8_);
	}
	_g_object_unref0 (visual);
}

static void
_budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self)
{
	budgie_end_session_dialog_on_bus_acquired ((BudgieEndSessionDialog*) self, connection);
}

static void
__lambda4_ (BudgieEndSessionDialog* self)
{
}

static void
___lambda4__gbus_name_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda4_ ((BudgieEndSessionDialog*) self);
}

static void
_budgie_DaemonNameLost_gbus_name_lost_callback (GDBusConnection* connection,
                                                const gchar* name,
                                                gpointer self)
{
	budgie_DaemonNameLost (connection, name);
}

static void
_budgie_end_session_dialog_on_realized_gtk_widget_realize (GtkWidget* _sender,
                                                           gpointer self)
{
	budgie_end_session_dialog_on_realized ((BudgieEndSessionDialog*) self);
}

static void
_budgie_end_session_dialog_on_composite_changed_gdk_screen_composited_changed (GdkScreen* _sender,
                                                                               gpointer self)
{
	budgie_end_session_dialog_on_composite_changed ((BudgieEndSessionDialog*) self);
}

static gboolean
__lambda5_ (BudgieEndSessionDialog* self)
{
	gboolean result;
	budgie_end_session_dialog_cancel_clicked (self);
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
___lambda5__gtk_widget_delete_event (GtkWidget* _sender,
                                     GdkEventAny* event,
                                     gpointer self)
{
	gboolean result;
	result = __lambda5_ ((BudgieEndSessionDialog*) self);
	return result;
}

BudgieEndSessionDialog*
budgie_end_session_dialog_construct (GType object_type,
                                     gboolean replace)
{
	BudgieEndSessionDialog * self = NULL;
	GBusNameOwnerFlags flags = 0U;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GtkEventBox* header = NULL;
	GtkEventBox* _tmp2_;
	GtkStyleContext* _tmp3_;
	self = (BudgieEndSessionDialog*) g_object_new (object_type, NULL);
	flags = G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.budgie_desktop.Session.EndSessionDialog", flags, (GClosure*) ((_budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_end_session_dialog_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda4__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda4__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) g_cclosure_new ((GCallback) _budgie_DaemonNameLost_gbus_name_lost_callback, NULL, (GClosureNotify) NULL));
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) _budgie_end_session_dialog_on_realized_gtk_widget_realize, self, 0);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object (_tmp1_, "composited-changed", (GCallback) _budgie_end_session_dialog_on_composite_changed_gdk_screen_composited_changed, self, 0);
	_tmp2_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp2_);
	header = _tmp2_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) header);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) header);
	gtk_style_context_remove_class (_tmp3_, "titlebar");
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda5__gtk_widget_delete_event, self, 0);
	_g_object_unref0 (header);
	return self;
}

BudgieEndSessionDialog*
budgie_end_session_dialog_new (gboolean replace)
{
	return budgie_end_session_dialog_construct (BUDGIE_TYPE_END_SESSION_DIALOG, replace);
}

void
budgie_end_session_dialog_Open (BudgieEndSessionDialog* self,
                                guint type,
                                guint timestamp,
                                guint open_length,
                                char** inhibiters,
                                gint inhibiters_length1,
                                GError** error)
{
	GtkWidget* main_show = NULL;
	GtkWidget* all_widgets[3] = {0};
	GtkButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_[3] = {0};
	gchar* title = NULL;
	const gchar* _tmp12_;
	GtkLabel* _tmp14_;
	const gchar* _tmp15_;
	GtkWidget* _tmp16_;
	GdkWindow* win = NULL;
	GdkWindow* _tmp32_;
	GdkWindow* _tmp33_;
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_OPENED_SIGNAL], 0);
	main_show = NULL;
	_tmp0_ = self->priv->button_logout;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->button_restart;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = self->priv->button_shutdown;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_[0] = _tmp1_;
	_tmp6_[1] = _tmp3_;
	_tmp6_[2] = _tmp5_;
	memcpy (all_widgets, _tmp6_, 3 * sizeof (GtkWidget*));
	title = NULL;
	switch (type) {
		case BUDGIE_DIALOG_TYPE_LOGOUT:
		{
			GtkButton* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->button_logout;
			main_show = (GtkWidget*) _tmp7_;
			_tmp8_ = g_strdup (_ ("Log out"));
			_g_free0 (title);
			title = _tmp8_;
			break;
		}
		case BUDGIE_DIALOG_TYPE_RESTART:
		case BUDGIE_DIALOG_TYPE_UPDATE_RESTART:
		{
			gchar* _tmp9_;
			GtkButton* _tmp10_;
			_tmp9_ = g_strdup (_ ("Restart device"));
			_g_free0 (title);
			title = _tmp9_;
			_tmp10_ = self->priv->button_restart;
			main_show = (GtkWidget*) _tmp10_;
			break;
		}
		case BUDGIE_DIALOG_TYPE_SHUTDOWN:
		{
			GtkButton* _tmp11_;
			_tmp11_ = self->priv->button_shutdown;
			main_show = (GtkWidget*) _tmp11_;
			break;
		}
		default:
		{
			main_show = NULL;
			break;
		}
	}
	_tmp12_ = title;
	if (_tmp12_ == NULL) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (_ ("Power Off"));
		_g_free0 (title);
		title = _tmp13_;
	}
	_tmp14_ = self->priv->label_end_title;
	_tmp15_ = title;
	gtk_label_set_text (_tmp14_, _tmp15_);
	_tmp16_ = main_show;
	if (_tmp16_ != NULL) {
		GtkWidget* _tmp23_;
		GtkWidget* _tmp24_;
		GtkWidget* _tmp25_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					GtkWidget* w = NULL;
					GtkWidget* _tmp19_;
					GtkWidget* _tmp20_;
					GtkWidget* _tmp21_;
					GtkWidget* _tmp22_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					if (!(i < 3)) {
						break;
					}
					_tmp19_ = all_widgets[i];
					w = _tmp19_;
					_tmp20_ = main_show;
					_tmp21_ = w;
					if (_tmp20_ == _tmp21_) {
						continue;
					}
					_tmp22_ = w;
					gtk_widget_hide (_tmp22_);
				}
			}
		}
		_tmp23_ = main_show;
		gtk_widget_show (_tmp23_);
		_tmp24_ = main_show;
		_tmp25_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_bin_get_type (), GtkBin));
		gtk_widget_show (_tmp25_);
	} else {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp26_ = FALSE;
				_tmp26_ = TRUE;
				while (TRUE) {
					GtkWidget* w = NULL;
					GtkWidget* _tmp28_;
					GtkWidget* _tmp29_;
					GtkWidget* _tmp30_;
					GtkWidget* _tmp31_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp26_ = FALSE;
					if (!(i < 3)) {
						break;
					}
					_tmp28_ = all_widgets[i];
					w = _tmp28_;
					_tmp29_ = w;
					gtk_widget_show (_tmp29_);
					_tmp30_ = w;
					_tmp31_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_bin_get_type (), GtkBin));
					gtk_widget_show (_tmp31_);
				}
			}
		}
	}
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
		gtk_widget_realize ((GtkWidget*) self);
	}
	gtk_window_present ((GtkWindow*) self);
	_tmp32_ = gtk_widget_get_window ((GtkWidget*) self);
	win = _tmp32_;
	_tmp33_ = win;
	if (_tmp33_ != NULL) {
		GdkDisplay* display = NULL;
		GdkScreen* _tmp34_;
		GdkScreen* _tmp35_;
		GdkDisplay* _tmp36_;
		GdkDisplay* _tmp37_;
		GdkDisplay* _tmp38_;
		_tmp34_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp35_ = _tmp34_;
		_tmp36_ = gdk_screen_get_display (_tmp35_);
		_tmp37_ = _g_object_ref0 (_tmp36_);
		display = _tmp37_;
		_tmp38_ = display;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, gdk_x11_display_get_type ())) {
			GdkWindow* _tmp39_;
			GdkDisplay* _tmp40_;
			_tmp39_ = win;
			_tmp40_ = display;
			gdk_window_focus (_tmp39_, gdk_x11_display_get_user_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gdk_x11_display_get_type (), GdkX11Display)));
		} else {
			GdkWindow* _tmp41_;
			_tmp41_ = win;
			gdk_window_focus (_tmp41_, gtk_get_current_event_time ());
		}
		_g_object_unref0 (display);
	}
	_g_free0 (title);
	_vala_array_destroy (all_widgets, 3, (GDestroyNotify) g_object_unref);
}

void
budgie_end_session_dialog_Close (BudgieEndSessionDialog* self,
                                 GError** error)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_signal_emit (self, budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL], 0);
}

static void
budgie_end_session_dialog_class_init (BudgieEndSessionDialogClass * klass,
                                      gpointer klass_data)
{
	budgie_end_session_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieEndSessionDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_end_session_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/budgie/endsession/endsession.ui");
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_LOGOUT_SIGNAL] = g_signal_new ("confirmed-logout", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_REBOOT_SIGNAL] = g_signal_new ("confirmed-reboot", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CONFIRMED_SHUTDOWN_SIGNAL] = g_signal_new ("confirmed-shutdown", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CANCELED_SIGNAL] = g_signal_new ("canceled", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_CLOSED_SIGNAL] = g_signal_new ("closed", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	budgie_end_session_dialog_signals[BUDGIE_END_SESSION_DIALOG_OPENED_SIGNAL] = g_signal_new ("opened", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_logout", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_logout));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_restart", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_restart));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_shutdown", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, button_shutdown));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_end_title", FALSE, BudgieEndSessionDialog_private_offset + G_STRUCT_OFFSET (BudgieEndSessionDialogPrivate, label_end_title));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_clicked", G_CALLBACK(_budgie_end_session_dialog_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "logout_clicked", G_CALLBACK(_budgie_end_session_dialog_logout_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "restart_clicked", G_CALLBACK(_budgie_end_session_dialog_restart_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "shutdown_clicked", G_CALLBACK(_budgie_end_session_dialog_shutdown_clicked_gtk_button_clicked));
}

static void
budgie_end_session_dialog_instance_init (BudgieEndSessionDialog * self,
                                         gpointer klass)
{
	self->priv = budgie_end_session_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
budgie_end_session_dialog_finalize (GObject * obj)
{
	BudgieEndSessionDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog);
	G_OBJECT_CLASS (budgie_end_session_dialog_parent_class)->finalize (obj);
}

static GType
budgie_end_session_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieEndSessionDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_end_session_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieEndSessionDialog), 0, (GInstanceInitFunc) budgie_end_session_dialog_instance_init, NULL };
	GType budgie_end_session_dialog_type_id;
	budgie_end_session_dialog_type_id = g_type_register_static (gtk_window_get_type (), "BudgieEndSessionDialog", &g_define_type_info, 0);
	g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_end_session_dialog_register_object);
	BudgieEndSessionDialog_private_offset = g_type_add_instance_private (budgie_end_session_dialog_type_id, sizeof (BudgieEndSessionDialogPrivate));
	return budgie_end_session_dialog_type_id;
}

GType
budgie_end_session_dialog_get_type (void)
{
	static volatile gsize budgie_end_session_dialog_type_id__once = 0;
	if (g_once_init_enter (&budgie_end_session_dialog_type_id__once)) {
		GType budgie_end_session_dialog_type_id;
		budgie_end_session_dialog_type_id = budgie_end_session_dialog_get_type_once ();
		g_once_init_leave (&budgie_end_session_dialog_type_id__once, budgie_end_session_dialog_type_id);
	}
	return budgie_end_session_dialog_type_id__once;
}

static void
_dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint type = 0U;
	GVariant* _tmp2_;
	guint timestamp = 0U;
	GVariant* _tmp3_;
	guint open_length = 0U;
	GVariant* _tmp4_;
	char** inhibiters = NULL;
	gint inhibiters_length1 = 0;
	GVariant* _tmp5_;
	char** _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	open_length = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (char*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (char*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	inhibiters_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	inhibiters = _tmp6_;
	g_variant_unref (_tmp5_);
	budgie_end_session_dialog_Open (self, type, timestamp, open_length, inhibiters, inhibiters_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	inhibiters = (_vala_array_free (inhibiters, inhibiters_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_end_session_dialog_Close (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Open") == 0) {
		_dbus_budgie_end_session_dialog_Open (object, parameters, invocation);
	} else if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_end_session_dialog_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "ConfirmedLogout", _arguments, NULL);
}

static void
_dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender,
                                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "ConfirmedReboot", _arguments, NULL);
}

static void
_dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender,
                                                    gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "ConfirmedShutdown", _arguments, NULL);
}

static void
_dbus_budgie_end_session_dialog_canceled (GObject* _sender,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "Canceled", _arguments, NULL);
}

static void
_dbus_budgie_end_session_dialog_closed (GObject* _sender,
                                        gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "Closed", _arguments, NULL);
}

static void
_dbus_budgie_end_session_dialog_opened (GObject* _sender,
                                        gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.budgie_desktop.Session.EndSessionDialog", "Opened", _arguments, NULL);
}

guint
budgie_end_session_dialog_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_end_session_dialog_dbus_interface_info), &_budgie_end_session_dialog_dbus_interface_vtable, data, _budgie_end_session_dialog_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "confirmed-logout", (GCallback) _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_connect (object, "confirmed-reboot", (GCallback) _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_connect (object, "confirmed-shutdown", (GCallback) _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_connect (object, "canceled", (GCallback) _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_connect (object, "closed", (GCallback) _dbus_budgie_end_session_dialog_closed, data);
	g_signal_connect (object, "opened", (GCallback) _dbus_budgie_end_session_dialog_opened, data);
	return result;
}

static void
_budgie_end_session_dialog_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_closed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_opened, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

