/* Switcheroo.c generated by valac 0.56.14, the Vala compiler
 * generated from Switcheroo.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-appindexer.h"
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include <glib-object.h>

typedef GDBusProxy BudgieSwitcherooDBusProxy;
typedef GDBusProxyClass BudgieSwitcherooDBusProxyClass;
enum  {
	BUDGIE_SWITCHEROO_0_PROPERTY,
	BUDGIE_SWITCHEROO_DUAL_GPU_PROPERTY,
	BUDGIE_SWITCHEROO_NUM_PROPERTIES
};
static GParamSpec* budgie_switcheroo_properties[BUDGIE_SWITCHEROO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

static gpointer budgie_switcheroo_parent_class = NULL;
static BudgieSwitcherooDBus* budgie_switcheroo_switcheroo;
static BudgieSwitcherooDBus* budgie_switcheroo_switcheroo = NULL;

static GType budgie_switcheroo_dbus_get_type_once (void);
static void budgie_switcheroo_dbus_proxy_g_signal (GDBusProxy* proxy,
                                            const gchar* sender_name,
                                            const gchar* signal_name,
                                            GVariant* parameters);
static gboolean budgie_switcheroo_dbus_dbus_proxy_get_has_dual_gpu (BudgieSwitcherooDBus* self);
static GHashTable** budgie_switcheroo_dbus_dbus_proxy_get_gpus (BudgieSwitcherooDBus* self,
                                                         gint* result_length1);
static void budgie_switcheroo_dbus_proxy_budgie_switcheroo_dbus_interface_init (BudgieSwitcherooDBusIface* iface);
static void budgie_switcheroo_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* method_name,
                                                        GVariant* parameters,
                                                        GDBusMethodInvocation* invocation,
                                                        gpointer user_data);
static GVariant* budgie_switcheroo_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data);
static GVariant* _dbus_budgie_switcheroo_dbus_get_has_dual_gpu (BudgieSwitcherooDBus* self);
static GVariant* _dbus_budgie_switcheroo_dbus_get_gpus (BudgieSwitcherooDBus* self);
static gboolean budgie_switcheroo_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* property_name,
                                                             GVariant* value,
                                                             GError** error,
                                                             gpointer user_data);
static void _budgie_switcheroo_dbus_unregister_object (gpointer user_data);
static void budgie_switcheroo_on_dbus_get (GObject* o,
                                    GAsyncResult* res);
static void _budgie_switcheroo_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self);
static void budgie_switcheroo_finalize (GObject * obj);
static GType budgie_switcheroo_get_type_once (void);
static void _vala_budgie_switcheroo_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusMethodInfo * const _budgie_switcheroo_dbus_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _budgie_switcheroo_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _budgie_switcheroo_dbus_dbus_property_info_has_dual_gpu = {-1, "HasDualGpu", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _budgie_switcheroo_dbus_dbus_property_info_gpus = {-1, "GPUs", "aa{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _budgie_switcheroo_dbus_dbus_property_info[] = {&_budgie_switcheroo_dbus_dbus_property_info_has_dual_gpu, &_budgie_switcheroo_dbus_dbus_property_info_gpus, NULL};
static const GDBusInterfaceInfo _budgie_switcheroo_dbus_dbus_interface_info = {-1, "net.hadess.SwitcherooControl", (GDBusMethodInfo **) (&_budgie_switcheroo_dbus_dbus_method_info), (GDBusSignalInfo **) (&_budgie_switcheroo_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_switcheroo_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_switcheroo_dbus_dbus_interface_vtable = {budgie_switcheroo_dbus_dbus_interface_method_call, budgie_switcheroo_dbus_dbus_interface_get_property, budgie_switcheroo_dbus_dbus_interface_set_property};

gboolean
budgie_switcheroo_dbus_get_has_dual_gpu (BudgieSwitcherooDBus* self)
{
	BudgieSwitcherooDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = BUDGIE_SWITCHEROO_DBUS_GET_INTERFACE (self);
	if (_iface_->get_has_dual_gpu) {
		return _iface_->get_has_dual_gpu (self);
	}
	return FALSE;
}

GHashTable**
budgie_switcheroo_dbus_get_gpus (BudgieSwitcherooDBus* self,
                                 gint* result_length1)
{
	BudgieSwitcherooDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = BUDGIE_SWITCHEROO_DBUS_GET_INTERFACE (self);
	if (_iface_->get_gpus) {
		return _iface_->get_gpus (self, result_length1);
	}
	return NULL;
}

static void
budgie_switcheroo_dbus_default_init (BudgieSwitcherooDBusIface * iface,
                                     gpointer iface_data)
{
}

static GType
budgie_switcheroo_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSwitcherooDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_switcheroo_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType budgie_switcheroo_dbus_type_id;
	budgie_switcheroo_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieSwitcherooDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (budgie_switcheroo_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (budgie_switcheroo_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_switcheroo_dbus_proxy_get_type);
	g_type_set_qdata (budgie_switcheroo_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "net.hadess.SwitcherooControl");
	g_type_set_qdata (budgie_switcheroo_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_switcheroo_dbus_dbus_interface_info));
	g_type_set_qdata (budgie_switcheroo_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_switcheroo_dbus_register_object);
	return budgie_switcheroo_dbus_type_id;
}

GType
budgie_switcheroo_dbus_get_type (void)
{
	static volatile gsize budgie_switcheroo_dbus_type_id__once = 0;
	if (g_once_init_enter (&budgie_switcheroo_dbus_type_id__once)) {
		GType budgie_switcheroo_dbus_type_id;
		budgie_switcheroo_dbus_type_id = budgie_switcheroo_dbus_get_type_once ();
		g_once_init_leave (&budgie_switcheroo_dbus_type_id__once, budgie_switcheroo_dbus_type_id);
	}
	return budgie_switcheroo_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BudgieSwitcherooDBusProxy, budgie_switcheroo_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_SWITCHEROO_DBUS, budgie_switcheroo_dbus_proxy_budgie_switcheroo_dbus_interface_init) )
static void
budgie_switcheroo_dbus_proxy_class_init (BudgieSwitcherooDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_switcheroo_dbus_proxy_g_signal;
}

static void
budgie_switcheroo_dbus_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters)
{
}

static void
budgie_switcheroo_dbus_proxy_init (BudgieSwitcherooDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_budgie_switcheroo_dbus_dbus_interface_info));
}

static gboolean
budgie_switcheroo_dbus_dbus_proxy_get_has_dual_gpu (BudgieSwitcherooDBus* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasDualGpu");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasDualGpu"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp0_ = FALSE;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static GHashTable**
budgie_switcheroo_dbus_dbus_proxy_get_gpus (BudgieSwitcherooDBus* self,
                                            gint* result_length1)
{
	GVariant *_inner_reply;
	GHashTable** _result;
	gint _result_length1;
	GHashTable** _tmp1_;
	gint _tmp1__length;
	gint _tmp1__size;
	gint _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "GPUs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("net.hadess.SwitcherooControl"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("GPUs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp1_ = g_new (GHashTable*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _inner_reply);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		GHashTable* _tmp4_;
		GVariantIter _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (GHashTable*, _tmp1_, _tmp1__size + 1);
		}
		_tmp4_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
		g_variant_iter_init (&_tmp5_, _tmp3_);
		while (g_variant_iter_loop (&_tmp5_, "{?*}", &_tmp6_, &_tmp7_)) {
			g_hash_table_insert (_tmp4_, g_variant_dup_string (_tmp6_, NULL), g_variant_get_variant (_tmp7_));
		}
		_tmp1_[_tmp1__length++] = _tmp4_;
		g_variant_unref (_tmp3_);
	}
	_result_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	_result = _tmp1_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static void
budgie_switcheroo_dbus_proxy_budgie_switcheroo_dbus_interface_init (BudgieSwitcherooDBusIface* iface)
{
	iface->get_has_dual_gpu = budgie_switcheroo_dbus_dbus_proxy_get_has_dual_gpu;
	iface->get_gpus = budgie_switcheroo_dbus_dbus_proxy_get_gpus;
}

static void
budgie_switcheroo_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_budgie_switcheroo_dbus_get_has_dual_gpu (BudgieSwitcherooDBus* self)
{
	gboolean result;
	GVariant* _reply;
	result = budgie_switcheroo_dbus_get_has_dual_gpu (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_budgie_switcheroo_dbus_get_gpus (BudgieSwitcherooDBus* self)
{
	GHashTable** result;
	gint result_length1 = 0;
	GVariant* _reply;
	GHashTable** _tmp8_;
	GVariantBuilder _tmp9_;
	gint _tmp10_;
	result = budgie_switcheroo_dbus_get_gpus (self, &result_length1);
	_tmp8_ = result;
	g_variant_builder_init (&_tmp9_, G_VARIANT_TYPE ("aa{sv}"));
	for (_tmp10_ = 0; _tmp10_ < result_length1; _tmp10_++) {
		GVariantBuilder _tmp11_;
		GHashTableIter _tmp12_;
		gpointer _tmp13_;
		gpointer _tmp14_;
		g_hash_table_iter_init (&_tmp12_, *_tmp8_);
		g_variant_builder_init (&_tmp11_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp12_, &_tmp13_, &_tmp14_)) {
			gchar* _key;
			GVariant* _value;
			_key = (gchar*) _tmp13_;
			_value = (GVariant*) _tmp14_;
			g_variant_builder_add (&_tmp11_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp9_, g_variant_builder_end (&_tmp11_));
		_tmp8_++;
	}
	_reply = g_variant_builder_end (&_tmp9_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	return _reply;
}

static GVariant*
budgie_switcheroo_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasDualGpu") == 0) {
		return _dbus_budgie_switcheroo_dbus_get_has_dual_gpu (object);
	} else if (strcmp (property_name, "GPUs") == 0) {
		return _dbus_budgie_switcheroo_dbus_get_gpus (object);
	}
	return NULL;
}

static gboolean
budgie_switcheroo_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_switcheroo_dbus_register_object (gpointer object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_switcheroo_dbus_dbus_interface_info), &_budgie_switcheroo_dbus_dbus_interface_vtable, data, _budgie_switcheroo_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_switcheroo_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
budgie_switcheroo_on_dbus_get (GObject* o,
                               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	{
		BudgieSwitcherooDBus* _tmp0_ = NULL;
		BudgieSwitcherooDBus* _tmp1_;
		BudgieSwitcherooDBus* _tmp2_;
		BudgieSwitcherooDBus* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (BudgieSwitcherooDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (BudgieSwitcherooDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (budgie_switcheroo_switcheroo);
		budgie_switcheroo_switcheroo = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("Switcheroo.vala:52: Unable to connect to Switcheroo DBus: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
* Attempt to apply a GPU environment to a launch context for an application.
*/
static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
budgie_switcheroo_apply_gpu_profile (BudgieSwitcheroo* self,
                                     GAppLaunchContext* context,
                                     gboolean use_default_gpu)
{
	BudgieSwitcherooDBus* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	BudgieSwitcherooDBus* _tmp3_;
	GHashTable** _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	GHashTable** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = budgie_switcheroo_switcheroo;
	if (_tmp0_ == NULL) {
		g_warning ("Switcheroo.vala:62: switcheroo-control not available, can't apply GPU " \
"environment");
		return;
	}
	_tmp1_ = budgie_switcheroo_get_dual_gpu (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = budgie_switcheroo_switcheroo;
	_tmp4_ = budgie_switcheroo_dbus_get_gpus (_tmp3_, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	{
		GHashTable** gpu_collection = NULL;
		gint gpu_collection_length1 = 0;
		gint _gpu_collection_size_ = 0;
		gint gpu_it = 0;
		gpu_collection = _tmp6_;
		gpu_collection_length1 = _tmp6__length1;
		for (gpu_it = 0; gpu_it < gpu_collection_length1; gpu_it = gpu_it + 1) {
			GHashTable* _tmp7_;
			GHashTable* gpu = NULL;
			_tmp7_ = _g_hash_table_ref0 (gpu_collection[gpu_it]);
			gpu = _tmp7_;
			{
				gboolean default_gpu = FALSE;
				GHashTable* _tmp8_;
				gconstpointer _tmp9_;
				GVariant* env = NULL;
				GHashTable* _tmp10_;
				gconstpointer _tmp11_;
				GVariant* _tmp12_;
				const gchar** env_parts = NULL;
				GVariant* _tmp13_;
				gsize _tmp14_ = 0;
				const gchar** _tmp15_;
				gint env_parts_length1;
				gint _env_parts_size_;
				_tmp8_ = gpu;
				_tmp9_ = g_hash_table_lookup (_tmp8_, "Default");
				default_gpu = g_variant_get_boolean ((GVariant*) _tmp9_);
				if (default_gpu != use_default_gpu) {
					_g_hash_table_unref0 (gpu);
					continue;
				}
				_tmp10_ = gpu;
				_tmp11_ = g_hash_table_lookup (_tmp10_, "Environment");
				_tmp12_ = _g_variant_ref0 ((GVariant*) _tmp11_);
				env = _tmp12_;
				_tmp13_ = env;
				_tmp15_ = g_variant_get_strv (_tmp13_, &_tmp14_);
				env_parts = _tmp15_;
				env_parts_length1 = _tmp14_;
				_env_parts_size_ = env_parts_length1;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							const gchar** _tmp17_;
							gint _tmp17__length1;
							const gchar* _tmp18_;
							const gchar** _tmp19_;
							gint _tmp19__length1;
							const gchar* _tmp20_;
							const gchar** _tmp21_;
							gint _tmp21__length1;
							const gchar* _tmp22_;
							if (!_tmp16_) {
								i = i + 2;
							}
							_tmp16_ = FALSE;
							_tmp17_ = env_parts;
							_tmp17__length1 = env_parts_length1;
							_tmp18_ = _tmp17_[i];
							if (!(_tmp18_ != NULL)) {
								break;
							}
							_tmp19_ = env_parts;
							_tmp19__length1 = env_parts_length1;
							_tmp20_ = _tmp19_[i];
							_tmp21_ = env_parts;
							_tmp21__length1 = env_parts_length1;
							_tmp22_ = _tmp21_[i + 1];
							g_app_launch_context_setenv (context, _tmp20_, _tmp22_);
						}
					}
				}
				env_parts = (g_free (env_parts), NULL);
				_g_variant_unref0 (env);
				_g_hash_table_unref0 (gpu);
				gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
				return;
			}
		}
		gpu_collection = (_vala_array_free (gpu_collection, gpu_collection_length1, (GDestroyNotify) g_hash_table_unref), NULL);
	}
	g_warning ("Switcheroo.vala:97: No GPUs found, cannot apply profile");
}

BudgieSwitcheroo*
budgie_switcheroo_construct (GType object_type)
{
	BudgieSwitcheroo * self = NULL;
	self = (BudgieSwitcheroo*) g_object_new (object_type, NULL);
	return self;
}

BudgieSwitcheroo*
budgie_switcheroo_new (void)
{
	return budgie_switcheroo_construct (BUDGIE_TYPE_SWITCHEROO);
}

gboolean
budgie_switcheroo_get_dual_gpu (BudgieSwitcheroo* self)
{
	gboolean result;
	BudgieSwitcherooDBus* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = budgie_switcheroo_switcheroo;
	_tmp1_ = budgie_switcheroo_dbus_get_has_dual_gpu (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
_budgie_switcheroo_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                      GAsyncResult* res,
                                                      gpointer self)
{
	budgie_switcheroo_on_dbus_get (source_object, res);
}

static void
budgie_switcheroo_class_init (BudgieSwitcherooClass * klass,
                              gpointer klass_data)
{
	GError* _inner_error0_ = NULL;
	budgie_switcheroo_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_switcheroo_get_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_switcheroo_finalize;
	/** Returns whether or not the system has a dual-GPU setup. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SWITCHEROO_DUAL_GPU_PROPERTY, budgie_switcheroo_properties[BUDGIE_SWITCHEROO_DUAL_GPU_PROPERTY] = g_param_spec_boolean ("dual-gpu", "dual-gpu", "dual-gpu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_async_initable_new_async (BUDGIE_TYPE_SWITCHEROO_DBUS_PROXY, 0, NULL, _budgie_switcheroo_on_dbus_get_gasync_ready_callback, NULL, "g-flags", 0, "g-name", "net.hadess.SwitcherooControl", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/net/hadess/SwitcherooControl", "g-interface-name", "net.hadess.SwitcherooControl", NULL);
}

static void
budgie_switcheroo_instance_init (BudgieSwitcheroo * self,
                                 gpointer klass)
{
}

static void
budgie_switcheroo_finalize (GObject * obj)
{
	BudgieSwitcheroo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SWITCHEROO, BudgieSwitcheroo);
	G_OBJECT_CLASS (budgie_switcheroo_parent_class)->finalize (obj);
}

/**
* This class connects to switeroo-control via DBus for handling dual-GPUs.
*/
static GType
budgie_switcheroo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSwitcherooClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_switcheroo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSwitcheroo), 0, (GInstanceInitFunc) budgie_switcheroo_instance_init, NULL };
	GType budgie_switcheroo_type_id;
	budgie_switcheroo_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieSwitcheroo", &g_define_type_info, 0);
	return budgie_switcheroo_type_id;
}

GType
budgie_switcheroo_get_type (void)
{
	static volatile gsize budgie_switcheroo_type_id__once = 0;
	if (g_once_init_enter (&budgie_switcheroo_type_id__once)) {
		GType budgie_switcheroo_type_id;
		budgie_switcheroo_type_id = budgie_switcheroo_get_type_once ();
		g_once_init_leave (&budgie_switcheroo_type_id__once, budgie_switcheroo_type_id);
	}
	return budgie_switcheroo_type_id__once;
}

static void
_vala_budgie_switcheroo_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	BudgieSwitcheroo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SWITCHEROO, BudgieSwitcheroo);
	switch (property_id) {
		case BUDGIE_SWITCHEROO_DUAL_GPU_PROPERTY:
		g_value_set_boolean (value, budgie_switcheroo_get_dual_gpu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

