/* Application.c generated by valac 0.56.14, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-appindexer.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>

enum  {
	BUDGIE_APPLICATION_0_PROPERTY,
	BUDGIE_APPLICATION_NAME_PROPERTY,
	BUDGIE_APPLICATION_DESCRIPTION_PROPERTY,
	BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY,
	BUDGIE_APPLICATION_EXEC_PROPERTY,
	BUDGIE_APPLICATION_KEYWORDS_PROPERTY,
	BUDGIE_APPLICATION_ICON_PROPERTY,
	BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY,
	BUDGIE_APPLICATION_CATEGORIES_PROPERTY,
	BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY,
	BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY,
	BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY,
	BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY,
	BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY,
	BUDGIE_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* budgie_application_properties[BUDGIE_APPLICATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_APPLICATION_LAUNCHED_SIGNAL,
	BUDGIE_APPLICATION_LAUNCH_FAILED_SIGNAL,
	BUDGIE_APPLICATION_NUM_SIGNALS
};
static guint budgie_application_signals[BUDGIE_APPLICATION_NUM_SIGNALS] = {0};

struct _BudgieApplicationPrivate {
	gchar* _name;
	gchar* _description;
	gchar* _desktop_id;
	gchar* _exec;
	gchar** _keywords;
	gint _keywords_length1;
	gint __keywords_size_;
	GIcon* _icon;
	gchar* _desktop_path;
	gchar* _categories;
	gchar** _content_types;
	gint _content_types_length1;
	gint __content_types_size_;
	gchar* _generic_name;
	gboolean _prefers_default_gpu;
	gboolean _should_show;
	gboolean _dbus_activatable;
	BudgieSwitcheroo* switcheroo;
};

static gint BudgieApplication_private_offset;
static gpointer budgie_application_parent_class = NULL;

static void budgie_application_set_description (BudgieApplication* self,
                                         const gchar* value);
static void budgie_application_set_exec (BudgieApplication* self,
                                  const gchar* value);
static void budgie_application_set_desktop_path (BudgieApplication* self,
                                          const gchar* value);
static void budgie_application_set_keywords (BudgieApplication* self,
                                      gchar** value,
                                      gint value_length1);
static void budgie_application_set_categories (BudgieApplication* self,
                                        const gchar* value);
static void budgie_application_set_content_types (BudgieApplication* self,
                                           gchar** value,
                                           gint value_length1);
static void budgie_application_set_generic_name (BudgieApplication* self,
                                          const gchar* value);
static void budgie_application_set_prefers_default_gpu (BudgieApplication* self,
                                                 gboolean value);
static void budgie_application_set_should_show (BudgieApplication* self,
                                         gboolean value);
static void budgie_application_set_dbus_activatable (BudgieApplication* self,
                                              gboolean value);
static void budgie_application_set_icon (BudgieApplication* self,
                                  GIcon* value);
static void ____lambda4_ (BudgieApplication* self,
                   GPid pid,
                   gint status);
static void _____lambda4__gchild_watch_func (GPid pid,
                                      gint wait_status,
                                      gpointer self);
static void ____lambda5_ (BudgieApplication* self,
                   GAppInfo* info,
                   GVariant* data);
static void _____lambda5__g_app_launch_context_launched (GAppLaunchContext* _sender,
                                                  GAppInfo* info,
                                                  GVariant* platform_data,
                                                  gpointer self);
static void ____lambda6_ (BudgieApplication* self,
                   const gchar* startup_id);
static void _____lambda6__g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                       const gchar* startup_notify_id,
                                                       gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * budgie_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void budgie_application_finalize (GObject * obj);
static GType budgie_application_get_type_once (void);
static void _vala_budgie_application_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_budgie_application_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_application_get_instance_private (BudgieApplication* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieApplication_private_offset);
}

/**
* Create a new application from a `DesktopAppInfo`.
*/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieApplication*
budgie_application_construct (GType object_type,
                              GDesktopAppInfo* app_info)
{
	BudgieApplication * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	const gchar* _tmp12_;
	GIcon* desktop_icon = NULL;
	GIcon* _tmp13_;
	GIcon* _tmp14_;
	GIcon* _tmp15_;
	g_return_val_if_fail (app_info != NULL, NULL);
	self = (BudgieApplication*) g_object_new (object_type, NULL);
	_tmp0_ = g_app_info_get_display_name ((GAppInfo*) app_info);
	budgie_application_set_name (self, _tmp0_);
	_tmp2_ = g_app_info_get_description ((GAppInfo*) app_info);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_name;
		_tmp1_ = _tmp3_;
	}
	budgie_application_set_description (self, _tmp1_);
	_tmp4_ = g_app_info_get_commandline ((GAppInfo*) app_info);
	budgie_application_set_exec (self, _tmp4_);
	_tmp5_ = g_app_info_get_id ((GAppInfo*) app_info);
	budgie_application_set_desktop_id (self, _tmp5_);
	_tmp6_ = g_desktop_app_info_get_filename (app_info);
	budgie_application_set_desktop_path (self, _tmp6_);
	_tmp8_ = _tmp7_ = g_desktop_app_info_get_keywords (app_info);
	budgie_application_set_keywords (self, _tmp8_, _vala_array_length (_tmp7_));
	_tmp9_ = g_desktop_app_info_get_categories (app_info);
	budgie_application_set_categories (self, _tmp9_);
	_tmp11_ = _tmp10_ = g_app_info_get_supported_types ((GAppInfo*) app_info);
	budgie_application_set_content_types (self, _tmp11_, _vala_array_length (_tmp10_));
	_tmp12_ = g_desktop_app_info_get_generic_name (app_info);
	budgie_application_set_generic_name (self, _tmp12_);
	budgie_application_set_prefers_default_gpu (self, !g_desktop_app_info_get_boolean (app_info, "PrefersNonDefaultGPU"));
	budgie_application_set_should_show (self, g_app_info_should_show ((GAppInfo*) app_info));
	budgie_application_set_dbus_activatable (self, g_desktop_app_info_get_boolean (app_info, "DBusActivatable"));
	_tmp13_ = g_app_info_get_icon ((GAppInfo*) app_info);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	desktop_icon = _tmp14_;
	_tmp15_ = desktop_icon;
	if (_tmp15_ != NULL) {
		GtkIconTheme* theme = NULL;
		GtkIconTheme* _tmp16_;
		GtkIconTheme* _tmp17_;
		GIcon* _tmp18_;
		GtkIconInfo* _tmp19_;
		GtkIconInfo* _tmp20_;
		gboolean _tmp21_;
		_tmp16_ = gtk_icon_theme_get_default ();
		theme = _tmp16_;
		_tmp17_ = theme;
		_tmp18_ = desktop_icon;
		_tmp19_ = gtk_icon_theme_lookup_by_gicon (_tmp17_, _tmp18_, 64, GTK_ICON_LOOKUP_USE_BUILTIN);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_ != NULL;
		_g_object_unref0 (_tmp20_);
		if (_tmp21_) {
			GIcon* _tmp22_;
			_tmp22_ = desktop_icon;
			budgie_application_set_icon (self, _tmp22_);
		}
	}
	_g_object_unref0 (desktop_icon);
	return self;
}

BudgieApplication*
budgie_application_new (GDesktopAppInfo* app_info)
{
	return budgie_application_construct (BUDGIE_TYPE_APPLICATION, app_info);
}

/**
* Launch this application.
*
* Returns `true` if the application launched successfully,
* otherwise `false`.
*/
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
____lambda4_ (BudgieApplication* self,
              GPid pid,
              gint status)
{
	g_spawn_close_pid (pid);
}

static void
_____lambda4__gchild_watch_func (GPid pid,
                                 gint wait_status,
                                 gpointer self)
{
	____lambda4_ ((BudgieApplication*) self, pid, wait_status);
}

static void
____lambda5_ (BudgieApplication* self,
              GAppInfo* info,
              GVariant* data)
{
	g_return_if_fail (info != NULL);
	g_return_if_fail (data != NULL);
	g_signal_emit (self, budgie_application_signals[BUDGIE_APPLICATION_LAUNCHED_SIGNAL], 0, info, data);
}

static void
_____lambda5__g_app_launch_context_launched (GAppLaunchContext* _sender,
                                             GAppInfo* info,
                                             GVariant* platform_data,
                                             gpointer self)
{
	____lambda5_ ((BudgieApplication*) self, info, platform_data);
}

static void
____lambda6_ (BudgieApplication* self,
              const gchar* startup_id)
{
	g_return_if_fail (startup_id != NULL);
	g_signal_emit (self, budgie_application_signals[BUDGIE_APPLICATION_LAUNCH_FAILED_SIGNAL], 0, startup_id);
}

static void
_____lambda6__g_app_launch_context_launch_failed (GAppLaunchContext* _sender,
                                                  const gchar* startup_notify_id,
                                                  gpointer self)
{
	____lambda6_ ((BudgieApplication*) self, startup_notify_id);
}

gboolean
budgie_application_launch (BudgieApplication* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GDesktopAppInfo* info = NULL;
		const gchar* _tmp0_;
		GDesktopAppInfo* _tmp1_;
		gchar* cmd = NULL;
		GDesktopAppInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** args = NULL;
		gchar** _tmp5_;
		gint args_length1;
		gint _args_size_;
		static const char checkstr[] = "pkexec";
		const gchar* _tmp6_;
		gboolean _tmp10_ = FALSE;
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp0_ = self->priv->_desktop_id;
		_tmp1_ = g_desktop_app_info_new (_tmp0_);
		info = _tmp1_;
		_tmp2_ = info;
		_tmp3_ = g_app_info_get_commandline ((GAppInfo*) _tmp2_);
		_tmp4_ = g_strdup (_tmp3_);
		cmd = _tmp4_;
		_tmp5_ = g_new0 (gchar*, 0 + 1);
		args = _tmp5_;
		args_length1 = 0;
		_args_size_ = args_length1;
		_tmp6_ = cmd;
		if (string_contains (_tmp6_, checkstr)) {
			const gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_;
			_tmp7_ = cmd;
			_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			args = _tmp9_;
			args_length1 = _vala_array_length (_tmp8_);
			_args_size_ = args_length1;
		}
		_tmp11_ = args;
		_tmp11__length1 = args_length1;
		if (_tmp11__length1 >= 2) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			_tmp12_ = args;
			_tmp12__length1 = args_length1;
			_tmp13_ = _tmp12_[0];
			_tmp10_ = g_strcmp0 (_tmp13_, checkstr) == 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gchar** env = NULL;
			gchar** _tmp14_;
			gchar** _tmp15_;
			gint env_length1;
			gint _env_size_;
			GPid child_pid = 0;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gchar** _tmp17_;
			gint _tmp17__length1;
			GPid _tmp18_ = 0;
			_tmp15_ = _tmp14_ = g_get_environ ();
			env = _tmp15_;
			env_length1 = _vala_array_length (_tmp14_);
			_env_size_ = env_length1;
			_tmp16_ = args;
			_tmp16__length1 = args_length1;
			_tmp17_ = env;
			_tmp17__length1 = env_length1;
			g_spawn_async ("/", _tmp16_, _tmp17_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp18_, &_inner_error0_);
			child_pid = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (cmd);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, _____lambda4__gchild_watch_func, g_object_ref (self), g_object_unref);
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		} else {
			GAppLaunchContext* context = NULL;
			GAppLaunchContext* _tmp19_;
			GAppLaunchContext* _tmp20_;
			GAppLaunchContext* _tmp21_;
			BudgieSwitcheroo* _tmp22_;
			GAppLaunchContext* _tmp23_;
			gboolean _tmp24_;
			const gchar* _tmp25_;
			GDesktopAppInfo* _tmp26_;
			GDesktopAppInfo* _tmp27_;
			GAppLaunchContext* _tmp28_;
			_tmp19_ = g_app_launch_context_new ();
			context = _tmp19_;
			_tmp20_ = context;
			g_signal_connect_object (_tmp20_, "launched", (GCallback) _____lambda5__g_app_launch_context_launched, self, 0);
			_tmp21_ = context;
			g_signal_connect_object (_tmp21_, "launch-failed", (GCallback) _____lambda6__g_app_launch_context_launch_failed, self, 0);
			_tmp22_ = self->priv->switcheroo;
			_tmp23_ = context;
			_tmp24_ = self->priv->_prefers_default_gpu;
			budgie_switcheroo_apply_gpu_profile (_tmp22_, _tmp23_, _tmp24_);
			_tmp25_ = self->priv->_desktop_id;
			_tmp26_ = g_desktop_app_info_new (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = context;
			g_app_info_launch ((GAppInfo*) _tmp27_, NULL, _tmp28_, &_inner_error0_);
			_g_object_unref0 (_tmp27_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (context);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (cmd);
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			_g_object_unref0 (context);
		}
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (cmd);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = self->priv->_name;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("Application.vala:138: Failed to launch application '%s': %s", _tmp29_, _tmp31_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp32_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp32_;
	}
	result = TRUE;
	return result;
}

const gchar*
budgie_application_get_name (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
budgie_application_set_name (BudgieApplication* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_NAME_PROPERTY]);
	}
}

const gchar*
budgie_application_get_description (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_description (BudgieApplication* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
budgie_application_get_desktop_id (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

void
budgie_application_set_desktop_id (BudgieApplication* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
budgie_application_get_exec (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_exec (BudgieApplication* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_exec (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_EXEC_PROPERTY]);
	}
}

gchar**
budgie_application_get_keywords (BudgieApplication* self,
                                 gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keywords;
	_tmp0__length1 = self->priv->_keywords_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
budgie_application_set_keywords (BudgieApplication* self,
                                 gchar** value,
                                 gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_keywords (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_keywords = _tmp0_;
		self->priv->_keywords_length1 = _tmp0__length1;
		self->priv->__keywords_size_ = self->priv->_keywords_length1;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_KEYWORDS_PROPERTY]);
	}
}

GIcon*
budgie_application_get_icon (BudgieApplication* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_icon (BudgieApplication* self,
                             GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_ICON_PROPERTY]);
	}
}

const gchar*
budgie_application_get_desktop_path (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_desktop_path (BudgieApplication* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY]);
	}
}

const gchar*
budgie_application_get_categories (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_categories;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_categories (BudgieApplication* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_categories (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_categories);
		self->priv->_categories = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_CATEGORIES_PROPERTY]);
	}
}

gchar**
budgie_application_get_content_types (BudgieApplication* self,
                                      gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_types;
	_tmp0__length1 = self->priv->_content_types_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
budgie_application_set_content_types (BudgieApplication* self,
                                      gchar** value,
                                      gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_content_types (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_content_types = (_vala_array_free (self->priv->_content_types, self->priv->_content_types_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_content_types = _tmp0_;
		self->priv->_content_types_length1 = _tmp0__length1;
		self->priv->__content_types_size_ = self->priv->_content_types_length1;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY]);
	}
}

const gchar*
budgie_application_get_generic_name (BudgieApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}

static void
budgie_application_set_generic_name (BudgieApplication* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_generic_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY]);
	}
}

gboolean
budgie_application_get_prefers_default_gpu (BudgieApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prefers_default_gpu;
	return result;
}

static void
budgie_application_set_prefers_default_gpu (BudgieApplication* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_prefers_default_gpu (self);
	if (old_value != value) {
		self->priv->_prefers_default_gpu = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY]);
	}
}

gboolean
budgie_application_get_should_show (BudgieApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_should_show;
	return result;
}

static void
budgie_application_set_should_show (BudgieApplication* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_should_show (self);
	if (old_value != value) {
		self->priv->_should_show = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY]);
	}
}

gboolean
budgie_application_get_dbus_activatable (BudgieApplication* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dbus_activatable;
	return result;
}

static void
budgie_application_set_dbus_activatable (BudgieApplication* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_application_get_dbus_activatable (self);
	if (old_value != value) {
		self->priv->_dbus_activatable = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_application_properties[BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_VARIANT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_variant (param_values + 2), data2);
}

static GObject *
budgie_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieApplication * self;
	BudgieSwitcheroo* _tmp0_;
	parent_class = G_OBJECT_CLASS (budgie_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APPLICATION, BudgieApplication);
	_tmp0_ = budgie_switcheroo_new ();
	_g_object_unref0 (self->priv->switcheroo);
	self->priv->switcheroo = _tmp0_;
	return obj;
}

static void
budgie_application_class_init (BudgieApplicationClass * klass,
                               gpointer klass_data)
{
	budgie_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieApplication_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_NAME_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_DESCRIPTION_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_EXEC_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_KEYWORDS_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_KEYWORDS_PROPERTY] = g_param_spec_boxed ("keywords", "keywords", "keywords", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_ICON_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_CATEGORIES_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_CATEGORIES_PROPERTY] = g_param_spec_string ("categories", "categories", "categories", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY] = g_param_spec_boxed ("content-types", "content-types", "content-types", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY] = g_param_spec_boolean ("prefers-default-gpu", "prefers-default-gpu", "prefers-default-gpu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY] = g_param_spec_boolean ("should-show", "should-show", "should-show", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY, budgie_application_properties[BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY] = g_param_spec_boolean ("dbus-activatable", "dbus-activatable", "dbus-activatable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Emitted when the application is launched.
	 *
	 * See https://valadoc.org/gio-2.0/GLib.AppLaunchContext.launched.html
	 */
	budgie_application_signals[BUDGIE_APPLICATION_LAUNCHED_SIGNAL] = g_signal_new ("launched", BUDGIE_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_VARIANT, G_TYPE_NONE, 2, g_app_info_get_type (), G_TYPE_VARIANT);
	/**
	 * Emitted when the application fails to launch.
	 *
	 * See https://valadoc.org/gio-2.0/GLib.AppLaunchContext.launch_failed.html
	 */
	budgie_application_signals[BUDGIE_APPLICATION_LAUNCH_FAILED_SIGNAL] = g_signal_new ("launch-failed", BUDGIE_TYPE_APPLICATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
budgie_application_instance_init (BudgieApplication * self,
                                  gpointer klass)
{
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_;
	self->priv = budgie_application_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("application-default-icon");
	self->priv->_icon = (GIcon*) _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_generic_name = _tmp2_;
	self->priv->_prefers_default_gpu = FALSE;
	self->priv->_should_show = TRUE;
	self->priv->_dbus_activatable = FALSE;
}

static void
budgie_application_finalize (GObject * obj)
{
	BudgieApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APPLICATION, BudgieApplication);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_desktop_path);
	_g_free0 (self->priv->_categories);
	self->priv->_content_types = (_vala_array_free (self->priv->_content_types, self->priv->_content_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_generic_name);
	_g_object_unref0 (self->priv->switcheroo);
	G_OBJECT_CLASS (budgie_application_parent_class)->finalize (obj);
}

/**
* Represents an application that can be ran.
*/
static GType
budgie_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieApplication), 0, (GInstanceInitFunc) budgie_application_instance_init, NULL };
	GType budgie_application_type_id;
	budgie_application_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieApplication", &g_define_type_info, 0);
	BudgieApplication_private_offset = g_type_add_instance_private (budgie_application_type_id, sizeof (BudgieApplicationPrivate));
	return budgie_application_type_id;
}

GType
budgie_application_get_type (void)
{
	static volatile gsize budgie_application_type_id__once = 0;
	if (g_once_init_enter (&budgie_application_type_id__once)) {
		GType budgie_application_type_id;
		budgie_application_type_id = budgie_application_get_type_once ();
		g_once_init_leave (&budgie_application_type_id__once, budgie_application_type_id);
	}
	return budgie_application_type_id__once;
}

static void
_vala_budgie_application_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BudgieApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_APPLICATION, BudgieApplication);
	switch (property_id) {
		case BUDGIE_APPLICATION_NAME_PROPERTY:
		g_value_set_string (value, budgie_application_get_name (self));
		break;
		case BUDGIE_APPLICATION_DESCRIPTION_PROPERTY:
		g_value_set_string (value, budgie_application_get_description (self));
		break;
		case BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, budgie_application_get_desktop_id (self));
		break;
		case BUDGIE_APPLICATION_EXEC_PROPERTY:
		g_value_set_string (value, budgie_application_get_exec (self));
		break;
		case BUDGIE_APPLICATION_KEYWORDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, budgie_application_get_keywords (self, &length));
		}
		break;
		case BUDGIE_APPLICATION_ICON_PROPERTY:
		g_value_set_object (value, budgie_application_get_icon (self));
		break;
		case BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, budgie_application_get_desktop_path (self));
		break;
		case BUDGIE_APPLICATION_CATEGORIES_PROPERTY:
		g_value_set_string (value, budgie_application_get_categories (self));
		break;
		case BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, budgie_application_get_content_types (self, &length));
		}
		break;
		case BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, budgie_application_get_generic_name (self));
		break;
		case BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY:
		g_value_set_boolean (value, budgie_application_get_prefers_default_gpu (self));
		break;
		case BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY:
		g_value_set_boolean (value, budgie_application_get_should_show (self));
		break;
		case BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY:
		g_value_set_boolean (value, budgie_application_get_dbus_activatable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_application_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BudgieApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_APPLICATION, BudgieApplication);
	switch (property_id) {
		case BUDGIE_APPLICATION_NAME_PROPERTY:
		budgie_application_set_name (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_DESCRIPTION_PROPERTY:
		budgie_application_set_description (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_DESKTOP_ID_PROPERTY:
		budgie_application_set_desktop_id (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_EXEC_PROPERTY:
		budgie_application_set_exec (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_KEYWORDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			budgie_application_set_keywords (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BUDGIE_APPLICATION_ICON_PROPERTY:
		budgie_application_set_icon (self, g_value_get_object (value));
		break;
		case BUDGIE_APPLICATION_DESKTOP_PATH_PROPERTY:
		budgie_application_set_desktop_path (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_CATEGORIES_PROPERTY:
		budgie_application_set_categories (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_CONTENT_TYPES_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			budgie_application_set_content_types (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case BUDGIE_APPLICATION_GENERIC_NAME_PROPERTY:
		budgie_application_set_generic_name (self, g_value_get_string (value));
		break;
		case BUDGIE_APPLICATION_PREFERS_DEFAULT_GPU_PROPERTY:
		budgie_application_set_prefers_default_gpu (self, g_value_get_boolean (value));
		break;
		case BUDGIE_APPLICATION_SHOULD_SHOW_PROPERTY:
		budgie_application_set_should_show (self, g_value_get_boolean (value));
		break;
		case BUDGIE_APPLICATION_DBUS_ACTIVATABLE_PROPERTY:
		budgie_application_set_dbus_activatable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

