/* AppIndex.c generated by valac 0.56.14, the Vala compiler
 * generated from AppIndex.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-appindexer.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>

enum  {
	BUDGIE_APP_INDEX_0_PROPERTY,
	BUDGIE_APP_INDEX_NUM_PROPERTIES
};
static GParamSpec* budgie_app_index_properties[BUDGIE_APP_INDEX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BUDGIE_APP_INDEX_CHANGED_SIGNAL,
	BUDGIE_APP_INDEX_NUM_SIGNALS
};
static guint budgie_app_index_signals[BUDGIE_APP_INDEX_NUM_SIGNALS] = {0};

struct _BudgieAppIndexPrivate {
	GeeArrayList* categories;
	BudgieCategory* misc_category;
	GAppInfoMonitor* monitor;
	GFileMonitor* file_monitor;
	guint timeout_id;
};

static gint BudgieAppIndex_private_offset;
static gpointer budgie_app_index_parent_class = NULL;
static BudgieAppIndex* budgie_app_index__instance;
static BudgieAppIndex* budgie_app_index__instance = NULL;

static BudgieAppIndex* budgie_app_index_new (void);
static BudgieAppIndex* budgie_app_index_construct (GType object_type);
static gboolean __lambda7_ (BudgieAppIndex* self);
static void budgie_app_index_refresh (BudgieAppIndex* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void budgie_app_index_create_custom_categories (BudgieAppIndex* self);
static void budgie_app_index_sort_application (BudgieAppIndex* self,
                                        GDesktopAppInfo* app_info);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * budgie_app_index_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _budgie_app_index___lambda8_ (BudgieAppIndex* self);
static void __budgie_app_index___lambda8__g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                               gpointer self);
static void _budgie_app_index____lambda9_ (BudgieAppIndex* self);
static void __budgie_app_index____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                                            GFile* file,
                                                            GFile* other_file,
                                                            GFileMonitorEvent event_type,
                                                            gpointer self);
static void budgie_app_index_finalize (GObject * obj);
static GType budgie_app_index_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
budgie_app_index_get_instance_private (BudgieAppIndex* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppIndex_private_offset);
}

static BudgieAppIndex*
budgie_app_index_construct (GType object_type)
{
	BudgieAppIndex * self = NULL;
	self = (BudgieAppIndex*) g_object_new (object_type, NULL);
	return self;
}

static BudgieAppIndex*
budgie_app_index_new (void)
{
	return budgie_app_index_construct (BUDGIE_TYPE_APP_INDEX);
}

/**
 * Gets the shared static AppIndex instance.
 *
 * If it has not yet been created, this function will
 * create it and return it.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BudgieAppIndex*
budgie_app_index_get (void)
{
	BudgieAppIndex* _tmp0_;
	BudgieAppIndex* _tmp2_;
	BudgieAppIndex* _tmp3_;
	BudgieAppIndex* result;
	_tmp0_ = budgie_app_index__instance;
	if (_tmp0_ == NULL) {
		BudgieAppIndex* _tmp1_;
		_tmp1_ = budgie_app_index_new ();
		_g_object_unref0 (budgie_app_index__instance);
		budgie_app_index__instance = _tmp1_;
	}
	_tmp2_ = budgie_app_index__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
 * Get all of the registered categories with applications in them.
 */
GeeArrayList*
budgie_app_index_get_categories (BudgieAppIndex* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->categories;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		g_warning ("AppIndex.vala:91: Trying to access application categories, but it is n" \
"ull!");
		_tmp1_ = gee_array_list_new (BUDGIE_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->categories);
		self->priv->categories = _tmp1_;
	}
	_tmp2_ = self->priv->categories;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

/**
* Queue an update of the application system to run.
*
* The time to wait before refreshing can be set by passing
* in the number of seconds. By default the time is 3 seconds.
*/
static gboolean
__lambda7_ (BudgieAppIndex* self)
{
	gboolean result;
	budgie_app_index_refresh (self);
	self->priv->timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((BudgieAppIndex*) self);
	return result;
}

void
budgie_app_index_queue_refresh (BudgieAppIndex* self,
                                gint seconds)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) seconds, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
}

/**
* Rebuild the entire app and category indexes.
*
* This iterates over all AppInfos on the system, so it is likely to be
* costly to call this function.
*/
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
budgie_app_index_refresh (BudgieAppIndex* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp2_;
	BudgieCategory* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	BudgieCategory* _tmp14_ = NULL;
	BudgieCategory* _tmp15_;
	GeeArrayList* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	BudgieCategory* _tmp21_ = NULL;
	BudgieCategory* _tmp22_;
	GeeArrayList* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	BudgieCategory* _tmp26_ = NULL;
	BudgieCategory* _tmp27_;
	GeeArrayList* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_;
	BudgieCategory* _tmp33_ = NULL;
	BudgieCategory* _tmp34_;
	GeeArrayList* _tmp35_;
	gchar* _tmp36_;
	gchar** _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	BudgieCategory* _tmp40_ = NULL;
	BudgieCategory* _tmp41_;
	GeeArrayList* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	BudgieCategory* _tmp45_ = NULL;
	BudgieCategory* _tmp46_;
	GeeArrayList* _tmp47_;
	gchar* _tmp48_;
	gchar** _tmp49_;
	BudgieCategory* _tmp50_ = NULL;
	BudgieCategory* _tmp51_;
	GeeArrayList* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar** _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	BudgieCategory* _tmp58_ = NULL;
	BudgieCategory* _tmp59_;
	GeeArrayList* _tmp60_;
	gchar* _tmp61_;
	gchar** _tmp62_;
	BudgieCategory* _tmp63_ = NULL;
	BudgieCategory* _tmp64_;
	GeeArrayList* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar** _tmp69_;
	gchar* _tmp70_;
	gchar** _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar** _tmp74_;
	BudgieCategory* _tmp75_ = NULL;
	BudgieCategory* _tmp76_;
	GeeArrayList* _tmp77_;
	gchar* _tmp78_;
	gchar** _tmp79_;
	BudgieCategory* _tmp80_ = NULL;
	BudgieCategory* _tmp81_;
	GList* _tmp82_;
	BudgieCategory* _tmp87_;
	GeeArrayList* _tmp88_;
	GeeArrayList* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->categories;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		g_warning ("AppIndex.vala:127: Trying to refresh the application index, but it is " \
"null!");
		_tmp1_ = gee_array_list_new (BUDGIE_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->categories);
		self->priv->categories = _tmp1_;
	}
	_tmp2_ = self->priv->categories;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	_tmp3_ = self->priv->misc_category;
	_tmp4_ = budgie_category_get_apps (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp5_);
	_tmp6_ = self->priv->categories;
	_tmp7_ = g_strdup ("Utility");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = g_strdup ("Accessibility");
	_tmp10_ = g_strdup ("System");
	_tmp11_ = g_new0 (gchar*, 2 + 1);
	_tmp11_[0] = _tmp9_;
	_tmp11_[1] = _tmp10_;
	_tmp12_ = g_strdup ("plank.desktop");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = budgie_category_new (_ ("Accessories"), FALSE);
	_tmp14_->included_categories = (_vala_array_free (_tmp14_->included_categories, _tmp14_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp14_->included_categories = _tmp8_;
	_tmp14_->included_categories_length1 = 1;
	_tmp14_->excluded_categories = (_vala_array_free (_tmp14_->excluded_categories, _tmp14_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp14_->excluded_categories = _tmp11_;
	_tmp14_->excluded_categories_length1 = 2;
	_tmp14_->excluded_applications = (_vala_array_free (_tmp14_->excluded_applications, _tmp14_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp14_->excluded_applications = _tmp13_;
	_tmp14_->excluded_applications_length1 = 1;
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->categories;
	_tmp17_ = g_strdup ("Education");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = g_strdup ("Science");
	_tmp20_ = g_new0 (gchar*, 1 + 1);
	_tmp20_[0] = _tmp19_;
	_tmp21_ = budgie_category_new (_ ("Education"), FALSE);
	_tmp21_->included_categories = (_vala_array_free (_tmp21_->included_categories, _tmp21_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp21_->included_categories = _tmp18_;
	_tmp21_->included_categories_length1 = 1;
	_tmp21_->excluded_categories = (_vala_array_free (_tmp21_->excluded_categories, _tmp21_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp21_->excluded_categories = _tmp20_;
	_tmp21_->excluded_categories_length1 = 1;
	_tmp22_ = _tmp21_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->categories;
	_tmp24_ = g_strdup ("Game");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = budgie_category_new (_ ("Games"), FALSE);
	_tmp26_->included_categories = (_vala_array_free (_tmp26_->included_categories, _tmp26_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp26_->included_categories = _tmp25_;
	_tmp26_->included_categories_length1 = 1;
	_tmp27_ = _tmp26_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->categories;
	_tmp29_ = g_strdup ("Graphics");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = g_strdup ("org.gnome.Evince.desktop");
	_tmp32_ = g_new0 (gchar*, 1 + 1);
	_tmp32_[0] = _tmp31_;
	_tmp33_ = budgie_category_new (_ ("Graphics"), FALSE);
	_tmp33_->included_categories = (_vala_array_free (_tmp33_->included_categories, _tmp33_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp33_->included_categories = _tmp30_;
	_tmp33_->included_categories_length1 = 1;
	_tmp33_->excluded_applications = (_vala_array_free (_tmp33_->excluded_applications, _tmp33_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp33_->excluded_applications = _tmp32_;
	_tmp33_->excluded_applications_length1 = 1;
	_tmp34_ = _tmp33_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = self->priv->categories;
	_tmp36_ = g_strdup ("Network");
	_tmp37_ = g_new0 (gchar*, 1 + 1);
	_tmp37_[0] = _tmp36_;
	_tmp38_ = g_strdup ("vinagre.desktop");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = budgie_category_new (_ ("Internet"), FALSE);
	_tmp40_->included_categories = (_vala_array_free (_tmp40_->included_categories, _tmp40_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp40_->included_categories = _tmp37_;
	_tmp40_->included_categories_length1 = 1;
	_tmp40_->excluded_applications = (_vala_array_free (_tmp40_->excluded_applications, _tmp40_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp40_->excluded_applications = _tmp39_;
	_tmp40_->excluded_applications_length1 = 1;
	_tmp41_ = _tmp40_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp41_);
	_g_object_unref0 (_tmp41_);
	_tmp42_ = self->priv->categories;
	_tmp43_ = g_strdup ("Office");
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	_tmp45_ = budgie_category_new (_ ("Office"), FALSE);
	_tmp45_->included_categories = (_vala_array_free (_tmp45_->included_categories, _tmp45_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp45_->included_categories = _tmp44_;
	_tmp45_->included_categories_length1 = 1;
	_tmp46_ = _tmp45_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = self->priv->categories;
	_tmp48_ = g_strdup ("Development");
	_tmp49_ = g_new0 (gchar*, 1 + 1);
	_tmp49_[0] = _tmp48_;
	_tmp50_ = budgie_category_new (_ ("Programming"), FALSE);
	_tmp50_->included_categories = (_vala_array_free (_tmp50_->included_categories, _tmp50_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp50_->included_categories = _tmp49_;
	_tmp50_->included_categories_length1 = 1;
	_tmp51_ = _tmp50_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp47_, _tmp51_);
	_g_object_unref0 (_tmp51_);
	_tmp52_ = self->priv->categories;
	_tmp53_ = g_strdup ("Science");
	_tmp54_ = g_strdup ("Education");
	_tmp55_ = g_new0 (gchar*, 2 + 1);
	_tmp55_[0] = _tmp53_;
	_tmp55_[1] = _tmp54_;
	_tmp56_ = g_strdup ("libreoffice-math.desktop");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = budgie_category_new (_ ("Science"), FALSE);
	_tmp58_->included_categories = (_vala_array_free (_tmp58_->included_categories, _tmp58_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp58_->included_categories = _tmp55_;
	_tmp58_->included_categories_length1 = 2;
	_tmp58_->excluded_applications = (_vala_array_free (_tmp58_->excluded_applications, _tmp58_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp58_->excluded_applications = _tmp57_;
	_tmp58_->excluded_applications_length1 = 1;
	_tmp59_ = _tmp58_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp59_);
	_g_object_unref0 (_tmp59_);
	_tmp60_ = self->priv->categories;
	_tmp61_ = g_strdup ("AudioVideo");
	_tmp62_ = g_new0 (gchar*, 1 + 1);
	_tmp62_[0] = _tmp61_;
	_tmp63_ = budgie_category_new (_ ("Sound & Video"), FALSE);
	_tmp63_->included_categories = (_vala_array_free (_tmp63_->included_categories, _tmp63_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp63_->included_categories = _tmp62_;
	_tmp63_->included_categories_length1 = 1;
	_tmp64_ = _tmp63_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = self->priv->categories;
	_tmp66_ = g_strdup ("Administration");
	_tmp67_ = g_strdup ("Settings");
	_tmp68_ = g_strdup ("System");
	_tmp69_ = g_new0 (gchar*, 3 + 1);
	_tmp69_[0] = _tmp66_;
	_tmp69_[1] = _tmp67_;
	_tmp69_[2] = _tmp68_;
	_tmp70_ = g_strdup ("Games");
	_tmp71_ = g_new0 (gchar*, 1 + 1);
	_tmp71_[0] = _tmp70_;
	_tmp72_ = g_strdup ("onboard.desktop");
	_tmp73_ = g_strdup ("onboard-settings.desktop");
	_tmp74_ = g_new0 (gchar*, 2 + 1);
	_tmp74_[0] = _tmp72_;
	_tmp74_[1] = _tmp73_;
	_tmp75_ = budgie_category_new (_ ("System Tools"), FALSE);
	_tmp75_->included_categories = (_vala_array_free (_tmp75_->included_categories, _tmp75_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp75_->included_categories = _tmp69_;
	_tmp75_->included_categories_length1 = 3;
	_tmp75_->excluded_categories = (_vala_array_free (_tmp75_->excluded_categories, _tmp75_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp75_->excluded_categories = _tmp71_;
	_tmp75_->excluded_categories_length1 = 1;
	_tmp75_->excluded_applications = (_vala_array_free (_tmp75_->excluded_applications, _tmp75_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp75_->excluded_applications = _tmp74_;
	_tmp75_->excluded_applications_length1 = 2;
	_tmp76_ = _tmp75_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, _tmp76_);
	_g_object_unref0 (_tmp76_);
	_tmp77_ = self->priv->categories;
	_tmp78_ = g_strdup ("Accessibility");
	_tmp79_ = g_new0 (gchar*, 1 + 1);
	_tmp79_[0] = _tmp78_;
	_tmp80_ = budgie_category_new (_ ("Universal Access"), FALSE);
	_tmp80_->included_categories = (_vala_array_free (_tmp80_->included_categories, _tmp80_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp80_->included_categories = _tmp79_;
	_tmp80_->included_categories_length1 = 1;
	_tmp81_ = _tmp80_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp77_, _tmp81_);
	_g_object_unref0 (_tmp81_);
	budgie_app_index_create_custom_categories (self);
	_tmp82_ = g_app_info_get_all ();
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp82_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* _tmp83_;
			GAppInfo* app = NULL;
			_tmp83_ = _g_object_ref0 ((GAppInfo*) app_it->data);
			app = _tmp83_;
			{
				GDesktopAppInfo* desktop_app = NULL;
				GAppInfo* _tmp84_;
				GDesktopAppInfo* _tmp85_;
				GDesktopAppInfo* _tmp86_;
				_tmp84_ = app;
				desktop_app = G_TYPE_CHECK_INSTANCE_TYPE (_tmp84_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp84_) : NULL;
				_tmp85_ = desktop_app;
				if (_tmp85_ == NULL) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp86_ = desktop_app;
				budgie_app_index_sort_application (self, _tmp86_);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_list_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp87_ = self->priv->misc_category;
	_tmp88_ = budgie_category_get_apps (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ > 0) {
		GeeArrayList* _tmp92_;
		BudgieCategory* _tmp93_;
		_tmp92_ = self->priv->categories;
		_tmp93_ = self->priv->misc_category;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp93_);
	}
	g_signal_emit (self, budgie_app_index_signals[BUDGIE_APP_INDEX_CHANGED_SIGNAL], 0);
}

/**
 * Read files in `~/.local/share/desktop-directories` and add a new category
 * for each of them.
 */
static void
budgie_app_index_create_custom_categories (BudgieAppIndex* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* directory_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, ".local", "share", "desktop-directories", NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	directory_file = _tmp3_;
	_tmp4_ = directory_file;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		_g_object_unref0 (directory_file);
		_g_free0 (path);
		return;
	}
	{
		GFileEnumerator* children = NULL;
		GFile* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileInfo* child = NULL;
		_tmp5_ = directory_file;
		_tmp6_ = g_file_enumerate_children (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		children = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		child = NULL;
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			gchar* file_path = NULL;
			const gchar* _tmp12_;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			GFileInfo* _tmp16_;
			const gchar* _tmp17_;
			_tmp8_ = children;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (child);
				_g_object_unref0 (children);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (child);
			child = _tmp10_;
			_tmp11_ = child;
			if (!(_tmp11_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp12_ = path;
			_tmp13_ = child;
			_tmp14_ = g_file_info_get_name (_tmp13_);
			_tmp15_ = g_build_path (G_DIR_SEPARATOR_S, _tmp12_, _tmp14_, NULL);
			file_path = _tmp15_;
			_tmp16_ = child;
			_tmp17_ = g_file_info_get_name (_tmp16_);
			if (!g_str_has_suffix (_tmp17_, ".directory")) {
				_g_free0 (file_path);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			{
				GFile* file = NULL;
				const gchar* _tmp18_;
				GFile* _tmp19_;
				BudgieCategory* category = NULL;
				GFile* _tmp20_;
				BudgieCategory* _tmp21_;
				BudgieCategory* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GeeArrayList* _tmp25_;
				BudgieCategory* _tmp26_;
				_tmp18_ = file_path;
				_tmp19_ = g_file_new_for_path (_tmp18_);
				file = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = budgie_category_new_for_file (_tmp20_, &_inner_error0_);
				category = _tmp21_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					goto __catch1_g_error;
				}
				_tmp22_ = category;
				_tmp23_ = budgie_category_get_name (_tmp22_);
				_tmp24_ = _tmp23_;
				g_debug ("AppIndex.vala:261: Adding custom category '%s'", _tmp24_);
				_tmp25_ = self->priv->categories;
				_tmp26_ = category;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				_g_object_unref0 (category);
				_g_object_unref0 (file);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GFileInfo* _tmp27_;
				const gchar* _tmp28_;
				GError* _tmp29_;
				const gchar* _tmp30_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp27_ = child;
				_tmp28_ = g_file_info_get_name (_tmp27_);
				_tmp29_ = e;
				_tmp30_ = _tmp29_->message;
				g_warning ("AppIndex.vala:265: Error creating category from '%s': %s", _tmp28_, _tmp30_);
				_g_error_free0 (e);
				_g_free0 (file_path);
				_g_object_unref0 (_tmp7_);
				continue;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (file_path);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (child);
				_g_object_unref0 (children);
				goto __catch0_g_error;
			}
			_g_free0 (file_path);
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (child);
		_g_object_unref0 (children);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("AppIndex.vala:270: Error enumerating files in desktop-directories: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (directory_file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (directory_file);
	_g_free0 (path);
}

/**
 * Sort a single application into the proper categories.
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
budgie_app_index_sort_application (BudgieAppIndex* self,
                                   GDesktopAppInfo* app_info)
{
	gchar* control_center = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean is_control_center_panel = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean should_skip = FALSE;
	BudgieApplication* application = NULL;
	BudgieApplication* _tmp14_;
	gboolean category_found = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	_tmp0_ = g_strdup ("budgie-control-center");
	control_center = _tmp0_;
	_tmp3_ = g_app_info_get_commandline ((GAppInfo*) app_info);
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = g_app_info_get_commandline ((GAppInfo*) app_info);
		_tmp5_ = control_center;
		_tmp2_ = string_contains (_tmp4_, _tmp5_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp6_ = g_app_info_get_commandline ((GAppInfo*) app_info);
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = control_center;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp8_ != _tmp11_;
	} else {
		_tmp1_ = FALSE;
	}
	is_control_center_panel = _tmp1_;
	if (!g_app_info_should_show ((GAppInfo*) app_info)) {
		_tmp13_ = !is_control_center_panel;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = g_desktop_app_info_get_boolean (app_info, "Terminal");
	}
	should_skip = _tmp12_;
	if (should_skip) {
		_g_free0 (control_center);
		return;
	}
	_tmp14_ = budgie_application_new (app_info);
	application = _tmp14_;
	category_found = FALSE;
	{
		GeeArrayList* _category_list = NULL;
		GeeArrayList* _tmp15_;
		gint _category_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _category_index = 0;
		_tmp15_ = self->priv->categories;
		_category_list = _tmp15_;
		_tmp16_ = _category_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_category_size = _tmp18_;
		_category_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BudgieCategory* category = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BudgieCategory* _tmp23_;
			BudgieApplication* _tmp24_;
			_category_index = _category_index + 1;
			_tmp19_ = _category_index;
			_tmp20_ = _category_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _category_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _category_index);
			category = (BudgieCategory*) _tmp22_;
			_tmp23_ = category;
			_tmp24_ = application;
			if (budgie_category_maybe_add_app (_tmp23_, _tmp24_)) {
				category_found = TRUE;
			}
			_g_object_unref0 (category);
		}
	}
	if (!category_found) {
		BudgieCategory* _tmp25_;
		BudgieApplication* _tmp26_;
		_tmp25_ = self->priv->misc_category;
		_tmp26_ = application;
		budgie_category_maybe_add_app (_tmp25_, _tmp26_);
	}
	_g_object_unref0 (application);
	_g_free0 (control_center);
}

static void
_budgie_app_index___lambda8_ (BudgieAppIndex* self)
{
	budgie_app_index_queue_refresh (self, 3);
}

static void
__budgie_app_index___lambda8__g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                          gpointer self)
{
	_budgie_app_index___lambda8_ ((BudgieAppIndex*) self);
}

static void
_budgie_app_index____lambda9_ (BudgieAppIndex* self)
{
	budgie_app_index_queue_refresh (self, 3);
}

static void
__budgie_app_index____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                                       GFile* file,
                                                       GFile* other_file,
                                                       GFileMonitorEvent event_type,
                                                       gpointer self)
{
	_budgie_app_index____lambda9_ ((BudgieAppIndex*) self);
}

static GObject *
budgie_app_index_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieAppIndex * self;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	BudgieCategory* _tmp10_ = NULL;
	GAppInfoMonitor* _tmp11_;
	GAppInfoMonitor* _tmp12_;
	gchar* path = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GFile* directory_file = NULL;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (budgie_app_index_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_INDEX, BudgieAppIndex);
	_tmp0_ = gee_array_list_new (BUDGIE_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->categories);
	self->priv->categories = _tmp0_;
	_tmp1_ = g_strdup ("Core");
	_tmp2_ = g_strdup ("Screensaver");
	_tmp3_ = g_strdup ("Settings");
	_tmp4_ = g_new0 (gchar*, 3 + 1);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp2_;
	_tmp4_[2] = _tmp3_;
	_tmp5_ = g_strdup ("htop.desktop");
	_tmp6_ = g_strdup ("onboard.desktop");
	_tmp7_ = g_strdup ("org.gnome.FileRoller.desktop");
	_tmp8_ = g_strdup ("org.gnome.font-viewer.desktop");
	_tmp9_ = g_new0 (gchar*, 4 + 1);
	_tmp9_[0] = _tmp5_;
	_tmp9_[1] = _tmp6_;
	_tmp9_[2] = _tmp7_;
	_tmp9_[3] = _tmp8_;
	_tmp10_ = budgie_category_new (_ ("Other"), TRUE);
	_tmp10_->excluded_categories = (_vala_array_free (_tmp10_->excluded_categories, _tmp10_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_->excluded_categories = _tmp4_;
	_tmp10_->excluded_categories_length1 = 3;
	_tmp10_->excluded_applications = (_vala_array_free (_tmp10_->excluded_applications, _tmp10_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_->excluded_applications = _tmp9_;
	_tmp10_->excluded_applications_length1 = 4;
	_g_object_unref0 (self->priv->misc_category);
	self->priv->misc_category = _tmp10_;
	_tmp11_ = g_app_info_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp11_;
	_tmp12_ = self->priv->monitor;
	g_signal_connect_object (_tmp12_, "changed", (GCallback) __budgie_app_index___lambda8__g_app_info_monitor_changed, self, 0);
	_tmp13_ = g_get_home_dir ();
	_tmp14_ = g_build_path (G_DIR_SEPARATOR_S, _tmp13_, ".local", "share", "desktop-directories", NULL);
	path = _tmp14_;
	_tmp15_ = path;
	_tmp16_ = g_file_new_for_path (_tmp15_);
	directory_file = _tmp16_;
	{
		GFileMonitor* _tmp17_ = NULL;
		GFile* _tmp18_;
		GFileMonitor* _tmp19_;
		GFileMonitor* _tmp20_;
		GFileMonitor* _tmp21_;
		_tmp18_ = directory_file;
		_tmp19_ = g_file_monitor_directory (_tmp18_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp17_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (directory_file);
			_g_free0 (path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp20_ = _tmp17_;
		_tmp17_ = NULL;
		_g_object_unref0 (self->priv->file_monitor);
		self->priv->file_monitor = _tmp20_;
		_tmp21_ = self->priv->file_monitor;
		g_signal_connect_object (_tmp21_, "changed", (GCallback) __budgie_app_index____lambda9__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp17_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_debug ("AppIndex.vala:65: Failed to create monitor for desktop directory: %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (directory_file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	budgie_app_index_refresh (self);
	_g_object_unref0 (directory_file);
	_g_free0 (path);
	return obj;
}

static void
budgie_app_index_class_init (BudgieAppIndexClass * klass,
                             gpointer klass_data)
{
	budgie_app_index_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppIndex_private_offset);
	G_OBJECT_CLASS (klass)->constructor = budgie_app_index_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_app_index_finalize;
	/**
	* Signal emitted whenever a change to the application state
	* occurs.
	*/
	budgie_app_index_signals[BUDGIE_APP_INDEX_CHANGED_SIGNAL] = g_signal_new ("changed", BUDGIE_TYPE_APP_INDEX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
budgie_app_index_instance_init (BudgieAppIndex * self,
                                gpointer klass)
{
	self->priv = budgie_app_index_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
}

static void
budgie_app_index_finalize (GObject * obj)
{
	BudgieAppIndex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APP_INDEX, BudgieAppIndex);
	_g_object_unref0 (self->priv->categories);
	_g_object_unref0 (self->priv->misc_category);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->file_monitor);
	G_OBJECT_CLASS (budgie_app_index_parent_class)->finalize (obj);
}

/**
* This holds all of the application and category state for all
* installed applications on the system.
*/
static GType
budgie_app_index_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppIndexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_app_index_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppIndex), 0, (GInstanceInitFunc) budgie_app_index_instance_init, NULL };
	GType budgie_app_index_type_id;
	budgie_app_index_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieAppIndex", &g_define_type_info, 0);
	BudgieAppIndex_private_offset = g_type_add_instance_private (budgie_app_index_type_id, sizeof (BudgieAppIndexPrivate));
	return budgie_app_index_type_id;
}

GType
budgie_app_index_get_type (void)
{
	static volatile gsize budgie_app_index_type_id__once = 0;
	if (g_once_init_enter (&budgie_app_index_type_id__once)) {
		GType budgie_app_index_type_id;
		budgie_app_index_type_id = budgie_app_index_get_type_once ();
		g_once_init_leave (&budgie_app_index_type_id__once, budgie_app_index_type_id);
	}
	return budgie_app_index_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

