/* abomination.c generated by valac 0.56.14, the Vala compiler
 * generated from abomination.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "abomination.h"
#include <gio/gio.h>
#include "appsys.h"
#include <libwnck/libwnck.h>
#include <glib-object.h>

#define NOTIFICATIONS_DBUS_NAME "org.budgie_desktop.Notifications"
#define NOTIFICATIONS_DBUS_OBJECT_PATH "/org/budgie_desktop/Notifications"

typedef GDBusProxy NotificationsRemoteProxy;
typedef GDBusProxyClass NotificationsRemoteProxyClass;
enum  {
	BUDGIE_ABOMINATION_ABOMINATION_0_PROPERTY,
	BUDGIE_ABOMINATION_ABOMINATION_NUM_PROPERTIES
};
static GParamSpec* budgie_abomination_abomination_properties[BUDGIE_ABOMINATION_ABOMINATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
enum  {
	BUDGIE_ABOMINATION_ABOMINATION_ADDED_APP_SIGNAL,
	BUDGIE_ABOMINATION_ABOMINATION_REMOVED_APP_SIGNAL,
	BUDGIE_ABOMINATION_ABOMINATION_UPDATED_GROUP_SIGNAL,
	BUDGIE_ABOMINATION_ABOMINATION_NUM_SIGNALS
};
static guint budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_NUM_SIGNALS] = {0};

struct _BudgieAbominationAbominationPrivate {
	BudgieAppSystem* app_system;
	GSettings* color_settings;
	GSettings* wm_settings;
	gboolean original_night_light_setting;
	gboolean should_disable_night_light_on_fullscreen;
	gboolean should_pause_notifications_on_fullscreen;
	GHashTable* fullscreen_windows;
	GHashTable* running_apps_id;
	GHashTable* running_app_groups;
	WnckScreen* screen;
	NotificationsRemote* notifications_proxy;
	gulong color_id;
};

struct _Block1Data {
	int _ref_count_;
	BudgieAbominationAbomination* self;
	BudgieAbominationRunningApp* app;
	WnckWindow* window;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gulong handler_id;
};

struct _Block3Data {
	int _ref_count_;
	BudgieAbominationAbomination* self;
	BudgieAbominationAppGroup* group;
	gchar* old_group_name;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	GList* existing_group_windows;
	GList* new_group_windows;
};

static gint BudgieAbominationAbomination_private_offset;
static gpointer budgie_abomination_abomination_parent_class = NULL;

static GType notifications_remote_get_type_once (void);
static void notifications_remote_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static gboolean notifications_remote_dbus_proxy_get_notifications_paused (NotificationsRemote* self);
static void notifications_remote_dbus_proxy_set_notifications_paused (NotificationsRemote* self,
                                                               gboolean value);
static void notifications_remote_proxy_notifications_remote_interface_init (NotificationsRemoteIface* iface);
static void notifications_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* notifications_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static GVariant* _dbus_notifications_remote_get_notifications_paused (NotificationsRemote* self);
static gboolean notifications_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _dbus_notifications_remote_set_notifications_paused (NotificationsRemote* self,
                                                          GVariant* _value);
static void _notifications_remote_unregister_object (gpointer user_data);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _budgie_abomination_abomination_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                                        GAsyncResult* res,
                                                                        gpointer self);
static void budgie_abomination_abomination_update_night_light_value (BudgieAbominationAbomination* self);
static void _budgie_abomination_abomination_update_night_light_value_g_settings_changed (GSettings* _sender,
                                                                                  const gchar* key,
                                                                                  gpointer self);
static void budgie_abomination_abomination_update_should_disable_night_light (BudgieAbominationAbomination* self);
static void budgie_abomination_abomination_update_should_pause_notifications (BudgieAbominationAbomination* self);
static void _budgie_abomination_abomination_update_should_disable_night_light_g_settings_changed (GSettings* _sender,
                                                                                           const gchar* key,
                                                                                           gpointer self);
static void _budgie_abomination_abomination_update_should_pause_notifications_g_settings_changed (GSettings* _sender,
                                                                                           const gchar* key,
                                                                                           gpointer self);
static void budgie_abomination_abomination_remove_app (BudgieAbominationAbomination* self,
                                                WnckWindow* window);
static void _budgie_abomination_abomination_remove_app_wnck_screen_window_closed (WnckScreen* _sender,
                                                                           WnckWindow* window,
                                                                           gpointer self);
static void budgie_abomination_abomination_add_app (BudgieAbominationAbomination* self,
                                             WnckWindow* window);
static void _budgie_abomination_abomination_add_app_wnck_screen_window_opened (WnckScreen* _sender,
                                                                        WnckWindow* window,
                                                                        gpointer self);
static void __lambda20_ (BudgieAbominationAbomination* self,
                  WnckWindow* window);
static void ___lambda20__gfunc (gconstpointer data,
                         gpointer self);
static BudgieAbominationAppGroup* budgie_abomination_abomination_get_window_group (BudgieAbominationAbomination* self,
                                                                            WnckWindow* window);
VALA_EXTERN gchar* budgie_abomination_get_group_name (WnckWindow* window);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda11_ (Block2Data* _data2_);
static gboolean __lambda12_ (Block2Data* _data2_);
static gboolean ___lambda12__gsource_func (gpointer self);
static void ____lambda11__wnck_window_name_changed (WnckWindow* _sender,
                                             gpointer self);
VALA_EXTERN BudgieAbominationAppGroup* budgie_abomination_app_group_new (WnckWindow* window);
VALA_EXTERN BudgieAbominationAppGroup* budgie_abomination_app_group_construct (GType object_type,
                                                                   WnckWindow* window);
static void ___lambda13_ (BudgieAbominationAbomination* self,
                   const gchar* old_group_name,
                   const gchar* new_group_name);
static void budgie_abomination_abomination_rename_group (BudgieAbominationAbomination* self,
                                                  const gchar* old_group_name,
                                                  const gchar* new_group_name);
static void ____lambda13__budgie_abomination_app_group_renamed_group (BudgieAbominationAppGroup* _sender,
                                                               const gchar* old_name,
                                                               const gchar* new_name,
                                                               gpointer self);
VALA_EXTERN BudgieAbominationRunningApp* budgie_abomination_running_app_new (BudgieAppSystem* app_system,
                                                                 WnckWindow* window,
                                                                 BudgieAbominationAppGroup* group);
VALA_EXTERN BudgieAbominationRunningApp* budgie_abomination_running_app_construct (GType object_type,
                                                                       BudgieAppSystem* app_system,
                                                                       WnckWindow* window,
                                                                       BudgieAbominationAppGroup* group);
static gulong* _ulong_dup (gulong* self);
static void budgie_abomination_abomination_track_window_fullscreen_state (BudgieAbominationAbomination* self,
                                                                   WnckWindow* window,
                                                                   WnckWindowState* state);
static void __lambda19_ (Block1Data* _data1_,
                  WnckWindowState changed,
                  WnckWindowState new_state);
static void ___lambda19__wnck_window_state_changed (WnckWindow* _sender,
                                             WnckWindowState changed_mask,
                                             WnckWindowState new_state,
                                             gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda14_ (BudgieAbominationAbomination* self,
                   WnckWindow* window);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static void ___lambda15_ (Block4Data* _data4_,
                   WnckWindow* window);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
static gboolean ___lambda16_ (Block4Data* _data4_);
static void __lambda17_ (BudgieAbominationAbomination* self,
                  WnckWindow* window);
static void ___lambda17__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda18_ (BudgieAbominationAbomination* self,
                  WnckWindow* window);
static void ___lambda18__gfunc (gconstpointer data,
                         gpointer self);
static gboolean ____lambda16__gsource_func (gpointer self);
static gboolean budgie_abomination_abomination_state_is_fullscreen (BudgieAbominationAbomination* self,
                                                             WnckWindowState* state);
static void budgie_abomination_abomination_toggle_night_light (BudgieAbominationAbomination* self);
static void budgie_abomination_abomination_set_notifications_paused (BudgieAbominationAbomination* self);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void budgie_abomination_abomination_finalize (GObject * obj);
static GType budgie_abomination_abomination_get_type_once (void);

static const GDBusMethodInfo * const _notifications_remote_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _notifications_remote_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _notifications_remote_dbus_property_info_notifications_paused = {-1, "NotificationsPaused", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _notifications_remote_dbus_property_info[] = {&_notifications_remote_dbus_property_info_notifications_paused, NULL};
static const GDBusInterfaceInfo _notifications_remote_dbus_interface_info = {-1, "org.buddiesofbudgie.budgie.Dispatcher", (GDBusMethodInfo **) (&_notifications_remote_dbus_method_info), (GDBusSignalInfo **) (&_notifications_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_notifications_remote_dbus_property_info), NULL};
static const GDBusInterfaceVTable _notifications_remote_dbus_interface_vtable = {notifications_remote_dbus_interface_method_call, notifications_remote_dbus_interface_get_property, notifications_remote_dbus_interface_set_property};

gboolean
notifications_remote_get_notifications_paused (NotificationsRemote* self)
{
	NotificationsRemoteIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = NOTIFICATIONS_REMOTE_GET_INTERFACE (self);
	if (_iface_->get_notifications_paused) {
		return _iface_->get_notifications_paused (self);
	}
	return FALSE;
}

void
notifications_remote_set_notifications_paused (NotificationsRemote* self,
                                               gboolean value)
{
	NotificationsRemoteIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = NOTIFICATIONS_REMOTE_GET_INTERFACE (self);
	if (_iface_->set_notifications_paused) {
		_iface_->set_notifications_paused (self, value);
	}
}

static void
notifications_remote_default_init (NotificationsRemoteIface * iface,
                                   gpointer iface_data)
{
}

static GType
notifications_remote_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsRemoteIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_remote_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType notifications_remote_type_id;
	notifications_remote_type_id = g_type_register_static (G_TYPE_INTERFACE, "NotificationsRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (notifications_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (notifications_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) notifications_remote_proxy_get_type);
	g_type_set_qdata (notifications_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.buddiesofbudgie.budgie.Dispatcher");
	g_type_set_qdata (notifications_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_notifications_remote_dbus_interface_info));
	g_type_set_qdata (notifications_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) notifications_remote_register_object);
	return notifications_remote_type_id;
}

GType
notifications_remote_get_type (void)
{
	static volatile gsize notifications_remote_type_id__once = 0;
	if (g_once_init_enter (&notifications_remote_type_id__once)) {
		GType notifications_remote_type_id;
		notifications_remote_type_id = notifications_remote_get_type_once ();
		g_once_init_leave (&notifications_remote_type_id__once, notifications_remote_type_id);
	}
	return notifications_remote_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (NotificationsRemoteProxy, notifications_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_NOTIFICATIONS_REMOTE, notifications_remote_proxy_notifications_remote_interface_init) )
static void
notifications_remote_proxy_class_init (NotificationsRemoteProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = notifications_remote_proxy_g_signal;
}

static void
notifications_remote_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
}

static void
notifications_remote_proxy_init (NotificationsRemoteProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_notifications_remote_dbus_interface_info));
}

static gboolean
notifications_remote_dbus_proxy_get_notifications_paused (NotificationsRemote* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "NotificationsPaused");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.buddiesofbudgie.budgie.Dispatcher"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("NotificationsPaused"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp0_ = FALSE;
			return _tmp0_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
notifications_remote_dbus_proxy_set_notifications_paused (NotificationsRemote* self,
                                                          gboolean value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.buddiesofbudgie.budgie.Dispatcher"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("NotificationsPaused"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
notifications_remote_proxy_notifications_remote_interface_init (NotificationsRemoteIface* iface)
{
	iface->get_notifications_paused = notifications_remote_dbus_proxy_get_notifications_paused;
	iface->set_notifications_paused = notifications_remote_dbus_proxy_set_notifications_paused;
}

static void
notifications_remote_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_notifications_remote_get_notifications_paused (NotificationsRemote* self)
{
	gboolean result;
	GVariant* _reply;
	result = notifications_remote_get_notifications_paused (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
notifications_remote_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		return _dbus_notifications_remote_get_notifications_paused (object);
	}
	return NULL;
}

static void
_dbus_notifications_remote_set_notifications_paused (NotificationsRemote* self,
                                                     GVariant* _value)
{
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	notifications_remote_set_notifications_paused (self, value);
}

static gboolean
notifications_remote_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "NotificationsPaused") == 0) {
		_dbus_notifications_remote_set_notifications_paused (object, value);
		return TRUE;
	}
	return FALSE;
}

guint
notifications_remote_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_notifications_remote_dbus_interface_info), &_notifications_remote_dbus_interface_vtable, data, _notifications_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_notifications_remote_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
budgie_abomination_abomination_get_instance_private (BudgieAbominationAbomination* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAbominationAbomination_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_abomination_abomination_on_dbus_get_gasync_ready_callback (GObject* source_object,
                                                                   GAsyncResult* res,
                                                                   gpointer self)
{
	budgie_abomination_abomination_on_dbus_get ((BudgieAbominationAbomination*) self, source_object, res);
	g_object_unref (self);
}

static void
_budgie_abomination_abomination_update_night_light_value_g_settings_changed (GSettings* _sender,
                                                                             const gchar* key,
                                                                             gpointer self)
{
	budgie_abomination_abomination_update_night_light_value ((BudgieAbominationAbomination*) self);
}

static void
_budgie_abomination_abomination_update_should_disable_night_light_g_settings_changed (GSettings* _sender,
                                                                                      const gchar* key,
                                                                                      gpointer self)
{
	budgie_abomination_abomination_update_should_disable_night_light ((BudgieAbominationAbomination*) self);
}

static void
_budgie_abomination_abomination_update_should_pause_notifications_g_settings_changed (GSettings* _sender,
                                                                                      const gchar* key,
                                                                                      gpointer self)
{
	budgie_abomination_abomination_update_should_pause_notifications ((BudgieAbominationAbomination*) self);
}

static void
_budgie_abomination_abomination_remove_app_wnck_screen_window_closed (WnckScreen* _sender,
                                                                      WnckWindow* window,
                                                                      gpointer self)
{
	budgie_abomination_abomination_remove_app ((BudgieAbominationAbomination*) self, window);
}

static void
_budgie_abomination_abomination_add_app_wnck_screen_window_opened (WnckScreen* _sender,
                                                                   WnckWindow* window,
                                                                   gpointer self)
{
	budgie_abomination_abomination_add_app ((BudgieAbominationAbomination*) self, window);
}

static void
__lambda20_ (BudgieAbominationAbomination* self,
             WnckWindow* window)
{
	g_return_if_fail (window != NULL);
	budgie_abomination_abomination_add_app (self, window);
}

static void
___lambda20__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda20_ ((BudgieAbominationAbomination*) self, (WnckWindow*) data);
}

BudgieAbominationAbomination*
budgie_abomination_abomination_construct (GType object_type)
{
	BudgieAbominationAbomination * self = NULL;
	BudgieAppSystem* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GHashTable* _tmp11_;
	WnckScreen* _tmp12_;
	WnckScreen* _tmp13_;
	GSettings* _tmp14_;
	GSettings* _tmp17_;
	WnckScreen* _tmp20_;
	WnckScreen* _tmp21_;
	WnckScreen* _tmp22_;
	GList* _tmp23_;
	GError* _inner_error0_ = NULL;
	self = (BudgieAbominationAbomination*) g_object_new (object_type, NULL);
	_tmp0_ = budgie_app_system_new ();
	_g_object_unref0 (self->priv->app_system);
	self->priv->app_system = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
	_g_object_unref0 (self->priv->color_settings);
	self->priv->color_settings = _tmp1_;
	_tmp2_ = g_settings_new ("com.solus-project.budgie-wm");
	_g_object_unref0 (self->priv->wm_settings);
	self->priv->wm_settings = _tmp2_;
	_tmp3_ = g_int_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->fullscreen_windows);
	self->priv->fullscreen_windows = _tmp5_;
	_tmp6_ = g_int_hash;
	_tmp7_ = g_int_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->running_apps_id);
	self->priv->running_apps_id = _tmp8_;
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = g_hash_table_new_full (_tmp9_, _tmp10_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->running_app_groups);
	self->priv->running_app_groups = _tmp11_;
	_tmp12_ = wnck_screen_get_default ();
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->screen);
	self->priv->screen = _tmp13_;
	g_async_initable_new_async (TYPE_NOTIFICATIONS_REMOTE_PROXY, 0, NULL, _budgie_abomination_abomination_on_dbus_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", NOTIFICATIONS_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", NOTIFICATIONS_DBUS_OBJECT_PATH, "g-interface-name", "org.buddiesofbudgie.budgie.Dispatcher", NULL);
	_tmp14_ = self->priv->color_settings;
	if (_tmp14_ != NULL) {
		GSettings* _tmp15_;
		gulong _tmp16_;
		budgie_abomination_abomination_update_night_light_value (self);
		_tmp15_ = self->priv->color_settings;
		_tmp16_ = g_signal_connect_object (_tmp15_, "changed::night-light-enabled", (GCallback) _budgie_abomination_abomination_update_night_light_value_g_settings_changed, self, 0);
		self->priv->color_id = _tmp16_;
	}
	_tmp17_ = self->priv->wm_settings;
	if (_tmp17_ != NULL) {
		GSettings* _tmp18_;
		GSettings* _tmp19_;
		budgie_abomination_abomination_update_should_disable_night_light (self);
		budgie_abomination_abomination_update_should_pause_notifications (self);
		_tmp18_ = self->priv->wm_settings;
		g_signal_connect_object (_tmp18_, "changed::disable-night-light-on-fullscreen", (GCallback) _budgie_abomination_abomination_update_should_disable_night_light_g_settings_changed, self, 0);
		_tmp19_ = self->priv->wm_settings;
		g_signal_connect_object (_tmp19_, "changed::pause-notifications-on-fullscreen", (GCallback) _budgie_abomination_abomination_update_should_pause_notifications_g_settings_changed, self, 0);
	}
	_tmp20_ = self->priv->screen;
	g_signal_connect_object (_tmp20_, "window-closed", (GCallback) _budgie_abomination_abomination_remove_app_wnck_screen_window_closed, self, 0);
	_tmp21_ = self->priv->screen;
	g_signal_connect_object (_tmp21_, "window-opened", (GCallback) _budgie_abomination_abomination_add_app_wnck_screen_window_opened, self, 0);
	_tmp22_ = self->priv->screen;
	_tmp23_ = wnck_screen_get_windows (_tmp22_);
	g_list_foreach (_tmp23_, ___lambda20__gfunc, self);
	return self;
}

BudgieAbominationAbomination*
budgie_abomination_abomination_new (void)
{
	return budgie_abomination_abomination_construct (BUDGIE_ABOMINATION_TYPE_ABOMINATION);
}

void
budgie_abomination_abomination_on_dbus_get (BudgieAbominationAbomination* self,
                                            GObject* o,
                                            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		NotificationsRemote* _tmp0_ = NULL;
		NotificationsRemote* _tmp1_;
		NotificationsRemote* _tmp2_;
		NotificationsRemote* _tmp3_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (NotificationsRemote*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (NotificationsRemote*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->notifications_proxy);
		self->priv->notifications_proxy = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("abomination.vala:87: Failed to gain Raven proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
 * is_disallowed_window_type will check if this specified window is a disallowed type
 */
gboolean
budgie_abomination_abomination_is_disallowed_window_type (BudgieAbominationAbomination* self,
                                                          WnckWindow* window)
{
	WnckWindowType win_type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	win_type = wnck_window_get_window_type (window);
	if (win_type == WNCK_WINDOW_DESKTOP) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (win_type == WNCK_WINDOW_DIALOG) {
			WnckWindow* _tmp5_;
			_tmp5_ = wnck_window_get_transient (window);
			_tmp4_ = _tmp5_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp3_ = _tmp4_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = win_type == WNCK_WINDOW_DOCK;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = win_type == WNCK_WINDOW_SPLASHSCREEN;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = win_type == WNCK_WINDOW_UTILITY;
	}
	result = _tmp0_;
	return result;
}

BudgieAbominationRunningApp*
budgie_abomination_abomination_get_app_from_window_id (BudgieAbominationAbomination* self,
                                                       gulong window_id)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieAbominationRunningApp* _tmp2_;
	BudgieAbominationRunningApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->running_apps_id;
	_tmp1_ = g_hash_table_lookup (_tmp0_, &window_id);
	_tmp2_ = _g_object_ref0 ((BudgieAbominationRunningApp*) _tmp1_);
	result = _tmp2_;
	return result;
}

GList*
budgie_abomination_abomination_get_running_apps (BudgieAbominationAbomination* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->running_apps_id;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Get the first running app of an app group identified by its name.
 */
BudgieAbominationRunningApp*
budgie_abomination_abomination_get_first_app_of_group (BudgieAbominationAbomination* self,
                                                       const gchar* group)
{
	BudgieAbominationAppGroup* app_group = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieAbominationAppGroup* _tmp2_;
	BudgieAbominationAppGroup* _tmp3_;
	WnckWindow* window = NULL;
	BudgieAbominationAppGroup* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	gconstpointer _tmp7_;
	WnckWindow* _tmp8_;
	WnckWindow* _tmp9_;
	WnckWindow* _tmp10_;
	BudgieAbominationRunningApp* first_app = NULL;
	GHashTable* _tmp11_;
	WnckWindow* _tmp12_;
	gulong _tmp13_;
	gconstpointer _tmp14_;
	BudgieAbominationRunningApp* _tmp15_;
	BudgieAbominationRunningApp* _tmp16_;
	gboolean _tmp17_ = FALSE;
	BudgieAbominationRunningApp* _tmp18_;
	WnckWindow* _tmp19_;
	WnckWindow* _tmp20_;
	gboolean _tmp21_;
	BudgieAbominationRunningApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = self->priv->running_app_groups;
	_tmp1_ = g_hash_table_lookup (_tmp0_, group);
	_tmp2_ = _g_object_ref0 ((BudgieAbominationAppGroup*) _tmp1_);
	app_group = _tmp2_;
	_tmp3_ = app_group;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (app_group);
		return result;
	}
	_tmp4_ = app_group;
	_tmp5_ = budgie_abomination_app_group_get_windows (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
	_tmp8_ = _g_object_ref0 ((WnckWindow*) _tmp7_);
	_tmp9_ = _tmp8_;
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (g_list_free (_tmp6_), NULL));
	window = _tmp9_;
	_tmp10_ = window;
	if (_tmp10_ == NULL) {
		result = NULL;
		_g_object_unref0 (window);
		_g_object_unref0 (app_group);
		return result;
	}
	_tmp11_ = self->priv->running_apps_id;
	_tmp12_ = window;
	_tmp13_ = wnck_window_get_xid (_tmp12_);
	_tmp14_ = g_hash_table_lookup (_tmp11_, &_tmp13_);
	_tmp15_ = _g_object_ref0 ((BudgieAbominationRunningApp*) _tmp14_);
	first_app = _tmp15_;
	_tmp16_ = first_app;
	if (_tmp16_ == NULL) {
		result = NULL;
		_g_object_unref0 (first_app);
		_g_object_unref0 (window);
		_g_object_unref0 (app_group);
		return result;
	}
	_tmp18_ = first_app;
	_tmp19_ = budgie_abomination_running_app_get_window (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_ != NULL;
	_g_object_unref0 (_tmp20_);
	if (_tmp21_) {
		BudgieAbominationRunningApp* _tmp22_;
		WnckWindow* _tmp23_;
		WnckWindow* _tmp24_;
		_tmp22_ = first_app;
		_tmp23_ = budgie_abomination_running_app_get_window (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp17_ = wnck_window_get_state (_tmp24_) == WNCK_WINDOW_STATE_SKIP_TASKLIST;
		_g_object_unref0 (_tmp24_);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		result = NULL;
		_g_object_unref0 (first_app);
		_g_object_unref0 (window);
		_g_object_unref0 (app_group);
		return result;
	}
	result = first_app;
	_g_object_unref0 (window);
	_g_object_unref0 (app_group);
	return result;
}

static BudgieAbominationAppGroup*
budgie_abomination_abomination_get_window_group (BudgieAbominationAbomination* self,
                                                 WnckWindow* window)
{
	gchar* group_name = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	gconstpointer _tmp5_;
	BudgieAbominationAppGroup* _tmp6_;
	BudgieAbominationAppGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_tmp0_ = budgie_abomination_get_group_name (window);
	group_name = _tmp0_;
	_tmp1_ = self->priv->running_app_groups;
	_tmp2_ = group_name;
	if (!g_hash_table_contains (_tmp1_, _tmp2_)) {
		result = NULL;
		_g_free0 (group_name);
		return result;
	}
	_tmp3_ = self->priv->running_app_groups;
	_tmp4_ = group_name;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	_tmp6_ = _g_object_ref0 ((BudgieAbominationAppGroup*) _tmp5_);
	result = _tmp6_;
	_g_free0 (group_name);
	return result;
}

/**
 * add_app will add a running application based on the provided window
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieAbominationAbomination* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->app);
		_g_object_unref0 (_data1_->window);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieAbominationAbomination* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda12_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	BudgieAbominationAbomination* self;
	gboolean result;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_signal_handler_disconnect ((GObject*) _data1_->window, _data2_->handler_id);
	budgie_abomination_abomination_add_app (self, _data1_->window);
	result = FALSE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
	return result;
}

static void
___lambda11_ (Block2Data* _data2_)
{
	Block1Data* _data1_;
	BudgieAbominationAbomination* self;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda12__gsource_func, block2_data_ref (_data2_), block2_data_unref);
}

static void
____lambda11__wnck_window_name_changed (WnckWindow* _sender,
                                        gpointer self)
{
	___lambda11_ (self);
}

static void
___lambda13_ (BudgieAbominationAbomination* self,
              const gchar* old_group_name,
              const gchar* new_group_name)
{
	g_return_if_fail (old_group_name != NULL);
	g_return_if_fail (new_group_name != NULL);
	budgie_abomination_abomination_rename_group (self, old_group_name, new_group_name);
}

static void
____lambda13__budgie_abomination_app_group_renamed_group (BudgieAbominationAppGroup* _sender,
                                                          const gchar* old_name,
                                                          const gchar* new_name,
                                                          gpointer self)
{
	___lambda13_ ((BudgieAbominationAbomination*) self, old_name, new_name);
}

static gulong*
_ulong_dup (gulong* self)
{
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}

static gpointer
__ulong_dup0 (gpointer self)
{
	return self ? _ulong_dup (self) : NULL;
}

static void
__lambda19_ (Block1Data* _data1_,
             WnckWindowState changed,
             WnckWindowState new_state)
{
	BudgieAbominationAbomination* self;
	self = _data1_->self;
	if (((changed | new_state) & WNCK_WINDOW_STATE_FULLSCREEN) == WNCK_WINDOW_STATE_FULLSCREEN) {
		BudgieAbominationRunningApp* _tmp0_;
		WnckWindow* _tmp1_;
		WnckWindow* _tmp2_;
		_tmp0_ = _data1_->app;
		_tmp1_ = budgie_abomination_running_app_get_window (_tmp0_);
		_tmp2_ = _tmp1_;
		budgie_abomination_abomination_track_window_fullscreen_state (self, _tmp2_, &new_state);
		_g_object_unref0 (_tmp2_);
	}
}

static void
___lambda19__wnck_window_state_changed (WnckWindow* _sender,
                                        WnckWindowState changed_mask,
                                        WnckWindowState new_state,
                                        gpointer self)
{
	__lambda19_ (self, changed_mask, new_state);
}

static void
budgie_abomination_abomination_add_app (BudgieAbominationAbomination* self,
                                        WnckWindow* window)
{
	Block1Data* _data1_;
	WnckWindow* _tmp0_;
	gboolean _tmp2_ = FALSE;
	BudgieAbominationAppGroup* group = NULL;
	BudgieAbominationAppGroup* _tmp3_;
	BudgieAbominationAppGroup* _tmp4_;
	BudgieAppSystem* _tmp11_;
	BudgieAbominationAppGroup* _tmp12_;
	BudgieAbominationRunningApp* _tmp13_;
	gboolean _tmp14_ = FALSE;
	BudgieAbominationRunningApp* _tmp15_;
	GHashTable* _tmp19_;
	BudgieAbominationRunningApp* _tmp20_;
	gulong _tmp21_;
	gulong _tmp22_;
	gulong* _tmp23_;
	BudgieAbominationRunningApp* _tmp24_;
	BudgieAbominationRunningApp* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	BudgieAbominationRunningApp* _tmp28_;
	BudgieAbominationAppGroup* _tmp29_;
	BudgieAbominationRunningApp* _tmp30_;
	WnckWindow* _tmp31_;
	WnckWindow* _tmp32_;
	BudgieAbominationRunningApp* _tmp33_;
	WnckWindow* _tmp34_;
	WnckWindow* _tmp35_;
	WnckWindowState _tmp36_;
	BudgieAbominationRunningApp* _tmp37_;
	WnckWindow* _tmp38_;
	WnckWindow* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data1_->window);
	_data1_->window = _tmp0_;
	if (!wnck_window_has_name (_data1_->window)) {
		Block2Data* _data2_;
		gulong _tmp1_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_data2_->handler_id = (gulong) 0;
		_tmp1_ = g_signal_connect_data (_data1_->window, "name-changed", (GCallback) ____lambda11__wnck_window_name_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_data2_->handler_id = _tmp1_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	if (budgie_abomination_abomination_is_disallowed_window_type (self, _data1_->window)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	if (wnck_window_is_skip_pager (_data1_->window)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = wnck_window_is_skip_tasklist (_data1_->window);
	}
	if (_tmp2_) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = budgie_abomination_abomination_get_window_group (self, _data1_->window);
	group = _tmp3_;
	_tmp4_ = group;
	if (_tmp4_ == NULL) {
		BudgieAbominationAppGroup* _tmp5_;
		GHashTable* _tmp6_;
		BudgieAbominationAppGroup* _tmp7_;
		gchar* _tmp8_;
		BudgieAbominationAppGroup* _tmp9_;
		BudgieAbominationAppGroup* _tmp10_;
		_tmp5_ = budgie_abomination_app_group_new (_data1_->window);
		_g_object_unref0 (group);
		group = _tmp5_;
		_tmp6_ = self->priv->running_app_groups;
		_tmp7_ = group;
		_tmp8_ = budgie_abomination_app_group_get_name (_tmp7_);
		_tmp9_ = group;
		g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
		_tmp10_ = group;
		g_signal_connect_object (_tmp10_, "renamed-group", (GCallback) ____lambda13__budgie_abomination_app_group_renamed_group, self, 0);
	}
	_tmp11_ = self->priv->app_system;
	_tmp12_ = group;
	_tmp13_ = budgie_abomination_running_app_new (_tmp11_, _data1_->window, _tmp12_);
	_data1_->app = _tmp13_;
	_tmp15_ = _data1_->app;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		BudgieAbominationRunningApp* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = _data1_->app;
		_tmp17_ = budgie_abomination_running_app_get_group_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ == NULL;
		_g_free0 (_tmp18_);
	}
	if (_tmp14_) {
		_g_object_unref0 (group);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp19_ = self->priv->running_apps_id;
	_tmp20_ = _data1_->app;
	_tmp21_ = budgie_abomination_running_app_get_id (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = __ulong_dup0 (&_tmp22_);
	_tmp24_ = _data1_->app;
	g_hash_table_insert (_tmp19_, _tmp23_, _tmp24_);
	_tmp25_ = _data1_->app;
	_tmp26_ = budgie_abomination_running_app_get_group_name (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _data1_->app;
	g_signal_emit (self, budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_ADDED_APP_SIGNAL], 0, _tmp27_, _tmp28_);
	_g_free0 (_tmp27_);
	_tmp29_ = group;
	budgie_abomination_app_group_add_window (_tmp29_, _data1_->window);
	_tmp30_ = _data1_->app;
	_tmp31_ = budgie_abomination_running_app_get_window (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _data1_->app;
	_tmp34_ = budgie_abomination_running_app_get_window (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = wnck_window_get_state (_tmp35_);
	budgie_abomination_abomination_track_window_fullscreen_state (self, _tmp32_, &_tmp36_);
	_g_object_unref0 (_tmp35_);
	_g_object_unref0 (_tmp32_);
	_tmp37_ = _data1_->app;
	_tmp38_ = budgie_abomination_running_app_get_window (_tmp37_);
	_tmp39_ = _tmp38_;
	g_signal_connect_data (_tmp39_, "state-changed", (GCallback) ___lambda19__wnck_window_state_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (_tmp39_);
	_g_object_unref0 (group);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
 * remove_app will remove a running application based on the provided window
 */
static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
budgie_abomination_abomination_remove_app (BudgieAbominationAbomination* self,
                                           WnckWindow* window)
{
	BudgieAbominationAppGroup* group = NULL;
	BudgieAbominationAppGroup* _tmp0_;
	BudgieAbominationAppGroup* _tmp1_;
	gulong id = 0UL;
	BudgieAbominationRunningApp* app = NULL;
	GHashTable* _tmp14_;
	gconstpointer _tmp15_;
	BudgieAbominationRunningApp* _tmp16_;
	GHashTable* _tmp17_;
	BudgieAbominationRunningApp* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = budgie_abomination_abomination_get_window_group (self, window);
	group = _tmp0_;
	_tmp1_ = group;
	if (_tmp1_ != NULL) {
		BudgieAbominationAppGroup* _tmp2_;
		BudgieAbominationAppGroup* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
		gboolean _tmp6_;
		_tmp2_ = group;
		budgie_abomination_app_group_remove_window (_tmp2_, window);
		_tmp3_ = group;
		_tmp4_ = budgie_abomination_app_group_get_windows (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_g_list_is_empty (_tmp5_);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
		if (_tmp6_) {
			GHashTable* _tmp7_;
			BudgieAbominationAppGroup* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			BudgieAbominationAppGroup* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = self->priv->running_app_groups;
			_tmp8_ = group;
			_tmp9_ = budgie_abomination_app_group_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			g_hash_table_remove (_tmp7_, _tmp10_);
			_g_free0 (_tmp10_);
			_tmp11_ = group;
			_tmp12_ = budgie_abomination_app_group_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			g_debug ("abomination.vala:214: Removed group: %s", _tmp13_);
			_g_free0 (_tmp13_);
		}
	}
	id = wnck_window_get_xid (window);
	_tmp14_ = self->priv->running_apps_id;
	_tmp15_ = g_hash_table_lookup (_tmp14_, &id);
	_tmp16_ = _g_object_ref0 ((BudgieAbominationRunningApp*) _tmp15_);
	app = _tmp16_;
	_tmp17_ = self->priv->running_apps_id;
	g_hash_table_remove (_tmp17_, &id);
	budgie_abomination_abomination_track_window_fullscreen_state (self, window, NULL);
	_tmp18_ = app;
	if (_tmp18_ != NULL) {
		BudgieAbominationRunningApp* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		BudgieAbominationRunningApp* _tmp22_;
		_tmp19_ = app;
		_tmp20_ = budgie_abomination_running_app_get_group_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = app;
		g_signal_emit (self, budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_REMOVED_APP_SIGNAL], 0, _tmp21_, _tmp22_);
		_g_free0 (_tmp21_);
	} else {
		const gchar* _tmp23_;
		_tmp23_ = wnck_window_get_name (window);
		g_debug ("abomination.vala:227: Cannot remove %s", _tmp23_);
	}
	_g_object_unref0 (app);
	_g_object_unref0 (group);
}

/**
 * rename_group will rename any associated group based on the old group name
 * The old group name is determined by current windows associated with the group
 */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieAbominationAbomination* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->group);
		_g_free0 (_data3_->old_group_name);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BudgieAbominationAbomination* self;
		self = _data4_->_data3_->self;
		(_data4_->new_group_windows == NULL) ? NULL : (_data4_->new_group_windows = (g_list_free (_data4_->new_group_windows), NULL));
		(_data4_->existing_group_windows == NULL) ? NULL : (_data4_->existing_group_windows = (g_list_free (_data4_->existing_group_windows), NULL));
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda14_ (BudgieAbominationAbomination* self,
              WnckWindow* window)
{
	g_return_if_fail (window != NULL);
	budgie_abomination_abomination_remove_app (self, window);
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ ((BudgieAbominationAbomination*) self, (WnckWindow*) data);
}

static void
___lambda15_ (Block4Data* _data4_,
              WnckWindow* window)
{
	Block3Data* _data3_;
	BudgieAbominationAbomination* self;
	BudgieAbominationAppGroup* _tmp0_;
	BudgieAbominationAppGroup* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gboolean _tmp4_;
	gulong id = 0UL;
	BudgieAbominationRunningApp* app = NULL;
	GHashTable* _tmp6_;
	gconstpointer _tmp7_;
	BudgieAbominationRunningApp* _tmp8_;
	GHashTable* _tmp9_;
	BudgieAbominationRunningApp* _tmp10_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	g_return_if_fail (window != NULL);
	_tmp0_ = _data3_->group;
	budgie_abomination_app_group_remove_window (_tmp0_, window);
	_tmp1_ = _data3_->group;
	_tmp2_ = budgie_abomination_app_group_get_windows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_g_list_is_empty (_tmp3_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	if (_tmp4_) {
		GHashTable* _tmp5_;
		_tmp5_ = self->priv->running_app_groups;
		g_hash_table_remove (_tmp5_, _data3_->old_group_name);
		g_debug ("abomination.vala:262: Removed group: %s", _data3_->old_group_name);
	}
	id = wnck_window_get_xid (window);
	_tmp6_ = self->priv->running_apps_id;
	_tmp7_ = g_hash_table_lookup (_tmp6_, &id);
	_tmp8_ = _g_object_ref0 ((BudgieAbominationRunningApp*) _tmp7_);
	app = _tmp8_;
	_tmp9_ = self->priv->running_apps_id;
	g_hash_table_remove (_tmp9_, &id);
	budgie_abomination_abomination_track_window_fullscreen_state (self, window, NULL);
	_tmp10_ = app;
	if (_tmp10_ != NULL) {
		BudgieAbominationRunningApp* _tmp11_;
		_tmp11_ = app;
		g_signal_emit (self, budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_REMOVED_APP_SIGNAL], 0, _data3_->old_group_name, _tmp11_);
	}
	_g_object_unref0 (app);
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda15_ (self, (WnckWindow*) data);
}

static void
__lambda17_ (BudgieAbominationAbomination* self,
             WnckWindow* window)
{
	g_return_if_fail (window != NULL);
	budgie_abomination_abomination_add_app (self, window);
}

static void
___lambda17__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda17_ ((BudgieAbominationAbomination*) self, (WnckWindow*) data);
}

static void
__lambda18_ (BudgieAbominationAbomination* self,
             WnckWindow* window)
{
	g_return_if_fail (window != NULL);
	budgie_abomination_abomination_add_app (self, window);
}

static void
___lambda18__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda18_ ((BudgieAbominationAbomination*) self, (WnckWindow*) data);
}

static gboolean
___lambda16_ (Block4Data* _data4_)
{
	Block3Data* _data3_;
	BudgieAbominationAbomination* self;
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	_tmp0_ = _data4_->existing_group_windows;
	g_list_foreach (_tmp0_, ___lambda17__gfunc, self);
	_tmp1_ = _data4_->new_group_windows;
	g_list_foreach (_tmp1_, ___lambda18__gfunc, self);
	result = FALSE;
	return result;
}

static gboolean
____lambda16__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda16_ (self);
	return result;
}

static void
budgie_abomination_abomination_rename_group (BudgieAbominationAbomination* self,
                                             const gchar* old_group_name,
                                             const gchar* new_group_name)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	BudgieAbominationAppGroup* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _tmp17_;
	BudgieAbominationAppGroup* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_group_name != NULL);
	g_return_if_fail (new_group_name != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (old_group_name);
	_g_free0 (_data3_->old_group_name);
	_data3_->old_group_name = _tmp0_;
	_tmp1_ = self->priv->running_app_groups;
	_tmp2_ = g_hash_table_lookup (_tmp1_, _data3_->old_group_name);
	_tmp3_ = _g_object_ref0 ((BudgieAbominationAppGroup*) _tmp2_);
	_data3_->group = _tmp3_;
	_tmp4_ = self->priv->running_app_groups;
	if (!g_hash_table_contains (_tmp4_, new_group_name)) {
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		BudgieAbominationAppGroup* _tmp7_;
		_tmp5_ = self->priv->running_app_groups;
		_tmp6_ = g_strdup (new_group_name);
		_tmp7_ = _data3_->group;
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
	} else {
		Block4Data* _data4_;
		BudgieAbominationAppGroup* existing_group = NULL;
		GHashTable* _tmp8_;
		gconstpointer _tmp9_;
		BudgieAbominationAppGroup* _tmp10_;
		BudgieAbominationAppGroup* _tmp11_;
		GList* _tmp12_;
		BudgieAbominationAppGroup* _tmp13_;
		GList* _tmp14_;
		GList* _tmp15_;
		GList* _tmp16_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->_data3_ = block3_data_ref (_data3_);
		g_debug ("abomination.vala:247: Strange app mode triggered for %s", new_group_name);
		_tmp8_ = self->priv->running_app_groups;
		_tmp9_ = g_hash_table_lookup (_tmp8_, new_group_name);
		_tmp10_ = _g_object_ref0 ((BudgieAbominationAppGroup*) _tmp9_);
		existing_group = _tmp10_;
		_tmp11_ = existing_group;
		_tmp12_ = budgie_abomination_app_group_get_windows (_tmp11_);
		_data4_->existing_group_windows = _tmp12_;
		_tmp13_ = _data3_->group;
		_tmp14_ = budgie_abomination_app_group_get_windows (_tmp13_);
		_data4_->new_group_windows = _tmp14_;
		_tmp15_ = _data4_->existing_group_windows;
		g_list_foreach (_tmp15_, ____lambda14__gfunc, self);
		_tmp16_ = _data4_->new_group_windows;
		g_list_foreach (_tmp16_, ____lambda15__gfunc, _data4_);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda16__gsource_func, block4_data_ref (_data4_), block4_data_unref);
		_g_object_unref0 (existing_group);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
	_tmp17_ = self->priv->running_app_groups;
	g_hash_table_remove (_tmp17_, _data3_->old_group_name);
	_tmp18_ = _data3_->group;
	g_signal_emit (self, budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_UPDATED_GROUP_SIGNAL], 0, _tmp18_);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

/**
 * Adds and removes windows from fullscreen_windows depending on their state.
 * Additionally, toggles night light and notification pausing as necessary if either are enabled.
 */
static void
budgie_abomination_abomination_track_window_fullscreen_state (BudgieAbominationAbomination* self,
                                                              WnckWindow* window,
                                                              WnckWindowState* state)
{
	gulong window_xid = 0UL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	window_xid = wnck_window_get_xid (window);
	_tmp1_ = self->priv->fullscreen_windows;
	if (!g_hash_table_contains (_tmp1_, &window_xid)) {
		_tmp0_ = budgie_abomination_abomination_state_is_fullscreen (self, state);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GHashTable* _tmp2_;
		gulong* _tmp3_;
		WnckWindow* _tmp4_;
		_tmp2_ = self->priv->fullscreen_windows;
		_tmp3_ = __ulong_dup0 (&window_xid);
		_tmp4_ = _g_object_ref0 (window);
		g_hash_table_insert (_tmp2_, _tmp3_, _tmp4_);
	} else {
		GHashTable* _tmp5_;
		_tmp5_ = self->priv->fullscreen_windows;
		if (g_hash_table_contains (_tmp5_, &window_xid)) {
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->fullscreen_windows;
			g_hash_table_steal (_tmp6_, &window_xid);
		}
	}
	budgie_abomination_abomination_toggle_night_light (self);
	budgie_abomination_abomination_set_notifications_paused (self);
}

static gboolean
budgie_abomination_abomination_state_is_fullscreen (BudgieAbominationAbomination* self,
                                                    WnckWindowState* state)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (state != NULL) {
		gboolean _tmp1_ = FALSE;
		if (((*state) & WNCK_WINDOW_STATE_FULLSCREEN) == WNCK_WINDOW_STATE_FULLSCREEN) {
			gboolean _tmp2_ = FALSE;
			if (((*state) & WNCK_WINDOW_STATE_MINIMIZED) == WNCK_WINDOW_STATE_MINIMIZED) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = ((*state) & WNCK_WINDOW_STATE_HIDDEN) == WNCK_WINDOW_STATE_HIDDEN;
			}
			_tmp1_ = !_tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * toggle_night_light will toggle the state of the night light depending on requested state
 * If we're disabling, we'll check if there is any items in fullscreen_windows first
 */
static void
budgie_abomination_abomination_toggle_night_light (BudgieAbominationAbomination* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->should_disable_night_light_on_fullscreen) {
		GSettings* _tmp0_;
		GHashTable* _tmp1_;
		GSettings* _tmp4_;
		_tmp0_ = self->priv->color_settings;
		g_signal_handler_block (_tmp0_, self->priv->color_id);
		_tmp1_ = self->priv->fullscreen_windows;
		if (g_hash_table_size (_tmp1_) >= ((guint) 1)) {
			GSettings* _tmp2_;
			_tmp2_ = self->priv->color_settings;
			g_settings_set_boolean (_tmp2_, "night-light-enabled", FALSE);
		} else {
			GSettings* _tmp3_;
			_tmp3_ = self->priv->color_settings;
			g_settings_set_boolean (_tmp3_, "night-light-enabled", self->priv->original_night_light_setting);
		}
		_tmp4_ = self->priv->color_settings;
		g_signal_handler_unblock (_tmp4_, self->priv->color_id);
	}
}

static void
budgie_abomination_abomination_set_notifications_paused (BudgieAbominationAbomination* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->should_pause_notifications_on_fullscreen) {
		NotificationsRemote* _tmp0_;
		GHashTable* _tmp1_;
		_tmp0_ = self->priv->notifications_proxy;
		_tmp1_ = self->priv->fullscreen_windows;
		notifications_remote_set_notifications_paused (_tmp0_, g_hash_table_size (_tmp1_) >= ((guint) 1));
	}
}

/**
 * update_should_disable_night_light will update our value determining if we should disable night light on fullscreen
 */
static void
budgie_abomination_abomination_update_should_disable_night_light (BudgieAbominationAbomination* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->wm_settings;
		self->priv->should_disable_night_light_on_fullscreen = g_settings_get_boolean (_tmp1_, "disable-night-light-on-fullscreen");
	}
}

/**
 * update_should_pause_notifications will update our value determining if we should pause notifications on fullscreen
 */
static void
budgie_abomination_abomination_update_should_pause_notifications (BudgieAbominationAbomination* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->wm_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->wm_settings;
		self->priv->should_pause_notifications_on_fullscreen = g_settings_get_boolean (_tmp1_, "pause-notifications-on-fullscreen");
	}
}

/**
 * update_night_light_value will update our copy / original night light enabled value
 */
static void
budgie_abomination_abomination_update_night_light_value (BudgieAbominationAbomination* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->color_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->color_settings;
		self->priv->original_night_light_setting = g_settings_get_boolean (_tmp1_, "night-light-enabled");
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
budgie_abomination_abomination_class_init (BudgieAbominationAbominationClass * klass,
                                           gpointer klass_data)
{
	budgie_abomination_abomination_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAbominationAbomination_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_abomination_abomination_finalize;
	/**
	 * Signals
	 */
	budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_ADDED_APP_SIGNAL] = g_signal_new ("added-app", BUDGIE_ABOMINATION_TYPE_ABOMINATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, BUDGIE_ABOMINATION_TYPE_RUNNING_APP);
	budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_REMOVED_APP_SIGNAL] = g_signal_new ("removed-app", BUDGIE_ABOMINATION_TYPE_ABOMINATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, BUDGIE_ABOMINATION_TYPE_RUNNING_APP);
	budgie_abomination_abomination_signals[BUDGIE_ABOMINATION_ABOMINATION_UPDATED_GROUP_SIGNAL] = g_signal_new ("updated-group", BUDGIE_ABOMINATION_TYPE_ABOMINATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BUDGIE_ABOMINATION_TYPE_APP_GROUP);
}

static void
budgie_abomination_abomination_instance_init (BudgieAbominationAbomination * self,
                                              gpointer klass)
{
	self->priv = budgie_abomination_abomination_get_instance_private (self);
	self->priv->app_system = NULL;
	self->priv->color_settings = NULL;
	self->priv->wm_settings = NULL;
	self->priv->original_night_light_setting = FALSE;
	self->priv->should_disable_night_light_on_fullscreen = FALSE;
	self->priv->should_pause_notifications_on_fullscreen = FALSE;
	self->priv->screen = NULL;
	self->priv->notifications_proxy = NULL;
	self->priv->color_id = (gulong) 0;
}

static void
budgie_abomination_abomination_finalize (GObject * obj)
{
	BudgieAbominationAbomination * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_ABOMINATION_TYPE_ABOMINATION, BudgieAbominationAbomination);
	_g_object_unref0 (self->priv->app_system);
	_g_object_unref0 (self->priv->color_settings);
	_g_object_unref0 (self->priv->wm_settings);
	_g_hash_table_unref0 (self->priv->fullscreen_windows);
	_g_hash_table_unref0 (self->priv->running_apps_id);
	_g_hash_table_unref0 (self->priv->running_app_groups);
	_g_object_unref0 (self->priv->screen);
	_g_object_unref0 (self->priv->notifications_proxy);
	G_OBJECT_CLASS (budgie_abomination_abomination_parent_class)->finalize (obj);
}

/**
 * Abomination is our application state tracking manager
 */
static GType
budgie_abomination_abomination_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAbominationAbominationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_abomination_abomination_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAbominationAbomination), 0, (GInstanceInitFunc) budgie_abomination_abomination_instance_init, NULL };
	GType budgie_abomination_abomination_type_id;
	budgie_abomination_abomination_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieAbominationAbomination", &g_define_type_info, 0);
	BudgieAbominationAbomination_private_offset = g_type_add_instance_private (budgie_abomination_abomination_type_id, sizeof (BudgieAbominationAbominationPrivate));
	return budgie_abomination_abomination_type_id;
}

GType
budgie_abomination_abomination_get_type (void)
{
	static volatile gsize budgie_abomination_abomination_type_id__once = 0;
	if (g_once_init_enter (&budgie_abomination_abomination_type_id__once)) {
		GType budgie_abomination_abomination_type_id;
		budgie_abomination_abomination_type_id = budgie_abomination_abomination_get_type_once ();
		g_once_init_leave (&budgie_abomination_abomination_type_id__once, budgie_abomination_abomination_type_id);
	}
	return budgie_abomination_abomination_type_id__once;
}

