/* VersionList.c generated by valac 0.56.16, the Vala compiler
 * generated from VersionList.vala, do not modify */

/*
Copyright (C) 2012, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#define BIRD_FONT_VERSION_LIST_item_height 25
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_VERSION_LIST_0_PROPERTY,
	BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY,
	BIRD_FONT_VERSION_LIST_NUM_PROPERTIES
};
static GParamSpec* bird_font_version_list_properties[BIRD_FONT_VERSION_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
enum  {
	BIRD_FONT_VERSION_LIST_SELECTED_SIGNAL,
	BIRD_FONT_VERSION_LIST_SIGNAL_DELETE_ITEM_SIGNAL,
	BIRD_FONT_VERSION_LIST_ADD_GLYPH_ITEM_SIGNAL,
	BIRD_FONT_VERSION_LIST_NUM_SIGNALS
};
static guint bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_NUM_SIGNALS] = {0};

struct _BirdFontVersionListPrivate {
	BirdFontGlyphCollection* glyph_collection;
	gdouble x;
	gdouble y;
	gdouble width;
	gdouble menu_x;
	gboolean _menu_visible;
	GeeArrayList* actions;
	MenuDirection direction;
};

static gint BirdFontVersionList_private_offset;
static gpointer bird_font_version_list_parent_class = NULL;

static void __lambda76_ (BirdFontVersionList* self,
                  BirdFontMenuAction* _self_);
static void ___lambda76__bird_font_menu_action_action (BirdFontMenuAction* _sender,
                                                BirdFontMenuAction* a,
                                                gpointer self);
static void __lambda333_ (BirdFontVersionList* self,
                   gint index);
static void bird_font_version_list_delete_item (BirdFontVersionList* self,
                                         gint index);
static void ___lambda333__bird_font_version_list_signal_delete_item (BirdFontVersionList* _sender,
                                                              gint item_index,
                                                              gpointer self);
static gint bird_font_version_list_get_current_version_index (BirdFontVersionList* self);
static void bird_font_version_list_set_selected_item (BirdFontVersionList* self,
                                               BirdFontMenuAction* ma,
                                               gboolean update_loaded_glyph);
static void bird_font_version_list_select_last_glyph (BirdFontVersionList* self);
static void bird_font_version_list_update_selection (BirdFontVersionList* self,
                                              gboolean update_loaded_glyph);
static void bird_font_version_list_reload_all_open_glyphs (BirdFontVersionList* self);
static void __lambda332_ (BirdFontVersionList* self,
                   BirdFontMenuAction* _self_);
static void ___lambda332__bird_font_menu_action_action (BirdFontMenuAction* _sender,
                                                 BirdFontMenuAction* a,
                                                 gpointer self);
static gboolean bird_font_version_list_has_version (BirdFontVersionList* self,
                                             gint id);
static BirdFontMenuAction* bird_font_version_list_get_menu_action_at (BirdFontVersionList* self,
                                                               gdouble px,
                                                               gdouble py);
static void bird_font_version_list_finalize (GObject * obj);
static GType bird_font_version_list_get_type_once (void);
static void _vala_bird_font_version_list_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_bird_font_version_list_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
menu_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{MENU_DIRECTION_DROP_DOWN, "MENU_DIRECTION_DROP_DOWN", "drop-down"}, {MENU_DIRECTION_POP_UP, "MENU_DIRECTION_POP_UP", "pop-up"}, {0, NULL, NULL}};
	GType menu_direction_type_id;
	menu_direction_type_id = g_enum_register_static ("MenuDirection", values);
	return menu_direction_type_id;
}

GType
menu_direction_get_type (void)
{
	static volatile gsize menu_direction_type_id__once = 0;
	if (g_once_init_enter (&menu_direction_type_id__once)) {
		GType menu_direction_type_id;
		menu_direction_type_id = menu_direction_get_type_once ();
		g_once_init_leave (&menu_direction_type_id__once, menu_direction_type_id);
	}
	return menu_direction_type_id__once;
}

static inline gpointer
bird_font_version_list_get_instance_private (BirdFontVersionList* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontVersionList_private_offset);
}

static void
__lambda76_ (BirdFontVersionList* self,
             BirdFontMenuAction* _self_)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontFont* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_;
	BirdFontGlyph* _tmp10_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = self->glyphs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ > 0);
	_tmp3_ = bird_font_bird_font_get_current_font ();
	_tmp4_ = _tmp3_;
	bird_font_font_touch (_tmp4_);
	_g_object_unref0 (_tmp4_);
	bird_font_version_list_add_new_version (self);
	_tmp5_ = self->glyphs;
	_tmp6_ = self->glyphs;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp8_ - 1);
	_tmp10_ = (BirdFontGlyph*) _tmp9_;
	self->current_version_id = _tmp10_->version_id;
	_g_object_unref0 (_tmp10_);
}

static void
___lambda76__bird_font_menu_action_action (BirdFontMenuAction* _sender,
                                           BirdFontMenuAction* a,
                                           gpointer self)
{
	__lambda76_ ((BirdFontVersionList*) self, a);
}

static void
__lambda333_ (BirdFontVersionList* self,
              gint index)
{
	bird_font_version_list_delete_item (self, index);
}

static void
___lambda333__bird_font_version_list_signal_delete_item (BirdFontVersionList* _sender,
                                                         gint item_index,
                                                         gpointer self)
{
	__lambda333_ ((BirdFontVersionList*) self, item_index);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontVersionList*
bird_font_version_list_construct (GType object_type,
                                  BirdFontGlyphCollection* gc)
{
	BirdFontVersionList * self = NULL;
	BirdFontMenuAction* ma = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontMenuAction* _tmp2_;
	BirdFontMenuAction* _tmp3_;
	BirdFontMenuAction* _tmp4_;
	BirdFontMenuAction* _tmp5_;
	BirdFontGlyphCollection* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	g_return_val_if_fail (gc != NULL, NULL);
	self = (BirdFontVersionList*) g_object_new (object_type, NULL);
	bird_font_version_list_set_menu_visible (self, FALSE);
	_tmp0_ = bird_font_t_ ("New version");
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_version_list_add_item (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	ma = _tmp3_;
	_tmp4_ = ma;
	_tmp4_->has_delete_button = FALSE;
	_tmp5_ = ma;
	g_signal_connect_object (_tmp5_, "action", (GCallback) ___lambda76__bird_font_menu_action_action, self, 0);
	g_signal_connect_object (self, "signal-delete-item", (GCallback) ___lambda333__bird_font_version_list_signal_delete_item, self, 0);
	_tmp6_ = _g_object_ref0 (gc);
	_g_object_unref0 (self->priv->glyph_collection);
	self->priv->glyph_collection = _tmp6_;
	_tmp7_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyphs);
	self->glyphs = _tmp7_;
	bird_font_version_list_set_direction (self, MENU_DIRECTION_POP_UP);
	_tmp8_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->glyphs);
	self->glyphs = _tmp8_;
	if (bird_font_glyph_collection_has_masters (gc)) {
		{
			GeeArrayList* _g_list = NULL;
			BirdFontGlyphMaster* _tmp9_;
			BirdFontGlyphMaster* _tmp10_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			gint _g_size = 0;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _g_index = 0;
			_tmp9_ = bird_font_glyph_collection_get_current_master (gc);
			_tmp10_ = _tmp9_;
			_tmp11_ = _tmp10_->glyphs;
			_tmp12_ = _tmp11_;
			_g_object_unref0 (_tmp10_);
			_g_list = _tmp12_;
			_tmp13_ = _g_list;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_g_size = _tmp15_;
			_g_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				BirdFontGlyph* g = NULL;
				GeeArrayList* _tmp18_;
				gpointer _tmp19_;
				BirdFontGlyph* _tmp20_;
				_g_index = _g_index + 1;
				_tmp16_ = _g_index;
				_tmp17_ = _g_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _g_list;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _g_index);
				g = (BirdFontGlyph*) _tmp19_;
				_tmp20_ = g;
				bird_font_version_list_add_glyph (self, _tmp20_, FALSE);
				_g_object_unref0 (g);
			}
		}
	}
	if (bird_font_glyph_collection_length (gc) > ((guint) 0)) {
		BirdFontGlyph* _tmp21_;
		BirdFontGlyph* _tmp22_;
		_tmp21_ = bird_font_glyph_collection_get_current (gc);
		_tmp22_ = _tmp21_;
		bird_font_version_list_set_selected_version (self, _tmp22_->version_id, FALSE);
		_g_object_unref0 (_tmp22_);
	}
	_g_object_unref0 (ma);
	return self;
}

BirdFontVersionList*
bird_font_version_list_new (BirdFontGlyphCollection* gc)
{
	return bird_font_version_list_construct (BIRD_FONT_TYPE_VERSION_LIST, gc);
}

static void
bird_font_version_list_delete_item (BirdFontVersionList* self,
                                    gint index)
{
	gint current_version = 0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOverview* over_view = NULL;
	BirdFontOverview* _tmp1_;
	BirdFontFont* _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	BirdFontGlyph* g = NULL;
	BirdFontGlyphCollection* _tmp22_;
	BirdFontGlyph* _tmp23_;
	BirdFontGlyphMaster* m = NULL;
	BirdFontGlyphCollection* _tmp24_;
	BirdFontGlyphMaster* _tmp25_;
	BirdFontFont* _tmp26_;
	BirdFontGlyph* _tmp27_;
	BirdFontGlyphMaster* _tmp28_;
	BirdFontOverview* _tmp29_;
	BirdFontGlyphCollection* _tmp30_;
	BirdFontGlyphCollection* _tmp31_;
	BirdFontGlyphCollection* _tmp32_;
	GeeArrayList* _tmp33_;
	gpointer _tmp34_;
	BirdFontGlyph* _tmp35_;
	BirdFontGlyphCollection* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_main_window_get_overview ();
	over_view = _tmp1_;
	_tmp2_ = font;
	bird_font_font_touch (_tmp2_);
	_tmp3_ = index;
	index = _tmp3_ - 1;
	_tmp4_ = self->glyphs;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 1) {
		BirdFontOverview* _tmp7_;
		BirdFontGlyphCollection* _tmp8_;
		BirdFontGlyphCollection* _tmp9_;
		BirdFontGlyphCollection* _tmp10_;
		BirdFontFont* _tmp11_;
		BirdFontGlyphCollection* _tmp12_;
		gchar* name = NULL;
		BirdFontGlyphCollection* _tmp13_;
		gchar* _tmp14_;
		BirdFontTabBar* _tmp15_;
		BirdFontTabBar* _tmp16_;
		const gchar* _tmp17_;
		_tmp7_ = over_view;
		_tmp8_ = self->priv->glyph_collection;
		_tmp9_ = bird_font_glyph_collection_copy (_tmp8_);
		_tmp10_ = _tmp9_;
		bird_font_overview_store_undo_state (_tmp7_, _tmp10_);
		_g_object_unref0 (_tmp10_);
		_tmp11_ = font;
		_tmp12_ = self->priv->glyph_collection;
		bird_font_font_delete_glyph (_tmp11_, _tmp12_);
		_tmp13_ = self->priv->glyph_collection;
		_tmp14_ = bird_font_glyph_collection_get_name (_tmp13_);
		name = _tmp14_;
		_tmp15_ = bird_font_main_window_get_tab_bar ();
		_tmp16_ = _tmp15_;
		_tmp17_ = name;
		bird_font_tab_bar_close_background_tab_by_name (_tmp16_, _tmp17_);
		_g_object_unref0 (_tmp16_);
		_g_free0 (name);
		_g_object_unref0 (over_view);
		_g_object_unref0 (font);
		return;
	}
	_tmp18_ = self->glyphs;
	_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = index;
	g_return_if_fail ((0 <= _tmp21_) && (_tmp21_ < _tmp20_));
	_tmp22_ = self->priv->glyph_collection;
	_tmp23_ = bird_font_glyph_collection_get_current (_tmp22_);
	g = _tmp23_;
	_tmp24_ = self->priv->glyph_collection;
	_tmp25_ = bird_font_glyph_collection_get_current_master (_tmp24_);
	m = _tmp25_;
	_tmp26_ = font;
	_tmp27_ = g;
	_tmp28_ = m;
	bird_font_font_add_deleted_glyph (_tmp26_, _tmp27_, _tmp28_);
	_tmp29_ = over_view;
	_tmp30_ = self->priv->glyph_collection;
	_tmp31_ = bird_font_glyph_collection_copy (_tmp30_);
	_tmp32_ = _tmp31_;
	bird_font_overview_store_undo_state (_tmp29_, _tmp32_);
	_g_object_unref0 (_tmp32_);
	current_version = bird_font_version_list_get_current_version_index (self);
	_tmp33_ = self->glyphs;
	_tmp34_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp33_, index);
	_tmp35_ = (BirdFontGlyph*) _tmp34_;
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->glyph_collection;
	bird_font_glyph_collection_remove (_tmp36_, index);
	bird_font_version_list_recreate_index (self);
	if (index == current_version) {
		BirdFontMenuAction* _tmp37_;
		BirdFontMenuAction* _tmp38_;
		_tmp37_ = bird_font_version_list_get_action_no2 (self);
		_tmp38_ = _tmp37_;
		bird_font_version_list_set_selected_item (self, _tmp38_, TRUE);
		_g_object_unref0 (_tmp38_);
	} else {
		if (index < current_version) {
			GeeArrayList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			GeeArrayList* _tmp43_;
			gpointer _tmp44_;
			BirdFontGlyph* _tmp45_;
			gint i = 0;
			BirdFontMenuAction* _tmp46_;
			BirdFontMenuAction* _tmp47_;
			_tmp39_ = self->glyphs;
			_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = current_version - 1;
			g_return_if_fail ((0 <= _tmp42_) && (_tmp42_ < _tmp41_));
			_tmp43_ = self->glyphs;
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, current_version - 1);
			_tmp45_ = (BirdFontGlyph*) _tmp44_;
			self->current_version_id = _tmp45_->version_id;
			_g_object_unref0 (_tmp45_);
			i = bird_font_version_list_get_current_version_index (self);
			_tmp46_ = bird_font_version_list_get_action_index (self, i);
			_tmp47_ = _tmp46_;
			bird_font_version_list_set_selected_item (self, _tmp47_, TRUE);
			_g_object_unref0 (_tmp47_);
		}
	}
	bird_font_version_list_select_last_glyph (self);
	_g_object_unref0 (m);
	_g_object_unref0 (g);
	_g_object_unref0 (over_view);
	_g_object_unref0 (font);
}

static gint
bird_font_version_list_get_current_version_index (BirdFontVersionList* self)
{
	gint i = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	i = 0;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp0_;
		gint _g_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _g_index = 0;
		_tmp0_ = self->glyphs;
		_g_list = _tmp0_;
		_tmp1_ = _g_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_size = _tmp3_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyph* _tmp8_;
			gint _tmp9_;
			_g_index = _g_index + 1;
			_tmp4_ = _g_index;
			_tmp5_ = _g_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _g_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
			g = (BirdFontGlyph*) _tmp7_;
			_tmp8_ = g;
			if (_tmp8_->version_id == self->current_version_id) {
				result = i;
				_g_object_unref0 (g);
				return result;
			}
			_tmp9_ = i;
			i = _tmp9_ + 1;
			_g_object_unref0 (g);
		}
	}
	g_warning ("VersionList.vala:138: No index for menu item.");
	result = 0;
	return result;
}

void
bird_font_version_list_set_selected_version (BirdFontVersionList* self,
                                             gint version_id,
                                             gboolean update_loaded_glyph)
{
	g_return_if_fail (self != NULL);
	self->current_version_id = version_id;
	bird_font_version_list_update_selection (self, update_loaded_glyph);
}

BirdFontGlyph*
bird_font_version_list_get_current (BirdFontVersionList* self)
{
	BirdFontGlyph* gl = NULL;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp24_ = FALSE;
	GeeArrayList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	BirdFontGlyph* _tmp29_;
	BirdFontGlyph* _tmp30_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	gl = NULL;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp0_;
		gint _g_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _g_index = 0;
		_tmp0_ = self->glyphs;
		_g_list = _tmp0_;
		_tmp1_ = _g_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_size = _tmp3_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyph* _tmp8_;
			_g_index = _g_index + 1;
			_tmp4_ = _g_index;
			_tmp5_ = _g_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _g_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
			g = (BirdFontGlyph*) _tmp7_;
			_tmp8_ = g;
			if (_tmp8_->version_id == self->current_version_id) {
				result = g;
				_g_object_unref0 (gl);
				return result;
			}
			_g_object_unref0 (g);
		}
	}
	_tmp9_ = self->glyphs;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (G_UNLIKELY (_tmp11_ > 0)) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_;
		BirdFontGlyph* _tmp21_;
		BirdFontGlyph* _tmp22_;
		BirdFontGlyph* _tmp23_;
		_tmp12_ = g_strdup_printf ("%i", self->current_version_id);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Can not find current glyph for id ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_warning ("VersionList.vala:157: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp16_ = self->glyphs;
		_tmp17_ = self->glyphs;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp19_ - 1);
		_g_object_unref0 (gl);
		gl = (BirdFontGlyph*) _tmp20_;
		_tmp21_ = gl;
		bird_font_version_list_set_selected_version (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph)->version_id, FALSE);
		_tmp22_ = gl;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		result = _tmp23_;
		_g_object_unref0 (gl);
		return result;
	}
	_tmp25_ = self->glyphs;
	_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == 0) {
		_tmp24_ = self->current_version_id == -1;
	} else {
		_tmp24_ = FALSE;
	}
	if (G_UNLIKELY (_tmp24_)) {
		BirdFontGlyph* _tmp28_;
		g_warning ("VersionList.vala:164: %s", "No glyphs added to collection");
		_tmp28_ = bird_font_glyph_new_no_lines ("", (gunichar) '\0');
		_g_object_unref0 (gl);
		gl = _tmp28_;
	}
	_tmp29_ = gl;
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	result = _tmp30_;
	_g_object_unref0 (gl);
	return result;
}

void
bird_font_version_list_add_new_version (BirdFontVersionList* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* new_version = NULL;
	BirdFontGlyph* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_version_list_get_current (self);
	g = _tmp0_;
	_tmp1_ = bird_font_glyph_copy (g);
	new_version = _tmp1_;
	new_version->version_id = bird_font_version_list_get_last_id (self) + 1;
	g_signal_emit (self, bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_ADD_GLYPH_ITEM_SIGNAL], 0, new_version);
	bird_font_version_list_add_glyph (self, new_version, TRUE);
	_g_object_unref0 (new_version);
	_g_object_unref0 (g);
}

gint
bird_font_version_list_get_last_id (BirdFontVersionList* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontGlyph* _tmp8_;
	gint _tmp9_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->glyphs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ > 0, 1);
	_tmp3_ = self->glyphs;
	_tmp4_ = self->glyphs;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	_tmp8_ = (BirdFontGlyph*) _tmp7_;
	_tmp9_ = _tmp8_->version_id;
	_g_object_unref0 (_tmp8_);
	result = _tmp9_;
	return result;
}

static void
bird_font_version_list_set_selected_item (BirdFontVersionList* self,
                                          BirdFontMenuAction* ma,
                                          gboolean update_loaded_glyph)
{
	gint i = 0;
	BirdFontGlyph* current_glyph = NULL;
	BirdFontGlyph* g = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyphCollection* _tmp7_;
	BirdFontGlyph* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ma != NULL);
	i = ma->index;
	_tmp0_ = self->glyphs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = i;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->glyphs;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, i);
	_g_object_unref0 (g);
	g = (BirdFontGlyph*) _tmp5_;
	_tmp6_ = g;
	self->current_version_id = _tmp6_->version_id;
	bird_font_version_list_deselect_all (self);
	bird_font_menu_action_set_selected (ma, TRUE);
	_tmp7_ = self->priv->glyph_collection;
	_tmp8_ = g;
	bird_font_glyph_collection_set_selected (_tmp7_, _tmp8_);
	bird_font_version_list_reload_all_open_glyphs (self);
	if (update_loaded_glyph) {
		BirdFontGlyphCollection* _tmp10_;
		_tmp10_ = bird_font_bird_font_current_glyph_collection;
		_tmp9_ = !bird_font_is_null (_tmp10_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		BirdFontGlyph* _tmp11_;
		BirdFontGlyph* _tmp12_;
		BirdFontGlyph* _tmp13_;
		BirdFontWidgetAllocation* _tmp14_;
		BirdFontGlyph* _tmp15_;
		BirdFontGlyph* _tmp16_;
		_tmp11_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (current_glyph);
		current_glyph = _tmp11_;
		_tmp12_ = g;
		_tmp13_ = current_glyph;
		_tmp14_ = _tmp13_->allocation;
		bird_font_glyph_set_allocation (_tmp12_, _tmp14_);
		_tmp15_ = g;
		bird_font_glyph_close_path (_tmp15_);
		_tmp16_ = g;
		bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) _tmp16_);
	}
	_g_object_unref0 (g);
	_g_object_unref0 (current_glyph);
}

/** Reload a glyph when a new version is selected. Updates the path
 * in glyph view, not from disk but from the glyph table.
 */
static void
bird_font_version_list_reload_all_open_glyphs (BirdFontVersionList* self)
{
	BirdFontTabBar* b = NULL;
	BirdFontTab* tab = NULL;
	BirdFontTab* tn = NULL;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* updated_glyph = NULL;
	BirdFontGlyph* ug = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	GString* uni = NULL;
	GString* _tmp1_;
	BirdFontTabBar* _tmp2_;
	BirdFontTabBar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = g_string_new ("");
	uni = _tmp1_;
	_tmp2_ = bird_font_main_window_get_tab_bar ();
	if (bird_font_is_null (_tmp2_)) {
		_g_string_free0 (uni);
		_g_object_unref0 (font);
		_g_object_unref0 (ug);
		_g_object_unref0 (updated_glyph);
		_g_object_unref0 (glyph);
		_g_object_unref0 (tn);
		_g_object_unref0 (tab);
		_g_object_unref0 (b);
		return;
	}
	_tmp3_ = bird_font_main_window_get_tab_bar ();
	_g_object_unref0 (b);
	b = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				BirdFontTabBar* _tmp6_;
				BirdFontTabBar* _tmp7_;
				BirdFontTab* _tmp8_;
				BirdFontTab* _tmp9_;
				BirdFontTab* _tmp10_;
				BirdFontTab* _tmp11_;
				BirdFontTab* _tmp12_;
				BirdFontFontDisplay* _tmp13_;
				BirdFontFontDisplay* _tmp14_;
				gboolean _tmp15_;
				BirdFontGlyphTab* glyph_tab = NULL;
				BirdFontTab* _tmp16_;
				BirdFontFontDisplay* _tmp17_;
				BirdFontGlyphTab* _tmp18_;
				BirdFontGlyphCollection* _tmp19_;
				BirdFontGlyph* _tmp20_;
				GString* _tmp21_;
				GString* _tmp22_;
				BirdFontGlyph* _tmp23_;
				BirdFontFont* _tmp24_;
				GString* _tmp25_;
				const gchar* _tmp26_;
				BirdFontGlyph* _tmp27_;
				BirdFontGlyph* _tmp28_;
				BirdFontGlyph* _tmp29_;
				BirdFontGlyph* _tmp30_;
				BirdFontTab* _tmp31_;
				BirdFontGlyphTab* _tmp32_;
				BirdFontGlyph* _tmp33_;
				BirdFontGlyph* _tmp34_;
				BirdFontGlyph* _tmp35_;
				BirdFontGlyph* _tmp36_;
				BirdFontGlyph* _tmp37_;
				BirdFontGlyph* _tmp38_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = b;
				if (!(((guint) i) < bird_font_tab_bar_get_length (_tmp6_))) {
					break;
				}
				_tmp7_ = b;
				_tmp8_ = bird_font_tab_bar_get_nth (_tmp7_, i);
				_g_object_unref0 (tn);
				tn = _tmp8_;
				_tmp9_ = tn;
				if (_tmp9_ == NULL) {
					g_warning ("VersionList.vala:235: tab is null");
					_g_string_free0 (uni);
					_g_object_unref0 (font);
					_g_object_unref0 (ug);
					_g_object_unref0 (updated_glyph);
					_g_object_unref0 (glyph);
					_g_object_unref0 (tn);
					_g_object_unref0 (tab);
					_g_object_unref0 (b);
					return;
				}
				_tmp10_ = tn;
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_TAB, BirdFontTab));
				_g_object_unref0 (tab);
				tab = _tmp11_;
				_tmp12_ = tab;
				_tmp13_ = bird_font_tab_get_display (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = !BIRD_FONT_IS_GLYPH_TAB (_tmp14_);
				_g_object_unref0 (_tmp14_);
				if (_tmp15_) {
					continue;
				}
				_tmp16_ = tab;
				_tmp17_ = bird_font_tab_get_display (_tmp16_);
				glyph_tab = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_GLYPH_TAB, BirdFontGlyphTab);
				_tmp18_ = glyph_tab;
				_tmp19_ = _tmp18_->glyphs;
				_tmp20_ = bird_font_glyph_collection_get_current (_tmp19_);
				_g_object_unref0 (glyph);
				glyph = _tmp20_;
				_tmp21_ = uni;
				g_string_truncate (_tmp21_, (gsize) 0);
				_tmp22_ = uni;
				_tmp23_ = glyph;
				g_string_append_unichar (_tmp22_, _tmp23_->unichar_code);
				_tmp24_ = font;
				_tmp25_ = uni;
				_tmp26_ = _tmp25_->str;
				_tmp27_ = bird_font_font_get_glyph (_tmp24_, _tmp26_);
				_g_object_unref0 (ug);
				ug = _tmp27_;
				_tmp28_ = ug;
				if (_tmp28_ == NULL) {
					_g_object_unref0 (glyph_tab);
					_g_string_free0 (uni);
					_g_object_unref0 (font);
					_g_object_unref0 (ug);
					_g_object_unref0 (updated_glyph);
					_g_object_unref0 (glyph);
					_g_object_unref0 (tn);
					_g_object_unref0 (tab);
					_g_object_unref0 (b);
					return;
				}
				_tmp29_ = ug;
				_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
				_g_object_unref0 (updated_glyph);
				updated_glyph = _tmp30_;
				_tmp31_ = tab;
				_tmp32_ = glyph_tab;
				bird_font_tab_set_display (_tmp31_, (BirdFontFontDisplay*) _tmp32_);
				_tmp33_ = updated_glyph;
				_tmp34_ = glyph;
				_tmp33_->view_zoom = _tmp34_->view_zoom;
				_tmp35_ = updated_glyph;
				_tmp36_ = glyph;
				_tmp35_->view_offset_x = _tmp36_->view_offset_x;
				_tmp37_ = updated_glyph;
				_tmp38_ = glyph;
				_tmp37_->view_offset_y = _tmp38_->view_offset_y;
				_g_object_unref0 (glyph_tab);
			}
		}
	}
	_g_string_free0 (uni);
	_g_object_unref0 (font);
	_g_object_unref0 (ug);
	_g_object_unref0 (updated_glyph);
	_g_object_unref0 (glyph);
	_g_object_unref0 (tn);
	_g_object_unref0 (tab);
	_g_object_unref0 (b);
}

static void
__lambda332_ (BirdFontVersionList* self,
              BirdFontMenuAction* _self_)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	bird_font_version_list_set_selected_item (self, _self_, TRUE);
	bird_font_font_touch (font);
	_g_object_unref0 (font);
}

static void
___lambda332__bird_font_menu_action_action (BirdFontMenuAction* _sender,
                                            BirdFontMenuAction* a,
                                            gpointer self)
{
	__lambda332_ ((BirdFontVersionList*) self, a);
}

void
bird_font_version_list_add_glyph (BirdFontVersionList* self,
                                  BirdFontGlyph* new_version,
                                  gboolean selected)
{
	BirdFontMenuAction* ma = NULL;
	gint v = 0;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontMenuAction* _tmp9_;
	BirdFontMenuAction* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	BirdFontMenuAction* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_version != NULL);
	v = new_version->version_id;
	_tmp0_ = self->glyphs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, new_version);
	_tmp1_ = bird_font_t_ ("Version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", v + 1);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (" ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp2_, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_version_list_add_item (self, _tmp8_);
	_g_object_unref0 (ma);
	ma = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp10_ = ma;
	_tmp11_ = self->glyphs;
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp10_->index = ((gint) _tmp13_) - 1;
	_tmp14_ = ma;
	g_signal_connect_object (_tmp14_, "action", (GCallback) ___lambda332__bird_font_menu_action_action, self, 0);
	if (selected) {
		BirdFontMenuAction* _tmp15_;
		_tmp15_ = ma;
		bird_font_version_list_set_selected_item (self, _tmp15_, TRUE);
	}
	if (selected) {
		bird_font_version_list_update_selection (self, TRUE);
	}
	_g_object_unref0 (ma);
}

static gboolean
bird_font_version_list_has_version (BirdFontVersionList* self,
                                    gint id)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp0_;
		gint _g_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _g_index = 0;
		_tmp0_ = self->glyphs;
		_g_list = _tmp0_;
		_tmp1_ = _g_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_size = _tmp3_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontGlyph* _tmp8_;
			_g_index = _g_index + 1;
			_tmp4_ = _g_index;
			_tmp5_ = _g_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _g_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _g_index);
			g = (BirdFontGlyph*) _tmp7_;
			_tmp8_ = g;
			if (_tmp8_->version_id == id) {
				result = TRUE;
				_g_object_unref0 (g);
				return result;
			}
			_g_object_unref0 (g);
		}
	}
	result = FALSE;
	return result;
}

static void
bird_font_version_list_update_selection (BirdFontVersionList* self,
                                         gboolean update_loaded_glyph)
{
	gint index = 0;
	g_return_if_fail (self != NULL);
	if (bird_font_version_list_has_version (self, self->current_version_id)) {
		BirdFontMenuAction* _tmp0_;
		BirdFontMenuAction* _tmp1_;
		index = bird_font_version_list_get_current_version_index (self);
		_tmp0_ = bird_font_version_list_get_action_index (self, index + 1);
		_tmp1_ = _tmp0_;
		bird_font_version_list_set_selected_item (self, _tmp1_, update_loaded_glyph);
		_g_object_unref0 (_tmp1_);
	}
}

BirdFontMenuAction*
bird_font_version_list_get_action_index (BirdFontVersionList* self,
                                         gint index)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp14_;
	gpointer _tmp15_;
	BirdFontMenuAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->actions;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	if (!((0 <= _tmp3_) && (_tmp3_ < _tmp2_))) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		BirdFontMenuAction* _tmp13_;
		_tmp4_ = g_strdup_printf ("%i", index);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->actions;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("No action for index ", _tmp5_, ". (actions.size: ", _tmp10_, ")", NULL);
		_tmp12_ = _tmp11_;
		g_warning ("VersionList.vala:308: %s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp5_);
		_tmp13_ = bird_font_menu_action_new ("None");
		result = _tmp13_;
		return result;
	}
	_tmp14_ = self->priv->actions;
	_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, index);
	result = (BirdFontMenuAction*) _tmp15_;
	return result;
}

void
bird_font_version_list_recreate_index (BirdFontVersionList* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = -1;
	{
		GeeArrayList* _a_list = NULL;
		GeeArrayList* _tmp0_;
		gint _a_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _a_index = 0;
		_tmp0_ = self->priv->actions;
		_a_list = _tmp0_;
		_tmp1_ = _a_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_a_size = _tmp3_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontMenuAction* a = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontMenuAction* _tmp8_;
			gint _tmp9_;
			_a_index = _a_index + 1;
			_tmp4_ = _a_index;
			_tmp5_ = _a_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _a_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _a_index);
			a = (BirdFontMenuAction*) _tmp7_;
			_tmp8_ = a;
			_tmp8_->index = i;
			_tmp9_ = i;
			i = _tmp9_ + 1;
			_g_object_unref0 (a);
		}
	}
}

BirdFontMenuAction*
bird_font_version_list_get_action_no2 (BirdFontVersionList* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BirdFontMenuAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->actions;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < 2) {
		BirdFontMenuAction* _tmp3_;
		g_warning ("VersionList.vala:324: No such action");
		_tmp3_ = bird_font_menu_action_new ("None");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->actions;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, 1);
	result = (BirdFontMenuAction*) _tmp5_;
	return result;
}

void
bird_font_version_list_deselect_all (BirdFontVersionList* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp0_;
		gint _m_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _m_index = 0;
		_tmp0_ = self->priv->actions;
		_m_list = _tmp0_;
		_tmp1_ = _m_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontMenuAction* m = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontMenuAction* _tmp8_;
			_m_index = _m_index + 1;
			_tmp4_ = _m_index;
			_tmp5_ = _m_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _m_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _m_index);
			m = (BirdFontMenuAction*) _tmp7_;
			_tmp8_ = m;
			bird_font_menu_action_set_selected (_tmp8_, FALSE);
			_g_object_unref0 (m);
		}
	}
}

void
bird_font_version_list_set_direction (BirdFontVersionList* self,
                                      MenuDirection d)
{
	g_return_if_fail (self != NULL);
	self->priv->direction = d;
}

void
bird_font_version_list_close (BirdFontVersionList* self)
{
	g_return_if_fail (self != NULL);
	bird_font_version_list_set_menu_visible (self, FALSE);
}

BirdFontMenuAction*
bird_font_version_list_add_item (BirdFontVersionList* self,
                                 const gchar* label)
{
	BirdFontMenuAction* m = NULL;
	BirdFontMenuAction* _tmp0_;
	BirdFontMenuAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = bird_font_menu_action_new (label);
	m = _tmp0_;
	bird_font_version_list_add_menu_item (self, m);
	result = m;
	return result;
}

void
bird_font_version_list_add_menu_item (BirdFontVersionList* self,
                                      BirdFontMenuAction* m)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = self->priv->actions;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, m);
}

gboolean
bird_font_version_list_is_over_icon (BirdFontVersionList* self,
                                     gdouble px,
                                     gdouble py)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->x == ((gdouble) -1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->y == ((gdouble) -1);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = px;
	if (((self->priv->x - 12) < _tmp2_) && (_tmp2_ <= self->priv->x)) {
		gdouble _tmp3_;
		_tmp3_ = py;
		_tmp1_ = ((self->priv->y - 5) < _tmp3_) && (_tmp3_ < ((self->priv->y + 12) + 5));
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gboolean
bird_font_version_list_menu_item_action (BirdFontVersionList* self,
                                         gdouble px,
                                         gdouble py)
{
	BirdFontMenuAction* action = NULL;
	BirdFontMenuAction* a = NULL;
	BirdFontMenuAction* ma = NULL;
	gint index = 0;
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_menu_visible;
	if (_tmp0_) {
		BirdFontMenuAction* _tmp1_;
		BirdFontMenuAction* _tmp2_;
		_tmp1_ = bird_font_version_list_get_menu_action_at (self, px, py);
		_g_object_unref0 (action);
		action = _tmp1_;
		_tmp2_ = action;
		if (_tmp2_ != NULL) {
			BirdFontMenuAction* _tmp3_;
			BirdFontMenuAction* _tmp4_;
			gboolean _tmp5_ = FALSE;
			BirdFontMenuAction* _tmp6_;
			_tmp3_ = action;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BIRD_FONT_TYPE_MENU_ACTION, BirdFontMenuAction));
			_g_object_unref0 (a);
			a = _tmp4_;
			_tmp6_ = a;
			if (_tmp6_->has_delete_button) {
				gdouble _tmp7_;
				_tmp7_ = px;
				_tmp5_ = (((self->priv->menu_x + self->priv->width) - 13) < _tmp7_) && (_tmp7_ <= (self->priv->menu_x + self->priv->width));
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				index = 0;
				_tmp8_ = self->priv->actions;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, 0);
				_g_object_unref0 (ma);
				ma = (BirdFontMenuAction*) _tmp9_;
				while (TRUE) {
					BirdFontMenuAction* _tmp10_;
					BirdFontMenuAction* _tmp11_;
					BirdFontMenuAction* _tmp15_;
					GeeArrayList* _tmp16_;
					GeeArrayList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gpointer _tmp20_;
					BirdFontMenuAction* _tmp21_;
					gboolean _tmp22_;
					_tmp10_ = a;
					_tmp11_ = ma;
					if (_tmp10_ == _tmp11_) {
						GeeArrayList* _tmp12_;
						gpointer _tmp13_;
						BirdFontMenuAction* _tmp14_;
						_tmp12_ = self->priv->actions;
						_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp12_, index);
						_tmp14_ = (BirdFontMenuAction*) _tmp13_;
						_g_object_unref0 (_tmp14_);
						g_signal_emit (self, bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_SIGNAL_DELETE_ITEM_SIGNAL], 0, index);
						break;
					}
					_tmp15_ = ma;
					_tmp16_ = self->priv->actions;
					_tmp17_ = self->priv->actions;
					_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp19_ - 1);
					_tmp21_ = (BirdFontMenuAction*) _tmp20_;
					_tmp22_ = _tmp15_ == _tmp21_;
					_g_object_unref0 (_tmp21_);
					if (_tmp22_) {
						break;
					} else {
						GeeArrayList* _tmp23_;
						gpointer _tmp24_;
						gint _tmp25_;
						_tmp23_ = self->priv->actions;
						_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, index + 1);
						_g_object_unref0 (ma);
						ma = (BirdFontMenuAction*) _tmp24_;
						_tmp25_ = index;
						index = _tmp25_ + 1;
					}
				}
				result = FALSE;
				_g_object_unref0 (ma);
				_g_object_unref0 (a);
				_g_object_unref0 (action);
				return result;
			} else {
				BirdFontMenuAction* _tmp26_;
				BirdFontMenuAction* _tmp27_;
				_tmp26_ = a;
				_tmp27_ = a;
				g_signal_emit_by_name (_tmp26_, "action", _tmp27_);
				g_signal_emit (self, bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_SELECTED_SIGNAL], 0, self);
				bird_font_version_list_set_menu_visible (self, FALSE);
			}
			result = TRUE;
			_g_object_unref0 (ma);
			_g_object_unref0 (a);
			_g_object_unref0 (action);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (ma);
	_g_object_unref0 (a);
	_g_object_unref0 (action);
	return result;
}

static void
bird_font_version_list_select_last_glyph (BirdFontVersionList* self)
{
	BirdFontMenuAction* ma = NULL;
	BirdFontMenuAction* _tmp10_;
	g_return_if_fail (self != NULL);
	ma = NULL;
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp0_;
		gint _m_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _m_index = 0;
		_tmp0_ = self->priv->actions;
		_m_list = _tmp0_;
		_tmp1_ = _m_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_m_size = _tmp3_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontMenuAction* m = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontMenuAction* _tmp8_;
			BirdFontMenuAction* _tmp9_;
			_m_index = _m_index + 1;
			_tmp4_ = _m_index;
			_tmp5_ = _m_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _m_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _m_index);
			m = (BirdFontMenuAction*) _tmp7_;
			_tmp8_ = m;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			_g_object_unref0 (ma);
			ma = _tmp9_;
			_g_object_unref0 (m);
		}
	}
	_tmp10_ = ma;
	if (_tmp10_ != NULL) {
		BirdFontMenuAction* _tmp11_;
		_tmp11_ = ma;
		bird_font_version_list_set_selected_item (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, BIRD_FONT_TYPE_MENU_ACTION, BirdFontMenuAction), TRUE);
	}
	_g_object_unref0 (ma);
}

gboolean
bird_font_version_list_menu_icon_action (BirdFontVersionList* self,
                                         gdouble px,
                                         gdouble py)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	bird_font_version_list_set_menu_visible (self, bird_font_version_list_is_over_icon (self, px, py));
	_tmp0_ = self->priv->_menu_visible;
	result = _tmp0_;
	return result;
}

static BirdFontMenuAction*
bird_font_version_list_get_menu_action_at (BirdFontVersionList* self,
                                           gdouble px,
                                           gdouble py)
{
	gdouble n = 0.0;
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	BirdFontMenuAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	n = (gdouble) 0;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = self->priv->actions;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontMenuAction* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gdouble _tmp9_;
			gdouble _tmp11_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (BirdFontMenuAction*) _tmp7_;
			ix = self->priv->menu_x - 6;
			if (self->priv->direction == MENU_DIRECTION_DROP_DOWN) {
				iy = (self->priv->y + 12) + (n * BIRD_FONT_VERSION_LIST_item_height);
			} else {
				iy = (self->priv->y - 24) - (n * BIRD_FONT_VERSION_LIST_item_height);
			}
			_tmp9_ = px;
			if ((ix <= _tmp9_) && (_tmp9_ <= (ix + self->priv->width))) {
				gdouble _tmp10_;
				_tmp10_ = py;
				_tmp8_ = (iy <= _tmp10_) && (_tmp10_ <= (iy + BIRD_FONT_VERSION_LIST_item_height));
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = item;
				return result;
			}
			_tmp11_ = n;
			n = _tmp11_ + 1;
			_g_object_unref0 (item);
		}
	}
	result = NULL;
	return result;
}

void
bird_font_version_list_set_position (BirdFontVersionList* self,
                                     gdouble px,
                                     gdouble py)
{
	g_return_if_fail (self != NULL);
	self->priv->x = px;
	self->priv->y = py;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = self->priv->actions;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontMenuAction* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontMenuAction* _tmp8_;
			BirdFontMenuAction* _tmp9_;
			const gchar* _tmp10_;
			BirdFontText* _tmp11_;
			BirdFontMenuAction* _tmp12_;
			BirdFontText* _tmp13_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (BirdFontMenuAction*) _tmp7_;
			_tmp8_ = item;
			_tmp9_ = item;
			_tmp10_ = _tmp9_->label;
			_tmp11_ = bird_font_text_new (_tmp10_, (gdouble) 17, (gdouble) 0);
			_g_object_unref0 (_tmp8_->text);
			_tmp8_->text = _tmp11_;
			_tmp12_ = item;
			_tmp13_ = _tmp12_->text;
			if ((bird_font_text_get_sidebearing_extent (_tmp13_) + 25) > self->priv->width) {
				BirdFontMenuAction* _tmp14_;
				BirdFontText* _tmp15_;
				_tmp14_ = item;
				_tmp15_ = _tmp14_->text;
				self->priv->width = bird_font_text_get_sidebearing_extent (_tmp15_) + 25;
			}
			_g_object_unref0 (item);
		}
	}
	if ((self->priv->x - self->priv->width) < ((gdouble) 5)) {
		self->priv->menu_x = (gdouble) 5;
	} else {
		self->priv->menu_x = self->priv->x - self->priv->width;
	}
}

void
bird_font_version_list_draw_menu (BirdFontVersionList* self,
                                  cairo_t* cr)
{
	gdouble ix = 0.0;
	gdouble iy = 0.0;
	gint n = 0;
	gboolean _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->_menu_visible;
	if (G_LIKELY (!_tmp0_)) {
		return;
	}
	cairo_save (cr);
	bird_font_theme_color (cr, "Default Background");
	_tmp1_ = self->priv->actions;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->actions;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	cairo_rectangle (cr, self->priv->menu_x, self->priv->y - (_tmp3_ * BIRD_FONT_VERSION_LIST_item_height), self->priv->width, (gdouble) (_tmp6_ * BIRD_FONT_VERSION_LIST_item_height));
	cairo_fill_preserve (cr);
	cairo_stroke (cr);
	cairo_restore (cr);
	cairo_save (cr);
	n = 0;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp7_;
		gint _item_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _item_index = 0;
		_tmp7_ = self->priv->actions;
		_item_list = _tmp7_;
		_tmp8_ = _item_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_item_size = _tmp10_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			BirdFontMenuAction* item = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			BirdFontMenuAction* _tmp15_;
			BirdFontMenuAction* _tmp16_;
			gint _tmp17_;
			_item_index = _item_index + 1;
			_tmp11_ = _item_index;
			_tmp12_ = _item_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _item_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _item_index);
			item = (BirdFontMenuAction*) _tmp14_;
			_tmp15_ = item;
			_tmp15_->width = self->priv->width;
			iy = (self->priv->y - 8) - (n * BIRD_FONT_VERSION_LIST_item_height);
			ix = self->priv->menu_x + 2;
			_tmp16_ = item;
			bird_font_menu_action_draw (_tmp16_, ix, iy, cr);
			_tmp17_ = n;
			n = _tmp17_ + 1;
			_g_object_unref0 (item);
		}
	}
	cairo_restore (cr);
}

gboolean
bird_font_version_list_get_menu_visible (BirdFontVersionList* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_menu_visible;
	return result;
}

void
bird_font_version_list_set_menu_visible (BirdFontVersionList* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_version_list_get_menu_visible (self);
	if (old_value != value) {
		self->priv->_menu_visible = value;
		g_object_notify_by_pspec ((GObject *) self, bird_font_version_list_properties[BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY]);
	}
}

static void
bird_font_version_list_class_init (BirdFontVersionListClass * klass,
                                   gpointer klass_data)
{
	bird_font_version_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontVersionList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_version_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_version_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_version_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY, bird_font_version_list_properties[BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY] = g_param_spec_boolean ("menu-visible", "menu-visible", "menu-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_SELECTED_SIGNAL] = g_signal_new ("selected", BIRD_FONT_TYPE_VERSION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_VERSION_LIST);
	bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_SIGNAL_DELETE_ITEM_SIGNAL] = g_signal_new ("signal-delete-item", BIRD_FONT_TYPE_VERSION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	bird_font_version_list_signals[BIRD_FONT_VERSION_LIST_ADD_GLYPH_ITEM_SIGNAL] = g_signal_new ("add-glyph-item", BIRD_FONT_TYPE_VERSION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_GLYPH);
}

static void
bird_font_version_list_instance_init (BirdFontVersionList * self,
                                      gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_version_list_get_instance_private (self);
	self->current_version_id = -1;
	self->priv->x = (gdouble) -1;
	self->priv->y = (gdouble) -1;
	self->priv->width = (gdouble) 0;
	self->priv->menu_x = (gdouble) -1;
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_MENU_ACTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->actions = _tmp0_;
	self->priv->direction = MENU_DIRECTION_DROP_DOWN;
}

static void
bird_font_version_list_finalize (GObject * obj)
{
	BirdFontVersionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_VERSION_LIST, BirdFontVersionList);
	_g_object_unref0 (self->priv->glyph_collection);
	_g_object_unref0 (self->glyphs);
	_g_object_unref0 (self->priv->actions);
	G_OBJECT_CLASS (bird_font_version_list_parent_class)->finalize (obj);
}

static GType
bird_font_version_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontVersionListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_version_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontVersionList), 0, (GInstanceInitFunc) bird_font_version_list_instance_init, NULL };
	GType bird_font_version_list_type_id;
	bird_font_version_list_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontVersionList", &g_define_type_info, 0);
	BirdFontVersionList_private_offset = g_type_add_instance_private (bird_font_version_list_type_id, sizeof (BirdFontVersionListPrivate));
	return bird_font_version_list_type_id;
}

GType
bird_font_version_list_get_type (void)
{
	static volatile gsize bird_font_version_list_type_id__once = 0;
	if (g_once_init_enter (&bird_font_version_list_type_id__once)) {
		GType bird_font_version_list_type_id;
		bird_font_version_list_type_id = bird_font_version_list_get_type_once ();
		g_once_init_leave (&bird_font_version_list_type_id__once, bird_font_version_list_type_id);
	}
	return bird_font_version_list_type_id__once;
}

static void
_vala_bird_font_version_list_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	BirdFontVersionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_VERSION_LIST, BirdFontVersionList);
	switch (property_id) {
		case BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY:
		g_value_set_boolean (value, bird_font_version_list_get_menu_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_version_list_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	BirdFontVersionList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_VERSION_LIST, BirdFontVersionList);
	switch (property_id) {
		case BIRD_FONT_VERSION_LIST_MENU_VISIBLE_PROPERTY:
		bird_font_version_list_set_menu_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

