/* Toolbox.c generated by valac 0.56.16, the Vala compiler
 * generated from Toolbox.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TOOLBOX_0_PROPERTY,
	BIRD_FONT_TOOLBOX_NUM_PROPERTIES
};
static GParamSpec* bird_font_toolbox_properties[BIRD_FONT_TOOLBOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BIRD_FONT_TOOLBOX_EMPTY_SET_0_PROPERTY,
	BIRD_FONT_TOOLBOX_EMPTY_SET_NUM_PROPERTIES
};
static GParamSpec* bird_font_toolbox_empty_set_properties[BIRD_FONT_TOOLBOX_EMPTY_SET_NUM_PROPERTIES];
enum  {
	BIRD_FONT_TOOLBOX_REDRAW_SIGNAL,
	BIRD_FONT_TOOLBOX_NEW_TOOL_SET_SIGNAL,
	BIRD_FONT_TOOLBOX_NUM_SIGNALS
};
static guint bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_NUM_SIGNALS] = {0};

struct _BirdFontToolboxPrivate {
	gboolean scrolling_toolbox;
	gboolean scrolling_touch;
	gdouble scroll_y;
	gchar* tool_tip;
	gdouble tool_tip_x;
	gdouble tool_tip_y;
	gboolean suppress_event;
};

struct _BirdFontToolboxEmptySetPrivate {
	GeeArrayList* expanders;
};

static gint BirdFontToolbox_private_offset;
static gpointer bird_font_toolbox_parent_class = NULL;
BirdFontToolCollection* bird_font_toolbox_current_set = NULL;
BirdFontHiddenTools* bird_font_toolbox_hidden_tools = NULL;
BirdFontDrawingTools* bird_font_toolbox_drawing_tools = NULL;
BirdFontKerningTools* bird_font_toolbox_kerning_tools = NULL;
BirdFontPreviewTools* bird_font_toolbox_preview_tools = NULL;
BirdFontOverviewTools* bird_font_toolbox_overview_tools = NULL;
BirdFontBackgroundTools* bird_font_toolbox_background_tools = NULL;
BirdFontSpacingTools* bird_font_toolbox_spacing_tools = NULL;
BirdFontSpacingClassTools* bird_font_toolbox_spacing_class_tools = NULL;
BirdFontFileTools* bird_font_toolbox_file_tools = NULL;
BirdFontThemeTools* bird_font_toolbox_theme_tools = NULL;
gint bird_font_toolbox_allocation_width = 0;
gint bird_font_toolbox_allocation_height = 0;
static gint BirdFontToolboxEmptySet_private_offset;
static gpointer bird_font_toolbox_empty_set_parent_class = NULL;

static void __lambda515_ (BirdFontToolbox* self,
                   BirdFontTab* tab);
static void ___lambda515__bird_font_tab_bar_signal_tab_selected (BirdFontTabBar* _sender,
                                                          BirdFontTab* selected_tab,
                                                          gpointer self);
static void bird_font_toolbox_scroll_current_set (BirdFontToolbox* self,
                                           gdouble d);
static void bird_font_toolbox_suppress_scroll (BirdFontToolbox* self);
static gboolean __lambda503_ (BirdFontToolbox* self);
static gboolean ___lambda503__gsource_func (gpointer self);
static void bird_font_toolbox_draw_expanders (BirdFontToolbox* self,
                                       gint w,
                                       gint h,
                                       cairo_t* cr);
static void bird_font_toolbox_draw_tool_tip (BirdFontToolbox* self,
                                      cairo_t* cr);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static GeeArrayList* bird_font_toolbox_empty_set_real_get_expanders (BirdFontToolCollection* base);
static void bird_font_toolbox_empty_set_finalize (GObject * obj);
static GType bird_font_toolbox_empty_set_get_type_once (void);
static void bird_font_toolbox_finalize (GObject * obj);
static GType bird_font_toolbox_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_toolbox_get_instance_private (BirdFontToolbox* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontToolbox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda515_ (BirdFontToolbox* self,
              BirdFontTab* tab)
{
	gchar* tab_name = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontFontDisplay* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (tab != NULL);
	_tmp0_ = bird_font_tab_get_display (tab);
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_display_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	tab_name = _tmp3_;
	bird_font_toolbox_set_toolbox_from_tab (tab_name, tab);
	g_signal_emit (self, bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_NEW_TOOL_SET_SIGNAL], 0, tab);
	_g_free0 (tab_name);
}

static void
___lambda515__bird_font_tab_bar_signal_tab_selected (BirdFontTabBar* _sender,
                                                     BirdFontTab* selected_tab,
                                                     gpointer self)
{
	__lambda515_ ((BirdFontToolbox*) self, selected_tab);
}

BirdFontToolbox*
bird_font_toolbox_construct (GType object_type,
                             BirdFontGlyphCanvas* glyph_canvas,
                             BirdFontTabBar* tab_bar)
{
	BirdFontToolbox * self = NULL;
	GeeArrayList* _tmp0_;
	BirdFontTool* _tmp1_;
	BirdFontHiddenTools* _tmp2_;
	BirdFontDrawingTools* _tmp3_;
	BirdFontKerningTools* _tmp4_;
	BirdFontPreviewTools* _tmp5_;
	BirdFontOverviewTools* _tmp6_;
	BirdFontBackgroundTools* _tmp7_;
	BirdFontSpacingTools* _tmp8_;
	BirdFontSpacingClassTools* _tmp9_;
	BirdFontFileTools* _tmp10_;
	BirdFontThemeTools* _tmp11_;
	GeeArrayList* _tmp12_;
	BirdFontThemeTools* _tmp13_;
	GeeArrayList* _tmp14_;
	BirdFontFileTools* _tmp15_;
	GeeArrayList* _tmp16_;
	BirdFontHiddenTools* _tmp17_;
	GeeArrayList* _tmp18_;
	BirdFontDrawingTools* _tmp19_;
	GeeArrayList* _tmp20_;
	BirdFontKerningTools* _tmp21_;
	GeeArrayList* _tmp22_;
	BirdFontPreviewTools* _tmp23_;
	GeeArrayList* _tmp24_;
	BirdFontOverviewTools* _tmp25_;
	GeeArrayList* _tmp26_;
	BirdFontSpacingClassTools* _tmp27_;
	GeeArrayList* _tmp28_;
	BirdFontBackgroundTools* _tmp29_;
	GeeArrayList* _tmp30_;
	BirdFontHiddenTools* _tmp31_;
	BirdFontFileTools* _tmp32_;
	BirdFontToolCollection* _tmp33_;
	BirdFontToolCollection* _tmp34_;
	g_return_val_if_fail (glyph_canvas != NULL, NULL);
	g_return_val_if_fail (tab_bar != NULL, NULL);
	self = (BirdFontToolbox*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_TOOL_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->tool_sets);
	self->tool_sets = _tmp0_;
	_tmp1_ = bird_font_tool_new (NULL, "");
	_g_object_unref0 (self->press_tool);
	self->press_tool = _tmp1_;
	_tmp2_ = bird_font_hidden_tools_new ();
	_g_object_unref0 (bird_font_toolbox_hidden_tools);
	bird_font_toolbox_hidden_tools = _tmp2_;
	_tmp3_ = bird_font_drawing_tools_new (glyph_canvas);
	_g_object_unref0 (bird_font_toolbox_drawing_tools);
	bird_font_toolbox_drawing_tools = _tmp3_;
	_tmp4_ = bird_font_kerning_tools_new ();
	_g_object_unref0 (bird_font_toolbox_kerning_tools);
	bird_font_toolbox_kerning_tools = _tmp4_;
	_tmp5_ = bird_font_preview_tools_new ();
	_g_object_unref0 (bird_font_toolbox_preview_tools);
	bird_font_toolbox_preview_tools = _tmp5_;
	_tmp6_ = bird_font_overview_tools_new ();
	_g_object_unref0 (bird_font_toolbox_overview_tools);
	bird_font_toolbox_overview_tools = _tmp6_;
	_tmp7_ = bird_font_background_tools_new ();
	_g_object_unref0 (bird_font_toolbox_background_tools);
	bird_font_toolbox_background_tools = _tmp7_;
	_tmp8_ = bird_font_spacing_tools_new ();
	_g_object_unref0 (bird_font_toolbox_spacing_tools);
	bird_font_toolbox_spacing_tools = _tmp8_;
	_tmp9_ = bird_font_spacing_class_tools_new ();
	_g_object_unref0 (bird_font_toolbox_spacing_class_tools);
	bird_font_toolbox_spacing_class_tools = _tmp9_;
	_tmp10_ = bird_font_file_tools_new ();
	_g_object_unref0 (bird_font_toolbox_file_tools);
	bird_font_toolbox_file_tools = _tmp10_;
	_tmp11_ = bird_font_theme_tools_new ();
	_g_object_unref0 (bird_font_toolbox_theme_tools);
	bird_font_toolbox_theme_tools = _tmp11_;
	_tmp12_ = self->tool_sets;
	_tmp13_ = bird_font_toolbox_theme_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (BirdFontToolCollection*) _tmp13_);
	_tmp14_ = self->tool_sets;
	_tmp15_ = bird_font_toolbox_file_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (BirdFontToolCollection*) _tmp15_);
	_tmp16_ = self->tool_sets;
	_tmp17_ = bird_font_toolbox_hidden_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, (BirdFontToolCollection*) _tmp17_);
	_tmp18_ = self->tool_sets;
	_tmp19_ = bird_font_toolbox_drawing_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, (BirdFontToolCollection*) _tmp19_);
	_tmp20_ = self->tool_sets;
	_tmp21_ = bird_font_toolbox_kerning_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, (BirdFontToolCollection*) _tmp21_);
	_tmp22_ = self->tool_sets;
	_tmp23_ = bird_font_toolbox_preview_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, (BirdFontToolCollection*) _tmp23_);
	_tmp24_ = self->tool_sets;
	_tmp25_ = bird_font_toolbox_overview_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, (BirdFontToolCollection*) _tmp25_);
	_tmp26_ = self->tool_sets;
	_tmp27_ = bird_font_toolbox_spacing_class_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, (BirdFontToolCollection*) _tmp27_);
	_tmp28_ = self->tool_sets;
	_tmp29_ = bird_font_toolbox_background_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, (BirdFontToolCollection*) _tmp29_);
	_tmp30_ = self->tool_sets;
	_tmp31_ = bird_font_toolbox_hidden_tools;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, (BirdFontToolCollection*) _tmp31_);
	_tmp32_ = bird_font_toolbox_file_tools;
	_tmp33_ = _g_object_ref0 ((BirdFontToolCollection*) _tmp32_);
	_g_object_unref0 (bird_font_toolbox_current_set);
	bird_font_toolbox_current_set = _tmp33_;
	_tmp34_ = bird_font_toolbox_current_set;
	bird_font_tool_collection_selected (_tmp34_);
	g_signal_connect_object (tab_bar, "signal-tab-selected", (GCallback) ___lambda515__bird_font_tab_bar_signal_tab_selected, self, 0);
	bird_font_toolbox_update_expanders (self);
	return self;
}

BirdFontToolbox*
bird_font_toolbox_new (BirdFontGlyphCanvas* glyph_canvas,
                       BirdFontTabBar* tab_bar)
{
	return bird_font_toolbox_construct (BIRD_FONT_TYPE_TOOLBOX, glyph_canvas, tab_bar);
}

void
bird_font_toolbox_set_suppress_event (BirdFontToolbox* self,
                                      gboolean e)
{
	g_return_if_fail (self != NULL);
	self->priv->suppress_event = e;
}

BirdFontDrawingTools*
bird_font_toolbox_get_drawing_tools (void)
{
	BirdFontDrawingTools* _tmp0_;
	BirdFontDrawingTools* _tmp1_;
	BirdFontDrawingTools* result;
	_tmp0_ = bird_font_toolbox_drawing_tools;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_toolbox_update_all_expanders (BirdFontToolbox* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tc_list = NULL;
		GeeArrayList* _tmp0_;
		gint _tc_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tc_index = 0;
		_tmp0_ = self->tool_sets;
		_tc_list = _tmp0_;
		_tmp1_ = _tc_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tc_size = _tmp3_;
		_tc_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontToolCollection* tc = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontToolCollection* _tmp8_;
			_tc_index = _tc_index + 1;
			_tmp4_ = _tc_index;
			_tmp5_ = _tc_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _tc_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tc_index);
			tc = (BirdFontToolCollection*) _tmp7_;
			_tmp8_ = tc;
			bird_font_tool_collection_redraw (_tmp8_);
			_g_object_unref0 (tc);
		}
	}
}

void
bird_font_toolbox_cache_all_tools (void)
{
	BirdFontToolbox* t = NULL;
	BirdFontToolbox* _tmp0_;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	t = _tmp0_;
	{
		GeeArrayList* _tc_list = NULL;
		BirdFontToolbox* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tc_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tc_index = 0;
		_tmp1_ = t;
		_tmp2_ = _tmp1_->tool_sets;
		_tc_list = _tmp2_;
		_tmp3_ = _tc_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tc_size = _tmp5_;
		_tc_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontToolCollection* tc = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontToolCollection* _tmp10_;
			_tc_index = _tc_index + 1;
			_tmp6_ = _tc_index;
			_tmp7_ = _tc_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _tc_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tc_index);
			tc = (BirdFontToolCollection*) _tmp9_;
			_tmp10_ = tc;
			bird_font_tool_collection_cache (_tmp10_);
			_g_object_unref0 (tc);
		}
	}
	_g_object_unref0 (t);
}

void
bird_font_toolbox_set_toolbox_from_tab (const gchar* tab_name,
                                        BirdFontTab* t)
{
	BirdFontToolCollection* _tmp26_;
	BirdFontToolbox* _tmp27_;
	BirdFontToolbox* _tmp28_;
	g_return_if_fail (tab_name != NULL);
	if (g_strcmp0 (tab_name, "Spacing") == 0) {
		BirdFontSpacingTools* _tmp0_;
		BirdFontToolCollection* _tmp1_;
		_tmp0_ = bird_font_toolbox_spacing_tools;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
		_g_object_unref0 (bird_font_toolbox_current_set);
		bird_font_toolbox_current_set = _tmp1_;
	} else {
		if (g_strcmp0 (tab_name, "Kerning") == 0) {
			BirdFontKerningTools* _tmp2_;
			BirdFontToolCollection* _tmp3_;
			_tmp2_ = bird_font_toolbox_kerning_tools;
			_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
			_g_object_unref0 (bird_font_toolbox_current_set);
			bird_font_toolbox_current_set = _tmp3_;
		} else {
			if (g_strcmp0 (tab_name, "Preview") == 0) {
				BirdFontPreviewTools* _tmp4_;
				BirdFontToolCollection* _tmp5_;
				_tmp4_ = bird_font_toolbox_preview_tools;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
				_g_object_unref0 (bird_font_toolbox_current_set);
				bird_font_toolbox_current_set = _tmp5_;
			} else {
				if (g_strcmp0 (tab_name, "Overview") == 0) {
					BirdFontOverviewTools* _tmp6_;
					BirdFontToolCollection* _tmp7_;
					_tmp6_ = bird_font_toolbox_overview_tools;
					_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
					_g_object_unref0 (bird_font_toolbox_current_set);
					bird_font_toolbox_current_set = _tmp7_;
				} else {
					if (g_strcmp0 (tab_name, "Backgrounds") == 0) {
						BirdFontBackgroundTools* _tmp8_;
						BirdFontToolCollection* _tmp9_;
						_tmp8_ = bird_font_toolbox_background_tools;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
						_g_object_unref0 (bird_font_toolbox_current_set);
						bird_font_toolbox_current_set = _tmp9_;
					} else {
						if (g_strcmp0 (tab_name, "SpacingClasses") == 0) {
							BirdFontSpacingClassTools* _tmp10_;
							BirdFontToolCollection* _tmp11_;
							_tmp10_ = bird_font_toolbox_spacing_class_tools;
							_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
							_g_object_unref0 (bird_font_toolbox_current_set);
							bird_font_toolbox_current_set = _tmp11_;
						} else {
							if (g_strcmp0 (tab_name, "Themes") == 0) {
								BirdFontThemeTools* _tmp12_;
								BirdFontToolCollection* _tmp13_;
								_tmp12_ = bird_font_toolbox_theme_tools;
								_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
								_g_object_unref0 (bird_font_toolbox_current_set);
								bird_font_toolbox_current_set = _tmp13_;
							} else {
								gboolean _tmp14_ = FALSE;
								if (t != NULL) {
									BirdFontFontDisplay* _tmp15_;
									BirdFontFontDisplay* _tmp16_;
									_tmp15_ = bird_font_tab_get_display (G_TYPE_CHECK_INSTANCE_CAST (t, BIRD_FONT_TYPE_TAB, BirdFontTab));
									_tmp16_ = _tmp15_;
									_tmp14_ = BIRD_FONT_IS_GLYPH_TAB (_tmp16_);
									_g_object_unref0 (_tmp16_);
								} else {
									_tmp14_ = FALSE;
								}
								if (_tmp14_) {
									BirdFontDrawingTools* _tmp17_;
									BirdFontToolCollection* _tmp18_;
									_tmp17_ = bird_font_toolbox_drawing_tools;
									_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
									_g_object_unref0 (bird_font_toolbox_current_set);
									bird_font_toolbox_current_set = _tmp18_;
								} else {
									gboolean _tmp19_ = FALSE;
									if (t != NULL) {
										BirdFontFontDisplay* _tmp20_;
										BirdFontFontDisplay* _tmp21_;
										_tmp20_ = bird_font_tab_get_display (G_TYPE_CHECK_INSTANCE_CAST (t, BIRD_FONT_TYPE_TAB, BirdFontTab));
										_tmp21_ = _tmp20_;
										_tmp19_ = BIRD_FONT_IS_GLYPH (_tmp21_);
										_g_object_unref0 (_tmp21_);
									} else {
										_tmp19_ = FALSE;
									}
									if (_tmp19_) {
										BirdFontDrawingTools* _tmp22_;
										BirdFontToolCollection* _tmp23_;
										g_warning ("Toolbox.vala:136: Expecting GlyphTab instead of Glyph.");
										_tmp22_ = bird_font_toolbox_drawing_tools;
										_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
										_g_object_unref0 (bird_font_toolbox_current_set);
										bird_font_toolbox_current_set = _tmp23_;
									} else {
										BirdFontFileTools* _tmp24_;
										BirdFontToolCollection* _tmp25_;
										_tmp24_ = bird_font_toolbox_file_tools;
										_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, BIRD_FONT_TYPE_TOOL_COLLECTION, BirdFontToolCollection));
										_g_object_unref0 (bird_font_toolbox_current_set);
										bird_font_toolbox_current_set = _tmp25_;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp26_ = bird_font_toolbox_current_set;
	bird_font_tool_collection_selected (_tmp26_);
	_tmp27_ = bird_font_main_window_get_toolbox ();
	_tmp28_ = _tmp27_;
	bird_font_toolbox_update_expanders (_tmp28_);
	_g_object_unref0 (_tmp28_);
	bird_font_toolbox_redraw_tool_box ();
}

BirdFontTool*
bird_font_toolbox_get_move_tool (void)
{
	BirdFontMoveTool* _tmp0_;
	BirdFontMoveTool* _tmp1_;
	BirdFontTool* _tmp2_;
	BirdFontTool* result;
	_tmp0_ = bird_font_drawing_tools_get_move_tool ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((BirdFontTool*) _tmp1_);
	result = _tmp2_;
	return result;
}

void
bird_font_toolbox_set_object_stroke (gdouble width)
{
	BirdFontSpinButton* _tmp0_;
	_tmp0_ = bird_font_drawing_tools_object_stroke;
	bird_font_spin_button_set_value_round (_tmp0_, width, TRUE, TRUE);
	bird_font_toolbox_redraw_tool_box ();
}

void
bird_font_toolbox_set_allocation (gint width,
                                  gint height)
{
	gboolean _tmp0_ = FALSE;
	if (width != bird_font_toolbox_allocation_width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_toolbox_allocation_height != height;
	}
	if (_tmp0_) {
		bird_font_toolbox_allocation_width = width;
		bird_font_toolbox_allocation_height = height;
		bird_font_toolbox_redraw_tool_box ();
	}
}

void
bird_font_toolbox_press (BirdFontToolbox* self,
                         guint button,
                         gdouble x,
                         gdouble y)
{
	gboolean _tmp0_ = FALSE;
	BirdFontToolCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->suppress_event;
	}
	if (_tmp0_) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	_tmp1_ = bird_font_toolbox_current_set;
	y = y - _tmp1_->scroll;
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _exp_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _exp_index = 0;
		_tmp2_ = bird_font_toolbox_current_set;
		_tmp3_ = bird_font_tool_collection_get_expanders (_tmp2_);
		_exp_list = _tmp3_;
		_tmp4_ = _exp_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_exp_size = _tmp6_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontExpander* _tmp11_;
			_exp_index = _exp_index + 1;
			_tmp7_ = _exp_index;
			_tmp8_ = _exp_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _exp_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _exp_index);
			exp = (BirdFontExpander*) _tmp10_;
			_tmp11_ = exp;
			if (_tmp11_->visible) {
				{
					GeeArrayList* _t_list = NULL;
					BirdFontExpander* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _t_size = 0;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _t_index = 0;
					_tmp12_ = exp;
					_tmp13_ = _tmp12_->tool;
					_t_list = _tmp13_;
					_tmp14_ = _t_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_t_size = _tmp16_;
					_t_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						BirdFontTool* t = NULL;
						GeeArrayList* _tmp19_;
						gpointer _tmp20_;
						gboolean _tmp21_ = FALSE;
						BirdFontTool* _tmp22_;
						_t_index = _t_index + 1;
						_tmp17_ = _t_index;
						_tmp18_ = _t_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _t_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _t_index);
						t = (BirdFontTool*) _tmp20_;
						_tmp22_ = t;
						if (bird_font_tool_tool_is_visible (_tmp22_)) {
							BirdFontTool* _tmp23_;
							_tmp23_ = t;
							_tmp21_ = bird_font_tool_is_over (_tmp23_, x, y);
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							BirdFontTool* _tmp24_;
							BirdFontTool* _tmp25_;
							BirdFontTool* _tmp26_;
							BirdFontTool* _tmp27_;
							_tmp24_ = t;
							_tmp25_ = t;
							g_signal_emit_by_name (_tmp24_, "panel-press-action", _tmp25_, button, x, y);
							_tmp26_ = t;
							_tmp27_ = _g_object_ref0 (_tmp26_);
							_g_object_unref0 (self->press_tool);
							self->press_tool = _tmp27_;
						}
						_g_object_unref0 (t);
					}
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
	self->priv->scrolling_touch = TRUE;
	self->priv->scroll_y = y;
}

void
bird_font_toolbox_release (BirdFontToolbox* self,
                           guint button,
                           gdouble x,
                           gdouble y)
{
	gboolean active = FALSE;
	BirdFontToolCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_toolbox_current_set;
	y = y - _tmp0_->scroll;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->suppress_event;
	}
	if (_tmp1_) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _exp_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _exp_index = 0;
		_tmp2_ = bird_font_toolbox_current_set;
		_tmp3_ = bird_font_tool_collection_get_expanders (_tmp2_);
		_exp_list = _tmp3_;
		_tmp4_ = _exp_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_exp_size = _tmp6_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontExpander* _tmp11_;
			_exp_index = _exp_index + 1;
			_tmp7_ = _exp_index;
			_tmp8_ = _exp_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _exp_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _exp_index);
			exp = (BirdFontExpander*) _tmp10_;
			_tmp11_ = exp;
			if (_tmp11_->visible) {
				{
					GeeArrayList* _t_list = NULL;
					BirdFontExpander* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _t_size = 0;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _t_index = 0;
					_tmp12_ = exp;
					_tmp13_ = _tmp12_->tool;
					_t_list = _tmp13_;
					_tmp14_ = _t_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_t_size = _tmp16_;
					_t_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						BirdFontTool* t = NULL;
						GeeArrayList* _tmp19_;
						gpointer _tmp20_;
						BirdFontTool* _tmp21_;
						_t_index = _t_index + 1;
						_tmp17_ = _t_index;
						_tmp18_ = _t_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _t_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _t_index);
						t = (BirdFontTool*) _tmp20_;
						_tmp21_ = t;
						if (bird_font_tool_tool_is_visible (_tmp21_)) {
							BirdFontTool* _tmp22_;
							BirdFontTool* _tmp26_;
							BirdFontTool* _tmp27_;
							_tmp22_ = t;
							active = bird_font_tool_is_over (_tmp22_, x, y);
							if (active) {
								BirdFontTool* _tmp23_;
								BirdFontTool* _tmp24_;
								_tmp23_ = self->press_tool;
								_tmp24_ = t;
								if (_tmp23_ == _tmp24_) {
									BirdFontTool* _tmp25_;
									_tmp25_ = t;
									bird_font_toolbox_select_tool (self, _tmp25_);
								}
							}
							_tmp26_ = t;
							_tmp27_ = t;
							g_signal_emit_by_name (_tmp26_, "panel-release-action", _tmp27_, button, x, y);
						}
						_g_object_unref0 (t);
					}
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
	self->priv->scrolling_touch = FALSE;
}

void
bird_font_toolbox_double_click (BirdFontToolbox* self,
                                guint button,
                                gdouble x,
                                gdouble y)
{
	gboolean _tmp0_ = FALSE;
	BirdFontToolCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->suppress_event;
	}
	if (_tmp0_) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	_tmp1_ = bird_font_toolbox_current_set;
	y = y - _tmp1_->scroll;
	{
		GeeArrayList* _e_list = NULL;
		BirdFontToolCollection* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _e_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = bird_font_toolbox_current_set;
		_tmp3_ = bird_font_tool_collection_get_expanders (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontExpander* e = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontExpander* _tmp11_;
			_e_index = _e_index + 1;
			_tmp7_ = _e_index;
			_tmp8_ = _e_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _e_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _e_index);
			e = (BirdFontExpander*) _tmp10_;
			_tmp11_ = e;
			if (_tmp11_->visible) {
				{
					GeeArrayList* _t_list = NULL;
					BirdFontExpander* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _t_size = 0;
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _t_index = 0;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->tool;
					_t_list = _tmp13_;
					_tmp14_ = _t_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_t_size = _tmp16_;
					_t_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						BirdFontTool* t = NULL;
						GeeArrayList* _tmp19_;
						gpointer _tmp20_;
						BirdFontTool* _tmp21_;
						BirdFontTool* _tmp22_;
						_t_index = _t_index + 1;
						_tmp17_ = _t_index;
						_tmp18_ = _t_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _t_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _t_index);
						t = (BirdFontTool*) _tmp20_;
						_tmp21_ = t;
						_tmp22_ = t;
						g_signal_emit_by_name (_tmp21_, "panel-double-click-action", _tmp22_, button, x, y);
						_g_object_unref0 (t);
					}
				}
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_list);
	}
}

void
bird_font_toolbox_scroll_wheel (BirdFontToolbox* self,
                                gdouble x,
                                gdouble y,
                                gdouble dx,
                                gdouble dy)
{
	gboolean action = FALSE;
	BirdFontToolCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	action = FALSE;
	_tmp0_ = bird_font_toolbox_current_set;
	y = y - _tmp0_->scroll;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->suppress_event;
	}
	if (_tmp1_) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	if (!self->priv->scrolling_toolbox) {
		{
			GeeArrayList* _exp_list = NULL;
			BirdFontToolCollection* _tmp2_;
			GeeArrayList* _tmp3_;
			gint _exp_size = 0;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _exp_index = 0;
			_tmp2_ = bird_font_toolbox_current_set;
			_tmp3_ = bird_font_tool_collection_get_expanders (_tmp2_);
			_exp_list = _tmp3_;
			_tmp4_ = _exp_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_exp_size = _tmp6_;
			_exp_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				BirdFontExpander* exp = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				BirdFontExpander* _tmp11_;
				_exp_index = _exp_index + 1;
				_tmp7_ = _exp_index;
				_tmp8_ = _exp_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _exp_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _exp_index);
				exp = (BirdFontExpander*) _tmp10_;
				_tmp11_ = exp;
				if (_tmp11_->visible) {
					{
						GeeArrayList* _t_list = NULL;
						BirdFontExpander* _tmp12_;
						GeeArrayList* _tmp13_;
						gint _t_size = 0;
						GeeArrayList* _tmp14_;
						gint _tmp15_;
						gint _tmp16_;
						gint _t_index = 0;
						_tmp12_ = exp;
						_tmp13_ = _tmp12_->tool;
						_t_list = _tmp13_;
						_tmp14_ = _t_list;
						_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
						_tmp16_ = _tmp15_;
						_t_size = _tmp16_;
						_t_index = -1;
						while (TRUE) {
							gint _tmp17_;
							gint _tmp18_;
							BirdFontTool* t = NULL;
							GeeArrayList* _tmp19_;
							gpointer _tmp20_;
							gboolean _tmp21_ = FALSE;
							BirdFontTool* _tmp22_;
							_t_index = _t_index + 1;
							_tmp17_ = _t_index;
							_tmp18_ = _t_size;
							if (!(_tmp17_ < _tmp18_)) {
								break;
							}
							_tmp19_ = _t_list;
							_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _t_index);
							t = (BirdFontTool*) _tmp20_;
							_tmp22_ = t;
							if (bird_font_tool_tool_is_visible (_tmp22_)) {
								BirdFontTool* _tmp23_;
								_tmp23_ = t;
								_tmp21_ = bird_font_tool_is_over (_tmp23_, x, y);
							} else {
								_tmp21_ = FALSE;
							}
							if (_tmp21_) {
								BirdFontTool* _tmp30_;
								BirdFontTool* _tmp31_;
								if (dy < ((gdouble) 0)) {
									BirdFontTool* _tmp24_;
									BirdFontTool* _tmp25_;
									gboolean _tmp26_ = FALSE;
									_tmp24_ = t;
									_tmp25_ = t;
									g_signal_emit_by_name (_tmp24_, "scroll-wheel-up-action", _tmp25_, &_tmp26_);
									action = _tmp26_;
								} else {
									BirdFontTool* _tmp27_;
									BirdFontTool* _tmp28_;
									gboolean _tmp29_ = FALSE;
									_tmp27_ = t;
									_tmp28_ = t;
									g_signal_emit_by_name (_tmp27_, "scroll-wheel-down-action", _tmp28_, &_tmp29_);
									action = _tmp29_;
								}
								_tmp30_ = t;
								_tmp31_ = _g_object_ref0 (_tmp30_);
								_g_object_unref0 (self->press_tool);
								self->press_tool = _tmp31_;
							}
							_g_object_unref0 (t);
						}
					}
				}
				_g_object_unref0 (exp);
			}
			_g_object_unref0 (_exp_list);
		}
	}
	if (!action) {
		bird_font_toolbox_scroll_current_set (self, dy);
	}
	bird_font_toolbox_redraw_tool_box ();
}

static void
bird_font_toolbox_scroll_current_set (BirdFontToolbox* self,
                                      gdouble d)
{
	BirdFontToolCollection* _tmp0_;
	BirdFontToolCollection* _tmp1_;
	BirdFontToolCollection* _tmp2_;
	BirdFontToolCollection* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_toolbox_current_set;
	_tmp1_ = bird_font_toolbox_current_set;
	_tmp1_->scroll = _tmp1_->scroll + d;
	_tmp2_ = bird_font_toolbox_current_set;
	if (_tmp2_->scroll > ((gdouble) 0)) {
		BirdFontToolCollection* _tmp3_;
		_tmp3_ = bird_font_toolbox_current_set;
		_tmp3_->scroll = (gdouble) 0;
	}
	_tmp4_ = bird_font_toolbox_current_set;
	if (_tmp4_->content_height < ((gdouble) bird_font_toolbox_allocation_height)) {
		BirdFontToolCollection* _tmp5_;
		_tmp5_ = bird_font_toolbox_current_set;
		_tmp5_->scroll = (gdouble) 0;
	} else {
		BirdFontToolCollection* _tmp6_;
		BirdFontToolCollection* _tmp7_;
		_tmp6_ = bird_font_toolbox_current_set;
		_tmp7_ = bird_font_toolbox_current_set;
		if ((_tmp6_->content_height + _tmp7_->scroll) < ((gdouble) bird_font_toolbox_allocation_height)) {
			BirdFontToolCollection* _tmp8_;
			BirdFontToolCollection* _tmp9_;
			_tmp8_ = bird_font_toolbox_current_set;
			_tmp9_ = bird_font_toolbox_current_set;
			_tmp8_->scroll = bird_font_toolbox_allocation_height - _tmp9_->content_height;
		}
	}
	bird_font_toolbox_update_expanders (self);
	bird_font_toolbox_suppress_scroll (self);
}

void
bird_font_toolbox_scroll_up (BirdFontToolbox* self,
                             gdouble x,
                             gdouble y)
{
	g_return_if_fail (self != NULL);
	bird_font_toolbox_scroll_wheel (self, x, y, (gdouble) 0, (gdouble) 20);
}

void
bird_font_toolbox_scroll_down (BirdFontToolbox* self,
                               gdouble x,
                               gdouble y)
{
	g_return_if_fail (self != NULL);
	bird_font_toolbox_scroll_wheel (self, x, y, (gdouble) 0, (gdouble) -20);
}

static gboolean
__lambda503_ (BirdFontToolbox* self)
{
	gboolean result;
	self->priv->scrolling_toolbox = FALSE;
	result = FALSE;
	return result;
}

static gboolean
___lambda503__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda503_ ((BirdFontToolbox*) self);
	return result;
}

static void
bird_font_toolbox_suppress_scroll (BirdFontToolbox* self)
{
	g_return_if_fail (self != NULL);
	self->priv->scrolling_toolbox = TRUE;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, ___lambda503__gsource_func, g_object_ref (self), g_object_unref);
}

void
bird_font_toolbox_move (BirdFontToolbox* self,
                        gdouble x,
                        gdouble y)
{
	gboolean update = FALSE;
	gboolean a = FALSE;
	gboolean consumed = FALSE;
	gboolean active = FALSE;
	BirdFontToolCollection* _tmp0_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp39_ = FALSE;
	g_return_if_fail (self != NULL);
	consumed = FALSE;
	_tmp0_ = bird_font_toolbox_current_set;
	y = y - _tmp0_->scroll;
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _exp_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _exp_index = 0;
		_tmp1_ = bird_font_toolbox_current_set;
		_tmp2_ = bird_font_tool_collection_get_expanders (_tmp1_);
		_exp_list = _tmp2_;
		_tmp3_ = _exp_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_exp_size = _tmp5_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontExpander* _tmp10_;
			_exp_index = _exp_index + 1;
			_tmp6_ = _exp_index;
			_tmp7_ = _exp_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _exp_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _exp_index);
			exp = (BirdFontExpander*) _tmp9_;
			_tmp10_ = exp;
			if (_tmp10_->visible) {
				BirdFontExpander* _tmp11_;
				BirdFontExpander* _tmp12_;
				_tmp11_ = exp;
				a = bird_font_expander_is_over (_tmp11_, x, y);
				_tmp12_ = exp;
				update = bird_font_expander_set_active (_tmp12_, a);
				if (update) {
					BirdFontExpander* _tmp13_;
					BirdFontExpander* _tmp14_;
					BirdFontExpander* _tmp15_;
					BirdFontExpander* _tmp16_;
					BirdFontExpander* _tmp17_;
					BirdFontExpander* _tmp18_;
					_tmp13_ = exp;
					_tmp14_ = exp;
					_tmp15_ = exp;
					_tmp16_ = exp;
					_tmp17_ = exp;
					_tmp18_ = exp;
					g_signal_emit (self, bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_REDRAW_SIGNAL], 0, ((gint) _tmp13_->x) - 10, ((gint) _tmp14_->y) - 10, (gint) ((_tmp15_->x + _tmp16_->w) + 20), (gint) ((_tmp17_->y + _tmp18_->h) + 20));
				}
				{
					GeeArrayList* _t_list = NULL;
					BirdFontExpander* _tmp19_;
					GeeArrayList* _tmp20_;
					gint _t_size = 0;
					GeeArrayList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gint _t_index = 0;
					_tmp19_ = exp;
					_tmp20_ = _tmp19_->tool;
					_t_list = _tmp20_;
					_tmp21_ = _t_list;
					_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					_t_size = _tmp23_;
					_t_index = -1;
					while (TRUE) {
						gint _tmp24_;
						gint _tmp25_;
						BirdFontTool* t = NULL;
						GeeArrayList* _tmp26_;
						gpointer _tmp27_;
						BirdFontTool* _tmp28_;
						_t_index = _t_index + 1;
						_tmp24_ = _t_index;
						_tmp25_ = _t_size;
						if (!(_tmp24_ < _tmp25_)) {
							break;
						}
						_tmp26_ = _t_list;
						_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _t_index);
						t = (BirdFontTool*) _tmp27_;
						_tmp28_ = t;
						if (bird_font_tool_tool_is_visible (_tmp28_)) {
							BirdFontTool* _tmp29_;
							gboolean _tmp30_ = FALSE;
							BirdFontTool* _tmp34_;
							BirdFontTool* _tmp35_;
							BirdFontTool* _tmp36_;
							gboolean _tmp37_ = FALSE;
							_tmp29_ = t;
							active = bird_font_tool_is_over (_tmp29_, x, y);
							if (!active) {
								BirdFontTool* _tmp31_;
								_tmp31_ = t;
								_tmp30_ = bird_font_tool_is_active (_tmp31_);
							} else {
								_tmp30_ = FALSE;
							}
							if (_tmp30_) {
								BirdFontTool* _tmp32_;
								BirdFontTool* _tmp33_;
								_tmp32_ = t;
								_tmp33_ = t;
								g_signal_emit_by_name (_tmp32_, "move-out-action", _tmp33_);
							}
							_tmp34_ = t;
							update = bird_font_tool_set_active (_tmp34_, active);
							if (update) {
								g_signal_emit (self, bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_REDRAW_SIGNAL], 0, 0, 0, bird_font_toolbox_allocation_width, bird_font_toolbox_allocation_height);
							}
							_tmp35_ = t;
							_tmp36_ = t;
							g_signal_emit_by_name (_tmp35_, "panel-move-action", _tmp36_, x, y, &_tmp37_);
							if (_tmp37_) {
								consumed = TRUE;
							}
						}
						_g_object_unref0 (t);
					}
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
	if (self->priv->scrolling_touch) {
		_tmp39_ = !consumed;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		_tmp38_ = bird_font_bird_font_android;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		bird_font_toolbox_scroll_current_set (self, y - self->priv->scroll_y);
		self->priv->scroll_y = y;
		bird_font_toolbox_redraw_tool_box ();
	}
}

void
bird_font_toolbox_redraw_tool_box (void)
{
	BirdFontToolbox* t = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Don't redraw toolbox when background thread is running.");
		return;
	}
	_tmp0_ = bird_font_main_window_get_toolbox ();
	t = _tmp0_;
	_tmp1_ = t;
	if (!bird_font_is_null (_tmp1_)) {
		BirdFontToolbox* _tmp2_;
		_tmp2_ = t;
		g_signal_emit (_tmp2_, bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_REDRAW_SIGNAL], 0, 0, 0, bird_font_toolbox_allocation_width, bird_font_toolbox_allocation_height);
	}
	_g_object_unref0 (t);
}

void
bird_font_toolbox_reset_active_tool (BirdFontToolbox* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _exp_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _exp_index = 0;
		_tmp0_ = bird_font_toolbox_current_set;
		_tmp1_ = bird_font_tool_collection_get_expanders (_tmp0_);
		_exp_list = _tmp1_;
		_tmp2_ = _exp_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_exp_size = _tmp4_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_exp_index = _exp_index + 1;
			_tmp5_ = _exp_index;
			_tmp6_ = _exp_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _exp_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _exp_index);
			exp = (BirdFontExpander*) _tmp8_;
			{
				GeeArrayList* _t_list = NULL;
				BirdFontExpander* _tmp9_;
				GeeArrayList* _tmp10_;
				gint _t_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _t_index = 0;
				_tmp9_ = exp;
				_tmp10_ = _tmp9_->tool;
				_t_list = _tmp10_;
				_tmp11_ = _t_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_t_size = _tmp13_;
				_t_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					BirdFontTool* t = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					BirdFontTool* _tmp18_;
					_t_index = _t_index + 1;
					_tmp14_ = _t_index;
					_tmp15_ = _t_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _t_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _t_index);
					t = (BirdFontTool*) _tmp17_;
					_tmp18_ = t;
					bird_font_tool_set_active (_tmp18_, FALSE);
					_g_object_unref0 (t);
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
}

BirdFontTool*
bird_font_toolbox_get_active_tool (BirdFontToolbox* self)
{
	BirdFontTool* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _exp_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _exp_index = 0;
		_tmp0_ = bird_font_toolbox_current_set;
		_tmp1_ = bird_font_tool_collection_get_expanders (_tmp0_);
		_exp_list = _tmp1_;
		_tmp2_ = _exp_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_exp_size = _tmp4_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			_exp_index = _exp_index + 1;
			_tmp5_ = _exp_index;
			_tmp6_ = _exp_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _exp_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _exp_index);
			exp = (BirdFontExpander*) _tmp8_;
			{
				GeeArrayList* _t_list = NULL;
				BirdFontExpander* _tmp9_;
				GeeArrayList* _tmp10_;
				gint _t_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _t_index = 0;
				_tmp9_ = exp;
				_tmp10_ = _tmp9_->tool;
				_t_list = _tmp10_;
				_tmp11_ = _t_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_t_size = _tmp13_;
				_t_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					BirdFontTool* t = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					BirdFontTool* _tmp18_;
					_t_index = _t_index + 1;
					_tmp14_ = _t_index;
					_tmp15_ = _t_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _t_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _t_index);
					t = (BirdFontTool*) _tmp17_;
					_tmp18_ = t;
					if (bird_font_tool_is_active (_tmp18_)) {
						result = t;
						_g_object_unref0 (exp);
						_g_object_unref0 (_exp_list);
						return result;
					}
					_g_object_unref0 (t);
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
	result = NULL;
	return result;
}

void
bird_font_toolbox_set_current_tool (BirdFontToolbox* self,
                                    BirdFontTool* tool)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	if (tool->editor_events) {
		BirdFontToolCollection* _tmp0_;
		_tmp0_ = bird_font_toolbox_current_set;
		bird_font_tool_collection_set_current_tool (_tmp0_, tool);
	}
}

BirdFontTool*
bird_font_toolbox_get_current_tool (BirdFontToolbox* self)
{
	BirdFontToolCollection* _tmp0_;
	BirdFontTool* _tmp1_;
	BirdFontTool* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_toolbox_current_set;
	_tmp1_ = bird_font_tool_collection_get_current_tool (_tmp0_);
	result = _tmp1_;
	return result;
}

void
bird_font_toolbox_select_tool (BirdFontToolbox* self,
                               BirdFontTool* tool)
{
	gboolean update = FALSE;
	gint offset_y = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	{
		GeeArrayList* _exp_list = NULL;
		BirdFontToolCollection* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _exp_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _exp_index = 0;
		_tmp0_ = bird_font_toolbox_current_set;
		_tmp1_ = bird_font_tool_collection_get_expanders (_tmp0_);
		_exp_list = _tmp1_;
		_tmp2_ = _exp_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_exp_size = _tmp4_;
		_exp_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontExpander* exp = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontExpander* _tmp9_;
			_exp_index = _exp_index + 1;
			_tmp5_ = _exp_index;
			_tmp6_ = _exp_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _exp_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _exp_index);
			exp = (BirdFontExpander*) _tmp8_;
			_tmp9_ = exp;
			if (_tmp9_->visible) {
				{
					GeeArrayList* _t_list = NULL;
					BirdFontExpander* _tmp10_;
					GeeArrayList* _tmp11_;
					gint _t_size = 0;
					GeeArrayList* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gint _t_index = 0;
					_tmp10_ = exp;
					_tmp11_ = _tmp10_->tool;
					_t_list = _tmp11_;
					_tmp12_ = _t_list;
					_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
					_tmp14_ = _tmp13_;
					_t_size = _tmp14_;
					_t_index = -1;
					while (TRUE) {
						gint _tmp15_;
						gint _tmp16_;
						BirdFontTool* t = NULL;
						GeeArrayList* _tmp17_;
						gpointer _tmp18_;
						BirdFontTool* _tmp19_;
						_t_index = _t_index + 1;
						_tmp15_ = _t_index;
						_tmp16_ = _t_size;
						if (!(_tmp15_ < _tmp16_)) {
							break;
						}
						_tmp17_ = _t_list;
						_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _t_index);
						t = (BirdFontTool*) _tmp18_;
						_tmp19_ = t;
						if (bird_font_tool_get_id (tool) == bird_font_tool_get_id (_tmp19_)) {
							BirdFontTool* _tmp20_;
							_tmp20_ = t;
							if (!bird_font_tool_tool_is_visible (_tmp20_)) {
								g_warning ("Toolbox.vala:401: Tool is hidden");
							} else {
								update = FALSE;
								update = bird_font_tool_set_selected (tool, TRUE);
								if (tool->persistent) {
									update = bird_font_tool_set_active (tool, TRUE);
								}
								g_signal_emit_by_name (tool, "select-action", tool);
								if (update) {
									BirdFontExpander* _tmp21_;
									BirdFontExpander* _tmp22_;
									_tmp21_ = exp;
									offset_y = (gint) (_tmp21_->y - self->priv->scroll_y);
									_tmp22_ = exp;
									g_signal_emit (self, bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_REDRAW_SIGNAL], 0, ((gint) _tmp22_->x) - 10, ((gint) offset_y) - 10, bird_font_toolbox_allocation_width, (gint) ((bird_font_toolbox_allocation_height - offset_y) + 10));
								}
								bird_font_toolbox_set_current_tool (self, tool);
							}
						}
						_g_object_unref0 (t);
					}
				}
			}
			_g_object_unref0 (exp);
		}
		_g_object_unref0 (_exp_list);
	}
}

BirdFontTool*
bird_font_toolbox_get_tool (BirdFontToolbox* self,
                            const gchar* name)
{
	BirdFontTool* _tmp30_;
	BirdFontTool* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeArrayList* _tc_list = NULL;
		GeeArrayList* _tmp0_;
		gint _tc_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tc_index = 0;
		_tmp0_ = self->tool_sets;
		_tc_list = _tmp0_;
		_tmp1_ = _tc_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tc_size = _tmp3_;
		_tc_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontToolCollection* tc = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_tc_index = _tc_index + 1;
			_tmp4_ = _tc_index;
			_tmp5_ = _tc_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _tc_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tc_index);
			tc = (BirdFontToolCollection*) _tmp7_;
			{
				GeeArrayList* _e_list = NULL;
				BirdFontToolCollection* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _e_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _e_index = 0;
				_tmp8_ = tc;
				_tmp9_ = bird_font_tool_collection_get_expanders (_tmp8_);
				_e_list = _tmp9_;
				_tmp10_ = _e_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_e_size = _tmp12_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					BirdFontExpander* e = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					_e_index = _e_index + 1;
					_tmp13_ = _e_index;
					_tmp14_ = _e_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _e_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _e_index);
					e = (BirdFontExpander*) _tmp16_;
					{
						GeeArrayList* _t_list = NULL;
						BirdFontExpander* _tmp17_;
						GeeArrayList* _tmp18_;
						gint _t_size = 0;
						GeeArrayList* _tmp19_;
						gint _tmp20_;
						gint _tmp21_;
						gint _t_index = 0;
						_tmp17_ = e;
						_tmp18_ = _tmp17_->tool;
						_t_list = _tmp18_;
						_tmp19_ = _t_list;
						_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
						_tmp21_ = _tmp20_;
						_t_size = _tmp21_;
						_t_index = -1;
						while (TRUE) {
							gint _tmp22_;
							gint _tmp23_;
							BirdFontTool* t = NULL;
							GeeArrayList* _tmp24_;
							gpointer _tmp25_;
							BirdFontTool* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
							gboolean _tmp29_;
							_t_index = _t_index + 1;
							_tmp22_ = _t_index;
							_tmp23_ = _t_size;
							if (!(_tmp22_ < _tmp23_)) {
								break;
							}
							_tmp24_ = _t_list;
							_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _t_index);
							t = (BirdFontTool*) _tmp25_;
							_tmp26_ = t;
							_tmp27_ = bird_font_tool_get_name (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = g_strcmp0 (_tmp28_, name) == 0;
							_g_free0 (_tmp28_);
							if (_tmp29_) {
								result = t;
								_g_object_unref0 (e);
								_g_object_unref0 (_e_list);
								_g_object_unref0 (tc);
								return result;
							}
							_g_object_unref0 (t);
						}
					}
					_g_object_unref0 (e);
				}
				_g_object_unref0 (_e_list);
			}
			_g_object_unref0 (tc);
		}
	}
	g_warning ("Toolbox.vala:436: No tool found for name \"%s\".\n", name);
	_tmp30_ = bird_font_tool_new ("no_icon", "");
	result = _tmp30_;
	return result;
}

void
bird_font_toolbox_set_tool_visible (const gchar* name,
                                    gboolean visible)
{
	BirdFontToolbox* tb = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontTool* t = NULL;
	BirdFontTool* _tmp1_;
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	tb = _tmp0_;
	_tmp1_ = bird_font_toolbox_get_tool (tb, name);
	t = _tmp1_;
	bird_font_tool_set_tool_visibility (t, visible);
	bird_font_toolbox_update_expanders (tb);
	bird_font_toolbox_redraw_tool_box ();
	_g_object_unref0 (t);
	_g_object_unref0 (tb);
}

void
bird_font_toolbox_select_tool_by_name (const gchar* name)
{
	BirdFontToolbox* b = NULL;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	BirdFontToolbox* _tmp2_;
	BirdFontToolbox* _tmp3_;
	BirdFontTool* _tmp4_;
	BirdFontTool* _tmp5_;
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_main_window_get_toolbox ();
	b = _tmp0_;
	_tmp1_ = b;
	if (bird_font_is_null (_tmp1_)) {
		_g_object_unref0 (b);
		return;
	}
	_tmp2_ = b;
	_tmp3_ = b;
	_tmp4_ = bird_font_toolbox_get_tool (_tmp3_, name);
	_tmp5_ = _tmp4_;
	bird_font_toolbox_select_tool (_tmp2_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (b);
}

gdouble
bird_font_toolbox_get_scale (void)
{
	gdouble result;
	result = bird_font_main_window_units;
	return result;
}

void
bird_font_toolbox_set_default_tool_size (BirdFontToolbox* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp0_;
		gint _t_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _t_index = 0;
		_tmp0_ = self->tool_sets;
		_t_list = _tmp0_;
		_tmp1_ = _t_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_t_size = _tmp3_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontToolCollection* t = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_t_index = _t_index + 1;
			_tmp4_ = _t_index;
			_tmp5_ = _t_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _t_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _t_index);
			t = (BirdFontToolCollection*) _tmp7_;
			{
				GeeArrayList* _e_list = NULL;
				BirdFontToolCollection* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _e_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _e_index = 0;
				_tmp8_ = t;
				_tmp9_ = bird_font_tool_collection_get_expanders (_tmp8_);
				_e_list = _tmp9_;
				_tmp10_ = _e_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_e_size = _tmp12_;
				_e_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					BirdFontExpander* e = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					BirdFontExpander* _tmp17_;
					_e_index = _e_index + 1;
					_tmp13_ = _e_index;
					_tmp14_ = _e_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _e_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _e_index);
					e = (BirdFontExpander*) _tmp16_;
					_tmp17_ = e;
					bird_font_expander_update_tool_position (_tmp17_);
					_g_object_unref0 (e);
				}
				_g_object_unref0 (_e_list);
			}
			_g_object_unref0 (t);
		}
	}
}

void
bird_font_toolbox_update_expanders (BirdFontToolbox* self)
{
	gdouble pos = 0.0;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _e_list = NULL;
		BirdFontToolCollection* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_toolbox_current_set;
		_tmp1_ = bird_font_tool_collection_get_expanders (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontExpander* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontExpander* _tmp9_;
			BirdFontToolCollection* _tmp10_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontExpander*) _tmp8_;
			_tmp9_ = e;
			_tmp10_ = bird_font_toolbox_current_set;
			bird_font_expander_set_scroll (_tmp9_, _tmp10_->scroll);
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	pos = 4 * bird_font_toolbox_get_scale ();
	{
		GeeArrayList* _e_list = NULL;
		BirdFontToolCollection* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _e_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _e_index = 0;
		_tmp11_ = bird_font_toolbox_current_set;
		_tmp12_ = bird_font_tool_collection_get_expanders (_tmp11_);
		_e_list = _tmp12_;
		_tmp13_ = _e_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_e_size = _tmp15_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			BirdFontExpander* e = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			BirdFontExpander* _tmp20_;
			_e_index = _e_index + 1;
			_tmp16_ = _e_index;
			_tmp17_ = _e_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _e_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _e_index);
			e = (BirdFontExpander*) _tmp19_;
			_tmp20_ = e;
			if (_tmp20_->visible) {
				BirdFontExpander* _tmp21_;
				BirdFontExpander* _tmp22_;
				BirdFontToolCollection* _tmp23_;
				_tmp21_ = e;
				bird_font_expander_set_offset (_tmp21_, pos);
				_tmp22_ = e;
				pos += bird_font_expander_get_content_height (_tmp22_) + (4 * bird_font_toolbox_get_scale ());
				_tmp23_ = bird_font_toolbox_current_set;
				_tmp23_->content_height = pos;
				if (bird_font_bird_font_android) {
					BirdFontToolCollection* _tmp24_;
					BirdFontToolCollection* _tmp25_;
					_tmp24_ = bird_font_toolbox_current_set;
					_tmp25_ = bird_font_toolbox_current_set;
					_tmp25_->content_height = _tmp25_->content_height * 1.15;
				}
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_list);
	}
	{
		GeeArrayList* _e_list = NULL;
		BirdFontToolCollection* _tmp26_;
		GeeArrayList* _tmp27_;
		gint _e_size = 0;
		GeeArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _e_index = 0;
		_tmp26_ = bird_font_toolbox_current_set;
		_tmp27_ = bird_font_tool_collection_get_expanders (_tmp26_);
		_e_list = _tmp27_;
		_tmp28_ = _e_list;
		_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_e_size = _tmp30_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			BirdFontExpander* e = NULL;
			GeeArrayList* _tmp33_;
			gpointer _tmp34_;
			BirdFontExpander* _tmp35_;
			_e_index = _e_index + 1;
			_tmp31_ = _e_index;
			_tmp32_ = _e_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _e_list;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _e_index);
			e = (BirdFontExpander*) _tmp34_;
			_tmp35_ = e;
			bird_font_expander_set_active (_tmp35_, FALSE);
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_list);
	}
}

static void
bird_font_toolbox_draw_expanders (BirdFontToolbox* self,
                                  gint w,
                                  gint h,
                                  cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	{
		GeeArrayList* _e_list = NULL;
		BirdFontToolCollection* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_toolbox_current_set;
		_tmp1_ = bird_font_tool_collection_get_expanders (_tmp0_);
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontExpander* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontExpander* _tmp9_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontExpander*) _tmp8_;
			_tmp9_ = e;
			if (_tmp9_->visible) {
				BirdFontExpander* _tmp10_;
				_tmp10_ = e;
				bird_font_expander_draw (_tmp10_, cr);
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_list);
	}
}

void
bird_font_toolbox_draw (BirdFontToolbox* self,
                        gint w,
                        gint h,
                        cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	bird_font_theme_color (cr, "Default Background");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	cairo_set_line_width (cr, (gdouble) 0);
	cairo_fill (cr);
	bird_font_toolbox_draw_expanders (self, w, h, cr);
	cairo_restore (cr);
	bird_font_toolbox_draw_tool_tip (self, cr);
}

static void
bird_font_toolbox_draw_tool_tip (BirdFontToolbox* self,
                                 cairo_t* cr)
{
	BirdFontTextArea* t = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp1_ = self->priv->tool_tip;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->tool_tip;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontTextArea* _tmp3_;
		BirdFontTextArea* _tmp4_;
		BirdFontWidgetAllocation* _tmp5_;
		BirdFontTextArea* _tmp6_;
		BirdFontTextArea* _tmp7_;
		const gchar* _tmp8_;
		BirdFontTextArea* _tmp9_;
		BirdFontTextArea* _tmp10_;
		BirdFontTextArea* _tmp11_;
		BirdFontTextArea* _tmp12_;
		BirdFontTextArea* _tmp13_;
		BirdFontTextArea* _tmp14_;
		BirdFontTextArea* _tmp15_;
		BirdFontTextArea* _tmp16_;
		BirdFontTextArea* _tmp18_;
		_tmp3_ = bird_font_text_area_new (17 * bird_font_toolbox_get_scale (), NULL);
		_g_object_unref0 (t);
		t = _tmp3_;
		_tmp4_ = t;
		_tmp5_ = bird_font_widget_allocation_new_for_area (0, 0, bird_font_toolbox_allocation_width, bird_font_toolbox_allocation_height);
		_g_object_unref0 (((BirdFontWidget*) _tmp4_)->allocation);
		((BirdFontWidget*) _tmp4_)->allocation = _tmp5_;
		_tmp6_ = t;
		bird_font_text_area_set_editable (_tmp6_, FALSE);
		_tmp7_ = t;
		_tmp8_ = self->priv->tool_tip;
		bird_font_text_area_set_text (_tmp7_, (const gchar*) _tmp8_);
		_tmp9_ = t;
		_tmp9_->width = bird_font_toolbox_allocation_width - (20 * bird_font_toolbox_get_scale ());
		_tmp10_ = t;
		_tmp10_->min_height = 17 * bird_font_toolbox_get_scale ();
		_tmp11_ = t;
		_tmp11_->height = 17 * bird_font_toolbox_get_scale ();
		_tmp12_ = t;
		bird_font_widget_layout ((BirdFontWidget*) _tmp12_);
		_tmp13_ = t;
		((BirdFontWidget*) _tmp13_)->widget_x = 10 * bird_font_toolbox_get_scale ();
		_tmp14_ = t;
		_tmp15_ = t;
		((BirdFontWidget*) _tmp14_)->widget_y = (self->priv->tool_tip_y - _tmp15_->height) - (5 * bird_font_toolbox_get_scale ());
		_tmp16_ = t;
		if (((BirdFontWidget*) _tmp16_)->widget_y < ((gdouble) 5)) {
			BirdFontTextArea* _tmp17_;
			_tmp17_ = t;
			((BirdFontWidget*) _tmp17_)->widget_y = (gdouble) 5;
		}
		_tmp18_ = t;
		bird_font_widget_draw ((BirdFontWidget*) _tmp18_, cr);
	}
	_g_object_unref0 (t);
}

void
bird_font_toolbox_hide_tooltip (BirdFontToolbox* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tool_tip;
	if (_tmp0_ != NULL) {
		_g_free0 (self->priv->tool_tip);
		self->priv->tool_tip = NULL;
		bird_font_toolbox_redraw_tool_box ();
	}
}

void
bird_font_toolbox_show_tooltip (BirdFontToolbox* self,
                                const gchar* tool_tip,
                                gdouble x,
                                gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool_tip != NULL);
	if (g_strcmp0 (tool_tip, "") != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (tool_tip);
		_g_free0 (self->priv->tool_tip);
		self->priv->tool_tip = _tmp0_;
		self->priv->tool_tip_x = x;
		self->priv->tool_tip_y = y;
		bird_font_toolbox_redraw_tool_box ();
	}
}

void
bird_font_toolbox_set_current_tool_set (BirdFontToolbox* self,
                                        BirdFontToolCollection* ts)
{
	BirdFontToolCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ts != NULL);
	_tmp0_ = _g_object_ref0 (ts);
	_g_object_unref0 (bird_font_toolbox_current_set);
	bird_font_toolbox_current_set = _tmp0_;
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static inline gpointer
bird_font_toolbox_empty_set_get_instance_private (BirdFontToolboxEmptySet* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontToolboxEmptySet_private_offset);
}

BirdFontToolboxEmptySet*
bird_font_toolbox_empty_set_construct (GType object_type)
{
	BirdFontToolboxEmptySet * self = NULL;
	GeeArrayList* _tmp0_;
	self = (BirdFontToolboxEmptySet*) bird_font_tool_collection_construct (object_type);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_EXPANDER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->expanders);
	self->priv->expanders = _tmp0_;
	return self;
}

BirdFontToolboxEmptySet*
bird_font_toolbox_empty_set_new (void)
{
	return bird_font_toolbox_empty_set_construct (BIRD_FONT_TOOLBOX_TYPE_EMPTY_SET);
}

static GeeArrayList*
bird_font_toolbox_empty_set_real_get_expanders (BirdFontToolCollection* base)
{
	BirdFontToolboxEmptySet * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontToolboxEmptySet*) base;
	_tmp0_ = self->priv->expanders;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_toolbox_empty_set_class_init (BirdFontToolboxEmptySetClass * klass,
                                        gpointer klass_data)
{
	bird_font_toolbox_empty_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontToolboxEmptySet_private_offset);
	((BirdFontToolCollectionClass *) klass)->get_expanders = (GeeArrayList* (*) (BirdFontToolCollection*)) bird_font_toolbox_empty_set_real_get_expanders;
	G_OBJECT_CLASS (klass)->finalize = bird_font_toolbox_empty_set_finalize;
}

static void
bird_font_toolbox_empty_set_instance_init (BirdFontToolboxEmptySet * self,
                                           gpointer klass)
{
	self->priv = bird_font_toolbox_empty_set_get_instance_private (self);
}

static void
bird_font_toolbox_empty_set_finalize (GObject * obj)
{
	BirdFontToolboxEmptySet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TOOLBOX_TYPE_EMPTY_SET, BirdFontToolboxEmptySet);
	_g_object_unref0 (self->priv->expanders);
	G_OBJECT_CLASS (bird_font_toolbox_empty_set_parent_class)->finalize (obj);
}

static GType
bird_font_toolbox_empty_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontToolboxEmptySetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_toolbox_empty_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontToolboxEmptySet), 0, (GInstanceInitFunc) bird_font_toolbox_empty_set_instance_init, NULL };
	GType bird_font_toolbox_empty_set_type_id;
	bird_font_toolbox_empty_set_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL_COLLECTION, "BirdFontToolboxEmptySet", &g_define_type_info, 0);
	BirdFontToolboxEmptySet_private_offset = g_type_add_instance_private (bird_font_toolbox_empty_set_type_id, sizeof (BirdFontToolboxEmptySetPrivate));
	return bird_font_toolbox_empty_set_type_id;
}

GType
bird_font_toolbox_empty_set_get_type (void)
{
	static volatile gsize bird_font_toolbox_empty_set_type_id__once = 0;
	if (g_once_init_enter (&bird_font_toolbox_empty_set_type_id__once)) {
		GType bird_font_toolbox_empty_set_type_id;
		bird_font_toolbox_empty_set_type_id = bird_font_toolbox_empty_set_get_type_once ();
		g_once_init_leave (&bird_font_toolbox_empty_set_type_id__once, bird_font_toolbox_empty_set_type_id);
	}
	return bird_font_toolbox_empty_set_type_id__once;
}

static void
bird_font_toolbox_class_init (BirdFontToolboxClass * klass,
                              gpointer klass_data)
{
	bird_font_toolbox_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontToolbox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_toolbox_finalize;
	bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_REDRAW_SIGNAL] = g_signal_new ("redraw", BIRD_FONT_TYPE_TOOLBOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	bird_font_toolbox_signals[BIRD_FONT_TOOLBOX_NEW_TOOL_SET_SIGNAL] = g_signal_new ("new-tool-set", BIRD_FONT_TYPE_TOOLBOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_TAB);
}

static void
bird_font_toolbox_instance_init (BirdFontToolbox * self,
                                 gpointer klass)
{
	self->priv = bird_font_toolbox_get_instance_private (self);
	self->priv->scrolling_toolbox = FALSE;
	self->priv->scrolling_touch = FALSE;
	self->priv->scroll_y = (gdouble) 0;
	self->priv->tool_tip = NULL;
	self->priv->tool_tip_x = (gdouble) 0;
	self->priv->tool_tip_y = (gdouble) 0;
	self->priv->suppress_event = FALSE;
}

static void
bird_font_toolbox_finalize (GObject * obj)
{
	BirdFontToolbox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TOOLBOX, BirdFontToolbox);
	_g_object_unref0 (self->press_tool);
	_g_object_unref0 (self->tool_sets);
	_g_free0 (self->priv->tool_tip);
	G_OBJECT_CLASS (bird_font_toolbox_parent_class)->finalize (obj);
}

static GType
bird_font_toolbox_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontToolboxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_toolbox_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontToolbox), 0, (GInstanceInitFunc) bird_font_toolbox_instance_init, NULL };
	GType bird_font_toolbox_type_id;
	bird_font_toolbox_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontToolbox", &g_define_type_info, 0);
	BirdFontToolbox_private_offset = g_type_add_instance_private (bird_font_toolbox_type_id, sizeof (BirdFontToolboxPrivate));
	return bird_font_toolbox_type_id;
}

GType
bird_font_toolbox_get_type (void)
{
	static volatile gsize bird_font_toolbox_type_id__once = 0;
	if (g_once_init_enter (&bird_font_toolbox_type_id__once)) {
		GType bird_font_toolbox_type_id;
		bird_font_toolbox_type_id = bird_font_toolbox_get_type_once ();
		g_once_init_leave (&bird_font_toolbox_type_id__once, bird_font_toolbox_type_id);
	}
	return bird_font_toolbox_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

