/* TextArea.c generated by valac 0.56.16, the Vala compiler
 * generated from TextArea.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdio.h>

#define BIRD_FONT_TEXT_AREA_DONE -2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TEXT_AREA_0_PROPERTY,
	BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY,
	BIRD_FONT_TEXT_AREA_NUM_PROPERTIES
};
static GParamSpec* bird_font_text_area_properties[BIRD_FONT_TEXT_AREA_NUM_PROPERTIES];
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block90Data Block90Data;
typedef struct _Block91Data Block91Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block92Data Block92Data;
typedef struct _Block93Data Block93Data;
typedef struct _Block94Data Block94Data;
typedef struct _Block95Data Block95Data;
typedef struct _Block96Data Block96Data;
enum  {
	BIRD_FONT_TEXT_AREA_TEXT_UNDO_ITEM_0_PROPERTY,
	BIRD_FONT_TEXT_AREA_TEXT_UNDO_ITEM_NUM_PROPERTIES
};
static GParamSpec* bird_font_text_area_text_undo_item_properties[BIRD_FONT_TEXT_AREA_TEXT_UNDO_ITEM_NUM_PROPERTIES];
enum  {
	BIRD_FONT_TEXT_AREA_PARAGRAPH_0_PROPERTY,
	BIRD_FONT_TEXT_AREA_PARAGRAPH_WORDS_PROPERTY,
	BIRD_FONT_TEXT_AREA_PARAGRAPH_NUM_PROPERTIES
};
static GParamSpec* bird_font_text_area_paragraph_properties[BIRD_FONT_TEXT_AREA_PARAGRAPH_NUM_PROPERTIES];
enum  {
	BIRD_FONT_TEXT_AREA_CARRET_0_PROPERTY,
	BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY,
	BIRD_FONT_TEXT_AREA_CARRET_NUM_PROPERTIES
};
static GParamSpec* bird_font_text_area_carret_properties[BIRD_FONT_TEXT_AREA_CARRET_NUM_PROPERTIES];
enum  {
	BIRD_FONT_TEXT_AREA_SCROLL_SIGNAL,
	BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL,
	BIRD_FONT_TEXT_AREA_ENTER_SIGNAL,
	BIRD_FONT_TEXT_AREA_NUM_SIGNALS
};
static guint bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_NUM_SIGNALS] = {0};

struct _BirdFontTextAreaPrivate {
	BirdFontTextAreaCarret* carret;
	BirdFontTextAreaCarret* selection_end;
	gboolean update_selection;
	GeeArrayList* paragraphs;
	gint last_paragraph;
	gchar* text;
	gint text_length;
	GeeArrayList* undo_items;
	GeeArrayList* redo_items;
	gboolean store_undo_state_at_next_event;
};

struct _Block90Data {
	int _ref_count_;
	BirdFontTextArea* self;
	gint i;
	gdouble tx;
	gint ch_index;
	gdouble min_d;
	BirdFontTextAreaCarret* c;
	gdouble click_x;
};

struct _Block91Data {
	int _ref_count_;
	Block90Data * _data90_;
	BirdFontText* next_word;
};

struct _Block92Data {
	int _ref_count_;
	BirdFontTextArea* self;
	gdouble scale;
	BirdFontTextAreaCarret* selection_start;
	BirdFontTextAreaCarret* selection_stop;
	cairo_t* cr;
};

struct _Block93Data {
	int _ref_count_;
	Block92Data * _data92_;
	BirdFontText* next_word;
	gboolean partial_start;
	gboolean partial_stop;
};

struct _Block94Data {
	int _ref_count_;
	Block93Data * _data93_;
	gint index;
	gdouble bx;
};

struct _Block95Data {
	int _ref_count_;
	BirdFontTextArea* self;
	gdouble tx;
	gdouble ty;
	gint ch_index;
	gdouble pos_x;
	gdouble pos_y;
	BirdFontTextAreaCarret* carret;
};

struct _Block96Data {
	int _ref_count_;
	Block95Data * _data95_;
	BirdFontText* next_word;
};

struct _BirdFontTextAreaParagraphPrivate {
	GeeArrayList* words_in_paragraph;
	gdouble font_size;
	BirdFontColor* text_color;
};

struct _BirdFontTextAreaCarretPrivate {
	gint ci;
};

static gint BirdFontTextArea_private_offset;
static gpointer bird_font_text_area_parent_class = NULL;
static gpointer bird_font_text_area_text_undo_item_parent_class = NULL;
static gint BirdFontTextAreaParagraph_private_offset;
static gpointer bird_font_text_area_paragraph_parent_class = NULL;
static gint BirdFontTextAreaCarret_private_offset;
static gpointer bird_font_text_area_carret_parent_class = NULL;

static void bird_font_text_area_real_focus (BirdFontWidget* base,
                                     gboolean focus);
static gdouble bird_font_text_area_real_get_height (BirdFontWidget* base);
static gdouble bird_font_text_area_real_get_width (BirdFontWidget* base);
static gboolean bird_font_text_area_generate_paragraphs (BirdFontTextArea* self);
static void bird_font_text_area_generate_all_paragraphs (BirdFontTextArea* self);
static void bird_font_text_area_real_key_press (BirdFontWidget* base,
                                         guint keyval);
static void bird_font_text_area_add_character (BirdFontTextArea* self,
                                        guint keyval);
static void bird_font_text_area_check_selection (BirdFontTextArea* self);
VALA_EXTERN gboolean bird_font_is_modifier_key (guint i);
static BirdFontTextAreaParagraph* bird_font_text_area_get_current_paragraph (BirdFontTextArea* self);
static BirdFontTextAreaCarret* bird_font_text_area_get_selection_start (BirdFontTextArea* self);
static BirdFontTextAreaCarret* bird_font_text_area_get_selection_stop (BirdFontTextArea* self);
static void bird_font_text_area_update_paragraph_index (BirdFontTextArea* self);
static gunichar bird_font_text_area_move_carret_one_character (BirdFontTextArea* self);
static gunichar bird_font_text_area_move_carret_back_one_character (BirdFontTextArea* self);
static BirdFontTextAreaCarret* bird_font_text_area_get_carret_at (BirdFontTextArea* self,
                                                           gdouble click_x,
                                                           gdouble click_y,
                                                           gboolean check_boundaries);
static gboolean bird_font_text_area_selection_is_visible (BirdFontTextArea* self);
static Block90Data* block90_data_ref (Block90Data* _data90_);
static void block90_data_unref (void * _userdata_);
static Block91Data* block91_data_ref (Block91Data* _data91_);
static void block91_data_unref (void * _userdata_);
static void __________lambda511_ (Block91Data* _data91_,
                           BirdFontGlyph* glyph,
                           gdouble kerning,
                           gboolean last);
static void ___________lambda511__bird_font_text_iterator (BirdFontGlyph* glyph,
                                                    gdouble kerning,
                                                    gboolean last,
                                                    gpointer self);
static void bird_font_text_area_real_layout (BirdFontWidget* base);
static void bird_font_text_area_real_button_press (BirdFontWidget* base,
                                            guint button,
                                            gdouble x,
                                            gdouble y);
static void bird_font_text_area_real_button_release (BirdFontWidget* base,
                                              guint button,
                                              gdouble x,
                                              gdouble y);
static gboolean bird_font_text_area_real_motion (BirdFontWidget* base,
                                          gdouble x,
                                          gdouble y);
static void bird_font_text_area_real_draw (BirdFontWidget* base,
                                    cairo_t* cr);
static Block92Data* block92_data_ref (Block92Data* _data92_);
static void block92_data_unref (void * _userdata_);
static Block93Data* block93_data_ref (Block93Data* _data93_);
static void block93_data_unref (void * _userdata_);
static Block94Data* block94_data_ref (Block94Data* _data94_);
static void block94_data_unref (void * _userdata_);
static void __________lambda182_ (Block94Data* _data94_,
                           BirdFontGlyph* glyph,
                           gdouble kerning,
                           gboolean last);
static void ___________lambda182__bird_font_text_iterator (BirdFontGlyph* glyph,
                                                    gdouble kerning,
                                                    gboolean last,
                                                    gpointer self);
static void bird_font_text_area_draw_carret_at (BirdFontTextArea* self,
                                         cairo_t* cr,
                                         gdouble x,
                                         gdouble y);
static void bird_font_text_area_get_carret_position (BirdFontTextArea* self,
                                              BirdFontTextAreaCarret* carret,
                                              gdouble* carret_x,
                                              gdouble* carret_y);
static Block95Data* block95_data_ref (Block95Data* _data95_);
static void block95_data_unref (void * _userdata_);
static Block96Data* block96_data_ref (Block96Data* _data96_);
static void block96_data_unref (void * _userdata_);
static void _______lambda183_ (Block96Data* _data96_,
                        BirdFontGlyph* glyph,
                        gdouble kerning,
                        gboolean last);
static void ________lambda183__bird_font_text_iterator (BirdFontGlyph* glyph,
                                                 gdouble kerning,
                                                 gboolean last,
                                                 gpointer self);
static gint ___lambda507_ (BirdFontTextArea* self,
                    BirdFontTextAreaParagraph* a,
                    BirdFontTextAreaParagraph* b);
static gint ____lambda507__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ___lambda508_ (BirdFontTextArea* self,
                    BirdFontTextAreaParagraph* a,
                    BirdFontTextAreaParagraph* b);
static gint ____lambda508__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ___lambda509_ (BirdFontTextArea* self,
                    BirdFontTextAreaParagraph* a,
                    BirdFontTextAreaParagraph* b);
static gint ____lambda509__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ___lambda510_ (BirdFontTextArea* self,
                    BirdFontTextAreaParagraph* a,
                    BirdFontTextAreaParagraph* b);
static gint ____lambda510__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static void bird_font_text_area_real_double_click (BirdFontWidget* base,
                                            guint button,
                                            gdouble x,
                                            gdouble y);
static void bird_font_text_area_text_undo_item_finalize (GObject * obj);
static GType bird_font_text_area_text_undo_item_get_type_once (void);
static void bird_font_text_area_paragraph_generate_words (BirdFontTextAreaParagraph* self);
static gchar* bird_font_text_area_paragraph_get_next_word (BirdFontTextAreaParagraph* self,
                                                    gboolean* carret_at_end_of_word,
                                                    gint* iter_pos,
                                                    gint carret);
static void bird_font_text_area_paragraph_finalize (GObject * obj);
static GType bird_font_text_area_paragraph_get_type_once (void);
static void _vala_bird_font_text_area_paragraph_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void bird_font_text_area_carret_finalize (GObject * obj);
static GType bird_font_text_area_carret_get_type_once (void);
static void _vala_bird_font_text_area_carret_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_bird_font_text_area_carret_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void bird_font_text_area_finalize (GObject * obj);
static GType bird_font_text_area_get_type_once (void);
static void _vala_bird_font_text_area_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_bird_font_text_area_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_text_area_get_instance_private (BirdFontTextArea* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTextArea_private_offset);
}

static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

BirdFontTextArea*
bird_font_text_area_construct (GType object_type,
                               gdouble font_size,
                               BirdFontColor* c)
{
	BirdFontTextArea * self = NULL;
	self = (BirdFontTextArea*) bird_font_widget_construct (object_type);
	self->font_size = font_size;
	self->width = self->min_width;
	self->height = self->min_height;
	self->editable = TRUE;
	if (c != NULL) {
		BirdFontColor* _tmp0_;
		_tmp0_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (c, BIRD_FONT_TYPE_COLOR, BirdFontColor));
		_bird_font_color_unref0 (self->text_color);
		self->text_color = _tmp0_;
	}
	return self;
}

BirdFontTextArea*
bird_font_text_area_new (gdouble font_size,
                         BirdFontColor* c)
{
	return bird_font_text_area_construct (BIRD_FONT_TYPE_TEXT_AREA, font_size, c);
}

static void
bird_font_text_area_real_focus (BirdFontWidget* base,
                                gboolean focus)
{
	BirdFontTextArea * self;
	self = (BirdFontTextArea*) base;
	bird_font_text_area_set_draw_carret (self, focus);
}

static gdouble
bird_font_text_area_real_get_height (BirdFontWidget* base)
{
	BirdFontTextArea * self;
	gdouble result;
	self = (BirdFontTextArea*) base;
	result = self->height + (2 * self->padding);
	return result;
}

static gdouble
bird_font_text_area_real_get_width (BirdFontWidget* base)
{
	BirdFontTextArea * self;
	gdouble result;
	self = (BirdFontTextArea*) base;
	result = self->width + (2 * self->padding);
	return result;
}

void
bird_font_text_area_set_font_size (BirdFontTextArea* self,
                                   gdouble z)
{
	g_return_if_fail (self != NULL);
	self->font_size = z;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
bird_font_text_area_generate_paragraphs (BirdFontTextArea* self)
{
	BirdFontTextAreaParagraph* paragraph = NULL;
	gint next_paragraph = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	next_paragraph = -1;
	_tmp0_ = self->priv->text;
	if (bird_font_is_null (_tmp0_)) {
		g_warning ("TextArea.vala:101: No text");
		result = FALSE;
		_g_object_unref0 (paragraph);
		return result;
	}
	if (self->priv->last_paragraph == BIRD_FONT_TEXT_AREA_DONE) {
		result = FALSE;
		_g_object_unref0 (paragraph);
		return result;
	}
	_tmp1_ = self->priv->text;
	next_paragraph = string_index_of (_tmp1_, "\n", self->priv->last_paragraph);
	if (next_paragraph == -1) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		BirdFontColor* _tmp8_;
		BirdFontTextAreaParagraph* _tmp9_;
		GeeArrayList* _tmp10_;
		BirdFontTextAreaParagraph* _tmp11_;
		_tmp2_ = self->priv->text;
		_tmp3_ = string_substring (_tmp2_, (glong) self->priv->last_paragraph, (glong) -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->paragraphs;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->text_color;
		_tmp9_ = bird_font_text_area_paragraph_new (_tmp4_, self->font_size, _tmp7_, _tmp8_);
		_g_object_unref0 (paragraph);
		paragraph = _tmp9_;
		_g_free0 (_tmp4_);
		_tmp10_ = self->priv->paragraphs;
		_tmp11_ = paragraph;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
		self->priv->last_paragraph = BIRD_FONT_TEXT_AREA_DONE;
	} else {
		gint _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		BirdFontColor* _tmp20_;
		BirdFontTextAreaParagraph* _tmp21_;
		GeeArrayList* _tmp22_;
		BirdFontTextAreaParagraph* _tmp23_;
		_tmp12_ = strlen ("\n");
		_tmp13_ = _tmp12_;
		next_paragraph += _tmp13_;
		_tmp14_ = self->priv->text;
		_tmp15_ = string_substring (_tmp14_, (glong) self->priv->last_paragraph, (glong) (next_paragraph - self->priv->last_paragraph));
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->paragraphs;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->text_color;
		_tmp21_ = bird_font_text_area_paragraph_new (_tmp16_, self->font_size, _tmp19_, _tmp20_);
		_g_object_unref0 (paragraph);
		paragraph = _tmp21_;
		_g_free0 (_tmp16_);
		_tmp22_ = self->priv->paragraphs;
		_tmp23_ = paragraph;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
		self->priv->last_paragraph = next_paragraph;
	}
	result = self->priv->last_paragraph != BIRD_FONT_TEXT_AREA_DONE;
	_g_object_unref0 (paragraph);
	return result;
}

static void
bird_font_text_area_generate_all_paragraphs (BirdFontTextArea* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		if (!bird_font_text_area_generate_paragraphs (self)) {
			break;
		}
	}
}

static void
bird_font_text_area_real_key_press (BirdFontWidget* base,
                                    guint keyval)
{
	BirdFontTextArea * self;
	gunichar c = 0U;
	BirdFontTextAreaTextUndoItem* ui = NULL;
	self = (BirdFontTextArea*) base;
	if (!self->editable) {
		_g_object_unref0 (ui);
		return;
	}
	c = (gunichar) keyval;
	switch (c) {
		case ' ':
		{
			bird_font_text_area_store_undo_edit_state (self);
			bird_font_text_area_add_character (self, keyval);
			break;
		}
		case 'a':
		{
			gboolean _tmp0_ = FALSE;
			if (bird_font_key_bindings_has_ctrl ()) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = bird_font_key_bindings_has_logo ();
			}
			if (_tmp0_) {
				bird_font_text_area_select_all (self);
			} else {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
		case 'c':
		{
			gboolean _tmp1_ = FALSE;
			if (bird_font_key_bindings_has_ctrl ()) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = bird_font_key_bindings_has_logo ();
			}
			if (_tmp1_) {
				bird_font_clip_tool_copy_text (self);
			} else {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
		case 'v':
		{
			gboolean _tmp2_ = FALSE;
			if (bird_font_key_bindings_has_ctrl ()) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = bird_font_key_bindings_has_logo ();
			}
			if (_tmp2_) {
				bird_font_clip_tool_paste_text (self);
				self->priv->store_undo_state_at_next_event = TRUE;
			} else {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
		case 'y':
		{
			gboolean _tmp3_ = FALSE;
			if (bird_font_key_bindings_has_ctrl ()) {
				_tmp3_ = TRUE;
			} else {
				_tmp3_ = bird_font_key_bindings_has_logo ();
			}
			if (_tmp3_) {
				bird_font_text_area_redo (self);
			} else {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
		case 'z':
		{
			gboolean _tmp4_ = FALSE;
			if (bird_font_key_bindings_has_ctrl ()) {
				_tmp4_ = TRUE;
			} else {
				_tmp4_ = bird_font_key_bindings_has_logo ();
			}
			if (_tmp4_) {
				bird_font_text_area_undo (self);
			} else {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
		case BIRD_FONT_KEY_RIGHT:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_next (self);
			break;
		}
		case BIRD_FONT_KEY_LEFT:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_previous (self);
			break;
		}
		case BIRD_FONT_KEY_DOWN:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_next_row (self);
			break;
		}
		case BIRD_FONT_KEY_UP:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_previous_row (self);
			break;
		}
		case BIRD_FONT_KEY_END:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_to_end_of_line (self);
			break;
		}
		case BIRD_FONT_KEY_HOME:
		{
			bird_font_text_area_check_selection (self);
			bird_font_text_area_move_carret_to_beginning_of_line (self);
			break;
		}
		case BIRD_FONT_KEY_BACK_SPACE:
		{
			gchar* _tmp13_;
			gchar* _tmp14_;
			if (bird_font_text_area_has_selection (self)) {
				BirdFontTextAreaTextUndoItem* _tmp5_;
				GeeArrayList* _tmp6_;
				BirdFontTextAreaTextUndoItem* _tmp7_;
				GeeArrayList* _tmp8_;
				_tmp5_ = bird_font_text_area_delete_selected_text (self);
				_g_object_unref0 (ui);
				ui = _tmp5_;
				_tmp6_ = self->priv->undo_items;
				_tmp7_ = ui;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
				_tmp8_ = self->priv->redo_items;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
				self->priv->store_undo_state_at_next_event = TRUE;
			} else {
				BirdFontTextAreaTextUndoItem* _tmp9_;
				GeeArrayList* _tmp10_;
				BirdFontTextAreaTextUndoItem* _tmp11_;
				GeeArrayList* _tmp12_;
				_tmp9_ = bird_font_text_area_remove_last_character (self);
				_g_object_unref0 (ui);
				ui = _tmp9_;
				_tmp10_ = self->priv->undo_items;
				_tmp11_ = ui;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_tmp12_ = self->priv->redo_items;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
				self->priv->store_undo_state_at_next_event = TRUE;
			}
			_tmp13_ = bird_font_text_area_get_text (self);
			_tmp14_ = _tmp13_;
			g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL], 0, _tmp14_);
			_g_free0 (_tmp14_);
			break;
		}
		case BIRD_FONT_KEY_ENTER:
		{
			bird_font_text_area_store_undo_edit_state (self);
			bird_font_text_area_insert_text (self, "\n");
			if (self->single_line) {
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = bird_font_text_area_get_text (self);
				_tmp16_ = _tmp15_;
				g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_ENTER_SIGNAL], 0, _tmp16_);
				_g_free0 (_tmp16_);
			}
			break;
		}
		case BIRD_FONT_KEY_DEL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			if (bird_font_text_area_has_selection (self)) {
				BirdFontTextAreaTextUndoItem* _tmp17_;
				GeeArrayList* _tmp18_;
				BirdFontTextAreaTextUndoItem* _tmp19_;
				GeeArrayList* _tmp20_;
				_tmp17_ = bird_font_text_area_delete_selected_text (self);
				_g_object_unref0 (ui);
				ui = _tmp17_;
				_tmp18_ = self->priv->undo_items;
				_tmp19_ = ui;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				_tmp20_ = self->priv->redo_items;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp20_);
				self->priv->store_undo_state_at_next_event = TRUE;
			} else {
				BirdFontTextAreaTextUndoItem* _tmp21_;
				GeeArrayList* _tmp22_;
				BirdFontTextAreaTextUndoItem* _tmp23_;
				GeeArrayList* _tmp24_;
				_tmp21_ = bird_font_text_area_remove_next_character (self);
				_g_object_unref0 (ui);
				ui = _tmp21_;
				_tmp22_ = self->priv->undo_items;
				_tmp23_ = ui;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				_tmp24_ = self->priv->redo_items;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp24_);
				self->priv->store_undo_state_at_next_event = TRUE;
			}
			_tmp25_ = bird_font_text_area_get_text (self);
			_tmp26_ = _tmp25_;
			g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL], 0, _tmp26_);
			_g_free0 (_tmp26_);
			break;
		}
		default:
		{
			gboolean _tmp27_ = FALSE;
			if (!bird_font_key_bindings_has_ctrl ()) {
				_tmp27_ = !bird_font_key_bindings_has_logo ();
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				bird_font_text_area_add_character (self, keyval);
			}
			break;
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (ui);
}

static void
bird_font_text_area_check_selection (BirdFontTextArea* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!bird_font_text_area_has_selection (self)) {
		_tmp0_ = bird_font_key_bindings_has_shift ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontTextAreaCarret* _tmp1_;
		BirdFontTextAreaCarret* _tmp2_;
		self->show_selection = TRUE;
		_tmp1_ = self->priv->carret;
		_tmp2_ = bird_font_text_area_carret_copy (_tmp1_);
		_g_object_unref0 (self->priv->selection_end);
		self->priv->selection_end = _tmp2_;
	}
	if (!bird_font_key_bindings_has_shift ()) {
		self->show_selection = FALSE;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
bird_font_text_area_add_character (BirdFontTextArea* self,
                                   guint keyval)
{
	gunichar c = 0U;
	gchar* s = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	c = (gunichar) keyval;
	if (!bird_font_is_modifier_key (keyval)) {
		_tmp1_ = !bird_font_key_bindings_has_ctrl ();
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !bird_font_key_bindings_has_alt ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = g_unichar_to_string (c);
		_g_free0 (s);
		s = (gchar*) _tmp2_;
		_tmp3_ = s;
		if (g_utf8_validate (_tmp3_, (gssize) -1, NULL)) {
			const gchar* _tmp4_;
			if (self->priv->store_undo_state_at_next_event) {
				bird_font_text_area_store_undo_edit_state (self);
				self->priv->store_undo_state_at_next_event = FALSE;
			}
			_tmp4_ = s;
			bird_font_text_area_insert_text (self, _tmp4_);
		}
	}
	_g_free0 (s);
}

static BirdFontTextAreaParagraph*
bird_font_text_area_get_current_paragraph (BirdFontTextArea* self)
{
	BirdFontTextAreaParagraph* p = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp19_;
	BirdFontTextAreaCarret* _tmp20_;
	gpointer _tmp21_;
	BirdFontTextAreaParagraph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = self->priv->paragraphs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_->paragraph;
	if (G_UNLIKELY (!((0 <= _tmp4_) && (_tmp4_ < _tmp3_)))) {
		BirdFontTextAreaCarret* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		BirdFontColor* _tmp15_;
		BirdFontTextAreaParagraph* _tmp16_;
		GeeArrayList* _tmp17_;
		BirdFontTextAreaParagraph* _tmp18_;
		_tmp5_ = self->priv->carret;
		_tmp6_ = g_strdup_printf ("%i", _tmp5_->paragraph);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->paragraphs;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("No paragraph, index: ", _tmp7_, ", size: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		g_warning ("TextArea.vala:287: %s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp7_);
		_tmp15_ = self->text_color;
		_tmp16_ = bird_font_text_area_paragraph_new ("", (gdouble) 0, 0, _tmp15_);
		_g_object_unref0 (p);
		p = _tmp16_;
		_tmp17_ = self->priv->paragraphs;
		_tmp18_ = p;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		result = p;
		return result;
	}
	_tmp19_ = self->priv->paragraphs;
	_tmp20_ = self->priv->carret;
	_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_->paragraph);
	_g_object_unref0 (p);
	p = (BirdFontTextAreaParagraph*) _tmp21_;
	result = p;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
bird_font_text_area_set_text (BirdFontTextArea* self,
                              const gchar* t)
{
	gint tl = 0;
	gint _tmp4_;
	gint _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	BirdFontTextAreaCarret* _tmp10_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	BirdFontTextAreaCarret* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gpointer _tmp19_;
	BirdFontTextAreaParagraph* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	BirdFontTextAreaCarret* _tmp24_;
	BirdFontTextAreaCarret* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if (self->single_line) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = string_replace (t, "\n", "");
		_tmp1_ = _tmp0_;
		_tmp2_ = string_replace (_tmp1_, "\r", "");
		_g_free0 (self->priv->text);
		self->priv->text = _tmp2_;
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (t);
		_g_free0 (self->priv->text);
		self->priv->text = _tmp3_;
	}
	_tmp4_ = strlen (t);
	_tmp5_ = _tmp4_;
	tl = _tmp5_;
	self->priv->text_length = self->priv->text_length + tl;
	_tmp6_ = self->priv->paragraphs;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp6_);
	bird_font_text_area_generate_paragraphs (self);
	_tmp7_ = self->priv->paragraphs;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	g_return_if_fail (_tmp9_ != 0);
	_tmp10_ = self->priv->carret;
	_tmp11_ = self->priv->paragraphs;
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp10_->paragraph = _tmp13_ - 1;
	_tmp14_ = self->priv->carret;
	_tmp15_ = self->priv->paragraphs;
	_tmp16_ = self->priv->paragraphs;
	_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp18_ - 1);
	_tmp20_ = (BirdFontTextAreaParagraph*) _tmp19_;
	_tmp21_ = _tmp20_->text;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	bird_font_text_area_carret_set_character_index (_tmp14_, _tmp23_);
	_g_object_unref0 (_tmp20_);
	_tmp24_ = self->priv->carret;
	_tmp25_ = bird_font_text_area_carret_copy (_tmp24_);
	_g_object_unref0 (self->priv->selection_end);
	self->priv->selection_end = _tmp25_;
	self->show_selection = FALSE;
	_tmp26_ = bird_font_text_area_get_text (self);
	_tmp27_ = _tmp26_;
	g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL], 0, _tmp27_);
	_g_free0 (_tmp27_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static BirdFontTextAreaCarret*
bird_font_text_area_get_selection_start (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	BirdFontTextAreaCarret* _tmp12_ = NULL;
	BirdFontTextAreaCarret* _tmp13_;
	BirdFontTextAreaCarret* _tmp14_;
	BirdFontTextAreaCarret* _tmp17_;
	BirdFontTextAreaCarret* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = self->priv->selection_end;
	if (_tmp0_->paragraph == _tmp1_->paragraph) {
		BirdFontTextAreaCarret* _tmp2_ = NULL;
		BirdFontTextAreaCarret* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		BirdFontTextAreaCarret* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		BirdFontTextAreaCarret* _tmp11_;
		_tmp3_ = self->priv->carret;
		_tmp4_ = bird_font_text_area_carret_get_character_index (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->selection_end;
		_tmp7_ = bird_font_text_area_carret_get_character_index (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp5_ < _tmp8_) {
			BirdFontTextAreaCarret* _tmp9_;
			_tmp9_ = self->priv->carret;
			_tmp2_ = _tmp9_;
		} else {
			BirdFontTextAreaCarret* _tmp10_;
			_tmp10_ = self->priv->selection_end;
			_tmp2_ = _tmp10_;
		}
		_tmp11_ = _g_object_ref0 (_tmp2_);
		result = _tmp11_;
		return result;
	}
	_tmp13_ = self->priv->carret;
	_tmp14_ = self->priv->selection_end;
	if (_tmp13_->paragraph < _tmp14_->paragraph) {
		BirdFontTextAreaCarret* _tmp15_;
		_tmp15_ = self->priv->carret;
		_tmp12_ = _tmp15_;
	} else {
		BirdFontTextAreaCarret* _tmp16_;
		_tmp16_ = self->priv->selection_end;
		_tmp12_ = _tmp16_;
	}
	_tmp17_ = _g_object_ref0 (_tmp12_);
	result = _tmp17_;
	return result;
}

static BirdFontTextAreaCarret*
bird_font_text_area_get_selection_stop (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	BirdFontTextAreaCarret* _tmp12_ = NULL;
	BirdFontTextAreaCarret* _tmp13_;
	BirdFontTextAreaCarret* _tmp14_;
	BirdFontTextAreaCarret* _tmp17_;
	BirdFontTextAreaCarret* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = self->priv->selection_end;
	if (_tmp0_->paragraph == _tmp1_->paragraph) {
		BirdFontTextAreaCarret* _tmp2_ = NULL;
		BirdFontTextAreaCarret* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		BirdFontTextAreaCarret* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		BirdFontTextAreaCarret* _tmp11_;
		_tmp3_ = self->priv->carret;
		_tmp4_ = bird_font_text_area_carret_get_character_index (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->selection_end;
		_tmp7_ = bird_font_text_area_carret_get_character_index (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp5_ > _tmp8_) {
			BirdFontTextAreaCarret* _tmp9_;
			_tmp9_ = self->priv->carret;
			_tmp2_ = _tmp9_;
		} else {
			BirdFontTextAreaCarret* _tmp10_;
			_tmp10_ = self->priv->selection_end;
			_tmp2_ = _tmp10_;
		}
		_tmp11_ = _g_object_ref0 (_tmp2_);
		result = _tmp11_;
		return result;
	}
	_tmp13_ = self->priv->carret;
	_tmp14_ = self->priv->selection_end;
	if (_tmp13_->paragraph > _tmp14_->paragraph) {
		BirdFontTextAreaCarret* _tmp15_;
		_tmp15_ = self->priv->carret;
		_tmp12_ = _tmp15_;
	} else {
		BirdFontTextAreaCarret* _tmp16_;
		_tmp16_ = self->priv->selection_end;
		_tmp12_ = _tmp16_;
	}
	_tmp17_ = _g_object_ref0 (_tmp12_);
	result = _tmp17_;
	return result;
}

gchar*
bird_font_text_area_get_selected_text (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* selection_start = NULL;
	BirdFontTextAreaCarret* selection_stop = NULL;
	gint i = 0;
	BirdFontTextAreaParagraph* pg = NULL;
	GString* sb = NULL;
	GString* _tmp0_;
	BirdFontTextAreaCarret* _tmp2_;
	BirdFontTextAreaCarret* _tmp3_;
	BirdFontTextAreaCarret* _tmp4_;
	BirdFontTextAreaCarret* _tmp5_;
	GeeArrayList* _tmp21_;
	BirdFontTextAreaCarret* _tmp22_;
	gpointer _tmp23_;
	GString* _tmp24_;
	BirdFontTextAreaParagraph* _tmp25_;
	const gchar* _tmp26_;
	BirdFontTextAreaCarret* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GeeArrayList* _tmp47_;
	BirdFontTextAreaCarret* _tmp48_;
	gpointer _tmp49_;
	GString* _tmp50_;
	BirdFontTextAreaParagraph* _tmp51_;
	const gchar* _tmp52_;
	BirdFontTextAreaCarret* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GString* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	_g_string_free0 (sb);
	sb = _tmp0_;
	if (!bird_font_text_area_has_selection (self)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		_g_string_free0 (sb);
		_g_object_unref0 (pg);
		_g_object_unref0 (selection_stop);
		_g_object_unref0 (selection_start);
		return result;
	}
	_tmp2_ = bird_font_text_area_get_selection_start (self);
	_g_object_unref0 (selection_start);
	selection_start = _tmp2_;
	_tmp3_ = bird_font_text_area_get_selection_stop (self);
	_g_object_unref0 (selection_stop);
	selection_stop = _tmp3_;
	_tmp4_ = selection_start;
	_tmp5_ = selection_stop;
	if (_tmp4_->paragraph == _tmp5_->paragraph) {
		GeeArrayList* _tmp6_;
		BirdFontTextAreaCarret* _tmp7_;
		gpointer _tmp8_;
		BirdFontTextAreaParagraph* _tmp9_;
		const gchar* _tmp10_;
		BirdFontTextAreaCarret* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		BirdFontTextAreaCarret* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		BirdFontTextAreaCarret* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		_tmp6_ = self->priv->paragraphs;
		_tmp7_ = selection_start;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_->paragraph);
		_g_object_unref0 (pg);
		pg = (BirdFontTextAreaParagraph*) _tmp8_;
		_tmp9_ = pg;
		_tmp10_ = _tmp9_->text;
		_tmp11_ = selection_start;
		_tmp12_ = bird_font_text_area_carret_get_character_index (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = selection_stop;
		_tmp15_ = bird_font_text_area_carret_get_character_index (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = selection_start;
		_tmp18_ = bird_font_text_area_carret_get_character_index (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_substring (_tmp10_, (glong) _tmp13_, (glong) (_tmp16_ - _tmp19_));
		result = _tmp20_;
		_g_string_free0 (sb);
		_g_object_unref0 (pg);
		_g_object_unref0 (selection_stop);
		_g_object_unref0 (selection_start);
		return result;
	}
	_tmp21_ = self->priv->paragraphs;
	_tmp22_ = selection_start;
	_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_->paragraph);
	_g_object_unref0 (pg);
	pg = (BirdFontTextAreaParagraph*) _tmp23_;
	_tmp24_ = sb;
	_tmp25_ = pg;
	_tmp26_ = _tmp25_->text;
	_tmp27_ = selection_start;
	_tmp28_ = bird_font_text_area_carret_get_character_index (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = string_substring (_tmp26_, (glong) _tmp29_, (glong) -1);
	_tmp31_ = _tmp30_;
	g_string_append (_tmp24_, _tmp31_);
	_g_free0 (_tmp31_);
	{
		BirdFontTextAreaCarret* _tmp32_;
		gboolean _tmp33_ = FALSE;
		_tmp32_ = selection_start;
		i = _tmp32_->paragraph + 1;
		_tmp33_ = TRUE;
		while (TRUE) {
			BirdFontTextAreaCarret* _tmp35_;
			GeeArrayList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			GeeArrayList* _tmp42_;
			gpointer _tmp43_;
			GString* _tmp44_;
			BirdFontTextAreaParagraph* _tmp45_;
			const gchar* _tmp46_;
			if (!_tmp33_) {
				gint _tmp34_;
				_tmp34_ = i;
				i = _tmp34_ + 1;
			}
			_tmp33_ = FALSE;
			_tmp35_ = selection_stop;
			if (!(i < _tmp35_->paragraph)) {
				break;
			}
			_tmp36_ = self->priv->paragraphs;
			_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = i;
			_tmp40_ = g_strdup ("");
			_tmp41_ = _tmp40_;
			g_return_val_if_fail ((0 <= _tmp39_) && (_tmp39_ < _tmp38_), _tmp41_);
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->paragraphs;
			_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, i);
			_g_object_unref0 (pg);
			pg = (BirdFontTextAreaParagraph*) _tmp43_;
			_tmp44_ = sb;
			_tmp45_ = pg;
			_tmp46_ = _tmp45_->text;
			g_string_append (_tmp44_, _tmp46_);
		}
	}
	_tmp47_ = self->priv->paragraphs;
	_tmp48_ = selection_stop;
	_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_->paragraph);
	_g_object_unref0 (pg);
	pg = (BirdFontTextAreaParagraph*) _tmp49_;
	_tmp50_ = sb;
	_tmp51_ = pg;
	_tmp52_ = _tmp51_->text;
	_tmp53_ = selection_stop;
	_tmp54_ = bird_font_text_area_carret_get_character_index (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = string_substring (_tmp52_, (glong) 0, (glong) _tmp55_);
	_tmp57_ = _tmp56_;
	g_string_append (_tmp50_, _tmp57_);
	_g_free0 (_tmp57_);
	_tmp58_ = sb;
	_tmp59_ = _tmp58_->str;
	_tmp60_ = g_strdup (_tmp59_);
	result = _tmp60_;
	_g_string_free0 (sb);
	_g_object_unref0 (pg);
	_g_object_unref0 (selection_stop);
	_g_object_unref0 (selection_start);
	return result;
}

void
bird_font_text_area_select_all (BirdFontTextArea* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		if (!(self->priv->last_paragraph != BIRD_FONT_TEXT_AREA_DONE)) {
			break;
		}
		bird_font_text_area_generate_paragraphs (self);
	}
	_tmp0_ = self->priv->paragraphs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		BirdFontTextAreaCarret* _tmp3_;
		BirdFontTextAreaCarret* _tmp4_;
		BirdFontTextAreaCarret* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		BirdFontTextAreaCarret* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gpointer _tmp14_;
		BirdFontTextAreaParagraph* _tmp15_;
		_tmp3_ = self->priv->carret;
		_tmp3_->paragraph = 0;
		_tmp4_ = self->priv->carret;
		bird_font_text_area_carret_set_character_index (_tmp4_, 0);
		_tmp5_ = self->priv->selection_end;
		_tmp6_ = self->priv->paragraphs;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_->paragraph = _tmp8_ - 1;
		_tmp9_ = self->priv->selection_end;
		_tmp10_ = self->priv->paragraphs;
		_tmp11_ = self->priv->paragraphs;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp13_ - 1);
		_tmp15_ = (BirdFontTextAreaParagraph*) _tmp14_;
		bird_font_text_area_carret_set_character_index (_tmp9_, _tmp15_->text_length);
		_g_object_unref0 (_tmp15_);
		self->show_selection = TRUE;
	}
}

BirdFontTextAreaTextUndoItem*
bird_font_text_area_delete_selected_text (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* selection_start = NULL;
	BirdFontTextAreaCarret* selection_stop = NULL;
	gint i = 0;
	BirdFontTextAreaParagraph* pg = NULL;
	BirdFontTextAreaParagraph* pge = NULL;
	gchar* e = NULL;
	gchar* s = NULL;
	gchar* n = NULL;
	gboolean same = FALSE;
	BirdFontTextAreaTextUndoItem* ui = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaTextUndoItem* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontTextAreaCarret* _tmp5_;
	BirdFontTextAreaCarret* _tmp6_;
	BirdFontTextAreaCarret* _tmp7_;
	BirdFontTextAreaCarret* _tmp8_;
	gboolean _tmp111_ = FALSE;
	const gchar* _tmp112_;
	gboolean _tmp134_ = FALSE;
	const gchar* _tmp135_;
	BirdFontTextAreaCarret* _tmp146_;
	BirdFontTextAreaCarret* _tmp147_;
	BirdFontTextAreaCarret* _tmp148_;
	BirdFontTextAreaCarret* _tmp149_;
	BirdFontTextAreaTextUndoItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = bird_font_text_area_text_undo_item_new (_tmp0_);
	_g_object_unref0 (ui);
	ui = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (e);
	e = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (s);
	s = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (n);
	n = _tmp4_;
	if (!bird_font_text_area_has_selection (self)) {
		g_warning ("TextArea.vala:402: No selected text.");
		result = ui;
		_g_free0 (n);
		_g_free0 (s);
		_g_free0 (e);
		_g_object_unref0 (pge);
		_g_object_unref0 (pg);
		_g_object_unref0 (selection_stop);
		_g_object_unref0 (selection_start);
		return result;
	}
	_tmp5_ = bird_font_text_area_get_selection_start (self);
	_g_object_unref0 (selection_start);
	selection_start = _tmp5_;
	_tmp6_ = bird_font_text_area_get_selection_stop (self);
	_g_object_unref0 (selection_stop);
	selection_stop = _tmp6_;
	_tmp7_ = selection_start;
	_tmp8_ = selection_stop;
	same = _tmp7_->paragraph == _tmp8_->paragraph;
	if (!same) {
		BirdFontTextAreaCarret* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		BirdFontTextAreaTextUndoItem* _tmp14_;
		GeeArrayList* _tmp15_;
		BirdFontTextAreaCarret* _tmp16_;
		gpointer _tmp17_;
		BirdFontTextAreaParagraph* _tmp18_;
		const gchar* _tmp19_;
		BirdFontTextAreaCarret* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		BirdFontTextAreaCarret* _tmp24_;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		BirdFontTextAreaTextUndoItem* _tmp29_;
		GeeArrayList* _tmp30_;
		BirdFontTextAreaCarret* _tmp31_;
		gpointer _tmp32_;
		BirdFontTextAreaParagraph* _tmp33_;
		const gchar* _tmp34_;
		BirdFontTextAreaCarret* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp9_ = selection_start;
		_tmp10_ = self->priv->paragraphs;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp9_->paragraph;
		_tmp14_ = ui;
		g_return_val_if_fail ((0 <= _tmp13_) && (_tmp13_ < _tmp12_), _tmp14_);
		_tmp15_ = self->priv->paragraphs;
		_tmp16_ = selection_start;
		_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_->paragraph);
		_g_object_unref0 (pg);
		pg = (BirdFontTextAreaParagraph*) _tmp17_;
		_tmp18_ = pg;
		_tmp19_ = _tmp18_->text;
		_tmp20_ = selection_start;
		_tmp21_ = bird_font_text_area_carret_get_character_index (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp19_, (glong) 0, (glong) _tmp22_);
		_g_free0 (s);
		s = _tmp23_;
		_tmp24_ = selection_stop;
		_tmp25_ = self->priv->paragraphs;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp24_->paragraph;
		_tmp29_ = ui;
		g_return_val_if_fail ((0 <= _tmp28_) && (_tmp28_ < _tmp27_), _tmp29_);
		_tmp30_ = self->priv->paragraphs;
		_tmp31_ = selection_stop;
		_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_->paragraph);
		_g_object_unref0 (pge);
		pge = (BirdFontTextAreaParagraph*) _tmp32_;
		_tmp33_ = pge;
		_tmp34_ = _tmp33_->text;
		_tmp35_ = selection_stop;
		_tmp36_ = bird_font_text_area_carret_get_character_index (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = string_substring (_tmp34_, (glong) _tmp37_, (glong) -1);
		_g_free0 (e);
		e = _tmp38_;
		_tmp39_ = s;
		if (!g_str_has_suffix (_tmp39_, "\n")) {
			BirdFontTextAreaTextUndoItem* _tmp40_;
			GeeArrayList* _tmp41_;
			BirdFontTextAreaParagraph* _tmp42_;
			BirdFontTextAreaParagraph* _tmp43_;
			BirdFontTextAreaParagraph* _tmp44_;
			BirdFontTextAreaTextUndoItem* _tmp45_;
			GeeArrayList* _tmp46_;
			BirdFontTextAreaParagraph* _tmp47_;
			BirdFontTextAreaParagraph* _tmp48_;
			BirdFontTextAreaParagraph* _tmp49_;
			BirdFontTextAreaParagraph* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			BirdFontTextAreaParagraph* _tmp55_;
			_tmp40_ = ui;
			_tmp41_ = _tmp40_->deleted;
			_tmp42_ = pge;
			_tmp43_ = bird_font_text_area_paragraph_copy (_tmp42_);
			_tmp44_ = _tmp43_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp44_);
			_g_object_unref0 (_tmp44_);
			_tmp45_ = ui;
			_tmp46_ = _tmp45_->edited;
			_tmp47_ = pg;
			_tmp48_ = bird_font_text_area_paragraph_copy (_tmp47_);
			_tmp49_ = _tmp48_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
			_g_object_unref0 (_tmp49_);
			_tmp50_ = pg;
			_tmp51_ = s;
			_tmp52_ = e;
			_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
			_tmp54_ = _tmp53_;
			bird_font_text_area_paragraph_set_text (_tmp50_, _tmp54_);
			_g_free0 (_tmp54_);
			_tmp55_ = pge;
			bird_font_text_area_paragraph_set_text (_tmp55_, "");
		} else {
			BirdFontTextAreaTextUndoItem* _tmp56_;
			GeeArrayList* _tmp57_;
			BirdFontTextAreaParagraph* _tmp58_;
			BirdFontTextAreaParagraph* _tmp59_;
			BirdFontTextAreaParagraph* _tmp60_;
			BirdFontTextAreaTextUndoItem* _tmp61_;
			GeeArrayList* _tmp62_;
			BirdFontTextAreaParagraph* _tmp63_;
			BirdFontTextAreaParagraph* _tmp64_;
			BirdFontTextAreaParagraph* _tmp65_;
			BirdFontTextAreaParagraph* _tmp66_;
			const gchar* _tmp67_;
			BirdFontTextAreaParagraph* _tmp68_;
			const gchar* _tmp69_;
			_tmp56_ = ui;
			_tmp57_ = _tmp56_->edited;
			_tmp58_ = pg;
			_tmp59_ = bird_font_text_area_paragraph_copy (_tmp58_);
			_tmp60_ = _tmp59_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, _tmp60_);
			_g_object_unref0 (_tmp60_);
			_tmp61_ = ui;
			_tmp62_ = _tmp61_->edited;
			_tmp63_ = pge;
			_tmp64_ = bird_font_text_area_paragraph_copy (_tmp63_);
			_tmp65_ = _tmp64_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp65_);
			_g_object_unref0 (_tmp65_);
			_tmp66_ = pg;
			_tmp67_ = s;
			bird_font_text_area_paragraph_set_text (_tmp66_, _tmp67_);
			_tmp68_ = pge;
			_tmp69_ = e;
			bird_font_text_area_paragraph_set_text (_tmp68_, _tmp69_);
		}
	} else {
		BirdFontTextAreaCarret* _tmp70_;
		GeeArrayList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		BirdFontTextAreaTextUndoItem* _tmp75_;
		GeeArrayList* _tmp76_;
		BirdFontTextAreaCarret* _tmp77_;
		gpointer _tmp78_;
		BirdFontTextAreaParagraph* _tmp79_;
		const gchar* _tmp80_;
		BirdFontTextAreaCarret* _tmp81_;
		gint _tmp82_;
		gint _tmp83_;
		gchar* _tmp84_;
		const gchar* _tmp85_;
		BirdFontTextAreaParagraph* _tmp86_;
		const gchar* _tmp87_;
		BirdFontTextAreaCarret* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		const gchar* _tmp94_;
		BirdFontTextAreaParagraph* _tmp109_;
		const gchar* _tmp110_;
		_tmp70_ = selection_start;
		_tmp71_ = self->priv->paragraphs;
		_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = _tmp70_->paragraph;
		_tmp75_ = ui;
		g_return_val_if_fail ((0 <= _tmp74_) && (_tmp74_ < _tmp73_), _tmp75_);
		_tmp76_ = self->priv->paragraphs;
		_tmp77_ = selection_start;
		_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _tmp77_->paragraph);
		_g_object_unref0 (pg);
		pg = (BirdFontTextAreaParagraph*) _tmp78_;
		_tmp79_ = pg;
		_tmp80_ = _tmp79_->text;
		_tmp81_ = selection_start;
		_tmp82_ = bird_font_text_area_carret_get_character_index (_tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = string_substring (_tmp80_, (glong) 0, (glong) _tmp83_);
		_g_free0 (n);
		n = _tmp84_;
		_tmp85_ = n;
		_tmp86_ = pg;
		_tmp87_ = _tmp86_->text;
		_tmp88_ = selection_stop;
		_tmp89_ = bird_font_text_area_carret_get_character_index (_tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = string_substring (_tmp87_, (glong) _tmp90_, (glong) -1);
		_tmp92_ = _tmp91_;
		_tmp93_ = g_strconcat (_tmp85_, _tmp92_, NULL);
		_g_free0 (n);
		n = _tmp93_;
		_g_free0 (_tmp92_);
		_tmp94_ = n;
		if (g_strcmp0 (_tmp94_, "") == 0) {
			BirdFontTextAreaTextUndoItem* _tmp95_;
			GeeArrayList* _tmp96_;
			BirdFontTextAreaParagraph* _tmp97_;
			BirdFontTextAreaParagraph* _tmp98_;
			BirdFontTextAreaParagraph* _tmp99_;
			GeeArrayList* _tmp100_;
			BirdFontTextAreaCarret* _tmp101_;
			gpointer _tmp102_;
			BirdFontTextAreaParagraph* _tmp103_;
			_tmp95_ = ui;
			_tmp96_ = _tmp95_->deleted;
			_tmp97_ = pg;
			_tmp98_ = bird_font_text_area_paragraph_copy (_tmp97_);
			_tmp99_ = _tmp98_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, _tmp99_);
			_g_object_unref0 (_tmp99_);
			_tmp100_ = self->priv->paragraphs;
			_tmp101_ = selection_start;
			_tmp102_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp100_, _tmp101_->paragraph);
			_tmp103_ = (BirdFontTextAreaParagraph*) _tmp102_;
			_g_object_unref0 (_tmp103_);
		} else {
			BirdFontTextAreaTextUndoItem* _tmp104_;
			GeeArrayList* _tmp105_;
			BirdFontTextAreaParagraph* _tmp106_;
			BirdFontTextAreaParagraph* _tmp107_;
			BirdFontTextAreaParagraph* _tmp108_;
			_tmp104_ = ui;
			_tmp105_ = _tmp104_->edited;
			_tmp106_ = pg;
			_tmp107_ = bird_font_text_area_paragraph_copy (_tmp106_);
			_tmp108_ = _tmp107_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp108_);
			_g_object_unref0 (_tmp108_);
		}
		_tmp109_ = pg;
		_tmp110_ = n;
		bird_font_text_area_paragraph_set_text (_tmp109_, _tmp110_);
	}
	_tmp112_ = e;
	if (g_strcmp0 (_tmp112_, "") == 0) {
		_tmp111_ = !same;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		GeeArrayList* _tmp113_;
		BirdFontTextAreaCarret* _tmp114_;
		gpointer _tmp115_;
		BirdFontTextAreaParagraph* _tmp116_;
		_tmp113_ = self->priv->paragraphs;
		_tmp114_ = selection_stop;
		_tmp115_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp113_, _tmp114_->paragraph);
		_tmp116_ = (BirdFontTextAreaParagraph*) _tmp115_;
		_g_object_unref0 (_tmp116_);
	}
	{
		BirdFontTextAreaCarret* _tmp117_;
		gboolean _tmp118_ = FALSE;
		_tmp117_ = selection_stop;
		i = _tmp117_->paragraph - 1;
		_tmp118_ = TRUE;
		while (TRUE) {
			BirdFontTextAreaCarret* _tmp120_;
			GeeArrayList* _tmp121_;
			gint _tmp122_;
			gint _tmp123_;
			gint _tmp124_;
			BirdFontTextAreaTextUndoItem* _tmp125_;
			BirdFontTextAreaTextUndoItem* _tmp126_;
			GeeArrayList* _tmp127_;
			GeeArrayList* _tmp128_;
			gpointer _tmp129_;
			BirdFontTextAreaParagraph* _tmp130_;
			GeeArrayList* _tmp131_;
			gpointer _tmp132_;
			BirdFontTextAreaParagraph* _tmp133_;
			if (!_tmp118_) {
				gint _tmp119_;
				_tmp119_ = i;
				i = _tmp119_ - 1;
			}
			_tmp118_ = FALSE;
			_tmp120_ = selection_start;
			if (!(i > _tmp120_->paragraph)) {
				break;
			}
			_tmp121_ = self->priv->paragraphs;
			_tmp122_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = i;
			_tmp125_ = ui;
			g_return_val_if_fail ((0 <= _tmp124_) && (_tmp124_ < _tmp123_), _tmp125_);
			_tmp126_ = ui;
			_tmp127_ = _tmp126_->deleted;
			_tmp128_ = self->priv->paragraphs;
			_tmp129_ = gee_abstract_list_get ((GeeAbstractList*) _tmp128_, i);
			_tmp130_ = (BirdFontTextAreaParagraph*) _tmp129_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp127_, _tmp130_);
			_g_object_unref0 (_tmp130_);
			_tmp131_ = self->priv->paragraphs;
			_tmp132_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp131_, i);
			_tmp133_ = (BirdFontTextAreaParagraph*) _tmp132_;
			_g_object_unref0 (_tmp133_);
		}
	}
	_tmp135_ = s;
	if (g_strcmp0 (_tmp135_, "") == 0) {
		_tmp134_ = !same;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		BirdFontTextAreaCarret* _tmp136_;
		GeeArrayList* _tmp137_;
		gint _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		BirdFontTextAreaTextUndoItem* _tmp141_;
		GeeArrayList* _tmp142_;
		BirdFontTextAreaCarret* _tmp143_;
		gpointer _tmp144_;
		BirdFontTextAreaParagraph* _tmp145_;
		_tmp136_ = selection_start;
		_tmp137_ = self->priv->paragraphs;
		_tmp138_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = _tmp136_->paragraph;
		_tmp141_ = ui;
		g_return_val_if_fail ((0 <= _tmp140_) && (_tmp140_ < _tmp139_), _tmp141_);
		_tmp142_ = self->priv->paragraphs;
		_tmp143_ = selection_start;
		_tmp144_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp142_, _tmp143_->paragraph);
		_tmp145_ = (BirdFontTextAreaParagraph*) _tmp144_;
		_g_object_unref0 (_tmp145_);
	}
	_tmp146_ = selection_start;
	_tmp147_ = bird_font_text_area_carret_copy (_tmp146_);
	_g_object_unref0 (self->priv->carret);
	self->priv->carret = _tmp147_;
	_tmp148_ = self->priv->carret;
	_tmp149_ = bird_font_text_area_carret_copy (_tmp148_);
	_g_object_unref0 (self->priv->selection_end);
	self->priv->selection_end = _tmp149_;
	self->show_selection = FALSE;
	bird_font_text_area_update_paragraph_index (self);
	bird_font_widget_layout ((BirdFontWidget*) self);
	result = ui;
	_g_free0 (n);
	_g_free0 (s);
	_g_free0 (e);
	_g_object_unref0 (pge);
	_g_object_unref0 (pg);
	_g_object_unref0 (selection_stop);
	_g_object_unref0 (selection_start);
	return result;
}

static void
bird_font_text_area_update_paragraph_index (BirdFontTextArea* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->priv->paragraphs;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTextAreaParagraph* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTextAreaParagraph* _tmp8_;
			gint _tmp9_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontTextAreaParagraph*) _tmp7_;
			_tmp8_ = p;
			_tmp8_->index = i;
			_tmp9_ = i;
			i = _tmp9_ + 1;
			_g_object_unref0 (p);
		}
	}
}

BirdFontTextAreaTextUndoItem*
bird_font_text_area_remove_last_character (BirdFontTextArea* self)
{
	BirdFontTextAreaTextUndoItem* ui = NULL;
	BirdFontTextAreaTextUndoItem* _tmp0_;
	BirdFontTextAreaTextUndoItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	bird_font_text_area_move_carret_previous (self);
	_tmp0_ = bird_font_text_area_remove_next_character (self);
	_g_object_unref0 (ui);
	ui = _tmp0_;
	result = ui;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

BirdFontTextAreaTextUndoItem*
bird_font_text_area_remove_next_character (BirdFontTextArea* self)
{
	BirdFontTextAreaParagraph* paragraph = NULL;
	BirdFontTextAreaParagraph* next_paragraph = NULL;
	gint index = 0;
	gunichar c = 0U;
	gchar* np = NULL;
	BirdFontTextAreaTextUndoItem* ui = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaTextUndoItem* _tmp1_;
	BirdFontTextAreaCarret* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontTextAreaTextUndoItem* _tmp7_;
	GeeArrayList* _tmp8_;
	BirdFontTextAreaCarret* _tmp9_;
	gpointer _tmp10_;
	BirdFontTextAreaCarret* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	BirdFontTextAreaParagraph* _tmp14_;
	const gchar* _tmp15_;
	gunichar _tmp16_ = 0U;
	BirdFontTextAreaParagraph* _tmp17_;
	BirdFontTextAreaTextUndoItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = bird_font_text_area_text_undo_item_new (_tmp0_);
	_g_object_unref0 (ui);
	ui = _tmp1_;
	_tmp2_ = self->priv->carret;
	_tmp3_ = self->priv->paragraphs;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp2_->paragraph;
	_tmp7_ = ui;
	g_return_val_if_fail ((0 <= _tmp6_) && (_tmp6_ < _tmp5_), _tmp7_);
	_tmp8_ = self->priv->paragraphs;
	_tmp9_ = self->priv->carret;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_->paragraph);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp10_;
	_tmp11_ = self->priv->carret;
	_tmp12_ = bird_font_text_area_carret_get_character_index (_tmp11_);
	_tmp13_ = _tmp12_;
	index = _tmp13_;
	_tmp14_ = paragraph;
	_tmp15_ = _tmp14_->text;
	string_get_next_char (_tmp15_, &index, &_tmp16_);
	c = _tmp16_;
	_tmp17_ = paragraph;
	if (index >= _tmp17_->text_length) {
		BirdFontTextAreaParagraph* _tmp18_;
		const gchar* _tmp19_;
		BirdFontTextAreaCarret* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		BirdFontTextAreaCarret* _tmp24_;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		BirdFontTextAreaParagraph* _tmp42_;
		const gchar* _tmp43_;
		BirdFontTextAreaTextUndoItem* _tmp44_;
		GeeArrayList* _tmp45_;
		BirdFontTextAreaParagraph* _tmp46_;
		_tmp18_ = paragraph;
		_tmp19_ = _tmp18_->text;
		_tmp20_ = self->priv->carret;
		_tmp21_ = bird_font_text_area_carret_get_character_index (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp19_, (glong) 0, (glong) _tmp22_);
		_g_free0 (np);
		np = _tmp23_;
		_tmp24_ = self->priv->carret;
		_tmp25_ = self->priv->paragraphs;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		if ((_tmp24_->paragraph + 1) < _tmp27_) {
			GeeArrayList* _tmp28_;
			BirdFontTextAreaCarret* _tmp29_;
			gpointer _tmp30_;
			GeeArrayList* _tmp31_;
			BirdFontTextAreaCarret* _tmp32_;
			gpointer _tmp33_;
			BirdFontTextAreaParagraph* _tmp34_;
			const gchar* _tmp35_;
			BirdFontTextAreaParagraph* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			BirdFontTextAreaTextUndoItem* _tmp39_;
			GeeArrayList* _tmp40_;
			BirdFontTextAreaParagraph* _tmp41_;
			_tmp28_ = self->priv->paragraphs;
			_tmp29_ = self->priv->carret;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_->paragraph + 1);
			_g_object_unref0 (next_paragraph);
			next_paragraph = (BirdFontTextAreaParagraph*) _tmp30_;
			_tmp31_ = self->priv->paragraphs;
			_tmp32_ = self->priv->carret;
			_tmp33_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp31_, _tmp32_->paragraph + 1);
			_tmp34_ = (BirdFontTextAreaParagraph*) _tmp33_;
			_g_object_unref0 (_tmp34_);
			_tmp35_ = np;
			_tmp36_ = next_paragraph;
			_tmp37_ = _tmp36_->text;
			_tmp38_ = g_strconcat (_tmp35_, _tmp37_, NULL);
			_g_free0 (np);
			np = _tmp38_;
			_tmp39_ = ui;
			_tmp40_ = _tmp39_->deleted;
			_tmp41_ = next_paragraph;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp40_, _tmp41_);
		}
		_tmp42_ = paragraph;
		_tmp43_ = np;
		bird_font_text_area_paragraph_set_text (_tmp42_, _tmp43_);
		_tmp44_ = ui;
		_tmp45_ = _tmp44_->edited;
		_tmp46_ = paragraph;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
	} else {
		BirdFontTextAreaParagraph* _tmp47_;
		const gchar* _tmp48_;
		BirdFontTextAreaCarret* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		BirdFontTextAreaParagraph* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		BirdFontTextAreaParagraph* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		_tmp47_ = paragraph;
		_tmp48_ = _tmp47_->text;
		_tmp49_ = self->priv->carret;
		_tmp50_ = bird_font_text_area_carret_get_character_index (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = string_substring (_tmp48_, (glong) 0, (glong) _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = paragraph;
		_tmp55_ = _tmp54_->text;
		_tmp56_ = string_substring (_tmp55_, (glong) index, (glong) -1);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp53_, _tmp57_, NULL);
		_g_free0 (np);
		np = _tmp58_;
		_g_free0 (_tmp57_);
		_g_free0 (_tmp53_);
		_tmp59_ = paragraph;
		_tmp60_ = np;
		bird_font_text_area_paragraph_set_text (_tmp59_, _tmp60_);
		_tmp61_ = np;
		if (g_strcmp0 (_tmp61_, "") == 0) {
			BirdFontTextAreaCarret* _tmp62_;
			BirdFontTextAreaTextUndoItem* _tmp63_;
			BirdFontTextAreaCarret* _tmp64_;
			gint _tmp65_;
			GeeArrayList* _tmp66_;
			BirdFontTextAreaCarret* _tmp67_;
			gpointer _tmp68_;
			BirdFontTextAreaCarret* _tmp69_;
			BirdFontTextAreaParagraph* _tmp70_;
			BirdFontTextAreaTextUndoItem* _tmp71_;
			GeeArrayList* _tmp72_;
			GeeArrayList* _tmp73_;
			BirdFontTextAreaCarret* _tmp74_;
			gpointer _tmp75_;
			BirdFontTextAreaParagraph* _tmp76_;
			GeeArrayList* _tmp77_;
			BirdFontTextAreaCarret* _tmp78_;
			gpointer _tmp79_;
			BirdFontTextAreaParagraph* _tmp80_;
			_tmp62_ = self->priv->carret;
			_tmp63_ = ui;
			g_return_val_if_fail (_tmp62_->paragraph > 0, _tmp63_);
			_tmp64_ = self->priv->carret;
			_tmp65_ = _tmp64_->paragraph;
			_tmp64_->paragraph = _tmp65_ - 1;
			_tmp66_ = self->priv->paragraphs;
			_tmp67_ = self->priv->carret;
			_tmp68_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, _tmp67_->paragraph);
			_g_object_unref0 (paragraph);
			paragraph = (BirdFontTextAreaParagraph*) _tmp68_;
			_tmp69_ = self->priv->carret;
			_tmp70_ = paragraph;
			bird_font_text_area_carret_set_character_index (_tmp69_, _tmp70_->text_length);
			_tmp71_ = ui;
			_tmp72_ = _tmp71_->deleted;
			_tmp73_ = self->priv->paragraphs;
			_tmp74_ = self->priv->carret;
			_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, _tmp74_->paragraph + 1);
			_tmp76_ = (BirdFontTextAreaParagraph*) _tmp75_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp72_, _tmp76_);
			_g_object_unref0 (_tmp76_);
			_tmp77_ = self->priv->paragraphs;
			_tmp78_ = self->priv->carret;
			_tmp79_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp77_, _tmp78_->paragraph + 1);
			_tmp80_ = (BirdFontTextAreaParagraph*) _tmp79_;
			_g_object_unref0 (_tmp80_);
		} else {
			BirdFontTextAreaTextUndoItem* _tmp81_;
			GeeArrayList* _tmp82_;
			BirdFontTextAreaParagraph* _tmp83_;
			_tmp81_ = ui;
			_tmp82_ = _tmp81_->edited;
			_tmp83_ = paragraph;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp82_, _tmp83_);
		}
	}
	bird_font_text_area_update_paragraph_index (self);
	bird_font_widget_layout ((BirdFontWidget*) self);
	result = ui;
	_g_free0 (np);
	_g_object_unref0 (next_paragraph);
	_g_object_unref0 (paragraph);
	return result;
}

void
bird_font_text_area_move_carret_next (BirdFontTextArea* self)
{
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	bird_font_text_area_move_carret_one_character (self);
	if (bird_font_key_bindings_has_ctrl ()) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			c = bird_font_text_area_move_carret_one_character (self);
			if (c == ((gunichar) '\0')) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = c == ((gunichar) ' ');
			}
			if (_tmp0_) {
				break;
			}
		}
	}
}

static gunichar
bird_font_text_area_move_carret_one_character (BirdFontTextArea* self)
{
	BirdFontTextAreaParagraph* paragraph = NULL;
	gint index = 0;
	gunichar c = 0U;
	BirdFontTextAreaCarret* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontTextAreaCarret* _tmp6_;
	gpointer _tmp7_;
	BirdFontTextAreaCarret* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	BirdFontTextAreaParagraph* _tmp11_;
	const gchar* _tmp12_;
	gunichar _tmp13_ = 0U;
	gboolean _tmp14_ = FALSE;
	BirdFontTextAreaParagraph* _tmp15_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->carret;
	_tmp1_ = self->priv->paragraphs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_->paragraph;
	g_return_val_if_fail ((0 <= _tmp4_) && (_tmp4_ < _tmp3_), '\0');
	_tmp5_ = self->priv->paragraphs;
	_tmp6_ = self->priv->carret;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp6_->paragraph);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp7_;
	_tmp8_ = self->priv->carret;
	_tmp9_ = bird_font_text_area_carret_get_character_index (_tmp8_);
	_tmp10_ = _tmp9_;
	index = _tmp10_;
	_tmp11_ = paragraph;
	_tmp12_ = _tmp11_->text;
	string_get_next_char (_tmp12_, &index, &_tmp13_);
	c = _tmp13_;
	_tmp15_ = paragraph;
	if (index >= _tmp15_->text_length) {
		BirdFontTextAreaCarret* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp16_ = self->priv->carret;
		_tmp17_ = self->priv->paragraphs;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp14_ = (_tmp16_->paragraph + 1) < _tmp19_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		BirdFontTextAreaCarret* _tmp20_;
		gint _tmp21_;
		BirdFontTextAreaCarret* _tmp22_;
		_tmp20_ = self->priv->carret;
		_tmp21_ = _tmp20_->paragraph;
		_tmp20_->paragraph = _tmp21_ + 1;
		_tmp22_ = self->priv->carret;
		bird_font_text_area_carret_set_character_index (_tmp22_, 0);
		c = (gunichar) ' ';
	} else {
		BirdFontTextAreaCarret* _tmp23_;
		_tmp23_ = self->priv->carret;
		bird_font_text_area_carret_set_character_index (_tmp23_, index);
	}
	result = c;
	_g_object_unref0 (paragraph);
	return result;
}

void
bird_font_text_area_move_carret_previous (BirdFontTextArea* self)
{
	gunichar c = 0U;
	g_return_if_fail (self != NULL);
	bird_font_text_area_move_carret_back_one_character (self);
	if (bird_font_key_bindings_has_ctrl ()) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			c = bird_font_text_area_move_carret_back_one_character (self);
			if (c == ((gunichar) '\0')) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = c == ((gunichar) ' ');
			}
			if (_tmp0_) {
				break;
			}
		}
	}
}

static gunichar
bird_font_text_area_move_carret_back_one_character (BirdFontTextArea* self)
{
	BirdFontTextAreaParagraph* paragraph = NULL;
	gint index = 0;
	gint last_index = 0;
	gunichar c = 0U;
	BirdFontTextAreaCarret* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontTextAreaCarret* _tmp6_;
	gpointer _tmp7_;
	gboolean _tmp16_ = FALSE;
	BirdFontTextAreaCarret* _tmp40_;
	GeeArrayList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->carret;
	_tmp1_ = self->priv->paragraphs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp0_->paragraph;
	g_return_val_if_fail ((0 <= _tmp4_) && (_tmp4_ < _tmp3_), '\0');
	_tmp5_ = self->priv->paragraphs;
	_tmp6_ = self->priv->carret;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp6_->paragraph);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp7_;
	index = 0;
	last_index = -1;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		BirdFontTextAreaParagraph* _tmp9_;
		const gchar* _tmp10_;
		gunichar _tmp11_ = 0U;
		gboolean _tmp12_;
		_tmp9_ = paragraph;
		_tmp10_ = _tmp9_->text;
		_tmp12_ = string_get_next_char (_tmp10_, &index, &_tmp11_);
		c = _tmp11_;
		if (_tmp12_) {
			BirdFontTextAreaCarret* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = self->priv->carret;
			_tmp14_ = bird_font_text_area_carret_get_character_index (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp8_ = index < _tmp15_;
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		last_index = index;
	}
	if (last_index <= 0) {
		BirdFontTextAreaCarret* _tmp17_;
		_tmp17_ = self->priv->carret;
		_tmp16_ = _tmp17_->paragraph > 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		BirdFontTextAreaCarret* _tmp18_;
		gint _tmp19_;
		BirdFontTextAreaCarret* _tmp20_;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		GeeArrayList* _tmp25_;
		BirdFontTextAreaCarret* _tmp26_;
		gpointer _tmp27_;
		BirdFontTextAreaCarret* _tmp28_;
		BirdFontTextAreaParagraph* _tmp29_;
		BirdFontTextAreaParagraph* _tmp30_;
		const gchar* _tmp31_;
		_tmp18_ = self->priv->carret;
		_tmp19_ = _tmp18_->paragraph;
		_tmp18_->paragraph = _tmp19_ - 1;
		_tmp20_ = self->priv->carret;
		_tmp21_ = self->priv->paragraphs;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp20_->paragraph;
		g_return_val_if_fail ((0 <= _tmp24_) && (_tmp24_ < _tmp23_), '\0');
		_tmp25_ = self->priv->paragraphs;
		_tmp26_ = self->priv->carret;
		_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_->paragraph);
		_g_object_unref0 (paragraph);
		paragraph = (BirdFontTextAreaParagraph*) _tmp27_;
		_tmp28_ = self->priv->carret;
		_tmp29_ = paragraph;
		bird_font_text_area_carret_set_character_index (_tmp28_, _tmp29_->text_length);
		_tmp30_ = paragraph;
		_tmp31_ = _tmp30_->text;
		if (g_str_has_suffix (_tmp31_, "\n")) {
			BirdFontTextAreaCarret* _tmp32_;
			BirdFontTextAreaCarret* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp32_ = self->priv->carret;
			_tmp33_ = self->priv->carret;
			_tmp34_ = bird_font_text_area_carret_get_character_index (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = strlen ("\n");
			_tmp37_ = _tmp36_;
			bird_font_text_area_carret_set_character_index (_tmp33_, _tmp35_ - _tmp37_);
		}
		c = (gunichar) ' ';
	} else {
		if (last_index > 0) {
			BirdFontTextAreaCarret* _tmp38_;
			_tmp38_ = self->priv->carret;
			bird_font_text_area_carret_set_character_index (_tmp38_, last_index);
		} else {
			BirdFontTextAreaCarret* _tmp39_;
			_tmp39_ = self->priv->carret;
			bird_font_text_area_carret_set_character_index (_tmp39_, 0);
			c = (gunichar) ' ';
		}
	}
	_tmp40_ = self->priv->carret;
	_tmp41_ = self->priv->paragraphs;
	_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp40_->paragraph;
	g_return_val_if_fail ((0 <= _tmp44_) && (_tmp44_ < _tmp43_), '\0');
	result = c;
	_g_object_unref0 (paragraph);
	return result;
}

void
bird_font_text_area_move_carret_next_row (BirdFontTextArea* self)
{
	gdouble nr = 0.0;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontTextAreaCarret* _tmp2_;
	g_return_if_fail (self != NULL);
	nr = self->font_size;
	_tmp0_ = self->priv->carret;
	_tmp1_ = ((BirdFontWidget*) self)->allocation;
	if ((_tmp0_->desired_y + (2 * self->font_size)) >= ((gdouble) _tmp1_->height)) {
		g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_SCROLL_SIGNAL], 0, 2 * self->font_size);
		nr = -self->font_size;
	}
	_tmp2_ = self->priv->carret;
	if ((_tmp2_->desired_y + nr) < ((((BirdFontWidget*) self)->widget_y + self->height) - self->padding)) {
		BirdFontTextAreaCarret* _tmp3_;
		BirdFontTextAreaCarret* _tmp4_;
		BirdFontTextAreaCarret* _tmp5_;
		_tmp3_ = self->priv->carret;
		_tmp4_ = self->priv->carret;
		_tmp5_ = bird_font_text_area_get_carret_at (self, (_tmp3_->desired_x - ((BirdFontWidget*) self)->widget_x) - self->padding, _tmp4_->desired_y + nr, TRUE);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp5_;
	}
}

void
bird_font_text_area_move_carret_to_end_of_line (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = bird_font_text_area_get_carret_at (self, (((BirdFontWidget*) self)->widget_x + self->padding) + self->width, _tmp0_->desired_y, FALSE);
	_g_object_unref0 (self->priv->carret);
	self->priv->carret = _tmp1_;
}

void
bird_font_text_area_move_carret_to_beginning_of_line (BirdFontTextArea* self)
{
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = bird_font_text_area_get_carret_at (self, ((BirdFontWidget*) self)->widget_x, _tmp0_->desired_y, FALSE);
	_g_object_unref0 (self->priv->carret);
	self->priv->carret = _tmp1_;
}

void
bird_font_text_area_move_carret_previous_row (BirdFontTextArea* self)
{
	gdouble nr = 0.0;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	g_return_if_fail (self != NULL);
	nr = -self->font_size;
	_tmp0_ = self->priv->carret;
	if ((_tmp0_->desired_y - (2 * self->font_size)) < ((gdouble) 0)) {
		g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_SCROLL_SIGNAL], 0, -2 * self->font_size);
		nr = self->font_size;
	}
	_tmp1_ = self->priv->carret;
	if ((_tmp1_->desired_y + nr) > (((BirdFontWidget*) self)->widget_y + self->padding)) {
		BirdFontTextAreaCarret* _tmp2_;
		BirdFontTextAreaCarret* _tmp3_;
		BirdFontTextAreaCarret* _tmp4_;
		_tmp2_ = self->priv->carret;
		_tmp3_ = self->priv->carret;
		_tmp4_ = bird_font_text_area_get_carret_at (self, _tmp2_->desired_x, _tmp3_->desired_y + nr, TRUE);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp4_;
	}
}

gboolean
bird_font_text_area_has_selection (BirdFontTextArea* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->show_selection) {
		_tmp0_ = bird_font_text_area_selection_is_visible (self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
bird_font_text_area_selection_is_visible (BirdFontTextArea* self)
{
	gboolean _tmp0_ = FALSE;
	BirdFontTextAreaCarret* _tmp1_;
	BirdFontTextAreaCarret* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->carret;
	_tmp2_ = self->priv->selection_end;
	if (_tmp1_->paragraph != _tmp2_->paragraph) {
		_tmp0_ = TRUE;
	} else {
		BirdFontTextAreaCarret* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		BirdFontTextAreaCarret* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp3_ = self->priv->carret;
		_tmp4_ = bird_font_text_area_carret_get_character_index (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->selection_end;
		_tmp7_ = bird_font_text_area_carret_get_character_index (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp5_ != _tmp8_;
	}
	result = _tmp0_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
bird_font_text_area_insert_text (BirdFontTextArea* self,
                                 const gchar* t)
{
	gchar* s = NULL;
	BirdFontTextAreaParagraph* paragraph = NULL;
	BirdFontTextAreaTextUndoItem* ui = NULL;
	GeeArrayList* pgs = NULL;
	gboolean u = FALSE;
	GeeArrayList* _tmp0_;
	gboolean _tmp23_ = FALSE;
	BirdFontTextAreaCarret* _tmp34_;
	GeeArrayList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GeeArrayList* _tmp39_;
	BirdFontTextAreaCarret* _tmp40_;
	gpointer _tmp41_;
	GeeArrayList* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	u = FALSE;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (pgs);
	pgs = _tmp0_;
	if (self->single_line) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GeeArrayList* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = string_replace (t, "\n", "");
		_tmp2_ = _tmp1_;
		_tmp3_ = string_replace (_tmp2_, "\r", "");
		_g_free0 (s);
		s = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp4_ = pgs;
		_tmp5_ = s;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	} else {
		if (string_last_index_of (t, "\n", 0) > 0) {
			gchar** parts = NULL;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint parts_length1;
			gint _parts_size_;
			gint i = 0;
			GeeArrayList* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			gchar** _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			_tmp7_ = _tmp6_ = g_strsplit (t, "\n", 0);
			parts = _tmp7_;
			parts_length1 = _vala_array_length (_tmp6_);
			_parts_size_ = parts_length1;
			{
				gboolean _tmp8_ = FALSE;
				i = 0;
				_tmp8_ = TRUE;
				while (TRUE) {
					gchar** _tmp10_;
					gint _tmp10__length1;
					GeeArrayList* _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					const gchar* _tmp13_;
					GeeArrayList* _tmp14_;
					if (!_tmp8_) {
						gint _tmp9_;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp10_ = parts;
					_tmp10__length1 = parts_length1;
					if (!(i < (_tmp10__length1 - 1))) {
						break;
					}
					_tmp11_ = pgs;
					_tmp12_ = parts;
					_tmp12__length1 = parts_length1;
					_tmp13_ = _tmp12_[i];
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp13_);
					_tmp14_ = pgs;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "\n");
				}
			}
			_tmp15_ = pgs;
			_tmp16_ = parts;
			_tmp16__length1 = parts_length1;
			_tmp17_ = parts;
			_tmp17__length1 = parts_length1;
			_tmp18_ = _tmp16_[_tmp17__length1 - 1];
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp18_);
			if (g_str_has_suffix (t, "\n")) {
				GeeArrayList* _tmp19_;
				_tmp19_ = pgs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "\n");
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gchar* _tmp20_;
			GeeArrayList* _tmp21_;
			const gchar* _tmp22_;
			_tmp20_ = g_strdup (t);
			_g_free0 (s);
			s = _tmp20_;
			_tmp21_ = pgs;
			_tmp22_ = s;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
		}
	}
	if (bird_font_text_area_has_selection (self)) {
		_tmp23_ = self->show_selection;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		BirdFontTextAreaTextUndoItem* _tmp24_;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp24_ = bird_font_text_area_delete_selected_text (self);
		_g_object_unref0 (ui);
		ui = _tmp24_;
		u = TRUE;
		_tmp25_ = self->priv->paragraphs;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == 0) {
			GeeArrayList* _tmp28_;
			BirdFontColor* _tmp29_;
			BirdFontTextAreaParagraph* _tmp30_;
			BirdFontTextAreaParagraph* _tmp31_;
			_tmp28_ = self->priv->paragraphs;
			_tmp29_ = self->text_color;
			_tmp30_ = bird_font_text_area_paragraph_new ("", self->font_size, 0, _tmp29_);
			_tmp31_ = _tmp30_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
			_g_object_unref0 (_tmp31_);
		}
	} else {
		BirdFontTextAreaCarret* _tmp32_;
		BirdFontTextAreaTextUndoItem* _tmp33_;
		_tmp32_ = self->priv->carret;
		_tmp33_ = bird_font_text_area_text_undo_item_new (_tmp32_);
		_g_object_unref0 (ui);
		ui = _tmp33_;
	}
	_tmp34_ = self->priv->carret;
	_tmp35_ = self->priv->paragraphs;
	_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = _tmp34_->paragraph;
	g_return_if_fail ((0 <= _tmp38_) && (_tmp38_ < _tmp37_));
	_tmp39_ = self->priv->paragraphs;
	_tmp40_ = self->priv->carret;
	_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_->paragraph);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp41_;
	_tmp42_ = pgs;
	_tmp43_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ > 0) {
		gchar* first = NULL;
		GeeArrayList* _tmp50_;
		gpointer _tmp51_;
		gchar* end = NULL;
		gchar* nt = NULL;
		BirdFontTextAreaParagraph* _tmp52_;
		const gchar* _tmp53_;
		BirdFontTextAreaCarret* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		BirdFontTextAreaParagraph* _tmp61_;
		const gchar* _tmp62_;
		BirdFontTextAreaCarret* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gchar* _tmp66_;
		BirdFontTextAreaParagraph* _tmp67_;
		const gchar* _tmp68_;
		gint paragraph_index = 0;
		BirdFontTextAreaCarret* _tmp69_;
		BirdFontTextAreaParagraph* next_paragraph = NULL;
		BirdFontTextAreaParagraph* _tmp70_;
		BirdFontTextAreaParagraph* _tmp71_;
		BirdFontTextAreaCarret* _tmp88_;
		BirdFontTextAreaCarret* _tmp89_;
		BirdFontTextAreaParagraph* _tmp90_;
		const gchar* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		BirdFontTextAreaParagraph* _tmp94_;
		BirdFontTextAreaParagraph* _tmp95_;
		const gchar* _tmp96_;
		const gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		if (!u) {
			BirdFontTextAreaTextUndoItem* _tmp45_;
			GeeArrayList* _tmp46_;
			BirdFontTextAreaParagraph* _tmp47_;
			BirdFontTextAreaParagraph* _tmp48_;
			BirdFontTextAreaParagraph* _tmp49_;
			_tmp45_ = ui;
			_tmp46_ = _tmp45_->edited;
			_tmp47_ = paragraph;
			_tmp48_ = bird_font_text_area_paragraph_copy (_tmp47_);
			_tmp49_ = _tmp48_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp49_);
			_g_object_unref0 (_tmp49_);
		}
		_tmp50_ = pgs;
		_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, 0);
		first = (gchar*) _tmp51_;
		_tmp52_ = paragraph;
		_tmp53_ = _tmp52_->text;
		_tmp54_ = self->priv->carret;
		_tmp55_ = bird_font_text_area_carret_get_character_index (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = string_substring (_tmp53_, (glong) 0, (glong) _tmp56_);
		nt = _tmp57_;
		_tmp58_ = nt;
		_tmp59_ = first;
		_tmp60_ = g_strconcat (_tmp58_, _tmp59_, NULL);
		_g_free0 (nt);
		nt = _tmp60_;
		_tmp61_ = paragraph;
		_tmp62_ = _tmp61_->text;
		_tmp63_ = self->priv->carret;
		_tmp64_ = bird_font_text_area_carret_get_character_index (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = string_substring (_tmp62_, (glong) _tmp65_, (glong) -1);
		_g_free0 (end);
		end = _tmp66_;
		_tmp67_ = paragraph;
		_tmp68_ = nt;
		bird_font_text_area_paragraph_set_text (_tmp67_, _tmp68_);
		_tmp69_ = self->priv->carret;
		paragraph_index = _tmp69_->paragraph;
		_tmp70_ = paragraph;
		_tmp71_ = _g_object_ref0 (_tmp70_);
		next_paragraph = _tmp71_;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp72_ = FALSE;
				_tmp72_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					gint _tmp77_;
					gchar* next = NULL;
					GeeArrayList* _tmp78_;
					gpointer _tmp79_;
					const gchar* _tmp80_;
					BirdFontColor* _tmp81_;
					BirdFontTextAreaParagraph* _tmp82_;
					GeeArrayList* _tmp83_;
					BirdFontTextAreaParagraph* _tmp84_;
					BirdFontTextAreaTextUndoItem* _tmp85_;
					GeeArrayList* _tmp86_;
					BirdFontTextAreaParagraph* _tmp87_;
					if (!_tmp72_) {
						gint _tmp73_;
						_tmp73_ = i;
						i = _tmp73_ + 1;
					}
					_tmp72_ = FALSE;
					_tmp74_ = pgs;
					_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
					_tmp76_ = _tmp75_;
					if (!(i < _tmp76_)) {
						break;
					}
					_tmp77_ = paragraph_index;
					paragraph_index = _tmp77_ + 1;
					_tmp78_ = pgs;
					_tmp79_ = gee_abstract_list_get ((GeeAbstractList*) _tmp78_, i);
					next = (gchar*) _tmp79_;
					_tmp80_ = next;
					_tmp81_ = self->text_color;
					_tmp82_ = bird_font_text_area_paragraph_new (_tmp80_, self->font_size, paragraph_index, _tmp81_);
					_g_object_unref0 (next_paragraph);
					next_paragraph = _tmp82_;
					_tmp83_ = self->priv->paragraphs;
					_tmp84_ = next_paragraph;
					gee_abstract_list_insert ((GeeAbstractList*) _tmp83_, paragraph_index, _tmp84_);
					_tmp85_ = ui;
					_tmp86_ = _tmp85_->added;
					_tmp87_ = next_paragraph;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
					u = TRUE;
					_g_free0 (next);
				}
			}
		}
		_tmp88_ = self->priv->carret;
		_tmp88_->paragraph = paragraph_index;
		_tmp89_ = self->priv->carret;
		_tmp90_ = next_paragraph;
		_tmp91_ = _tmp90_->text;
		_tmp92_ = strlen (_tmp91_);
		_tmp93_ = _tmp92_;
		bird_font_text_area_carret_set_character_index (_tmp89_, _tmp93_);
		_tmp94_ = next_paragraph;
		_tmp95_ = next_paragraph;
		_tmp96_ = _tmp95_->text;
		_tmp97_ = end;
		_tmp98_ = g_strconcat (_tmp96_, _tmp97_, NULL);
		_tmp99_ = _tmp98_;
		bird_font_text_area_paragraph_set_text (_tmp94_, _tmp99_);
		_g_free0 (_tmp99_);
		_g_object_unref0 (next_paragraph);
		_g_free0 (nt);
		_g_free0 (end);
		_g_free0 (first);
	}
	if (u) {
		GeeArrayList* _tmp100_;
		BirdFontTextAreaTextUndoItem* _tmp101_;
		GeeArrayList* _tmp102_;
		_tmp100_ = self->priv->undo_items;
		_tmp101_ = ui;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp101_);
		_tmp102_ = self->priv->redo_items;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp102_);
	}
	bird_font_text_area_update_paragraph_index (self);
	bird_font_widget_layout ((BirdFontWidget*) self);
	_tmp103_ = bird_font_text_area_get_text (self);
	_tmp104_ = _tmp103_;
	g_signal_emit (self, bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL], 0, _tmp104_);
	_g_free0 (_tmp104_);
	self->show_selection = FALSE;
	_g_object_unref0 (pgs);
	_g_object_unref0 (ui);
	_g_object_unref0 (paragraph);
	_g_free0 (s);
}

gchar*
bird_font_text_area_get_text (BirdFontTextArea* self)
{
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	bird_font_text_area_generate_all_paragraphs (self);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = self->priv->paragraphs;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontTextAreaParagraph* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GString* _tmp9_;
			BirdFontTextAreaParagraph* _tmp10_;
			const gchar* _tmp11_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontTextAreaParagraph*) _tmp8_;
			_tmp9_ = sb;
			_tmp10_ = p;
			_tmp11_ = _tmp10_->text;
			g_string_append (_tmp9_, _tmp11_);
			_g_object_unref0 (p);
		}
	}
	_tmp12_ = sb;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (sb);
	return result;
}

static Block90Data*
block90_data_ref (Block90Data* _data90_)
{
	g_atomic_int_inc (&_data90_->_ref_count_);
	return _data90_;
}

static void
block90_data_unref (void * _userdata_)
{
	Block90Data* _data90_;
	_data90_ = (Block90Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data90_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data90_->self;
		_g_object_unref0 (_data90_->c);
		_g_object_unref0 (self);
		g_slice_free (Block90Data, _data90_);
	}
}

static Block91Data*
block91_data_ref (Block91Data* _data91_)
{
	g_atomic_int_inc (&_data91_->_ref_count_);
	return _data91_;
}

static void
block91_data_unref (void * _userdata_)
{
	Block91Data* _data91_;
	_data91_ = (Block91Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data91_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data91_->_data90_->self;
		_g_object_unref0 (_data91_->next_word);
		block90_data_unref (_data91_->_data90_);
		_data91_->_data90_ = NULL;
		g_slice_free (Block91Data, _data91_);
	}
}

static void
__________lambda511_ (Block91Data* _data91_,
                      BirdFontGlyph* glyph,
                      gdouble kerning,
                      gboolean last)
{
	Block90Data* _data90_;
	BirdFontTextArea* self;
	gdouble cw = 0.0;
	gint ci = 0;
	gdouble d = 0.0;
	gchar* gc = NULL;
	gchar* _tmp0_;
	BirdFontText* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	_data90_ = _data91_->_data90_;
	self = _data90_->self;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = g_unichar_to_string (bird_font_glyph_get_unichar (glyph));
	gc = (gchar*) _tmp0_;
	d = fabs (_data90_->click_x - _data90_->tx);
	if (d <= _data90_->min_d) {
		BirdFontTextAreaCarret* _tmp1_;
		BirdFontTextAreaCarret* _tmp2_;
		_data90_->min_d = d;
		_tmp1_ = _data90_->c;
		bird_font_text_area_carret_set_character_index (_tmp1_, _data90_->ch_index);
		_tmp2_ = _data90_->c;
		_tmp2_->paragraph = _data90_->i;
	}
	_tmp3_ = _data91_->next_word;
	cw = (bird_font_glyph_get_width (glyph) * bird_font_text_get_font_scale (_tmp3_)) + kerning;
	_tmp4_ = gc;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	ci = _tmp6_;
	_data90_->tx += cw;
	_data90_->ch_index += ci;
	_g_free0 (gc);
}

static void
___________lambda511__bird_font_text_iterator (BirdFontGlyph* glyph,
                                               gdouble kerning,
                                               gboolean last,
                                               gpointer self)
{
	__________lambda511_ (self, glyph, kerning, last);
}

static BirdFontTextAreaCarret*
bird_font_text_area_get_carret_at (BirdFontTextArea* self,
                                   gdouble click_x,
                                   gdouble click_y,
                                   gboolean check_boundaries)
{
	Block90Data* _data90_;
	gdouble ty = 0.0;
	gdouble p = 0.0;
	gchar* w = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	gdouble dt = 0.0;
	BirdFontTextAreaCarret* _tmp1_;
	BirdFontTextAreaCarret* _tmp2_;
	BirdFontTextAreaCarret* _tmp3_;
	BirdFontTextAreaCarret* _tmp69_;
	BirdFontTextAreaCarret* _tmp90_;
	BirdFontTextAreaCarret* _tmp91_;
	BirdFontTextAreaCarret* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data90_ = g_slice_new0 (Block90Data);
	_data90_->_ref_count_ = 1;
	_data90_->self = g_object_ref (self);
	_data90_->click_x = click_x;
	_data90_->i = 0;
	_data90_->min_d = DBL_MAX;
	_tmp0_ = bird_font_text_area_carret_new ();
	_data90_->c = _tmp0_;
	_tmp1_ = _data90_->c;
	_tmp1_->paragraph = -1;
	_tmp2_ = _data90_->c;
	_tmp2_->desired_x = _data90_->click_x;
	_tmp3_ = _data90_->c;
	_tmp3_->desired_y = click_y;
	{
		GeeArrayList* _paragraph_list = NULL;
		GeeArrayList* _tmp4_;
		gint _paragraph_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _paragraph_index = 0;
		_tmp4_ = self->priv->paragraphs;
		_paragraph_list = _tmp4_;
		_tmp5_ = _paragraph_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_paragraph_size = _tmp7_;
		_paragraph_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontTextAreaParagraph* paragraph = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			gint _tmp68_;
			_paragraph_index = _paragraph_index + 1;
			_tmp8_ = _paragraph_index;
			_tmp9_ = _paragraph_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _paragraph_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _paragraph_index);
			paragraph = (BirdFontTextAreaParagraph*) _tmp11_;
			if (!check_boundaries) {
				_tmp12_ = TRUE;
			} else {
				BirdFontTextAreaParagraph* _tmp13_;
				BirdFontWidgetAllocation* _tmp14_;
				_tmp13_ = paragraph;
				_tmp14_ = ((BirdFontWidget*) self)->allocation;
				_tmp12_ = bird_font_text_area_paragraph_text_is_on_screen (_tmp13_, _tmp14_, ((BirdFontWidget*) self)->widget_y);
			}
			if (_tmp12_) {
				BirdFontTextAreaParagraph* _tmp15_;
				BirdFontTextAreaParagraph* _tmp16_;
				gdouble _tmp17_;
				_data90_->ch_index = 0;
				_tmp15_ = paragraph;
				_tmp16_ = paragraph;
				_tmp17_ = click_y;
				if ((((_tmp15_->start_y + ((BirdFontWidget*) self)->widget_y) - self->font_size) <= _tmp17_) && (_tmp17_ <= ((_tmp16_->end_y + ((BirdFontWidget*) self)->widget_y) + self->font_size))) {
					{
						GeeArrayList* _next_word_list = NULL;
						BirdFontTextAreaParagraph* _tmp18_;
						GeeArrayList* _tmp19_;
						GeeArrayList* _tmp20_;
						gint _next_word_size = 0;
						GeeArrayList* _tmp21_;
						gint _tmp22_;
						gint _tmp23_;
						gint _next_word_index = 0;
						_tmp18_ = paragraph;
						_tmp19_ = bird_font_text_area_paragraph_get_words (_tmp18_);
						_tmp20_ = _tmp19_;
						_next_word_list = _tmp20_;
						_tmp21_ = _next_word_list;
						_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
						_tmp23_ = _tmp22_;
						_next_word_size = _tmp23_;
						_next_word_index = -1;
						while (TRUE) {
							Block91Data* _data91_;
							gint _tmp24_;
							gint _tmp25_;
							GeeArrayList* _tmp26_;
							gpointer _tmp27_;
							gdouble tt_click = 0.0;
							BirdFontText* _tmp28_;
							const gchar* _tmp29_;
							gchar* _tmp30_;
							BirdFontText* _tmp31_;
							BirdFontText* _tmp32_;
							gdouble _tmp33_;
							_data91_ = g_slice_new0 (Block91Data);
							_data91_->_ref_count_ = 1;
							_data91_->_data90_ = block90_data_ref (_data90_);
							_next_word_index = _next_word_index + 1;
							_tmp24_ = _next_word_index;
							_tmp25_ = _next_word_size;
							if (!(_tmp24_ < _tmp25_)) {
								block91_data_unref (_data91_);
								_data91_ = NULL;
								break;
							}
							_tmp26_ = _next_word_list;
							_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _next_word_index);
							_data91_->next_word = (BirdFontText*) _tmp27_;
							tt_click = ((click_y - ((BirdFontWidget*) self)->widget_y) - self->padding) + self->font_size;
							_tmp28_ = _data91_->next_word;
							_tmp29_ = _tmp28_->text;
							_tmp30_ = g_strdup (_tmp29_);
							_g_free0 (w);
							w = _tmp30_;
							_tmp31_ = _data91_->next_word;
							_tmp32_ = _data91_->next_word;
							_tmp33_ = tt_click;
							if ((((BirdFontWidget*) _tmp31_)->widget_y <= _tmp33_) && (_tmp33_ <= (((BirdFontWidget*) _tmp32_)->widget_y + self->font_size))) {
								BirdFontText* _tmp34_;
								gboolean _tmp35_ = FALSE;
								BirdFontText* _tmp36_;
								BirdFontText* _tmp37_;
								gdouble _tmp38_;
								_tmp34_ = _data91_->next_word;
								p = bird_font_text_get_sidebearing_extent (_tmp34_);
								_tmp36_ = _data91_->next_word;
								_tmp37_ = _data91_->next_word;
								_tmp38_ = tt_click;
								if ((((BirdFontWidget*) _tmp36_)->widget_y <= _tmp38_) && (_tmp38_ <= (((BirdFontWidget*) _tmp37_)->widget_y + self->font_size))) {
									BirdFontText* _tmp39_;
									BirdFontText* _tmp40_;
									BirdFontText* _tmp41_;
									gdouble _tmp42_;
									_tmp39_ = _data91_->next_word;
									_tmp40_ = _data91_->next_word;
									_tmp41_ = _data91_->next_word;
									_tmp42_ = _data90_->click_x;
									_tmp35_ = ((((BirdFontWidget*) _tmp39_)->widget_x + ((BirdFontWidget*) self)->widget_x) <= _tmp42_) && (_tmp42_ <= (((((BirdFontWidget*) _tmp40_)->widget_x + ((BirdFontWidget*) self)->widget_x) + self->padding) + bird_font_text_get_sidebearing_extent (_tmp41_)));
								} else {
									_tmp35_ = FALSE;
								}
								if (_tmp35_) {
									BirdFontText* _tmp43_;
									BirdFontText* _tmp44_;
									BirdFontText* _tmp45_;
									_tmp43_ = _data91_->next_word;
									_data90_->tx = (((BirdFontWidget*) self)->widget_x + ((BirdFontWidget*) _tmp43_)->widget_x) + self->padding;
									_tmp44_ = _data91_->next_word;
									ty = (((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp44_)->widget_y) + self->padding;
									_tmp45_ = _data91_->next_word;
									bird_font_text_iterate (_tmp45_, ___________lambda511__bird_font_text_iterator, _data91_);
									dt = fabs (_data90_->click_x - ((_data90_->tx + ((BirdFontWidget*) self)->widget_x) + self->padding));
									if (dt < _data90_->min_d) {
										BirdFontTextAreaCarret* _tmp46_;
										BirdFontTextAreaCarret* _tmp47_;
										_data90_->min_d = dt;
										_tmp46_ = _data90_->c;
										bird_font_text_area_carret_set_character_index (_tmp46_, _data90_->ch_index);
										_tmp47_ = _data90_->c;
										_tmp47_->paragraph = _data90_->i;
									}
								} else {
									BirdFontText* _tmp48_;
									BirdFontText* _tmp49_;
									const gchar* _tmp62_;
									gint _tmp63_;
									gint _tmp64_;
									_tmp48_ = _data91_->next_word;
									_tmp49_ = _data91_->next_word;
									dt = fabs (_data90_->click_x - (((((BirdFontWidget*) _tmp48_)->widget_x + ((BirdFontWidget*) self)->widget_x) + self->padding) + bird_font_text_get_sidebearing_extent (_tmp49_)));
									if (dt < _data90_->min_d) {
										BirdFontTextAreaCarret* _tmp50_;
										const gchar* _tmp51_;
										gint _tmp52_;
										gint _tmp53_;
										const gchar* _tmp54_;
										BirdFontTextAreaCarret* _tmp61_;
										_data90_->min_d = dt;
										_tmp50_ = _data90_->c;
										_tmp51_ = w;
										_tmp52_ = strlen (_tmp51_);
										_tmp53_ = _tmp52_;
										bird_font_text_area_carret_set_character_index (_tmp50_, _data90_->ch_index + _tmp53_);
										_tmp54_ = w;
										if (g_str_has_suffix (_tmp54_, "\n")) {
											BirdFontTextAreaCarret* _tmp55_;
											BirdFontTextAreaCarret* _tmp56_;
											gint _tmp57_;
											gint _tmp58_;
											gint _tmp59_;
											gint _tmp60_;
											_tmp55_ = _data90_->c;
											_tmp56_ = _data90_->c;
											_tmp57_ = bird_font_text_area_carret_get_character_index (_tmp56_);
											_tmp58_ = _tmp57_;
											_tmp59_ = strlen ("\n");
											_tmp60_ = _tmp59_;
											bird_font_text_area_carret_set_character_index (_tmp56_, _tmp58_ - _tmp60_);
										}
										_tmp61_ = _data90_->c;
										_tmp61_->paragraph = _data90_->i;
									}
									_tmp62_ = w;
									_tmp63_ = strlen (_tmp62_);
									_tmp64_ = _tmp63_;
									_data90_->ch_index += _tmp64_;
								}
							} else {
								const gchar* _tmp65_;
								gint _tmp66_;
								gint _tmp67_;
								_tmp65_ = w;
								_tmp66_ = strlen (_tmp65_);
								_tmp67_ = _tmp66_;
								_data90_->ch_index += _tmp67_;
							}
							block91_data_unref (_data91_);
							_data91_ = NULL;
						}
					}
				}
			}
			_tmp68_ = _data90_->i;
			_data90_->i = _tmp68_ + 1;
			_g_object_unref0 (paragraph);
		}
	}
	_tmp69_ = _data90_->c;
	if (G_UNLIKELY (_tmp69_->paragraph < 0)) {
		gint _tmp70_ = 0;
		GeeArrayList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		BirdFontTextAreaCarret* _tmp77_;
		gint _tmp78_ = 0;
		GeeArrayList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		BirdFontTextAreaCarret* _tmp89_;
		_tmp71_ = self->priv->paragraphs;
		_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		if (_tmp73_ > 0) {
			GeeArrayList* _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			_tmp74_ = self->priv->paragraphs;
			_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
			_tmp76_ = _tmp75_;
			_tmp70_ = _tmp76_ - 1;
		} else {
			_tmp70_ = 0;
		}
		_tmp77_ = _data90_->c;
		_tmp77_->paragraph = _tmp70_;
		_tmp79_ = self->priv->paragraphs;
		_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		if (_tmp81_ > 0) {
			GeeArrayList* _tmp82_;
			BirdFontTextAreaCarret* _tmp83_;
			gpointer _tmp84_;
			BirdFontTextAreaParagraph* _tmp85_;
			const gchar* _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			_tmp82_ = self->priv->paragraphs;
			_tmp83_ = _data90_->c;
			_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, _tmp83_->paragraph);
			_tmp85_ = (BirdFontTextAreaParagraph*) _tmp84_;
			_tmp86_ = _tmp85_->text;
			_tmp87_ = strlen (_tmp86_);
			_tmp88_ = _tmp87_;
			_tmp78_ = _tmp88_;
			_g_object_unref0 (_tmp85_);
		} else {
			_tmp78_ = 0;
		}
		_tmp89_ = _data90_->c;
		bird_font_text_area_carret_set_character_index (_tmp89_, _tmp78_);
	}
	self->priv->store_undo_state_at_next_event = TRUE;
	_tmp90_ = _data90_->c;
	_tmp91_ = _g_object_ref0 (_tmp90_);
	result = _tmp91_;
	_g_free0 (w);
	block90_data_unref (_data90_);
	_data90_ = NULL;
	return result;
}

/** @return offset to click in text. */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_text_area_real_layout (BirdFontWidget* base)
{
	BirdFontTextArea * self;
	gdouble p = 0.0;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gchar* w = NULL;
	gdouble xmax = 0.0;
	gint i = 0;
	gdouble dd = 0.0;
	gboolean _tmp0_ = FALSE;
	BirdFontWidgetAllocation* _tmp1_;
	gboolean _tmp74_ = FALSE;
	BirdFontWidgetAllocation* _tmp75_;
	self = (BirdFontTextArea*) base;
	xmax = (gdouble) 0;
	i = 0;
	tx = (gdouble) 0;
	ty = self->font_size;
	_tmp1_ = ((BirdFontWidget*) self)->allocation;
	if (_tmp1_->width <= 0) {
		_tmp0_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp2_;
		_tmp2_ = ((BirdFontWidget*) self)->allocation;
		_tmp0_ = _tmp2_->height <= 0;
	}
	if (_tmp0_) {
		g_warning ("TextArea.vala:894: Parent widget allocation is not set.");
	}
	{
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = self->priv->paragraphs;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		i = _tmp5_ - 1;
		_tmp6_ = TRUE;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontTextAreaParagraph* _tmp14_;
			gboolean _tmp15_;
			if (!_tmp6_) {
				gint _tmp7_;
				_tmp7_ = i;
				i = _tmp7_ - 1;
			}
			_tmp6_ = FALSE;
			if (i >= 0) {
				GeeArrayList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = self->priv->paragraphs;
				_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp8_ = _tmp11_ > 1;
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp12_ = self->priv->paragraphs;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
			_tmp14_ = (BirdFontTextAreaParagraph*) _tmp13_;
			_tmp15_ = G_UNLIKELY (bird_font_text_area_paragraph_is_empty (_tmp14_));
			_g_object_unref0 (_tmp14_);
			if (_tmp15_) {
				GeeArrayList* _tmp16_;
				gpointer _tmp17_;
				BirdFontTextAreaParagraph* _tmp18_;
				g_warning ("TextArea.vala:899: Empty paragraph.");
				_tmp16_ = self->priv->paragraphs;
				_tmp17_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp16_, i);
				_tmp18_ = (BirdFontTextAreaParagraph*) _tmp17_;
				_g_object_unref0 (_tmp18_);
				bird_font_text_area_update_paragraph_index (self);
			}
		}
	}
	i = 0;
	{
		GeeArrayList* _paragraph_list = NULL;
		GeeArrayList* _tmp19_;
		gint _paragraph_size = 0;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _paragraph_index = 0;
		_tmp19_ = self->priv->paragraphs;
		_paragraph_list = _tmp19_;
		_tmp20_ = _paragraph_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_paragraph_size = _tmp22_;
		_paragraph_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			BirdFontTextAreaParagraph* paragraph = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			gboolean _tmp27_ = FALSE;
			BirdFontTextAreaParagraph* _tmp28_;
			BirdFontTextAreaParagraph* _tmp71_;
			BirdFontTextAreaParagraph* _tmp72_;
			gint _tmp73_;
			_paragraph_index = _paragraph_index + 1;
			_tmp23_ = _paragraph_index;
			_tmp24_ = _paragraph_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _paragraph_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _paragraph_index);
			paragraph = (BirdFontTextAreaParagraph*) _tmp26_;
			_tmp28_ = paragraph;
			if (_tmp28_->need_layout) {
				_tmp27_ = TRUE;
			} else {
				gboolean _tmp29_ = FALSE;
				BirdFontTextAreaParagraph* _tmp30_;
				_tmp30_ = paragraph;
				if (_tmp30_->text_area_width != self->width) {
					BirdFontTextAreaParagraph* _tmp31_;
					BirdFontWidgetAllocation* _tmp32_;
					_tmp31_ = paragraph;
					_tmp32_ = ((BirdFontWidget*) self)->allocation;
					_tmp29_ = bird_font_text_area_paragraph_text_is_on_screen (_tmp31_, _tmp32_, ((BirdFontWidget*) self)->widget_y);
				} else {
					_tmp29_ = FALSE;
				}
				_tmp27_ = _tmp29_;
			}
			if (_tmp27_) {
				BirdFontTextAreaParagraph* _tmp33_;
				BirdFontTextAreaParagraph* _tmp34_;
				BirdFontTextAreaParagraph* _tmp35_;
				BirdFontTextAreaParagraph* _tmp66_;
				BirdFontTextAreaParagraph* _tmp67_;
				BirdFontTextAreaParagraph* _tmp68_;
				BirdFontTextAreaParagraph* _tmp69_;
				BirdFontTextAreaParagraph* _tmp70_;
				_tmp33_ = paragraph;
				_tmp33_->start_y = ty;
				_tmp34_ = paragraph;
				_tmp34_->start_x = tx;
				_tmp35_ = paragraph;
				_cairo_surface_destroy0 (_tmp35_->cached_surface);
				_tmp35_->cached_surface = NULL;
				{
					GeeArrayList* _next_word_list = NULL;
					BirdFontTextAreaParagraph* _tmp36_;
					GeeArrayList* _tmp37_;
					GeeArrayList* _tmp38_;
					gint _next_word_size = 0;
					GeeArrayList* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					gint _next_word_index = 0;
					_tmp36_ = paragraph;
					_tmp37_ = bird_font_text_area_paragraph_get_words (_tmp36_);
					_tmp38_ = _tmp37_;
					_next_word_list = _tmp38_;
					_tmp39_ = _next_word_list;
					_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
					_tmp41_ = _tmp40_;
					_next_word_size = _tmp41_;
					_next_word_index = -1;
					while (TRUE) {
						gint _tmp42_;
						gint _tmp43_;
						BirdFontText* next_word = NULL;
						GeeArrayList* _tmp44_;
						gpointer _tmp45_;
						BirdFontText* _tmp46_;
						BirdFontText* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						BirdFontText* _tmp50_;
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						_next_word_index = _next_word_index + 1;
						_tmp42_ = _next_word_index;
						_tmp43_ = _next_word_size;
						if (!(_tmp42_ < _tmp43_)) {
							break;
						}
						_tmp44_ = _next_word_list;
						_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _next_word_index);
						next_word = (BirdFontText*) _tmp45_;
						_tmp46_ = next_word;
						bird_font_text_set_font_size (_tmp46_, self->font_size);
						_tmp47_ = next_word;
						_tmp48_ = _tmp47_->text;
						_tmp49_ = g_strdup (_tmp48_);
						_g_free0 (w);
						w = _tmp49_;
						_tmp50_ = next_word;
						p = bird_font_text_get_sidebearing_extent (_tmp50_);
						if (G_UNLIKELY (p == ((gdouble) 0))) {
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							_tmp51_ = w;
							_tmp52_ = string_to_string (_tmp51_);
							_tmp53_ = g_strconcat ("Zero width word: ", _tmp52_, NULL);
							_tmp54_ = _tmp53_;
							g_warning ("TextArea.vala:923: %s", _tmp54_);
							_g_free0 (_tmp54_);
						}
						_tmp55_ = w;
						if (g_strcmp0 (_tmp55_, "") == 0) {
							_g_object_unref0 (next_word);
							break;
						}
						_tmp56_ = w;
						if (g_strcmp0 (_tmp56_, "\n") == 0) {
							BirdFontText* _tmp57_;
							BirdFontText* _tmp58_;
							BirdFontText* _tmp59_;
							_tmp57_ = next_word;
							((BirdFontWidget*) _tmp57_)->widget_x = tx;
							_tmp58_ = next_word;
							((BirdFontWidget*) _tmp58_)->widget_y = ty;
							tx = (gdouble) 0;
							_tmp59_ = next_word;
							ty += _tmp59_->font_size;
						} else {
							BirdFontText* _tmp63_;
							BirdFontText* _tmp64_;
							const gchar* _tmp65_;
							if (!self->single_line) {
								gboolean _tmp60_ = FALSE;
								if (((tx + p) + (2 * self->padding)) > self->width) {
									_tmp60_ = TRUE;
								} else {
									const gchar* _tmp61_;
									_tmp61_ = w;
									_tmp60_ = g_strcmp0 (_tmp61_, "\n") == 0;
								}
								if (_tmp60_) {
									BirdFontText* _tmp62_;
									tx = (gdouble) 0;
									_tmp62_ = next_word;
									ty += _tmp62_->font_size;
								}
							}
							if ((tx + p) > xmax) {
								xmax = tx + p;
							}
							_tmp63_ = next_word;
							((BirdFontWidget*) _tmp63_)->widget_x = tx;
							_tmp64_ = next_word;
							((BirdFontWidget*) _tmp64_)->widget_y = ty;
							_tmp65_ = w;
							if (g_strcmp0 (_tmp65_, "\n") != 0) {
								tx += p;
							}
						}
						_g_object_unref0 (next_word);
					}
				}
				if (tx > xmax) {
					xmax = tx;
				}
				_tmp66_ = paragraph;
				_tmp66_->text_area_width = self->width;
				_tmp67_ = paragraph;
				_tmp67_->width = xmax;
				_tmp68_ = paragraph;
				_tmp68_->end_x = tx;
				_tmp69_ = paragraph;
				_tmp69_->end_y = ty;
				_tmp70_ = paragraph;
				_tmp70_->need_layout = FALSE;
			}
			if (xmax > self->width) {
				_g_object_unref0 (paragraph);
				break;
			}
			_tmp71_ = paragraph;
			tx = _tmp71_->end_x;
			_tmp72_ = paragraph;
			ty = _tmp72_->end_y;
			_tmp73_ = i;
			i = _tmp73_ + 1;
			_g_object_unref0 (paragraph);
		}
	}
	if (xmax > self->width) {
		self->width = xmax + (2 * self->padding);
		bird_font_widget_layout ((BirdFontWidget*) self);
		_g_free0 (w);
		return;
	}
	self->height = fmax (self->min_height, ty + (2 * self->padding));
	if (self->priv->last_paragraph != BIRD_FONT_TEXT_AREA_DONE) {
		self->height = ((self->priv->text_length / ((gdouble) self->priv->last_paragraph)) * ty) + (2 * self->padding);
	}
	_tmp75_ = ((BirdFontWidget*) self)->allocation;
	if ((ty + ((BirdFontWidget*) self)->widget_y) < ((gdouble) _tmp75_->height)) {
		_tmp74_ = self->priv->last_paragraph != BIRD_FONT_TEXT_AREA_DONE;
	} else {
		_tmp74_ = FALSE;
	}
	if (_tmp74_) {
		bird_font_text_area_generate_paragraphs (self);
		bird_font_widget_layout ((BirdFontWidget*) self);
		_g_free0 (w);
		return;
	}
	ty = self->font_size;
	tx = (gdouble) 0;
	{
		GeeArrayList* _paragraph_list = NULL;
		GeeArrayList* _tmp76_;
		gint _paragraph_size = 0;
		GeeArrayList* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		gint _paragraph_index = 0;
		_tmp76_ = self->priv->paragraphs;
		_paragraph_list = _tmp76_;
		_tmp77_ = _paragraph_list;
		_tmp78_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp77_);
		_tmp79_ = _tmp78_;
		_paragraph_size = _tmp79_;
		_paragraph_index = -1;
		while (TRUE) {
			gint _tmp80_;
			gint _tmp81_;
			BirdFontTextAreaParagraph* paragraph = NULL;
			GeeArrayList* _tmp82_;
			gpointer _tmp83_;
			BirdFontTextAreaParagraph* _tmp84_;
			BirdFontTextAreaParagraph* _tmp101_;
			_paragraph_index = _paragraph_index + 1;
			_tmp80_ = _paragraph_index;
			_tmp81_ = _paragraph_size;
			if (!(_tmp80_ < _tmp81_)) {
				break;
			}
			_tmp82_ = _paragraph_list;
			_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, _paragraph_index);
			paragraph = (BirdFontTextAreaParagraph*) _tmp83_;
			_tmp84_ = paragraph;
			dd = ty - _tmp84_->start_y;
			if (dd != ((gdouble) 0)) {
				BirdFontTextAreaParagraph* _tmp85_;
				BirdFontTextAreaParagraph* _tmp86_;
				BirdFontTextAreaParagraph* _tmp87_;
				BirdFontTextAreaParagraph* _tmp88_;
				_tmp85_ = paragraph;
				_tmp86_ = paragraph;
				_tmp86_->start_y = _tmp86_->start_y + dd;
				_tmp87_ = paragraph;
				_tmp88_ = paragraph;
				_tmp88_->end_y = _tmp88_->end_y + dd;
				{
					GeeArrayList* _word_list = NULL;
					BirdFontTextAreaParagraph* _tmp89_;
					GeeArrayList* _tmp90_;
					GeeArrayList* _tmp91_;
					gint _word_size = 0;
					GeeArrayList* _tmp92_;
					gint _tmp93_;
					gint _tmp94_;
					gint _word_index = 0;
					_tmp89_ = paragraph;
					_tmp90_ = bird_font_text_area_paragraph_get_words (_tmp89_);
					_tmp91_ = _tmp90_;
					_word_list = _tmp91_;
					_tmp92_ = _word_list;
					_tmp93_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp92_);
					_tmp94_ = _tmp93_;
					_word_size = _tmp94_;
					_word_index = -1;
					while (TRUE) {
						gint _tmp95_;
						gint _tmp96_;
						BirdFontText* word = NULL;
						GeeArrayList* _tmp97_;
						gpointer _tmp98_;
						BirdFontText* _tmp99_;
						BirdFontText* _tmp100_;
						_word_index = _word_index + 1;
						_tmp95_ = _word_index;
						_tmp96_ = _word_size;
						if (!(_tmp95_ < _tmp96_)) {
							break;
						}
						_tmp97_ = _word_list;
						_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, _word_index);
						word = (BirdFontText*) _tmp98_;
						_tmp99_ = word;
						_tmp100_ = word;
						((BirdFontWidget*) _tmp100_)->widget_y = ((BirdFontWidget*) _tmp100_)->widget_y + dd;
						_g_object_unref0 (word);
					}
				}
			}
			_tmp101_ = paragraph;
			ty = _tmp101_->end_y;
			_g_object_unref0 (paragraph);
		}
	}
	_g_free0 (w);
}

static void
bird_font_text_area_real_button_press (BirdFontWidget* base,
                                       guint button,
                                       gdouble x,
                                       gdouble y)
{
	BirdFontTextArea * self;
	self = (BirdFontTextArea*) base;
	if (bird_font_widget_is_over ((BirdFontWidget*) self, x, y)) {
		BirdFontTextAreaCarret* _tmp0_;
		BirdFontTextAreaCarret* _tmp1_;
		BirdFontTextAreaCarret* _tmp2_;
		_tmp0_ = bird_font_text_area_get_carret_at (self, x, y, TRUE);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp0_;
		_tmp1_ = self->priv->carret;
		_tmp2_ = bird_font_text_area_carret_copy (_tmp1_);
		_g_object_unref0 (self->priv->selection_end);
		self->priv->selection_end = _tmp2_;
		self->priv->update_selection = TRUE;
	}
}

static void
bird_font_text_area_real_button_release (BirdFontWidget* base,
                                         guint button,
                                         gdouble x,
                                         gdouble y)
{
	BirdFontTextArea * self;
	self = (BirdFontTextArea*) base;
	self->priv->update_selection = FALSE;
	self->show_selection = bird_font_text_area_selection_is_visible (self);
}

static gboolean
bird_font_text_area_real_motion (BirdFontWidget* base,
                                 gdouble x,
                                 gdouble y)
{
	BirdFontTextArea * self;
	gboolean result;
	self = (BirdFontTextArea*) base;
	if (self->priv->update_selection) {
		BirdFontTextAreaCarret* _tmp0_;
		_tmp0_ = bird_font_text_area_get_carret_at (self, x, y, TRUE);
		_g_object_unref0 (self->priv->selection_end);
		self->priv->selection_end = _tmp0_;
		self->show_selection = bird_font_text_area_selection_is_visible (self);
	}
	result = self->priv->update_selection;
	return result;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static Block92Data*
block92_data_ref (Block92Data* _data92_)
{
	g_atomic_int_inc (&_data92_->_ref_count_);
	return _data92_;
}

static void
block92_data_unref (void * _userdata_)
{
	Block92Data* _data92_;
	_data92_ = (Block92Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data92_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data92_->self;
		_g_object_unref0 (_data92_->selection_stop);
		_g_object_unref0 (_data92_->selection_start);
		_cairo_destroy0 (_data92_->cr);
		_g_object_unref0 (self);
		g_slice_free (Block92Data, _data92_);
	}
}

static Block93Data*
block93_data_ref (Block93Data* _data93_)
{
	g_atomic_int_inc (&_data93_->_ref_count_);
	return _data93_;
}

static void
block93_data_unref (void * _userdata_)
{
	Block93Data* _data93_;
	_data93_ = (Block93Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data93_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data93_->_data92_->self;
		_g_object_unref0 (_data93_->next_word);
		block92_data_unref (_data93_->_data92_);
		_data93_->_data92_ = NULL;
		g_slice_free (Block93Data, _data93_);
	}
}

static Block94Data*
block94_data_ref (Block94Data* _data94_)
{
	g_atomic_int_inc (&_data94_->_ref_count_);
	return _data94_;
}

static void
block94_data_unref (void * _userdata_)
{
	Block94Data* _data94_;
	_data94_ = (Block94Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data94_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data94_->_data93_->_data92_->self;
		block93_data_unref (_data94_->_data93_);
		_data94_->_data93_ = NULL;
		g_slice_free (Block94Data, _data94_);
	}
}

static void
__________lambda182_ (Block94Data* _data94_,
                      BirdFontGlyph* glyph,
                      gdouble kerning,
                      gboolean last)
{
	Block93Data* _data93_;
	Block92Data* _data92_;
	BirdFontTextArea* self;
	gdouble cwi = 0.0;
	gint ci = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	BirdFontTextAreaCarret* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean draw = FALSE;
	BirdFontText* _tmp21_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	_data93_ = _data94_->_data93_;
	_data92_ = _data93_->_data92_;
	self = _data92_->self;
	g_return_if_fail (glyph != NULL);
	_tmp4_ = _data92_->selection_start;
	_tmp5_ = bird_font_text_area_carret_get_character_index (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_data94_->index >= _tmp6_) {
		_tmp3_ = _data93_->partial_start;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !_data93_->partial_stop;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		BirdFontTextAreaCarret* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = _data92_->selection_stop;
		_tmp10_ = bird_font_text_area_carret_get_character_index (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_data94_->index < _tmp11_) {
			_tmp8_ = !_data93_->partial_start;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_tmp7_ = _data93_->partial_stop;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		BirdFontTextAreaCarret* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		BirdFontTextAreaCarret* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp14_ = _data92_->selection_start;
		_tmp15_ = bird_font_text_area_carret_get_character_index (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _data92_->selection_stop;
		_tmp18_ = bird_font_text_area_carret_get_character_index (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _data94_->index;
		if ((_tmp16_ <= _tmp20_) && (_tmp20_ < _tmp19_)) {
			_tmp13_ = _data93_->partial_start;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			_tmp12_ = _data93_->partial_stop;
		} else {
			_tmp12_ = FALSE;
		}
		_tmp0_ = _tmp12_;
	}
	draw = _tmp0_;
	_tmp21_ = _data93_->next_word;
	cwi = (bird_font_glyph_get_width (glyph) * bird_font_text_get_font_scale (_tmp21_)) + kerning;
	if (draw) {
		gdouble selection_y = 0.0;
		BirdFontText* _tmp22_;
		BirdFontText* _tmp23_;
		BirdFontCachedFont* _tmp24_;
		gdouble _tmp25_;
		gdouble _tmp26_;
		_tmp22_ = _data93_->next_word;
		_tmp23_ = _data93_->next_word;
		_tmp24_ = _tmp23_->cached_font;
		_tmp25_ = bird_font_cached_font_get_bottom_limit (_tmp24_);
		_tmp26_ = _tmp25_;
		selection_y = ((((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp22_)->widget_y) + (_data92_->scale * (-_tmp26_))) - self->font_size;
		cairo_rectangle (_data92_->cr, _data94_->bx - 1, selection_y, cwi + 1, self->font_size);
		cairo_fill (_data92_->cr);
	}
	_data94_->bx += cwi;
	_tmp27_ = g_unichar_to_string (bird_font_glyph_get_unichar (glyph));
	_tmp28_ = (gchar*) _tmp27_;
	_tmp29_ = strlen (_tmp28_);
	_tmp30_ = _tmp29_;
	ci = _tmp30_;
	_g_free0 (_tmp28_);
	_data94_->index += ci;
}

static void
___________lambda182__bird_font_text_iterator (BirdFontGlyph* glyph,
                                               gdouble kerning,
                                               gboolean last,
                                               gpointer self)
{
	__________lambda182_ (self, glyph, kerning, last);
}

static void
bird_font_text_area_real_draw (BirdFontWidget* base,
                               cairo_t* cr)
{
	BirdFontTextArea * self;
	Block92Data* _data92_;
	cairo_t* _tmp0_;
	BirdFontText* word = NULL;
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gchar* w = NULL;
	gdouble width = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble carret_x = 0.0;
	gdouble carret_y = 0.0;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	gint first_visible = 0;
	gint last_visible = 0;
	gint paragraphs_size = 0;
	GeeArrayList* _tmp60_;
	gint _tmp61_;
	gint _tmp62_;
	cairo_t* cc = NULL;
	BirdFontTextAreaParagraph* paragraph = NULL;
	GeeArrayList* _tmp76_;
	gpointer _tmp77_;
	BirdFontTextAreaParagraph* _tmp78_;
	BirdFontTextAreaParagraph* _tmp79_;
	self = (BirdFontTextArea*) base;
	g_return_if_fail (cr != NULL);
	_data92_ = g_slice_new0 (Block92Data);
	_data92_->_ref_count_ = 1;
	_data92_->self = g_object_ref (self);
	_tmp0_ = _cairo_reference0 (cr);
	_cairo_destroy0 (_data92_->cr);
	_data92_->cr = _tmp0_;
	x = ((BirdFontWidget*) self)->widget_x;
	y = ((BirdFontWidget*) self)->widget_y;
	bird_font_widget_layout ((BirdFontWidget*) self);
	if (self->draw_border) {
		cairo_save (_data92_->cr);
		cairo_set_line_width (_data92_->cr, (gdouble) 1);
		bird_font_theme_color (_data92_->cr, "Text Area Background");
		bird_font_widget_draw_rounded_rectangle (_data92_->cr, x, y, self->width, self->height - self->padding, self->padding);
		cairo_fill (_data92_->cr);
		cairo_restore (_data92_->cr);
		cairo_save (_data92_->cr);
		cairo_set_line_width (_data92_->cr, (gdouble) 1);
		bird_font_theme_color (_data92_->cr, "Foreground 1");
		bird_font_widget_draw_rounded_rectangle (_data92_->cr, x, y, self->width, self->height - self->padding, self->padding);
		cairo_stroke (_data92_->cr);
		cairo_restore (_data92_->cr);
	}
	cairo_save (_data92_->cr);
	_tmp1_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (word);
	word = _tmp1_;
	width = self->width - self->padding;
	x += self->padding;
	_tmp2_ = word;
	_data92_->scale = bird_font_text_get_font_scale (_tmp2_);
	y += self->font_size;
	if (bird_font_text_area_has_selection (self)) {
		BirdFontTextAreaCarret* _tmp3_;
		BirdFontTextAreaCarret* _tmp4_;
		tx = (gdouble) 0;
		ty = (gdouble) 0;
		_tmp3_ = bird_font_text_area_get_selection_start (self);
		_g_object_unref0 (_data92_->selection_start);
		_data92_->selection_start = _tmp3_;
		_tmp4_ = bird_font_text_area_get_selection_stop (self);
		_g_object_unref0 (_data92_->selection_stop);
		_data92_->selection_stop = _tmp4_;
		cairo_save (_data92_->cr);
		bird_font_theme_color (_data92_->cr, "Highlighted 1");
		{
			gint i = 0;
			BirdFontTextAreaCarret* _tmp5_;
			_tmp5_ = _data92_->selection_start;
			i = _tmp5_->paragraph;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					BirdFontTextAreaCarret* _tmp8_;
					GeeArrayList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					BirdFontTextAreaParagraph* pg = NULL;
					GeeArrayList* _tmp13_;
					gpointer _tmp14_;
					BirdFontTextAreaParagraph* _tmp15_;
					BirdFontWidgetAllocation* _tmp16_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = _data92_->selection_stop;
					if (!(i <= _tmp8_->paragraph)) {
						break;
					}
					_tmp9_ = self->priv->paragraphs;
					_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = i;
					g_return_if_fail ((0 <= _tmp12_) && (_tmp12_ < _tmp11_));
					_tmp13_ = self->priv->paragraphs;
					_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, i);
					pg = (BirdFontTextAreaParagraph*) _tmp14_;
					_tmp15_ = pg;
					_tmp16_ = ((BirdFontWidget*) self)->allocation;
					if (bird_font_text_area_paragraph_text_is_on_screen (_tmp15_, _tmp16_, ((BirdFontWidget*) self)->widget_y)) {
						gint char_index = 0;
						char_index = 0;
						{
							GeeArrayList* _next_word_list = NULL;
							BirdFontTextAreaParagraph* _tmp17_;
							GeeArrayList* _tmp18_;
							GeeArrayList* _tmp19_;
							gint _next_word_size = 0;
							GeeArrayList* _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gint _next_word_index = 0;
							_tmp17_ = pg;
							_tmp18_ = bird_font_text_area_paragraph_get_words (_tmp17_);
							_tmp19_ = _tmp18_;
							_next_word_list = _tmp19_;
							_tmp20_ = _next_word_list;
							_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
							_tmp22_ = _tmp21_;
							_next_word_size = _tmp22_;
							_next_word_index = -1;
							while (TRUE) {
								Block93Data* _data93_;
								gint _tmp23_;
								gint _tmp24_;
								GeeArrayList* _tmp25_;
								gpointer _tmp26_;
								gdouble cw = 0.0;
								BirdFontText* _tmp27_;
								gboolean paint_background = FALSE;
								gint wl = 0;
								BirdFontText* _tmp28_;
								const gchar* _tmp29_;
								gchar* _tmp30_;
								const gchar* _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								BirdFontText* _tmp34_;
								BirdFontTextAreaCarret* _tmp35_;
								BirdFontTextAreaCarret* _tmp36_;
								gboolean _tmp45_ = FALSE;
								gboolean _tmp53_ = FALSE;
								const gchar* _tmp57_;
								gint _tmp58_;
								gint _tmp59_;
								_data93_ = g_slice_new0 (Block93Data);
								_data93_->_ref_count_ = 1;
								_data93_->_data92_ = block92_data_ref (_data92_);
								_next_word_index = _next_word_index + 1;
								_tmp23_ = _next_word_index;
								_tmp24_ = _next_word_size;
								if (!(_tmp23_ < _tmp24_)) {
									block93_data_unref (_data93_);
									_data93_ = NULL;
									break;
								}
								_tmp25_ = _next_word_list;
								_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _next_word_index);
								_data93_->next_word = (BirdFontText*) _tmp26_;
								_tmp27_ = _data93_->next_word;
								cw = bird_font_text_get_sidebearing_extent (_tmp27_);
								paint_background = FALSE;
								_data93_->partial_start = FALSE;
								_data93_->partial_stop = FALSE;
								_tmp28_ = _data93_->next_word;
								_tmp29_ = _tmp28_->text;
								_tmp30_ = g_strdup (_tmp29_);
								_g_free0 (w);
								w = _tmp30_;
								_tmp31_ = w;
								_tmp32_ = strlen (_tmp31_);
								_tmp33_ = _tmp32_;
								wl = _tmp33_;
								_tmp34_ = _data93_->next_word;
								_data92_->scale = bird_font_text_get_font_scale (_tmp34_);
								_tmp35_ = _data92_->selection_start;
								_tmp36_ = _data92_->selection_stop;
								if (_tmp35_->paragraph == _tmp36_->paragraph) {
									_data93_->partial_start = TRUE;
									_data93_->partial_stop = TRUE;
								} else {
									BirdFontTextAreaCarret* _tmp37_;
									BirdFontTextAreaCarret* _tmp38_;
									gint _tmp39_;
									_tmp37_ = _data92_->selection_start;
									_tmp38_ = _data92_->selection_stop;
									_tmp39_ = i;
									if ((_tmp37_->paragraph < _tmp39_) && (_tmp39_ < _tmp38_->paragraph)) {
										paint_background = TRUE;
									} else {
										BirdFontTextAreaCarret* _tmp40_;
										_tmp40_ = _data92_->selection_start;
										if (_tmp40_->paragraph == i) {
											paint_background = TRUE;
											_data93_->partial_start = TRUE;
										} else {
											BirdFontTextAreaCarret* _tmp41_;
											_tmp41_ = _data92_->selection_stop;
											if (_tmp41_->paragraph == i) {
												BirdFontTextAreaCarret* _tmp42_;
												gint _tmp43_;
												gint _tmp44_;
												_tmp42_ = _data92_->selection_stop;
												_tmp43_ = bird_font_text_area_carret_get_character_index (_tmp42_);
												_tmp44_ = _tmp43_;
												paint_background = (char_index + wl) < _tmp44_;
												_data93_->partial_stop = !paint_background;
											}
										}
									}
								}
								if (paint_background) {
									gboolean _tmp46_ = FALSE;
									if (_data93_->partial_start) {
										_tmp46_ = TRUE;
									} else {
										_tmp46_ = _data93_->partial_stop;
									}
									_tmp45_ = !_tmp46_;
								} else {
									_tmp45_ = FALSE;
								}
								if (_tmp45_) {
									gdouble selection_y = 0.0;
									BirdFontText* _tmp47_;
									BirdFontText* _tmp48_;
									BirdFontCachedFont* _tmp49_;
									gdouble _tmp50_;
									gdouble _tmp51_;
									BirdFontText* _tmp52_;
									_tmp47_ = _data93_->next_word;
									_tmp48_ = _data93_->next_word;
									_tmp49_ = _tmp48_->cached_font;
									_tmp50_ = bird_font_cached_font_get_bottom_limit (_tmp49_);
									_tmp51_ = _tmp50_;
									selection_y = ((((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp47_)->widget_y) + (_data92_->scale * (-_tmp51_))) - self->font_size;
									_tmp52_ = _data93_->next_word;
									cairo_rectangle (_data92_->cr, ((((BirdFontWidget*) self)->widget_x + self->padding) + ((BirdFontWidget*) _tmp52_)->widget_x) - 1, selection_y, cw + 1, self->font_size);
									cairo_fill (_data92_->cr);
								}
								if (_data93_->partial_start) {
									_tmp53_ = TRUE;
								} else {
									_tmp53_ = _data93_->partial_stop;
								}
								if (_tmp53_) {
									Block94Data* _data94_;
									gint _tmp54_ = 0;
									BirdFontText* _tmp55_;
									BirdFontText* _tmp56_;
									_data94_ = g_slice_new0 (Block94Data);
									_data94_->_ref_count_ = 1;
									_data94_->_data93_ = block93_data_ref (_data93_);
									_data94_->index = char_index;
									if (_data93_->partial_start) {
										_tmp54_ = 0;
									} else {
										_tmp54_ = 1;
									}
									_tmp55_ = _data93_->next_word;
									_data94_->bx = ((((BirdFontWidget*) self)->widget_x + self->padding) + ((BirdFontWidget*) _tmp55_)->widget_x) + _tmp54_;
									_tmp56_ = _data93_->next_word;
									bird_font_text_iterate (_tmp56_, ___________lambda182__bird_font_text_iterator, _data94_);
									block94_data_unref (_data94_);
									_data94_ = NULL;
								}
								_tmp57_ = w;
								_tmp58_ = strlen (_tmp57_);
								_tmp59_ = _tmp58_;
								char_index += _tmp59_;
								block93_data_unref (_data93_);
								_data93_ = NULL;
							}
						}
					}
					_g_object_unref0 (pg);
				}
			}
		}
		cairo_restore (_data92_->cr);
	}
	tx = (gdouble) 0;
	ty = (gdouble) 0;
	first_visible = 0;
	_tmp60_ = self->priv->paragraphs;
	_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
	_tmp62_ = _tmp61_;
	paragraphs_size = _tmp62_;
	while (TRUE) {
		GeeArrayList* _tmp63_;
		gpointer _tmp64_;
		BirdFontTextAreaParagraph* _tmp65_;
		BirdFontWidgetAllocation* _tmp66_;
		gboolean _tmp67_;
		gint _tmp68_;
		if (!(first_visible < paragraphs_size)) {
			break;
		}
		_tmp63_ = self->priv->paragraphs;
		_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, first_visible);
		_tmp65_ = (BirdFontTextAreaParagraph*) _tmp64_;
		_tmp66_ = ((BirdFontWidget*) self)->allocation;
		_tmp67_ = bird_font_text_area_paragraph_text_is_on_screen (_tmp65_, _tmp66_, ((BirdFontWidget*) self)->widget_y);
		_g_object_unref0 (_tmp65_);
		if (_tmp67_) {
			break;
		}
		_tmp68_ = first_visible;
		first_visible = _tmp68_ + 1;
	}
	last_visible = first_visible;
	while (TRUE) {
		GeeArrayList* _tmp69_;
		gpointer _tmp70_;
		BirdFontTextAreaParagraph* _tmp71_;
		BirdFontWidgetAllocation* _tmp72_;
		gboolean _tmp73_;
		gint _tmp75_;
		if (!(last_visible < paragraphs_size)) {
			break;
		}
		_tmp69_ = self->priv->paragraphs;
		_tmp70_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, last_visible);
		_tmp71_ = (BirdFontTextAreaParagraph*) _tmp70_;
		_tmp72_ = ((BirdFontWidget*) self)->allocation;
		_tmp73_ = !bird_font_text_area_paragraph_text_is_on_screen (_tmp71_, _tmp72_, ((BirdFontWidget*) self)->widget_y);
		_g_object_unref0 (_tmp71_);
		if (_tmp73_) {
			gint _tmp74_;
			_tmp74_ = last_visible;
			last_visible = _tmp74_ + 1;
			break;
		}
		_tmp75_ = last_visible;
		last_visible = _tmp75_ + 1;
	}
	if (paragraphs_size == 0) {
		if (self->carret_is_visible) {
			bird_font_text_area_draw_carret_at (self, _data92_->cr, ((BirdFontWidget*) self)->widget_x + self->padding, (((BirdFontWidget*) self)->widget_y + self->font_size) + self->padding);
		}
		_g_free0 (w);
		_g_object_unref0 (word);
		block92_data_unref (_data92_);
		_data92_ = NULL;
		return;
	}
	_tmp76_ = self->priv->paragraphs;
	_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, 0);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp77_;
	_tmp78_ = paragraph;
	tx = _tmp78_->start_x;
	_tmp79_ = paragraph;
	ty = _tmp79_->start_y;
	{
		gint i = 0;
		i = first_visible;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp82_;
				gpointer _tmp83_;
				BirdFontTextAreaParagraph* _tmp84_;
				BirdFontTextAreaParagraph* _tmp85_;
				BirdFontTextAreaParagraph* _tmp86_;
				cairo_surface_t* _tmp87_;
				BirdFontTextAreaParagraph* _tmp111_;
				cairo_surface_t* _tmp112_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = i;
					i = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				if (!(i < last_visible)) {
					break;
				}
				_tmp82_ = self->priv->paragraphs;
				_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, i);
				_g_object_unref0 (paragraph);
				paragraph = (BirdFontTextAreaParagraph*) _tmp83_;
				_tmp84_ = paragraph;
				tx = _tmp84_->start_x;
				_tmp85_ = paragraph;
				ty = _tmp85_->start_y;
				_tmp86_ = paragraph;
				_tmp87_ = _tmp86_->cached_surface;
				if (_tmp87_ == NULL) {
					BirdFontTextAreaParagraph* _tmp88_;
					BirdFontTextAreaParagraph* _tmp89_;
					cairo_surface_t* _tmp90_;
					BirdFontTextAreaParagraph* _tmp91_;
					cairo_surface_t* _tmp92_;
					cairo_t* _tmp93_;
					cairo_t* _tmp94_;
					_tmp88_ = paragraph;
					_tmp89_ = paragraph;
					_tmp90_ = bird_font_screen_create_background_surface (((gint) width) + 2, (bird_font_text_area_paragraph_get_height (_tmp89_) + ((gint) self->font_size)) + 2);
					_cairo_surface_destroy0 (_tmp88_->cached_surface);
					_tmp88_->cached_surface = _tmp90_;
					_tmp91_ = paragraph;
					_tmp92_ = _tmp91_->cached_surface;
					_tmp93_ = cairo_create ((cairo_surface_t*) _tmp92_);
					_cairo_destroy0 (cc);
					cc = _tmp93_;
					_tmp94_ = cc;
					cairo_scale (_tmp94_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
					{
						GeeArrayList* _next_word_list = NULL;
						BirdFontTextAreaParagraph* _tmp95_;
						GeeArrayList* _tmp96_;
						GeeArrayList* _tmp97_;
						gint _next_word_size = 0;
						GeeArrayList* _tmp98_;
						gint _tmp99_;
						gint _tmp100_;
						gint _next_word_index = 0;
						_tmp95_ = paragraph;
						_tmp96_ = bird_font_text_area_paragraph_get_words (_tmp95_);
						_tmp97_ = _tmp96_;
						_next_word_list = _tmp97_;
						_tmp98_ = _next_word_list;
						_tmp99_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp98_);
						_tmp100_ = _tmp99_;
						_next_word_size = _tmp100_;
						_next_word_index = -1;
						while (TRUE) {
							gint _tmp101_;
							gint _tmp102_;
							BirdFontText* next_word = NULL;
							GeeArrayList* _tmp103_;
							gpointer _tmp104_;
							BirdFontText* _tmp105_;
							const gchar* _tmp106_;
							_next_word_index = _next_word_index + 1;
							_tmp101_ = _next_word_index;
							_tmp102_ = _next_word_size;
							if (!(_tmp101_ < _tmp102_)) {
								break;
							}
							_tmp103_ = _next_word_list;
							_tmp104_ = gee_abstract_list_get ((GeeAbstractList*) _tmp103_, _next_word_index);
							next_word = (BirdFontText*) _tmp104_;
							_tmp105_ = next_word;
							_tmp106_ = _tmp105_->text;
							if (g_strcmp0 (_tmp106_, "\n") != 0) {
								BirdFontText* _tmp107_;
								cairo_t* _tmp108_;
								BirdFontText* _tmp109_;
								BirdFontText* _tmp110_;
								_tmp107_ = next_word;
								_tmp108_ = cc;
								_tmp109_ = next_word;
								_tmp110_ = next_word;
								bird_font_text_draw_at_top (_tmp107_, _tmp108_, ((BirdFontWidget*) _tmp109_)->widget_x, ((BirdFontWidget*) _tmp110_)->widget_y - ty, "");
							}
							_g_object_unref0 (next_word);
						}
					}
				}
				_tmp111_ = paragraph;
				_tmp112_ = _tmp111_->cached_surface;
				if (G_LIKELY (_tmp112_ != NULL)) {
					BirdFontTextAreaParagraph* _tmp113_;
					cairo_surface_t* _tmp114_;
					BirdFontTextAreaParagraph* _tmp115_;
					_tmp113_ = paragraph;
					_tmp114_ = _tmp113_->cached_surface;
					_tmp115_ = paragraph;
					bird_font_screen_paint_background_surface (_data92_->cr, (cairo_surface_t*) _tmp114_, (gint) (x + tx), (gint) (((((BirdFontWidget*) self)->widget_y + _tmp115_->start_y) - self->font_size) + self->padding));
				} else {
					g_warning ("TextArea.vala:1219: No paragraph image.");
				}
			}
		}
	}
	if (self->carret_is_visible) {
		BirdFontTextAreaCarret* _tmp116_;
		gdouble _tmp117_ = 0.0;
		gdouble _tmp118_ = 0.0;
		_tmp116_ = self->priv->carret;
		bird_font_text_area_get_carret_position (self, _tmp116_, &_tmp117_, &_tmp118_);
		carret_x = _tmp117_;
		carret_y = _tmp118_;
		if (carret_y < ((gdouble) 0)) {
			bird_font_text_area_draw_carret_at (self, _data92_->cr, ((BirdFontWidget*) self)->widget_x + self->padding, (((BirdFontWidget*) self)->widget_y + self->font_size) + self->padding);
		} else {
			bird_font_text_area_draw_carret_at (self, _data92_->cr, carret_x, carret_y);
		}
	}
	if (bird_font_text_area_has_selection (self)) {
		BirdFontTextAreaCarret* _tmp119_;
		gdouble _tmp120_ = 0.0;
		gdouble _tmp121_ = 0.0;
		_tmp119_ = self->priv->selection_end;
		bird_font_text_area_get_carret_position (self, _tmp119_, &_tmp120_, &_tmp121_);
		carret_x = _tmp120_;
		carret_y = _tmp121_;
		if (carret_y < ((gdouble) 0)) {
			bird_font_text_area_draw_carret_at (self, _data92_->cr, ((BirdFontWidget*) self)->widget_x + self->padding, (((BirdFontWidget*) self)->widget_y + self->font_size) + self->padding);
		} else {
			bird_font_text_area_draw_carret_at (self, _data92_->cr, carret_x, carret_y);
		}
	}
	_g_object_unref0 (paragraph);
	_cairo_destroy0 (cc);
	_g_free0 (w);
	_g_object_unref0 (word);
	block92_data_unref (_data92_);
	_data92_ = NULL;
}

static Block95Data*
block95_data_ref (Block95Data* _data95_)
{
	g_atomic_int_inc (&_data95_->_ref_count_);
	return _data95_;
}

static void
block95_data_unref (void * _userdata_)
{
	Block95Data* _data95_;
	_data95_ = (Block95Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data95_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data95_->self;
		_g_object_unref0 (_data95_->carret);
		_g_object_unref0 (self);
		g_slice_free (Block95Data, _data95_);
	}
}

static Block96Data*
block96_data_ref (Block96Data* _data96_)
{
	g_atomic_int_inc (&_data96_->_ref_count_);
	return _data96_;
}

static void
block96_data_unref (void * _userdata_)
{
	Block96Data* _data96_;
	_data96_ = (Block96Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data96_->_ref_count_)) {
		BirdFontTextArea* self;
		self = _data96_->_data95_->self;
		_g_object_unref0 (_data96_->next_word);
		block95_data_unref (_data96_->_data95_);
		_data96_->_data95_ = NULL;
		g_slice_free (Block96Data, _data96_);
	}
}

static void
_______lambda183_ (Block96Data* _data96_,
                   BirdFontGlyph* glyph,
                   gdouble kerning,
                   gboolean last)
{
	Block95Data* _data95_;
	BirdFontTextArea* self;
	gdouble cw = 0.0;
	gint ci = 0;
	BirdFontText* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	_data95_ = _data96_->_data95_;
	self = _data95_->self;
	g_return_if_fail (glyph != NULL);
	_tmp0_ = _data96_->next_word;
	cw = (bird_font_glyph_get_width (glyph) * bird_font_text_get_font_scale (_tmp0_)) + kerning;
	_tmp1_ = g_unichar_to_string (bird_font_glyph_get_unichar (glyph));
	_tmp2_ = (gchar*) _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	ci = _tmp4_;
	_g_free0 (_tmp2_);
	_tmp5_ = bird_font_text_area_carret_get_character_index (_data95_->carret);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	if ((_data95_->ch_index < _tmp7_) && (_tmp7_ <= (_data95_->ch_index + ci))) {
		_data95_->pos_x = (_data95_->tx + cw) + self->padding;
		_data95_->pos_y = _data95_->ty;
		if (bird_font_glyph_get_unichar (glyph) == ((gunichar) '\n')) {
			BirdFontText* _tmp8_;
			_data95_->pos_x = ((BirdFontWidget*) self)->widget_x + self->padding;
			_tmp8_ = _data96_->next_word;
			_data95_->pos_y += _tmp8_->font_size;
		}
	}
	_data95_->tx += cw;
	_data95_->ch_index += ci;
}

static void
________lambda183__bird_font_text_iterator (BirdFontGlyph* glyph,
                                            gdouble kerning,
                                            gboolean last,
                                            gpointer self)
{
	_______lambda183_ (self, glyph, kerning, last);
}

static void
bird_font_text_area_get_carret_position (BirdFontTextArea* self,
                                         BirdFontTextAreaCarret* carret,
                                         gdouble* carret_x,
                                         gdouble* carret_y)
{
	gdouble _vala_carret_x = 0.0;
	gdouble _vala_carret_y = 0.0;
	Block95Data* _data95_;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaParagraph* paragraph = NULL;
	gint wl = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (carret != NULL);
	_data95_ = g_slice_new0 (Block95Data);
	_data95_->_ref_count_ = 1;
	_data95_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (carret);
	_g_object_unref0 (_data95_->carret);
	_data95_->carret = _tmp0_;
	_data95_->ch_index = 0;
	_vala_carret_x = (gdouble) -1;
	_vala_carret_y = (gdouble) -1;
	_tmp1_ = self->priv->paragraphs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data95_->carret->paragraph;
	g_return_if_fail ((0 <= _tmp4_) && (_tmp4_ < _tmp3_));
	_tmp5_ = self->priv->paragraphs;
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _data95_->carret->paragraph);
	_g_object_unref0 (paragraph);
	paragraph = (BirdFontTextAreaParagraph*) _tmp6_;
	_data95_->pos_x = (gdouble) -1;
	_data95_->pos_y = (gdouble) -1;
	{
		GeeArrayList* _next_word_list = NULL;
		BirdFontTextAreaParagraph* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _next_word_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _next_word_index = 0;
		_tmp7_ = paragraph;
		_tmp8_ = bird_font_text_area_paragraph_get_words (_tmp7_);
		_tmp9_ = _tmp8_;
		_next_word_list = _tmp9_;
		_tmp10_ = _next_word_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_next_word_size = _tmp12_;
		_next_word_index = -1;
		while (TRUE) {
			Block96Data* _data96_;
			gint _tmp13_;
			gint _tmp14_;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			gchar* w = NULL;
			BirdFontText* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_data96_ = g_slice_new0 (Block96Data);
			_data96_->_ref_count_ = 1;
			_data96_->_data95_ = block95_data_ref (_data95_);
			_next_word_index = _next_word_index + 1;
			_tmp13_ = _next_word_index;
			_tmp14_ = _next_word_size;
			if (!(_tmp13_ < _tmp14_)) {
				block96_data_unref (_data96_);
				_data96_ = NULL;
				break;
			}
			_tmp15_ = _next_word_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _next_word_index);
			_data96_->next_word = (BirdFontText*) _tmp16_;
			_tmp17_ = _data96_->next_word;
			_tmp18_ = _tmp17_->text;
			_tmp19_ = g_strdup (_tmp18_);
			w = _tmp19_;
			_tmp20_ = w;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			wl = _tmp22_;
			_tmp23_ = bird_font_text_area_carret_get_character_index (_data95_->carret);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == _data95_->ch_index) {
				BirdFontText* _tmp25_;
				BirdFontText* _tmp26_;
				BirdFontText* _tmp27_;
				_tmp25_ = _data96_->next_word;
				_data95_->pos_x = (((BirdFontWidget*) _tmp25_)->widget_x + ((BirdFontWidget*) self)->widget_x) + self->padding;
				_tmp26_ = _data96_->next_word;
				_tmp27_ = _data96_->next_word;
				_data95_->pos_y = (((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp26_)->widget_y) + bird_font_text_get_baseline_to_bottom_for_font (_tmp27_);
			} else {
				gint _tmp28_;
				gint _tmp29_;
				_tmp28_ = bird_font_text_area_carret_get_character_index (_data95_->carret);
				_tmp29_ = _tmp28_;
				if (_tmp29_ >= (_data95_->ch_index + wl)) {
					BirdFontText* _tmp30_;
					BirdFontText* _tmp31_;
					BirdFontText* _tmp32_;
					BirdFontText* _tmp33_;
					BirdFontText* _tmp34_;
					const gchar* _tmp35_;
					_tmp30_ = _data96_->next_word;
					_tmp31_ = _data96_->next_word;
					_data95_->pos_x = ((((BirdFontWidget*) _tmp30_)->widget_x + bird_font_text_get_sidebearing_extent (_tmp31_)) + ((BirdFontWidget*) self)->widget_x) + self->padding;
					_tmp32_ = _data96_->next_word;
					_tmp33_ = _data96_->next_word;
					_data95_->pos_y = (((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp32_)->widget_y) + bird_font_text_get_baseline_to_bottom_for_font (_tmp33_);
					_tmp34_ = _data96_->next_word;
					_tmp35_ = _tmp34_->text;
					if (g_str_has_suffix (_tmp35_, "\n")) {
						BirdFontText* _tmp36_;
						_data95_->pos_x = ((BirdFontWidget*) self)->widget_x + self->padding;
						_tmp36_ = _data96_->next_word;
						_data95_->pos_y += _tmp36_->font_size;
					}
				} else {
					gint _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					_tmp37_ = bird_font_text_area_carret_get_character_index (_data95_->carret);
					_tmp38_ = _tmp37_;
					_tmp39_ = _tmp38_;
					if ((_data95_->ch_index < _tmp39_) && (_tmp39_ <= (_data95_->ch_index + wl))) {
						BirdFontText* _tmp40_;
						BirdFontText* _tmp41_;
						BirdFontText* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						BirdFontText* _tmp45_;
						_tmp40_ = _data96_->next_word;
						_data95_->tx = ((BirdFontWidget*) self)->widget_x + ((BirdFontWidget*) _tmp40_)->widget_x;
						_tmp41_ = _data96_->next_word;
						_tmp42_ = _data96_->next_word;
						_data95_->ty = (((BirdFontWidget*) self)->widget_y + ((BirdFontWidget*) _tmp41_)->widget_y) + bird_font_text_get_baseline_to_bottom_for_font (_tmp42_);
						_tmp43_ = bird_font_text_area_carret_get_character_index (_data95_->carret);
						_tmp44_ = _tmp43_;
						if (_tmp44_ <= _data95_->ch_index) {
							_data95_->pos_x = ((BirdFontWidget*) self)->widget_x + self->padding;
							_data95_->pos_y = _data95_->ty;
						}
						_tmp45_ = _data96_->next_word;
						bird_font_text_iterate (_tmp45_, ________lambda183__bird_font_text_iterator, _data96_);
					}
				}
			}
			_data95_->ch_index += wl;
			_g_free0 (w);
			block96_data_unref (_data96_);
			_data96_ = NULL;
		}
	}
	_vala_carret_x = _data95_->pos_x;
	_vala_carret_y = _data95_->pos_y;
	_g_object_unref0 (paragraph);
	if (carret_x) {
		*carret_x = _vala_carret_x;
	}
	if (carret_y) {
		*carret_y = _vala_carret_y;
	}
	block95_data_unref (_data95_);
	_data95_ = NULL;
}

static void
bird_font_text_area_draw_carret_at (BirdFontTextArea* self,
                                    cairo_t* cr,
                                    gdouble x,
                                    gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.5);
	cairo_set_line_width (cr, (gdouble) 1);
	cairo_move_to (cr, x, y);
	cairo_line_to (cr, x, y - self->font_size);
	cairo_stroke (cr);
	cairo_restore (cr);
}

void
bird_font_text_area_store_undo_edit_state (BirdFontTextArea* self)
{
	BirdFontTextAreaTextUndoItem* ui = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	BirdFontTextAreaTextUndoItem* _tmp1_;
	GeeArrayList* _tmp2_;
	BirdFontTextAreaParagraph* _tmp3_;
	BirdFontTextAreaParagraph* _tmp4_;
	BirdFontTextAreaParagraph* _tmp5_;
	BirdFontTextAreaParagraph* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->carret;
	_tmp1_ = bird_font_text_area_text_undo_item_new (_tmp0_);
	ui = _tmp1_;
	_tmp2_ = ui->edited;
	_tmp3_ = bird_font_text_area_get_current_paragraph (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = bird_font_text_area_paragraph_copy (_tmp4_);
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_tmp7_ = self->priv->undo_items;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, ui);
	_tmp8_ = self->priv->redo_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
	_g_object_unref0 (ui);
}

static gint
___lambda507_ (BirdFontTextArea* self,
               BirdFontTextAreaParagraph* a,
               BirdFontTextAreaParagraph* b)
{
	BirdFontTextAreaParagraph* pa = NULL;
	BirdFontTextAreaParagraph* _tmp0_;
	BirdFontTextAreaParagraph* pb = NULL;
	BirdFontTextAreaParagraph* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pb = _tmp1_;
	result = pb->index - pa->index;
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}

static gint
____lambda507__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ___lambda507_ ((BirdFontTextArea*) self, (BirdFontTextAreaParagraph*) a, (BirdFontTextAreaParagraph*) b);
	return result;
}

static gint
___lambda508_ (BirdFontTextArea* self,
               BirdFontTextAreaParagraph* a,
               BirdFontTextAreaParagraph* b)
{
	BirdFontTextAreaParagraph* pa = NULL;
	BirdFontTextAreaParagraph* _tmp0_;
	BirdFontTextAreaParagraph* pb = NULL;
	BirdFontTextAreaParagraph* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pb = _tmp1_;
	result = pa->index - pb->index;
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}

static gint
____lambda508__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ___lambda508_ ((BirdFontTextArea*) self, (BirdFontTextAreaParagraph*) a, (BirdFontTextAreaParagraph*) b);
	return result;
}

void
bird_font_text_area_redo (BirdFontTextArea* self)
{
	BirdFontTextAreaTextUndoItem* i = NULL;
	BirdFontTextAreaTextUndoItem* undo_item = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->redo_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gpointer _tmp7_;
		BirdFontTextAreaTextUndoItem* _tmp8_;
		BirdFontTextAreaCarret* _tmp9_;
		BirdFontTextAreaTextUndoItem* _tmp10_;
		BirdFontTextAreaTextUndoItem* _tmp11_;
		GeeArrayList* _tmp12_;
		BirdFontTextAreaTextUndoItem* _tmp13_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp120_;
		GeeArrayList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gpointer _tmp124_;
		BirdFontTextAreaTextUndoItem* _tmp125_;
		GeeArrayList* _tmp126_;
		BirdFontTextAreaTextUndoItem* _tmp127_;
		BirdFontTextAreaTextUndoItem* _tmp128_;
		BirdFontTextAreaCarret* _tmp129_;
		BirdFontTextAreaCarret* _tmp130_;
		_tmp3_ = self->priv->redo_items;
		_tmp4_ = self->priv->redo_items;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
		_g_object_unref0 (i);
		i = (BirdFontTextAreaTextUndoItem*) _tmp7_;
		_tmp8_ = i;
		_tmp9_ = _tmp8_->carret;
		_tmp10_ = bird_font_text_area_text_undo_item_new (_tmp9_);
		_g_object_unref0 (undo_item);
		undo_item = _tmp10_;
		_tmp11_ = i;
		_tmp12_ = _tmp11_->deleted;
		gee_list_sort ((GeeList*) _tmp12_, ____lambda507__gcompare_data_func, g_object_ref (self), g_object_unref);
		_tmp13_ = i;
		_tmp14_ = _tmp13_->added;
		gee_list_sort ((GeeList*) _tmp14_, ____lambda508__gcompare_data_func, g_object_ref (self), g_object_unref);
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp15_;
			GeeArrayList* _tmp16_;
			gint _p_size = 0;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _p_index = 0;
			_tmp15_ = i;
			_tmp16_ = _tmp15_->deleted;
			_p_list = _tmp16_;
			_tmp17_ = _p_list;
			_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_p_size = _tmp19_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp22_;
				gpointer _tmp23_;
				BirdFontTextAreaParagraph* _tmp24_;
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_p_index = _p_index + 1;
				_tmp20_ = _p_index;
				_tmp21_ = _p_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _p_list;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp23_;
				_tmp24_ = p;
				_tmp25_ = self->priv->paragraphs;
				_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp24_->index;
				if (G_UNLIKELY (!((0 <= _tmp28_) && (_tmp28_ < _tmp27_)))) {
					g_warning ("TextArea.vala:1356: Paragraph not found.");
				} else {
					BirdFontTextAreaTextUndoItem* _tmp29_;
					GeeArrayList* _tmp30_;
					BirdFontTextAreaParagraph* _tmp31_;
					BirdFontTextAreaParagraph* _tmp32_;
					BirdFontTextAreaParagraph* _tmp33_;
					GeeArrayList* _tmp34_;
					BirdFontTextAreaParagraph* _tmp35_;
					gpointer _tmp36_;
					BirdFontTextAreaParagraph* _tmp37_;
					_tmp29_ = undo_item;
					_tmp30_ = _tmp29_->deleted;
					_tmp31_ = p;
					_tmp32_ = bird_font_text_area_paragraph_copy (_tmp31_);
					_tmp33_ = _tmp32_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp33_);
					_g_object_unref0 (_tmp33_);
					_tmp34_ = self->priv->paragraphs;
					_tmp35_ = p;
					_tmp36_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp34_, _tmp35_->index);
					_tmp37_ = (BirdFontTextAreaParagraph*) _tmp36_;
					_g_object_unref0 (_tmp37_);
				}
				_g_object_unref0 (p);
			}
		}
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp38_;
			GeeArrayList* _tmp39_;
			gint _p_size = 0;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _p_index = 0;
			_tmp38_ = i;
			_tmp39_ = _tmp38_->added;
			_p_list = _tmp39_;
			_tmp40_ = _p_list;
			_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_p_size = _tmp42_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp45_;
				gpointer _tmp46_;
				BirdFontTextAreaParagraph* _tmp47_;
				GeeArrayList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				_p_index = _p_index + 1;
				_tmp43_ = _p_index;
				_tmp44_ = _p_size;
				if (!(_tmp43_ < _tmp44_)) {
					break;
				}
				_tmp45_ = _p_list;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp46_;
				_tmp47_ = p;
				_tmp48_ = self->priv->paragraphs;
				_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				if (_tmp47_->index == _tmp50_) {
					GeeArrayList* _tmp51_;
					BirdFontTextAreaParagraph* _tmp52_;
					BirdFontTextAreaParagraph* _tmp53_;
					BirdFontTextAreaParagraph* _tmp54_;
					_tmp51_ = self->priv->paragraphs;
					_tmp52_ = p;
					_tmp53_ = bird_font_text_area_paragraph_copy (_tmp52_);
					_tmp54_ = _tmp53_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp54_);
					_g_object_unref0 (_tmp54_);
				} else {
					BirdFontTextAreaParagraph* _tmp55_;
					GeeArrayList* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					_tmp55_ = p;
					_tmp56_ = self->priv->paragraphs;
					_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = _tmp55_->index;
					if (G_UNLIKELY (!((0 <= _tmp59_) && (_tmp59_ < _tmp58_)))) {
						BirdFontTextAreaParagraph* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						GeeArrayList* _tmp63_;
						gint _tmp64_;
						gint _tmp65_;
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
						gchar* _tmp69_;
						_tmp60_ = p;
						_tmp61_ = g_strdup_printf ("%i", _tmp60_->index);
						_tmp62_ = _tmp61_;
						_tmp63_ = self->priv->paragraphs;
						_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
						_tmp65_ = _tmp64_;
						_tmp66_ = g_strdup_printf ("%i", _tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = g_strconcat ("Index: ", _tmp62_, " out of bounds, size: ", _tmp67_, NULL);
						_tmp69_ = _tmp68_;
						g_warning ("TextArea.vala:1368: %s", _tmp69_);
						_g_free0 (_tmp69_);
						_g_free0 (_tmp67_);
						_g_free0 (_tmp62_);
					} else {
						BirdFontTextAreaTextUndoItem* _tmp70_;
						GeeArrayList* _tmp71_;
						GeeArrayList* _tmp72_;
						BirdFontTextAreaParagraph* _tmp73_;
						gpointer _tmp74_;
						BirdFontTextAreaParagraph* _tmp75_;
						BirdFontTextAreaParagraph* _tmp76_;
						BirdFontTextAreaParagraph* _tmp77_;
						GeeArrayList* _tmp78_;
						BirdFontTextAreaParagraph* _tmp79_;
						BirdFontTextAreaParagraph* _tmp80_;
						BirdFontTextAreaParagraph* _tmp81_;
						BirdFontTextAreaParagraph* _tmp82_;
						_tmp70_ = undo_item;
						_tmp71_ = _tmp70_->added;
						_tmp72_ = self->priv->paragraphs;
						_tmp73_ = p;
						_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_->index);
						_tmp75_ = (BirdFontTextAreaParagraph*) _tmp74_;
						_tmp76_ = bird_font_text_area_paragraph_copy (_tmp75_);
						_tmp77_ = _tmp76_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, _tmp77_);
						_g_object_unref0 (_tmp77_);
						_g_object_unref0 (_tmp75_);
						_tmp78_ = self->priv->paragraphs;
						_tmp79_ = p;
						_tmp80_ = p;
						_tmp81_ = bird_font_text_area_paragraph_copy (_tmp80_);
						_tmp82_ = _tmp81_;
						gee_abstract_list_insert ((GeeAbstractList*) _tmp78_, _tmp79_->index, _tmp82_);
						_g_object_unref0 (_tmp82_);
					}
				}
				_g_object_unref0 (p);
			}
		}
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp83_;
			GeeArrayList* _tmp84_;
			gint _p_size = 0;
			GeeArrayList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint _p_index = 0;
			_tmp83_ = i;
			_tmp84_ = _tmp83_->edited;
			_p_list = _tmp84_;
			_tmp85_ = _p_list;
			_tmp86_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			_p_size = _tmp87_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp88_;
				gint _tmp89_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp90_;
				gpointer _tmp91_;
				BirdFontTextAreaParagraph* _tmp92_;
				GeeArrayList* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				BirdFontTextAreaTextUndoItem* _tmp107_;
				GeeArrayList* _tmp108_;
				GeeArrayList* _tmp109_;
				BirdFontTextAreaParagraph* _tmp110_;
				gpointer _tmp111_;
				BirdFontTextAreaParagraph* _tmp112_;
				BirdFontTextAreaParagraph* _tmp113_;
				BirdFontTextAreaParagraph* _tmp114_;
				GeeArrayList* _tmp115_;
				BirdFontTextAreaParagraph* _tmp116_;
				BirdFontTextAreaParagraph* _tmp117_;
				BirdFontTextAreaParagraph* _tmp118_;
				BirdFontTextAreaParagraph* _tmp119_;
				_p_index = _p_index + 1;
				_tmp88_ = _p_index;
				_tmp89_ = _p_size;
				if (!(_tmp88_ < _tmp89_)) {
					break;
				}
				_tmp90_ = _p_list;
				_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp91_;
				_tmp92_ = p;
				_tmp93_ = self->priv->paragraphs;
				_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp92_->index;
				if (G_UNLIKELY (!((0 <= _tmp96_) && (_tmp96_ < _tmp95_)))) {
					BirdFontTextAreaParagraph* _tmp97_;
					gchar* _tmp98_;
					gchar* _tmp99_;
					GeeArrayList* _tmp100_;
					gint _tmp101_;
					gint _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					_tmp97_ = p;
					_tmp98_ = g_strdup_printf ("%i", _tmp97_->index);
					_tmp99_ = _tmp98_;
					_tmp100_ = self->priv->paragraphs;
					_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = g_strdup_printf ("%i", _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = g_strconcat ("Index: ", _tmp99_, " out of bounds, size: ", _tmp104_, NULL);
					_tmp106_ = _tmp105_;
					g_warning ("TextArea.vala:1378: %s", _tmp106_);
					_g_free0 (_tmp106_);
					_g_free0 (_tmp104_);
					_g_free0 (_tmp99_);
					_g_object_unref0 (p);
					_g_object_unref0 (undo_item);
					_g_object_unref0 (i);
					return;
				}
				_tmp107_ = undo_item;
				_tmp108_ = _tmp107_->edited;
				_tmp109_ = self->priv->paragraphs;
				_tmp110_ = p;
				_tmp111_ = gee_abstract_list_get ((GeeAbstractList*) _tmp109_, _tmp110_->index);
				_tmp112_ = (BirdFontTextAreaParagraph*) _tmp111_;
				_tmp113_ = bird_font_text_area_paragraph_copy (_tmp112_);
				_tmp114_ = _tmp113_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp108_, _tmp114_);
				_g_object_unref0 (_tmp114_);
				_g_object_unref0 (_tmp112_);
				_tmp115_ = self->priv->paragraphs;
				_tmp116_ = p;
				_tmp117_ = p;
				_tmp118_ = bird_font_text_area_paragraph_copy (_tmp117_);
				_tmp119_ = _tmp118_;
				gee_abstract_list_set ((GeeAbstractList*) _tmp115_, _tmp116_->index, _tmp119_);
				_g_object_unref0 (_tmp119_);
				_g_object_unref0 (p);
			}
		}
		_tmp120_ = self->priv->redo_items;
		_tmp121_ = self->priv->redo_items;
		_tmp122_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp120_, _tmp123_ - 1);
		_tmp125_ = (BirdFontTextAreaTextUndoItem*) _tmp124_;
		_g_object_unref0 (_tmp125_);
		_tmp126_ = self->priv->undo_items;
		_tmp127_ = undo_item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp126_, _tmp127_);
		_tmp128_ = i;
		_tmp129_ = _tmp128_->carret;
		_tmp130_ = bird_font_text_area_carret_copy (_tmp129_);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp130_;
		bird_font_widget_layout ((BirdFontWidget*) self);
	}
	_g_object_unref0 (undo_item);
	_g_object_unref0 (i);
}

static gint
___lambda509_ (BirdFontTextArea* self,
               BirdFontTextAreaParagraph* a,
               BirdFontTextAreaParagraph* b)
{
	BirdFontTextAreaParagraph* pa = NULL;
	BirdFontTextAreaParagraph* _tmp0_;
	BirdFontTextAreaParagraph* pb = NULL;
	BirdFontTextAreaParagraph* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pb = _tmp1_;
	result = pa->index - pb->index;
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}

static gint
____lambda509__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ___lambda509_ ((BirdFontTextArea*) self, (BirdFontTextAreaParagraph*) a, (BirdFontTextAreaParagraph*) b);
	return result;
}

static gint
___lambda510_ (BirdFontTextArea* self,
               BirdFontTextAreaParagraph* a,
               BirdFontTextAreaParagraph* b)
{
	BirdFontTextAreaParagraph* pa = NULL;
	BirdFontTextAreaParagraph* _tmp0_;
	BirdFontTextAreaParagraph* pb = NULL;
	BirdFontTextAreaParagraph* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pa = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph));
	pb = _tmp1_;
	result = pb->index - pa->index;
	_g_object_unref0 (pb);
	_g_object_unref0 (pa);
	return result;
}

static gint
____lambda510__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ___lambda510_ ((BirdFontTextArea*) self, (BirdFontTextAreaParagraph*) a, (BirdFontTextAreaParagraph*) b);
	return result;
}

void
bird_font_text_area_undo (BirdFontTextArea* self)
{
	BirdFontTextAreaTextUndoItem* i = NULL;
	BirdFontTextAreaTextUndoItem* redo_item = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gpointer _tmp7_;
		BirdFontTextAreaTextUndoItem* _tmp8_;
		BirdFontTextAreaCarret* _tmp9_;
		BirdFontTextAreaTextUndoItem* _tmp10_;
		BirdFontTextAreaTextUndoItem* _tmp11_;
		GeeArrayList* _tmp12_;
		BirdFontTextAreaTextUndoItem* _tmp13_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp120_;
		GeeArrayList* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gpointer _tmp124_;
		BirdFontTextAreaTextUndoItem* _tmp125_;
		GeeArrayList* _tmp126_;
		BirdFontTextAreaTextUndoItem* _tmp127_;
		BirdFontTextAreaTextUndoItem* _tmp128_;
		BirdFontTextAreaCarret* _tmp129_;
		BirdFontTextAreaCarret* _tmp130_;
		_tmp3_ = self->priv->undo_items;
		_tmp4_ = self->priv->undo_items;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
		_g_object_unref0 (i);
		i = (BirdFontTextAreaTextUndoItem*) _tmp7_;
		_tmp8_ = i;
		_tmp9_ = _tmp8_->carret;
		_tmp10_ = bird_font_text_area_text_undo_item_new (_tmp9_);
		_g_object_unref0 (redo_item);
		redo_item = _tmp10_;
		_tmp11_ = i;
		_tmp12_ = _tmp11_->deleted;
		gee_list_sort ((GeeList*) _tmp12_, ____lambda509__gcompare_data_func, g_object_ref (self), g_object_unref);
		_tmp13_ = i;
		_tmp14_ = _tmp13_->added;
		gee_list_sort ((GeeList*) _tmp14_, ____lambda510__gcompare_data_func, g_object_ref (self), g_object_unref);
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp15_;
			GeeArrayList* _tmp16_;
			gint _p_size = 0;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _p_index = 0;
			_tmp15_ = i;
			_tmp16_ = _tmp15_->added;
			_p_list = _tmp16_;
			_tmp17_ = _p_list;
			_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_p_size = _tmp19_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp22_;
				gpointer _tmp23_;
				BirdFontTextAreaParagraph* _tmp24_;
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_p_index = _p_index + 1;
				_tmp20_ = _p_index;
				_tmp21_ = _p_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _p_list;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp23_;
				_tmp24_ = p;
				_tmp25_ = self->priv->paragraphs;
				_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp24_->index;
				if (G_UNLIKELY (!((0 <= _tmp28_) && (_tmp28_ < _tmp27_)))) {
					g_warning ("TextArea.vala:1416: Paragraph not found.");
				} else {
					BirdFontTextAreaTextUndoItem* _tmp29_;
					GeeArrayList* _tmp30_;
					GeeArrayList* _tmp31_;
					BirdFontTextAreaParagraph* _tmp32_;
					gpointer _tmp33_;
					BirdFontTextAreaParagraph* _tmp34_;
					BirdFontTextAreaParagraph* _tmp35_;
					BirdFontTextAreaParagraph* _tmp36_;
					GeeArrayList* _tmp37_;
					BirdFontTextAreaParagraph* _tmp38_;
					gpointer _tmp39_;
					BirdFontTextAreaParagraph* _tmp40_;
					_tmp29_ = redo_item;
					_tmp30_ = _tmp29_->added;
					_tmp31_ = self->priv->paragraphs;
					_tmp32_ = p;
					_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_->index);
					_tmp34_ = (BirdFontTextAreaParagraph*) _tmp33_;
					_tmp35_ = bird_font_text_area_paragraph_copy (_tmp34_);
					_tmp36_ = _tmp35_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp36_);
					_g_object_unref0 (_tmp36_);
					_g_object_unref0 (_tmp34_);
					_tmp37_ = self->priv->paragraphs;
					_tmp38_ = p;
					_tmp39_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp37_, _tmp38_->index);
					_tmp40_ = (BirdFontTextAreaParagraph*) _tmp39_;
					_g_object_unref0 (_tmp40_);
				}
				_g_object_unref0 (p);
			}
		}
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp41_;
			GeeArrayList* _tmp42_;
			gint _p_size = 0;
			GeeArrayList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _p_index = 0;
			_tmp41_ = i;
			_tmp42_ = _tmp41_->deleted;
			_p_list = _tmp42_;
			_tmp43_ = _p_list;
			_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_p_size = _tmp45_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp48_;
				gpointer _tmp49_;
				BirdFontTextAreaParagraph* _tmp50_;
				GeeArrayList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				_p_index = _p_index + 1;
				_tmp46_ = _p_index;
				_tmp47_ = _p_size;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = _p_list;
				_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp49_;
				_tmp50_ = p;
				_tmp51_ = self->priv->paragraphs;
				_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				if (_tmp50_->index == _tmp53_) {
					GeeArrayList* _tmp54_;
					BirdFontTextAreaParagraph* _tmp55_;
					BirdFontTextAreaParagraph* _tmp56_;
					BirdFontTextAreaParagraph* _tmp57_;
					_tmp54_ = self->priv->paragraphs;
					_tmp55_ = p;
					_tmp56_ = bird_font_text_area_paragraph_copy (_tmp55_);
					_tmp57_ = _tmp56_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp57_);
					_g_object_unref0 (_tmp57_);
				} else {
					BirdFontTextAreaParagraph* _tmp58_;
					GeeArrayList* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					_tmp58_ = p;
					_tmp59_ = self->priv->paragraphs;
					_tmp60_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = _tmp58_->index;
					if (G_UNLIKELY (!((0 <= _tmp62_) && (_tmp62_ < _tmp61_)))) {
						BirdFontTextAreaParagraph* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						GeeArrayList* _tmp66_;
						gint _tmp67_;
						gint _tmp68_;
						gchar* _tmp69_;
						gchar* _tmp70_;
						gchar* _tmp71_;
						gchar* _tmp72_;
						_tmp63_ = p;
						_tmp64_ = g_strdup_printf ("%i", _tmp63_->index);
						_tmp65_ = _tmp64_;
						_tmp66_ = self->priv->paragraphs;
						_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
						_tmp68_ = _tmp67_;
						_tmp69_ = g_strdup_printf ("%i", _tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = g_strconcat ("Index: ", _tmp65_, " out of bounds, size: ", _tmp70_, NULL);
						_tmp72_ = _tmp71_;
						g_warning ("TextArea.vala:1428: %s", _tmp72_);
						_g_free0 (_tmp72_);
						_g_free0 (_tmp70_);
						_g_free0 (_tmp65_);
					} else {
						BirdFontTextAreaTextUndoItem* _tmp73_;
						GeeArrayList* _tmp74_;
						BirdFontTextAreaParagraph* _tmp75_;
						BirdFontTextAreaParagraph* _tmp76_;
						BirdFontTextAreaParagraph* _tmp77_;
						GeeArrayList* _tmp78_;
						BirdFontTextAreaParagraph* _tmp79_;
						BirdFontTextAreaParagraph* _tmp80_;
						BirdFontTextAreaParagraph* _tmp81_;
						BirdFontTextAreaParagraph* _tmp82_;
						_tmp73_ = redo_item;
						_tmp74_ = _tmp73_->deleted;
						_tmp75_ = p;
						_tmp76_ = bird_font_text_area_paragraph_copy (_tmp75_);
						_tmp77_ = _tmp76_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, _tmp77_);
						_g_object_unref0 (_tmp77_);
						_tmp78_ = self->priv->paragraphs;
						_tmp79_ = p;
						_tmp80_ = p;
						_tmp81_ = bird_font_text_area_paragraph_copy (_tmp80_);
						_tmp82_ = _tmp81_;
						gee_abstract_list_insert ((GeeAbstractList*) _tmp78_, _tmp79_->index, _tmp82_);
						_g_object_unref0 (_tmp82_);
					}
				}
				_g_object_unref0 (p);
			}
		}
		{
			GeeArrayList* _p_list = NULL;
			BirdFontTextAreaTextUndoItem* _tmp83_;
			GeeArrayList* _tmp84_;
			gint _p_size = 0;
			GeeArrayList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint _p_index = 0;
			_tmp83_ = i;
			_tmp84_ = _tmp83_->edited;
			_p_list = _tmp84_;
			_tmp85_ = _p_list;
			_tmp86_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			_p_size = _tmp87_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp88_;
				gint _tmp89_;
				BirdFontTextAreaParagraph* p = NULL;
				GeeArrayList* _tmp90_;
				gpointer _tmp91_;
				BirdFontTextAreaParagraph* _tmp92_;
				GeeArrayList* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				BirdFontTextAreaTextUndoItem* _tmp107_;
				GeeArrayList* _tmp108_;
				GeeArrayList* _tmp109_;
				BirdFontTextAreaParagraph* _tmp110_;
				gpointer _tmp111_;
				BirdFontTextAreaParagraph* _tmp112_;
				BirdFontTextAreaParagraph* _tmp113_;
				BirdFontTextAreaParagraph* _tmp114_;
				GeeArrayList* _tmp115_;
				BirdFontTextAreaParagraph* _tmp116_;
				BirdFontTextAreaParagraph* _tmp117_;
				BirdFontTextAreaParagraph* _tmp118_;
				BirdFontTextAreaParagraph* _tmp119_;
				_p_index = _p_index + 1;
				_tmp88_ = _p_index;
				_tmp89_ = _p_size;
				if (!(_tmp88_ < _tmp89_)) {
					break;
				}
				_tmp90_ = _p_list;
				_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, _p_index);
				p = (BirdFontTextAreaParagraph*) _tmp91_;
				_tmp92_ = p;
				_tmp93_ = self->priv->paragraphs;
				_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp92_->index;
				if (G_UNLIKELY (!((0 <= _tmp96_) && (_tmp96_ < _tmp95_)))) {
					BirdFontTextAreaParagraph* _tmp97_;
					gchar* _tmp98_;
					gchar* _tmp99_;
					GeeArrayList* _tmp100_;
					gint _tmp101_;
					gint _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					_tmp97_ = p;
					_tmp98_ = g_strdup_printf ("%i", _tmp97_->index);
					_tmp99_ = _tmp98_;
					_tmp100_ = self->priv->paragraphs;
					_tmp101_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = g_strdup_printf ("%i", _tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = g_strconcat ("Index: ", _tmp99_, " out of bounds, size: ", _tmp104_, NULL);
					_tmp106_ = _tmp105_;
					g_warning ("TextArea.vala:1438: %s", _tmp106_);
					_g_free0 (_tmp106_);
					_g_free0 (_tmp104_);
					_g_free0 (_tmp99_);
					_g_object_unref0 (p);
					_g_object_unref0 (redo_item);
					_g_object_unref0 (i);
					return;
				}
				_tmp107_ = redo_item;
				_tmp108_ = _tmp107_->edited;
				_tmp109_ = self->priv->paragraphs;
				_tmp110_ = p;
				_tmp111_ = gee_abstract_list_get ((GeeAbstractList*) _tmp109_, _tmp110_->index);
				_tmp112_ = (BirdFontTextAreaParagraph*) _tmp111_;
				_tmp113_ = bird_font_text_area_paragraph_copy (_tmp112_);
				_tmp114_ = _tmp113_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp108_, _tmp114_);
				_g_object_unref0 (_tmp114_);
				_g_object_unref0 (_tmp112_);
				_tmp115_ = self->priv->paragraphs;
				_tmp116_ = p;
				_tmp117_ = p;
				_tmp118_ = bird_font_text_area_paragraph_copy (_tmp117_);
				_tmp119_ = _tmp118_;
				gee_abstract_list_set ((GeeAbstractList*) _tmp115_, _tmp116_->index, _tmp119_);
				_g_object_unref0 (_tmp119_);
				_g_object_unref0 (p);
			}
		}
		_tmp120_ = self->priv->undo_items;
		_tmp121_ = self->priv->undo_items;
		_tmp122_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp121_);
		_tmp123_ = _tmp122_;
		_tmp124_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp120_, _tmp123_ - 1);
		_tmp125_ = (BirdFontTextAreaTextUndoItem*) _tmp124_;
		_g_object_unref0 (_tmp125_);
		_tmp126_ = self->priv->redo_items;
		_tmp127_ = redo_item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp126_, _tmp127_);
		_tmp128_ = i;
		_tmp129_ = _tmp128_->carret;
		_tmp130_ = bird_font_text_area_carret_copy (_tmp129_);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp130_;
		bird_font_widget_layout ((BirdFontWidget*) self);
	}
	_g_object_unref0 (redo_item);
	_g_object_unref0 (i);
}

void
bird_font_text_area_set_editable (BirdFontTextArea* self,
                                  gboolean editable)
{
	g_return_if_fail (self != NULL);
	self->editable = editable;
}

static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static void
bird_font_text_area_real_double_click (BirdFontWidget* base,
                                       guint button,
                                       gdouble x,
                                       gdouble y)
{
	BirdFontTextArea * self;
	self = (BirdFontTextArea*) base;
	if (bird_font_widget_is_over ((BirdFontWidget*) self, x, y)) {
		BirdFontTextAreaCarret* _tmp0_;
		BirdFontTextAreaParagraph* paragraph = NULL;
		GeeArrayList* _tmp1_;
		BirdFontTextAreaCarret* _tmp2_;
		gpointer _tmp3_;
		gint index = 0;
		BirdFontTextAreaCarret* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint prev_index = 0;
		gunichar c = 0U;
		BirdFontTextAreaCarret* _tmp13_;
		BirdFontTextAreaCarret* _tmp14_;
		BirdFontTextAreaCarret* _tmp15_;
		BirdFontTextAreaCarret* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		BirdFontTextAreaCarret* _tmp25_;
		_tmp0_ = bird_font_text_area_get_carret_at (self, x, y, TRUE);
		_g_object_unref0 (self->priv->carret);
		self->priv->carret = _tmp0_;
		_tmp1_ = self->priv->paragraphs;
		_tmp2_ = self->priv->carret;
		_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, _tmp2_->paragraph);
		paragraph = (BirdFontTextAreaParagraph*) _tmp3_;
		_tmp4_ = self->priv->carret;
		_tmp5_ = bird_font_text_area_carret_get_character_index (_tmp4_);
		_tmp6_ = _tmp5_;
		index = _tmp6_;
		prev_index = index;
		while (TRUE) {
			BirdFontTextAreaParagraph* _tmp7_;
			const gchar* _tmp8_;
			gunichar _tmp9_ = 0U;
			gboolean _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_tmp7_ = paragraph;
			_tmp8_ = _tmp7_->text;
			_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
			c = _tmp9_;
			if (!_tmp10_) {
				break;
			}
			if (c == ((gunichar) '\t')) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = c == ((gunichar) ' ');
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = c == ((gunichar) '\n');
			}
			if (_tmp11_) {
				break;
			}
			prev_index = index;
		}
		_tmp13_ = self->priv->carret;
		bird_font_text_area_carret_set_character_index (_tmp13_, prev_index);
		_tmp14_ = self->priv->carret;
		_tmp15_ = bird_font_text_area_carret_copy (_tmp14_);
		_g_object_unref0 (self->priv->selection_end);
		self->priv->selection_end = _tmp15_;
		_tmp16_ = self->priv->selection_end;
		_tmp17_ = bird_font_text_area_carret_get_character_index (_tmp16_);
		_tmp18_ = _tmp17_;
		index = _tmp18_;
		while (TRUE) {
			BirdFontTextAreaParagraph* _tmp19_;
			const gchar* _tmp20_;
			gunichar _tmp21_ = 0U;
			gboolean _tmp22_;
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			_tmp19_ = paragraph;
			_tmp20_ = _tmp19_->text;
			_tmp22_ = string_get_next_char (_tmp20_, &index, &_tmp21_);
			c = _tmp21_;
			if (!_tmp22_) {
				break;
			}
			if (c == ((gunichar) '\t')) {
				_tmp24_ = TRUE;
			} else {
				_tmp24_ = c == ((gunichar) ' ');
			}
			if (_tmp24_) {
				_tmp23_ = TRUE;
			} else {
				_tmp23_ = c == ((gunichar) '\n');
			}
			if (_tmp23_) {
				break;
			}
			prev_index = index;
		}
		_tmp25_ = self->priv->selection_end;
		bird_font_text_area_carret_set_character_index (_tmp25_, prev_index);
		self->show_selection = bird_font_text_area_selection_is_visible (self);
		self->priv->update_selection = TRUE;
		_g_object_unref0 (paragraph);
	}
}

gboolean
bird_font_text_area_get_draw_carret (BirdFontTextArea* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->carret_is_visible;
	return result;
}

void
bird_font_text_area_set_draw_carret (BirdFontTextArea* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->carret_is_visible = value;
	if (!value) {
		BirdFontTextAreaCarret* _tmp0_;
		BirdFontTextAreaCarret* _tmp1_;
		self->priv->update_selection = FALSE;
		_tmp0_ = self->priv->carret;
		_tmp1_ = bird_font_text_area_carret_copy (_tmp0_);
		_g_object_unref0 (self->priv->selection_end);
		self->priv->selection_end = _tmp1_;
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_text_area_properties[BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY]);
}

BirdFontTextAreaTextUndoItem*
bird_font_text_area_text_undo_item_construct (GType object_type,
                                              BirdFontTextAreaCarret* c)
{
	BirdFontTextAreaTextUndoItem * self = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	g_return_val_if_fail (c != NULL, NULL);
	self = (BirdFontTextAreaTextUndoItem*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_text_area_carret_copy (c);
	_g_object_unref0 (self->carret);
	self->carret = _tmp0_;
	return self;
}

BirdFontTextAreaTextUndoItem*
bird_font_text_area_text_undo_item_new (BirdFontTextAreaCarret* c)
{
	return bird_font_text_area_text_undo_item_construct (BIRD_FONT_TEXT_AREA_TYPE_TEXT_UNDO_ITEM, c);
}

static void
bird_font_text_area_text_undo_item_class_init (BirdFontTextAreaTextUndoItemClass * klass,
                                               gpointer klass_data)
{
	bird_font_text_area_text_undo_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_text_area_text_undo_item_finalize;
}

static void
bird_font_text_area_text_undo_item_instance_init (BirdFontTextAreaTextUndoItem * self,
                                                  gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	_tmp0_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->added = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->edited = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->deleted = _tmp2_;
}

static void
bird_font_text_area_text_undo_item_finalize (GObject * obj)
{
	BirdFontTextAreaTextUndoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TEXT_AREA_TYPE_TEXT_UNDO_ITEM, BirdFontTextAreaTextUndoItem);
	_g_object_unref0 (self->carret);
	_g_object_unref0 (self->added);
	_g_object_unref0 (self->edited);
	_g_object_unref0 (self->deleted);
	G_OBJECT_CLASS (bird_font_text_area_text_undo_item_parent_class)->finalize (obj);
}

static GType
bird_font_text_area_text_undo_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTextAreaTextUndoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_text_area_text_undo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTextAreaTextUndoItem), 0, (GInstanceInitFunc) bird_font_text_area_text_undo_item_instance_init, NULL };
	GType bird_font_text_area_text_undo_item_type_id;
	bird_font_text_area_text_undo_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTextAreaTextUndoItem", &g_define_type_info, 0);
	return bird_font_text_area_text_undo_item_type_id;
}

GType
bird_font_text_area_text_undo_item_get_type (void)
{
	static volatile gsize bird_font_text_area_text_undo_item_type_id__once = 0;
	if (g_once_init_enter (&bird_font_text_area_text_undo_item_type_id__once)) {
		GType bird_font_text_area_text_undo_item_type_id;
		bird_font_text_area_text_undo_item_type_id = bird_font_text_area_text_undo_item_get_type_once ();
		g_once_init_leave (&bird_font_text_area_text_undo_item_type_id__once, bird_font_text_area_text_undo_item_type_id);
	}
	return bird_font_text_area_text_undo_item_type_id__once;
}

static inline gpointer
bird_font_text_area_paragraph_get_instance_private (BirdFontTextAreaParagraph* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTextAreaParagraph_private_offset);
}

BirdFontTextAreaParagraph*
bird_font_text_area_paragraph_construct (GType object_type,
                                         const gchar* text,
                                         gdouble font_size,
                                         gint index,
                                         BirdFontColor* c)
{
	BirdFontTextAreaParagraph * self = NULL;
	BirdFontColor* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	self = (BirdFontTextAreaParagraph*) g_object_new (object_type, NULL);
	self->index = index;
	self->priv->font_size = font_size;
	_tmp0_ = _bird_font_color_ref0 (c);
	_bird_font_color_unref0 (self->priv->text_color);
	self->priv->text_color = _tmp0_;
	bird_font_text_area_paragraph_set_text (self, text);
	return self;
}

BirdFontTextAreaParagraph*
bird_font_text_area_paragraph_new (const gchar* text,
                                   gdouble font_size,
                                   gint index,
                                   BirdFontColor* c)
{
	return bird_font_text_area_paragraph_construct (BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, text, font_size, index, c);
}

BirdFontTextAreaParagraph*
bird_font_text_area_paragraph_copy (BirdFontTextAreaParagraph* self)
{
	BirdFontTextAreaParagraph* p = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BirdFontColor* _tmp3_;
	BirdFontTextAreaParagraph* _tmp4_;
	BirdFontTextAreaParagraph* _tmp5_;
	BirdFontTextAreaParagraph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->text;
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->text_color;
	_tmp4_ = bird_font_text_area_paragraph_new (_tmp2_, self->priv->font_size, self->index, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	p = _tmp5_;
	p->need_layout = TRUE;
	result = p;
	return result;
}

gboolean
bird_font_text_area_paragraph_is_empty (BirdFontTextAreaParagraph* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->text;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}

void
bird_font_text_area_paragraph_set_text (BirdFontTextAreaParagraph* self,
                                        const gchar* t)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = g_strdup (t);
	_g_free0 (self->text);
	self->text = _tmp0_;
	_tmp1_ = strlen (t);
	_tmp2_ = _tmp1_;
	self->text_length = _tmp2_;
	self->need_layout = TRUE;
	_tmp3_ = bird_font_text_area_paragraph_get_words (self);
	_tmp4_ = _tmp3_;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
	_cairo_surface_destroy0 (self->cached_surface);
	self->cached_surface = NULL;
}

gint
bird_font_text_area_paragraph_get_height (BirdFontTextAreaParagraph* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gint) (self->end_y - self->start_y)) + 1;
	return result;
}

gint
bird_font_text_area_paragraph_get_width (BirdFontTextAreaParagraph* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gint) self->width) + 1;
	return result;
}

gboolean
bird_font_text_area_paragraph_text_is_on_screen (BirdFontTextAreaParagraph* self,
                                                 BirdFontWidgetAllocation* alloc,
                                                 gdouble widget_y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gboolean v = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (alloc != NULL, FALSE);
	_tmp2_ = self->start_y + widget_y;
	if ((((gdouble) 0) <= _tmp2_) && (_tmp2_ <= ((gdouble) alloc->height))) {
		_tmp1_ = TRUE;
	} else {
		gdouble _tmp3_;
		_tmp3_ = self->end_y + widget_y;
		_tmp1_ = (((gdouble) 0) <= _tmp3_) && (_tmp3_ <= ((gdouble) alloc->height));
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if ((self->start_y + widget_y) <= ((gdouble) 0)) {
			_tmp4_ = ((gdouble) alloc->height) <= (self->end_y + widget_y);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	v = _tmp0_;
	result = v;
	return result;
}

static void
bird_font_text_area_paragraph_generate_words (BirdFontTextAreaParagraph* self)
{
	gchar* w = NULL;
	gint p = 0;
	gboolean carret_at_word_end = FALSE;
	BirdFontText* word = NULL;
	gint carret = 0;
	gint iter_pos = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	p = 0;
	carret_at_word_end = FALSE;
	carret = 0;
	iter_pos = 0;
	_tmp0_ = self->priv->words_in_paragraph;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ == 0);
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		BirdFontText* _tmp7_;
		BirdFontText* _tmp8_;
		BirdFontColor* _tmp9_;
		BirdFontText* _tmp10_;
		BirdFontColor* _tmp11_;
		BirdFontText* _tmp12_;
		BirdFontColor* _tmp13_;
		BirdFontText* _tmp14_;
		BirdFontColor* _tmp15_;
		GeeArrayList* _tmp16_;
		BirdFontText* _tmp17_;
		if (!(p < self->text_length)) {
			break;
		}
		_tmp4_ = bird_font_text_area_paragraph_get_next_word (self, &_tmp3_, &iter_pos, carret);
		carret_at_word_end = _tmp3_;
		_g_free0 (w);
		w = _tmp4_;
		_tmp5_ = w;
		if (g_strcmp0 (_tmp5_, "") == 0) {
			break;
		}
		_tmp6_ = w;
		_tmp7_ = bird_font_text_new (_tmp6_, self->priv->font_size, (gdouble) 0);
		_g_object_unref0 (word);
		word = _tmp7_;
		_tmp8_ = word;
		_tmp9_ = self->priv->text_color;
		_tmp8_->r = _tmp9_->r;
		_tmp10_ = word;
		_tmp11_ = self->priv->text_color;
		_tmp10_->g = _tmp11_->g;
		_tmp12_ = word;
		_tmp13_ = self->priv->text_color;
		_tmp12_->b = _tmp13_->b;
		_tmp14_ = word;
		_tmp15_ = self->priv->text_color;
		_tmp14_->a = _tmp15_->a;
		_tmp16_ = self->priv->words_in_paragraph;
		_tmp17_ = word;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	}
	_g_object_unref0 (word);
	_g_free0 (w);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
bird_font_text_area_paragraph_get_next_word (BirdFontTextAreaParagraph* self,
                                             gboolean* carret_at_end_of_word,
                                             gint* iter_pos,
                                             gint carret)
{
	gboolean _vala_carret_at_end_of_word = FALSE;
	gint i = 0;
	gint ni = 0;
	gint pi = 0;
	gchar* n = NULL;
	gint nl = 0;
	const gchar* _tmp1_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_carret_at_end_of_word = FALSE;
	if ((*iter_pos) >= self->text_length) {
		gchar* _tmp0_;
		_vala_carret_at_end_of_word = TRUE;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		_g_free0 (n);
		if (carret_at_end_of_word) {
			*carret_at_end_of_word = _vala_carret_at_end_of_word;
		}
		return result;
	}
	_tmp1_ = self->text;
	if (string_get_char (_tmp1_, (glong) (*iter_pos)) == ((gunichar) '\n')) {
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = strlen ("\n");
		_tmp3_ = _tmp2_;
		*iter_pos = (*iter_pos) + _tmp3_;
		_vala_carret_at_end_of_word = (*iter_pos) == carret;
		_tmp4_ = g_strdup ("\n");
		result = _tmp4_;
		_g_free0 (n);
		if (carret_at_end_of_word) {
			*carret_at_end_of_word = _vala_carret_at_end_of_word;
		}
		return result;
	}
	_tmp5_ = self->text;
	i = string_index_of (_tmp5_, " ", *iter_pos);
	_tmp6_ = strlen (" ");
	_tmp7_ = _tmp6_;
	pi = i + _tmp7_;
	_tmp8_ = self->text;
	ni = string_index_of (_tmp8_, "\t", *iter_pos);
	if (ni != -1) {
		_tmp10_ = ni < pi;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = i == -1;
	}
	if (_tmp9_) {
		gint _tmp11_;
		gint _tmp12_;
		i = ni;
		_tmp11_ = strlen ("\t");
		_tmp12_ = _tmp11_;
		pi = i + _tmp12_;
	}
	_tmp13_ = self->text;
	ni = string_index_of (_tmp13_, "\n", *iter_pos);
	if (ni != -1) {
		_tmp15_ = ni < pi;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = i == -1;
	}
	if (_tmp14_) {
		i = ni;
		pi = i;
	}
	if ((((*iter_pos) + (*iter_pos)) - pi) > self->text_length) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = i == -1;
	}
	if (_tmp16_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = self->text;
		_tmp18_ = string_substring (_tmp17_, (glong) (*iter_pos), (glong) -1);
		_g_free0 (n);
		n = _tmp18_;
	} else {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = self->text;
		_tmp20_ = string_substring (_tmp19_, (glong) (*iter_pos), (glong) (pi - (*iter_pos)));
		_g_free0 (n);
		n = _tmp20_;
	}
	_tmp21_ = n;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	nl = _tmp23_;
	_tmp24_ = carret;
	if (((*iter_pos) < _tmp24_) && (_tmp24_ < ((*iter_pos) + nl))) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp25_ = self->text;
		_tmp26_ = string_substring (_tmp25_, (glong) (*iter_pos), (glong) (carret - (*iter_pos)));
		_g_free0 (n);
		n = _tmp26_;
		_tmp27_ = n;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		nl = _tmp29_;
		_vala_carret_at_end_of_word = TRUE;
	}
	*iter_pos = (*iter_pos) + nl;
	if ((*iter_pos) == carret) {
		_vala_carret_at_end_of_word = TRUE;
	}
	result = n;
	if (carret_at_end_of_word) {
		*carret_at_end_of_word = _vala_carret_at_end_of_word;
	}
	return result;
}

GeeArrayList*
bird_font_text_area_paragraph_get_words (BirdFontTextAreaParagraph* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->words_in_paragraph;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		bird_font_text_area_paragraph_generate_words (self);
	}
	_tmp3_ = self->priv->words_in_paragraph;
	result = _tmp3_;
	return result;
}

static void
bird_font_text_area_paragraph_class_init (BirdFontTextAreaParagraphClass * klass,
                                          gpointer klass_data)
{
	bird_font_text_area_paragraph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTextAreaParagraph_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_text_area_paragraph_get_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_text_area_paragraph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_TEXT_AREA_PARAGRAPH_WORDS_PROPERTY, bird_font_text_area_paragraph_properties[BIRD_FONT_TEXT_AREA_PARAGRAPH_WORDS_PROPERTY] = g_param_spec_object ("words", "words", "words", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
bird_font_text_area_paragraph_instance_init (BirdFontTextAreaParagraph * self,
                                             gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_text_area_paragraph_get_instance_private (self);
	self->end_x = (gdouble) -10000;
	self->end_y = (gdouble) -10000;
	self->start_x = (gdouble) -10000;
	self->start_y = (gdouble) -10000;
	self->width = (gdouble) -10000;
	self->text_area_width = (gdouble) -10000;
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_TEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->words_in_paragraph = _tmp0_;
	self->need_layout = TRUE;
	self->cached_surface = NULL;
}

static void
bird_font_text_area_paragraph_finalize (GObject * obj)
{
	BirdFontTextAreaParagraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph);
	_g_free0 (self->text);
	_g_object_unref0 (self->priv->words_in_paragraph);
	_cairo_surface_destroy0 (self->cached_surface);
	_bird_font_color_unref0 (self->priv->text_color);
	G_OBJECT_CLASS (bird_font_text_area_paragraph_parent_class)->finalize (obj);
}

static GType
bird_font_text_area_paragraph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTextAreaParagraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_text_area_paragraph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTextAreaParagraph), 0, (GInstanceInitFunc) bird_font_text_area_paragraph_instance_init, NULL };
	GType bird_font_text_area_paragraph_type_id;
	bird_font_text_area_paragraph_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTextAreaParagraph", &g_define_type_info, 0);
	BirdFontTextAreaParagraph_private_offset = g_type_add_instance_private (bird_font_text_area_paragraph_type_id, sizeof (BirdFontTextAreaParagraphPrivate));
	return bird_font_text_area_paragraph_type_id;
}

GType
bird_font_text_area_paragraph_get_type (void)
{
	static volatile gsize bird_font_text_area_paragraph_type_id__once = 0;
	if (g_once_init_enter (&bird_font_text_area_paragraph_type_id__once)) {
		GType bird_font_text_area_paragraph_type_id;
		bird_font_text_area_paragraph_type_id = bird_font_text_area_paragraph_get_type_once ();
		g_once_init_leave (&bird_font_text_area_paragraph_type_id__once, bird_font_text_area_paragraph_type_id);
	}
	return bird_font_text_area_paragraph_type_id__once;
}

static void
_vala_bird_font_text_area_paragraph_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	BirdFontTextAreaParagraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, BirdFontTextAreaParagraph);
	switch (property_id) {
		case BIRD_FONT_TEXT_AREA_PARAGRAPH_WORDS_PROPERTY:
		g_value_set_object (value, bird_font_text_area_paragraph_get_words (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
bird_font_text_area_carret_get_instance_private (BirdFontTextAreaCarret* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTextAreaCarret_private_offset);
}

BirdFontTextAreaCarret*
bird_font_text_area_carret_construct (GType object_type)
{
	BirdFontTextAreaCarret * self = NULL;
	self = (BirdFontTextAreaCarret*) g_object_new (object_type, NULL);
	return self;
}

BirdFontTextAreaCarret*
bird_font_text_area_carret_new (void)
{
	return bird_font_text_area_carret_construct (BIRD_FONT_TEXT_AREA_TYPE_CARRET);
}

void
bird_font_text_area_carret_print (BirdFontTextAreaCarret* self)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = g_strdup_printf ("%i", self->paragraph);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_text_area_carret_get_character_index (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("paragraph: ", _tmp2_, ", character_index: ", _tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	fprintf (_tmp0_, "%s", _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
}

BirdFontTextAreaCarret*
bird_font_text_area_carret_copy (BirdFontTextAreaCarret* self)
{
	BirdFontTextAreaCarret* c = NULL;
	BirdFontTextAreaCarret* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BirdFontTextAreaCarret* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_text_area_carret_new ();
	c = _tmp0_;
	c->paragraph = self->paragraph;
	_tmp1_ = bird_font_text_area_carret_get_character_index (self);
	_tmp2_ = _tmp1_;
	bird_font_text_area_carret_set_character_index (c, _tmp2_);
	c->desired_x = self->desired_x;
	c->desired_y = self->desired_y;
	result = c;
	return result;
}

gint
bird_font_text_area_carret_get_character_index (BirdFontTextAreaCarret* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->ci;
	return result;
}

void
bird_font_text_area_carret_set_character_index (BirdFontTextAreaCarret* self,
                                                gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->ci = value;
	g_object_notify_by_pspec ((GObject *) self, bird_font_text_area_carret_properties[BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY]);
}

static void
bird_font_text_area_carret_class_init (BirdFontTextAreaCarretClass * klass,
                                       gpointer klass_data)
{
	bird_font_text_area_carret_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTextAreaCarret_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_text_area_carret_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_text_area_carret_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_text_area_carret_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY, bird_font_text_area_carret_properties[BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY] = g_param_spec_int ("character-index", "character-index", "character-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
bird_font_text_area_carret_instance_init (BirdFontTextAreaCarret * self,
                                          gpointer klass)
{
	self->priv = bird_font_text_area_carret_get_instance_private (self);
	self->paragraph = 0;
	self->priv->ci = 0;
	self->desired_x = (gdouble) 0;
	self->desired_y = (gdouble) 0;
}

static void
bird_font_text_area_carret_finalize (GObject * obj)
{
	BirdFontTextAreaCarret * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TEXT_AREA_TYPE_CARRET, BirdFontTextAreaCarret);
	G_OBJECT_CLASS (bird_font_text_area_carret_parent_class)->finalize (obj);
}

static GType
bird_font_text_area_carret_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTextAreaCarretClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_text_area_carret_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTextAreaCarret), 0, (GInstanceInitFunc) bird_font_text_area_carret_instance_init, NULL };
	GType bird_font_text_area_carret_type_id;
	bird_font_text_area_carret_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTextAreaCarret", &g_define_type_info, 0);
	BirdFontTextAreaCarret_private_offset = g_type_add_instance_private (bird_font_text_area_carret_type_id, sizeof (BirdFontTextAreaCarretPrivate));
	return bird_font_text_area_carret_type_id;
}

GType
bird_font_text_area_carret_get_type (void)
{
	static volatile gsize bird_font_text_area_carret_type_id__once = 0;
	if (g_once_init_enter (&bird_font_text_area_carret_type_id__once)) {
		GType bird_font_text_area_carret_type_id;
		bird_font_text_area_carret_type_id = bird_font_text_area_carret_get_type_once ();
		g_once_init_leave (&bird_font_text_area_carret_type_id__once, bird_font_text_area_carret_type_id);
	}
	return bird_font_text_area_carret_type_id__once;
}

static void
_vala_bird_font_text_area_carret_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	BirdFontTextAreaCarret * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TEXT_AREA_TYPE_CARRET, BirdFontTextAreaCarret);
	switch (property_id) {
		case BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY:
		g_value_set_int (value, bird_font_text_area_carret_get_character_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_text_area_carret_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	BirdFontTextAreaCarret * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TEXT_AREA_TYPE_CARRET, BirdFontTextAreaCarret);
	switch (property_id) {
		case BIRD_FONT_TEXT_AREA_CARRET_CHARACTER_INDEX_PROPERTY:
		bird_font_text_area_carret_set_character_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
bird_font_text_area_class_init (BirdFontTextAreaClass * klass,
                                gpointer klass_data)
{
	bird_font_text_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTextArea_private_offset);
	((BirdFontWidgetClass *) klass)->focus = (void (*) (BirdFontWidget*, gboolean)) bird_font_text_area_real_focus;
	((BirdFontWidgetClass *) klass)->get_height = (gdouble (*) (BirdFontWidget*)) bird_font_text_area_real_get_height;
	((BirdFontWidgetClass *) klass)->get_width = (gdouble (*) (BirdFontWidget*)) bird_font_text_area_real_get_width;
	((BirdFontWidgetClass *) klass)->key_press = (void (*) (BirdFontWidget*, guint)) bird_font_text_area_real_key_press;
	((BirdFontWidgetClass *) klass)->layout = (void (*) (BirdFontWidget*)) bird_font_text_area_real_layout;
	((BirdFontWidgetClass *) klass)->button_press = (void (*) (BirdFontWidget*, guint, gdouble, gdouble)) bird_font_text_area_real_button_press;
	((BirdFontWidgetClass *) klass)->button_release = (void (*) (BirdFontWidget*, guint, gdouble, gdouble)) bird_font_text_area_real_button_release;
	((BirdFontWidgetClass *) klass)->motion = (gboolean (*) (BirdFontWidget*, gdouble, gdouble)) bird_font_text_area_real_motion;
	((BirdFontWidgetClass *) klass)->draw = (void (*) (BirdFontWidget*, cairo_t*)) bird_font_text_area_real_draw;
	((BirdFontWidgetClass *) klass)->double_click = (void (*) (BirdFontWidget*, guint, gdouble, gdouble)) bird_font_text_area_real_double_click;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_text_area_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_text_area_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_text_area_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY, bird_font_text_area_properties[BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY] = g_param_spec_boolean ("draw-carret", "draw-carret", "draw-carret", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_SCROLL_SIGNAL] = g_signal_new ("scroll", BIRD_FONT_TYPE_TEXT_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_TEXT_CHANGED_SIGNAL] = g_signal_new ("text-changed", BIRD_FONT_TYPE_TEXT_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	bird_font_text_area_signals[BIRD_FONT_TEXT_AREA_ENTER_SIGNAL] = g_signal_new ("enter", BIRD_FONT_TYPE_TEXT_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
bird_font_text_area_instance_init (BirdFontTextArea * self,
                                   gpointer klass)
{
	BirdFontColor* _tmp0_;
	BirdFontTextAreaCarret* _tmp1_;
	BirdFontTextAreaCarret* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	self->priv = bird_font_text_area_get_instance_private (self);
	self->min_width = (gdouble) 500;
	self->min_height = (gdouble) 100;
	self->padding = 3.3;
	self->single_line = FALSE;
	_tmp0_ = bird_font_color_black ();
	self->text_color = _tmp0_;
	self->carret_is_visible = FALSE;
	self->draw_border = TRUE;
	_tmp1_ = bird_font_text_area_carret_new ();
	self->priv->carret = _tmp1_;
	_tmp2_ = bird_font_text_area_carret_new ();
	self->priv->selection_end = _tmp2_;
	self->priv->update_selection = FALSE;
	self->show_selection = FALSE;
	_tmp3_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_PARAGRAPH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->paragraphs = _tmp3_;
	self->priv->last_paragraph = 0;
	_tmp4_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_TEXT_UNDO_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->undo_items = _tmp4_;
	_tmp5_ = gee_array_list_new (BIRD_FONT_TEXT_AREA_TYPE_TEXT_UNDO_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->redo_items = _tmp5_;
	self->priv->store_undo_state_at_next_event = FALSE;
}

static void
bird_font_text_area_finalize (GObject * obj)
{
	BirdFontTextArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea);
	_bird_font_color_unref0 (self->text_color);
	_g_object_unref0 (self->priv->carret);
	_g_object_unref0 (self->priv->selection_end);
	_g_object_unref0 (self->priv->paragraphs);
	_g_free0 (self->priv->text);
	_g_object_unref0 (self->priv->undo_items);
	_g_object_unref0 (self->priv->redo_items);
	G_OBJECT_CLASS (bird_font_text_area_parent_class)->finalize (obj);
}

static GType
bird_font_text_area_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTextAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_text_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTextArea), 0, (GInstanceInitFunc) bird_font_text_area_instance_init, NULL };
	GType bird_font_text_area_type_id;
	bird_font_text_area_type_id = g_type_register_static (BIRD_FONT_TYPE_WIDGET, "BirdFontTextArea", &g_define_type_info, 0);
	BirdFontTextArea_private_offset = g_type_add_instance_private (bird_font_text_area_type_id, sizeof (BirdFontTextAreaPrivate));
	return bird_font_text_area_type_id;
}

GType
bird_font_text_area_get_type (void)
{
	static volatile gsize bird_font_text_area_type_id__once = 0;
	if (g_once_init_enter (&bird_font_text_area_type_id__once)) {
		GType bird_font_text_area_type_id;
		bird_font_text_area_type_id = bird_font_text_area_get_type_once ();
		g_once_init_leave (&bird_font_text_area_type_id__once, bird_font_text_area_type_id);
	}
	return bird_font_text_area_type_id__once;
}

static void
_vala_bird_font_text_area_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BirdFontTextArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea);
	switch (property_id) {
		case BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY:
		g_value_set_boolean (value, bird_font_text_area_get_draw_carret (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_text_area_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BirdFontTextArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_TEXT_AREA, BirdFontTextArea);
	switch (property_id) {
		case BIRD_FONT_TEXT_AREA_DRAW_CARRET_PROPERTY:
		bird_font_text_area_set_draw_carret (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

