/* Table.c generated by valac 0.56.16, the Vala compiler
 * generated from Table.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TABLE_0_PROPERTY,
	BIRD_FONT_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_table_properties[BIRD_FONT_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BirdFontTablePrivate {
	gdouble scroll;
	gdouble page_height;
	GeeArrayList* column_width;
	GeeArrayList* rows;
};

static gint BirdFontTable_private_offset;
static gpointer bird_font_table_parent_class = NULL;

static void bird_font_table_real_update_rows (BirdFontTable* self);
static GeeArrayList* bird_font_table_real_get_rows (BirdFontTable* self);
static void bird_font_table_real_selected_row (BirdFontTable* self,
                                        BirdFontRow* row,
                                        gint column,
                                        gboolean delete_button);
static void bird_font_table_real_draw (BirdFontFontDisplay* base,
                                BirdFontWidgetAllocation* allocation,
                                cairo_t* cr);
static void bird_font_table_draw_headline (BirdFontTable* self,
                                    BirdFontWidgetAllocation* allocation,
                                    cairo_t* cr,
                                    BirdFontRow* row,
                                    gdouble y);
static void bird_font_table_draw_row (BirdFontTable* self,
                               BirdFontWidgetAllocation* allocation,
                               cairo_t* cr,
                               BirdFontRow* row,
                               gdouble y,
                               gboolean color,
                               gboolean dark);
static void bird_font_table_real_button_release (BirdFontFontDisplay* base,
                                          gint button,
                                          gdouble ex,
                                          gdouble ey);
static gboolean bird_font_table_real_has_scrollbar (BirdFontFontDisplay* base);
static void bird_font_table_real_scroll_wheel (BirdFontFontDisplay* base,
                                        gdouble x,
                                        gdouble y,
                                        gdouble pixeldelta,
                                        gdouble dy);
static void bird_font_table_real_update_scrollbar (BirdFontFontDisplay* base);
static void bird_font_table_real_scroll_to (BirdFontFontDisplay* base,
                                     gdouble percent);
static void bird_font_table_real_selected_canvas (BirdFontFontDisplay* base);
static void bird_font_table_finalize (GObject * obj);
static GType bird_font_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_table_get_instance_private (BirdFontTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTable_private_offset);
}

static void
bird_font_table_real_update_rows (BirdFontTable* self)
{
	g_critical ("Type `%s' does not implement abstract method `bird_font_table_update_rows'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
bird_font_table_update_rows (BirdFontTable* self)
{
	BirdFontTableClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_TABLE_GET_CLASS (self);
	if (_klass_->update_rows) {
		_klass_->update_rows (self);
	}
}

static GeeArrayList*
bird_font_table_real_get_rows (BirdFontTable* self)
{
	g_critical ("Type `%s' does not implement abstract method `bird_font_table_get_rows'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeArrayList*
bird_font_table_get_rows (BirdFontTable* self)
{
	BirdFontTableClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BIRD_FONT_TABLE_GET_CLASS (self);
	if (_klass_->get_rows) {
		return _klass_->get_rows (self);
	}
	return NULL;
}

static void
bird_font_table_real_selected_row (BirdFontTable* self,
                                   BirdFontRow* row,
                                   gint column,
                                   gboolean delete_button)
{
	g_critical ("Type `%s' does not implement abstract method `bird_font_table_selected_row'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
bird_font_table_selected_row (BirdFontTable* self,
                              BirdFontRow* row,
                              gint column,
                              gboolean delete_button)
{
	BirdFontTableClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_TABLE_GET_CLASS (self);
	if (_klass_->selected_row) {
		_klass_->selected_row (self, row, column, delete_button);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_table_real_draw (BirdFontFontDisplay* base,
                           BirdFontWidgetAllocation* allocation,
                           cairo_t* cr)
{
	BirdFontTable * self;
	gboolean color = FALSE;
	gboolean _tmp0_ = FALSE;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontTable*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	color = (self->priv->scroll + (1 % 2)) == ((gdouble) 0);
	_tmp1_ = self->allocation;
	if (allocation->width != _tmp1_->width) {
		_tmp0_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp2_;
		_tmp2_ = self->allocation;
		_tmp0_ = allocation->height != _tmp2_->height;
	}
	if (_tmp0_) {
		BirdFontWidgetAllocation* _tmp3_;
		_tmp3_ = _g_object_ref0 (allocation);
		_g_object_unref0 (self->allocation);
		self->allocation = _tmp3_;
		bird_font_table_update_rows (self);
		bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	}
	bird_font_table_layout (self);
	cairo_save (cr);
	bird_font_theme_color (cr, "Background 1");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
	cairo_fill (cr);
	cairo_restore (cr);
	{
		GeeArrayList* _r_list = NULL;
		GeeArrayList* _tmp4_;
		gint _r_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _r_index = 0;
		_tmp4_ = self->priv->rows;
		_r_list = _tmp4_;
		_tmp5_ = _r_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_r_size = _tmp7_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontRow* r = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			BirdFontRow* _tmp13_;
			gdouble _tmp14_;
			_r_index = _r_index + 1;
			_tmp8_ = _r_index;
			_tmp9_ = _r_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _r_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _r_index);
			r = (BirdFontRow*) _tmp11_;
			_tmp13_ = r;
			_tmp14_ = _tmp13_->y;
			if ((self->priv->scroll < _tmp14_) && (_tmp14_ < (self->priv->scroll + allocation->height))) {
				_tmp12_ = TRUE;
			} else {
				BirdFontRow* _tmp15_;
				BirdFontRow* _tmp16_;
				gdouble _tmp17_;
				_tmp15_ = r;
				_tmp16_ = r;
				_tmp17_ = _tmp15_->y + bird_font_row_get_height (_tmp16_);
				_tmp12_ = (self->priv->scroll < _tmp17_) && (_tmp17_ < (self->priv->scroll + allocation->height));
			}
			if (_tmp12_) {
				BirdFontRow* _tmp18_;
				_tmp18_ = r;
				if (_tmp18_->is_headline) {
					BirdFontRow* _tmp19_;
					BirdFontRow* _tmp20_;
					_tmp19_ = r;
					_tmp20_ = r;
					bird_font_table_draw_headline (self, allocation, cr, _tmp19_, _tmp20_->y - self->priv->scroll);
				} else {
					BirdFontRow* _tmp21_;
					BirdFontRow* _tmp22_;
					_tmp21_ = r;
					_tmp22_ = r;
					bird_font_table_draw_row (self, allocation, cr, _tmp21_, _tmp22_->y - self->priv->scroll, color, TRUE);
				}
				color = !color;
			}
			_g_object_unref0 (r);
		}
	}
}

void
bird_font_table_layout (BirdFontTable* self)
{
	gint width = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_table_get_rows (self);
	_g_object_unref0 (self->priv->rows);
	self->priv->rows = _tmp0_;
	_tmp1_ = self->priv->column_width;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp4_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i <= BIRD_FONT_ROW_MAX_COLUMNS)) {
					break;
				}
				_tmp4_ = self->priv->column_width;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((gintptr) 0));
			}
		}
	}
	self->priv->page_height = (gdouble) 0;
	{
		GeeArrayList* _row_list = NULL;
		GeeArrayList* _tmp5_;
		gint _row_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _row_index = 0;
		_tmp5_ = self->priv->rows;
		_row_list = _tmp5_;
		_tmp6_ = _row_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_row_size = _tmp8_;
		_row_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontRow* row = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontRow* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			BirdFontRow* _tmp30_;
			BirdFontRow* _tmp31_;
			_row_index = _row_index + 1;
			_tmp9_ = _row_index;
			_tmp10_ = _row_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _row_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _row_index);
			row = (BirdFontRow*) _tmp12_;
			_tmp13_ = row;
			_tmp14_ = bird_font_row_get_columns (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->column_width;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			g_return_if_fail (_tmp15_ <= _tmp18_);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp19_ = FALSE;
					_tmp19_ = TRUE;
					while (TRUE) {
						BirdFontRow* _tmp21_;
						gint _tmp22_;
						gint _tmp23_;
						BirdFontRow* _tmp24_;
						BirdFontText* _tmp25_;
						BirdFontText* _tmp26_;
						GeeArrayList* _tmp27_;
						gpointer _tmp28_;
						if (!_tmp19_) {
							gint _tmp20_;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp19_ = FALSE;
						_tmp21_ = row;
						_tmp22_ = bird_font_row_get_columns (_tmp21_);
						_tmp23_ = _tmp22_;
						if (!(i < _tmp23_)) {
							break;
						}
						_tmp24_ = row;
						_tmp25_ = bird_font_row_get_column (_tmp24_, i);
						_tmp26_ = _tmp25_;
						width = (gint) bird_font_text_get_sidebearing_extent (_tmp26_);
						_g_object_unref0 (_tmp26_);
						width += (gint) 10;
						if (width < 100) {
							width = (gint) 100;
						}
						_tmp27_ = self->priv->column_width;
						_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, i);
						if (width > ((gint) ((gintptr) _tmp28_))) {
							GeeArrayList* _tmp29_;
							_tmp29_ = self->priv->column_width;
							gee_abstract_list_set ((GeeAbstractList*) _tmp29_, i, (gpointer) ((gintptr) width));
						}
					}
				}
			}
			_tmp30_ = row;
			_tmp30_->y = self->priv->page_height;
			_tmp31_ = row;
			self->priv->page_height = self->priv->page_height + bird_font_row_get_height (_tmp31_);
			_g_object_unref0 (row);
		}
	}
}

static void
bird_font_table_draw_headline (BirdFontTable* self,
                               BirdFontWidgetAllocation* allocation,
                               cairo_t* cr,
                               BirdFontRow* row,
                               gdouble y)
{
	BirdFontText* t = NULL;
	BirdFontText* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (row != NULL);
	cairo_save (cr);
	bird_font_theme_color (cr, "Text Foreground");
	_tmp0_ = bird_font_row_get_column (row, 0);
	_g_object_unref0 (t);
	t = _tmp0_;
	((BirdFontWidget*) t)->widget_x = (gdouble) 40;
	((BirdFontWidget*) t)->widget_y = y + 45;
	bird_font_widget_draw ((BirdFontWidget*) t, cr);
	cairo_restore (cr);
	_g_object_unref0 (t);
}

static void
bird_font_table_draw_row (BirdFontTable* self,
                          BirdFontWidgetAllocation* allocation,
                          cairo_t* cr,
                          BirdFontRow* row,
                          gdouble y,
                          gboolean color,
                          gboolean dark)
{
	BirdFontText* t = NULL;
	gdouble x = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (row != NULL);
	cairo_save (cr);
	if (color) {
		bird_font_theme_color (cr, "Table Background 2");
	} else {
		bird_font_theme_color (cr, "Table Background 1");
	}
	cairo_rectangle (cr, (gdouble) 0, y, (gdouble) allocation->width, (gdouble) 25);
	cairo_fill (cr);
	cairo_restore (cr);
	if (bird_font_row_has_delete_button (row)) {
		cairo_save (cr);
		bird_font_theme_color (cr, "Foreground 1");
		cairo_set_line_width (cr, (gdouble) 1);
		cairo_move_to (cr, (gdouble) 10, y + 15);
		cairo_line_to (cr, (gdouble) 15, y + 10);
		cairo_move_to (cr, (gdouble) 10, y + 10);
		cairo_line_to (cr, (gdouble) 15, y + 15);
		cairo_stroke (cr);
		cairo_restore (cr);
	}
	_tmp0_ = bird_font_row_get_columns (row);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->column_width;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_return_if_fail (_tmp1_ <= _tmp4_);
	x = (gdouble) 40;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				BirdFontText* _tmp9_;
				BirdFontText* _tmp10_;
				BirdFontText* _tmp11_;
				BirdFontText* _tmp12_;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = bird_font_row_get_columns (row);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				cairo_save (cr);
				bird_font_theme_color (cr, "Foreground 1");
				_tmp9_ = bird_font_row_get_column (row, i);
				_g_object_unref0 (t);
				t = _tmp9_;
				_tmp10_ = t;
				((BirdFontWidget*) _tmp10_)->widget_x = x;
				_tmp11_ = t;
				((BirdFontWidget*) _tmp11_)->widget_y = y + 3;
				_tmp12_ = t;
				bird_font_widget_draw ((BirdFontWidget*) _tmp12_, cr);
				_tmp13_ = self->priv->column_width;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, i);
				x += (gdouble) ((gint) ((gintptr) _tmp14_));
				cairo_restore (cr);
			}
		}
	}
	_g_object_unref0 (t);
}

static void
bird_font_table_real_button_release (BirdFontFontDisplay* base,
                                     gint button,
                                     gdouble ex,
                                     gdouble ey)
{
	BirdFontTable * self;
	gdouble x = 0.0;
	gint column = 0;
	BirdFontRow* selected = NULL;
	gboolean over_delete = FALSE;
	BirdFontRow* _tmp31_;
	BirdFontWidgetAllocation* _tmp33_;
	BirdFontWidgetAllocation* _tmp34_;
	self = (BirdFontTable*) base;
	x = (gdouble) 0;
	column = -1;
	selected = NULL;
	over_delete = FALSE;
	if (button != 1) {
		_g_object_unref0 (selected);
		return;
	}
	{
		GeeArrayList* _r_list = NULL;
		GeeArrayList* _tmp0_;
		gint _r_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _r_index = 0;
		_tmp0_ = self->priv->rows;
		_r_list = _tmp0_;
		_tmp1_ = _r_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_r_size = _tmp3_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontRow* r = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontRow* _tmp8_;
			BirdFontRow* _tmp9_;
			BirdFontRow* _tmp10_;
			gdouble _tmp11_;
			_r_index = _r_index + 1;
			_tmp4_ = _r_index;
			_tmp5_ = _r_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _r_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _r_index);
			r = (BirdFontRow*) _tmp7_;
			_tmp8_ = r;
			_tmp9_ = r;
			_tmp10_ = r;
			_tmp11_ = ey + self->priv->scroll;
			if ((_tmp8_->y <= _tmp11_) && (_tmp11_ <= (_tmp9_->y + bird_font_row_get_height (_tmp10_)))) {
				gboolean _tmp26_ = FALSE;
				BirdFontRow* _tmp28_;
				x = (gdouble) 0;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							BirdFontRow* _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							GeeArrayList* _tmp17_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							GeeArrayList* _tmp21_;
							gpointer _tmp22_;
							gdouble _tmp23_;
							GeeArrayList* _tmp24_;
							gpointer _tmp25_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = i;
								i = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = r;
							_tmp15_ = bird_font_row_get_columns (_tmp14_);
							_tmp16_ = _tmp15_;
							if (!(i < _tmp16_)) {
								break;
							}
							_tmp17_ = self->priv->column_width;
							_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = i;
							g_return_if_fail ((0 <= _tmp20_) && (_tmp20_ < _tmp19_));
							_tmp21_ = self->priv->column_width;
							_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, i);
							_tmp23_ = ex;
							if ((x <= _tmp23_) && (_tmp23_ < (x + ((gint) ((gintptr) _tmp22_))))) {
								column = i;
							}
							_tmp24_ = self->priv->column_width;
							_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
							x += (gdouble) ((gint) ((gintptr) _tmp25_));
						}
					}
				}
				if (ex < ((gdouble) 18)) {
					BirdFontRow* _tmp27_;
					_tmp27_ = r;
					_tmp26_ = bird_font_row_has_delete_button (_tmp27_);
				} else {
					_tmp26_ = FALSE;
				}
				over_delete = _tmp26_;
				if (over_delete) {
					column = -1;
				}
				_tmp28_ = r;
				if (!_tmp28_->is_headline) {
					BirdFontRow* _tmp29_;
					BirdFontRow* _tmp30_;
					_tmp29_ = r;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					_g_object_unref0 (selected);
					selected = _tmp30_;
				}
				_g_object_unref0 (r);
				break;
			}
			_g_object_unref0 (r);
		}
	}
	_tmp31_ = selected;
	if (_tmp31_ != NULL) {
		BirdFontRow* _tmp32_;
		_tmp32_ = selected;
		bird_font_table_selected_row (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, BIRD_FONT_TYPE_ROW, BirdFontRow), column, over_delete);
	}
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	_tmp33_ = self->allocation;
	_tmp34_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp33_->width, (gdouble) _tmp34_->height);
	_g_object_unref0 (selected);
}

static gboolean
bird_font_table_real_has_scrollbar (BirdFontFontDisplay* base)
{
	BirdFontTable * self;
	gboolean result;
	self = (BirdFontTable*) base;
	result = TRUE;
	return result;
}

static void
bird_font_table_real_scroll_wheel (BirdFontFontDisplay* base,
                                   gdouble x,
                                   gdouble y,
                                   gdouble pixeldelta,
                                   gdouble dy)
{
	BirdFontTable * self;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	BirdFontWidgetAllocation* _tmp4_;
	self = (BirdFontTable*) base;
	self->priv->scroll = self->priv->scroll - dy;
	_tmp0_ = self->allocation;
	if (self->priv->scroll > (self->priv->page_height - _tmp0_->height)) {
		BirdFontWidgetAllocation* _tmp1_;
		_tmp1_ = self->allocation;
		self->priv->scroll = self->priv->page_height - _tmp1_->height;
	}
	_tmp2_ = self->allocation;
	if (((gdouble) _tmp2_->height) > self->priv->page_height) {
		self->priv->scroll = (gdouble) 0;
	}
	if (self->priv->scroll < ((gdouble) 0)) {
		self->priv->scroll = (gdouble) 0;
	}
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	_tmp3_ = self->allocation;
	_tmp4_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp3_->width, (gdouble) _tmp4_->height);
}

static void
bird_font_table_real_update_scrollbar (BirdFontFontDisplay* base)
{
	BirdFontTable * self;
	gboolean _tmp0_ = FALSE;
	self = (BirdFontTable*) base;
	if (self->priv->page_height == ((gdouble) 0)) {
		_tmp0_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp1_;
		_tmp1_ = self->allocation;
		_tmp0_ = ((gdouble) _tmp1_->height) >= self->priv->page_height;
	}
	if (_tmp0_) {
		bird_font_main_window_set_scrollbar_size ((gdouble) 0);
		bird_font_main_window_set_scrollbar_position ((gdouble) 0);
	} else {
		BirdFontWidgetAllocation* _tmp2_;
		BirdFontWidgetAllocation* _tmp3_;
		_tmp2_ = self->allocation;
		bird_font_main_window_set_scrollbar_size (_tmp2_->height / self->priv->page_height);
		_tmp3_ = self->allocation;
		bird_font_main_window_set_scrollbar_position (self->priv->scroll / (self->priv->page_height - _tmp3_->height));
	}
}

static void
bird_font_table_real_scroll_to (BirdFontFontDisplay* base,
                                gdouble percent)
{
	BirdFontTable * self;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	self = (BirdFontTable*) base;
	_tmp0_ = self->allocation;
	self->priv->scroll = percent * (self->priv->page_height - _tmp0_->height);
	if (self->priv->scroll > self->priv->page_height) {
		BirdFontWidgetAllocation* _tmp1_;
		_tmp1_ = self->allocation;
		self->priv->scroll = (gdouble) ((gint) (self->priv->page_height - _tmp1_->height));
	}
	_tmp2_ = self->allocation;
	_tmp3_ = self->allocation;
	g_signal_emit_by_name ((BirdFontFontDisplay*) self, "redraw-area", (gdouble) 0, (gdouble) 0, (gdouble) _tmp2_->width, (gdouble) _tmp3_->height);
}

static void
bird_font_table_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontTable * self;
	self = (BirdFontTable*) base;
	bird_font_table_update_rows (self);
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
}

BirdFontTable*
bird_font_table_construct (GType object_type)
{
	BirdFontTable * self = NULL;
	self = (BirdFontTable*) bird_font_font_display_construct (object_type);
	return self;
}

static void
bird_font_table_class_init (BirdFontTableClass * klass,
                            gpointer klass_data)
{
	bird_font_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTable_private_offset);
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_table_real_update_rows;
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_table_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_table_real_selected_row;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_table_real_draw;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_table_real_button_release;
	((BirdFontFontDisplayClass *) klass)->has_scrollbar = (gboolean (*) (BirdFontFontDisplay*)) bird_font_table_real_has_scrollbar;
	((BirdFontFontDisplayClass *) klass)->scroll_wheel = (void (*) (BirdFontFontDisplay*, gdouble, gdouble, gdouble, gdouble)) bird_font_table_real_scroll_wheel;
	((BirdFontFontDisplayClass *) klass)->update_scrollbar = (void (*) (BirdFontFontDisplay*)) bird_font_table_real_update_scrollbar;
	((BirdFontFontDisplayClass *) klass)->scroll_to = (void (*) (BirdFontFontDisplay*, gdouble)) bird_font_table_real_scroll_to;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_table_real_selected_canvas;
	G_OBJECT_CLASS (klass)->finalize = bird_font_table_finalize;
}

static void
bird_font_table_instance_init (BirdFontTable * self,
                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	GeeArrayList* _tmp2_;
	self->priv = bird_font_table_get_instance_private (self);
	self->priv->scroll = (gdouble) 0;
	self->priv->page_height = (gdouble) 0;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	self->priv->column_width = _tmp0_;
	_tmp1_ = bird_font_widget_allocation_new ();
	self->allocation = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->rows = _tmp2_;
}

static void
bird_font_table_finalize (GObject * obj)
{
	BirdFontTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TABLE, BirdFontTable);
	_g_object_unref0 (self->priv->column_width);
	_g_object_unref0 (self->allocation);
	_g_object_unref0 (self->priv->rows);
	G_OBJECT_CLASS (bird_font_table_parent_class)->finalize (obj);
}

/** Table functions. */
static GType
bird_font_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTable), 0, (GInstanceInitFunc) bird_font_table_instance_init, NULL };
	GType bird_font_table_type_id;
	bird_font_table_type_id = g_type_register_static (BIRD_FONT_TYPE_FONT_DISPLAY, "BirdFontTable", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BirdFontTable_private_offset = g_type_add_instance_private (bird_font_table_type_id, sizeof (BirdFontTablePrivate));
	return bird_font_table_type_id;
}

GType
bird_font_table_get_type (void)
{
	static volatile gsize bird_font_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_table_type_id__once)) {
		GType bird_font_table_type_id;
		bird_font_table_type_id = bird_font_table_get_type_once ();
		g_once_init_leave (&bird_font_table_type_id__once, bird_font_table_type_id);
	}
	return bird_font_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

