/* TabContent.c generated by valac 0.56.16, the Vala compiler
 * generated from TabContent.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 3 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib-object.h>

#define BIRD_FONT_TAB_CONTENT_TEXT_INPUT_HEIGHT 51
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TAB_CONTENT_0_PROPERTY,
	BIRD_FONT_TAB_CONTENT_NUM_PROPERTIES
};
static GParamSpec* bird_font_tab_content_properties[BIRD_FONT_TAB_CONTENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block66Data Block66Data;

struct _Block66Data {
	int _ref_count_;
	BirdFontTextListener* tl;
};

static gpointer bird_font_tab_content_parent_class = NULL;
static BirdFontText* bird_font_tab_content_text_input_label;
static BirdFontText* bird_font_tab_content_text_input_label = NULL;
static BirdFontLineTextArea* bird_font_tab_content_text_input;
static BirdFontLineTextArea* bird_font_tab_content_text_input = NULL;
static BirdFontButton* bird_font_tab_content_text_input_button;
static BirdFontButton* bird_font_tab_content_text_input_button = NULL;
static gboolean bird_font_tab_content_text_input_visible;
static gboolean bird_font_tab_content_text_input_visible = FALSE;
static BirdFontTextListener* bird_font_tab_content_text_callback;
static BirdFontTextListener* bird_font_tab_content_text_callback = NULL;
static cairo_surface_t* bird_font_tab_content_pause_surface;
static cairo_surface_t* bird_font_tab_content_pause_surface = NULL;
static gdouble bird_font_tab_content_last_press_time;
static gdouble bird_font_tab_content_last_press_time = (gdouble) 0;

static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static void __lambda15_ (Block66Data* _data66_,
                  const gchar* text);
static void ___lambda15__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                                    const gchar* text,
                                                    gpointer self);
static void __lambda16_ (Block66Data* _data66_,
                  const gchar* text);
static void ___lambda16__bird_font_text_area_enter (BirdFontTextArea* _sender,
                                             const gchar* text,
                                             gpointer self);
static void __lambda17_ (Block66Data* _data66_);
static void ___lambda17__bird_font_button_action (BirdFontButton* _sender,
                                           gpointer self);
static void bird_font_tab_content_finalize (GObject * obj);
static GType bird_font_tab_content_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
bird_font_tab_content_zoom_in (void)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_zoom_in (_tmp0_);
}

void
bird_font_tab_content_zoom_out (void)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_zoom_out (_tmp0_);
}

void
bird_font_tab_content_move_view (gdouble x,
                                 gdouble y)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_move_view (_tmp0_, x, y);
}

gboolean
bird_font_tab_content_has_scrollbar (void)
{
	BirdFontFontDisplay* _tmp0_;
	gboolean result;
	if (bird_font_menu_tab_has_suppress_event ()) {
		result = FALSE;
		return result;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	result = bird_font_font_display_has_scrollbar (_tmp0_);
	return result;
}

void
bird_font_tab_content_scroll_to (gdouble percent)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_scroll_to (_tmp0_, percent);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_tab_content_draw (BirdFontWidgetAllocation* allocation,
                            cairo_t* cr)
{
	BirdFontAbstractMenu* menu = NULL;
	BirdFontDialog* dialog = NULL;
	gdouble scollbar_width = 0.0;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	scollbar_width = 10 * bird_font_screen_get_scale ();
	if (bird_font_main_window_has_scrollbar ()) {
		allocation->width = allocation->width - ((gint) scollbar_width);
	}
	if (G_UNLIKELY (bird_font_menu_tab_has_suppress_event ())) {
		cairo_surface_t* _tmp0_;
		cairo_save (cr);
		bird_font_theme_color (cr, "Background 1");
		cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
		cairo_fill (cr);
		_tmp0_ = bird_font_tab_content_pause_surface;
		if (_tmp0_ != NULL) {
			cairo_surface_t* _tmp1_;
			cairo_scale (cr, 1.0 / bird_font_screen_get_scale (), 1.0 / bird_font_screen_get_scale ());
			_tmp1_ = bird_font_tab_content_pause_surface;
			cairo_set_source_surface (cr, (cairo_surface_t*) _tmp1_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
		}
		cairo_restore (cr);
	} else {
		BirdFontAbstractMenu* _tmp2_;
		BirdFontDialog* _tmp3_;
		BirdFontGlyph* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontFontDisplay* _tmp6_;
		BirdFontDialog* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp2_ = bird_font_main_window_get_menu ();
		_g_object_unref0 (menu);
		menu = _tmp2_;
		_tmp3_ = bird_font_main_window_get_dialog ();
		_g_object_unref0 (dialog);
		dialog = _tmp3_;
		bird_font_glyph_canvas_set_allocation (allocation);
		_tmp4_ = bird_font_main_window_get_current_glyph ();
		_tmp5_ = _tmp4_;
		bird_font_glyph_resized (_tmp5_, allocation);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_draw (_tmp6_, allocation, cr);
		_tmp7_ = dialog;
		_tmp8_ = bird_font_dialog_get_visible (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			BirdFontDialog* _tmp10_;
			BirdFontWidgetAllocation* _tmp11_;
			BirdFontDialog* _tmp12_;
			BirdFontDialog* _tmp13_;
			_tmp10_ = dialog;
			_tmp11_ = _g_object_ref0 (allocation);
			_g_object_unref0 (((BirdFontWidget*) _tmp10_)->allocation);
			((BirdFontWidget*) _tmp10_)->allocation = _tmp11_;
			_tmp12_ = dialog;
			bird_font_widget_layout ((BirdFontWidget*) _tmp12_);
			_tmp13_ = dialog;
			bird_font_widget_draw ((BirdFontWidget*) _tmp13_, cr);
		} else {
			BirdFontAbstractMenu* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp14_ = menu;
			_tmp15_ = bird_font_abstract_menu_get_show_menu (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				BirdFontAbstractMenu* _tmp17_;
				_tmp17_ = menu;
				bird_font_abstract_menu_draw (_tmp17_, allocation, cr);
			}
		}
		if (bird_font_font_display_dirty_scrollbar) {
			BirdFontFontDisplay* _tmp18_;
			_tmp18_ = bird_font_glyph_canvas_current_display;
			bird_font_font_display_update_scrollbar (_tmp18_);
			bird_font_font_display_dirty_scrollbar = FALSE;
		}
		if (bird_font_tab_content_text_input_visible) {
			bird_font_tab_content_draw_text_input (allocation, cr);
		}
		if (bird_font_main_window_has_scrollbar ()) {
			BirdFontScrollbar* _tmp19_;
			_tmp19_ = bird_font_main_window_scrollbar;
			bird_font_scrollbar_draw (_tmp19_, cr, allocation, scollbar_width);
		}
	}
	_g_object_unref0 (dialog);
	_g_object_unref0 (menu);
}

void
bird_font_tab_content_create_pause_surface (void)
{
	cairo_t* cr = NULL;
	BirdFontWidgetAllocation* alloc = NULL;
	BirdFontWidgetAllocation* _tmp0_;
	gdouble scollbar_width = 0.0;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	BirdFontWidgetAllocation* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	BirdFontWidgetAllocation* _tmp9_;
	cairo_t* _tmp10_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		g_warning ("TabContent.vala:130: Background surface already created.");
		_g_object_unref0 (alloc);
		_cairo_destroy0 (cr);
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_get_allocation ();
	_g_object_unref0 (alloc);
	alloc = _tmp0_;
	scollbar_width = 10 * bird_font_screen_get_scale ();
	_tmp1_ = alloc;
	_tmp2_ = alloc;
	_tmp2_->width = _tmp2_->width + ((gint) scollbar_width);
	_tmp3_ = alloc;
	_tmp4_ = alloc;
	_tmp5_ = bird_font_screen_create_background_surface (_tmp3_->width, _tmp4_->height);
	_cairo_surface_destroy0 (bird_font_tab_content_pause_surface);
	bird_font_tab_content_pause_surface = _tmp5_;
	_tmp6_ = bird_font_tab_content_pause_surface;
	_tmp7_ = cairo_create ((cairo_surface_t*) _tmp6_);
	_cairo_destroy0 (cr);
	cr = _tmp7_;
	_tmp8_ = cr;
	cairo_scale (_tmp8_, bird_font_screen_get_scale (), bird_font_screen_get_scale ());
	_tmp9_ = alloc;
	_tmp10_ = cr;
	bird_font_tab_content_draw (_tmp9_, _tmp10_);
	_g_object_unref0 (alloc);
	_cairo_destroy0 (cr);
}

void
bird_font_tab_content_key_press (guint keyval)
{
	gboolean _tmp0_ = FALSE;
	gunichar c = 0U;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp0_ = TRUE;
	} else {
		BirdFontDialog* _tmp1_;
		BirdFontDialog* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = bird_font_main_window_get_dialog ();
		_tmp2_ = _tmp1_;
		_tmp3_ = bird_font_dialog_get_visible (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	if (_tmp0_) {
		return;
	}
	c = (gunichar) keyval;
	if (G_UNLIKELY (!g_unichar_validate (c))) {
		g_warning ("TabContent.vala:153: Invalid unichar: $(keyval)");
		return;
	}
	bird_font_key_bindings_add_modifier_from_keyval (keyval);
	if (!bird_font_tab_content_text_input_visible) {
		BirdFontAbstractMenu* menu = NULL;
		BirdFontAbstractMenu* _tmp5_;
		gboolean consumed = FALSE;
		BirdFontAbstractMenu* _tmp6_;
		_tmp5_ = bird_font_main_window_get_menu ();
		menu = _tmp5_;
		_tmp6_ = menu;
		consumed = bird_font_abstract_menu_process_key_binding_events (_tmp6_, keyval);
		if (!consumed) {
			BirdFontFontDisplay* _tmp7_;
			_tmp7_ = bird_font_glyph_canvas_current_display;
			bird_font_font_display_key_press (_tmp7_, keyval);
		}
		_g_object_unref0 (menu);
	} else {
		BirdFontLineTextArea* _tmp8_;
		_tmp8_ = bird_font_tab_content_text_input;
		bird_font_widget_key_press ((BirdFontWidget*) _tmp8_, keyval);
	}
}

void
bird_font_tab_content_key_release (guint keyval)
{
	gboolean _tmp0_ = FALSE;
	gunichar c = 0U;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_tmp0_ = TRUE;
	} else {
		BirdFontDialog* _tmp1_;
		BirdFontDialog* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = bird_font_main_window_get_dialog ();
		_tmp2_ = _tmp1_;
		_tmp3_ = bird_font_dialog_get_visible (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	if (_tmp0_) {
		return;
	}
	c = (gunichar) keyval;
	if (G_UNLIKELY (!g_unichar_validate (c))) {
		g_warning ("TabContent.vala:179: Invalid unichar: $(keyval)");
		return;
	}
	bird_font_key_bindings_remove_modifier_from_keyval (keyval);
	if (!bird_font_tab_content_text_input_visible) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_key_release (_tmp5_, keyval);
	}
}

void
bird_font_tab_content_motion_notify (gdouble x,
                                     gdouble y)
{
	BirdFontToolbox* toolbox = NULL;
	BirdFontToolbox* _tmp3_;
	BirdFontToolbox* _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_object_unref0 (toolbox);
		return;
	}
	if (!bird_font_tab_content_text_input_visible) {
		gboolean consumed = FALSE;
		BirdFontScrollbar* _tmp0_;
		_tmp0_ = bird_font_main_window_scrollbar;
		consumed = bird_font_scrollbar_motion (_tmp0_, x, y);
		if (!consumed) {
			BirdFontFontDisplay* _tmp1_;
			_tmp1_ = bird_font_glyph_canvas_current_display;
			bird_font_font_display_motion_notify (_tmp1_, x, y);
		}
	} else {
		BirdFontLineTextArea* _tmp2_;
		_tmp2_ = bird_font_tab_content_text_input;
		bird_font_widget_motion ((BirdFontWidget*) _tmp2_, x, y);
		bird_font_glyph_canvas_redraw ();
	}
	_tmp3_ = bird_font_main_window_get_toolbox ();
	_g_object_unref0 (toolbox);
	toolbox = _tmp3_;
	_tmp4_ = toolbox;
	bird_font_toolbox_hide_tooltip (_tmp4_);
	_g_object_unref0 (toolbox);
}

void
bird_font_tab_content_button_release (gint button,
                                      gdouble x,
                                      gdouble y)
{
	BirdFontDialog* _tmp0_;
	BirdFontDialog* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_dialog ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_dialog_get_visible (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontDialog* _tmp5_;
		BirdFontDialog* _tmp6_;
		_tmp5_ = bird_font_main_window_get_dialog ();
		_tmp6_ = _tmp5_;
		bird_font_widget_button_release ((BirdFontWidget*) _tmp6_, (guint) button, x, y);
		_g_object_unref0 (_tmp6_);
	} else {
		BirdFontAbstractMenu* _tmp7_;
		BirdFontAbstractMenu* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = bird_font_main_window_get_menu ();
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_abstract_menu_get_show_menu (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp8_);
		if (_tmp11_) {
			BirdFontAbstractMenu* _tmp12_;
			BirdFontAbstractMenu* _tmp13_;
			_tmp12_ = bird_font_main_window_get_menu ();
			_tmp13_ = _tmp12_;
			bird_font_abstract_menu_button_release (_tmp13_, button, x, y);
			_g_object_unref0 (_tmp13_);
		} else {
			if (bird_font_tab_content_text_input_visible) {
				BirdFontButton* _tmp14_;
				BirdFontLineTextArea* _tmp15_;
				_tmp14_ = bird_font_tab_content_text_input_button;
				bird_font_widget_button_release ((BirdFontWidget*) _tmp14_, (guint) button, x, y);
				_tmp15_ = bird_font_tab_content_text_input;
				bird_font_widget_button_release ((BirdFontWidget*) _tmp15_, (guint) button, x, y);
				bird_font_glyph_canvas_redraw ();
			} else {
				gboolean consumed = FALSE;
				BirdFontScrollbar* _tmp16_;
				_tmp16_ = bird_font_main_window_scrollbar;
				consumed = bird_font_scrollbar_button_release (_tmp16_, (guint) button, x, y);
				if (!consumed) {
					BirdFontFontDisplay* _tmp17_;
					_tmp17_ = bird_font_glyph_canvas_current_display;
					bird_font_font_display_button_release (_tmp17_, button, x, y);
				}
			}
		}
	}
}

void
bird_font_tab_content_button_press (guint button,
                                    gdouble x,
                                    gdouble y)
{
	BirdFontDialog* _tmp0_;
	BirdFontDialog* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	bird_font_tab_content_last_press_time = (gdouble) g_get_real_time ();
	_tmp0_ = bird_font_main_window_get_dialog ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_dialog_get_visible (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontDialog* _tmp5_;
		BirdFontDialog* _tmp6_;
		_tmp5_ = bird_font_main_window_get_dialog ();
		_tmp6_ = _tmp5_;
		bird_font_widget_button_press ((BirdFontWidget*) _tmp6_, button, x, y);
		_g_object_unref0 (_tmp6_);
	} else {
		BirdFontAbstractMenu* _tmp7_;
		BirdFontAbstractMenu* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = bird_font_main_window_get_menu ();
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_abstract_menu_get_show_menu (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = !_tmp10_;
		_g_object_unref0 (_tmp8_);
		if (_tmp11_) {
			if (bird_font_tab_content_text_input_visible) {
				BirdFontLineTextArea* _tmp12_;
				BirdFontButton* _tmp13_;
				_tmp12_ = bird_font_tab_content_text_input;
				bird_font_widget_button_press ((BirdFontWidget*) _tmp12_, button, x, y);
				_tmp13_ = bird_font_tab_content_text_input_button;
				bird_font_widget_button_press ((BirdFontWidget*) _tmp13_, button, x, y);
				if (y > ((gdouble) BIRD_FONT_TAB_CONTENT_TEXT_INPUT_HEIGHT)) {
					bird_font_tab_content_hide_text_input ();
				}
			} else {
				gboolean consumed = FALSE;
				BirdFontScrollbar* _tmp14_;
				_tmp14_ = bird_font_main_window_scrollbar;
				consumed = bird_font_scrollbar_button_press (_tmp14_, button, x, y);
				if (!consumed) {
					BirdFontFontDisplay* _tmp15_;
					_tmp15_ = bird_font_glyph_canvas_current_display;
					bird_font_font_display_button_press (_tmp15_, button, x, y);
				}
			}
		}
	}
}

void
bird_font_tab_content_double_click (guint button,
                                    gdouble ex,
                                    gdouble ey)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_double_click (_tmp5_, button, ex, ey);
	}
}

void
bird_font_tab_content_scroll_wheel_pixel_delta (gdouble x,
                                                gdouble y,
                                                gdouble pixeldelta_x,
                                                gdouble pixeldelta_y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_scroll_wheel (_tmp5_, x, y, pixeldelta_x, pixeldelta_y);
	}
}

void
bird_font_tab_content_scroll_wheel_up (gdouble x,
                                       gdouble y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_scroll_wheel (_tmp5_, x, y, (gdouble) 0, (gdouble) 15);
	}
}

void
bird_font_tab_content_scroll_wheel_down (gdouble x,
                                         gdouble y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_scroll_wheel (_tmp5_, x, y, (gdouble) 0, (gdouble) -15);
	}
}

void
bird_font_tab_content_magnify (gdouble magnification)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_magnify (_tmp5_, magnification);
	}
}

void
bird_font_tab_content_tap_down (gint finger,
                                gint x,
                                gint y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_tap_down (_tmp5_, finger, x, y);
	}
}

void
bird_font_tab_content_tap_up (gint finger,
                              gint x,
                              gint y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_tap_up (_tmp5_, finger, x, y);
	}
}

void
bird_font_tab_content_tap_move (gint finger,
                                gint x,
                                gint y)
{
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = !_tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontFontDisplay* _tmp5_;
		_tmp5_ = bird_font_glyph_canvas_current_display;
		bird_font_font_display_tap_move (_tmp5_, finger, x, y);
	}
}

void
bird_font_tab_content_undo (void)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_undo (_tmp0_);
}

void
bird_font_tab_content_redo (void)
{
	BirdFontFontDisplay* _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	_tmp0_ = bird_font_glyph_canvas_current_display;
	bird_font_font_display_redo (_tmp0_);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
bird_font_tab_content_path_to_uri (const gchar* path)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	gchar* wp = NULL;
	const gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_strdup (path);
	uri = _tmp0_;
	if (bird_font_bird_font_win32) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gboolean _tmp6_;
		const gchar* _tmp9_;
		_tmp1_ = uri;
		_tmp2_ = bird_font_wine_to_unix_path (_tmp1_);
		_g_free0 (wp);
		wp = _tmp2_;
		_tmp3_ = wp;
		_tmp4_ = bird_font_search_paths_find_file (_tmp3_, "");
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_query_exists (_tmp5_, NULL);
		_g_object_unref0 (_tmp5_);
		if (_tmp6_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = wp;
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (uri);
			uri = _tmp8_;
		}
		_tmp9_ = uri;
		if (string_index_of (_tmp9_, "\\", 0) > -1) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = uri;
			_tmp11_ = string_replace (_tmp10_, "\\", "/");
			_g_free0 (uri);
			uri = _tmp11_;
		}
	}
	_tmp12_ = uri;
	if (string_index_of (_tmp12_, "/", 0) == 0) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = uri;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = g_strconcat ("file://", _tmp14_, NULL);
		_g_free0 (uri);
		uri = _tmp15_;
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = uri;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat ("file:///", _tmp17_, NULL);
		_g_free0 (uri);
		uri = _tmp18_;
	}
	result = uri;
	_g_free0 (wp);
	return result;
}

void
bird_font_tab_content_draw_text_input (BirdFontWidgetAllocation* allocation,
                                       cairo_t* cr)
{
	BirdFontText* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	BirdFontLineTextArea* _tmp3_;
	BirdFontWidgetAllocation* _tmp4_;
	BirdFontLineTextArea* _tmp5_;
	BirdFontLineTextArea* _tmp6_;
	BirdFontText* _tmp7_;
	BirdFontLineTextArea* _tmp8_;
	BirdFontLineTextArea* _tmp9_;
	BirdFontButton* _tmp10_;
	BirdFontText* _tmp11_;
	BirdFontButton* _tmp12_;
	BirdFontWidgetAllocation* _tmp13_;
	BirdFontButton* _tmp14_;
	BirdFontLineTextArea* _tmp15_;
	BirdFontLineTextArea* _tmp16_;
	BirdFontButton* _tmp17_;
	BirdFontText* _tmp18_;
	BirdFontLineTextArea* _tmp19_;
	BirdFontButton* _tmp20_;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	bird_font_theme_color (cr, "Default Background");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) BIRD_FONT_TAB_CONTENT_TEXT_INPUT_HEIGHT);
	cairo_fill (cr);
	cairo_restore (cr);
	_tmp0_ = bird_font_tab_content_text_input_label;
	bird_font_theme_text_color (_tmp0_, "Button Foreground");
	_tmp1_ = bird_font_tab_content_text_input_label;
	((BirdFontWidget*) _tmp1_)->widget_x = (gdouble) 10;
	_tmp2_ = bird_font_tab_content_text_input_label;
	((BirdFontWidget*) _tmp2_)->widget_y = (gdouble) 17;
	_tmp3_ = bird_font_tab_content_text_input;
	_tmp4_ = _g_object_ref0 (allocation);
	_g_object_unref0 (((BirdFontWidget*) _tmp3_)->allocation);
	((BirdFontWidget*) _tmp3_)->allocation = _tmp4_;
	_tmp5_ = bird_font_tab_content_text_input;
	bird_font_widget_layout ((BirdFontWidget*) _tmp5_);
	_tmp6_ = bird_font_tab_content_text_input;
	_tmp7_ = bird_font_tab_content_text_input_label;
	((BirdFontWidget*) _tmp6_)->widget_x = bird_font_text_get_extent (_tmp7_) + 20;
	_tmp8_ = bird_font_tab_content_text_input;
	((BirdFontWidget*) _tmp8_)->widget_y = (gdouble) 10;
	_tmp9_ = bird_font_tab_content_text_input;
	_tmp10_ = bird_font_tab_content_text_input_button;
	_tmp11_ = bird_font_tab_content_text_input_label;
	((BirdFontTextArea*) _tmp9_)->width = ((allocation->width - bird_font_widget_get_width ((BirdFontWidget*) _tmp10_)) - bird_font_text_get_extent (_tmp11_)) - 40;
	_tmp12_ = bird_font_tab_content_text_input_button;
	_tmp13_ = _g_object_ref0 (allocation);
	_g_object_unref0 (((BirdFontWidget*) _tmp12_)->allocation);
	((BirdFontWidget*) _tmp12_)->allocation = _tmp13_;
	_tmp14_ = bird_font_tab_content_text_input_button;
	_tmp15_ = bird_font_tab_content_text_input;
	_tmp16_ = bird_font_tab_content_text_input;
	((BirdFontWidget*) _tmp14_)->widget_x = (((BirdFontWidget*) _tmp15_)->widget_x + ((BirdFontTextArea*) _tmp16_)->width) + 10;
	_tmp17_ = bird_font_tab_content_text_input_button;
	((BirdFontWidget*) _tmp17_)->widget_y = (gdouble) 10;
	_tmp18_ = bird_font_tab_content_text_input_label;
	bird_font_widget_draw ((BirdFontWidget*) _tmp18_, cr);
	_tmp19_ = bird_font_tab_content_text_input;
	bird_font_widget_draw ((BirdFontWidget*) _tmp19_, cr);
	_tmp20_ = bird_font_tab_content_text_input_button;
	bird_font_widget_draw ((BirdFontWidget*) _tmp20_, cr);
}

static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		_g_object_unref0 (_data66_->tl);
		g_slice_free (Block66Data, _data66_);
	}
}

static void
__lambda15_ (Block66Data* _data66_,
             const gchar* text)
{
	g_return_if_fail (text != NULL);
	g_signal_emit_by_name (_data66_->tl, "signal-text-input", text);
}

static void
___lambda15__bird_font_text_area_text_changed (BirdFontTextArea* _sender,
                                               const gchar* text,
                                               gpointer self)
{
	__lambda15_ (self, text);
}

static void
__lambda16_ (Block66Data* _data66_,
             const gchar* text)
{
	g_return_if_fail (text != NULL);
	g_signal_emit_by_name (_data66_->tl, "signal-submit", text);
	bird_font_tab_content_text_input_visible = FALSE;
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda16__bird_font_text_area_enter (BirdFontTextArea* _sender,
                                        const gchar* text,
                                        gpointer self)
{
	__lambda16_ (self, text);
}

static void
__lambda17_ (Block66Data* _data66_)
{
	BirdFontLineTextArea* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = bird_font_tab_content_text_input;
	_tmp1_ = bird_font_text_area_get_text ((BirdFontTextArea*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name (_data66_->tl, "signal-submit", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
___lambda17__bird_font_button_action (BirdFontButton* _sender,
                                      gpointer self)
{
	__lambda17_ (self);
}

void
bird_font_tab_content_show_text_input (BirdFontTextListener* tl)
{
	Block66Data* _data66_;
	BirdFontTextListener* _tmp0_;
	BirdFontTextListener* _tmp1_;
	const gchar* _tmp2_;
	BirdFontText* _tmp3_;
	BirdFontLineTextArea* _tmp4_;
	const gchar* _tmp5_;
	BirdFontButton* _tmp6_;
	BirdFontLineTextArea* _tmp7_;
	BirdFontLineTextArea* _tmp8_;
	const gchar* _tmp9_;
	BirdFontLineTextArea* _tmp10_;
	BirdFontLineTextArea* _tmp11_;
	BirdFontButton* _tmp12_;
	g_return_if_fail (tl != NULL);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (tl);
	_g_object_unref0 (_data66_->tl);
	_data66_->tl = _tmp0_;
	_tmp1_ = _g_object_ref0 (_data66_->tl);
	_g_object_unref0 (bird_font_tab_content_text_callback);
	bird_font_tab_content_text_callback = _tmp1_;
	_tmp2_ = _data66_->tl->label;
	_tmp3_ = bird_font_text_new (_tmp2_, (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (bird_font_tab_content_text_input_label);
	bird_font_tab_content_text_input_label = _tmp3_;
	_tmp4_ = bird_font_line_text_area_new ((gdouble) 20);
	_g_object_unref0 (bird_font_tab_content_text_input);
	bird_font_tab_content_text_input = _tmp4_;
	_tmp5_ = _data66_->tl->button_label;
	_tmp6_ = bird_font_button_new (_tmp5_, (gdouble) 0);
	_g_object_unref0 (bird_font_tab_content_text_input_button);
	bird_font_tab_content_text_input_button = _tmp6_;
	_tmp7_ = bird_font_tab_content_text_input;
	((BirdFontTextArea*) _tmp7_)->carret_is_visible = TRUE;
	_tmp8_ = bird_font_tab_content_text_input;
	_tmp9_ = _data66_->tl->default_text;
	bird_font_text_area_set_text ((BirdFontTextArea*) _tmp8_, _tmp9_);
	_tmp10_ = bird_font_tab_content_text_input;
	g_signal_connect_data ((BirdFontTextArea*) _tmp10_, "text-changed", (GCallback) ___lambda15__bird_font_text_area_text_changed, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
	_tmp11_ = bird_font_tab_content_text_input;
	g_signal_connect_data ((BirdFontTextArea*) _tmp11_, "enter", (GCallback) ___lambda16__bird_font_text_area_enter, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
	_tmp12_ = bird_font_tab_content_text_input_button;
	g_signal_connect_data (_tmp12_, "action", (GCallback) ___lambda17__bird_font_button_action, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
	bird_font_tab_content_text_input_visible = TRUE;
	bird_font_glyph_canvas_redraw ();
	block66_data_unref (_data66_);
	_data66_ = NULL;
}

void
bird_font_tab_content_hide_text_input (void)
{
	BirdFontTextListener* _tmp0_;
	bird_font_tab_content_text_input_visible = FALSE;
	_tmp0_ = bird_font_text_listener_new ("", "", "");
	_g_object_unref0 (bird_font_tab_content_text_callback);
	bird_font_tab_content_text_callback = _tmp0_;
}

void
bird_font_tab_content_reset_modifier (void)
{
	BirdFontFontDisplay* _tmp0_;
	BirdFontFontDisplay* _tmp1_;
	gboolean _tmp2_;
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_CTRL_RIGHT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_CTRL_LEFT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_SHIFT_LEFT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_SHIFT_RIGHT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_ALT_LEFT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_ALT_RIGHT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_LOGO_LEFT);
	bird_font_tab_content_key_release ((guint) BIRD_FONT_KEY_LOGO_RIGHT);
	_tmp0_ = bird_font_main_window_get_current_display ();
	_tmp1_ = _tmp0_;
	_tmp2_ = BIRD_FONT_IS_GLYPH_TAB (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		bird_font_tab_content_key_release ((guint) ' ');
	}
}

BirdFontTabContent*
bird_font_tab_content_construct (GType object_type)
{
	BirdFontTabContent * self = NULL;
	self = (BirdFontTabContent*) g_object_new (object_type, NULL);
	return self;
}

BirdFontTabContent*
bird_font_tab_content_new (void)
{
	return bird_font_tab_content_construct (BIRD_FONT_TYPE_TAB_CONTENT);
}

static void
bird_font_tab_content_class_init (BirdFontTabContentClass * klass,
                                  gpointer klass_data)
{
	bird_font_tab_content_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_tab_content_finalize;
}

static void
bird_font_tab_content_instance_init (BirdFontTabContent * self,
                                     gpointer klass)
{
}

static void
bird_font_tab_content_finalize (GObject * obj)
{
	BirdFontTabContent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TAB_CONTENT, BirdFontTabContent);
	G_OBJECT_CLASS (bird_font_tab_content_parent_class)->finalize (obj);
}

/** Interface for events from native window to the current tab. */
static GType
bird_font_tab_content_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTabContentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_tab_content_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTabContent), 0, (GInstanceInitFunc) bird_font_tab_content_instance_init, NULL };
	GType bird_font_tab_content_type_id;
	bird_font_tab_content_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTabContent", &g_define_type_info, 0);
	return bird_font_tab_content_type_id;
}

GType
bird_font_tab_content_get_type (void)
{
	static volatile gsize bird_font_tab_content_type_id__once = 0;
	if (g_once_init_enter (&bird_font_tab_content_type_id__once)) {
		GType bird_font_tab_content_type_id;
		bird_font_tab_content_type_id = bird_font_tab_content_get_type_once ();
		g_once_init_leave (&bird_font_tab_content_type_id__once, bird_font_tab_content_type_id);
	}
	return bird_font_tab_content_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

