/* TabBar.c generated by valac 0.56.16, the Vala compiler
 * generated from TabBar.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#define BIRD_FONT_TAB_BAR_NO_TAB -1
#define BIRD_FONT_TAB_BAR_NEXT_TAB -2
#define BIRD_FONT_TAB_BAR_PREVIOUS_TAB -3
#define BIRD_FONT_TAB_BAR_PROGRESS_WHEEL -3
#define BIRD_FONT_TAB_BAR_SHOW_MENU -4
#define BIRD_FONT_TAB_BAR_STOP_BUTTON -5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_TAB_BAR_0_PROPERTY,
	BIRD_FONT_TAB_BAR_NUM_PROPERTIES
};
static GParamSpec* bird_font_tab_bar_properties[BIRD_FONT_TAB_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
enum  {
	BIRD_FONT_TAB_BAR_SIGNAL_TAB_SELECTED_SIGNAL,
	BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL,
	BIRD_FONT_TAB_BAR_NUM_SIGNALS
};
static guint bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_NUM_SIGNALS] = {0};

struct _BirdFontTabBarPrivate {
	gint first_tab;
	gint selected;
	gint over;
	gint over_close_tab;
	BirdFontTab* previous_tab;
	BirdFontTab* current_tab;
	gdouble scale;
	gboolean processing;
	gboolean stop_button;
	gdouble wheel_rotation;
	gdouble background_r;
	gdouble background_g;
	gdouble background_b;
	BirdFontText* menu_icon;
	BirdFontText* progress_icon;
	BirdFontText* stop_icon;
	BirdFontText* left_arrow;
	BirdFontText* right_arrow;
};

static gint BirdFontTabBar_private_offset;
static gpointer bird_font_tab_bar_parent_class = NULL;

static void bird_font_tab_bar_motion_event (BirdFontTabBar* self,
                                     gdouble x,
                                     gdouble y,
                                     gint* over,
                                     gint* over_close_tab);
static gboolean bird_font_tab_bar_has_scroll (BirdFontTabBar* self);
static gboolean bird_font_tab_bar_has_progress_wheel (BirdFontTabBar* self);
static gboolean bird_font_tab_bar_cancelable_task (BirdFontTabBar* self);
static void bird_font_tab_bar_select_previous_tab (BirdFontTabBar* self);
static void bird_font_tab_bar_scroll_to_tab (BirdFontTabBar* self,
                                      gint index,
                                      gboolean send_signal_selected);
static void bird_font_tab_bar_signal_selected (BirdFontTabBar* self,
                                        gint index);
static gboolean bird_font_tab_bar_has_stop_button (BirdFontTabBar* self);
static void bird_font_tab_bar_draw_tabs (BirdFontTabBar* self,
                                  cairo_t* cr);
static gboolean ___lambda77_ (BirdFontTabBar* self);
static gboolean ____lambda77__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void bird_font_tab_bar_finalize (GObject * obj);
static GType bird_font_tab_bar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_tab_bar_get_instance_private (BirdFontTabBar* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontTabBar_private_offset);
}

BirdFontTabBar*
bird_font_tab_bar_construct (GType object_type)
{
	BirdFontTabBar * self = NULL;
	GeeArrayList* _tmp0_;
	BirdFontText* _tmp1_;
	BirdFontText* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BirdFontText* _tmp5_;
	BirdFontText* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontText* _tmp9_;
	BirdFontText* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BirdFontText* _tmp13_;
	BirdFontText* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	BirdFontText* _tmp17_;
	BirdFontText* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	self = (BirdFontTabBar*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_TAB, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->tabs);
	self->tabs = _tmp0_;
	_tmp1_ = bird_font_text_new ("menu_icon", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->menu_icon);
	self->priv->menu_icon = _tmp1_;
	_tmp2_ = self->priv->menu_icon;
	_tmp3_ = bird_font_theme_get_icon_file ();
	_tmp4_ = _tmp3_;
	bird_font_text_load_font (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = bird_font_text_new ("progress", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->progress_icon);
	self->priv->progress_icon = _tmp5_;
	_tmp6_ = self->priv->progress_icon;
	_tmp7_ = bird_font_theme_get_icon_file ();
	_tmp8_ = _tmp7_;
	bird_font_text_load_font (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = bird_font_text_new ("stop", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->stop_icon);
	self->priv->stop_icon = _tmp9_;
	_tmp10_ = self->priv->stop_icon;
	_tmp11_ = bird_font_theme_get_icon_file ();
	_tmp12_ = _tmp11_;
	bird_font_text_load_font (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = bird_font_text_new ("left_arrow", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->left_arrow);
	self->priv->left_arrow = _tmp13_;
	_tmp14_ = self->priv->left_arrow;
	_tmp15_ = bird_font_theme_get_icon_file ();
	_tmp16_ = _tmp15_;
	bird_font_text_load_font (_tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = bird_font_text_new ("right_arrow", (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->right_arrow);
	self->priv->right_arrow = _tmp17_;
	_tmp18_ = self->priv->right_arrow;
	_tmp19_ = bird_font_theme_get_icon_file ();
	_tmp20_ = _tmp19_;
	bird_font_text_load_font (_tmp18_, _tmp20_);
	_g_free0 (_tmp20_);
	bird_font_tab_bar_start_wheel ();
	return self;
}

BirdFontTabBar*
bird_font_tab_bar_new (void)
{
	return bird_font_tab_bar_construct (BIRD_FONT_TYPE_TAB_BAR);
}

void
bird_font_tab_bar_redraw (BirdFontTabBar* self,
                          gint x,
                          gint y,
                          gint w,
                          gint h)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL], 0, x, y, w, h);
}

void
bird_font_tab_bar_set_background_color (BirdFontTabBar* self,
                                        gdouble r,
                                        gdouble g,
                                        gdouble b)
{
	g_return_if_fail (self != NULL);
	self->priv->background_r = r;
	self->priv->background_g = g;
	self->priv->background_b = r;
}

void
bird_font_tab_bar_motion (BirdFontTabBar* self,
                          gdouble x,
                          gdouble y)
{
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
	bird_font_tab_bar_motion_event (self, x, y, &_tmp0_, &_tmp1_);
	self->priv->over = _tmp0_;
	self->priv->over_close_tab = _tmp1_;
}

static void
bird_font_tab_bar_motion_event (BirdFontTabBar* self,
                                gdouble x,
                                gdouble y,
                                gint* over,
                                gint* over_close_tab)
{
	gint _vala_over = 0;
	gint _vala_over_close_tab = 0;
	gint i = 0;
	gdouble offset = 0.0;
	gboolean close_y = FALSE;
	gboolean close_x = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	i = 0;
	offset = (gdouble) 0;
	if (x < ((gdouble) 24)) {
		_tmp0_ = bird_font_tab_bar_has_scroll (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
		_vala_over = BIRD_FONT_TAB_BAR_PREVIOUS_TAB;
		if (over) {
			*over = _vala_over;
		}
		if (over_close_tab) {
			*over_close_tab = _vala_over_close_tab;
		}
		return;
	}
	if (!bird_font_tab_bar_has_progress_wheel (self)) {
		if (x > ((gdouble) (self->width - 25))) {
			_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
			_vala_over = BIRD_FONT_TAB_BAR_SHOW_MENU;
			if (over) {
				*over = _vala_over;
			}
			if (over_close_tab) {
				*over_close_tab = _vala_over_close_tab;
			}
			return;
		}
	} else {
		gboolean _tmp1_ = FALSE;
		if (!bird_font_tab_bar_has_scroll (self)) {
			_tmp1_ = bird_font_tab_bar_cancelable_task (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gboolean _tmp2_ = FALSE;
			if (x > ((gdouble) (self->width - 19))) {
				gdouble _tmp3_;
				_tmp3_ = y;
				_tmp2_ = (((gdouble) 10) <= _tmp3_) && (_tmp3_ < ((gdouble) (self->height - 10)));
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
				_vala_over = BIRD_FONT_TAB_BAR_STOP_BUTTON;
				self->priv->stop_button = TRUE;
				g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL], 0, 0, 0, self->width, self->height);
			} else {
				self->priv->stop_button = FALSE;
			}
		} else {
			gboolean _tmp4_ = FALSE;
			if (bird_font_tab_bar_has_scroll (self)) {
				_tmp4_ = bird_font_tab_bar_cancelable_task (self);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				gboolean _tmp5_ = FALSE;
				if (x > ((gdouble) (self->width - 19))) {
					gdouble _tmp6_;
					_tmp6_ = y;
					_tmp5_ = (((gdouble) 10) <= _tmp6_) && (_tmp6_ < ((gdouble) (self->height - 10)));
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
					_vala_over = BIRD_FONT_TAB_BAR_STOP_BUTTON;
					self->priv->stop_button = TRUE;
					g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL], 0, 0, 0, self->width, self->height);
					if (over) {
						*over = _vala_over;
					}
					if (over_close_tab) {
						*over_close_tab = _vala_over_close_tab;
					}
					return;
				} else {
					if (x > ((gdouble) (self->width - (2 * 19)))) {
						_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
						_vala_over = BIRD_FONT_TAB_BAR_NEXT_TAB;
					}
				}
				self->priv->stop_button = FALSE;
			} else {
				gboolean _tmp7_ = FALSE;
				if (!bird_font_tab_bar_has_scroll (self)) {
					_tmp7_ = bird_font_tab_bar_has_progress_wheel (self);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					if (x > ((gdouble) (self->width - 19))) {
						_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
						_vala_over = BIRD_FONT_TAB_BAR_PROGRESS_WHEEL;
					}
				} else {
					gboolean _tmp8_ = FALSE;
					if (bird_font_tab_bar_has_scroll (self)) {
						_tmp8_ = !bird_font_tab_bar_has_progress_wheel (self);
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						if (x > ((gdouble) (self->width - 19))) {
							_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
							_vala_over = BIRD_FONT_TAB_BAR_NEXT_TAB;
						}
					}
				}
			}
		}
	}
	if (bird_font_tab_bar_has_scroll (self)) {
		offset += (gdouble) 25;
	}
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp9_;
		gint _t_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _t_index = 0;
		_tmp9_ = self->tabs;
		_t_list = _tmp9_;
		_tmp10_ = _t_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_t_size = _tmp12_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontTab* t = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontTab* _tmp18_;
			gdouble _tmp19_;
			BirdFontTab* _tmp23_;
			gint _tmp24_;
			_t_index = _t_index + 1;
			_tmp13_ = _t_index;
			_tmp14_ = _t_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _t_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _t_index);
			t = (BirdFontTab*) _tmp16_;
			if (i < self->priv->first_tab) {
				gint _tmp17_;
				_tmp17_ = i;
				i = _tmp17_ + 1;
				_g_object_unref0 (t);
				continue;
			}
			_tmp18_ = t;
			_tmp19_ = x;
			if ((offset < _tmp19_) && (_tmp19_ < (offset + bird_font_tab_get_width (_tmp18_)))) {
				gdouble _tmp20_;
				BirdFontTab* _tmp21_;
				gboolean _tmp22_ = FALSE;
				_vala_over = i;
				_tmp20_ = y;
				close_y = (((self->height / 2.0) - 4) < _tmp20_) && (_tmp20_ < ((self->height / 2.0) + 4));
				_tmp21_ = t;
				close_x = x > ((offset + bird_font_tab_get_width (_tmp21_)) - 16);
				if (close_y) {
					_tmp22_ = close_x;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					_vala_over_close_tab = i;
				} else {
					_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
				}
				_g_object_unref0 (t);
				if (over) {
					*over = _vala_over;
				}
				if (over_close_tab) {
					*over_close_tab = _vala_over_close_tab;
				}
				return;
			}
			_tmp23_ = t;
			offset += bird_font_tab_get_width (_tmp23_);
			_tmp24_ = i;
			i = _tmp24_ + 1;
			_g_object_unref0 (t);
		}
	}
	_vala_over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
	_vala_over = BIRD_FONT_TAB_BAR_NO_TAB;
	if (over) {
		*over = _vala_over;
	}
	if (over_close_tab) {
		*over_close_tab = _vala_over_close_tab;
	}
}

static gboolean
bird_font_tab_bar_cancelable_task (BirdFontTabBar* self)
{
	BirdFontTask* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_main_window_blocking_background_task;
	result = bird_font_task_is_cancellable (_tmp0_);
	return result;
}

/** Select tab for a glyph by charcode or name.
 * @return true if the tab was found
 */
gboolean
bird_font_tab_bar_select_char (BirdFontTabBar* self,
                               const gchar* s)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	i = 0;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp0_;
		gint _t_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _t_index = 0;
		_tmp0_ = self->tabs;
		_t_list = _tmp0_;
		_tmp1_ = _t_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_t_size = _tmp3_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTab* t = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTab* _tmp8_;
			BirdFontFontDisplay* _tmp9_;
			BirdFontFontDisplay* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			gint _tmp14_;
			_t_index = _t_index + 1;
			_tmp4_ = _t_index;
			_tmp5_ = _t_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _t_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _t_index);
			t = (BirdFontTab*) _tmp7_;
			_tmp8_ = t;
			_tmp9_ = bird_font_tab_get_display (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = bird_font_font_display_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, s) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				bird_font_tab_bar_select_tab (self, i, TRUE);
				result = TRUE;
				_g_object_unref0 (t);
				return result;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_g_object_unref0 (t);
		}
	}
	result = FALSE;
	return result;
}

gboolean
bird_font_tab_bar_select_tab_name (BirdFontTabBar* self,
                                   const gchar* s)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		return result;
	}
	result = bird_font_tab_bar_select_char (self, s);
	return result;
}

void
bird_font_tab_bar_select_overview (BirdFontTabBar* self)
{
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	bird_font_tab_bar_select_tab_name (self, "Overview");
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_tab_bar_select_previous_tab (BirdFontTabBar* self)
{
	BirdFontTab* t = NULL;
	gboolean open = FALSE;
	BirdFontTab* _tmp0_;
	BirdFontTab* _tmp1_;
	BirdFontTab* _tmp2_;
	BirdFontTab* _tmp3_;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		_g_object_unref0 (t);
		return;
	}
	_tmp0_ = self->priv->previous_tab;
	if (_tmp0_ == NULL) {
		_g_object_unref0 (t);
		return;
	}
	_tmp1_ = self->priv->previous_tab;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_TAB, BirdFontTab));
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	open = bird_font_tab_bar_selected_open_tab (self, _tmp3_);
	if (!open) {
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->tabs;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		bird_font_tab_bar_select_tab (self, ((gint) _tmp6_) - 1, TRUE);
	}
	_g_object_unref0 (t);
}

void
bird_font_tab_bar_close_display (BirdFontTabBar* self,
                                 BirdFontFontDisplay* f)
{
	gint i = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	i = -1;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	_tmp0_ = self->tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ >= 1) {
		{
			GeeArrayList* _t_list = NULL;
			GeeArrayList* _tmp3_;
			gint _t_size = 0;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _t_index = 0;
			_tmp3_ = self->tabs;
			_t_list = _tmp3_;
			_tmp4_ = _t_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_t_size = _tmp6_;
			_t_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				BirdFontTab* t = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				gint _tmp11_;
				BirdFontTab* _tmp12_;
				BirdFontFontDisplay* _tmp13_;
				BirdFontFontDisplay* _tmp14_;
				gboolean _tmp15_;
				_t_index = _t_index + 1;
				_tmp7_ = _t_index;
				_tmp8_ = _t_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _t_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _t_index);
				t = (BirdFontTab*) _tmp10_;
				i = i + 1;
				_tmp11_ = i;
				_tmp12_ = t;
				_tmp13_ = bird_font_tab_get_display (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_ == f;
				_g_object_unref0 (_tmp14_);
				if (_tmp15_) {
					bird_font_tab_bar_close_tab (self, i, FALSE, TRUE);
					_g_object_unref0 (t);
					return;
				}
				_g_object_unref0 (t);
			}
		}
	}
	g_return_if_fail (i != -1);
}

void
bird_font_tab_bar_close_all_tabs (BirdFontTabBar* self)
{
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < bird_font_tab_bar_get_length (self))) {
					break;
				}
				if (bird_font_tab_bar_close_tab (self, i, FALSE, TRUE)) {
					bird_font_tab_bar_close_all_tabs (self);
				}
			}
		}
	}
}

gboolean
bird_font_tab_bar_close_tab (BirdFontTabBar* self,
                             gint index,
                             gboolean background_tab,
                             gboolean select_new_tab)
{
	BirdFontTab* t = NULL;
	BirdFontEmptyTab* empty_tab_canvas = NULL;
	BirdFontTab* empty_tab = NULL;
	BirdFontGlyphCollection* gc = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GeeArrayList* _tmp16_;
	gpointer _tmp17_;
	BirdFontTab* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		_g_object_unref0 (gc);
		_g_object_unref0 (empty_tab);
		_g_object_unref0 (empty_tab_canvas);
		_g_object_unref0 (t);
		return result;
	}
	_tmp0_ = self->tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	if (!((0 <= _tmp3_) && (_tmp3_ < _tmp2_))) {
		result = FALSE;
		_g_object_unref0 (gc);
		_g_object_unref0 (empty_tab);
		_g_object_unref0 (empty_tab_canvas);
		_g_object_unref0 (t);
		return result;
	}
	_tmp4_ = self->tabs;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 1) {
		BirdFontEmptyTab* _tmp7_;
		BirdFontGlyphCollection* _tmp8_;
		BirdFontEmptyTab* _tmp9_;
		BirdFontGlyphCanvas* _tmp10_;
		BirdFontGlyphCanvas* _tmp11_;
		BirdFontGlyphCollection* _tmp12_;
		BirdFontEmptyTab* _tmp13_;
		BirdFontTab* _tmp14_;
		BirdFontTab* _tmp15_;
		_tmp7_ = bird_font_empty_tab_new ("", "");
		_g_object_unref0 (empty_tab_canvas);
		empty_tab_canvas = _tmp7_;
		_tmp8_ = bird_font_glyph_collection_new_with_glyph ((gunichar) '\0', "");
		_g_object_unref0 (gc);
		gc = _tmp8_;
		_tmp9_ = empty_tab_canvas;
		bird_font_glyph_canvas_set_display ((BirdFontFontDisplay*) _tmp9_);
		_tmp10_ = bird_font_main_window_get_glyph_canvas ();
		_tmp11_ = _tmp10_;
		_tmp12_ = gc;
		bird_font_glyph_canvas_set_current_glyph_collection (_tmp11_, _tmp12_, TRUE);
		_g_object_unref0 (_tmp11_);
		_tmp13_ = empty_tab_canvas;
		_tmp14_ = bird_font_tab_new ((BirdFontFontDisplay*) _tmp13_, (gdouble) 0, FALSE);
		_g_object_unref0 (empty_tab);
		empty_tab = _tmp14_;
		_tmp15_ = empty_tab;
		g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_SIGNAL_TAB_SELECTED_SIGNAL], 0, _tmp15_);
	}
	_tmp16_ = self->tabs;
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, index);
	_g_object_unref0 (t);
	t = (BirdFontTab*) _tmp17_;
	if (self->priv->first_tab > 0) {
		gint _tmp18_;
		_tmp18_ = self->priv->first_tab;
		self->priv->first_tab = _tmp18_ - 1;
	}
	_tmp19_ = t;
	if (bird_font_tab_has_close_button (_tmp19_)) {
		BirdFontTab* _tmp20_;
		BirdFontFontDisplay* _tmp21_;
		BirdFontFontDisplay* _tmp22_;
		GeeArrayList* _tmp23_;
		gpointer _tmp24_;
		BirdFontTab* _tmp25_;
		gboolean _tmp26_ = FALSE;
		_tmp20_ = t;
		_tmp21_ = bird_font_tab_get_display (_tmp20_);
		_tmp22_ = _tmp21_;
		bird_font_font_display_close (_tmp22_);
		_g_object_unref0 (_tmp22_);
		_tmp23_ = self->tabs;
		_tmp24_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp23_, index);
		_tmp25_ = (BirdFontTab*) _tmp24_;
		_g_object_unref0 (_tmp25_);
		if (!background_tab) {
			_tmp26_ = select_new_tab;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			bird_font_tab_bar_select_previous_tab (self);
		}
		result = TRUE;
		_g_object_unref0 (gc);
		_g_object_unref0 (empty_tab);
		_g_object_unref0 (empty_tab_canvas);
		_g_object_unref0 (t);
		return result;
	}
	if (select_new_tab) {
		bird_font_tab_bar_select_tab (self, index, TRUE);
	}
	result = FALSE;
	_g_object_unref0 (gc);
	_g_object_unref0 (empty_tab);
	_g_object_unref0 (empty_tab_canvas);
	_g_object_unref0 (t);
	return result;
}

gboolean
bird_font_tab_bar_close_by_name (BirdFontTabBar* self,
                                 const gchar* name,
                                 gboolean background_tab)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	i = 0;
	{
		GeeArrayList* _tab_list = NULL;
		GeeArrayList* _tmp0_;
		gint _tab_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tab_index = 0;
		_tmp0_ = self->tabs;
		_tab_list = _tmp0_;
		_tmp1_ = _tab_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tab_size = _tmp3_;
		_tab_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTab* tab = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTab* _tmp8_;
			BirdFontFontDisplay* _tmp9_;
			BirdFontFontDisplay* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			gint _tmp14_;
			_tab_index = _tab_index + 1;
			_tmp4_ = _tab_index;
			_tmp5_ = _tab_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _tab_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tab_index);
			tab = (BirdFontTab*) _tmp7_;
			_tmp8_ = tab;
			_tmp9_ = bird_font_tab_get_display (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = bird_font_font_display_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, name) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				gboolean closed = FALSE;
				closed = bird_font_tab_bar_close_tab (self, i, background_tab, TRUE);
				g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL], 0, 0, 0, self->width, self->height);
				result = closed;
				_g_object_unref0 (tab);
				return result;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_g_object_unref0 (tab);
		}
	}
	result = FALSE;
	return result;
}

void
bird_font_tab_bar_close_background_tab_by_name (BirdFontTabBar* self,
                                                const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	bird_font_tab_bar_close_by_name (self, name, TRUE);
}

/** Select a tab and return true if it is open. */
gboolean
bird_font_tab_bar_selected_open_tab (BirdFontTabBar* self,
                                     BirdFontTab* t)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	i = 0;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp0_;
		gint _n_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _n_index = 0;
		_tmp0_ = self->tabs;
		_n_list = _tmp0_;
		_tmp1_ = _n_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_n_size = _tmp3_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTab* n = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTab* _tmp8_;
			gint _tmp9_;
			_n_index = _n_index + 1;
			_tmp4_ = _n_index;
			_tmp5_ = _n_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _n_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _n_index);
			n = (BirdFontTab*) _tmp7_;
			_tmp8_ = n;
			if (_tmp8_ == t) {
				bird_font_tab_bar_select_tab (self, i, TRUE);
				result = TRUE;
				_g_object_unref0 (n);
				return result;
			}
			_tmp9_ = i;
			i = _tmp9_ + 1;
			_g_object_unref0 (n);
		}
	}
	result = FALSE;
	return result;
}

BirdFontTab*
bird_font_tab_bar_get_nth (BirdFontTabBar* self,
                           gint i)
{
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gpointer _tmp2_;
	BirdFontTab* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = i;
	if (!((0 <= _tmp0_) && (_tmp0_ < bird_font_tab_bar_get_length (self)))) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->tabs;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, i);
	result = (BirdFontTab*) _tmp2_;
	return result;
}

BirdFontTab*
bird_font_tab_bar_get_tab (BirdFontTabBar* self,
                           const gchar* name)
{
	BirdFontTab* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp0_;
		gint _n_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _n_index = 0;
		_tmp0_ = self->tabs;
		_n_list = _tmp0_;
		_tmp1_ = _n_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_n_size = _tmp3_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTab* n = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTab* _tmp8_;
			BirdFontFontDisplay* _tmp9_;
			BirdFontFontDisplay* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_n_index = _n_index + 1;
			_tmp4_ = _n_index;
			_tmp5_ = _n_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _n_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _n_index);
			n = (BirdFontTab*) _tmp7_;
			_tmp8_ = n;
			_tmp9_ = bird_font_tab_get_display (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = bird_font_font_display_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, name) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				result = n;
				return result;
			}
			_g_object_unref0 (n);
		}
	}
	result = NULL;
	return result;
}

gboolean
bird_font_tab_bar_selected_open_tab_by_name (BirdFontTabBar* self,
                                             const gchar* t)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	i = 0;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp0_;
		gint _n_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _n_index = 0;
		_tmp0_ = self->tabs;
		_n_list = _tmp0_;
		_tmp1_ = _n_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_n_size = _tmp3_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontTab* n = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontTab* _tmp8_;
			BirdFontFontDisplay* _tmp9_;
			BirdFontFontDisplay* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			gint _tmp14_;
			_n_index = _n_index + 1;
			_tmp4_ = _n_index;
			_tmp5_ = _n_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _n_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _n_index);
			n = (BirdFontTab*) _tmp7_;
			_tmp8_ = n;
			_tmp9_ = bird_font_tab_get_display (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = bird_font_font_display_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, t) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				bird_font_tab_bar_select_tab (self, i, TRUE);
				result = TRUE;
				_g_object_unref0 (n);
				return result;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_g_object_unref0 (n);
		}
	}
	result = FALSE;
	return result;
}

BirdFontTab*
bird_font_tab_bar_get_selected_tab (BirdFontTabBar* self)
{
	gint s = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEmptyTab* _tmp6_;
	BirdFontEmptyTab* _tmp7_;
	BirdFontTab* _tmp8_;
	BirdFontTab* _tmp9_;
	BirdFontTab* result;
	g_return_val_if_fail (self != NULL, NULL);
	s = bird_font_tab_bar_get_selected (self);
	_tmp0_ = self->tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = s;
	if ((0 <= _tmp3_) && (_tmp3_ < _tmp2_)) {
		GeeArrayList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->tabs;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, bird_font_tab_bar_get_selected (self));
		result = (BirdFontTab*) _tmp5_;
		return result;
	}
	g_warning ("TabBar.vala:413: No tab selected.");
	_tmp6_ = bird_font_empty_tab_new ("Error", "Error");
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_tab_new ((BirdFontFontDisplay*) _tmp7_, (gdouble) 30, FALSE);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	result = _tmp9_;
	return result;
}

guint
bird_font_tab_bar_get_length (BirdFontTabBar* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->tabs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}

gint
bird_font_tab_bar_get_selected (BirdFontTabBar* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->selected;
	return result;
}

void
bird_font_tab_bar_select_tab (BirdFontTabBar* self,
                              gint index,
                              gboolean signal_selected)
{
	BirdFontTab* t = NULL;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeArrayList* _tmp18_;
	gpointer _tmp19_;
	BirdFontTab* _tmp20_;
	BirdFontTab* _tmp21_;
	BirdFontTab* _tmp22_;
	BirdFontTab* _tmp23_;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		_g_object_unref0 (t);
		return;
	}
	bird_font_tab_content_hide_text_input ();
	if (index == BIRD_FONT_TAB_BAR_SHOW_MENU) {
		BirdFontAbstractMenu* _tmp0_;
		BirdFontAbstractMenu* _tmp1_;
		BirdFontAbstractMenu* _tmp2_;
		BirdFontAbstractMenu* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp0_ = bird_font_main_window_get_menu ();
		_tmp1_ = _tmp0_;
		_tmp2_ = bird_font_main_window_get_menu ();
		_tmp3_ = _tmp2_;
		_tmp4_ = bird_font_abstract_menu_get_show_menu (_tmp3_);
		_tmp5_ = _tmp4_;
		bird_font_abstract_menu_set_show_menu (_tmp1_, !_tmp5_);
		_g_object_unref0 (_tmp3_);
		_g_object_unref0 (_tmp1_);
		bird_font_glyph_canvas_redraw ();
		_g_object_unref0 (t);
		return;
	}
	if (index == BIRD_FONT_TAB_BAR_NEXT_TAB) {
		gint _tmp6_;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = self->priv->selected;
		self->priv->selected = _tmp6_ + 1;
		_tmp7_ = self->tabs;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (self->priv->selected >= _tmp9_) {
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = self->tabs;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			self->priv->selected = ((gint) _tmp12_) - 1;
		}
		bird_font_tab_bar_scroll_to_tab (self, self->priv->selected, TRUE);
		_g_object_unref0 (t);
		return;
	}
	if (index == BIRD_FONT_TAB_BAR_PREVIOUS_TAB) {
		if (self->priv->selected > 0) {
			gint _tmp13_;
			_tmp13_ = self->priv->selected;
			self->priv->selected = _tmp13_ - 1;
		}
		bird_font_tab_bar_scroll_to_tab (self, self->priv->selected, TRUE);
		_g_object_unref0 (t);
		return;
	}
	_tmp14_ = self->tabs;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = index;
	if (!((0 <= _tmp17_) && (_tmp17_ < _tmp16_))) {
		_g_object_unref0 (t);
		return;
	}
	self->priv->selected = index;
	_tmp18_ = self->tabs;
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, index);
	_g_object_unref0 (t);
	t = (BirdFontTab*) _tmp19_;
	_tmp20_ = self->priv->current_tab;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (self->priv->previous_tab);
	self->priv->previous_tab = _tmp21_;
	_tmp22_ = t;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (self->priv->current_tab);
	self->priv->current_tab = _tmp23_;
	bird_font_tab_bar_scroll_to_tab (self, self->priv->selected, signal_selected);
	_g_object_unref0 (t);
}

static gboolean
bird_font_tab_bar_has_scroll (BirdFontTabBar* self)
{
	gint i = 0;
	gdouble offset = 0.0;
	gint _tmp0_ = 0;
	gdouble end = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	i = 0;
	offset = (gdouble) 19;
	if (bird_font_tab_bar_has_progress_wheel (self)) {
		_tmp0_ = self->width - 28;
	} else {
		_tmp0_ = self->width - 19;
	}
	end = (gdouble) _tmp0_;
	if (self->priv->first_tab > 0) {
		result = TRUE;
		return result;
	}
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp1_;
		gint _t_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _t_index = 0;
		_tmp1_ = self->tabs;
		_t_list = _tmp1_;
		_tmp2_ = _t_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_t_size = _tmp4_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontTab* t = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontTab* _tmp10_;
			BirdFontTab* _tmp11_;
			gint _tmp12_;
			_t_index = _t_index + 1;
			_tmp5_ = _t_index;
			_tmp6_ = _t_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _t_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _t_index);
			t = (BirdFontTab*) _tmp8_;
			if (i < self->priv->first_tab) {
				gint _tmp9_;
				_tmp9_ = i;
				i = _tmp9_ + 1;
				_g_object_unref0 (t);
				continue;
			}
			_tmp10_ = t;
			if (((offset + bird_font_tab_get_width (_tmp10_)) + 3) > end) {
				result = TRUE;
				_g_object_unref0 (t);
				return result;
			}
			_tmp11_ = t;
			offset += bird_font_tab_get_width (_tmp11_);
			_tmp12_ = i;
			i = _tmp12_ + 1;
			_g_object_unref0 (t);
		}
	}
	result = FALSE;
	return result;
}

static void
bird_font_tab_bar_signal_selected (BirdFontTabBar* self,
                                   gint index)
{
	BirdFontTab* t = NULL;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	BirdFontFontDisplay* _tmp2_;
	BirdFontFontDisplay* _tmp3_;
	BirdFontGlyphCanvas* _tmp4_;
	BirdFontGlyphCanvas* _tmp5_;
	BirdFontGlyphCollection* _tmp6_;
	BirdFontGlyphCollection* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tabs;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, index);
	_g_object_unref0 (t);
	t = (BirdFontTab*) _tmp1_;
	_tmp2_ = bird_font_tab_get_display (t);
	_tmp3_ = _tmp2_;
	bird_font_glyph_canvas_set_display (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = bird_font_main_window_get_glyph_canvas ();
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_tab_get_glyph_collection (t);
	_tmp7_ = _tmp6_;
	bird_font_glyph_canvas_set_current_glyph_collection (_tmp5_, _tmp7_, TRUE);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_SIGNAL_TAB_SELECTED_SIGNAL], 0, t);
	_g_object_unref0 (t);
}

static void
bird_font_tab_bar_scroll_to_tab (BirdFontTabBar* self,
                                 gint index,
                                 gboolean send_signal_selected)
{
	gdouble offset = 0.0;
	gint i = 0;
	gint _tmp0_ = 0;
	gdouble end = 0.0;
	g_return_if_fail (self != NULL);
	offset = (gdouble) 19;
	i = 0;
	if (bird_font_tab_bar_has_progress_wheel (self)) {
		_tmp0_ = self->width - 68;
	} else {
		_tmp0_ = self->width - 40;
	}
	end = (gdouble) _tmp0_;
	if (index < self->priv->first_tab) {
		self->priv->first_tab = index;
		if (send_signal_selected) {
			bird_font_tab_bar_signal_selected (self, index);
		}
		return;
	}
	{
		GeeArrayList* _t_list = NULL;
		GeeArrayList* _tmp1_;
		gint _t_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _t_index = 0;
		_tmp1_ = self->tabs;
		_t_list = _tmp1_;
		_tmp2_ = _t_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_t_size = _tmp4_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontTab* t = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontTab* _tmp10_;
			BirdFontTab* _tmp12_;
			gint _tmp13_;
			_t_index = _t_index + 1;
			_tmp5_ = _t_index;
			_tmp6_ = _t_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _t_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _t_index);
			t = (BirdFontTab*) _tmp8_;
			if (i < self->priv->first_tab) {
				gint _tmp9_;
				_tmp9_ = i;
				i = _tmp9_ + 1;
				_g_object_unref0 (t);
				continue;
			}
			_tmp10_ = t;
			if (((offset + bird_font_tab_get_width (_tmp10_)) + 3) > end) {
				gint _tmp11_;
				_tmp11_ = self->priv->first_tab;
				self->priv->first_tab = _tmp11_ + 1;
				bird_font_tab_bar_scroll_to_tab (self, index, TRUE);
				_g_object_unref0 (t);
				return;
			}
			if (i == index) {
				if (send_signal_selected) {
					bird_font_tab_bar_signal_selected (self, index);
				}
				_g_object_unref0 (t);
				return;
			}
			_tmp12_ = t;
			offset += bird_font_tab_get_width (_tmp12_);
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_g_object_unref0 (t);
		}
	}
	g_warning ("TabBar.vala:554: ");
}

void
bird_font_tab_bar_select_tab_click (BirdFontTabBar* self,
                                    gdouble x,
                                    gdouble y,
                                    gint width,
                                    gint height)
{
	gint over = 0;
	gint close = 0;
	BirdFontAbstractMenu* _tmp0_;
	BirdFontAbstractMenu* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_menu ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_abstract_menu_get_show_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		BirdFontAbstractMenu* _tmp5_;
		BirdFontAbstractMenu* _tmp6_;
		_tmp5_ = bird_font_main_window_get_menu ();
		_tmp6_ = _tmp5_;
		bird_font_abstract_menu_set_show_menu (_tmp6_, FALSE);
		_g_object_unref0 (_tmp6_);
		bird_font_glyph_canvas_redraw ();
	}
	self->width = width;
	self->height = height;
	self->priv->scale = height / 117.0;
	bird_font_tab_bar_motion_event (self, x, y, &_tmp7_, &_tmp8_);
	over = _tmp7_;
	close = _tmp8_;
	if (self->priv->stop_button) {
		bird_font_main_window_abort_task ();
	} else {
		if (self->priv->over_close_tab >= 0) {
			bird_font_tab_bar_close_tab (self, self->priv->over_close_tab, FALSE, TRUE);
		} else {
			bird_font_tab_bar_select_tab (self, over, TRUE);
		}
	}
}

void
bird_font_tab_bar_add_tab (BirdFontTabBar* self,
                           BirdFontFontDisplay* display_item,
                           gboolean signal_selected,
                           BirdFontGlyphCollection* gc)
{
	gdouble tab_width = 0.0;
	gboolean always_open = FALSE;
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint position = 0;
	BirdFontTab* tab = NULL;
	BirdFontTab* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeArrayList* _tmp19_;
	BirdFontTab* _tmp20_;
	BirdFontTab* _tmp22_;
	BirdFontFontDisplay* _tmp23_;
	BirdFontFontDisplay* _tmp24_;
	BirdFontGlyphCanvas* _tmp25_;
	BirdFontGlyphCanvas* _tmp26_;
	BirdFontTab* _tmp27_;
	BirdFontGlyphCollection* _tmp28_;
	BirdFontGlyphCollection* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display_item != NULL);
	tab_width = (gdouble) -1;
	always_open = FALSE;
	_tmp1_ = self->tabs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = self->priv->selected + 1;
	}
	position = _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		_g_object_unref0 (tab);
		return;
	}
	if (tab_width < ((gdouble) 0)) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = bird_font_font_display_get_label (display_item);
		_tmp5_ = _tmp4_;
		tab_width = (gdouble) (9 * g_utf8_strlen (_tmp5_, (gssize) -1));
		_g_free0 (_tmp5_);
		tab_width += (gdouble) 36;
	}
	_tmp6_ = bird_font_tab_new (display_item, tab_width, always_open);
	_g_object_unref0 (tab);
	tab = _tmp6_;
	_tmp7_ = self->tabs;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (position > _tmp9_) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp10_ = g_strdup_printf ("%i", position);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->tabs;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%i", _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat ("Tab index out of bounds, position: ", _tmp11_, " tabs: ", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		g_warning ("TabBar.vala:599: %s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp11_);
		position = 0;
	}
	_tmp19_ = self->tabs;
	_tmp20_ = tab;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp19_, position, _tmp20_);
	if (gc != NULL) {
		BirdFontTab* _tmp21_;
		_tmp21_ = tab;
		bird_font_tab_set_glyph_collection (_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (gc, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	}
	_tmp22_ = tab;
	_tmp23_ = bird_font_tab_get_display (_tmp22_);
	_tmp24_ = _tmp23_;
	bird_font_glyph_canvas_set_display (_tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = bird_font_main_window_get_glyph_canvas ();
	_tmp26_ = _tmp25_;
	_tmp27_ = tab;
	_tmp28_ = bird_font_tab_get_glyph_collection (_tmp27_);
	_tmp29_ = _tmp28_;
	bird_font_glyph_canvas_set_current_glyph_collection (_tmp26_, _tmp29_, TRUE);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (_tmp26_);
	bird_font_tab_bar_select_tab (self, position, signal_selected);
	_g_object_unref0 (tab);
}

/** Returns true if the new item was added to the bar. */
gboolean
bird_font_tab_bar_add_unique_tab (BirdFontTabBar* self,
                                  BirdFontFontDisplay* display_item,
                                  gboolean signal_selected)
{
	gboolean i = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display_item != NULL, FALSE);
	if (bird_font_menu_tab_has_suppress_event ()) {
		bird_font_warn_if_test ("Event suppressed");
		result = FALSE;
		return result;
	}
	_tmp0_ = bird_font_font_display_get_name (display_item);
	_tmp1_ = _tmp0_;
	i = bird_font_tab_bar_select_tab_name (self, _tmp1_);
	_g_free0 (_tmp1_);
	if (!i) {
		bird_font_tab_bar_add_tab (self, display_item, signal_selected, NULL);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

void
bird_font_tab_bar_draw (BirdFontTabBar* self,
                        cairo_t* cr,
                        gint width,
                        gint height)
{
	gdouble next_tab_x = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	self->width = width;
	self->height = height;
	self->priv->scale = height / 117.0;
	cairo_save (cr);
	cairo_set_line_width (cr, (gdouble) 0);
	bird_font_theme_color (cr, "Default Background");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	cairo_scale (cr, self->priv->scale, self->priv->scale);
	w = width / self->priv->scale;
	h = height / self->priv->scale;
	if (bird_font_tab_bar_has_scroll (self)) {
		_tmp0_ = !bird_font_tab_bar_has_progress_wheel (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontText* _tmp1_;
		BirdFontText* _tmp2_;
		BirdFontText* _tmp3_;
		BirdFontText* _tmp4_;
		BirdFontText* _tmp5_;
		BirdFontText* _tmp6_;
		gdouble _tmp7_ = 0.0;
		BirdFontText* _tmp8_;
		BirdFontText* _tmp9_;
		BirdFontText* _tmp10_;
		BirdFontText* _tmp11_;
		_tmp1_ = self->priv->left_arrow;
		bird_font_theme_text_color (_tmp1_, "Text Tab Bar");
		_tmp2_ = self->priv->left_arrow;
		bird_font_text_set_font_size (_tmp2_, 40 / self->priv->scale);
		_tmp3_ = self->priv->left_arrow;
		((BirdFontWidget*) _tmp3_)->widget_x = 2 / self->priv->scale;
		_tmp4_ = self->priv->left_arrow;
		((BirdFontWidget*) _tmp4_)->widget_y = (h / 2.0) - ((40 / self->priv->scale) / 2);
		_tmp5_ = self->priv->left_arrow;
		bird_font_widget_draw ((BirdFontWidget*) _tmp5_, cr);
		_tmp6_ = self->priv->right_arrow;
		bird_font_theme_text_color (_tmp6_, "Text Tab Bar");
		if (bird_font_tab_bar_has_progress_wheel (self)) {
			_tmp7_ = w - (((2 * 19) + 3) / self->priv->scale);
		} else {
			_tmp7_ = w - (19 / self->priv->scale);
		}
		next_tab_x = _tmp7_;
		next_tab_x -= 32 / self->priv->scale;
		_tmp8_ = self->priv->right_arrow;
		bird_font_text_set_font_size (_tmp8_, 40 / self->priv->scale);
		_tmp9_ = self->priv->right_arrow;
		((BirdFontWidget*) _tmp9_)->widget_x = next_tab_x;
		_tmp10_ = self->priv->right_arrow;
		((BirdFontWidget*) _tmp10_)->widget_y = (h / 2.0) - ((40 / self->priv->scale) / 2);
		_tmp11_ = self->priv->right_arrow;
		bird_font_widget_draw ((BirdFontWidget*) _tmp11_, cr);
	}
	if (bird_font_tab_bar_has_progress_wheel (self)) {
		gdouble progress_size = 0.0;
		BirdFontText* _tmp12_ = NULL;
		BirdFontText* wheel = NULL;
		BirdFontText* _tmp15_;
		BirdFontText* _tmp18_;
		gdouble middley = 0.0;
		gdouble middlex = 0.0;
		BirdFontText* _tmp19_;
		BirdFontText* _tmp20_;
		BirdFontText* _tmp21_;
		BirdFontText* _tmp22_;
		BirdFontText* _tmp23_;
		BirdFontText* _tmp24_;
		progress_size = 40 / self->priv->scale;
		if (bird_font_tab_bar_has_stop_button (self)) {
			BirdFontText* _tmp13_;
			_tmp13_ = self->priv->stop_icon;
			_tmp12_ = _tmp13_;
		} else {
			BirdFontText* _tmp14_;
			_tmp14_ = self->priv->progress_icon;
			_tmp12_ = _tmp14_;
		}
		_tmp15_ = _g_object_ref0 (_tmp12_);
		wheel = _tmp15_;
		if (!bird_font_tab_bar_has_stop_button (self)) {
			BirdFontText* _tmp16_;
			_tmp16_ = wheel;
			bird_font_theme_text_color (_tmp16_, "Text Tab Bar");
		} else {
			BirdFontText* _tmp17_;
			_tmp17_ = wheel;
			bird_font_theme_text_color (_tmp17_, "Highlighted 1");
		}
		_tmp18_ = wheel;
		bird_font_text_set_font_size (_tmp18_, progress_size);
		middley = h / 2;
		_tmp19_ = wheel;
		middlex = w - ((bird_font_text_get_sidebearing_extent (_tmp19_) / 2) / self->priv->scale);
		_tmp20_ = wheel;
		((BirdFontWidget*) _tmp20_)->widget_x = middlex;
		_tmp21_ = wheel;
		((BirdFontWidget*) _tmp21_)->widget_y = middley;
		cairo_save (cr);
		if (!bird_font_tab_bar_has_stop_button (self)) {
			cairo_translate (cr, middlex, middley);
			cairo_rotate (cr, self->priv->wheel_rotation);
			cairo_translate (cr, -middlex, -middley);
		}
		_tmp22_ = wheel;
		_tmp23_ = wheel;
		_tmp24_ = wheel;
		bird_font_text_draw_at_baseline (_tmp22_, cr, ((BirdFontWidget*) _tmp23_)->widget_x, ((BirdFontWidget*) _tmp24_)->widget_y, "");
		cairo_restore (cr);
		_g_object_unref0 (wheel);
	} else {
		BirdFontAbstractMenu* _tmp25_;
		BirdFontAbstractMenu* _tmp26_;
		gboolean _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		BirdFontAbstractMenu* _tmp30_;
		BirdFontAbstractMenu* _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		BirdFontText* _tmp37_;
		BirdFontText* _tmp38_;
		BirdFontText* _tmp39_;
		BirdFontText* _tmp40_;
		BirdFontText* _tmp41_;
		_tmp25_ = bird_font_main_window_get_menu ();
		_tmp26_ = _tmp25_;
		_tmp27_ = bird_font_abstract_menu_get_show_menu (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp26_);
		if (_tmp29_) {
			bird_font_theme_color (cr, "Menu Background");
			cairo_rectangle (cr, w - (40 / self->priv->scale), (gdouble) 0, 40 / self->priv->scale, h);
			cairo_fill (cr);
		}
		_tmp30_ = bird_font_main_window_get_menu ();
		_tmp31_ = _tmp30_;
		_tmp32_ = bird_font_abstract_menu_get_show_menu (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		_g_object_unref0 (_tmp31_);
		if (_tmp34_) {
			BirdFontText* _tmp35_;
			_tmp35_ = self->priv->menu_icon;
			bird_font_theme_text_color (_tmp35_, "Foreground Inverted");
		} else {
			BirdFontText* _tmp36_;
			_tmp36_ = self->priv->menu_icon;
			bird_font_theme_text_color (_tmp36_, "Highlighted 1");
		}
		_tmp37_ = self->priv->menu_icon;
		bird_font_text_set_font_size (_tmp37_, 40 / self->priv->scale);
		_tmp38_ = self->priv->menu_icon;
		((BirdFontWidget*) _tmp38_)->widget_x = (gdouble) ((gint) (w - (27 / self->priv->scale)));
		_tmp39_ = self->priv->menu_icon;
		_tmp40_ = self->priv->menu_icon;
		((BirdFontWidget*) _tmp39_)->widget_y = (gdouble) ((gint) (((h - bird_font_widget_get_height ((BirdFontWidget*) _tmp40_)) / 2) / self->priv->scale));
		_tmp41_ = self->priv->menu_icon;
		bird_font_widget_draw ((BirdFontWidget*) _tmp41_, cr);
	}
	bird_font_tab_bar_draw_tabs (self, cr);
	cairo_restore (cr);
}

static void
bird_font_tab_bar_draw_tabs (BirdFontTabBar* self,
                             cairo_t* cr)
{
	gdouble text_height = 0.0;
	gdouble text_width = 0.0;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	gdouble close_opacity = 0.0;
	gdouble offset = 0.0;
	gdouble tab_width = 0.0;
	gdouble tabs_end = 0.0;
	gdouble h = 0.0;
	gdouble tab_height = 0.0;
	BirdFontTab* t = NULL;
	BirdFontText* label = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	tabs_end = self->width / self->priv->scale;
	h = self->height / self->priv->scale;
	if (bird_font_tab_bar_has_progress_wheel (self)) {
		tabs_end -= 19 / self->priv->scale;
	}
	if (bird_font_tab_bar_has_scroll (self)) {
		tabs_end -= 60 / self->priv->scale;
		offset = 24 / self->priv->scale;
	} else {
		offset = (gdouble) 0;
	}
	tab_height = self->height / self->priv->scale;
	{
		gint tab_index = 0;
		tab_index = self->priv->first_tab;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				BirdFontTab* _tmp7_;
				BirdFontTab* _tmp8_;
				BirdFontText* _tmp10_;
				BirdFontText* _tmp11_;
				BirdFontTab* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				BirdFontText* _tmp15_;
				BirdFontText* _tmp16_;
				BirdFontText* _tmp19_;
				BirdFontText* _tmp20_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = tab_index;
					tab_index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->tabs;
				_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(tab_index < _tmp4_)) {
					break;
				}
				_tmp5_ = self->tabs;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, tab_index);
				_g_object_unref0 (t);
				t = (BirdFontTab*) _tmp6_;
				cairo_save (cr);
				cairo_translate (cr, offset, (gdouble) 0);
				_tmp7_ = t;
				tab_width = bird_font_tab_get_width (_tmp7_) / self->priv->scale;
				if ((offset + tab_width) > tabs_end) {
					cairo_restore (cr);
					break;
				}
				if (tab_index == self->priv->selected) {
					cairo_save (cr);
					bird_font_theme_color (cr, "Highlighted 1");
					cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, tab_width, h);
					cairo_fill (cr);
					cairo_restore (cr);
				} else {
					if (tab_index == self->priv->over) {
						cairo_save (cr);
						bird_font_theme_color (cr, "Default Background");
						cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, tab_width, h);
						cairo_fill (cr);
						cairo_restore (cr);
					} else {
						cairo_save (cr);
						bird_font_theme_color (cr, "Default Background");
						cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, tab_width, h);
						cairo_fill (cr);
						cairo_restore (cr);
					}
				}
				_tmp8_ = t;
				if (bird_font_tab_has_close_button (_tmp8_)) {
					gdouble _tmp9_ = 0.0;
					cairo_save (cr);
					cairo_new_path (cr);
					cairo_set_line_width (cr, 1 / self->priv->scale);
					if (self->priv->over_close_tab == tab_index) {
						_tmp9_ = (gdouble) 1;
					} else {
						_tmp9_ = 0.2;
					}
					close_opacity = _tmp9_;
					if (tab_index == self->priv->selected) {
						bird_font_theme_color_opacity (cr, "Selected Tab Foreground", close_opacity);
					} else {
						bird_font_theme_color_opacity (cr, "Text Foreground", close_opacity);
					}
					cairo_move_to (cr, tab_width - (7 / self->priv->scale), (h / 2.0) - (2.5 / self->priv->scale));
					cairo_line_to (cr, tab_width - (12 / self->priv->scale), (h / 2.0) + (2.5 / self->priv->scale));
					cairo_move_to (cr, tab_width - (12 / self->priv->scale), (h / 2.0) - (2.5 / self->priv->scale));
					cairo_line_to (cr, tab_width - (7 / self->priv->scale), (h / 2.0) + (2.5 / self->priv->scale));
					cairo_stroke (cr);
					cairo_restore (cr);
				}
				_tmp10_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
				_g_object_unref0 (label);
				label = _tmp10_;
				_tmp11_ = label;
				_tmp12_ = t;
				_tmp13_ = bird_font_tab_get_label (_tmp12_);
				_tmp14_ = _tmp13_;
				bird_font_text_set_text (_tmp11_, _tmp14_);
				_g_free0 (_tmp14_);
				text_height = (gdouble) ((gint) (16 / self->priv->scale));
				_tmp15_ = label;
				bird_font_text_set_font_size (_tmp15_, text_height);
				_tmp16_ = label;
				text_width = bird_font_text_get_extent (_tmp16_);
				center_x = (tab_width / 2.0) - (text_width / 2.0);
				center_y = (gdouble) ((gint) ((tab_height / 2.0) + (4 / self->priv->scale)));
				if (tab_index == self->priv->selected) {
					BirdFontText* _tmp17_;
					_tmp17_ = label;
					bird_font_theme_text_color (_tmp17_, "Selected Tab Foreground");
				} else {
					BirdFontText* _tmp18_;
					_tmp18_ = label;
					bird_font_theme_text_color (_tmp18_, "Text Tab Bar");
				}
				_tmp19_ = label;
				bird_font_text_set_font_size (_tmp19_, text_height);
				_tmp20_ = label;
				bird_font_text_draw_at_baseline (_tmp20_, cr, center_x, center_y, "");
				if (tab_index != self->priv->selected) {
					if ((tab_index + 1) != self->priv->selected) {
						cairo_save (cr);
						bird_font_theme_color (cr, "Tab Separator");
						cairo_rectangle (cr, tab_width - (1 / self->priv->scale), (gdouble) 0, 1 / self->priv->scale, h);
						cairo_fill (cr);
						cairo_restore (cr);
					}
					if (tab_index == self->priv->first_tab) {
						cairo_save (cr);
						bird_font_theme_color (cr, "Tab Separator");
						cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, 1 / self->priv->scale, h);
						cairo_fill (cr);
						cairo_restore (cr);
					}
				}
				cairo_restore (cr);
				offset += tab_width;
			}
		}
	}
	_g_object_unref0 (label);
	_g_object_unref0 (t);
}

void
bird_font_tab_bar_add_empty_tab (BirdFontTabBar* self,
                                 const gchar* name,
                                 const gchar* label)
{
	BirdFontEmptyTab* _tmp0_;
	BirdFontEmptyTab* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = bird_font_empty_tab_new (name, label);
	_tmp1_ = _tmp0_;
	bird_font_tab_bar_add_tab (self, (BirdFontFontDisplay*) _tmp1_, TRUE, NULL);
	_g_object_unref0 (_tmp1_);
}

static gboolean
bird_font_tab_bar_has_stop_button (BirdFontTabBar* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->processing) {
		_tmp0_ = self->priv->stop_button;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
bird_font_tab_bar_has_progress_wheel (BirdFontTabBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->processing;
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
___lambda77_ (BirdFontTabBar* self)
{
	gboolean result;
	self->priv->wheel_rotation = self->priv->wheel_rotation + ((0.008 * 2) * G_PI);
	if (self->priv->wheel_rotation > (2 * G_PI)) {
		self->priv->wheel_rotation = self->priv->wheel_rotation - (2 * G_PI);
	}
	g_signal_emit (self, bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL], 0, self->width - 40, 0, 40, self->height);
	result = self->priv->processing;
	return result;
}

static gboolean
____lambda77__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda77_ ((BirdFontTabBar*) self);
	return result;
}

void
bird_font_tab_bar_set_progress (BirdFontTabBar* self,
                                gboolean running)
{
	GSource* timer = NULL;
	g_return_if_fail (self != NULL);
	if (G_UNLIKELY (self->priv->processing == running)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = bool_to_string (running);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat ("Progress is already set to ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		g_warning ("TabBar.vala:869: %s", _tmp3_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		_g_source_unref0 (timer);
		return;
	}
	self->priv->processing = running;
	if (!self->priv->processing) {
		self->priv->stop_button = FALSE;
	}
	if (self->priv->processing) {
		GSource* _tmp4_;
		GSource* _tmp5_;
		GSource* _tmp6_;
		_tmp4_ = g_timeout_source_new ((guint) 250);
		_g_source_unref0 (timer);
		timer = _tmp4_;
		_tmp5_ = timer;
		g_source_set_callback (_tmp5_, ____lambda77__gsource_func, g_object_ref (self), g_object_unref);
		_tmp6_ = timer;
		g_source_attach (_tmp6_, NULL);
	}
	_g_source_unref0 (timer);
}

void
bird_font_tab_bar_start_wheel (void)
{
	BirdFontTabBar* t = NULL;
	BirdFontTabBar* _tmp0_;
	_tmp0_ = bird_font_main_window_get_tab_bar ();
	if (!bird_font_is_null (_tmp0_)) {
		BirdFontTabBar* _tmp1_;
		BirdFontTabBar* _tmp2_;
		_tmp1_ = bird_font_main_window_get_tab_bar ();
		_g_object_unref0 (t);
		t = _tmp1_;
		_tmp2_ = t;
		bird_font_tab_bar_set_progress (_tmp2_, TRUE);
	}
	_g_object_unref0 (t);
}

void
bird_font_tab_bar_stop_wheel (void)
{
	BirdFontTabBar* _tmp0_;
	_tmp0_ = bird_font_main_window_get_tab_bar ();
	if (!bird_font_is_null (_tmp0_)) {
		BirdFontTabBar* _tmp1_;
		BirdFontTabBar* _tmp2_;
		_tmp1_ = bird_font_main_window_get_tab_bar ();
		_tmp2_ = _tmp1_;
		bird_font_tab_bar_set_progress (_tmp2_, FALSE);
		_g_object_unref0 (_tmp2_);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
bird_font_tab_bar_class_init (BirdFontTabBarClass * klass,
                              gpointer klass_data)
{
	bird_font_tab_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontTabBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_tab_bar_finalize;
	bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_SIGNAL_TAB_SELECTED_SIGNAL] = g_signal_new ("signal-tab-selected", BIRD_FONT_TYPE_TAB_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_TAB);
	bird_font_tab_bar_signals[BIRD_FONT_TAB_BAR_REDRAW_TAB_BAR_SIGNAL] = g_signal_new ("redraw-tab-bar", BIRD_FONT_TYPE_TAB_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
}

static void
bird_font_tab_bar_instance_init (BirdFontTabBar * self,
                                 gpointer klass)
{
	self->priv = bird_font_tab_bar_get_instance_private (self);
	self->width = 0;
	self->height = 0;
	self->priv->first_tab = 0;
	self->priv->selected = 0;
	self->priv->over = BIRD_FONT_TAB_BAR_NO_TAB;
	self->priv->over_close_tab = BIRD_FONT_TAB_BAR_NO_TAB;
	self->priv->previous_tab = NULL;
	self->priv->current_tab = NULL;
	self->priv->scale = (gdouble) 1;
	self->priv->processing = FALSE;
	self->priv->stop_button = FALSE;
	self->priv->wheel_rotation = (gdouble) 0;
	self->priv->background_r = 51 / 255.0;
	self->priv->background_g = 54 / 255.0;
	self->priv->background_b = 59 / 255.0;
}

static void
bird_font_tab_bar_finalize (GObject * obj)
{
	BirdFontTabBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_TAB_BAR, BirdFontTabBar);
	_g_object_unref0 (self->tabs);
	_g_object_unref0 (self->priv->previous_tab);
	_g_object_unref0 (self->priv->current_tab);
	_g_object_unref0 (self->priv->menu_icon);
	_g_object_unref0 (self->priv->progress_icon);
	_g_object_unref0 (self->priv->stop_icon);
	_g_object_unref0 (self->priv->left_arrow);
	_g_object_unref0 (self->priv->right_arrow);
	G_OBJECT_CLASS (bird_font_tab_bar_parent_class)->finalize (obj);
}

static GType
bird_font_tab_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontTabBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_tab_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontTabBar), 0, (GInstanceInitFunc) bird_font_tab_bar_instance_init, NULL };
	GType bird_font_tab_bar_type_id;
	bird_font_tab_bar_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontTabBar", &g_define_type_info, 0);
	BirdFontTabBar_private_offset = g_type_add_instance_private (bird_font_tab_bar_type_id, sizeof (BirdFontTabBarPrivate));
	return bird_font_tab_bar_type_id;
}

GType
bird_font_tab_bar_get_type (void)
{
	static volatile gsize bird_font_tab_bar_type_id__once = 0;
	if (g_once_init_enter (&bird_font_tab_bar_type_id__once)) {
		GType bird_font_tab_bar_type_id;
		bird_font_tab_bar_type_id = bird_font_tab_bar_get_type_once ();
		g_once_init_leave (&bird_font_tab_bar_type_id__once, bird_font_tab_bar_type_id);
	}
	return bird_font_tab_bar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

