/* SvgParser.c generated by valac 0.56.16, the Vala compiler
 * generated from SvgParser.vala, do not modify */

/*
Copyright (C) 2012 - 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <xmlbird.h>
#include <gee.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <errno.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _bird_font_svg_parser_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_svg_parser_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _bird_font_svg_style_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_svg_style_unref (var), NULL)))
#define _bird_font_bezier_points_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_bezier_points_unref (var), NULL)))
typedef struct _BirdFontParamSpecSvgParser BirdFontParamSpecSvgParser;

struct _BirdFontSvgParserPrivate {
	BirdFontSvgFormat format;
};

struct _BirdFontParamSpecSvgParser {
	GParamSpec parent_instance;
};

static gint BirdFontSvgParser_private_offset;
static gpointer bird_font_svg_parser_parent_class = NULL;

static void __lambda41_ (const gchar* p);
static void ___lambda41__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                        const gchar* path,
                                                        gpointer self);
static void __lambda354_ (const gchar* p);
static void ___lambda354__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                         const gchar* path,
                                                         gpointer self);
static BirdFontPathList* bird_font_svg_parser_parse_svg_file (BirdFontSvgParser* self,
                                                       BTag* tag);
static void bird_font_svg_parser_parse_layer (BirdFontSvgParser* self,
                                       BTag* tag,
                                       BirdFontLayer* pl);
static void bird_font_svg_parser_parse_path (BirdFontSvgParser* self,
                                      BTag* tag,
                                      BirdFontLayer* pl);
static void bird_font_svg_parser_parse_polygon (BirdFontSvgParser* self,
                                         BTag* tag,
                                         BirdFontLayer* pl);
static void bird_font_svg_parser_parse_polyline (BirdFontSvgParser* self,
                                          BTag* tag,
                                          BirdFontLayer* pl);
static void bird_font_svg_parser_parse_circle (BirdFontSvgParser* self,
                                        BTag* tag,
                                        BirdFontLayer* pl);
static void bird_font_svg_parser_parse_ellipse (BirdFontSvgParser* self,
                                         BTag* tag,
                                         BirdFontLayer* pl);
static void bird_font_svg_parser_parse_line (BirdFontSvgParser* self,
                                      BTag* tag,
                                      BirdFontLayer* pl);
static void bird_font_svg_parser_parse_rect (BirdFontSvgParser* self,
                                      BTag* tag,
                                      BirdFontLayer* pl);
static void bird_font_svg_parser_transform (BirdFontSvgParser* self,
                                     const gchar* transform_functions,
                                     BirdFontLayer* layer);
static void bird_font_svg_parser_transform_paths (BirdFontSvgParser* self,
                                           const gchar* transform_functions,
                                           BirdFontPathList* pl);
static void bird_font_svg_parser_transform_subgroups (BirdFontSvgParser* self,
                                               const gchar* transform_functions,
                                               BirdFontLayer* layer);
static void bird_font_svg_parser_translate (BirdFontSvgParser* self,
                                     const gchar* function,
                                     BirdFontPathList* pl);
static void bird_font_svg_parser_scale (BirdFontSvgParser* self,
                                 const gchar* function,
                                 BirdFontPathList* pl);
static void bird_font_svg_parser_matrix (BirdFontSvgParser* self,
                                  const gchar* function,
                                  BirdFontPathList* pl);
static gchar* bird_font_svg_parser_get_transform_parameters (BirdFontSvgParser* self,
                                                      const gchar* function);
static gdouble bird_font_svg_parser_parse_double (const gchar* s);
static void bird_font_svg_parser_move_and_resize (BirdFontSvgParser* self,
                                           BirdFontBezierPoints** b,
                                           gint b_length1,
                                           gint num_b,
                                           gboolean svg_glyph,
                                           gdouble units,
                                           BirdFontGlyph* glyph);
static BirdFontPathList* bird_font_svg_parser_get_polyline (BirdFontSvgParser* self,
                                                     BTag* tag);
static BirdFontPath* bird_font_svg_parser_parse_poly_data (BirdFontSvgParser* self,
                                                    const gchar* polygon_points);
static gchar* bird_font_svg_parser_add_separators (const gchar* d);
static gboolean bird_font_svg_parser_is_point (const gchar* s);
static gint bird_font_svg_parser_parse_int (const gchar* s);
VALA_EXTERN void bird_font_add_arc_points (BirdFontBezierPoints** bezier_points,
                               gint bezier_points_length1,
                               gint* bi,
                               gdouble x0,
                               gdouble y0,
                               gdouble rx,
                               gdouble ry,
                               gdouble angle,
                               gboolean largeArcFlag,
                               gboolean sweepFlag,
                               gdouble x,
                               gdouble y);
static BirdFontPathList* bird_font_svg_parser_create_paths_illustrator (BirdFontSvgParser* self,
                                                                 BirdFontBezierPoints** b,
                                                                 gint b_length1,
                                                                 gint num_b);
static BirdFontPathList* bird_font_svg_parser_create_paths_inkscape (BirdFontSvgParser* self,
                                                              BirdFontBezierPoints** b,
                                                              gint b_length1,
                                                              gint num_b);
static void bird_font_svg_parser_find_last_handle (BirdFontSvgParser* self,
                                            gint start_index,
                                            BirdFontBezierPoints** b,
                                            gint b_length1,
                                            gint num_b,
                                            gdouble* left_x,
                                            gdouble* left_y,
                                            BirdFontPointType* last_type);
static void bird_font_svg_parser_finalize (BirdFontSvgParser * obj);
static GType bird_font_svg_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
bird_font_svg_format_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_SVG_FORMAT_NONE, "BIRD_FONT_SVG_FORMAT_NONE", "none"}, {BIRD_FONT_SVG_FORMAT_INKSCAPE, "BIRD_FONT_SVG_FORMAT_INKSCAPE", "inkscape"}, {BIRD_FONT_SVG_FORMAT_ILLUSTRATOR, "BIRD_FONT_SVG_FORMAT_ILLUSTRATOR", "illustrator"}, {0, NULL, NULL}};
	GType bird_font_svg_format_type_id;
	bird_font_svg_format_type_id = g_enum_register_static ("BirdFontSvgFormat", values);
	return bird_font_svg_format_type_id;
}

GType
bird_font_svg_format_get_type (void)
{
	static volatile gsize bird_font_svg_format_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_format_type_id__once)) {
		GType bird_font_svg_format_type_id;
		bird_font_svg_format_type_id = bird_font_svg_format_get_type_once ();
		g_once_init_leave (&bird_font_svg_format_type_id__once, bird_font_svg_format_type_id);
	}
	return bird_font_svg_format_type_id__once;
}

static inline gpointer
bird_font_svg_parser_get_instance_private (BirdFontSvgParser* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSvgParser_private_offset);
}

BirdFontSvgParser*
bird_font_svg_parser_construct (GType object_type)
{
	BirdFontSvgParser* self = NULL;
	self = (BirdFontSvgParser*) g_type_create_instance (object_type);
	return self;
}

BirdFontSvgParser*
bird_font_svg_parser_new (void)
{
	return bird_font_svg_parser_construct (BIRD_FONT_TYPE_SVG_PARSER);
}

void
bird_font_svg_parser_set_format (BirdFontSvgParser* self,
                                 BirdFontSvgFormat f)
{
	g_return_if_fail (self != NULL);
	self->priv->format = f;
}

static void
__lambda41_ (const gchar* p)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	if (p == NULL) {
		_g_free0 (path);
		return;
	}
	_tmp0_ = g_strdup ((const gchar*) p);
	_g_free0 (path);
	path = _tmp0_;
	_tmp1_ = path;
	bird_font_svg_parser_import_svg (_tmp1_);
	_g_free0 (path);
}

static void
___lambda41__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                   const gchar* path,
                                                   gpointer self)
{
	__lambda41_ (path);
}

void
bird_font_svg_parser_import (void)
{
	BirdFontFileChooser* fc = NULL;
	BirdFontFileChooser* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = bird_font_file_chooser_new ();
	fc = _tmp0_;
	g_signal_connect (fc, "file-selected", (GCallback) ___lambda41__bird_font_file_chooser_file_selected, NULL);
	bird_font_file_chooser_add_extension (fc, "svg");
	_tmp1_ = bird_font_t_ ("Import");
	_tmp2_ = _tmp1_;
	bird_font_main_window_file_chooser (_tmp2_, fc, BIRD_FONT_FILE_CHOOSER_LOAD);
	_g_free0 (_tmp2_);
	_g_object_unref0 (fc);
}

static void
__lambda354_ (const gchar* p)
{
	gchar* path = NULL;
	GFile* svg_folder = NULL;
	GFile* svg = NULL;
	gboolean imported = FALSE;
	GFileEnumerator* enumerator = NULL;
	GFileInfo* file_info = NULL;
	gchar* file_name = NULL;
	BirdFontFont* font = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	BirdFontFont* _tmp3_;
	GError* _inner_error0_ = NULL;
	if (p == NULL) {
		_g_object_unref0 (font);
		_g_free0 (file_name);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (svg);
		_g_object_unref0 (svg_folder);
		_g_free0 (path);
		return;
	}
	_tmp0_ = g_strdup ((const gchar*) p);
	_g_free0 (path);
	path = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_g_object_unref0 (svg_folder);
	svg_folder = _tmp2_;
	_tmp3_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp3_;
	{
		GFileEnumerator* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileEnumerator* _tmp7_;
		_tmp5_ = svg_folder;
		_tmp6_ = g_file_enumerate_children (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (enumerator);
		enumerator = _tmp7_;
		while (TRUE) {
			GFileInfo* _tmp8_ = NULL;
			GFileEnumerator* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp9_ = enumerator;
			_tmp10_ = g_file_enumerator_next_file (_tmp9_, NULL, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (_tmp4_);
				goto __catch0_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp11_;
			_tmp12_ = file_info;
			if (!(_tmp12_ != NULL)) {
				_g_object_unref0 (_tmp8_);
				break;
			}
			_tmp13_ = file_info;
			_tmp14_ = g_file_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_file_info_get_type (), GFileInfo));
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (file_name);
			file_name = _tmp15_;
			_tmp16_ = file_name;
			if (g_str_has_suffix (_tmp16_, ".svg")) {
				GFile* _tmp17_;
				const gchar* _tmp18_;
				GFile* _tmp19_;
				BirdFontFont* _tmp20_;
				GFile* _tmp21_;
				_tmp17_ = svg_folder;
				_tmp18_ = file_name;
				_tmp19_ = bird_font_get_child (_tmp17_, _tmp18_);
				_g_object_unref0 (svg);
				svg = _tmp19_;
				_tmp20_ = font;
				_tmp21_ = svg;
				imported = bird_font_import_svg_file (_tmp20_, _tmp21_);
				if (!imported) {
					GFile* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = svg;
					_tmp23_ = g_file_get_path (_tmp22_);
					_tmp24_ = (gchar*) _tmp23_;
					g_warning ("SvgParser.vala:84: Can't import %s.", _tmp24_);
					_g_free0 (_tmp24_);
				} else {
					BirdFontFont* _tmp25_;
					_tmp25_ = font;
					bird_font_font_touch (_tmp25_);
				}
			}
			_g_object_unref0 (_tmp8_);
		}
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		g_warning ("SvgParser.vala:91: %s", _tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (font);
		_g_free0 (file_name);
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (svg);
		_g_object_unref0 (svg_folder);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (font);
	_g_free0 (file_name);
	_g_object_unref0 (file_info);
	_g_object_unref0 (enumerator);
	_g_object_unref0 (svg);
	_g_object_unref0 (svg_folder);
	_g_free0 (path);
}

static void
___lambda354__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                    const gchar* path,
                                                    gpointer self)
{
	__lambda354_ (path);
}

void
bird_font_svg_parser_import_folder (void)
{
	BirdFontFileChooser* fc = NULL;
	BirdFontFileChooser* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = bird_font_file_chooser_new ();
	fc = _tmp0_;
	g_signal_connect (fc, "file-selected", (GCallback) ___lambda354__bird_font_file_chooser_file_selected, NULL);
	_tmp1_ = bird_font_t_ ("Import");
	_tmp2_ = _tmp1_;
	bird_font_main_window_file_chooser (_tmp2_, fc, BIRD_FONT_FILE_CHOOSER_LOAD | BIRD_FONT_FILE_CHOOSER_DIRECTORY);
	_g_free0 (_tmp2_);
	_g_object_unref0 (fc);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
bird_font_svg_parser_import_svg_data (const gchar* xml_data,
                                      BirdFontSvgFormat format)
{
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	gchar** lines = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint lines_length1;
	gint _lines_size_;
	gboolean has_format = FALSE;
	BirdFontSvgParser* parser = NULL;
	BirdFontSvgParser* _tmp3_;
	BXmlParser* xmlparser = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	BXmlParser* _tmp15_;
	BXmlParser* _tmp16_;
	BirdFontSvgParser* _tmp17_;
	BXmlParser* _tmp18_;
	BTag* _tmp19_;
	BTag* _tmp20_;
	BirdFontPathList* _tmp21_;
	BirdFontGlyph* _tmp22_;
	BirdFontGlyph* _tmp46_;
	BirdFontGlyph* _tmp47_;
	g_return_if_fail (xml_data != NULL);
	_tmp0_ = bird_font_path_list_new ();
	path_list = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (xml_data, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = lines_length1;
	has_format = FALSE;
	_tmp3_ = bird_font_svg_parser_new ();
	parser = _tmp3_;
	_tmp4_ = lines;
	_tmp4__length1 = lines_length1;
	{
		gchar** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint _l_collection_size_ = 0;
		gint l_it = 0;
		l_collection = _tmp4_;
		l_collection_length1 = _tmp4__length1;
		for (l_it = 0; l_it < l_collection_length1; l_it = l_it + 1) {
			gchar* _tmp5_;
			gchar* l = NULL;
			_tmp5_ = g_strdup (l_collection[l_it]);
			l = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				_tmp7_ = l;
				if (string_index_of (_tmp7_, "Illustrator", 0) > -1) {
					_tmp6_ = TRUE;
				} else {
					const gchar* _tmp8_;
					_tmp8_ = l;
					_tmp6_ = string_index_of (_tmp8_, "illustrator", 0) > -1;
				}
				if (_tmp6_) {
					BirdFontSvgParser* _tmp9_;
					_tmp9_ = parser;
					bird_font_svg_parser_set_format (_tmp9_, BIRD_FONT_SVG_FORMAT_ILLUSTRATOR);
					has_format = TRUE;
				}
				_tmp11_ = l;
				if (string_index_of (_tmp11_, "Inkscape", 0) > -1) {
					_tmp10_ = TRUE;
				} else {
					const gchar* _tmp12_;
					_tmp12_ = l;
					_tmp10_ = string_index_of (_tmp12_, "inkscape", 0) > -1;
				}
				if (_tmp10_) {
					BirdFontSvgParser* _tmp13_;
					_tmp13_ = parser;
					bird_font_svg_parser_set_format (_tmp13_, BIRD_FONT_SVG_FORMAT_INKSCAPE);
					has_format = TRUE;
				}
				_g_free0 (l);
			}
		}
	}
	if (format != BIRD_FONT_SVG_FORMAT_NONE) {
		BirdFontSvgParser* _tmp14_;
		_tmp14_ = parser;
		bird_font_svg_parser_set_format (_tmp14_, format);
	}
	if (!has_format) {
		bird_font_warn_if_test ("No format identifier found in SVG parser.\n");
	}
	_tmp15_ = b_xml_parser_new (xml_data);
	_g_object_unref0 (xmlparser);
	xmlparser = _tmp15_;
	_tmp16_ = xmlparser;
	if (!b_xml_parser_validate (_tmp16_)) {
		g_warning ("SvgParser.vala:130: Invalid XML in SVG parser.");
	}
	_tmp17_ = parser;
	_tmp18_ = xmlparser;
	_tmp19_ = b_xml_parser_get_root_tag (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = bird_font_svg_parser_parse_svg_file (_tmp17_, _tmp20_);
	_g_object_unref0 (path_list);
	path_list = _tmp21_;
	_g_object_unref0 (_tmp20_);
	_tmp22_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (glyph);
	glyph = _tmp22_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _p_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _p_index = 0;
		_tmp23_ = path_list;
		_tmp24_ = _tmp23_->paths;
		_p_list = _tmp24_;
		_tmp25_ = _p_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_p_size = _tmp27_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			BirdFontGlyph* _tmp32_;
			BirdFontPath* _tmp33_;
			_p_index = _p_index + 1;
			_tmp28_ = _p_index;
			_tmp29_ = _p_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _p_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _p_index);
			p = (BirdFontPath*) _tmp31_;
			_tmp32_ = glyph;
			_tmp33_ = p;
			bird_font_glyph_add_path (_tmp32_, _tmp33_);
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp34_;
		GeeArrayList* _tmp35_;
		gint _p_size = 0;
		GeeArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _p_index = 0;
		_tmp34_ = path_list;
		_tmp35_ = _tmp34_->paths;
		_p_list = _tmp35_;
		_tmp36_ = _p_list;
		_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_p_size = _tmp38_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp41_;
			gpointer _tmp42_;
			BirdFontGlyph* _tmp43_;
			BirdFontPath* _tmp44_;
			BirdFontPath* _tmp45_;
			_p_index = _p_index + 1;
			_tmp39_ = _p_index;
			_tmp40_ = _p_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _p_list;
			_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, _p_index);
			p = (BirdFontPath*) _tmp42_;
			_tmp43_ = glyph;
			_tmp44_ = p;
			bird_font_glyph_add_active_path (_tmp43_, NULL, _tmp44_);
			_tmp45_ = p;
			bird_font_path_update_region_boundaries (_tmp45_);
			_g_object_unref0 (p);
		}
	}
	_tmp46_ = glyph;
	bird_font_glyph_close_path (_tmp46_);
	_tmp47_ = glyph;
	bird_font_glyph_fix_curve_orientation (_tmp47_);
	_g_object_unref0 (xmlparser);
	_bird_font_svg_parser_unref0 (parser);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (glyph);
	_g_object_unref0 (path_list);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
bird_font_svg_parser_replace (const gchar* content,
                              const gchar* start,
                              const gchar* stop,
                              const gchar* replacement)
{
	gint i_tag = 0;
	gint end_tag = 0;
	gchar* c = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (stop != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	i_tag = string_index_of (content, start, 0);
	end_tag = string_index_of (content, stop, i_tag);
	_tmp0_ = g_strdup ("");
	c = _tmp0_;
	if (i_tag > -1) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = string_substring (content, (glong) 0, (glong) i_tag);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_tmp2_, replacement, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = strlen (stop);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_substring (content, (glong) (end_tag + _tmp6_), (glong) -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
		_g_free0 (c);
		c = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (content);
		_g_free0 (c);
		c = _tmp10_;
	}
	result = c;
	return result;
}

void
bird_font_svg_parser_import_svg (const gchar* path)
{
	gchar* svg_data = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (svg_data);
		svg_data = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("SvgParser.vala:170: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (svg_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	bird_font_svg_parser_import_svg_data (svg_data, BIRD_FONT_SVG_FORMAT_NONE);
	_g_free0 (svg_data);
}

static BirdFontPathList*
bird_font_svg_parser_parse_svg_file (BirdFontSvgParser* self,
                                     BTag* tag)
{
	BirdFontLayer* pl = NULL;
	BirdFontLayer* _tmp0_;
	BirdFontLayer* _tmp53_;
	BirdFontPathList* _tmp54_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = bird_font_layer_new ();
	pl = _tmp0_;
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp1_;
		_tmp1_ = b_tag_iterator (tag);
		_t_it = _tmp1_;
		while (TRUE) {
			BTagIterator* _tmp2_;
			BTag* t = NULL;
			BTagIterator* _tmp3_;
			BTag* _tmp4_;
			BTag* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			BTag* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			BTag* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			BTag* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BTag* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gboolean _tmp32_;
			BTag* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gboolean _tmp38_;
			BTag* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gboolean _tmp44_;
			BTag* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gboolean _tmp50_;
			_tmp2_ = _t_it;
			if (!b_tag_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _t_it;
			_tmp4_ = b_tag_iterator_get (_tmp3_);
			t = _tmp4_;
			_tmp5_ = t;
			_tmp6_ = b_tag_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "g") == 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				BTag* _tmp9_;
				BirdFontLayer* _tmp10_;
				_tmp9_ = t;
				_tmp10_ = pl;
				bird_font_svg_parser_parse_layer (self, _tmp9_, _tmp10_);
			}
			_tmp11_ = t;
			_tmp12_ = b_tag_get_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp13_, "switch") == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				BTag* _tmp15_;
				BirdFontLayer* _tmp16_;
				_tmp15_ = t;
				_tmp16_ = pl;
				bird_font_svg_parser_parse_layer (self, _tmp15_, _tmp16_);
			}
			_tmp17_ = t;
			_tmp18_ = b_tag_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "path") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				BTag* _tmp21_;
				BirdFontLayer* _tmp22_;
				_tmp21_ = t;
				_tmp22_ = pl;
				bird_font_svg_parser_parse_path (self, _tmp21_, _tmp22_);
			}
			_tmp23_ = t;
			_tmp24_ = b_tag_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "polygon") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BTag* _tmp27_;
				BirdFontLayer* _tmp28_;
				_tmp27_ = t;
				_tmp28_ = pl;
				bird_font_svg_parser_parse_polygon (self, _tmp27_, _tmp28_);
			}
			_tmp29_ = t;
			_tmp30_ = b_tag_get_name (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strcmp0 (_tmp31_, "polyline") == 0;
			_g_free0 (_tmp31_);
			if (_tmp32_) {
				BTag* _tmp33_;
				BirdFontLayer* _tmp34_;
				_tmp33_ = t;
				_tmp34_ = pl;
				bird_font_svg_parser_parse_polyline (self, _tmp33_, _tmp34_);
			}
			_tmp35_ = t;
			_tmp36_ = b_tag_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strcmp0 (_tmp37_, "circle") == 0;
			_g_free0 (_tmp37_);
			if (_tmp38_) {
				BTag* _tmp39_;
				BirdFontLayer* _tmp40_;
				_tmp39_ = t;
				_tmp40_ = pl;
				bird_font_svg_parser_parse_circle (self, _tmp39_, _tmp40_);
			}
			_tmp41_ = t;
			_tmp42_ = b_tag_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strcmp0 (_tmp43_, "ellipse") == 0;
			_g_free0 (_tmp43_);
			if (_tmp44_) {
				BTag* _tmp45_;
				BirdFontLayer* _tmp46_;
				_tmp45_ = t;
				_tmp46_ = pl;
				bird_font_svg_parser_parse_ellipse (self, _tmp45_, _tmp46_);
			}
			_tmp47_ = t;
			_tmp48_ = b_tag_get_name (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strcmp0 (_tmp49_, "line") == 0;
			_g_free0 (_tmp49_);
			if (_tmp50_) {
				BTag* _tmp51_;
				BirdFontLayer* _tmp52_;
				_tmp51_ = t;
				_tmp52_ = pl;
				bird_font_svg_parser_parse_line (self, _tmp51_, _tmp52_);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	_tmp53_ = pl;
	_tmp54_ = bird_font_layer_get_all_paths (_tmp53_);
	result = _tmp54_;
	_g_object_unref0 (pl);
	return result;
}

static void
bird_font_svg_parser_parse_layer (BirdFontSvgParser* self,
                                  BTag* tag,
                                  BirdFontLayer* pl)
{
	BirdFontLayer* layer = NULL;
	gboolean hidden = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	hidden = FALSE;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp0_;
		BAttributes* _tmp1_;
		BAttributesIterator* _tmp2_;
		BAttributesIterator* _tmp3_;
		_tmp0_ = b_tag_get_attributes (tag);
		_tmp1_ = _tmp0_;
		_tmp2_ = b_attributes_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_attr_it = _tmp3_;
		while (TRUE) {
			BAttributesIterator* _tmp4_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp5_;
			BAttribute* _tmp6_;
			gboolean _tmp7_ = FALSE;
			BAttribute* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp15_ = FALSE;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			_tmp4_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _attr_it;
			_tmp6_ = b_attributes_iterator_get (_tmp5_);
			attr = _tmp6_;
			_tmp8_ = attr;
			_tmp9_ = b_attribute_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, "display") == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BAttribute* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp12_ = attr;
				_tmp13_ = b_attribute_get_content (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp7_ = g_strcmp0 (_tmp14_, "none") == 0;
				_g_free0 (_tmp14_);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				hidden = TRUE;
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "visibility") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				gboolean _tmp20_ = FALSE;
				BAttribute* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				_tmp21_ = attr;
				_tmp22_ = b_attribute_get_content (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "hidden") == 0;
				_g_free0 (_tmp23_);
				if (_tmp24_) {
					_tmp20_ = TRUE;
				} else {
					BAttribute* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp25_ = attr;
					_tmp26_ = b_attribute_get_content (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp20_ = g_strcmp0 (_tmp27_, "collapse") == 0;
					_g_free0 (_tmp27_);
				}
				_tmp15_ = _tmp20_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	if (hidden) {
		_g_object_unref0 (layer);
		return;
	}
	{
		BTagIterator* _t_it = NULL;
		BTagIterator* _tmp28_;
		_tmp28_ = b_tag_iterator (tag);
		_t_it = _tmp28_;
		while (TRUE) {
			BTagIterator* _tmp29_;
			BTag* t = NULL;
			BTagIterator* _tmp30_;
			BTag* _tmp31_;
			BTag* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gboolean _tmp35_;
			BTag* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gboolean _tmp40_;
			BTag* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gboolean _tmp49_;
			BTag* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gboolean _tmp54_;
			BTag* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gboolean _tmp59_;
			BTag* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gboolean _tmp64_;
			BTag* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			gboolean _tmp69_;
			BTag* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gboolean _tmp74_;
			_tmp29_ = _t_it;
			if (!b_tag_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _t_it;
			_tmp31_ = b_tag_iterator_get (_tmp30_);
			t = _tmp31_;
			_tmp32_ = t;
			_tmp33_ = b_tag_get_name (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strcmp0 (_tmp34_, "path") == 0;
			_g_free0 (_tmp34_);
			if (_tmp35_) {
				BTag* _tmp36_;
				_tmp36_ = t;
				bird_font_svg_parser_parse_path (self, _tmp36_, pl);
			}
			_tmp37_ = t;
			_tmp38_ = b_tag_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strcmp0 (_tmp39_, "g") == 0;
			_g_free0 (_tmp39_);
			if (_tmp40_) {
				BirdFontLayer* _tmp41_;
				BTag* _tmp42_;
				BirdFontLayer* _tmp43_;
				GeeArrayList* _tmp44_;
				BirdFontLayer* _tmp45_;
				_tmp41_ = bird_font_layer_new ();
				_g_object_unref0 (layer);
				layer = _tmp41_;
				_tmp42_ = t;
				_tmp43_ = layer;
				bird_font_svg_parser_parse_layer (self, _tmp42_, _tmp43_);
				_tmp44_ = pl->subgroups;
				_tmp45_ = layer;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
			}
			_tmp46_ = t;
			_tmp47_ = b_tag_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strcmp0 (_tmp48_, "polygon") == 0;
			_g_free0 (_tmp48_);
			if (_tmp49_) {
				BTag* _tmp50_;
				_tmp50_ = t;
				bird_font_svg_parser_parse_polygon (self, _tmp50_, pl);
			}
			_tmp51_ = t;
			_tmp52_ = b_tag_get_name (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strcmp0 (_tmp53_, "polyline") == 0;
			_g_free0 (_tmp53_);
			if (_tmp54_) {
				BTag* _tmp55_;
				_tmp55_ = t;
				bird_font_svg_parser_parse_polyline (self, _tmp55_, pl);
			}
			_tmp56_ = t;
			_tmp57_ = b_tag_get_name (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = g_strcmp0 (_tmp58_, "rect") == 0;
			_g_free0 (_tmp58_);
			if (_tmp59_) {
				BTag* _tmp60_;
				_tmp60_ = t;
				bird_font_svg_parser_parse_rect (self, _tmp60_, pl);
			}
			_tmp61_ = t;
			_tmp62_ = b_tag_get_name (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = g_strcmp0 (_tmp63_, "circle") == 0;
			_g_free0 (_tmp63_);
			if (_tmp64_) {
				BTag* _tmp65_;
				_tmp65_ = t;
				bird_font_svg_parser_parse_circle (self, _tmp65_, pl);
			}
			_tmp66_ = t;
			_tmp67_ = b_tag_get_name (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strcmp0 (_tmp68_, "ellipse") == 0;
			_g_free0 (_tmp68_);
			if (_tmp69_) {
				BTag* _tmp70_;
				_tmp70_ = t;
				bird_font_svg_parser_parse_ellipse (self, _tmp70_, pl);
			}
			_tmp71_ = t;
			_tmp72_ = b_tag_get_name (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strcmp0 (_tmp73_, "line") == 0;
			_g_free0 (_tmp73_);
			if (_tmp74_) {
				BTag* _tmp75_;
				_tmp75_ = t;
				bird_font_svg_parser_parse_line (self, _tmp75_, pl);
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_it);
	}
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp76_;
		BAttributes* _tmp77_;
		BAttributesIterator* _tmp78_;
		BAttributesIterator* _tmp79_;
		_tmp76_ = b_tag_get_attributes (tag);
		_tmp77_ = _tmp76_;
		_tmp78_ = b_attributes_iterator (_tmp77_);
		_tmp79_ = _tmp78_;
		_g_object_unref0 (_tmp77_);
		_attr_it = _tmp79_;
		while (TRUE) {
			BAttributesIterator* _tmp80_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp81_;
			BAttribute* _tmp82_;
			BAttribute* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gboolean _tmp86_;
			_tmp80_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp80_)) {
				break;
			}
			_tmp81_ = _attr_it;
			_tmp82_ = b_attributes_iterator_get (_tmp81_);
			attr = _tmp82_;
			_tmp83_ = attr;
			_tmp84_ = b_attribute_get_name (_tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_strcmp0 (_tmp85_, "transform") == 0;
			_g_free0 (_tmp85_);
			if (_tmp86_) {
				BAttribute* _tmp87_;
				gchar* _tmp88_;
				gchar* _tmp89_;
				_tmp87_ = attr;
				_tmp88_ = b_attribute_get_content (_tmp87_);
				_tmp89_ = _tmp88_;
				bird_font_svg_parser_transform (self, _tmp89_, pl);
				_g_free0 (_tmp89_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_g_object_unref0 (layer);
}

static void
bird_font_svg_parser_transform (BirdFontSvgParser* self,
                                const gchar* transform_functions,
                                BirdFontLayer* layer)
{
	BirdFontPathList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transform_functions != NULL);
	g_return_if_fail (layer != NULL);
	_tmp0_ = layer->paths;
	bird_font_svg_parser_transform_paths (self, transform_functions, _tmp0_);
	bird_font_svg_parser_transform_subgroups (self, transform_functions, layer);
}

static void
bird_font_svg_parser_transform_subgroups (BirdFontSvgParser* self,
                                          const gchar* transform_functions,
                                          BirdFontLayer* layer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (transform_functions != NULL);
	g_return_if_fail (layer != NULL);
	{
		GeeArrayList* _subgroup_list = NULL;
		GeeArrayList* _tmp0_;
		gint _subgroup_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _subgroup_index = 0;
		_tmp0_ = layer->subgroups;
		_subgroup_list = _tmp0_;
		_tmp1_ = _subgroup_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_subgroup_size = _tmp3_;
		_subgroup_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLayer* subgroup = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLayer* _tmp8_;
			_subgroup_index = _subgroup_index + 1;
			_tmp4_ = _subgroup_index;
			_tmp5_ = _subgroup_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _subgroup_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _subgroup_index);
			subgroup = (BirdFontLayer*) _tmp7_;
			_tmp8_ = subgroup;
			bird_font_svg_parser_transform (self, transform_functions, _tmp8_);
			_g_object_unref0 (subgroup);
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
bird_font_svg_parser_transform_paths (BirdFontSvgParser* self,
                                      const gchar* transform_functions,
                                      BirdFontPathList* pl)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	gchar** functions = NULL;
	gint functions_length1 = 0;
	gint _functions_size_ = 0;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (transform_functions != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = g_strdup (transform_functions);
	data = _tmp0_;
	while (TRUE) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = data;
		if (!(string_index_of (_tmp1_, "  ", 0) > -1)) {
			break;
		}
		_tmp2_ = data;
		_tmp3_ = string_replace (_tmp2_, "  ", " ");
		_g_free0 (data);
		data = _tmp3_;
	}
	_tmp4_ = data;
	g_return_if_fail (string_index_of (_tmp4_, ")", 0) > -1);
	_tmp5_ = data;
	_tmp6_ = string_replace (_tmp5_, ") ", "|");
	_g_free0 (data);
	data = _tmp6_;
	_tmp7_ = data;
	_tmp8_ = string_replace (_tmp7_, ")", "|");
	_g_free0 (data);
	data = _tmp8_;
	_tmp9_ = data;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "|", 0);
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_free), NULL);
	functions = _tmp11_;
	functions_length1 = _vala_array_length (_tmp10_);
	_functions_size_ = functions_length1;
	{
		gint i = 0;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = functions;
		_tmp12__length1 = functions_length1;
		i = _tmp12__length1 - 1;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ - 1;
				}
				_tmp13_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp15_ = functions;
				_tmp15__length1 = functions_length1;
				_tmp16_ = _tmp15_[i];
				if (g_str_has_prefix (_tmp16_, "translate")) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					_tmp17_ = functions;
					_tmp17__length1 = functions_length1;
					_tmp18_ = _tmp17_[i];
					bird_font_svg_parser_translate (self, _tmp18_, pl);
				}
				_tmp19_ = functions;
				_tmp19__length1 = functions_length1;
				_tmp20_ = _tmp19_[i];
				if (g_str_has_prefix (_tmp20_, "scale")) {
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					_tmp21_ = functions;
					_tmp21__length1 = functions_length1;
					_tmp22_ = _tmp21_[i];
					bird_font_svg_parser_scale (self, _tmp22_, pl);
				}
				_tmp23_ = functions;
				_tmp23__length1 = functions_length1;
				_tmp24_ = _tmp23_[i];
				if (g_str_has_prefix (_tmp24_, "matrix")) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					_tmp25_ = functions;
					_tmp25__length1 = functions_length1;
					_tmp26_ = _tmp25_[i];
					bird_font_svg_parser_matrix (self, _tmp26_, pl);
				}
			}
		}
	}
	functions = (_vala_array_free (functions, functions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}

/** @param path a path in the cartesian coordinate system
 * The other parameters are in the SVG coordinate system.
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_svg_parser_apply_matrix (BirdFontPath* path,
                                   gdouble a,
                                   gdouble b,
                                   gdouble c,
                                   gdouble d,
                                   gdouble e,
                                   gdouble f)
{
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp1_;
	g_return_if_fail (path != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp1_;
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _ep_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _ep_index = 0;
		_tmp2_ = bird_font_path_get_points (path);
		_tmp3_ = _tmp2_;
		_ep_list = _tmp3_;
		_tmp4_ = _ep_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_ep_size = _tmp6_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			_ep_index = _ep_index + 1;
			_tmp7_ = _ep_index;
			_tmp8_ = _ep_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _ep_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp10_;
			_tmp11_ = ep;
			bird_font_edit_point_set_tie_handles (_tmp11_, FALSE);
			_tmp12_ = ep;
			bird_font_edit_point_set_reflective_point (_tmp12_, FALSE);
			_g_object_unref0 (ep);
		}
	}
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _ep_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _ep_index = 0;
		_tmp13_ = bird_font_path_get_points (path);
		_tmp14_ = _tmp13_;
		_ep_list = _tmp14_;
		_tmp15_ = _ep_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_ep_size = _tmp17_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			BirdFontEditPoint* _tmp22_;
			BirdFontEditPointHandle* _tmp23_;
			BirdFontEditPointHandle* left = NULL;
			BirdFontEditPoint* _tmp24_;
			BirdFontEditPointHandle* _tmp25_;
			BirdFontEditPointHandle* _tmp26_;
			gboolean _tmp27_ = FALSE;
			BirdFontEditPointHandle* _tmp28_;
			BirdFontEditPoint* _tmp33_;
			BirdFontFont* _tmp34_;
			BirdFontEditPoint* _tmp35_;
			gdouble _tmp36_;
			gdouble _tmp37_;
			BirdFontEditPoint* _tmp38_;
			BirdFontEditPoint* _tmp39_;
			gdouble _tmp40_;
			gdouble _tmp41_;
			BirdFontGlyph* _tmp42_;
			gdouble _tmp43_;
			gdouble _tmp44_;
			BirdFontEditPoint* _tmp45_;
			gdouble _tmp46_;
			gdouble _tmp47_;
			BirdFontEditPoint* _tmp48_;
			gdouble _tmp49_;
			gdouble _tmp50_;
			BirdFontEditPoint* _tmp51_;
			gdouble _tmp52_;
			gdouble _tmp53_;
			BirdFontEditPoint* _tmp54_;
			gdouble _tmp55_;
			gdouble _tmp56_;
			BirdFontEditPoint* _tmp57_;
			BirdFontEditPoint* _tmp58_;
			BirdFontEditPoint* _tmp59_;
			BirdFontFont* _tmp60_;
			BirdFontEditPoint* _tmp61_;
			gdouble _tmp62_;
			gdouble _tmp63_;
			BirdFontEditPoint* _tmp64_;
			BirdFontEditPoint* _tmp65_;
			gdouble _tmp66_;
			gdouble _tmp67_;
			BirdFontGlyph* _tmp68_;
			gdouble _tmp69_;
			gdouble _tmp70_;
			_ep_index = _ep_index + 1;
			_tmp18_ = _ep_index;
			_tmp19_ = _ep_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _ep_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp21_;
			_tmp22_ = ep;
			_tmp23_ = bird_font_edit_point_get_right_handle (_tmp22_);
			bird_font_svg_parser_apply_matrix_on_handle (_tmp23_, a, b, c, d, e, f);
			_tmp24_ = ep;
			_tmp25_ = bird_font_edit_point_get_left_handle (_tmp24_);
			_tmp26_ = _g_object_ref0 (_tmp25_);
			left = _tmp26_;
			_tmp28_ = left;
			if (_tmp28_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
				_tmp27_ = TRUE;
			} else {
				BirdFontEditPointHandle* _tmp29_;
				_tmp29_ = left;
				_tmp27_ = _tmp29_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
			}
			if (_tmp27_) {
				BirdFontEditPoint* _tmp30_;
				BirdFontEditPointHandle* _tmp31_;
				_tmp30_ = ep;
				_tmp31_ = bird_font_edit_point_get_right_handle (_tmp30_);
				bird_font_edit_point_handle_process_connected_handle (_tmp31_);
			} else {
				BirdFontEditPointHandle* _tmp32_;
				_tmp32_ = left;
				bird_font_svg_parser_apply_matrix_on_handle (_tmp32_, a, b, c, d, e, f);
			}
			_tmp33_ = ep;
			_tmp34_ = font;
			_tmp35_ = ep;
			_tmp36_ = bird_font_edit_point_get_independent_y (_tmp35_);
			_tmp37_ = _tmp36_;
			bird_font_edit_point_set_independent_y (_tmp33_, _tmp34_->top_position - _tmp37_);
			_tmp38_ = ep;
			_tmp39_ = ep;
			_tmp40_ = bird_font_edit_point_get_independent_x (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = glyph;
			_tmp43_ = bird_font_glyph_get_left_limit (_tmp42_);
			_tmp44_ = _tmp43_;
			bird_font_edit_point_set_independent_x (_tmp39_, _tmp41_ - _tmp44_);
			_tmp45_ = ep;
			_tmp46_ = bird_font_edit_point_get_independent_x (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = ep;
			_tmp49_ = bird_font_edit_point_get_independent_y (_tmp48_);
			_tmp50_ = _tmp49_;
			dx = ((a * _tmp47_) + (c * _tmp50_)) + e;
			_tmp51_ = ep;
			_tmp52_ = bird_font_edit_point_get_independent_x (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = ep;
			_tmp55_ = bird_font_edit_point_get_independent_y (_tmp54_);
			_tmp56_ = _tmp55_;
			dy = ((b * _tmp53_) + (d * _tmp56_)) + f;
			_tmp57_ = ep;
			bird_font_edit_point_set_independent_x (_tmp57_, dx);
			_tmp58_ = ep;
			bird_font_edit_point_set_independent_y (_tmp58_, dy);
			_tmp59_ = ep;
			_tmp60_ = font;
			_tmp61_ = ep;
			_tmp62_ = bird_font_edit_point_get_independent_y (_tmp61_);
			_tmp63_ = _tmp62_;
			bird_font_edit_point_set_independent_y (_tmp59_, _tmp60_->top_position - _tmp63_);
			_tmp64_ = ep;
			_tmp65_ = ep;
			_tmp66_ = bird_font_edit_point_get_independent_x (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = glyph;
			_tmp69_ = bird_font_glyph_get_left_limit (_tmp68_);
			_tmp70_ = _tmp69_;
			bird_font_edit_point_set_independent_x (_tmp65_, _tmp67_ + _tmp70_);
			_g_object_unref0 (left);
			_g_object_unref0 (ep);
		}
	}
	_g_object_unref0 (glyph);
	_g_object_unref0 (font);
}

void
bird_font_svg_parser_apply_matrix_on_handle (BirdFontEditPointHandle* h,
                                             gdouble a,
                                             gdouble b,
                                             gdouble c,
                                             gdouble d,
                                             gdouble e,
                                             gdouble f)
{
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	gdouble _tmp21_;
	g_return_if_fail (h != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp1_;
	_tmp2_ = bird_font_edit_point_handle_get_y (h);
	_tmp3_ = _tmp2_;
	bird_font_edit_point_handle_set_y (h, font->top_position - _tmp3_);
	_tmp4_ = bird_font_edit_point_handle_get_x (h);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_glyph_get_left_limit (glyph);
	_tmp7_ = _tmp6_;
	bird_font_edit_point_handle_set_x (h, _tmp5_ - _tmp7_);
	_tmp8_ = bird_font_edit_point_handle_get_x (h);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_edit_point_handle_get_y (h);
	_tmp11_ = _tmp10_;
	dx = ((a * _tmp9_) + (c * _tmp11_)) + e;
	_tmp12_ = bird_font_edit_point_handle_get_x (h);
	_tmp13_ = _tmp12_;
	_tmp14_ = bird_font_edit_point_handle_get_y (h);
	_tmp15_ = _tmp14_;
	dy = ((b * _tmp13_) + (d * _tmp15_)) + f;
	bird_font_edit_point_handle_set_x (h, dx);
	bird_font_edit_point_handle_set_y (h, dy);
	_tmp16_ = bird_font_edit_point_handle_get_y (h);
	_tmp17_ = _tmp16_;
	bird_font_edit_point_handle_set_y (h, font->top_position - _tmp17_);
	_tmp18_ = bird_font_edit_point_handle_get_x (h);
	_tmp19_ = _tmp18_;
	_tmp20_ = bird_font_glyph_get_left_limit (glyph);
	_tmp21_ = _tmp20_;
	bird_font_edit_point_handle_set_x (h, _tmp19_ + _tmp21_);
	_g_object_unref0 (glyph);
	_g_object_unref0 (font);
}

static void
bird_font_svg_parser_matrix (BirdFontSvgParser* self,
                             const gchar* function,
                             BirdFontPathList* pl)
{
	gchar* parameters = NULL;
	gchar* _tmp0_;
	gchar** p = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint p_length1;
	gint _p_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_parser_get_transform_parameters (self, function);
	parameters = _tmp0_;
	_tmp1_ = parameters;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	p = _tmp3_;
	p_length1 = _vala_array_length (_tmp2_);
	_p_size_ = p_length1;
	_tmp4_ = p;
	_tmp4__length1 = p_length1;
	if (_tmp4__length1 != 6) {
		g_warning ("SvgParser.vala:389: Expecting six parameters for matrix transformation" \
".");
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (parameters);
		return;
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp5_;
		gint _path_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _path_index = 0;
		_tmp5_ = pl->paths;
		_path_list = _tmp5_;
		_tmp6_ = _path_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_path_size = _tmp8_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontPath* _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			const gchar* _tmp23_;
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			_path_index = _path_index + 1;
			_tmp9_ = _path_index;
			_tmp10_ = _path_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _path_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _path_index);
			path = (BirdFontPath*) _tmp12_;
			_tmp13_ = path;
			_tmp14_ = p;
			_tmp14__length1 = p_length1;
			_tmp15_ = _tmp14_[0];
			_tmp16_ = p;
			_tmp16__length1 = p_length1;
			_tmp17_ = _tmp16_[1];
			_tmp18_ = p;
			_tmp18__length1 = p_length1;
			_tmp19_ = _tmp18_[2];
			_tmp20_ = p;
			_tmp20__length1 = p_length1;
			_tmp21_ = _tmp20_[3];
			_tmp22_ = p;
			_tmp22__length1 = p_length1;
			_tmp23_ = _tmp22_[4];
			_tmp24_ = p;
			_tmp24__length1 = p_length1;
			_tmp25_ = _tmp24_[5];
			bird_font_svg_parser_apply_matrix (_tmp13_, bird_font_svg_parser_parse_double (_tmp15_), bird_font_svg_parser_parse_double (_tmp17_), bird_font_svg_parser_parse_double (_tmp19_), bird_font_svg_parser_parse_double (_tmp21_), bird_font_svg_parser_parse_double (_tmp23_), bird_font_svg_parser_parse_double (_tmp25_));
			_g_object_unref0 (path);
		}
	}
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parameters);
}

static void
bird_font_svg_parser_scale (BirdFontSvgParser* self,
                            const gchar* function,
                            BirdFontPathList* pl)
{
	gchar* parameters = NULL;
	gchar* _tmp0_;
	gchar** p = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint p_length1;
	gint _p_size_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_parser_get_transform_parameters (self, function);
	parameters = _tmp0_;
	_tmp1_ = parameters;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	p = _tmp3_;
	p_length1 = _vala_array_length (_tmp2_);
	_p_size_ = p_length1;
	x = (gdouble) 1;
	y = (gdouble) 1;
	_tmp4_ = p;
	_tmp4__length1 = p_length1;
	if (_tmp4__length1 > 0) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		_tmp5_ = p;
		_tmp5__length1 = p_length1;
		_tmp6_ = _tmp5_[0];
		x = bird_font_svg_parser_parse_double (_tmp6_);
	}
	_tmp7_ = p;
	_tmp7__length1 = p_length1;
	if (_tmp7__length1 > 1) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = p;
		_tmp8__length1 = p_length1;
		_tmp9_ = _tmp8_[1];
		y = bird_font_svg_parser_parse_double (_tmp9_);
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp10_;
		gint _path_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _path_index = 0;
		_tmp10_ = pl->paths;
		_path_list = _tmp10_;
		_tmp11_ = _path_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_path_size = _tmp13_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontPath* _tmp18_;
			_path_index = _path_index + 1;
			_tmp14_ = _path_index;
			_tmp15_ = _path_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _path_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _path_index);
			path = (BirdFontPath*) _tmp17_;
			_tmp18_ = path;
			bird_font_path_scale (_tmp18_, -x, y);
			_g_object_unref0 (path);
		}
	}
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parameters);
}

static void
bird_font_svg_parser_translate (BirdFontSvgParser* self,
                                const gchar* function,
                                BirdFontPathList* pl)
{
	gchar* parameters = NULL;
	gchar* _tmp0_;
	gchar** p = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint p_length1;
	gint _p_size_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_parser_get_transform_parameters (self, function);
	parameters = _tmp0_;
	_tmp1_ = parameters;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	p = _tmp3_;
	p_length1 = _vala_array_length (_tmp2_);
	_p_size_ = p_length1;
	x = (gdouble) 0;
	y = (gdouble) 0;
	_tmp4_ = p;
	_tmp4__length1 = p_length1;
	if (_tmp4__length1 > 0) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		_tmp5_ = p;
		_tmp5__length1 = p_length1;
		_tmp6_ = _tmp5_[0];
		x = bird_font_svg_parser_parse_double (_tmp6_);
	}
	_tmp7_ = p;
	_tmp7__length1 = p_length1;
	if (_tmp7__length1 > 1) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = p;
		_tmp8__length1 = p_length1;
		_tmp9_ = _tmp8_[1];
		y = bird_font_svg_parser_parse_double (_tmp9_);
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp10_;
		gint _path_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _path_index = 0;
		_tmp10_ = pl->paths;
		_path_list = _tmp10_;
		_tmp11_ = _path_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_path_size = _tmp13_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontPath* _tmp18_;
			_path_index = _path_index + 1;
			_tmp14_ = _path_index;
			_tmp15_ = _path_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _path_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _path_index);
			path = (BirdFontPath*) _tmp17_;
			_tmp18_ = path;
			bird_font_path_move (_tmp18_, x, -y);
			_g_object_unref0 (path);
		}
	}
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parameters);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
bird_font_svg_parser_get_transform_parameters (BirdFontSvgParser* self,
                                               const gchar* function)
{
	gint i = 0;
	gchar* param = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = g_strdup ("");
	param = _tmp0_;
	i = string_index_of (function, "(", 0);
	_tmp1_ = param;
	g_return_val_if_fail (i != -1, _tmp1_);
	_tmp2_ = string_substring (function, (glong) i, (glong) -1);
	_g_free0 (param);
	param = _tmp2_;
	_tmp3_ = param;
	_tmp4_ = string_replace (_tmp3_, "(", "");
	_g_free0 (param);
	param = _tmp4_;
	_tmp5_ = param;
	_tmp6_ = string_replace (_tmp5_, "\n", " ");
	_g_free0 (param);
	param = _tmp6_;
	_tmp7_ = param;
	_tmp8_ = string_replace (_tmp7_, "\t", " ");
	_g_free0 (param);
	param = _tmp8_;
	_tmp9_ = param;
	_tmp10_ = string_replace (_tmp9_, ",", " ");
	_g_free0 (param);
	param = _tmp10_;
	while (TRUE) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = param;
		if (!(string_index_of (_tmp11_, "  ", 0) > -1)) {
			break;
		}
		_tmp12_ = param;
		_tmp13_ = string_replace (_tmp12_, "  ", " ");
		_g_free0 (param);
		param = _tmp13_;
	}
	_tmp14_ = param;
	_tmp15_ = string_strip (_tmp14_);
	result = _tmp15_;
	_g_free0 (param);
	return result;
}

static void
bird_font_svg_parser_parse_circle (BirdFontSvgParser* self,
                                   BTag* tag,
                                   BirdFontLayer* pl)
{
	BirdFontPath* p = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble r = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontPathList* npl = NULL;
	BirdFontBezierPoints** bezier_points = NULL;
	gint bezier_points_length1 = 0;
	gint _bezier_points_size_ = 0;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp0_;
	gboolean hidden = FALSE;
	BirdFontPathList* _tmp1_;
	BAttributes* _tmp38_;
	BAttributes* _tmp39_;
	BirdFontSvgStyle* _tmp40_;
	BirdFontBezierPoints** _tmp41_;
	BirdFontBezierPoints** _tmp42_;
	gint _tmp42__length1;
	BirdFontBezierPoints* _tmp43_;
	BirdFontBezierPoints** _tmp44_;
	gint _tmp44__length1;
	BirdFontBezierPoints* _tmp45_;
	BirdFontBezierPoints** _tmp46_;
	gint _tmp46__length1;
	BirdFontBezierPoints* _tmp47_;
	BirdFontBezierPoints** _tmp48_;
	gint _tmp48__length1;
	BirdFontBezierPoints* _tmp49_;
	BirdFontGlyph* _tmp50_;
	BirdFontBezierPoints** _tmp51_;
	gint _tmp51__length1;
	BirdFontGlyph* _tmp52_;
	BirdFontBezierPoints** _tmp53_;
	gint _tmp53__length1;
	BirdFontBezierPoints* _tmp54_;
	BirdFontBezierPoints** _tmp55_;
	gint _tmp55__length1;
	BirdFontBezierPoints* _tmp56_;
	BirdFontPath* _tmp57_;
	BirdFontPathList* _tmp58_;
	BirdFontPath* _tmp59_;
	BirdFontSvgStyle* _tmp75_;
	BirdFontPathList* _tmp76_;
	BirdFontPathList* _tmp77_;
	BirdFontPathList* _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_style_new ();
	style = _tmp0_;
	hidden = FALSE;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (npl);
	npl = _tmp1_;
	x = (gdouble) 0;
	y = (gdouble) 0;
	r = (gdouble) 0;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attr_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp30_ = FALSE;
			BAttribute* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gboolean _tmp34_;
			_tmp6_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attr_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attr = _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "cx") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				x = bird_font_svg_parser_parse_double (_tmp15_);
				_g_free0 (_tmp15_);
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "cy") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BAttribute* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = attr;
				_tmp21_ = b_attribute_get_content (_tmp20_);
				_tmp22_ = _tmp21_;
				y = -bird_font_svg_parser_parse_double (_tmp22_);
				_g_free0 (_tmp22_);
			}
			_tmp23_ = attr;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "r") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BAttribute* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = attr;
				_tmp28_ = b_attribute_get_content (_tmp27_);
				_tmp29_ = _tmp28_;
				r = bird_font_svg_parser_parse_double (_tmp29_);
				_g_free0 (_tmp29_);
			}
			_tmp31_ = attr;
			_tmp32_ = b_attribute_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strcmp0 (_tmp33_, "display") == 0;
			_g_free0 (_tmp33_);
			if (_tmp34_) {
				BAttribute* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp35_ = attr;
				_tmp36_ = b_attribute_get_content (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp30_ = g_strcmp0 (_tmp37_, "none") == 0;
				_g_free0 (_tmp37_);
			} else {
				_tmp30_ = FALSE;
			}
			if (_tmp30_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp38_ = b_tag_get_attributes (tag);
	_tmp39_ = _tmp38_;
	_tmp40_ = bird_font_svg_style_parse (_tmp39_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp40_;
	_g_object_unref0 (_tmp39_);
	if (hidden) {
		_bird_font_svg_style_unref0 (style);
		bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
		_g_object_unref0 (npl);
		_g_object_unref0 (g);
		_g_object_unref0 (p);
		return;
	}
	_tmp41_ = g_new0 (BirdFontBezierPoints*, 1 + 1);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	bezier_points = _tmp41_;
	bezier_points_length1 = 1;
	_bezier_points_size_ = bezier_points_length1;
	_tmp42_ = bezier_points;
	_tmp42__length1 = bezier_points_length1;
	_tmp43_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp42_[0]);
	_tmp42_[0] = _tmp43_;
	_tmp44_ = bezier_points;
	_tmp44__length1 = bezier_points_length1;
	_tmp45_ = _tmp44_[0];
	_tmp45_->type = (gunichar) 'L';
	_tmp46_ = bezier_points;
	_tmp46__length1 = bezier_points_length1;
	_tmp47_ = _tmp46_[0];
	_tmp47_->x0 = x;
	_tmp48_ = bezier_points;
	_tmp48__length1 = bezier_points_length1;
	_tmp49_ = _tmp48_[0];
	_tmp49_->y0 = y;
	_tmp50_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp50_;
	_tmp51_ = bezier_points;
	_tmp51__length1 = bezier_points_length1;
	_tmp52_ = g;
	bird_font_svg_parser_move_and_resize (self, _tmp51_, (gint) _tmp51__length1, 1, FALSE, (gdouble) 1, _tmp52_);
	_tmp53_ = bezier_points;
	_tmp53__length1 = bezier_points_length1;
	_tmp54_ = _tmp53_[0];
	_tmp55_ = bezier_points;
	_tmp55__length1 = bezier_points_length1;
	_tmp56_ = _tmp55_[0];
	_tmp57_ = bird_font_circle_tool_create_circle (_tmp54_->x0, _tmp56_->y0, r, BIRD_FONT_POINT_TYPE_CUBIC);
	_g_object_unref0 (p);
	p = _tmp57_;
	_tmp58_ = npl;
	_tmp59_ = p;
	bird_font_path_list_add (_tmp58_, _tmp59_);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp60_;
		BAttributes* _tmp61_;
		BAttributesIterator* _tmp62_;
		BAttributesIterator* _tmp63_;
		_tmp60_ = b_tag_get_attributes (tag);
		_tmp61_ = _tmp60_;
		_tmp62_ = b_attributes_iterator (_tmp61_);
		_tmp63_ = _tmp62_;
		_g_object_unref0 (_tmp61_);
		_attr_it = _tmp63_;
		while (TRUE) {
			BAttributesIterator* _tmp64_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp65_;
			BAttribute* _tmp66_;
			BAttribute* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gboolean _tmp70_;
			_tmp64_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp64_)) {
				break;
			}
			_tmp65_ = _attr_it;
			_tmp66_ = b_attributes_iterator_get (_tmp65_);
			attr = _tmp66_;
			_tmp67_ = attr;
			_tmp68_ = b_attribute_get_name (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strcmp0 (_tmp69_, "transform") == 0;
			_g_free0 (_tmp69_);
			if (_tmp70_) {
				BAttribute* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				BirdFontPathList* _tmp74_;
				_tmp71_ = attr;
				_tmp72_ = b_attribute_get_content (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = npl;
				bird_font_svg_parser_transform_paths (self, _tmp73_, _tmp74_);
				_g_free0 (_tmp73_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp75_ = style;
	_tmp76_ = npl;
	bird_font_svg_style_apply (_tmp75_, _tmp76_);
	_tmp77_ = pl->paths;
	_tmp78_ = npl;
	bird_font_path_list_append (_tmp77_, _tmp78_);
	_bird_font_svg_style_unref0 (style);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	_g_object_unref0 (npl);
	_g_object_unref0 (g);
	_g_object_unref0 (p);
}

static void
bird_font_svg_parser_parse_ellipse (BirdFontSvgParser* self,
                                    BTag* tag,
                                    BirdFontLayer* pl)
{
	BirdFontPath* p = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontPathList* npl = NULL;
	BirdFontBezierPoints** bezier_points = NULL;
	gint bezier_points_length1 = 0;
	gint _bezier_points_size_ = 0;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp0_;
	gboolean hidden = FALSE;
	BirdFontPathList* _tmp1_;
	BAttributes* _tmp45_;
	BAttributes* _tmp46_;
	BirdFontSvgStyle* _tmp47_;
	BirdFontBezierPoints** _tmp48_;
	BirdFontBezierPoints** _tmp49_;
	gint _tmp49__length1;
	BirdFontBezierPoints* _tmp50_;
	BirdFontBezierPoints** _tmp51_;
	gint _tmp51__length1;
	BirdFontBezierPoints* _tmp52_;
	BirdFontBezierPoints** _tmp53_;
	gint _tmp53__length1;
	BirdFontBezierPoints* _tmp54_;
	BirdFontBezierPoints** _tmp55_;
	gint _tmp55__length1;
	BirdFontBezierPoints* _tmp56_;
	BirdFontGlyph* _tmp57_;
	BirdFontBezierPoints** _tmp58_;
	gint _tmp58__length1;
	BirdFontGlyph* _tmp59_;
	BirdFontBezierPoints** _tmp60_;
	gint _tmp60__length1;
	BirdFontBezierPoints* _tmp61_;
	BirdFontBezierPoints** _tmp62_;
	gint _tmp62__length1;
	BirdFontBezierPoints* _tmp63_;
	BirdFontPath* _tmp64_;
	BirdFontPathList* _tmp65_;
	BirdFontPath* _tmp66_;
	BirdFontSvgStyle* _tmp82_;
	BirdFontPathList* _tmp83_;
	BirdFontPathList* _tmp84_;
	BirdFontPathList* _tmp85_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_style_new ();
	style = _tmp0_;
	hidden = FALSE;
	_tmp1_ = bird_font_path_list_new ();
	_g_object_unref0 (npl);
	npl = _tmp1_;
	x = (gdouble) 0;
	y = (gdouble) 0;
	rx = (gdouble) 0;
	ry = (gdouble) 0;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attr_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BAttribute* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp37_ = FALSE;
			BAttribute* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_;
			_tmp6_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attr_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attr = _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "cx") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				x = bird_font_svg_parser_parse_double (_tmp15_);
				_g_free0 (_tmp15_);
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "cy") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BAttribute* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = attr;
				_tmp21_ = b_attribute_get_content (_tmp20_);
				_tmp22_ = _tmp21_;
				y = -bird_font_svg_parser_parse_double (_tmp22_);
				_g_free0 (_tmp22_);
			}
			_tmp23_ = attr;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "rx") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BAttribute* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = attr;
				_tmp28_ = b_attribute_get_content (_tmp27_);
				_tmp29_ = _tmp28_;
				rx = bird_font_svg_parser_parse_double (_tmp29_);
				_g_free0 (_tmp29_);
			}
			_tmp30_ = attr;
			_tmp31_ = b_attribute_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strcmp0 (_tmp32_, "ry") == 0;
			_g_free0 (_tmp32_);
			if (_tmp33_) {
				BAttribute* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp34_ = attr;
				_tmp35_ = b_attribute_get_content (_tmp34_);
				_tmp36_ = _tmp35_;
				ry = bird_font_svg_parser_parse_double (_tmp36_);
				_g_free0 (_tmp36_);
			}
			_tmp38_ = attr;
			_tmp39_ = b_attribute_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strcmp0 (_tmp40_, "display") == 0;
			_g_free0 (_tmp40_);
			if (_tmp41_) {
				BAttribute* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp42_ = attr;
				_tmp43_ = b_attribute_get_content (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp37_ = g_strcmp0 (_tmp44_, "none") == 0;
				_g_free0 (_tmp44_);
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp45_ = b_tag_get_attributes (tag);
	_tmp46_ = _tmp45_;
	_tmp47_ = bird_font_svg_style_parse (_tmp46_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp47_;
	_g_object_unref0 (_tmp46_);
	if (hidden) {
		_bird_font_svg_style_unref0 (style);
		bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
		_g_object_unref0 (npl);
		_g_object_unref0 (g);
		_g_object_unref0 (p);
		return;
	}
	_tmp48_ = g_new0 (BirdFontBezierPoints*, 1 + 1);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	bezier_points = _tmp48_;
	bezier_points_length1 = 1;
	_bezier_points_size_ = bezier_points_length1;
	_tmp49_ = bezier_points;
	_tmp49__length1 = bezier_points_length1;
	_tmp50_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp49_[0]);
	_tmp49_[0] = _tmp50_;
	_tmp51_ = bezier_points;
	_tmp51__length1 = bezier_points_length1;
	_tmp52_ = _tmp51_[0];
	_tmp52_->type = (gunichar) 'L';
	_tmp53_ = bezier_points;
	_tmp53__length1 = bezier_points_length1;
	_tmp54_ = _tmp53_[0];
	_tmp54_->x0 = x;
	_tmp55_ = bezier_points;
	_tmp55__length1 = bezier_points_length1;
	_tmp56_ = _tmp55_[0];
	_tmp56_->y0 = y;
	_tmp57_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp57_;
	_tmp58_ = bezier_points;
	_tmp58__length1 = bezier_points_length1;
	_tmp59_ = g;
	bird_font_svg_parser_move_and_resize (self, _tmp58_, (gint) _tmp58__length1, 1, FALSE, (gdouble) 1, _tmp59_);
	_tmp60_ = bezier_points;
	_tmp60__length1 = bezier_points_length1;
	_tmp61_ = _tmp60_[0];
	_tmp62_ = bezier_points;
	_tmp62__length1 = bezier_points_length1;
	_tmp63_ = _tmp62_[0];
	_tmp64_ = bird_font_circle_tool_create_ellipse (_tmp61_->x0, _tmp63_->y0, rx, ry, BIRD_FONT_POINT_TYPE_CUBIC);
	_g_object_unref0 (p);
	p = _tmp64_;
	_tmp65_ = npl;
	_tmp66_ = p;
	bird_font_path_list_add (_tmp65_, _tmp66_);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp67_;
		BAttributes* _tmp68_;
		BAttributesIterator* _tmp69_;
		BAttributesIterator* _tmp70_;
		_tmp67_ = b_tag_get_attributes (tag);
		_tmp68_ = _tmp67_;
		_tmp69_ = b_attributes_iterator (_tmp68_);
		_tmp70_ = _tmp69_;
		_g_object_unref0 (_tmp68_);
		_attr_it = _tmp70_;
		while (TRUE) {
			BAttributesIterator* _tmp71_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp72_;
			BAttribute* _tmp73_;
			BAttribute* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			gboolean _tmp77_;
			_tmp71_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp71_)) {
				break;
			}
			_tmp72_ = _attr_it;
			_tmp73_ = b_attributes_iterator_get (_tmp72_);
			attr = _tmp73_;
			_tmp74_ = attr;
			_tmp75_ = b_attribute_get_name (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strcmp0 (_tmp76_, "transform") == 0;
			_g_free0 (_tmp76_);
			if (_tmp77_) {
				BAttribute* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				BirdFontPathList* _tmp81_;
				_tmp78_ = attr;
				_tmp79_ = b_attribute_get_content (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = npl;
				bird_font_svg_parser_transform_paths (self, _tmp80_, _tmp81_);
				_g_free0 (_tmp80_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp82_ = style;
	_tmp83_ = npl;
	bird_font_svg_style_apply (_tmp82_, _tmp83_);
	_tmp84_ = pl->paths;
	_tmp85_ = npl;
	bird_font_path_list_append (_tmp84_, _tmp85_);
	_bird_font_svg_style_unref0 (style);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	_g_object_unref0 (npl);
	_g_object_unref0 (g);
	_g_object_unref0 (p);
}

static void
bird_font_svg_parser_parse_line (BirdFontSvgParser* self,
                                 BTag* tag,
                                 BirdFontLayer* pl)
{
	BirdFontPath* p = NULL;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	BirdFontBezierPoints** bezier_points = NULL;
	gint bezier_points_length1 = 0;
	gint _bezier_points_size_ = 0;
	BirdFontGlyph* g = NULL;
	BirdFontPathList* npl = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp1_;
	gboolean hidden = FALSE;
	BAttributes* _tmp45_;
	BAttributes* _tmp46_;
	BirdFontSvgStyle* _tmp47_;
	BirdFontBezierPoints** _tmp48_;
	BirdFontBezierPoints** _tmp49_;
	gint _tmp49__length1;
	BirdFontBezierPoints* _tmp50_;
	BirdFontBezierPoints** _tmp51_;
	gint _tmp51__length1;
	BirdFontBezierPoints* _tmp52_;
	BirdFontBezierPoints** _tmp53_;
	gint _tmp53__length1;
	BirdFontBezierPoints* _tmp54_;
	BirdFontBezierPoints** _tmp55_;
	gint _tmp55__length1;
	BirdFontBezierPoints* _tmp56_;
	BirdFontBezierPoints** _tmp57_;
	gint _tmp57__length1;
	BirdFontBezierPoints* _tmp58_;
	BirdFontBezierPoints** _tmp59_;
	gint _tmp59__length1;
	BirdFontBezierPoints* _tmp60_;
	BirdFontBezierPoints** _tmp61_;
	gint _tmp61__length1;
	BirdFontBezierPoints* _tmp62_;
	BirdFontBezierPoints** _tmp63_;
	gint _tmp63__length1;
	BirdFontBezierPoints* _tmp64_;
	BirdFontGlyph* _tmp65_;
	BirdFontBezierPoints** _tmp66_;
	gint _tmp66__length1;
	BirdFontGlyph* _tmp67_;
	BirdFontPath* _tmp68_;
	BirdFontPath* _tmp69_;
	BirdFontBezierPoints** _tmp70_;
	gint _tmp70__length1;
	BirdFontBezierPoints* _tmp71_;
	BirdFontBezierPoints** _tmp72_;
	gint _tmp72__length1;
	BirdFontBezierPoints* _tmp73_;
	BirdFontEditPoint* _tmp74_;
	BirdFontEditPoint* _tmp75_;
	BirdFontPath* _tmp76_;
	BirdFontBezierPoints** _tmp77_;
	gint _tmp77__length1;
	BirdFontBezierPoints* _tmp78_;
	BirdFontBezierPoints** _tmp79_;
	gint _tmp79__length1;
	BirdFontBezierPoints* _tmp80_;
	BirdFontEditPoint* _tmp81_;
	BirdFontEditPoint* _tmp82_;
	BirdFontPath* _tmp83_;
	BirdFontPath* _tmp84_;
	BirdFontPath* _tmp85_;
	BirdFontPathList* _tmp86_;
	BirdFontPath* _tmp87_;
	BirdFontSvgStyle* _tmp103_;
	BirdFontPathList* _tmp104_;
	BirdFontPathList* _tmp105_;
	BirdFontPathList* _tmp106_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_path_list_new ();
	npl = _tmp0_;
	_tmp1_ = bird_font_svg_style_new ();
	style = _tmp1_;
	hidden = FALSE;
	x1 = (gdouble) 0;
	y1 = (gdouble) 0;
	x2 = (gdouble) 0;
	y2 = (gdouble) 0;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attr_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BAttribute* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp37_ = FALSE;
			BAttribute* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_;
			_tmp6_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attr_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attr = _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "x1") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				x1 = bird_font_svg_parser_parse_double (_tmp15_);
				_g_free0 (_tmp15_);
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "y1") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BAttribute* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = attr;
				_tmp21_ = b_attribute_get_content (_tmp20_);
				_tmp22_ = _tmp21_;
				y1 = -bird_font_svg_parser_parse_double (_tmp22_);
				_g_free0 (_tmp22_);
			}
			_tmp23_ = attr;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "x2") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BAttribute* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = attr;
				_tmp28_ = b_attribute_get_content (_tmp27_);
				_tmp29_ = _tmp28_;
				x2 = bird_font_svg_parser_parse_double (_tmp29_);
				_g_free0 (_tmp29_);
			}
			_tmp30_ = attr;
			_tmp31_ = b_attribute_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strcmp0 (_tmp32_, "xy") == 0;
			_g_free0 (_tmp32_);
			if (_tmp33_) {
				BAttribute* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp34_ = attr;
				_tmp35_ = b_attribute_get_content (_tmp34_);
				_tmp36_ = _tmp35_;
				y2 = -bird_font_svg_parser_parse_double (_tmp36_);
				_g_free0 (_tmp36_);
			}
			_tmp38_ = attr;
			_tmp39_ = b_attribute_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strcmp0 (_tmp40_, "display") == 0;
			_g_free0 (_tmp40_);
			if (_tmp41_) {
				BAttribute* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp42_ = attr;
				_tmp43_ = b_attribute_get_content (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp37_ = g_strcmp0 (_tmp44_, "none") == 0;
				_g_free0 (_tmp44_);
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp45_ = b_tag_get_attributes (tag);
	_tmp46_ = _tmp45_;
	_tmp47_ = bird_font_svg_style_parse (_tmp46_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp47_;
	_g_object_unref0 (_tmp46_);
	if (hidden) {
		_bird_font_svg_style_unref0 (style);
		_g_object_unref0 (npl);
		_g_object_unref0 (g);
		bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
		_g_object_unref0 (p);
		return;
	}
	_tmp48_ = g_new0 (BirdFontBezierPoints*, 2 + 1);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	bezier_points = _tmp48_;
	bezier_points_length1 = 2;
	_bezier_points_size_ = bezier_points_length1;
	_tmp49_ = bezier_points;
	_tmp49__length1 = bezier_points_length1;
	_tmp50_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp49_[0]);
	_tmp49_[0] = _tmp50_;
	_tmp51_ = bezier_points;
	_tmp51__length1 = bezier_points_length1;
	_tmp52_ = _tmp51_[0];
	_tmp52_->type = (gunichar) 'L';
	_tmp53_ = bezier_points;
	_tmp53__length1 = bezier_points_length1;
	_tmp54_ = _tmp53_[0];
	_tmp54_->x0 = x1;
	_tmp55_ = bezier_points;
	_tmp55__length1 = bezier_points_length1;
	_tmp56_ = _tmp55_[0];
	_tmp56_->y0 = y1;
	_tmp57_ = bezier_points;
	_tmp57__length1 = bezier_points_length1;
	_tmp58_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp57_[1]);
	_tmp57_[1] = _tmp58_;
	_tmp59_ = bezier_points;
	_tmp59__length1 = bezier_points_length1;
	_tmp60_ = _tmp59_[1];
	_tmp60_->type = (gunichar) 'L';
	_tmp61_ = bezier_points;
	_tmp61__length1 = bezier_points_length1;
	_tmp62_ = _tmp61_[1];
	_tmp62_->x0 = x2;
	_tmp63_ = bezier_points;
	_tmp63__length1 = bezier_points_length1;
	_tmp64_ = _tmp63_[1];
	_tmp64_->y0 = y2;
	_tmp65_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp65_;
	_tmp66_ = bezier_points;
	_tmp66__length1 = bezier_points_length1;
	_tmp67_ = g;
	bird_font_svg_parser_move_and_resize (self, _tmp66_, (gint) _tmp66__length1, 2, FALSE, (gdouble) 1, _tmp67_);
	_tmp68_ = bird_font_path_new ();
	_g_object_unref0 (p);
	p = _tmp68_;
	_tmp69_ = p;
	_tmp70_ = bezier_points;
	_tmp70__length1 = bezier_points_length1;
	_tmp71_ = _tmp70_[0];
	_tmp72_ = bezier_points;
	_tmp72__length1 = bezier_points_length1;
	_tmp73_ = _tmp72_[0];
	_tmp74_ = bird_font_path_add (_tmp69_, _tmp71_->x0, _tmp73_->y0);
	_tmp75_ = _tmp74_;
	_g_object_unref0 (_tmp75_);
	_tmp76_ = p;
	_tmp77_ = bezier_points;
	_tmp77__length1 = bezier_points_length1;
	_tmp78_ = _tmp77_[1];
	_tmp79_ = bezier_points;
	_tmp79__length1 = bezier_points_length1;
	_tmp80_ = _tmp79_[1];
	_tmp81_ = bird_font_path_add (_tmp76_, _tmp78_->x0, _tmp80_->y0);
	_tmp82_ = _tmp81_;
	_g_object_unref0 (_tmp82_);
	_tmp83_ = p;
	bird_font_path_close (_tmp83_);
	_tmp84_ = p;
	bird_font_path_create_list (_tmp84_);
	_tmp85_ = p;
	bird_font_path_recalculate_linear_handles (_tmp85_);
	_tmp86_ = npl;
	_tmp87_ = p;
	bird_font_path_list_add (_tmp86_, _tmp87_);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp88_;
		BAttributes* _tmp89_;
		BAttributesIterator* _tmp90_;
		BAttributesIterator* _tmp91_;
		_tmp88_ = b_tag_get_attributes (tag);
		_tmp89_ = _tmp88_;
		_tmp90_ = b_attributes_iterator (_tmp89_);
		_tmp91_ = _tmp90_;
		_g_object_unref0 (_tmp89_);
		_attr_it = _tmp91_;
		while (TRUE) {
			BAttributesIterator* _tmp92_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp93_;
			BAttribute* _tmp94_;
			BAttribute* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gboolean _tmp98_;
			_tmp92_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp92_)) {
				break;
			}
			_tmp93_ = _attr_it;
			_tmp94_ = b_attributes_iterator_get (_tmp93_);
			attr = _tmp94_;
			_tmp95_ = attr;
			_tmp96_ = b_attribute_get_name (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = g_strcmp0 (_tmp97_, "transform") == 0;
			_g_free0 (_tmp97_);
			if (_tmp98_) {
				BAttribute* _tmp99_;
				gchar* _tmp100_;
				gchar* _tmp101_;
				BirdFontPathList* _tmp102_;
				_tmp99_ = attr;
				_tmp100_ = b_attribute_get_content (_tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = npl;
				bird_font_svg_parser_transform_paths (self, _tmp101_, _tmp102_);
				_g_free0 (_tmp101_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp103_ = style;
	_tmp104_ = npl;
	bird_font_svg_style_apply (_tmp103_, _tmp104_);
	_tmp105_ = pl->paths;
	_tmp106_ = npl;
	bird_font_path_list_append (_tmp105_, _tmp106_);
	_bird_font_svg_style_unref0 (style);
	_g_object_unref0 (npl);
	_g_object_unref0 (g);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	_g_object_unref0 (p);
}

static void
bird_font_svg_parser_parse_rect (BirdFontSvgParser* self,
                                 BTag* tag,
                                 BirdFontLayer* pl)
{
	BirdFontPath* p = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	BirdFontBezierPoints** bezier_points = NULL;
	gint bezier_points_length1 = 0;
	gint _bezier_points_size_ = 0;
	BirdFontGlyph* g = NULL;
	BirdFontPathList* npl = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp1_;
	gboolean hidden = FALSE;
	BirdFontEditPoint* ep = NULL;
	BAttributes* _tmp45_;
	BAttributes* _tmp46_;
	BirdFontSvgStyle* _tmp47_;
	BirdFontBezierPoints** _tmp48_;
	BirdFontBezierPoints** _tmp49_;
	gint _tmp49__length1;
	BirdFontBezierPoints* _tmp50_;
	BirdFontBezierPoints** _tmp51_;
	gint _tmp51__length1;
	BirdFontBezierPoints* _tmp52_;
	BirdFontBezierPoints** _tmp53_;
	gint _tmp53__length1;
	BirdFontBezierPoints* _tmp54_;
	BirdFontBezierPoints** _tmp55_;
	gint _tmp55__length1;
	BirdFontBezierPoints* _tmp56_;
	BirdFontBezierPoints** _tmp57_;
	gint _tmp57__length1;
	BirdFontBezierPoints* _tmp58_;
	BirdFontBezierPoints** _tmp59_;
	gint _tmp59__length1;
	BirdFontBezierPoints* _tmp60_;
	BirdFontBezierPoints** _tmp61_;
	gint _tmp61__length1;
	BirdFontBezierPoints* _tmp62_;
	BirdFontBezierPoints** _tmp63_;
	gint _tmp63__length1;
	BirdFontBezierPoints* _tmp64_;
	BirdFontBezierPoints** _tmp65_;
	gint _tmp65__length1;
	BirdFontBezierPoints* _tmp66_;
	BirdFontBezierPoints** _tmp67_;
	gint _tmp67__length1;
	BirdFontBezierPoints* _tmp68_;
	BirdFontBezierPoints** _tmp69_;
	gint _tmp69__length1;
	BirdFontBezierPoints* _tmp70_;
	BirdFontBezierPoints** _tmp71_;
	gint _tmp71__length1;
	BirdFontBezierPoints* _tmp72_;
	BirdFontBezierPoints** _tmp73_;
	gint _tmp73__length1;
	BirdFontBezierPoints* _tmp74_;
	BirdFontBezierPoints** _tmp75_;
	gint _tmp75__length1;
	BirdFontBezierPoints* _tmp76_;
	BirdFontBezierPoints** _tmp77_;
	gint _tmp77__length1;
	BirdFontBezierPoints* _tmp78_;
	BirdFontBezierPoints** _tmp79_;
	gint _tmp79__length1;
	BirdFontBezierPoints* _tmp80_;
	BirdFontGlyph* _tmp81_;
	BirdFontBezierPoints** _tmp82_;
	gint _tmp82__length1;
	BirdFontGlyph* _tmp83_;
	BirdFontPath* _tmp84_;
	BirdFontPath* _tmp85_;
	BirdFontBezierPoints** _tmp86_;
	gint _tmp86__length1;
	BirdFontBezierPoints* _tmp87_;
	BirdFontBezierPoints** _tmp88_;
	gint _tmp88__length1;
	BirdFontBezierPoints* _tmp89_;
	BirdFontEditPoint* _tmp90_;
	BirdFontEditPoint* _tmp91_;
	BirdFontPath* _tmp92_;
	BirdFontBezierPoints** _tmp93_;
	gint _tmp93__length1;
	BirdFontBezierPoints* _tmp94_;
	BirdFontBezierPoints** _tmp95_;
	gint _tmp95__length1;
	BirdFontBezierPoints* _tmp96_;
	BirdFontEditPoint* _tmp97_;
	BirdFontEditPoint* _tmp98_;
	BirdFontPath* _tmp99_;
	BirdFontBezierPoints** _tmp100_;
	gint _tmp100__length1;
	BirdFontBezierPoints* _tmp101_;
	BirdFontBezierPoints** _tmp102_;
	gint _tmp102__length1;
	BirdFontBezierPoints* _tmp103_;
	BirdFontEditPoint* _tmp104_;
	BirdFontEditPoint* _tmp105_;
	BirdFontPath* _tmp106_;
	BirdFontBezierPoints** _tmp107_;
	gint _tmp107__length1;
	BirdFontBezierPoints* _tmp108_;
	BirdFontBezierPoints** _tmp109_;
	gint _tmp109__length1;
	BirdFontBezierPoints* _tmp110_;
	BirdFontEditPoint* _tmp111_;
	BirdFontEditPoint* _tmp112_;
	BirdFontPath* _tmp113_;
	BirdFontPath* _tmp114_;
	BirdFontPath* _tmp115_;
	BirdFontPathList* _tmp116_;
	BirdFontPath* _tmp117_;
	BirdFontSvgStyle* _tmp133_;
	BirdFontPathList* _tmp134_;
	BirdFontPathList* _tmp135_;
	BirdFontPathList* _tmp136_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_path_list_new ();
	npl = _tmp0_;
	_tmp1_ = bird_font_svg_style_new ();
	style = _tmp1_;
	hidden = FALSE;
	x = (gdouble) 0;
	y = (gdouble) 0;
	x2 = (gdouble) 0;
	y2 = (gdouble) 0;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp2_;
		BAttributes* _tmp3_;
		BAttributesIterator* _tmp4_;
		BAttributesIterator* _tmp5_;
		_tmp2_ = b_tag_get_attributes (tag);
		_tmp3_ = _tmp2_;
		_tmp4_ = b_attributes_iterator (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_attr_it = _tmp5_;
		while (TRUE) {
			BAttributesIterator* _tmp6_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp7_;
			BAttribute* _tmp8_;
			BAttribute* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			BAttribute* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_;
			BAttribute* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gboolean _tmp26_;
			BAttribute* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gboolean _tmp33_;
			gboolean _tmp37_ = FALSE;
			BAttribute* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_;
			_tmp6_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _attr_it;
			_tmp8_ = b_attributes_iterator_get (_tmp7_);
			attr = _tmp8_;
			_tmp9_ = attr;
			_tmp10_ = b_attribute_get_name (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strcmp0 (_tmp11_, "x") == 0;
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				BAttribute* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = attr;
				_tmp14_ = b_attribute_get_content (_tmp13_);
				_tmp15_ = _tmp14_;
				x = bird_font_svg_parser_parse_double (_tmp15_);
				_g_free0 (_tmp15_);
			}
			_tmp16_ = attr;
			_tmp17_ = b_attribute_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strcmp0 (_tmp18_, "y") == 0;
			_g_free0 (_tmp18_);
			if (_tmp19_) {
				BAttribute* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = attr;
				_tmp21_ = b_attribute_get_content (_tmp20_);
				_tmp22_ = _tmp21_;
				y = -bird_font_svg_parser_parse_double (_tmp22_);
				_g_free0 (_tmp22_);
			}
			_tmp23_ = attr;
			_tmp24_ = b_attribute_get_name (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strcmp0 (_tmp25_, "width") == 0;
			_g_free0 (_tmp25_);
			if (_tmp26_) {
				BAttribute* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = attr;
				_tmp28_ = b_attribute_get_content (_tmp27_);
				_tmp29_ = _tmp28_;
				x2 = bird_font_svg_parser_parse_double (_tmp29_);
				_g_free0 (_tmp29_);
			}
			_tmp30_ = attr;
			_tmp31_ = b_attribute_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strcmp0 (_tmp32_, "height") == 0;
			_g_free0 (_tmp32_);
			if (_tmp33_) {
				BAttribute* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				_tmp34_ = attr;
				_tmp35_ = b_attribute_get_content (_tmp34_);
				_tmp36_ = _tmp35_;
				y2 = -bird_font_svg_parser_parse_double (_tmp36_);
				_g_free0 (_tmp36_);
			}
			_tmp38_ = attr;
			_tmp39_ = b_attribute_get_name (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strcmp0 (_tmp40_, "display") == 0;
			_g_free0 (_tmp40_);
			if (_tmp41_) {
				BAttribute* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp42_ = attr;
				_tmp43_ = b_attribute_get_content (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp37_ = g_strcmp0 (_tmp44_, "none") == 0;
				_g_free0 (_tmp44_);
			} else {
				_tmp37_ = FALSE;
			}
			if (_tmp37_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp45_ = b_tag_get_attributes (tag);
	_tmp46_ = _tmp45_;
	_tmp47_ = bird_font_svg_style_parse (_tmp46_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp47_;
	_g_object_unref0 (_tmp46_);
	if (hidden) {
		_g_object_unref0 (ep);
		_bird_font_svg_style_unref0 (style);
		_g_object_unref0 (npl);
		_g_object_unref0 (g);
		bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
		_g_object_unref0 (p);
		return;
	}
	x2 += x;
	y2 += y;
	_tmp48_ = g_new0 (BirdFontBezierPoints*, 4 + 1);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	bezier_points = _tmp48_;
	bezier_points_length1 = 4;
	_bezier_points_size_ = bezier_points_length1;
	_tmp49_ = bezier_points;
	_tmp49__length1 = bezier_points_length1;
	_tmp50_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp49_[0]);
	_tmp49_[0] = _tmp50_;
	_tmp51_ = bezier_points;
	_tmp51__length1 = bezier_points_length1;
	_tmp52_ = _tmp51_[0];
	_tmp52_->type = (gunichar) 'L';
	_tmp53_ = bezier_points;
	_tmp53__length1 = bezier_points_length1;
	_tmp54_ = _tmp53_[0];
	_tmp54_->x0 = x;
	_tmp55_ = bezier_points;
	_tmp55__length1 = bezier_points_length1;
	_tmp56_ = _tmp55_[0];
	_tmp56_->y0 = y;
	_tmp57_ = bezier_points;
	_tmp57__length1 = bezier_points_length1;
	_tmp58_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp57_[1]);
	_tmp57_[1] = _tmp58_;
	_tmp59_ = bezier_points;
	_tmp59__length1 = bezier_points_length1;
	_tmp60_ = _tmp59_[1];
	_tmp61_ = bezier_points;
	_tmp61__length1 = bezier_points_length1;
	_tmp62_ = _tmp61_[1];
	_tmp62_->x0 = x2;
	_tmp63_ = bezier_points;
	_tmp63__length1 = bezier_points_length1;
	_tmp64_ = _tmp63_[1];
	_tmp64_->y0 = y;
	_tmp65_ = bezier_points;
	_tmp65__length1 = bezier_points_length1;
	_tmp66_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp65_[2]);
	_tmp65_[2] = _tmp66_;
	_tmp67_ = bezier_points;
	_tmp67__length1 = bezier_points_length1;
	_tmp68_ = _tmp67_[2];
	_tmp68_->type = (gunichar) 'L';
	_tmp69_ = bezier_points;
	_tmp69__length1 = bezier_points_length1;
	_tmp70_ = _tmp69_[2];
	_tmp70_->x0 = x2;
	_tmp71_ = bezier_points;
	_tmp71__length1 = bezier_points_length1;
	_tmp72_ = _tmp71_[2];
	_tmp72_->y0 = y2;
	_tmp73_ = bezier_points;
	_tmp73__length1 = bezier_points_length1;
	_tmp74_ = bird_font_bezier_points_new ();
	_bird_font_bezier_points_unref0 (_tmp73_[3]);
	_tmp73_[3] = _tmp74_;
	_tmp75_ = bezier_points;
	_tmp75__length1 = bezier_points_length1;
	_tmp76_ = _tmp75_[3];
	_tmp76_->type = (gunichar) 'L';
	_tmp77_ = bezier_points;
	_tmp77__length1 = bezier_points_length1;
	_tmp78_ = _tmp77_[3];
	_tmp78_->x0 = x;
	_tmp79_ = bezier_points;
	_tmp79__length1 = bezier_points_length1;
	_tmp80_ = _tmp79_[3];
	_tmp80_->y0 = y2;
	_tmp81_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp81_;
	_tmp82_ = bezier_points;
	_tmp82__length1 = bezier_points_length1;
	_tmp83_ = g;
	bird_font_svg_parser_move_and_resize (self, _tmp82_, (gint) _tmp82__length1, 4, FALSE, (gdouble) 1, _tmp83_);
	_tmp84_ = bird_font_path_new ();
	_g_object_unref0 (p);
	p = _tmp84_;
	_tmp85_ = p;
	_tmp86_ = bezier_points;
	_tmp86__length1 = bezier_points_length1;
	_tmp87_ = _tmp86_[0];
	_tmp88_ = bezier_points;
	_tmp88__length1 = bezier_points_length1;
	_tmp89_ = _tmp88_[0];
	_tmp90_ = bird_font_path_add (_tmp85_, _tmp87_->x0, _tmp89_->y0);
	_g_object_unref0 (ep);
	ep = _tmp90_;
	_tmp91_ = ep;
	bird_font_edit_point_set_point_type (_tmp91_, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp92_ = p;
	_tmp93_ = bezier_points;
	_tmp93__length1 = bezier_points_length1;
	_tmp94_ = _tmp93_[1];
	_tmp95_ = bezier_points;
	_tmp95__length1 = bezier_points_length1;
	_tmp96_ = _tmp95_[1];
	_tmp97_ = bird_font_path_add (_tmp92_, _tmp94_->x0, _tmp96_->y0);
	_g_object_unref0 (ep);
	ep = _tmp97_;
	_tmp98_ = ep;
	bird_font_edit_point_set_point_type (_tmp98_, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp99_ = p;
	_tmp100_ = bezier_points;
	_tmp100__length1 = bezier_points_length1;
	_tmp101_ = _tmp100_[2];
	_tmp102_ = bezier_points;
	_tmp102__length1 = bezier_points_length1;
	_tmp103_ = _tmp102_[2];
	_tmp104_ = bird_font_path_add (_tmp99_, _tmp101_->x0, _tmp103_->y0);
	_g_object_unref0 (ep);
	ep = _tmp104_;
	_tmp105_ = ep;
	bird_font_edit_point_set_point_type (_tmp105_, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp106_ = p;
	_tmp107_ = bezier_points;
	_tmp107__length1 = bezier_points_length1;
	_tmp108_ = _tmp107_[3];
	_tmp109_ = bezier_points;
	_tmp109__length1 = bezier_points_length1;
	_tmp110_ = _tmp109_[3];
	_tmp111_ = bird_font_path_add (_tmp106_, _tmp108_->x0, _tmp110_->y0);
	_g_object_unref0 (ep);
	ep = _tmp111_;
	_tmp112_ = ep;
	bird_font_edit_point_set_point_type (_tmp112_, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp113_ = p;
	bird_font_path_close (_tmp113_);
	_tmp114_ = p;
	bird_font_path_create_list (_tmp114_);
	_tmp115_ = p;
	bird_font_path_recalculate_linear_handles (_tmp115_);
	_tmp116_ = npl;
	_tmp117_ = p;
	bird_font_path_list_add (_tmp116_, _tmp117_);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp118_;
		BAttributes* _tmp119_;
		BAttributesIterator* _tmp120_;
		BAttributesIterator* _tmp121_;
		_tmp118_ = b_tag_get_attributes (tag);
		_tmp119_ = _tmp118_;
		_tmp120_ = b_attributes_iterator (_tmp119_);
		_tmp121_ = _tmp120_;
		_g_object_unref0 (_tmp119_);
		_attr_it = _tmp121_;
		while (TRUE) {
			BAttributesIterator* _tmp122_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp123_;
			BAttribute* _tmp124_;
			BAttribute* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			gboolean _tmp128_;
			_tmp122_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp122_)) {
				break;
			}
			_tmp123_ = _attr_it;
			_tmp124_ = b_attributes_iterator_get (_tmp123_);
			attr = _tmp124_;
			_tmp125_ = attr;
			_tmp126_ = b_attribute_get_name (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = g_strcmp0 (_tmp127_, "transform") == 0;
			_g_free0 (_tmp127_);
			if (_tmp128_) {
				BAttribute* _tmp129_;
				gchar* _tmp130_;
				gchar* _tmp131_;
				BirdFontPathList* _tmp132_;
				_tmp129_ = attr;
				_tmp130_ = b_attribute_get_content (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = npl;
				bird_font_svg_parser_transform_paths (self, _tmp131_, _tmp132_);
				_g_free0 (_tmp131_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp133_ = style;
	_tmp134_ = npl;
	bird_font_svg_style_apply (_tmp133_, _tmp134_);
	_tmp135_ = pl->paths;
	_tmp136_ = npl;
	bird_font_path_list_append (_tmp135_, _tmp136_);
	_g_object_unref0 (ep);
	_bird_font_svg_style_unref0 (style);
	_g_object_unref0 (npl);
	_g_object_unref0 (g);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	_g_object_unref0 (p);
}

static void
bird_font_svg_parser_parse_polygon (BirdFontSvgParser* self,
                                    BTag* tag,
                                    BirdFontLayer* pl)
{
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp11_;
	BirdFontPathList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_svg_parser_get_polyline (self, tag);
	path_list = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp1_ = path_list;
		_tmp2_ = _tmp1_->paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			_tmp10_ = p;
			bird_font_path_close (_tmp10_);
			_g_object_unref0 (p);
		}
	}
	_tmp11_ = pl->paths;
	_tmp12_ = path_list;
	bird_font_path_list_append (_tmp11_, _tmp12_);
	_g_object_unref0 (path_list);
}

static void
bird_font_svg_parser_parse_polyline (BirdFontSvgParser* self,
                                     BTag* tag,
                                     BirdFontLayer* pl)
{
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp1_;
	BirdFontPathList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = pl->paths;
	_tmp1_ = bird_font_svg_parser_get_polyline (self, tag);
	_tmp2_ = _tmp1_;
	bird_font_path_list_append (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static BirdFontPathList*
bird_font_svg_parser_get_polyline (BirdFontSvgParser* self,
                                   BTag* tag)
{
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	gboolean hidden = FALSE;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp2_;
	BAttributes* _tmp26_;
	BAttributes* _tmp27_;
	BirdFontSvgStyle* _tmp28_;
	BirdFontPathList* _tmp29_;
	BirdFontPath* _tmp30_;
	BirdFontSvgStyle* _tmp31_;
	BirdFontPathList* _tmp32_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	p = _tmp0_;
	hidden = FALSE;
	_tmp1_ = bird_font_path_list_new ();
	path_list = _tmp1_;
	_tmp2_ = bird_font_svg_style_new ();
	style = _tmp2_;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp3_;
		BAttributes* _tmp4_;
		BAttributesIterator* _tmp5_;
		BAttributesIterator* _tmp6_;
		_tmp3_ = b_tag_get_attributes (tag);
		_tmp4_ = _tmp3_;
		_tmp5_ = b_attributes_iterator (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_attr_it = _tmp6_;
		while (TRUE) {
			BAttributesIterator* _tmp7_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp8_;
			BAttribute* _tmp9_;
			BAttribute* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp18_ = FALSE;
			BAttribute* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
			_tmp7_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _attr_it;
			_tmp9_ = b_attributes_iterator_get (_tmp8_);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = b_attribute_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, "points") == 0;
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				BAttribute* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				BirdFontPath* _tmp17_;
				_tmp14_ = attr;
				_tmp15_ = b_attribute_get_content (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = bird_font_svg_parser_parse_poly_data (self, _tmp16_);
				_g_object_unref0 (p);
				p = _tmp17_;
				_g_free0 (_tmp16_);
			}
			_tmp19_ = attr;
			_tmp20_ = b_attribute_get_name (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strcmp0 (_tmp21_, "display") == 0;
			_g_free0 (_tmp21_);
			if (_tmp22_) {
				BAttribute* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp23_ = attr;
				_tmp24_ = b_attribute_get_content (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp18_ = g_strcmp0 (_tmp25_, "none") == 0;
				_g_free0 (_tmp25_);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp26_ = b_tag_get_attributes (tag);
	_tmp27_ = _tmp26_;
	_tmp28_ = bird_font_svg_style_parse (_tmp27_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp28_;
	_g_object_unref0 (_tmp27_);
	if (hidden) {
		result = path_list;
		_bird_font_svg_style_unref0 (style);
		_g_object_unref0 (p);
		return result;
	}
	_tmp29_ = path_list;
	_tmp30_ = p;
	bird_font_path_list_add (_tmp29_, _tmp30_);
	_tmp31_ = style;
	_tmp32_ = path_list;
	bird_font_svg_style_apply (_tmp31_, _tmp32_);
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp33_;
		BAttributes* _tmp34_;
		BAttributesIterator* _tmp35_;
		BAttributesIterator* _tmp36_;
		_tmp33_ = b_tag_get_attributes (tag);
		_tmp34_ = _tmp33_;
		_tmp35_ = b_attributes_iterator (_tmp34_);
		_tmp36_ = _tmp35_;
		_g_object_unref0 (_tmp34_);
		_attr_it = _tmp36_;
		while (TRUE) {
			BAttributesIterator* _tmp37_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp38_;
			BAttribute* _tmp39_;
			BAttribute* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp37_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp37_)) {
				break;
			}
			_tmp38_ = _attr_it;
			_tmp39_ = b_attributes_iterator_get (_tmp38_);
			attr = _tmp39_;
			_tmp40_ = attr;
			_tmp41_ = b_attribute_get_name (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strcmp0 (_tmp42_, "transform") == 0;
			_g_free0 (_tmp42_);
			if (_tmp43_) {
				BAttribute* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				BirdFontPathList* _tmp47_;
				_tmp44_ = attr;
				_tmp45_ = b_attribute_get_content (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = path_list;
				bird_font_svg_parser_transform_paths (self, _tmp46_, _tmp47_);
				_g_free0 (_tmp46_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	result = path_list;
	_bird_font_svg_style_unref0 (style);
	_g_object_unref0 (p);
	return result;
}

static void
bird_font_svg_parser_parse_path (BirdFontSvgParser* self,
                                 BTag* tag,
                                 BirdFontLayer* pl)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp1_;
	BirdFontSvgStyle* style = NULL;
	BirdFontSvgStyle* _tmp2_;
	gboolean hidden = FALSE;
	BAttributes* _tmp40_;
	BAttributes* _tmp41_;
	BirdFontSvgStyle* _tmp42_;
	BirdFontPathList* _tmp43_;
	BirdFontPathList* _tmp44_;
	BirdFontSvgStyle* _tmp45_;
	BirdFontPathList* _tmp46_;
	gint inside_count = 0;
	gboolean inside = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (pl != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = bird_font_path_list_new ();
	path_list = _tmp1_;
	_tmp2_ = bird_font_svg_style_new ();
	style = _tmp2_;
	hidden = FALSE;
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp3_;
		BAttributes* _tmp4_;
		BAttributesIterator* _tmp5_;
		BAttributesIterator* _tmp6_;
		_tmp3_ = b_tag_get_attributes (tag);
		_tmp4_ = _tmp3_;
		_tmp5_ = b_attributes_iterator (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_attr_it = _tmp6_;
		while (TRUE) {
			BAttributesIterator* _tmp7_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp8_;
			BAttribute* _tmp9_;
			BAttribute* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp19_ = FALSE;
			BAttribute* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp27_ = FALSE;
			BAttribute* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_;
			_tmp7_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _attr_it;
			_tmp9_ = b_attributes_iterator_get (_tmp8_);
			attr = _tmp9_;
			_tmp10_ = attr;
			_tmp11_ = b_attribute_get_name (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strcmp0 (_tmp12_, "d") == 0;
			_g_free0 (_tmp12_);
			if (_tmp13_) {
				BAttribute* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				BirdFontGlyph* _tmp17_;
				BirdFontPathList* _tmp18_;
				_tmp14_ = attr;
				_tmp15_ = b_attribute_get_content (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = glyph;
				_tmp18_ = bird_font_svg_parser_parse_svg_data (self, _tmp16_, _tmp17_, FALSE, (gdouble) 1);
				_g_object_unref0 (path_list);
				path_list = _tmp18_;
				_g_free0 (_tmp16_);
			}
			_tmp20_ = attr;
			_tmp21_ = b_attribute_get_name (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strcmp0 (_tmp22_, "display") == 0;
			_g_free0 (_tmp22_);
			if (_tmp23_) {
				BAttribute* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp24_ = attr;
				_tmp25_ = b_attribute_get_content (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp19_ = g_strcmp0 (_tmp26_, "none") == 0;
				_g_free0 (_tmp26_);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				hidden = TRUE;
			}
			_tmp28_ = attr;
			_tmp29_ = b_attribute_get_name (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strcmp0 (_tmp30_, "visibility") == 0;
			_g_free0 (_tmp30_);
			if (_tmp31_) {
				gboolean _tmp32_ = FALSE;
				BAttribute* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gboolean _tmp36_;
				_tmp33_ = attr;
				_tmp34_ = b_attribute_get_content (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strcmp0 (_tmp35_, "hidden") == 0;
				_g_free0 (_tmp35_);
				if (_tmp36_) {
					_tmp32_ = TRUE;
				} else {
					BAttribute* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp37_ = attr;
					_tmp38_ = b_attribute_get_content (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp32_ = g_strcmp0 (_tmp39_, "collapse") == 0;
					_g_free0 (_tmp39_);
				}
				_tmp27_ = _tmp32_;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				hidden = TRUE;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp40_ = b_tag_get_attributes (tag);
	_tmp41_ = _tmp40_;
	_tmp42_ = bird_font_svg_style_parse (_tmp41_);
	_bird_font_svg_style_unref0 (style);
	style = _tmp42_;
	_g_object_unref0 (_tmp41_);
	if (hidden) {
		_bird_font_svg_style_unref0 (style);
		_g_object_unref0 (path_list);
		_g_object_unref0 (glyph);
		return;
	}
	_tmp43_ = pl->paths;
	_tmp44_ = path_list;
	bird_font_path_list_append (_tmp43_, _tmp44_);
	_tmp45_ = style;
	_tmp46_ = path_list;
	bird_font_svg_style_apply (_tmp45_, _tmp46_);
	{
		GeeArrayList* _p1_list = NULL;
		BirdFontPathList* _tmp47_;
		GeeArrayList* _tmp48_;
		gint _p1_size = 0;
		GeeArrayList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _p1_index = 0;
		_tmp47_ = pl->paths;
		_tmp48_ = _tmp47_->paths;
		_p1_list = _tmp48_;
		_tmp49_ = _p1_list;
		_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_p1_size = _tmp51_;
		_p1_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			BirdFontPath* p1 = NULL;
			GeeArrayList* _tmp54_;
			gpointer _tmp55_;
			_p1_index = _p1_index + 1;
			_tmp52_ = _p1_index;
			_tmp53_ = _p1_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _p1_list;
			_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _p1_index);
			p1 = (BirdFontPath*) _tmp55_;
			inside_count = 0;
			{
				GeeArrayList* _p2_list = NULL;
				BirdFontPathList* _tmp56_;
				GeeArrayList* _tmp57_;
				gint _p2_size = 0;
				GeeArrayList* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gint _p2_index = 0;
				_tmp56_ = pl->paths;
				_tmp57_ = _tmp56_->paths;
				_p2_list = _tmp57_;
				_tmp58_ = _p2_list;
				_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
				_tmp60_ = _tmp59_;
				_p2_size = _tmp60_;
				_p2_index = -1;
				while (TRUE) {
					gint _tmp61_;
					gint _tmp62_;
					BirdFontPath* p2 = NULL;
					GeeArrayList* _tmp63_;
					gpointer _tmp64_;
					BirdFontPath* _tmp65_;
					BirdFontPath* _tmp66_;
					_p2_index = _p2_index + 1;
					_tmp61_ = _p2_index;
					_tmp62_ = _p2_size;
					if (!(_tmp61_ < _tmp62_)) {
						break;
					}
					_tmp63_ = _p2_list;
					_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _p2_index);
					p2 = (BirdFontPath*) _tmp64_;
					_tmp65_ = p1;
					_tmp66_ = p2;
					if (_tmp65_ != _tmp66_) {
						inside = TRUE;
						{
							GeeArrayList* _ep_list = NULL;
							BirdFontPath* _tmp67_;
							GeeArrayList* _tmp68_;
							GeeArrayList* _tmp69_;
							gint _ep_size = 0;
							GeeArrayList* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							gint _ep_index = 0;
							_tmp67_ = p1;
							_tmp68_ = bird_font_path_get_points (_tmp67_);
							_tmp69_ = _tmp68_;
							_ep_list = _tmp69_;
							_tmp70_ = _ep_list;
							_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
							_tmp72_ = _tmp71_;
							_ep_size = _tmp72_;
							_ep_index = -1;
							while (TRUE) {
								gint _tmp73_;
								gint _tmp74_;
								BirdFontEditPoint* ep = NULL;
								GeeArrayList* _tmp75_;
								gpointer _tmp76_;
								BirdFontEditPoint* _tmp77_;
								BirdFontPath* _tmp78_;
								_ep_index = _ep_index + 1;
								_tmp73_ = _ep_index;
								_tmp74_ = _ep_size;
								if (!(_tmp73_ < _tmp74_)) {
									break;
								}
								_tmp75_ = _ep_list;
								_tmp76_ = gee_abstract_list_get ((GeeAbstractList*) _tmp75_, _ep_index);
								ep = (BirdFontEditPoint*) _tmp76_;
								_tmp77_ = ep;
								_tmp78_ = p2;
								if (!bird_font_svg_parser_is_inside (_tmp77_, _tmp78_)) {
									inside = FALSE;
								}
								_g_object_unref0 (ep);
							}
						}
						if (inside) {
							gint _tmp79_;
							_tmp79_ = inside_count;
							inside_count = _tmp79_ + 1;
						}
					}
					_g_object_unref0 (p2);
				}
			}
			if ((inside_count % 2) == 0) {
				BirdFontPath* _tmp80_;
				_tmp80_ = p1;
				bird_font_path_force_direction (_tmp80_, BIRD_FONT_DIRECTION_CLOCKWISE);
			} else {
				BirdFontPath* _tmp81_;
				_tmp81_ = p1;
				bird_font_path_force_direction (_tmp81_, BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE);
			}
			_g_object_unref0 (p1);
		}
	}
	{
		BAttributesIterator* _attr_it = NULL;
		BAttributes* _tmp82_;
		BAttributes* _tmp83_;
		BAttributesIterator* _tmp84_;
		BAttributesIterator* _tmp85_;
		_tmp82_ = b_tag_get_attributes (tag);
		_tmp83_ = _tmp82_;
		_tmp84_ = b_attributes_iterator (_tmp83_);
		_tmp85_ = _tmp84_;
		_g_object_unref0 (_tmp83_);
		_attr_it = _tmp85_;
		while (TRUE) {
			BAttributesIterator* _tmp86_;
			BAttribute* attr = NULL;
			BAttributesIterator* _tmp87_;
			BAttribute* _tmp88_;
			BAttribute* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gboolean _tmp92_;
			_tmp86_ = _attr_it;
			if (!b_attributes_iterator_next (_tmp86_)) {
				break;
			}
			_tmp87_ = _attr_it;
			_tmp88_ = b_attributes_iterator_get (_tmp87_);
			attr = _tmp88_;
			_tmp89_ = attr;
			_tmp90_ = b_attribute_get_name (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = g_strcmp0 (_tmp91_, "transform") == 0;
			_g_free0 (_tmp91_);
			if (_tmp92_) {
				BAttribute* _tmp93_;
				gchar* _tmp94_;
				gchar* _tmp95_;
				BirdFontPathList* _tmp96_;
				_tmp93_ = attr;
				_tmp94_ = b_attribute_get_content (_tmp93_);
				_tmp95_ = _tmp94_;
				_tmp96_ = path_list;
				bird_font_svg_parser_transform_paths (self, _tmp95_, _tmp96_);
				_g_free0 (_tmp95_);
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_bird_font_svg_style_unref0 (style);
	_g_object_unref0 (path_list);
	_g_object_unref0 (glyph);
}

void
bird_font_svg_parser_create_lines_for_segment (BirdFontPath* path,
                                               BirdFontEditPoint* start,
                                               BirdFontEditPoint* end,
                                               gdouble tolerance)
{
	gdouble x1 = 0.0;
	gdouble x2 = 0.0;
	gdouble x3 = 0.0;
	gdouble y1 = 0.0;
	gdouble y2 = 0.0;
	gdouble y3 = 0.0;
	gdouble step_start = 0.0;
	gdouble step = 0.0;
	gdouble step_end = 0.0;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = bird_font_path_add (path, start->x, start->y);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	step_start = (gdouble) 0;
	step = 0.5;
	step_end = (gdouble) 1;
	while (TRUE) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		bird_font_path_get_point_for_step (start, end, step_start, &_tmp2_, &_tmp3_);
		x1 = _tmp2_;
		y1 = _tmp3_;
		bird_font_path_get_point_for_step (start, end, step, &_tmp4_, &_tmp5_);
		x2 = _tmp4_;
		y2 = _tmp5_;
		bird_font_path_get_point_for_step (start, end, step_end, &_tmp6_, &_tmp7_);
		x3 = _tmp6_;
		y3 = _tmp7_;
		if (!bird_font_stroke_tool_is_flat (x1, y1, x2, y2, x3, y3, tolerance)) {
			_tmp11_ = (step_end - (step / 2.0)) > step_start;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			_tmp10_ = (step_end - (step / 2.0)) > 0.1;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = step > 0.05;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = bird_font_path_distance_to_point (start, end) > ((gdouble) 1);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			step /= 2.0;
			if (step < 0.05) {
				step = 0.05;
			} else {
				step_end = step_start + (2 * step);
			}
		} else {
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			_tmp12_ = bird_font_path_add (path, x3, y3);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp13_);
			if ((step_end + step) < ((gdouble) 1)) {
				step_start = step_end;
				step_end += step;
			} else {
				break;
			}
		}
	}
}

BirdFontPath*
bird_font_svg_parser_get_lines (BirdFontPath* p)
{
	BirdFontEditPoint* start = NULL;
	BirdFontPath* path = NULL;
	BirdFontPath* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	BirdFontPath* result;
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	path = _tmp0_;
	_tmp1_ = bird_font_path_get_points (p);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = path;
		_g_object_unref0 (start);
		return result;
	}
	_tmp5_ = bird_font_path_get_points (p);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_path_get_points (p);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp10_ - 1);
	_g_object_unref0 (start);
	start = (BirdFontEditPoint*) _tmp11_;
	{
		GeeArrayList* _end_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _end_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _end_index = 0;
		_tmp12_ = bird_font_path_get_points (p);
		_tmp13_ = _tmp12_;
		_end_list = _tmp13_;
		_tmp14_ = _end_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_end_size = _tmp16_;
		_end_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			BirdFontEditPoint* end = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			BirdFontPath* _tmp21_;
			BirdFontEditPoint* _tmp22_;
			BirdFontEditPoint* _tmp23_;
			BirdFontEditPoint* _tmp24_;
			BirdFontEditPoint* _tmp25_;
			_end_index = _end_index + 1;
			_tmp17_ = _end_index;
			_tmp18_ = _end_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _end_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _end_index);
			end = (BirdFontEditPoint*) _tmp20_;
			_tmp21_ = path;
			_tmp22_ = start;
			_tmp23_ = end;
			bird_font_svg_parser_create_lines_for_segment (_tmp21_, _tmp22_, _tmp23_, (gdouble) 1);
			_tmp24_ = end;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (start);
			start = _tmp25_;
			_g_object_unref0 (end);
		}
	}
	result = path;
	_g_object_unref0 (start);
	return result;
}

/** Check if a point is inside using the even odd fill rule.
 * The path should only have straight lines.
 */
gboolean
bird_font_svg_parser_is_inside (BirdFontEditPoint* point,
                                BirdFontPath* path)
{
	BirdFontEditPoint* prev = NULL;
	gboolean inside = FALSE;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gpointer _tmp12_;
	gboolean result;
	g_return_val_if_fail (point != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	inside = FALSE;
	_tmp0_ = bird_font_path_get_points (path);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ <= 1) {
		result = FALSE;
		_g_object_unref0 (prev);
		return result;
	}
	_tmp4_ = point->x;
	if (!((path->xmin <= _tmp4_) && (_tmp4_ <= path->xmax))) {
		result = FALSE;
		_g_object_unref0 (prev);
		return result;
	}
	_tmp5_ = point->y;
	if (!((path->ymin <= _tmp5_) && (_tmp5_ <= path->ymax))) {
		result = FALSE;
		_g_object_unref0 (prev);
		return result;
	}
	_tmp6_ = bird_font_path_get_points (path);
	_tmp7_ = _tmp6_;
	_tmp8_ = bird_font_path_get_points (path);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp11_ - 1);
	_g_object_unref0 (prev);
	prev = (BirdFontEditPoint*) _tmp12_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _p_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _p_index = 0;
		_tmp13_ = bird_font_path_get_points (path);
		_tmp14_ = _tmp13_;
		_p_list = _tmp14_;
		_tmp15_ = _p_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_p_size = _tmp17_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			gboolean _tmp22_ = FALSE;
			BirdFontEditPoint* _tmp23_;
			BirdFontEditPoint* _tmp24_;
			BirdFontEditPoint* _tmp31_;
			BirdFontEditPoint* _tmp32_;
			_p_index = _p_index + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _p_index);
			p = (BirdFontEditPoint*) _tmp21_;
			_tmp23_ = p;
			_tmp24_ = prev;
			if ((_tmp23_->y > point->y) != (_tmp24_->y > point->y)) {
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPoint* _tmp26_;
				BirdFontEditPoint* _tmp27_;
				BirdFontEditPoint* _tmp28_;
				BirdFontEditPoint* _tmp29_;
				BirdFontEditPoint* _tmp30_;
				_tmp25_ = prev;
				_tmp26_ = p;
				_tmp27_ = p;
				_tmp28_ = prev;
				_tmp29_ = p;
				_tmp30_ = p;
				_tmp22_ = point->x < ((((_tmp25_->x - _tmp26_->x) * (point->y - _tmp27_->y)) / (_tmp28_->y - _tmp29_->y)) + _tmp30_->x);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				inside = !inside;
			}
			_tmp31_ = p;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_g_object_unref0 (prev);
			prev = _tmp32_;
			_g_object_unref0 (p);
		}
	}
	result = inside;
	_g_object_unref0 (prev);
	return result;
}

/** Add space as separator to svg data. 
 * @param d svg data
 */
static gchar*
bird_font_svg_parser_add_separators (const gchar* d)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* result;
	g_return_val_if_fail (d != NULL, NULL);
	_tmp0_ = g_strdup (d);
	data = _tmp0_;
	_tmp1_ = data;
	_tmp2_ = string_replace (_tmp1_, ",", " ");
	_g_free0 (data);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = string_replace (_tmp3_, "a", " a ");
	_g_free0 (data);
	data = _tmp4_;
	_tmp5_ = data;
	_tmp6_ = string_replace (_tmp5_, "A", " A ");
	_g_free0 (data);
	data = _tmp6_;
	_tmp7_ = data;
	_tmp8_ = string_replace (_tmp7_, "m", " m ");
	_g_free0 (data);
	data = _tmp8_;
	_tmp9_ = data;
	_tmp10_ = string_replace (_tmp9_, "M", " M ");
	_g_free0 (data);
	data = _tmp10_;
	_tmp11_ = data;
	_tmp12_ = string_replace (_tmp11_, "h", " h ");
	_g_free0 (data);
	data = _tmp12_;
	_tmp13_ = data;
	_tmp14_ = string_replace (_tmp13_, "H", " H ");
	_g_free0 (data);
	data = _tmp14_;
	_tmp15_ = data;
	_tmp16_ = string_replace (_tmp15_, "v", " v ");
	_g_free0 (data);
	data = _tmp16_;
	_tmp17_ = data;
	_tmp18_ = string_replace (_tmp17_, "V", " V ");
	_g_free0 (data);
	data = _tmp18_;
	_tmp19_ = data;
	_tmp20_ = string_replace (_tmp19_, "l", " l ");
	_g_free0 (data);
	data = _tmp20_;
	_tmp21_ = data;
	_tmp22_ = string_replace (_tmp21_, "L", " L ");
	_g_free0 (data);
	data = _tmp22_;
	_tmp23_ = data;
	_tmp24_ = string_replace (_tmp23_, "q", " q ");
	_g_free0 (data);
	data = _tmp24_;
	_tmp25_ = data;
	_tmp26_ = string_replace (_tmp25_, "Q", " Q ");
	_g_free0 (data);
	data = _tmp26_;
	_tmp27_ = data;
	_tmp28_ = string_replace (_tmp27_, "c", " c ");
	_g_free0 (data);
	data = _tmp28_;
	_tmp29_ = data;
	_tmp30_ = string_replace (_tmp29_, "C", " C ");
	_g_free0 (data);
	data = _tmp30_;
	_tmp31_ = data;
	_tmp32_ = string_replace (_tmp31_, "t", " t ");
	_g_free0 (data);
	data = _tmp32_;
	_tmp33_ = data;
	_tmp34_ = string_replace (_tmp33_, "T", " T ");
	_g_free0 (data);
	data = _tmp34_;
	_tmp35_ = data;
	_tmp36_ = string_replace (_tmp35_, "s", " s ");
	_g_free0 (data);
	data = _tmp36_;
	_tmp37_ = data;
	_tmp38_ = string_replace (_tmp37_, "S", " S ");
	_g_free0 (data);
	data = _tmp38_;
	_tmp39_ = data;
	_tmp40_ = string_replace (_tmp39_, "zM", " z M ");
	_g_free0 (data);
	data = _tmp40_;
	_tmp41_ = data;
	_tmp42_ = string_replace (_tmp41_, "zm", " z m ");
	_g_free0 (data);
	data = _tmp42_;
	_tmp43_ = data;
	_tmp44_ = string_replace (_tmp43_, "z", " z ");
	_g_free0 (data);
	data = _tmp44_;
	_tmp45_ = data;
	_tmp46_ = string_replace (_tmp45_, "Z", " Z ");
	_g_free0 (data);
	data = _tmp46_;
	_tmp47_ = data;
	_tmp48_ = string_replace (_tmp47_, "-", " -");
	_g_free0 (data);
	data = _tmp48_;
	_tmp49_ = data;
	_tmp50_ = string_replace (_tmp49_, "e -", "e-");
	_g_free0 (data);
	data = _tmp50_;
	_tmp51_ = data;
	_tmp52_ = string_replace (_tmp51_, "\t", " ");
	_g_free0 (data);
	data = _tmp52_;
	_tmp53_ = data;
	_tmp54_ = string_replace (_tmp53_, "\r\n", " ");
	_g_free0 (data);
	data = _tmp54_;
	_tmp55_ = data;
	_tmp56_ = string_replace (_tmp55_, "\n", " ");
	_g_free0 (data);
	data = _tmp56_;
	_tmp57_ = data;
	_tmp58_ = string_replace (_tmp57_, "+", " ");
	_g_free0 (data);
	data = _tmp58_;
	while (TRUE) {
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp59_ = data;
		if (!(string_index_of (_tmp59_, "  ", 0) > -1)) {
			break;
		}
		_tmp60_ = data;
		_tmp61_ = string_replace (_tmp60_, "  ", " ");
		_g_free0 (data);
		data = _tmp61_;
	}
	result = data;
	return result;
}

void
bird_font_svg_parser_add_path_to_glyph (BirdFontSvgParser* self,
                                        const gchar* d,
                                        BirdFontGlyph* g,
                                        gboolean svg_glyph,
                                        gdouble units)
{
	BirdFontPathList* p = NULL;
	BirdFontPathList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_svg_parser_parse_svg_data (self, d, g, svg_glyph, units);
	p = _tmp0_;
	{
		GeeArrayList* _path_list = NULL;
		BirdFontPathList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp1_ = p;
		_tmp2_ = _tmp1_->paths;
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (BirdFontPath*) _tmp9_;
			_tmp10_ = path;
			bird_font_glyph_add_path (g, _tmp10_);
			_g_object_unref0 (path);
		}
	}
	_g_object_unref0 (p);
}

/** 
 * @param d svg data
 * @param glyph use lines from this glyph but don't add the generated paths
 * @param svg_glyph parse svg glyph with origo in lower left corner
 * 
 * @return the new paths
 */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

BirdFontPathList*
bird_font_svg_parser_parse_svg_data (BirdFontSvgParser* self,
                                     const gchar* d,
                                     BirdFontGlyph* glyph,
                                     gboolean svg_glyph,
                                     gdouble units)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble px2 = 0.0;
	gdouble py2 = 0.0;
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gchar* data = NULL;
	BirdFontFont* font = NULL;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontBezierPoints** bezier_points = NULL;
	gint bezier_points_length1 = 0;
	gint _bezier_points_size_ = 0;
	gchar** c = NULL;
	gint c_length1 = 0;
	gint _c_size_ = 0;
	gdouble arc_rx = 0.0;
	gdouble arc_ry = 0.0;
	gdouble arc_rotation = 0.0;
	gint large_arc = 0;
	gint arc_sweep = 0;
	gdouble arc_dest_x = 0.0;
	gdouble arc_dest_y = 0.0;
	gdouble first_point_x = 0.0;
	gdouble first_point_y = 0.0;
	gboolean set_first = FALSE;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	BirdFontBezierPoints** _tmp7_;
	gint bi = 0;
	gint i = 0;
	BirdFontBezierPoints** _tmp634_;
	gint _tmp634__length1;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	g_return_val_if_fail (glyph != NULL, NULL);
	px = (gdouble) 0;
	py = (gdouble) 0;
	px2 = (gdouble) 0;
	py2 = (gdouble) 0;
	cx = (gdouble) 0;
	cy = (gdouble) 0;
	_tmp0_ = bird_font_path_list_new ();
	path_list = _tmp0_;
	first_point_x = (gdouble) 0;
	first_point_y = (gdouble) 0;
	set_first = TRUE;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp1_;
	_tmp2_ = bird_font_svg_parser_add_separators (d);
	_g_free0 (data);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, " ", 0);
	c = (_vala_array_free (c, c_length1, (GDestroyNotify) g_free), NULL);
	c = _tmp5_;
	c_length1 = _vala_array_length (_tmp4_);
	_c_size_ = c_length1;
	_tmp6_ = c;
	_tmp6__length1 = c_length1;
	_tmp7_ = g_new0 (BirdFontBezierPoints*, ((8 * _tmp6__length1) + 2) + 1);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	bezier_points = _tmp7_;
	bezier_points_length1 = (8 * _tmp6__length1) + 2;
	_bezier_points_size_ = bezier_points_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gchar** _tmp10_;
				gint _tmp10__length1;
				BirdFontBezierPoints** _tmp11_;
				gint _tmp11__length1;
				BirdFontBezierPoints* _tmp12_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = c;
				_tmp10__length1 = c_length1;
				if (!(i < ((2 * _tmp10__length1) + 1))) {
					break;
				}
				_tmp11_ = bezier_points;
				_tmp11__length1 = bezier_points_length1;
				_tmp12_ = bird_font_bezier_points_new ();
				_bird_font_bezier_points_unref0 (_tmp11_[i]);
				_tmp11_[i] = _tmp12_;
			}
		}
	}
	bi = 0;
	i = -1;
	while (TRUE) {
		gboolean _tmp13_ = FALSE;
		gint _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		i = i + 1;
		_tmp14_ = i;
		_tmp15_ = c;
		_tmp15__length1 = c_length1;
		if (_tmp14_ < _tmp15__length1) {
			BirdFontBezierPoints** _tmp16_;
			gint _tmp16__length1;
			_tmp16_ = bezier_points;
			_tmp16__length1 = bezier_points_length1;
			_tmp13_ = bi < _tmp16__length1;
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			break;
		}
		_tmp17_ = c;
		_tmp17__length1 = c_length1;
		_tmp18_ = _tmp17_[i];
		if (g_strcmp0 (_tmp18_, "m") == 0) {
			while (TRUE) {
				gboolean _tmp19_ = FALSE;
				gchar** _tmp20_;
				gint _tmp20__length1;
				BirdFontBezierPoints** _tmp23_;
				gint _tmp23__length1;
				BirdFontBezierPoints* _tmp24_;
				BirdFontBezierPoints** _tmp25_;
				gint _tmp25__length1;
				BirdFontBezierPoints* _tmp26_;
				gchar** _tmp27_;
				gint _tmp27__length1;
				gint _tmp28_;
				const gchar* _tmp29_;
				BirdFontBezierPoints** _tmp36_;
				gint _tmp36__length1;
				BirdFontBezierPoints* _tmp37_;
				BirdFontBezierPoints** _tmp38_;
				gint _tmp38__length1;
				BirdFontBezierPoints* _tmp39_;
				gint _tmp40_;
				_tmp20_ = c;
				_tmp20__length1 = c_length1;
				if ((i + 2) < _tmp20__length1) {
					gchar** _tmp21_;
					gint _tmp21__length1;
					const gchar* _tmp22_;
					_tmp21_ = c;
					_tmp21__length1 = c_length1;
					_tmp22_ = _tmp21_[i + 1];
					_tmp19_ = bird_font_svg_parser_is_point (_tmp22_);
				} else {
					_tmp19_ = FALSE;
				}
				if (!_tmp19_) {
					break;
				}
				_tmp23_ = bezier_points;
				_tmp23__length1 = bezier_points_length1;
				_tmp24_ = _tmp23_[bi];
				_tmp24_->type = (gunichar) 'M';
				_tmp25_ = bezier_points;
				_tmp25__length1 = bezier_points_length1;
				_tmp26_ = _tmp25_[bi];
				_tmp26_->svg_type = (gunichar) 'm';
				_tmp27_ = c;
				_tmp27__length1 = c_length1;
				i = i + 1;
				_tmp28_ = i;
				_tmp29_ = _tmp27_[_tmp28_];
				px += bird_font_svg_parser_parse_double (_tmp29_);
				if (svg_glyph) {
					gchar** _tmp30_;
					gint _tmp30__length1;
					gint _tmp31_;
					const gchar* _tmp32_;
					_tmp30_ = c;
					_tmp30__length1 = c_length1;
					i = i + 1;
					_tmp31_ = i;
					_tmp32_ = _tmp30_[_tmp31_];
					py += bird_font_svg_parser_parse_double (_tmp32_);
				} else {
					gchar** _tmp33_;
					gint _tmp33__length1;
					gint _tmp34_;
					const gchar* _tmp35_;
					_tmp33_ = c;
					_tmp33__length1 = c_length1;
					i = i + 1;
					_tmp34_ = i;
					_tmp35_ = _tmp33_[_tmp34_];
					py += -bird_font_svg_parser_parse_double (_tmp35_);
				}
				_tmp36_ = bezier_points;
				_tmp36__length1 = bezier_points_length1;
				_tmp37_ = _tmp36_[bi];
				_tmp37_->x0 = px;
				_tmp38_ = bezier_points;
				_tmp38__length1 = bezier_points_length1;
				_tmp39_ = _tmp38_[bi];
				_tmp39_->y0 = py;
				first_point_x = px;
				first_point_y = py;
				set_first = FALSE;
				_tmp40_ = bi;
				bi = _tmp40_ + 1;
			}
		} else {
			gchar** _tmp41_;
			gint _tmp41__length1;
			const gchar* _tmp42_;
			_tmp41_ = c;
			_tmp41__length1 = c_length1;
			_tmp42_ = _tmp41_[i];
			if (g_strcmp0 (_tmp42_, "M") == 0) {
				while (TRUE) {
					gboolean _tmp43_ = FALSE;
					gchar** _tmp44_;
					gint _tmp44__length1;
					BirdFontBezierPoints** _tmp47_;
					gint _tmp47__length1;
					BirdFontBezierPoints* _tmp48_;
					BirdFontBezierPoints** _tmp49_;
					gint _tmp49__length1;
					BirdFontBezierPoints* _tmp50_;
					gchar** _tmp51_;
					gint _tmp51__length1;
					gint _tmp52_;
					const gchar* _tmp53_;
					BirdFontBezierPoints** _tmp60_;
					gint _tmp60__length1;
					BirdFontBezierPoints* _tmp61_;
					BirdFontBezierPoints** _tmp62_;
					gint _tmp62__length1;
					BirdFontBezierPoints* _tmp63_;
					gint _tmp64_;
					_tmp44_ = c;
					_tmp44__length1 = c_length1;
					if ((i + 2) < _tmp44__length1) {
						gchar** _tmp45_;
						gint _tmp45__length1;
						const gchar* _tmp46_;
						_tmp45_ = c;
						_tmp45__length1 = c_length1;
						_tmp46_ = _tmp45_[i + 1];
						_tmp43_ = bird_font_svg_parser_is_point (_tmp46_);
					} else {
						_tmp43_ = FALSE;
					}
					if (!_tmp43_) {
						break;
					}
					_tmp47_ = bezier_points;
					_tmp47__length1 = bezier_points_length1;
					_tmp48_ = _tmp47_[bi];
					_tmp48_->type = (gunichar) 'M';
					_tmp49_ = bezier_points;
					_tmp49__length1 = bezier_points_length1;
					_tmp50_ = _tmp49_[bi];
					_tmp50_->svg_type = (gunichar) 'M';
					_tmp51_ = c;
					_tmp51__length1 = c_length1;
					i = i + 1;
					_tmp52_ = i;
					_tmp53_ = _tmp51_[_tmp52_];
					px = bird_font_svg_parser_parse_double (_tmp53_);
					if (svg_glyph) {
						gchar** _tmp54_;
						gint _tmp54__length1;
						gint _tmp55_;
						const gchar* _tmp56_;
						_tmp54_ = c;
						_tmp54__length1 = c_length1;
						i = i + 1;
						_tmp55_ = i;
						_tmp56_ = _tmp54_[_tmp55_];
						py = bird_font_svg_parser_parse_double (_tmp56_);
					} else {
						gchar** _tmp57_;
						gint _tmp57__length1;
						gint _tmp58_;
						const gchar* _tmp59_;
						_tmp57_ = c;
						_tmp57__length1 = c_length1;
						i = i + 1;
						_tmp58_ = i;
						_tmp59_ = _tmp57_[_tmp58_];
						py = -bird_font_svg_parser_parse_double (_tmp59_);
					}
					_tmp60_ = bezier_points;
					_tmp60__length1 = bezier_points_length1;
					_tmp61_ = _tmp60_[bi];
					_tmp61_->x0 = px;
					_tmp62_ = bezier_points;
					_tmp62__length1 = bezier_points_length1;
					_tmp63_ = _tmp62_[bi];
					_tmp63_->y0 = py;
					first_point_x = px;
					first_point_y = py;
					set_first = FALSE;
					_tmp64_ = bi;
					bi = _tmp64_ + 1;
				}
			} else {
				gchar** _tmp65_;
				gint _tmp65__length1;
				const gchar* _tmp66_;
				_tmp65_ = c;
				_tmp65__length1 = c_length1;
				_tmp66_ = _tmp65_[i];
				if (g_strcmp0 (_tmp66_, "h") == 0) {
					while (TRUE) {
						gboolean _tmp67_ = FALSE;
						gchar** _tmp68_;
						gint _tmp68__length1;
						BirdFontBezierPoints** _tmp71_;
						gint _tmp71__length1;
						BirdFontBezierPoints* _tmp72_;
						BirdFontBezierPoints** _tmp73_;
						gint _tmp73__length1;
						BirdFontBezierPoints* _tmp74_;
						gchar** _tmp75_;
						gint _tmp75__length1;
						gint _tmp76_;
						const gchar* _tmp77_;
						BirdFontBezierPoints** _tmp78_;
						gint _tmp78__length1;
						BirdFontBezierPoints* _tmp79_;
						BirdFontBezierPoints** _tmp80_;
						gint _tmp80__length1;
						BirdFontBezierPoints* _tmp81_;
						gint _tmp82_;
						_tmp68_ = c;
						_tmp68__length1 = c_length1;
						if ((i + 1) < _tmp68__length1) {
							gchar** _tmp69_;
							gint _tmp69__length1;
							const gchar* _tmp70_;
							_tmp69_ = c;
							_tmp69__length1 = c_length1;
							_tmp70_ = _tmp69_[i + 1];
							_tmp67_ = bird_font_svg_parser_is_point (_tmp70_);
						} else {
							_tmp67_ = FALSE;
						}
						if (!_tmp67_) {
							break;
						}
						_tmp71_ = bezier_points;
						_tmp71__length1 = bezier_points_length1;
						_tmp72_ = _tmp71_[bi];
						_tmp72_->type = (gunichar) 'L';
						_tmp73_ = bezier_points;
						_tmp73__length1 = bezier_points_length1;
						_tmp74_ = _tmp73_[bi];
						_tmp74_->svg_type = (gunichar) 'h';
						_tmp75_ = c;
						_tmp75__length1 = c_length1;
						i = i + 1;
						_tmp76_ = i;
						_tmp77_ = _tmp75_[_tmp76_];
						px += bird_font_svg_parser_parse_double (_tmp77_);
						_tmp78_ = bezier_points;
						_tmp78__length1 = bezier_points_length1;
						_tmp79_ = _tmp78_[bi];
						_tmp79_->x0 = px;
						_tmp80_ = bezier_points;
						_tmp80__length1 = bezier_points_length1;
						_tmp81_ = _tmp80_[bi];
						_tmp81_->y0 = py;
						_tmp82_ = bi;
						bi = _tmp82_ + 1;
					}
				} else {
					gchar** _tmp83_;
					gint _tmp83__length1;
					const gchar* _tmp84_;
					_tmp83_ = c;
					_tmp83__length1 = c_length1;
					_tmp84_ = _tmp83_[i];
					if (g_strcmp0 (_tmp84_, "H") == 0) {
						while (TRUE) {
							gboolean _tmp85_ = FALSE;
							gchar** _tmp86_;
							gint _tmp86__length1;
							BirdFontBezierPoints** _tmp89_;
							gint _tmp89__length1;
							BirdFontBezierPoints* _tmp90_;
							BirdFontBezierPoints** _tmp91_;
							gint _tmp91__length1;
							BirdFontBezierPoints* _tmp92_;
							gchar** _tmp93_;
							gint _tmp93__length1;
							gint _tmp94_;
							const gchar* _tmp95_;
							BirdFontBezierPoints** _tmp96_;
							gint _tmp96__length1;
							BirdFontBezierPoints* _tmp97_;
							BirdFontBezierPoints** _tmp98_;
							gint _tmp98__length1;
							BirdFontBezierPoints* _tmp99_;
							gint _tmp100_;
							_tmp86_ = c;
							_tmp86__length1 = c_length1;
							if ((i + 1) < _tmp86__length1) {
								gchar** _tmp87_;
								gint _tmp87__length1;
								const gchar* _tmp88_;
								_tmp87_ = c;
								_tmp87__length1 = c_length1;
								_tmp88_ = _tmp87_[i + 1];
								_tmp85_ = bird_font_svg_parser_is_point (_tmp88_);
							} else {
								_tmp85_ = FALSE;
							}
							if (!_tmp85_) {
								break;
							}
							_tmp89_ = bezier_points;
							_tmp89__length1 = bezier_points_length1;
							_tmp90_ = _tmp89_[bi];
							_tmp90_->type = (gunichar) 'L';
							_tmp91_ = bezier_points;
							_tmp91__length1 = bezier_points_length1;
							_tmp92_ = _tmp91_[bi];
							_tmp92_->svg_type = (gunichar) 'H';
							_tmp93_ = c;
							_tmp93__length1 = c_length1;
							i = i + 1;
							_tmp94_ = i;
							_tmp95_ = _tmp93_[_tmp94_];
							px = bird_font_svg_parser_parse_double (_tmp95_);
							_tmp96_ = bezier_points;
							_tmp96__length1 = bezier_points_length1;
							_tmp97_ = _tmp96_[bi];
							_tmp97_->x0 = px;
							_tmp98_ = bezier_points;
							_tmp98__length1 = bezier_points_length1;
							_tmp99_ = _tmp98_[bi];
							_tmp99_->y0 = py;
							_tmp100_ = bi;
							bi = _tmp100_ + 1;
						}
					} else {
						gchar** _tmp101_;
						gint _tmp101__length1;
						const gchar* _tmp102_;
						_tmp101_ = c;
						_tmp101__length1 = c_length1;
						_tmp102_ = _tmp101_[i];
						if (g_strcmp0 (_tmp102_, "v") == 0) {
							while (TRUE) {
								gboolean _tmp103_ = FALSE;
								gchar** _tmp104_;
								gint _tmp104__length1;
								BirdFontBezierPoints** _tmp107_;
								gint _tmp107__length1;
								BirdFontBezierPoints* _tmp108_;
								BirdFontBezierPoints** _tmp109_;
								gint _tmp109__length1;
								BirdFontBezierPoints* _tmp110_;
								BirdFontBezierPoints** _tmp119_;
								gint _tmp119__length1;
								BirdFontBezierPoints* _tmp120_;
								BirdFontBezierPoints** _tmp121_;
								gint _tmp121__length1;
								BirdFontBezierPoints* _tmp122_;
								gint _tmp123_;
								_tmp104_ = c;
								_tmp104__length1 = c_length1;
								if ((i + 1) < _tmp104__length1) {
									gchar** _tmp105_;
									gint _tmp105__length1;
									const gchar* _tmp106_;
									_tmp105_ = c;
									_tmp105__length1 = c_length1;
									_tmp106_ = _tmp105_[i + 1];
									_tmp103_ = bird_font_svg_parser_is_point (_tmp106_);
								} else {
									_tmp103_ = FALSE;
								}
								if (!_tmp103_) {
									break;
								}
								_tmp107_ = bezier_points;
								_tmp107__length1 = bezier_points_length1;
								_tmp108_ = _tmp107_[bi];
								_tmp108_->type = (gunichar) 'L';
								_tmp109_ = bezier_points;
								_tmp109__length1 = bezier_points_length1;
								_tmp110_ = _tmp109_[bi];
								_tmp110_->svg_type = (gunichar) 'v';
								if (svg_glyph) {
									gdouble _tmp111_;
									gchar** _tmp112_;
									gint _tmp112__length1;
									gint _tmp113_;
									const gchar* _tmp114_;
									_tmp111_ = py;
									_tmp112_ = c;
									_tmp112__length1 = c_length1;
									i = i + 1;
									_tmp113_ = i;
									_tmp114_ = _tmp112_[_tmp113_];
									py = _tmp111_ + bird_font_svg_parser_parse_double (_tmp114_);
								} else {
									gdouble _tmp115_;
									gchar** _tmp116_;
									gint _tmp116__length1;
									gint _tmp117_;
									const gchar* _tmp118_;
									_tmp115_ = py;
									_tmp116_ = c;
									_tmp116__length1 = c_length1;
									i = i + 1;
									_tmp117_ = i;
									_tmp118_ = _tmp116_[_tmp117_];
									py = _tmp115_ - bird_font_svg_parser_parse_double (_tmp118_);
								}
								_tmp119_ = bezier_points;
								_tmp119__length1 = bezier_points_length1;
								_tmp120_ = _tmp119_[bi];
								_tmp120_->x0 = px;
								_tmp121_ = bezier_points;
								_tmp121__length1 = bezier_points_length1;
								_tmp122_ = _tmp121_[bi];
								_tmp122_->y0 = py;
								_tmp123_ = bi;
								bi = _tmp123_ + 1;
							}
						} else {
							gboolean _tmp124_ = FALSE;
							gchar** _tmp125_;
							gint _tmp125__length1;
							_tmp125_ = c;
							_tmp125__length1 = c_length1;
							if ((i + 1) < _tmp125__length1) {
								gchar** _tmp126_;
								gint _tmp126__length1;
								const gchar* _tmp127_;
								_tmp126_ = c;
								_tmp126__length1 = c_length1;
								_tmp127_ = _tmp126_[i];
								_tmp124_ = g_strcmp0 (_tmp127_, "V") == 0;
							} else {
								_tmp124_ = FALSE;
							}
							if (_tmp124_) {
								while (TRUE) {
									gchar** _tmp128_;
									gint _tmp128__length1;
									const gchar* _tmp129_;
									BirdFontBezierPoints** _tmp130_;
									gint _tmp130__length1;
									BirdFontBezierPoints* _tmp131_;
									BirdFontBezierPoints** _tmp132_;
									gint _tmp132__length1;
									BirdFontBezierPoints* _tmp133_;
									BirdFontBezierPoints** _tmp140_;
									gint _tmp140__length1;
									BirdFontBezierPoints* _tmp141_;
									BirdFontBezierPoints** _tmp142_;
									gint _tmp142__length1;
									BirdFontBezierPoints* _tmp143_;
									gint _tmp144_;
									_tmp128_ = c;
									_tmp128__length1 = c_length1;
									_tmp129_ = _tmp128_[i + 1];
									if (!bird_font_svg_parser_is_point (_tmp129_)) {
										break;
									}
									_tmp130_ = bezier_points;
									_tmp130__length1 = bezier_points_length1;
									_tmp131_ = _tmp130_[bi];
									_tmp131_->type = (gunichar) 'L';
									_tmp132_ = bezier_points;
									_tmp132__length1 = bezier_points_length1;
									_tmp133_ = _tmp132_[bi];
									_tmp133_->svg_type = (gunichar) 'V';
									if (svg_glyph) {
										gchar** _tmp134_;
										gint _tmp134__length1;
										gint _tmp135_;
										const gchar* _tmp136_;
										_tmp134_ = c;
										_tmp134__length1 = c_length1;
										i = i + 1;
										_tmp135_ = i;
										_tmp136_ = _tmp134_[_tmp135_];
										py = bird_font_svg_parser_parse_double (_tmp136_);
									} else {
										gchar** _tmp137_;
										gint _tmp137__length1;
										gint _tmp138_;
										const gchar* _tmp139_;
										_tmp137_ = c;
										_tmp137__length1 = c_length1;
										i = i + 1;
										_tmp138_ = i;
										_tmp139_ = _tmp137_[_tmp138_];
										py = -bird_font_svg_parser_parse_double (_tmp139_);
									}
									_tmp140_ = bezier_points;
									_tmp140__length1 = bezier_points_length1;
									_tmp141_ = _tmp140_[bi];
									_tmp141_->x0 = px;
									_tmp142_ = bezier_points;
									_tmp142__length1 = bezier_points_length1;
									_tmp143_ = _tmp142_[bi];
									_tmp143_->y0 = py;
									_tmp144_ = bi;
									bi = _tmp144_ + 1;
								}
							} else {
								gchar** _tmp145_;
								gint _tmp145__length1;
								const gchar* _tmp146_;
								_tmp145_ = c;
								_tmp145__length1 = c_length1;
								_tmp146_ = _tmp145_[i];
								if (g_strcmp0 (_tmp146_, "l") == 0) {
									while (TRUE) {
										gboolean _tmp147_ = FALSE;
										gchar** _tmp148_;
										gint _tmp148__length1;
										BirdFontBezierPoints** _tmp151_;
										gint _tmp151__length1;
										BirdFontBezierPoints* _tmp152_;
										BirdFontBezierPoints** _tmp153_;
										gint _tmp153__length1;
										BirdFontBezierPoints* _tmp154_;
										gdouble _tmp155_;
										gchar** _tmp156_;
										gint _tmp156__length1;
										gint _tmp157_;
										const gchar* _tmp158_;
										BirdFontBezierPoints** _tmp167_;
										gint _tmp167__length1;
										BirdFontBezierPoints* _tmp168_;
										BirdFontBezierPoints** _tmp169_;
										gint _tmp169__length1;
										BirdFontBezierPoints* _tmp170_;
										gint _tmp171_;
										_tmp148_ = c;
										_tmp148__length1 = c_length1;
										if ((i + 2) < _tmp148__length1) {
											gchar** _tmp149_;
											gint _tmp149__length1;
											const gchar* _tmp150_;
											_tmp149_ = c;
											_tmp149__length1 = c_length1;
											_tmp150_ = _tmp149_[i + 1];
											_tmp147_ = bird_font_svg_parser_is_point (_tmp150_);
										} else {
											_tmp147_ = FALSE;
										}
										if (!_tmp147_) {
											break;
										}
										_tmp151_ = bezier_points;
										_tmp151__length1 = bezier_points_length1;
										_tmp152_ = _tmp151_[bi];
										_tmp152_->type = (gunichar) 'L';
										_tmp153_ = bezier_points;
										_tmp153__length1 = bezier_points_length1;
										_tmp154_ = _tmp153_[bi];
										_tmp154_->svg_type = (gunichar) 'l';
										_tmp155_ = px;
										_tmp156_ = c;
										_tmp156__length1 = c_length1;
										i = i + 1;
										_tmp157_ = i;
										_tmp158_ = _tmp156_[_tmp157_];
										cx = _tmp155_ + bird_font_svg_parser_parse_double (_tmp158_);
										if (svg_glyph) {
											gdouble _tmp159_;
											gchar** _tmp160_;
											gint _tmp160__length1;
											gint _tmp161_;
											const gchar* _tmp162_;
											_tmp159_ = py;
											_tmp160_ = c;
											_tmp160__length1 = c_length1;
											i = i + 1;
											_tmp161_ = i;
											_tmp162_ = _tmp160_[_tmp161_];
											cy = _tmp159_ + bird_font_svg_parser_parse_double (_tmp162_);
										} else {
											gdouble _tmp163_;
											gchar** _tmp164_;
											gint _tmp164__length1;
											gint _tmp165_;
											const gchar* _tmp166_;
											_tmp163_ = py;
											_tmp164_ = c;
											_tmp164__length1 = c_length1;
											i = i + 1;
											_tmp165_ = i;
											_tmp166_ = _tmp164_[_tmp165_];
											cy = _tmp163_ - bird_font_svg_parser_parse_double (_tmp166_);
										}
										px = cx;
										py = cy;
										_tmp167_ = bezier_points;
										_tmp167__length1 = bezier_points_length1;
										_tmp168_ = _tmp167_[bi];
										_tmp168_->x0 = cx;
										_tmp169_ = bezier_points;
										_tmp169__length1 = bezier_points_length1;
										_tmp170_ = _tmp169_[bi];
										_tmp170_->y0 = cy;
										_tmp171_ = bi;
										bi = _tmp171_ + 1;
									}
								} else {
									gchar** _tmp172_;
									gint _tmp172__length1;
									const gchar* _tmp173_;
									_tmp172_ = c;
									_tmp172__length1 = c_length1;
									_tmp173_ = _tmp172_[i];
									if (g_strcmp0 (_tmp173_, "L") == 0) {
										while (TRUE) {
											gboolean _tmp174_ = FALSE;
											gchar** _tmp175_;
											gint _tmp175__length1;
											BirdFontBezierPoints** _tmp178_;
											gint _tmp178__length1;
											BirdFontBezierPoints* _tmp179_;
											BirdFontBezierPoints** _tmp180_;
											gint _tmp180__length1;
											BirdFontBezierPoints* _tmp181_;
											gchar** _tmp182_;
											gint _tmp182__length1;
											gint _tmp183_;
											const gchar* _tmp184_;
											BirdFontBezierPoints** _tmp191_;
											gint _tmp191__length1;
											BirdFontBezierPoints* _tmp192_;
											BirdFontBezierPoints** _tmp193_;
											gint _tmp193__length1;
											BirdFontBezierPoints* _tmp194_;
											gint _tmp195_;
											_tmp175_ = c;
											_tmp175__length1 = c_length1;
											if ((i + 2) < _tmp175__length1) {
												gchar** _tmp176_;
												gint _tmp176__length1;
												const gchar* _tmp177_;
												_tmp176_ = c;
												_tmp176__length1 = c_length1;
												_tmp177_ = _tmp176_[i + 1];
												_tmp174_ = bird_font_svg_parser_is_point (_tmp177_);
											} else {
												_tmp174_ = FALSE;
											}
											if (!_tmp174_) {
												break;
											}
											_tmp178_ = bezier_points;
											_tmp178__length1 = bezier_points_length1;
											_tmp179_ = _tmp178_[bi];
											_tmp179_->type = (gunichar) 'L';
											_tmp180_ = bezier_points;
											_tmp180__length1 = bezier_points_length1;
											_tmp181_ = _tmp180_[bi];
											_tmp181_->svg_type = (gunichar) 'L';
											_tmp182_ = c;
											_tmp182__length1 = c_length1;
											i = i + 1;
											_tmp183_ = i;
											_tmp184_ = _tmp182_[_tmp183_];
											cx = bird_font_svg_parser_parse_double (_tmp184_);
											if (svg_glyph) {
												gchar** _tmp185_;
												gint _tmp185__length1;
												gint _tmp186_;
												const gchar* _tmp187_;
												_tmp185_ = c;
												_tmp185__length1 = c_length1;
												i = i + 1;
												_tmp186_ = i;
												_tmp187_ = _tmp185_[_tmp186_];
												cy = bird_font_svg_parser_parse_double (_tmp187_);
											} else {
												gchar** _tmp188_;
												gint _tmp188__length1;
												gint _tmp189_;
												const gchar* _tmp190_;
												_tmp188_ = c;
												_tmp188__length1 = c_length1;
												i = i + 1;
												_tmp189_ = i;
												_tmp190_ = _tmp188_[_tmp189_];
												cy = -bird_font_svg_parser_parse_double (_tmp190_);
											}
											px = cx;
											py = cy;
											_tmp191_ = bezier_points;
											_tmp191__length1 = bezier_points_length1;
											_tmp192_ = _tmp191_[bi];
											_tmp192_->x0 = cx;
											_tmp193_ = bezier_points;
											_tmp193__length1 = bezier_points_length1;
											_tmp194_ = _tmp193_[bi];
											_tmp194_->y0 = cy;
											_tmp195_ = bi;
											bi = _tmp195_ + 1;
										}
									} else {
										gchar** _tmp196_;
										gint _tmp196__length1;
										const gchar* _tmp197_;
										_tmp196_ = c;
										_tmp196__length1 = c_length1;
										_tmp197_ = _tmp196_[i];
										if (g_strcmp0 (_tmp197_, "c") == 0) {
											while (TRUE) {
												gboolean _tmp198_ = FALSE;
												gchar** _tmp199_;
												gint _tmp199__length1;
												BirdFontBezierPoints** _tmp202_;
												gint _tmp202__length1;
												BirdFontBezierPoints* _tmp203_;
												BirdFontBezierPoints** _tmp204_;
												gint _tmp204__length1;
												BirdFontBezierPoints* _tmp205_;
												gdouble _tmp206_;
												gchar** _tmp207_;
												gint _tmp207__length1;
												gint _tmp208_;
												const gchar* _tmp209_;
												BirdFontBezierPoints** _tmp218_;
												gint _tmp218__length1;
												BirdFontBezierPoints* _tmp219_;
												BirdFontBezierPoints** _tmp220_;
												gint _tmp220__length1;
												BirdFontBezierPoints* _tmp221_;
												gdouble _tmp222_;
												gchar** _tmp223_;
												gint _tmp223__length1;
												gint _tmp224_;
												const gchar* _tmp225_;
												BirdFontBezierPoints** _tmp234_;
												gint _tmp234__length1;
												BirdFontBezierPoints* _tmp235_;
												BirdFontBezierPoints** _tmp236_;
												gint _tmp236__length1;
												BirdFontBezierPoints* _tmp237_;
												gdouble _tmp238_;
												gchar** _tmp239_;
												gint _tmp239__length1;
												gint _tmp240_;
												const gchar* _tmp241_;
												BirdFontBezierPoints** _tmp250_;
												gint _tmp250__length1;
												BirdFontBezierPoints* _tmp251_;
												BirdFontBezierPoints** _tmp252_;
												gint _tmp252__length1;
												BirdFontBezierPoints* _tmp253_;
												gint _tmp254_;
												_tmp199_ = c;
												_tmp199__length1 = c_length1;
												if ((i + 6) < _tmp199__length1) {
													gchar** _tmp200_;
													gint _tmp200__length1;
													const gchar* _tmp201_;
													_tmp200_ = c;
													_tmp200__length1 = c_length1;
													_tmp201_ = _tmp200_[i + 1];
													_tmp198_ = bird_font_svg_parser_is_point (_tmp201_);
												} else {
													_tmp198_ = FALSE;
												}
												if (!_tmp198_) {
													break;
												}
												_tmp202_ = bezier_points;
												_tmp202__length1 = bezier_points_length1;
												_tmp203_ = _tmp202_[bi];
												_tmp203_->type = (gunichar) 'C';
												_tmp204_ = bezier_points;
												_tmp204__length1 = bezier_points_length1;
												_tmp205_ = _tmp204_[bi];
												_tmp205_->svg_type = (gunichar) 'C';
												_tmp206_ = px;
												_tmp207_ = c;
												_tmp207__length1 = c_length1;
												i = i + 1;
												_tmp208_ = i;
												_tmp209_ = _tmp207_[_tmp208_];
												cx = _tmp206_ + bird_font_svg_parser_parse_double (_tmp209_);
												if (svg_glyph) {
													gdouble _tmp210_;
													gchar** _tmp211_;
													gint _tmp211__length1;
													gint _tmp212_;
													const gchar* _tmp213_;
													_tmp210_ = py;
													_tmp211_ = c;
													_tmp211__length1 = c_length1;
													i = i + 1;
													_tmp212_ = i;
													_tmp213_ = _tmp211_[_tmp212_];
													cy = _tmp210_ + bird_font_svg_parser_parse_double (_tmp213_);
												} else {
													gdouble _tmp214_;
													gchar** _tmp215_;
													gint _tmp215__length1;
													gint _tmp216_;
													const gchar* _tmp217_;
													_tmp214_ = py;
													_tmp215_ = c;
													_tmp215__length1 = c_length1;
													i = i + 1;
													_tmp216_ = i;
													_tmp217_ = _tmp215_[_tmp216_];
													cy = _tmp214_ - bird_font_svg_parser_parse_double (_tmp217_);
												}
												_tmp218_ = bezier_points;
												_tmp218__length1 = bezier_points_length1;
												_tmp219_ = _tmp218_[bi];
												_tmp219_->x0 = cx;
												_tmp220_ = bezier_points;
												_tmp220__length1 = bezier_points_length1;
												_tmp221_ = _tmp220_[bi];
												_tmp221_->y0 = cy;
												_tmp222_ = px;
												_tmp223_ = c;
												_tmp223__length1 = c_length1;
												i = i + 1;
												_tmp224_ = i;
												_tmp225_ = _tmp223_[_tmp224_];
												cx = _tmp222_ + bird_font_svg_parser_parse_double (_tmp225_);
												if (svg_glyph) {
													gdouble _tmp226_;
													gchar** _tmp227_;
													gint _tmp227__length1;
													gint _tmp228_;
													const gchar* _tmp229_;
													_tmp226_ = py;
													_tmp227_ = c;
													_tmp227__length1 = c_length1;
													i = i + 1;
													_tmp228_ = i;
													_tmp229_ = _tmp227_[_tmp228_];
													cy = _tmp226_ + bird_font_svg_parser_parse_double (_tmp229_);
												} else {
													gdouble _tmp230_;
													gchar** _tmp231_;
													gint _tmp231__length1;
													gint _tmp232_;
													const gchar* _tmp233_;
													_tmp230_ = py;
													_tmp231_ = c;
													_tmp231__length1 = c_length1;
													i = i + 1;
													_tmp232_ = i;
													_tmp233_ = _tmp231_[_tmp232_];
													cy = _tmp230_ - bird_font_svg_parser_parse_double (_tmp233_);
												}
												px2 = cx;
												py2 = cy;
												_tmp234_ = bezier_points;
												_tmp234__length1 = bezier_points_length1;
												_tmp235_ = _tmp234_[bi];
												_tmp235_->x1 = px2;
												_tmp236_ = bezier_points;
												_tmp236__length1 = bezier_points_length1;
												_tmp237_ = _tmp236_[bi];
												_tmp237_->y1 = py2;
												_tmp238_ = px;
												_tmp239_ = c;
												_tmp239__length1 = c_length1;
												i = i + 1;
												_tmp240_ = i;
												_tmp241_ = _tmp239_[_tmp240_];
												cx = _tmp238_ + bird_font_svg_parser_parse_double (_tmp241_);
												if (svg_glyph) {
													gdouble _tmp242_;
													gchar** _tmp243_;
													gint _tmp243__length1;
													gint _tmp244_;
													const gchar* _tmp245_;
													_tmp242_ = py;
													_tmp243_ = c;
													_tmp243__length1 = c_length1;
													i = i + 1;
													_tmp244_ = i;
													_tmp245_ = _tmp243_[_tmp244_];
													cy = _tmp242_ + bird_font_svg_parser_parse_double (_tmp245_);
												} else {
													gdouble _tmp246_;
													gchar** _tmp247_;
													gint _tmp247__length1;
													gint _tmp248_;
													const gchar* _tmp249_;
													_tmp246_ = py;
													_tmp247_ = c;
													_tmp247__length1 = c_length1;
													i = i + 1;
													_tmp248_ = i;
													_tmp249_ = _tmp247_[_tmp248_];
													cy = _tmp246_ + (-bird_font_svg_parser_parse_double (_tmp249_));
												}
												_tmp250_ = bezier_points;
												_tmp250__length1 = bezier_points_length1;
												_tmp251_ = _tmp250_[bi];
												_tmp251_->x2 = cx;
												_tmp252_ = bezier_points;
												_tmp252__length1 = bezier_points_length1;
												_tmp253_ = _tmp252_[bi];
												_tmp253_->y2 = cy;
												px = cx;
												py = cy;
												_tmp254_ = bi;
												bi = _tmp254_ + 1;
											}
										} else {
											gchar** _tmp255_;
											gint _tmp255__length1;
											const gchar* _tmp256_;
											_tmp255_ = c;
											_tmp255__length1 = c_length1;
											_tmp256_ = _tmp255_[i];
											if (g_strcmp0 (_tmp256_, "C") == 0) {
												while (TRUE) {
													gboolean _tmp257_ = FALSE;
													gchar** _tmp258_;
													gint _tmp258__length1;
													BirdFontBezierPoints** _tmp261_;
													gint _tmp261__length1;
													BirdFontBezierPoints* _tmp262_;
													BirdFontBezierPoints** _tmp263_;
													gint _tmp263__length1;
													BirdFontBezierPoints* _tmp264_;
													gchar** _tmp265_;
													gint _tmp265__length1;
													gint _tmp266_;
													const gchar* _tmp267_;
													BirdFontBezierPoints** _tmp274_;
													gint _tmp274__length1;
													BirdFontBezierPoints* _tmp275_;
													BirdFontBezierPoints** _tmp276_;
													gint _tmp276__length1;
													BirdFontBezierPoints* _tmp277_;
													gchar** _tmp278_;
													gint _tmp278__length1;
													gint _tmp279_;
													const gchar* _tmp280_;
													BirdFontBezierPoints** _tmp287_;
													gint _tmp287__length1;
													BirdFontBezierPoints* _tmp288_;
													BirdFontBezierPoints** _tmp289_;
													gint _tmp289__length1;
													BirdFontBezierPoints* _tmp290_;
													gchar** _tmp291_;
													gint _tmp291__length1;
													gint _tmp292_;
													const gchar* _tmp293_;
													BirdFontBezierPoints** _tmp300_;
													gint _tmp300__length1;
													BirdFontBezierPoints* _tmp301_;
													BirdFontBezierPoints** _tmp302_;
													gint _tmp302__length1;
													BirdFontBezierPoints* _tmp303_;
													gint _tmp304_;
													_tmp258_ = c;
													_tmp258__length1 = c_length1;
													if ((i + 6) < _tmp258__length1) {
														gchar** _tmp259_;
														gint _tmp259__length1;
														const gchar* _tmp260_;
														_tmp259_ = c;
														_tmp259__length1 = c_length1;
														_tmp260_ = _tmp259_[i + 1];
														_tmp257_ = bird_font_svg_parser_is_point (_tmp260_);
													} else {
														_tmp257_ = FALSE;
													}
													if (!_tmp257_) {
														break;
													}
													_tmp261_ = bezier_points;
													_tmp261__length1 = bezier_points_length1;
													_tmp262_ = _tmp261_[bi];
													_tmp262_->type = (gunichar) 'C';
													_tmp263_ = bezier_points;
													_tmp263__length1 = bezier_points_length1;
													_tmp264_ = _tmp263_[bi];
													_tmp264_->svg_type = (gunichar) 'C';
													_tmp265_ = c;
													_tmp265__length1 = c_length1;
													i = i + 1;
													_tmp266_ = i;
													_tmp267_ = _tmp265_[_tmp266_];
													cx = bird_font_svg_parser_parse_double (_tmp267_);
													if (svg_glyph) {
														gchar** _tmp268_;
														gint _tmp268__length1;
														gint _tmp269_;
														const gchar* _tmp270_;
														_tmp268_ = c;
														_tmp268__length1 = c_length1;
														i = i + 1;
														_tmp269_ = i;
														_tmp270_ = _tmp268_[_tmp269_];
														cy = bird_font_svg_parser_parse_double (_tmp270_);
													} else {
														gchar** _tmp271_;
														gint _tmp271__length1;
														gint _tmp272_;
														const gchar* _tmp273_;
														_tmp271_ = c;
														_tmp271__length1 = c_length1;
														i = i + 1;
														_tmp272_ = i;
														_tmp273_ = _tmp271_[_tmp272_];
														cy = -bird_font_svg_parser_parse_double (_tmp273_);
													}
													_tmp274_ = bezier_points;
													_tmp274__length1 = bezier_points_length1;
													_tmp275_ = _tmp274_[bi];
													_tmp275_->x0 = cx;
													_tmp276_ = bezier_points;
													_tmp276__length1 = bezier_points_length1;
													_tmp277_ = _tmp276_[bi];
													_tmp277_->y0 = cy;
													_tmp278_ = c;
													_tmp278__length1 = c_length1;
													i = i + 1;
													_tmp279_ = i;
													_tmp280_ = _tmp278_[_tmp279_];
													cx = bird_font_svg_parser_parse_double (_tmp280_);
													if (svg_glyph) {
														gchar** _tmp281_;
														gint _tmp281__length1;
														gint _tmp282_;
														const gchar* _tmp283_;
														_tmp281_ = c;
														_tmp281__length1 = c_length1;
														i = i + 1;
														_tmp282_ = i;
														_tmp283_ = _tmp281_[_tmp282_];
														cy = bird_font_svg_parser_parse_double (_tmp283_);
													} else {
														gchar** _tmp284_;
														gint _tmp284__length1;
														gint _tmp285_;
														const gchar* _tmp286_;
														_tmp284_ = c;
														_tmp284__length1 = c_length1;
														i = i + 1;
														_tmp285_ = i;
														_tmp286_ = _tmp284_[_tmp285_];
														cy = -bird_font_svg_parser_parse_double (_tmp286_);
													}
													px2 = cx;
													py2 = cy;
													_tmp287_ = bezier_points;
													_tmp287__length1 = bezier_points_length1;
													_tmp288_ = _tmp287_[bi];
													_tmp288_->x1 = cx;
													_tmp289_ = bezier_points;
													_tmp289__length1 = bezier_points_length1;
													_tmp290_ = _tmp289_[bi];
													_tmp290_->y1 = cy;
													_tmp291_ = c;
													_tmp291__length1 = c_length1;
													i = i + 1;
													_tmp292_ = i;
													_tmp293_ = _tmp291_[_tmp292_];
													cx = bird_font_svg_parser_parse_double (_tmp293_);
													if (svg_glyph) {
														gchar** _tmp294_;
														gint _tmp294__length1;
														gint _tmp295_;
														const gchar* _tmp296_;
														_tmp294_ = c;
														_tmp294__length1 = c_length1;
														i = i + 1;
														_tmp295_ = i;
														_tmp296_ = _tmp294_[_tmp295_];
														cy = bird_font_svg_parser_parse_double (_tmp296_);
													} else {
														gchar** _tmp297_;
														gint _tmp297__length1;
														gint _tmp298_;
														const gchar* _tmp299_;
														_tmp297_ = c;
														_tmp297__length1 = c_length1;
														i = i + 1;
														_tmp298_ = i;
														_tmp299_ = _tmp297_[_tmp298_];
														cy = -bird_font_svg_parser_parse_double (_tmp299_);
													}
													_tmp300_ = bezier_points;
													_tmp300__length1 = bezier_points_length1;
													_tmp301_ = _tmp300_[bi];
													_tmp301_->x2 = cx;
													_tmp302_ = bezier_points;
													_tmp302__length1 = bezier_points_length1;
													_tmp303_ = _tmp302_[bi];
													_tmp303_->y2 = cy;
													px = cx;
													py = cy;
													_tmp304_ = bi;
													bi = _tmp304_ + 1;
												}
											} else {
												gchar** _tmp305_;
												gint _tmp305__length1;
												const gchar* _tmp306_;
												_tmp305_ = c;
												_tmp305__length1 = c_length1;
												_tmp306_ = _tmp305_[i];
												if (g_strcmp0 (_tmp306_, "q") == 0) {
													while (TRUE) {
														gboolean _tmp307_ = FALSE;
														gchar** _tmp308_;
														gint _tmp308__length1;
														BirdFontBezierPoints** _tmp311_;
														gint _tmp311__length1;
														BirdFontBezierPoints* _tmp312_;
														BirdFontBezierPoints** _tmp313_;
														gint _tmp313__length1;
														BirdFontBezierPoints* _tmp314_;
														gdouble _tmp315_;
														gchar** _tmp316_;
														gint _tmp316__length1;
														gint _tmp317_;
														const gchar* _tmp318_;
														BirdFontBezierPoints** _tmp327_;
														gint _tmp327__length1;
														BirdFontBezierPoints* _tmp328_;
														BirdFontBezierPoints** _tmp329_;
														gint _tmp329__length1;
														BirdFontBezierPoints* _tmp330_;
														gdouble _tmp331_;
														gchar** _tmp332_;
														gint _tmp332__length1;
														gint _tmp333_;
														const gchar* _tmp334_;
														BirdFontBezierPoints** _tmp343_;
														gint _tmp343__length1;
														BirdFontBezierPoints* _tmp344_;
														BirdFontBezierPoints** _tmp345_;
														gint _tmp345__length1;
														BirdFontBezierPoints* _tmp346_;
														gint _tmp347_;
														_tmp308_ = c;
														_tmp308__length1 = c_length1;
														if ((i + 4) < _tmp308__length1) {
															gchar** _tmp309_;
															gint _tmp309__length1;
															const gchar* _tmp310_;
															_tmp309_ = c;
															_tmp309__length1 = c_length1;
															_tmp310_ = _tmp309_[i + 1];
															_tmp307_ = bird_font_svg_parser_is_point (_tmp310_);
														} else {
															_tmp307_ = FALSE;
														}
														if (!_tmp307_) {
															break;
														}
														_tmp311_ = bezier_points;
														_tmp311__length1 = bezier_points_length1;
														_tmp312_ = _tmp311_[bi];
														_tmp312_->type = (gunichar) 'Q';
														_tmp313_ = bezier_points;
														_tmp313__length1 = bezier_points_length1;
														_tmp314_ = _tmp313_[bi];
														_tmp314_->svg_type = (gunichar) 'q';
														_tmp315_ = px;
														_tmp316_ = c;
														_tmp316__length1 = c_length1;
														i = i + 1;
														_tmp317_ = i;
														_tmp318_ = _tmp316_[_tmp317_];
														cx = _tmp315_ + bird_font_svg_parser_parse_double (_tmp318_);
														if (svg_glyph) {
															gdouble _tmp319_;
															gchar** _tmp320_;
															gint _tmp320__length1;
															gint _tmp321_;
															const gchar* _tmp322_;
															_tmp319_ = py;
															_tmp320_ = c;
															_tmp320__length1 = c_length1;
															i = i + 1;
															_tmp321_ = i;
															_tmp322_ = _tmp320_[_tmp321_];
															cy = _tmp319_ + bird_font_svg_parser_parse_double (_tmp322_);
														} else {
															gdouble _tmp323_;
															gchar** _tmp324_;
															gint _tmp324__length1;
															gint _tmp325_;
															const gchar* _tmp326_;
															_tmp323_ = py;
															_tmp324_ = c;
															_tmp324__length1 = c_length1;
															i = i + 1;
															_tmp325_ = i;
															_tmp326_ = _tmp324_[_tmp325_];
															cy = _tmp323_ - bird_font_svg_parser_parse_double (_tmp326_);
														}
														_tmp327_ = bezier_points;
														_tmp327__length1 = bezier_points_length1;
														_tmp328_ = _tmp327_[bi];
														_tmp328_->x0 = cx;
														_tmp329_ = bezier_points;
														_tmp329__length1 = bezier_points_length1;
														_tmp330_ = _tmp329_[bi];
														_tmp330_->y0 = cy;
														px2 = cx;
														py2 = cy;
														_tmp331_ = px;
														_tmp332_ = c;
														_tmp332__length1 = c_length1;
														i = i + 1;
														_tmp333_ = i;
														_tmp334_ = _tmp332_[_tmp333_];
														cx = _tmp331_ + bird_font_svg_parser_parse_double (_tmp334_);
														if (svg_glyph) {
															gdouble _tmp335_;
															gchar** _tmp336_;
															gint _tmp336__length1;
															gint _tmp337_;
															const gchar* _tmp338_;
															_tmp335_ = py;
															_tmp336_ = c;
															_tmp336__length1 = c_length1;
															i = i + 1;
															_tmp337_ = i;
															_tmp338_ = _tmp336_[_tmp337_];
															cy = _tmp335_ + bird_font_svg_parser_parse_double (_tmp338_);
														} else {
															gdouble _tmp339_;
															gchar** _tmp340_;
															gint _tmp340__length1;
															gint _tmp341_;
															const gchar* _tmp342_;
															_tmp339_ = py;
															_tmp340_ = c;
															_tmp340__length1 = c_length1;
															i = i + 1;
															_tmp341_ = i;
															_tmp342_ = _tmp340_[_tmp341_];
															cy = _tmp339_ - bird_font_svg_parser_parse_double (_tmp342_);
														}
														_tmp343_ = bezier_points;
														_tmp343__length1 = bezier_points_length1;
														_tmp344_ = _tmp343_[bi];
														_tmp344_->x1 = cx;
														_tmp345_ = bezier_points;
														_tmp345__length1 = bezier_points_length1;
														_tmp346_ = _tmp345_[bi];
														_tmp346_->y1 = cy;
														px = cx;
														py = cy;
														_tmp347_ = bi;
														bi = _tmp347_ + 1;
													}
												} else {
													gchar** _tmp348_;
													gint _tmp348__length1;
													const gchar* _tmp349_;
													_tmp348_ = c;
													_tmp348__length1 = c_length1;
													_tmp349_ = _tmp348_[i];
													if (g_strcmp0 (_tmp349_, "Q") == 0) {
														while (TRUE) {
															gboolean _tmp350_ = FALSE;
															gchar** _tmp351_;
															gint _tmp351__length1;
															BirdFontBezierPoints** _tmp354_;
															gint _tmp354__length1;
															BirdFontBezierPoints* _tmp355_;
															BirdFontBezierPoints** _tmp356_;
															gint _tmp356__length1;
															BirdFontBezierPoints* _tmp357_;
															gchar** _tmp358_;
															gint _tmp358__length1;
															gint _tmp359_;
															const gchar* _tmp360_;
															BirdFontBezierPoints** _tmp367_;
															gint _tmp367__length1;
															BirdFontBezierPoints* _tmp368_;
															BirdFontBezierPoints** _tmp369_;
															gint _tmp369__length1;
															BirdFontBezierPoints* _tmp370_;
															gchar** _tmp371_;
															gint _tmp371__length1;
															gint _tmp372_;
															const gchar* _tmp373_;
															BirdFontBezierPoints** _tmp380_;
															gint _tmp380__length1;
															BirdFontBezierPoints* _tmp381_;
															BirdFontBezierPoints** _tmp382_;
															gint _tmp382__length1;
															BirdFontBezierPoints* _tmp383_;
															gint _tmp384_;
															_tmp351_ = c;
															_tmp351__length1 = c_length1;
															if ((i + 4) < _tmp351__length1) {
																gchar** _tmp352_;
																gint _tmp352__length1;
																const gchar* _tmp353_;
																_tmp352_ = c;
																_tmp352__length1 = c_length1;
																_tmp353_ = _tmp352_[i + 1];
																_tmp350_ = bird_font_svg_parser_is_point (_tmp353_);
															} else {
																_tmp350_ = FALSE;
															}
															if (!_tmp350_) {
																break;
															}
															_tmp354_ = bezier_points;
															_tmp354__length1 = bezier_points_length1;
															_tmp355_ = _tmp354_[bi];
															_tmp355_->type = (gunichar) 'Q';
															_tmp356_ = bezier_points;
															_tmp356__length1 = bezier_points_length1;
															_tmp357_ = _tmp356_[bi];
															_tmp357_->svg_type = (gunichar) 'Q';
															_tmp358_ = c;
															_tmp358__length1 = c_length1;
															i = i + 1;
															_tmp359_ = i;
															_tmp360_ = _tmp358_[_tmp359_];
															cx = bird_font_svg_parser_parse_double (_tmp360_);
															if (svg_glyph) {
																gchar** _tmp361_;
																gint _tmp361__length1;
																gint _tmp362_;
																const gchar* _tmp363_;
																_tmp361_ = c;
																_tmp361__length1 = c_length1;
																i = i + 1;
																_tmp362_ = i;
																_tmp363_ = _tmp361_[_tmp362_];
																cy = bird_font_svg_parser_parse_double (_tmp363_);
															} else {
																gchar** _tmp364_;
																gint _tmp364__length1;
																gint _tmp365_;
																const gchar* _tmp366_;
																_tmp364_ = c;
																_tmp364__length1 = c_length1;
																i = i + 1;
																_tmp365_ = i;
																_tmp366_ = _tmp364_[_tmp365_];
																cy = -bird_font_svg_parser_parse_double (_tmp366_);
															}
															_tmp367_ = bezier_points;
															_tmp367__length1 = bezier_points_length1;
															_tmp368_ = _tmp367_[bi];
															_tmp368_->x0 = cx;
															_tmp369_ = bezier_points;
															_tmp369__length1 = bezier_points_length1;
															_tmp370_ = _tmp369_[bi];
															_tmp370_->y0 = cy;
															px2 = cx;
															py2 = cy;
															_tmp371_ = c;
															_tmp371__length1 = c_length1;
															i = i + 1;
															_tmp372_ = i;
															_tmp373_ = _tmp371_[_tmp372_];
															cx = bird_font_svg_parser_parse_double (_tmp373_);
															if (svg_glyph) {
																gchar** _tmp374_;
																gint _tmp374__length1;
																gint _tmp375_;
																const gchar* _tmp376_;
																_tmp374_ = c;
																_tmp374__length1 = c_length1;
																i = i + 1;
																_tmp375_ = i;
																_tmp376_ = _tmp374_[_tmp375_];
																cy = bird_font_svg_parser_parse_double (_tmp376_);
															} else {
																gchar** _tmp377_;
																gint _tmp377__length1;
																gint _tmp378_;
																const gchar* _tmp379_;
																_tmp377_ = c;
																_tmp377__length1 = c_length1;
																i = i + 1;
																_tmp378_ = i;
																_tmp379_ = _tmp377_[_tmp378_];
																cy = -bird_font_svg_parser_parse_double (_tmp379_);
															}
															px = cx;
															py = cy;
															_tmp380_ = bezier_points;
															_tmp380__length1 = bezier_points_length1;
															_tmp381_ = _tmp380_[bi];
															_tmp381_->x1 = cx;
															_tmp382_ = bezier_points;
															_tmp382__length1 = bezier_points_length1;
															_tmp383_ = _tmp382_[bi];
															_tmp383_->y1 = cy;
															_tmp384_ = bi;
															bi = _tmp384_ + 1;
														}
													} else {
														gchar** _tmp385_;
														gint _tmp385__length1;
														const gchar* _tmp386_;
														_tmp385_ = c;
														_tmp385__length1 = c_length1;
														_tmp386_ = _tmp385_[i];
														if (g_strcmp0 (_tmp386_, "t") == 0) {
															while (TRUE) {
																gboolean _tmp387_ = FALSE;
																gchar** _tmp388_;
																gint _tmp388__length1;
																BirdFontBezierPoints** _tmp391_;
																gint _tmp391__length1;
																BirdFontBezierPoints* _tmp392_;
																BirdFontBezierPoints** _tmp393_;
																gint _tmp393__length1;
																BirdFontBezierPoints* _tmp394_;
																BirdFontBezierPoints** _tmp395_;
																gint _tmp395__length1;
																BirdFontBezierPoints* _tmp396_;
																BirdFontBezierPoints** _tmp397_;
																gint _tmp397__length1;
																BirdFontBezierPoints* _tmp398_;
																gdouble _tmp399_;
																gchar** _tmp400_;
																gint _tmp400__length1;
																gint _tmp401_;
																const gchar* _tmp402_;
																BirdFontBezierPoints** _tmp411_;
																gint _tmp411__length1;
																BirdFontBezierPoints* _tmp412_;
																BirdFontBezierPoints** _tmp413_;
																gint _tmp413__length1;
																BirdFontBezierPoints* _tmp414_;
																gint _tmp415_;
																_tmp388_ = c;
																_tmp388__length1 = c_length1;
																if ((i + 2) < _tmp388__length1) {
																	gchar** _tmp389_;
																	gint _tmp389__length1;
																	const gchar* _tmp390_;
																	_tmp389_ = c;
																	_tmp389__length1 = c_length1;
																	_tmp390_ = _tmp389_[i + 1];
																	_tmp387_ = bird_font_svg_parser_is_point (_tmp390_);
																} else {
																	_tmp387_ = FALSE;
																}
																if (!_tmp387_) {
																	break;
																}
																_tmp391_ = bezier_points;
																_tmp391__length1 = bezier_points_length1;
																_tmp392_ = _tmp391_[bi];
																_tmp392_->type = (gunichar) 'Q';
																_tmp393_ = bezier_points;
																_tmp393__length1 = bezier_points_length1;
																_tmp394_ = _tmp393_[bi];
																_tmp394_->svg_type = (gunichar) 't';
																cx = (2 * px) - px2;
																cy = (2 * py) - py2;
																_tmp395_ = bezier_points;
																_tmp395__length1 = bezier_points_length1;
																_tmp396_ = _tmp395_[bi];
																_tmp396_->x0 = cx;
																_tmp397_ = bezier_points;
																_tmp397__length1 = bezier_points_length1;
																_tmp398_ = _tmp397_[bi];
																_tmp398_->y0 = cy;
																px2 = cx;
																py2 = cy;
																_tmp399_ = px;
																_tmp400_ = c;
																_tmp400__length1 = c_length1;
																i = i + 1;
																_tmp401_ = i;
																_tmp402_ = _tmp400_[_tmp401_];
																cx = _tmp399_ + bird_font_svg_parser_parse_double (_tmp402_);
																if (svg_glyph) {
																	gdouble _tmp403_;
																	gchar** _tmp404_;
																	gint _tmp404__length1;
																	gint _tmp405_;
																	const gchar* _tmp406_;
																	_tmp403_ = py;
																	_tmp404_ = c;
																	_tmp404__length1 = c_length1;
																	i = i + 1;
																	_tmp405_ = i;
																	_tmp406_ = _tmp404_[_tmp405_];
																	cy = _tmp403_ + bird_font_svg_parser_parse_double (_tmp406_);
																} else {
																	gdouble _tmp407_;
																	gchar** _tmp408_;
																	gint _tmp408__length1;
																	gint _tmp409_;
																	const gchar* _tmp410_;
																	_tmp407_ = py;
																	_tmp408_ = c;
																	_tmp408__length1 = c_length1;
																	i = i + 1;
																	_tmp409_ = i;
																	_tmp410_ = _tmp408_[_tmp409_];
																	cy = _tmp407_ - bird_font_svg_parser_parse_double (_tmp410_);
																}
																px = cx;
																py = cy;
																_tmp411_ = bezier_points;
																_tmp411__length1 = bezier_points_length1;
																_tmp412_ = _tmp411_[bi];
																_tmp412_->x1 = px;
																_tmp413_ = bezier_points;
																_tmp413__length1 = bezier_points_length1;
																_tmp414_ = _tmp413_[bi];
																_tmp414_->y1 = py;
																_tmp415_ = bi;
																bi = _tmp415_ + 1;
															}
														} else {
															gchar** _tmp416_;
															gint _tmp416__length1;
															const gchar* _tmp417_;
															_tmp416_ = c;
															_tmp416__length1 = c_length1;
															_tmp417_ = _tmp416_[i];
															if (g_strcmp0 (_tmp417_, "T") == 0) {
																while (TRUE) {
																	gboolean _tmp418_ = FALSE;
																	gchar** _tmp419_;
																	gint _tmp419__length1;
																	BirdFontBezierPoints** _tmp422_;
																	gint _tmp422__length1;
																	BirdFontBezierPoints* _tmp423_;
																	BirdFontBezierPoints** _tmp424_;
																	gint _tmp424__length1;
																	BirdFontBezierPoints* _tmp425_;
																	BirdFontBezierPoints** _tmp426_;
																	gint _tmp426__length1;
																	BirdFontBezierPoints* _tmp427_;
																	BirdFontBezierPoints** _tmp428_;
																	gint _tmp428__length1;
																	BirdFontBezierPoints* _tmp429_;
																	gchar** _tmp430_;
																	gint _tmp430__length1;
																	gint _tmp431_;
																	const gchar* _tmp432_;
																	BirdFontBezierPoints** _tmp439_;
																	gint _tmp439__length1;
																	BirdFontBezierPoints* _tmp440_;
																	BirdFontBezierPoints** _tmp441_;
																	gint _tmp441__length1;
																	BirdFontBezierPoints* _tmp442_;
																	gint _tmp443_;
																	_tmp419_ = c;
																	_tmp419__length1 = c_length1;
																	if ((i + 2) < _tmp419__length1) {
																		gchar** _tmp420_;
																		gint _tmp420__length1;
																		const gchar* _tmp421_;
																		_tmp420_ = c;
																		_tmp420__length1 = c_length1;
																		_tmp421_ = _tmp420_[i + 1];
																		_tmp418_ = bird_font_svg_parser_is_point (_tmp421_);
																	} else {
																		_tmp418_ = FALSE;
																	}
																	if (!_tmp418_) {
																		break;
																	}
																	_tmp422_ = bezier_points;
																	_tmp422__length1 = bezier_points_length1;
																	_tmp423_ = _tmp422_[bi];
																	_tmp423_->type = (gunichar) 'Q';
																	_tmp424_ = bezier_points;
																	_tmp424__length1 = bezier_points_length1;
																	_tmp425_ = _tmp424_[bi];
																	_tmp425_->svg_type = (gunichar) 'T';
																	cx = (2 * px) - px2;
																	cy = (2 * py) - py2;
																	_tmp426_ = bezier_points;
																	_tmp426__length1 = bezier_points_length1;
																	_tmp427_ = _tmp426_[bi];
																	_tmp427_->x0 = cx;
																	_tmp428_ = bezier_points;
																	_tmp428__length1 = bezier_points_length1;
																	_tmp429_ = _tmp428_[bi];
																	_tmp429_->y0 = cy;
																	px2 = cx;
																	py2 = cy;
																	_tmp430_ = c;
																	_tmp430__length1 = c_length1;
																	i = i + 1;
																	_tmp431_ = i;
																	_tmp432_ = _tmp430_[_tmp431_];
																	cx = bird_font_svg_parser_parse_double (_tmp432_);
																	if (svg_glyph) {
																		gchar** _tmp433_;
																		gint _tmp433__length1;
																		gint _tmp434_;
																		const gchar* _tmp435_;
																		_tmp433_ = c;
																		_tmp433__length1 = c_length1;
																		i = i + 1;
																		_tmp434_ = i;
																		_tmp435_ = _tmp433_[_tmp434_];
																		cy = bird_font_svg_parser_parse_double (_tmp435_);
																	} else {
																		gchar** _tmp436_;
																		gint _tmp436__length1;
																		gint _tmp437_;
																		const gchar* _tmp438_;
																		_tmp436_ = c;
																		_tmp436__length1 = c_length1;
																		i = i + 1;
																		_tmp437_ = i;
																		_tmp438_ = _tmp436_[_tmp437_];
																		cy = -bird_font_svg_parser_parse_double (_tmp438_);
																	}
																	px = cx;
																	py = cy;
																	_tmp439_ = bezier_points;
																	_tmp439__length1 = bezier_points_length1;
																	_tmp440_ = _tmp439_[bi];
																	_tmp440_->x1 = px;
																	_tmp441_ = bezier_points;
																	_tmp441__length1 = bezier_points_length1;
																	_tmp442_ = _tmp441_[bi];
																	_tmp442_->y1 = py;
																	_tmp443_ = bi;
																	bi = _tmp443_ + 1;
																}
															} else {
																gchar** _tmp444_;
																gint _tmp444__length1;
																const gchar* _tmp445_;
																_tmp444_ = c;
																_tmp444__length1 = c_length1;
																_tmp445_ = _tmp444_[i];
																if (g_strcmp0 (_tmp445_, "s") == 0) {
																	while (TRUE) {
																		gboolean _tmp446_ = FALSE;
																		gchar** _tmp447_;
																		gint _tmp447__length1;
																		BirdFontBezierPoints** _tmp450_;
																		gint _tmp450__length1;
																		BirdFontBezierPoints* _tmp451_;
																		BirdFontBezierPoints** _tmp452_;
																		gint _tmp452__length1;
																		BirdFontBezierPoints* _tmp453_;
																		BirdFontBezierPoints** _tmp454_;
																		gint _tmp454__length1;
																		BirdFontBezierPoints* _tmp455_;
																		BirdFontBezierPoints** _tmp456_;
																		gint _tmp456__length1;
																		BirdFontBezierPoints* _tmp457_;
																		gdouble _tmp458_;
																		gchar** _tmp459_;
																		gint _tmp459__length1;
																		gint _tmp460_;
																		const gchar* _tmp461_;
																		BirdFontBezierPoints** _tmp470_;
																		gint _tmp470__length1;
																		BirdFontBezierPoints* _tmp471_;
																		BirdFontBezierPoints** _tmp472_;
																		gint _tmp472__length1;
																		BirdFontBezierPoints* _tmp473_;
																		gdouble _tmp474_;
																		gchar** _tmp475_;
																		gint _tmp475__length1;
																		gint _tmp476_;
																		const gchar* _tmp477_;
																		BirdFontBezierPoints** _tmp486_;
																		gint _tmp486__length1;
																		BirdFontBezierPoints* _tmp487_;
																		BirdFontBezierPoints** _tmp488_;
																		gint _tmp488__length1;
																		BirdFontBezierPoints* _tmp489_;
																		gint _tmp490_;
																		_tmp447_ = c;
																		_tmp447__length1 = c_length1;
																		if ((i + 4) < _tmp447__length1) {
																			gchar** _tmp448_;
																			gint _tmp448__length1;
																			const gchar* _tmp449_;
																			_tmp448_ = c;
																			_tmp448__length1 = c_length1;
																			_tmp449_ = _tmp448_[i + 1];
																			_tmp446_ = bird_font_svg_parser_is_point (_tmp449_);
																		} else {
																			_tmp446_ = FALSE;
																		}
																		if (!_tmp446_) {
																			break;
																		}
																		_tmp450_ = bezier_points;
																		_tmp450__length1 = bezier_points_length1;
																		_tmp451_ = _tmp450_[bi];
																		_tmp451_->type = (gunichar) 'C';
																		_tmp452_ = bezier_points;
																		_tmp452__length1 = bezier_points_length1;
																		_tmp453_ = _tmp452_[bi];
																		_tmp453_->svg_type = (gunichar) 's';
																		cx = (2 * px) - px2;
																		cy = (2 * py) - py2;
																		_tmp454_ = bezier_points;
																		_tmp454__length1 = bezier_points_length1;
																		_tmp455_ = _tmp454_[bi];
																		_tmp455_->x0 = cx;
																		_tmp456_ = bezier_points;
																		_tmp456__length1 = bezier_points_length1;
																		_tmp457_ = _tmp456_[bi];
																		_tmp457_->y0 = cy;
																		_tmp458_ = px;
																		_tmp459_ = c;
																		_tmp459__length1 = c_length1;
																		i = i + 1;
																		_tmp460_ = i;
																		_tmp461_ = _tmp459_[_tmp460_];
																		cx = _tmp458_ + bird_font_svg_parser_parse_double (_tmp461_);
																		if (svg_glyph) {
																			gdouble _tmp462_;
																			gchar** _tmp463_;
																			gint _tmp463__length1;
																			gint _tmp464_;
																			const gchar* _tmp465_;
																			_tmp462_ = py;
																			_tmp463_ = c;
																			_tmp463__length1 = c_length1;
																			i = i + 1;
																			_tmp464_ = i;
																			_tmp465_ = _tmp463_[_tmp464_];
																			cy = _tmp462_ + bird_font_svg_parser_parse_double (_tmp465_);
																		} else {
																			gdouble _tmp466_;
																			gchar** _tmp467_;
																			gint _tmp467__length1;
																			gint _tmp468_;
																			const gchar* _tmp469_;
																			_tmp466_ = py;
																			_tmp467_ = c;
																			_tmp467__length1 = c_length1;
																			i = i + 1;
																			_tmp468_ = i;
																			_tmp469_ = _tmp467_[_tmp468_];
																			cy = _tmp466_ - bird_font_svg_parser_parse_double (_tmp469_);
																		}
																		px2 = cx;
																		py2 = cy;
																		_tmp470_ = bezier_points;
																		_tmp470__length1 = bezier_points_length1;
																		_tmp471_ = _tmp470_[bi];
																		_tmp471_->x1 = px2;
																		_tmp472_ = bezier_points;
																		_tmp472__length1 = bezier_points_length1;
																		_tmp473_ = _tmp472_[bi];
																		_tmp473_->y1 = py2;
																		_tmp474_ = px;
																		_tmp475_ = c;
																		_tmp475__length1 = c_length1;
																		i = i + 1;
																		_tmp476_ = i;
																		_tmp477_ = _tmp475_[_tmp476_];
																		cx = _tmp474_ + bird_font_svg_parser_parse_double (_tmp477_);
																		if (svg_glyph) {
																			gdouble _tmp478_;
																			gchar** _tmp479_;
																			gint _tmp479__length1;
																			gint _tmp480_;
																			const gchar* _tmp481_;
																			_tmp478_ = py;
																			_tmp479_ = c;
																			_tmp479__length1 = c_length1;
																			i = i + 1;
																			_tmp480_ = i;
																			_tmp481_ = _tmp479_[_tmp480_];
																			cy = _tmp478_ + bird_font_svg_parser_parse_double (_tmp481_);
																		} else {
																			gdouble _tmp482_;
																			gchar** _tmp483_;
																			gint _tmp483__length1;
																			gint _tmp484_;
																			const gchar* _tmp485_;
																			_tmp482_ = py;
																			_tmp483_ = c;
																			_tmp483__length1 = c_length1;
																			i = i + 1;
																			_tmp484_ = i;
																			_tmp485_ = _tmp483_[_tmp484_];
																			cy = _tmp482_ - bird_font_svg_parser_parse_double (_tmp485_);
																		}
																		_tmp486_ = bezier_points;
																		_tmp486__length1 = bezier_points_length1;
																		_tmp487_ = _tmp486_[bi];
																		_tmp487_->x2 = cx;
																		_tmp488_ = bezier_points;
																		_tmp488__length1 = bezier_points_length1;
																		_tmp489_ = _tmp488_[bi];
																		_tmp489_->y2 = cy;
																		px = cx;
																		py = cy;
																		_tmp490_ = bi;
																		bi = _tmp490_ + 1;
																	}
																} else {
																	gchar** _tmp491_;
																	gint _tmp491__length1;
																	const gchar* _tmp492_;
																	_tmp491_ = c;
																	_tmp491__length1 = c_length1;
																	_tmp492_ = _tmp491_[i];
																	if (g_strcmp0 (_tmp492_, "S") == 0) {
																		while (TRUE) {
																			gboolean _tmp493_ = FALSE;
																			gchar** _tmp494_;
																			gint _tmp494__length1;
																			BirdFontBezierPoints** _tmp497_;
																			gint _tmp497__length1;
																			BirdFontBezierPoints* _tmp498_;
																			BirdFontBezierPoints** _tmp499_;
																			gint _tmp499__length1;
																			BirdFontBezierPoints* _tmp500_;
																			BirdFontBezierPoints** _tmp501_;
																			gint _tmp501__length1;
																			BirdFontBezierPoints* _tmp502_;
																			BirdFontBezierPoints** _tmp503_;
																			gint _tmp503__length1;
																			BirdFontBezierPoints* _tmp504_;
																			gchar** _tmp505_;
																			gint _tmp505__length1;
																			gint _tmp506_;
																			const gchar* _tmp507_;
																			BirdFontBezierPoints** _tmp514_;
																			gint _tmp514__length1;
																			BirdFontBezierPoints* _tmp515_;
																			BirdFontBezierPoints** _tmp516_;
																			gint _tmp516__length1;
																			BirdFontBezierPoints* _tmp517_;
																			gchar** _tmp518_;
																			gint _tmp518__length1;
																			gint _tmp519_;
																			const gchar* _tmp520_;
																			BirdFontBezierPoints** _tmp527_;
																			gint _tmp527__length1;
																			BirdFontBezierPoints* _tmp528_;
																			BirdFontBezierPoints** _tmp529_;
																			gint _tmp529__length1;
																			BirdFontBezierPoints* _tmp530_;
																			gint _tmp531_;
																			_tmp494_ = c;
																			_tmp494__length1 = c_length1;
																			if ((i + 4) < _tmp494__length1) {
																				gchar** _tmp495_;
																				gint _tmp495__length1;
																				const gchar* _tmp496_;
																				_tmp495_ = c;
																				_tmp495__length1 = c_length1;
																				_tmp496_ = _tmp495_[i + 1];
																				_tmp493_ = bird_font_svg_parser_is_point (_tmp496_);
																			} else {
																				_tmp493_ = FALSE;
																			}
																			if (!_tmp493_) {
																				break;
																			}
																			_tmp497_ = bezier_points;
																			_tmp497__length1 = bezier_points_length1;
																			_tmp498_ = _tmp497_[bi];
																			_tmp498_->type = (gunichar) 'C';
																			_tmp499_ = bezier_points;
																			_tmp499__length1 = bezier_points_length1;
																			_tmp500_ = _tmp499_[bi];
																			_tmp500_->svg_type = (gunichar) 'S';
																			cx = (2 * px) - px2;
																			cy = (2 * py) - py2;
																			_tmp501_ = bezier_points;
																			_tmp501__length1 = bezier_points_length1;
																			_tmp502_ = _tmp501_[bi];
																			_tmp502_->x0 = cx;
																			_tmp503_ = bezier_points;
																			_tmp503__length1 = bezier_points_length1;
																			_tmp504_ = _tmp503_[bi];
																			_tmp504_->y0 = cy;
																			_tmp505_ = c;
																			_tmp505__length1 = c_length1;
																			i = i + 1;
																			_tmp506_ = i;
																			_tmp507_ = _tmp505_[_tmp506_];
																			cx = bird_font_svg_parser_parse_double (_tmp507_);
																			if (svg_glyph) {
																				gchar** _tmp508_;
																				gint _tmp508__length1;
																				gint _tmp509_;
																				const gchar* _tmp510_;
																				_tmp508_ = c;
																				_tmp508__length1 = c_length1;
																				i = i + 1;
																				_tmp509_ = i;
																				_tmp510_ = _tmp508_[_tmp509_];
																				cy = bird_font_svg_parser_parse_double (_tmp510_);
																			} else {
																				gchar** _tmp511_;
																				gint _tmp511__length1;
																				gint _tmp512_;
																				const gchar* _tmp513_;
																				_tmp511_ = c;
																				_tmp511__length1 = c_length1;
																				i = i + 1;
																				_tmp512_ = i;
																				_tmp513_ = _tmp511_[_tmp512_];
																				cy = -bird_font_svg_parser_parse_double (_tmp513_);
																			}
																			px2 = cx;
																			py2 = cy;
																			_tmp514_ = bezier_points;
																			_tmp514__length1 = bezier_points_length1;
																			_tmp515_ = _tmp514_[bi];
																			_tmp515_->x1 = px2;
																			_tmp516_ = bezier_points;
																			_tmp516__length1 = bezier_points_length1;
																			_tmp517_ = _tmp516_[bi];
																			_tmp517_->y1 = py2;
																			_tmp518_ = c;
																			_tmp518__length1 = c_length1;
																			i = i + 1;
																			_tmp519_ = i;
																			_tmp520_ = _tmp518_[_tmp519_];
																			cx = bird_font_svg_parser_parse_double (_tmp520_);
																			if (svg_glyph) {
																				gchar** _tmp521_;
																				gint _tmp521__length1;
																				gint _tmp522_;
																				const gchar* _tmp523_;
																				_tmp521_ = c;
																				_tmp521__length1 = c_length1;
																				i = i + 1;
																				_tmp522_ = i;
																				_tmp523_ = _tmp521_[_tmp522_];
																				cy = bird_font_svg_parser_parse_double (_tmp523_);
																			} else {
																				gchar** _tmp524_;
																				gint _tmp524__length1;
																				gint _tmp525_;
																				const gchar* _tmp526_;
																				_tmp524_ = c;
																				_tmp524__length1 = c_length1;
																				i = i + 1;
																				_tmp525_ = i;
																				_tmp526_ = _tmp524_[_tmp525_];
																				cy = -bird_font_svg_parser_parse_double (_tmp526_);
																			}
																			_tmp527_ = bezier_points;
																			_tmp527__length1 = bezier_points_length1;
																			_tmp528_ = _tmp527_[bi];
																			_tmp528_->x2 = cx;
																			_tmp529_ = bezier_points;
																			_tmp529__length1 = bezier_points_length1;
																			_tmp530_ = _tmp529_[bi];
																			_tmp530_->y2 = cy;
																			px = cx;
																			py = cy;
																			_tmp531_ = bi;
																			bi = _tmp531_ + 1;
																		}
																	} else {
																		gchar** _tmp532_;
																		gint _tmp532__length1;
																		const gchar* _tmp533_;
																		_tmp532_ = c;
																		_tmp532__length1 = c_length1;
																		_tmp533_ = _tmp532_[i];
																		if (g_strcmp0 (_tmp533_, "a") == 0) {
																			while (TRUE) {
																				gboolean _tmp534_ = FALSE;
																				gchar** _tmp535_;
																				gint _tmp535__length1;
																				gchar** _tmp538_;
																				gint _tmp538__length1;
																				gint _tmp539_;
																				const gchar* _tmp540_;
																				gchar** _tmp541_;
																				gint _tmp541__length1;
																				gint _tmp542_;
																				const gchar* _tmp543_;
																				gchar** _tmp544_;
																				gint _tmp544__length1;
																				gint _tmp545_;
																				const gchar* _tmp546_;
																				gchar** _tmp547_;
																				gint _tmp547__length1;
																				gint _tmp548_;
																				const gchar* _tmp549_;
																				gchar** _tmp550_;
																				gint _tmp550__length1;
																				gint _tmp551_;
																				const gchar* _tmp552_;
																				gdouble _tmp553_;
																				gchar** _tmp554_;
																				gint _tmp554__length1;
																				gint _tmp555_;
																				const gchar* _tmp556_;
																				BirdFontBezierPoints** _tmp565_;
																				gint _tmp565__length1;
																				_tmp535_ = c;
																				_tmp535__length1 = c_length1;
																				if ((i + 7) < _tmp535__length1) {
																					gchar** _tmp536_;
																					gint _tmp536__length1;
																					const gchar* _tmp537_;
																					_tmp536_ = c;
																					_tmp536__length1 = c_length1;
																					_tmp537_ = _tmp536_[i + 1];
																					_tmp534_ = bird_font_svg_parser_is_point (_tmp537_);
																				} else {
																					_tmp534_ = FALSE;
																				}
																				if (!_tmp534_) {
																					break;
																				}
																				_tmp538_ = c;
																				_tmp538__length1 = c_length1;
																				i = i + 1;
																				_tmp539_ = i;
																				_tmp540_ = _tmp538_[_tmp539_];
																				arc_rx = bird_font_svg_parser_parse_double (_tmp540_);
																				_tmp541_ = c;
																				_tmp541__length1 = c_length1;
																				i = i + 1;
																				_tmp542_ = i;
																				_tmp543_ = _tmp541_[_tmp542_];
																				arc_ry = bird_font_svg_parser_parse_double (_tmp543_);
																				_tmp544_ = c;
																				_tmp544__length1 = c_length1;
																				i = i + 1;
																				_tmp545_ = i;
																				_tmp546_ = _tmp544_[_tmp545_];
																				arc_rotation = bird_font_svg_parser_parse_double (_tmp546_);
																				_tmp547_ = c;
																				_tmp547__length1 = c_length1;
																				i = i + 1;
																				_tmp548_ = i;
																				_tmp549_ = _tmp547_[_tmp548_];
																				large_arc = bird_font_svg_parser_parse_int (_tmp549_);
																				_tmp550_ = c;
																				_tmp550__length1 = c_length1;
																				i = i + 1;
																				_tmp551_ = i;
																				_tmp552_ = _tmp550_[_tmp551_];
																				arc_sweep = bird_font_svg_parser_parse_int (_tmp552_);
																				_tmp553_ = px;
																				_tmp554_ = c;
																				_tmp554__length1 = c_length1;
																				i = i + 1;
																				_tmp555_ = i;
																				_tmp556_ = _tmp554_[_tmp555_];
																				cx = _tmp553_ + bird_font_svg_parser_parse_double (_tmp556_);
																				if (svg_glyph) {
																					gdouble _tmp557_;
																					gchar** _tmp558_;
																					gint _tmp558__length1;
																					gint _tmp559_;
																					const gchar* _tmp560_;
																					_tmp557_ = py;
																					_tmp558_ = c;
																					_tmp558__length1 = c_length1;
																					i = i + 1;
																					_tmp559_ = i;
																					_tmp560_ = _tmp558_[_tmp559_];
																					cy = _tmp557_ + bird_font_svg_parser_parse_double (_tmp560_);
																				} else {
																					gdouble _tmp561_;
																					gchar** _tmp562_;
																					gint _tmp562__length1;
																					gint _tmp563_;
																					const gchar* _tmp564_;
																					_tmp561_ = py;
																					_tmp562_ = c;
																					_tmp562__length1 = c_length1;
																					i = i + 1;
																					_tmp563_ = i;
																					_tmp564_ = _tmp562_[_tmp563_];
																					cy = _tmp561_ - bird_font_svg_parser_parse_double (_tmp564_);
																				}
																				arc_dest_x = cx;
																				arc_dest_y = cy;
																				_tmp565_ = bezier_points;
																				_tmp565__length1 = bezier_points_length1;
																				bird_font_add_arc_points (_tmp565_, (gint) _tmp565__length1, &bi, px, py, arc_rx, arc_ry, arc_rotation, large_arc == 1, arc_sweep == 1, cx, cy);
																				px = cx;
																				py = cy;
																			}
																		} else {
																			gboolean _tmp566_ = FALSE;
																			gchar** _tmp567_;
																			gint _tmp567__length1;
																			_tmp567_ = c;
																			_tmp567__length1 = c_length1;
																			if ((i + 7) < _tmp567__length1) {
																				gchar** _tmp568_;
																				gint _tmp568__length1;
																				const gchar* _tmp569_;
																				_tmp568_ = c;
																				_tmp568__length1 = c_length1;
																				_tmp569_ = _tmp568_[i];
																				_tmp566_ = g_strcmp0 (_tmp569_, "A") == 0;
																			} else {
																				_tmp566_ = FALSE;
																			}
																			if (_tmp566_) {
																				while (TRUE) {
																					gchar** _tmp570_;
																					gint _tmp570__length1;
																					const gchar* _tmp571_;
																					gchar** _tmp572_;
																					gint _tmp572__length1;
																					gint _tmp573_;
																					const gchar* _tmp574_;
																					gchar** _tmp575_;
																					gint _tmp575__length1;
																					gint _tmp576_;
																					const gchar* _tmp577_;
																					gchar** _tmp578_;
																					gint _tmp578__length1;
																					gint _tmp579_;
																					const gchar* _tmp580_;
																					gchar** _tmp581_;
																					gint _tmp581__length1;
																					gint _tmp582_;
																					const gchar* _tmp583_;
																					gchar** _tmp584_;
																					gint _tmp584__length1;
																					gint _tmp585_;
																					const gchar* _tmp586_;
																					gchar** _tmp587_;
																					gint _tmp587__length1;
																					gint _tmp588_;
																					const gchar* _tmp589_;
																					BirdFontBezierPoints** _tmp596_;
																					gint _tmp596__length1;
																					_tmp570_ = c;
																					_tmp570__length1 = c_length1;
																					_tmp571_ = _tmp570_[i + 1];
																					if (!bird_font_svg_parser_is_point (_tmp571_)) {
																						break;
																					}
																					_tmp572_ = c;
																					_tmp572__length1 = c_length1;
																					i = i + 1;
																					_tmp573_ = i;
																					_tmp574_ = _tmp572_[_tmp573_];
																					arc_rx = bird_font_svg_parser_parse_double (_tmp574_);
																					_tmp575_ = c;
																					_tmp575__length1 = c_length1;
																					i = i + 1;
																					_tmp576_ = i;
																					_tmp577_ = _tmp575_[_tmp576_];
																					arc_ry = bird_font_svg_parser_parse_double (_tmp577_);
																					_tmp578_ = c;
																					_tmp578__length1 = c_length1;
																					i = i + 1;
																					_tmp579_ = i;
																					_tmp580_ = _tmp578_[_tmp579_];
																					arc_rotation = bird_font_svg_parser_parse_double (_tmp580_);
																					_tmp581_ = c;
																					_tmp581__length1 = c_length1;
																					i = i + 1;
																					_tmp582_ = i;
																					_tmp583_ = _tmp581_[_tmp582_];
																					large_arc = bird_font_svg_parser_parse_int (_tmp583_);
																					_tmp584_ = c;
																					_tmp584__length1 = c_length1;
																					i = i + 1;
																					_tmp585_ = i;
																					_tmp586_ = _tmp584_[_tmp585_];
																					arc_sweep = bird_font_svg_parser_parse_int (_tmp586_);
																					_tmp587_ = c;
																					_tmp587__length1 = c_length1;
																					i = i + 1;
																					_tmp588_ = i;
																					_tmp589_ = _tmp587_[_tmp588_];
																					cx = bird_font_svg_parser_parse_double (_tmp589_);
																					if (svg_glyph) {
																						gchar** _tmp590_;
																						gint _tmp590__length1;
																						gint _tmp591_;
																						const gchar* _tmp592_;
																						_tmp590_ = c;
																						_tmp590__length1 = c_length1;
																						i = i + 1;
																						_tmp591_ = i;
																						_tmp592_ = _tmp590_[_tmp591_];
																						cy = bird_font_svg_parser_parse_double (_tmp592_);
																					} else {
																						gchar** _tmp593_;
																						gint _tmp593__length1;
																						gint _tmp594_;
																						const gchar* _tmp595_;
																						_tmp593_ = c;
																						_tmp593__length1 = c_length1;
																						i = i + 1;
																						_tmp594_ = i;
																						_tmp595_ = _tmp593_[_tmp594_];
																						cy = -bird_font_svg_parser_parse_double (_tmp595_);
																					}
																					arc_dest_x = cx;
																					arc_dest_y = cy;
																					_tmp596_ = bezier_points;
																					_tmp596__length1 = bezier_points_length1;
																					bird_font_add_arc_points (_tmp596_, (gint) _tmp596__length1, &bi, px, py, arc_rx, arc_ry, arc_rotation, large_arc == 1, arc_sweep == 1, cx, cy);
																					px = cx;
																					py = cy;
																				}
																			} else {
																				gboolean _tmp597_ = FALSE;
																				gchar** _tmp598_;
																				gint _tmp598__length1;
																				const gchar* _tmp599_;
																				_tmp598_ = c;
																				_tmp598__length1 = c_length1;
																				_tmp599_ = _tmp598_[i];
																				if (g_strcmp0 (_tmp599_, "z") == 0) {
																					_tmp597_ = TRUE;
																				} else {
																					gchar** _tmp600_;
																					gint _tmp600__length1;
																					const gchar* _tmp601_;
																					_tmp600_ = c;
																					_tmp600__length1 = c_length1;
																					_tmp601_ = _tmp600_[i];
																					_tmp597_ = g_strcmp0 (_tmp601_, "Z") == 0;
																				}
																				if (_tmp597_) {
																					BirdFontBezierPoints** _tmp611_;
																					gint _tmp611__length1;
																					BirdFontBezierPoints* _tmp612_;
																					BirdFontBezierPoints** _tmp613_;
																					gint _tmp613__length1;
																					BirdFontBezierPoints* _tmp614_;
																					gint _tmp615_;
																					if (bird_font_path_distance (px, first_point_x, py, first_point_y) > 0.001) {
																						BirdFontBezierPoints** _tmp602_;
																						gint _tmp602__length1;
																						BirdFontBezierPoints* _tmp603_;
																						BirdFontBezierPoints** _tmp604_;
																						gint _tmp604__length1;
																						BirdFontBezierPoints* _tmp605_;
																						BirdFontBezierPoints** _tmp606_;
																						gint _tmp606__length1;
																						BirdFontBezierPoints* _tmp607_;
																						BirdFontBezierPoints** _tmp608_;
																						gint _tmp608__length1;
																						BirdFontBezierPoints* _tmp609_;
																						gint _tmp610_;
																						px = first_point_x;
																						py = first_point_y;
																						_tmp602_ = bezier_points;
																						_tmp602__length1 = bezier_points_length1;
																						_tmp603_ = _tmp602_[bi];
																						_tmp603_->type = (gunichar) 'L';
																						_tmp604_ = bezier_points;
																						_tmp604__length1 = bezier_points_length1;
																						_tmp605_ = _tmp604_[bi];
																						_tmp605_->svg_type = (gunichar) 'l';
																						_tmp606_ = bezier_points;
																						_tmp606__length1 = bezier_points_length1;
																						_tmp607_ = _tmp606_[bi];
																						_tmp607_->x0 = px;
																						_tmp608_ = bezier_points;
																						_tmp608__length1 = bezier_points_length1;
																						_tmp609_ = _tmp608_[bi];
																						_tmp609_->y0 = py;
																						_tmp610_ = bi;
																						bi = _tmp610_ + 1;
																					}
																					_tmp611_ = bezier_points;
																					_tmp611__length1 = bezier_points_length1;
																					_tmp612_ = _tmp611_[bi];
																					_tmp612_->type = (gunichar) 'z';
																					_tmp613_ = bezier_points;
																					_tmp613__length1 = bezier_points_length1;
																					_tmp614_ = _tmp613_[bi];
																					_tmp614_->svg_type = (gunichar) 'z';
																					set_first = TRUE;
																					_tmp615_ = bi;
																					bi = _tmp615_ + 1;
																				} else {
																					gchar** _tmp616_;
																					gint _tmp616__length1;
																					const gchar* _tmp617_;
																					_tmp616_ = c;
																					_tmp616__length1 = c_length1;
																					_tmp617_ = _tmp616_[i];
																					if (g_strcmp0 (_tmp617_, "") == 0) {
																					} else {
																						gchar** _tmp618_;
																						gint _tmp618__length1;
																						const gchar* _tmp619_;
																						_tmp618_ = c;
																						_tmp618__length1 = c_length1;
																						_tmp619_ = _tmp618_[i];
																						if (g_strcmp0 (_tmp619_, " ") == 0) {
																						} else {
																							gchar** _tmp627_;
																							gint _tmp627__length1;
																							const gchar* _tmp628_;
																							const gchar* _tmp629_;
																							gchar* _tmp630_;
																							gchar* _tmp631_;
																							gchar* _tmp632_;
																							gchar* _tmp633_;
																							g_print ("%s", "\n\nSVG:");
																							{
																								gint dd = 0;
																								dd = 0;
																								{
																									gboolean _tmp620_ = FALSE;
																									_tmp620_ = TRUE;
																									while (TRUE) {
																										gchar** _tmp622_;
																										gint _tmp622__length1;
																										const gchar* _tmp623_;
																										const gchar* _tmp624_;
																										gchar* _tmp625_;
																										gchar* _tmp626_;
																										if (!_tmp620_) {
																											gint _tmp621_;
																											_tmp621_ = dd;
																											dd = _tmp621_ + 1;
																										}
																										_tmp620_ = FALSE;
																										if (!(dd <= i)) {
																											break;
																										}
																										_tmp622_ = c;
																										_tmp622__length1 = c_length1;
																										_tmp623_ = _tmp622_[dd];
																										_tmp624_ = string_to_string (_tmp623_);
																										_tmp625_ = g_strconcat (_tmp624_, " ", NULL);
																										_tmp626_ = _tmp625_;
																										g_print ("%s", _tmp626_);
																										_g_free0 (_tmp626_);
																									}
																								}
																							}
																							g_print ("%s", "\n");
																							_tmp627_ = c;
																							_tmp627__length1 = c_length1;
																							_tmp628_ = _tmp627_[i];
																							_tmp629_ = string_to_string (_tmp628_);
																							_tmp630_ = g_strdup_printf ("%i", i);
																							_tmp631_ = _tmp630_;
																							_tmp632_ = g_strconcat ("Unknown instruction: ", _tmp629_, ", i: ", _tmp631_, NULL);
																							_tmp633_ = _tmp632_;
																							g_warning ("SvgParser.vala:1603: %s", _tmp633_);
																							_g_free0 (_tmp633_);
																							_g_free0 (_tmp631_);
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if (bi == 0) {
		g_warning ("SvgParser.vala:1608: No points in path.");
		result = path_list;
		c = (_vala_array_free (c, c_length1, (GDestroyNotify) g_free), NULL);
		bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
		_g_object_unref0 (font);
		_g_free0 (data);
		return result;
	}
	_tmp634_ = bezier_points;
	_tmp634__length1 = bezier_points_length1;
	bird_font_svg_parser_move_and_resize (self, _tmp634_, (gint) _tmp634__length1, bi, svg_glyph, units, glyph);
	if (self->priv->format == BIRD_FONT_SVG_FORMAT_ILLUSTRATOR) {
		BirdFontBezierPoints** _tmp635_;
		gint _tmp635__length1;
		BirdFontPathList* _tmp636_;
		_tmp635_ = bezier_points;
		_tmp635__length1 = bezier_points_length1;
		_tmp636_ = bird_font_svg_parser_create_paths_illustrator (self, _tmp635_, (gint) _tmp635__length1, bi);
		_g_object_unref0 (path_list);
		path_list = _tmp636_;
	} else {
		BirdFontBezierPoints** _tmp637_;
		gint _tmp637__length1;
		BirdFontPathList* _tmp638_;
		_tmp637_ = bezier_points;
		_tmp637__length1 = bezier_points_length1;
		_tmp638_ = bird_font_svg_parser_create_paths_inkscape (self, _tmp637_, (gint) _tmp637__length1, bi);
		_g_object_unref0 (path_list);
		path_list = _tmp638_;
	}
	result = path_list;
	c = (_vala_array_free (c, c_length1, (GDestroyNotify) g_free), NULL);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	_g_object_unref0 (font);
	_g_free0 (data);
	return result;
}

static void
bird_font_svg_parser_move_and_resize (BirdFontSvgParser* self,
                                      BirdFontBezierPoints** b,
                                      gint b_length1,
                                      gint num_b,
                                      gboolean svg_glyph,
                                      gdouble units,
                                      BirdFontGlyph* glyph)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				BirdFontBezierPoints* _tmp3_;
				BirdFontBezierPoints* _tmp4_;
				BirdFontBezierPoints* _tmp5_;
				BirdFontBezierPoints* _tmp6_;
				BirdFontBezierPoints* _tmp7_;
				BirdFontBezierPoints* _tmp8_;
				BirdFontBezierPoints* _tmp9_;
				BirdFontBezierPoints* _tmp10_;
				BirdFontBezierPoints* _tmp11_;
				BirdFontBezierPoints* _tmp12_;
				BirdFontBezierPoints* _tmp13_;
				BirdFontBezierPoints* _tmp14_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < num_b)) {
					break;
				}
				_tmp3_ = b[i];
				_tmp4_ = b[i];
				_tmp4_->x0 = _tmp4_->x0 * units;
				_tmp5_ = b[i];
				_tmp6_ = b[i];
				_tmp6_->y0 = _tmp6_->y0 * units;
				_tmp7_ = b[i];
				_tmp8_ = b[i];
				_tmp8_->x1 = _tmp8_->x1 * units;
				_tmp9_ = b[i];
				_tmp10_ = b[i];
				_tmp10_->y1 = _tmp10_->y1 * units;
				_tmp11_ = b[i];
				_tmp12_ = b[i];
				_tmp12_->x2 = _tmp12_->x2 * units;
				_tmp13_ = b[i];
				_tmp14_ = b[i];
				_tmp14_->y2 = _tmp14_->y2 * units;
				if (svg_glyph) {
					BirdFontBezierPoints* _tmp15_;
					BirdFontBezierPoints* _tmp16_;
					gdouble _tmp17_;
					gdouble _tmp18_;
					BirdFontBezierPoints* _tmp19_;
					BirdFontBezierPoints* _tmp20_;
					BirdFontFont* _tmp21_;
					BirdFontBezierPoints* _tmp22_;
					BirdFontBezierPoints* _tmp23_;
					gdouble _tmp24_;
					gdouble _tmp25_;
					BirdFontBezierPoints* _tmp26_;
					BirdFontBezierPoints* _tmp27_;
					BirdFontFont* _tmp28_;
					BirdFontBezierPoints* _tmp29_;
					BirdFontBezierPoints* _tmp30_;
					gdouble _tmp31_;
					gdouble _tmp32_;
					BirdFontBezierPoints* _tmp33_;
					BirdFontBezierPoints* _tmp34_;
					BirdFontFont* _tmp35_;
					_tmp15_ = b[i];
					_tmp16_ = b[i];
					_tmp17_ = bird_font_glyph_get_left_limit (glyph);
					_tmp18_ = _tmp17_;
					_tmp16_->x0 = _tmp16_->x0 + _tmp18_;
					_tmp19_ = b[i];
					_tmp20_ = b[i];
					_tmp21_ = font;
					_tmp20_->y0 = _tmp20_->y0 + _tmp21_->base_line;
					_tmp22_ = b[i];
					_tmp23_ = b[i];
					_tmp24_ = bird_font_glyph_get_left_limit (glyph);
					_tmp25_ = _tmp24_;
					_tmp23_->x1 = _tmp23_->x1 + _tmp25_;
					_tmp26_ = b[i];
					_tmp27_ = b[i];
					_tmp28_ = font;
					_tmp27_->y1 = _tmp27_->y1 + _tmp28_->base_line;
					_tmp29_ = b[i];
					_tmp30_ = b[i];
					_tmp31_ = bird_font_glyph_get_left_limit (glyph);
					_tmp32_ = _tmp31_;
					_tmp30_->x2 = _tmp30_->x2 + _tmp32_;
					_tmp33_ = b[i];
					_tmp34_ = b[i];
					_tmp35_ = font;
					_tmp34_->y2 = _tmp34_->y2 + _tmp35_->base_line;
				} else {
					BirdFontBezierPoints* _tmp36_;
					BirdFontBezierPoints* _tmp37_;
					gdouble _tmp38_;
					gdouble _tmp39_;
					BirdFontBezierPoints* _tmp40_;
					BirdFontBezierPoints* _tmp41_;
					BirdFontFont* _tmp42_;
					BirdFontBezierPoints* _tmp43_;
					BirdFontBezierPoints* _tmp44_;
					gdouble _tmp45_;
					gdouble _tmp46_;
					BirdFontBezierPoints* _tmp47_;
					BirdFontBezierPoints* _tmp48_;
					BirdFontFont* _tmp49_;
					BirdFontBezierPoints* _tmp50_;
					BirdFontBezierPoints* _tmp51_;
					gdouble _tmp52_;
					gdouble _tmp53_;
					BirdFontBezierPoints* _tmp54_;
					BirdFontBezierPoints* _tmp55_;
					BirdFontFont* _tmp56_;
					_tmp36_ = b[i];
					_tmp37_ = b[i];
					_tmp38_ = bird_font_glyph_get_left_limit (glyph);
					_tmp39_ = _tmp38_;
					_tmp37_->x0 = _tmp37_->x0 + _tmp39_;
					_tmp40_ = b[i];
					_tmp41_ = b[i];
					_tmp42_ = font;
					_tmp41_->y0 = _tmp41_->y0 + _tmp42_->top_limit;
					_tmp43_ = b[i];
					_tmp44_ = b[i];
					_tmp45_ = bird_font_glyph_get_left_limit (glyph);
					_tmp46_ = _tmp45_;
					_tmp44_->x1 = _tmp44_->x1 + _tmp46_;
					_tmp47_ = b[i];
					_tmp48_ = b[i];
					_tmp49_ = font;
					_tmp48_->y1 = _tmp48_->y1 + _tmp49_->top_limit;
					_tmp50_ = b[i];
					_tmp51_ = b[i];
					_tmp52_ = bird_font_glyph_get_left_limit (glyph);
					_tmp53_ = _tmp52_;
					_tmp51_->x2 = _tmp51_->x2 + _tmp53_;
					_tmp54_ = b[i];
					_tmp55_ = b[i];
					_tmp56_ = font;
					_tmp55_->y2 = _tmp55_->y2 + _tmp56_->top_limit;
				}
			}
		}
	}
	_g_object_unref0 (font);
}

static gpointer
_bird_font_bezier_points_ref0 (gpointer self)
{
	return self ? bird_font_bezier_points_ref (self) : NULL;
}

static void
bird_font_svg_parser_find_last_handle (BirdFontSvgParser* self,
                                       gint start_index,
                                       BirdFontBezierPoints** b,
                                       gint b_length1,
                                       gint num_b,
                                       gdouble* left_x,
                                       gdouble* left_y,
                                       BirdFontPointType* last_type)
{
	gdouble _vala_left_x = 0.0;
	gdouble _vala_left_y = 0.0;
	BirdFontPointType _vala_last_type = 0;
	BirdFontBezierPoints* last = NULL;
	BirdFontBezierPoints* _tmp0_;
	gboolean found = FALSE;
	BirdFontBezierPoints* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bezier_points_new ();
	last = _tmp0_;
	found = FALSE;
	_vala_left_x = (gdouble) 0;
	_vala_left_y = (gdouble) 0;
	_vala_last_type = BIRD_FONT_POINT_TYPE_NONE;
	g_return_if_fail (b_length1 != 0);
	_tmp1_ = b[0];
	g_return_if_fail (_tmp1_->type != ((gunichar) 'z'));
	g_return_if_fail (num_b < b_length1);
	if (num_b == 2) {
		BirdFontBezierPoints* _tmp2_;
		BirdFontBezierPoints* _tmp3_;
		BirdFontBezierPoints* _tmp4_;
		BirdFontBezierPoints* _tmp5_;
		BirdFontBezierPoints* _tmp6_;
		BirdFontBezierPoints* _tmp7_;
		_tmp2_ = b[0];
		_tmp3_ = b[1];
		_tmp4_ = b[0];
		_vala_left_x = _tmp2_->x0 + ((_tmp3_->x0 - _tmp4_->x0) / 3.0);
		_tmp5_ = b[0];
		_tmp6_ = b[1];
		_tmp7_ = b[0];
		_vala_left_y = _tmp5_->y0 + ((_tmp6_->y0 - _tmp7_->y0) / 3.0);
		_vala_last_type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
		_bird_font_bezier_points_unref0 (last);
		if (left_x) {
			*left_x = _vala_left_x;
		}
		if (left_y) {
			*left_y = _vala_left_y;
		}
		if (last_type) {
			*last_type = _vala_last_type;
		}
		return;
	}
	{
		gint i = 0;
		i = start_index;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				BirdFontBezierPoints* _tmp10_;
				gboolean _tmp11_ = FALSE;
				BirdFontBezierPoints* _tmp35_;
				BirdFontBezierPoints* _tmp36_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < num_b)) {
					break;
				}
				_tmp10_ = b[i];
				switch (_tmp10_->type) {
					case 'Q':
					{
						break;
					}
					case 'C':
					{
						break;
					}
					case 'z':
					{
						found = TRUE;
						break;
					}
					default:
					{
						break;
					}
				}
				if (found) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = (i + 1) == num_b;
				}
				if (_tmp11_) {
					BirdFontBezierPoints* _tmp12_;
					g_return_if_fail (i >= 1);
					_tmp12_ = b[i - 1];
					if (_tmp12_->type == ((gunichar) 'Q')) {
						BirdFontBezierPoints* _tmp13_;
						BirdFontBezierPoints* _tmp14_;
						g_return_if_fail (i >= 1);
						_tmp13_ = b[i - 1];
						_vala_left_x = _tmp13_->x0;
						_tmp14_ = b[i - 1];
						_vala_left_y = _tmp14_->y0;
						_vala_last_type = BIRD_FONT_POINT_TYPE_QUADRATIC;
					} else {
						BirdFontBezierPoints* _tmp15_;
						_tmp15_ = b[i - 1];
						if (_tmp15_->type == ((gunichar) 'C')) {
							BirdFontBezierPoints* _tmp16_;
							BirdFontBezierPoints* _tmp17_;
							g_return_if_fail (i >= 1);
							_tmp16_ = b[i - 1];
							_vala_left_x = _tmp16_->x1;
							_tmp17_ = b[i - 1];
							_vala_left_y = _tmp17_->y1;
							_vala_last_type = BIRD_FONT_POINT_TYPE_CUBIC;
						} else {
							BirdFontBezierPoints* _tmp18_;
							_tmp18_ = b[i - 1];
							if (_tmp18_->type == ((gunichar) 'S')) {
								BirdFontBezierPoints* _tmp19_;
								BirdFontBezierPoints* _tmp20_;
								g_return_if_fail (i >= 1);
								_tmp19_ = b[i - 1];
								_vala_left_x = _tmp19_->x1;
								_tmp20_ = b[i - 1];
								_vala_left_y = _tmp20_->y1;
								_vala_last_type = BIRD_FONT_POINT_TYPE_CUBIC;
							} else {
								gboolean _tmp21_ = FALSE;
								BirdFontBezierPoints* _tmp22_;
								_tmp22_ = b[i - 1];
								if (_tmp22_->type == ((gunichar) 'L')) {
									_tmp21_ = TRUE;
								} else {
									BirdFontBezierPoints* _tmp23_;
									_tmp23_ = last;
									_tmp21_ = _tmp23_->type == ((gunichar) 'M');
								}
								if (_tmp21_) {
									BirdFontBezierPoints* _tmp24_;
									BirdFontBezierPoints* _tmp25_;
									BirdFontBezierPoints* _tmp26_;
									BirdFontBezierPoints* _tmp27_;
									BirdFontBezierPoints* _tmp28_;
									BirdFontBezierPoints* _tmp29_;
									g_return_if_fail (i >= 2);
									_tmp24_ = b[i - 2];
									_tmp25_ = b[i - 1];
									_tmp26_ = b[i - 2];
									_vala_left_x = _tmp24_->x0 + ((_tmp25_->x0 - _tmp26_->x0) / 3.0);
									_tmp27_ = b[i - 2];
									_tmp28_ = b[i - 1];
									_tmp29_ = b[i - 2];
									_vala_left_y = _tmp27_->y0 + ((_tmp28_->y0 - _tmp29_->y0) / 3.0);
									_vala_last_type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
								} else {
									BirdFontBezierPoints* _tmp30_;
									gchar* _tmp31_;
									gchar* _tmp32_;
									gchar* _tmp33_;
									gchar* _tmp34_;
									_tmp30_ = b[i - 1];
									_tmp31_ = bird_font_bezier_points_to_string (_tmp30_);
									_tmp32_ = _tmp31_;
									_tmp33_ = g_strconcat ("Unexpected type. ", _tmp32_, "\n", NULL);
									_tmp34_ = _tmp33_;
									g_warning ("SvgParser.vala:1712: %s", _tmp34_);
									_g_free0 (_tmp34_);
									_g_free0 (_tmp32_);
								}
							}
						}
					}
					_bird_font_bezier_points_unref0 (last);
					if (left_x) {
						*left_x = _vala_left_x;
					}
					if (left_y) {
						*left_y = _vala_left_y;
					}
					if (last_type) {
						*last_type = _vala_last_type;
					}
					return;
				}
				_tmp35_ = b[i];
				_tmp36_ = _bird_font_bezier_points_ref0 (_tmp35_);
				_bird_font_bezier_points_unref0 (last);
				last = _tmp36_;
			}
		}
	}
	g_warning ("SvgParser.vala:1720: Last point not found.");
	_bird_font_bezier_points_unref0 (last);
	if (left_x) {
		*left_x = _vala_left_x;
	}
	if (left_y) {
		*left_y = _vala_left_y;
	}
	if (last_type) {
		*last_type = _vala_last_type;
	}
}

static BirdFontPathList*
bird_font_svg_parser_create_paths_inkscape (BirdFontSvgParser* self,
                                            BirdFontBezierPoints** b,
                                            gint b_length1,
                                            gint num_b)
{
	gdouble last_x = 0.0;
	gdouble last_y = 0.0;
	BirdFontPointType last_type = 0;
	BirdFontPath* path = NULL;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp1_;
	GeeArrayList* smooth_points = NULL;
	GeeArrayList* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontBezierPoints* _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	BirdFontPointType _tmp7_ = 0;
	BirdFontPath* _tmp161_;
	GeeArrayList* _tmp162_;
	GeeArrayList* _tmp163_;
	gint _tmp164_;
	gint _tmp165_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	path_list = _tmp0_;
	_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	smooth_points = _tmp2_;
	_tmp3_ = bird_font_path_new ();
	_g_object_unref0 (path);
	path = _tmp3_;
	if (num_b == 0) {
		g_warning ("SvgParser.vala:1735: No SVG data");
		result = path_list;
		_g_object_unref0 (smooth_points);
		_g_object_unref0 (ep);
		_g_object_unref0 (path);
		return result;
	}
	_tmp4_ = b[0];
	if (_tmp4_->type != ((gunichar) 'M')) {
		g_warning ("SvgParser.vala:1740: Path must begin with M or m. Not $(b[0].type	)");
		result = path_list;
		_g_object_unref0 (smooth_points);
		_g_object_unref0 (ep);
		_g_object_unref0 (path);
		return result;
	}
	bird_font_svg_parser_find_last_handle (self, 0, b, (gint) b_length1, num_b, &_tmp5_, &_tmp6_, &_tmp7_);
	last_x = _tmp5_;
	last_y = _tmp6_;
	last_type = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				BirdFontBezierPoints* _tmp10_;
				BirdFontBezierPoints* _tmp11_;
				BirdFontBezierPoints* _tmp21_;
				BirdFontBezierPoints* _tmp58_;
				BirdFontBezierPoints* _tmp81_;
				gboolean _tmp101_ = FALSE;
				BirdFontBezierPoints* _tmp102_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < num_b)) {
					break;
				}
				_tmp10_ = b[i];
				if (_tmp10_->type == ((gunichar) '\0')) {
					g_warning ("SvgParser.vala:1748: Parser error.");
					result = path_list;
					_g_object_unref0 (smooth_points);
					_g_object_unref0 (ep);
					_g_object_unref0 (path);
					return result;
				}
				_tmp11_ = b[i];
				if (_tmp11_->type == ((gunichar) 'z')) {
					BirdFontPath* _tmp12_;
					BirdFontPath* _tmp13_;
					BirdFontPath* _tmp14_;
					BirdFontPathList* _tmp15_;
					BirdFontPath* _tmp16_;
					BirdFontPath* _tmp17_;
					_tmp12_ = path;
					bird_font_path_close (_tmp12_);
					_tmp13_ = path;
					bird_font_path_create_list (_tmp13_);
					_tmp14_ = path;
					bird_font_path_recalculate_linear_handles (_tmp14_);
					_tmp15_ = path_list;
					_tmp16_ = path;
					bird_font_path_list_add (_tmp15_, _tmp16_);
					_tmp17_ = bird_font_path_new ();
					_g_object_unref0 (path);
					path = _tmp17_;
					if ((i + 1) >= num_b) {
						break;
					} else {
						gdouble _tmp18_ = 0.0;
						gdouble _tmp19_ = 0.0;
						BirdFontPointType _tmp20_ = 0;
						bird_font_svg_parser_find_last_handle (self, i + 1, b, (gint) b_length1, num_b, &_tmp18_, &_tmp19_, &_tmp20_);
						last_x = _tmp18_;
						last_y = _tmp19_;
						last_type = _tmp20_;
					}
				}
				if (i >= num_b) {
					break;
				}
				_tmp21_ = b[i];
				if (_tmp21_->type == ((gunichar) 'M')) {
					BirdFontPath* _tmp22_;
					BirdFontBezierPoints* _tmp23_;
					BirdFontBezierPoints* _tmp24_;
					BirdFontEditPoint* _tmp25_;
					BirdFontEditPoint* _tmp26_;
					BirdFontEditPoint* _tmp27_;
					BirdFontEditPointHandle* _tmp28_;
					gboolean _tmp29_ = FALSE;
					_tmp22_ = path;
					_tmp23_ = b[i];
					_tmp24_ = b[i];
					_tmp25_ = bird_font_path_add (_tmp22_, _tmp23_->x0, _tmp24_->y0);
					_g_object_unref0 (ep);
					ep = _tmp25_;
					_tmp26_ = ep;
					bird_font_edit_point_set_point_type (_tmp26_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp27_ = ep;
					_tmp28_ = bird_font_edit_point_get_left_handle (_tmp27_);
					bird_font_edit_point_handle_set_point_type (_tmp28_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
					if (i == 0) {
						_tmp29_ = TRUE;
					} else {
						BirdFontBezierPoints* _tmp30_;
						_tmp30_ = b[i - 1];
						_tmp29_ = _tmp30_->type == ((gunichar) 'z');
					}
					if (_tmp29_) {
						BirdFontEditPoint* _tmp31_;
						BirdFontEditPointHandle* _tmp32_;
						BirdFontEditPoint* _tmp33_;
						BirdFontEditPointHandle* _tmp34_;
						_tmp31_ = ep;
						_tmp32_ = bird_font_edit_point_get_left_handle (_tmp31_);
						bird_font_edit_point_handle_set_point_type (_tmp32_, last_type);
						_tmp33_ = ep;
						_tmp34_ = bird_font_edit_point_get_left_handle (_tmp33_);
						bird_font_edit_point_handle_move_to_coordinate (_tmp34_, last_x, last_y);
					} else {
						gboolean _tmp35_ = FALSE;
						BirdFontBezierPoints* _tmp36_;
						gboolean _tmp44_ = FALSE;
						BirdFontBezierPoints* _tmp45_;
						_tmp36_ = b[i - 1];
						if (_tmp36_->type == ((gunichar) 'C')) {
							_tmp35_ = TRUE;
						} else {
							BirdFontBezierPoints* _tmp37_;
							_tmp37_ = b[i - 1];
							_tmp35_ = _tmp37_->type == ((gunichar) 'S');
						}
						if (_tmp35_) {
							BirdFontEditPoint* _tmp38_;
							BirdFontEditPointHandle* _tmp39_;
							BirdFontEditPoint* _tmp40_;
							BirdFontEditPointHandle* _tmp41_;
							BirdFontBezierPoints* _tmp42_;
							BirdFontBezierPoints* _tmp43_;
							_tmp38_ = ep;
							_tmp39_ = bird_font_edit_point_get_left_handle (_tmp38_);
							bird_font_edit_point_handle_set_point_type (_tmp39_, BIRD_FONT_POINT_TYPE_CUBIC);
							_tmp40_ = ep;
							_tmp41_ = bird_font_edit_point_get_left_handle (_tmp40_);
							_tmp42_ = b[i + 1];
							_tmp43_ = b[i + 1];
							bird_font_edit_point_handle_move_to_coordinate (_tmp41_, _tmp42_->x1, _tmp43_->y1);
						}
						_tmp45_ = b[i + 1];
						if (_tmp45_->type == ((gunichar) 'C')) {
							_tmp44_ = TRUE;
						} else {
							BirdFontBezierPoints* _tmp46_;
							_tmp46_ = b[i - 1];
							_tmp44_ = _tmp46_->type == ((gunichar) 'S');
						}
						if (_tmp44_) {
							BirdFontEditPoint* _tmp47_;
							BirdFontEditPointHandle* _tmp48_;
							BirdFontEditPoint* _tmp49_;
							BirdFontEditPointHandle* _tmp50_;
							BirdFontBezierPoints* _tmp51_;
							BirdFontBezierPoints* _tmp52_;
							_tmp47_ = ep;
							_tmp48_ = bird_font_edit_point_get_right_handle (_tmp47_);
							bird_font_edit_point_handle_set_point_type (_tmp48_, BIRD_FONT_POINT_TYPE_CUBIC);
							_tmp49_ = ep;
							_tmp50_ = bird_font_edit_point_get_right_handle (_tmp49_);
							_tmp51_ = b[i + 1];
							_tmp52_ = b[i + 1];
							bird_font_edit_point_handle_move_to_coordinate (_tmp50_, _tmp51_->x0, _tmp52_->y0);
						} else {
							gboolean _tmp53_ = FALSE;
							BirdFontBezierPoints* _tmp54_;
							_tmp54_ = b[i + 1];
							if (_tmp54_->type == ((gunichar) 'L')) {
								_tmp53_ = TRUE;
							} else {
								BirdFontBezierPoints* _tmp55_;
								_tmp55_ = b[i + 1];
								_tmp53_ = _tmp55_->type == ((gunichar) 'M');
							}
							if (_tmp53_) {
								BirdFontEditPoint* _tmp56_;
								BirdFontEditPointHandle* _tmp57_;
								_tmp56_ = ep;
								_tmp57_ = bird_font_edit_point_get_right_handle (_tmp56_);
								bird_font_edit_point_handle_set_point_type (_tmp57_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
							}
						}
					}
				}
				_tmp58_ = b[i];
				if (_tmp58_->type == ((gunichar) 'L')) {
					BirdFontPathList* _tmp59_;
					BirdFontPath* _tmp60_;
					BirdFontBezierPoints* _tmp61_;
					BirdFontBezierPoints* _tmp62_;
					BirdFontEditPoint* _tmp63_;
					BirdFontEditPoint* _tmp64_;
					BirdFontEditPoint* _tmp65_;
					BirdFontEditPointHandle* _tmp66_;
					BirdFontEditPoint* _tmp67_;
					BirdFontEditPointHandle* _tmp68_;
					gboolean _tmp69_ = FALSE;
					gboolean _tmp70_ = FALSE;
					BirdFontBezierPoints* _tmp71_;
					gboolean _tmp76_ = FALSE;
					BirdFontBezierPoints* _tmp77_;
					_tmp59_ = path_list;
					g_return_val_if_fail (i != 0, _tmp59_);
					_tmp60_ = path;
					_tmp61_ = b[i];
					_tmp62_ = b[i];
					_tmp63_ = bird_font_path_add (_tmp60_, _tmp61_->x0, _tmp62_->y0);
					_g_object_unref0 (ep);
					ep = _tmp63_;
					_tmp64_ = ep;
					bird_font_edit_point_set_point_type (_tmp64_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp65_ = ep;
					_tmp66_ = bird_font_edit_point_get_right_handle (_tmp65_);
					bird_font_edit_point_handle_set_point_type (_tmp66_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
					_tmp67_ = ep;
					_tmp68_ = bird_font_edit_point_get_left_handle (_tmp67_);
					bird_font_edit_point_handle_set_point_type (_tmp68_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
					_tmp71_ = b[i + 1];
					if (_tmp71_->type == ((gunichar) 'L')) {
						_tmp70_ = TRUE;
					} else {
						BirdFontBezierPoints* _tmp72_;
						_tmp72_ = b[i + 1];
						_tmp70_ = _tmp72_->type == ((gunichar) 'M');
					}
					if (_tmp70_) {
						_tmp69_ = TRUE;
					} else {
						BirdFontBezierPoints* _tmp73_;
						_tmp73_ = b[i + 1];
						_tmp69_ = _tmp73_->type == ((gunichar) 'z');
					}
					if (_tmp69_) {
						BirdFontEditPoint* _tmp74_;
						BirdFontEditPointHandle* _tmp75_;
						_tmp74_ = ep;
						_tmp75_ = bird_font_edit_point_get_right_handle (_tmp74_);
						bird_font_edit_point_handle_set_point_type (_tmp75_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
					}
					_tmp77_ = b[i - 1];
					if (_tmp77_->type == ((gunichar) 'L')) {
						_tmp76_ = TRUE;
					} else {
						BirdFontBezierPoints* _tmp78_;
						_tmp78_ = b[i - 1];
						_tmp76_ = _tmp78_->type == ((gunichar) 'M');
					}
					if (_tmp76_) {
						BirdFontEditPoint* _tmp79_;
						BirdFontEditPointHandle* _tmp80_;
						_tmp79_ = ep;
						_tmp80_ = bird_font_edit_point_get_left_handle (_tmp79_);
						bird_font_edit_point_handle_set_point_type (_tmp80_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
					}
				}
				_tmp81_ = b[i];
				if (_tmp81_->type == ((gunichar) 'Q')) {
					BirdFontPathList* _tmp82_;
					BirdFontEditPoint* _tmp83_;
					BirdFontEditPoint* _tmp84_;
					BirdFontEditPointHandle* _tmp85_;
					BirdFontEditPoint* _tmp86_;
					BirdFontEditPointHandle* _tmp87_;
					BirdFontBezierPoints* _tmp88_;
					BirdFontBezierPoints* _tmp89_;
					BirdFontBezierPoints* _tmp90_;
					_tmp82_ = path_list;
					g_return_val_if_fail (i != 0, _tmp82_);
					_tmp83_ = ep;
					bird_font_edit_point_set_point_type (_tmp83_, BIRD_FONT_POINT_TYPE_QUADRATIC);
					_tmp84_ = ep;
					_tmp85_ = bird_font_edit_point_get_right_handle (_tmp84_);
					bird_font_edit_point_handle_set_point_type (_tmp85_, BIRD_FONT_POINT_TYPE_QUADRATIC);
					_tmp86_ = ep;
					_tmp87_ = bird_font_edit_point_get_right_handle (_tmp86_);
					_tmp88_ = b[i];
					_tmp89_ = b[i];
					bird_font_edit_point_handle_move_to_coordinate (_tmp87_, _tmp88_->x0, _tmp89_->y0);
					_tmp90_ = b[i + 1];
					if (_tmp90_->type != ((gunichar) 'z')) {
						BirdFontPath* _tmp91_;
						BirdFontBezierPoints* _tmp92_;
						BirdFontBezierPoints* _tmp93_;
						BirdFontEditPoint* _tmp94_;
						BirdFontEditPoint* _tmp95_;
						BirdFontEditPointHandle* _tmp96_;
						BirdFontEditPoint* _tmp97_;
						BirdFontEditPointHandle* _tmp98_;
						BirdFontBezierPoints* _tmp99_;
						BirdFontBezierPoints* _tmp100_;
						_tmp91_ = path;
						_tmp92_ = b[i];
						_tmp93_ = b[i];
						_tmp94_ = bird_font_path_add (_tmp91_, _tmp92_->x1, _tmp93_->y1);
						_g_object_unref0 (ep);
						ep = _tmp94_;
						_tmp95_ = ep;
						_tmp96_ = bird_font_edit_point_get_left_handle (_tmp95_);
						bird_font_edit_point_handle_set_point_type (_tmp96_, BIRD_FONT_POINT_TYPE_QUADRATIC);
						_tmp97_ = ep;
						_tmp98_ = bird_font_edit_point_get_left_handle (_tmp97_);
						_tmp99_ = b[i];
						_tmp100_ = b[i];
						bird_font_edit_point_handle_move_to_coordinate (_tmp98_, _tmp99_->x0, _tmp100_->y0);
					}
				}
				_tmp102_ = b[i];
				if (_tmp102_->type == ((gunichar) 'C')) {
					_tmp101_ = TRUE;
				} else {
					BirdFontBezierPoints* _tmp103_;
					_tmp103_ = b[i];
					_tmp101_ = _tmp103_->type == ((gunichar) 'S');
				}
				if (_tmp101_) {
					BirdFontPathList* _tmp104_;
					BirdFontEditPoint* _tmp105_;
					BirdFontEditPoint* _tmp106_;
					BirdFontEditPointHandle* _tmp107_;
					BirdFontEditPoint* _tmp108_;
					BirdFontEditPointHandle* _tmp109_;
					BirdFontBezierPoints* _tmp110_;
					BirdFontBezierPoints* _tmp111_;
					BirdFontBezierPoints* _tmp112_;
					BirdFontBezierPoints* _tmp115_;
					_tmp104_ = path_list;
					g_return_val_if_fail (i != 0, _tmp104_);
					_tmp105_ = ep;
					bird_font_edit_point_set_point_type (_tmp105_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp106_ = ep;
					_tmp107_ = bird_font_edit_point_get_right_handle (_tmp106_);
					bird_font_edit_point_handle_set_point_type (_tmp107_, BIRD_FONT_POINT_TYPE_CUBIC);
					_tmp108_ = ep;
					_tmp109_ = bird_font_edit_point_get_right_handle (_tmp108_);
					_tmp110_ = b[i];
					_tmp111_ = b[i];
					bird_font_edit_point_handle_move_to_coordinate (_tmp109_, _tmp110_->x0, _tmp111_->y0);
					_tmp112_ = b[i];
					if (_tmp112_->type == ((gunichar) 'S')) {
						GeeArrayList* _tmp113_;
						BirdFontEditPoint* _tmp114_;
						_tmp113_ = smooth_points;
						_tmp114_ = ep;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, _tmp114_);
					}
					_tmp115_ = b[i + 1];
					if (_tmp115_->type != ((gunichar) 'z')) {
						BirdFontPath* _tmp116_;
						BirdFontBezierPoints* _tmp117_;
						BirdFontBezierPoints* _tmp118_;
						BirdFontEditPoint* _tmp119_;
						BirdFontEditPoint* _tmp120_;
						BirdFontEditPointHandle* _tmp121_;
						BirdFontEditPoint* _tmp122_;
						BirdFontEditPointHandle* _tmp123_;
						BirdFontBezierPoints* _tmp124_;
						BirdFontBezierPoints* _tmp125_;
						_tmp116_ = path;
						_tmp117_ = b[i];
						_tmp118_ = b[i];
						_tmp119_ = bird_font_path_add (_tmp116_, _tmp117_->x2, _tmp118_->y2);
						_g_object_unref0 (ep);
						ep = _tmp119_;
						_tmp120_ = ep;
						_tmp121_ = bird_font_edit_point_get_left_handle (_tmp120_);
						bird_font_edit_point_handle_set_point_type (_tmp121_, BIRD_FONT_POINT_TYPE_CUBIC);
						_tmp122_ = ep;
						_tmp123_ = bird_font_edit_point_get_left_handle (_tmp122_);
						_tmp124_ = b[i];
						_tmp125_ = b[i];
						bird_font_edit_point_handle_move_to_coordinate (_tmp123_, _tmp124_->x1, _tmp125_->y1);
					}
				}
			}
		}
	}
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp126_;
		gint _e_size = 0;
		GeeArrayList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _e_index = 0;
		_tmp126_ = smooth_points;
		_e_list = _tmp126_;
		_tmp127_ = _e_list;
		_tmp128_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_e_size = _tmp129_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp132_;
			gpointer _tmp133_;
			BirdFontEditPoint* _tmp134_;
			BirdFontEditPoint* _tmp135_;
			BirdFontEditPointHandle* _tmp136_;
			BirdFontEditPoint* _tmp137_;
			BirdFontEditPointHandle* _tmp138_;
			_e_index = _e_index + 1;
			_tmp130_ = _e_index;
			_tmp131_ = _e_size;
			if (!(_tmp130_ < _tmp131_)) {
				break;
			}
			_tmp132_ = _e_list;
			_tmp133_ = gee_abstract_list_get ((GeeAbstractList*) _tmp132_, _e_index);
			e = (BirdFontEditPoint*) _tmp133_;
			_tmp134_ = e;
			bird_font_edit_point_set_point_type (_tmp134_, BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE);
			_tmp135_ = e;
			_tmp136_ = bird_font_edit_point_get_right_handle (_tmp135_);
			bird_font_edit_point_handle_set_point_type (_tmp136_, BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE);
			_tmp137_ = e;
			_tmp138_ = bird_font_edit_point_get_left_handle (_tmp137_);
			bird_font_edit_point_handle_set_point_type (_tmp138_, BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE);
			_g_object_unref0 (e);
		}
	}
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp139_;
		gint _e_size = 0;
		GeeArrayList* _tmp140_;
		gint _tmp141_;
		gint _tmp142_;
		gint _e_index = 0;
		_tmp139_ = smooth_points;
		_e_list = _tmp139_;
		_tmp140_ = _e_list;
		_tmp141_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp140_);
		_tmp142_ = _tmp141_;
		_e_size = _tmp142_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp143_;
			gint _tmp144_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp145_;
			gpointer _tmp146_;
			BirdFontPath* _tmp147_;
			BirdFontEditPoint* _tmp148_;
			_e_index = _e_index + 1;
			_tmp143_ = _e_index;
			_tmp144_ = _e_size;
			if (!(_tmp143_ < _tmp144_)) {
				break;
			}
			_tmp145_ = _e_list;
			_tmp146_ = gee_abstract_list_get ((GeeAbstractList*) _tmp145_, _e_index);
			e = (BirdFontEditPoint*) _tmp146_;
			_tmp147_ = path;
			_tmp148_ = e;
			bird_font_path_recalculate_linear_handles_for_point (_tmp147_, _tmp148_);
			_g_object_unref0 (e);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp149_ = FALSE;
			_tmp149_ = TRUE;
			while (TRUE) {
				if (!_tmp149_) {
					gint _tmp150_;
					_tmp150_ = i;
					i = _tmp150_ + 1;
				}
				_tmp149_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				{
					GeeArrayList* _e_list = NULL;
					GeeArrayList* _tmp151_;
					gint _e_size = 0;
					GeeArrayList* _tmp152_;
					gint _tmp153_;
					gint _tmp154_;
					gint _e_index = 0;
					_tmp151_ = smooth_points;
					_e_list = _tmp151_;
					_tmp152_ = _e_list;
					_tmp153_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp152_);
					_tmp154_ = _tmp153_;
					_e_size = _tmp154_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp155_;
						gint _tmp156_;
						BirdFontEditPoint* e = NULL;
						GeeArrayList* _tmp157_;
						gpointer _tmp158_;
						BirdFontEditPoint* _tmp159_;
						BirdFontEditPoint* _tmp160_;
						_e_index = _e_index + 1;
						_tmp155_ = _e_index;
						_tmp156_ = _e_size;
						if (!(_tmp155_ < _tmp156_)) {
							break;
						}
						_tmp157_ = _e_list;
						_tmp158_ = gee_abstract_list_get ((GeeAbstractList*) _tmp157_, _e_index);
						e = (BirdFontEditPoint*) _tmp158_;
						_tmp159_ = e;
						bird_font_edit_point_set_tie_handle (_tmp159_, TRUE);
						_tmp160_ = e;
						bird_font_edit_point_process_tied_handle (_tmp160_);
						_g_object_unref0 (e);
					}
				}
			}
		}
	}
	_tmp161_ = path;
	_tmp162_ = bird_font_path_get_points (_tmp161_);
	_tmp163_ = _tmp162_;
	_tmp164_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp163_);
	_tmp165_ = _tmp164_;
	if (_tmp165_ > 0) {
		BirdFontPathList* _tmp166_;
		BirdFontPath* _tmp167_;
		_tmp166_ = path_list;
		_tmp167_ = path;
		bird_font_path_list_add (_tmp166_, _tmp167_);
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp168_;
		GeeArrayList* _tmp169_;
		gint _p_size = 0;
		GeeArrayList* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		gint _p_index = 0;
		_tmp168_ = path_list;
		_tmp169_ = _tmp168_->paths;
		_p_list = _tmp169_;
		_tmp170_ = _p_list;
		_tmp171_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp170_);
		_tmp172_ = _tmp171_;
		_p_size = _tmp172_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp173_;
			gint _tmp174_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp175_;
			gpointer _tmp176_;
			BirdFontPath* _tmp177_;
			_p_index = _p_index + 1;
			_tmp173_ = _p_index;
			_tmp174_ = _p_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _p_list;
			_tmp176_ = gee_abstract_list_get ((GeeAbstractList*) _tmp175_, _p_index);
			p = (BirdFontPath*) _tmp176_;
			_tmp177_ = p;
			bird_font_path_remove_points_on_points (_tmp177_, 0.2);
			_g_object_unref0 (p);
		}
	}
	result = path_list;
	_g_object_unref0 (smooth_points);
	_g_object_unref0 (ep);
	_g_object_unref0 (path);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static BirdFontPathList*
bird_font_svg_parser_create_paths_illustrator (BirdFontSvgParser* self,
                                               BirdFontBezierPoints** b,
                                               gint b_length1,
                                               gint num_b)
{
	BirdFontPath* path = NULL;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontEditPoint* ep = NULL;
	gboolean first_point = FALSE;
	gdouble first_left_x = 0.0;
	gdouble first_left_y = 0.0;
	GeeArrayList* smooth_points = NULL;
	GeeArrayList* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontPath* _tmp170_;
	GeeArrayList* _tmp171_;
	GeeArrayList* _tmp172_;
	gint _tmp173_;
	gint _tmp174_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_list_new ();
	path_list = _tmp0_;
	first_point = TRUE;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	smooth_points = _tmp1_;
	if (num_b > b_length1) {
		g_warning ("SvgParser.vala:1885: num_b > b.length: $num_b > $(b.length)");
		result = path_list;
		_g_object_unref0 (smooth_points);
		_g_object_unref0 (ep);
		_g_object_unref0 (path);
		return result;
	}
	_tmp2_ = bird_font_path_new ();
	_g_object_unref0 (path);
	path = _tmp2_;
	if (num_b <= 1) {
		g_warning ("SvgParser.vala:1892: No SVG data");
		result = path_list;
		_g_object_unref0 (smooth_points);
		_g_object_unref0 (ep);
		_g_object_unref0 (path);
		return result;
	}
	first_left_x = (gdouble) 0;
	first_left_y = (gdouble) 0;
	_tmp3_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (ep);
	ep = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				BirdFontBezierPoints* _tmp6_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < num_b)) {
					break;
				}
				_tmp6_ = b[i];
				if (_tmp6_->type == ((gunichar) '\0')) {
					g_warning ("SvgParser.vala:1903: Parser error.");
					result = path_list;
					_g_object_unref0 (smooth_points);
					_g_object_unref0 (ep);
					_g_object_unref0 (path);
					return result;
				} else {
					BirdFontBezierPoints* _tmp7_;
					_tmp7_ = b[i];
					if (_tmp7_->type == ((gunichar) 'z')) {
						BirdFontPath* _tmp8_;
						BirdFontPath* _tmp9_;
						gint first_index = 0;
						gboolean _tmp13_ = FALSE;
						BirdFontBezierPoints* _tmp14_;
						BirdFontPath* _tmp61_;
						BirdFontPathList* _tmp62_;
						BirdFontPath* _tmp63_;
						BirdFontPath* _tmp64_;
						_tmp8_ = path;
						bird_font_path_close (_tmp8_);
						_tmp9_ = path;
						bird_font_path_create_list (_tmp9_);
						first_index = 1;
						{
							gint j = 0;
							j = i - 1;
							{
								gboolean _tmp10_ = FALSE;
								_tmp10_ = TRUE;
								while (TRUE) {
									BirdFontBezierPoints* _tmp12_;
									if (!_tmp10_) {
										gint _tmp11_;
										_tmp11_ = j;
										j = _tmp11_ - 1;
									}
									_tmp10_ = FALSE;
									if (!(j >= 1)) {
										break;
									}
									_tmp12_ = b[j];
									if (_tmp12_->type == ((gunichar) 'z')) {
										first_index = j + 1;
									}
								}
							}
						}
						_tmp14_ = b[first_index];
						if (_tmp14_->type == ((gunichar) 'C')) {
							_tmp13_ = TRUE;
						} else {
							BirdFontBezierPoints* _tmp15_;
							_tmp15_ = b[first_index];
							_tmp13_ = _tmp15_->type == ((gunichar) 'S');
						}
						if (_tmp13_) {
							BirdFontPath* _tmp16_;
							GeeArrayList* _tmp17_;
							GeeArrayList* _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							BirdFontPathList* _tmp21_;
							BirdFontPath* _tmp22_;
							GeeArrayList* _tmp23_;
							GeeArrayList* _tmp24_;
							BirdFontPath* _tmp25_;
							GeeArrayList* _tmp26_;
							GeeArrayList* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gpointer _tmp30_;
							BirdFontBezierPoints* _tmp31_;
							_tmp16_ = path;
							_tmp17_ = bird_font_path_get_points (_tmp16_);
							_tmp18_ = _tmp17_;
							_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
							_tmp20_ = _tmp19_;
							_tmp21_ = path_list;
							g_return_val_if_fail (_tmp20_ != 0, _tmp21_);
							_tmp22_ = path;
							_tmp23_ = bird_font_path_get_points (_tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = path;
							_tmp26_ = bird_font_path_get_points (_tmp25_);
							_tmp27_ = _tmp26_;
							_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
							_tmp29_ = _tmp28_;
							_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp29_ - 1);
							_g_object_unref0 (ep);
							ep = (BirdFontEditPoint*) _tmp30_;
							_tmp31_ = b[i - 1];
							if (_tmp31_->type != ((gunichar) 'L')) {
								BirdFontEditPoint* _tmp32_;
								BirdFontEditPointHandle* _tmp33_;
								BirdFontEditPoint* _tmp34_;
								BirdFontEditPointHandle* _tmp35_;
								BirdFontBezierPoints* _tmp36_;
								BirdFontBezierPoints* _tmp37_;
								_tmp32_ = ep;
								_tmp33_ = bird_font_edit_point_get_right_handle (_tmp32_);
								bird_font_edit_point_handle_set_point_type (_tmp33_, BIRD_FONT_POINT_TYPE_CUBIC);
								_tmp34_ = ep;
								_tmp35_ = bird_font_edit_point_get_right_handle (_tmp34_);
								_tmp36_ = b[first_index];
								_tmp37_ = b[first_index];
								bird_font_edit_point_handle_move_to_coordinate (_tmp35_, _tmp36_->x0, _tmp37_->y0);
							}
						} else {
							BirdFontBezierPoints* _tmp38_;
							_tmp38_ = b[first_index];
							if (_tmp38_->type == ((gunichar) 'L')) {
								BirdFontPath* _tmp39_;
								GeeArrayList* _tmp40_;
								GeeArrayList* _tmp41_;
								gint _tmp42_;
								gint _tmp43_;
								BirdFontPathList* _tmp44_;
								BirdFontPath* _tmp45_;
								GeeArrayList* _tmp46_;
								GeeArrayList* _tmp47_;
								BirdFontPath* _tmp48_;
								GeeArrayList* _tmp49_;
								GeeArrayList* _tmp50_;
								gint _tmp51_;
								gint _tmp52_;
								gpointer _tmp53_;
								BirdFontEditPoint* _tmp54_;
								BirdFontEditPointHandle* _tmp55_;
								BirdFontPath* _tmp56_;
								BirdFontEditPoint* _tmp57_;
								_tmp39_ = path;
								_tmp40_ = bird_font_path_get_points (_tmp39_);
								_tmp41_ = _tmp40_;
								_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = path_list;
								g_return_val_if_fail (_tmp43_ != 0, _tmp44_);
								_tmp45_ = path;
								_tmp46_ = bird_font_path_get_points (_tmp45_);
								_tmp47_ = _tmp46_;
								_tmp48_ = path;
								_tmp49_ = bird_font_path_get_points (_tmp48_);
								_tmp50_ = _tmp49_;
								_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
								_tmp52_ = _tmp51_;
								_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp52_ - 1);
								_g_object_unref0 (ep);
								ep = (BirdFontEditPoint*) _tmp53_;
								_tmp54_ = ep;
								_tmp55_ = bird_font_edit_point_get_right_handle (_tmp54_);
								bird_font_edit_point_handle_set_point_type (_tmp55_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
								_tmp56_ = path;
								_tmp57_ = ep;
								bird_font_path_recalculate_linear_handles_for_point (_tmp56_, _tmp57_);
							} else {
								BirdFontBezierPoints* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								_tmp58_ = b[first_index];
								_tmp59_ = g_unichar_to_string (_tmp58_->type);
								_tmp60_ = (gchar*) _tmp59_;
								g_warning ("SvgParser.vala:1931: Unexpected type: %s", _tmp60_);
								_g_free0 (_tmp60_);
							}
						}
						_tmp61_ = path;
						bird_font_path_recalculate_linear_handles (_tmp61_);
						_tmp62_ = path_list;
						_tmp63_ = path;
						bird_font_path_list_add (_tmp62_, _tmp63_);
						_tmp64_ = bird_font_path_new ();
						_g_object_unref0 (path);
						path = _tmp64_;
						first_point = TRUE;
					} else {
						gboolean _tmp65_ = FALSE;
						BirdFontBezierPoints* _tmp66_;
						_tmp66_ = b[i];
						if (_tmp66_->type == ((gunichar) 'L')) {
							_tmp65_ = TRUE;
						} else {
							BirdFontBezierPoints* _tmp67_;
							_tmp67_ = b[i];
							_tmp65_ = _tmp67_->type == ((gunichar) 'M');
						}
						if (_tmp65_) {
							BirdFontPath* _tmp70_;
							BirdFontBezierPoints* _tmp71_;
							BirdFontBezierPoints* _tmp72_;
							BirdFontEditPoint* _tmp73_;
							BirdFontEditPoint* _tmp74_;
							BirdFontEditPoint* _tmp75_;
							BirdFontEditPointHandle* _tmp76_;
							gboolean _tmp77_ = FALSE;
							gboolean _tmp81_ = FALSE;
							BirdFontBezierPoints* _tmp82_;
							if (first_point) {
								BirdFontBezierPoints* _tmp68_;
								BirdFontBezierPoints* _tmp69_;
								_tmp68_ = b[i];
								first_left_x = _tmp68_->x0;
								_tmp69_ = b[i];
								first_left_y = _tmp69_->y0;
							}
							_tmp70_ = path;
							_tmp71_ = b[i];
							_tmp72_ = b[i];
							_tmp73_ = bird_font_path_add (_tmp70_, _tmp71_->x0, _tmp72_->y0);
							_g_object_unref0 (ep);
							ep = _tmp73_;
							_tmp74_ = ep;
							bird_font_edit_point_set_point_type (_tmp74_, BIRD_FONT_POINT_TYPE_CUBIC);
							_tmp75_ = ep;
							_tmp76_ = bird_font_edit_point_get_right_handle (_tmp75_);
							bird_font_edit_point_handle_set_point_type (_tmp76_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
							if (first_point) {
								_tmp77_ = TRUE;
							} else {
								BirdFontBezierPoints* _tmp78_;
								_tmp78_ = b[i - 1];
								_tmp77_ = _tmp78_->type == ((gunichar) 'L');
							}
							if (_tmp77_) {
							} else {
								BirdFontEditPoint* _tmp79_;
								BirdFontEditPointHandle* _tmp80_;
								_tmp79_ = ep;
								_tmp80_ = bird_font_edit_point_get_left_handle (_tmp79_);
								bird_font_edit_point_handle_set_point_type (_tmp80_, BIRD_FONT_POINT_TYPE_CUBIC);
							}
							_tmp82_ = b[i + 1];
							if (_tmp82_->type == ((gunichar) 'C')) {
								_tmp81_ = TRUE;
							} else {
								BirdFontBezierPoints* _tmp83_;
								_tmp83_ = b[i + 1];
								_tmp81_ = _tmp83_->type == ((gunichar) 'S');
							}
							if (_tmp81_) {
								BirdFontPathList* _tmp84_;
								BirdFontEditPoint* _tmp85_;
								BirdFontEditPointHandle* _tmp86_;
								BirdFontEditPoint* _tmp87_;
								BirdFontEditPointHandle* _tmp88_;
								BirdFontBezierPoints* _tmp89_;
								BirdFontBezierPoints* _tmp90_;
								_tmp84_ = path_list;
								g_return_val_if_fail ((i + 1) < num_b, _tmp84_);
								_tmp85_ = ep;
								_tmp86_ = bird_font_edit_point_get_right_handle (_tmp85_);
								bird_font_edit_point_handle_set_point_type (_tmp86_, BIRD_FONT_POINT_TYPE_CUBIC);
								_tmp87_ = ep;
								_tmp88_ = bird_font_edit_point_get_right_handle (_tmp87_);
								_tmp89_ = b[i + 1];
								_tmp90_ = b[i + 1];
								bird_font_edit_point_handle_move_to_coordinate (_tmp88_, _tmp89_->x0, _tmp90_->y0);
							}
							first_point = FALSE;
						} else {
							BirdFontBezierPoints* _tmp91_;
							_tmp91_ = b[i];
							if (_tmp91_->type == ((gunichar) 'Q')) {
								BirdFontBezierPoints* _tmp92_;
								gchar* _tmp93_;
								gchar* _tmp94_;
								gchar* _tmp95_;
								gchar* _tmp96_;
								g_warning ("SvgParser.vala:1964: Illustrator does not support quadratic control po" \
"ints.");
								_tmp92_ = b[i];
								_tmp93_ = bird_font_bezier_points_to_string (_tmp92_);
								_tmp94_ = _tmp93_;
								_tmp95_ = g_strconcat (_tmp94_, "\n", NULL);
								_tmp96_ = _tmp95_;
								g_warning ("SvgParser.vala:1965: %s", _tmp96_);
								_g_free0 (_tmp96_);
								_g_free0 (_tmp94_);
							} else {
								gboolean _tmp97_ = FALSE;
								BirdFontBezierPoints* _tmp98_;
								_tmp98_ = b[i];
								if (_tmp98_->type == ((gunichar) 'C')) {
									_tmp97_ = TRUE;
								} else {
									BirdFontBezierPoints* _tmp99_;
									_tmp99_ = b[i];
									_tmp97_ = _tmp99_->type == ((gunichar) 'S');
								}
								if (_tmp97_) {
									BirdFontPath* _tmp102_;
									BirdFontBezierPoints* _tmp103_;
									BirdFontBezierPoints* _tmp104_;
									BirdFontEditPoint* _tmp105_;
									BirdFontEditPoint* _tmp106_;
									BirdFontEditPoint* _tmp107_;
									BirdFontEditPointHandle* _tmp108_;
									BirdFontEditPoint* _tmp109_;
									BirdFontEditPointHandle* _tmp110_;
									BirdFontEditPoint* _tmp111_;
									BirdFontEditPointHandle* _tmp112_;
									BirdFontBezierPoints* _tmp113_;
									BirdFontBezierPoints* _tmp114_;
									BirdFontBezierPoints* _tmp115_;
									gboolean _tmp118_ = FALSE;
									BirdFontBezierPoints* _tmp119_;
									if (first_point) {
										BirdFontBezierPoints* _tmp100_;
										BirdFontBezierPoints* _tmp101_;
										_tmp100_ = b[i];
										first_left_x = _tmp100_->x0;
										_tmp101_ = b[i];
										first_left_y = _tmp101_->y0;
									}
									_tmp102_ = path;
									_tmp103_ = b[i];
									_tmp104_ = b[i];
									_tmp105_ = bird_font_path_add (_tmp102_, _tmp103_->x2, _tmp104_->y2);
									_g_object_unref0 (ep);
									ep = _tmp105_;
									_tmp106_ = ep;
									bird_font_edit_point_set_point_type (_tmp106_, BIRD_FONT_POINT_TYPE_CUBIC);
									_tmp107_ = ep;
									_tmp108_ = bird_font_edit_point_get_right_handle (_tmp107_);
									bird_font_edit_point_handle_set_point_type (_tmp108_, BIRD_FONT_POINT_TYPE_CUBIC);
									_tmp109_ = ep;
									_tmp110_ = bird_font_edit_point_get_left_handle (_tmp109_);
									bird_font_edit_point_handle_set_point_type (_tmp110_, BIRD_FONT_POINT_TYPE_CUBIC);
									_tmp111_ = ep;
									_tmp112_ = bird_font_edit_point_get_left_handle (_tmp111_);
									_tmp113_ = b[i];
									_tmp114_ = b[i];
									bird_font_edit_point_handle_move_to_coordinate (_tmp112_, _tmp113_->x1, _tmp114_->y1);
									_tmp115_ = b[i];
									if (_tmp115_->type == ((gunichar) 'S')) {
										GeeArrayList* _tmp116_;
										BirdFontEditPoint* _tmp117_;
										_tmp116_ = smooth_points;
										_tmp117_ = ep;
										gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, _tmp117_);
									}
									_tmp119_ = b[i + 1];
									if (_tmp119_->type != ((gunichar) 'z')) {
										_tmp118_ = i != (num_b - 1);
									} else {
										_tmp118_ = FALSE;
									}
									if (_tmp118_) {
										BirdFontEditPoint* _tmp120_;
										BirdFontEditPointHandle* _tmp121_;
										BirdFontBezierPoints* _tmp122_;
										BirdFontBezierPoints* _tmp123_;
										_tmp120_ = ep;
										_tmp121_ = bird_font_edit_point_get_right_handle (_tmp120_);
										_tmp122_ = b[i + 1];
										_tmp123_ = b[i + 1];
										bird_font_edit_point_handle_move_to_coordinate (_tmp121_, _tmp122_->x0, _tmp123_->y0);
									} else {
										BirdFontEditPoint* _tmp124_;
										BirdFontEditPointHandle* _tmp125_;
										_tmp124_ = ep;
										_tmp125_ = bird_font_edit_point_get_right_handle (_tmp124_);
										bird_font_edit_point_handle_move_to_coordinate (_tmp125_, first_left_x, first_left_y);
									}
									first_point = FALSE;
								} else {
									BirdFontBezierPoints* _tmp126_;
									gchar* _tmp127_;
									gchar* _tmp128_;
									gchar* _tmp129_;
									gchar* _tmp130_;
									g_warning ("SvgParser.vala:1993: Unknown control point type.");
									_tmp126_ = b[i];
									_tmp127_ = bird_font_bezier_points_to_string (_tmp126_);
									_tmp128_ = _tmp127_;
									_tmp129_ = g_strconcat (_tmp128_, "\n", NULL);
									_tmp130_ = _tmp129_;
									g_warning ("SvgParser.vala:1994: %s", _tmp130_);
									_g_free0 (_tmp130_);
									_g_free0 (_tmp128_);
								}
							}
						}
					}
				}
			}
		}
	}
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp131_;
		gint _e_size = 0;
		GeeArrayList* _tmp132_;
		gint _tmp133_;
		gint _tmp134_;
		gint _e_index = 0;
		_tmp131_ = smooth_points;
		_e_list = _tmp131_;
		_tmp132_ = _e_list;
		_tmp133_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp132_);
		_tmp134_ = _tmp133_;
		_e_size = _tmp134_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp135_;
			gint _tmp136_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp137_;
			gpointer _tmp138_;
			BirdFontEditPoint* _tmp139_;
			BirdFontEditPoint* _tmp140_;
			BirdFontEditPointHandle* _tmp141_;
			BirdFontEditPoint* _tmp142_;
			BirdFontEditPointHandle* _tmp143_;
			_e_index = _e_index + 1;
			_tmp135_ = _e_index;
			_tmp136_ = _e_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _e_list;
			_tmp138_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, _e_index);
			e = (BirdFontEditPoint*) _tmp138_;
			_tmp139_ = e;
			bird_font_edit_point_set_point_type (_tmp139_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
			_tmp140_ = e;
			_tmp141_ = bird_font_edit_point_get_right_handle (_tmp140_);
			bird_font_edit_point_handle_set_point_type (_tmp141_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
			_tmp142_ = e;
			_tmp143_ = bird_font_edit_point_get_left_handle (_tmp142_);
			bird_font_edit_point_handle_set_point_type (_tmp143_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
			_g_object_unref0 (e);
		}
	}
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp144_;
		gint _e_size = 0;
		GeeArrayList* _tmp145_;
		gint _tmp146_;
		gint _tmp147_;
		gint _e_index = 0;
		_tmp144_ = smooth_points;
		_e_list = _tmp144_;
		_tmp145_ = _e_list;
		_tmp146_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp145_);
		_tmp147_ = _tmp146_;
		_e_size = _tmp147_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp148_;
			gint _tmp149_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp150_;
			gpointer _tmp151_;
			BirdFontPath* _tmp152_;
			BirdFontEditPoint* _tmp153_;
			_e_index = _e_index + 1;
			_tmp148_ = _e_index;
			_tmp149_ = _e_size;
			if (!(_tmp148_ < _tmp149_)) {
				break;
			}
			_tmp150_ = _e_list;
			_tmp151_ = gee_abstract_list_get ((GeeAbstractList*) _tmp150_, _e_index);
			e = (BirdFontEditPoint*) _tmp151_;
			_tmp152_ = path;
			_tmp153_ = e;
			bird_font_path_recalculate_linear_handles_for_point (_tmp152_, _tmp153_);
			_g_object_unref0 (e);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp154_ = FALSE;
			_tmp154_ = TRUE;
			while (TRUE) {
				if (!_tmp154_) {
					gint _tmp155_;
					_tmp155_ = i;
					i = _tmp155_ + 1;
				}
				_tmp154_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				{
					GeeArrayList* _e_list = NULL;
					GeeArrayList* _tmp156_;
					gint _e_size = 0;
					GeeArrayList* _tmp157_;
					gint _tmp158_;
					gint _tmp159_;
					gint _e_index = 0;
					_tmp156_ = smooth_points;
					_e_list = _tmp156_;
					_tmp157_ = _e_list;
					_tmp158_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp157_);
					_tmp159_ = _tmp158_;
					_e_size = _tmp159_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp160_;
						gint _tmp161_;
						BirdFontEditPoint* e = NULL;
						GeeArrayList* _tmp162_;
						gpointer _tmp163_;
						BirdFontEditPoint* _tmp164_;
						BirdFontEditPoint* _tmp165_;
						BirdFontEditPointHandle* _tmp166_;
						BirdFontEditPoint* _tmp167_;
						BirdFontEditPointHandle* _tmp168_;
						BirdFontEditPoint* _tmp169_;
						_e_index = _e_index + 1;
						_tmp160_ = _e_index;
						_tmp161_ = _e_size;
						if (!(_tmp160_ < _tmp161_)) {
							break;
						}
						_tmp162_ = _e_list;
						_tmp163_ = gee_abstract_list_get ((GeeAbstractList*) _tmp162_, _e_index);
						e = (BirdFontEditPoint*) _tmp163_;
						_tmp164_ = e;
						bird_font_edit_point_set_tie_handle (_tmp164_, TRUE);
						_tmp165_ = e;
						_tmp166_ = bird_font_edit_point_get_right_handle (_tmp165_);
						bird_font_edit_point_handle_set_point_type (_tmp166_, BIRD_FONT_POINT_TYPE_CUBIC);
						_tmp167_ = e;
						_tmp168_ = bird_font_edit_point_get_left_handle (_tmp167_);
						bird_font_edit_point_handle_set_point_type (_tmp168_, BIRD_FONT_POINT_TYPE_CUBIC);
						_tmp169_ = e;
						bird_font_edit_point_process_tied_handle (_tmp169_);
						_g_object_unref0 (e);
					}
				}
			}
		}
	}
	_tmp170_ = path;
	_tmp171_ = bird_font_path_get_points (_tmp170_);
	_tmp172_ = _tmp171_;
	_tmp173_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp172_);
	_tmp174_ = _tmp173_;
	if (_tmp174_ > 0) {
		BirdFontPathList* _tmp175_;
		BirdFontPath* _tmp176_;
		_tmp175_ = path_list;
		_tmp176_ = path;
		bird_font_path_list_add (_tmp175_, _tmp176_);
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp177_;
		GeeArrayList* _tmp178_;
		gint _p_size = 0;
		GeeArrayList* _tmp179_;
		gint _tmp180_;
		gint _tmp181_;
		gint _p_index = 0;
		_tmp177_ = path_list;
		_tmp178_ = _tmp177_->paths;
		_p_list = _tmp178_;
		_tmp179_ = _p_list;
		_tmp180_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp179_);
		_tmp181_ = _tmp180_;
		_p_size = _tmp181_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp182_;
			gint _tmp183_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp184_;
			gpointer _tmp185_;
			BirdFontPath* _tmp186_;
			_p_index = _p_index + 1;
			_tmp182_ = _p_index;
			_tmp183_ = _p_size;
			if (!(_tmp182_ < _tmp183_)) {
				break;
			}
			_tmp184_ = _p_list;
			_tmp185_ = gee_abstract_list_get ((GeeAbstractList*) _tmp184_, _p_index);
			p = (BirdFontPath*) _tmp185_;
			_tmp186_ = p;
			bird_font_path_remove_points_on_points (_tmp186_, 0.00001);
			_g_object_unref0 (p);
		}
	}
	result = path_list;
	_g_object_unref0 (smooth_points);
	_g_object_unref0 (ep);
	_g_object_unref0 (path);
	return result;
}

static gint
bird_font_svg_parser_parse_int (const gchar* s)
{
	gint result;
	if (bird_font_is_null (s)) {
		g_warning ("SvgParser.vala:2032: null instead of string");
		result = 0;
		return result;
	}
	if (!bird_font_svg_parser_is_point ((const gchar*) s)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = string_to_string ((const gchar*) s);
		_tmp1_ = g_strconcat ("Expecting an integer got: ", _tmp0_, NULL);
		_tmp2_ = _tmp1_;
		g_warning ("SvgParser.vala:2037: %s", _tmp2_);
		_g_free0 (_tmp2_);
		result = 0;
		return result;
	}
	result = atoi ((const gchar*) s);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gdouble
bird_font_svg_parser_parse_double (const gchar* s)
{
	gchar* d = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gdouble result;
	if (bird_font_is_null (s)) {
		g_warning ("SvgParser.vala:2046: Got null instead of expected string.");
		result = (gdouble) 0;
		return result;
	}
	if (!bird_font_svg_parser_is_point ((const gchar*) s)) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = string_to_string ((const gchar*) s);
		_tmp1_ = g_strconcat ("Expecting a double got: ", _tmp0_, NULL);
		_tmp2_ = _tmp1_;
		g_warning ("SvgParser.vala:2051: %s", _tmp2_);
		_g_free0 (_tmp2_);
		result = (gdouble) 0;
		return result;
	}
	_tmp3_ = g_strdup ((const gchar*) s);
	d = _tmp3_;
	_tmp4_ = d;
	_tmp5_ = string_replace (_tmp4_, "px", "");
	_g_free0 (d);
	d = _tmp5_;
	_tmp6_ = d;
	result = double_parse (_tmp6_);
	_g_free0 (d);
	return result;
}

static gboolean
double_try_parse (const gchar* str,
                  gdouble* _result_,
                  const gchar** unparsed)
{
	gdouble _vala__result_ = 0.0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gdouble _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtod (str, &_tmp0_);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = errno != ERANGE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
bird_font_svg_parser_is_point (const gchar* s)
{
	gboolean result;
	if (s == NULL) {
		g_warning ("SvgParser.vala:2063: s is null");
		result = FALSE;
		return result;
	}
	result = double_try_parse ((const gchar*) s, NULL, NULL);
	return result;
}

static BirdFontPath*
bird_font_svg_parser_parse_poly_data (BirdFontSvgParser* self,
                                      const gchar* polygon_points)
{
	gchar* data = NULL;
	gchar* _tmp0_;
	gchar** c = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint c_length1;
	gint _c_size_;
	BirdFontPath* path = NULL;
	BirdFontBezierPoints** bezier_points = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	BirdFontBezierPoints** _tmp5_;
	gint bezier_points_length1;
	gint _bezier_points_size_;
	gint bi = 0;
	BirdFontGlyph* g = NULL;
	BirdFontEditPoint* ep = NULL;
	BirdFontGlyph* _tmp23_;
	BirdFontBezierPoints** _tmp24_;
	gint _tmp24__length1;
	BirdFontGlyph* _tmp25_;
	BirdFontPath* _tmp26_;
	BirdFontPath* _tmp36_;
	BirdFontPath* _tmp37_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (polygon_points != NULL, NULL);
	_tmp0_ = bird_font_svg_parser_add_separators (polygon_points);
	data = _tmp0_;
	_tmp1_ = data;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	c = _tmp3_;
	c_length1 = _vala_array_length (_tmp2_);
	_c_size_ = c_length1;
	_tmp4_ = c;
	_tmp4__length1 = c_length1;
	_tmp5_ = g_new0 (BirdFontBezierPoints*, (_tmp4__length1 + 1) + 1);
	bezier_points = _tmp5_;
	bezier_points_length1 = _tmp4__length1 + 1;
	_bezier_points_size_ = bezier_points_length1;
	bi = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				BirdFontBezierPoints** _tmp9_;
				gint _tmp9__length1;
				BirdFontBezierPoints** _tmp10_;
				gint _tmp10__length1;
				BirdFontBezierPoints* _tmp11_;
				BirdFontBezierPoints** _tmp12_;
				gint _tmp12__length1;
				BirdFontBezierPoints* _tmp13_;
				BirdFontBezierPoints** _tmp14_;
				gint _tmp14__length1;
				BirdFontBezierPoints* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				BirdFontBezierPoints** _tmp18_;
				gint _tmp18__length1;
				BirdFontBezierPoints* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				gint _tmp22_;
				if (!_tmp6_) {
					i += 2;
				}
				_tmp6_ = FALSE;
				_tmp7_ = c;
				_tmp7__length1 = c_length1;
				if (!(i < (_tmp7__length1 - 1))) {
					break;
				}
				_tmp8_ = c;
				_tmp8__length1 = c_length1;
				if ((i + 1) >= _tmp8__length1) {
					g_warning ("SvgParser.vala:2082: No y value.");
					break;
				}
				_tmp9_ = bezier_points;
				_tmp9__length1 = bezier_points_length1;
				if (bi >= _tmp9__length1) {
					g_warning ("SvgParser.vala:2087: End of bezier_points");
					break;
				}
				_tmp10_ = bezier_points;
				_tmp10__length1 = bezier_points_length1;
				_tmp11_ = bird_font_bezier_points_new ();
				_bird_font_bezier_points_unref0 (_tmp10_[bi]);
				_tmp10_[bi] = _tmp11_;
				_tmp12_ = bezier_points;
				_tmp12__length1 = bezier_points_length1;
				_tmp13_ = _tmp12_[bi];
				_tmp13_->type = (gunichar) 'L';
				_tmp14_ = bezier_points;
				_tmp14__length1 = bezier_points_length1;
				_tmp15_ = _tmp14_[bi];
				_tmp16_ = c;
				_tmp16__length1 = c_length1;
				_tmp17_ = _tmp16_[i];
				_tmp15_->x0 = bird_font_svg_parser_parse_double (_tmp17_);
				_tmp18_ = bezier_points;
				_tmp18__length1 = bezier_points_length1;
				_tmp19_ = _tmp18_[bi];
				_tmp20_ = c;
				_tmp20__length1 = c_length1;
				_tmp21_ = _tmp20_[i + 1];
				_tmp19_->y0 = -bird_font_svg_parser_parse_double (_tmp21_);
				_tmp22_ = bi;
				bi = _tmp22_ + 1;
			}
		}
	}
	_tmp23_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp23_;
	_tmp24_ = bezier_points;
	_tmp24__length1 = bezier_points_length1;
	_tmp25_ = g;
	bird_font_svg_parser_move_and_resize (self, _tmp24_, (gint) _tmp24__length1, bi, FALSE, (gdouble) 1, _tmp25_);
	_tmp26_ = bird_font_path_new ();
	_g_object_unref0 (path);
	path = _tmp26_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp29_;
				BirdFontBezierPoints** _tmp30_;
				gint _tmp30__length1;
				BirdFontBezierPoints* _tmp31_;
				BirdFontBezierPoints** _tmp32_;
				gint _tmp32__length1;
				BirdFontBezierPoints* _tmp33_;
				BirdFontEditPoint* _tmp34_;
				BirdFontEditPoint* _tmp35_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				if (!(i < bi)) {
					break;
				}
				_tmp29_ = path;
				_tmp30_ = bezier_points;
				_tmp30__length1 = bezier_points_length1;
				_tmp31_ = _tmp30_[i];
				_tmp32_ = bezier_points;
				_tmp32__length1 = bezier_points_length1;
				_tmp33_ = _tmp32_[i];
				_tmp34_ = bird_font_path_add (_tmp29_, _tmp31_->x0, _tmp33_->y0);
				_g_object_unref0 (ep);
				ep = _tmp34_;
				_tmp35_ = ep;
				bird_font_edit_point_set_point_type (_tmp35_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
			}
		}
	}
	_tmp36_ = path;
	bird_font_path_create_list (_tmp36_);
	_tmp37_ = path;
	bird_font_path_recalculate_linear_handles (_tmp37_);
	result = path;
	_g_object_unref0 (ep);
	_g_object_unref0 (g);
	bezier_points = (_vala_array_free (bezier_points, bezier_points_length1, (GDestroyNotify) bird_font_bezier_points_unref), NULL);
	c = (_vala_array_free (c, c_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	return result;
}

static void
bird_font_value_svg_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_svg_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_svg_parser_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_svg_parser_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_svg_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_svg_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_svg_parser_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontSvgParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_svg_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_svg_parser_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	BirdFontSvgParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_svg_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_svg_parser (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	BirdFontParamSpecSvgParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_SVG_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_svg_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_PARSER), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_svg_parser (GValue* value,
                                gpointer v_object)
{
	BirdFontSvgParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_svg_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_parser_unref (old);
	}
}

void
bird_font_value_take_svg_parser (GValue* value,
                                 gpointer v_object)
{
	BirdFontSvgParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_parser_unref (old);
	}
}

static void
bird_font_svg_parser_class_init (BirdFontSvgParserClass * klass,
                                 gpointer klass_data)
{
	bird_font_svg_parser_parent_class = g_type_class_peek_parent (klass);
	((BirdFontSvgParserClass *) klass)->finalize = bird_font_svg_parser_finalize;
	g_type_class_adjust_private_offset (klass, &BirdFontSvgParser_private_offset);
}

static void
bird_font_svg_parser_instance_init (BirdFontSvgParser * self,
                                    gpointer klass)
{
	self->priv = bird_font_svg_parser_get_instance_private (self);
	self->priv->format = BIRD_FONT_SVG_FORMAT_ILLUSTRATOR;
	self->ref_count = 1;
}

static void
bird_font_svg_parser_finalize (BirdFontSvgParser * obj)
{
	BirdFontSvgParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG_PARSER, BirdFontSvgParser);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_svg_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_svg_parser_init, bird_font_value_svg_parser_free_value, bird_font_value_svg_parser_copy_value, bird_font_value_svg_parser_peek_pointer, "p", bird_font_value_svg_parser_collect_value, "p", bird_font_value_svg_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvgParser), 0, (GInstanceInitFunc) bird_font_svg_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_svg_parser_type_id;
	bird_font_svg_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontSvgParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BirdFontSvgParser_private_offset = g_type_add_instance_private (bird_font_svg_parser_type_id, sizeof (BirdFontSvgParserPrivate));
	return bird_font_svg_parser_type_id;
}

GType
bird_font_svg_parser_get_type (void)
{
	static volatile gsize bird_font_svg_parser_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_parser_type_id__once)) {
		GType bird_font_svg_parser_type_id;
		bird_font_svg_parser_type_id = bird_font_svg_parser_get_type_once ();
		g_once_init_leave (&bird_font_svg_parser_type_id__once, bird_font_svg_parser_type_id);
	}
	return bird_font_svg_parser_type_id__once;
}

gpointer
bird_font_svg_parser_ref (gpointer instance)
{
	BirdFontSvgParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_svg_parser_unref (gpointer instance)
{
	BirdFontSvgParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_SVG_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

