/* Svg.c generated by valac 0.56.16, the Vala compiler
 * generated from Svg.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BirdFontParamSpecSvg BirdFontParamSpecSvg;

struct _BirdFontParamSpecSvg {
	GParamSpec parent_instance;
};

static gpointer bird_font_svg_parent_class = NULL;

static void bird_font_svg_write_path_as_glyph (BirdFontPath* pl,
                                        GString* svg,
                                        BirdFontGlyph* g);
static void bird_font_svg_write_paths_as_glyph (BirdFontPathList* pl,
                                         GString* svg,
                                         BirdFontGlyph* g);
static void bird_font_svg_write_path (BirdFontPath* p,
                               GString* svg,
                               BirdFontGlyph* g,
                               gboolean do_glyph);
static void bird_font_svg_add_abs_start (BirdFontEditPoint* ep,
                                  GString* svg,
                                  BirdFontGlyph* g,
                                  gboolean to_glyph);
static void bird_font_svg_add_abs_next (BirdFontEditPoint* start,
                                 BirdFontEditPoint* end,
                                 GString* svg,
                                 BirdFontGlyph* g,
                                 gboolean do_glyph);
static void bird_font_svg_close_path (GString* svg);
static void bird_font_svg_add_abs_line_to (BirdFontEditPoint* start,
                                    BirdFontEditPoint* stop,
                                    GString* svg,
                                    BirdFontGlyph* g,
                                    gboolean to_glyph);
static void bird_font_svg_add_quadratic_abs_path (BirdFontEditPoint* start,
                                           BirdFontEditPoint* end,
                                           GString* svg,
                                           BirdFontGlyph* g,
                                           gboolean to_glyph);
static void bird_font_svg_add_double_quadratic_abs_path (BirdFontEditPoint* start,
                                                  BirdFontEditPoint* end,
                                                  GString* svg,
                                                  BirdFontGlyph* g,
                                                  gboolean to_glyph);
static void bird_font_svg_add_cubic_abs_path (BirdFontEditPoint* start,
                                       BirdFontEditPoint* end,
                                       GString* svg,
                                       BirdFontGlyph* g,
                                       gboolean to_glyph);
VALA_EXTERN gchar* bird_font_round (gdouble p);
static void bird_font_svg_finalize (BirdFontSvg * obj);
static GType bird_font_svg_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/** Export to svg glyph data. */
gchar*
bird_font_svg_to_svg_glyph (BirdFontGlyph* g)
{
	GString* svg = NULL;
	GString* _tmp0_;
	BirdFontPathList* stroke_list = NULL;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	g_return_val_if_fail (g != NULL, NULL);
	_tmp0_ = g_string_new ("");
	svg = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp1_ = bird_font_glyph_get_visible_paths (g);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontPath* _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontPath*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_path_get_stroke (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == ((gdouble) 0)) {
				BirdFontPath* _tmp12_;
				GString* _tmp13_;
				_tmp12_ = p;
				_tmp13_ = svg;
				bird_font_svg_write_path_as_glyph (_tmp12_, _tmp13_, g);
			} else {
				BirdFontPath* _tmp14_;
				BirdFontPathList* _tmp15_;
				BirdFontPathList* _tmp16_;
				GString* _tmp17_;
				_tmp14_ = p;
				_tmp15_ = bird_font_path_get_completed_stroke (_tmp14_);
				_g_object_unref0 (stroke_list);
				stroke_list = _tmp15_;
				_tmp16_ = stroke_list;
				_tmp17_ = svg;
				bird_font_svg_write_paths_as_glyph (_tmp16_, _tmp17_, g);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	_tmp18_ = svg;
	_tmp19_ = _tmp18_->str;
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	_g_object_unref0 (stroke_list);
	_g_string_free0 (svg);
	return result;
}

/** Export to svg-font data. */
gchar*
bird_font_svg_to_svg_path (BirdFontPath* pl,
                           BirdFontGlyph* g)
{
	GString* svg = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (pl != NULL, NULL);
	g_return_val_if_fail (g != NULL, NULL);
	_tmp0_ = g_string_new ("");
	svg = _tmp0_;
	bird_font_path_create_list (pl);
	bird_font_svg_write_path (pl, svg, g, FALSE);
	_tmp1_ = svg->str;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	_g_string_free0 (svg);
	return result;
}

static void
bird_font_svg_write_paths_as_glyph (BirdFontPathList* pl,
                                    GString* svg,
                                    BirdFontGlyph* g)
{
	g_return_if_fail (pl != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = pl->paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontPath* _tmp8_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			_tmp8_ = p;
			bird_font_svg_write_path_as_glyph (_tmp8_, svg, g);
			_g_object_unref0 (p);
		}
	}
}

static void
bird_font_svg_write_path_as_glyph (BirdFontPath* pl,
                                   GString* svg,
                                   BirdFontGlyph* g)
{
	g_return_if_fail (pl != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	bird_font_svg_write_path (pl, svg, g, TRUE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_svg_write_path (BirdFontPath* p,
                          GString* svg,
                          BirdFontGlyph* g,
                          gboolean do_glyph)
{
	gint i = 0;
	BirdFontEditPoint* n = NULL;
	BirdFontEditPoint* m = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (p != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	i = 0;
	n = NULL;
	_tmp0_ = bird_font_path_get_points (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		_g_object_unref0 (m);
		_g_object_unref0 (n);
		return;
	}
	bird_font_path_create_list (p);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _e_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = bird_font_path_get_points (p);
		_tmp5_ = _tmp4_;
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontEditPoint* _tmp17_;
			BirdFontEditPoint* _tmp18_;
			BirdFontEditPoint* _tmp19_;
			BirdFontEditPoint* _tmp20_;
			BirdFontEditPoint* _tmp21_;
			BirdFontEditPoint* _tmp22_;
			gint _tmp23_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _e_index);
			e = (BirdFontEditPoint*) _tmp12_;
			if (i == 0) {
				BirdFontEditPoint* _tmp13_;
				gint _tmp14_;
				BirdFontEditPoint* _tmp15_;
				BirdFontEditPoint* _tmp16_;
				_tmp13_ = e;
				bird_font_svg_add_abs_start (_tmp13_, svg, g, do_glyph);
				_tmp14_ = i;
				i = _tmp14_ + 1;
				_tmp15_ = e;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (n);
				n = _tmp16_;
				_g_object_unref0 (e);
				continue;
			}
			_tmp17_ = n;
			_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
			_g_object_unref0 (m);
			m = _tmp18_;
			_tmp19_ = m;
			_tmp20_ = e;
			bird_font_svg_add_abs_next (_tmp19_, _tmp20_, svg, g, do_glyph);
			_tmp21_ = e;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_g_object_unref0 (n);
			n = _tmp22_;
			_tmp23_ = i;
			i = _tmp23_ + 1;
			_g_object_unref0 (e);
		}
	}
	if (!bird_font_path_is_open (p)) {
		GeeArrayList* _tmp24_;
		GeeArrayList* _tmp25_;
		gpointer _tmp26_;
		BirdFontEditPoint* _tmp27_;
		BirdFontEditPoint* _tmp28_;
		_tmp24_ = bird_font_path_get_points (p);
		_tmp25_ = _tmp24_;
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
		_g_object_unref0 (m);
		m = (BirdFontEditPoint*) _tmp26_;
		_tmp27_ = n;
		_tmp28_ = m;
		bird_font_svg_add_abs_next (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint), _tmp28_, svg, g, do_glyph);
		bird_font_svg_close_path (svg);
	}
	_g_object_unref0 (m);
	_g_object_unref0 (n);
}

static void
bird_font_svg_add_abs_next (BirdFontEditPoint* start,
                            BirdFontEditPoint* end,
                            GString* svg,
                            BirdFontGlyph* g,
                            gboolean do_glyph)
{
	BirdFontEditPointHandle* _tmp0_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = start->right_handle;
	if (_tmp0_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		bird_font_svg_add_abs_line_to (start, end, svg, g, do_glyph);
	} else {
		gboolean _tmp1_ = FALSE;
		BirdFontEditPointHandle* _tmp2_;
		_tmp2_ = start->right_handle;
		if (_tmp2_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
			BirdFontEditPointHandle* _tmp3_;
			_tmp3_ = end->left_handle;
			_tmp1_ = _tmp3_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			bird_font_svg_add_abs_line_to (start, end, svg, g, do_glyph);
		} else {
			gboolean _tmp4_ = FALSE;
			BirdFontEditPointHandle* _tmp5_;
			_tmp5_ = end->left_handle;
			if (_tmp5_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
				_tmp4_ = TRUE;
			} else {
				BirdFontEditPointHandle* _tmp6_;
				_tmp6_ = start->right_handle;
				_tmp4_ = _tmp6_->type == BIRD_FONT_POINT_TYPE_QUADRATIC;
			}
			if (_tmp4_) {
				bird_font_svg_add_quadratic_abs_path (start, end, svg, g, do_glyph);
			} else {
				gboolean _tmp7_ = FALSE;
				BirdFontEditPointHandle* _tmp8_;
				_tmp8_ = end->left_handle;
				if (_tmp8_->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
					_tmp7_ = TRUE;
				} else {
					BirdFontEditPointHandle* _tmp9_;
					_tmp9_ = start->right_handle;
					_tmp7_ = _tmp9_->type == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
				}
				if (_tmp7_) {
					bird_font_svg_add_double_quadratic_abs_path (start, end, svg, g, do_glyph);
				} else {
					bird_font_svg_add_cubic_abs_path (start, end, svg, g, do_glyph);
				}
			}
		}
	}
}

static void
bird_font_svg_add_abs_start (BirdFontEditPoint* ep,
                             GString* svg,
                             BirdFontGlyph* g,
                             gboolean to_glyph)
{
	gdouble left = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble baseline = 0.0;
	BirdFontFont* _tmp2_;
	BirdFontFont* _tmp3_;
	gdouble _tmp4_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp5_;
	gdouble height = 0.0;
	BirdFontFont* _tmp6_;
	BirdFontFont* _tmp7_;
	g_return_if_fail (ep != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (g);
	_tmp1_ = _tmp0_;
	left = _tmp1_;
	_tmp2_ = bird_font_bird_font_get_current_font ();
	_tmp3_ = _tmp2_;
	_tmp4_ = -_tmp3_->base_line;
	_g_object_unref0 (_tmp3_);
	baseline = _tmp4_;
	_tmp5_ = bird_font_bird_font_get_current_font ();
	font = _tmp5_;
	_tmp6_ = font;
	_tmp7_ = font;
	height = _tmp6_->top_limit - _tmp7_->base_line;
	g_string_append_printf (svg, "M");
	if (!to_glyph) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = bird_font_round (ep->x - left);
		_tmp9_ = _tmp8_;
		g_string_append_printf (svg, "%s ", _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = bird_font_round ((-ep->y) + height);
		_tmp11_ = _tmp10_;
		g_string_append_printf (svg, "%s ", _tmp11_);
		_g_free0 (_tmp11_);
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = bird_font_round (ep->x - left);
		_tmp13_ = _tmp12_;
		g_string_append_printf (svg, "%s ", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = bird_font_round (ep->y + baseline);
		_tmp15_ = _tmp14_;
		g_string_append_printf (svg, "%s ", _tmp15_);
		_g_free0 (_tmp15_);
	}
	_g_object_unref0 (font);
}

static void
bird_font_svg_close_path (GString* svg)
{
	g_return_if_fail (svg != NULL);
	g_string_append (svg, "z");
}

static void
bird_font_svg_add_abs_line_to (BirdFontEditPoint* start,
                               BirdFontEditPoint* stop,
                               GString* svg,
                               BirdFontGlyph* g,
                               gboolean to_glyph)
{
	gdouble baseline = 0.0;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	gdouble _tmp2_;
	gdouble left = 0.0;
	gdouble _tmp3_;
	gdouble _tmp4_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp5_;
	gdouble height = 0.0;
	BirdFontFont* _tmp6_;
	BirdFontFont* _tmp7_;
	gdouble xa = 0.0;
	gdouble ya = 0.0;
	gdouble xb = 0.0;
	gdouble yb = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	g_return_if_fail (start != NULL);
	g_return_if_fail (stop != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = -_tmp1_->base_line;
	_g_object_unref0 (_tmp1_);
	baseline = _tmp2_;
	_tmp3_ = bird_font_glyph_get_left_limit (g);
	_tmp4_ = _tmp3_;
	left = _tmp4_;
	_tmp5_ = bird_font_bird_font_get_current_font ();
	font = _tmp5_;
	_tmp6_ = font;
	_tmp7_ = font;
	height = _tmp6_->top_limit - _tmp7_->base_line;
	bird_font_path_get_line_points (start, stop, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	xa = _tmp8_;
	ya = _tmp9_;
	xb = _tmp10_;
	yb = _tmp11_;
	center_x = bird_font_glyph_xc ();
	center_y = bird_font_glyph_yc ();
	g_string_append (svg, "L");
	if (!to_glyph) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = bird_font_round ((xb - center_x) - left);
		_tmp13_ = _tmp12_;
		g_string_append_printf (svg, "%s ", _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = bird_font_round ((yb - center_y) + height);
		_tmp15_ = _tmp14_;
		g_string_append_printf (svg, "%s ", _tmp15_);
		_g_free0 (_tmp15_);
	} else {
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = bird_font_round ((xb - center_x) - left);
		_tmp17_ = _tmp16_;
		g_string_append_printf (svg, "%s ", _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = bird_font_round (((-yb) + center_y) + baseline);
		_tmp19_ = _tmp18_;
		g_string_append_printf (svg, "%s ", _tmp19_);
		_g_free0 (_tmp19_);
	}
	_g_object_unref0 (font);
}

static void
bird_font_svg_add_double_quadratic_abs_path (BirdFontEditPoint* start,
                                             BirdFontEditPoint* end,
                                             GString* svg,
                                             BirdFontGlyph* g,
                                             gboolean to_glyph)
{
	BirdFontEditPoint* middle = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPointHandle* _tmp19_;
	BirdFontEditPointHandle* _tmp20_;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	_tmp1_ = bird_font_edit_point_handle_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_edit_point_get_left_handle (end);
	_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_edit_point_get_right_handle (start);
	_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
	_tmp8_ = _tmp7_;
	x = _tmp2_ + ((_tmp5_ - _tmp8_) / 2);
	_tmp9_ = bird_font_edit_point_get_right_handle (start);
	_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_edit_point_get_left_handle (end);
	_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_edit_point_get_right_handle (start);
	_tmp16_ = bird_font_edit_point_handle_get_y (_tmp15_);
	_tmp17_ = _tmp16_;
	y = _tmp11_ + ((_tmp14_ - _tmp17_) / 2);
	_tmp18_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_QUADRATIC);
	_g_object_unref0 (middle);
	middle = _tmp18_;
	_tmp19_ = bird_font_edit_point_get_left_handle (end);
	_tmp20_ = bird_font_edit_point_handle_copy (_tmp19_);
	_g_object_unref0 (middle->right_handle);
	middle->right_handle = _tmp20_;
	bird_font_svg_add_quadratic_abs_path (start, middle, svg, g, to_glyph);
	bird_font_svg_add_quadratic_abs_path (middle, end, svg, g, to_glyph);
	_g_object_unref0 (middle);
}

static void
bird_font_svg_add_quadratic_abs_path (BirdFontEditPoint* start,
                                      BirdFontEditPoint* end,
                                      GString* svg,
                                      BirdFontGlyph* g,
                                      gboolean to_glyph)
{
	gdouble left = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble baseline = 0.0;
	BirdFontFont* _tmp2_;
	BirdFontFont* _tmp3_;
	gdouble _tmp4_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp5_;
	gdouble height = 0.0;
	BirdFontFont* _tmp6_;
	BirdFontFont* _tmp7_;
	gdouble xa = 0.0;
	gdouble ya = 0.0;
	gdouble xb = 0.0;
	gdouble yb = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xd = 0.0;
	gdouble yd = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (g);
	_tmp1_ = _tmp0_;
	left = _tmp1_;
	_tmp2_ = bird_font_bird_font_get_current_font ();
	_tmp3_ = _tmp2_;
	_tmp4_ = -_tmp3_->base_line;
	_g_object_unref0 (_tmp3_);
	baseline = _tmp4_;
	_tmp5_ = bird_font_bird_font_get_current_font ();
	font = _tmp5_;
	_tmp6_ = font;
	_tmp7_ = font;
	height = _tmp6_->top_limit - _tmp7_->base_line;
	bird_font_path_get_bezier_points (start, end, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	xa = _tmp8_;
	ya = _tmp9_;
	xb = _tmp10_;
	yb = _tmp11_;
	xc = _tmp12_;
	yc = _tmp13_;
	xd = _tmp14_;
	yd = _tmp15_;
	center_x = bird_font_glyph_xc ();
	center_y = bird_font_glyph_yc ();
	if (!to_glyph) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		g_string_append_printf (svg, "Q");
		_tmp16_ = bird_font_round ((xb - center_x) - left);
		_tmp17_ = _tmp16_;
		g_string_append_printf (svg, "%s ", _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = bird_font_round ((yb - center_y) + height);
		_tmp19_ = _tmp18_;
		g_string_append_printf (svg, "%s ", _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = bird_font_round ((xd - center_x) - left);
		_tmp21_ = _tmp20_;
		g_string_append_printf (svg, "%s ", _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = bird_font_round ((yd - center_y) + height);
		_tmp23_ = _tmp22_;
		g_string_append_printf (svg, "%s ", _tmp23_);
		_g_free0 (_tmp23_);
	} else {
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		g_string_append_printf (svg, "Q");
		_tmp24_ = bird_font_round ((xb - center_x) - left);
		_tmp25_ = _tmp24_;
		g_string_append_printf (svg, "%s ", _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = bird_font_round (((-yb) + center_y) + baseline);
		_tmp27_ = _tmp26_;
		g_string_append_printf (svg, "%s ", _tmp27_);
		_g_free0 (_tmp27_);
		_tmp28_ = bird_font_round ((xd - center_x) - left);
		_tmp29_ = _tmp28_;
		g_string_append_printf (svg, "%s ", _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = bird_font_round (((-yd) + center_y) + baseline);
		_tmp31_ = _tmp30_;
		g_string_append_printf (svg, "%s ", _tmp31_);
		_g_free0 (_tmp31_);
	}
	_g_object_unref0 (font);
}

static void
bird_font_svg_add_cubic_abs_path (BirdFontEditPoint* start,
                                  BirdFontEditPoint* end,
                                  GString* svg,
                                  BirdFontGlyph* g,
                                  gboolean to_glyph)
{
	gdouble left = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble baseline = 0.0;
	BirdFontFont* _tmp2_;
	BirdFontFont* _tmp3_;
	gdouble _tmp4_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp5_;
	gdouble height = 0.0;
	BirdFontFont* _tmp6_;
	BirdFontFont* _tmp7_;
	gdouble xa = 0.0;
	gdouble ya = 0.0;
	gdouble xb = 0.0;
	gdouble yb = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xd = 0.0;
	gdouble yd = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	g_return_if_fail (svg != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = bird_font_glyph_get_left_limit (g);
	_tmp1_ = _tmp0_;
	left = _tmp1_;
	_tmp2_ = bird_font_bird_font_get_current_font ();
	_tmp3_ = _tmp2_;
	_tmp4_ = -_tmp3_->base_line;
	_g_object_unref0 (_tmp3_);
	baseline = _tmp4_;
	_tmp5_ = bird_font_bird_font_get_current_font ();
	font = _tmp5_;
	_tmp6_ = font;
	_tmp7_ = font;
	height = _tmp6_->top_limit - _tmp7_->base_line;
	bird_font_path_get_bezier_points (start, end, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
	xa = _tmp8_;
	ya = _tmp9_;
	xb = _tmp10_;
	yb = _tmp11_;
	xc = _tmp12_;
	yc = _tmp13_;
	xd = _tmp14_;
	yd = _tmp15_;
	center_x = bird_font_glyph_xc ();
	center_y = bird_font_glyph_yc ();
	if (!to_glyph) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		g_string_append_printf (svg, "C");
		_tmp16_ = bird_font_round ((xb - center_x) - left);
		_tmp17_ = _tmp16_;
		g_string_append_printf (svg, "%s ", _tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = bird_font_round ((yb - center_y) + height);
		_tmp19_ = _tmp18_;
		g_string_append_printf (svg, "%s ", _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = bird_font_round ((xc - center_x) - left);
		_tmp21_ = _tmp20_;
		g_string_append_printf (svg, "%s ", _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = bird_font_round ((yc - center_y) + height);
		_tmp23_ = _tmp22_;
		g_string_append_printf (svg, "%s ", _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = bird_font_round ((xd - center_x) - left);
		_tmp25_ = _tmp24_;
		g_string_append_printf (svg, "%s ", _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = bird_font_round ((yd - center_y) + height);
		_tmp27_ = _tmp26_;
		g_string_append_printf (svg, "%s ", _tmp27_);
		_g_free0 (_tmp27_);
	} else {
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		g_string_append_printf (svg, "C");
		_tmp28_ = bird_font_round ((xb - center_x) - left);
		_tmp29_ = _tmp28_;
		g_string_append_printf (svg, "%s ", _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = bird_font_round (((-yb) + center_y) + baseline);
		_tmp31_ = _tmp30_;
		g_string_append_printf (svg, "%s ", _tmp31_);
		_g_free0 (_tmp31_);
		_tmp32_ = bird_font_round ((xc - center_x) - left);
		_tmp33_ = _tmp32_;
		g_string_append_printf (svg, "%s ", _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = bird_font_round (((-yc) + center_y) + baseline);
		_tmp35_ = _tmp34_;
		g_string_append_printf (svg, "%s ", _tmp35_);
		_g_free0 (_tmp35_);
		_tmp36_ = bird_font_round ((xd - center_x) - left);
		_tmp37_ = _tmp36_;
		g_string_append_printf (svg, "%s ", _tmp37_);
		_g_free0 (_tmp37_);
		_tmp38_ = bird_font_round (((-yd) + center_y) + baseline);
		_tmp39_ = _tmp38_;
		g_string_append_printf (svg, "%s ", _tmp39_);
		_g_free0 (_tmp39_);
	}
	_g_object_unref0 (font);
}

/** Draw path from svg font data. */
static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

void
bird_font_svg_draw_svg_path (cairo_t* cr,
                             const gchar* svg,
                             gdouble x,
                             gdouble y)
{
	gdouble x1 = 0.0;
	gdouble x2 = 0.0;
	gdouble x3 = 0.0;
	gdouble y1 = 0.0;
	gdouble y2 = 0.0;
	gdouble y3 = 0.0;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gchar** d = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint d_length1;
	gint _d_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (svg != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (svg, " ", 0);
	d = _tmp1_;
	d_length1 = _vala_array_length (_tmp0_);
	_d_size_ = d_length1;
	_tmp2_ = d;
	_tmp2__length1 = d_length1;
	if (_tmp2__length1 == 0) {
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	px = (gdouble) 0;
	py = (gdouble) 0;
	cairo_save (cr);
	cairo_set_line_width (cr, (gdouble) 0);
	if (g_strcmp0 (svg, "") == 0) {
		d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				gchar** _tmp12_;
				gint _tmp12__length1;
				const gchar* _tmp13_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				const gchar* _tmp33_;
				gchar** _tmp48_;
				gint _tmp48__length1;
				const gchar* _tmp49_;
				gchar** _tmp56_;
				gint _tmp56__length1;
				const gchar* _tmp57_;
				gchar** _tmp64_;
				gint _tmp64__length1;
				const gchar* _tmp65_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = d;
				_tmp5__length1 = d_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				while (TRUE) {
					gchar** _tmp6_;
					gint _tmp6__length1;
					const gchar* _tmp7_;
					gchar** _tmp8_;
					gint _tmp8__length1;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp6_ = d;
					_tmp6__length1 = d_length1;
					_tmp7_ = _tmp6_[i];
					if (!(string_index_of (_tmp7_, " ", 0) == 0)) {
						break;
					}
					_tmp8_ = d;
					_tmp8__length1 = d_length1;
					_tmp9_ = d;
					_tmp9__length1 = d_length1;
					_tmp10_ = _tmp9_[i];
					_tmp11_ = string_substring (_tmp10_, (glong) 1, (glong) -1);
					_g_free0 (_tmp8_[i]);
					_tmp8_[i] = _tmp11_;
				}
				_tmp12_ = d;
				_tmp12__length1 = d_length1;
				_tmp13_ = _tmp12_[i];
				if (string_index_of (_tmp13_, "L", 0) == 0) {
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					_tmp14_ = d;
					_tmp14__length1 = d_length1;
					_tmp15_ = _tmp14_[i];
					_tmp16_ = string_substring (_tmp15_, (glong) 1, (glong) -1);
					_tmp17_ = _tmp16_;
					x1 = double_parse (_tmp17_) + x;
					_g_free0 (_tmp17_);
					_tmp18_ = d;
					_tmp18__length1 = d_length1;
					_tmp19_ = _tmp18_[i + 1];
					y1 = (-double_parse (_tmp19_)) + y;
					cairo_line_to (cr, x1, y1);
					px = x1;
					py = y1;
					continue;
				}
				_tmp20_ = d;
				_tmp20__length1 = d_length1;
				_tmp21_ = _tmp20_[i];
				if (string_index_of (_tmp21_, "Q", 0) == 0) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar** _tmp26_;
					gint _tmp26__length1;
					const gchar* _tmp27_;
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					_tmp22_ = d;
					_tmp22__length1 = d_length1;
					_tmp23_ = _tmp22_[i];
					_tmp24_ = string_substring (_tmp23_, (glong) 1, (glong) -1);
					_tmp25_ = _tmp24_;
					x1 = double_parse (_tmp25_) + x;
					_g_free0 (_tmp25_);
					_tmp26_ = d;
					_tmp26__length1 = d_length1;
					_tmp27_ = _tmp26_[i + 1];
					y1 = (-double_parse (_tmp27_)) + y;
					_tmp28_ = d;
					_tmp28__length1 = d_length1;
					_tmp29_ = _tmp28_[i + 2];
					x2 = double_parse (_tmp29_) + x;
					_tmp30_ = d;
					_tmp30__length1 = d_length1;
					_tmp31_ = _tmp30_[i + 3];
					y2 = (-double_parse (_tmp31_)) + y;
					cairo_curve_to (cr, (px + (2 * x1)) / 3, (py + (2 * y1)) / 3, (x2 + (2 * x1)) / 3, (y2 + (2 * y1)) / 3, x2, y2);
					px = x2;
					py = y2;
					continue;
				}
				_tmp32_ = d;
				_tmp32__length1 = d_length1;
				_tmp33_ = _tmp32_[i];
				if (string_index_of (_tmp33_, "C", 0) == 0) {
					gchar** _tmp34_;
					gint _tmp34__length1;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar** _tmp38_;
					gint _tmp38__length1;
					const gchar* _tmp39_;
					gchar** _tmp40_;
					gint _tmp40__length1;
					const gchar* _tmp41_;
					gchar** _tmp42_;
					gint _tmp42__length1;
					const gchar* _tmp43_;
					gchar** _tmp44_;
					gint _tmp44__length1;
					const gchar* _tmp45_;
					gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					_tmp34_ = d;
					_tmp34__length1 = d_length1;
					_tmp35_ = _tmp34_[i];
					_tmp36_ = string_substring (_tmp35_, (glong) 1, (glong) -1);
					_tmp37_ = _tmp36_;
					x1 = double_parse (_tmp37_) + x;
					_g_free0 (_tmp37_);
					_tmp38_ = d;
					_tmp38__length1 = d_length1;
					_tmp39_ = _tmp38_[i + 1];
					y1 = (-double_parse (_tmp39_)) + y;
					_tmp40_ = d;
					_tmp40__length1 = d_length1;
					_tmp41_ = _tmp40_[i + 2];
					x2 = double_parse (_tmp41_) + x;
					_tmp42_ = d;
					_tmp42__length1 = d_length1;
					_tmp43_ = _tmp42_[i + 3];
					y2 = (-double_parse (_tmp43_)) + y;
					_tmp44_ = d;
					_tmp44__length1 = d_length1;
					_tmp45_ = _tmp44_[i + 4];
					x3 = double_parse (_tmp45_) + x;
					_tmp46_ = d;
					_tmp46__length1 = d_length1;
					_tmp47_ = _tmp46_[i + 5];
					y3 = (-double_parse (_tmp47_)) + y;
					cairo_curve_to (cr, x1, y1, x2, y2, x3, y3);
					px = x3;
					py = y3;
					continue;
				}
				_tmp48_ = d;
				_tmp48__length1 = d_length1;
				_tmp49_ = _tmp48_[i];
				if (string_index_of (_tmp49_, "M", 0) == 0) {
					gchar** _tmp50_;
					gint _tmp50__length1;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar** _tmp54_;
					gint _tmp54__length1;
					const gchar* _tmp55_;
					_tmp50_ = d;
					_tmp50__length1 = d_length1;
					_tmp51_ = _tmp50_[i];
					_tmp52_ = string_substring (_tmp51_, (glong) 1, (glong) -1);
					_tmp53_ = _tmp52_;
					x1 = double_parse (_tmp53_) + x;
					_g_free0 (_tmp53_);
					_tmp54_ = d;
					_tmp54__length1 = d_length1;
					_tmp55_ = _tmp54_[i + 1];
					y1 = (-double_parse (_tmp55_)) + y;
					cairo_move_to (cr, x1, y1);
					px = x1;
					py = y1;
					continue;
				}
				_tmp56_ = d;
				_tmp56__length1 = d_length1;
				_tmp57_ = _tmp56_[i];
				if (string_index_of (_tmp57_, "zM", 0) == 0) {
					gchar** _tmp58_;
					gint _tmp58__length1;
					const gchar* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					gchar** _tmp62_;
					gint _tmp62__length1;
					const gchar* _tmp63_;
					cairo_close_path (cr);
					_tmp58_ = d;
					_tmp58__length1 = d_length1;
					_tmp59_ = _tmp58_[i];
					_tmp60_ = string_substring (_tmp59_, (glong) 2, (glong) -1);
					_tmp61_ = _tmp60_;
					x1 = double_parse (_tmp61_) + x;
					_g_free0 (_tmp61_);
					_tmp62_ = d;
					_tmp62__length1 = d_length1;
					_tmp63_ = _tmp62_[i + 1];
					y1 = (-double_parse (_tmp63_)) + y;
					cairo_move_to (cr, x1, y1);
					px = x1;
					py = y1;
					continue;
				}
				_tmp64_ = d;
				_tmp64__length1 = d_length1;
				_tmp65_ = _tmp64_[i];
				if (string_index_of (_tmp65_, "z", 0) == 0) {
					cairo_close_path (cr);
					continue;
				}
			}
		}
	}
	cairo_fill (cr);
	cairo_restore (cr);
	d = (_vala_array_free (d, d_length1, (GDestroyNotify) g_free), NULL);
}

BirdFontSvg*
bird_font_svg_construct (GType object_type)
{
	BirdFontSvg* self = NULL;
	self = (BirdFontSvg*) g_type_create_instance (object_type);
	return self;
}

BirdFontSvg*
bird_font_svg_new (void)
{
	return bird_font_svg_construct (BIRD_FONT_TYPE_SVG);
}

static void
bird_font_value_svg_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_svg_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_svg_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_svg_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_svg_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_svg_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_svg_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontSvg * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_svg_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_svg_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	BirdFontSvg ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_svg_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_svg (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	BirdFontParamSpecSvg* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_SVG), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_svg (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_svg (GValue* value,
                         gpointer v_object)
{
	BirdFontSvg * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_svg_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_unref (old);
	}
}

void
bird_font_value_take_svg (GValue* value,
                          gpointer v_object)
{
	BirdFontSvg * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_SVG));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_SVG));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_svg_unref (old);
	}
}

static void
bird_font_svg_class_init (BirdFontSvgClass * klass,
                          gpointer klass_data)
{
	bird_font_svg_parent_class = g_type_class_peek_parent (klass);
	((BirdFontSvgClass *) klass)->finalize = bird_font_svg_finalize;
}

static void
bird_font_svg_instance_init (BirdFontSvg * self,
                             gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_svg_finalize (BirdFontSvg * obj)
{
	BirdFontSvg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SVG, BirdFontSvg);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_svg_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_svg_init, bird_font_value_svg_free_value, bird_font_value_svg_copy_value, bird_font_value_svg_peek_pointer, "p", bird_font_value_svg_collect_value, "p", bird_font_value_svg_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSvgClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_svg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSvg), 0, (GInstanceInitFunc) bird_font_svg_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_svg_type_id;
	bird_font_svg_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontSvg", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_svg_type_id;
}

GType
bird_font_svg_get_type (void)
{
	static volatile gsize bird_font_svg_type_id__once = 0;
	if (g_once_init_enter (&bird_font_svg_type_id__once)) {
		GType bird_font_svg_type_id;
		bird_font_svg_type_id = bird_font_svg_get_type_once ();
		g_once_init_leave (&bird_font_svg_type_id__once, bird_font_svg_type_id);
	}
	return bird_font_svg_type_id__once;
}

gpointer
bird_font_svg_ref (gpointer instance)
{
	BirdFontSvg * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_svg_unref (gpointer instance)
{
	BirdFontSvg * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_SVG_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

gchar*
bird_font_round (gdouble p)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	gchar* c = NULL;
	gchar* _tmp1_;
	gint c_length1;
	gint _c_size_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result;
	_tmp0_ = double_to_string (p);
	v = _tmp0_;
	_tmp1_ = g_new0 (gchar, 501);
	c = _tmp1_;
	c_length1 = 501;
	_c_size_ = c_length1;
	_tmp2_ = c;
	_tmp2__length1 = c_length1;
	_tmp3_ = g_ascii_formatd (_tmp2_, (gint) _tmp2__length1, "%3.15f", p);
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (v);
	v = _tmp4_;
	_tmp5_ = v;
	if (string_index_of (_tmp5_, "e", 0) != -1) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("0.0");
		result = _tmp6_;
		c = (g_free (c), NULL);
		_g_free0 (v);
		return result;
	}
	result = v;
	c = (g_free (c), NULL);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

