/* SpinButton.c generated by valac 0.56.16, the Vala compiler
 * generated from SpinButton.vala, do not modify */

/*
Copyright (C) 2012, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SPIN_BUTTON_0_PROPERTY,
	BIRD_FONT_SPIN_BUTTON_NUM_PROPERTIES
};
static GParamSpec* bird_font_spin_button_properties[BIRD_FONT_SPIN_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL,
	BIRD_FONT_SPIN_BUTTON_NUM_SIGNALS
};
static guint bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NUM_SIGNALS] = {0};

struct _BirdFontSpinButtonPrivate {
	gboolean negative;
	gboolean value_from_motion;
	gdouble begin_y;
	gint begin_value;
	gint max;
	gint min;
	gint step;
	gboolean big_number;
	gboolean integers;
	gdouble last_active_time;
	gboolean waiting_for_icon_switch;
	gboolean show_icon_tool_icon;
};

static gint BirdFontSpinButton_private_offset;
static gpointer bird_font_spin_button_parent_class = NULL;

static void __lambda355_ (BirdFontSpinButton* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static gint bird_font_spin_button_get_int_value (BirdFontSpinButton* self);
static void ___lambda355__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                      BirdFontTool* selected,
                                                      guint button,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static gboolean __lambda358_ (BirdFontSpinButton* self,
                       BirdFontTool* selected,
                       BirdFontTool* button,
                       gdouble tx,
                       gdouble ty);
static void bird_font_spin_button_show_adjustmet_icon (BirdFontSpinButton* self);
static gboolean ___lambda358__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                         BirdFontTool* selected,
                                                         gdouble x,
                                                         gdouble y,
                                                         gpointer self);
static void __lambda359_ (BirdFontSpinButton* self,
                   BirdFontTool* selected,
                   guint button,
                   gdouble tx,
                   gdouble ty);
static void ___lambda359__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        guint button,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static gboolean __lambda360_ (BirdFontSpinButton* self,
                       BirdFontTool* selected);
static gboolean ___lambda360__bird_font_tool_scroll_wheel_up_action (BirdFontTool* _sender,
                                                              BirdFontTool* selected,
                                                              gpointer self);
static gboolean __lambda361_ (BirdFontSpinButton* self,
                       BirdFontTool* selected);
static gboolean ___lambda361__bird_font_tool_scroll_wheel_down_action (BirdFontTool* _sender,
                                                                BirdFontTool* selected,
                                                                gpointer self);
static gboolean ___lambda104_ (BirdFontSpinButton* self);
static gboolean ____lambda104__gsource_func (gpointer self);
static void __lambda356_ (BirdFontSpinButton* self,
                   const gchar* text);
static void ___lambda356__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda357_ (BirdFontSpinButton* self);
static void ___lambda357__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static gint8 bird_font_spin_button_parse (BirdFontSpinButton* self,
                                   const gchar* s);
static void bird_font_spin_button_real_draw_tool (BirdFontTool* base,
                                           cairo_t* cr,
                                           gdouble px,
                                           gdouble py);
static void bird_font_spin_button_finalize (GObject * obj);
static GType bird_font_spin_button_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_spin_button_get_instance_private (BirdFontSpinButton* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSpinButton_private_offset);
}

static void
__lambda355_ (BirdFontSpinButton* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	gdouble py = 0.0;
	gint n = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (selected != NULL);
	py = fabs (((BirdFontTool*) self)->y - ty);
	n = 0;
	if (button == ((guint) 3)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_key_bindings_modifier != BIRD_FONT_NONE;
	}
	if (_tmp0_) {
		bird_font_spin_button_set_from_text (self);
		n = 0;
		bird_font_tool_set_selected ((BirdFontTool*) self, FALSE);
		return;
	}
	if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
		if (button == ((guint) 1)) {
			n = 1;
		} else {
			if (button == ((guint) 2)) {
				n = 10;
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_ = FALSE;
					gboolean _tmp4_ = FALSE;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < n)) {
						break;
					}
					if (py < ((gdouble) 9)) {
						_tmp3_ = !self->locked;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						bird_font_spin_button_increase (self);
					}
					if (py > ((gdouble) 25)) {
						_tmp4_ = !self->locked;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						bird_font_spin_button_decrease (self);
					}
				}
			}
		}
	}
	self->priv->value_from_motion = !self->locked;
	self->priv->begin_y = ty;
	self->priv->begin_value = bird_font_spin_button_get_int_value (self);
	if (button == ((guint) 1)) {
		bird_font_tool_set_selected ((BirdFontTool*) self, TRUE);
	}
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda355__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 guint button,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
	__lambda355_ ((BirdFontSpinButton*) self, selected, button, x, y);
}

static gboolean
__lambda358_ (BirdFontSpinButton* self,
              BirdFontTool* selected,
              BirdFontTool* button,
              gdouble tx,
              gdouble ty)
{
	gdouble d = 0.0;
	gint new_value = 0;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	if (bird_font_tool_is_active ((BirdFontTool*) self)) {
		bird_font_spin_button_show_adjustmet_icon (self);
	}
	if (self->priv->value_from_motion) {
		_tmp0_ = bird_font_tool_is_selected ((BirdFontTool*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdouble _tmp1_ = 0.0;
		d = (self->priv->begin_y - ty) / 200;
		if (d < ((gdouble) 0)) {
			_tmp1_ = -pow (d, (gdouble) 2);
		} else {
			_tmp1_ = pow (d, (gdouble) 2);
		}
		d = _tmp1_;
		d *= (gdouble) 1000;
		new_value = (gint) (self->priv->begin_value + d);
		if (new_value < self->priv->min) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup_printf ("%i", self->priv->min);
			_tmp3_ = _tmp2_;
			bird_font_spin_button_set_int_value (self, _tmp3_);
			_g_free0 (_tmp3_);
		} else {
			if (new_value > self->priv->max) {
				gchar* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = g_strdup_printf ("%i", self->priv->max);
				_tmp5_ = _tmp4_;
				bird_font_spin_button_set_int_value (self, _tmp5_);
				_g_free0 (_tmp5_);
			} else {
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp6_ = g_strdup_printf ("%i", new_value);
				_tmp7_ = _tmp6_;
				bird_font_spin_button_set_int_value (self, _tmp7_);
				_g_free0 (_tmp7_);
			}
		}
		bird_font_tool_redraw ((BirdFontTool*) self);
	}
	result = self->priv->value_from_motion;
	return result;
}

static gboolean
___lambda358__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	gboolean result;
	result = __lambda358_ ((BirdFontSpinButton*) self, _sender, selected, x, y);
	return result;
}

static void
__lambda359_ (BirdFontSpinButton* self,
              BirdFontTool* selected,
              guint button,
              gdouble tx,
              gdouble ty)
{
	g_return_if_fail (selected != NULL);
	self->priv->value_from_motion = FALSE;
	if (button == ((guint) 1)) {
		bird_font_tool_set_selected ((BirdFontTool*) self, FALSE);
	}
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda359__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   guint button,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self)
{
	__lambda359_ ((BirdFontSpinButton*) self, selected, button, x, y);
}

static gboolean
__lambda360_ (BirdFontSpinButton* self,
              BirdFontTool* selected)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	bird_font_spin_button_increase (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda360__bird_font_tool_scroll_wheel_up_action (BirdFontTool* _sender,
                                                     BirdFontTool* selected,
                                                     gpointer self)
{
	gboolean result;
	result = __lambda360_ ((BirdFontSpinButton*) self, selected);
	return result;
}

static gboolean
__lambda361_ (BirdFontSpinButton* self,
              BirdFontTool* selected)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	bird_font_spin_button_decrease (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda361__bird_font_tool_scroll_wheel_down_action (BirdFontTool* _sender,
                                                       BirdFontTool* selected,
                                                       gpointer self)
{
	gboolean result;
	result = __lambda361_ ((BirdFontSpinButton*) self, selected);
	return result;
}

BirdFontSpinButton*
bird_font_spin_button_construct (GType object_type,
                                 const gchar* name,
                                 const gchar* tip)
{
	BirdFontSpinButton * self = NULL;
	g_return_val_if_fail (tip != NULL, NULL);
	self = (BirdFontSpinButton*) bird_font_tool_construct (object_type, NULL, tip);
	if (name != NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ((const gchar*) name);
		_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name);
		G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name = _tmp0_;
	}
	bird_font_tool_set_icon ((BirdFontTool*) self, "spin_button");
	g_signal_connect_object ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda355__bird_font_tool_panel_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-move-action", (GCallback) ___lambda358__bird_font_tool_panel_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-release-action", (GCallback) ___lambda359__bird_font_tool_panel_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "scroll-wheel-up-action", (GCallback) ___lambda360__bird_font_tool_scroll_wheel_up_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "scroll-wheel-down-action", (GCallback) ___lambda361__bird_font_tool_scroll_wheel_down_action, self, 0);
	return self;
}

BirdFontSpinButton*
bird_font_spin_button_new (const gchar* name,
                           const gchar* tip)
{
	return bird_font_spin_button_construct (BIRD_FONT_TYPE_SPIN_BUTTON, name, tip);
}

void
bird_font_spin_button_show_icon (BirdFontSpinButton* self,
                                 gboolean i)
{
	g_return_if_fail (self != NULL);
	self->priv->show_icon_tool_icon = i;
	if (!self->priv->show_icon_tool_icon) {
		bird_font_tool_set_icon ((BirdFontTool*) self, "spin_button");
	} else {
		const gchar* _tmp0_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name;
		bird_font_tool_set_icon ((BirdFontTool*) self, (const gchar*) _tmp0_);
	}
}

void
bird_font_spin_button_hide_value (BirdFontSpinButton* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name;
	bird_font_tool_set_icon ((BirdFontTool*) self, _tmp0_);
	self->priv->waiting_for_icon_switch = FALSE;
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static gboolean
___lambda104_ (BirdFontSpinButton* self)
{
	gboolean result;
	if ((g_get_real_time () - self->priv->last_active_time) > ((gdouble) 4000000)) {
		const gchar* _tmp0_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->name;
		bird_font_tool_set_icon ((BirdFontTool*) self, _tmp0_);
		bird_font_tool_redraw ((BirdFontTool*) self);
		self->priv->waiting_for_icon_switch = FALSE;
	}
	result = self->priv->waiting_for_icon_switch;
	return result;
}

static gboolean
____lambda104__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda104_ ((BirdFontSpinButton*) self);
	return result;
}

static void
bird_font_spin_button_show_adjustmet_icon (BirdFontSpinButton* self)
{
	GSource* timer = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	bird_font_tool_set_icon ((BirdFontTool*) self, "spin_button");
	bird_font_tool_redraw ((BirdFontTool*) self);
	self->priv->last_active_time = (gdouble) g_get_real_time ();
	if (self->priv->show_icon_tool_icon) {
		_tmp0_ = !self->priv->waiting_for_icon_switch;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GSource* _tmp1_;
		GSource* _tmp2_;
		GSource* _tmp3_;
		self->priv->waiting_for_icon_switch = TRUE;
		_tmp1_ = g_timeout_source_new ((guint) 100);
		_g_source_unref0 (timer);
		timer = _tmp1_;
		_tmp2_ = timer;
		g_source_set_callback (_tmp2_, ____lambda104__gsource_func, g_object_ref (self), g_object_unref);
		_tmp3_ = timer;
		g_source_attach (_tmp3_, NULL);
	}
	_g_source_unref0 (timer);
}

void
bird_font_spin_button_set_big_number (BirdFontSpinButton* self,
                                      gboolean b)
{
	g_return_if_fail (self != NULL);
	self->priv->big_number = b;
}

void
bird_font_spin_button_set_integers (BirdFontSpinButton* self,
                                    gboolean i)
{
	g_return_if_fail (self != NULL);
	self->priv->integers = i;
	self->priv->big_number = i;
}

gchar*
bird_font_spin_button_convert_to_string (gdouble val)
{
	BirdFontSpinButton* sb = NULL;
	BirdFontSpinButton* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = bird_font_spin_button_new (NULL, "");
	sb = _tmp0_;
	bird_font_spin_button_set_value_round (sb, val, TRUE, TRUE);
	_tmp1_ = bird_font_spin_button_get_display_value (sb);
	result = _tmp1_;
	_g_object_unref0 (sb);
	return result;
}

gdouble
bird_font_spin_button_convert_to_double (const gchar* val)
{
	BirdFontSpinButton* sb = NULL;
	BirdFontSpinButton* _tmp0_;
	gdouble result;
	g_return_val_if_fail (val != NULL, 0.0);
	_tmp0_ = bird_font_spin_button_new (NULL, "");
	sb = _tmp0_;
	bird_font_spin_button_set_int_value (sb, val);
	result = bird_font_spin_button_get_value (sb);
	_g_object_unref0 (sb);
	return result;
}

static void
__lambda356_ (BirdFontSpinButton* self,
              const gchar* text)
{
	g_return_if_fail (text != NULL);
	bird_font_spin_button_set_value (self, text, TRUE, TRUE);
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda356__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda356_ ((BirdFontSpinButton*) self, text);
}

static void
__lambda357_ (BirdFontSpinButton* self)
{
	bird_font_tab_content_hide_text_input ();
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda357__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda357_ ((BirdFontSpinButton*) self);
}

void
bird_font_spin_button_set_from_text (BirdFontSpinButton* self)
{
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontTextListener* _tmp6_;
	BirdFontTextListener* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_t_ ("Set");
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_spin_button_get_display_value (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_t_ ("Close");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_text_listener_new (_tmp1_, _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	listener = _tmp7_;
	g_signal_connect_object (listener, "signal-text-input", (GCallback) ___lambda356__bird_font_text_listener_signal_text_input, self, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda357__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
}

void
bird_font_spin_button_set_max (BirdFontSpinButton* self,
                               gdouble max)
{
	g_return_if_fail (self != NULL);
	if (self->priv->big_number) {
		max = max / 100;
	}
	self->priv->max = (gint) rint (max * 10000);
}

void
bird_font_spin_button_set_min (BirdFontSpinButton* self,
                               gdouble min)
{
	g_return_if_fail (self != NULL);
	if (self->priv->big_number) {
		min = min / 100;
	}
	self->priv->min = (gint) rint (min * 10000);
}

void
bird_font_spin_button_set_int_step (BirdFontSpinButton* self,
                                    gdouble step)
{
	g_return_if_fail (self != NULL);
	if (self->priv->big_number) {
		step = step / 100;
	}
	self->priv->step = (gint) rint (step * 10000);
}

void
bird_font_spin_button_increase (BirdFontSpinButton* self)
{
	gint v = 0;
	g_return_if_fail (self != NULL);
	v = bird_font_spin_button_get_int_value (self);
	v += self->priv->step;
	if (v > self->priv->max) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("%i", self->priv->max);
		_tmp1_ = _tmp0_;
		bird_font_spin_button_set_int_value (self, _tmp1_);
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("%i", v);
		_tmp3_ = _tmp2_;
		bird_font_spin_button_set_int_value (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	g_signal_emit (self, bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL], 0, self);
	bird_font_tool_redraw ((BirdFontTool*) self);
}

void
bird_font_spin_button_decrease (BirdFontSpinButton* self)
{
	gint v = 0;
	g_return_if_fail (self != NULL);
	v = bird_font_spin_button_get_int_value (self);
	v -= self->priv->step;
	if (v <= self->priv->min) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("%i", self->priv->min);
		_tmp1_ = _tmp0_;
		bird_font_spin_button_set_int_value (self, _tmp1_);
		_g_free0 (_tmp1_);
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("%i", v);
		_tmp3_ = _tmp2_;
		bird_font_spin_button_set_int_value (self, _tmp3_);
		_g_free0 (_tmp3_);
	}
	g_signal_emit (self, bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL], 0, self);
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

void
bird_font_spin_button_set_int_value (BirdFontSpinButton* self,
                                     const gchar* new_value)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_value != NULL);
	_tmp0_ = g_strdup (new_value);
	v = _tmp0_;
	_tmp1_ = v;
	self->priv->negative = g_str_has_prefix (_tmp1_, "-");
	if (self->priv->negative) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = v;
		_tmp3_ = string_replace (_tmp2_, "-", "");
		_g_free0 (v);
		v = _tmp3_;
	}
	while (TRUE) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = v;
		if (!(!(g_utf8_strlen (_tmp4_, (gssize) -1) >= 5))) {
			break;
		}
		_tmp5_ = v;
		_tmp6_ = g_strconcat ("0", _tmp5_, NULL);
		_g_free0 (v);
		v = _tmp6_;
	}
	_tmp7_ = v;
	_tmp8_ = v;
	_tmp9_ = string_substring (_tmp7_, (glong) string_index_of_nth_char (_tmp8_, (glong) 0), (glong) 1);
	_tmp10_ = _tmp9_;
	self->n0 = bird_font_spin_button_parse (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = v;
	_tmp12_ = v;
	_tmp13_ = string_substring (_tmp11_, (glong) string_index_of_nth_char (_tmp12_, (glong) 1), (glong) 1);
	_tmp14_ = _tmp13_;
	self->n1 = bird_font_spin_button_parse (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = v;
	_tmp16_ = v;
	_tmp17_ = string_substring (_tmp15_, (glong) string_index_of_nth_char (_tmp16_, (glong) 2), (glong) 1);
	_tmp18_ = _tmp17_;
	self->n2 = bird_font_spin_button_parse (self, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = v;
	_tmp20_ = v;
	_tmp21_ = string_substring (_tmp19_, (glong) string_index_of_nth_char (_tmp20_, (glong) 3), (glong) 1);
	_tmp22_ = _tmp21_;
	self->n3 = bird_font_spin_button_parse (self, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = v;
	_tmp24_ = v;
	_tmp25_ = string_substring (_tmp23_, (glong) string_index_of_nth_char (_tmp24_, (glong) 4), (glong) 1);
	_tmp26_ = _tmp25_;
	self->n4 = bird_font_spin_button_parse (self, _tmp26_);
	_g_free0 (_tmp26_);
	bird_font_spin_button_show_adjustmet_icon (self);
	g_signal_emit (self, bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL], 0, self);
	_g_free0 (v);
}

static gint8
bird_font_spin_button_parse (BirdFontSpinButton* self,
                             const gchar* s)
{
	gint v = 0;
	gint8 result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s != NULL, 0);
	v = atoi (s);
	if (v < 0) {
		g_warning ("SpinButton.vala:307: Failed to parse integer.");
		result = (gint8) 0;
		return result;
	}
	result = (gint8) v;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
bird_font_spin_button_set_value (BirdFontSpinButton* self,
                                 const gchar* new_value,
                                 gboolean check_boundaries,
                                 gboolean emit_signal)
{
	gchar* v = NULL;
	gchar* _tmp0_;
	gint fv = 0;
	gchar* separator = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp78_;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp90_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_value != NULL);
	_tmp0_ = string_replace (new_value, ",", ".");
	v = _tmp0_;
	_tmp1_ = g_strdup ("");
	separator = _tmp1_;
	_tmp2_ = v;
	self->priv->negative = g_str_has_prefix (_tmp2_, "-");
	if (self->priv->negative) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = v;
		_tmp4_ = string_replace (_tmp3_, "-", "");
		_g_free0 (v);
		v = _tmp4_;
	}
	if (self->priv->big_number) {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		const gchar* _tmp15_;
		gint _tmp16_ = 0;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp6_ = v;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = v;
			_tmp5_ = g_strcmp0 (_tmp7_, "0") == 0;
		}
		if (_tmp5_) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("0.0000");
			_g_free0 (v);
			v = _tmp8_;
		}
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			const gchar* _tmp10_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp10_ = v;
			if (g_str_has_prefix (_tmp10_, "0")) {
				const gchar* _tmp11_;
				_tmp11_ = v;
				_tmp9_ = !g_str_has_prefix (_tmp11_, "0.");
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp12_ = v;
			_tmp13_ = v;
			_tmp14_ = string_substring (_tmp12_, (glong) string_index_of_nth_char (_tmp13_, (glong) 1), (glong) -1);
			_g_free0 (v);
			v = _tmp14_;
		}
		_tmp15_ = v;
		fv = atoi (_tmp15_);
		if (fv < 0) {
			_tmp16_ = -fv;
		} else {
			_tmp16_ = fv;
		}
		fv = _tmp16_;
		if (fv < 10) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = v;
			_tmp18_ = string_to_string (_tmp17_);
			_tmp19_ = g_strconcat ("00", _tmp18_, NULL);
			_g_free0 (v);
			v = _tmp19_;
		} else {
			if (fv < 100) {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = v;
				_tmp21_ = string_to_string (_tmp20_);
				_tmp22_ = g_strconcat ("0", _tmp21_, NULL);
				_g_free0 (v);
				v = _tmp22_;
			}
		}
		_tmp23_ = v;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (v);
		v = _tmp25_;
	}
	while (TRUE) {
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp26_ = v;
		if (!(g_utf8_strlen (_tmp26_, (gssize) -1) < 6)) {
			break;
		}
		_tmp27_ = v;
		if (string_index_of (_tmp27_, ".", 0) == -1) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = v;
			_tmp29_ = g_strconcat (_tmp28_, ".", NULL);
			_g_free0 (v);
			v = _tmp29_;
		} else {
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp30_ = v;
			_tmp31_ = g_strconcat (_tmp30_, "0", NULL);
			_g_free0 (v);
			v = _tmp31_;
		}
	}
	if (!self->priv->big_number) {
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp32_ = v;
		_tmp33_ = v;
		_tmp34_ = string_substring (_tmp32_, (glong) string_index_of_nth_char (_tmp33_, (glong) 0), (glong) 1);
		_tmp35_ = _tmp34_;
		self->n0 = (gint8) atoi (_tmp35_);
		_g_free0 (_tmp35_);
		_tmp36_ = v;
		_tmp37_ = v;
		_tmp38_ = string_substring (_tmp36_, (glong) string_index_of_nth_char (_tmp37_, (glong) 1), (glong) 1);
		_g_free0 (separator);
		separator = _tmp38_;
		_tmp39_ = v;
		_tmp40_ = v;
		_tmp41_ = string_substring (_tmp39_, (glong) string_index_of_nth_char (_tmp40_, (glong) 2), (glong) 1);
		_tmp42_ = _tmp41_;
		self->n1 = (gint8) atoi (_tmp42_);
		_g_free0 (_tmp42_);
		_tmp43_ = v;
		_tmp44_ = v;
		_tmp45_ = string_substring (_tmp43_, (glong) string_index_of_nth_char (_tmp44_, (glong) 3), (glong) 1);
		_tmp46_ = _tmp45_;
		self->n2 = (gint8) atoi (_tmp46_);
		_g_free0 (_tmp46_);
		_tmp47_ = v;
		_tmp48_ = v;
		_tmp49_ = string_substring (_tmp47_, (glong) string_index_of_nth_char (_tmp48_, (glong) 4), (glong) 1);
		_tmp50_ = _tmp49_;
		self->n3 = (gint8) atoi (_tmp50_);
		_g_free0 (_tmp50_);
		_tmp51_ = v;
		_tmp52_ = v;
		_tmp53_ = string_substring (_tmp51_, (glong) string_index_of_nth_char (_tmp52_, (glong) 5), (glong) 1);
		_tmp54_ = _tmp53_;
		self->n4 = (gint8) atoi (_tmp54_);
		_g_free0 (_tmp54_);
	} else {
		const gchar* _tmp55_;
		const gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		const gchar* _tmp74_;
		const gchar* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp55_ = v;
		_tmp56_ = v;
		_tmp57_ = string_substring (_tmp55_, (glong) string_index_of_nth_char (_tmp56_, (glong) 0), (glong) 1);
		_tmp58_ = _tmp57_;
		self->n0 = (gint8) atoi (_tmp58_);
		_g_free0 (_tmp58_);
		_tmp59_ = v;
		_tmp60_ = v;
		_tmp61_ = string_substring (_tmp59_, (glong) string_index_of_nth_char (_tmp60_, (glong) 1), (glong) 1);
		_tmp62_ = _tmp61_;
		self->n1 = (gint8) atoi (_tmp62_);
		_g_free0 (_tmp62_);
		_tmp63_ = v;
		_tmp64_ = v;
		_tmp65_ = string_substring (_tmp63_, (glong) string_index_of_nth_char (_tmp64_, (glong) 2), (glong) 1);
		_tmp66_ = _tmp65_;
		self->n2 = (gint8) atoi (_tmp66_);
		_g_free0 (_tmp66_);
		_tmp67_ = v;
		_tmp68_ = v;
		_tmp69_ = string_substring (_tmp67_, (glong) string_index_of_nth_char (_tmp68_, (glong) 3), (glong) 1);
		_g_free0 (separator);
		separator = _tmp69_;
		_tmp70_ = v;
		_tmp71_ = v;
		_tmp72_ = string_substring (_tmp70_, (glong) string_index_of_nth_char (_tmp71_, (glong) 4), (glong) 1);
		_tmp73_ = _tmp72_;
		self->n3 = (gint8) atoi (_tmp73_);
		_g_free0 (_tmp73_);
		_tmp74_ = v;
		_tmp75_ = v;
		_tmp76_ = string_substring (_tmp74_, (glong) string_index_of_nth_char (_tmp75_, (glong) 5), (glong) 1);
		_tmp77_ = _tmp76_;
		self->n4 = (gint8) atoi (_tmp77_);
		_g_free0 (_tmp77_);
		if (self->priv->integers) {
			self->n3 = (gint8) 0;
			self->n4 = (gint8) 0;
		}
	}
	_tmp78_ = separator;
	if (g_strcmp0 (_tmp78_, ".") != 0) {
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp79_ = string_to_string (new_value);
		_tmp80_ = v;
		_tmp81_ = string_to_string (_tmp80_);
		_tmp82_ = g_strconcat ("Expecting \".\" ", _tmp79_, " -> (", _tmp81_, ")", NULL);
		_tmp83_ = _tmp82_;
		g_warning ("SpinButton.vala:374: %s", _tmp83_);
		_g_free0 (_tmp83_);
	}
	if (check_boundaries) {
		_tmp84_ = bird_font_spin_button_get_int_value (self) > self->priv->max;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		_tmp85_ = string_to_string (new_value);
		_tmp86_ = g_strdup_printf ("%i", self->priv->max);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat ("Out of bounds (", _tmp85_, " > ", _tmp87_, ").", NULL);
		_tmp89_ = _tmp88_;
		g_warning ("SpinButton.vala:378: %s", _tmp89_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		bird_font_spin_button_set_value_round (self, (gdouble) self->priv->max, FALSE, TRUE);
	}
	if (check_boundaries) {
		_tmp90_ = bird_font_spin_button_get_int_value (self) < self->priv->min;
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		const gchar* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		_tmp91_ = string_to_string (new_value);
		_tmp92_ = g_strdup_printf ("%i", self->priv->min);
		_tmp93_ = _tmp92_;
		_tmp94_ = g_strconcat ("Out of bounds (", _tmp91_, " < ", _tmp93_, ").", NULL);
		_tmp95_ = _tmp94_;
		g_warning ("SpinButton.vala:383: %s", _tmp95_);
		_g_free0 (_tmp95_);
		_g_free0 (_tmp93_);
		bird_font_spin_button_set_value_round (self, (gdouble) self->priv->min, FALSE, TRUE);
	}
	if (emit_signal) {
		g_signal_emit (self, bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL], 0, self);
	}
	bird_font_spin_button_show_adjustmet_icon (self);
	_g_free0 (separator);
	_g_free0 (v);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_spin_button_set_value_round (BirdFontSpinButton* self,
                                       gdouble v,
                                       gboolean check_boundaries,
                                       gboolean emit_signal)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	if (v == ((gdouble) -0)) {
		v = (gdouble) 0;
	}
	_tmp0_ = double_to_string (v);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, ",", ".");
	_tmp3_ = _tmp2_;
	bird_font_spin_button_set_value (self, _tmp3_, check_boundaries, emit_signal);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
}

gdouble
bird_font_spin_button_get_value (BirdFontSpinButton* self)
{
	gdouble r = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (!self->priv->big_number) {
		r = (((self->n0 + (self->n1 / 10.0)) + (self->n2 / 100.0)) + (self->n3 / 1000.0)) + (self->n4 / 1000.0);
	} else {
		r = ((((self->n0 * 100) + (self->n1 * 10)) + self->n2) + (self->n3 / 10.0)) + (self->n4 / 100.0);
	}
	if (self->priv->negative) {
		_tmp0_ = -r;
	} else {
		_tmp0_ = r;
	}
	result = _tmp0_;
	return result;
}

static gint
bird_font_spin_button_get_int_value (BirdFontSpinButton* self)
{
	gint r = 0;
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	r = ((((self->n0 * 10000) + (self->n1 * 1000)) + (self->n2 * 100)) + (self->n3 * 10)) + self->n4;
	if (self->priv->negative) {
		_tmp0_ = -r;
	} else {
		_tmp0_ = r;
	}
	result = _tmp0_;
	return result;
}

gchar*
bird_font_spin_button_get_short_display_value (BirdFontSpinButton* self)
{
	gboolean _tmp51_ = FALSE;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->integers) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (((gint) self->n0) == 0) {
			_tmp0_ = ((gint) self->n1) == 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup_printf ("%hhi", self->n2);
			result = _tmp1_;
			return result;
		}
		if (((gint) self->n0) == 0) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp2_ = g_strdup_printf ("%hhi", self->n1);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_strdup_printf ("%hhi", self->n2);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strconcat (_tmp3_, _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			_g_free0 (_tmp3_);
			result = _tmp7_;
			return result;
		}
		_tmp8_ = g_strdup_printf ("%hhi", self->n0);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%hhi", self->n1);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%hhi", self->n2);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp9_, _tmp11_, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = _tmp15_;
		return result;
	}
	if (!self->priv->big_number) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp16_ = g_strdup_printf ("%hhi", self->n0);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%hhi", self->n1);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%hhi", self->n2);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("%hhi", self->n3);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp17_, ".", _tmp19_, _tmp21_, _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		result = _tmp25_;
		return result;
	}
	if (self->priv->negative) {
		gboolean _tmp26_ = FALSE;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		if (((gint) self->n0) == 0) {
			_tmp26_ = ((gint) self->n1) == 0;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp27_ = g_strdup_printf ("%hhi", self->n2);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf ("%hhi", self->n3);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("%hhi", self->n4);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat ("-", _tmp28_, ".", _tmp30_, _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			result = _tmp34_;
			return result;
		}
		if (((gint) self->n0) == 0) {
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp35_ = g_strdup_printf ("%hhi", self->n1);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strdup_printf ("%hhi", self->n2);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strdup_printf ("%hhi", self->n3);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat ("-", _tmp36_, _tmp38_, ".", _tmp40_, NULL);
			_tmp42_ = _tmp41_;
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			result = _tmp42_;
			return result;
		}
		_tmp43_ = g_strdup_printf ("%hhi", self->n0);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("%hhi", self->n1);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strdup_printf ("%hhi", self->n2);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat ("-", _tmp44_, _tmp46_, _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = _tmp50_;
		return result;
	}
	if (((gint) self->n0) == 0) {
		_tmp51_ = ((gint) self->n1) == 0;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp52_ = g_strdup_printf ("%hhi", self->n2);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup_printf ("%hhi", self->n3);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf ("%hhi", self->n4);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp53_, ".", _tmp55_, _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		result = _tmp59_;
		return result;
	}
	if (((gint) self->n0) == 0) {
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp60_ = g_strdup_printf ("%hhi", self->n1);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strdup_printf ("%hhi", self->n2);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strdup_printf ("%hhi", self->n3);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strdup_printf ("%hhi", self->n4);
		_tmp67_ = _tmp66_;
		_tmp68_ = g_strconcat (_tmp61_, _tmp63_, ".", _tmp65_, _tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_g_free0 (_tmp67_);
		_g_free0 (_tmp65_);
		_g_free0 (_tmp63_);
		_g_free0 (_tmp61_);
		result = _tmp69_;
		return result;
	}
	_tmp70_ = g_strdup_printf ("%hhi", self->n0);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strdup_printf ("%hhi", self->n1);
	_tmp73_ = _tmp72_;
	_tmp74_ = g_strdup_printf ("%hhi", self->n2);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strdup_printf ("%hhi", self->n3);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strconcat (_tmp71_, _tmp73_, _tmp75_, ".", _tmp77_, NULL);
	_tmp79_ = _tmp78_;
	_g_free0 (_tmp77_);
	_g_free0 (_tmp75_);
	_g_free0 (_tmp73_);
	_g_free0 (_tmp71_);
	result = _tmp79_;
	return result;
}

gchar*
bird_font_spin_button_get_display_value (BirdFontSpinButton* self)
{
	gchar* v = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->integers) {
		gchar* _tmp0_;
		_tmp0_ = bird_font_spin_button_get_short_display_value (self);
		result = _tmp0_;
		_g_free0 (v);
		return result;
	}
	if (!self->priv->big_number) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = g_strdup_printf ("%hhi", self->n0);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("%hhi", self->n1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%hhi", self->n2);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("%hhi", self->n3);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("%hhi", self->n4);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp2_, ".", _tmp4_, _tmp6_, _tmp8_, _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		result = _tmp12_;
		_g_free0 (v);
		return result;
	}
	if (self->priv->negative) {
		_tmp13_ = "-";
	} else {
		_tmp13_ = "";
	}
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (v);
	v = _tmp14_;
	if (((gint) self->n0) == 0) {
		_tmp15_ = ((gint) self->n1) == 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp16_ = v;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strdup_printf ("%hhi", self->n2);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%hhi", self->n3);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("%hhi", self->n4);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp17_, _tmp19_, ".", _tmp21_, _tmp23_, NULL);
		_g_free0 (v);
		v = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	} else {
		if (((gint) self->n0) == 0) {
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp25_ = v;
			_tmp26_ = string_to_string (_tmp25_);
			_tmp27_ = g_strdup_printf ("%hhi", self->n1);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup_printf ("%hhi", self->n2);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("%hhi", self->n3);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup_printf ("%hhi", self->n4);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp26_, _tmp28_, _tmp30_, ".", _tmp32_, _tmp34_, NULL);
			_g_free0 (v);
			v = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
		} else {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp36_ = v;
			_tmp37_ = string_to_string (_tmp36_);
			_tmp38_ = g_strdup_printf ("%hhi", self->n0);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strdup_printf ("%hhi", self->n1);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("%hhi", self->n2);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup_printf ("%hhi", self->n3);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strdup_printf ("%hhi", self->n4);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat (_tmp37_, _tmp39_, _tmp41_, _tmp43_, ".", _tmp45_, _tmp47_, NULL);
			_g_free0 (v);
			v = _tmp48_;
			_g_free0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
		}
	}
	result = v;
	return result;
}

static void
bird_font_spin_button_real_draw_tool (BirdFontTool* base,
                                      cairo_t* cr,
                                      gdouble px,
                                      gdouble py)
{
	BirdFontSpinButton * self;
	gdouble scale = 0.0;
	gdouble text_height = 0.0;
	gchar* display_value = NULL;
	gchar* _tmp0_;
	BirdFontText* text = NULL;
	const gchar* _tmp1_;
	BirdFontText* _tmp2_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble text_x = 0.0;
	BirdFontText* _tmp3_;
	gdouble text_y = 0.0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_ = FALSE;
	self = (BirdFontSpinButton*) base;
	g_return_if_fail (cr != NULL);
	scale = bird_font_toolbox_get_scale ();
	text_height = 14 * scale;
	_tmp0_ = bird_font_spin_button_get_short_display_value (self);
	display_value = _tmp0_;
	_tmp1_ = display_value;
	_tmp2_ = bird_font_text_new (_tmp1_, text_height, (gdouble) 0);
	text = _tmp2_;
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	_tmp3_ = text;
	text_x = (x + ((((BirdFontTool*) self)->w - bird_font_text_get_sidebearing_extent (_tmp3_)) / 2)) + 1;
	text_y = y + ((((BirdFontTool*) self)->h - text_height) / 2);
	if (!self->priv->show_icon_tool_icon) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->priv->waiting_for_icon_switch;
	}
	if (_tmp4_) {
		if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Active Spin Button");
			_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color);
			G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color = _tmp5_;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("Spin Button");
			_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color);
			G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color = _tmp6_;
		}
	} else {
		if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("Selected Tool Foreground");
			_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color);
			G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color = _tmp7_;
		} else {
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("Tool Foreground");
			_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color);
			G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool)->icon_color = _tmp8_;
		}
	}
	BIRD_FONT_TOOL_CLASS (bird_font_spin_button_parent_class)->draw_tool (G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_TOOL, BirdFontTool), cr, px, py);
	if (!self->priv->show_icon_tool_icon) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = self->priv->waiting_for_icon_switch;
	}
	if (_tmp9_) {
		BirdFontText* _tmp12_;
		BirdFontText* _tmp13_;
		BirdFontText* _tmp14_;
		BirdFontText* _tmp15_;
		if (bird_font_tool_is_selected ((BirdFontTool*) self)) {
			BirdFontText* _tmp10_;
			_tmp10_ = text;
			bird_font_theme_text_color (_tmp10_, "Selected Tool Foreground");
		} else {
			BirdFontText* _tmp11_;
			_tmp11_ = text;
			bird_font_theme_text_color (_tmp11_, "Tool Foreground");
		}
		_tmp12_ = text;
		((BirdFontWidget*) _tmp12_)->widget_x = text_x;
		_tmp13_ = text;
		_tmp14_ = text;
		((BirdFontWidget*) _tmp13_)->widget_y = text_y + bird_font_text_get_decender (_tmp14_);
		_tmp15_ = text;
		bird_font_widget_draw ((BirdFontWidget*) _tmp15_, cr);
	}
	_g_object_unref0 (text);
	_g_free0 (display_value);
}

static void
bird_font_spin_button_class_init (BirdFontSpinButtonClass * klass,
                                  gpointer klass_data)
{
	bird_font_spin_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontSpinButton_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_spin_button_real_draw_tool;
	G_OBJECT_CLASS (klass)->finalize = bird_font_spin_button_finalize;
	bird_font_spin_button_signals[BIRD_FONT_SPIN_BUTTON_NEW_VALUE_ACTION_SIGNAL] = g_signal_new ("new-value-action", BIRD_FONT_TYPE_SPIN_BUTTON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_SPIN_BUTTON);
}

static void
bird_font_spin_button_instance_init (BirdFontSpinButton * self,
                                     gpointer klass)
{
	self->priv = bird_font_spin_button_get_instance_private (self);
	self->priv->negative = FALSE;
	self->n0 = (gint8) 2;
	self->n1 = (gint8) 0;
	self->n2 = (gint8) 0;
	self->n3 = (gint8) 0;
	self->n4 = (gint8) 0;
	self->priv->value_from_motion = FALSE;
	self->priv->begin_y = (gdouble) 0;
	self->priv->begin_value = 0;
	self->priv->max = 99999;
	self->priv->min = 0;
	self->priv->step = 1;
	self->priv->big_number = FALSE;
	self->priv->integers = FALSE;
	self->priv->last_active_time = (gdouble) 0;
	self->priv->waiting_for_icon_switch = FALSE;
	self->priv->show_icon_tool_icon = FALSE;
	self->locked = FALSE;
}

static void
bird_font_spin_button_finalize (GObject * obj)
{
	BirdFontSpinButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SPIN_BUTTON, BirdFontSpinButton);
	G_OBJECT_CLASS (bird_font_spin_button_parent_class)->finalize (obj);
}

static GType
bird_font_spin_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSpinButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_spin_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSpinButton), 0, (GInstanceInitFunc) bird_font_spin_button_instance_init, NULL };
	GType bird_font_spin_button_type_id;
	bird_font_spin_button_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontSpinButton", &g_define_type_info, 0);
	BirdFontSpinButton_private_offset = g_type_add_instance_private (bird_font_spin_button_type_id, sizeof (BirdFontSpinButtonPrivate));
	return bird_font_spin_button_type_id;
}

GType
bird_font_spin_button_get_type (void)
{
	static volatile gsize bird_font_spin_button_type_id__once = 0;
	if (g_once_init_enter (&bird_font_spin_button_type_id__once)) {
		GType bird_font_spin_button_type_id;
		bird_font_spin_button_type_id = bird_font_spin_button_get_type_once ();
		g_once_init_leave (&bird_font_spin_button_type_id__once, bird_font_spin_button_type_id);
	}
	return bird_font_spin_button_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

