/* SpacingTab.c generated by valac 0.56.16, the Vala compiler
 * generated from SpacingTab.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SPACING_TAB_0_PROPERTY,
	BIRD_FONT_SPACING_TAB_NUM_PROPERTIES
};
static GParamSpec* bird_font_spacing_tab_properties[BIRD_FONT_SPACING_TAB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block59Data Block59Data;
typedef struct _Block60Data Block60Data;

struct _BirdFontSpacingTabPrivate {
	gdouble box_size;
	gdouble height;
	gdouble character_height;
	BirdFontWidgetAllocation* allocation;
	BirdFontGlyph* text_input_glyph;
};

struct _Block59Data {
	int _ref_count_;
	BirdFontSpacingTab* self;
	gchar* submitted_value;
};

struct _Block60Data {
	int _ref_count_;
	BirdFontSpacingTab* self;
	gchar* submitted_value;
};

static gint BirdFontSpacingTab_private_offset;
static gpointer bird_font_spacing_tab_parent_class = NULL;

static gchar* bird_font_spacing_tab_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_spacing_tab_real_get_name (BirdFontFontDisplay* base);
static void bird_font_spacing_tab_real_draw (BirdFontFontDisplay* base,
                                      BirdFontWidgetAllocation* allocation,
                                      cairo_t* cr);
static void bird_font_spacing_tab_draw_spacing_metrix (BirdFontSpacingTab* self,
                                                BirdFontWidgetAllocation* allocation,
                                                cairo_t* cr);
static void bird_font_spacing_tab_draw_glyph_spacing (BirdFontSpacingTab* self,
                                               BirdFontWidgetAllocation* allocation,
                                               cairo_t* cr,
                                               BirdFontGlyph* glyph,
                                               gint index);
static void bird_font_spacing_tab_real_button_press (BirdFontFontDisplay* base,
                                              guint button,
                                              gdouble ex,
                                              gdouble ey);
static void bird_font_spacing_tab_real_button_release (BirdFontFontDisplay* base,
                                                gint button,
                                                gdouble ex,
                                                gdouble ey);
static void bird_font_spacing_tab_update_lsb (BirdFontSpacingTab* self,
                                       BirdFontGlyph* g);
static void bird_font_spacing_tab_update_rsb (BirdFontSpacingTab* self,
                                       BirdFontGlyph* g);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static void __lambda234_ (Block59Data* _data59_,
                   const gchar* text);
static void ___lambda234__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda235_ (Block59Data* _data59_);
static void ___lambda235__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static void __lambda236_ (Block60Data* _data60_,
                   const gchar* text);
static void ___lambda236__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda237_ (Block60Data* _data60_);
static void ___lambda237__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static gboolean bird_font_spacing_tab_real_needs_modifier (BirdFontFontDisplay* base);
static void bird_font_spacing_tab_finalize (GObject * obj);
static GType bird_font_spacing_tab_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_spacing_tab_get_instance_private (BirdFontSpacingTab* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSpacingTab_private_offset);
}

BirdFontSpacingTab*
bird_font_spacing_tab_construct (GType object_type)
{
	BirdFontSpacingTab * self = NULL;
	BirdFontWidgetAllocation* _tmp0_;
	self = (BirdFontSpacingTab*) bird_font_kerning_display_construct (object_type);
	_tmp0_ = bird_font_widget_allocation_new ();
	_g_object_unref0 (self->priv->allocation);
	self->priv->allocation = _tmp0_;
	((BirdFontKerningDisplay*) self)->adjust_side_bearings = TRUE;
	return self;
}

BirdFontSpacingTab*
bird_font_spacing_tab_new (void)
{
	return bird_font_spacing_tab_construct (BIRD_FONT_TYPE_SPACING_TAB);
}

static gchar*
bird_font_spacing_tab_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontSpacingTab * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontSpacingTab*) base;
	_tmp0_ = bird_font_t_ ("Spacing");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_spacing_tab_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontSpacingTab * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontSpacingTab*) base;
	_tmp0_ = g_strdup ("Spacing");
	result = _tmp0_;
	return result;
}

static void
bird_font_spacing_tab_real_draw (BirdFontFontDisplay* base,
                                 BirdFontWidgetAllocation* allocation,
                                 cairo_t* cr)
{
	BirdFontSpacingTab * self;
	self = (BirdFontSpacingTab*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_spacing_tab_parent_class)->draw ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay), allocation, cr);
	bird_font_spacing_tab_draw_spacing_metrix (self, allocation, cr);
}

static void
bird_font_spacing_tab_draw_spacing_metrix (BirdFontSpacingTab* self,
                                           BirdFontWidgetAllocation* allocation,
                                           cairo_t* cr)
{
	BirdFontGlyphSequence* row = NULL;
	gint index = 0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontGlyphSequence* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	cairo_save (cr);
	bird_font_theme_color (cr, "Background 1");
	cairo_rectangle (cr, (gdouble) 0, allocation->height - self->priv->height, (gdouble) allocation->width, self->priv->height);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Table Border");
	cairo_set_line_width (cr, 0.8);
	cairo_move_to (cr, (gdouble) 0, allocation->height - self->priv->height);
	cairo_line_to (cr, (gdouble) allocation->width, allocation->height - self->priv->height);
	cairo_stroke (cr);
	cairo_move_to (cr, (gdouble) 0, (allocation->height - self->priv->height) + self->priv->character_height);
	cairo_line_to (cr, (gdouble) allocation->width, (allocation->height - self->priv->height) + self->priv->character_height);
	cairo_stroke (cr);
	cairo_restore (cr);
	_tmp1_ = bird_font_kerning_display_get_first_row ((BirdFontKerningDisplay*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = font;
	_tmp4_ = bird_font_glyph_sequence_process_ligatures (_tmp2_, _tmp3_);
	_g_object_unref0 (row);
	row = _tmp4_;
	_g_object_unref0 (_tmp2_);
	index = 0;
	{
		GeeArrayList* _g_list = NULL;
		BirdFontGlyphSequence* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _g_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _g_index = 0;
		_tmp5_ = row;
		_tmp6_ = _tmp5_->glyph;
		_g_list = _tmp6_;
		_tmp7_ = _g_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_size = _tmp9_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontGlyph* _tmp14_;
			gint _tmp15_;
			_g_index = _g_index + 1;
			_tmp10_ = _g_index;
			_tmp11_ = _g_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _g_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _g_index);
			g = (BirdFontGlyph*) _tmp13_;
			_tmp14_ = g;
			bird_font_spacing_tab_draw_glyph_spacing (self, allocation, cr, _tmp14_, index);
			_tmp15_ = index;
			index = _tmp15_ + 1;
			_g_object_unref0 (g);
		}
	}
	_g_object_unref0 (font);
	_g_object_unref0 (row);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
bird_font_spacing_tab_draw_glyph_spacing (BirdFontSpacingTab* self,
                                          BirdFontWidgetAllocation* allocation,
                                          cairo_t* cr,
                                          BirdFontGlyph* glyph,
                                          gint index)
{
	BirdFontGlyph* g = NULL;
	gdouble end = 0.0;
	gdouble middle = 0.0;
	gdouble l = 0.0;
	gdouble r = 0.0;
	BirdFontText* left = NULL;
	BirdFontText* right = NULL;
	BirdFontText* cap = NULL;
	gunichar c = 0U;
	BirdFontWidgetAllocation* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = _g_object_ref0 (allocation);
	_g_object_unref0 (self->priv->allocation);
	self->priv->allocation = _tmp0_;
	end = (index + 1) * self->priv->box_size;
	cairo_save (cr);
	cairo_set_source_rgba (cr, 0.5, 0.5, 0.5, (gdouble) 1);
	cairo_set_line_width (cr, (gdouble) 2);
	cairo_move_to (cr, end, allocation->height - self->priv->height);
	cairo_line_to (cr, end, (gdouble) allocation->height);
	cairo_stroke (cr);
	cairo_restore (cr);
	middle = end - (self->priv->box_size / 2.0);
	cairo_save (cr);
	cairo_set_source_rgba (cr, 0.5, 0.5, 0.5, (gdouble) 1);
	cairo_set_line_width (cr, 0.8);
	cairo_move_to (cr, middle, (allocation->height - self->priv->height) + self->priv->character_height);
	cairo_line_to (cr, middle, (gdouble) allocation->height);
	cairo_stroke (cr);
	cairo_restore (cr);
	if (glyph != NULL) {
		BirdFontGlyph* _tmp1_;
		BirdFontGlyph* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		BirdFontText* _tmp5_;
		BirdFontText* _tmp6_;
		BirdFontText* _tmp7_;
		BirdFontText* _tmp8_;
		BirdFontText* _tmp9_;
		BirdFontText* _tmp10_;
		BirdFontText* _tmp11_;
		BirdFontText* _tmp12_;
		BirdFontGlyph* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		BirdFontText* _tmp16_;
		BirdFontText* _tmp17_;
		BirdFontText* _tmp18_;
		BirdFontText* _tmp19_;
		BirdFontText* _tmp20_;
		BirdFontText* _tmp21_;
		BirdFontText* _tmp22_;
		BirdFontText* _tmp23_;
		BirdFontGlyph* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		BirdFontText* _tmp27_;
		BirdFontText* _tmp28_;
		BirdFontText* _tmp29_;
		BirdFontText* _tmp30_;
		BirdFontText* _tmp31_;
		BirdFontText* _tmp32_;
		BirdFontText* _tmp33_;
		BirdFontText* _tmp34_;
		BirdFontText* _tmp35_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (glyph, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		_g_object_unref0 (g);
		g = _tmp1_;
		_tmp2_ = g;
		c = bird_font_glyph_get_unichar (_tmp2_);
		_tmp3_ = g_unichar_to_string (c);
		_tmp4_ = (gchar*) _tmp3_;
		_tmp5_ = bird_font_text_new (_tmp4_, (gdouble) 17, (gdouble) 0);
		_g_object_unref0 (cap);
		cap = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = cap;
		bird_font_theme_text_color (_tmp6_, "Table Border");
		_tmp7_ = cap;
		_tmp8_ = cap;
		((BirdFontWidget*) _tmp7_)->widget_x = middle - (bird_font_text_get_extent (_tmp8_) / 2.0);
		_tmp9_ = cap;
		((BirdFontWidget*) _tmp9_)->widget_y = ((allocation->height - self->priv->height) + self->priv->character_height) - 4;
		_tmp10_ = cap;
		_tmp11_ = cap;
		_tmp12_ = cap;
		bird_font_text_draw_at_baseline (_tmp10_, cr, ((BirdFontWidget*) _tmp11_)->widget_x, ((BirdFontWidget*) _tmp12_)->widget_y, "");
		_tmp13_ = g;
		l = bird_font_glyph_get_left_side_bearing (_tmp13_);
		if (fabs (l) < 0.001) {
			l = (gdouble) 0;
		}
		_tmp14_ = bird_font_spacing_tab_truncate (self, l, 5);
		_tmp15_ = _tmp14_;
		_tmp16_ = bird_font_text_new (_tmp15_, (gdouble) 17, (gdouble) 0);
		_g_object_unref0 (left);
		left = _tmp16_;
		_g_free0 (_tmp15_);
		_tmp17_ = left;
		bird_font_theme_text_color (_tmp17_, "Foreground 1");
		_tmp18_ = left;
		_tmp19_ = left;
		((BirdFontWidget*) _tmp18_)->widget_x = (middle - (self->priv->box_size / 2.0)) + (((self->priv->box_size / 2.0) - bird_font_text_get_extent (_tmp19_)) / 2.0);
		_tmp20_ = left;
		((BirdFontWidget*) _tmp20_)->widget_y = (gdouble) (allocation->height - 7);
		_tmp21_ = left;
		_tmp22_ = left;
		_tmp23_ = left;
		bird_font_text_draw_at_baseline (_tmp21_, cr, ((BirdFontWidget*) _tmp22_)->widget_x, ((BirdFontWidget*) _tmp23_)->widget_y, "");
		_tmp24_ = g;
		r = bird_font_glyph_get_right_side_bearing (_tmp24_);
		if (fabs (r) < 0.001) {
			r = (gdouble) 0;
		}
		_tmp25_ = bird_font_spacing_tab_truncate (self, r, 5);
		_tmp26_ = _tmp25_;
		_tmp27_ = bird_font_text_new (_tmp26_, (gdouble) 17, (gdouble) 0);
		_g_object_unref0 (right);
		right = _tmp27_;
		_g_free0 (_tmp26_);
		_tmp28_ = right;
		bird_font_theme_text_color (_tmp28_, "Table Border");
		_tmp29_ = right;
		_tmp30_ = right;
		_tmp31_ = right;
		((BirdFontWidget*) _tmp29_)->widget_x = (end - (((self->priv->box_size / 2.0) - bird_font_text_get_extent (_tmp30_)) / 2.0)) - bird_font_text_get_extent (_tmp31_);
		_tmp32_ = right;
		((BirdFontWidget*) _tmp32_)->widget_y = (gdouble) (allocation->height - 7);
		_tmp33_ = right;
		_tmp34_ = right;
		_tmp35_ = right;
		bird_font_text_draw_at_baseline (_tmp33_, cr, ((BirdFontWidget*) _tmp34_)->widget_x, ((BirdFontWidget*) _tmp35_)->widget_y, "");
	}
	_g_object_unref0 (cap);
	_g_object_unref0 (right);
	_g_object_unref0 (left);
	_g_object_unref0 (g);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gchar*
bird_font_spacing_tab_truncate (BirdFontSpacingTab* self,
                                gdouble f,
                                gint digits)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	gchar* s = NULL;
	gchar* _tmp1_;
	gint d = 0;
	gint i = 0;
	gunichar c = 0U;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = double_to_string (f);
	t = _tmp0_;
	_tmp1_ = g_strdup ("");
	s = _tmp1_;
	d = digits;
	_tmp2_ = t;
	if (string_index_of (_tmp2_, "-", 0) != -1) {
		gint _tmp3_;
		_tmp3_ = d;
		d = _tmp3_ + 1;
	}
	_tmp4_ = t;
	if (string_index_of (_tmp4_, ".", 0) != -1) {
		gint _tmp5_;
		_tmp5_ = d;
		d = _tmp5_ + 1;
	}
	i = 0;
	while (TRUE) {
		const gchar* _tmp6_;
		gunichar _tmp7_ = 0U;
		gboolean _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = t;
		_tmp8_ = string_get_next_char (_tmp6_, &i, &_tmp7_);
		c = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = s;
		_tmp10_ = g_unichar_to_string (c);
		_tmp11_ = (gchar*) _tmp10_;
		_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
		_g_free0 (s);
		s = _tmp12_;
		_g_free0 (_tmp11_);
		if (i >= d) {
			break;
		}
	}
	result = s;
	_g_free0 (t);
	return result;
}

static void
bird_font_spacing_tab_real_button_press (BirdFontFontDisplay* base,
                                         guint button,
                                         gdouble ex,
                                         gdouble ey)
{
	BirdFontSpacingTab * self;
	BirdFontWidgetAllocation* _tmp0_;
	self = (BirdFontSpacingTab*) base;
	if (button == ((guint) 3)) {
		return;
	}
	_tmp0_ = self->priv->allocation;
	if (!(ey >= (_tmp0_->height - self->priv->height))) {
		BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_spacing_tab_parent_class)->button_press ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay), button, ex, ey);
	}
}

static void
bird_font_spacing_tab_real_button_release (BirdFontFontDisplay* base,
                                           gint button,
                                           gdouble ex,
                                           gdouble ey)
{
	BirdFontSpacingTab * self;
	BirdFontGlyphSequence* row = NULL;
	gdouble p = 0.0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontSpacingTab*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	if (button == 3) {
		_g_object_unref0 (font);
		_g_object_unref0 (row);
		return;
	}
	_tmp1_ = self->priv->allocation;
	if (ey >= (_tmp1_->height - self->priv->height)) {
		BirdFontGlyphSequence* _tmp2_;
		BirdFontGlyphSequence* _tmp3_;
		BirdFontFont* _tmp4_;
		BirdFontGlyphSequence* _tmp5_;
		bird_font_tab_content_hide_text_input ();
		_tmp2_ = bird_font_kerning_display_get_first_row ((BirdFontKerningDisplay*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = font;
		_tmp5_ = bird_font_glyph_sequence_process_ligatures (_tmp3_, _tmp4_);
		_g_object_unref0 (row);
		row = _tmp5_;
		_g_object_unref0 (_tmp3_);
		p = (gdouble) 0;
		{
			GeeArrayList* _g_list = NULL;
			BirdFontGlyphSequence* _tmp6_;
			GeeArrayList* _tmp7_;
			gint _g_size = 0;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _g_index = 0;
			_tmp6_ = row;
			_tmp7_ = _tmp6_->glyph;
			_g_list = _tmp7_;
			_tmp8_ = _g_list;
			_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_size = _tmp10_;
			_g_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				BirdFontGlyph* g = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp17_;
				_g_index = _g_index + 1;
				_tmp11_ = _g_index;
				_tmp12_ = _g_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _g_list;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _g_index);
				g = (BirdFontGlyph*) _tmp14_;
				_tmp15_ = ex;
				if ((p < _tmp15_) && (_tmp15_ < (p + (self->priv->box_size / 2.0)))) {
					BirdFontGlyph* _tmp16_;
					_tmp16_ = g;
					bird_font_spacing_tab_update_lsb (self, _tmp16_);
				}
				_tmp17_ = ex;
				if (((p + (self->priv->box_size / 2.0)) < _tmp17_) && (_tmp17_ < (p + self->priv->box_size))) {
					BirdFontGlyph* _tmp18_;
					_tmp18_ = g;
					bird_font_spacing_tab_update_rsb (self, _tmp18_);
				}
				p += self->priv->box_size;
				_g_object_unref0 (g);
			}
		}
	} else {
		BIRD_FONT_FONT_DISPLAY_CLASS (bird_font_spacing_tab_parent_class)->button_release ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (self, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay), button, ex, ey);
	}
	_g_object_unref0 (font);
	_g_object_unref0 (row);
}

static Block59Data*
block59_data_ref (Block59Data* _data59_)
{
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}

static void
block59_data_unref (void * _userdata_)
{
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		BirdFontSpacingTab* self;
		self = _data59_->self;
		_g_free0 (_data59_->submitted_value);
		_g_object_unref0 (self);
		g_slice_free (Block59Data, _data59_);
	}
}

static void
__lambda234_ (Block59Data* _data59_,
              const gchar* text)
{
	BirdFontSpacingTab* self;
	gchar* _tmp0_;
	self = _data59_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data59_->submitted_value);
	_data59_->submitted_value = _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda234__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda234_ (self, text);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
__lambda235_ (Block59Data* _data59_)
{
	BirdFontSpacingTab* self;
	gdouble v = 0.0;
	const gchar* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* _tmp6_;
	self = _data59_->self;
	bird_font_tab_content_hide_text_input ();
	((BirdFontKerningDisplay*) self)->text_input = FALSE;
	((BirdFontKerningDisplay*) self)->suppress_input = FALSE;
	_tmp0_ = _data59_->submitted_value;
	v = double_parse (_tmp0_);
	_tmp1_ = self->priv->text_input_glyph;
	_tmp2_ = self->priv->text_input_glyph;
	_tmp3_ = bird_font_glyph_get_left_limit (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->text_input_glyph;
	bird_font_glyph_set_left_limit (_tmp2_, _tmp4_ - (v - bird_font_glyph_get_left_side_bearing (_tmp5_)));
	_tmp6_ = self->priv->text_input_glyph;
	bird_font_glyph_update_other_spacing_classes (_tmp6_);
}

static void
___lambda235__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda235_ (self);
}

static void
bird_font_spacing_tab_update_lsb (BirdFontSpacingTab* self,
                                  BirdFontGlyph* g)
{
	Block59Data* _data59_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gdouble l = 0.0;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontTextListener* _tmp9_;
	BirdFontTextListener* _tmp10_;
	BirdFontTextListener* _tmp11_;
	BirdFontTextListener* _tmp12_;
	g_return_if_fail (self != NULL);
	_data59_ = g_slice_new0 (Block59Data);
	_data59_->_ref_count_ = 1;
	_data59_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data59_->submitted_value = _tmp0_;
	if (g == NULL) {
		_g_object_unref0 (listener);
		block59_data_unref (_data59_);
		_data59_ = NULL;
		return;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (g, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	_g_object_unref0 (self->priv->text_input_glyph);
	self->priv->text_input_glyph = _tmp1_;
	_tmp2_ = self->priv->text_input_glyph;
	l = bird_font_glyph_get_left_side_bearing (_tmp2_);
	if (fabs (l) < 0.001) {
		l = (gdouble) 0;
	}
	_tmp3_ = bird_font_t_ ("Left");
	_tmp4_ = _tmp3_;
	_tmp5_ = double_to_string (l);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_t_ ("Set");
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_text_listener_new (_tmp4_, _tmp6_, _tmp8_);
	_g_object_unref0 (listener);
	listener = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp10_ = listener;
	g_signal_connect_data (_tmp10_, "signal-text-input", (GCallback) ___lambda234__bird_font_text_listener_signal_text_input, block59_data_ref (_data59_), (GClosureNotify) block59_data_unref, 0);
	_tmp11_ = listener;
	g_signal_connect_data (_tmp11_, "signal-submit", (GCallback) ___lambda235__bird_font_text_listener_signal_submit, block59_data_ref (_data59_), (GClosureNotify) block59_data_unref, 0);
	((BirdFontKerningDisplay*) self)->suppress_input = TRUE;
	((BirdFontKerningDisplay*) self)->text_input = TRUE;
	_tmp12_ = listener;
	bird_font_tab_content_show_text_input (_tmp12_);
	_g_object_unref0 (listener);
	block59_data_unref (_data59_);
	_data59_ = NULL;
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		BirdFontSpacingTab* self;
		self = _data60_->self;
		_g_free0 (_data60_->submitted_value);
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}

static void
__lambda236_ (Block60Data* _data60_,
              const gchar* text)
{
	BirdFontSpacingTab* self;
	gchar* _tmp0_;
	self = _data60_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data60_->submitted_value);
	_data60_->submitted_value = _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda236__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda236_ (self, text);
}

static void
__lambda237_ (Block60Data* _data60_)
{
	BirdFontSpacingTab* self;
	gdouble v = 0.0;
	const gchar* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	BirdFontGlyph* _tmp5_;
	BirdFontGlyph* _tmp6_;
	self = _data60_->self;
	bird_font_tab_content_hide_text_input ();
	((BirdFontKerningDisplay*) self)->text_input = FALSE;
	((BirdFontKerningDisplay*) self)->suppress_input = FALSE;
	_tmp0_ = _data60_->submitted_value;
	v = double_parse (_tmp0_);
	_tmp1_ = self->priv->text_input_glyph;
	_tmp2_ = self->priv->text_input_glyph;
	_tmp3_ = bird_font_glyph_get_right_limit (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->text_input_glyph;
	bird_font_glyph_set_right_limit (_tmp2_, _tmp4_ + (v - bird_font_glyph_get_right_side_bearing (_tmp5_)));
	_tmp6_ = self->priv->text_input_glyph;
	bird_font_glyph_update_other_spacing_classes (_tmp6_);
}

static void
___lambda237__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda237_ (self);
}

static void
bird_font_spacing_tab_update_rsb (BirdFontSpacingTab* self,
                                  BirdFontGlyph* g)
{
	Block60Data* _data60_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gdouble r = 0.0;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BirdFontTextListener* _tmp9_;
	BirdFontTextListener* _tmp10_;
	BirdFontTextListener* _tmp11_;
	BirdFontTextListener* _tmp12_;
	g_return_if_fail (self != NULL);
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_data60_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data60_->submitted_value = _tmp0_;
	if (g == NULL) {
		_g_object_unref0 (listener);
		block60_data_unref (_data60_);
		_data60_ = NULL;
		return;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (g, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	_g_object_unref0 (self->priv->text_input_glyph);
	self->priv->text_input_glyph = _tmp1_;
	_tmp2_ = self->priv->text_input_glyph;
	r = bird_font_glyph_get_right_side_bearing (_tmp2_);
	if (fabs (r) < 0.001) {
		r = (gdouble) 0;
	}
	_tmp3_ = bird_font_t_ ("Right");
	_tmp4_ = _tmp3_;
	_tmp5_ = double_to_string (r);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_t_ ("Set");
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_text_listener_new (_tmp4_, _tmp6_, _tmp8_);
	_g_object_unref0 (listener);
	listener = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp10_ = listener;
	g_signal_connect_data (_tmp10_, "signal-text-input", (GCallback) ___lambda236__bird_font_text_listener_signal_text_input, block60_data_ref (_data60_), (GClosureNotify) block60_data_unref, 0);
	_tmp11_ = listener;
	g_signal_connect_data (_tmp11_, "signal-submit", (GCallback) ___lambda237__bird_font_text_listener_signal_submit, block60_data_ref (_data60_), (GClosureNotify) block60_data_unref, 0);
	((BirdFontKerningDisplay*) self)->suppress_input = TRUE;
	((BirdFontKerningDisplay*) self)->text_input = TRUE;
	_tmp12_ = listener;
	bird_font_tab_content_show_text_input (_tmp12_);
	_g_object_unref0 (listener);
	block60_data_unref (_data60_);
	_data60_ = NULL;
}

static gboolean
bird_font_spacing_tab_real_needs_modifier (BirdFontFontDisplay* base)
{
	BirdFontSpacingTab * self;
	gboolean result;
	self = (BirdFontSpacingTab*) base;
	result = TRUE;
	return result;
}

static void
bird_font_spacing_tab_class_init (BirdFontSpacingTabClass * klass,
                                  gpointer klass_data)
{
	bird_font_spacing_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontSpacingTab_private_offset);
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_spacing_tab_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_spacing_tab_real_get_name;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_spacing_tab_real_draw;
	((BirdFontFontDisplayClass *) klass)->button_press = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_spacing_tab_real_button_press;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_spacing_tab_real_button_release;
	((BirdFontFontDisplayClass *) klass)->needs_modifier = (gboolean (*) (BirdFontFontDisplay*)) bird_font_spacing_tab_real_needs_modifier;
	G_OBJECT_CLASS (klass)->finalize = bird_font_spacing_tab_finalize;
}

static void
bird_font_spacing_tab_instance_init (BirdFontSpacingTab * self,
                                     gpointer klass)
{
	self->priv = bird_font_spacing_tab_get_instance_private (self);
	self->priv->box_size = (gdouble) 122;
	self->priv->height = (gdouble) 44;
	self->priv->character_height = (gdouble) 20;
}

static void
bird_font_spacing_tab_finalize (GObject * obj)
{
	BirdFontSpacingTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SPACING_TAB, BirdFontSpacingTab);
	_g_object_unref0 (self->priv->allocation);
	_g_object_unref0 (self->priv->text_input_glyph);
	G_OBJECT_CLASS (bird_font_spacing_tab_parent_class)->finalize (obj);
}

/** Kerning context. */
static GType
bird_font_spacing_tab_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSpacingTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_spacing_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSpacingTab), 0, (GInstanceInitFunc) bird_font_spacing_tab_instance_init, NULL };
	GType bird_font_spacing_tab_type_id;
	bird_font_spacing_tab_type_id = g_type_register_static (BIRD_FONT_TYPE_KERNING_DISPLAY, "BirdFontSpacingTab", &g_define_type_info, 0);
	BirdFontSpacingTab_private_offset = g_type_add_instance_private (bird_font_spacing_tab_type_id, sizeof (BirdFontSpacingTabPrivate));
	return bird_font_spacing_tab_type_id;
}

GType
bird_font_spacing_tab_get_type (void)
{
	static volatile gsize bird_font_spacing_tab_type_id__once = 0;
	if (g_once_init_enter (&bird_font_spacing_tab_type_id__once)) {
		GType bird_font_spacing_tab_type_id;
		bird_font_spacing_tab_type_id = bird_font_spacing_tab_get_type_once ();
		g_once_init_leave (&bird_font_spacing_tab_type_id__once, bird_font_spacing_tab_type_id);
	}
	return bird_font_spacing_tab_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

