/* SettingsDisplay.c generated by valac 0.56.16, the Vala compiler
 * generated from SettingsDisplay.vala, do not modify */

/*
Copyright (C) 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BIRD_FONT_TYPE_SETTINGS_DISPLAY (bird_font_settings_display_get_type ())
#define BIRD_FONT_SETTINGS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplay))
#define BIRD_FONT_SETTINGS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplayClass))
#define BIRD_FONT_IS_SETTINGS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY))
#define BIRD_FONT_IS_SETTINGS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BIRD_FONT_TYPE_SETTINGS_DISPLAY))
#define BIRD_FONT_SETTINGS_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplayClass))

typedef struct _BirdFontSettingsDisplay BirdFontSettingsDisplay;
typedef struct _BirdFontSettingsDisplayClass BirdFontSettingsDisplayClass;
typedef struct _BirdFontSettingsDisplayPrivate BirdFontSettingsDisplayPrivate;
enum  {
	BIRD_FONT_SETTINGS_DISPLAY_0_PROPERTY,
	BIRD_FONT_SETTINGS_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* bird_font_settings_display_properties[BIRD_FONT_SETTINGS_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontSettingsDisplay {
	BirdFontFontDisplay parent_instance;
	BirdFontSettingsDisplayPrivate * priv;
	GeeArrayList* tools;
};

struct _BirdFontSettingsDisplayClass {
	BirdFontFontDisplayClass parent_class;
	void (*create_setting_items) (BirdFontSettingsDisplay* self);
};

struct _BirdFontSettingsDisplayPrivate {
	gdouble scroll;
	gdouble content_height;
	BirdFontWidgetAllocation* allocation;
	BirdFontSettingsItem* new_key_bindings;
};

static gint BirdFontSettingsDisplay_private_offset;
static gpointer bird_font_settings_display_parent_class = NULL;
VALA_EXTERN BirdFontSpinButton* bird_font_settings_display_precision;
BirdFontSpinButton* bird_font_settings_display_precision = NULL;
VALA_EXTERN gboolean bird_font_settings_display_update_key_bindings;
gboolean bird_font_settings_display_update_key_bindings = FALSE;

VALA_EXTERN GType bird_font_settings_display_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void bird_font_settings_display_create_setting_items (BirdFontSettingsDisplay* self);
VALA_EXTERN BirdFontSettingsDisplay* bird_font_settings_display_construct (GType object_type);
static void bird_font_settings_display_real_create_setting_items (BirdFontSettingsDisplay* self);
static void bird_font_settings_display_real_draw (BirdFontFontDisplay* base,
                                           BirdFontWidgetAllocation* allocation,
                                           cairo_t* cr);
VALA_EXTERN void bird_font_settings_display_layout (BirdFontSettingsDisplay* self);
static void bird_font_settings_display_set_key_bindings (BirdFontSettingsDisplay* self,
                                                  BirdFontSettingsItem* item);
static void bird_font_settings_display_real_key_release (BirdFontFontDisplay* base,
                                                  guint keyval);
VALA_EXTERN gboolean bird_font_is_modifier_key (guint i);
static gboolean bird_font_settings_display_has_key_binding (BirdFontSettingsDisplay* self,
                                                     guint modifier,
                                                     gunichar key);
static BirdFontSettingsItem* bird_font_settings_display_get_key_binding (BirdFontSettingsDisplay* self,
                                                                  guint modifier,
                                                                  gunichar key);
static gboolean bird_font_settings_display_same_scope (BirdFontSettingsDisplay* self,
                                                BirdFontSettingsItem* key_binding1,
                                                BirdFontSettingsItem* key_binding2);
static void bird_font_settings_display_real_button_press (BirdFontFontDisplay* base,
                                                   guint button,
                                                   gdouble x,
                                                   gdouble y);
static void bird_font_settings_display_real_button_release (BirdFontFontDisplay* base,
                                                     gint button,
                                                     gdouble x,
                                                     gdouble y);
static void bird_font_settings_display_real_motion_notify (BirdFontFontDisplay* base,
                                                    gdouble x,
                                                    gdouble y);
static gchar* bird_font_settings_display_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_settings_display_real_get_name (BirdFontFontDisplay* base);
static gboolean bird_font_settings_display_real_has_scrollbar (BirdFontFontDisplay* base);
static void bird_font_settings_display_real_scroll_wheel (BirdFontFontDisplay* base,
                                                   gdouble x,
                                                   gdouble y,
                                                   gdouble pixeldelta,
                                                   gdouble dy);
static void bird_font_settings_display_real_selected_canvas (BirdFontFontDisplay* base);
static void bird_font_settings_display_real_update_scrollbar (BirdFontFontDisplay* base);
static void bird_font_settings_display_real_scroll_to (BirdFontFontDisplay* base,
                                                gdouble percent);
static void bird_font_settings_display_finalize (GObject * obj);
static GType bird_font_settings_display_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_settings_display_get_instance_private (BirdFontSettingsDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontSettingsDisplay_private_offset);
}

BirdFontSettingsDisplay*
bird_font_settings_display_construct (GType object_type)
{
	BirdFontSettingsDisplay * self = NULL;
	BirdFontWidgetAllocation* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontSpinButton* _tmp2_;
	self = (BirdFontSettingsDisplay*) bird_font_font_display_construct (object_type);
	_tmp0_ = bird_font_widget_allocation_new ();
	_g_object_unref0 (self->priv->allocation);
	self->priv->allocation = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_SETTINGS_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->tools);
	self->tools = _tmp1_;
	self->priv->content_height = (gdouble) 200;
	_tmp2_ = bird_font_spin_button_new ("precision", "");
	_g_object_unref0 (bird_font_settings_display_precision);
	bird_font_settings_display_precision = _tmp2_;
	return self;
}

static void
bird_font_settings_display_real_create_setting_items (BirdFontSettingsDisplay* self)
{
	g_critical ("Type `%s' does not implement abstract method `bird_font_settings_display_create_setting_items'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
bird_font_settings_display_create_setting_items (BirdFontSettingsDisplay* self)
{
	BirdFontSettingsDisplayClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_SETTINGS_DISPLAY_GET_CLASS (self);
	if (_klass_->create_setting_items) {
		_klass_->create_setting_items (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bird_font_settings_display_real_draw (BirdFontFontDisplay* base,
                                      BirdFontWidgetAllocation* allocation,
                                      cairo_t* cr)
{
	BirdFontSettingsDisplay * self;
	BirdFontWidgetAllocation* _tmp0_;
	self = (BirdFontSettingsDisplay*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = _g_object_ref0 (allocation);
	_g_object_unref0 (self->priv->allocation);
	self->priv->allocation = _tmp0_;
	bird_font_settings_display_layout (self);
	cairo_save (cr);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
	cairo_set_line_width (cr, (gdouble) 0);
	bird_font_theme_color (cr, "Default Background");
	cairo_fill (cr);
	cairo_stroke (cr);
	cairo_restore (cr);
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp1_;
		gint _s_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _s_index = 0;
		_tmp1_ = self->tools;
		_s_list = _tmp1_;
		_tmp2_ = _s_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_s_size = _tmp4_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontSettingsItem* s = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontSettingsItem* _tmp9_;
			gdouble _tmp10_;
			_s_index = _s_index + 1;
			_tmp5_ = _s_index;
			_tmp6_ = _s_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _s_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _s_index);
			s = (BirdFontSettingsItem*) _tmp8_;
			_tmp9_ = s;
			_tmp10_ = _tmp9_->y;
			if ((((gdouble) -20) <= _tmp10_) && (_tmp10_ <= ((gdouble) (allocation->height + 20)))) {
				BirdFontSettingsItem* _tmp11_;
				_tmp11_ = s;
				bird_font_settings_item_draw (_tmp11_, allocation, cr);
			}
			_g_object_unref0 (s);
		}
	}
}

void
bird_font_settings_display_layout (BirdFontSettingsDisplay* self)
{
	gdouble y = 0.0;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	y = -self->priv->scroll;
	first = TRUE;
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp0_;
		gint _s_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _s_index = 0;
		_tmp0_ = self->tools;
		_s_list = _tmp0_;
		_tmp1_ = _s_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_s_size = _tmp3_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontSettingsItem* s = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontSettingsItem* _tmp10_;
			BirdFontSettingsItem* _tmp11_;
			BirdFontTool* _tmp12_;
			BirdFontSettingsItem* _tmp17_;
			_s_index = _s_index + 1;
			_tmp4_ = _s_index;
			_tmp5_ = _s_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _s_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _s_index);
			s = (BirdFontSettingsItem*) _tmp7_;
			if (!first) {
				BirdFontSettingsItem* _tmp9_;
				_tmp9_ = s;
				_tmp8_ = _tmp9_->headline;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				y += (gdouble) 30;
			}
			_tmp10_ = s;
			_tmp10_->y = y;
			_tmp11_ = s;
			_tmp12_ = _tmp11_->button;
			if (_tmp12_ != NULL) {
				BirdFontSettingsItem* _tmp13_;
				BirdFontTool* _tmp14_;
				BirdFontSettingsItem* _tmp15_;
				BirdFontTool* _tmp16_;
				_tmp13_ = s;
				_tmp14_ = _tmp13_->button;
				G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_TOOL, BirdFontTool)->y = y;
				_tmp15_ = s;
				_tmp16_ = _tmp15_->button;
				G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, BIRD_FONT_TYPE_TOOL, BirdFontTool)->x = (gdouble) 20;
			}
			_tmp17_ = s;
			if (_tmp17_->headline) {
				y += (gdouble) 50;
			} else {
				y += (gdouble) 40;
			}
			first = FALSE;
			_g_object_unref0 (s);
		}
	}
	self->priv->content_height = y + self->priv->scroll;
}

static void
bird_font_settings_display_set_key_bindings (BirdFontSettingsDisplay* self,
                                             BirdFontSettingsItem* item)
{
	BirdFontSettingsItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->new_key_bindings;
	if (_tmp0_->active) {
		BirdFontSettingsItem* _tmp1_;
		_tmp1_ = self->priv->new_key_bindings;
		_tmp1_->active = FALSE;
		bird_font_settings_display_update_key_bindings = FALSE;
	} else {
		BirdFontSettingsItem* _tmp2_;
		BirdFontSettingsItem* _tmp3_;
		BirdFontSettingsItem* _tmp4_;
		_tmp2_ = self->priv->new_key_bindings;
		_tmp2_->active = FALSE;
		_tmp3_ = _g_object_ref0 (item);
		_g_object_unref0 (self->priv->new_key_bindings);
		self->priv->new_key_bindings = _tmp3_;
		bird_font_settings_display_update_key_bindings = TRUE;
		_tmp4_ = self->priv->new_key_bindings;
		_tmp4_->active = TRUE;
	}
}

static void
bird_font_settings_display_real_key_release (BirdFontFontDisplay* base,
                                             guint keyval)
{
	BirdFontSettingsDisplay * self;
	BirdFontSettingsItem* old_key_binding = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (BirdFontSettingsDisplay*) base;
	if (!bird_font_is_modifier_key (keyval)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = keyval == ((guint) BIRD_FONT_KEY_BACK_SPACE);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == ((guint) BIRD_FONT_KEY_DEL);
	}
	if (_tmp0_) {
		if (bird_font_settings_display_update_key_bindings) {
			gboolean _tmp2_ = FALSE;
			BirdFontAbstractMenu* _tmp20_;
			BirdFontAbstractMenu* _tmp21_;
			if (keyval == ((guint) BIRD_FONT_KEY_BACK_SPACE)) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = keyval == ((guint) BIRD_FONT_KEY_DEL);
			}
			if (_tmp2_) {
				BirdFontSettingsItem* _tmp3_;
				BirdFontSettingsItem* _tmp4_;
				BirdFontMenuItem* _tmp5_;
				BirdFontSettingsItem* _tmp6_;
				BirdFontMenuItem* _tmp7_;
				bird_font_settings_display_update_key_bindings = FALSE;
				_tmp3_ = self->priv->new_key_bindings;
				_tmp3_->active = FALSE;
				_tmp4_ = self->priv->new_key_bindings;
				_tmp5_ = _tmp4_->menu_item;
				_tmp5_->modifiers = BIRD_FONT_NONE;
				_tmp6_ = self->priv->new_key_bindings;
				_tmp7_ = _tmp6_->menu_item;
				_tmp7_->key = (gunichar) '\0';
			} else {
				if (bird_font_key_bindings_get_mod_from_key (keyval) == BIRD_FONT_NONE) {
					BirdFontSettingsItem* _tmp15_;
					BirdFontMenuItem* _tmp16_;
					BirdFontSettingsItem* _tmp17_;
					BirdFontMenuItem* _tmp18_;
					BirdFontSettingsItem* _tmp19_;
					if (bird_font_settings_display_has_key_binding (self, bird_font_key_bindings_modifier, (gunichar) keyval)) {
						BirdFontSettingsItem* _tmp8_;
						BirdFontSettingsItem* _tmp9_;
						BirdFontSettingsItem* _tmp10_;
						_tmp8_ = bird_font_settings_display_get_key_binding (self, bird_font_key_bindings_modifier, (gunichar) keyval);
						_g_object_unref0 (old_key_binding);
						old_key_binding = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_SETTINGS_ITEM, BirdFontSettingsItem);
						_tmp9_ = old_key_binding;
						_tmp10_ = self->priv->new_key_bindings;
						if (bird_font_settings_display_same_scope (self, _tmp9_, _tmp10_)) {
							BirdFontSettingsItem* _tmp11_;
							BirdFontMenuItem* _tmp12_;
							BirdFontSettingsItem* _tmp13_;
							BirdFontMenuItem* _tmp14_;
							_tmp11_ = old_key_binding;
							_tmp12_ = _tmp11_->menu_item;
							_tmp12_->modifiers = BIRD_FONT_NONE;
							_tmp13_ = old_key_binding;
							_tmp14_ = _tmp13_->menu_item;
							_tmp14_->key = (gunichar) '\0';
						}
					}
					_tmp15_ = self->priv->new_key_bindings;
					_tmp16_ = _tmp15_->menu_item;
					_tmp16_->modifiers = bird_font_key_bindings_modifier;
					_tmp17_ = self->priv->new_key_bindings;
					_tmp18_ = _tmp17_->menu_item;
					_tmp18_->key = (gunichar) keyval;
					bird_font_settings_display_update_key_bindings = FALSE;
					_tmp19_ = self->priv->new_key_bindings;
					_tmp19_->active = FALSE;
				}
			}
			_tmp20_ = bird_font_main_window_get_menu ();
			_tmp21_ = _tmp20_;
			bird_font_abstract_menu_write_key_bindings (_tmp21_);
			_g_object_unref0 (_tmp21_);
			bird_font_glyph_canvas_redraw ();
		}
	}
	_g_object_unref0 (old_key_binding);
}

/** Check if key binding is used in same tab. */
static gboolean
bird_font_settings_display_same_scope (BirdFontSettingsDisplay* self,
                                       BirdFontSettingsItem* key_binding1,
                                       BirdFontSettingsItem* key_binding2)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_binding1 != NULL, FALSE);
	g_return_val_if_fail (key_binding2 != NULL, FALSE);
	{
		GeeArrayList* _scope_list = NULL;
		BirdFontMenuItem* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _scope_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _scope_index = 0;
		_tmp0_ = key_binding1->menu_item;
		_tmp1_ = _tmp0_->displays;
		_scope_list = _tmp1_;
		_tmp2_ = _scope_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_scope_size = _tmp4_;
		_scope_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* scope = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontMenuItem* _tmp9_;
			const gchar* _tmp10_;
			_scope_index = _scope_index + 1;
			_tmp5_ = _scope_index;
			_tmp6_ = _scope_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _scope_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _scope_index);
			scope = (gchar*) _tmp8_;
			_tmp9_ = key_binding2->menu_item;
			_tmp10_ = scope;
			if (bird_font_menu_item_in_display (_tmp9_, _tmp10_)) {
				result = TRUE;
				_g_free0 (scope);
				return result;
			}
			_g_free0 (scope);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
bird_font_settings_display_has_key_binding (BirdFontSettingsDisplay* self,
                                            guint modifier,
                                            gunichar key)
{
	BirdFontSettingsItem* _tmp0_;
	BirdFontSettingsItem* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_settings_display_get_key_binding (self, modifier, key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static BirdFontSettingsItem*
bird_font_settings_display_get_key_binding (BirdFontSettingsDisplay* self,
                                            guint modifier,
                                            gunichar key)
{
	BirdFontSettingsItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp0_;
		gint _i_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _i_index = 0;
		_tmp0_ = self->tools;
		_i_list = _tmp0_;
		_tmp1_ = _i_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_i_size = _tmp3_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontSettingsItem* i = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontSettingsItem* _tmp9_;
			BirdFontMenuItem* _tmp10_;
			_i_index = _i_index + 1;
			_tmp4_ = _i_index;
			_tmp5_ = _i_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _i_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _i_index);
			i = (BirdFontSettingsItem*) _tmp7_;
			_tmp9_ = i;
			_tmp10_ = _tmp9_->menu_item;
			if (_tmp10_->modifiers == modifier) {
				BirdFontSettingsItem* _tmp11_;
				BirdFontMenuItem* _tmp12_;
				_tmp11_ = i;
				_tmp12_ = _tmp11_->menu_item;
				_tmp8_ = _tmp12_->key == key;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = i;
				return result;
			}
			_g_object_unref0 (i);
		}
	}
	result = NULL;
	return result;
}

static void
bird_font_settings_display_real_button_press (BirdFontFontDisplay* base,
                                              guint button,
                                              gdouble x,
                                              gdouble y)
{
	BirdFontSettingsDisplay * self;
	self = (BirdFontSettingsDisplay*) base;
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp0_;
		gint _s_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _s_index = 0;
		_tmp0_ = self->tools;
		_s_list = _tmp0_;
		_tmp1_ = _s_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_s_size = _tmp3_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontSettingsItem* s = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontSettingsItem* _tmp9_;
			_s_index = _s_index + 1;
			_tmp4_ = _s_index;
			_tmp5_ = _s_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _s_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _s_index);
			s = (BirdFontSettingsItem*) _tmp7_;
			_tmp9_ = s;
			if (_tmp9_->handle_events) {
				BirdFontSettingsItem* _tmp10_;
				BirdFontTool* _tmp11_;
				_tmp10_ = s;
				_tmp11_ = _tmp10_->button;
				_tmp8_ = _tmp11_ != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				BirdFontSettingsItem* _tmp12_;
				BirdFontTool* _tmp13_;
				_tmp12_ = s;
				_tmp13_ = _tmp12_->button;
				if (bird_font_tool_is_over (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_TOOL, BirdFontTool), x, y)) {
					BirdFontSettingsItem* _tmp14_;
					BirdFontTool* _tmp15_;
					BirdFontSettingsItem* _tmp16_;
					BirdFontTool* _tmp17_;
					BirdFontSettingsItem* _tmp18_;
					BirdFontTool* _tmp19_;
					BirdFontSettingsItem* _tmp24_;
					BirdFontTool* _tmp25_;
					BirdFontSettingsItem* _tmp26_;
					BirdFontTool* _tmp27_;
					_tmp14_ = s;
					_tmp15_ = _tmp14_->button;
					_tmp16_ = s;
					_tmp17_ = _tmp16_->button;
					bird_font_tool_set_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, BIRD_FONT_TYPE_TOOL, BirdFontTool), !G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_TOOL, BirdFontTool)->selected);
					_tmp18_ = s;
					_tmp19_ = _tmp18_->button;
					if (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, BIRD_FONT_TYPE_TOOL, BirdFontTool)->selected) {
						BirdFontSettingsItem* _tmp20_;
						BirdFontTool* _tmp21_;
						BirdFontSettingsItem* _tmp22_;
						BirdFontTool* _tmp23_;
						_tmp20_ = s;
						_tmp21_ = _tmp20_->button;
						_tmp22_ = s;
						_tmp23_ = _tmp22_->button;
						g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "select-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, BIRD_FONT_TYPE_TOOL, BirdFontTool));
					}
					_tmp24_ = s;
					_tmp25_ = _tmp24_->button;
					_tmp26_ = s;
					_tmp27_ = _tmp26_->button;
					g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "panel-press-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, BIRD_FONT_TYPE_TOOL, BirdFontTool), button, x, y);
				}
			}
			_g_object_unref0 (s);
		}
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_settings_display_real_button_release (BirdFontFontDisplay* base,
                                                gint button,
                                                gdouble x,
                                                gdouble y)
{
	BirdFontSettingsDisplay * self;
	self = (BirdFontSettingsDisplay*) base;
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp0_;
		gint _s_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _s_index = 0;
		_tmp0_ = self->tools;
		_s_list = _tmp0_;
		_tmp1_ = _s_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_s_size = _tmp3_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontSettingsItem* s = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontSettingsItem* _tmp9_;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_ = FALSE;
			BirdFontSettingsItem* _tmp18_;
			_s_index = _s_index + 1;
			_tmp4_ = _s_index;
			_tmp5_ = _s_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _s_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _s_index);
			s = (BirdFontSettingsItem*) _tmp7_;
			_tmp9_ = s;
			if (_tmp9_->handle_events) {
				BirdFontSettingsItem* _tmp10_;
				BirdFontTool* _tmp11_;
				_tmp10_ = s;
				_tmp11_ = _tmp10_->button;
				_tmp8_ = _tmp11_ != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				BirdFontSettingsItem* _tmp12_;
				BirdFontTool* _tmp13_;
				BirdFontSettingsItem* _tmp14_;
				BirdFontTool* _tmp15_;
				_tmp12_ = s;
				_tmp13_ = _tmp12_->button;
				_tmp14_ = s;
				_tmp15_ = _tmp14_->button;
				g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "panel-release-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, BIRD_FONT_TYPE_TOOL, BirdFontTool), (guint) button, x, y);
			}
			_tmp18_ = s;
			if (_tmp18_->key_bindings) {
				BirdFontSettingsItem* _tmp19_;
				BirdFontSettingsItem* _tmp20_;
				gdouble _tmp21_;
				_tmp19_ = s;
				_tmp20_ = s;
				_tmp21_ = y;
				_tmp17_ = (_tmp19_->y <= _tmp21_) && (_tmp21_ < (_tmp20_->y + 40));
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				_tmp16_ = button == 1;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				BirdFontSettingsItem* _tmp22_;
				_tmp22_ = s;
				bird_font_settings_display_set_key_bindings (self, _tmp22_);
			}
			_g_object_unref0 (s);
		}
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_settings_display_real_motion_notify (BirdFontFontDisplay* base,
                                               gdouble x,
                                               gdouble y)
{
	BirdFontSettingsDisplay * self;
	gboolean consumed = FALSE;
	gboolean active = FALSE;
	gboolean update = FALSE;
	gboolean _tmp40_ = FALSE;
	self = (BirdFontSettingsDisplay*) base;
	consumed = FALSE;
	update = FALSE;
	{
		GeeArrayList* _si_list = NULL;
		GeeArrayList* _tmp0_;
		gint _si_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _si_index = 0;
		_tmp0_ = self->tools;
		_si_list = _tmp0_;
		_tmp1_ = _si_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_si_size = _tmp3_;
		_si_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontSettingsItem* si = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			BirdFontSettingsItem* _tmp9_;
			_si_index = _si_index + 1;
			_tmp4_ = _si_index;
			_tmp5_ = _si_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _si_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _si_index);
			si = (BirdFontSettingsItem*) _tmp7_;
			_tmp9_ = si;
			if (_tmp9_->handle_events) {
				BirdFontSettingsItem* _tmp10_;
				BirdFontTool* _tmp11_;
				_tmp10_ = si;
				_tmp11_ = _tmp10_->button;
				_tmp8_ = _tmp11_ != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				BirdFontSettingsItem* _tmp12_;
				BirdFontTool* _tmp13_;
				gboolean _tmp14_ = FALSE;
				BirdFontSettingsItem* _tmp21_;
				BirdFontTool* _tmp22_;
				_tmp12_ = si;
				_tmp13_ = _tmp12_->button;
				active = bird_font_tool_is_over (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_TOOL, BirdFontTool), x, y);
				if (!active) {
					BirdFontSettingsItem* _tmp15_;
					BirdFontTool* _tmp16_;
					_tmp15_ = si;
					_tmp16_ = _tmp15_->button;
					_tmp14_ = bird_font_tool_is_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, BIRD_FONT_TYPE_TOOL, BirdFontTool));
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					BirdFontSettingsItem* _tmp17_;
					BirdFontTool* _tmp18_;
					BirdFontSettingsItem* _tmp19_;
					BirdFontTool* _tmp20_;
					_tmp17_ = si;
					_tmp18_ = _tmp17_->button;
					_tmp19_ = si;
					_tmp20_ = _tmp19_->button;
					g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "move-out-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, BIRD_FONT_TYPE_TOOL, BirdFontTool));
				}
				_tmp21_ = si;
				_tmp22_ = _tmp21_->button;
				if (bird_font_tool_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_TOOL, BirdFontTool), active)) {
					update = TRUE;
				}
			}
			_g_object_unref0 (si);
		}
	}
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp23_;
		gint _s_size = 0;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _s_index = 0;
		_tmp23_ = self->tools;
		_s_list = _tmp23_;
		_tmp24_ = _s_list;
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_s_size = _tmp26_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			BirdFontSettingsItem* s = NULL;
			GeeArrayList* _tmp29_;
			gpointer _tmp30_;
			gboolean _tmp31_ = FALSE;
			BirdFontSettingsItem* _tmp32_;
			_s_index = _s_index + 1;
			_tmp27_ = _s_index;
			_tmp28_ = _s_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _s_list;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _s_index);
			s = (BirdFontSettingsItem*) _tmp30_;
			_tmp32_ = s;
			if (_tmp32_->handle_events) {
				BirdFontSettingsItem* _tmp33_;
				BirdFontTool* _tmp34_;
				_tmp33_ = s;
				_tmp34_ = _tmp33_->button;
				_tmp31_ = _tmp34_ != NULL;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				BirdFontSettingsItem* _tmp35_;
				BirdFontTool* _tmp36_;
				BirdFontSettingsItem* _tmp37_;
				BirdFontTool* _tmp38_;
				gboolean _tmp39_ = FALSE;
				_tmp35_ = s;
				_tmp36_ = _tmp35_->button;
				_tmp37_ = s;
				_tmp38_ = _tmp37_->button;
				g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "panel-move-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, BIRD_FONT_TYPE_TOOL, BirdFontTool), x, y, &_tmp39_);
				if (_tmp39_) {
					consumed = TRUE;
				}
			}
			_g_object_unref0 (s);
		}
	}
	if (consumed) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = update;
	}
	if (_tmp40_) {
		bird_font_glyph_canvas_redraw ();
	}
}

static gchar*
bird_font_settings_display_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontSettingsDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontSettingsDisplay*) base;
	_tmp0_ = bird_font_t_ ("Settings");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_settings_display_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontSettingsDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontSettingsDisplay*) base;
	_tmp0_ = g_strdup ("Settings");
	result = _tmp0_;
	return result;
}

static gboolean
bird_font_settings_display_real_has_scrollbar (BirdFontFontDisplay* base)
{
	BirdFontSettingsDisplay * self;
	gboolean result;
	self = (BirdFontSettingsDisplay*) base;
	result = TRUE;
	return result;
}

static void
bird_font_settings_display_real_scroll_wheel (BirdFontFontDisplay* base,
                                              gdouble x,
                                              gdouble y,
                                              gdouble pixeldelta,
                                              gdouble dy)
{
	BirdFontSettingsDisplay * self;
	BirdFontWidgetAllocation* _tmp38_;
	self = (BirdFontSettingsDisplay*) base;
	if (dy < ((gdouble) 0)) {
		{
			GeeArrayList* _s_list = NULL;
			GeeArrayList* _tmp0_;
			gint _s_size = 0;
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _s_index = 0;
			_tmp0_ = self->tools;
			_s_list = _tmp0_;
			_tmp1_ = _s_list;
			_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_s_size = _tmp3_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				BirdFontSettingsItem* s = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				gboolean _tmp8_ = FALSE;
				BirdFontSettingsItem* _tmp9_;
				_s_index = _s_index + 1;
				_tmp4_ = _s_index;
				_tmp5_ = _s_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _s_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _s_index);
				s = (BirdFontSettingsItem*) _tmp7_;
				_tmp9_ = s;
				if (_tmp9_->handle_events) {
					BirdFontSettingsItem* _tmp10_;
					BirdFontTool* _tmp11_;
					_tmp10_ = s;
					_tmp11_ = _tmp10_->button;
					_tmp8_ = _tmp11_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					BirdFontSettingsItem* _tmp12_;
					BirdFontTool* _tmp13_;
					_tmp12_ = s;
					_tmp13_ = _tmp12_->button;
					if (bird_font_tool_is_over (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_TOOL, BirdFontTool), x, y)) {
						BirdFontSettingsItem* _tmp14_;
						BirdFontTool* _tmp15_;
						BirdFontSettingsItem* _tmp16_;
						BirdFontTool* _tmp17_;
						gboolean _tmp18_ = FALSE;
						_tmp14_ = s;
						_tmp15_ = _tmp14_->button;
						_tmp16_ = s;
						_tmp17_ = _tmp16_->button;
						g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "scroll-wheel-down-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_TOOL, BirdFontTool), &_tmp18_);
						_g_object_unref0 (s);
						return;
					}
				}
				_g_object_unref0 (s);
			}
		}
	} else {
		{
			GeeArrayList* _s_list = NULL;
			GeeArrayList* _tmp19_;
			gint _s_size = 0;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _s_index = 0;
			_tmp19_ = self->tools;
			_s_list = _tmp19_;
			_tmp20_ = _s_list;
			_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_s_size = _tmp22_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp23_;
				gint _tmp24_;
				BirdFontSettingsItem* s = NULL;
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				gboolean _tmp27_ = FALSE;
				BirdFontSettingsItem* _tmp28_;
				_s_index = _s_index + 1;
				_tmp23_ = _s_index;
				_tmp24_ = _s_size;
				if (!(_tmp23_ < _tmp24_)) {
					break;
				}
				_tmp25_ = _s_list;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _s_index);
				s = (BirdFontSettingsItem*) _tmp26_;
				_tmp28_ = s;
				if (_tmp28_->handle_events) {
					BirdFontSettingsItem* _tmp29_;
					BirdFontTool* _tmp30_;
					_tmp29_ = s;
					_tmp30_ = _tmp29_->button;
					_tmp27_ = _tmp30_ != NULL;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					BirdFontSettingsItem* _tmp31_;
					BirdFontTool* _tmp32_;
					_tmp31_ = s;
					_tmp32_ = _tmp31_->button;
					if (bird_font_tool_is_over (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, BIRD_FONT_TYPE_TOOL, BirdFontTool), x, y)) {
						BirdFontSettingsItem* _tmp33_;
						BirdFontTool* _tmp34_;
						BirdFontSettingsItem* _tmp35_;
						BirdFontTool* _tmp36_;
						gboolean _tmp37_ = FALSE;
						_tmp33_ = s;
						_tmp34_ = _tmp33_->button;
						_tmp35_ = s;
						_tmp36_ = _tmp35_->button;
						g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_TOOL, BirdFontTool), "scroll-wheel-up-action", G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, BIRD_FONT_TYPE_TOOL, BirdFontTool), &_tmp37_);
						_g_object_unref0 (s);
						return;
					}
				}
				_g_object_unref0 (s);
			}
		}
	}
	self->priv->scroll = self->priv->scroll - dy;
	_tmp38_ = self->priv->allocation;
	if ((self->priv->scroll + _tmp38_->height) >= self->priv->content_height) {
		BirdFontWidgetAllocation* _tmp39_;
		_tmp39_ = self->priv->allocation;
		self->priv->scroll = self->priv->content_height - _tmp39_->height;
	}
	if (self->priv->scroll < ((gdouble) 0)) {
		self->priv->scroll = (gdouble) 0;
	}
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_settings_display_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontSettingsDisplay * self;
	BirdFontToolbox* _tmp0_;
	BirdFontToolbox* _tmp1_;
	self = (BirdFontSettingsDisplay*) base;
	_tmp0_ = bird_font_main_window_get_toolbox ();
	_tmp1_ = _tmp0_;
	bird_font_toolbox_set_default_tool_size (_tmp1_);
	_g_object_unref0 (_tmp1_);
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_settings_display_real_update_scrollbar (BirdFontFontDisplay* base)
{
	BirdFontSettingsDisplay * self;
	gdouble h = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontSettingsDisplay*) base;
	_tmp0_ = self->priv->allocation;
	h = self->priv->content_height - _tmp0_->height;
	_tmp1_ = self->priv->allocation;
	bird_font_main_window_set_scrollbar_size (_tmp1_->height / self->priv->content_height);
	bird_font_main_window_set_scrollbar_position (self->priv->scroll / h);
}

static void
bird_font_settings_display_real_scroll_to (BirdFontFontDisplay* base,
                                           gdouble percent)
{
	BirdFontSettingsDisplay * self;
	gdouble h = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	self = (BirdFontSettingsDisplay*) base;
	_tmp0_ = self->priv->allocation;
	h = self->priv->content_height - _tmp0_->height;
	self->priv->scroll = percent * h;
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_settings_display_class_init (BirdFontSettingsDisplayClass * klass,
                                       gpointer klass_data)
{
	bird_font_settings_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontSettingsDisplay_private_offset);
	((BirdFontSettingsDisplayClass *) klass)->create_setting_items = (void (*) (BirdFontSettingsDisplay*)) bird_font_settings_display_real_create_setting_items;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_settings_display_real_draw;
	((BirdFontFontDisplayClass *) klass)->key_release = (void (*) (BirdFontFontDisplay*, guint)) bird_font_settings_display_real_key_release;
	((BirdFontFontDisplayClass *) klass)->button_press = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_settings_display_real_button_press;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_settings_display_real_button_release;
	((BirdFontFontDisplayClass *) klass)->motion_notify = (void (*) (BirdFontFontDisplay*, gdouble, gdouble)) bird_font_settings_display_real_motion_notify;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_settings_display_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_settings_display_real_get_name;
	((BirdFontFontDisplayClass *) klass)->has_scrollbar = (gboolean (*) (BirdFontFontDisplay*)) bird_font_settings_display_real_has_scrollbar;
	((BirdFontFontDisplayClass *) klass)->scroll_wheel = (void (*) (BirdFontFontDisplay*, gdouble, gdouble, gdouble, gdouble)) bird_font_settings_display_real_scroll_wheel;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_settings_display_real_selected_canvas;
	((BirdFontFontDisplayClass *) klass)->update_scrollbar = (void (*) (BirdFontFontDisplay*)) bird_font_settings_display_real_update_scrollbar;
	((BirdFontFontDisplayClass *) klass)->scroll_to = (void (*) (BirdFontFontDisplay*, gdouble)) bird_font_settings_display_real_scroll_to;
	G_OBJECT_CLASS (klass)->finalize = bird_font_settings_display_finalize;
}

static void
bird_font_settings_display_instance_init (BirdFontSettingsDisplay * self,
                                          gpointer klass)
{
	BirdFontSettingsItem* _tmp0_;
	self->priv = bird_font_settings_display_get_instance_private (self);
	self->priv->scroll = (gdouble) 0;
	self->priv->content_height = (gdouble) 1;
	_tmp0_ = bird_font_settings_item_new_head_line ("");
	self->priv->new_key_bindings = _tmp0_;
}

static void
bird_font_settings_display_finalize (GObject * obj)
{
	BirdFontSettingsDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SETTINGS_DISPLAY, BirdFontSettingsDisplay);
	_g_object_unref0 (self->priv->allocation);
	_g_object_unref0 (self->tools);
	_g_object_unref0 (self->priv->new_key_bindings);
	G_OBJECT_CLASS (bird_font_settings_display_parent_class)->finalize (obj);
}

static GType
bird_font_settings_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontSettingsDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_settings_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontSettingsDisplay), 0, (GInstanceInitFunc) bird_font_settings_display_instance_init, NULL };
	GType bird_font_settings_display_type_id;
	bird_font_settings_display_type_id = g_type_register_static (BIRD_FONT_TYPE_FONT_DISPLAY, "BirdFontSettingsDisplay", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	BirdFontSettingsDisplay_private_offset = g_type_add_instance_private (bird_font_settings_display_type_id, sizeof (BirdFontSettingsDisplayPrivate));
	return bird_font_settings_display_type_id;
}

GType
bird_font_settings_display_get_type (void)
{
	static volatile gsize bird_font_settings_display_type_id__once = 0;
	if (g_once_init_enter (&bird_font_settings_display_type_id__once)) {
		GType bird_font_settings_display_type_id;
		bird_font_settings_display_type_id = bird_font_settings_display_get_type_once ();
		g_once_init_leave (&bird_font_settings_display_type_id__once, bird_font_settings_display_type_id);
	}
	return bird_font_settings_display_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

