/* ResizeTool.c generated by valac 0.56.16, the Vala compiler
 * generated from ResizeTool.vala, do not modify */

/*
Copyright (C) 2013 2015 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_RESIZE_TOOL_0_PROPERTY,
	BIRD_FONT_RESIZE_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_resize_tool_properties[BIRD_FONT_RESIZE_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BIRD_FONT_RESIZE_TOOL_OBJECTS_ROTATED_SIGNAL,
	BIRD_FONT_RESIZE_TOOL_OBJECTS_RESIZED_SIGNAL,
	BIRD_FONT_RESIZE_TOOL_NUM_SIGNALS
};
static guint bird_font_resize_tool_signals[BIRD_FONT_RESIZE_TOOL_NUM_SIGNALS] = {0};

struct _BirdFontResizeToolPrivate {
	gboolean resize_path_proportional;
	gboolean resize_width;
	BirdFontPath* resized_path;
	gdouble last_resize_y;
	gdouble last_resize_x;
	gboolean move_paths;
	BirdFontText* proportional_handle;
	BirdFontText* horizontal_handle;
};

static gint BirdFontResizeTool_private_offset;
static gpointer bird_font_resize_tool_parent_class = NULL;
static gdouble bird_font_resize_tool_selection_box_width;
static gdouble bird_font_resize_tool_selection_box_width = (gdouble) 0;
static gdouble bird_font_resize_tool_selection_box_height;
static gdouble bird_font_resize_tool_selection_box_height = (gdouble) 0;
static gdouble bird_font_resize_tool_selection_box_center_x;
static gdouble bird_font_resize_tool_selection_box_center_x = (gdouble) 0;
static gdouble bird_font_resize_tool_selection_box_center_y;
static gdouble bird_font_resize_tool_selection_box_center_y = (gdouble) 0;
static gboolean bird_font_resize_tool_rotate_path;
static gboolean bird_font_resize_tool_rotate_path = FALSE;
static gdouble bird_font_resize_tool_last_rotate_y;
static gdouble bird_font_resize_tool_last_rotate_y = 0.0;
static gdouble bird_font_resize_tool_rotation;
static gdouble bird_font_resize_tool_rotation = (gdouble) 0;
static gdouble bird_font_resize_tool_last_rotate;
static gdouble bird_font_resize_tool_last_rotate = (gdouble) 0;

static void __lambda106_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_);
static void ___lambda106__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda107_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_);
static void ___lambda107__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   gpointer self);
static void __lambda108_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static gboolean bird_font_resize_tool_is_over_resize_handle (BirdFontResizeTool* self,
                                                      BirdFontPath* p,
                                                      gdouble x,
                                                      gdouble y);
static gboolean bird_font_resize_tool_is_over_horizontal_resize_handle (BirdFontResizeTool* self,
                                                                 BirdFontPath* p,
                                                                 gdouble x,
                                                                 gdouble y);
static gboolean bird_font_resize_tool_is_over_rotate_handle (BirdFontPath* p,
                                                      gdouble x,
                                                      gdouble y);
static void bird_font_resize_tool_update_selection_box (BirdFontResizeTool* self);
static void ___lambda108__bird_font_tool_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gint button,
                                                gint x,
                                                gint y,
                                                gpointer self);
static void __lambda109_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static void ___lambda109__bird_font_tool_release_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  gint button,
                                                  gint x,
                                                  gint y,
                                                  gpointer self);
static void __lambda111_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_,
                   gint x,
                   gint y);
static gboolean bird_font_resize_tool_can_resize (BirdFontResizeTool* self,
                                           gdouble x,
                                           gdouble y);
static void bird_font_resize_tool_resize_proportional (BirdFontResizeTool* self,
                                                gdouble px,
                                                gdouble py);
static void bird_font_resize_tool_resize_horizontal (BirdFontResizeTool* self,
                                              gdouble px,
                                              gdouble py);
static void bird_font_resize_tool_rotate (BirdFontResizeTool* self,
                                   gdouble x,
                                   gdouble y);
static void ___lambda111__bird_font_tool_move_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda112_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_,
                   cairo_t* cr,
                   BirdFontGlyph* glyph);
static void bird_font_resize_tool_draw_rotate_handle (cairo_t* cr);
static void ___lambda112__bird_font_tool_draw_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               cairo_t* cr,
                                               BirdFontGlyph* glyph,
                                               gpointer self);
static void __lambda113_ (BirdFontResizeTool* self,
                   BirdFontTool* _self_,
                   guint32 keyval);
static void ___lambda113__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                                    BirdFontTool* selected,
                                                    guint32 keyval,
                                                    gpointer self);
static gdouble bird_font_resize_tool_get_resize_ratio (BirdFontResizeTool* self,
                                                gdouble px,
                                                gdouble py);
static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void bird_font_resize_tool_finalize (GObject * obj);
static GType bird_font_resize_tool_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_resize_tool_get_instance_private (BirdFontResizeTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontResizeTool_private_offset);
}

static void
__lambda106_ (BirdFontResizeTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda106__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda106_ ((BirdFontResizeTool*) self, selected);
}

static void
__lambda107_ (BirdFontResizeTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda107__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gpointer self)
{
	__lambda107_ ((BirdFontResizeTool*) self, selected);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda108_ (BirdFontResizeTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	BirdFontPath* last_path = NULL;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp27_;
	GeeArrayList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (glyph);
	glyph = _tmp0_;
	_tmp1_ = glyph;
	bird_font_glyph_store_undo_state (_tmp1_, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = glyph;
		_tmp3_ = _tmp2_->active_paths;
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp14_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = p;
			if (bird_font_resize_tool_is_over_resize_handle (self, _tmp11_, (gdouble) x, (gdouble) y)) {
				BirdFontPath* _tmp12_;
				BirdFontPath* _tmp13_;
				self->priv->resize_path_proportional = TRUE;
				_tmp12_ = p;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_g_object_unref0 (self->priv->resized_path);
				self->priv->resized_path = _tmp13_;
				self->priv->last_resize_x = (gdouble) x;
				self->priv->last_resize_y = (gdouble) y;
				_g_object_unref0 (p);
				_g_object_unref0 (glyph);
				_g_object_unref0 (last_path);
				return;
			}
			_tmp14_ = p;
			if (bird_font_resize_tool_is_over_horizontal_resize_handle (self, _tmp14_, (gdouble) x, (gdouble) y)) {
				BirdFontPath* _tmp15_;
				BirdFontPath* _tmp16_;
				self->priv->resize_width = TRUE;
				_tmp15_ = p;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (self->priv->resized_path);
				self->priv->resized_path = _tmp16_;
				self->priv->last_resize_x = (gdouble) x;
				self->priv->last_resize_y = (gdouble) y;
				_g_object_unref0 (p);
				_g_object_unref0 (glyph);
				_g_object_unref0 (last_path);
				return;
			}
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _p_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _p_index = 0;
		_tmp17_ = glyph;
		_tmp18_ = _tmp17_->active_paths;
		_p_list = _tmp18_;
		_tmp19_ = _p_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_p_size = _tmp21_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			BirdFontPath* _tmp26_;
			_p_index = _p_index + 1;
			_tmp22_ = _p_index;
			_tmp23_ = _p_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _p_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _p_index);
			p = (BirdFontPath*) _tmp25_;
			_tmp26_ = p;
			if (bird_font_resize_tool_is_over_rotate_handle (_tmp26_, (gdouble) x, (gdouble) y)) {
				bird_font_resize_tool_rotate_path = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (glyph);
				_g_object_unref0 (last_path);
				return;
			}
			_g_object_unref0 (p);
		}
	}
	_tmp27_ = glyph;
	_tmp28_ = _tmp27_->active_paths;
	_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ > 0) {
		BirdFontGlyph* _tmp31_;
		GeeArrayList* _tmp32_;
		BirdFontGlyph* _tmp33_;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gpointer _tmp37_;
		BirdFontPath* _tmp38_;
		_tmp31_ = glyph;
		_tmp32_ = _tmp31_->active_paths;
		_tmp33_ = glyph;
		_tmp34_ = _tmp33_->active_paths;
		_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp36_ - 1);
		_g_object_unref0 (last_path);
		last_path = (BirdFontPath*) _tmp37_;
		_tmp38_ = last_path;
		bird_font_resize_tool_last_rotate = _tmp38_->rotation;
	}
	bird_font_resize_tool_rotation = bird_font_resize_tool_last_rotate;
	self->priv->last_resize_x = (gdouble) x;
	bird_font_resize_tool_last_rotate_y = (gdouble) y;
	if (!self->priv->resize_path_proportional) {
		_tmp40_ = !self->priv->resize_width;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		_tmp39_ = !bird_font_resize_tool_rotate_path;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		BirdFontMoveTool* _tmp41_;
		BirdFontMoveTool* _tmp42_;
		_tmp41_ = bird_font_drawing_tools_get_move_tool ();
		_tmp42_ = _tmp41_;
		bird_font_move_tool_press (_tmp42_, b, x, y);
	}
	self->priv->move_paths = TRUE;
	bird_font_resize_tool_update_selection_box (self);
	_g_object_unref0 (glyph);
	_g_object_unref0 (last_path);
}

static void
___lambda108__bird_font_tool_press_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gint button,
                                           gint x,
                                           gint y,
                                           gpointer self)
{
	__lambda108_ ((BirdFontResizeTool*) self, selected, button, x, y);
}

static void
__lambda109_ (BirdFontResizeTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	BirdFontMoveTool* _tmp0_;
	BirdFontMoveTool* _tmp1_;
	g_return_if_fail (_self_ != NULL);
	self->priv->resize_path_proportional = FALSE;
	self->priv->resize_width = FALSE;
	bird_font_resize_tool_rotate_path = FALSE;
	self->priv->move_paths = FALSE;
	_tmp0_ = bird_font_drawing_tools_get_move_tool ();
	_tmp1_ = _tmp0_;
	bird_font_move_tool_release (_tmp1_, b, x, y);
	bird_font_resize_tool_update_selection_box (self);
	bird_font_glyph_canvas_redraw ();
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		BirdFontGlyph* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _p_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _p_index = 0;
		_tmp2_ = bird_font_main_window_get_current_glyph ();
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->active_paths;
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_p_list = _tmp5_;
		_tmp6_ = _p_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_p_size = _tmp8_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontPath* _tmp13_;
			_p_index = _p_index + 1;
			_tmp9_ = _p_index;
			_tmp10_ = _p_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _p_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _p_index);
			p = (BirdFontPath*) _tmp12_;
			_tmp13_ = p;
			bird_font_path_create_full_stroke (_tmp13_);
			_g_object_unref0 (p);
		}
	}
}

static void
___lambda109__bird_font_tool_release_action (BirdFontTool* _sender,
                                             BirdFontTool* selected,
                                             gint button,
                                             gint x,
                                             gint y,
                                             gpointer self)
{
	__lambda109_ ((BirdFontResizeTool*) self, selected, button, x, y);
}

static void
__lambda111_ (BirdFontResizeTool* self,
              BirdFontTool* _self_,
              gint x,
              gint y)
{
	BirdFontGlyph* glyph = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	BirdFontMoveTool* _tmp16_;
	BirdFontMoveTool* _tmp17_;
	g_return_if_fail (_self_ != NULL);
	if (self->priv->resize_path_proportional) {
		_tmp0_ = bird_font_resize_tool_can_resize (self, (gdouble) x, (gdouble) y);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_resize_tool_resize_proportional (self, (gdouble) x, (gdouble) y);
		bird_font_resize_tool_update_selection_box (self);
	}
	if (self->priv->resize_width) {
		_tmp1_ = bird_font_resize_tool_can_resize (self, (gdouble) x, (gdouble) y);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		bird_font_resize_tool_resize_horizontal (self, (gdouble) x, (gdouble) y);
		bird_font_resize_tool_update_selection_box (self);
	}
	if (bird_font_resize_tool_rotate_path) {
		bird_font_resize_tool_rotate (self, (gdouble) x, (gdouble) y);
		bird_font_resize_tool_update_selection_box (self);
	}
	if (self->priv->move_paths) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = bird_font_resize_tool_rotate_path;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->resize_path_proportional;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->resize_width;
	}
	if (_tmp2_) {
		BirdFontGlyph* _tmp5_;
		_tmp5_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (glyph);
		glyph = _tmp5_;
		{
			GeeArrayList* _selected_path_list = NULL;
			BirdFontGlyph* _tmp6_;
			GeeArrayList* _tmp7_;
			gint _selected_path_size = 0;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _selected_path_index = 0;
			_tmp6_ = glyph;
			_tmp7_ = _tmp6_->active_paths;
			_selected_path_list = _tmp7_;
			_tmp8_ = _selected_path_list;
			_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_selected_path_size = _tmp10_;
			_selected_path_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				BirdFontPath* selected_path = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				BirdFontPath* _tmp15_;
				_selected_path_index = _selected_path_index + 1;
				_tmp11_ = _selected_path_index;
				_tmp12_ = _selected_path_size;
				if (!(_tmp11_ < _tmp12_)) {
					break;
				}
				_tmp13_ = _selected_path_list;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _selected_path_index);
				selected_path = (BirdFontPath*) _tmp14_;
				_tmp15_ = selected_path;
				bird_font_path_reset_stroke (_tmp15_);
				_g_object_unref0 (selected_path);
			}
		}
		bird_font_glyph_canvas_redraw ();
	}
	_tmp16_ = bird_font_drawing_tools_get_move_tool ();
	_tmp17_ = _tmp16_;
	bird_font_move_tool_move (_tmp17_, x, y);
	_g_object_unref0 (glyph);
}

static void
___lambda111__bird_font_tool_move_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda111_ ((BirdFontResizeTool*) self, selected, x, y);
}

static void
__lambda112_ (BirdFontResizeTool* self,
              BirdFontTool* _self_,
              cairo_t* cr,
              BirdFontGlyph* glyph)
{
	BirdFontText* handle = NULL;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	if (!bird_font_resize_tool_rotate_path) {
		if (!self->priv->resize_width) {
			BirdFontText* _tmp1_;
			BirdFontText* _tmp2_;
			BirdFontText* _tmp3_;
			BirdFontText* _tmp4_;
			gdouble _tmp5_ = 0.0;
			gdouble _tmp6_ = 0.0;
			BirdFontText* _tmp7_;
			BirdFontText* _tmp8_;
			BirdFontText* _tmp9_;
			BirdFontText* _tmp10_;
			BirdFontText* _tmp11_;
			BirdFontText* _tmp12_;
			BirdFontText* _tmp13_;
			_tmp1_ = self->priv->proportional_handle;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_g_object_unref0 (handle);
			handle = _tmp2_;
			_tmp3_ = handle;
			_tmp4_ = handle;
			bird_font_resize_tool_get_resize_handle_position (&_tmp5_, &_tmp6_);
			((BirdFontWidget*) _tmp3_)->widget_x = _tmp5_;
			((BirdFontWidget*) _tmp4_)->widget_y = _tmp6_;
			_tmp7_ = handle;
			_tmp8_ = handle;
			_tmp9_ = handle;
			((BirdFontWidget*) _tmp8_)->widget_x = ((BirdFontWidget*) _tmp8_)->widget_x - (bird_font_text_get_sidebearing_extent (_tmp9_) / 2);
			_tmp10_ = handle;
			_tmp11_ = handle;
			_tmp12_ = handle;
			((BirdFontWidget*) _tmp11_)->widget_y = ((BirdFontWidget*) _tmp11_)->widget_y - (bird_font_widget_get_height ((BirdFontWidget*) _tmp12_) / 2);
			_tmp13_ = handle;
			bird_font_widget_draw ((BirdFontWidget*) _tmp13_, cr);
		}
		if (!self->priv->resize_path_proportional) {
			BirdFontText* _tmp14_;
			BirdFontText* _tmp15_;
			BirdFontText* _tmp16_;
			BirdFontText* _tmp17_;
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			BirdFontText* _tmp20_;
			BirdFontText* _tmp21_;
			BirdFontText* _tmp22_;
			BirdFontText* _tmp23_;
			BirdFontText* _tmp24_;
			BirdFontText* _tmp25_;
			BirdFontText* _tmp26_;
			_tmp14_ = self->priv->horizontal_handle;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (handle);
			handle = _tmp15_;
			_tmp16_ = handle;
			_tmp17_ = handle;
			bird_font_resize_tool_get_horizontal_reseize_handle_position (&_tmp18_, &_tmp19_);
			((BirdFontWidget*) _tmp16_)->widget_x = _tmp18_;
			((BirdFontWidget*) _tmp17_)->widget_y = _tmp19_;
			_tmp20_ = handle;
			_tmp21_ = handle;
			_tmp22_ = handle;
			((BirdFontWidget*) _tmp21_)->widget_x = ((BirdFontWidget*) _tmp21_)->widget_x - (bird_font_text_get_sidebearing_extent (_tmp22_) / 2);
			_tmp23_ = handle;
			_tmp24_ = handle;
			_tmp25_ = handle;
			((BirdFontWidget*) _tmp24_)->widget_y = ((BirdFontWidget*) _tmp24_)->widget_y - (bird_font_widget_get_height ((BirdFontWidget*) _tmp25_) / 2);
			_tmp26_ = handle;
			bird_font_widget_draw ((BirdFontWidget*) _tmp26_, cr);
		}
	}
	if (!self->priv->resize_path_proportional) {
		_tmp28_ = !self->priv->resize_width;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		BirdFontGlyph* _tmp29_;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp29_ = g;
		_tmp30_ = _tmp29_->active_paths;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp27_ = _tmp32_ > 0;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		bird_font_resize_tool_draw_rotate_handle (cr);
	}
	bird_font_move_tool_draw_actions (cr);
	_g_object_unref0 (g);
	_g_object_unref0 (handle);
}

static void
___lambda112__bird_font_tool_draw_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          cairo_t* cr,
                                          BirdFontGlyph* glyph,
                                          gpointer self)
{
	__lambda112_ ((BirdFontResizeTool*) self, selected, cr, glyph);
}

static void
__lambda113_ (BirdFontResizeTool* self,
              BirdFontTool* _self_,
              guint32 keyval)
{
	BirdFontMoveTool* _tmp0_;
	BirdFontMoveTool* _tmp1_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_drawing_tools_get_move_tool ();
	_tmp1_ = _tmp0_;
	bird_font_move_tool_key_down (_tmp1_, keyval);
}

static void
___lambda113__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               guint32 keyval,
                                               gpointer self)
{
	__lambda113_ ((BirdFontResizeTool*) self, selected, keyval);
}

BirdFontResizeTool*
bird_font_resize_tool_construct (GType object_type,
                                 const gchar* n)
{
	BirdFontResizeTool * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontText* _tmp2_;
	BirdFontText* _tmp3_;
	BirdFontText* _tmp4_;
	BirdFontText* _tmp5_;
	BirdFontText* _tmp6_;
	BirdFontText* _tmp7_;
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = bird_font_t_ ("Resize and rotate paths");
	_tmp1_ = _tmp0_;
	self = (BirdFontResizeTool*) bird_font_tool_construct (object_type, n, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = bird_font_text_new ("resize_handle", (gdouble) 60, (gdouble) 0);
	_g_object_unref0 (self->priv->proportional_handle);
	self->priv->proportional_handle = _tmp2_;
	_tmp3_ = self->priv->proportional_handle;
	bird_font_text_load_font (_tmp3_, "icons.birdfont");
	_tmp4_ = self->priv->proportional_handle;
	bird_font_theme_text_color (_tmp4_, "Highlighted 1");
	_tmp5_ = bird_font_text_new ("resize_handle_horizontal", (gdouble) 60, (gdouble) 0);
	_g_object_unref0 (self->priv->horizontal_handle);
	self->priv->horizontal_handle = _tmp5_;
	_tmp6_ = self->priv->horizontal_handle;
	bird_font_text_load_font (_tmp6_, "icons.birdfont");
	_tmp7_ = self->priv->horizontal_handle;
	bird_font_theme_text_color (_tmp7_, "Highlighted 1");
	g_signal_connect_object ((BirdFontTool*) self, "select-action", (GCallback) ___lambda106__bird_font_tool_select_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "deselect-action", (GCallback) ___lambda107__bird_font_tool_deselect_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "press-action", (GCallback) ___lambda108__bird_font_tool_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "release-action", (GCallback) ___lambda109__bird_font_tool_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "move-action", (GCallback) ___lambda111__bird_font_tool_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "draw-action", (GCallback) ___lambda112__bird_font_tool_draw_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "key-press-action", (GCallback) ___lambda113__bird_font_tool_key_press_action, self, 0);
	return self;
}

BirdFontResizeTool*
bird_font_resize_tool_new (const gchar* n)
{
	return bird_font_resize_tool_construct (BIRD_FONT_TYPE_RESIZE_TOOL, n);
}

void
bird_font_resize_tool_get_resize_handle_position (gdouble* px,
                                                  gdouble* py)
{
	gdouble _vala_px = 0.0;
	gdouble _vala_py = 0.0;
	_vala_px = (gdouble) bird_font_glyph_reverse_path_coordinate_x (bird_font_resize_tool_selection_box_center_x + (bird_font_resize_tool_selection_box_width / 2));
	_vala_py = (gdouble) bird_font_glyph_reverse_path_coordinate_y (bird_font_resize_tool_selection_box_center_y + (bird_font_resize_tool_selection_box_height / 2));
	if (px) {
		*px = _vala_px;
	}
	if (py) {
		*py = _vala_py;
	}
}

void
bird_font_resize_tool_get_horizontal_reseize_handle_position (gdouble* px,
                                                              gdouble* py)
{
	gdouble _vala_px = 0.0;
	gdouble _vala_py = 0.0;
	_vala_px = (gdouble) bird_font_glyph_reverse_path_coordinate_x (bird_font_resize_tool_selection_box_center_x + (bird_font_resize_tool_selection_box_width / 2));
	_vala_px = _vala_px + 40;
	_vala_py = (gdouble) bird_font_glyph_reverse_path_coordinate_y (bird_font_resize_tool_selection_box_center_y);
	if (px) {
		*px = _vala_px;
	}
	if (py) {
		*py = _vala_py;
	}
}

gdouble
bird_font_resize_tool_get_rotated_handle_length (void)
{
	gdouble s = 0.0;
	gdouble hx = 0.0;
	gdouble hy = 0.0;
	gdouble d = 0.0;
	gdouble result;
	s = fmin (bird_font_resize_tool_selection_box_width, bird_font_resize_tool_selection_box_height) * 1.1;
	d = (s / bird_font_glyph_ivz ()) / 2;
	hx = cos (bird_font_resize_tool_rotation) * d;
	hy = sin (bird_font_resize_tool_rotation) * d;
	result = d;
	return result;
}

void
bird_font_resize_tool_signal_objects_rotated (BirdFontResizeTool* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bird_font_resize_tool_signals[BIRD_FONT_RESIZE_TOOL_OBJECTS_ROTATED_SIGNAL], 0, bird_font_resize_tool_rotation * (180 / G_PI));
}

void
bird_font_resize_tool_rotate_selected_paths (BirdFontResizeTool* self,
                                             gdouble angle,
                                             gdouble cx,
                                             gdouble cy)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	gdouble xc2 = 0.0;
	gdouble yc2 = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontPath* last_path = NULL;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	BirdFontGlyph* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			_tmp10_ = p;
			bird_font_path_rotate (_tmp10_, angle, cx, cy);
			_g_object_unref0 (p);
		}
	}
	bird_font_move_tool_get_selection_box_boundaries (&_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	xc2 = _tmp11_;
	yc2 = _tmp12_;
	w = _tmp13_;
	h = _tmp14_;
	dx = -(xc2 - cx);
	dy = -(yc2 - cy);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp15_;
		GeeArrayList* _tmp16_;
		gint _p_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _p_index = 0;
		_tmp15_ = glyph;
		_tmp16_ = _tmp15_->active_paths;
		_p_list = _tmp16_;
		_tmp17_ = _p_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_p_size = _tmp19_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			BirdFontPath* _tmp24_;
			_p_index = _p_index + 1;
			_tmp20_ = _p_index;
			_tmp21_ = _p_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _p_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _p_index);
			p = (BirdFontPath*) _tmp23_;
			_tmp24_ = p;
			bird_font_path_move (_tmp24_, dx, dy);
			_g_object_unref0 (p);
		}
	}
	bird_font_resize_tool_last_rotate = bird_font_resize_tool_rotation;
	bird_font_move_tool_update_selection_boundaries ();
	_tmp25_ = glyph;
	_tmp26_ = _tmp25_->active_paths;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 0) {
		BirdFontGlyph* _tmp29_;
		GeeArrayList* _tmp30_;
		BirdFontGlyph* _tmp31_;
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gpointer _tmp35_;
		BirdFontPath* _tmp36_;
		_tmp29_ = glyph;
		_tmp30_ = _tmp29_->active_paths;
		_tmp31_ = glyph;
		_tmp32_ = _tmp31_->active_paths;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp34_ - 1);
		_g_object_unref0 (last_path);
		last_path = (BirdFontPath*) _tmp35_;
		_tmp36_ = last_path;
		bird_font_resize_tool_rotation = _tmp36_->rotation;
		if (bird_font_resize_tool_rotation > G_PI) {
			bird_font_resize_tool_rotation = bird_font_resize_tool_rotation - (2 * G_PI);
		}
		bird_font_resize_tool_last_rotate = bird_font_resize_tool_rotation;
		bird_font_resize_tool_signal_objects_rotated (self);
	}
	_g_object_unref0 (last_path);
	_g_object_unref0 (glyph);
}

/** Move rotate handle to pixel x,y. */
static void
bird_font_resize_tool_rotate (BirdFontResizeTool* self,
                              gdouble x,
                              gdouble y)
{
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble a = 0.0;
	gdouble b = 0.0;
	g_return_if_fail (self != NULL);
	cx = (gdouble) bird_font_glyph_reverse_path_coordinate_x (bird_font_resize_tool_selection_box_center_x);
	cy = (gdouble) bird_font_glyph_reverse_path_coordinate_y (bird_font_resize_tool_selection_box_center_y);
	xc = bird_font_resize_tool_selection_box_center_x;
	yc = bird_font_resize_tool_selection_box_center_y;
	a = x - cx;
	b = y - cy;
	bird_font_resize_tool_rotation = atan (b / a);
	if (a < ((gdouble) 0)) {
		bird_font_resize_tool_rotation = bird_font_resize_tool_rotation + G_PI;
	}
	bird_font_resize_tool_rotate_selected_paths (self, bird_font_resize_tool_rotation - bird_font_resize_tool_last_rotate, bird_font_resize_tool_selection_box_center_x, bird_font_resize_tool_selection_box_center_y);
}

static gboolean
bird_font_resize_tool_is_over_rotate_handle (BirdFontPath* p,
                                             gdouble x,
                                             gdouble y)
{
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble hx = 0.0;
	gdouble hy = 0.0;
	gdouble size = 0.0;
	gboolean inx = FALSE;
	gboolean iny = FALSE;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	size = (gdouble) 10;
	cx = (gdouble) bird_font_glyph_reverse_path_coordinate_x (bird_font_resize_tool_selection_box_center_x);
	cy = (gdouble) bird_font_glyph_reverse_path_coordinate_y (bird_font_resize_tool_selection_box_center_y);
	hx = cos (bird_font_resize_tool_rotation) * bird_font_resize_tool_get_rotated_handle_length ();
	hy = sin (bird_font_resize_tool_rotation) * bird_font_resize_tool_get_rotated_handle_length ();
	_tmp0_ = (cx + hx) - 2.5;
	inx = ((x - size) <= _tmp0_) && (_tmp0_ <= (x + size));
	_tmp1_ = (cy + hy) - 2.5;
	iny = ((y - size) <= _tmp1_) && (_tmp1_ <= (y + size));
	if (inx) {
		_tmp2_ = iny;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	return result;
}

static void
bird_font_resize_tool_draw_rotate_handle (cairo_t* cr)
{
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble hx = 0.0;
	gdouble hy = 0.0;
	g_return_if_fail (cr != NULL);
	cx = (gdouble) bird_font_glyph_reverse_path_coordinate_x (bird_font_resize_tool_selection_box_center_x);
	cy = (gdouble) bird_font_glyph_reverse_path_coordinate_y (bird_font_resize_tool_selection_box_center_y);
	cairo_save (cr);
	bird_font_theme_color (cr, "Highlighted 1");
	cairo_rectangle (cr, cx - 2.5, cy - 2.5, (gdouble) 5, (gdouble) 5);
	cairo_fill (cr);
	hx = cos (bird_font_resize_tool_rotation) * bird_font_resize_tool_get_rotated_handle_length ();
	hy = sin (bird_font_resize_tool_rotation) * bird_font_resize_tool_get_rotated_handle_length ();
	cairo_set_line_width (cr, (gdouble) 1);
	cairo_move_to (cr, cx, cy);
	cairo_line_to (cr, cx + hx, cy + hy);
	cairo_stroke (cr);
	bird_font_theme_color (cr, "Highlighted 1");
	cairo_rectangle (cr, (cx + hx) - 2.5, (cy + hy) - 2.5, (gdouble) 5, (gdouble) 5);
	cairo_fill (cr);
	cairo_restore (cr);
}

static gdouble
bird_font_resize_tool_get_resize_ratio (BirdFontResizeTool* self,
                                        gdouble px,
                                        gdouble py)
{
	gdouble ratio = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = glyph;
	bird_font_glyph_selection_boundaries (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp2_;
	y = _tmp3_;
	w = _tmp4_;
	h = _tmp5_;
	ratio = (gdouble) 1;
	if (fabs (self->priv->last_resize_y - py) > fabs (self->priv->last_resize_x - px)) {
		ratio = 1 + ((bird_font_glyph_path_coordinate_y (py) - bird_font_glyph_path_coordinate_y (self->priv->last_resize_y)) / h);
	} else {
		ratio = 1 + ((bird_font_glyph_path_coordinate_x (px) - bird_font_glyph_path_coordinate_x (self->priv->last_resize_x)) / w);
	}
	result = ratio;
	_g_object_unref0 (glyph);
	return result;
}

void
bird_font_resize_tool_resize_selected_paths (BirdFontResizeTool* self,
                                             gdouble ratio_x,
                                             gdouble ratio_y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_resize_tool_resize_glyph (self, g, ratio_x, ratio_y, TRUE, TRUE);
	_g_object_unref0 (g);
}

void
bird_font_resize_tool_resize_glyph (BirdFontResizeTool* self,
                                    BirdFontGlyph* glyph,
                                    gdouble ratio_x,
                                    gdouble ratio_y,
                                    gboolean selected,
                                    gboolean relative_to_object)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	if (!selected) {
		bird_font_glyph_clear_active_paths (glyph);
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp1_;
			gint _path_size = 0;
			GeeArrayList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _path_index = 0;
			_tmp1_ = bird_font_glyph_get_visible_paths (glyph);
			_path_list = _tmp1_;
			_tmp2_ = _path_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_path_size = _tmp4_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				BirdFontPath* path = NULL;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				BirdFontPath* _tmp9_;
				_path_index = _path_index + 1;
				_tmp5_ = _path_index;
				_tmp6_ = _path_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _path_list;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _path_index);
				path = (BirdFontPath*) _tmp8_;
				_tmp9_ = path;
				bird_font_glyph_add_active_path (glyph, NULL, _tmp9_);
				_g_object_unref0 (path);
			}
			_g_object_unref0 (_path_list);
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp10_;
		gint _path_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _path_index = 0;
		_tmp10_ = glyph->active_paths;
		_path_list = _tmp10_;
		_tmp11_ = _path_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_path_size = _tmp13_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontFont* _tmp18_;
			BirdFontSvgTransforms* transform = NULL;
			BirdFontSvgTransforms* _tmp19_;
			BirdFontSvgTransforms* _tmp20_;
			cairo_matrix_t matrix = {0};
			BirdFontSvgTransforms* _tmp21_;
			cairo_matrix_t _tmp22_ = {0};
			BirdFontPath* _tmp23_;
			cairo_matrix_t _tmp24_;
			BirdFontPath* _tmp25_;
			_path_index = _path_index + 1;
			_tmp14_ = _path_index;
			_tmp15_ = _path_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _path_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _path_index);
			path = (BirdFontPath*) _tmp17_;
			((BirdFontTool*) self)->x = bird_font_resize_tool_selection_box_center_x - (bird_font_resize_tool_selection_box_width / 2);
			_tmp18_ = font;
			((BirdFontTool*) self)->y = _tmp18_->base_line;
			if (relative_to_object) {
				((BirdFontTool*) self)->y = bird_font_resize_tool_selection_box_center_y - (bird_font_resize_tool_selection_box_height / 2);
			}
			_tmp19_ = bird_font_svg_transforms_new ();
			transform = _tmp19_;
			_tmp20_ = transform;
			bird_font_svg_transforms_resize (_tmp20_, ratio_x, ratio_y, ((BirdFontTool*) self)->x, ((BirdFontTool*) self)->y);
			_tmp21_ = transform;
			bird_font_svg_transforms_get_matrix (_tmp21_, &_tmp22_);
			matrix = _tmp22_;
			_tmp23_ = path;
			_tmp24_ = matrix;
			bird_font_path_transform (_tmp23_, &_tmp24_);
			_tmp25_ = path;
			bird_font_path_reset_stroke (_tmp25_);
			_g_object_unref0 (transform);
			_g_object_unref0 (path);
		}
	}
	_tmp26_ = glyph->active_paths;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 0) {
		{
			GeeArrayList* _p_list = NULL;
			GeeArrayList* _tmp29_;
			gint _p_size = 0;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _p_index = 0;
			_tmp29_ = glyph->active_paths;
			_p_list = _tmp29_;
			_tmp30_ = _p_list;
			_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_p_size = _tmp32_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp33_;
				gint _tmp34_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp35_;
				gpointer _tmp36_;
				BirdFontPath* _tmp37_;
				_p_index = _p_index + 1;
				_tmp33_ = _p_index;
				_tmp34_ = _p_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _p_list;
				_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _p_index);
				p = (BirdFontPath*) _tmp36_;
				_tmp37_ = p;
				bird_font_path_update_region_boundaries (_tmp37_);
				_g_object_unref0 (p);
			}
		}
	}
	if (!selected) {
		gdouble _tmp38_;
		gdouble _tmp39_;
		gdouble _tmp40_;
		gdouble _tmp41_;
		bird_font_glyph_add_help_lines (glyph);
		_tmp38_ = bird_font_glyph_get_left_limit (glyph);
		_tmp39_ = _tmp38_;
		bird_font_glyph_set_left_limit (glyph, _tmp39_ * ratio_x);
		_tmp40_ = bird_font_glyph_get_right_limit (glyph);
		_tmp41_ = _tmp40_;
		bird_font_glyph_set_right_limit (glyph, _tmp41_ * ratio_x);
		bird_font_glyph_clear_active_paths (glyph);
		bird_font_glyph_remove_lines (glyph);
		bird_font_glyph_add_help_lines (glyph);
		glyph->view_zoom = (gdouble) 1;
		glyph->view_offset_x = (gdouble) 0;
		glyph->view_offset_y = (gdouble) 0;
	}
	_g_object_unref0 (font);
}

static void
bird_font_resize_tool_update_selection_box (BirdFontResizeTool* self)
{
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	bird_font_move_tool_update_boundaries_for_selection ();
	bird_font_move_tool_get_selection_box_boundaries (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	bird_font_resize_tool_selection_box_center_x = _tmp0_;
	bird_font_resize_tool_selection_box_center_y = _tmp1_;
	bird_font_resize_tool_selection_box_width = _tmp2_;
	bird_font_resize_tool_selection_box_height = _tmp3_;
}

/** Move resize handle to pixel x,y. */
static void
bird_font_resize_tool_resize_proportional (BirdFontResizeTool* self,
                                           gdouble px,
                                           gdouble py)
{
	gdouble ratio = 0.0;
	g_return_if_fail (self != NULL);
	ratio = bird_font_resize_tool_get_resize_ratio (self, px, py);
	if (ratio != ((gdouble) 1)) {
		bird_font_resize_tool_resize_selected_paths (self, ratio, ratio);
		self->priv->last_resize_x = px;
		self->priv->last_resize_y = py;
	}
}

/** Move resize handle to pixel x,y. */
static void
bird_font_resize_tool_resize_horizontal (BirdFontResizeTool* self,
                                         gdouble px,
                                         gdouble py)
{
	gdouble ratio = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = glyph;
	bird_font_glyph_selection_boundaries (_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp2_;
	y = _tmp3_;
	w = _tmp4_;
	h = _tmp5_;
	ratio = 1 + ((bird_font_glyph_path_coordinate_x (px) - bird_font_glyph_path_coordinate_x (self->priv->last_resize_x)) / w);
	if (ratio != ((gdouble) 1)) {
		bird_font_resize_tool_resize_selected_paths (self, ratio, (gdouble) 1);
		self->priv->last_resize_x = px;
		self->priv->last_resize_y = py;
	}
	_g_object_unref0 (glyph);
}

void
bird_font_resize_tool_full_height (BirdFontResizeTool* self)
{
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble descender = 0.0;
	BirdFontFont* _tmp6_;
	gdouble font_height = 0.0;
	BirdFontFont* _tmp7_;
	BirdFontFont* _tmp8_;
	gdouble scale = 0.0;
	BirdFontFont* _tmp9_;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	BirdFontMoveTool* _tmp14_;
	BirdFontMoveTool* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	bird_font_move_tool_update_boundaries_for_selection ();
	bird_font_move_tool_get_selection_box_boundaries (&_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	xc = _tmp2_;
	yc = _tmp3_;
	w = _tmp4_;
	h = _tmp5_;
	_tmp6_ = font;
	descender = _tmp6_->base_line - (yc - (h / 2));
	if (descender < ((gdouble) 0)) {
		descender = (gdouble) 0;
	}
	_tmp7_ = font;
	_tmp8_ = font;
	font_height = _tmp7_->top_position - _tmp8_->base_line;
	scale = font_height / (h - descender);
	bird_font_resize_tool_resize_selected_paths (self, scale, scale);
	bird_font_pen_tool_reset_stroke ();
	bird_font_move_tool_update_boundaries_for_selection ();
	_tmp9_ = font;
	bird_font_font_touch (_tmp9_);
	bird_font_move_tool_get_selection_box_boundaries (&_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
	bird_font_resize_tool_selection_box_center_x = _tmp10_;
	bird_font_resize_tool_selection_box_center_y = _tmp11_;
	bird_font_resize_tool_selection_box_width = _tmp12_;
	bird_font_resize_tool_selection_box_height = _tmp13_;
	_tmp14_ = bird_font_drawing_tools_get_move_tool ();
	_tmp15_ = _tmp14_;
	bird_font_move_tool_move_to_baseline (_tmp15_);
	{
		GeeArrayList* _path_list = NULL;
		BirdFontGlyph* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _path_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _path_index = 0;
		_tmp16_ = glyph;
		_tmp17_ = _tmp16_->active_paths;
		_path_list = _tmp17_;
		_tmp18_ = _path_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_path_size = _tmp20_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			BirdFontPath* _tmp25_;
			_path_index = _path_index + 1;
			_tmp21_ = _path_index;
			_tmp22_ = _path_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _path_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _path_index);
			path = (BirdFontPath*) _tmp24_;
			_tmp25_ = path;
			bird_font_path_move (_tmp25_, (gdouble) 0, (-descender) * scale);
			_g_object_unref0 (path);
		}
	}
	g_signal_emit (self, bird_font_resize_tool_signals[BIRD_FONT_RESIZE_TOOL_OBJECTS_RESIZED_SIGNAL], 0, bird_font_resize_tool_selection_box_width, bird_font_resize_tool_selection_box_height);
	_g_object_unref0 (font);
	_g_object_unref0 (glyph);
}

static gboolean
bird_font_resize_tool_can_resize (BirdFontResizeTool* self,
                                  gdouble x,
                                  gdouble y)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble h = 0.0;
	gdouble w = 0.0;
	gdouble ratio = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	ratio = bird_font_resize_tool_get_resize_ratio (self, x, y);
	{
		GeeArrayList* _selected_path_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _selected_path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _selected_path_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_selected_path_list = _tmp2_;
		_tmp3_ = _selected_path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_selected_path_size = _tmp5_;
		_selected_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* selected_path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontPath* _tmp13_;
			BirdFontPath* _tmp14_;
			GeeArrayList* _tmp15_;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gboolean _tmp19_ = FALSE;
			_selected_path_index = _selected_path_index + 1;
			_tmp6_ = _selected_path_index;
			_tmp7_ = _selected_path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _selected_path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _selected_path_index);
			selected_path = (BirdFontPath*) _tmp9_;
			_tmp10_ = selected_path;
			_tmp11_ = selected_path;
			h = _tmp10_->ymax - _tmp11_->ymin;
			_tmp12_ = selected_path;
			_tmp13_ = selected_path;
			w = _tmp12_->xmax - _tmp13_->xmin;
			_tmp14_ = selected_path;
			_tmp15_ = bird_font_path_get_points (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ <= 1) {
				_g_object_unref0 (selected_path);
				continue;
			}
			if ((h * ratio) < 0.0001) {
				_tmp19_ = TRUE;
			} else {
				_tmp19_ = (w * ratio) < 0.0001;
			}
			if (_tmp19_) {
				result = FALSE;
				_g_object_unref0 (selected_path);
				_g_object_unref0 (glyph);
				return result;
			}
			_g_object_unref0 (selected_path);
		}
	}
	result = TRUE;
	_g_object_unref0 (glyph);
	return result;
}

static gboolean
bird_font_resize_tool_is_over_resize_handle (BirdFontResizeTool* self,
                                             BirdFontPath* p,
                                             gdouble x,
                                             gdouble y)
{
	gdouble handle_x = 0.0;
	gdouble handle_y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	bird_font_resize_tool_get_resize_handle_position (&_tmp0_, &_tmp1_);
	handle_x = _tmp0_;
	handle_y = _tmp1_;
	result = bird_font_path_distance (handle_x, x, handle_y, y) < ((gdouble) 12);
	return result;
}

static gboolean
bird_font_resize_tool_is_over_horizontal_resize_handle (BirdFontResizeTool* self,
                                                        BirdFontPath* p,
                                                        gdouble x,
                                                        gdouble y)
{
	gdouble handle_x = 0.0;
	gdouble handle_y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	bird_font_resize_tool_get_horizontal_reseize_handle_position (&_tmp0_, &_tmp1_);
	handle_x = _tmp0_;
	handle_y = _tmp1_;
	result = bird_font_path_distance (handle_x, x, handle_y, y) < ((gdouble) 12);
	return result;
}

void
bird_font_resize_tool_skew (BirdFontResizeTool* self,
                            gdouble skew)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	bird_font_resize_tool_skew_glyph (self, glyph, skew, self->last_skew, TRUE);
	self->last_skew = skew;
	_g_object_unref0 (glyph);
}

void
bird_font_resize_tool_skew_glyph (BirdFontResizeTool* self,
                                  BirdFontGlyph* glyph,
                                  gdouble skew,
                                  gdouble last_skew,
                                  gboolean selected_paths)
{
	gdouble dx = 0.0;
	gdouble nx = 0.0;
	gdouble nw = 0.0;
	gdouble dw = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp38_;
	gdouble _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyph != NULL);
	s = (skew - last_skew) / 100.0;
	if (!selected_paths) {
		bird_font_glyph_clear_active_paths (glyph);
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp0_;
			gint _path_size = 0;
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _path_index = 0;
			_tmp0_ = bird_font_glyph_get_visible_paths (glyph);
			_path_list = _tmp0_;
			_tmp1_ = _path_list;
			_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_path_size = _tmp3_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				BirdFontPath* path = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				BirdFontPath* _tmp8_;
				_path_index = _path_index + 1;
				_tmp4_ = _path_index;
				_tmp5_ = _path_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _path_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _path_index);
				path = (BirdFontPath*) _tmp7_;
				_tmp8_ = path;
				bird_font_glyph_add_active_path (glyph, NULL, _tmp8_);
				_g_object_unref0 (path);
			}
			_g_object_unref0 (_path_list);
		}
	}
	bird_font_glyph_selection_boundaries (glyph, &_tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	x = _tmp9_;
	y = _tmp10_;
	w = _tmp11_;
	h = _tmp12_;
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp13_;
		gint _path_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _path_index = 0;
		_tmp13_ = glyph->active_paths;
		_path_list = _tmp13_;
		_tmp14_ = _path_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_path_size = _tmp16_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			BirdFontPath* _tmp21_;
			BirdFontPath* _tmp22_;
			BirdFontPath* _tmp23_;
			_path_index = _path_index + 1;
			_tmp17_ = _path_index;
			_tmp18_ = _path_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _path_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _path_index);
			path = (BirdFontPath*) _tmp20_;
			_tmp21_ = path;
			bird_font_svg_parser_apply_matrix (_tmp21_, (gdouble) 1, (gdouble) 0, s, (gdouble) 1, (gdouble) 0, (gdouble) 0);
			_tmp22_ = path;
			_tmp22_->skew = skew;
			_tmp23_ = path;
			bird_font_path_update_region_boundaries (_tmp23_);
			_g_object_unref0 (path);
		}
	}
	bird_font_glyph_selection_boundaries (glyph, &_tmp24_, &_tmp25_, &_tmp26_, &_tmp27_);
	nx = _tmp24_;
	y = _tmp25_;
	nw = _tmp26_;
	h = _tmp27_;
	dx = -(nx - x);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp28_;
		gint _p_size = 0;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _p_index = 0;
		_tmp28_ = glyph->active_paths;
		_p_list = _tmp28_;
		_tmp29_ = _p_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_p_size = _tmp31_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp34_;
			gpointer _tmp35_;
			BirdFontPath* _tmp36_;
			BirdFontPath* _tmp37_;
			_p_index = _p_index + 1;
			_tmp32_ = _p_index;
			_tmp33_ = _p_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _p_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _p_index);
			p = (BirdFontPath*) _tmp35_;
			_tmp36_ = p;
			bird_font_path_move (_tmp36_, dx, (gdouble) 0);
			_tmp37_ = p;
			bird_font_path_reset_stroke (_tmp37_);
			_g_object_unref0 (p);
		}
	}
	dw = nw - w;
	_tmp38_ = bird_font_glyph_get_right_limit (glyph);
	_tmp39_ = _tmp38_;
	bird_font_glyph_set_right_limit (glyph, _tmp39_ + dw);
	bird_font_glyph_remove_lines (glyph);
	bird_font_glyph_add_help_lines (glyph);
	if (!selected_paths) {
		bird_font_glyph_clear_active_paths (glyph);
	}
}

static void
g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), data2);
}

static void
bird_font_resize_tool_class_init (BirdFontResizeToolClass * klass,
                                  gpointer klass_data)
{
	bird_font_resize_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontResizeTool_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_resize_tool_finalize;
	bird_font_resize_tool_signals[BIRD_FONT_RESIZE_TOOL_OBJECTS_ROTATED_SIGNAL] = g_signal_new ("objects-rotated", BIRD_FONT_TYPE_RESIZE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
	bird_font_resize_tool_signals[BIRD_FONT_RESIZE_TOOL_OBJECTS_RESIZED_SIGNAL] = g_signal_new ("objects-resized", BIRD_FONT_TYPE_RESIZE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_DOUBLE);
}

static void
bird_font_resize_tool_instance_init (BirdFontResizeTool * self,
                                     gpointer klass)
{
	self->priv = bird_font_resize_tool_get_instance_private (self);
	self->priv->resize_path_proportional = FALSE;
	self->priv->resize_width = FALSE;
	self->priv->resized_path = NULL;
	self->priv->move_paths = FALSE;
	self->last_skew = (gdouble) 0;
}

static void
bird_font_resize_tool_finalize (GObject * obj)
{
	BirdFontResizeTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_RESIZE_TOOL, BirdFontResizeTool);
	_g_object_unref0 (self->priv->resized_path);
	_g_object_unref0 (self->priv->proportional_handle);
	_g_object_unref0 (self->priv->horizontal_handle);
	G_OBJECT_CLASS (bird_font_resize_tool_parent_class)->finalize (obj);
}

static GType
bird_font_resize_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontResizeToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_resize_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontResizeTool), 0, (GInstanceInitFunc) bird_font_resize_tool_instance_init, NULL };
	GType bird_font_resize_tool_type_id;
	bird_font_resize_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontResizeTool", &g_define_type_info, 0);
	BirdFontResizeTool_private_offset = g_type_add_instance_private (bird_font_resize_tool_type_id, sizeof (BirdFontResizeToolPrivate));
	return bird_font_resize_tool_type_id;
}

GType
bird_font_resize_tool_get_type (void)
{
	static volatile gsize bird_font_resize_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_resize_tool_type_id__once)) {
		GType bird_font_resize_tool_type_id;
		bird_font_resize_tool_type_id = bird_font_resize_tool_get_type_once ();
		g_once_init_leave (&bird_font_resize_tool_type_id__once, bird_font_resize_tool_type_id);
	}
	return bird_font_resize_tool_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

