/* Preferences.c generated by valac 0.56.16, the Vala compiler
 * generated from Preferences.vala, do not modify */

/*
Copyright (C) 2012 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirdFontParamSpecPreferences BirdFontParamSpecPreferences;

struct _BirdFontParamSpecPreferences {
	GParamSpec parent_instance;
};

static gpointer bird_font_preferences_parent_class = NULL;
static GeeHashMap* bird_font_preferences_data;
static GeeHashMap* bird_font_preferences_data = NULL;
gboolean bird_font_preferences_draw_boundaries = FALSE;

VALA_EXTERN GFile* bird_font_bird_font_get_settings_directory (void);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static void bird_font_preferences_finalize (BirdFontPreferences * obj);
static GType bird_font_preferences_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BirdFontPreferences*
bird_font_preferences_construct (GType object_type)
{
	BirdFontPreferences* self = NULL;
	GeeHashMap* _tmp0_;
	self = (BirdFontPreferences*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_preferences_data);
	bird_font_preferences_data = _tmp0_;
	return self;
}

BirdFontPreferences*
bird_font_preferences_new (void)
{
	return bird_font_preferences_construct (BIRD_FONT_TYPE_PREFERENCES);
}

void
bird_font_preferences_set_last_file (const gchar* fn)
{
	g_return_if_fail (fn != NULL);
	bird_font_preferences_set ("last_file", fn);
}

gchar*
bird_font_preferences_get (const gchar* k)
{
	gchar* s = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (k != NULL, NULL);
	_tmp0_ = bird_font_preferences_data;
	if (bird_font_is_null (_tmp0_)) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (bird_font_preferences_data);
		bird_font_preferences_data = _tmp1_;
	}
	_tmp2_ = bird_font_preferences_data;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, k);
	_g_free0 (s);
	s = (gchar*) _tmp3_;
	_tmp5_ = s;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = s;
		_tmp4_ = (const gchar*) _tmp6_;
	} else {
		_tmp4_ = "";
	}
	_tmp7_ = g_strdup (_tmp4_);
	result = _tmp7_;
	_g_free0 (s);
	return result;
}

void
bird_font_preferences_set (const gchar* k,
                           const gchar* v)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = bird_font_preferences_data;
	if (bird_font_is_null (_tmp0_)) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (bird_font_preferences_data);
		bird_font_preferences_data = _tmp1_;
	}
	_tmp2_ = bird_font_preferences_data;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, k, v);
	bird_font_preferences_save ();
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar**
bird_font_preferences_get_recent_files (gint* result_length1)
{
	gchar* recent = NULL;
	gchar* _tmp0_;
	gchar** files = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** result;
	_tmp0_ = bird_font_preferences_get ("recent_files");
	recent = _tmp0_;
	_tmp1_ = recent;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, "\t", 0);
	files = _tmp3_;
	files_length1 = _vala_array_length (_tmp2_);
	_files_size_ = files_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = files;
				_tmp6__length1 = files_length1;
				if (!(i < ((guint) _tmp6__length1))) {
					break;
				}
				_tmp7_ = files;
				_tmp7__length1 = files_length1;
				_tmp8_ = files;
				_tmp8__length1 = files_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = string_replace (_tmp9_, "\\t", "\t");
				_g_free0 (_tmp7_[i]);
				_tmp7_[i] = _tmp10_;
			}
		}
	}
	_tmp11_ = files;
	_tmp11__length1 = files_length1;
	if (result_length1) {
		*result_length1 = _tmp11__length1;
	}
	result = _tmp11_;
	_g_free0 (recent);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

GFile*
bird_font_preferences_get_backup_directory (void)
{
	GFile* config_directory = NULL;
	GFile* _tmp0_;
	GFile* backup_directory = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	config_directory = _tmp0_;
	_tmp1_ = config_directory;
	_tmp2_ = bird_font_get_child (_tmp1_, "backup");
	backup_directory = _tmp2_;
	_tmp3_ = backup_directory;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gint _error_ = 0;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gint _tmp7_;
		_tmp4_ = backup_directory;
		_tmp5_ = g_file_get_path (_tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_tmp7_ = g_mkdir (_tmp6_, 0766);
		_g_free0 (_tmp6_);
		_error_ = _tmp7_;
		if (_error_ == -1) {
			GFile* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp8_ = backup_directory;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = (gchar*) _tmp9_;
			_tmp11_ = string_to_string (_tmp10_);
			_tmp12_ = g_strconcat ("Failed to create backup directory: ", _tmp11_, "\n", NULL);
			_tmp13_ = _tmp12_;
			g_warning ("Preferences.vala:72: %s", _tmp13_);
			_g_free0 (_tmp13_);
			_g_free0 (_tmp10_);
		}
	}
	result = backup_directory;
	_g_object_unref0 (config_directory);
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

GFile*
bird_font_preferences_get_backup_directory_for_font (const gchar* bf_file_name)
{
	GFile* backup_directory = NULL;
	GFile* _tmp2_;
	gchar* subdir_name = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp12_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* backup_subdir = NULL;
	GFile* _tmp22_;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* result;
	g_return_val_if_fail (bf_file_name != NULL, NULL);
	if (g_strcmp0 (bf_file_name, "") == 0) {
		g_warning ("Preferences.vala:81: no filename.");
	}
	if (string_index_of (bf_file_name, "/", 0) > -1) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strconcat ("Expecting a file and not a folder got: ", bf_file_name, NULL);
		_tmp1_ = _tmp0_;
		g_warning ("Preferences.vala:85: %s", _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = bird_font_preferences_get_backup_directory ();
	backup_directory = _tmp2_;
	_tmp3_ = g_strdup (bf_file_name);
	subdir_name = _tmp3_;
	_tmp4_ = subdir_name;
	if (g_str_has_suffix (_tmp4_, ".bf")) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = subdir_name;
		_tmp6_ = subdir_name;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = strlen (".bf");
		_tmp10_ = _tmp9_;
		_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
		_g_free0 (subdir_name);
		subdir_name = _tmp11_;
	}
	_tmp12_ = subdir_name;
	if (g_str_has_suffix (_tmp12_, ".birdfont")) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		_tmp13_ = subdir_name;
		_tmp14_ = subdir_name;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = strlen (".birdfont");
		_tmp18_ = _tmp17_;
		_tmp19_ = string_substring (_tmp13_, (glong) 0, (glong) (_tmp16_ - _tmp18_));
		_g_free0 (subdir_name);
		subdir_name = _tmp19_;
	}
	_tmp20_ = subdir_name;
	_tmp21_ = g_strconcat (_tmp20_, ".backup", NULL);
	_g_free0 (subdir_name);
	subdir_name = _tmp21_;
	_tmp22_ = backup_directory;
	_tmp23_ = subdir_name;
	_tmp24_ = bird_font_get_child (_tmp22_, _tmp23_);
	backup_subdir = _tmp24_;
	_tmp25_ = backup_subdir;
	if (!g_file_query_exists (_tmp25_, NULL)) {
		gint _error_ = 0;
		GFile* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gint _tmp29_;
		_tmp26_ = backup_subdir;
		_tmp27_ = g_file_get_path (_tmp26_);
		_tmp28_ = (gchar*) _tmp27_;
		_tmp29_ = g_mkdir (_tmp28_, 0766);
		_g_free0 (_tmp28_);
		_error_ = _tmp29_;
		if (_error_ == -1) {
			GFile* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = backup_subdir;
			_tmp31_ = g_file_get_path (_tmp30_);
			_tmp32_ = (gchar*) _tmp31_;
			_tmp33_ = string_to_string (_tmp32_);
			_tmp34_ = g_strconcat ("Failed to create backup directory: ", _tmp33_, "\n", NULL);
			_tmp35_ = _tmp34_;
			g_warning ("Preferences.vala:107: %s", _tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp32_);
		}
	}
	result = backup_subdir;
	_g_free0 (subdir_name);
	_g_object_unref0 (backup_directory);
	return result;
}

void
bird_font_preferences_add_recent_files (const gchar* file)
{
	gchar* escaped_string = NULL;
	gchar* _tmp0_;
	GString* recent = NULL;
	GString* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (file != NULL);
	_tmp0_ = string_replace (file, "\t", "\\t");
	escaped_string = _tmp0_;
	_tmp1_ = g_string_new ("");
	recent = _tmp1_;
	_tmp3_ = bird_font_preferences_get_recent_files (&_tmp2_);
	{
		gchar** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp3_;
		f_collection_length1 = _tmp2_;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			gchar* _tmp4_;
			gchar* f = NULL;
			_tmp4_ = g_strdup (f_collection[f_it]);
			f = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = f;
				if (g_strcmp0 (_tmp5_, file) != 0) {
					GString* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					GString* _tmp10_;
					_tmp6_ = recent;
					_tmp7_ = f;
					_tmp8_ = string_replace (_tmp7_, "\t", "\\t");
					_tmp9_ = _tmp8_;
					g_string_append (_tmp6_, _tmp9_);
					_g_free0 (_tmp9_);
					_tmp10_ = recent;
					g_string_append (_tmp10_, "\t");
				}
				_g_free0 (f);
			}
		}
		f_collection = (_vala_array_free (f_collection, f_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp11_ = recent;
	_tmp12_ = escaped_string;
	g_string_append (_tmp11_, _tmp12_);
	_tmp13_ = recent;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = string_to_string (_tmp14_);
	bird_font_preferences_set ("recent_files", _tmp15_);
	_g_string_free0 (recent);
	_g_free0 (escaped_string);
}

void
bird_font_preferences_set_window_size (gint x,
                                       gint y,
                                       gint width,
                                       gint height)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = g_strdup_printf ("%i", x);
	_tmp1_ = _tmp0_;
	bird_font_preferences_set ("window_x", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup_printf ("%i", y);
	_tmp3_ = _tmp2_;
	bird_font_preferences_set ("window_y", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = g_strdup_printf ("%i", width);
	_tmp5_ = _tmp4_;
	bird_font_preferences_set ("window_width", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_strdup_printf ("%i", height);
	_tmp7_ = _tmp6_;
	bird_font_preferences_set ("window_height", _tmp7_);
	_g_free0 (_tmp7_);
}

gint
bird_font_preferences_get_window_x (void)
{
	gchar* wp = NULL;
	gchar* _tmp0_;
	gint x = 0;
	gint result;
	_tmp0_ = bird_font_preferences_get ("window_x");
	wp = _tmp0_;
	x = atoi (wp);
	result = x;
	_g_free0 (wp);
	return result;
}

gint
bird_font_preferences_get_window_y (void)
{
	gchar* wp = NULL;
	gchar* _tmp0_;
	gint y = 0;
	gint result;
	_tmp0_ = bird_font_preferences_get ("window_y");
	wp = _tmp0_;
	y = atoi (wp);
	result = y;
	_g_free0 (wp);
	return result;
}

gint
bird_font_preferences_get_window_width (void)
{
	gchar* wp = NULL;
	gchar* _tmp0_;
	gint w = 0;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint result;
	_tmp0_ = bird_font_preferences_get ("window_width");
	wp = _tmp0_;
	_tmp1_ = wp;
	w = atoi (_tmp1_);
	if (w == 0) {
		_tmp2_ = 860;
	} else {
		_tmp2_ = w;
	}
	result = _tmp2_;
	_g_free0 (wp);
	return result;
}

gint
bird_font_preferences_get_window_height (void)
{
	gint h = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint result;
	_tmp0_ = bird_font_preferences_get ("window_height");
	_tmp1_ = _tmp0_;
	_tmp2_ = atoi (_tmp1_);
	_g_free0 (_tmp1_);
	h = _tmp2_;
	if (h == 0) {
		_tmp3_ = 500;
	} else {
		_tmp3_ = h;
	}
	result = _tmp3_;
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

void
bird_font_preferences_load (void)
{
	GFile* config_dir = NULL;
	GFile* settings = NULL;
	FILE* settings_file = NULL;
	FILE* b = NULL;
	gchar* l = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GeeHashMap* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	FILE* _tmp8_;
	FILE* _tmp9_;
	FILE* _tmp14_;
	FILE* _tmp15_;
	gchar* _tmp16_;
	_tmp0_ = bird_font_bird_font_get_settings_directory ();
	_g_object_unref0 (config_dir);
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	_tmp2_ = bird_font_get_child (_tmp1_, "settings");
	_g_object_unref0 (settings);
	settings = _tmp2_;
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (bird_font_preferences_data);
	bird_font_preferences_data = _tmp3_;
	_tmp4_ = settings;
	if (!g_file_query_exists (_tmp4_, NULL)) {
		_g_free0 (l);
		_fclose0 (settings_file);
		_g_object_unref0 (settings);
		_g_object_unref0 (config_dir);
		return;
	}
	_tmp5_ = settings;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = (gchar*) _tmp6_;
	_tmp8_ = g_fopen (_tmp7_, "r");
	_fclose0 (settings_file);
	settings_file = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = settings_file;
	if (_tmp9_ == NULL) {
		FILE* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = stderr;
		_tmp11_ = settings;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = (gchar*) _tmp12_;
		fprintf (_tmp10_, "Failed to load settings from file %s.\n", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (l);
		_fclose0 (settings_file);
		_g_object_unref0 (settings);
		_g_object_unref0 (config_dir);
		return;
	}
	_tmp14_ = settings_file;
	b = (FILE*) _tmp14_;
	_tmp15_ = b;
	_tmp16_ = g_file_stream_read_line (_tmp15_);
	_g_free0 (l);
	l = _tmp16_;
	while (TRUE) {
		FILE* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* line = NULL;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gint i = 0;
		gint s = 0;
		const gchar* _tmp23_;
		gchar* key = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* val = NULL;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		GeeHashMap* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp17_ = b;
		_tmp18_ = g_file_stream_read_line (_tmp17_);
		_g_free0 (l);
		l = _tmp18_;
		_tmp19_ = l;
		if (!(_tmp19_ != NULL)) {
			break;
		}
		_tmp20_ = l;
		_tmp21_ = g_strdup ((const gchar*) _tmp20_);
		_g_free0 (line);
		line = _tmp21_;
		_tmp22_ = line;
		if (string_get_char (_tmp22_, (glong) 0) == ((gunichar) '#')) {
			_g_free0 (line);
			continue;
		}
		i = 0;
		s = 0;
		_tmp23_ = line;
		i = string_index_of_char (_tmp23_, (gunichar) ' ', s);
		_tmp24_ = line;
		_tmp25_ = string_substring (_tmp24_, (glong) s, (glong) (i - s));
		key = _tmp25_;
		s = i + 1;
		_tmp26_ = line;
		i = string_index_of_char (_tmp26_, (gunichar) '"', s);
		s = i + 1;
		_tmp27_ = line;
		i = string_index_of_char (_tmp27_, (gunichar) '"', s);
		_tmp28_ = line;
		_tmp29_ = string_substring (_tmp28_, (glong) s, (glong) (i - s));
		val = _tmp29_;
		_tmp30_ = bird_font_preferences_data;
		_tmp31_ = key;
		_tmp32_ = val;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, _tmp32_);
		_g_free0 (val);
		_g_free0 (key);
		_g_free0 (line);
	}
	_g_free0 (l);
	_fclose0 (settings_file);
	_g_object_unref0 (settings);
	_g_object_unref0 (config_dir);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
bird_font_preferences_save (void)
{
	GError* _inner_error0_ = NULL;
	{
		GFile* config_dir = NULL;
		GFile* _tmp0_;
		GFile* settings = NULL;
		GFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFileOutputStream* _tmp6_ = NULL;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_;
		GDataOutputStream* os = NULL;
		GDataOutputStream* _tmp9_;
		guint8* d = NULL;
		gint d_length1 = 0;
		gint _d_size_ = 0;
		glong written = 0L;
		GString* sb = NULL;
		GString* _tmp10_;
		GString* _tmp11_;
		GString* _tmp12_;
		GString* _tmp31_;
		const gchar* _tmp32_;
		guint8* _tmp33_;
		gint _tmp33__length1;
		gint _tmp34_ = 0;
		guint8* _tmp35_;
		gint _tmp35__length1;
		guint8* _tmp36_;
		gint _tmp36__length1;
		_tmp0_ = bird_font_bird_font_get_settings_directory ();
		config_dir = _tmp0_;
		_tmp1_ = config_dir;
		_tmp2_ = bird_font_get_child (_tmp1_, "settings");
		settings = _tmp2_;
		_tmp3_ = config_dir;
		g_return_if_fail (g_file_query_exists (_tmp3_, NULL));
		_tmp4_ = settings;
		if (g_file_query_exists (_tmp4_, NULL)) {
			GFile* _tmp5_;
			_tmp5_ = settings;
			g_file_delete (_tmp5_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (settings);
				_g_object_unref0 (config_dir);
				goto __catch0_g_error;
			}
		}
		_tmp7_ = settings;
		_tmp8_ = g_file_create (_tmp7_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (settings);
			_g_object_unref0 (config_dir);
			goto __catch0_g_error;
		}
		_tmp9_ = g_data_output_stream_new ((GOutputStream*) _tmp6_);
		os = _tmp9_;
		written = (glong) 0;
		_tmp10_ = g_string_new ("");
		sb = _tmp10_;
		_tmp11_ = sb;
		g_string_append (_tmp11_, "# BirdFont settings\n");
		_tmp12_ = sb;
		g_string_append (_tmp12_, "# Version: 1.0\n");
		{
			GeeIterator* _k_it = NULL;
			GeeHashMap* _tmp13_;
			GeeSet* _tmp14_;
			GeeSet* _tmp15_;
			GeeSet* _tmp16_;
			GeeIterator* _tmp17_;
			GeeIterator* _tmp18_;
			_tmp13_ = bird_font_preferences_data;
			_tmp14_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp16_);
			_k_it = _tmp18_;
			while (TRUE) {
				GeeIterator* _tmp19_;
				gchar* k = NULL;
				GeeIterator* _tmp20_;
				gpointer _tmp21_;
				GString* _tmp22_;
				const gchar* _tmp23_;
				GString* _tmp24_;
				GString* _tmp25_;
				GeeHashMap* _tmp26_;
				const gchar* _tmp27_;
				gpointer _tmp28_;
				gchar* _tmp29_;
				GString* _tmp30_;
				_tmp19_ = _k_it;
				if (!gee_iterator_next (_tmp19_)) {
					break;
				}
				_tmp20_ = _k_it;
				_tmp21_ = gee_iterator_get (_tmp20_);
				k = (gchar*) _tmp21_;
				_tmp22_ = sb;
				_tmp23_ = k;
				g_string_append (_tmp22_, _tmp23_);
				_tmp24_ = sb;
				g_string_append (_tmp24_, " \"");
				_tmp25_ = sb;
				_tmp26_ = bird_font_preferences_data;
				_tmp27_ = k;
				_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
				_tmp29_ = (gchar*) _tmp28_;
				g_string_append (_tmp25_, _tmp29_);
				_g_free0 (_tmp29_);
				_tmp30_ = sb;
				g_string_append (_tmp30_, "\"\n");
				_g_free0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp31_ = sb;
		_tmp32_ = _tmp31_->str;
		_tmp33_ = string_get_data (_tmp32_, &_tmp34_);
		_tmp33__length1 = _tmp34_;
		_tmp35_ = _tmp33_;
		_tmp35__length1 = _tmp33__length1;
		_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup2 (_tmp35_, _tmp35__length1) : _tmp35_;
		_tmp36__length1 = _tmp35__length1;
		d = (g_free (d), NULL);
		d = _tmp36_;
		d_length1 = _tmp36__length1;
		_d_size_ = d_length1;
		while (TRUE) {
			guint8* _tmp37_;
			gint _tmp37__length1;
			gssize _tmp38_ = 0L;
			GDataOutputStream* _tmp39_;
			guint8* _tmp40_;
			gint _tmp40__length1;
			guint8* _tmp41_;
			gint _tmp41__length1;
			_tmp37_ = d;
			_tmp37__length1 = d_length1;
			if (!(written < ((glong) _tmp37__length1))) {
				break;
			}
			_tmp39_ = os;
			_tmp40_ = d;
			_tmp40__length1 = d_length1;
			_tmp41_ = d;
			_tmp41__length1 = d_length1;
			_tmp38_ = g_output_stream_write ((GOutputStream*) _tmp39_, _tmp40_ + ((gint) written), (gsize) (_tmp41__length1 - ((gint) written)), NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_string_free0 (sb);
				d = (g_free (d), NULL);
				_g_object_unref0 (os);
				_g_object_unref0 (_tmp6_);
				_g_object_unref0 (settings);
				_g_object_unref0 (config_dir);
				goto __catch0_g_error;
			}
			written += (glong) _tmp38_;
		}
		_g_string_free0 (sb);
		d = (g_free (d), NULL);
		_g_object_unref0 (os);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (settings);
		_g_object_unref0 (config_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = stderr;
		_tmp43_ = e;
		_tmp44_ = _tmp43_->message;
		fprintf (_tmp42_, "Can not save key settings. (%s)", _tmp44_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
bird_font_value_preferences_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_preferences_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_preferences_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_preferences_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_preferences_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_preferences_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_preferences_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontPreferences * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_preferences_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_preferences_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	BirdFontPreferences ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_preferences_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_preferences (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	BirdFontParamSpecPreferences* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_PREFERENCES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_preferences (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_PREFERENCES), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_preferences (GValue* value,
                                 gpointer v_object)
{
	BirdFontPreferences * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_PREFERENCES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_PREFERENCES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_preferences_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_preferences_unref (old);
	}
}

void
bird_font_value_take_preferences (GValue* value,
                                  gpointer v_object)
{
	BirdFontPreferences * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_PREFERENCES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_PREFERENCES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_preferences_unref (old);
	}
}

static void
bird_font_preferences_class_init (BirdFontPreferencesClass * klass,
                                  gpointer klass_data)
{
	bird_font_preferences_parent_class = g_type_class_peek_parent (klass);
	((BirdFontPreferencesClass *) klass)->finalize = bird_font_preferences_finalize;
}

static void
bird_font_preferences_instance_init (BirdFontPreferences * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
bird_font_preferences_finalize (BirdFontPreferences * obj)
{
	BirdFontPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_PREFERENCES, BirdFontPreferences);
	g_signal_handlers_destroy (self);
}

static GType
bird_font_preferences_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_preferences_init, bird_font_value_preferences_free_value, bird_font_value_preferences_copy_value, bird_font_value_preferences_peek_pointer, "p", bird_font_value_preferences_collect_value, "p", bird_font_value_preferences_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontPreferences), 0, (GInstanceInitFunc) bird_font_preferences_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_preferences_type_id;
	bird_font_preferences_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontPreferences", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_preferences_type_id;
}

GType
bird_font_preferences_get_type (void)
{
	static volatile gsize bird_font_preferences_type_id__once = 0;
	if (g_once_init_enter (&bird_font_preferences_type_id__once)) {
		GType bird_font_preferences_type_id;
		bird_font_preferences_type_id = bird_font_preferences_get_type_once ();
		g_once_init_leave (&bird_font_preferences_type_id__once, bird_font_preferences_type_id);
	}
	return bird_font_preferences_type_id__once;
}

gpointer
bird_font_preferences_ref (gpointer instance)
{
	BirdFontPreferences * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_preferences_unref (gpointer instance)
{
	BirdFontPreferences * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_PREFERENCES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

