/* Path.c generated by valac 0.56.16, the Vala compiler
 * generated from Path.vala, do not modify */

/*
Copyright (C) 2012 - 2016 2019 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gee.h>
#include <cairo-gobject.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_PATH_0_PROPERTY,
	BIRD_FONT_PATH_POINTS_PROPERTY,
	BIRD_FONT_PATH_STROKE_PROPERTY,
	BIRD_FONT_PATH_NUM_PROPERTIES
};
static GParamSpec* bird_font_path_properties[BIRD_FONT_PATH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
typedef struct _Block43Data Block43Data;
typedef struct _Block44Data Block44Data;
typedef struct _Block45Data Block45Data;
#define _bird_font_point_converter_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_point_converter_unref (var), NULL)))
typedef struct _Block46Data Block46Data;
typedef struct _Block47Data Block47Data;
typedef struct _Block48Data Block48Data;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block49Data Block49Data;
typedef struct _Block50Data Block50Data;
typedef struct _Block51Data Block51Data;
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontPathPrivate {
	BirdFontEditPoint* last_point;
	gdouble path_stroke_width;
	BirdFontPathList* fast_stroke;
	BirdFontStrokeTask* stroke_creator;
	gboolean edit;
	gboolean open;
	gboolean no_derived_direction;
	gboolean clockwise_direction;
};

struct _Block43Data {
	int _ref_count_;
	BirdFontPath* self;
	BirdFontPath* p;
};

struct _Block44Data {
	int _ref_count_;
	BirdFontPath* self;
	BirdFontPath* flat;
};

struct _Block45Data {
	int _ref_count_;
	BirdFontPath* self;
	gdouble tolerance;
	gboolean g;
	BirdFontEditPoint* ep;
	gdouble min;
};

struct _Block46Data {
	int _ref_count_;
	BirdFontPath* self;
	gdouble position;
	gdouble min;
	gdouble closest_x;
	gdouble closest_y;
	BirdFontEditPoint* ep;
};

struct _Block47Data {
	int _ref_count_;
	BirdFontPath* self;
	gdouble min;
	gdouble n;
	gboolean g;
	gdouble ox;
	gdouble oy;
	BirdFontEditPoint* i;
	BirdFontEditPoint* previous_point;
	BirdFontEditPoint* next_point;
	gdouble step;
	gdouble x;
	gdouble y;
};

struct _Block48Data {
	int _ref_count_;
	BirdFontPath* self;
	BirdFontPathRasterIterator iter;
	gpointer iter_target;
	gint steps;
};

struct _Block49Data {
	int _ref_count_;
	BirdFontPath* self;
	gdouble px;
	gdouble py;
	gdouble xc;
	gdouble yc;
	cairo_t* cr;
};

struct _Block50Data {
	int _ref_count_;
	gdouble min_distance;
	gdouble npx;
	gdouble npy;
	gdouble rmin_t;
	gdouble rmax_t;
	gboolean found;
	gint step;
	gdouble px;
	gdouble py;
};

struct _Block51Data {
	int _ref_count_;
	BirdFontPath* self;
	BirdFontStrokeTask* task;
};

static gint BirdFontPath_private_offset;
static gpointer bird_font_path_parent_class = NULL;
gdouble bird_font_path_stroke_width = (gdouble) 0;
gboolean bird_font_path_show_all_line_handles = TRUE;
static gboolean bird_font_path__fill_open_path;
static gboolean bird_font_path__fill_open_path = FALSE;
static BirdFontText* bird_font_path_arrow;
static BirdFontText* bird_font_path_arrow = NULL;

static void bird_font_path_draw_next (BirdFontPath* self,
                               BirdFontEditPoint* e,
                               BirdFontEditPoint* en,
                               cairo_t* cr,
                               gboolean highlighted);
static void bird_font_path_draw_double_curve (BirdFontEditPoint* e,
                                       BirdFontEditPoint* en,
                                       cairo_t* cr,
                                       gboolean highlighted);
static void bird_font_path_draw_curve (BirdFontEditPoint* e,
                                BirdFontEditPoint* en,
                                cairo_t* cr,
                                gboolean highlighted,
                                gdouble alpha);
static void bird_font_path_reverse_points (BirdFontPath* self);
static gdouble bird_font_path_clockwise_sum (BirdFontPath* self);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static gboolean ___lambda28_ (Block43Data* _data43_,
                       BirdFontEditPoint* a,
                       BirdFontEditPoint* b);
static gboolean ____lambda28__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                        BirdFontEditPoint* stop,
                                                        gpointer self);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static gboolean __lambda50_ (Block44Data* _data44_,
                      gdouble x,
                      gdouble y,
                      gdouble t);
static gboolean ___lambda50__bird_font_path_raster_iterator (gdouble x,
                                                      gdouble y,
                                                      gdouble step,
                                                      gpointer self);
static void bird_font_path_update_region_boundaries_for_segment (BirdFontPath* self,
                                                          BirdFontEditPoint* a,
                                                          BirdFontEditPoint* b);
static gboolean ___lambda21_ (BirdFontPath* self,
                       gdouble cx,
                       gdouble cy);
static gboolean ____lambda21__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean ___lambda22_ (BirdFontPath* self,
                       gdouble cx,
                       gdouble cy);
static gboolean ____lambda22__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean ___lambda23_ (BirdFontPath* self,
                       gdouble cx,
                       gdouble cy);
static gboolean ____lambda23__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean ___lambda24_ (BirdFontPath* self,
                       gdouble cx,
                       gdouble cy);
static gboolean ____lambda24__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean __lambda20_ (BirdFontPath* self,
                      BirdFontEditPoint* a,
                      BirdFontEditPoint* b);
static gboolean ___lambda20__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                       BirdFontEditPoint* stop,
                                                       gpointer self);
static gboolean bird_font_path_test_is_outline_of_path (BirdFontPath* self,
                                                 BirdFontPath* outline);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static gboolean ___lambda373_ (Block45Data* _data45_,
                        gdouble cx,
                        gdouble cy);
static gboolean ____lambda373__bird_font_path_raster_iterator (gdouble x,
                                                        gdouble y,
                                                        gdouble step,
                                                        gpointer self);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static gboolean ___lambda29_ (Block46Data* _data46_,
                       gdouble cx,
                       gdouble cy,
                       gdouble t);
static gboolean ____lambda29__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static gboolean ___lambda30_ (Block47Data* _data47_,
                       gdouble cx,
                       gdouble cy,
                       gdouble t);
static gboolean ____lambda30__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean bird_font_path_all_of_double (gdouble x0,
                                       gdouble y0,
                                       gdouble x1,
                                       gdouble y1,
                                       gdouble x2,
                                       gdouble y2,
                                       gdouble x3,
                                       gdouble y3,
                                       BirdFontPathRasterIterator iter,
                                       gpointer iter_target,
                                       gdouble steps,
                                       gdouble min_t,
                                       gdouble max_t);
static gboolean bird_font_path_all_of_quadratic_curve (gdouble x0,
                                                gdouble y0,
                                                gdouble x1,
                                                gdouble y1,
                                                gdouble x2,
                                                gdouble y2,
                                                BirdFontPathRasterIterator iter,
                                                gpointer iter_target,
                                                gdouble steps,
                                                gdouble min_t,
                                                gdouble max_t);
static gboolean bird_font_path_all_of_curve (gdouble x0,
                                      gdouble y0,
                                      gdouble x1,
                                      gdouble y1,
                                      gdouble x2,
                                      gdouble y2,
                                      gdouble x3,
                                      gdouble y3,
                                      BirdFontPathRasterIterator iter,
                                      gpointer iter_target,
                                      gdouble steps,
                                      gdouble min_t,
                                      gdouble max_t);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static gboolean __lambda37_ (Block48Data* _data48_,
                      BirdFontEditPoint* start,
                      BirdFontEditPoint* stop);
static gboolean ___lambda37__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                                       BirdFontEditPoint* stop,
                                                       gpointer self);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static gboolean __lambda374_ (Block49Data* _data49_,
                       gdouble x,
                       gdouble y);
static gboolean ___lambda374__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static gboolean ____lambda35_ (Block50Data* _data50_,
                        gdouble xa,
                        gdouble ya,
                        gdouble ta);
static gboolean _____lambda35__bird_font_path_raster_iterator (gdouble x,
                                                        gdouble y,
                                                        gdouble step,
                                                        gpointer self);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static gboolean __lambda110_ (Block51Data* _data51_);
static gboolean ___lambda110__gsource_func (gpointer self);
static void bird_font_path_adjust_interpolated_handles (BirdFontPath* self,
                                                 BirdFontPath* master,
                                                 gdouble edge);
static void bird_font_path_adjust_interpolated_handle (BirdFontPath* self,
                                                BirdFontPath* master,
                                                BirdFontEditPoint* ep,
                                                BirdFontEditPoint* next,
                                                gdouble edge);
VALA_EXTERN void bird_font_bird_font_file_parse_path_data (const gchar* data,
                                               BirdFontPath* path);
static void bird_font_path_finalize (GObject * obj);
static GType bird_font_path_get_type_once (void);
static void _vala_bird_font_path_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_bird_font_path_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static GType
bird_font_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_DIRECTION_CLOCKWISE, "BIRD_FONT_DIRECTION_CLOCKWISE", "clockwise"}, {BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE, "BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE", "counter-clockwise"}, {0, NULL, NULL}};
	GType bird_font_direction_type_id;
	bird_font_direction_type_id = g_enum_register_static ("BirdFontDirection", values);
	return bird_font_direction_type_id;
}

GType
bird_font_direction_get_type (void)
{
	static volatile gsize bird_font_direction_type_id__once = 0;
	if (g_once_init_enter (&bird_font_direction_type_id__once)) {
		GType bird_font_direction_type_id;
		bird_font_direction_type_id = bird_font_direction_get_type_once ();
		g_once_init_leave (&bird_font_direction_type_id__once, bird_font_direction_type_id);
	}
	return bird_font_direction_type_id__once;
}

static inline gpointer
bird_font_path_get_instance_private (BirdFontPath* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontPath_private_offset);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

BirdFontPath*
bird_font_path_construct (GType object_type)
{
	BirdFontPath * self = NULL;
	gchar* width = NULL;
	self = (BirdFontPath*) g_object_new (object_type, NULL);
	if (G_UNLIKELY (bird_font_path_stroke_width < ((gdouble) 1))) {
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = bird_font_preferences_get ("stroke_width");
		_g_free0 (width);
		width = _tmp0_;
		_tmp1_ = width;
		if (g_strcmp0 (_tmp1_, "") != 0) {
			const gchar* _tmp2_;
			_tmp2_ = width;
			bird_font_path_stroke_width = double_parse (_tmp2_);
		}
	}
	if (bird_font_path_stroke_width < ((gdouble) 1)) {
		bird_font_path_stroke_width = (gdouble) 1;
	}
	_g_free0 (width);
	return self;
}

BirdFontPath*
bird_font_path_new (void)
{
	return bird_font_path_construct (BIRD_FONT_TYPE_PATH);
}

gboolean
bird_font_path_is_filled (BirdFontPath* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->fill;
	return result;
}

void
bird_font_path_set_fill (BirdFontPath* self,
                         gboolean f)
{
	g_return_if_fail (self != NULL);
	self->fill = f;
}

BirdFontEditPoint*
bird_font_path_get_first_point (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_UNLIKELY (_tmp3_ == 0)) {
		BirdFontEditPoint* _tmp4_;
		g_warning ("Path.vala:135: No point");
		_tmp4_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = bird_font_path_get_points (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, 0);
	result = (BirdFontEditPoint*) _tmp7_;
	return result;
}

BirdFontEditPoint*
bird_font_path_get_last_visible_point (BirdFontPath* self)
{
	BirdFontEditPoint* e = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_UNLIKELY (_tmp3_ == 0)) {
		BirdFontEditPoint* _tmp4_;
		g_warning ("Path.vala:146: No point");
		_tmp4_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		result = _tmp4_;
		_g_object_unref0 (e);
		return result;
	}
	{
		gint i = 0;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = bird_font_path_get_points (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		i = _tmp8_ - 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				BirdFontEditPoint* _tmp14_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ - 1;
				}
				_tmp9_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp11_ = bird_font_path_get_points (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
				_g_object_unref0 (e);
				e = (BirdFontEditPoint*) _tmp13_;
				_tmp14_ = e;
				if (_tmp14_->type != BIRD_FONT_POINT_TYPE_HIDDEN) {
					result = e;
					return result;
				}
			}
		}
	}
	g_warning ("Path.vala:157: Only hidden points");
	_tmp15_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	result = _tmp15_;
	_g_object_unref0 (e);
	return result;
}

BirdFontEditPoint*
bird_font_path_get_last_point (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_UNLIKELY (_tmp3_ == 0)) {
		BirdFontEditPoint* _tmp4_;
		g_warning ("Path.vala:163: No point");
		_tmp4_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = bird_font_path_get_points (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_path_get_points (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp10_ - 1);
	result = (BirdFontEditPoint*) _tmp11_;
	return result;
}

gboolean
bird_font_path_has_direction (BirdFontPath* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->direction_is_set;
	return result;
}

gboolean
bird_font_path_empty (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_ == 0;
	return result;
}

void
bird_font_path_draw_boundaries (BirdFontPath* self,
                                cairo_t* cr)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x = (gdouble) bird_font_glyph_reverse_path_coordinate_x (self->xmin);
	y = (gdouble) bird_font_glyph_reverse_path_coordinate_y (self->ymin);
	x2 = (gdouble) bird_font_glyph_reverse_path_coordinate_x (self->xmax);
	y2 = (gdouble) bird_font_glyph_reverse_path_coordinate_y (self->ymax);
	cairo_save (cr);
	bird_font_theme_color (cr, "Default Background");
	cairo_set_line_width (cr, (gdouble) 2);
	cairo_rectangle (cr, x, y, x2 - x, y2 - y);
	cairo_stroke (cr);
	cairo_restore (cr);
}

void
bird_font_path_draw_outline (BirdFontPath* self,
                             cairo_t* cr)
{
	BirdFontEditPoint* n = NULL;
	BirdFontEditPoint* en = NULL;
	BirdFontEditPoint* em = NULL;
	gint i = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp50_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	n = NULL;
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		return;
	}
	cairo_new_path (cr);
	i = 0;
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _e_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = bird_font_path_get_points (self);
		_tmp5_ = _tmp4_;
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp22_;
			gint _tmp23_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _e_index);
			e = (BirdFontEditPoint*) _tmp12_;
			_tmp13_ = n;
			if (_tmp13_ != NULL) {
				BirdFontEditPoint* _tmp14_;
				gboolean _tmp15_ = FALSE;
				_tmp14_ = n;
				en = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
				if (!self->highlight_last_segment) {
					_tmp15_ = TRUE;
				} else {
					GeeArrayList* _tmp16_;
					GeeArrayList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					_tmp16_ = bird_font_path_get_points (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp15_ = i != (_tmp19_ - 1);
				}
				if (_tmp15_) {
					BirdFontEditPoint* _tmp20_;
					BirdFontEditPoint* _tmp21_;
					_tmp20_ = en;
					_tmp21_ = e;
					bird_font_path_draw_next (self, _tmp20_, _tmp21_, cr, FALSE);
				}
			}
			_tmp22_ = e;
			n = _tmp22_;
			_tmp23_ = i;
			i = _tmp23_ + 1;
			_g_object_unref0 (e);
		}
	}
	if (!bird_font_path_is_open (self)) {
		BirdFontEditPoint* _tmp25_;
		_tmp25_ = n;
		_tmp24_ = _tmp25_ != NULL;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		if (self->highlight_last_segment) {
			GeeArrayList* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* _tmp28_;
			GeeArrayList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			BirdFontEditPoint* _tmp33_;
			BirdFontEditPoint* _tmp34_;
			GeeArrayList* _tmp35_;
			GeeArrayList* _tmp36_;
			gpointer _tmp37_;
			BirdFontEditPoint* _tmp38_;
			BirdFontEditPoint* _tmp39_;
			BirdFontEditPoint* _tmp40_;
			BirdFontEditPoint* _tmp41_;
			cairo_stroke (cr);
			_tmp26_ = bird_font_path_get_points (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = bird_font_path_get_points (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp31_ - 1);
			_tmp33_ = (BirdFontEditPoint*) _tmp32_;
			_tmp34_ = bird_font_edit_point_get_link_item (_tmp33_);
			en = _tmp34_;
			_g_object_unref0 (_tmp33_);
			_tmp35_ = bird_font_path_get_points (self);
			_tmp36_ = _tmp35_;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, 0);
			_tmp38_ = (BirdFontEditPoint*) _tmp37_;
			_tmp39_ = bird_font_edit_point_get_link_item (_tmp38_);
			em = _tmp39_;
			_g_object_unref0 (_tmp38_);
			_tmp40_ = en;
			_tmp41_ = em;
			bird_font_path_draw_next (self, _tmp40_, _tmp41_, cr, FALSE);
			cairo_stroke (cr);
		} else {
			BirdFontEditPoint* _tmp42_;
			GeeArrayList* _tmp43_;
			GeeArrayList* _tmp44_;
			gpointer _tmp45_;
			BirdFontEditPoint* _tmp46_;
			BirdFontEditPoint* _tmp47_;
			BirdFontEditPoint* _tmp48_;
			BirdFontEditPoint* _tmp49_;
			_tmp42_ = n;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
			_tmp43_ = bird_font_path_get_points (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, 0);
			_tmp46_ = (BirdFontEditPoint*) _tmp45_;
			_tmp47_ = bird_font_edit_point_get_link_item (_tmp46_);
			em = _tmp47_;
			_g_object_unref0 (_tmp46_);
			_tmp48_ = en;
			_tmp49_ = em;
			bird_font_path_draw_next (self, _tmp48_, _tmp49_, cr, FALSE);
			cairo_stroke (cr);
		}
	} else {
		cairo_stroke (cr);
	}
	if (self->highlight_last_segment) {
		GeeArrayList* _tmp51_;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		_tmp51_ = bird_font_path_get_points (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_tmp50_ = _tmp54_ >= 2;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		GeeArrayList* _tmp55_;
		GeeArrayList* _tmp56_;
		GeeArrayList* _tmp57_;
		GeeArrayList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gpointer _tmp61_;
		BirdFontEditPoint* _tmp62_;
		GeeArrayList* _tmp63_;
		GeeArrayList* _tmp64_;
		GeeArrayList* _tmp65_;
		GeeArrayList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gpointer _tmp69_;
		BirdFontEditPoint* _tmp70_;
		_tmp55_ = bird_font_path_get_points (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = bird_font_path_get_points (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, _tmp60_ - 2);
		_tmp62_ = (BirdFontEditPoint*) _tmp61_;
		_tmp63_ = bird_font_path_get_points (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = bird_font_path_get_points (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, _tmp68_ - 1);
		_tmp70_ = (BirdFontEditPoint*) _tmp69_;
		bird_font_path_draw_next (self, _tmp62_, _tmp70_, cr, TRUE);
		_g_object_unref0 (_tmp70_);
		_g_object_unref0 (_tmp62_);
		cairo_stroke (cr);
	}
}

void
bird_font_path_draw_edit_points (BirdFontPath* self,
                                 cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	if (bird_font_path_is_editable (self)) {
		{
			GeeArrayList* _e_list = NULL;
			GeeArrayList* _tmp0_;
			GeeArrayList* _tmp1_;
			gint _e_size = 0;
			GeeArrayList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _e_index = 0;
			_tmp0_ = bird_font_path_get_points (self);
			_tmp1_ = _tmp0_;
			_e_list = _tmp1_;
			_tmp2_ = _e_list;
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
			_tmp4_ = _tmp3_;
			_e_size = _tmp4_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				BirdFontEditPoint* e = NULL;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				_e_index = _e_index + 1;
				_tmp5_ = _e_index;
				_tmp6_ = _e_size;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = _e_list;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
				e = (BirdFontEditPoint*) _tmp8_;
				if (bird_font_path_show_all_line_handles) {
					_tmp10_ = TRUE;
				} else {
					BirdFontEditPoint* _tmp11_;
					gboolean _tmp12_;
					gboolean _tmp13_;
					_tmp11_ = e;
					_tmp12_ = bird_font_edit_point_get_selected_point (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp10_ = _tmp13_;
				}
				if (_tmp10_) {
					_tmp9_ = TRUE;
				} else {
					BirdFontEditPoint* _tmp14_;
					_tmp14_ = e;
					_tmp9_ = _tmp14_->selected_handle > 0;
				}
				if (_tmp9_) {
					BirdFontEditPoint* _tmp15_;
					_tmp15_ = e;
					bird_font_path_draw_edit_point_handles (self, _tmp15_, cr);
				}
				_g_object_unref0 (e);
			}
		}
		{
			GeeArrayList* _e_list = NULL;
			GeeArrayList* _tmp16_;
			GeeArrayList* _tmp17_;
			gint _e_size = 0;
			GeeArrayList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _e_index = 0;
			_tmp16_ = bird_font_path_get_points (self);
			_tmp17_ = _tmp16_;
			_e_list = _tmp17_;
			_tmp18_ = _e_list;
			_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_e_size = _tmp20_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				BirdFontEditPoint* e = NULL;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				BirdFontEditPoint* _tmp25_;
				_e_index = _e_index + 1;
				_tmp21_ = _e_index;
				_tmp22_ = _e_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _e_list;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _e_index);
				e = (BirdFontEditPoint*) _tmp24_;
				_tmp25_ = e;
				bird_font_path_draw_edit_point (self, _tmp25_, cr);
				_g_object_unref0 (e);
			}
		}
	}
}

/** Add all control points for a path to the cairo context.
 * Call Context.new_path (); before this method and Context.fill ()
 * to show the path.
 */
static gpointer
_bird_font_color_ref0 (gpointer self)
{
	return self ? bird_font_color_ref (self) : NULL;
}

void
bird_font_path_draw_path (BirdFontPath* self,
                          cairo_t* cr,
                          BirdFontGlyph* glyph,
                          BirdFontColor* color)
{
	BirdFontEditPoint* n = NULL;
	BirdFontEditPoint* en = NULL;
	BirdFontEditPoint* em = NULL;
	BirdFontColor* c = NULL;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	gdouble ex = 0.0;
	gdouble ey = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontWidgetAllocation* _tmp4_;
	BirdFontWidgetAllocation* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	BirdFontEditPoint* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	gpointer _tmp12_;
	BirdFontEditPoint* _tmp13_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	BirdFontColor* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	n = NULL;
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_bird_font_color_unref0 (c);
		return;
	}
	_tmp4_ = glyph->allocation;
	center_x = _tmp4_->width / 2.0;
	_tmp5_ = glyph->allocation;
	center_y = _tmp5_->height / 2.0;
	_tmp6_ = bird_font_path_get_points (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, 0);
	_tmp9_ = (BirdFontEditPoint*) _tmp8_;
	ex = center_x + _tmp9_->x;
	_g_object_unref0 (_tmp9_);
	_tmp10_ = bird_font_path_get_points (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, 0);
	_tmp13_ = (BirdFontEditPoint*) _tmp12_;
	ey = center_y - _tmp13_->y;
	_g_object_unref0 (_tmp13_);
	cairo_move_to (cr, ex, ey);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		gint _e_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _e_index = 0;
		_tmp14_ = bird_font_path_get_points (self);
		_tmp15_ = _tmp14_;
		_e_list = _tmp15_;
		_tmp16_ = _e_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_e_size = _tmp18_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			BirdFontEditPoint* _tmp23_;
			BirdFontEditPoint* _tmp27_;
			_e_index = _e_index + 1;
			_tmp19_ = _e_index;
			_tmp20_ = _e_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _e_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _e_index);
			e = (BirdFontEditPoint*) _tmp22_;
			_tmp23_ = n;
			if (_tmp23_ != NULL) {
				BirdFontEditPoint* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPoint* _tmp26_;
				_tmp24_ = n;
				en = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
				_tmp25_ = en;
				_tmp26_ = e;
				bird_font_path_draw_next (self, _tmp25_, _tmp26_, cr, FALSE);
			}
			_tmp27_ = e;
			n = _tmp27_;
			_g_object_unref0 (e);
		}
	}
	if (!bird_font_path_is_open (self)) {
		GeeArrayList* _tmp30_;
		GeeArrayList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		_tmp30_ = bird_font_path_get_points (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ >= 2;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		BirdFontEditPoint* _tmp34_;
		_tmp34_ = n;
		_tmp28_ = _tmp34_ != NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		BirdFontEditPoint* _tmp35_;
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
		gpointer _tmp38_;
		BirdFontEditPoint* _tmp39_;
		BirdFontEditPoint* _tmp40_;
		BirdFontEditPoint* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		_tmp35_ = n;
		en = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
		_tmp36_ = bird_font_path_get_points (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, 0);
		_tmp39_ = (BirdFontEditPoint*) _tmp38_;
		_tmp40_ = bird_font_edit_point_get_link_item (_tmp39_);
		em = _tmp40_;
		_g_object_unref0 (_tmp39_);
		_tmp41_ = en;
		_tmp42_ = em;
		bird_font_path_draw_next (self, _tmp41_, _tmp42_, cr, FALSE);
	}
	cairo_close_path (cr);
	_tmp43_ = self->color;
	if (_tmp43_ != NULL) {
		BirdFontColor* _tmp44_;
		BirdFontColor* _tmp45_;
		BirdFontColor* _tmp46_;
		BirdFontColor* _tmp47_;
		BirdFontColor* _tmp48_;
		BirdFontColor* _tmp49_;
		_tmp44_ = self->color;
		_tmp45_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
		_bird_font_color_unref0 (c);
		c = _tmp45_;
		_tmp46_ = c;
		_tmp47_ = c;
		_tmp48_ = c;
		_tmp49_ = c;
		cairo_set_source_rgba (cr, _tmp46_->r, _tmp47_->g, _tmp48_->b, _tmp49_->a);
	} else {
		if (color != NULL) {
			BirdFontColor* _tmp50_;
			BirdFontColor* _tmp51_;
			BirdFontColor* _tmp52_;
			BirdFontColor* _tmp53_;
			BirdFontColor* _tmp54_;
			_tmp50_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (color, BIRD_FONT_TYPE_COLOR, BirdFontColor));
			_bird_font_color_unref0 (c);
			c = _tmp50_;
			_tmp51_ = c;
			_tmp52_ = c;
			_tmp53_ = c;
			_tmp54_ = c;
			cairo_set_source_rgba (cr, _tmp51_->r, _tmp52_->g, _tmp53_->b, _tmp54_->a);
		} else {
			if (bird_font_path_is_clockwise (self)) {
				bird_font_theme_color_opacity (cr, "Selected Objects", 0.4);
			} else {
				bird_font_theme_color_opacity (cr, "Selected Objects", 0.8);
			}
		}
	}
	_bird_font_color_unref0 (c);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_path_draw_orientation_arrow (BirdFontPath* self,
                                       cairo_t* cr,
                                       gdouble opacity)
{
	BirdFontEditPoint* top = NULL;
	BirdFontEditPoint* _tmp0_;
	gdouble max = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble angle = 0.0;
	gdouble size = 0.0;
	BirdFontText* arrow_icon = NULL;
	BirdFontText* _tmp14_;
	BirdFontText* _tmp19_;
	BirdFontText* _tmp20_;
	BirdFontText* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontEditPointHandle* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	BirdFontEditPoint* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	top = _tmp0_;
	max = BIRD_FONT_GLYPH_CANVAS_MIN;
	size = 200 * bird_font_screen_get_scale ();
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _e_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _e_index = 0;
		_tmp1_ = bird_font_path_get_points (self);
		_tmp2_ = _tmp1_;
		_e_list = _tmp2_;
		_tmp3_ = _e_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_e_size = _tmp5_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontEditPoint* _tmp10_;
			_e_index = _e_index + 1;
			_tmp6_ = _e_index;
			_tmp7_ = _e_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _e_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _e_index);
			e = (BirdFontEditPoint*) _tmp9_;
			_tmp10_ = e;
			if (_tmp10_->y > max) {
				BirdFontEditPoint* _tmp11_;
				BirdFontEditPoint* _tmp12_;
				BirdFontEditPoint* _tmp13_;
				_tmp11_ = e;
				max = _tmp11_->y;
				_tmp12_ = e;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_g_object_unref0 (top);
				top = _tmp13_;
			}
			_g_object_unref0 (e);
		}
	}
	_tmp14_ = bird_font_path_arrow;
	if (_tmp14_ == NULL) {
		BirdFontText* _tmp15_;
		BirdFontText* _tmp16_;
		BirdFontText* _tmp17_;
		BirdFontText* _tmp18_;
		_tmp15_ = bird_font_text_new ("orientation_arrow", size, (gdouble) 0);
		_g_object_unref0 (arrow_icon);
		arrow_icon = _tmp15_;
		_tmp16_ = arrow_icon;
		bird_font_text_load_font (_tmp16_, "icons.birdfont");
		_tmp17_ = arrow_icon;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (bird_font_path_arrow);
		bird_font_path_arrow = _tmp18_;
	}
	_tmp19_ = bird_font_path_arrow;
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, BIRD_FONT_TYPE_TEXT, BirdFontText));
	_g_object_unref0 (arrow_icon);
	arrow_icon = _tmp20_;
	_tmp21_ = arrow_icon;
	bird_font_theme_text_color_opacity (_tmp21_, "Highlighted 1", opacity);
	_tmp22_ = top;
	_tmp23_ = bird_font_edit_point_get_right_handle (_tmp22_);
	angle = _tmp23_->angle;
	_tmp24_ = top;
	x = (bird_font_glyph_xc () + _tmp24_->x) + ((cos (angle + (G_PI / 2)) * 10) * bird_font_glyph_ivz ());
	_tmp25_ = top;
	y = (bird_font_glyph_yc () - _tmp25_->y) - ((sin (angle + (G_PI / 2)) * 10) * bird_font_glyph_ivz ());
	_tmp26_ = bird_font_path_get_points (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ > 0) {
		gdouble inverted_zoom = 0.0;
		gdouble zoom = 0.0;
		BirdFontText* _tmp30_;
		inverted_zoom = bird_font_glyph_ivz ();
		zoom = 1 / inverted_zoom;
		cairo_scale (cr, inverted_zoom, inverted_zoom);
		cairo_save (cr);
		cairo_translate (cr, x * zoom, y * zoom);
		cairo_rotate (cr, -angle);
		cairo_translate (cr, (-x) * zoom, (-y) * zoom);
		_tmp30_ = arrow_icon;
		bird_font_text_draw_at_baseline (_tmp30_, cr, x * zoom, y * zoom, "");
		cairo_restore (cr);
	}
	_g_object_unref0 (arrow_icon);
	_g_object_unref0 (top);
}

static void
bird_font_path_draw_next (BirdFontPath* self,
                          BirdFontEditPoint* e,
                          BirdFontEditPoint* en,
                          cairo_t* cr,
                          gboolean highlighted)
{
	BirdFontPointType r = 0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontPointType l = 0;
	BirdFontEditPointHandle* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (e);
	r = _tmp0_->type;
	_tmp1_ = bird_font_edit_point_get_left_handle (en);
	l = _tmp1_->type;
	if (r == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = l == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp2_) {
		bird_font_path_draw_double_curve (e, en, cr, highlighted);
	} else {
		bird_font_path_draw_curve (e, en, cr, highlighted, (gdouble) 1);
	}
}

static void
bird_font_path_draw_double_curve (BirdFontEditPoint* e,
                                  BirdFontEditPoint* en,
                                  cairo_t* cr,
                                  gboolean highlighted)
{
	BirdFontEditPoint* middle = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPointHandle* _tmp19_;
	BirdFontEditPointHandle* _tmp20_;
	BirdFontEditPointHandle* _tmp21_;
	BirdFontEditPointHandle* _tmp22_;
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (e);
	_tmp1_ = bird_font_edit_point_handle_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_edit_point_get_left_handle (en);
	_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_edit_point_get_right_handle (e);
	_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
	_tmp8_ = _tmp7_;
	x = _tmp2_ + ((_tmp5_ - _tmp8_) / 2);
	_tmp9_ = bird_font_edit_point_get_right_handle (e);
	_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_edit_point_get_left_handle (en);
	_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = bird_font_edit_point_get_right_handle (e);
	_tmp16_ = bird_font_edit_point_handle_get_y (_tmp15_);
	_tmp17_ = _tmp16_;
	y = _tmp11_ + ((_tmp14_ - _tmp17_) / 2);
	_tmp18_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
	_g_object_unref0 (middle);
	middle = _tmp18_;
	_tmp19_ = bird_font_edit_point_get_left_handle (en);
	_tmp20_ = bird_font_edit_point_handle_copy (_tmp19_);
	_g_object_unref0 (middle->right_handle);
	middle->right_handle = _tmp20_;
	_tmp21_ = middle->right_handle;
	_tmp21_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	_tmp22_ = middle->left_handle;
	_tmp22_->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	bird_font_path_draw_curve (e, middle, cr, highlighted, (gdouble) 1);
	bird_font_path_draw_curve (middle, en, cr, highlighted, (gdouble) 1);
	_g_object_unref0 (middle);
}

static void
bird_font_path_draw_curve (BirdFontEditPoint* e,
                           BirdFontEditPoint* en,
                           cairo_t* cr,
                           gboolean highlighted,
                           gdouble alpha)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble xa = 0.0;
	gdouble ya = 0.0;
	gdouble xb = 0.0;
	gdouble yb = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xd = 0.0;
	gdouble yd = 0.0;
	BirdFontPointType t = 0;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontPointType u = 0;
	BirdFontEditPointHandle* _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	BirdFontGlyph* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = bird_font_edit_point_get_right_handle (e);
	t = _tmp1_->type;
	_tmp2_ = bird_font_edit_point_get_left_handle (en);
	u = _tmp2_->type;
	bird_font_path_get_bezier_points (e, en, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
	xa = _tmp3_;
	ya = _tmp4_;
	xb = _tmp5_;
	yb = _tmp6_;
	xc = _tmp7_;
	yc = _tmp8_;
	xd = _tmp9_;
	yd = _tmp10_;
	if (!highlighted) {
		bird_font_theme_color (cr, "Stroke Color");
	} else {
		bird_font_theme_color (cr, "Highlighted Guide");
	}
	_tmp11_ = g;
	cairo_set_line_width (cr, bird_font_path_stroke_width / _tmp11_->view_zoom);
	cairo_line_to (cr, xa, ya);
	if (t == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = t == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = t == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = u == BIRD_FONT_POINT_TYPE_QUADRATIC;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = u == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = u == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp12_) {
		cairo_curve_to (cr, (xa + (2 * xb)) / 3, (ya + (2 * yb)) / 3, (xd + (2 * xb)) / 3, (yd + (2 * yb)) / 3, xd, yd);
	} else {
		cairo_curve_to (cr, xb, yb, xc, yc, xd, yd);
	}
	_g_object_unref0 (g);
}

/** Curve relative to window center. */
void
bird_font_path_get_bezier_points (BirdFontEditPoint* e,
                                  BirdFontEditPoint* en,
                                  gdouble* xa,
                                  gdouble* ya,
                                  gdouble* xb,
                                  gdouble* yb,
                                  gdouble* xc,
                                  gdouble* yc,
                                  gdouble* xd,
                                  gdouble* yd)
{
	gdouble _vala_xa = 0.0;
	gdouble _vala_ya = 0.0;
	gdouble _vala_xb = 0.0;
	gdouble _vala_yb = 0.0;
	gdouble _vala_xc = 0.0;
	gdouble _vala_yc = 0.0;
	gdouble _vala_xd = 0.0;
	gdouble _vala_yd = 0.0;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble center_x = 0.0;
	gdouble center_y = 0.0;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = g->allocation;
	center_x = _tmp1_->width / 2.0;
	_tmp2_ = g->allocation;
	center_y = _tmp2_->height / 2.0;
	_vala_xa = center_x + e->x;
	_vala_ya = center_y - e->y;
	_tmp3_ = bird_font_edit_point_get_right_handle (e);
	_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_xb = center_x + _tmp5_;
	_tmp6_ = bird_font_edit_point_get_right_handle (e);
	_tmp7_ = bird_font_edit_point_handle_get_y (_tmp6_);
	_tmp8_ = _tmp7_;
	_vala_yb = center_y - _tmp8_;
	_tmp9_ = bird_font_edit_point_get_left_handle (en);
	_tmp10_ = bird_font_edit_point_handle_get_x (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_xc = center_x + _tmp11_;
	_tmp12_ = bird_font_edit_point_get_left_handle (en);
	_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
	_tmp14_ = _tmp13_;
	_vala_yc = center_y - _tmp14_;
	_vala_xd = center_x + en->x;
	_vala_yd = center_y - en->y;
	_g_object_unref0 (g);
	if (xa) {
		*xa = _vala_xa;
	}
	if (ya) {
		*ya = _vala_ya;
	}
	if (xb) {
		*xb = _vala_xb;
	}
	if (yb) {
		*yb = _vala_yb;
	}
	if (xc) {
		*xc = _vala_xc;
	}
	if (yc) {
		*yc = _vala_yc;
	}
	if (xd) {
		*xd = _vala_xd;
	}
	if (yd) {
		*yd = _vala_yd;
	}
}

/** Curve absolute glyph data. */
void
bird_font_path_get_abs_bezier_points (BirdFontEditPoint* e,
                                      BirdFontEditPoint* en,
                                      gdouble* xa,
                                      gdouble* ya,
                                      gdouble* xb,
                                      gdouble* yb,
                                      gdouble* xc,
                                      gdouble* yc,
                                      gdouble* xd,
                                      gdouble* yd)
{
	gdouble _vala_xa = 0.0;
	gdouble _vala_ya = 0.0;
	gdouble _vala_xb = 0.0;
	gdouble _vala_yb = 0.0;
	gdouble _vala_xc = 0.0;
	gdouble _vala_yc = 0.0;
	gdouble _vala_xd = 0.0;
	gdouble _vala_yd = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	_vala_xa = +e->x;
	_vala_ya = -e->y;
	_tmp0_ = bird_font_edit_point_get_right_handle (e);
	_tmp1_ = bird_font_edit_point_handle_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_xb = +_tmp2_;
	_tmp3_ = bird_font_edit_point_get_right_handle (e);
	_tmp4_ = bird_font_edit_point_handle_get_y (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_yb = -_tmp5_;
	_tmp6_ = bird_font_edit_point_get_left_handle (en);
	_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
	_tmp8_ = _tmp7_;
	_vala_xc = +_tmp8_;
	_tmp9_ = bird_font_edit_point_get_left_handle (en);
	_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_yc = -_tmp11_;
	_vala_xd = +en->x;
	_vala_yd = -en->y;
	if (xa) {
		*xa = _vala_xa;
	}
	if (ya) {
		*ya = _vala_ya;
	}
	if (xb) {
		*xb = _vala_xb;
	}
	if (yb) {
		*yb = _vala_yb;
	}
	if (xc) {
		*xc = _vala_xc;
	}
	if (yc) {
		*yc = _vala_yc;
	}
	if (xd) {
		*xd = _vala_xd;
	}
	if (yd) {
		*yd = _vala_yd;
	}
}

/** Line points relative to centrum. */
void
bird_font_path_get_line_points (BirdFontEditPoint* e,
                                BirdFontEditPoint* en,
                                gdouble* xa,
                                gdouble* ya,
                                gdouble* xb,
                                gdouble* yb)
{
	gdouble _vala_xa = 0.0;
	gdouble _vala_ya = 0.0;
	gdouble _vala_xb = 0.0;
	gdouble _vala_yb = 0.0;
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	xc = bird_font_glyph_xc ();
	yc = bird_font_glyph_yc ();
	_vala_xa = xc + e->x;
	_vala_ya = yc - e->y;
	_vala_xb = xc + en->x;
	_vala_yb = yc - en->y;
	if (xa) {
		*xa = _vala_xa;
	}
	if (ya) {
		*ya = _vala_ya;
	}
	if (xb) {
		*xb = _vala_xb;
	}
	if (yb) {
		*yb = _vala_yb;
	}
}

void
bird_font_path_draw_line (BirdFontPath* self,
                          BirdFontEditPoint* e,
                          BirdFontEditPoint* en,
                          cairo_t* cr,
                          gdouble alpha)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble ax = 0.0;
	gdouble ay = 0.0;
	gdouble bx = 0.0;
	gdouble by = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	g_return_if_fail (en != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	bird_font_path_get_line_points (e, en, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	ax = _tmp1_;
	ay = _tmp2_;
	bx = _tmp3_;
	by = _tmp4_;
	bird_font_theme_color (cr, "Handle Color");
	cairo_set_line_width (cr, 1.7 * (bird_font_path_stroke_width / g->view_zoom));
	cairo_line_to (cr, ax, ay);
	cairo_line_to (cr, bx, by);
	cairo_stroke (cr);
	_g_object_unref0 (g);
}

void
bird_font_path_draw_edit_point (BirdFontPath* self,
                                BirdFontEditPoint* e,
                                cairo_t* cr)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	g_return_if_fail (cr != NULL);
	bird_font_path_draw_edit_point_center (e, cr);
}

void
bird_font_path_draw_edit_point_handles (BirdFontPath* self,
                                        BirdFontEditPoint* e,
                                        cairo_t* cr)
{
	BirdFontColor* color_left = NULL;
	BirdFontColor* _tmp0_;
	BirdFontColor* color_right = NULL;
	BirdFontColor* _tmp1_;
	BirdFontEditPoint* handle_right = NULL;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPoint* handle_left = NULL;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_theme_get_color ("Control Point Handle");
	color_left = _tmp0_;
	_tmp1_ = bird_font_theme_get_color ("Control Point Handle");
	color_right = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_right_handle (e);
	_tmp3_ = bird_font_edit_point_handle_get_point (_tmp2_);
	handle_right = _tmp3_;
	_tmp4_ = bird_font_edit_point_get_left_handle (e);
	_tmp5_ = bird_font_edit_point_handle_get_point (_tmp4_);
	handle_left = _tmp5_;
	cairo_stroke (cr);
	if (e->type != BIRD_FONT_POINT_TYPE_HIDDEN) {
		BirdFontEditPointHandle* _tmp6_;
		BirdFontEditPointHandle* _tmp11_;
		BirdFontEditPointHandle* _tmp16_;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp39_ = FALSE;
		_tmp6_ = bird_font_edit_point_get_right_handle (e);
		if (_tmp6_->selected) {
			BirdFontColor* _tmp7_;
			_tmp7_ = bird_font_theme_get_color ("Selected Control Point Handle");
			_bird_font_color_unref0 (color_right);
			color_right = _tmp7_;
		} else {
			BirdFontEditPointHandle* _tmp8_;
			_tmp8_ = bird_font_edit_point_get_right_handle (e);
			if (_tmp8_->active) {
				BirdFontColor* _tmp9_;
				_tmp9_ = bird_font_theme_get_color ("Active Handle");
				_bird_font_color_unref0 (color_right);
				color_right = _tmp9_;
			} else {
				BirdFontColor* _tmp10_;
				_tmp10_ = bird_font_theme_get_color ("Control Point Handle");
				_bird_font_color_unref0 (color_right);
				color_right = _tmp10_;
			}
		}
		_tmp11_ = bird_font_edit_point_get_left_handle (e);
		if (_tmp11_->selected) {
			BirdFontColor* _tmp12_;
			_tmp12_ = bird_font_theme_get_color ("Selected Control Point Handle");
			_bird_font_color_unref0 (color_left);
			color_left = _tmp12_;
		} else {
			BirdFontEditPointHandle* _tmp13_;
			_tmp13_ = bird_font_edit_point_get_left_handle (e);
			if (_tmp13_->active) {
				BirdFontColor* _tmp14_;
				_tmp14_ = bird_font_theme_get_color ("Active Handle");
				_bird_font_color_unref0 (color_left);
				color_left = _tmp14_;
			} else {
				BirdFontColor* _tmp15_;
				_tmp15_ = bird_font_theme_get_color ("Control Point Handle");
				_bird_font_color_unref0 (color_left);
				color_left = _tmp15_;
			}
		}
		_tmp16_ = bird_font_edit_point_get_right_handle (e);
		if (_tmp16_->selected) {
			BirdFontColor* _tmp17_;
			_tmp17_ = bird_font_theme_get_color ("Selected Control Point Handle");
			_bird_font_color_unref0 (color_right);
			color_right = _tmp17_;
		} else {
			BirdFontEditPointHandle* _tmp18_;
			_tmp18_ = bird_font_edit_point_get_right_handle (e);
			if (_tmp18_->active) {
				BirdFontColor* _tmp19_;
				_tmp19_ = bird_font_theme_get_color ("Active Handle");
				_bird_font_color_unref0 (color_right);
				color_right = _tmp19_;
			} else {
				BirdFontColor* _tmp20_;
				_tmp20_ = bird_font_theme_get_color ("Control Point Handle");
				_bird_font_color_unref0 (color_right);
				color_right = _tmp20_;
			}
		}
		if (!self->hide_end_handle) {
			_tmp21_ = TRUE;
		} else {
			gboolean _tmp22_ = FALSE;
			if (bird_font_path_is_open (self)) {
				GeeArrayList* _tmp23_;
				GeeArrayList* _tmp24_;
				GeeArrayList* _tmp25_;
				GeeArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gpointer _tmp29_;
				BirdFontEditPoint* _tmp30_;
				_tmp23_ = bird_font_path_get_points (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = bird_font_path_get_points (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp28_ - 1);
				_tmp30_ = (BirdFontEditPoint*) _tmp29_;
				_tmp22_ = e == _tmp30_;
				_g_object_unref0 (_tmp30_);
			} else {
				_tmp22_ = FALSE;
			}
			_tmp21_ = !_tmp22_;
		}
		if (_tmp21_) {
			BirdFontEditPoint* _tmp31_;
			BirdFontEditPointHandle* _tmp32_;
			gdouble _tmp33_;
			gdouble _tmp34_;
			BirdFontEditPointHandle* _tmp35_;
			gdouble _tmp36_;
			gdouble _tmp37_;
			BirdFontColor* _tmp38_;
			_tmp31_ = handle_right;
			bird_font_path_draw_line (self, _tmp31_, e, cr, 0.15);
			_tmp32_ = bird_font_edit_point_get_right_handle (e);
			_tmp33_ = bird_font_edit_point_handle_get_x (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = bird_font_edit_point_get_right_handle (e);
			_tmp36_ = bird_font_edit_point_handle_get_y (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = color_right;
			bird_font_path_draw_control_point (cr, _tmp34_, _tmp37_, _tmp38_, 3.5);
		}
		if (bird_font_path_is_open (self)) {
			GeeArrayList* _tmp40_;
			GeeArrayList* _tmp41_;
			gpointer _tmp42_;
			BirdFontEditPoint* _tmp43_;
			_tmp40_ = bird_font_path_get_points (self);
			_tmp41_ = _tmp40_;
			_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 0);
			_tmp43_ = (BirdFontEditPoint*) _tmp42_;
			_tmp39_ = e == _tmp43_;
			_g_object_unref0 (_tmp43_);
		} else {
			_tmp39_ = FALSE;
		}
		if (!_tmp39_) {
			BirdFontEditPoint* _tmp44_;
			BirdFontEditPointHandle* _tmp45_;
			gdouble _tmp46_;
			gdouble _tmp47_;
			BirdFontEditPointHandle* _tmp48_;
			gdouble _tmp49_;
			gdouble _tmp50_;
			BirdFontColor* _tmp51_;
			_tmp44_ = handle_left;
			bird_font_path_draw_line (self, _tmp44_, e, cr, 0.15);
			_tmp45_ = bird_font_edit_point_get_left_handle (e);
			_tmp46_ = bird_font_edit_point_handle_get_x (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = bird_font_edit_point_get_left_handle (e);
			_tmp49_ = bird_font_edit_point_handle_get_y (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = color_left;
			bird_font_path_draw_control_point (cr, _tmp47_, _tmp50_, _tmp51_, 3.5);
		}
	}
	_g_object_unref0 (handle_left);
	_g_object_unref0 (handle_right);
	_bird_font_color_unref0 (color_right);
	_bird_font_color_unref0 (color_left);
}

void
bird_font_path_draw_edit_point_center (BirdFontEditPoint* e,
                                       cairo_t* cr)
{
	BirdFontColor* c = NULL;
	g_return_if_fail (e != NULL);
	g_return_if_fail (cr != NULL);
	if (e->type != BIRD_FONT_POINT_TYPE_HIDDEN) {
		gboolean _tmp0_ = FALSE;
		BirdFontColor* _tmp41_;
		if (e->type == BIRD_FONT_POINT_TYPE_CUBIC) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = e->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
		}
		if (_tmp0_) {
			if (bird_font_edit_point_is_selected (e)) {
				gboolean _tmp1_;
				gboolean _tmp2_;
				_tmp1_ = bird_font_edit_point_get_active_point (e);
				_tmp2_ = _tmp1_;
				if (_tmp2_) {
					BirdFontColor* _tmp3_;
					_tmp3_ = e->color;
					if (_tmp3_ != NULL) {
						BirdFontColor* _tmp4_;
						BirdFontColor* _tmp5_;
						_tmp4_ = e->color;
						_tmp5_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp5_;
					} else {
						BirdFontColor* _tmp6_;
						_tmp6_ = bird_font_theme_get_color ("Selected Active Cubic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp6_;
					}
				} else {
					BirdFontColor* _tmp7_;
					_tmp7_ = e->color;
					if (_tmp7_ != NULL) {
						BirdFontColor* _tmp8_;
						BirdFontColor* _tmp9_;
						_tmp8_ = e->color;
						_tmp9_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp9_;
					} else {
						BirdFontColor* _tmp10_;
						_tmp10_ = bird_font_theme_get_color ("Selected Cubic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp10_;
					}
				}
			} else {
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp11_ = bird_font_edit_point_get_active_point (e);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					BirdFontColor* _tmp13_;
					_tmp13_ = e->color;
					if (_tmp13_ != NULL) {
						BirdFontColor* _tmp14_;
						BirdFontColor* _tmp15_;
						_tmp14_ = e->color;
						_tmp15_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp15_;
					} else {
						BirdFontColor* _tmp16_;
						_tmp16_ = bird_font_theme_get_color ("Active Cubic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp16_;
					}
				} else {
					BirdFontColor* _tmp17_;
					_tmp17_ = e->color;
					if (_tmp17_ != NULL) {
						BirdFontColor* _tmp18_;
						BirdFontColor* _tmp19_;
						_tmp18_ = e->color;
						_tmp19_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp19_;
					} else {
						BirdFontColor* _tmp20_;
						_tmp20_ = bird_font_theme_get_color ("Cubic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp20_;
					}
				}
			}
		} else {
			if (bird_font_edit_point_is_selected (e)) {
				gboolean _tmp21_;
				gboolean _tmp22_;
				_tmp21_ = bird_font_edit_point_get_active_point (e);
				_tmp22_ = _tmp21_;
				if (_tmp22_) {
					BirdFontColor* _tmp23_;
					_tmp23_ = e->color;
					if (_tmp23_ != NULL) {
						BirdFontColor* _tmp24_;
						BirdFontColor* _tmp25_;
						_tmp24_ = e->color;
						_tmp25_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp25_;
					} else {
						BirdFontColor* _tmp26_;
						_tmp26_ = bird_font_theme_get_color ("Selected Active Quadratic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp26_;
					}
				} else {
					BirdFontColor* _tmp27_;
					_tmp27_ = e->color;
					if (_tmp27_ != NULL) {
						BirdFontColor* _tmp28_;
						BirdFontColor* _tmp29_;
						_tmp28_ = e->color;
						_tmp29_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp29_;
					} else {
						BirdFontColor* _tmp30_;
						_tmp30_ = bird_font_theme_get_color ("Selected Quadratic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp30_;
					}
				}
			} else {
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp31_ = bird_font_edit_point_get_active_point (e);
				_tmp32_ = _tmp31_;
				if (_tmp32_) {
					BirdFontColor* _tmp33_;
					_tmp33_ = e->color;
					if (_tmp33_ != NULL) {
						BirdFontColor* _tmp34_;
						BirdFontColor* _tmp35_;
						_tmp34_ = e->color;
						_tmp35_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp35_;
					} else {
						BirdFontColor* _tmp36_;
						_tmp36_ = bird_font_theme_get_color ("Active Quadratic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp36_;
					}
				} else {
					BirdFontColor* _tmp37_;
					_tmp37_ = e->color;
					if (_tmp37_ != NULL) {
						BirdFontColor* _tmp38_;
						BirdFontColor* _tmp39_;
						_tmp38_ = e->color;
						_tmp39_ = _bird_font_color_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
						_bird_font_color_unref0 (c);
						c = _tmp39_;
					} else {
						BirdFontColor* _tmp40_;
						_tmp40_ = bird_font_theme_get_color ("Quadratic Control Point");
						_bird_font_color_unref0 (c);
						c = _tmp40_;
					}
				}
			}
		}
		_tmp41_ = c;
		bird_font_path_draw_control_point (cr, e->x, e->y, _tmp41_, 3.5);
	}
	_bird_font_color_unref0 (c);
}

void
bird_font_path_draw_control_point (cairo_t* cr,
                                   gdouble x,
                                   gdouble y,
                                   BirdFontColor* color,
                                   gdouble size)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble ivz = 0.0;
	gdouble width = 0.0;
	gdouble xc = 0.0;
	BirdFontWidgetAllocation* _tmp1_;
	gdouble yc = 0.0;
	BirdFontWidgetAllocation* _tmp2_;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	ivz = 1 / g->view_zoom;
	width = (size * sqrt (bird_font_path_stroke_width)) * ivz;
	_tmp1_ = g->allocation;
	xc = _tmp1_->width / 2.0;
	_tmp2_ = g->allocation;
	yc = _tmp2_->height / 2.0;
	cairo_save (cr);
	x = xc + x;
	y = yc - y;
	cairo_set_source_rgba (cr, color->r, color->g, color->b, color->a);
	cairo_move_to (cr, x, y);
	cairo_arc (cr, x, y, width, (gdouble) 0, 2 * G_PI);
	cairo_close_path (cr);
	cairo_fill (cr);
	cairo_restore (cr);
	_g_object_unref0 (g);
}

/** Set direction for this path to clockwise for outline and 
 * counter clockwise for inline paths.
 */
gboolean
bird_font_path_force_direction (BirdFontPath* self,
                                BirdFontDirection direction)
{
	gboolean c = FALSE;
	gboolean d = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	c = direction == BIRD_FONT_DIRECTION_CLOCKWISE;
	d = bird_font_path_is_clockwise (self);
	self->direction_is_set = TRUE;
	if (c != d) {
		bird_font_path_reverse (self);
	}
	d = bird_font_path_is_clockwise (self);
	if (G_UNLIKELY (d != c)) {
		g_warning ("Path.vala:636: Failed to set direction for path in force_direction.");
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/** Switch direction from clockwise path to counter clockwise path or vise versa. */
gboolean
bird_font_path_reverse (BirdFontPath* self)
{
	gboolean direction = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	direction = bird_font_path_is_clockwise (self);
	if (self->priv->no_derived_direction) {
		self->priv->clockwise_direction = !self->priv->clockwise_direction;
	}
	bird_font_path_reverse_points (self);
	if (G_UNLIKELY (direction == bird_font_path_is_clockwise (self))) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static void
bird_font_path_reverse_points (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPointHandle* t = NULL;
	BirdFontEditPoint* e = NULL;
	GeeArrayList* new_points = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_return_if_fail (_tmp3_ > 0, "points.size > 0");
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (new_points);
	new_points = _tmp4_;
	{
		gint i = 0;
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = bird_font_path_get_points (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		i = _tmp8_ - 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				BirdFontEditPoint* _tmp14_;
				BirdFontEditPointHandle* _tmp15_;
				BirdFontEditPointHandle* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPointHandle* _tmp19_;
				BirdFontEditPointHandle* _tmp20_;
				BirdFontEditPoint* _tmp21_;
				BirdFontEditPointHandle* _tmp22_;
				BirdFontEditPointHandle* _tmp23_;
				GeeArrayList* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ - 1;
				}
				_tmp9_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp11_ = bird_font_path_get_points (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
				_g_object_unref0 (e);
				e = (BirdFontEditPoint*) _tmp13_;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->right_handle;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (t);
				t = _tmp16_;
				_tmp17_ = e;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->left_handle;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (_tmp17_->right_handle);
				_tmp17_->right_handle = _tmp20_;
				_tmp21_ = e;
				_tmp22_ = t;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_g_object_unref0 (_tmp21_->left_handle);
				_tmp21_->left_handle = _tmp23_;
				_tmp24_ = new_points;
				_tmp25_ = e;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			}
		}
	}
	_tmp26_ = new_points;
	bird_font_path_set_points (self, _tmp26_);
	bird_font_path_create_list (self);
	_g_object_unref0 (new_points);
	_g_object_unref0 (e);
	_g_object_unref0 (t);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_path_print_all_points (BirdFontPath* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gint _tmp9_;
			const gchar* _tmp10_ = NULL;
			BirdFontEditPoint* _tmp11_;
			gchar* t = NULL;
			gchar* _tmp12_;
			FILE* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			BirdFontEditPoint* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			BirdFontEditPoint* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			i = i + 1;
			_tmp9_ = i;
			_tmp11_ = p;
			if (_tmp11_->type == BIRD_FONT_POINT_TYPE_END) {
				_tmp10_ = " endpoint";
			} else {
				_tmp10_ = "";
			}
			_tmp12_ = g_strdup (_tmp10_);
			t = _tmp12_;
			_tmp13_ = stdout;
			_tmp14_ = g_strdup_printf ("%i", i);
			_tmp15_ = _tmp14_;
			_tmp16_ = p;
			_tmp17_ = double_to_string (_tmp16_->x);
			_tmp18_ = _tmp17_;
			_tmp19_ = p;
			_tmp20_ = double_to_string (_tmp19_->y);
			_tmp21_ = _tmp20_;
			_tmp22_ = t;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = g_strconcat ("Point ", _tmp15_, " at (", _tmp18_, ", ", _tmp21_, ") ", _tmp23_, " \n", NULL);
			_tmp25_ = _tmp24_;
			fprintf (_tmp13_, "%s", _tmp25_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp15_);
			_g_free0 (t);
			_g_object_unref0 (p);
		}
	}
}

static gdouble
bird_font_path_clockwise_sum (BirdFontPath* self)
{
	gdouble sum = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	sum = (gdouble) 0;
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp3_ >= 3, 0);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _e_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _e_index = 0;
		_tmp4_ = bird_font_path_get_points (self);
		_tmp5_ = _tmp4_;
		_e_list = _tmp5_;
		_tmp6_ = _e_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_e_size = _tmp8_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontEditPoint* _tmp13_;
			_e_index = _e_index + 1;
			_tmp9_ = _e_index;
			_tmp10_ = _e_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _e_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _e_index);
			e = (BirdFontEditPoint*) _tmp12_;
			_tmp13_ = e;
			sum += bird_font_edit_point_get_direction (_tmp13_);
			_g_object_unref0 (e);
		}
	}
	result = sum;
	return result;
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		BirdFontPath* self;
		self = _data43_->self;
		_g_object_unref0 (_data43_->p);
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static gboolean
___lambda28_ (Block43Data* _data43_,
              BirdFontEditPoint* a,
              BirdFontEditPoint* b)
{
	BirdFontPath* self;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble step = 0.0;
	BirdFontEditPoint* new_point = NULL;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	BirdFontEditPoint* _tmp2_;
	BirdFontPath* _tmp3_;
	gboolean result;
	self = _data43_->self;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	step = 0.3;
	bird_font_path_get_point_for_step (a, b, step, &_tmp0_, &_tmp1_);
	px = _tmp0_;
	py = _tmp1_;
	_tmp2_ = bird_font_edit_point_new (px, py, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (new_point);
	new_point = _tmp2_;
	new_point->prev = a;
	new_point->next = b;
	_tmp3_ = _data43_->p;
	bird_font_path_insert_new_point_on_path (_tmp3_, new_point, step, FALSE);
	result = TRUE;
	_g_object_unref0 (new_point);
	return result;
}

static gboolean
____lambda28__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                               BirdFontEditPoint* stop,
                                               gpointer self)
{
	gboolean result;
	result = ___lambda28_ (self, start, stop);
	return result;
}

gboolean
bird_font_path_is_clockwise (BirdFontPath* self)
{
	Block43Data* _data43_;
	gdouble s = 0.0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_data43_ = g_slice_new0 (Block43Data);
	_data43_->_ref_count_ = 1;
	_data43_->self = g_object_ref (self);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (G_UNLIKELY (_tmp3_ <= 2)) {
		self->priv->no_derived_direction = TRUE;
		result = self->priv->clockwise_direction;
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return result;
	}
	_tmp4_ = bird_font_path_get_points (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (G_UNLIKELY (_tmp7_ == 2)) {
		BirdFontPath* _tmp8_;
		BirdFontPath* _tmp9_;
		_tmp8_ = bird_font_path_copy (self);
		_g_object_unref0 (_data43_->p);
		_data43_->p = _tmp8_;
		bird_font_path_all_segments (self, ____lambda28__bird_font_path_segment_iterator, _data43_);
		_tmp9_ = _data43_->p;
		result = bird_font_path_is_clockwise (_tmp9_);
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return result;
	}
	s = bird_font_path_clockwise_sum (self);
	if (s == ((gdouble) 0)) {
		self->priv->no_derived_direction = TRUE;
		result = self->priv->clockwise_direction;
		block43_data_unref (_data43_);
		_data43_ = NULL;
		return result;
	}
	result = s > ((gdouble) 0);
	block43_data_unref (_data43_);
	_data43_ = NULL;
	return result;
}

gboolean
bird_font_path_is_editable (BirdFontPath* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->edit;
	return result;
}

/** Show control points on outline path. */
void
bird_font_path_set_editable (BirdFontPath* self,
                             gboolean e)
{
	g_return_if_fail (self != NULL);
	self->priv->edit = e;
}

gboolean
bird_font_path_is_open (BirdFontPath* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->open;
	return result;
}

/** Resize path relative to bottom left coordinates. */
void
bird_font_path_resize (BirdFontPath* self,
                       gdouble ratio_x,
                       gdouble ratio_y)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			gdouble _tmp11_;
			gdouble _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			gdouble _tmp15_;
			gdouble _tmp16_;
			BirdFontEditPoint* _tmp17_;
			BirdFontEditPointHandle* _tmp18_;
			BirdFontEditPoint* _tmp19_;
			BirdFontEditPointHandle* _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			BirdFontEditPoint* _tmp23_;
			BirdFontEditPointHandle* _tmp24_;
			BirdFontEditPoint* _tmp25_;
			BirdFontEditPointHandle* _tmp26_;
			gdouble _tmp27_;
			gdouble _tmp28_;
			BirdFontEditPoint* _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			BirdFontEditPoint* _tmp31_;
			BirdFontEditPointHandle* _tmp32_;
			gdouble _tmp33_;
			gdouble _tmp34_;
			BirdFontEditPoint* _tmp35_;
			BirdFontEditPointHandle* _tmp36_;
			BirdFontEditPoint* _tmp37_;
			BirdFontEditPointHandle* _tmp38_;
			gdouble _tmp39_;
			gdouble _tmp40_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = p;
			_tmp11_ = bird_font_edit_point_get_independent_x (_tmp10_);
			_tmp12_ = _tmp11_;
			bird_font_edit_point_set_independent_x (_tmp10_, _tmp12_ * ratio_x);
			_tmp13_ = p;
			_tmp14_ = p;
			_tmp15_ = bird_font_edit_point_get_independent_y (_tmp14_);
			_tmp16_ = _tmp15_;
			bird_font_edit_point_set_independent_y (_tmp14_, _tmp16_ * ratio_y);
			_tmp17_ = p;
			_tmp18_ = bird_font_edit_point_get_right_handle (_tmp17_);
			_tmp19_ = p;
			_tmp20_ = bird_font_edit_point_get_right_handle (_tmp19_);
			_tmp21_ = bird_font_edit_point_handle_get_independent_x (_tmp20_);
			_tmp22_ = _tmp21_;
			bird_font_edit_point_handle_set_independent_x (_tmp20_, _tmp22_ * ratio_x);
			_tmp23_ = p;
			_tmp24_ = bird_font_edit_point_get_right_handle (_tmp23_);
			_tmp25_ = p;
			_tmp26_ = bird_font_edit_point_get_right_handle (_tmp25_);
			_tmp27_ = bird_font_edit_point_handle_get_independent_y (_tmp26_);
			_tmp28_ = _tmp27_;
			bird_font_edit_point_handle_set_independent_y (_tmp26_, _tmp28_ * ratio_y);
			_tmp29_ = p;
			_tmp30_ = bird_font_edit_point_get_left_handle (_tmp29_);
			_tmp31_ = p;
			_tmp32_ = bird_font_edit_point_get_left_handle (_tmp31_);
			_tmp33_ = bird_font_edit_point_handle_get_independent_x (_tmp32_);
			_tmp34_ = _tmp33_;
			bird_font_edit_point_handle_set_independent_x (_tmp32_, _tmp34_ * ratio_x);
			_tmp35_ = p;
			_tmp36_ = bird_font_edit_point_get_left_handle (_tmp35_);
			_tmp37_ = p;
			_tmp38_ = bird_font_edit_point_get_left_handle (_tmp37_);
			_tmp39_ = bird_font_edit_point_handle_get_independent_y (_tmp38_);
			_tmp40_ = _tmp39_;
			bird_font_edit_point_handle_set_independent_y (_tmp38_, _tmp40_ * ratio_y);
			_g_object_unref0 (p);
		}
	}
	self->xmin = self->xmin * ratio_x;
	self->xmax = self->xmax * ratio_x;
	self->ymin = self->ymin * ratio_y;
	self->ymax = self->ymax * ratio_y;
}

void
bird_font_path_scale (BirdFontPath* self,
                      gdouble scale_x,
                      gdouble scale_y)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPointHandle* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPointHandle* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPointHandle* _tmp14_;
			BirdFontEditPoint* _tmp15_;
			BirdFontEditPointHandle* _tmp16_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = _tmp9_->right_handle;
			_tmp11_ = p;
			_tmp12_ = _tmp11_->right_handle;
			_tmp12_->length = _tmp12_->length * (scale_x * scale_y);
			_tmp13_ = p;
			_tmp14_ = _tmp13_->left_handle;
			_tmp15_ = p;
			_tmp16_ = _tmp15_->left_handle;
			_tmp16_->length = _tmp16_->length * (scale_x * scale_y);
			_g_object_unref0 (p);
		}
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _p_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _p_index = 0;
		_tmp17_ = bird_font_path_get_points (self);
		_tmp18_ = _tmp17_;
		_p_list = _tmp18_;
		_tmp19_ = _p_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_p_size = _tmp21_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			BirdFontEditPoint* _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPoint* _tmp28_;
			BirdFontEditPoint* _tmp29_;
			_p_index = _p_index + 1;
			_tmp22_ = _p_index;
			_tmp23_ = _p_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _p_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _p_index);
			p = (BirdFontEditPoint*) _tmp25_;
			_tmp26_ = p;
			_tmp27_ = p;
			_tmp27_->x = _tmp27_->x * scale_x;
			_tmp28_ = p;
			_tmp29_ = p;
			_tmp29_->y = _tmp29_->y * scale_y;
			_g_object_unref0 (p);
		}
	}
	self->xmin = self->xmin * scale_x;
	self->xmax = self->xmax * scale_x;
	self->ymin = self->ymin * scale_y;
	self->ymax = self->ymax * scale_y;
}

BirdFontPath*
bird_font_path_copy (BirdFontPath* self)
{
	BirdFontPath* new_path = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* p = NULL;
	BirdFontGradient* _tmp16_;
	BirdFontColor* _tmp20_;
	BirdFontColor* _tmp24_;
	BirdFontPath* _tmp28_;
	BirdFontPath* _tmp29_;
	BirdFontPath* _tmp30_;
	BirdFontPath* _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	BirdFontPath* _tmp34_;
	BirdFontPath* _tmp35_;
	BirdFontPath* _tmp36_;
	BirdFontPath* _tmp37_;
	BirdFontPath* _tmp38_;
	BirdFontPath* _tmp39_;
	BirdFontPath* _tmp40_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	new_path = _tmp0_;
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _ep_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _ep_index = 0;
		_tmp1_ = bird_font_path_get_points (self);
		_tmp2_ = _tmp1_;
		_ep_list = _tmp2_;
		_tmp3_ = _ep_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_ep_size = _tmp5_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontPath* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPoint* _tmp15_;
			_ep_index = _ep_index + 1;
			_tmp6_ = _ep_index;
			_tmp7_ = _ep_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _ep_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp9_;
			_tmp10_ = ep;
			_tmp11_ = bird_font_edit_point_copy (_tmp10_);
			_g_object_unref0 (p);
			p = _tmp11_;
			_tmp12_ = new_path;
			_tmp13_ = p;
			_tmp14_ = bird_font_path_add_point (_tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp15_);
			_g_object_unref0 (ep);
		}
	}
	_tmp16_ = self->gradient;
	if (_tmp16_ != NULL) {
		BirdFontPath* _tmp17_;
		BirdFontGradient* _tmp18_;
		BirdFontGradient* _tmp19_;
		_tmp17_ = new_path;
		_tmp18_ = self->gradient;
		_tmp19_ = bird_font_gradient_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_GRADIENT, BirdFontGradient));
		_g_object_unref0 (_tmp17_->gradient);
		_tmp17_->gradient = _tmp19_;
	}
	_tmp20_ = self->color;
	if (_tmp20_ != NULL) {
		BirdFontPath* _tmp21_;
		BirdFontColor* _tmp22_;
		BirdFontColor* _tmp23_;
		_tmp21_ = new_path;
		_tmp22_ = self->color;
		_tmp23_ = bird_font_color_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
		_bird_font_color_unref0 (_tmp21_->color);
		_tmp21_->color = _tmp23_;
	}
	_tmp24_ = self->stroke_color;
	if (_tmp24_ != NULL) {
		BirdFontPath* _tmp25_;
		BirdFontColor* _tmp26_;
		BirdFontColor* _tmp27_;
		_tmp25_ = new_path;
		_tmp26_ = self->stroke_color;
		_tmp27_ = bird_font_color_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, BIRD_FONT_TYPE_COLOR, BirdFontColor));
		_bird_font_color_unref0 (_tmp25_->stroke_color);
		_tmp25_->stroke_color = _tmp27_;
	}
	_tmp28_ = new_path;
	_tmp28_->fill = self->fill;
	_tmp29_ = new_path;
	_tmp29_->priv->edit = self->priv->edit;
	_tmp30_ = new_path;
	_tmp30_->priv->open = self->priv->open;
	_tmp31_ = new_path;
	_tmp32_ = bird_font_path_get_stroke (self);
	_tmp33_ = _tmp32_;
	bird_font_path_set_stroke (_tmp31_, _tmp33_);
	_tmp34_ = new_path;
	_tmp34_->line_cap = self->line_cap;
	_tmp35_ = new_path;
	_tmp35_->skew = self->skew;
	_tmp36_ = new_path;
	_tmp36_->fill = self->fill;
	_tmp37_ = new_path;
	_tmp37_->direction_is_set = self->direction_is_set;
	_tmp38_ = new_path;
	bird_font_path_create_list (_tmp38_);
	_tmp39_ = new_path;
	_tmp39_->hide_end_handle = self->hide_end_handle;
	_tmp40_ = new_path;
	_tmp40_->highlight_last_segment = self->highlight_last_segment;
	result = new_path;
	_g_object_unref0 (p);
	return result;
}

gboolean
bird_font_path_is_over (BirdFontPath* self,
                        gdouble x,
                        gdouble y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	x = ((x * bird_font_glyph_ivz ()) + g->view_offset_x) - bird_font_glyph_xc ();
	y = ((y * bird_font_glyph_ivz ()) + g->view_offset_y) - bird_font_glyph_yc ();
	y = y * -1;
	result = bird_font_path_is_over_coordinate (self, x, y);
	_g_object_unref0 (g);
	return result;
}

gboolean
bird_font_path_is_over_coordinate (BirdFontPath* self,
                                   gdouble x,
                                   gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = bird_font_path_is_over_coordinate_var (self, x, y);
	return result;
}

gdouble
bird_font_path_point_distance (BirdFontEditPoint* p1,
                               BirdFontEditPoint* p2)
{
	gdouble result;
	g_return_val_if_fail (p1 != NULL, 0.0);
	g_return_val_if_fail (p2 != NULL, 0.0);
	result = bird_font_path_distance (p1->x, p2->x, p1->y, p2->y);
	return result;
}

gdouble
bird_font_path_distance (gdouble ax,
                         gdouble bx,
                         gdouble ay,
                         gdouble by)
{
	gdouble result;
	result = fabs (sqrt (pow (ax - bx, (gdouble) 2) + pow (ay - by, (gdouble) 2)));
	return result;
}

gdouble
bird_font_path_distance_to_point (BirdFontEditPoint* a,
                                  BirdFontEditPoint* b)
{
	gdouble result;
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	result = bird_font_path_distance (a->x, b->x, a->y, b->y);
	return result;
}

gdouble
bird_font_path_distance_pixels (gdouble x1,
                                gdouble y1,
                                gdouble x2,
                                gdouble y2)
{
	gdouble result;
	result = bird_font_path_distance (bird_font_glyph_path_coordinate_x (x1), bird_font_glyph_path_coordinate_x (x2), bird_font_glyph_path_coordinate_x (y1), bird_font_glyph_path_coordinate_x (y2));
	return result;
}

gdouble
bird_font_path_get_length_from (BirdFontEditPoint* a,
                                BirdFontEditPoint* b)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontEditPointHandle* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	BirdFontEditPointHandle* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	BirdFontEditPointHandle* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	BirdFontEditPointHandle* _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	BirdFontEditPointHandle* _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble result;
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp0_ = bird_font_edit_point_get_right_handle (a);
	_tmp1_ = bird_font_edit_point_handle_get_x (_tmp0_);
	_tmp2_ = _tmp1_;
	x = fabs (a->x - _tmp2_);
	_tmp3_ = bird_font_edit_point_get_right_handle (a);
	_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_edit_point_get_left_handle (b);
	_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
	_tmp8_ = _tmp7_;
	x += fabs (_tmp5_ - _tmp8_);
	_tmp9_ = bird_font_edit_point_get_left_handle (b);
	_tmp10_ = bird_font_edit_point_handle_get_x (_tmp9_);
	_tmp11_ = _tmp10_;
	x += fabs (_tmp11_ - b->x);
	_tmp12_ = bird_font_edit_point_get_right_handle (a);
	_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
	_tmp14_ = _tmp13_;
	y = fabs (a->y - _tmp14_);
	_tmp15_ = bird_font_edit_point_get_right_handle (a);
	_tmp16_ = bird_font_edit_point_handle_get_y (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = bird_font_edit_point_get_left_handle (b);
	_tmp19_ = bird_font_edit_point_handle_get_y (_tmp18_);
	_tmp20_ = _tmp19_;
	y += fabs (_tmp17_ - _tmp20_);
	_tmp21_ = bird_font_edit_point_get_left_handle (b);
	_tmp22_ = bird_font_edit_point_handle_get_y (_tmp21_);
	_tmp23_ = _tmp22_;
	y += fabs (_tmp23_ - b->y);
	result = fabs (sqrt ((x * x) + (y * y)));
	return result;
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		BirdFontPath* self;
		self = _data44_->self;
		_g_object_unref0 (_data44_->flat);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static gboolean
__lambda50_ (Block44Data* _data44_,
             gdouble x,
             gdouble y,
             gdouble t)
{
	BirdFontPath* self;
	BirdFontEditPoint* ep = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gboolean result;
	self = _data44_->self;
	_tmp0_ = _data44_->flat;
	_tmp1_ = bird_font_path_add (_tmp0_, x, y);
	ep = _tmp1_;
	ep->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	_tmp2_ = bird_font_edit_point_get_right_handle (ep);
	_tmp2_->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	_tmp3_ = bird_font_edit_point_get_left_handle (ep);
	_tmp3_->type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	result = TRUE;
	_g_object_unref0 (ep);
	return result;
}

static gboolean
___lambda50__bird_font_path_raster_iterator (gdouble x,
                                             gdouble y,
                                             gdouble step,
                                             gpointer self)
{
	gboolean result;
	result = __lambda50_ (self, x, y, step);
	return result;
}

BirdFontPath*
bird_font_path_flatten (BirdFontPath* self,
                        gint steps)
{
	Block44Data* _data44_;
	BirdFontPath* _tmp0_;
	BirdFontPath* _tmp2_;
	BirdFontPath* _tmp3_;
	BirdFontPath* _tmp4_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = bird_font_path_new ();
	_data44_->flat = _tmp0_;
	bird_font_path_all_of_path (self, ___lambda50__bird_font_path_raster_iterator, _data44_, steps);
	if (!bird_font_path_is_open (self)) {
		BirdFontPath* _tmp1_;
		_tmp1_ = _data44_->flat;
		bird_font_path_close (_tmp1_);
	}
	_tmp2_ = _data44_->flat;
	bird_font_path_update_region_boundaries (_tmp2_);
	_tmp3_ = _data44_->flat;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	block44_data_unref (_data44_);
	_data44_ = NULL;
	return result;
}

/** Variable precision */
gboolean
bird_font_path_is_over_coordinate_var (BirdFontPath* self,
                                       gdouble x,
                                       gdouble y)
{
	gint insides = 0;
	BirdFontPath* path = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	insides = 0;
	_tmp0_ = bird_font_path_get_stroke (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > ((gdouble) 0)) {
		gboolean _tmp20_ = FALSE;
		{
			GeeArrayList* _p_list = NULL;
			BirdFontPathList* _tmp2_;
			BirdFontPathList* _tmp3_;
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _p_size = 0;
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _p_index = 0;
			_tmp2_ = bird_font_path_get_stroke_fast (self);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_->paths;
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_p_list = _tmp5_;
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_p_size = _tmp8_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				BirdFontPath* _tmp13_;
				BirdFontPath* _tmp14_;
				BirdFontEditPoint* _tmp15_;
				BirdFontEditPoint* _tmp16_;
				BirdFontPath* _tmp17_;
				gboolean _tmp18_;
				_p_index = _p_index + 1;
				_tmp9_ = _p_index;
				_tmp10_ = _p_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _p_list;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _p_index);
				p = (BirdFontPath*) _tmp12_;
				_tmp13_ = p;
				_tmp14_ = bird_font_path_flatten (_tmp13_, 10);
				_g_object_unref0 (path);
				path = _tmp14_;
				_tmp15_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_NONE);
				_tmp16_ = _tmp15_;
				_tmp17_ = path;
				_tmp18_ = bird_font_stroke_tool_is_inside (_tmp16_, _tmp17_);
				_g_object_unref0 (_tmp16_);
				if (_tmp18_) {
					gint _tmp19_;
					_tmp19_ = insides;
					insides = _tmp19_ + 1;
				}
				_g_object_unref0 (p);
			}
		}
		if (insides > 0) {
			_tmp20_ = bird_font_path_is_filled (self);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			result = TRUE;
			_g_object_unref0 (path);
			return result;
		}
		if ((insides % 2) == 1) {
			result = TRUE;
			_g_object_unref0 (path);
			return result;
		}
	} else {
		if (bird_font_path_is_over_boundry (self, x, y)) {
			BirdFontPath* _tmp21_;
			BirdFontEditPoint* _tmp22_;
			BirdFontEditPoint* _tmp23_;
			BirdFontPath* _tmp24_;
			gboolean _tmp25_;
			_tmp21_ = bird_font_path_flatten (self, 10);
			_g_object_unref0 (path);
			path = _tmp21_;
			_tmp22_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_NONE);
			_tmp23_ = _tmp22_;
			_tmp24_ = path;
			_tmp25_ = bird_font_stroke_tool_is_inside (_tmp23_, _tmp24_);
			_g_object_unref0 (_tmp23_);
			result = _tmp25_;
			_g_object_unref0 (path);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (path);
	return result;
}

gboolean
bird_font_path_is_over_boundry (BirdFontPath* self,
                                gdouble x,
                                gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->ymin == DBL_MAX) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->ymin == ((gdouble) 10000);
	}
	if (G_UNLIKELY (_tmp0_)) {
		g_warning ("Path.vala:926: bounding box is not calculated, run update_region_bound" \
"aries first.");
		bird_font_path_update_region_boundaries (self);
	}
	_tmp2_ = y;
	if ((self->ymin <= _tmp2_) && (_tmp2_ <= self->ymax)) {
		gdouble _tmp3_;
		_tmp3_ = x;
		_tmp1_ = (self->xmin <= _tmp3_) && (_tmp3_ <= self->xmax);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

gboolean
bird_font_path_has_overlapping_boundry (BirdFontPath* self,
                                        BirdFontPath* p)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	if (self->xmax <= p->xmin) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->ymax <= p->ymin;
	}
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->xmin >= p->xmax) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->ymin >= p->ymax;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

BirdFontEditPoint*
bird_font_path_delete_first_point (BirdFontPath* self)
{
	BirdFontEditPoint* r = NULL;
	gint size = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	size = _tmp3_;
	if (G_UNLIKELY (size == 0)) {
		BirdFontEditPoint* _tmp4_;
		g_warning ("Path.vala:943: No points in path.");
		_tmp4_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		result = _tmp4_;
		_g_object_unref0 (r);
		return result;
	}
	_tmp5_ = bird_font_path_get_points (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, 0);
	_g_object_unref0 (r);
	r = (BirdFontEditPoint*) _tmp7_;
	_tmp8_ = bird_font_path_get_points (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp9_, 0);
	_tmp11_ = (BirdFontEditPoint*) _tmp10_;
	_g_object_unref0 (_tmp11_);
	if (size > 1) {
		BirdFontEditPoint* _tmp12_;
		BirdFontEditPoint* _tmp13_;
		_tmp12_ = r;
		_tmp13_ = bird_font_edit_point_get_next (_tmp12_);
		_tmp13_->prev = NULL;
	}
	result = r;
	return result;
}

BirdFontEditPoint*
bird_font_path_delete_last_point (BirdFontPath* self)
{
	BirdFontEditPoint* r = NULL;
	gint size = 0;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	size = _tmp3_;
	if (G_UNLIKELY (size == 0)) {
		BirdFontEditPoint* _tmp4_;
		g_warning ("Path.vala:963: No points in path.");
		_tmp4_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
		result = _tmp4_;
		_g_object_unref0 (r);
		return result;
	}
	_tmp5_ = bird_font_path_get_points (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, size - 1);
	_g_object_unref0 (r);
	r = (BirdFontEditPoint*) _tmp7_;
	_tmp8_ = bird_font_path_get_points (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp9_, size - 1);
	_tmp11_ = (BirdFontEditPoint*) _tmp10_;
	_g_object_unref0 (_tmp11_);
	if (size > 1) {
		BirdFontEditPoint* _tmp12_;
		BirdFontEditPoint* _tmp13_;
		BirdFontEditPoint* _tmp14_;
		BirdFontEditPoint* _tmp15_;
		_tmp12_ = r;
		_tmp13_ = bird_font_edit_point_get_prev (_tmp12_);
		_tmp13_->next = NULL;
		_tmp14_ = r;
		_tmp15_ = _tmp14_->next;
		if (_tmp15_ != NULL) {
			BirdFontEditPoint* _tmp16_;
			BirdFontEditPoint* _tmp17_;
			_tmp16_ = r;
			_tmp17_ = bird_font_edit_point_get_next (_tmp16_);
			_tmp17_->prev = NULL;
		}
	}
	result = r;
	return result;
}

BirdFontEditPoint*
bird_font_path_add (BirdFontPath* self,
                    gdouble x,
                    gdouble y)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_NONE);
	ep = _tmp0_;
	_tmp1_ = bird_font_path_add_point (self, ep);
	result = _tmp1_;
	_g_object_unref0 (ep);
	return result;
}

BirdFontEditPoint*
bird_font_path_add_point (BirdFontPath* self,
                          BirdFontEditPoint* p)
{
	BirdFontEditPoint* previous_point = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		_tmp4_ = bird_font_path_get_points (self);
		_tmp5_ = _tmp4_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, p);
		p->prev = p;
		p->next = p;
	} else {
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gpointer _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		BirdFontEditPoint* _tmp15_;
		BirdFontEditPoint* _tmp16_;
		BirdFontEditPoint* _tmp17_;
		_tmp6_ = bird_font_path_get_points (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = bird_font_path_get_points (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp11_ - 1);
		_g_object_unref0 (previous_point);
		previous_point = (BirdFontEditPoint*) _tmp12_;
		_tmp13_ = bird_font_path_get_points (self);
		_tmp14_ = _tmp13_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, p);
		_tmp15_ = previous_point;
		p->prev = _tmp15_;
		_tmp16_ = previous_point;
		_tmp17_ = _tmp16_->next;
		p->next = _tmp17_;
	}
	_tmp18_ = _g_object_ref0 (p);
	_g_object_unref0 (self->priv->last_point);
	self->priv->last_point = _tmp18_;
	_tmp19_ = _g_object_ref0 (p);
	result = _tmp19_;
	_g_object_unref0 (previous_point);
	return result;
}

/** @return a list item pointing to the new point */
BirdFontEditPoint*
bird_font_path_add_point_after (BirdFontPath* self,
                                BirdFontEditPoint* p,
                                BirdFontEditPoint* previous_point)
{
	gint prev_index = 0;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	BirdFontEditPoint* _tmp40_;
	BirdFontEditPoint* _tmp41_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	if (previous_point == NULL) {
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp1_ = bird_font_path_get_points (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (G_UNLIKELY (_tmp0_)) {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gpointer _tmp11_;
		BirdFontEditPoint* _tmp12_;
		BirdFontEditPoint* _tmp13_;
		g_warning ("Path.vala:1010: previous_point == null");
		_tmp5_ = bird_font_path_get_points (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = bird_font_path_get_points (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp10_ - 1);
		_tmp12_ = (BirdFontEditPoint*) _tmp11_;
		_tmp13_ = bird_font_edit_point_get_link_item (_tmp12_);
		previous_point = _tmp13_;
		_g_object_unref0 (_tmp12_);
	}
	_tmp14_ = bird_font_path_get_points (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 0) {
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		gpointer _tmp22_;
		BirdFontEditPoint* _tmp23_;
		BirdFontEditPoint* _tmp24_;
		GeeArrayList* _tmp25_;
		GeeArrayList* _tmp26_;
		gpointer _tmp27_;
		BirdFontEditPoint* _tmp28_;
		BirdFontEditPoint* _tmp29_;
		_tmp18_ = bird_font_path_get_points (self);
		_tmp19_ = _tmp18_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, p);
		_tmp20_ = bird_font_path_get_points (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
		_tmp23_ = (BirdFontEditPoint*) _tmp22_;
		_tmp24_ = bird_font_edit_point_get_link_item (_tmp23_);
		p->prev = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_tmp25_ = bird_font_path_get_points (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, 0);
		_tmp28_ = (BirdFontEditPoint*) _tmp27_;
		_tmp29_ = bird_font_edit_point_get_link_item (_tmp28_);
		p->next = _tmp29_;
		_g_object_unref0 (_tmp28_);
	} else {
		BirdFontEditPoint* _tmp30_;
		GeeArrayList* _tmp31_;
		GeeArrayList* _tmp32_;
		GeeArrayList* _tmp33_;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		GeeArrayList* _tmp38_;
		GeeArrayList* _tmp39_;
		p->prev = G_TYPE_CHECK_INSTANCE_CAST (previous_point, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint);
		_tmp30_ = G_TYPE_CHECK_INSTANCE_CAST (previous_point, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint)->next;
		p->next = _tmp30_;
		_tmp31_ = bird_font_path_get_points (self);
		_tmp32_ = _tmp31_;
		prev_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (previous_point, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
		_tmp33_ = bird_font_path_get_points (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = prev_index;
		if (G_UNLIKELY (!((0 <= _tmp37_) && (_tmp37_ < _tmp36_)))) {
			g_warning ("Path.vala:1025: no previous point");
		}
		_tmp38_ = bird_font_path_get_points (self);
		_tmp39_ = _tmp38_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp39_, prev_index + 1, p);
	}
	_tmp40_ = _g_object_ref0 (p);
	_g_object_unref0 (self->priv->last_point);
	self->priv->last_point = _tmp40_;
	_tmp41_ = _g_object_ref0 (p);
	result = _tmp41_;
	return result;
}

void
bird_font_path_close (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->open = FALSE;
	self->priv->edit = FALSE;
	bird_font_path_create_list (self);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 2) {
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPoint* _tmp7_;
		_tmp4_ = bird_font_path_get_last_point (self);
		_tmp5_ = _tmp4_;
		bird_font_path_recalculate_linear_handles_for_point (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_tmp6_ = bird_font_path_get_first_point (self);
		_tmp7_ = _tmp6_;
		bird_font_path_recalculate_linear_handles_for_point (self, _tmp7_);
		_g_object_unref0 (_tmp7_);
	}
}

void
bird_font_path_reopen (BirdFontPath* self)
{
	g_return_if_fail (self != NULL);
	self->priv->open = TRUE;
	self->priv->edit = TRUE;
}

/** Move path. */
void
bird_font_path_move (BirdFontPath* self,
                     gdouble delta_x,
                     gdouble delta_y)
{
	BirdFontGradient* _tmp13_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			_tmp10_ = ep;
			_tmp10_->x = _tmp10_->x + delta_x;
			_tmp11_ = ep;
			_tmp12_ = ep;
			_tmp12_->y = _tmp12_->y + delta_y;
			_g_object_unref0 (ep);
		}
	}
	_tmp13_ = self->gradient;
	if (_tmp13_ != NULL) {
		BirdFontGradient* g = NULL;
		BirdFontGradient* _tmp14_;
		BirdFontGradient* _tmp15_;
		BirdFontGradient* _tmp16_;
		BirdFontGradient* _tmp17_;
		BirdFontGradient* _tmp18_;
		BirdFontGradient* _tmp19_;
		BirdFontGradient* _tmp20_;
		BirdFontGradient* _tmp21_;
		BirdFontGradient* _tmp22_;
		BirdFontGradient* _tmp23_;
		_tmp14_ = self->gradient;
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_GRADIENT, BirdFontGradient));
		g = _tmp15_;
		_tmp16_ = g;
		_tmp17_ = g;
		_tmp17_->x1 = _tmp17_->x1 + delta_x;
		_tmp18_ = g;
		_tmp19_ = g;
		_tmp19_->x2 = _tmp19_->x2 + delta_x;
		_tmp20_ = g;
		_tmp21_ = g;
		_tmp21_->y1 = _tmp21_->y1 + delta_y;
		_tmp22_ = g;
		_tmp23_ = g;
		_tmp23_->y2 = _tmp23_->y2 + delta_y;
		_g_object_unref0 (g);
	}
	bird_font_path_update_region_boundaries (self);
}

static gboolean
___lambda21_ (BirdFontPath* self,
              gdouble cx,
              gdouble cy)
{
	gboolean result;
	if (cx > self->xmax) {
		self->xmax = cx;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda21__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda21_ ((BirdFontPath*) self, x, y);
	return result;
}

static gboolean
___lambda22_ (BirdFontPath* self,
              gdouble cx,
              gdouble cy)
{
	gboolean result;
	if (cx < self->xmin) {
		self->xmin = cx;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda22__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda22_ ((BirdFontPath*) self, x, y);
	return result;
}

static gboolean
___lambda23_ (BirdFontPath* self,
              gdouble cx,
              gdouble cy)
{
	gboolean result;
	if (cy > self->ymax) {
		self->ymax = cy;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda23__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda23_ ((BirdFontPath*) self, x, y);
	return result;
}

static gboolean
___lambda24_ (BirdFontPath* self,
              gdouble cx,
              gdouble cy)
{
	gboolean result;
	if (cy < self->ymin) {
		self->ymin = cy;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda24__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda24_ ((BirdFontPath*) self, x, y);
	return result;
}

static void
bird_font_path_update_region_boundaries_for_segment (BirdFontPath* self,
                                                     BirdFontEditPoint* a,
                                                     BirdFontEditPoint* b)
{
	BirdFontEditPointHandle* left_handle = NULL;
	BirdFontEditPointHandle* right_handle = NULL;
	gint steps = 0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPointHandle* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	steps = 10;
	_tmp0_ = bird_font_edit_point_get_right_handle (a);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (right_handle);
	right_handle = _tmp1_;
	_tmp2_ = bird_font_edit_point_get_left_handle (b);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (left_handle);
	left_handle = _tmp3_;
	if (a->x > self->xmax) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = b->x > self->xmax;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		_tmp7_ = left_handle;
		_tmp8_ = bird_font_edit_point_handle_get_x (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ > self->xmax;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		_tmp10_ = right_handle;
		_tmp11_ = bird_font_edit_point_handle_get_x (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp4_ = _tmp12_ > self->xmax;
	}
	if (_tmp4_) {
		bird_font_path_all_of (a, b, ____lambda21__bird_font_path_raster_iterator, self, steps, (gdouble) 0, (gdouble) 1);
	}
	if (a->x < self->xmin) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = b->x < self->xmin;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp16_;
		gdouble _tmp17_;
		gdouble _tmp18_;
		_tmp16_ = left_handle;
		_tmp17_ = bird_font_edit_point_handle_get_x (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ < self->xmin;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp19_;
		gdouble _tmp20_;
		gdouble _tmp21_;
		_tmp19_ = right_handle;
		_tmp20_ = bird_font_edit_point_handle_get_x (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp13_ = _tmp21_ < self->xmin;
	}
	if (_tmp13_) {
		bird_font_path_all_of (a, b, ____lambda22__bird_font_path_raster_iterator, self, steps, (gdouble) 0, (gdouble) 1);
	}
	if (a->y > self->ymax) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = b->y > self->ymax;
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		_tmp25_ = left_handle;
		_tmp26_ = bird_font_edit_point_handle_get_y (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp23_ = _tmp27_ > self->xmax;
	}
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp28_;
		gdouble _tmp29_;
		gdouble _tmp30_;
		_tmp28_ = right_handle;
		_tmp29_ = bird_font_edit_point_handle_get_y (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp22_ = _tmp30_ > self->xmax;
	}
	if (_tmp22_) {
		bird_font_path_all_of (a, b, ____lambda23__bird_font_path_raster_iterator, self, steps, (gdouble) 0, (gdouble) 1);
	}
	if (a->y < self->ymin) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = b->y < self->ymin;
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp34_;
		gdouble _tmp35_;
		gdouble _tmp36_;
		_tmp34_ = left_handle;
		_tmp35_ = bird_font_edit_point_handle_get_y (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp32_ = _tmp36_ < self->xmin;
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		_tmp37_ = right_handle;
		_tmp38_ = bird_font_edit_point_handle_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp31_ = _tmp39_ < self->xmin;
	}
	if (_tmp31_) {
		bird_font_path_all_of (a, b, ____lambda24__bird_font_path_raster_iterator, self, steps, (gdouble) 0, (gdouble) 1);
	}
	_g_object_unref0 (right_handle);
	_g_object_unref0 (left_handle);
}

static gboolean
__lambda20_ (BirdFontPath* self,
             BirdFontEditPoint* a,
             BirdFontEditPoint* b)
{
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	bird_font_path_update_region_boundaries_for_segment (self, a, b);
	result = TRUE;
	return result;
}

static gboolean
___lambda20__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                              BirdFontEditPoint* stop,
                                              gpointer self)
{
	gboolean result;
	result = __lambda20_ ((BirdFontPath*) self, start, stop);
	return result;
}

void
bird_font_path_update_region_boundaries (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	g_return_if_fail (self != NULL);
	self->xmax = BIRD_FONT_GLYPH_CANVAS_MIN;
	self->xmin = BIRD_FONT_GLYPH_CANVAS_MAX;
	self->ymax = BIRD_FONT_GLYPH_CANVAS_MIN;
	self->ymin = BIRD_FONT_GLYPH_CANVAS_MAX;
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		self->xmax = (gdouble) 0;
		self->xmin = (gdouble) 0;
		self->ymax = (gdouble) 0;
		self->ymin = (gdouble) 0;
	}
	bird_font_path_all_segments (self, ___lambda20__bird_font_path_segment_iterator, self);
	_tmp4_ = bird_font_path_get_stroke (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > ((gdouble) 0)) {
		gdouble stroke2 = 0.0;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp6_ = bird_font_path_get_stroke (self);
		_tmp7_ = _tmp6_;
		stroke2 = _tmp7_ / 2;
		self->xmax = self->xmax + stroke2;
		self->xmin = self->xmin - stroke2;
		self->ymax = self->ymax + stroke2;
		self->ymin = self->ymin - stroke2;
	}
	_tmp8_ = bird_font_path_get_points (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == 1) {
		BirdFontEditPoint* e = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gpointer _tmp14_;
		BirdFontEditPoint* _tmp15_;
		BirdFontEditPoint* _tmp16_;
		BirdFontEditPoint* _tmp17_;
		BirdFontEditPoint* _tmp18_;
		_tmp12_ = bird_font_path_get_points (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, 0);
		e = (BirdFontEditPoint*) _tmp14_;
		_tmp15_ = e;
		self->xmax = _tmp15_->x;
		_tmp16_ = e;
		self->xmin = _tmp16_->x;
		_tmp17_ = e;
		self->ymax = _tmp17_->y;
		_tmp18_ = e;
		self->ymin = _tmp18_->y;
		_g_object_unref0 (e);
	}
}

void
bird_font_path_transform (BirdFontPath* self,
                          cairo_matrix_t* matrix)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontEditPointHandle* handle = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (matrix != NULL);
	{
		GeeArrayList* _point_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _point_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _point_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_point_list = _tmp1_;
		_tmp2_ = _point_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_point_size = _tmp4_;
		_point_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* point = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPointHandle* _tmp14_;
			BirdFontEditPointHandle* _tmp15_;
			BirdFontEditPointHandle* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			BirdFontEditPointHandle* _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_;
			BirdFontEditPointHandle* _tmp22_;
			BirdFontEditPointHandle* _tmp23_;
			BirdFontEditPoint* _tmp24_;
			BirdFontEditPointHandle* _tmp25_;
			BirdFontEditPointHandle* _tmp26_;
			BirdFontEditPointHandle* _tmp27_;
			gdouble _tmp28_;
			gdouble _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			gdouble _tmp31_;
			gdouble _tmp32_;
			BirdFontEditPointHandle* _tmp33_;
			BirdFontEditPointHandle* _tmp34_;
			_point_index = _point_index + 1;
			_tmp5_ = _point_index;
			_tmp6_ = _point_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _point_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _point_index);
			point = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = point;
			x = _tmp9_->x;
			_tmp10_ = point;
			y = _tmp10_->y;
			cairo_matrix_transform_point (matrix, &x, &y);
			_tmp11_ = point;
			bird_font_edit_point_set_independent_x (_tmp11_, x);
			_tmp12_ = point;
			bird_font_edit_point_set_independent_y (_tmp12_, y);
			_tmp13_ = point;
			_tmp14_ = bird_font_edit_point_get_right_handle (_tmp13_);
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (handle);
			handle = _tmp15_;
			_tmp16_ = handle;
			_tmp17_ = bird_font_edit_point_handle_get_x (_tmp16_);
			_tmp18_ = _tmp17_;
			x = _tmp18_;
			_tmp19_ = handle;
			_tmp20_ = bird_font_edit_point_handle_get_y (_tmp19_);
			_tmp21_ = _tmp20_;
			y = _tmp21_;
			cairo_matrix_transform_point (matrix, &x, &y);
			_tmp22_ = handle;
			bird_font_edit_point_handle_set_independent_x (_tmp22_, x);
			_tmp23_ = handle;
			bird_font_edit_point_handle_set_independent_y (_tmp23_, y);
			_tmp24_ = point;
			_tmp25_ = bird_font_edit_point_get_left_handle (_tmp24_);
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (handle);
			handle = _tmp26_;
			_tmp27_ = handle;
			_tmp28_ = bird_font_edit_point_handle_get_x (_tmp27_);
			_tmp29_ = _tmp28_;
			x = _tmp29_;
			_tmp30_ = handle;
			_tmp31_ = bird_font_edit_point_handle_get_y (_tmp30_);
			_tmp32_ = _tmp31_;
			y = _tmp32_;
			cairo_matrix_transform_point (matrix, &x, &y);
			_tmp33_ = handle;
			bird_font_edit_point_handle_set_independent_x (_tmp33_, x);
			_tmp34_ = handle;
			bird_font_edit_point_handle_set_independent_y (_tmp34_, y);
			_g_object_unref0 (point);
		}
	}
	bird_font_path_update_region_boundaries (self);
	_g_object_unref0 (handle);
}

/** Test if @param path is a valid outline for this object. */
gboolean
bird_font_path_test_is_outline (BirdFontPath* self,
                                BirdFontPath* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_vala_assert (FALSE, "false");
	if (bird_font_path_test_is_outline_of_path (self, path)) {
		_tmp0_ = bird_font_path_test_is_outline_of_path (path, self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		BirdFontPath* self;
		self = _data45_->self;
		_g_object_unref0 (_data45_->ep);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static gboolean
___lambda373_ (Block45Data* _data45_,
               gdouble cx,
               gdouble cy)
{
	BirdFontPath* self;
	BirdFontEditPoint* _tmp0_;
	gdouble n = 0.0;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	gboolean result;
	self = _data45_->self;
	_tmp0_ = _data45_->ep;
	bird_font_path_get_closest_point_on_path (self, _tmp0_, cx, cy, NULL, NULL, -1);
	_tmp1_ = _data45_->ep;
	_tmp2_ = _data45_->ep;
	n = pow (_tmp1_->x - cx, (gdouble) 2) + pow (cy - _tmp2_->y, (gdouble) 2);
	if (n < _data45_->min) {
		_data45_->min = n;
	}
	if (n < _data45_->tolerance) {
		_data45_->g = TRUE;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda373__bird_font_path_raster_iterator (gdouble x,
                                               gdouble y,
                                               gdouble step,
                                               gpointer self)
{
	gboolean result;
	result = ___lambda373_ (self, x, y);
	return result;
}

static gboolean
bird_font_path_test_is_outline_of_path (BirdFontPath* self,
                                        BirdFontPath* outline)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	Block45Data* _data45_;
	BirdFontEditPoint* i = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* prev = NULL;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	BirdFontEditPoint* _tmp23_;
	BirdFontEditPoint* _tmp24_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (outline != NULL, FALSE);
	_tmp0_ = bird_font_path_get_points (outline);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_path_get_points (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_return_val_if_fail ((_tmp3_ >= 2) || (_tmp7_ >= 2), "outline.points.size >= 2 || points.size >= 2", FALSE);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_object_ref (self);
	_tmp8_ = bird_font_path_get_points (outline);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
	_tmp11_ = (BirdFontEditPoint*) _tmp10_;
	_tmp12_ = bird_font_edit_point_get_link_item (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	i = _tmp13_;
	_tmp14_ = bird_font_path_get_points (outline);
	_tmp15_ = _tmp14_;
	_tmp16_ = bird_font_path_get_points (outline);
	_tmp17_ = _tmp16_;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp19_ - 1);
	_tmp21_ = (BirdFontEditPoint*) _tmp20_;
	_tmp22_ = bird_font_edit_point_get_link_item (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp21_);
	prev = _tmp23_;
	_data45_->tolerance = (gdouble) 1;
	_data45_->g = FALSE;
	_tmp24_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_data45_->ep = _tmp24_;
	_data45_->min = DBL_MAX;
	while (TRUE) {
		BirdFontEditPoint* _tmp25_;
		BirdFontEditPoint* _tmp26_;
		BirdFontEditPoint* _tmp31_;
		GeeArrayList* _tmp32_;
		GeeArrayList* _tmp33_;
		GeeArrayList* _tmp34_;
		GeeArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gpointer _tmp38_;
		BirdFontEditPoint* _tmp39_;
		gboolean _tmp40_;
		BirdFontEditPoint* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		_data45_->min = (gdouble) 10000;
		_tmp25_ = prev;
		_tmp26_ = i;
		bird_font_path_all_of (_tmp25_, _tmp26_, ____lambda373__bird_font_path_raster_iterator, _data45_, -1, (gdouble) 0, (gdouble) 1);
		if (!_data45_->g) {
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp27_ = double_to_string (_data45_->min);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat ("this path does not seem to be the outline. (min ", _tmp28_, ")", NULL);
			_tmp30_ = _tmp29_;
			g_critical ("Path.vala:1227: %s", _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
		}
		_data45_->g = FALSE;
		_tmp31_ = i;
		_tmp32_ = bird_font_path_get_points (outline);
		_tmp33_ = _tmp32_;
		_tmp34_ = bird_font_path_get_points (outline);
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp37_ - 1);
		_tmp39_ = (BirdFontEditPoint*) _tmp38_;
		_tmp40_ = _tmp31_ == _tmp39_;
		_g_object_unref0 (_tmp39_);
		if (_tmp40_) {
			break;
		}
		_tmp41_ = i;
		_tmp42_ = bird_font_edit_point_get_next (_tmp41_);
		i = _tmp42_;
	}
	result = TRUE;
	block45_data_unref (_data45_);
	_data45_ = NULL;
	return result;
}

/** Add the extra point between line handles for double curve. */
void
bird_font_path_add_hidden_double_points (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* hidden = NULL;
	BirdFontEditPoint* prev = NULL;
	BirdFontEditPoint* first = NULL;
	BirdFontPointType left = 0;
	BirdFontPointType right = 0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	GeeArrayList* middle_points = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* first_points = NULL;
	GeeArrayList* _tmp5_;
	BirdFontEditPoint* _tmp6_ = NULL;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPoint* _tmp104_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_return_if_fail (_tmp3_ > 1, "points.size > 1");
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	middle_points = _tmp4_;
	_tmp5_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	first_points = _tmp5_;
	if (bird_font_path_is_open (self)) {
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gpointer _tmp9_;
		_tmp7_ = bird_font_path_get_points (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, 0);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = (BirdFontEditPoint*) _tmp9_;
	} else {
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gpointer _tmp16_;
		_tmp10_ = bird_font_path_get_points (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_path_get_points (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp15_ - 1);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = (BirdFontEditPoint*) _tmp16_;
	}
	_tmp17_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (first);
	first = _tmp17_;
	{
		GeeArrayList* _next_list = NULL;
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		gint _next_size = 0;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _next_index = 0;
		_tmp18_ = bird_font_path_get_points (self);
		_tmp19_ = _tmp18_;
		_next_list = _tmp19_;
		_tmp20_ = _next_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_next_size = _tmp22_;
		_next_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			BirdFontEditPoint* next = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPointHandle* _tmp28_;
			BirdFontEditPoint* _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			gboolean _tmp31_ = FALSE;
			BirdFontEditPoint* _tmp32_;
			BirdFontEditPoint* _tmp33_;
			BirdFontEditPoint* _tmp87_;
			BirdFontEditPoint* _tmp88_;
			_next_index = _next_index + 1;
			_tmp23_ = _next_index;
			_tmp24_ = _next_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _next_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _next_index);
			next = (BirdFontEditPoint*) _tmp26_;
			_tmp27_ = first;
			_tmp28_ = bird_font_edit_point_get_right_handle (_tmp27_);
			left = _tmp28_->type;
			_tmp29_ = next;
			_tmp30_ = bird_font_edit_point_get_left_handle (_tmp29_);
			right = _tmp30_->type;
			_tmp32_ = next;
			_tmp33_ = first;
			if (_tmp32_ != _tmp33_) {
				gboolean _tmp34_ = FALSE;
				if (right == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
					_tmp34_ = TRUE;
				} else {
					_tmp34_ = left == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
				}
				_tmp31_ = _tmp34_;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				BirdFontEditPoint* _tmp35_;
				BirdFontEditPointHandle* _tmp36_;
				BirdFontEditPoint* _tmp37_;
				BirdFontEditPointHandle* _tmp38_;
				gdouble _tmp39_;
				gdouble _tmp40_;
				BirdFontEditPoint* _tmp41_;
				BirdFontEditPointHandle* _tmp42_;
				gdouble _tmp43_;
				gdouble _tmp44_;
				BirdFontEditPoint* _tmp45_;
				BirdFontEditPointHandle* _tmp46_;
				gdouble _tmp47_;
				gdouble _tmp48_;
				BirdFontEditPoint* _tmp49_;
				BirdFontEditPointHandle* _tmp50_;
				gdouble _tmp51_;
				gdouble _tmp52_;
				BirdFontEditPoint* _tmp53_;
				BirdFontEditPointHandle* _tmp54_;
				gdouble _tmp55_;
				gdouble _tmp56_;
				BirdFontEditPoint* _tmp57_;
				BirdFontEditPointHandle* _tmp58_;
				gdouble _tmp59_;
				gdouble _tmp60_;
				BirdFontEditPoint* _tmp61_;
				BirdFontEditPoint* _tmp62_;
				BirdFontEditPointHandle* _tmp63_;
				BirdFontEditPoint* _tmp64_;
				BirdFontEditPointHandle* _tmp65_;
				BirdFontEditPoint* _tmp66_;
				BirdFontEditPoint* _tmp67_;
				BirdFontEditPointHandle* _tmp68_;
				BirdFontEditPoint* _tmp69_;
				BirdFontEditPointHandle* _tmp70_;
				gdouble _tmp71_;
				gdouble _tmp72_;
				BirdFontEditPoint* _tmp73_;
				BirdFontEditPointHandle* _tmp74_;
				gdouble _tmp75_;
				gdouble _tmp76_;
				BirdFontEditPoint* _tmp77_;
				BirdFontEditPointHandle* _tmp78_;
				BirdFontEditPoint* _tmp79_;
				BirdFontEditPoint* _tmp80_;
				BirdFontEditPointHandle* _tmp81_;
				BirdFontEditPoint* _tmp82_;
				GeeArrayList* _tmp83_;
				BirdFontEditPoint* _tmp84_;
				GeeArrayList* _tmp85_;
				BirdFontEditPoint* _tmp86_;
				_tmp35_ = first;
				_tmp36_ = bird_font_edit_point_get_right_handle (_tmp35_);
				_tmp36_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp37_ = first;
				_tmp38_ = bird_font_edit_point_get_right_handle (_tmp37_);
				_tmp39_ = bird_font_edit_point_handle_get_x (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = next;
				_tmp42_ = bird_font_edit_point_get_left_handle (_tmp41_);
				_tmp43_ = bird_font_edit_point_handle_get_x (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = first;
				_tmp46_ = bird_font_edit_point_get_right_handle (_tmp45_);
				_tmp47_ = bird_font_edit_point_handle_get_x (_tmp46_);
				_tmp48_ = _tmp47_;
				x = _tmp40_ + ((_tmp44_ - _tmp48_) / 2);
				_tmp49_ = first;
				_tmp50_ = bird_font_edit_point_get_right_handle (_tmp49_);
				_tmp51_ = bird_font_edit_point_handle_get_y (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = next;
				_tmp54_ = bird_font_edit_point_get_left_handle (_tmp53_);
				_tmp55_ = bird_font_edit_point_handle_get_y (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = first;
				_tmp58_ = bird_font_edit_point_get_right_handle (_tmp57_);
				_tmp59_ = bird_font_edit_point_handle_get_y (_tmp58_);
				_tmp60_ = _tmp59_;
				y = _tmp52_ + ((_tmp56_ - _tmp60_) / 2);
				_tmp61_ = bird_font_edit_point_new (x, y, BIRD_FONT_POINT_TYPE_QUADRATIC);
				_g_object_unref0 (hidden);
				hidden = _tmp61_;
				_tmp62_ = hidden;
				_tmp63_ = bird_font_edit_point_get_right_handle (_tmp62_);
				_tmp63_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp64_ = hidden;
				_tmp65_ = bird_font_edit_point_get_left_handle (_tmp64_);
				_tmp65_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp66_ = hidden;
				_tmp66_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp67_ = hidden;
				_tmp68_ = _tmp67_->right_handle;
				_tmp69_ = next;
				_tmp70_ = bird_font_edit_point_get_left_handle (_tmp69_);
				_tmp71_ = bird_font_edit_point_handle_get_x (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = next;
				_tmp74_ = bird_font_edit_point_get_left_handle (_tmp73_);
				_tmp75_ = bird_font_edit_point_handle_get_y (_tmp74_);
				_tmp76_ = _tmp75_;
				bird_font_edit_point_handle_move_to_coordinate_internal (_tmp68_, _tmp72_, _tmp76_);
				_tmp77_ = first;
				_tmp78_ = bird_font_edit_point_get_right_handle (_tmp77_);
				_tmp78_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp79_ = first;
				_tmp79_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp80_ = next;
				_tmp81_ = bird_font_edit_point_get_left_handle (_tmp80_);
				_tmp81_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp82_ = next;
				_tmp82_->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				_tmp83_ = middle_points;
				_tmp84_ = hidden;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp84_);
				_tmp85_ = first_points;
				_tmp86_ = first;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, _tmp86_);
			}
			_tmp87_ = next;
			_tmp88_ = _g_object_ref0 (_tmp87_);
			_g_object_unref0 (first);
			first = _tmp88_;
			_g_object_unref0 (next);
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp89_ = FALSE;
			_tmp89_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				GeeArrayList* _tmp94_;
				gpointer _tmp95_;
				GeeArrayList* _tmp96_;
				gpointer _tmp97_;
				BirdFontEditPoint* _tmp98_;
				GeeArrayList* _tmp99_;
				gpointer _tmp100_;
				BirdFontEditPoint* _tmp101_;
				BirdFontEditPoint* _tmp102_;
				BirdFontEditPoint* _tmp103_;
				if (!_tmp89_) {
					gint _tmp90_;
					_tmp90_ = i;
					i = _tmp90_ + 1;
				}
				_tmp89_ = FALSE;
				_tmp91_ = middle_points;
				_tmp92_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp91_);
				_tmp93_ = _tmp92_;
				if (!(i < _tmp93_)) {
					break;
				}
				_tmp94_ = middle_points;
				_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, i);
				_g_object_unref0 (hidden);
				hidden = (BirdFontEditPoint*) _tmp95_;
				_tmp96_ = middle_points;
				_tmp97_ = gee_abstract_list_get ((GeeAbstractList*) _tmp96_, i);
				_tmp98_ = (BirdFontEditPoint*) _tmp97_;
				_tmp99_ = first_points;
				_tmp100_ = gee_abstract_list_get ((GeeAbstractList*) _tmp99_, i);
				_tmp101_ = (BirdFontEditPoint*) _tmp100_;
				_tmp102_ = bird_font_path_add_point_after (self, _tmp98_, _tmp101_);
				_tmp103_ = _tmp102_;
				_g_object_unref0 (_tmp103_);
				_g_object_unref0 (_tmp101_);
				_g_object_unref0 (_tmp98_);
			}
		}
	}
	bird_font_path_create_list (self);
	_tmp104_ = bird_font_path_get_last_point (self);
	_g_object_unref0 (prev);
	prev = _tmp104_;
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp105_;
		GeeArrayList* _tmp106_;
		gint _ep_size = 0;
		GeeArrayList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _ep_index = 0;
		_tmp105_ = bird_font_path_get_points (self);
		_tmp106_ = _tmp105_;
		_ep_list = _tmp106_;
		_tmp107_ = _ep_list;
		_tmp108_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_ep_size = _tmp109_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp110_;
			gint _tmp111_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp112_;
			gpointer _tmp113_;
			BirdFontEditPoint* _tmp114_;
			BirdFontEditPoint* _tmp125_;
			BirdFontEditPoint* _tmp126_;
			_ep_index = _ep_index + 1;
			_tmp110_ = _ep_index;
			_tmp111_ = _ep_size;
			if (!(_tmp110_ < _tmp111_)) {
				break;
			}
			_tmp112_ = _ep_list;
			_tmp113_ = gee_abstract_list_get ((GeeAbstractList*) _tmp112_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp113_;
			_tmp114_ = ep;
			if (_tmp114_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
				BirdFontEditPoint* _tmp115_;
				BirdFontEditPointHandle* _tmp116_;
				gdouble _tmp117_;
				gdouble _tmp118_;
				BirdFontEditPoint* _tmp119_;
				BirdFontEditPointHandle* _tmp120_;
				gdouble _tmp121_;
				gdouble _tmp122_;
				BirdFontEditPoint* _tmp123_;
				BirdFontEditPointHandle* _tmp124_;
				_tmp115_ = prev;
				_tmp116_ = bird_font_edit_point_get_right_handle (_tmp115_);
				_tmp117_ = bird_font_edit_point_handle_get_x (_tmp116_);
				_tmp118_ = _tmp117_;
				x = _tmp118_;
				_tmp119_ = prev;
				_tmp120_ = bird_font_edit_point_get_right_handle (_tmp119_);
				_tmp121_ = bird_font_edit_point_handle_get_y (_tmp120_);
				_tmp122_ = _tmp121_;
				y = _tmp122_;
				_tmp123_ = ep;
				_tmp124_ = bird_font_edit_point_get_left_handle (_tmp123_);
				bird_font_edit_point_handle_move_to_coordinate (_tmp124_, x, y);
			}
			_tmp125_ = ep;
			_tmp126_ = _g_object_ref0 (_tmp125_);
			_g_object_unref0 (prev);
			prev = _tmp126_;
			_g_object_unref0 (ep);
		}
	}
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (first_points);
	_g_object_unref0 (middle_points);
	_g_object_unref0 (first);
	_g_object_unref0 (prev);
	_g_object_unref0 (hidden);
}

/** Convert quadratic bezier points to cubic representation of the glyph
 * for ttf-export.
 */
BirdFontPath*
bird_font_path_get_quadratic_points (BirdFontPath* self)
{
	BirdFontPointConverter* converter = NULL;
	BirdFontPointConverter* _tmp0_;
	BirdFontPath* _tmp1_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_point_converter_new (self);
	_bird_font_point_converter_unref0 (converter);
	converter = _tmp0_;
	_tmp1_ = bird_font_point_converter_get_quadratic_path (converter);
	result = _tmp1_;
	_bird_font_point_converter_unref0 (converter);
	return result;
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		BirdFontPath* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->ep);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static gboolean
___lambda29_ (Block46Data* _data46_,
              gdouble cx,
              gdouble cy,
              gdouble t)
{
	BirdFontPath* self;
	gdouble n = 0.0;
	gboolean result;
	self = _data46_->self;
	n = pow (_data46_->ep->x - cx, (gdouble) 2) + pow (_data46_->ep->y - cy, (gdouble) 2);
	if (n < _data46_->min) {
		_data46_->min = n;
		_data46_->position = t;
		_data46_->closest_x = cx;
		_data46_->closest_y = cy;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda29__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda29_ (self, x, y, step);
	return result;
}

void
bird_font_path_insert_new_point_on_path (BirdFontPath* self,
                                         BirdFontEditPoint* ep,
                                         gdouble t,
                                         gboolean move_point_to_path)
{
	Block46Data* _data46_;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* start = NULL;
	BirdFontEditPoint* stop = NULL;
	gdouble x0 = 0.0;
	gdouble x1 = 0.0;
	gdouble y0 = 0.0;
	gdouble y1 = 0.0;
	BirdFontPointType left = 0;
	BirdFontPointType right = 0;
	gboolean _tmp1_ = FALSE;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	gboolean _tmp12_ = FALSE;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPoint* _tmp19_;
	gboolean _tmp22_ = FALSE;
	BirdFontEditPointHandle* _tmp109_;
	BirdFontEditPointHandle* _tmp110_;
	BirdFontEditPoint* _tmp111_;
	BirdFontEditPointHandle* _tmp112_;
	BirdFontEditPoint* _tmp113_;
	BirdFontEditPointHandle* _tmp114_;
	BirdFontEditPoint* _tmp115_;
	BirdFontEditPointHandle* _tmp116_;
	BirdFontEditPoint* _tmp117_;
	BirdFontEditPointHandle* _tmp118_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ep != NULL);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (ep);
	_g_object_unref0 (_data46_->ep);
	_data46_->ep = _tmp0_;
	_data46_->closest_x = (gdouble) 0;
	_data46_->closest_y = (gdouble) 0;
	_tmp2_ = _data46_->ep->next;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BirdFontEditPoint* _tmp3_;
		_tmp3_ = _data46_->ep->prev;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		g_warning ("Path.vala:1323: missing point");
		_g_object_unref0 (stop);
		_g_object_unref0 (start);
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return;
	}
	_tmp4_ = bird_font_edit_point_get_prev (_data46_->ep);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (start);
	start = _tmp5_;
	_tmp6_ = bird_font_edit_point_get_next (_data46_->ep);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (stop);
	stop = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = bird_font_edit_point_get_right_handle (_tmp8_);
	right = _tmp9_->type;
	_tmp10_ = stop;
	_tmp11_ = bird_font_edit_point_get_left_handle (_tmp10_);
	left = _tmp11_->type;
	if (right == BIRD_FONT_POINT_TYPE_CUBIC) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = left == BIRD_FONT_POINT_TYPE_CUBIC;
	}
	if (_tmp12_) {
		BirdFontEditPoint* _tmp13_;
		BirdFontEditPointHandle* _tmp14_;
		BirdFontEditPoint* _tmp15_;
		BirdFontEditPointHandle* _tmp16_;
		_tmp13_ = start;
		_tmp14_ = bird_font_edit_point_get_right_handle (_tmp13_);
		_tmp14_->type = BIRD_FONT_POINT_TYPE_CUBIC;
		_tmp15_ = stop;
		_tmp16_ = bird_font_edit_point_get_left_handle (_tmp15_);
		_tmp16_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	}
	_tmp17_ = bird_font_edit_point_get_prev (_data46_->ep);
	_tmp18_ = bird_font_path_add_point_after (self, _data46_->ep, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	_data46_->min = DBL_MAX;
	_data46_->position = 0.5;
	if (t < ((gdouble) 0)) {
		BirdFontEditPoint* _tmp20_;
		BirdFontEditPoint* _tmp21_;
		_tmp20_ = start;
		_tmp21_ = stop;
		bird_font_path_all_of (_tmp20_, _tmp21_, ____lambda29__bird_font_path_raster_iterator, _data46_, -1, (gdouble) 0, (gdouble) 1);
		if (move_point_to_path) {
			_data46_->ep->x = _data46_->closest_x;
			_data46_->ep->y = _data46_->closest_y;
		}
	} else {
		_data46_->position = t;
	}
	if (right == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = left == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp22_) {
		BirdFontEditPoint* _tmp23_;
		BirdFontEditPoint* _tmp24_;
		BirdFontEditPointHandle* _tmp25_;
		gdouble _tmp26_;
		gdouble _tmp27_;
		BirdFontEditPoint* _tmp28_;
		BirdFontEditPointHandle* _tmp29_;
		gdouble _tmp30_;
		gdouble _tmp31_;
		BirdFontEditPoint* _tmp32_;
		gdouble _tmp33_ = 0.0;
		gdouble _tmp34_ = 0.0;
		BirdFontEditPoint* _tmp35_;
		BirdFontEditPoint* _tmp36_;
		BirdFontEditPointHandle* _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_;
		BirdFontEditPoint* _tmp40_;
		BirdFontEditPointHandle* _tmp41_;
		gdouble _tmp42_;
		gdouble _tmp43_;
		BirdFontEditPoint* _tmp44_;
		gdouble _tmp45_ = 0.0;
		gdouble _tmp46_ = 0.0;
		BirdFontEditPointHandle* _tmp47_;
		BirdFontEditPointHandle* _tmp48_;
		BirdFontEditPointHandle* _tmp49_;
		BirdFontEditPointHandle* _tmp50_;
		_tmp23_ = start;
		_tmp24_ = start;
		_tmp25_ = bird_font_edit_point_get_right_handle (_tmp24_);
		_tmp26_ = bird_font_edit_point_handle_get_x (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = stop;
		_tmp29_ = bird_font_edit_point_get_left_handle (_tmp28_);
		_tmp30_ = bird_font_edit_point_handle_get_x (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = stop;
		bird_font_path_double_bezier_vector (_data46_->position, _tmp23_->x, _tmp27_, _tmp31_, _tmp32_->x, &_tmp33_, &_tmp34_);
		x0 = _tmp33_;
		x1 = _tmp34_;
		_tmp35_ = start;
		_tmp36_ = start;
		_tmp37_ = bird_font_edit_point_get_right_handle (_tmp36_);
		_tmp38_ = bird_font_edit_point_handle_get_y (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = stop;
		_tmp41_ = bird_font_edit_point_get_left_handle (_tmp40_);
		_tmp42_ = bird_font_edit_point_handle_get_y (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = stop;
		bird_font_path_double_bezier_vector (_data46_->position, _tmp35_->y, _tmp39_, _tmp43_, _tmp44_->y, &_tmp45_, &_tmp46_);
		y0 = _tmp45_;
		y1 = _tmp46_;
		_tmp47_ = bird_font_edit_point_get_left_handle (_data46_->ep);
		bird_font_edit_point_handle_set_point_type (_tmp47_, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
		_tmp48_ = bird_font_edit_point_get_right_handle (_data46_->ep);
		bird_font_edit_point_handle_set_point_type (_tmp48_, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
		_tmp49_ = bird_font_edit_point_get_left_handle (_data46_->ep);
		bird_font_edit_point_handle_move_to_coordinate (_tmp49_, x0, y0);
		_tmp50_ = bird_font_edit_point_get_right_handle (_data46_->ep);
		bird_font_edit_point_handle_move_to_coordinate (_tmp50_, x1, y1);
		_data46_->ep->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	} else {
		if (right == BIRD_FONT_POINT_TYPE_QUADRATIC) {
			BirdFontEditPoint* _tmp51_;
			BirdFontEditPoint* _tmp52_;
			BirdFontEditPointHandle* _tmp53_;
			gdouble _tmp54_;
			gdouble _tmp55_;
			BirdFontEditPoint* _tmp56_;
			BirdFontEditPoint* _tmp57_;
			BirdFontEditPoint* _tmp58_;
			BirdFontEditPointHandle* _tmp59_;
			gdouble _tmp60_;
			gdouble _tmp61_;
			BirdFontEditPoint* _tmp62_;
			BirdFontEditPointHandle* _tmp63_;
			BirdFontEditPointHandle* _tmp64_;
			BirdFontEditPointHandle* _tmp65_;
			BirdFontEditPointHandle* _tmp66_;
			_tmp51_ = stop;
			_tmp52_ = start;
			_tmp53_ = bird_font_edit_point_get_right_handle (_tmp52_);
			_tmp54_ = bird_font_edit_point_handle_get_x (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = start;
			x0 = bird_font_path_quadratic_bezier_vector (1 - _data46_->position, _tmp51_->x, _tmp55_, _tmp56_->x);
			_tmp57_ = stop;
			_tmp58_ = start;
			_tmp59_ = bird_font_edit_point_get_right_handle (_tmp58_);
			_tmp60_ = bird_font_edit_point_handle_get_y (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = start;
			y0 = bird_font_path_quadratic_bezier_vector (1 - _data46_->position, _tmp57_->y, _tmp61_, _tmp62_->y);
			_tmp63_ = bird_font_edit_point_get_right_handle (_data46_->ep);
			bird_font_edit_point_handle_move_to_coordinate (_tmp63_, x0, y0);
			_tmp64_ = bird_font_edit_point_get_left_handle (_data46_->ep);
			bird_font_edit_point_handle_set_point_type (_tmp64_, BIRD_FONT_POINT_TYPE_QUADRATIC);
			_tmp65_ = bird_font_edit_point_get_right_handle (_data46_->ep);
			bird_font_edit_point_handle_set_point_type (_tmp65_, BIRD_FONT_POINT_TYPE_QUADRATIC);
			_tmp66_ = bird_font_edit_point_get_left_handle (_data46_->ep);
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp66_, (gdouble) 0, (gdouble) 0);
			_data46_->ep->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
		} else {
			gboolean _tmp67_ = FALSE;
			if (right == BIRD_FONT_POINT_TYPE_CUBIC) {
				_tmp67_ = TRUE;
			} else {
				_tmp67_ = left == BIRD_FONT_POINT_TYPE_CUBIC;
			}
			if (_tmp67_) {
				BirdFontEditPoint* _tmp68_;
				BirdFontEditPoint* _tmp69_;
				BirdFontEditPointHandle* _tmp70_;
				gdouble _tmp71_;
				gdouble _tmp72_;
				BirdFontEditPoint* _tmp73_;
				BirdFontEditPointHandle* _tmp74_;
				gdouble _tmp75_;
				gdouble _tmp76_;
				BirdFontEditPoint* _tmp77_;
				gdouble _tmp78_ = 0.0;
				gdouble _tmp79_ = 0.0;
				BirdFontEditPoint* _tmp80_;
				BirdFontEditPoint* _tmp81_;
				BirdFontEditPointHandle* _tmp82_;
				gdouble _tmp83_;
				gdouble _tmp84_;
				BirdFontEditPoint* _tmp85_;
				BirdFontEditPointHandle* _tmp86_;
				gdouble _tmp87_;
				gdouble _tmp88_;
				BirdFontEditPoint* _tmp89_;
				gdouble _tmp90_ = 0.0;
				gdouble _tmp91_ = 0.0;
				BirdFontEditPointHandle* _tmp92_;
				BirdFontEditPointHandle* _tmp93_;
				BirdFontEditPointHandle* _tmp94_;
				BirdFontEditPointHandle* _tmp95_;
				_tmp68_ = start;
				_tmp69_ = start;
				_tmp70_ = bird_font_edit_point_get_right_handle (_tmp69_);
				_tmp71_ = bird_font_edit_point_handle_get_x (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = stop;
				_tmp74_ = bird_font_edit_point_get_left_handle (_tmp73_);
				_tmp75_ = bird_font_edit_point_handle_get_x (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = stop;
				bird_font_path_bezier_vector (_data46_->position, _tmp68_->x, _tmp72_, _tmp76_, _tmp77_->x, &_tmp78_, &_tmp79_);
				x0 = _tmp78_;
				x1 = _tmp79_;
				_tmp80_ = start;
				_tmp81_ = start;
				_tmp82_ = bird_font_edit_point_get_right_handle (_tmp81_);
				_tmp83_ = bird_font_edit_point_handle_get_y (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = stop;
				_tmp86_ = bird_font_edit_point_get_left_handle (_tmp85_);
				_tmp87_ = bird_font_edit_point_handle_get_y (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = stop;
				bird_font_path_bezier_vector (_data46_->position, _tmp80_->y, _tmp84_, _tmp88_, _tmp89_->y, &_tmp90_, &_tmp91_);
				y0 = _tmp90_;
				y1 = _tmp91_;
				_tmp92_ = bird_font_edit_point_get_left_handle (_data46_->ep);
				bird_font_edit_point_handle_set_point_type (_tmp92_, BIRD_FONT_POINT_TYPE_CUBIC);
				_tmp93_ = bird_font_edit_point_get_left_handle (_data46_->ep);
				bird_font_edit_point_handle_move_to_coordinate (_tmp93_, x0, y0);
				_tmp94_ = bird_font_edit_point_get_right_handle (_data46_->ep);
				bird_font_edit_point_handle_set_point_type (_tmp94_, BIRD_FONT_POINT_TYPE_CUBIC);
				_tmp95_ = bird_font_edit_point_get_right_handle (_data46_->ep);
				bird_font_edit_point_handle_move_to_coordinate (_tmp95_, x1, y1);
				_data46_->ep->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			} else {
				gboolean _tmp96_ = FALSE;
				if (right == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
					_tmp96_ = left == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
				} else {
					_tmp96_ = FALSE;
				}
				if (_tmp96_) {
					BirdFontEditPointHandle* _tmp97_;
					BirdFontEditPointHandle* _tmp98_;
					_tmp97_ = bird_font_edit_point_get_right_handle (_data46_->ep);
					bird_font_edit_point_handle_set_point_type (_tmp97_, BIRD_FONT_POINT_TYPE_LINE_QUADRATIC);
					_tmp98_ = bird_font_edit_point_get_left_handle (_data46_->ep);
					bird_font_edit_point_handle_set_point_type (_tmp98_, BIRD_FONT_POINT_TYPE_LINE_QUADRATIC);
					_data46_->ep->type = BIRD_FONT_POINT_TYPE_QUADRATIC;
				} else {
					gboolean _tmp99_ = FALSE;
					if (right == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
						_tmp99_ = left == BIRD_FONT_POINT_TYPE_LINE_CUBIC;
					} else {
						_tmp99_ = FALSE;
					}
					if (_tmp99_) {
						BirdFontEditPointHandle* _tmp100_;
						BirdFontEditPointHandle* _tmp101_;
						_tmp100_ = bird_font_edit_point_get_right_handle (_data46_->ep);
						bird_font_edit_point_handle_set_point_type (_tmp100_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
						_tmp101_ = bird_font_edit_point_get_left_handle (_data46_->ep);
						bird_font_edit_point_handle_set_point_type (_tmp101_, BIRD_FONT_POINT_TYPE_LINE_CUBIC);
						_data46_->ep->type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
					} else {
						gboolean _tmp102_ = FALSE;
						if (right == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
							_tmp102_ = left == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
						} else {
							_tmp102_ = FALSE;
						}
						if (_tmp102_) {
							BirdFontEditPointHandle* _tmp103_;
							BirdFontEditPointHandle* _tmp104_;
							_tmp103_ = bird_font_edit_point_get_right_handle (_data46_->ep);
							bird_font_edit_point_handle_set_point_type (_tmp103_, BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE);
							_tmp104_ = bird_font_edit_point_get_left_handle (_data46_->ep);
							bird_font_edit_point_handle_set_point_type (_tmp104_, BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE);
							_data46_->ep->type = BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
						} else {
							GEnumValue* _tmp105_;
							GEnumValue* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp108_;
							_tmp105_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), right);
							_tmp106_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), left);
							_tmp107_ = g_strconcat ("Point types: ", (_tmp105_ != NULL) ? _tmp105_->value_name : NULL, " and ", (_tmp106_ != NULL) ? _tmp106_->value_name : NULL, " in insert_new_point_on_path", NULL);
							_tmp108_ = _tmp107_;
							g_warning ("Path.vala:1412: %s", _tmp108_);
							_g_free0 (_tmp108_);
						}
					}
				}
			}
		}
	}
	_tmp109_ = bird_font_edit_point_get_left_handle (_data46_->ep);
	_tmp109_->parent = _data46_->ep;
	_tmp110_ = bird_font_edit_point_get_right_handle (_data46_->ep);
	_tmp110_->parent = _data46_->ep;
	_tmp111_ = stop;
	_tmp112_ = bird_font_edit_point_get_left_handle (_tmp111_);
	_tmp113_ = stop;
	_tmp114_ = bird_font_edit_point_get_left_handle (_tmp113_);
	_tmp114_->length = _tmp114_->length * (1 - _data46_->position);
	_tmp115_ = start;
	_tmp116_ = bird_font_edit_point_get_right_handle (_tmp115_);
	_tmp117_ = start;
	_tmp118_ = bird_font_edit_point_get_right_handle (_tmp117_);
	_tmp118_->length = _tmp118_->length * _data46_->position;
	if (right == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		BirdFontEditPoint* _tmp119_;
		_tmp119_ = _data46_->ep->prev;
		if (_tmp119_ != NULL) {
			BirdFontEditPointHandle* _tmp120_;
			BirdFontEditPoint* _tmp121_;
			BirdFontEditPointHandle* _tmp122_;
			gdouble _tmp123_;
			gdouble _tmp124_;
			BirdFontEditPoint* _tmp125_;
			BirdFontEditPointHandle* _tmp126_;
			gdouble _tmp127_;
			gdouble _tmp128_;
			_tmp120_ = bird_font_edit_point_get_left_handle (_data46_->ep);
			_tmp121_ = bird_font_edit_point_get_prev (_data46_->ep);
			_tmp122_ = _tmp121_->right_handle;
			_tmp123_ = bird_font_edit_point_handle_get_x (_tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = bird_font_edit_point_get_prev (_data46_->ep);
			_tmp126_ = _tmp125_->right_handle;
			_tmp127_ = bird_font_edit_point_handle_get_y (_tmp126_);
			_tmp128_ = _tmp127_;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp120_, _tmp124_, _tmp128_);
		} else {
			g_warning ("Path.vala:1428: ep.prev is null for quadratic point");
		}
	}
	bird_font_path_create_list (self);
	bird_font_path_recalculate_linear_handles (self);
	_g_object_unref0 (stop);
	_g_object_unref0 (start);
	block46_data_unref (_data46_);
	_data46_ = NULL;
}

/** Get a point on the this path closest to x and y coordinates.
 * Don't look for a point in the segment skip_previous to skip_next.
 */
static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		BirdFontPath* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->next_point);
		_g_object_unref0 (_data47_->previous_point);
		_g_object_unref0 (_data47_->i);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gboolean
___lambda30_ (Block47Data* _data47_,
              gdouble cx,
              gdouble cy,
              gdouble t)
{
	BirdFontPath* self;
	gboolean result;
	self = _data47_->self;
	_data47_->n = pow (_data47_->x - cx, (gdouble) 2) + pow (_data47_->y - cy, (gdouble) 2);
	if (_data47_->n < _data47_->min) {
		BirdFontEditPoint* _tmp0_;
		BirdFontEditPoint* _tmp1_;
		BirdFontEditPoint* _tmp2_;
		BirdFontEditPoint* _tmp3_;
		BirdFontEditPoint* _tmp4_;
		_data47_->min = _data47_->n;
		_data47_->ox = cx;
		_data47_->oy = cy;
		_tmp0_ = _data47_->i;
		_tmp1_ = _tmp0_->prev;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (_data47_->previous_point);
		_data47_->previous_point = _tmp2_;
		_tmp3_ = _data47_->i;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (_data47_->next_point);
		_data47_->next_point = _tmp4_;
		_data47_->step = t;
		_data47_->g = TRUE;
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda30__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = ___lambda30_ (self, x, y, step);
	return result;
}

void
bird_font_path_get_closest_point_on_path (BirdFontPath* self,
                                          BirdFontEditPoint* edit_point,
                                          gdouble x,
                                          gdouble y,
                                          BirdFontEditPoint* skip_previous,
                                          BirdFontEditPoint* skip_next,
                                          gint steps)
{
	Block47Data* _data47_;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* prev = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gpointer _tmp13_;
	gboolean done = FALSE;
	gboolean exit = FALSE;
	gboolean first = FALSE;
	BirdFontEditPoint* previous = NULL;
	BirdFontEditPoint* next = NULL;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	BirdFontEditPoint* _tmp26_;
	BirdFontEditPoint* _tmp27_;
	gboolean _tmp69_ = FALSE;
	BirdFontEditPoint* _tmp70_;
	BirdFontEditPoint* _tmp81_;
	BirdFontEditPoint* _tmp90_;
	BirdFontEditPoint* _tmp91_;
	BirdFontEditPoint* _tmp92_;
	BirdFontEditPoint* _tmp93_;
	BirdFontEditPoint* _tmp94_;
	BirdFontEditPoint* _tmp95_;
	BirdFontEditPoint* _tmp96_;
	BirdFontEditPoint* _tmp97_;
	BirdFontEditPointHandle* _tmp98_;
	BirdFontEditPoint* _tmp99_;
	BirdFontEditPointHandle* _tmp100_;
	BirdFontEditPointHandle* _tmp101_;
	BirdFontEditPoint* _tmp102_;
	BirdFontEditPointHandle* _tmp103_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (edit_point != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_data47_->x = x;
	_data47_->y = y;
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_return_if_fail (_tmp3_ >= 1);
	_data47_->min = DBL_MAX;
	_data47_->n = (gdouble) 0;
	_data47_->g = FALSE;
	_data47_->ox = (gdouble) 0;
	_data47_->oy = (gdouble) 0;
	_tmp4_ = bird_font_path_get_points (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_path_get_points (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp9_ - 1);
	prev = (BirdFontEditPoint*) _tmp10_;
	_tmp11_ = bird_font_path_get_points (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
	_data47_->i = (BirdFontEditPoint*) _tmp13_;
	done = FALSE;
	exit = FALSE;
	first = TRUE;
	_data47_->previous_point = NULL;
	_data47_->next_point = NULL;
	_data47_->step = (gdouble) 0;
	_tmp14_ = bird_font_path_get_points (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 0) {
		g_warning ("Path.vala:1466: Empty path.");
		_g_object_unref0 (next);
		_g_object_unref0 (previous);
		_g_object_unref0 (prev);
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp18_ = bird_font_path_get_points (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ == 1) {
		BirdFontEditPoint* _tmp22_;
		BirdFontEditPoint* _tmp23_;
		BirdFontEditPoint* _tmp24_;
		BirdFontEditPoint* _tmp25_;
		_tmp22_ = _data47_->i;
		edit_point->x = _tmp22_->x;
		_tmp23_ = _data47_->i;
		edit_point->y = _tmp23_->y;
		_tmp24_ = _data47_->i;
		edit_point->prev = _tmp24_;
		_tmp25_ = _data47_->i;
		edit_point->next = _tmp25_;
		_g_object_unref0 (next);
		_g_object_unref0 (previous);
		_g_object_unref0 (prev);
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp26_ = _data47_->i;
	edit_point->x = _tmp26_->x;
	_tmp27_ = _data47_->i;
	edit_point->y = _tmp27_->y;
	bird_font_path_create_list (self);
	while (TRUE) {
		gboolean _tmp28_ = FALSE;
		BirdFontEditPoint* _tmp55_;
		gboolean _tmp56_ = FALSE;
		BirdFontEditPoint* _tmp57_;
		BirdFontEditPoint* _tmp58_;
		BirdFontEditPoint* _tmp61_;
		gboolean _tmp62_ = FALSE;
		BirdFontEditPoint* _tmp63_;
		BirdFontEditPoint* _tmp64_;
		BirdFontEditPoint* _tmp67_;
		BirdFontEditPoint* _tmp68_;
		if (!(!exit)) {
			break;
		}
		if (!first) {
			BirdFontEditPoint* _tmp29_;
			GeeArrayList* _tmp30_;
			GeeArrayList* _tmp31_;
			GeeArrayList* _tmp32_;
			GeeArrayList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_;
			BirdFontEditPoint* _tmp37_;
			_tmp29_ = _data47_->i;
			_tmp30_ = bird_font_path_get_points (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = bird_font_path_get_points (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp35_ - 1);
			_tmp37_ = (BirdFontEditPoint*) _tmp36_;
			_tmp28_ = _tmp29_ == _tmp37_;
			_g_object_unref0 (_tmp37_);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			done = TRUE;
		}
		if (!done) {
			BirdFontEditPoint* _tmp38_;
			BirdFontEditPoint* _tmp39_;
			BirdFontEditPoint* _tmp40_;
			BirdFontEditPoint* _tmp41_;
			BirdFontEditPoint* _tmp42_;
			BirdFontEditPoint* _tmp43_;
			_tmp38_ = _data47_->i;
			_tmp39_ = bird_font_edit_point_get_next (_tmp38_);
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (_data47_->i);
			_data47_->i = _tmp40_;
			_tmp41_ = _data47_->i;
			_tmp42_ = bird_font_edit_point_get_prev (_tmp41_);
			_tmp43_ = _g_object_ref0 (_tmp42_);
			_g_object_unref0 (prev);
			prev = _tmp43_;
		} else {
			gboolean _tmp44_ = FALSE;
			if (done) {
				_tmp44_ = !bird_font_path_is_open (self);
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				GeeArrayList* _tmp45_;
				GeeArrayList* _tmp46_;
				gpointer _tmp47_;
				GeeArrayList* _tmp48_;
				GeeArrayList* _tmp49_;
				GeeArrayList* _tmp50_;
				GeeArrayList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_;
				_tmp45_ = bird_font_path_get_points (self);
				_tmp46_ = _tmp45_;
				_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, 0);
				_g_object_unref0 (_data47_->i);
				_data47_->i = (BirdFontEditPoint*) _tmp47_;
				_tmp48_ = bird_font_path_get_points (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = bird_font_path_get_points (self);
				_tmp51_ = _tmp50_;
				_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp53_ - 1);
				_g_object_unref0 (prev);
				prev = (BirdFontEditPoint*) _tmp54_;
				exit = TRUE;
			} else {
				break;
			}
		}
		_tmp55_ = prev;
		if (skip_previous == _tmp55_) {
			continue;
		}
		_tmp57_ = prev;
		_tmp58_ = _tmp57_->prev;
		if (_tmp58_ != NULL) {
			BirdFontEditPoint* _tmp59_;
			BirdFontEditPoint* _tmp60_;
			_tmp59_ = prev;
			_tmp60_ = bird_font_edit_point_get_prev (_tmp59_);
			_tmp56_ = skip_previous == _tmp60_;
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			continue;
		}
		_tmp61_ = _data47_->i;
		if (skip_next == _tmp61_) {
			continue;
		}
		_tmp63_ = prev;
		_tmp64_ = _tmp63_->next;
		if (_tmp64_ != NULL) {
			BirdFontEditPoint* _tmp65_;
			BirdFontEditPoint* _tmp66_;
			_tmp65_ = prev;
			_tmp66_ = bird_font_edit_point_get_next (_tmp65_);
			_tmp62_ = skip_next == _tmp66_;
		} else {
			_tmp62_ = FALSE;
		}
		if (_tmp62_) {
			continue;
		}
		_tmp67_ = prev;
		_tmp68_ = _data47_->i;
		bird_font_path_all_of (_tmp67_, _tmp68_, ____lambda30__bird_font_path_raster_iterator, _data47_, steps, (gdouble) 0, (gdouble) 1);
		first = FALSE;
	}
	_tmp70_ = _data47_->previous_point;
	if (_tmp70_ == NULL) {
		_tmp69_ = bird_font_path_is_open (self);
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		GeeArrayList* _tmp71_;
		GeeArrayList* _tmp72_;
		GeeArrayList* _tmp73_;
		GeeArrayList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gpointer _tmp77_;
		BirdFontEditPoint* _tmp78_;
		BirdFontEditPoint* _tmp79_;
		BirdFontEditPoint* _tmp80_;
		_tmp71_ = bird_font_path_get_points (self);
		_tmp72_ = _tmp71_;
		_tmp73_ = bird_font_path_get_points (self);
		_tmp74_ = _tmp73_;
		_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp76_ - 1);
		_tmp78_ = (BirdFontEditPoint*) _tmp77_;
		_tmp79_ = bird_font_edit_point_get_link_item (_tmp78_);
		_tmp80_ = _g_object_ref0 (_tmp79_);
		_g_object_unref0 (_data47_->previous_point);
		_data47_->previous_point = _tmp80_;
		_g_object_unref0 (_tmp78_);
	}
	_tmp81_ = _data47_->previous_point;
	if (_tmp81_ == NULL) {
		GeeArrayList* _tmp82_;
		GeeArrayList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		_tmp82_ = bird_font_path_get_points (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strdup_printf ("%i", _tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat ("previous_point == null, points.size: ", _tmp87_, NULL);
		_tmp89_ = _tmp88_;
		g_warning ("Path.vala:1544: %s", _tmp89_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		_g_object_unref0 (next);
		_g_object_unref0 (previous);
		_g_object_unref0 (prev);
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp90_ = _data47_->next_point;
	if (_tmp90_ == NULL) {
		g_warning ("Path.vala:1549: next_point != null");
		_g_object_unref0 (next);
		_g_object_unref0 (previous);
		_g_object_unref0 (prev);
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	_tmp91_ = _data47_->previous_point;
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
	_g_object_unref0 (previous);
	previous = _tmp92_;
	_tmp93_ = _data47_->next_point;
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, BIRD_FONT_TYPE_EDIT_POINT, BirdFontEditPoint));
	_g_object_unref0 (next);
	next = _tmp94_;
	_tmp95_ = _data47_->previous_point;
	edit_point->prev = _tmp95_;
	_tmp96_ = _data47_->next_point;
	edit_point->next = _tmp96_;
	bird_font_edit_point_set_position (edit_point, _data47_->ox, _data47_->oy);
	_tmp97_ = previous;
	edit_point->type = _tmp97_->type;
	_tmp98_ = bird_font_edit_point_get_left_handle (edit_point);
	_tmp99_ = previous;
	_tmp100_ = bird_font_edit_point_get_right_handle (_tmp99_);
	_tmp98_->type = _tmp100_->type;
	_tmp101_ = bird_font_edit_point_get_right_handle (edit_point);
	_tmp102_ = next;
	_tmp103_ = bird_font_edit_point_get_left_handle (_tmp102_);
	_tmp101_->type = _tmp103_->type;
	_g_object_unref0 (next);
	_g_object_unref0 (previous);
	_g_object_unref0 (prev);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

gboolean
bird_font_path_all_of (BirdFontEditPoint* start,
                       BirdFontEditPoint* stop,
                       BirdFontPathRasterIterator iter,
                       gpointer iter_target,
                       gint steps,
                       gdouble min_t,
                       gdouble max_t)
{
	BirdFontPointType right = 0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontPointType left = 0;
	BirdFontEditPointHandle* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp35_ = FALSE;
	BirdFontEditPointHandle* _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	BirdFontEditPointHandle* _tmp39_;
	gdouble _tmp40_;
	gdouble _tmp41_;
	gboolean result;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	right = bird_font_pen_tool_to_curve (_tmp0_->type);
	_tmp1_ = bird_font_edit_point_get_left_handle (stop);
	left = bird_font_pen_tool_to_curve (_tmp1_->type);
	if (steps == -1) {
		steps = (gint) (10 * bird_font_path_get_length_from (start, stop));
	}
	if (right == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = left == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp2_) {
		BirdFontEditPointHandle* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		BirdFontEditPointHandle* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		BirdFontEditPointHandle* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		BirdFontEditPointHandle* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		_tmp3_ = bird_font_edit_point_get_right_handle (start);
		_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_edit_point_get_right_handle (start);
		_tmp7_ = bird_font_edit_point_handle_get_y (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = bird_font_edit_point_get_left_handle (stop);
		_tmp10_ = bird_font_edit_point_handle_get_x (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_edit_point_get_left_handle (stop);
		_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
		_tmp14_ = _tmp13_;
		result = bird_font_path_all_of_double (start->x, start->y, _tmp5_, _tmp8_, _tmp11_, _tmp14_, stop->x, stop->y, iter, iter_target, (gdouble) steps, min_t, max_t);
		return result;
	} else {
		gboolean _tmp15_ = FALSE;
		if (right == BIRD_FONT_POINT_TYPE_QUADRATIC) {
			_tmp15_ = left == BIRD_FONT_POINT_TYPE_QUADRATIC;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			BirdFontEditPointHandle* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			BirdFontEditPointHandle* _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_;
			_tmp16_ = bird_font_edit_point_get_right_handle (start);
			_tmp17_ = bird_font_edit_point_handle_get_x (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = bird_font_edit_point_get_right_handle (start);
			_tmp20_ = bird_font_edit_point_handle_get_y (_tmp19_);
			_tmp21_ = _tmp20_;
			result = bird_font_path_all_of_quadratic_curve (start->x, start->y, _tmp18_, _tmp21_, stop->x, stop->y, iter, iter_target, (gdouble) steps, min_t, max_t);
			return result;
		} else {
			gboolean _tmp22_ = FALSE;
			if (right == BIRD_FONT_POINT_TYPE_CUBIC) {
				_tmp22_ = left == BIRD_FONT_POINT_TYPE_CUBIC;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				BirdFontEditPointHandle* _tmp23_;
				gdouble _tmp24_;
				gdouble _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				gdouble _tmp27_;
				gdouble _tmp28_;
				BirdFontEditPointHandle* _tmp29_;
				gdouble _tmp30_;
				gdouble _tmp31_;
				BirdFontEditPointHandle* _tmp32_;
				gdouble _tmp33_;
				gdouble _tmp34_;
				_tmp23_ = bird_font_edit_point_get_right_handle (start);
				_tmp24_ = bird_font_edit_point_handle_get_x (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = bird_font_edit_point_get_right_handle (start);
				_tmp27_ = bird_font_edit_point_handle_get_y (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = bird_font_edit_point_get_left_handle (stop);
				_tmp30_ = bird_font_edit_point_handle_get_x (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = bird_font_edit_point_get_left_handle (stop);
				_tmp33_ = bird_font_edit_point_handle_get_y (_tmp32_);
				_tmp34_ = _tmp33_;
				result = bird_font_path_all_of_curve (start->x, start->y, _tmp25_, _tmp28_, _tmp31_, _tmp34_, stop->x, stop->y, iter, iter_target, (gdouble) steps, min_t, max_t);
				return result;
			}
		}
	}
	if (start->x == stop->x) {
		_tmp35_ = start->y == stop->y;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		g_warning ("Path.vala:1586: Zero length.");
		result = TRUE;
		return result;
	}
	_tmp36_ = bird_font_edit_point_get_right_handle (start);
	_tmp37_ = bird_font_edit_point_handle_get_x (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = bird_font_edit_point_get_right_handle (start);
	_tmp40_ = bird_font_edit_point_handle_get_x (_tmp39_);
	_tmp41_ = _tmp40_;
	result = bird_font_path_all_of_quadratic_curve (start->x, start->y, _tmp38_, _tmp41_, stop->x, stop->y, iter, iter_target, (gdouble) steps, (gdouble) 0, (gdouble) 1);
	return result;
}

void
bird_font_path_get_point_for_step (BirdFontEditPoint* start,
                                   BirdFontEditPoint* stop,
                                   gdouble step,
                                   gdouble* x,
                                   gdouble* y)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	BirdFontPointType right = 0;
	BirdFontEditPointHandle* _tmp0_;
	BirdFontPointType left = 0;
	BirdFontEditPointHandle* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (start != NULL);
	g_return_if_fail (stop != NULL);
	_tmp0_ = bird_font_edit_point_get_right_handle (start);
	right = bird_font_pen_tool_to_curve (_tmp0_->type);
	_tmp1_ = bird_font_edit_point_get_left_handle (stop);
	left = bird_font_pen_tool_to_curve (_tmp1_->type);
	if (right == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp2_ = left == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		BirdFontEditPointHandle* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		BirdFontEditPointHandle* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		BirdFontEditPointHandle* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		BirdFontEditPointHandle* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		_tmp3_ = bird_font_edit_point_get_right_handle (start);
		_tmp4_ = bird_font_edit_point_handle_get_x (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_edit_point_get_left_handle (stop);
		_tmp7_ = bird_font_edit_point_handle_get_x (_tmp6_);
		_tmp8_ = _tmp7_;
		_vala_x = bird_font_path_double_bezier_path (step, start->x, _tmp5_, _tmp8_, stop->x);
		_tmp9_ = bird_font_edit_point_get_right_handle (start);
		_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_edit_point_get_left_handle (stop);
		_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
		_tmp14_ = _tmp13_;
		_vala_y = bird_font_path_double_bezier_path (step, start->y, _tmp11_, _tmp14_, stop->y);
	} else {
		gboolean _tmp15_ = FALSE;
		if (right == BIRD_FONT_POINT_TYPE_QUADRATIC) {
			_tmp15_ = left == BIRD_FONT_POINT_TYPE_QUADRATIC;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			BirdFontEditPointHandle* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			BirdFontEditPointHandle* _tmp19_;
			gdouble _tmp20_;
			gdouble _tmp21_;
			_tmp16_ = bird_font_edit_point_get_right_handle (start);
			_tmp17_ = bird_font_edit_point_handle_get_x (_tmp16_);
			_tmp18_ = _tmp17_;
			_vala_x = bird_font_path_quadratic_bezier_path (step, start->x, _tmp18_, stop->x);
			_tmp19_ = bird_font_edit_point_get_right_handle (start);
			_tmp20_ = bird_font_edit_point_handle_get_y (_tmp19_);
			_tmp21_ = _tmp20_;
			_vala_y = bird_font_path_quadratic_bezier_path (step, start->y, _tmp21_, stop->y);
		} else {
			gboolean _tmp22_ = FALSE;
			if (right == BIRD_FONT_POINT_TYPE_CUBIC) {
				_tmp22_ = left == BIRD_FONT_POINT_TYPE_CUBIC;
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				BirdFontEditPointHandle* _tmp23_;
				gdouble _tmp24_;
				gdouble _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				gdouble _tmp27_;
				gdouble _tmp28_;
				BirdFontEditPointHandle* _tmp29_;
				gdouble _tmp30_;
				gdouble _tmp31_;
				BirdFontEditPointHandle* _tmp32_;
				gdouble _tmp33_;
				gdouble _tmp34_;
				_tmp23_ = bird_font_edit_point_get_right_handle (start);
				_tmp24_ = bird_font_edit_point_handle_get_x (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = bird_font_edit_point_get_left_handle (stop);
				_tmp27_ = bird_font_edit_point_handle_get_x (_tmp26_);
				_tmp28_ = _tmp27_;
				_vala_x = bird_font_path_bezier_path (step, start->x, _tmp25_, _tmp28_, stop->x);
				_tmp29_ = bird_font_edit_point_get_right_handle (start);
				_tmp30_ = bird_font_edit_point_handle_get_y (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = bird_font_edit_point_get_left_handle (stop);
				_tmp33_ = bird_font_edit_point_handle_get_y (_tmp32_);
				_tmp34_ = _tmp33_;
				_vala_y = bird_font_path_bezier_path (step, start->y, _tmp31_, _tmp34_, stop->y);
			} else {
				gboolean _tmp35_ = FALSE;
				if (right == BIRD_FONT_POINT_TYPE_HIDDEN) {
					_tmp35_ = left == BIRD_FONT_POINT_TYPE_HIDDEN;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					BirdFontEditPointHandle* _tmp36_;
					gdouble _tmp37_;
					gdouble _tmp38_;
					BirdFontEditPointHandle* _tmp39_;
					gdouble _tmp40_;
					gdouble _tmp41_;
					BirdFontEditPointHandle* _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					BirdFontEditPointHandle* _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					_tmp36_ = bird_font_edit_point_get_right_handle (start);
					_tmp37_ = bird_font_edit_point_handle_get_x (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = bird_font_edit_point_get_left_handle (stop);
					_tmp40_ = bird_font_edit_point_handle_get_x (_tmp39_);
					_tmp41_ = _tmp40_;
					_vala_x = bird_font_path_bezier_path (step, start->x, _tmp38_, _tmp41_, stop->x);
					_tmp42_ = bird_font_edit_point_get_right_handle (start);
					_tmp43_ = bird_font_edit_point_handle_get_y (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = bird_font_edit_point_get_left_handle (stop);
					_tmp46_ = bird_font_edit_point_handle_get_y (_tmp45_);
					_tmp47_ = _tmp46_;
					_vala_y = bird_font_path_bezier_path (step, start->y, _tmp44_, _tmp47_, stop->y);
				} else {
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					GEnumValue* _tmp56_;
					GEnumValue* _tmp57_;
					GEnumValue* _tmp58_;
					GEnumValue* _tmp59_;
					gchar* _tmp60_;
					gchar* _tmp61_;
					BirdFontEditPointHandle* _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_;
					BirdFontEditPointHandle* _tmp65_;
					gdouble _tmp66_;
					gdouble _tmp67_;
					BirdFontEditPointHandle* _tmp68_;
					gdouble _tmp69_;
					gdouble _tmp70_;
					BirdFontEditPointHandle* _tmp71_;
					gdouble _tmp72_;
					gdouble _tmp73_;
					_tmp48_ = double_to_string (start->x);
					_tmp49_ = _tmp48_;
					_tmp50_ = double_to_string (start->y);
					_tmp51_ = _tmp50_;
					_tmp52_ = double_to_string (stop->x);
					_tmp53_ = _tmp52_;
					_tmp54_ = double_to_string (stop->y);
					_tmp55_ = _tmp54_;
					_tmp56_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), right);
					_tmp57_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), left);
					_tmp58_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), start->type);
					_tmp59_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), stop->type);
					_tmp60_ = g_strconcat ("Mixed point types in segment ", _tmp49_, ",", _tmp51_, " to ", _tmp53_, ",", _tmp55_, " right: ", (_tmp56_ != NULL) ? _tmp56_->value_name : NULL, ", left: ", (_tmp57_ != NULL) ? _tmp57_->value_name : NULL, " (start: ", (_tmp58_ != NULL) ? _tmp58_->value_name : NULL, ", stop: ", (_tmp59_ != NULL) ? _tmp59_->value_name : NULL, ")", NULL);
					_tmp61_ = _tmp60_;
					g_warning ("Path.vala:1613: %s", _tmp61_);
					_g_free0 (_tmp61_);
					_g_free0 (_tmp55_);
					_g_free0 (_tmp53_);
					_g_free0 (_tmp51_);
					_g_free0 (_tmp49_);
					_tmp62_ = bird_font_edit_point_get_right_handle (start);
					_tmp63_ = bird_font_edit_point_handle_get_x (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = bird_font_edit_point_get_left_handle (stop);
					_tmp66_ = bird_font_edit_point_handle_get_x (_tmp65_);
					_tmp67_ = _tmp66_;
					_vala_x = bird_font_path_bezier_path (step, start->x, _tmp64_, _tmp67_, stop->x);
					_tmp68_ = bird_font_edit_point_get_right_handle (start);
					_tmp69_ = bird_font_edit_point_handle_get_y (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = bird_font_edit_point_get_left_handle (stop);
					_tmp72_ = bird_font_edit_point_handle_get_y (_tmp71_);
					_tmp73_ = _tmp72_;
					_vala_y = bird_font_path_bezier_path (step, start->y, _tmp70_, _tmp73_, stop->y);
				}
			}
		}
	}
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static gboolean
bird_font_path_all_of_double (gdouble x0,
                              gdouble y0,
                              gdouble x1,
                              gdouble y1,
                              gdouble x2,
                              gdouble y2,
                              gdouble x3,
                              gdouble y3,
                              BirdFontPathRasterIterator iter,
                              gpointer iter_target,
                              gdouble steps,
                              gdouble min_t,
                              gdouble max_t)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble t = 0.0;
	gdouble middle_x = 0.0;
	gdouble middle_y = 0.0;
	gdouble double_step = 0.0;
	gboolean result;
	px = x1;
	py = y1;
	middle_x = x1 + ((x2 - x1) / 2);
	middle_y = y1 + ((y2 - y1) / 2);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gdouble) i) < steps)) {
					break;
				}
				t = (i / steps) + min_t;
				px = bird_font_path_quadratic_bezier_path (t, x0, x1, middle_x);
				py = bird_font_path_quadratic_bezier_path (t, y0, y1, middle_y);
				double_step = t / 2;
				if (double_step > max_t) {
					result = FALSE;
					return result;
				}
				if (!iter (px, py, double_step, iter_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((gdouble) i) < steps)) {
					break;
				}
				t = (i / steps) + min_t;
				px = bird_font_path_quadratic_bezier_path (t, middle_x, x2, x3);
				py = bird_font_path_quadratic_bezier_path (t, middle_y, y2, y3);
				double_step = 0.5 + (t / 2);
				if (double_step > max_t) {
					result = FALSE;
					return result;
				}
				if (!iter (px, py, double_step, iter_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
bird_font_path_all_of_quadratic_curve (gdouble x0,
                                       gdouble y0,
                                       gdouble x1,
                                       gdouble y1,
                                       gdouble x2,
                                       gdouble y2,
                                       BirdFontPathRasterIterator iter,
                                       gpointer iter_target,
                                       gdouble steps,
                                       gdouble min_t,
                                       gdouble max_t)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble t = 0.0;
	gboolean result;
	px = x1;
	py = y1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gdouble) i) < steps)) {
					break;
				}
				t = (i / steps) + min_t;
				px = bird_font_path_quadratic_bezier_path (t, x0, x1, x2);
				py = bird_font_path_quadratic_bezier_path (t, y0, y1, y2);
				if (t > max_t) {
					result = FALSE;
					return result;
				}
				if (!iter (px, py, t, iter_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
bird_font_path_all_of_curve (gdouble x0,
                             gdouble y0,
                             gdouble x1,
                             gdouble y1,
                             gdouble x2,
                             gdouble y2,
                             gdouble x3,
                             gdouble y3,
                             BirdFontPathRasterIterator iter,
                             gpointer iter_target,
                             gdouble steps,
                             gdouble min_t,
                             gdouble max_t)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble t = 0.0;
	gboolean result;
	px = x1;
	py = y1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gdouble) i) < steps)) {
					break;
				}
				t = (i / steps) + min_t;
				px = bird_font_path_bezier_path (t, x0, x1, x2, x3);
				py = bird_font_path_bezier_path (t, y0, y1, y2, y3);
				if (t > max_t) {
					result = FALSE;
					return result;
				}
				if (!iter (px, py, t, iter_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

gboolean
bird_font_path_all_segments (BirdFontPath* self,
                             BirdFontPathSegmentIterator iter,
                             gpointer iter_target)
{
	BirdFontEditPoint* i = NULL;
	BirdFontEditPoint* next = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		result = FALSE;
		return result;
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp6_;
				GeeArrayList* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				gpointer _tmp12_;
				BirdFontEditPoint* _tmp13_;
				BirdFontEditPoint* _tmp14_;
				BirdFontEditPoint* _tmp15_;
				BirdFontEditPoint* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				BirdFontEditPoint* _tmp18_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = j;
					j = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = bird_font_path_get_points (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (!(j < (_tmp9_ - 1))) {
					break;
				}
				_tmp10_ = bird_font_path_get_points (self);
				_tmp11_ = _tmp10_;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, j);
				_tmp13_ = (BirdFontEditPoint*) _tmp12_;
				_tmp14_ = bird_font_edit_point_get_link_item (_tmp13_);
				i = _tmp14_;
				_g_object_unref0 (_tmp13_);
				_tmp15_ = i;
				_tmp16_ = bird_font_edit_point_get_next (_tmp15_);
				next = _tmp16_;
				_tmp17_ = i;
				_tmp18_ = next;
				if (!iter (_tmp17_, _tmp18_, iter_target)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	if (!bird_font_path_is_open (self)) {
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gpointer _tmp25_;
		BirdFontEditPoint* _tmp26_;
		GeeArrayList* _tmp27_;
		GeeArrayList* _tmp28_;
		gpointer _tmp29_;
		BirdFontEditPoint* _tmp30_;
		gboolean _tmp31_;
		_tmp19_ = bird_font_path_get_points (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = bird_font_path_get_points (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp24_ - 1);
		_tmp26_ = (BirdFontEditPoint*) _tmp25_;
		_tmp27_ = bird_font_path_get_points (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
		_tmp30_ = (BirdFontEditPoint*) _tmp29_;
		_tmp31_ = iter (_tmp26_, _tmp30_, iter_target);
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (_tmp26_);
		result = _tmp31_;
		return result;
	}
	result = TRUE;
	return result;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		BirdFontPath* self;
		self = _data48_->self;
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static gboolean
__lambda37_ (Block48Data* _data48_,
             BirdFontEditPoint* start,
             BirdFontEditPoint* stop)
{
	BirdFontPath* self;
	gboolean result;
	self = _data48_->self;
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (stop != NULL, FALSE);
	result = bird_font_path_all_of (start, stop, _data48_->iter, _data48_->iter_target, _data48_->steps, (gdouble) 0, (gdouble) 1);
	return result;
}

static gboolean
___lambda37__bird_font_path_segment_iterator (BirdFontEditPoint* start,
                                              BirdFontEditPoint* stop,
                                              gpointer self)
{
	gboolean result;
	result = __lambda37_ (self, start, stop);
	return result;
}

void
bird_font_path_all_of_path (BirdFontPath* self,
                            BirdFontPathRasterIterator iter,
                            gpointer iter_target,
                            gint steps)
{
	Block48Data* _data48_;
	g_return_if_fail (self != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_data48_->iter = iter;
	_data48_->iter_target = iter_target;
	_data48_->steps = steps;
	bird_font_path_all_segments (self, ___lambda37__bird_font_path_segment_iterator, _data48_);
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

gdouble
bird_font_path_bezier_path (gdouble step,
                            gdouble p0,
                            gdouble p1,
                            gdouble p2,
                            gdouble p3)
{
	gdouble q0 = 0.0;
	gdouble q1 = 0.0;
	gdouble q2 = 0.0;
	gdouble r0 = 0.0;
	gdouble r1 = 0.0;
	gdouble result;
	q0 = (step * (p1 - p0)) + p0;
	q1 = (step * (p2 - p1)) + p1;
	q2 = (step * (p3 - p2)) + p2;
	r0 = (step * (q1 - q0)) + q0;
	r1 = (step * (q2 - q1)) + q1;
	result = (step * (r1 - r0)) + r0;
	return result;
}

void
bird_font_path_bezier_vector (gdouble step,
                              gdouble p0,
                              gdouble p1,
                              gdouble p2,
                              gdouble p3,
                              gdouble* a0,
                              gdouble* a1)
{
	gdouble _vala_a0 = 0.0;
	gdouble _vala_a1 = 0.0;
	gdouble q0 = 0.0;
	gdouble q1 = 0.0;
	gdouble q2 = 0.0;
	q0 = (step * (p1 - p0)) + p0;
	q1 = (step * (p2 - p1)) + p1;
	q2 = (step * (p3 - p2)) + p2;
	_vala_a0 = (step * (q1 - q0)) + q0;
	_vala_a1 = (step * (q2 - q1)) + q1;
	if (a0) {
		*a0 = _vala_a0;
	}
	if (a1) {
		*a1 = _vala_a1;
	}
}

gdouble
bird_font_path_quadratic_bezier_vector (gdouble step,
                                        gdouble p0,
                                        gdouble p1,
                                        gdouble p2)
{
	gdouble result;
	result = (step * (p1 - p0)) + p0;
	return result;
}

gdouble
bird_font_path_quadratic_bezier_path (gdouble step,
                                      gdouble p0,
                                      gdouble p1,
                                      gdouble p2)
{
	gdouble q0 = 0.0;
	gdouble q1 = 0.0;
	gdouble result;
	q0 = (step * (p1 - p0)) + p0;
	q1 = (step * (p2 - p1)) + p1;
	result = (step * (q1 - q0)) + q0;
	return result;
}

gdouble
bird_font_path_double_bezier_path (gdouble step,
                                   gdouble p0,
                                   gdouble p1,
                                   gdouble p2,
                                   gdouble p3)
{
	gdouble middle = 0.0;
	gdouble result;
	middle = p1 + ((p2 - p1) / 2);
	if (step == 0.5) {
		g_warning ("Path.vala:1788: Middle");
	}
	if (step < 0.5) {
		result = bird_font_path_quadratic_bezier_path (2 * step, p0, p1, middle);
		return result;
	}
	result = bird_font_path_quadratic_bezier_path (2 * (step - 0.5), middle, p2, p3);
	return result;
}

void
bird_font_path_double_bezier_vector (gdouble step,
                                     gdouble p0,
                                     gdouble p1,
                                     gdouble p2,
                                     gdouble p3,
                                     gdouble* a0,
                                     gdouble* a1)
{
	gdouble _vala_a0 = 0.0;
	gdouble _vala_a1 = 0.0;
	gdouble b0 = 0.0;
	gdouble b1 = 0.0;
	gdouble c0 = 0.0;
	gdouble c1 = 0.0;
	gdouble d0 = 0.0;
	gdouble d1 = 0.0;
	gboolean _tmp0_ = FALSE;
	if (step <= ((gdouble) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = step >= ((gdouble) 1);
	}
	if (G_UNLIKELY (_tmp0_)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = double_to_string (step);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat ("Bad step: ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("Path.vala:1802: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		step = step + 0.00004;
	}
	b0 = bird_font_path_double_bezier_path (step + 0.00001, p0, p1, p2, p3);
	c0 = bird_font_path_double_bezier_path (step + 0.00002, p0, p1, p2, p3);
	b1 = bird_font_path_double_bezier_path (step - 0.00001, p0, p1, p2, p3);
	c1 = bird_font_path_double_bezier_path (step - 0.00002, p0, p1, p2, p3);
	d0 = b0 + (((b0 - c0) * 25000) * step);
	d1 = b1 + (((b1 - c1) * 25000) * (1 - step));
	_vala_a0 = d0;
	_vala_a1 = d1;
	if (a0) {
		*a0 = _vala_a0;
	}
	if (a1) {
		*a1 = _vala_a1;
	}
}

void
bird_font_path_get_handles_for_step (BirdFontEditPoint* start,
                                     BirdFontEditPoint* stop,
                                     gdouble step,
                                     gdouble* x1,
                                     gdouble* y1,
                                     gdouble* x2,
                                     gdouble* y2)
{
	gdouble _vala_x1 = 0.0;
	gdouble _vala_y1 = 0.0;
	gdouble _vala_x2 = 0.0;
	gdouble _vala_y2 = 0.0;
	BirdFontPointType right = 0;
	BirdFontPointType left = 0;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (start != NULL);
	g_return_if_fail (stop != NULL);
	right = bird_font_pen_tool_to_curve (start->type);
	left = bird_font_pen_tool_to_curve (stop->type);
	if (right == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = left == BIRD_FONT_POINT_TYPE_DOUBLE_CURVE;
	}
	if (_tmp0_) {
		BirdFontEditPointHandle* _tmp1_;
		gdouble _tmp2_;
		gdouble _tmp3_;
		BirdFontEditPointHandle* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_ = 0.0;
		gdouble _tmp8_ = 0.0;
		BirdFontEditPointHandle* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		BirdFontEditPointHandle* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp1_ = bird_font_edit_point_get_right_handle (start);
		_tmp2_ = bird_font_edit_point_handle_get_x (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = bird_font_edit_point_get_left_handle (stop);
		_tmp5_ = bird_font_edit_point_handle_get_x (_tmp4_);
		_tmp6_ = _tmp5_;
		bird_font_path_double_bezier_vector (step, start->x, _tmp3_, _tmp6_, stop->x, &_tmp7_, &_tmp8_);
		_vala_x1 = _tmp7_;
		_vala_x2 = _tmp8_;
		_tmp9_ = bird_font_edit_point_get_right_handle (start);
		_tmp10_ = bird_font_edit_point_handle_get_y (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_edit_point_get_left_handle (stop);
		_tmp13_ = bird_font_edit_point_handle_get_y (_tmp12_);
		_tmp14_ = _tmp13_;
		bird_font_path_double_bezier_vector (step, start->y, _tmp11_, _tmp14_, stop->y, &_tmp15_, &_tmp16_);
		_vala_y1 = _tmp15_;
		_vala_y2 = _tmp16_;
	} else {
		gboolean _tmp17_ = FALSE;
		if (right == BIRD_FONT_POINT_TYPE_QUADRATIC) {
			_tmp17_ = left == BIRD_FONT_POINT_TYPE_QUADRATIC;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			BirdFontEditPointHandle* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			BirdFontEditPointHandle* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			_tmp18_ = bird_font_edit_point_get_right_handle (start);
			_tmp19_ = bird_font_edit_point_handle_get_x (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_x1 = bird_font_path_quadratic_bezier_vector (step, start->x, _tmp20_, stop->x);
			_tmp21_ = bird_font_edit_point_get_right_handle (start);
			_tmp22_ = bird_font_edit_point_handle_get_y (_tmp21_);
			_tmp23_ = _tmp22_;
			_vala_y1 = bird_font_path_quadratic_bezier_vector (step, start->y, _tmp23_, stop->y);
			_vala_x2 = _vala_x1;
			_vala_y2 = _vala_y1;
		} else {
			gboolean _tmp24_ = FALSE;
			if (right == BIRD_FONT_POINT_TYPE_CUBIC) {
				_tmp24_ = left == BIRD_FONT_POINT_TYPE_CUBIC;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				BirdFontEditPointHandle* _tmp25_;
				gdouble _tmp26_;
				gdouble _tmp27_;
				BirdFontEditPointHandle* _tmp28_;
				gdouble _tmp29_;
				gdouble _tmp30_;
				gdouble _tmp31_ = 0.0;
				gdouble _tmp32_ = 0.0;
				BirdFontEditPointHandle* _tmp33_;
				gdouble _tmp34_;
				gdouble _tmp35_;
				BirdFontEditPointHandle* _tmp36_;
				gdouble _tmp37_;
				gdouble _tmp38_;
				gdouble _tmp39_ = 0.0;
				gdouble _tmp40_ = 0.0;
				_tmp25_ = bird_font_edit_point_get_right_handle (start);
				_tmp26_ = bird_font_edit_point_handle_get_x (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = bird_font_edit_point_get_left_handle (stop);
				_tmp29_ = bird_font_edit_point_handle_get_x (_tmp28_);
				_tmp30_ = _tmp29_;
				bird_font_path_bezier_vector (step, start->x, _tmp27_, _tmp30_, stop->x, &_tmp31_, &_tmp32_);
				_vala_x1 = _tmp31_;
				_vala_x2 = _tmp32_;
				_tmp33_ = bird_font_edit_point_get_right_handle (start);
				_tmp34_ = bird_font_edit_point_handle_get_y (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = bird_font_edit_point_get_left_handle (stop);
				_tmp37_ = bird_font_edit_point_handle_get_y (_tmp36_);
				_tmp38_ = _tmp37_;
				bird_font_path_bezier_vector (step, start->y, _tmp35_, _tmp38_, stop->y, &_tmp39_, &_tmp40_);
				_vala_y1 = _tmp39_;
				_vala_y2 = _tmp40_;
			} else {
				gboolean _tmp41_ = FALSE;
				if (right == BIRD_FONT_POINT_TYPE_HIDDEN) {
					_tmp41_ = left == BIRD_FONT_POINT_TYPE_HIDDEN;
				} else {
					_tmp41_ = FALSE;
				}
				if (_tmp41_) {
					BirdFontEditPointHandle* _tmp42_;
					gdouble _tmp43_;
					gdouble _tmp44_;
					BirdFontEditPointHandle* _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					gdouble _tmp48_ = 0.0;
					gdouble _tmp49_ = 0.0;
					BirdFontEditPointHandle* _tmp50_;
					gdouble _tmp51_;
					gdouble _tmp52_;
					BirdFontEditPointHandle* _tmp53_;
					gdouble _tmp54_;
					gdouble _tmp55_;
					gdouble _tmp56_ = 0.0;
					gdouble _tmp57_ = 0.0;
					_tmp42_ = bird_font_edit_point_get_right_handle (start);
					_tmp43_ = bird_font_edit_point_handle_get_x (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = bird_font_edit_point_get_left_handle (stop);
					_tmp46_ = bird_font_edit_point_handle_get_x (_tmp45_);
					_tmp47_ = _tmp46_;
					bird_font_path_bezier_vector (step, start->x, _tmp44_, _tmp47_, stop->x, &_tmp48_, &_tmp49_);
					_vala_x1 = _tmp48_;
					_vala_x2 = _tmp49_;
					_tmp50_ = bird_font_edit_point_get_right_handle (start);
					_tmp51_ = bird_font_edit_point_handle_get_y (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = bird_font_edit_point_get_left_handle (stop);
					_tmp54_ = bird_font_edit_point_handle_get_y (_tmp53_);
					_tmp55_ = _tmp54_;
					bird_font_path_bezier_vector (step, start->y, _tmp52_, _tmp55_, stop->y, &_tmp56_, &_tmp57_);
					_vala_y1 = _tmp56_;
					_vala_y2 = _tmp57_;
				} else {
					BirdFontEditPointHandle* _tmp58_;
					gdouble _tmp59_;
					gdouble _tmp60_;
					BirdFontEditPointHandle* _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_ = 0.0;
					gdouble _tmp65_ = 0.0;
					BirdFontEditPointHandle* _tmp66_;
					gdouble _tmp67_;
					gdouble _tmp68_;
					BirdFontEditPointHandle* _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					gdouble _tmp72_ = 0.0;
					gdouble _tmp73_ = 0.0;
					_tmp58_ = bird_font_edit_point_get_right_handle (start);
					_tmp59_ = bird_font_edit_point_handle_get_x (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = bird_font_edit_point_get_left_handle (stop);
					_tmp62_ = bird_font_edit_point_handle_get_x (_tmp61_);
					_tmp63_ = _tmp62_;
					bird_font_path_bezier_vector (step, start->x, _tmp60_, _tmp63_, stop->x, &_tmp64_, &_tmp65_);
					_vala_x1 = _tmp64_;
					_vala_x2 = _tmp65_;
					_tmp66_ = bird_font_edit_point_get_right_handle (start);
					_tmp67_ = bird_font_edit_point_handle_get_y (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = bird_font_edit_point_get_left_handle (stop);
					_tmp70_ = bird_font_edit_point_handle_get_y (_tmp69_);
					_tmp71_ = _tmp70_;
					bird_font_path_bezier_vector (step, start->y, _tmp68_, _tmp71_, stop->y, &_tmp72_, &_tmp73_);
					_vala_y1 = _tmp72_;
					_vala_y2 = _tmp73_;
				}
			}
		}
	}
	if (x1) {
		*x1 = _vala_x1;
	}
	if (y1) {
		*y1 = _vala_y1;
	}
	if (x2) {
		*x2 = _vala_x2;
	}
	if (y2) {
		*y2 = _vala_y2;
	}
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		BirdFontPath* self;
		self = _data49_->self;
		_cairo_destroy0 (_data49_->cr);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gboolean
__lambda374_ (Block49Data* _data49_,
              gdouble x,
              gdouble y)
{
	BirdFontPath* self;
	gboolean result;
	self = _data49_->self;
	cairo_move_to (_data49_->cr, _data49_->px + _data49_->xc, (-_data49_->py) + _data49_->yc);
	cairo_line_to (_data49_->cr, x + _data49_->xc, (-y) + _data49_->yc);
	_data49_->px = x;
	_data49_->py = y;
	result = TRUE;
	return result;
}

static gboolean
___lambda374__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = __lambda374_ (self, x, y);
	return result;
}

void
bird_font_path_plot (BirdFontPath* self,
                     cairo_t* cr,
                     BirdFontWidgetAllocation* allocation,
                     gdouble view_zoom)
{
	Block49Data* _data49_;
	cairo_t* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (allocation != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = _cairo_reference0 (cr);
	_cairo_destroy0 (_data49_->cr);
	_data49_->cr = _tmp0_;
	_data49_->px = (gdouble) 0;
	_data49_->py = (gdouble) 0;
	_data49_->xc = allocation->width / 2.0;
	_data49_->yc = allocation->height / 2.0;
	cairo_save (_data49_->cr);
	bird_font_path_all_of_path (self, ___lambda374__bird_font_path_raster_iterator, _data49_, -1);
	cairo_stroke (_data49_->cr);
	cairo_restore (_data49_->cr);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

void
bird_font_path_print_boundaries (BirdFontPath* self)
{
	FILE* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	FILE* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	FILE* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	FILE* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stderr;
	_tmp1_ = double_to_string (self->xmax);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("xmax ", _tmp2_, " \n", NULL);
	_tmp4_ = _tmp3_;
	fprintf (_tmp0_, "%s", _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = stderr;
	_tmp6_ = double_to_string (self->xmin);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("xmin ", _tmp7_, " \n", NULL);
	_tmp9_ = _tmp8_;
	fprintf (_tmp5_, "%s", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp10_ = stderr;
	_tmp11_ = double_to_string (self->ymax);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat ("ymax ", _tmp12_, " \n", NULL);
	_tmp14_ = _tmp13_;
	fprintf (_tmp10_, "%s", _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp15_ = stderr;
	_tmp16_ = double_to_string (self->ymin);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat ("ymin ", _tmp17_, " \n", NULL);
	_tmp19_ = _tmp18_;
	fprintf (_tmp15_, "%s", _tmp19_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
}

gboolean
bird_font_path_has_region_boundaries (BirdFontPath* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->xmax == ((gdouble) -10000)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->xmin == ((gdouble) 10000);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->ymax == ((gdouble) -10000);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->ymin == ((gdouble) 10000);
	}
	result = !_tmp0_;
	return result;
}

void
bird_font_path_create_list (BirdFontPath* self)
{
	BirdFontEditPoint* ep = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gpointer _tmp15_;
	BirdFontEditPoint* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gpointer _tmp19_;
	BirdFontEditPoint* _tmp20_;
	BirdFontEditPoint* _tmp21_;
	BirdFontEditPoint* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gpointer _tmp29_;
	BirdFontEditPoint* _tmp30_;
	BirdFontEditPoint* _tmp31_;
	GeeArrayList* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	GeeArrayList* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gpointer _tmp59_;
	BirdFontEditPoint* _tmp60_;
	GeeArrayList* _tmp61_;
	GeeArrayList* _tmp62_;
	gpointer _tmp63_;
	BirdFontEditPoint* _tmp64_;
	BirdFontEditPoint* _tmp65_;
	BirdFontEditPoint* _tmp66_;
	GeeArrayList* _tmp67_;
	GeeArrayList* _tmp68_;
	GeeArrayList* _tmp69_;
	GeeArrayList* _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gpointer _tmp73_;
	BirdFontEditPoint* _tmp74_;
	BirdFontEditPoint* _tmp75_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_g_object_unref0 (ep);
		return;
	}
	_tmp4_ = bird_font_path_get_points (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 1) {
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		gpointer _tmp10_;
		BirdFontEditPoint* _tmp11_;
		BirdFontEditPoint* _tmp12_;
		_tmp8_ = bird_font_path_get_points (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
		_g_object_unref0 (ep);
		ep = (BirdFontEditPoint*) _tmp10_;
		_tmp11_ = ep;
		_tmp11_->next = NULL;
		_tmp12_ = ep;
		_tmp12_->prev = NULL;
		_g_object_unref0 (ep);
		return;
	}
	_tmp13_ = bird_font_path_get_points (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
	_g_object_unref0 (ep);
	ep = (BirdFontEditPoint*) _tmp15_;
	_tmp16_ = ep;
	_tmp17_ = bird_font_path_get_points (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, 1);
	_tmp20_ = (BirdFontEditPoint*) _tmp19_;
	_tmp21_ = bird_font_edit_point_get_link_item (_tmp20_);
	_tmp16_->next = _tmp21_;
	_g_object_unref0 (_tmp20_);
	_tmp22_ = ep;
	_tmp23_ = bird_font_path_get_points (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = bird_font_path_get_points (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp28_ - 1);
	_tmp30_ = (BirdFontEditPoint*) _tmp29_;
	_tmp31_ = bird_font_edit_point_get_link_item (_tmp30_);
	_tmp22_->prev = _tmp31_;
	_g_object_unref0 (_tmp30_);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp34_;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				GeeArrayList* _tmp38_;
				GeeArrayList* _tmp39_;
				gpointer _tmp40_;
				BirdFontEditPoint* _tmp41_;
				GeeArrayList* _tmp42_;
				GeeArrayList* _tmp43_;
				gpointer _tmp44_;
				BirdFontEditPoint* _tmp45_;
				BirdFontEditPoint* _tmp46_;
				BirdFontEditPoint* _tmp47_;
				GeeArrayList* _tmp48_;
				GeeArrayList* _tmp49_;
				gpointer _tmp50_;
				BirdFontEditPoint* _tmp51_;
				BirdFontEditPoint* _tmp52_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = bird_font_path_get_points (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (!(i < (_tmp37_ - 1))) {
					break;
				}
				_tmp38_ = bird_font_path_get_points (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp40_;
				_tmp41_ = ep;
				_tmp42_ = bird_font_path_get_points (self);
				_tmp43_ = _tmp42_;
				_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, i - 1);
				_tmp45_ = (BirdFontEditPoint*) _tmp44_;
				_tmp46_ = bird_font_edit_point_get_link_item (_tmp45_);
				_tmp41_->prev = _tmp46_;
				_g_object_unref0 (_tmp45_);
				_tmp47_ = ep;
				_tmp48_ = bird_font_path_get_points (self);
				_tmp49_ = _tmp48_;
				_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, i + 1);
				_tmp51_ = (BirdFontEditPoint*) _tmp50_;
				_tmp52_ = bird_font_edit_point_get_link_item (_tmp51_);
				_tmp47_->next = _tmp52_;
				_g_object_unref0 (_tmp51_);
			}
		}
	}
	_tmp53_ = bird_font_path_get_points (self);
	_tmp54_ = _tmp53_;
	_tmp55_ = bird_font_path_get_points (self);
	_tmp56_ = _tmp55_;
	_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _tmp58_ - 1);
	_g_object_unref0 (ep);
	ep = (BirdFontEditPoint*) _tmp59_;
	_tmp60_ = ep;
	_tmp61_ = bird_font_path_get_points (self);
	_tmp62_ = _tmp61_;
	_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, 0);
	_tmp64_ = (BirdFontEditPoint*) _tmp63_;
	_tmp65_ = bird_font_edit_point_get_link_item (_tmp64_);
	_tmp60_->next = _tmp65_;
	_g_object_unref0 (_tmp64_);
	_tmp66_ = ep;
	_tmp67_ = bird_font_path_get_points (self);
	_tmp68_ = _tmp67_;
	_tmp69_ = bird_font_path_get_points (self);
	_tmp70_ = _tmp69_;
	_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _tmp72_ - 2);
	_tmp74_ = (BirdFontEditPoint*) _tmp73_;
	_tmp75_ = bird_font_edit_point_get_link_item (_tmp74_);
	_tmp66_->prev = _tmp75_;
	_g_object_unref0 (_tmp74_);
	_g_object_unref0 (ep);
}

gboolean
bird_font_path_has_point (BirdFontPath* self,
                          BirdFontEditPoint* ep)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ep != NULL, FALSE);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, ep);
	return result;
}

gboolean
bird_font_path_has_deleted_point (BirdFontPath* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _p_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _p_index);
			p = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = p;
			_tmp10_ = bird_font_edit_point_get_deleted (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				result = TRUE;
				_g_object_unref0 (p);
				return result;
			}
			_g_object_unref0 (p);
		}
	}
	result = FALSE;
	return result;
}

/** @return the remaining parts as a new path. */
BirdFontPathList*
bird_font_path_process_deleted_points (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* p = NULL;
	BirdFontEditPoint* ep = NULL;
	BirdFontPath* current_path = NULL;
	BirdFontPath* _tmp4_;
	BirdFontPath* remaining_points = NULL;
	BirdFontPath* _tmp5_;
	BirdFontPathList* path_list = NULL;
	BirdFontPathList* _tmp6_;
	gint i = 0;
	gint index = 0;
	BirdFontPath* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	BirdFontPath* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeArrayList* _tmp36_;
	GeeArrayList* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	GeeArrayList* _tmp46_;
	GeeArrayList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_return_val_if_fail (_tmp3_ > 0, "points.size > 0", NULL);
	_tmp4_ = bird_font_path_new ();
	current_path = _tmp4_;
	_tmp5_ = bird_font_path_new ();
	remaining_points = _tmp5_;
	_tmp6_ = bird_font_path_list_new ();
	path_list = _tmp6_;
	index = 0;
	_tmp7_ = remaining_points;
	_tmp8_ = bird_font_path_get_stroke (self);
	_tmp9_ = _tmp8_;
	bird_font_path_set_stroke (_tmp7_, _tmp9_);
	_tmp10_ = current_path;
	_tmp11_ = bird_font_path_get_stroke (self);
	_tmp12_ = _tmp11_;
	bird_font_path_set_stroke (_tmp10_, _tmp12_);
	if (!bird_font_path_has_deleted_point (self)) {
		result = path_list;
		_g_object_unref0 (remaining_points);
		_g_object_unref0 (current_path);
		_g_object_unref0 (ep);
		_g_object_unref0 (p);
		return result;
	}
	_tmp13_ = bird_font_path_get_points (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == 1) {
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		gpointer _tmp19_;
		BirdFontEditPoint* _tmp20_;
		_tmp17_ = bird_font_path_get_points (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp18_, 0);
		_tmp20_ = (BirdFontEditPoint*) _tmp19_;
		_g_object_unref0 (_tmp20_);
		result = path_list;
		_g_object_unref0 (remaining_points);
		_g_object_unref0 (current_path);
		_g_object_unref0 (ep);
		_g_object_unref0 (p);
		return result;
	}
	{
		gboolean _tmp21_ = FALSE;
		i = 0;
		_tmp21_ = TRUE;
		while (TRUE) {
			GeeArrayList* _tmp23_;
			GeeArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* _tmp28_;
			gpointer _tmp29_;
			BirdFontEditPoint* _tmp30_;
			gboolean _tmp31_;
			gboolean _tmp32_;
			if (!_tmp21_) {
				gint _tmp22_;
				_tmp22_ = i;
				i = _tmp22_ + 1;
			}
			_tmp21_ = FALSE;
			_tmp23_ = bird_font_path_get_points (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			if (!(i < _tmp26_)) {
				break;
			}
			_tmp27_ = bird_font_path_get_points (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, i);
			_g_object_unref0 (p);
			p = (BirdFontEditPoint*) _tmp29_;
			_tmp30_ = p;
			_tmp31_ = bird_font_edit_point_get_deleted (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_) {
				gint _tmp33_;
				BirdFontEditPoint* _tmp34_;
				BirdFontEditPoint* _tmp35_;
				index = i;
				_tmp33_ = i;
				i = _tmp33_ + 1;
				_tmp34_ = p;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_g_object_unref0 (ep);
				ep = _tmp35_;
				break;
			}
		}
	}
	_tmp36_ = bird_font_path_get_points (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ > 1) {
		GeeArrayList* _tmp40_;
		GeeArrayList* _tmp41_;
		gpointer _tmp42_;
		BirdFontEditPoint* _tmp43_;
		BirdFontEditPoint* _tmp44_;
		BirdFontEditPoint* _tmp45_;
		_tmp40_ = bird_font_path_get_points (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 1);
		_g_object_unref0 (p);
		p = (BirdFontEditPoint*) _tmp42_;
		_tmp43_ = p;
		bird_font_edit_point_convert_to_curve (_tmp43_);
		_tmp44_ = p;
		bird_font_edit_point_set_reflective_handles (_tmp44_, FALSE);
		_tmp45_ = p;
		bird_font_edit_point_set_tie_handle (_tmp45_, FALSE);
	}
	_tmp46_ = bird_font_path_get_points (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	if (_tmp49_ > 0) {
		GeeArrayList* _tmp50_;
		GeeArrayList* _tmp51_;
		GeeArrayList* _tmp52_;
		GeeArrayList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gpointer _tmp56_;
		BirdFontEditPoint* _tmp57_;
		BirdFontEditPoint* _tmp58_;
		BirdFontEditPoint* _tmp59_;
		_tmp50_ = bird_font_path_get_points (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = bird_font_path_get_points (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, _tmp55_ - 1);
		_g_object_unref0 (p);
		p = (BirdFontEditPoint*) _tmp56_;
		_tmp57_ = p;
		bird_font_edit_point_convert_to_curve (_tmp57_);
		_tmp58_ = p;
		bird_font_edit_point_set_reflective_handles (_tmp58_, FALSE);
		_tmp59_ = p;
		bird_font_edit_point_set_tie_handle (_tmp59_, FALSE);
	}
	while (TRUE) {
		GeeArrayList* _tmp60_;
		GeeArrayList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		GeeArrayList* _tmp64_;
		GeeArrayList* _tmp65_;
		gpointer _tmp66_;
		BirdFontPath* _tmp67_;
		BirdFontEditPoint* _tmp68_;
		BirdFontEditPoint* _tmp69_;
		BirdFontEditPoint* _tmp70_;
		gint _tmp71_;
		_tmp60_ = bird_font_path_get_points (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		if (!(i < _tmp63_)) {
			break;
		}
		_tmp64_ = bird_font_path_get_points (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, i);
		_g_object_unref0 (p);
		p = (BirdFontEditPoint*) _tmp66_;
		_tmp67_ = current_path;
		_tmp68_ = p;
		_tmp69_ = bird_font_path_add_point (_tmp67_, _tmp68_);
		_tmp70_ = _tmp69_;
		_g_object_unref0 (_tmp70_);
		_tmp71_ = i;
		i = _tmp71_ + 1;
	}
	{
		gboolean _tmp72_ = FALSE;
		i = 0;
		_tmp72_ = TRUE;
		while (TRUE) {
			GeeArrayList* _tmp74_;
			GeeArrayList* _tmp75_;
			gpointer _tmp76_;
			BirdFontPath* _tmp77_;
			BirdFontEditPoint* _tmp78_;
			BirdFontEditPoint* _tmp79_;
			BirdFontEditPoint* _tmp80_;
			if (!_tmp72_) {
				gint _tmp73_;
				_tmp73_ = i;
				i = _tmp73_ + 1;
			}
			_tmp72_ = FALSE;
			if (!(i < index)) {
				break;
			}
			_tmp74_ = bird_font_path_get_points (self);
			_tmp75_ = _tmp74_;
			_tmp76_ = gee_abstract_list_get ((GeeAbstractList*) _tmp75_, i);
			_g_object_unref0 (p);
			p = (BirdFontEditPoint*) _tmp76_;
			_tmp77_ = remaining_points;
			_tmp78_ = p;
			_tmp79_ = bird_font_path_add_point (_tmp77_, _tmp78_);
			_tmp80_ = _tmp79_;
			_g_object_unref0 (_tmp80_);
		}
	}
	if (!bird_font_path_is_open (self)) {
		BirdFontPath* _tmp97_;
		GeeArrayList* _tmp98_;
		GeeArrayList* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		{
			GeeArrayList* _point_list = NULL;
			BirdFontPath* _tmp81_;
			GeeArrayList* _tmp82_;
			GeeArrayList* _tmp83_;
			gint _point_size = 0;
			GeeArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _point_index = 0;
			_tmp81_ = remaining_points;
			_tmp82_ = bird_font_path_get_points (_tmp81_);
			_tmp83_ = _tmp82_;
			_point_list = _tmp83_;
			_tmp84_ = _point_list;
			_tmp85_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_point_size = _tmp86_;
			_point_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				BirdFontEditPoint* point = NULL;
				GeeArrayList* _tmp89_;
				gpointer _tmp90_;
				BirdFontPath* _tmp91_;
				BirdFontEditPoint* _tmp92_;
				BirdFontEditPoint* _tmp93_;
				BirdFontEditPoint* _tmp94_;
				BirdFontEditPoint* _tmp95_;
				BirdFontEditPoint* _tmp96_;
				_point_index = _point_index + 1;
				_tmp87_ = _point_index;
				_tmp88_ = _point_size;
				if (!(_tmp87_ < _tmp88_)) {
					break;
				}
				_tmp89_ = _point_list;
				_tmp90_ = gee_abstract_list_get ((GeeAbstractList*) _tmp89_, _point_index);
				point = (BirdFontEditPoint*) _tmp90_;
				_tmp91_ = current_path;
				_tmp92_ = point;
				_tmp93_ = bird_font_edit_point_copy (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = bird_font_path_add_point (_tmp91_, _tmp94_);
				_tmp96_ = _tmp95_;
				_g_object_unref0 (_tmp96_);
				_g_object_unref0 (_tmp94_);
				_g_object_unref0 (point);
			}
		}
		_tmp97_ = current_path;
		_tmp98_ = bird_font_path_get_points (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp99_);
		_tmp101_ = _tmp100_;
		if (_tmp101_ > 0) {
			BirdFontPath* _tmp102_;
			GeeArrayList* _tmp103_;
			GeeArrayList* _tmp104_;
			gpointer _tmp105_;
			BirdFontEditPoint* _tmp106_;
			BirdFontEditPoint* _tmp107_;
			BirdFontEditPoint* _tmp108_;
			BirdFontEditPointHandle* _tmp109_;
			BirdFontEditPoint* _tmp110_;
			BirdFontEditPoint* _tmp111_;
			BirdFontEditPoint* _tmp112_;
			BirdFontPathList* _tmp113_;
			BirdFontPath* _tmp114_;
			BirdFontPath* _tmp115_;
			GeeArrayList* _tmp116_;
			GeeArrayList* _tmp117_;
			BirdFontPath* _tmp118_;
			GeeArrayList* _tmp119_;
			GeeArrayList* _tmp120_;
			gint _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			BirdFontEditPoint* _tmp124_;
			BirdFontEditPointHandle* _tmp125_;
			BirdFontEditPoint* _tmp126_;
			BirdFontEditPoint* _tmp127_;
			BirdFontEditPoint* _tmp128_;
			BirdFontEditPointHandle* _tmp129_;
			_tmp102_ = current_path;
			_tmp103_ = bird_font_path_get_points (_tmp102_);
			_tmp104_ = _tmp103_;
			_tmp105_ = gee_abstract_list_get ((GeeAbstractList*) _tmp104_, 0);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp105_;
			_tmp106_ = ep;
			bird_font_edit_point_set_tie_handle (_tmp106_, FALSE);
			_tmp107_ = ep;
			bird_font_edit_point_set_reflective_handles (_tmp107_, FALSE);
			_tmp108_ = ep;
			_tmp109_ = bird_font_edit_point_get_left_handle (_tmp108_);
			_tmp110_ = ep;
			_tmp109_->type = bird_font_pen_tool_to_line (_tmp110_->type);
			_tmp111_ = ep;
			_tmp112_ = ep;
			_tmp111_->type = bird_font_pen_tool_to_curve (_tmp112_->type);
			_tmp113_ = path_list;
			_tmp114_ = current_path;
			bird_font_path_list_add (_tmp113_, _tmp114_);
			_tmp115_ = current_path;
			_tmp116_ = bird_font_path_get_points (_tmp115_);
			_tmp117_ = _tmp116_;
			_tmp118_ = current_path;
			_tmp119_ = bird_font_path_get_points (_tmp118_);
			_tmp120_ = _tmp119_;
			_tmp121_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = gee_abstract_list_get ((GeeAbstractList*) _tmp117_, _tmp122_ - 1);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp123_;
			_tmp124_ = ep;
			_tmp125_ = bird_font_edit_point_get_right_handle (_tmp124_);
			_tmp126_ = ep;
			_tmp125_->type = bird_font_pen_tool_to_line (_tmp126_->type);
			_tmp127_ = ep;
			_tmp128_ = ep;
			_tmp129_ = bird_font_edit_point_get_right_handle (_tmp128_);
			_tmp127_->type = bird_font_pen_tool_to_curve (_tmp129_->type);
		}
	} else {
		BirdFontPath* _tmp130_;
		GeeArrayList* _tmp131_;
		GeeArrayList* _tmp132_;
		gint _tmp133_;
		gint _tmp134_;
		BirdFontPath* _tmp168_;
		GeeArrayList* _tmp169_;
		GeeArrayList* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		_tmp130_ = current_path;
		_tmp131_ = bird_font_path_get_points (_tmp130_);
		_tmp132_ = _tmp131_;
		_tmp133_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp132_);
		_tmp134_ = _tmp133_;
		if (_tmp134_ > 0) {
			BirdFontPath* _tmp135_;
			GeeArrayList* _tmp136_;
			GeeArrayList* _tmp137_;
			gpointer _tmp138_;
			BirdFontEditPoint* _tmp139_;
			BirdFontEditPoint* _tmp140_;
			BirdFontEditPoint* _tmp141_;
			BirdFontEditPointHandle* _tmp142_;
			BirdFontEditPoint* _tmp143_;
			BirdFontEditPoint* _tmp144_;
			BirdFontEditPoint* _tmp145_;
			BirdFontPath* _tmp146_;
			GeeArrayList* _tmp147_;
			GeeArrayList* _tmp148_;
			gpointer _tmp149_;
			BirdFontEditPoint* _tmp150_;
			BirdFontPathList* _tmp151_;
			BirdFontPath* _tmp152_;
			BirdFontPath* _tmp153_;
			GeeArrayList* _tmp154_;
			GeeArrayList* _tmp155_;
			BirdFontPath* _tmp156_;
			GeeArrayList* _tmp157_;
			GeeArrayList* _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			gpointer _tmp161_;
			BirdFontEditPoint* _tmp162_;
			BirdFontEditPointHandle* _tmp163_;
			BirdFontEditPoint* _tmp164_;
			BirdFontEditPoint* _tmp165_;
			BirdFontEditPoint* _tmp166_;
			BirdFontEditPointHandle* _tmp167_;
			_tmp135_ = current_path;
			_tmp136_ = bird_font_path_get_points (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, 0);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp138_;
			_tmp139_ = ep;
			bird_font_edit_point_set_tie_handle (_tmp139_, FALSE);
			_tmp140_ = ep;
			bird_font_edit_point_set_reflective_handles (_tmp140_, FALSE);
			_tmp141_ = ep;
			_tmp142_ = bird_font_edit_point_get_left_handle (_tmp141_);
			_tmp143_ = ep;
			_tmp142_->type = bird_font_pen_tool_to_line (_tmp143_->type);
			_tmp144_ = ep;
			_tmp145_ = ep;
			_tmp144_->type = bird_font_pen_tool_to_curve (_tmp145_->type);
			_tmp146_ = current_path;
			_tmp147_ = bird_font_path_get_points (_tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = gee_abstract_list_get ((GeeAbstractList*) _tmp148_, 0);
			_tmp150_ = (BirdFontEditPoint*) _tmp149_;
			bird_font_path_set_new_start (self, _tmp150_);
			_g_object_unref0 (_tmp150_);
			_tmp151_ = path_list;
			_tmp152_ = current_path;
			bird_font_path_list_add (_tmp151_, _tmp152_);
			_tmp153_ = current_path;
			_tmp154_ = bird_font_path_get_points (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = current_path;
			_tmp157_ = bird_font_path_get_points (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp159_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp158_);
			_tmp160_ = _tmp159_;
			_tmp161_ = gee_abstract_list_get ((GeeAbstractList*) _tmp155_, _tmp160_ - 1);
			_g_object_unref0 (ep);
			ep = (BirdFontEditPoint*) _tmp161_;
			_tmp162_ = ep;
			_tmp163_ = bird_font_edit_point_get_right_handle (_tmp162_);
			_tmp164_ = ep;
			_tmp163_->type = bird_font_pen_tool_to_line (_tmp164_->type);
			_tmp165_ = ep;
			_tmp166_ = ep;
			_tmp167_ = bird_font_edit_point_get_right_handle (_tmp166_);
			_tmp165_->type = bird_font_pen_tool_to_curve (_tmp167_->type);
		}
		_tmp168_ = remaining_points;
		_tmp169_ = bird_font_path_get_points (_tmp168_);
		_tmp170_ = _tmp169_;
		_tmp171_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp170_);
		_tmp172_ = _tmp171_;
		if (_tmp172_ > 0) {
			BirdFontPath* _tmp173_;
			GeeArrayList* _tmp174_;
			GeeArrayList* _tmp175_;
			gpointer _tmp176_;
			BirdFontEditPoint* _tmp177_;
			BirdFontPath* _tmp178_;
			GeeArrayList* _tmp179_;
			GeeArrayList* _tmp180_;
			gpointer _tmp181_;
			BirdFontEditPoint* _tmp182_;
			BirdFontPath* _tmp183_;
			GeeArrayList* _tmp184_;
			GeeArrayList* _tmp185_;
			gpointer _tmp186_;
			BirdFontEditPoint* _tmp187_;
			BirdFontPath* _tmp188_;
			GeeArrayList* _tmp189_;
			GeeArrayList* _tmp190_;
			gpointer _tmp191_;
			BirdFontEditPoint* _tmp192_;
			BirdFontPath* _tmp193_;
			GeeArrayList* _tmp194_;
			GeeArrayList* _tmp195_;
			gpointer _tmp196_;
			BirdFontEditPoint* _tmp197_;
			BirdFontPathList* _tmp198_;
			BirdFontPath* _tmp199_;
			BirdFontPath* _tmp200_;
			GeeArrayList* _tmp201_;
			GeeArrayList* _tmp202_;
			gint _tmp203_;
			gint _tmp204_;
			_tmp173_ = remaining_points;
			_tmp174_ = bird_font_path_get_points (_tmp173_);
			_tmp175_ = _tmp174_;
			_tmp176_ = gee_abstract_list_get ((GeeAbstractList*) _tmp175_, 0);
			_tmp177_ = (BirdFontEditPoint*) _tmp176_;
			bird_font_edit_point_set_tie_handle (_tmp177_, FALSE);
			_g_object_unref0 (_tmp177_);
			_tmp178_ = remaining_points;
			_tmp179_ = bird_font_path_get_points (_tmp178_);
			_tmp180_ = _tmp179_;
			_tmp181_ = gee_abstract_list_get ((GeeAbstractList*) _tmp180_, 0);
			_tmp182_ = (BirdFontEditPoint*) _tmp181_;
			bird_font_edit_point_set_reflective_handles (_tmp182_, FALSE);
			_g_object_unref0 (_tmp182_);
			_tmp183_ = remaining_points;
			_tmp184_ = bird_font_path_get_points (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_ = gee_abstract_list_get ((GeeAbstractList*) _tmp185_, 0);
			_tmp187_ = (BirdFontEditPoint*) _tmp186_;
			_tmp188_ = remaining_points;
			_tmp189_ = bird_font_path_get_points (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = gee_abstract_list_get ((GeeAbstractList*) _tmp190_, 0);
			_tmp192_ = (BirdFontEditPoint*) _tmp191_;
			_tmp187_->type = _tmp192_->type;
			_g_object_unref0 (_tmp192_);
			_g_object_unref0 (_tmp187_);
			_tmp193_ = remaining_points;
			_tmp194_ = bird_font_path_get_points (_tmp193_);
			_tmp195_ = _tmp194_;
			_tmp196_ = gee_abstract_list_get ((GeeAbstractList*) _tmp195_, 0);
			_tmp197_ = (BirdFontEditPoint*) _tmp196_;
			bird_font_path_set_new_start (self, _tmp197_);
			_g_object_unref0 (_tmp197_);
			_tmp198_ = path_list;
			_tmp199_ = remaining_points;
			bird_font_path_list_add (_tmp198_, _tmp199_);
			_tmp200_ = current_path;
			_tmp201_ = bird_font_path_get_points (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp202_);
			_tmp204_ = _tmp203_;
			if (_tmp204_ > 0) {
				BirdFontPath* _tmp205_;
				GeeArrayList* _tmp206_;
				GeeArrayList* _tmp207_;
				BirdFontPath* _tmp208_;
				GeeArrayList* _tmp209_;
				GeeArrayList* _tmp210_;
				gint _tmp211_;
				gint _tmp212_;
				gpointer _tmp213_;
				BirdFontEditPoint* _tmp214_;
				BirdFontEditPointHandle* _tmp215_;
				BirdFontEditPoint* _tmp216_;
				BirdFontEditPoint* _tmp217_;
				BirdFontEditPoint* _tmp218_;
				BirdFontEditPointHandle* _tmp219_;
				_tmp205_ = current_path;
				_tmp206_ = bird_font_path_get_points (_tmp205_);
				_tmp207_ = _tmp206_;
				_tmp208_ = current_path;
				_tmp209_ = bird_font_path_get_points (_tmp208_);
				_tmp210_ = _tmp209_;
				_tmp211_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = gee_abstract_list_get ((GeeAbstractList*) _tmp207_, _tmp212_ - 1);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp213_;
				_tmp214_ = ep;
				_tmp215_ = bird_font_edit_point_get_right_handle (_tmp214_);
				_tmp216_ = ep;
				_tmp215_->type = bird_font_pen_tool_to_line (_tmp216_->type);
				_tmp217_ = ep;
				_tmp218_ = ep;
				_tmp219_ = bird_font_edit_point_get_right_handle (_tmp218_);
				_tmp217_->type = bird_font_pen_tool_to_curve (_tmp219_->type);
			}
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		BirdFontPathList* _tmp220_;
		GeeArrayList* _tmp221_;
		gint _path_size = 0;
		GeeArrayList* _tmp222_;
		gint _tmp223_;
		gint _tmp224_;
		gint _path_index = 0;
		_tmp220_ = path_list;
		_tmp221_ = _tmp220_->paths;
		_path_list = _tmp221_;
		_tmp222_ = _path_list;
		_tmp223_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp222_);
		_tmp224_ = _tmp223_;
		_path_size = _tmp224_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp225_;
			gint _tmp226_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp227_;
			gpointer _tmp228_;
			BirdFontPath* _tmp229_;
			_path_index = _path_index + 1;
			_tmp225_ = _path_index;
			_tmp226_ = _path_size;
			if (!(_tmp225_ < _tmp226_)) {
				break;
			}
			_tmp227_ = _path_list;
			_tmp228_ = gee_abstract_list_get ((GeeAbstractList*) _tmp227_, _path_index);
			path = (BirdFontPath*) _tmp228_;
			_tmp229_ = path;
			bird_font_path_update_region_boundaries (_tmp229_);
			_g_object_unref0 (path);
		}
	}
	result = path_list;
	_g_object_unref0 (remaining_points);
	_g_object_unref0 (current_path);
	_g_object_unref0 (ep);
	_g_object_unref0 (p);
	return result;
}

void
bird_font_path_set_new_start (BirdFontPath* self,
                              BirdFontEditPoint* ep)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_;
	gint start = 0;
	GeeArrayList* _tmp34_;
	GeeArrayList* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ep != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_return_if_fail (_tmp3_ > 0, "points.size > 0");
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp4_;
	start = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp7_;
				GeeArrayList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				BirdFontEditPoint* _tmp14_;
				gboolean _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = bird_font_path_get_points (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(i < _tmp10_)) {
					break;
				}
				_tmp11_ = bird_font_path_get_points (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
				_tmp14_ = (BirdFontEditPoint*) _tmp13_;
				_tmp15_ = ep == _tmp14_;
				_g_object_unref0 (_tmp14_);
				if (_tmp15_) {
					start = i;
				}
			}
		}
	}
	{
		gint i = 0;
		i = start;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp18_;
				GeeArrayList* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				GeeArrayList* _tmp22_;
				GeeArrayList* _tmp23_;
				GeeArrayList* _tmp24_;
				gpointer _tmp25_;
				BirdFontEditPoint* _tmp26_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = bird_font_path_get_points (self);
				_tmp19_ = _tmp18_;
				_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
				_tmp21_ = _tmp20_;
				if (!(i < _tmp21_)) {
					break;
				}
				_tmp22_ = list;
				_tmp23_ = bird_font_path_get_points (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
				_tmp26_ = (BirdFontEditPoint*) _tmp25_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp26_);
				_g_object_unref0 (_tmp26_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp29_;
				GeeArrayList* _tmp30_;
				GeeArrayList* _tmp31_;
				gpointer _tmp32_;
				BirdFontEditPoint* _tmp33_;
				if (!_tmp27_) {
					gint _tmp28_;
					_tmp28_ = i;
					i = _tmp28_ + 1;
				}
				_tmp27_ = FALSE;
				if (!(i < start)) {
					break;
				}
				_tmp29_ = list;
				_tmp30_ = bird_font_path_get_points (self);
				_tmp31_ = _tmp30_;
				_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
				_tmp33_ = (BirdFontEditPoint*) _tmp32_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp33_);
				_g_object_unref0 (_tmp33_);
			}
		}
	}
	_tmp34_ = list;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (self->control_points);
	self->control_points = _tmp35_;
	_g_object_unref0 (list);
}

void
bird_font_path_append_path (BirdFontPath* self,
                            BirdFontPath* path)
{
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp1_ = bird_font_path_get_points (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = bird_font_path_get_points (path);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == 0;
	}
	if (_tmp0_) {
		g_warning ("Path.vala:2064: No points");
		return;
	}
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _p_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _p_index = 0;
		_tmp9_ = bird_font_path_get_points (path);
		_tmp10_ = _tmp9_;
		_p_list = _tmp10_;
		_tmp11_ = _p_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_p_size = _tmp13_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontEditPoint* p = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontEditPoint* _tmp18_;
			BirdFontEditPoint* _tmp19_;
			BirdFontEditPoint* _tmp20_;
			BirdFontEditPoint* _tmp21_;
			BirdFontEditPoint* _tmp22_;
			_p_index = _p_index + 1;
			_tmp14_ = _p_index;
			_tmp15_ = _p_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _p_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _p_index);
			p = (BirdFontEditPoint*) _tmp17_;
			_tmp18_ = p;
			_tmp19_ = bird_font_edit_point_copy (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = bird_font_path_add_point (self, _tmp20_);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (_tmp20_);
			_g_object_unref0 (p);
		}
	}
	_tmp23_ = bird_font_path_get_points (path);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp24_);
}

/** Roatate around coordinate xc, xc. */
void
bird_font_path_rotate (BirdFontPath* self,
                       gdouble theta,
                       gdouble xc,
                       gdouble yc)
{
	gdouble a = 0.0;
	gdouble radius = 0.0;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPoint* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPoint* _tmp15_;
			BirdFontEditPointHandle* _tmp16_;
			BirdFontEditPoint* _tmp17_;
			BirdFontEditPointHandle* _tmp18_;
			BirdFontEditPoint* _tmp19_;
			BirdFontEditPointHandle* _tmp20_;
			BirdFontEditPoint* _tmp21_;
			BirdFontEditPointHandle* _tmp22_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			_tmp10_ = ep;
			radius = sqrt (pow (xc - _tmp9_->x, (gdouble) 2) + pow (yc + _tmp10_->y, (gdouble) 2));
			_tmp11_ = ep;
			if ((yc + _tmp11_->y) < ((gdouble) 0)) {
				radius = -radius;
			}
			_tmp12_ = ep;
			a = acos ((_tmp12_->x - xc) / radius);
			_tmp13_ = ep;
			_tmp13_->x = xc + (cos (a - theta) * radius);
			_tmp14_ = ep;
			_tmp14_->y = yc + (sin (a - theta) * radius);
			_tmp15_ = ep;
			_tmp16_ = bird_font_edit_point_get_right_handle (_tmp15_);
			_tmp17_ = ep;
			_tmp18_ = bird_font_edit_point_get_right_handle (_tmp17_);
			_tmp18_->angle = _tmp18_->angle - theta;
			_tmp19_ = ep;
			_tmp20_ = bird_font_edit_point_get_left_handle (_tmp19_);
			_tmp21_ = ep;
			_tmp22_ = bird_font_edit_point_get_left_handle (_tmp21_);
			_tmp22_->angle = _tmp22_->angle - theta;
			while (TRUE) {
				BirdFontEditPoint* _tmp23_;
				BirdFontEditPointHandle* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				BirdFontEditPoint* _tmp27_;
				BirdFontEditPointHandle* _tmp28_;
				_tmp23_ = ep;
				_tmp24_ = bird_font_edit_point_get_right_handle (_tmp23_);
				if (!(_tmp24_->angle < ((gdouble) 0))) {
					break;
				}
				_tmp25_ = ep;
				_tmp26_ = bird_font_edit_point_get_right_handle (_tmp25_);
				_tmp27_ = ep;
				_tmp28_ = bird_font_edit_point_get_right_handle (_tmp27_);
				_tmp28_->angle = _tmp28_->angle + (2 * G_PI);
			}
			while (TRUE) {
				BirdFontEditPoint* _tmp29_;
				BirdFontEditPointHandle* _tmp30_;
				BirdFontEditPoint* _tmp31_;
				BirdFontEditPointHandle* _tmp32_;
				BirdFontEditPoint* _tmp33_;
				BirdFontEditPointHandle* _tmp34_;
				_tmp29_ = ep;
				_tmp30_ = bird_font_edit_point_get_left_handle (_tmp29_);
				if (!(_tmp30_->angle < ((gdouble) 0))) {
					break;
				}
				_tmp31_ = ep;
				_tmp32_ = bird_font_edit_point_get_left_handle (_tmp31_);
				_tmp33_ = ep;
				_tmp34_ = bird_font_edit_point_get_left_handle (_tmp33_);
				_tmp34_->angle = _tmp34_->angle + (2 * G_PI);
			}
			_g_object_unref0 (ep);
		}
	}
	self->rotation = self->rotation + theta;
	self->rotation = fmod (self->rotation, 2 * G_PI);
	bird_font_path_update_region_boundaries (self);
}

void
bird_font_path_flip_vertical (BirdFontPath* self)
{
	BirdFontEditPointHandle* hl = NULL;
	BirdFontEditPointHandle* hr = NULL;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPointHandle* _tmp10_;
			BirdFontEditPointHandle* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPointHandle* _tmp13_;
			BirdFontEditPointHandle* _tmp14_;
			BirdFontEditPointHandle* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			BirdFontEditPointHandle* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			BirdFontEditPointHandle* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			BirdFontEditPointHandle* _tmp24_;
			gdouble _tmp25_;
			gdouble _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPoint* _tmp28_;
			BirdFontEditPointHandle* _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = e;
			_tmp10_ = bird_font_edit_point_get_left_handle (_tmp9_);
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (hl);
			hl = _tmp11_;
			_tmp12_ = e;
			_tmp13_ = bird_font_edit_point_get_right_handle (_tmp12_);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (hr);
			hr = _tmp14_;
			_tmp15_ = hl;
			_tmp16_ = bird_font_edit_point_handle_get_x (_tmp15_);
			_tmp17_ = _tmp16_;
			lx = _tmp17_;
			_tmp18_ = hl;
			_tmp19_ = bird_font_edit_point_handle_get_y (_tmp18_);
			_tmp20_ = _tmp19_;
			ly = _tmp20_;
			_tmp21_ = hr;
			_tmp22_ = bird_font_edit_point_handle_get_x (_tmp21_);
			_tmp23_ = _tmp22_;
			rx = _tmp23_;
			_tmp24_ = hr;
			_tmp25_ = bird_font_edit_point_handle_get_y (_tmp24_);
			_tmp26_ = _tmp25_;
			ry = _tmp26_;
			_tmp27_ = e;
			_tmp28_ = e;
			_tmp28_->y = _tmp28_->y * -1;
			_tmp29_ = hr;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp29_, rx, -1 * ry);
			_tmp30_ = hl;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp30_, lx, -1 * ly);
			_g_object_unref0 (e);
		}
	}
	bird_font_path_update_region_boundaries (self);
	_g_object_unref0 (hr);
	_g_object_unref0 (hl);
}

void
bird_font_path_flip_horizontal (BirdFontPath* self)
{
	BirdFontEditPointHandle* hl = NULL;
	BirdFontEditPointHandle* hr = NULL;
	gdouble lx = 0.0;
	gdouble ly = 0.0;
	gdouble rx = 0.0;
	gdouble ry = 0.0;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPointHandle* _tmp10_;
			BirdFontEditPointHandle* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPointHandle* _tmp13_;
			BirdFontEditPointHandle* _tmp14_;
			BirdFontEditPointHandle* _tmp15_;
			gdouble _tmp16_;
			gdouble _tmp17_;
			BirdFontEditPointHandle* _tmp18_;
			gdouble _tmp19_;
			gdouble _tmp20_;
			BirdFontEditPointHandle* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			BirdFontEditPointHandle* _tmp24_;
			gdouble _tmp25_;
			gdouble _tmp26_;
			BirdFontEditPoint* _tmp27_;
			BirdFontEditPoint* _tmp28_;
			BirdFontEditPointHandle* _tmp29_;
			BirdFontEditPointHandle* _tmp30_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = e;
			_tmp10_ = bird_font_edit_point_get_left_handle (_tmp9_);
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (hl);
			hl = _tmp11_;
			_tmp12_ = e;
			_tmp13_ = bird_font_edit_point_get_right_handle (_tmp12_);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (hr);
			hr = _tmp14_;
			_tmp15_ = hl;
			_tmp16_ = bird_font_edit_point_handle_get_x (_tmp15_);
			_tmp17_ = _tmp16_;
			lx = _tmp17_;
			_tmp18_ = hl;
			_tmp19_ = bird_font_edit_point_handle_get_y (_tmp18_);
			_tmp20_ = _tmp19_;
			ly = _tmp20_;
			_tmp21_ = hr;
			_tmp22_ = bird_font_edit_point_handle_get_x (_tmp21_);
			_tmp23_ = _tmp22_;
			rx = _tmp23_;
			_tmp24_ = hr;
			_tmp25_ = bird_font_edit_point_handle_get_y (_tmp24_);
			_tmp26_ = _tmp25_;
			ry = _tmp26_;
			_tmp27_ = e;
			_tmp28_ = e;
			_tmp28_->x = _tmp28_->x * -1;
			_tmp29_ = hr;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp29_, -1 * rx, ry);
			_tmp30_ = hl;
			bird_font_edit_point_handle_move_to_coordinate_internal (_tmp30_, -1 * lx, ly);
			_g_object_unref0 (e);
		}
	}
	bird_font_path_update_region_boundaries (self);
	_g_object_unref0 (hr);
	_g_object_unref0 (hl);
}

void
bird_font_path_init_point_type (BirdFontPath* self,
                                BirdFontPointType pt)
{
	BirdFontPointType type = 0;
	g_return_if_fail (self != NULL);
	if (pt == BIRD_FONT_POINT_TYPE_NONE) {
		pt = bird_font_drawing_tools_point_type;
	}
	switch (pt) {
		case BIRD_FONT_POINT_TYPE_QUADRATIC:
		{
			type = BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
			break;
		}
		case BIRD_FONT_POINT_TYPE_DOUBLE_CURVE:
		{
			type = BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE;
			break;
		}
		case BIRD_FONT_POINT_TYPE_CUBIC:
		{
			type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			break;
		}
		default:
		{
			g_warning ("Path.vala:2171: No type is set");
			type = BIRD_FONT_POINT_TYPE_LINE_CUBIC;
			break;
		}
	}
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPointHandle* _tmp11_;
			BirdFontEditPoint* _tmp12_;
			BirdFontEditPointHandle* _tmp13_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			_tmp9_->type = type;
			_tmp10_ = ep;
			_tmp11_ = bird_font_edit_point_get_right_handle (_tmp10_);
			_tmp11_->type = type;
			_tmp12_ = ep;
			_tmp13_ = bird_font_edit_point_get_left_handle (_tmp12_);
			_tmp13_->type = type;
			_g_object_unref0 (ep);
		}
	}
}

void
bird_font_path_convert_path_ending_to_line (BirdFontPath* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ < 2) {
		return;
	}
	_tmp4_ = bird_font_path_get_first_point (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_edit_point_get_left_handle (_tmp5_);
	bird_font_edit_point_handle_convert_to_line (_tmp6_);
	_g_object_unref0 (_tmp5_);
	_tmp7_ = bird_font_path_get_last_point (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = bird_font_edit_point_get_right_handle (_tmp8_);
	bird_font_edit_point_handle_convert_to_line (_tmp9_);
	_g_object_unref0 (_tmp8_);
}

void
bird_font_path_print_all_types (BirdFontPath* self)
{
	g_return_if_fail (self != NULL);
	g_print ("%s", "Control points:\n");
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _ep_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ep_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_ep_list = _tmp1_;
		_tmp2_ = _ep_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ep_size = _tmp4_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			GEnumValue* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			BirdFontEditPointHandle* _tmp12_;
			GEnumValue* _tmp13_;
			BirdFontEditPoint* _tmp14_;
			BirdFontEditPointHandle* _tmp15_;
			GEnumValue* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_ep_index = _ep_index + 1;
			_tmp5_ = _ep_index;
			_tmp6_ = _ep_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _ep_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = ep;
			_tmp10_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp9_->type);
			_tmp11_ = ep;
			_tmp12_ = bird_font_edit_point_get_left_handle (_tmp11_);
			_tmp13_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp12_->type);
			_tmp14_ = ep;
			_tmp15_ = bird_font_edit_point_get_right_handle (_tmp14_);
			_tmp16_ = g_enum_get_value (g_type_class_ref (BIRD_FONT_TYPE_POINT_TYPE), _tmp15_->type);
			_tmp17_ = g_strconcat ((_tmp10_ != NULL) ? _tmp10_->value_name : NULL, " L: ", (_tmp13_ != NULL) ? _tmp13_->value_name : NULL, " R: L: ", (_tmp16_ != NULL) ? _tmp16_->value_name : NULL, "\n", NULL);
			_tmp18_ = _tmp17_;
			g_print ("%s", _tmp18_);
			_g_free0 (_tmp18_);
			_g_object_unref0 (ep);
		}
	}
}

/** Find the point where two lines intersect. */
void
bird_font_path_find_intersection (gdouble x1,
                                  gdouble y1,
                                  gdouble x2,
                                  gdouble y2,
                                  gdouble x3,
                                  gdouble y3,
                                  gdouble x4,
                                  gdouble y4,
                                  gdouble* point_x,
                                  gdouble* point_y)
{
	gdouble _vala_point_x = 0.0;
	gdouble _vala_point_y = 0.0;
	_vala_point_x = ((((x1 * y2) - (y1 * x2)) * (x3 - x4)) - ((x1 - x2) * ((x3 * y4) - (y3 * x4)))) / (((x1 - x2) * (y3 - y4)) - ((y1 - y2) * (x3 - x4)));
	_vala_point_y = ((((x1 * y2) - (y1 * x2)) * (y3 - y4)) - ((y1 - y2) * ((x3 * y4) - (y3 * x4)))) / (((x1 - x2) * (y3 - y4)) - ((y1 - y2) * (x3 - x4)));
	if (point_x) {
		*point_x = _vala_point_x;
	}
	if (point_y) {
		*point_y = _vala_point_y;
	}
}

void
bird_font_path_find_intersection_handle (BirdFontEditPointHandle* h1,
                                         BirdFontEditPointHandle* h2,
                                         gdouble* point_x,
                                         gdouble* point_y)
{
	gdouble _vala_point_x = 0.0;
	gdouble _vala_point_y = 0.0;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	g_return_if_fail (h1 != NULL);
	g_return_if_fail (h2 != NULL);
	_tmp0_ = h1->parent;
	_tmp1_ = h1->parent;
	_tmp2_ = bird_font_edit_point_handle_get_x (h1);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_edit_point_handle_get_y (h1);
	_tmp5_ = _tmp4_;
	_tmp6_ = h2->parent;
	_tmp7_ = h2->parent;
	_tmp8_ = bird_font_edit_point_handle_get_x (h2);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_edit_point_handle_get_y (h2);
	_tmp11_ = _tmp10_;
	bird_font_path_find_intersection (_tmp0_->x, _tmp1_->y, _tmp3_, _tmp5_, _tmp6_->x, _tmp7_->y, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	_vala_point_x = _tmp12_;
	_vala_point_y = _tmp13_;
	if (point_x) {
		*point_x = _vala_point_x;
	}
	if (point_y) {
		*point_y = _vala_point_y;
	}
}

/** Finx intersection point for two straight lines. */
void
bird_font_path_find_intersection_point (BirdFontEditPoint* p1,
                                        BirdFontEditPoint* p2,
                                        BirdFontEditPoint* q1,
                                        BirdFontEditPoint* q2,
                                        gdouble* point_x,
                                        gdouble* point_y)
{
	gdouble _vala_point_x = 0.0;
	gdouble _vala_point_y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (p1 != NULL);
	g_return_if_fail (p2 != NULL);
	g_return_if_fail (q1 != NULL);
	g_return_if_fail (q2 != NULL);
	bird_font_path_find_intersection (p1->x, p1->y, p2->x, p2->y, q1->x, q1->y, q2->x, q2->y, &_tmp0_, &_tmp1_);
	_vala_point_x = _tmp0_;
	_vala_point_y = _tmp1_;
	if (point_x) {
		*point_x = _vala_point_x;
	}
	if (point_y) {
		*point_y = _vala_point_y;
	}
}

BirdFontEditPoint*
bird_font_path_insert_new_point_on_path_at (BirdFontPath* self,
                                            gdouble x,
                                            gdouble y)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* prev = NULL;
	BirdFontEditPoint* next = NULL;
	gboolean exists = FALSE;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPoint* _tmp6_ = NULL;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_ = NULL;
	BirdFontEditPoint* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontEditPoint* _tmp29_;
	gboolean _tmp30_ = FALSE;
	BirdFontEditPoint* _tmp31_;
	BirdFontEditPoint* _tmp32_;
	gboolean _tmp35_ = FALSE;
	BirdFontEditPoint* _tmp36_;
	BirdFontEditPoint* _tmp37_;
	BirdFontEditPoint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	ep = _tmp0_;
	_tmp1_ = bird_font_path_get_points (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 2) {
		g_warning ("Path.vala:2221: Can't add extrema to just one point.");
		result = ep;
		_g_object_unref0 (next);
		_g_object_unref0 (prev);
		return result;
	}
	_tmp5_ = ep;
	bird_font_path_get_closest_point_on_path (self, _tmp5_, x, y, NULL, NULL, -1);
	_tmp7_ = ep;
	_tmp8_ = _tmp7_->next;
	if (_tmp8_ == NULL) {
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gpointer _tmp11_;
		_tmp9_ = bird_font_path_get_points (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, 0);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = (BirdFontEditPoint*) _tmp11_;
	} else {
		BirdFontEditPoint* _tmp12_;
		BirdFontEditPoint* _tmp13_;
		BirdFontEditPoint* _tmp14_;
		_tmp12_ = ep;
		_tmp13_ = bird_font_edit_point_get_next (_tmp12_);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (_tmp6_);
		_tmp6_ = _tmp14_;
	}
	_tmp15_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (next);
	next = _tmp15_;
	_tmp17_ = ep;
	_tmp18_ = _tmp17_->prev;
	if (_tmp18_ == NULL) {
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gpointer _tmp25_;
		_tmp19_ = bird_font_path_get_points (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = bird_font_path_get_points (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp24_ - 1);
		_g_object_unref0 (_tmp16_);
		_tmp16_ = (BirdFontEditPoint*) _tmp25_;
	} else {
		BirdFontEditPoint* _tmp26_;
		BirdFontEditPoint* _tmp27_;
		BirdFontEditPoint* _tmp28_;
		_tmp26_ = ep;
		_tmp27_ = bird_font_edit_point_get_prev (_tmp26_);
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_g_object_unref0 (_tmp16_);
		_tmp16_ = _tmp28_;
	}
	_tmp29_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (prev);
	prev = _tmp29_;
	_tmp31_ = prev;
	_tmp32_ = ep;
	if (_tmp31_->x == _tmp32_->x) {
		BirdFontEditPoint* _tmp33_;
		BirdFontEditPoint* _tmp34_;
		_tmp33_ = prev;
		_tmp34_ = ep;
		_tmp30_ = _tmp33_->y == _tmp34_->y;
	} else {
		_tmp30_ = FALSE;
	}
	exists = _tmp30_;
	_tmp36_ = next;
	_tmp37_ = ep;
	if (_tmp36_->x == _tmp37_->x) {
		BirdFontEditPoint* _tmp38_;
		BirdFontEditPoint* _tmp39_;
		_tmp38_ = next;
		_tmp39_ = ep;
		_tmp35_ = _tmp38_->y == _tmp39_->y;
	} else {
		_tmp35_ = FALSE;
	}
	exists |= _tmp35_;
	if (!exists) {
		BirdFontEditPoint* _tmp40_;
		_tmp40_ = ep;
		bird_font_path_insert_new_point_on_path (self, _tmp40_, (gdouble) -1, FALSE);
	}
	result = ep;
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (next);
	_g_object_unref0 (prev);
	return result;
}

gboolean
bird_font_path_is_counter (BirdFontPathList* pl,
                           BirdFontPath* path)
{
	gboolean result;
	g_return_val_if_fail (pl != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = (bird_font_path_counters (pl, path) % 2) != 0;
	return result;
}

gint
bird_font_path_counters (BirdFontPathList* pl,
                         BirdFontPath* path)
{
	gint inside_count = 0;
	gboolean inside = FALSE;
	BirdFontPathList* lines = NULL;
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp1_;
	gint result;
	g_return_val_if_fail (pl != NULL, 0);
	g_return_val_if_fail (path != NULL, 0);
	inside_count = 0;
	_tmp0_ = bird_font_path_list_new ();
	lines = _tmp0_;
	_tmp1_ = _g_object_ref0 (pl);
	_g_object_unref0 (lines);
	lines = _tmp1_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontPathList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = lines;
		_tmp3_ = _tmp2_->paths;
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			BirdFontPath* _tmp13_;
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp13_ = p;
			_tmp14_ = bird_font_path_get_points (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > 1) {
				BirdFontPath* _tmp18_;
				_tmp18_ = p;
				_tmp12_ = _tmp18_ != path;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				BirdFontPath* _tmp19_;
				_tmp19_ = p;
				_tmp11_ = bird_font_path_boundaries_intersecting (path, _tmp19_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				inside = FALSE;
				{
					GeeArrayList* _ep_list = NULL;
					GeeArrayList* _tmp20_;
					GeeArrayList* _tmp21_;
					gint _ep_size = 0;
					GeeArrayList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _ep_index = 0;
					_tmp20_ = bird_font_path_get_points (path);
					_tmp21_ = _tmp20_;
					_ep_list = _tmp21_;
					_tmp22_ = _ep_list;
					_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_ep_size = _tmp24_;
					_ep_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						BirdFontEditPoint* ep = NULL;
						GeeArrayList* _tmp27_;
						gpointer _tmp28_;
						BirdFontEditPoint* _tmp29_;
						BirdFontPath* _tmp30_;
						_ep_index = _ep_index + 1;
						_tmp25_ = _ep_index;
						_tmp26_ = _ep_size;
						if (!(_tmp25_ < _tmp26_)) {
							break;
						}
						_tmp27_ = _ep_list;
						_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _ep_index);
						ep = (BirdFontEditPoint*) _tmp28_;
						_tmp29_ = ep;
						_tmp30_ = p;
						if (bird_font_svg_parser_is_inside (_tmp29_, _tmp30_)) {
							inside = TRUE;
						}
						_g_object_unref0 (ep);
					}
				}
				if (inside) {
					gint _tmp31_;
					_tmp31_ = inside_count;
					inside_count = _tmp31_ + 1;
				}
			}
			_g_object_unref0 (p);
		}
	}
	result = inside_count;
	_g_object_unref0 (lines);
	return result;
}

gboolean
bird_font_path_boundaries_intersecting (BirdFontPath* self,
                                        BirdFontPath* p)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p != NULL, FALSE);
	result = bird_font_path_in_boundaries (self, p->xmin, p->xmax, p->ymin, p->ymax);
	return result;
}

gboolean
bird_font_path_in_boundaries (BirdFontPath* self,
                              gdouble other_xmin,
                              gdouble other_xmax,
                              gdouble other_ymin,
                              gdouble other_ymax)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gdouble _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp4_ = other_xmin;
	if ((self->xmin <= _tmp4_) && (_tmp4_ <= self->xmax)) {
		_tmp3_ = TRUE;
	} else {
		gdouble _tmp5_;
		_tmp5_ = other_xmax;
		_tmp3_ = (self->xmin <= _tmp5_) && (_tmp5_ <= self->xmax);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gdouble _tmp6_;
		_tmp6_ = self->xmin;
		_tmp2_ = (other_xmin <= _tmp6_) && (_tmp6_ <= other_xmax);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gdouble _tmp7_;
		_tmp7_ = self->xmax;
		_tmp1_ = (other_xmin <= _tmp7_) && (_tmp7_ <= other_xmax);
	}
	if (_tmp1_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gdouble _tmp11_;
		_tmp11_ = other_ymin;
		if ((self->ymin <= _tmp11_) && (_tmp11_ <= self->ymax)) {
			_tmp10_ = TRUE;
		} else {
			gdouble _tmp12_;
			_tmp12_ = other_ymax;
			_tmp10_ = (self->ymin <= _tmp12_) && (_tmp12_ <= self->ymax);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			gdouble _tmp13_;
			_tmp13_ = self->ymin;
			_tmp9_ = (other_ymin <= _tmp13_) && (_tmp13_ <= other_ymax);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gdouble _tmp14_;
			_tmp14_ = self->ymax;
			_tmp8_ = (other_ymin <= _tmp14_) && (_tmp14_ <= other_ymax);
		}
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/** @param t smallest distance to other points. */
void
bird_font_path_remove_points_on_points (BirdFontPath* self,
                                        gdouble t)
{
	GeeArrayList* remove = NULL;
	GeeArrayList* _tmp0_;
	BirdFontEditPoint* n = NULL;
	BirdFontEditPointHandle* hr = NULL;
	BirdFontEditPointHandle* h = NULL;
	gdouble t3 = 0.0;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	remove = _tmp0_;
	t3 = t / 3;
	_tmp1_ = bird_font_path_get_points (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		_g_object_unref0 (h);
		_g_object_unref0 (hr);
		_g_object_unref0 (n);
		_g_object_unref0 (remove);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp7_;
				GeeArrayList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				BirdFontEditPoint* ep = NULL;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gpointer _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				BirdFontEditPoint* _tmp23_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = bird_font_path_get_points (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(i < (_tmp10_ + 1))) {
					break;
				}
				_tmp11_ = bird_font_path_get_points (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = bird_font_path_get_points (self);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i % _tmp16_);
				ep = (BirdFontEditPoint*) _tmp17_;
				_tmp23_ = ep;
				if ((_tmp23_->flags & BIRD_FONT_EDIT_POINT_STROKE_OFFSET) > ((guint) 0)) {
					BirdFontEditPoint* _tmp24_;
					BirdFontEditPointHandle* _tmp25_;
					_tmp24_ = ep;
					_tmp25_ = bird_font_edit_point_get_right_handle (_tmp24_);
					_tmp22_ = _tmp25_->length < t3;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					BirdFontEditPoint* _tmp26_;
					BirdFontEditPointHandle* _tmp27_;
					_tmp26_ = ep;
					_tmp27_ = bird_font_edit_point_get_left_handle (_tmp26_);
					_tmp21_ = _tmp27_->length < t3;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					BirdFontEditPoint* _tmp28_;
					_tmp28_ = ep;
					_tmp20_ = !bird_font_path_is_endpoint (self, _tmp28_);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					BirdFontEditPoint* _tmp29_;
					_tmp29_ = ep;
					_tmp19_ = (_tmp29_->flags & BIRD_FONT_EDIT_POINT_CURVE_KEEP) == ((guint) 0);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					BirdFontEditPoint* _tmp30_;
					_tmp30_ = ep;
					_tmp18_ = (_tmp30_->flags & BIRD_FONT_EDIT_POINT_SEGMENT_END) == ((guint) 0);
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					BirdFontEditPoint* _tmp31_;
					_tmp31_ = ep;
					bird_font_edit_point_set_deleted (_tmp31_, TRUE);
				}
				_g_object_unref0 (ep);
			}
		}
	}
	bird_font_path_remove_deleted_points (self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp34_;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				BirdFontEditPoint* ep = NULL;
				GeeArrayList* _tmp38_;
				GeeArrayList* _tmp39_;
				GeeArrayList* _tmp40_;
				GeeArrayList* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_;
				GeeArrayList* _tmp45_;
				GeeArrayList* _tmp46_;
				GeeArrayList* _tmp47_;
				GeeArrayList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gpointer _tmp51_;
				BirdFontEditPoint* _tmp52_;
				BirdFontEditPoint* _tmp53_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = bird_font_path_get_points (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (!(i < (_tmp37_ + 1))) {
					break;
				}
				_tmp38_ = bird_font_path_get_points (self);
				_tmp39_ = _tmp38_;
				_tmp40_ = bird_font_path_get_points (self);
				_tmp41_ = _tmp40_;
				_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, i % _tmp43_);
				ep = (BirdFontEditPoint*) _tmp44_;
				_tmp45_ = bird_font_path_get_points (self);
				_tmp46_ = _tmp45_;
				_tmp47_ = bird_font_path_get_points (self);
				_tmp48_ = _tmp47_;
				_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, (i + 1) % _tmp50_);
				_g_object_unref0 (n);
				n = (BirdFontEditPoint*) _tmp51_;
				_tmp52_ = n;
				_tmp53_ = ep;
				if (bird_font_path_distance_to_point (_tmp52_, _tmp53_) < t) {
					GeeArrayList* _tmp54_;
					BirdFontEditPoint* _tmp55_;
					_tmp54_ = remove;
					_tmp55_ = ep;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp55_);
				}
				_g_object_unref0 (ep);
			}
		}
	}
	bird_font_path_create_list (self);
	{
		GeeArrayList* _r_list = NULL;
		GeeArrayList* _tmp56_;
		gint _r_size = 0;
		GeeArrayList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _r_index = 0;
		_tmp56_ = remove;
		_r_list = _tmp56_;
		_tmp57_ = _r_list;
		_tmp58_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_r_size = _tmp59_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			BirdFontEditPoint* r = NULL;
			GeeArrayList* _tmp62_;
			gpointer _tmp63_;
			GeeArrayList* _tmp64_;
			GeeArrayList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			BirdFontEditPoint* _tmp68_;
			BirdFontEditPoint* _tmp69_;
			GeeArrayList* _tmp76_;
			GeeArrayList* _tmp77_;
			BirdFontEditPoint* _tmp78_;
			BirdFontEditPoint* _tmp79_;
			BirdFontEditPointHandle* _tmp80_;
			BirdFontEditPointHandle* _tmp81_;
			BirdFontEditPoint* _tmp82_;
			BirdFontEditPointHandle* _tmp83_;
			BirdFontEditPointHandle* _tmp84_;
			BirdFontEditPointHandle* _tmp85_;
			BirdFontEditPointHandle* _tmp86_;
			BirdFontEditPointHandle* _tmp87_;
			BirdFontEditPointHandle* _tmp88_;
			BirdFontEditPointHandle* _tmp89_;
			BirdFontEditPointHandle* _tmp90_;
			BirdFontEditPointHandle* _tmp91_;
			_r_index = _r_index + 1;
			_tmp60_ = _r_index;
			_tmp61_ = _r_size;
			if (!(_tmp60_ < _tmp61_)) {
				break;
			}
			_tmp62_ = _r_list;
			_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, _r_index);
			r = (BirdFontEditPoint*) _tmp63_;
			_tmp64_ = bird_font_path_get_points (self);
			_tmp65_ = _tmp64_;
			_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			if (_tmp67_ == 0) {
				_g_object_unref0 (r);
				_g_object_unref0 (h);
				_g_object_unref0 (hr);
				_g_object_unref0 (n);
				_g_object_unref0 (remove);
				return;
			}
			_tmp68_ = r;
			_tmp69_ = _tmp68_->next;
			if (_tmp69_ != NULL) {
				BirdFontEditPoint* _tmp70_;
				BirdFontEditPoint* _tmp71_;
				BirdFontEditPoint* _tmp72_;
				_tmp70_ = r;
				_tmp71_ = bird_font_edit_point_get_next (_tmp70_);
				_tmp72_ = _g_object_ref0 (_tmp71_);
				_g_object_unref0 (n);
				n = _tmp72_;
			} else {
				GeeArrayList* _tmp73_;
				GeeArrayList* _tmp74_;
				gpointer _tmp75_;
				_tmp73_ = bird_font_path_get_points (self);
				_tmp74_ = _tmp73_;
				_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, 0);
				_g_object_unref0 (n);
				n = (BirdFontEditPoint*) _tmp75_;
			}
			_tmp76_ = bird_font_path_get_points (self);
			_tmp77_ = _tmp76_;
			_tmp78_ = r;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp77_, _tmp78_);
			_tmp79_ = n;
			_tmp80_ = bird_font_edit_point_get_left_handle (_tmp79_);
			_tmp81_ = _g_object_ref0 (_tmp80_);
			_g_object_unref0 (h);
			h = _tmp81_;
			_tmp82_ = r;
			_tmp83_ = bird_font_edit_point_get_left_handle (_tmp82_);
			_tmp84_ = _g_object_ref0 (_tmp83_);
			_g_object_unref0 (hr);
			hr = _tmp84_;
			_tmp85_ = h;
			_tmp86_ = hr;
			_tmp85_->length = _tmp86_->length;
			_tmp87_ = h;
			_tmp88_ = hr;
			_tmp87_->angle = _tmp88_->angle;
			_tmp89_ = h;
			_tmp90_ = hr;
			_tmp89_->type = _tmp90_->type;
			_tmp91_ = h;
			if (_tmp91_->length < t) {
				BirdFontEditPointHandle* _tmp92_;
				BirdFontEditPointHandle* _tmp93_;
				BirdFontEditPoint* _tmp94_;
				BirdFontEditPointHandle* _tmp95_;
				_tmp92_ = h;
				_tmp92_->length = t;
				_tmp93_ = h;
				_tmp94_ = n;
				_tmp95_ = bird_font_edit_point_get_right_handle (_tmp94_);
				_tmp93_->angle = _tmp95_->angle - G_PI;
			}
			bird_font_path_create_list (self);
			_g_object_unref0 (r);
		}
	}
	bird_font_path_recalculate_linear_handles (self);
	_g_object_unref0 (h);
	_g_object_unref0 (hr);
	_g_object_unref0 (n);
	_g_object_unref0 (remove);
}

gboolean
bird_font_path_is_endpoint (BirdFontPath* self,
                            BirdFontEditPoint* ep)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	BirdFontEditPoint* _tmp8_;
	gboolean _tmp9_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ep != NULL, FALSE);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp5_ = bird_font_path_get_points (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, 0);
	_tmp8_ = (BirdFontEditPoint*) _tmp7_;
	_tmp9_ = ep == _tmp8_;
	_g_object_unref0 (_tmp8_);
	if (_tmp9_) {
		_tmp4_ = TRUE;
	} else {
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gpointer _tmp16_;
		BirdFontEditPoint* _tmp17_;
		_tmp10_ = bird_font_path_get_points (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = bird_font_path_get_points (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp15_ - 1);
		_tmp17_ = (BirdFontEditPoint*) _tmp16_;
		_tmp4_ = ep == _tmp17_;
		_g_object_unref0 (_tmp17_);
	}
	result = _tmp4_;
	return result;
}

void
bird_font_path_remove_deleted_points (BirdFontPath* self)
{
	GeeArrayList* p = NULL;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	p = _tmp0_;
	{
		GeeArrayList* _ep_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _ep_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _ep_index = 0;
		_tmp1_ = bird_font_path_get_points (self);
		_tmp2_ = _tmp1_;
		_ep_list = _tmp2_;
		_tmp3_ = _ep_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_ep_size = _tmp5_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontEditPoint* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_ep_index = _ep_index + 1;
			_tmp6_ = _ep_index;
			_tmp7_ = _ep_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _ep_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp9_;
			_tmp10_ = ep;
			_tmp11_ = bird_font_edit_point_get_deleted (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				GeeArrayList* _tmp13_;
				BirdFontEditPoint* _tmp14_;
				_tmp13_ = p;
				_tmp14_ = ep;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_g_object_unref0 (ep);
		}
	}
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp15_;
		gint _e_size = 0;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _e_index = 0;
		_tmp15_ = p;
		_e_list = _tmp15_;
		_tmp16_ = _e_list;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_e_size = _tmp18_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp21_;
			gpointer _tmp22_;
			GeeArrayList* _tmp23_;
			GeeArrayList* _tmp24_;
			BirdFontEditPoint* _tmp25_;
			_e_index = _e_index + 1;
			_tmp19_ = _e_index;
			_tmp20_ = _e_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _e_list;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _e_index);
			e = (BirdFontEditPoint*) _tmp22_;
			_tmp23_ = bird_font_path_get_points (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = e;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_g_object_unref0 (e);
		}
	}
	bird_font_path_create_list (self);
	_g_object_unref0 (p);
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
____lambda35_ (Block50Data* _data50_,
               gdouble xa,
               gdouble ya,
               gdouble ta)
{
	gdouble d = 0.0;
	gboolean result;
	d = bird_font_path_distance (_data50_->px, xa, _data50_->py, ya);
	if (d < _data50_->min_distance) {
		_data50_->min_distance = d;
		_data50_->npx = xa;
		_data50_->npy = ya;
		_data50_->rmin_t = ta - (1.0 / _data50_->step);
		_data50_->rmax_t = ta + (1.0 / _data50_->step);
		_data50_->found = TRUE;
	}
	result = TRUE;
	return result;
}

static gboolean
_____lambda35__bird_font_path_raster_iterator (gdouble x,
                                               gdouble y,
                                               gdouble step,
                                               gpointer self)
{
	gboolean result;
	result = ____lambda35_ (self, x, y, step);
	return result;
}

void
bird_font_path_find_closes_point_in_segment (BirdFontEditPoint* ep0,
                                             BirdFontEditPoint* ep1,
                                             gdouble px,
                                             gdouble py,
                                             gdouble* nx,
                                             gdouble* ny,
                                             gdouble max_step)
{
	gdouble _vala_nx = 0.0;
	gdouble _vala_ny = 0.0;
	Block50Data* _data50_;
	gdouble min_t = 0.0;
	gdouble max_t = 0.0;
	g_return_if_fail (ep0 != NULL);
	g_return_if_fail (ep1 != NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->px = px;
	_data50_->py = py;
	_data50_->min_distance = DBL_MAX;
	_data50_->npx = (gdouble) 0;
	_data50_->npy = (gdouble) 0;
	min_t = (gdouble) 0;
	max_t = (gdouble) 1;
	_data50_->rmin_t = (gdouble) 0;
	_data50_->rmax_t = (gdouble) 1;
	{
		gboolean _tmp0_ = FALSE;
		_data50_->step = 3;
		_tmp0_ = TRUE;
		while (TRUE) {
			gdouble _tmp1_ = 0.0;
			gdouble _tmp2_ = 0.0;
			if (!_tmp0_) {
				_data50_->step *= 2;
			}
			_tmp0_ = FALSE;
			if (!(((gdouble) _data50_->step) <= max_step)) {
				break;
			}
			_data50_->found = FALSE;
			_data50_->min_distance = DBL_MAX;
			bird_font_path_all_of (ep0, ep1, _____lambda35__bird_font_path_raster_iterator, _data50_, _data50_->step, min_t, max_t);
			if (!_data50_->found) {
				_data50_->rmin_t = 1 - (1.0 / _data50_->step);
				_data50_->rmax_t = (gdouble) 1;
			}
			if (_data50_->rmin_t > ((gdouble) 0)) {
				_tmp1_ = _data50_->rmin_t;
			} else {
				_tmp1_ = (gdouble) 0;
			}
			min_t = _tmp1_;
			if (_data50_->rmax_t < ((gdouble) 1)) {
				_tmp2_ = _data50_->rmax_t;
			} else {
				_tmp2_ = (gdouble) 1;
			}
			max_t = _tmp2_;
		}
	}
	_vala_nx = _data50_->npx;
	_vala_ny = _data50_->npy;
	if (nx) {
		*nx = _vala_nx;
	}
	if (ny) {
		*ny = _vala_ny;
	}
	block50_data_unref (_data50_);
	_data50_ = NULL;
}

void
bird_font_path_reset_stroke (BirdFontPath* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->full_stroke);
	self->full_stroke = NULL;
	_g_object_unref0 (self->priv->fast_stroke);
	self->priv->fast_stroke = NULL;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		BirdFontPath* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->task);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static gboolean
__lambda110_ (Block51Data* _data51_)
{
	BirdFontPath* self;
	BirdFontNativeWindow* _tmp0_;
	BirdFontStrokeTask* _tmp1_;
	gboolean result;
	self = _data51_->self;
	_tmp0_ = bird_font_main_window_native_window;
	_tmp1_ = _data51_->task;
	bird_font_native_window_run_non_blocking_background_thread (_tmp0_, (BirdFontTask*) _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda110__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda110_ (self);
	return result;
}

void
bird_font_path_create_full_stroke (BirdFontPath* self)
{
	Block51Data* _data51_;
	gdouble _tmp0_;
	gdouble _tmp1_;
	BirdFontStrokeTask* _tmp2_;
	GSource* idle = NULL;
	GSource* _tmp3_;
	GSource* _tmp4_;
	GSource* _tmp5_;
	BirdFontStrokeTask* _tmp6_;
	BirdFontStrokeTask* _tmp7_;
	g_return_if_fail (self != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = bird_font_path_get_stroke (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ <= ((gdouble) 0)) {
		block51_data_unref (_data51_);
		_data51_ = NULL;
		return;
	}
	_tmp2_ = bird_font_stroke_task_new (self);
	_data51_->task = _tmp2_;
	_tmp3_ = g_idle_source_new ();
	idle = _tmp3_;
	_tmp4_ = idle;
	g_source_set_callback (_tmp4_, ___lambda110__gsource_func, block51_data_ref (_data51_), block51_data_unref);
	_tmp5_ = idle;
	g_source_attach (_tmp5_, NULL);
	bird_font_path_stop_stroke_creator (self);
	_tmp6_ = _data51_->task;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->stroke_creator);
	self->priv->stroke_creator = _tmp7_;
	_g_source_unref0 (idle);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

void
bird_font_path_stop_stroke_creator (BirdFontPath* self)
{
	BirdFontStrokeTask* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stroke_creator;
	if (_tmp0_ != NULL) {
		BirdFontStrokeTask* _tmp1_;
		_tmp1_ = self->priv->stroke_creator;
		bird_font_task_cancel ((BirdFontTask*) G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_STROKE_TASK, BirdFontStrokeTask));
	}
}

BirdFontPathList*
bird_font_path_get_completed_stroke (BirdFontPath* self)
{
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp6_;
	BirdFontPathList* _tmp7_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->full_stroke;
	if (_tmp0_ == NULL) {
		BirdFontStrokeTool* s = NULL;
		BirdFontStrokeTool* _tmp1_;
		BirdFontStrokeTool* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		BirdFontPathList* _tmp5_;
		_tmp1_ = bird_font_stroke_tool_new ();
		s = _tmp1_;
		_tmp2_ = s;
		_tmp3_ = bird_font_path_get_stroke (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = bird_font_stroke_tool_get_stroke (_tmp2_, self, _tmp4_);
		_g_object_unref0 (self->full_stroke);
		self->full_stroke = _tmp5_;
		_g_object_unref0 (s);
	}
	_tmp6_ = self->full_stroke;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_PATH_LIST, BirdFontPathList));
	result = _tmp7_;
	return result;
}

BirdFontPathList*
bird_font_path_get_stroke_fast (BirdFontPath* self)
{
	BirdFontPathList* _tmp0_;
	BirdFontPathList* _tmp3_;
	BirdFontStrokeTool* s = NULL;
	BirdFontStrokeTool* _tmp6_;
	BirdFontStrokeTool* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	BirdFontPathList* _tmp10_;
	BirdFontPathList* _tmp11_;
	BirdFontPathList* _tmp12_;
	BirdFontPathList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->full_stroke;
	if (_tmp0_ != NULL) {
		BirdFontPathList* _tmp1_;
		BirdFontPathList* _tmp2_;
		_tmp1_ = self->full_stroke;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_PATH_LIST, BirdFontPathList));
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->fast_stroke;
	if (_tmp3_ != NULL) {
		BirdFontPathList* _tmp4_;
		BirdFontPathList* _tmp5_;
		_tmp4_ = self->priv->fast_stroke;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_PATH_LIST, BirdFontPathList));
		result = _tmp5_;
		return result;
	}
	_tmp6_ = bird_font_stroke_tool_new ();
	s = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = bird_font_path_get_stroke (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = bird_font_stroke_tool_get_stroke_fast (_tmp7_, self, _tmp9_);
	_g_object_unref0 (self->priv->fast_stroke);
	self->priv->fast_stroke = _tmp10_;
	_tmp11_ = self->priv->fast_stroke;
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, BIRD_FONT_TYPE_PATH_LIST, BirdFontPathList));
	result = _tmp12_;
	_g_object_unref0 (s);
	return result;
}

void
bird_font_path_add_cubic_bezier_points (BirdFontPath* self,
                                        gdouble x0,
                                        gdouble y0,
                                        gdouble x1,
                                        gdouble y1,
                                        gdouble x2,
                                        gdouble y2,
                                        gdouble x3,
                                        gdouble y3)
{
	BirdFontEditPoint* start = NULL;
	BirdFontEditPoint* end = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPointHandle* _tmp10_;
	BirdFontEditPointHandle* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_path_get_points (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		BirdFontEditPoint* _tmp4_;
		_tmp4_ = bird_font_path_get_last_point (self);
		_g_object_unref0 (start);
		start = _tmp4_;
	} else {
		BirdFontEditPoint* _tmp5_;
		_tmp5_ = bird_font_path_add (self, x0, y0);
		_g_object_unref0 (start);
		start = _tmp5_;
	}
	_tmp6_ = bird_font_path_add (self, x3, y3);
	_g_object_unref0 (end);
	end = _tmp6_;
	_tmp7_ = start;
	bird_font_edit_point_set_point_type (_tmp7_, BIRD_FONT_POINT_TYPE_CUBIC);
	bird_font_edit_point_set_point_type (end, BIRD_FONT_POINT_TYPE_CUBIC);
	_tmp8_ = start;
	bird_font_edit_point_convert_to_curve (_tmp8_);
	bird_font_edit_point_convert_to_curve (end);
	_tmp9_ = start;
	_tmp10_ = bird_font_edit_point_get_right_handle (_tmp9_);
	bird_font_edit_point_handle_move_to_coordinate (_tmp10_, x1, y1);
	_tmp11_ = bird_font_edit_point_get_left_handle (end);
	bird_font_edit_point_handle_move_to_coordinate (_tmp11_, x2, y2);
	_g_object_unref0 (end);
	_g_object_unref0 (start);
}

void
bird_font_path_recalculate_linear_handles (BirdFontPath* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _e_list = NULL;
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _e_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _e_index = 0;
		_tmp0_ = bird_font_path_get_points (self);
		_tmp1_ = _tmp0_;
		_e_list = _tmp1_;
		_tmp2_ = _e_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_e_size = _tmp4_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			BirdFontEditPoint* _tmp9_;
			_e_index = _e_index + 1;
			_tmp5_ = _e_index;
			_tmp6_ = _e_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _e_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _e_index);
			e = (BirdFontEditPoint*) _tmp8_;
			_tmp9_ = e;
			bird_font_path_recalculate_linear_handles_for_point (self, _tmp9_);
			_g_object_unref0 (e);
		}
	}
}

/** Set bezier points for linear paths. */
void
bird_font_path_recalculate_linear_handles_for_point (BirdFontPath* self,
                                                     BirdFontEditPoint* ep)
{
	BirdFontEditPointHandle* h = NULL;
	BirdFontEditPoint* n = NULL;
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	gboolean _tmp0_ = FALSE;
	BirdFontEditPointHandle* _tmp1_;
	BirdFontEditPoint* _tmp3_;
	gboolean _tmp11_ = FALSE;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPointHandle* _tmp14_;
	BirdFontEditPointHandle* _tmp18_;
	BirdFontEditPointHandle* _tmp22_;
	BirdFontEditPoint* _tmp26_;
	BirdFontEditPointHandle* _tmp27_;
	BirdFontEditPointHandle* _tmp28_;
	gboolean _tmp29_ = FALSE;
	BirdFontEditPointHandle* _tmp30_;
	BirdFontEditPointHandle* _tmp32_;
	BirdFontEditPointHandle* _tmp38_;
	BirdFontEditPointHandle* _tmp44_;
	BirdFontEditPoint* _tmp50_;
	gboolean _tmp58_ = FALSE;
	BirdFontEditPoint* _tmp59_;
	BirdFontEditPointHandle* _tmp61_;
	BirdFontEditPointHandle* _tmp65_;
	BirdFontEditPointHandle* _tmp69_;
	BirdFontEditPoint* _tmp73_;
	BirdFontEditPointHandle* _tmp74_;
	BirdFontEditPointHandle* _tmp75_;
	BirdFontEditPointHandle* _tmp76_;
	BirdFontEditPointHandle* _tmp77_;
	BirdFontEditPointHandle* _tmp83_;
	BirdFontEditPointHandle* _tmp89_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ep != NULL);
	_tmp1_ = ep->right_handle;
	if (!bird_font_is_null (_tmp1_)) {
		BirdFontEditPointHandle* _tmp2_;
		_tmp2_ = ep->left_handle;
		_tmp0_ = !bird_font_is_null (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp3_ = ep->prev;
	if (_tmp3_ != NULL) {
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPointHandle* _tmp6_;
		BirdFontEditPointHandle* _tmp7_;
		_tmp4_ = bird_font_edit_point_get_prev (ep);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (n);
		n = _tmp5_;
		_tmp6_ = bird_font_edit_point_get_left_handle (ep);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (h);
		h = _tmp7_;
	} else {
		BirdFontEditPoint* _tmp8_;
		BirdFontEditPointHandle* _tmp9_;
		BirdFontEditPointHandle* _tmp10_;
		_tmp8_ = bird_font_path_get_last_point (self);
		_g_object_unref0 (n);
		n = _tmp8_;
		_tmp9_ = bird_font_edit_point_get_left_handle (ep);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (h);
		h = _tmp10_;
	}
	_tmp12_ = n;
	if (!bird_font_is_null (_tmp12_)) {
		BirdFontEditPointHandle* _tmp13_;
		_tmp13_ = h;
		_tmp11_ = !bird_font_is_null (_tmp13_);
	} else {
		_tmp11_ = FALSE;
	}
	g_return_if_fail (_tmp11_);
	_tmp14_ = h;
	if (_tmp14_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
		BirdFontEditPoint* _tmp15_;
		BirdFontEditPoint* _tmp16_;
		BirdFontEditPointHandle* _tmp17_;
		_tmp15_ = n;
		nx = ep->x + ((_tmp15_->x - ep->x) / 3);
		_tmp16_ = n;
		ny = ep->y + ((_tmp16_->y - ep->y) / 3);
		_tmp17_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp17_, nx, ny);
	}
	_tmp18_ = h;
	if (_tmp18_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
		BirdFontEditPoint* _tmp19_;
		BirdFontEditPoint* _tmp20_;
		BirdFontEditPointHandle* _tmp21_;
		_tmp19_ = n;
		nx = ep->x + ((_tmp19_->x - ep->x) / 4);
		_tmp20_ = n;
		ny = ep->y + ((_tmp20_->y - ep->y) / 4);
		_tmp21_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp21_, nx, ny);
	}
	_tmp22_ = h;
	if (_tmp22_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		BirdFontEditPoint* _tmp23_;
		BirdFontEditPoint* _tmp24_;
		BirdFontEditPointHandle* _tmp25_;
		_tmp23_ = n;
		nx = ep->x + ((_tmp23_->x - ep->x) / 2);
		_tmp24_ = n;
		ny = ep->y + ((_tmp24_->y - ep->y) / 2);
		_tmp25_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp25_, nx, ny);
	}
	_tmp26_ = n;
	_tmp27_ = bird_font_edit_point_get_right_handle (_tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	_g_object_unref0 (h);
	h = _tmp28_;
	_tmp30_ = h;
	if (!bird_font_is_null (_tmp30_)) {
		BirdFontEditPointHandle* _tmp31_;
		_tmp31_ = h;
		_tmp29_ = !bird_font_is_null (_tmp31_);
	} else {
		_tmp29_ = FALSE;
	}
	g_return_if_fail (_tmp29_);
	_tmp32_ = h;
	if (_tmp32_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
		BirdFontEditPoint* _tmp33_;
		BirdFontEditPoint* _tmp34_;
		BirdFontEditPoint* _tmp35_;
		BirdFontEditPoint* _tmp36_;
		BirdFontEditPointHandle* _tmp37_;
		_tmp33_ = n;
		_tmp34_ = n;
		nx = _tmp33_->x + ((ep->x - _tmp34_->x) / 4);
		_tmp35_ = n;
		_tmp36_ = n;
		ny = _tmp35_->y + ((ep->y - _tmp36_->y) / 4);
		_tmp37_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp37_, nx, ny);
	}
	_tmp38_ = h;
	if (_tmp38_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
		BirdFontEditPoint* _tmp39_;
		BirdFontEditPoint* _tmp40_;
		BirdFontEditPoint* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		BirdFontEditPointHandle* _tmp43_;
		_tmp39_ = n;
		_tmp40_ = n;
		nx = _tmp39_->x + ((ep->x - _tmp40_->x) / 3);
		_tmp41_ = n;
		_tmp42_ = n;
		ny = _tmp41_->y + ((ep->y - _tmp42_->y) / 3);
		_tmp43_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp43_, nx, ny);
	}
	_tmp44_ = h;
	if (_tmp44_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		BirdFontEditPoint* _tmp45_;
		BirdFontEditPoint* _tmp46_;
		BirdFontEditPoint* _tmp47_;
		BirdFontEditPoint* _tmp48_;
		BirdFontEditPointHandle* _tmp49_;
		_tmp45_ = n;
		_tmp46_ = n;
		nx = _tmp45_->x + ((ep->x - _tmp46_->x) / 2);
		_tmp47_ = n;
		_tmp48_ = n;
		ny = _tmp47_->y + ((ep->y - _tmp48_->y) / 2);
		_tmp49_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp49_, nx, ny);
	}
	_tmp50_ = ep->next;
	if (_tmp50_ != NULL) {
		BirdFontEditPoint* _tmp51_;
		BirdFontEditPoint* _tmp52_;
		BirdFontEditPointHandle* _tmp53_;
		BirdFontEditPointHandle* _tmp54_;
		_tmp51_ = bird_font_edit_point_get_next (ep);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		_g_object_unref0 (n);
		n = _tmp52_;
		_tmp53_ = bird_font_edit_point_get_right_handle (ep);
		_tmp54_ = _g_object_ref0 (_tmp53_);
		_g_object_unref0 (h);
		h = _tmp54_;
	} else {
		BirdFontEditPoint* _tmp55_;
		BirdFontEditPointHandle* _tmp56_;
		BirdFontEditPointHandle* _tmp57_;
		_tmp55_ = bird_font_path_get_first_point (self);
		_g_object_unref0 (n);
		n = _tmp55_;
		_tmp56_ = bird_font_edit_point_get_right_handle (ep);
		_tmp57_ = _g_object_ref0 (_tmp56_);
		_g_object_unref0 (h);
		h = _tmp57_;
	}
	_tmp59_ = n;
	if (!bird_font_is_null (_tmp59_)) {
		BirdFontEditPointHandle* _tmp60_;
		_tmp60_ = h;
		_tmp58_ = !bird_font_is_null (_tmp60_);
	} else {
		_tmp58_ = FALSE;
	}
	g_return_if_fail (_tmp58_);
	_tmp61_ = h;
	if (_tmp61_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
		BirdFontEditPoint* _tmp62_;
		BirdFontEditPoint* _tmp63_;
		BirdFontEditPointHandle* _tmp64_;
		_tmp62_ = n;
		nx = ep->x + ((_tmp62_->x - ep->x) / 3);
		_tmp63_ = n;
		ny = ep->y + ((_tmp63_->y - ep->y) / 3);
		_tmp64_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp64_, nx, ny);
	}
	_tmp65_ = h;
	if (_tmp65_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
		BirdFontEditPoint* _tmp66_;
		BirdFontEditPoint* _tmp67_;
		BirdFontEditPointHandle* _tmp68_;
		_tmp66_ = n;
		nx = ep->x + ((_tmp66_->x - ep->x) / 4);
		_tmp67_ = n;
		ny = ep->y + ((_tmp67_->y - ep->y) / 4);
		_tmp68_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp68_, nx, ny);
	}
	_tmp69_ = h;
	if (_tmp69_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		BirdFontEditPoint* _tmp70_;
		BirdFontEditPoint* _tmp71_;
		BirdFontEditPointHandle* _tmp72_;
		_tmp70_ = n;
		nx = ep->x + ((_tmp70_->x - ep->x) / 2);
		_tmp71_ = n;
		ny = ep->y + ((_tmp71_->y - ep->y) / 2);
		_tmp72_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp72_, nx, ny);
	}
	_tmp73_ = n;
	_tmp74_ = bird_font_edit_point_get_left_handle (_tmp73_);
	_tmp75_ = _g_object_ref0 (_tmp74_);
	_g_object_unref0 (h);
	h = _tmp75_;
	_tmp76_ = h;
	g_return_if_fail (!bird_font_is_null (_tmp76_));
	_tmp77_ = h;
	if (_tmp77_->type == BIRD_FONT_POINT_TYPE_LINE_CUBIC) {
		BirdFontEditPoint* _tmp78_;
		BirdFontEditPoint* _tmp79_;
		BirdFontEditPoint* _tmp80_;
		BirdFontEditPoint* _tmp81_;
		BirdFontEditPointHandle* _tmp82_;
		_tmp78_ = n;
		_tmp79_ = n;
		nx = _tmp78_->x + ((ep->x - _tmp79_->x) / 3);
		_tmp80_ = n;
		_tmp81_ = n;
		ny = _tmp80_->y + ((ep->y - _tmp81_->y) / 3);
		_tmp82_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp82_, nx, ny);
	}
	_tmp83_ = h;
	if (_tmp83_->type == BIRD_FONT_POINT_TYPE_LINE_DOUBLE_CURVE) {
		BirdFontEditPoint* _tmp84_;
		BirdFontEditPoint* _tmp85_;
		BirdFontEditPoint* _tmp86_;
		BirdFontEditPoint* _tmp87_;
		BirdFontEditPointHandle* _tmp88_;
		_tmp84_ = n;
		_tmp85_ = n;
		nx = _tmp84_->x + ((ep->x - _tmp85_->x) / 4);
		_tmp86_ = n;
		_tmp87_ = n;
		ny = _tmp86_->y + ((ep->y - _tmp87_->y) / 4);
		_tmp88_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp88_, nx, ny);
	}
	_tmp89_ = h;
	if (_tmp89_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC) {
		BirdFontEditPoint* _tmp90_;
		BirdFontEditPoint* _tmp91_;
		BirdFontEditPoint* _tmp92_;
		BirdFontEditPoint* _tmp93_;
		BirdFontEditPointHandle* _tmp94_;
		_tmp90_ = n;
		_tmp91_ = n;
		nx = _tmp90_->x + ((ep->x - _tmp91_->x) / 2);
		_tmp92_ = n;
		_tmp93_ = n;
		ny = _tmp92_->y + ((ep->y - _tmp93_->y) / 2);
		_tmp94_ = h;
		bird_font_edit_point_handle_move_to_coordinate (_tmp94_, nx, ny);
	}
	_g_object_unref0 (n);
	_g_object_unref0 (h);
}

BirdFontPath*
bird_font_path_self_interpolate (BirdFontPath* self,
                                 gdouble weight,
                                 gboolean counter)
{
	BirdFontPath* master = NULL;
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_path_new ();
	p = _tmp0_;
	_tmp1_ = bird_font_path_get_stroke (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > ((gdouble) 0)) {
		BirdFontPath* _tmp3_;
		BirdFontPath* _tmp4_;
		BirdFontPath* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		BirdFontPath* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp3_ = bird_font_path_copy (self);
		_g_object_unref0 (p);
		p = _tmp3_;
		_tmp4_ = p;
		_tmp5_ = p;
		_tmp6_ = bird_font_path_get_stroke (_tmp5_);
		_tmp7_ = _tmp6_;
		bird_font_path_set_stroke (_tmp5_, _tmp7_ + ((5 * weight) * 2));
		_tmp8_ = p;
		_tmp9_ = bird_font_path_get_stroke (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ < 0.002) {
			BirdFontPath* _tmp11_;
			_tmp11_ = p;
			bird_font_path_set_stroke (_tmp11_, 0.002);
		}
	} else {
		BirdFontPath* _tmp12_;
		BirdFontPath* _tmp13_;
		BirdFontPath* _tmp14_;
		bird_font_path_remove_points_on_points (self, 0.00001);
		_tmp12_ = bird_font_path_get_self_interpolated_master (self, counter, weight);
		_g_object_unref0 (master);
		master = _tmp12_;
		_tmp13_ = master;
		_tmp14_ = bird_font_path_interpolate_estimated_path (self, _tmp13_, weight);
		_g_object_unref0 (p);
		p = _tmp14_;
		bird_font_path_recalculate_linear_handles (self);
	}
	result = p;
	_g_object_unref0 (master);
	return result;
}

BirdFontPath*
bird_font_path_interpolate_estimated_path (BirdFontPath* self,
                                           BirdFontPath* master,
                                           gdouble weight)
{
	BirdFontPath* p = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* master_point = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble direction = 0.0;
	gboolean _tmp1_ = FALSE;
	BirdFontPath* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontEditPoint* _tmp11_;
	BirdFontPath* _tmp50_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (master != NULL, NULL);
	_tmp0_ = bird_font_path_copy (self);
	p = _tmp0_;
	direction = weight;
	weight = fabs (weight);
	_tmp2_ = p;
	_tmp3_ = bird_font_path_get_points (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ <= 1) {
		_tmp1_ = TRUE;
	} else {
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp7_ = bird_font_path_get_points (master);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ = _tmp10_ <= 1;
	}
	if (_tmp1_) {
		result = p;
		_g_object_unref0 (master_point);
		_g_object_unref0 (ep);
		return result;
	}
	_tmp11_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (master_point);
	master_point = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				BirdFontPath* _tmp14_;
				GeeArrayList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				BirdFontPath* _tmp19_;
				GeeArrayList* _tmp20_;
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				gdouble right_angle = 0.0;
				BirdFontEditPoint* _tmp23_;
				BirdFontEditPointHandle* _tmp24_;
				gdouble left_angle = 0.0;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPointHandle* _tmp26_;
				gdouble angle = 0.0;
				gdouble _tmp27_ = 0.0;
				gdouble close_x = 0.0;
				gdouble close_y = 0.0;
				gdouble min_distance = 0.0;
				gdouble distance = 0.0;
				gdouble distance_to_edge = 0.0;
				BirdFontEditPoint* _tmp28_;
				BirdFontEditPoint* _tmp42_;
				BirdFontColor* _tmp43_;
				BirdFontEditPoint* _tmp44_;
				BirdFontEditPoint* _tmp45_;
				BirdFontEditPoint* _tmp46_;
				BirdFontEditPoint* _tmp47_;
				BirdFontEditPoint* _tmp48_;
				BirdFontEditPoint* _tmp49_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = p;
				_tmp15_ = bird_font_path_get_points (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				if (!(i < _tmp18_)) {
					break;
				}
				_tmp19_ = p;
				_tmp20_ = bird_font_path_get_points (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp22_;
				_tmp23_ = ep;
				_tmp24_ = bird_font_edit_point_get_right_handle (_tmp23_);
				right_angle = _tmp24_->angle;
				_tmp25_ = ep;
				_tmp26_ = bird_font_edit_point_get_left_handle (_tmp25_);
				left_angle = _tmp26_->angle;
				angle = bird_font_edit_point_handle_average_angle (right_angle, left_angle);
				if (direction > ((gdouble) 0)) {
					_tmp27_ = -G_PI;
				} else {
					_tmp27_ = G_PI;
				}
				angle += _tmp27_;
				if (angle < ((gdouble) 0)) {
					angle += 2 * G_PI;
				}
				angle = fmod (angle, 2 * G_PI);
				min_distance = BIRD_FONT_GLYPH_CANVAS_MAX;
				distance_to_edge = (5 / 2.0) * weight;
				close_x = BIRD_FONT_GLYPH_CANVAS_MAX;
				close_y = BIRD_FONT_GLYPH_CANVAS_MAX;
				_tmp28_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
				_g_object_unref0 (master_point);
				master_point = _tmp28_;
				while (TRUE) {
					BirdFontEditPoint* _tmp29_;
					BirdFontEditPoint* _tmp30_;
					BirdFontEditPoint* _tmp31_;
					BirdFontEditPoint* _tmp32_;
					BirdFontEditPoint* _tmp33_;
					BirdFontEditPoint* _tmp34_;
					BirdFontEditPoint* _tmp35_;
					BirdFontColor* _tmp36_;
					BirdFontEditPoint* _tmp37_;
					BirdFontEditPoint* _tmp38_;
					BirdFontEditPointHandle* _tmp39_;
					BirdFontEditPoint* _tmp40_;
					BirdFontEditPoint* _tmp41_;
					_tmp29_ = master_point;
					_tmp30_ = master_point;
					if (!(bird_font_path_distance (close_x, _tmp29_->x, close_y, _tmp30_->y) > 0.1)) {
						break;
					}
					_tmp31_ = ep;
					x = _tmp31_->x + (distance_to_edge * cos (angle));
					_tmp32_ = ep;
					y = _tmp32_->y + (distance_to_edge * sin (angle));
					_tmp33_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
					_g_object_unref0 (master_point);
					master_point = _tmp33_;
					_tmp34_ = master_point;
					bird_font_path_get_closest_point_on_path (master, _tmp34_, x, y, NULL, NULL, -1);
					_tmp35_ = master_point;
					_tmp36_ = bird_font_color_red ();
					_bird_font_color_unref0 (_tmp35_->color);
					_tmp35_->color = _tmp36_;
					_tmp37_ = master_point;
					bird_font_edit_point_convert_to_curve (_tmp37_);
					_tmp38_ = master_point;
					_tmp39_ = bird_font_edit_point_get_right_handle (_tmp38_);
					_tmp39_->angle = angle;
					distance_to_edge += 0.1;
					_tmp40_ = master_point;
					_tmp41_ = master_point;
					distance = bird_font_path_distance (x, _tmp40_->x, y, _tmp41_->y);
					if (distance < min_distance) {
						min_distance = distance;
						close_x = x;
						close_y = y;
					}
					if (distance_to_edge > ((gdouble) 5)) {
						break;
					}
				}
				_tmp42_ = master_point;
				_tmp43_ = bird_font_color_blue ();
				_bird_font_color_unref0 (_tmp42_->color);
				_tmp42_->color = _tmp43_;
				x = close_x;
				y = close_x;
				_tmp44_ = ep;
				_tmp45_ = ep;
				_tmp46_ = ep;
				_tmp45_->x = _tmp45_->x + ((close_x - _tmp46_->x) * direction);
				_tmp47_ = ep;
				_tmp48_ = ep;
				_tmp49_ = ep;
				_tmp48_->y = _tmp48_->y + ((close_y - _tmp49_->y) * direction);
			}
		}
	}
	_tmp50_ = p;
	bird_font_path_adjust_interpolated_handles (_tmp50_, master, fabs ((5 / 2.0) * weight));
	result = p;
	_g_object_unref0 (master_point);
	_g_object_unref0 (ep);
	return result;
}

BirdFontPath*
bird_font_path_get_self_interpolated_master (BirdFontPath* self,
                                             gboolean counter,
                                             gdouble weight)
{
	BirdFontPath* _tmp0_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_stroke_tool_change_weight (self, counter, weight);
	result = _tmp0_;
	return result;
}

static void
bird_font_path_adjust_interpolated_handles (BirdFontPath* self,
                                            BirdFontPath* master,
                                            gdouble edge)
{
	BirdFontEditPoint* ep = NULL;
	BirdFontEditPoint* next = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (master != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp2_;
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gpointer _tmp15_;
				BirdFontEditPoint* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = bird_font_path_get_points (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = bird_font_path_get_points (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, i);
				_g_object_unref0 (ep);
				ep = (BirdFontEditPoint*) _tmp8_;
				_tmp9_ = bird_font_path_get_points (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = bird_font_path_get_points (self);
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i % _tmp14_);
				_g_object_unref0 (next);
				next = (BirdFontEditPoint*) _tmp15_;
				_tmp16_ = ep;
				_tmp17_ = next;
				bird_font_path_adjust_interpolated_handle (self, master, _tmp16_, _tmp17_, edge);
			}
		}
	}
	_g_object_unref0 (next);
	_g_object_unref0 (ep);
}

static void
bird_font_path_adjust_interpolated_handle (BirdFontPath* self,
                                           BirdFontPath* master,
                                           BirdFontEditPoint* ep,
                                           BirdFontEditPoint* next,
                                           gdouble edge)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble next_length_adjustment = 0.0;
	gdouble prev_length_adjustment_reverse = 0.0;
	gdouble min_distortion = 0.0;
	BirdFontEditPoint* master_point = NULL;
	BirdFontEditPoint* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	BirdFontEditPoint* _tmp3_;
	gdouble tolerance = 0.0;
	gdouble start_length = 0.0;
	BirdFontEditPointHandle* _tmp4_;
	gdouble stop_length = 0.0;
	BirdFontEditPointHandle* _tmp5_;
	BirdFontEditPoint* ep1 = NULL;
	BirdFontEditPoint* ep2 = NULL;
	BirdFontEditPoint* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	gdouble total_distance = 0.0;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPoint* _tmp9_;
	BirdFontEditPoint* _tmp10_;
	BirdFontEditPoint* _tmp11_;
	BirdFontEditPointHandle* _tmp28_;
	BirdFontEditPointHandle* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (master != NULL);
	g_return_if_fail (ep != NULL);
	g_return_if_fail (next != NULL);
	next_length_adjustment = (gdouble) 0;
	prev_length_adjustment_reverse = (gdouble) 0;
	min_distortion = DBL_MAX;
	_tmp0_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	master_point = _tmp0_;
	bird_font_path_get_point_for_step (ep, next, 0.55, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = master_point;
	bird_font_path_get_closest_point_on_path (master, _tmp3_, x, y, NULL, NULL, -1);
	tolerance = 0.01;
	_tmp4_ = bird_font_edit_point_get_right_handle (ep);
	start_length = _tmp4_->length;
	_tmp5_ = bird_font_edit_point_get_left_handle (next);
	stop_length = _tmp5_->length;
	_tmp6_ = bird_font_edit_point_copy (ep);
	_g_object_unref0 (ep1);
	ep1 = _tmp6_;
	_tmp7_ = bird_font_edit_point_copy (next);
	_g_object_unref0 (ep2);
	ep2 = _tmp7_;
	_tmp8_ = ep1;
	_tmp9_ = ep2;
	_tmp10_ = ep1;
	_tmp11_ = ep2;
	total_distance = bird_font_path_distance (_tmp8_->x, _tmp9_->x, _tmp10_->y, _tmp11_->y);
	{
		gdouble m = 0.0;
		m = 50.0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gdouble step = 0.0;
				gdouble _tmp13_ = 0.0;
				gdouble first = 0.0;
				if (!_tmp12_) {
					m /= 10.0;
				}
				_tmp12_ = FALSE;
				if (!(m >= (tolerance / 2.0))) {
					break;
				}
				step = m / 10.0;
				min_distortion = DBL_MAX;
				if (m == 50.0) {
					_tmp13_ = (gdouble) 0;
				} else {
					_tmp13_ = -m;
				}
				first = _tmp13_;
				{
					gdouble a = 0.0;
					a = first;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							if (!_tmp14_) {
								a += step;
							}
							_tmp14_ = FALSE;
							if (!(a < m)) {
								break;
							}
							{
								gdouble b = 0.0;
								b = first;
								{
									gboolean _tmp15_ = FALSE;
									_tmp15_ = TRUE;
									while (TRUE) {
										BirdFontEditPoint* _tmp16_;
										BirdFontEditPointHandle* _tmp17_;
										BirdFontEditPoint* _tmp18_;
										BirdFontEditPointHandle* _tmp19_;
										BirdFontEditPoint* _tmp20_;
										BirdFontEditPoint* _tmp21_;
										gdouble _tmp22_ = 0.0;
										gdouble _tmp23_ = 0.0;
										gdouble _error_ = 0.0;
										BirdFontEditPoint* _tmp24_;
										BirdFontEditPoint* _tmp25_;
										gboolean _tmp26_ = FALSE;
										gboolean _tmp27_ = FALSE;
										if (!_tmp15_) {
											b += step;
										}
										_tmp15_ = FALSE;
										if (!(b < m)) {
											break;
										}
										if ((((start_length + a) + stop_length) + b) > total_distance) {
											break;
										}
										_tmp16_ = ep1;
										_tmp17_ = bird_font_edit_point_get_right_handle (_tmp16_);
										_tmp17_->length = start_length + a;
										_tmp18_ = ep2;
										_tmp19_ = bird_font_edit_point_get_left_handle (_tmp18_);
										_tmp19_->length = stop_length + b;
										_tmp20_ = ep1;
										_tmp21_ = ep2;
										bird_font_path_get_point_for_step (_tmp20_, _tmp21_, 0.55, &_tmp22_, &_tmp23_);
										x = _tmp22_;
										y = _tmp23_;
										_tmp24_ = master_point;
										_tmp25_ = master_point;
										_error_ = bird_font_path_distance (_tmp24_->x, x, _tmp25_->y, y);
										_error_ = fabs (_error_ - edge);
										if (_error_ < min_distortion) {
											_tmp27_ = (start_length + a) > ((gdouble) 0);
										} else {
											_tmp27_ = FALSE;
										}
										if (_tmp27_) {
											_tmp26_ = (stop_length + b) > ((gdouble) 0);
										} else {
											_tmp26_ = FALSE;
										}
										if (_tmp26_) {
											min_distortion = _error_;
											prev_length_adjustment_reverse = a;
											next_length_adjustment = b;
										}
									}
								}
							}
						}
					}
				}
				start_length += prev_length_adjustment_reverse;
				stop_length += next_length_adjustment;
			}
		}
	}
	_tmp28_ = bird_font_edit_point_get_right_handle (ep);
	_tmp28_->length = start_length;
	_tmp29_ = bird_font_edit_point_get_right_handle (ep);
	if (_tmp29_->type != BIRD_FONT_POINT_TYPE_QUADRATIC) {
		BirdFontEditPointHandle* _tmp30_;
		_tmp30_ = bird_font_edit_point_get_left_handle (next);
		_tmp30_->length = stop_length;
	} else {
		BirdFontEditPointHandle* _tmp31_;
		BirdFontEditPointHandle* _tmp32_;
		gdouble _tmp33_;
		gdouble _tmp34_;
		BirdFontEditPointHandle* _tmp35_;
		gdouble _tmp36_;
		gdouble _tmp37_;
		_tmp31_ = bird_font_edit_point_get_left_handle (next);
		_tmp32_ = bird_font_edit_point_get_right_handle (ep);
		_tmp33_ = bird_font_edit_point_handle_get_x (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = bird_font_edit_point_get_right_handle (ep);
		_tmp36_ = bird_font_edit_point_handle_get_y (_tmp35_);
		_tmp37_ = _tmp36_;
		bird_font_edit_point_handle_move_to_coordinate (_tmp31_, _tmp34_, _tmp37_);
	}
	_g_object_unref0 (ep2);
	_g_object_unref0 (ep1);
	_g_object_unref0 (master_point);
}

GeeArrayList*
bird_font_path_get_points (BirdFontPath* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->control_points;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_EDIT_POINT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->control_points);
		self->control_points = _tmp1_;
		_tmp2_ = self->point_data;
		bird_font_bird_font_file_parse_path_data (_tmp2_, self);
		_tmp3_ = g_strdup ("");
		_g_free0 (self->point_data);
		self->point_data = _tmp3_;
	}
	_tmp4_ = self->control_points;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ARRAY_LIST, GeeArrayList);
	return result;
}

void
bird_font_path_set_points (BirdFontPath* self,
                           GeeArrayList* value)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->control_points);
	self->control_points = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, bird_font_path_properties[BIRD_FONT_PATH_POINTS_PROPERTY]);
}

gdouble
bird_font_path_get_stroke (BirdFontPath* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->path_stroke_width;
	return result;
}

void
bird_font_path_set_stroke (BirdFontPath* self,
                           gdouble value)
{
	gdouble _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if ((((gdouble) 0) < _tmp0_) && (_tmp0_ < 0.1)) {
		self->priv->path_stroke_width = 0.2;
	} else {
		self->priv->path_stroke_width = value;
	}
	g_object_notify_by_pspec ((GObject *) self, bird_font_path_properties[BIRD_FONT_PATH_STROKE_PROPERTY]);
}

gboolean
bird_font_path_get_fill_open_path (void)
{
	gboolean result;
	result = bird_font_path__fill_open_path;
	return result;
}

void
bird_font_path_set_fill_open_path (gboolean value)
{
	bird_font_path__fill_open_path = value;
}

static void
bird_font_path_class_init (BirdFontPathClass * klass,
                           gpointer klass_data)
{
	bird_font_path_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontPath_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_path_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_path_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_path_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_PATH_POINTS_PROPERTY, bird_font_path_properties[BIRD_FONT_PATH_POINTS_PROPERTY] = g_param_spec_object ("points", "points", "points", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Stroke width */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_PATH_STROKE_PROPERTY, bird_font_path_properties[BIRD_FONT_PATH_STROKE_PROPERTY] = g_param_spec_double ("stroke", "stroke", "stroke", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
bird_font_path_instance_init (BirdFontPath * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = bird_font_path_get_instance_private (self);
	self->control_points = NULL;
	self->priv->last_point = NULL;
	self->xmax = BIRD_FONT_GLYPH_CANVAS_MIN;
	self->xmin = BIRD_FONT_GLYPH_CANVAS_MAX;
	self->ymax = BIRD_FONT_GLYPH_CANVAS_MIN;
	self->ymin = BIRD_FONT_GLYPH_CANVAS_MAX;
	self->priv->path_stroke_width = (gdouble) 0;
	self->line_cap = BIRD_FONT_LINE_CAP_BUTT;
	self->full_stroke = NULL;
	self->priv->fast_stroke = NULL;
	self->fill = FALSE;
	self->priv->edit = TRUE;
	self->priv->open = TRUE;
	self->direction_is_set = FALSE;
	self->priv->no_derived_direction = FALSE;
	self->priv->clockwise_direction = TRUE;
	self->rotation = (gdouble) 0;
	self->skew = (gdouble) 0;
	self->hide_end_handle = TRUE;
	self->highlight_last_segment = FALSE;
	_tmp0_ = g_strdup ("");
	self->point_data = _tmp0_;
	self->color = NULL;
	self->stroke_color = NULL;
	self->gradient = NULL;
}

static void
bird_font_path_finalize (GObject * obj)
{
	BirdFontPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_PATH, BirdFontPath);
	_g_object_unref0 (self->control_points);
	_g_object_unref0 (self->priv->last_point);
	_g_object_unref0 (self->full_stroke);
	_g_object_unref0 (self->priv->fast_stroke);
	_g_object_unref0 (self->priv->stroke_creator);
	_g_free0 (self->point_data);
	_bird_font_color_unref0 (self->color);
	_bird_font_color_unref0 (self->stroke_color);
	_g_object_unref0 (self->gradient);
	G_OBJECT_CLASS (bird_font_path_parent_class)->finalize (obj);
}

static GType
bird_font_path_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontPathClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_path_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontPath), 0, (GInstanceInitFunc) bird_font_path_instance_init, NULL };
	GType bird_font_path_type_id;
	bird_font_path_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontPath", &g_define_type_info, 0);
	BirdFontPath_private_offset = g_type_add_instance_private (bird_font_path_type_id, sizeof (BirdFontPathPrivate));
	return bird_font_path_type_id;
}

GType
bird_font_path_get_type (void)
{
	static volatile gsize bird_font_path_type_id__once = 0;
	if (g_once_init_enter (&bird_font_path_type_id__once)) {
		GType bird_font_path_type_id;
		bird_font_path_type_id = bird_font_path_get_type_once ();
		g_once_init_leave (&bird_font_path_type_id__once, bird_font_path_type_id);
	}
	return bird_font_path_type_id__once;
}

static void
_vala_bird_font_path_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BirdFontPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_PATH, BirdFontPath);
	switch (property_id) {
		case BIRD_FONT_PATH_POINTS_PROPERTY:
		g_value_set_object (value, bird_font_path_get_points (self));
		break;
		case BIRD_FONT_PATH_STROKE_PROPERTY:
		g_value_set_double (value, bird_font_path_get_stroke (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_path_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BirdFontPath * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_PATH, BirdFontPath);
	switch (property_id) {
		case BIRD_FONT_PATH_POINTS_PROPERTY:
		bird_font_path_set_points (self, g_value_get_object (value));
		break;
		case BIRD_FONT_PATH_STROKE_PROPERTY:
		bird_font_path_set_stroke (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

