/* Overview.c generated by valac 0.56.16, the Vala compiler
 * generated from Overview.vala, do not modify */

/*
Copyright (C) 2012 - 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define BIRD_FONT_OVERVIEW_UCD_LINE_HEIGHT (17 * 1.3)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_OVERVIEW_0_PROPERTY,
	BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY,
	BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY,
	BIRD_FONT_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* bird_font_overview_properties[BIRD_FONT_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _bird_font_overview_overview_undo_item_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_overview_overview_undo_item_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _BirdFontOverviewParamSpecOverviewUndoItem BirdFontOverviewParamSpecOverviewUndoItem;
enum  {
	BIRD_FONT_OVERVIEW_OPEN_NEW_GLYPH_SIGNAL_SIGNAL,
	BIRD_FONT_OVERVIEW_OPEN_GLYPH_SIGNAL_SIGNAL,
	BIRD_FONT_OVERVIEW_NUM_SIGNALS
};
static guint bird_font_overview_signals[BIRD_FONT_OVERVIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontOverviewPrivate {
	gint selected;
	gint first_visible;
	gint rows;
	gint items_per_row;
	gdouble view_offset_y;
	gdouble view_offset_x;
	BirdFontGlyphRange* _glyph_range;
	gchar* search_query;
	gboolean _all_available;
	BirdFontCharacterInfo* character_info;
	gdouble scroll_size;
	gboolean update_scheduled;
};

struct _BirdFontOverviewParamSpecOverviewUndoItem {
	GParamSpec parent_instance;
};

static gint BirdFontOverview_private_offset;
static gpointer bird_font_overview_parent_class = NULL;
static gpointer bird_font_overview_overview_undo_item_parent_class = NULL;

static void ___lambda342_ (BirdFontOverview* self,
                    BirdFontGlyphCollection* glyph_collection);
static void ____lambda342__bird_font_overview_open_glyph_signal (BirdFontOverview* _sender,
                                                          BirdFontGlyphCollection* c,
                                                          gpointer self);
static void ___lambda343_ (BirdFontOverview* self,
                    gunichar character);
static void ____lambda343__bird_font_overview_open_new_glyph_signal (BirdFontOverview* _sender,
                                                              gunichar c,
                                                              gpointer self);
static gboolean ___lambda344_ (BirdFontOverview* self);
static gboolean ____lambda344__gsource_func (gpointer self);
static void __lambda228_ (const gchar* text);
static void ___lambda228__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda229_ (void);
static void ___lambda229__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static gboolean bird_font_overview_real_has_scrollbar (BirdFontFontDisplay* base);
static gboolean bird_font_overview_at_bottom (BirdFontOverview* self);
static void bird_font_overview_real_scroll_wheel (BirdFontFontDisplay* base,
                                           gdouble x,
                                           gdouble y,
                                           gdouble dx,
                                           gdouble dy);
static void bird_font_overview_real_selected_canvas (BirdFontFontDisplay* base);
static BirdFontOverviewItem* bird_font_overview_get_selected_item (BirdFontOverview* self);
static void bird_font_overview_real_zoom_min (BirdFontFontDisplay* base);
static void bird_font_overview_real_reset_zoom (BirdFontFontDisplay* base);
static void bird_font_overview_real_zoom_max (BirdFontFontDisplay* base);
static void bird_font_overview_real_zoom_in (BirdFontFontDisplay* base);
static void bird_font_overview_real_zoom_out (BirdFontFontDisplay* base);
static void bird_font_overview_real_store_current_view (BirdFontFontDisplay* base);
static void bird_font_overview_real_restore_last_view (BirdFontFontDisplay* base);
static void bird_font_overview_real_next_view (BirdFontFontDisplay* base);
static gchar* bird_font_overview_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_overview_real_get_name (BirdFontFontDisplay* base);
static gint bird_font_overview_get_items_per_row (BirdFontOverview* self);
static void bird_font_overview_real_draw (BirdFontFontDisplay* base,
                                   BirdFontWidgetAllocation* allocation,
                                   cairo_t* cr);
static void bird_font_overview_draw_empty_canvas (BirdFontOverview* self,
                                           BirdFontWidgetAllocation* allocation,
                                           cairo_t* cr);
static void bird_font_overview_draw_character_info (BirdFontOverview* self,
                                             cairo_t* cr);
static void bird_font_overview_scroll (BirdFontOverview* self,
                                gdouble pixel_adjustment);
static void bird_font_overview_scroll_to_position (BirdFontOverview* self,
                                            gint64 r);
static void bird_font_overview_real_scroll_to (BirdFontFontDisplay* base,
                                        gdouble position);
static gboolean bird_font_overview_last_row (BirdFontOverview* self);
static void bird_font_overview_real_key_press (BirdFontFontDisplay* base,
                                        guint keyval);
static void bird_font_overview_real_undo (BirdFontFontDisplay* base);
static void bird_font_overview_real_redo (BirdFontFontDisplay* base);
static gboolean bird_font_overview_select_visible_glyph (BirdFontOverview* self,
                                                  const gchar* name);
VALA_EXTERN gboolean bird_font_is_modifier_key (guint i);
static void bird_font_overview_real_double_click (BirdFontFontDisplay* base,
                                           guint button,
                                           gdouble ex,
                                           gdouble ey);
static void bird_font_overview_real_button_press (BirdFontFontDisplay* base,
                                           guint button,
                                           gdouble x,
                                           gdouble y);
static void bird_font_overview_draw_info_line (BirdFontOverview* self,
                                        const gchar* line,
                                        cairo_t* cr,
                                        gdouble x,
                                        gdouble y,
                                        gint row);
static void bird_font_overview_draw_fallback_character (BirdFontOverview* self,
                                                 cairo_t* cr,
                                                 gdouble x,
                                                 gdouble y,
                                                 gdouble height);
static gint __lambda345_ (BirdFontOverview* self,
                   BirdFontGlyphCollection* a,
                   BirdFontGlyphCollection* b);
static gint ___lambda345__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gboolean bird_font_overview_real_needs_modifier (BirdFontFontDisplay* base);
static void bird_font_overview_overview_undo_item_finalize (BirdFontOverviewOverviewUndoItem * obj);
static GType bird_font_overview_overview_undo_item_get_type_once (void);
static void bird_font_overview_finalize (GObject * obj);
static GType bird_font_overview_get_type_once (void);
static void _vala_bird_font_overview_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_bird_font_overview_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_overview_get_instance_private (BirdFontOverview* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontOverview_private_offset);
}

static void
___lambda342_ (BirdFontOverview* self,
               BirdFontGlyphCollection* glyph_collection)
{
	BirdFontTabBar* tabs = NULL;
	BirdFontTabBar* _tmp0_;
	gchar* n = NULL;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean selected = FALSE;
	BirdFontTabBar* _tmp6_;
	const gchar* _tmp7_;
	BirdFontGlyphTab* glyph_tab = NULL;
	g_return_if_fail (glyph_collection != NULL);
	_tmp0_ = bird_font_main_window_get_tab_bar ();
	tabs = _tmp0_;
	_tmp1_ = bird_font_glyph_collection_get_current (glyph_collection);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->name;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	n = _tmp5_;
	_tmp6_ = tabs;
	_tmp7_ = n;
	selected = bird_font_tab_bar_select_char (_tmp6_, _tmp7_);
	if (!selected) {
		BirdFontGlyphTab* _tmp8_;
		BirdFontTabBar* _tmp9_;
		BirdFontGlyphTab* _tmp10_;
		_tmp8_ = bird_font_glyph_tab_new (glyph_collection);
		_g_object_unref0 (glyph_tab);
		glyph_tab = _tmp8_;
		_tmp9_ = tabs;
		_tmp10_ = glyph_tab;
		bird_font_tab_bar_add_tab (_tmp9_, (BirdFontFontDisplay*) _tmp10_, TRUE, glyph_collection);
		bird_font_overview_set_glyph_zoom (self, glyph_collection);
		bird_font_pen_tool_update_orientation ();
	}
	_g_object_unref0 (glyph_tab);
	_g_free0 (n);
	_g_object_unref0 (tabs);
}

static void
____lambda342__bird_font_overview_open_glyph_signal (BirdFontOverview* _sender,
                                                     BirdFontGlyphCollection* c,
                                                     gpointer self)
{
	___lambda342_ ((BirdFontOverview*) self, c);
}

static void
___lambda343_ (BirdFontOverview* self,
               gunichar character)
{
	gboolean _tmp0_ = FALSE;
	BirdFontGlyphCollection* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	if (character <= ((gunichar) 0x1F)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = character == ((gunichar) 0xFFFF);
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = bird_font_overview_create_new_glyph (self, character);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
____lambda343__bird_font_overview_open_new_glyph_signal (BirdFontOverview* _sender,
                                                         gunichar c,
                                                         gpointer self)
{
	___lambda343_ ((BirdFontOverview*) self, c);
}

static gboolean
___lambda344_ (BirdFontOverview* self)
{
	gboolean result;
	bird_font_overview_use_default_character_set (self);
	bird_font_font_display_selected_canvas ((BirdFontFontDisplay*) self);
	result = FALSE;
	return result;
}

static gboolean
____lambda344__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda344_ ((BirdFontOverview*) self);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

BirdFontOverview*
bird_font_overview_construct (GType object_type,
                              BirdFontGlyphRange* range,
                              gboolean open_selected,
                              gboolean default_character_set)
{
	BirdFontOverview * self = NULL;
	BirdFontGlyphRange* gr = NULL;
	gchar* zoom = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	self = (BirdFontOverview*) bird_font_font_display_construct (object_type);
	if (range == NULL) {
		BirdFontGlyphRange* _tmp0_;
		BirdFontGlyphRange* _tmp1_;
		_tmp0_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (gr);
		gr = _tmp0_;
		_tmp1_ = gr;
		bird_font_overview_set_current_glyph_range (self, _tmp1_);
	}
	if (open_selected) {
		g_signal_connect_object (self, "open-glyph-signal", (GCallback) ____lambda342__bird_font_overview_open_glyph_signal, self, 0);
		g_signal_connect_object (self, "open-new-glyph-signal", (GCallback) ____lambda343__bird_font_overview_open_new_glyph_signal, self, 0);
	}
	if (default_character_set) {
		GSource* idle = NULL;
		GSource* _tmp2_;
		GSource* _tmp3_;
		GSource* _tmp4_;
		_tmp2_ = g_idle_source_new ();
		idle = _tmp2_;
		_tmp3_ = idle;
		g_source_set_callback (_tmp3_, ____lambda344__gsource_func, g_object_ref (self), g_object_unref);
		_tmp4_ = idle;
		g_source_attach (_tmp4_, NULL);
		_g_source_unref0 (idle);
	}
	bird_font_overview_update_item_list (self);
	bird_font_overview_update_scrollbar (self);
	bird_font_font_display_reset_zoom ((BirdFontFontDisplay*) self);
	_tmp5_ = bird_font_preferences_get ("overview_zoom");
	zoom = _tmp5_;
	_tmp6_ = zoom;
	if (_tmp6_ != NULL) {
		gchar* z = NULL;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = zoom;
		_tmp8_ = g_strdup ((const gchar*) _tmp7_);
		z = _tmp8_;
		_tmp9_ = z;
		if (g_strcmp0 (_tmp9_, "") != 0) {
			const gchar* _tmp10_;
			_tmp10_ = z;
			bird_font_overview_set_zoom (self, double_parse (_tmp10_));
		}
		_g_free0 (z);
	}
	_g_free0 (zoom);
	_bird_font_glyph_range_unref0 (gr);
	return self;
}

BirdFontOverview*
bird_font_overview_new (BirdFontGlyphRange* range,
                        gboolean open_selected,
                        gboolean default_character_set)
{
	return bird_font_overview_construct (BIRD_FONT_TYPE_OVERVIEW, range, open_selected, default_character_set);
}

void
bird_font_overview_reset_cache (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp0_;
		gint _i_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _i_index = 0;
		_tmp0_ = self->visible_items;
		_i_list = _tmp0_;
		_tmp1_ = _i_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_i_size = _tmp3_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontOverviewItem* i = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontOverviewItem* _tmp8_;
			_i_index = _i_index + 1;
			_tmp4_ = _i_index;
			_tmp5_ = _i_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _i_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _i_index);
			i = (BirdFontOverviewItem*) _tmp7_;
			_tmp8_ = i;
			bird_font_overview_item_clear_cache (_tmp8_);
			_g_object_unref0 (i);
		}
	}
}

BirdFontGlyph*
bird_font_overview_get_selected_glyph (BirdFontOverview* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	BirdFontGlyphCollection* _tmp5_;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->selected_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->selected_items;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	_tmp5_ = (BirdFontGlyphCollection*) _tmp4_;
	_tmp6_ = bird_font_glyph_collection_get_current (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	result = _tmp7_;
	return result;
}

void
bird_font_overview_select_all_glyphs (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	BirdFontGlyphCollection* glyphs = NULL;
	BirdFontFont* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (f);
	f = _tmp0_;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				BirdFontFont* _tmp3_;
				BirdFontFont* _tmp4_;
				BirdFontGlyphCollection* _tmp5_;
				BirdFontGlyphCollection* _tmp6_;
				GeeArrayList* _tmp7_;
				BirdFontGlyphCollection* _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = f;
				if (!(((guint) index) < bird_font_font_length (_tmp3_))) {
					break;
				}
				_tmp4_ = f;
				_tmp5_ = bird_font_font_get_glyph_collection_index (_tmp4_, (gunichar) ((guint32) index));
				_g_object_unref0 (glyphs);
				glyphs = _tmp5_;
				_tmp6_ = glyphs;
				g_return_if_fail (_tmp6_ != NULL);
				_tmp7_ = self->selected_items;
				_tmp8_ = glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
		}
	}
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp9_;
		gint _item_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _item_index = 0;
		_tmp9_ = self->visible_items;
		_item_list = _tmp9_;
		_tmp10_ = _item_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_item_size = _tmp12_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			BirdFontOverviewItem* item = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			BirdFontOverviewItem* _tmp17_;
			BirdFontOverviewItem* _tmp18_;
			BirdFontGlyphCollection* _tmp19_;
			_item_index = _item_index + 1;
			_tmp13_ = _item_index;
			_tmp14_ = _item_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _item_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _item_index);
			item = (BirdFontOverviewItem*) _tmp16_;
			_tmp17_ = item;
			_tmp18_ = item;
			_tmp19_ = _tmp18_->glyphs;
			_tmp17_->selected = _tmp19_ != NULL;
			_g_object_unref0 (item);
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (glyphs);
	_g_object_unref0 (f);
}

void
bird_font_overview_use_default_character_set (BirdFontOverview* self)
{
	BirdFontGlyphRange* gr = NULL;
	BirdFontGlyphRange* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_range_new ();
	gr = _tmp0_;
	bird_font_overview_set_all_available (self, FALSE);
	bird_font_default_character_set_use_default_range (gr);
	bird_font_overview_set_current_glyph_range (self, gr);
	bird_font_overview_tools_update_overview_characterset (NULL);
	bird_font_font_display_dirty_scrollbar = TRUE;
	_bird_font_glyph_range_unref0 (gr);
}

BirdFontGlyphCollection*
bird_font_overview_create_new_glyph (BirdFontOverview* self,
                                     gunichar character)
{
	GString* name = NULL;
	GString* _tmp0_;
	BirdFontTabBar* tabs = NULL;
	BirdFontTabBar* _tmp1_;
	gboolean selected = FALSE;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	BirdFontGlyphCanvas* canvas = NULL;
	BirdFontGlyphTab* glyph_tab = NULL;
	BirdFontGlyphCollection* _tmp2_;
	GString* _tmp3_;
	BirdFontTabBar* _tmp4_;
	GString* _tmp5_;
	const gchar* _tmp6_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	_tmp1_ = bird_font_main_window_get_tab_bar ();
	tabs = _tmp1_;
	_tmp2_ = bird_font_main_window_get_current_glyph_collection ();
	_g_object_unref0 (glyph_collection);
	glyph_collection = _tmp2_;
	_tmp3_ = name;
	g_string_append_unichar (_tmp3_, character);
	_tmp4_ = tabs;
	_tmp5_ = name;
	_tmp6_ = _tmp5_->str;
	selected = bird_font_tab_bar_select_char (_tmp4_, _tmp6_);
	if (!selected) {
		BirdFontGlyphCollection* _tmp7_;
		BirdFontGlyphCollection* _tmp8_;
		BirdFontGlyphTab* _tmp9_;
		BirdFontGlyphCollection* _tmp10_;
		BirdFontGlyph* _tmp11_;
		BirdFontGlyph* _tmp12_;
		BirdFontLayer* _tmp13_;
		BirdFontLayer* _tmp14_;
		BirdFontLayer* _tmp15_;
		BirdFontTabBar* _tmp16_;
		BirdFontGlyphTab* _tmp17_;
		BirdFontGlyphCollection* _tmp18_;
		GeeArrayList* _tmp19_;
		BirdFontGlyphCollection* _tmp20_;
		BirdFontGlyphCanvas* _tmp21_;
		BirdFontGlyphCanvas* _tmp22_;
		BirdFontGlyphCollection* _tmp23_;
		BirdFontGlyphCollection* _tmp24_;
		_tmp7_ = bird_font_overview_add_character_to_font (self, character, FALSE, FALSE, "");
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp7_;
		_tmp8_ = glyph_collection;
		_tmp9_ = bird_font_glyph_tab_new (_tmp8_);
		_g_object_unref0 (glyph_tab);
		glyph_tab = _tmp9_;
		_tmp10_ = glyph_collection;
		_tmp11_ = bird_font_glyph_collection_get_current (_tmp10_);
		_g_object_unref0 (glyph);
		glyph = _tmp11_;
		_tmp12_ = glyph;
		_tmp13_ = _tmp12_->layers;
		_tmp14_ = bird_font_layer_new ();
		_tmp15_ = _tmp14_;
		bird_font_layer_add_layer (_tmp13_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		_tmp16_ = tabs;
		_tmp17_ = glyph_tab;
		_tmp18_ = glyph_collection;
		bird_font_tab_bar_add_tab (_tmp16_, (BirdFontFontDisplay*) _tmp17_, TRUE, _tmp18_);
		_tmp19_ = self->selected_items;
		_tmp20_ = glyph_collection;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
		_tmp21_ = bird_font_main_window_get_glyph_canvas ();
		_g_object_unref0 (canvas);
		canvas = _tmp21_;
		_tmp22_ = canvas;
		_tmp23_ = glyph_collection;
		bird_font_glyph_canvas_set_current_glyph_collection (_tmp22_, _tmp23_, TRUE);
		_tmp24_ = glyph_collection;
		bird_font_overview_set_glyph_zoom (self, _tmp24_);
	} else {
		g_warning ("Overview.vala:213: Glyph is already open");
	}
	bird_font_overview_tools_update_overview_characterset (NULL);
	result = glyph_collection;
	_g_object_unref0 (glyph_tab);
	_g_object_unref0 (canvas);
	_g_object_unref0 (glyph);
	_g_object_unref0 (tabs);
	_g_string_free0 (name);
	return result;
}

BirdFontGlyphCollection*
bird_font_overview_add_empty_character_to_font (BirdFontOverview* self,
                                                gunichar character,
                                                gboolean unassigned,
                                                const gchar* name)
{
	BirdFontGlyphCollection* _tmp0_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = bird_font_overview_add_character_to_font (self, character, TRUE, unassigned, "");
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontGlyphCollection*
bird_font_overview_add_character_to_font (BirdFontOverview* self,
                                          gunichar character,
                                          gboolean empty,
                                          gboolean unassigned,
                                          const gchar* glyph_name)
{
	GString* name = NULL;
	GString* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontGlyphCollection* fg = NULL;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphCollection* glyph_collection = NULL;
	gboolean _tmp4_;
	gboolean _tmp5_;
	BirdFontGlyphCollection* _tmp14_;
	BirdFontGlyphCollection* _tmp31_;
	BirdFontGlyphCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyph_name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	if (g_strcmp0 (glyph_name, "") == 0) {
		GString* _tmp2_;
		_tmp2_ = name;
		g_string_append_unichar (_tmp2_, character);
	} else {
		GString* _tmp3_;
		_tmp3_ = name;
		g_string_append (_tmp3_, glyph_name);
	}
	_tmp4_ = bird_font_overview_get_all_available (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		BirdFontFont* _tmp6_;
		GString* _tmp7_;
		const gchar* _tmp8_;
		BirdFontGlyphCollection* _tmp9_;
		_tmp6_ = font;
		_tmp7_ = name;
		_tmp8_ = _tmp7_->str;
		_tmp9_ = bird_font_font_get_glyph_collection_by_name (_tmp6_, _tmp8_);
		_g_object_unref0 (fg);
		fg = _tmp9_;
	} else {
		BirdFontFont* _tmp10_;
		GString* _tmp11_;
		const gchar* _tmp12_;
		BirdFontGlyphCollection* _tmp13_;
		_tmp10_ = font;
		_tmp11_ = name;
		_tmp12_ = _tmp11_->str;
		_tmp13_ = bird_font_font_get_glyph_collection (_tmp10_, _tmp12_);
		_g_object_unref0 (fg);
		fg = _tmp13_;
	}
	_tmp14_ = fg;
	if (_tmp14_ != NULL) {
		BirdFontGlyphCollection* _tmp15_;
		BirdFontGlyphCollection* _tmp16_;
		_tmp15_ = fg;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp16_;
	} else {
		GString* _tmp17_;
		const gchar* _tmp18_;
		BirdFontGlyphCollection* _tmp19_;
		BirdFontFont* _tmp29_;
		BirdFontGlyphCollection* _tmp30_;
		_tmp17_ = name;
		_tmp18_ = _tmp17_->str;
		_tmp19_ = bird_font_glyph_collection_new (character, _tmp18_);
		_g_object_unref0 (glyph_collection);
		glyph_collection = _tmp19_;
		if (!empty) {
			gunichar _tmp20_ = 0U;
			GString* _tmp21_;
			const gchar* _tmp22_;
			BirdFontGlyph* _tmp23_;
			BirdFontGlyphCollection* _tmp24_;
			BirdFontGlyphMaster* _tmp25_;
			BirdFontGlyphMaster* _tmp26_;
			BirdFontGlyphCollection* _tmp27_;
			BirdFontGlyph* _tmp28_;
			if (!unassigned) {
				_tmp20_ = character;
			} else {
				_tmp20_ = (gunichar) '\0';
			}
			_tmp21_ = name;
			_tmp22_ = _tmp21_->str;
			_tmp23_ = bird_font_glyph_new (_tmp22_, _tmp20_);
			_g_object_unref0 (glyph);
			glyph = _tmp23_;
			_tmp24_ = glyph_collection;
			_tmp25_ = bird_font_glyph_master_new ();
			_tmp26_ = _tmp25_;
			bird_font_glyph_collection_add_master (_tmp24_, _tmp26_);
			_g_object_unref0 (_tmp26_);
			_tmp27_ = glyph_collection;
			_tmp28_ = glyph;
			bird_font_glyph_collection_insert_glyph (_tmp27_, _tmp28_, TRUE);
		}
		_tmp29_ = font;
		_tmp30_ = glyph_collection;
		bird_font_font_add_glyph_collection (_tmp29_, _tmp30_);
	}
	_tmp31_ = glyph_collection;
	bird_font_glyph_collection_set_unassigned (_tmp31_, unassigned);
	result = glyph_collection;
	_g_object_unref0 (glyph);
	_g_object_unref0 (fg);
	_g_object_unref0 (font);
	_g_string_free0 (name);
	return result;
}

static void
__lambda228_ (const gchar* text)
{
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = bird_font_main_window_get_overview ();
	o = _tmp0_;
	_tmp1_ = g_strdup (text);
	_g_free0 (o->priv->search_query);
	o->priv->search_query = _tmp1_;
	_g_object_unref0 (o);
}

static void
___lambda228__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda228_ (text);
}

static void
__lambda229_ (void)
{
	BirdFontOverview* o = NULL;
	BirdFontOverview* _tmp0_;
	gchar* q = NULL;
	BirdFontOverview* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	BirdFontGlyphRange* r = NULL;
	const gchar* _tmp11_;
	BirdFontGlyphRange* _tmp12_;
	BirdFontOverview* _tmp13_;
	BirdFontTabBar* _tmp14_;
	BirdFontTabBar* _tmp15_;
	BirdFontTextListener* tl = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BirdFontOverview* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	BirdFontTextListener* _tmp22_;
	BirdFontTextListener* _tmp23_;
	_tmp0_ = bird_font_main_window_get_overview ();
	o = _tmp0_;
	_tmp1_ = o;
	_tmp2_ = _tmp1_->priv->search_query;
	_tmp3_ = g_strdup (_tmp2_);
	q = _tmp3_;
	_tmp4_ = q;
	if (g_strcmp0 (_tmp4_, "*") == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("star");
		_g_free0 (q);
		q = _tmp5_;
	}
	_tmp6_ = q;
	if (g_strcmp0 (_tmp6_, "?") == 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("question");
		_g_free0 (q);
		q = _tmp7_;
	}
	_tmp8_ = q;
	if (g_utf8_strlen (_tmp8_, (gssize) -1) > 1) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = q;
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
		_g_free0 (q);
		q = _tmp10_;
	}
	_tmp11_ = q;
	_tmp12_ = bird_font_char_database_search (_tmp11_);
	r = _tmp12_;
	_tmp13_ = o;
	bird_font_overview_set_current_glyph_range (_tmp13_, r);
	_tmp14_ = bird_font_main_window_get_tab_bar ();
	_tmp15_ = _tmp14_;
	bird_font_tab_bar_select_tab_name (_tmp15_, "Overview");
	_g_object_unref0 (_tmp15_);
	_tmp16_ = bird_font_t_ ("Search");
	_tmp17_ = _tmp16_;
	_tmp18_ = o;
	_tmp19_ = _tmp18_->priv->search_query;
	_tmp20_ = bird_font_t_ ("Filter");
	_tmp21_ = _tmp20_;
	_tmp22_ = bird_font_text_listener_new (_tmp17_, _tmp19_, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp17_);
	tl = _tmp23_;
	bird_font_tab_content_show_text_input (tl);
	_g_object_unref0 (tl);
	_bird_font_glyph_range_unref0 (r);
	_g_free0 (q);
	_g_object_unref0 (o);
}

static void
___lambda229__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda229_ ();
}

void
bird_font_overview_search (void)
{
	BirdFontOverview* ow = NULL;
	BirdFontOverview* _tmp0_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontTextListener* _tmp6_;
	BirdFontTextListener* _tmp7_;
	_tmp0_ = bird_font_main_window_get_overview ();
	ow = _tmp0_;
	_tmp1_ = bird_font_t_ ("Search");
	_tmp2_ = _tmp1_;
	_tmp3_ = ow->priv->search_query;
	_tmp4_ = bird_font_t_ ("Filter");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_text_listener_new (_tmp2_, _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	listener = _tmp7_;
	g_signal_connect (listener, "signal-text-input", (GCallback) ___lambda228__bird_font_text_listener_signal_text_input, NULL);
	g_signal_connect (listener, "signal-submit", (GCallback) ___lambda229__bird_font_text_listener_signal_submit, NULL);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	_g_object_unref0 (ow);
}

BirdFontGlyph*
bird_font_overview_get_current_glyph (BirdFontOverview* self)
{
	BirdFontOverviewItem* oi = NULL;
	BirdFontOverviewItem* _tmp0_;
	BirdFontOverviewItem* _tmp1_;
	BirdFontOverviewItem* _tmp2_;
	BirdFontGlyphCollection* _tmp3_;
	BirdFontGlyph* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->selected_item;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	oi = _tmp1_;
	_tmp2_ = oi;
	_tmp3_ = _tmp2_->glyphs;
	if (_tmp3_ != NULL) {
		BirdFontOverviewItem* _tmp4_;
		BirdFontGlyphCollection* _tmp5_;
		BirdFontGlyph* _tmp6_;
		_tmp4_ = oi;
		_tmp5_ = _tmp4_->glyphs;
		_tmp6_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		result = _tmp6_;
		_g_object_unref0 (oi);
		return result;
	}
	result = NULL;
	_g_object_unref0 (oi);
	return result;
}

void
bird_font_overview_set_glyph_zoom (BirdFontOverview* self,
                                   BirdFontGlyphCollection* glyphs)
{
	BirdFontGlyphCanvas* canvas = NULL;
	BirdFontGlyphCanvas* _tmp0_;
	BirdFontToolbox* tools = NULL;
	BirdFontToolbox* _tmp1_;
	BirdFontZoomTool* z = NULL;
	BirdFontTool* _tmp2_;
	BirdFontGlyph* _tmp3_;
	BirdFontGlyph* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyphs != NULL);
	_tmp0_ = bird_font_main_window_get_glyph_canvas ();
	_g_object_unref0 (canvas);
	canvas = _tmp0_;
	bird_font_glyph_canvas_set_current_glyph_collection (canvas, glyphs, TRUE);
	_tmp1_ = bird_font_main_window_get_toolbox ();
	tools = _tmp1_;
	_tmp2_ = bird_font_toolbox_get_tool (tools, "zoom_tool");
	z = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_ZOOM_TOOL, BirdFontZoomTool);
	bird_font_zoom_tool_store_current_view (z);
	_tmp3_ = bird_font_glyph_collection_get_current (glyphs);
	_tmp4_ = _tmp3_;
	bird_font_glyph_default_zoom (_tmp4_);
	_g_object_unref0 (_tmp4_);
	bird_font_zoom_tool_store_current_view (z);
	bird_font_overview_item_reset_label ();
	_g_object_unref0 (z);
	_g_object_unref0 (tools);
	_g_object_unref0 (canvas);
}

gdouble
bird_font_overview_get_height (BirdFontOverview* self)
{
	gdouble l = 0.0;
	BirdFontFont* f = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (self->priv->rows == 0) {
		result = (gdouble) 0;
		_g_object_unref0 (f);
		return result;
	}
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		l = (gdouble) bird_font_font_length (_tmp3_);
	} else {
		BirdFontGlyphRange* _tmp4_;
		BirdFontGlyphRange* _tmp5_;
		_tmp4_ = bird_font_overview_get_glyph_range (self);
		_tmp5_ = _tmp4_;
		l = (gdouble) bird_font_glyph_range_length (_tmp5_);
	}
	result = (2.0 * bird_font_overview_item_height) * (l / self->priv->rows);
	_g_object_unref0 (f);
	return result;
}

gboolean
bird_font_overview_selected_char_is_visible (BirdFontOverview* self)
{
	gint _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->selected;
	result = (self->priv->first_visible <= _tmp0_) && (_tmp0_ <= (self->priv->first_visible + (self->priv->items_per_row * self->priv->rows)));
	return result;
}

static gboolean
bird_font_overview_real_has_scrollbar (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	gboolean result;
	self = (BirdFontOverview*) base;
	result = TRUE;
	return result;
}

gboolean
bird_font_overview_all_characters_in_view (BirdFontOverview* self)
{
	gdouble length = 0.0;
	BirdFontFont* f = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		length = (gdouble) bird_font_font_length (_tmp3_);
	} else {
		BirdFontGlyphRange* _tmp4_;
		BirdFontGlyphRange* _tmp5_;
		_tmp4_ = bird_font_overview_get_glyph_range (self);
		_tmp5_ = _tmp4_;
		length = (gdouble) bird_font_glyph_range_length (_tmp5_);
	}
	result = length < ((gdouble) (self->priv->items_per_row * self->priv->rows));
	_g_object_unref0 (f);
	return result;
}

void
bird_font_overview_move_up (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
	self->priv->selected = self->priv->selected + self->priv->items_per_row;
	if (self->priv->first_visible < 0) {
		self->priv->selected = self->priv->selected - self->priv->items_per_row;
		self->priv->first_visible = 0;
		self->priv->view_offset_y = (gdouble) 0;
	}
}

void
bird_font_overview_move_down (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	if (!bird_font_overview_at_bottom (self)) {
		self->priv->first_visible = self->priv->first_visible + self->priv->items_per_row;
		self->priv->selected = self->priv->selected - self->priv->items_per_row;
	}
}

static void
bird_font_overview_real_scroll_wheel (BirdFontFontDisplay* base,
                                      gdouble x,
                                      gdouble y,
                                      gdouble dx,
                                      gdouble dy)
{
	BirdFontOverview * self;
	gdouble pixel_delta = 0.0;
	self = (BirdFontOverview*) base;
	pixel_delta = 3 * dy;
	if (dy > ((gdouble) 0)) {
		self->priv->view_offset_y = self->priv->view_offset_y + pixel_delta;
		while (TRUE) {
			if (!(self->priv->view_offset_y > ((gdouble) 0))) {
				break;
			}
			self->priv->view_offset_y = self->priv->view_offset_y - bird_font_overview_item_height;
			bird_font_overview_move_up (self);
		}
	} else {
		if (bird_font_overview_at_bottom (self)) {
			gboolean _tmp0_ = FALSE;
			if (self->priv->view_offset_y > (-2 * bird_font_overview_item_height)) {
				_tmp0_ = !bird_font_overview_all_characters_in_view (self);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				self->priv->view_offset_y = self->priv->view_offset_y + pixel_delta;
			}
		} else {
			self->priv->view_offset_y = self->priv->view_offset_y + pixel_delta;
			while (TRUE) {
				if (!(self->priv->view_offset_y < (-bird_font_overview_item_height))) {
					break;
				}
				self->priv->view_offset_y = self->priv->view_offset_y + bird_font_overview_item_height;
				bird_font_overview_move_down (self);
			}
		}
	}
	if (self->priv->view_offset_y < (-2 * bird_font_overview_item_height)) {
		self->priv->view_offset_y = -2 * bird_font_overview_item_height;
	}
	bird_font_overview_update_item_list (self);
	bird_font_overview_update_scrollbar (self);
	bird_font_overview_hide_menu (self);
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_overview_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	BirdFontOverviewItem* _tmp0_;
	self = (BirdFontOverview*) base;
	bird_font_overview_tools_update_overview_characterset (NULL);
	bird_font_key_bindings_set_require_modifier (TRUE);
	bird_font_overview_update_scrollbar (self);
	bird_font_overview_update_zoom_bar (self);
	bird_font_overview_item_glyph_scale = (gdouble) 1;
	bird_font_overview_update_item_list (self);
	_tmp0_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp0_;
	bird_font_glyph_canvas_redraw ();
}

void
bird_font_overview_update_zoom_bar (BirdFontOverview* self)
{
	gdouble z = 0.0;
	BirdFontOverviewTools* _tmp0_;
	BirdFontZoomBar* _tmp1_;
	g_return_if_fail (self != NULL);
	z = (bird_font_overview_item_width / bird_font_overview_item_DEFAULT_WIDTH) - 0.5;
	_tmp0_ = bird_font_toolbox_overview_tools;
	_tmp1_ = _tmp0_->zoom_bar;
	bird_font_zoom_bar_set_zoom (_tmp1_, z);
	bird_font_toolbox_redraw_tool_box ();
	bird_font_overview_update_item_list (self);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

void
bird_font_overview_set_zoom (BirdFontOverview* self,
                             gdouble zoom)
{
	gdouble z = 0.0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp2_;
	g_return_if_fail (self != NULL);
	z = zoom + 0.5;
	bird_font_overview_item_glyph_scale = (gdouble) 1;
	bird_font_overview_item_width = bird_font_overview_item_DEFAULT_WIDTH * z;
	bird_font_overview_item_height = bird_font_overview_item_DEFAULT_HEIGHT * z;
	bird_font_overview_item_margin = bird_font_overview_item_DEFAULT_MARGIN * z;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	_tmp0_ = double_to_string (zoom);
	_tmp1_ = _tmp0_;
	bird_font_preferences_set ("overview_zoom", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = bird_font_bird_font_get_current_font ();
	font = _tmp2_;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				BirdFontFont* _tmp5_;
				BirdFontGlyphCollection* glyphs = NULL;
				BirdFontFont* _tmp6_;
				BirdFontGlyphCollection* _tmp7_;
				BirdFontGlyphCollection* _tmp8_;
				BirdFontGlyphCollection* g = NULL;
				BirdFontGlyphCollection* _tmp9_;
				BirdFontGlyphCollection* _tmp10_;
				BirdFontGlyphCollection* _tmp11_;
				BirdFontGlyph* _tmp12_;
				BirdFontGlyph* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = index;
					index = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = font;
				if (!(((guint) index) < bird_font_font_length (_tmp5_))) {
					break;
				}
				_tmp6_ = font;
				_tmp7_ = bird_font_font_get_glyph_collection_index (_tmp6_, (gunichar) ((guint32) index));
				glyphs = _tmp7_;
				_tmp8_ = glyphs;
				g_return_if_fail (_tmp8_ != NULL);
				_tmp9_ = glyphs;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
				g = _tmp10_;
				_tmp11_ = g;
				_tmp12_ = bird_font_glyph_collection_get_current (_tmp11_);
				_tmp13_ = _tmp12_;
				_cairo_surface_destroy0 (_tmp13_->overview_thumbnail);
				_tmp13_->overview_thumbnail = NULL;
				_g_object_unref0 (_tmp13_);
				_g_object_unref0 (g);
				_g_object_unref0 (glyphs);
			}
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (font);
}

static void
bird_font_overview_real_zoom_min (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
	bird_font_overview_item_width = bird_font_overview_item_DEFAULT_WIDTH * 0.5;
	bird_font_overview_item_height = bird_font_overview_item_DEFAULT_HEIGHT * 0.5;
	bird_font_overview_item_margin = bird_font_overview_item_DEFAULT_MARGIN * 0.5;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	bird_font_glyph_canvas_redraw ();
	bird_font_overview_update_zoom_bar (self);
}

static void
bird_font_overview_real_reset_zoom (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
	bird_font_overview_item_width = bird_font_overview_item_DEFAULT_WIDTH;
	bird_font_overview_item_height = bird_font_overview_item_DEFAULT_HEIGHT;
	bird_font_overview_item_margin = bird_font_overview_item_DEFAULT_MARGIN;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	bird_font_glyph_canvas_redraw ();
	bird_font_overview_update_zoom_bar (self);
}

static void
bird_font_overview_real_zoom_max (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontOverview*) base;
	_tmp0_ = self->allocation;
	bird_font_overview_item_width = (gdouble) _tmp0_->width;
	_tmp1_ = self->allocation;
	bird_font_overview_item_height = (gdouble) _tmp1_->height;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_overview_real_zoom_in (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
	bird_font_overview_item_width = bird_font_overview_item_width * 1.1;
	bird_font_overview_item_height = bird_font_overview_item_height * 1.1;
	bird_font_overview_item_margin = bird_font_overview_item_margin * 1.1;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	bird_font_glyph_canvas_redraw ();
	bird_font_overview_update_zoom_bar (self);
}

static void
bird_font_overview_real_zoom_out (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
	bird_font_overview_item_width = bird_font_overview_item_width * 0.9;
	bird_font_overview_item_height = bird_font_overview_item_height * 0.9;
	bird_font_overview_item_margin = bird_font_overview_item_margin * 0.9;
	bird_font_overview_update_item_list (self);
	bird_font_overview_item_reset_label ();
	bird_font_glyph_canvas_redraw ();
	bird_font_overview_update_zoom_bar (self);
}

static void
bird_font_overview_real_store_current_view (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
}

static void
bird_font_overview_real_restore_last_view (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
}

static void
bird_font_overview_real_next_view (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	self = (BirdFontOverview*) base;
}

static gchar*
bird_font_overview_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontOverview*) base;
	_tmp0_ = bird_font_t_ ("Overview");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_overview_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontOverview*) base;
	_tmp0_ = g_strdup ("Overview");
	result = _tmp0_;
	return result;
}

void
bird_font_overview_display_all_available_glyphs (BirdFontOverview* self)
{
	BirdFontOverviewItem* _tmp0_;
	g_return_if_fail (self != NULL);
	bird_font_overview_set_all_available (self, TRUE);
	self->priv->view_offset_y = (gdouble) 0;
	self->priv->first_visible = 0;
	self->priv->selected = 0;
	bird_font_overview_update_item_list (self);
	_tmp0_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp0_;
	bird_font_glyph_canvas_redraw ();
}

static BirdFontOverviewItem*
bird_font_overview_get_selected_item (BirdFontOverview* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	BirdFontOverviewItem* item = NULL;
	GeeArrayList* _tmp10_;
	gpointer _tmp11_;
	BirdFontOverviewItem* _tmp12_;
	BirdFontOverviewItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->visible_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		BirdFontOverviewItem* _tmp3_;
		_tmp3_ = bird_font_overview_item_new ();
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->visible_items;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->selected;
	if (!((0 <= _tmp7_) && (_tmp7_ < _tmp6_))) {
		BirdFontOverviewItem* _tmp8_;
		BirdFontOverviewItem* _tmp9_;
		_tmp8_ = self->selected_item;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = self->visible_items;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, self->priv->selected);
	item = (BirdFontOverviewItem*) _tmp11_;
	_tmp12_ = item;
	_tmp12_->selected = TRUE;
	result = item;
	return result;
}

static gint
bird_font_overview_get_items_per_row (BirdFontOverview* self)
{
	gint i = 0;
	gdouble tab_with = 0.0;
	BirdFontWidgetAllocation* _tmp0_;
	gdouble l = 0.0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	i = 1;
	_tmp0_ = self->allocation;
	tab_with = (gdouble) (_tmp0_->width - 30);
	bird_font_overview_item_margin = bird_font_overview_item_width * 0.1;
	l = bird_font_overview_item_margin + bird_font_overview_item_full_width ();
	while (TRUE) {
		gint _tmp1_;
		if (!(l <= tab_with)) {
			break;
		}
		l += bird_font_overview_item_full_width ();
		_tmp1_ = i;
		i = _tmp1_ + 1;
	}
	result = i - 1;
	return result;
}

void
bird_font_overview_update_item_list (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	self->priv->update_scheduled = TRUE;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
bird_font_overview_process_item_list_update (BirdFontOverview* self)
{
	gchar* character_string = NULL;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphCollection* glyphs = NULL;
	guint32 index = 0U;
	BirdFontOverviewItem* item = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gunichar character = 0U;
	BirdFontGlyph* glyph = NULL;
	gdouble tab_with = 0.0;
	gint item_list_length = 0;
	gint visible_size = 0;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontWidgetAllocation* _tmp2_;
	GeeArrayList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GeeArrayList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gint selected_index = 0;
	gboolean selected_item = FALSE;
	gdouble full_width = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	glyphs = NULL;
	_tmp1_ = self->allocation;
	tab_with = (gdouble) (_tmp1_->width - 30);
	self->priv->items_per_row = bird_font_overview_get_items_per_row (self);
	_tmp2_ = self->allocation;
	self->priv->rows = ((gint) (_tmp2_->height / bird_font_overview_item_full_height ())) + 2;
	item_list_length = self->priv->items_per_row * self->priv->rows;
	_tmp3_ = self->visible_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	index = (guint32) self->priv->first_visible;
	x = bird_font_overview_item_margin;
	y = bird_font_overview_item_margin;
	_tmp4_ = bird_font_overview_get_all_available (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		guint font_length = 0U;
		BirdFontFont* _tmp6_;
		_tmp6_ = f;
		font_length = bird_font_font_length (_tmp6_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_ = FALSE;
					BirdFontFont* _tmp10_;
					BirdFontGlyphCollection* _tmp11_;
					BirdFontGlyphCollection* _tmp12_;
					BirdFontGlyphCollection* _tmp13_;
					BirdFontGlyph* _tmp14_;
					BirdFontGlyph* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					BirdFontGlyph* _tmp18_;
					BirdFontOverviewItem* _tmp19_;
					BirdFontOverviewItem* _tmp20_;
					BirdFontOverviewItem* _tmp21_;
					BirdFontGlyphCollection* _tmp22_;
					BirdFontOverviewItem* _tmp23_;
					BirdFontOverviewItem* _tmp24_;
					GeeArrayList* _tmp25_;
					BirdFontOverviewItem* _tmp26_;
					guint32 _tmp27_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = i;
						i = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					if (i < item_list_length) {
						_tmp9_ = index < ((guint32) font_length);
					} else {
						_tmp9_ = FALSE;
					}
					if (!_tmp9_) {
						break;
					}
					_tmp10_ = f;
					_tmp11_ = bird_font_font_get_glyph_collection_index (_tmp10_, (gunichar) ((guint32) index));
					_g_object_unref0 (glyphs);
					glyphs = _tmp11_;
					_tmp12_ = glyphs;
					g_return_if_fail (_tmp12_ != NULL);
					_tmp13_ = glyphs;
					_tmp14_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
					_g_object_unref0 (glyph);
					glyph = _tmp14_;
					_tmp15_ = glyph;
					_tmp16_ = _tmp15_->name;
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (character_string);
					character_string = _tmp17_;
					_tmp18_ = glyph;
					character = _tmp18_->unichar_code;
					_tmp19_ = bird_font_overview_item_new ();
					_g_object_unref0 (item);
					item = _tmp19_;
					_tmp20_ = item;
					bird_font_overview_item_set_character (_tmp20_, character);
					_tmp21_ = item;
					_tmp22_ = glyphs;
					bird_font_overview_item_set_glyphs (_tmp21_, _tmp22_);
					_tmp23_ = item;
					_tmp23_->x = x;
					_tmp24_ = item;
					_tmp24_->y = y;
					_tmp25_ = self->visible_items;
					_tmp26_ = item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
					_tmp27_ = index;
					index = _tmp27_ + 1;
				}
			}
		}
	} else {
		guint32 glyph_range_size = 0U;
		BirdFontGlyphRange* _tmp28_;
		BirdFontGlyphRange* _tmp29_;
		guint max_length = 0U;
		BirdFontGlyphRange* _tmp30_;
		BirdFontGlyphRange* _tmp31_;
		GeeArrayList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		GeeArrayList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		_tmp28_ = bird_font_overview_get_glyph_range (self);
		_tmp29_ = _tmp28_;
		glyph_range_size = bird_font_glyph_range_get_length (_tmp29_);
		_tmp30_ = bird_font_overview_get_glyph_range (self);
		_tmp31_ = _tmp30_;
		max_length = (guint) (bird_font_glyph_range_length (_tmp31_) - self->priv->first_visible);
		if (((guint) item_list_length) > max_length) {
			item_list_length = (gint) max_length;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp32_ = FALSE;
				_tmp32_ = TRUE;
				while (TRUE) {
					gboolean _tmp34_ = FALSE;
					BirdFontOverviewItem* _tmp35_;
					GeeArrayList* _tmp36_;
					BirdFontOverviewItem* _tmp37_;
					if (!_tmp32_) {
						gint _tmp33_;
						_tmp33_ = i;
						i = _tmp33_ + 1;
					}
					_tmp32_ = FALSE;
					if (i < item_list_length) {
						_tmp34_ = index < glyph_range_size;
					} else {
						_tmp34_ = FALSE;
					}
					if (!_tmp34_) {
						break;
					}
					_tmp35_ = bird_font_overview_item_new ();
					_g_object_unref0 (item);
					item = _tmp35_;
					_tmp36_ = self->visible_items;
					_tmp37_ = item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
				}
			}
		}
		index = (guint32) self->priv->first_visible;
		_tmp38_ = self->visible_items;
		_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		visible_size = _tmp40_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp41_ = FALSE;
				_tmp41_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp43_;
					gpointer _tmp44_;
					BirdFontGlyphRange* _tmp45_;
					BirdFontGlyphRange* _tmp46_;
					BirdFontOverviewItem* _tmp47_;
					guint32 _tmp48_;
					if (!_tmp41_) {
						gint _tmp42_;
						_tmp42_ = i;
						i = _tmp42_ + 1;
					}
					_tmp41_ = FALSE;
					if (!(i < visible_size)) {
						break;
					}
					_tmp43_ = self->visible_items;
					_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, i);
					_g_object_unref0 (item);
					item = (BirdFontOverviewItem*) _tmp44_;
					_tmp45_ = bird_font_overview_get_glyph_range (self);
					_tmp46_ = _tmp45_;
					character = bird_font_glyph_range_get_character (_tmp46_, (guint32) index);
					_tmp47_ = item;
					bird_font_overview_item_set_character (_tmp47_, character);
					_tmp48_ = index;
					index = _tmp48_ + 1;
				}
			}
		}
		_tmp49_ = self->visible_items;
		_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		visible_size = _tmp51_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp52_ = FALSE;
				_tmp52_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp54_;
					gpointer _tmp55_;
					BirdFontFont* _tmp56_;
					BirdFontOverviewItem* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					BirdFontGlyphCollection* _tmp60_;
					BirdFontOverviewItem* _tmp61_;
					BirdFontGlyphCollection* _tmp62_;
					if (!_tmp52_) {
						gint _tmp53_;
						_tmp53_ = i;
						i = _tmp53_ + 1;
					}
					_tmp52_ = FALSE;
					if (!(i < visible_size)) {
						break;
					}
					_tmp54_ = self->visible_items;
					_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, i);
					_g_object_unref0 (item);
					item = (BirdFontOverviewItem*) _tmp55_;
					_tmp56_ = f;
					_tmp57_ = item;
					_tmp58_ = g_unichar_to_string (_tmp57_->character);
					_tmp59_ = (gchar*) _tmp58_;
					_tmp60_ = bird_font_font_get_glyph_collection_by_name (_tmp56_, _tmp59_);
					_g_object_unref0 (glyphs);
					glyphs = _tmp60_;
					_g_free0 (_tmp59_);
					_tmp61_ = item;
					_tmp62_ = glyphs;
					bird_font_overview_item_set_glyphs (_tmp61_, _tmp62_);
				}
			}
		}
	}
	x = bird_font_overview_item_margin;
	y = bird_font_overview_item_margin;
	_tmp63_ = self->visible_items;
	_tmp64_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	visible_size = _tmp65_;
	full_width = bird_font_overview_item_full_width ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp66_ = FALSE;
			_tmp66_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp68_;
				gpointer _tmp69_;
				gboolean _tmp70_;
				gboolean _tmp71_;
				BirdFontGlyphCollection* _tmp79_;
				BirdFontOverviewItem* _tmp82_;
				BirdFontOverviewItem* _tmp83_;
				BirdFontOverviewItem* _tmp84_;
				if (!_tmp66_) {
					gint _tmp67_;
					_tmp67_ = i;
					i = _tmp67_ + 1;
				}
				_tmp66_ = FALSE;
				if (!(i < visible_size)) {
					break;
				}
				_tmp68_ = self->visible_items;
				_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, i);
				_g_object_unref0 (item);
				item = (BirdFontOverviewItem*) _tmp69_;
				selected_item = FALSE;
				_tmp70_ = bird_font_overview_get_all_available (self);
				_tmp71_ = _tmp70_;
				if (_tmp71_) {
					BirdFontFont* _tmp72_;
					BirdFontGlyphCollection* _tmp73_;
					_tmp72_ = f;
					_tmp73_ = bird_font_font_get_glyph_collection_index (_tmp72_, (gunichar) ((guint32) i));
					_g_object_unref0 (glyphs);
					glyphs = _tmp73_;
				} else {
					BirdFontFont* _tmp74_;
					BirdFontOverviewItem* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					BirdFontGlyphCollection* _tmp78_;
					_tmp74_ = f;
					_tmp75_ = item;
					_tmp76_ = g_unichar_to_string (_tmp75_->character);
					_tmp77_ = (gchar*) _tmp76_;
					_tmp78_ = bird_font_font_get_glyph_collection_by_name (_tmp74_, _tmp77_);
					_g_object_unref0 (glyphs);
					glyphs = _tmp78_;
					_g_free0 (_tmp77_);
				}
				_tmp79_ = glyphs;
				if (_tmp79_ != NULL) {
					GeeArrayList* _tmp80_;
					BirdFontGlyphCollection* _tmp81_;
					_tmp80_ = self->selected_items;
					_tmp81_ = glyphs;
					selected_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp80_, G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
					selected_item = selected_index != -1;
				}
				selected_item |= i == self->priv->selected;
				_tmp82_ = item;
				_tmp82_->selected = selected_item;
				_tmp83_ = item;
				_tmp83_->x = x + self->priv->view_offset_x;
				_tmp84_ = item;
				_tmp84_->y = y + self->priv->view_offset_y;
				x += full_width;
				if ((x + full_width) >= tab_with) {
					x = bird_font_overview_item_margin;
					y += bird_font_overview_item_full_height ();
				}
			}
		}
	}
	self->priv->update_scheduled = FALSE;
	_g_object_unref0 (glyph);
	_g_object_unref0 (item);
	_g_object_unref0 (glyphs);
	_g_object_unref0 (f);
	_g_free0 (character_string);
}

static void
bird_font_overview_real_draw (BirdFontFontDisplay* base,
                              BirdFontWidgetAllocation* allocation,
                              cairo_t* cr)
{
	BirdFontOverview * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	BirdFontWidgetAllocation* _tmp7_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	BirdFontCharacterInfo* _tmp20_;
	self = (BirdFontOverview*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	if (self->priv->update_scheduled) {
		_tmp2_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp3_;
		_tmp3_ = self->allocation;
		_tmp2_ = _tmp3_->width != allocation->width;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp4_;
		_tmp4_ = self->allocation;
		_tmp1_ = _tmp4_->height != allocation->height;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		BirdFontWidgetAllocation* _tmp5_;
		_tmp5_ = self->allocation;
		_tmp0_ = _tmp5_->width == 0;
	}
	if (_tmp0_) {
		BirdFontWidgetAllocation* _tmp6_;
		_tmp6_ = _g_object_ref0 (allocation);
		_g_object_unref0 (self->allocation);
		self->allocation = _tmp6_;
		bird_font_overview_process_item_list_update (self);
	}
	_tmp7_ = _g_object_ref0 (allocation);
	_g_object_unref0 (self->allocation);
	self->allocation = _tmp7_;
	cairo_save (cr);
	bird_font_theme_color (cr, "Background 1");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
	cairo_fill (cr);
	cairo_restore (cr);
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp8_;
		gint _i_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _i_index = 0;
		_tmp8_ = self->visible_items;
		_i_list = _tmp8_;
		_tmp9_ = _i_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_i_size = _tmp11_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontOverviewItem* i = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontOverviewItem* _tmp16_;
			_i_index = _i_index + 1;
			_tmp12_ = _i_index;
			_tmp13_ = _i_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _i_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _i_index);
			i = (BirdFontOverviewItem*) _tmp15_;
			_tmp16_ = i;
			bird_font_overview_item_draw (_tmp16_, allocation, cr);
			_g_object_unref0 (i);
		}
	}
	_tmp17_ = self->visible_items;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (G_UNLIKELY (_tmp19_ == 0)) {
		bird_font_overview_draw_empty_canvas (self, allocation, cr);
	}
	_tmp20_ = self->priv->character_info;
	if (G_UNLIKELY (_tmp20_ != NULL)) {
		bird_font_overview_draw_character_info (self, cr);
	}
}

static void
bird_font_overview_draw_empty_canvas (BirdFontOverview* self,
                                      BirdFontWidgetAllocation* allocation,
                                      cairo_t* cr)
{
	BirdFontText* t = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BirdFontText* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	_tmp0_ = bird_font_t_ ("No glyphs in this view.");
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_text_new (_tmp1_, (gdouble) 24, (gdouble) 0);
	_g_object_unref0 (t);
	t = _tmp2_;
	_g_free0 (_tmp1_);
	bird_font_theme_text_color (t, "Text Foreground");
	((BirdFontWidget*) t)->widget_x = (gdouble) 40;
	((BirdFontWidget*) t)->widget_y = (gdouble) 30;
	bird_font_widget_draw ((BirdFontWidget*) t, cr);
	cairo_restore (cr);
	_g_object_unref0 (t);
}

void
bird_font_overview_scroll_rows (BirdFontOverview* self,
                                gint row_adjustment)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < row_adjustment)) {
					break;
				}
				bird_font_overview_scroll (self, -bird_font_overview_item_height);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i > row_adjustment)) {
					break;
				}
				bird_font_overview_scroll (self, bird_font_overview_item_height);
			}
		}
	}
}

void
bird_font_overview_scroll_adjustment (BirdFontOverview* self,
                                      gdouble pixel_adjustment)
{
	gdouble l = 0.0;
	BirdFontFont* f = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		l = (gdouble) bird_font_font_length (_tmp3_);
	} else {
		BirdFontGlyphRange* _tmp4_;
		BirdFontGlyphRange* _tmp5_;
		_tmp4_ = bird_font_overview_get_glyph_range (self);
		_tmp5_ = _tmp4_;
		l = (gdouble) bird_font_glyph_range_length (_tmp5_);
	}
	if (self->priv->first_visible <= 0) {
		_g_object_unref0 (f);
		return;
	}
	if (((gdouble) (self->priv->first_visible + (self->priv->rows * self->priv->items_per_row))) >= l) {
		_g_object_unref0 (f);
		return;
	}
	bird_font_overview_scroll (self, (gdouble) ((gint64) pixel_adjustment));
	_g_object_unref0 (f);
}

static void
bird_font_overview_scroll_to_position (BirdFontOverview* self,
                                       gint64 r)
{
	g_return_if_fail (self != NULL);
	if (r < ((gint64) 0)) {
		bird_font_overview_scroll_top (self);
		return;
	}
	self->priv->selected = self->priv->selected - ((gint) (r - self->priv->first_visible));
	self->priv->first_visible = (gint) r;
	bird_font_overview_update_item_list (self);
}

static void
bird_font_overview_real_scroll_to (BirdFontFontDisplay* base,
                                   gdouble position)
{
	BirdFontOverview * self;
	gdouble r = 0.0;
	gint nrows = 0;
	BirdFontFont* f = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (BirdFontOverview*) base;
	_vala_return_if_fail (self->priv->items_per_row > 0, "items_per_row > 0");
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		nrows = (gint) (bird_font_font_length (_tmp3_) / self->priv->items_per_row);
	} else {
		BirdFontGlyphRange* _tmp4_;
		BirdFontGlyphRange* _tmp5_;
		_tmp4_ = bird_font_overview_get_glyph_range (self);
		_tmp5_ = _tmp4_;
		nrows = (gint) (bird_font_glyph_range_length (_tmp5_) / self->priv->items_per_row);
	}
	self->priv->view_offset_y = (gdouble) 0;
	r = (gdouble) ((gint64) (position * ((nrows - self->priv->rows) + 3)));
	r *= (gdouble) self->priv->items_per_row;
	bird_font_overview_scroll_to_position (self, (gint64) r);
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (f);
}

static void
bird_font_overview_scroll (BirdFontOverview* self,
                           gdouble pixel_adjustment)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->first_visible < 0) {
		_tmp0_ = pixel_adjustment < ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_overview_scroll_top (self);
		return;
	}
	self->priv->view_offset_y = self->priv->view_offset_y + pixel_adjustment;
	if (self->priv->view_offset_y >= ((gdouble) 0)) {
		while (TRUE) {
			if (!(self->priv->view_offset_y > bird_font_overview_item_height)) {
				break;
			}
			self->priv->view_offset_y = self->priv->view_offset_y - bird_font_overview_item_height;
			self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
		}
		self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
		self->priv->view_offset_y = self->priv->view_offset_y - bird_font_overview_item_height;
	} else {
		if (self->priv->view_offset_y < (-bird_font_overview_item_height)) {
			self->priv->view_offset_y = (gdouble) 0;
			self->priv->first_visible = self->priv->first_visible + self->priv->items_per_row;
		}
	}
	bird_font_overview_update_item_list (self);
}

void
bird_font_overview_scroll_top (BirdFontOverview* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->first_visible = 0;
	self->priv->view_offset_y = (gdouble) 0;
	bird_font_overview_update_item_list (self);
	_tmp0_ = self->visible_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		BirdFontOverviewItem* _tmp3_;
		_tmp3_ = bird_font_overview_get_selected_item (self);
		_g_object_unref0 (self->selected_item);
		self->selected_item = _tmp3_;
	}
}

/** Returns true if the selected glyph is at the last row. */
static gboolean
bird_font_overview_last_row (BirdFontOverview* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->visible_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (_tmp2_ - self->priv->selected) <= self->priv->items_per_row;
	return result;
}

void
bird_font_overview_key_down (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint64 len = 0LL;
	gboolean _tmp7_ = FALSE;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	BirdFontOverviewItem* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp2_ = bird_font_overview_get_all_available (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		BirdFontFont* _tmp4_;
		_tmp4_ = f;
		_tmp1_ = bird_font_font_length (_tmp4_);
	} else {
		BirdFontGlyphRange* _tmp5_;
		BirdFontGlyphRange* _tmp6_;
		_tmp5_ = bird_font_overview_get_glyph_range (self);
		_tmp6_ = _tmp5_;
		_tmp1_ = (guint) bird_font_glyph_range_length (_tmp6_);
	}
	len = (gint64) _tmp1_;
	if (bird_font_overview_at_bottom (self)) {
		_tmp7_ = bird_font_overview_last_row (self);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_g_object_unref0 (f);
		return;
	}
	self->priv->selected = self->priv->selected + self->priv->items_per_row;
	if (self->priv->selected >= (self->priv->items_per_row * self->priv->rows)) {
		self->priv->first_visible = self->priv->first_visible + self->priv->items_per_row;
		self->priv->selected = self->priv->selected - self->priv->items_per_row;
	}
	if (((gint64) (self->priv->first_visible + self->priv->selected)) >= len) {
		self->priv->selected = (gint) ((len - self->priv->first_visible) - 1);
		if (self->priv->selected < (self->priv->items_per_row * (self->priv->rows - 1))) {
			self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
			self->priv->selected = self->priv->selected + self->priv->items_per_row;
		}
	}
	_tmp8_ = self->visible_items;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (self->priv->selected >= _tmp10_) {
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = self->visible_items;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		self->priv->selected = (gint) (_tmp13_ - 1);
	}
	_tmp14_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp14_;
	bird_font_overview_update_item_list (self);
	_g_object_unref0 (f);
}

void
bird_font_overview_key_right (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint64 len = 0LL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	f = _tmp0_;
	_tmp2_ = bird_font_overview_get_all_available (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		BirdFontFont* _tmp4_;
		_tmp4_ = f;
		_tmp1_ = bird_font_font_length (_tmp4_);
	} else {
		BirdFontGlyphRange* _tmp5_;
		BirdFontGlyphRange* _tmp6_;
		_tmp5_ = bird_font_overview_get_glyph_range (self);
		_tmp6_ = _tmp5_;
		_tmp1_ = (guint) bird_font_glyph_range_length (_tmp6_);
	}
	len = (gint64) _tmp1_;
	if (bird_font_overview_at_bottom (self)) {
		_tmp7_ = ((gint64) ((self->priv->first_visible + self->priv->selected) + 1)) >= len;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		BirdFontOverviewItem* _tmp11_;
		_tmp8_ = self->visible_items;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		self->priv->selected = (gint) (_tmp10_ - 1);
		_tmp11_ = bird_font_overview_get_selected_item (self);
		_g_object_unref0 (self->selected_item);
		self->selected_item = _tmp11_;
		_g_object_unref0 (f);
		return;
	}
	self->priv->selected = self->priv->selected + 1;
	if (self->priv->selected >= (self->priv->items_per_row * self->priv->rows)) {
		self->priv->first_visible = self->priv->first_visible + self->priv->items_per_row;
		self->priv->selected = self->priv->selected - self->priv->items_per_row;
		self->priv->selected = self->priv->selected - 1;
	}
	if (((gint64) (self->priv->first_visible + self->priv->selected)) > len) {
		BirdFontOverviewItem* _tmp12_;
		self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
		self->priv->selected = (gint) ((len - self->priv->first_visible) - 1);
		_tmp12_ = bird_font_overview_get_selected_item (self);
		_g_object_unref0 (self->selected_item);
		self->selected_item = _tmp12_;
	}
	bird_font_overview_update_item_list (self);
	_g_object_unref0 (f);
}

void
bird_font_overview_key_up (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	self->priv->selected = self->priv->selected - self->priv->items_per_row;
	if (self->priv->selected < 0) {
		self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
		self->priv->selected = self->priv->selected + self->priv->items_per_row;
	}
	if (self->priv->first_visible < 0) {
		self->priv->first_visible = 0;
	}
	bird_font_overview_update_item_list (self);
}

void
bird_font_overview_key_left (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	self->priv->selected = self->priv->selected - 1;
	if (self->priv->selected < 0) {
		self->priv->first_visible = self->priv->first_visible - self->priv->items_per_row;
		self->priv->selected = self->priv->selected + self->priv->items_per_row;
		self->priv->selected = self->priv->selected + 1;
	}
	if (self->priv->first_visible < 0) {
		bird_font_overview_scroll_top (self);
	}
	bird_font_overview_update_item_list (self);
}

gchar*
bird_font_overview_get_selected_char (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	BirdFontGlyph* g = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	BirdFontGlyphRange* _tmp10_;
	BirdFontGlyphRange* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		BirdFontGlyph* _tmp4_;
		BirdFontGlyph* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		BirdFontGlyph* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		_tmp4_ = bird_font_font_get_glyph_index (_tmp3_, (gunichar) self->priv->selected);
		_g_object_unref0 (g);
		g = _tmp4_;
		_tmp5_ = g;
		_tmp6_ = g_strdup ("");
		_tmp7_ = _tmp6_;
		g_return_val_if_fail (_tmp5_ != NULL, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = g;
		_tmp9_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
		result = _tmp9_;
		_g_object_unref0 (g);
		_g_object_unref0 (f);
		return result;
	}
	_tmp10_ = bird_font_overview_get_glyph_range (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = bird_font_glyph_range_get_char (_tmp11_, (guint32) self->priv->selected);
	result = _tmp12_;
	_g_object_unref0 (g);
	_g_object_unref0 (f);
	return result;
}

static void
bird_font_overview_real_key_press (BirdFontFontDisplay* base,
                                   guint keyval)
{
	BirdFontOverview * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp61_ = FALSE;
	BirdFontOverviewItem* _tmp62_;
	GeeArrayList* _tmp63_;
	BirdFontOverviewItem* _tmp64_;
	BirdFontGlyphCollection* _tmp65_;
	self = (BirdFontOverview*) base;
	bird_font_overview_hide_menu (self);
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
	if (bird_font_key_bindings_has_ctrl ()) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = bird_font_key_bindings_has_logo ();
	}
	if (_tmp0_) {
		return;
	}
	switch (keyval) {
		case BIRD_FONT_KEY_ENTER:
		{
			bird_font_overview_open_current_glyph (self);
			return;
		}
		case BIRD_FONT_KEY_UP:
		{
			BirdFontOverviewItem* _tmp1_;
			BirdFontOverviewItem* _tmp2_;
			BirdFontOverviewItem* _tmp3_;
			GeeArrayList* _tmp4_;
			BirdFontOverviewItem* _tmp5_;
			BirdFontGlyphCollection* _tmp6_;
			_tmp1_ = bird_font_overview_get_selected_item (self);
			_tmp2_ = _tmp1_;
			_tmp2_->selected = FALSE;
			_g_object_unref0 (_tmp2_);
			bird_font_overview_key_up (self);
			_tmp3_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp3_;
			_tmp4_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp4_);
			_tmp5_ = self->selected_item;
			_tmp6_ = _tmp5_->glyphs;
			if (_tmp6_ != NULL) {
				GeeArrayList* _tmp7_;
				BirdFontOverviewItem* _tmp8_;
				BirdFontGlyphCollection* _tmp9_;
				_tmp7_ = self->selected_items;
				_tmp8_ = self->selected_item;
				_tmp9_ = _tmp8_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_RIGHT:
		{
			BirdFontOverviewItem* _tmp10_;
			BirdFontOverviewItem* _tmp11_;
			BirdFontOverviewItem* _tmp12_;
			GeeArrayList* _tmp13_;
			BirdFontOverviewItem* _tmp14_;
			BirdFontGlyphCollection* _tmp15_;
			_tmp10_ = bird_font_overview_get_selected_item (self);
			_tmp11_ = _tmp10_;
			_tmp11_->selected = FALSE;
			_g_object_unref0 (_tmp11_);
			bird_font_overview_key_right (self);
			_tmp12_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp12_;
			_tmp13_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
			_tmp14_ = self->selected_item;
			_tmp15_ = _tmp14_->glyphs;
			if (_tmp15_ != NULL) {
				GeeArrayList* _tmp16_;
				BirdFontOverviewItem* _tmp17_;
				BirdFontGlyphCollection* _tmp18_;
				_tmp16_ = self->selected_items;
				_tmp17_ = self->selected_item;
				_tmp18_ = _tmp17_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_LEFT:
		{
			BirdFontOverviewItem* _tmp19_;
			BirdFontOverviewItem* _tmp20_;
			BirdFontOverviewItem* _tmp21_;
			GeeArrayList* _tmp22_;
			BirdFontOverviewItem* _tmp23_;
			BirdFontGlyphCollection* _tmp24_;
			_tmp19_ = bird_font_overview_get_selected_item (self);
			_tmp20_ = _tmp19_;
			_tmp20_->selected = FALSE;
			_g_object_unref0 (_tmp20_);
			bird_font_overview_key_left (self);
			_tmp21_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp21_;
			_tmp22_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp22_);
			_tmp23_ = self->selected_item;
			_tmp24_ = _tmp23_->glyphs;
			if (_tmp24_ != NULL) {
				GeeArrayList* _tmp25_;
				BirdFontOverviewItem* _tmp26_;
				BirdFontGlyphCollection* _tmp27_;
				_tmp25_ = self->selected_items;
				_tmp26_ = self->selected_item;
				_tmp27_ = _tmp26_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_DOWN:
		{
			BirdFontOverviewItem* _tmp28_;
			BirdFontOverviewItem* _tmp29_;
			BirdFontOverviewItem* _tmp30_;
			GeeArrayList* _tmp31_;
			BirdFontOverviewItem* _tmp32_;
			BirdFontGlyphCollection* _tmp33_;
			_tmp28_ = bird_font_overview_get_selected_item (self);
			_tmp29_ = _tmp28_;
			_tmp29_->selected = FALSE;
			_g_object_unref0 (_tmp29_);
			bird_font_overview_key_down (self);
			_tmp30_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp30_;
			_tmp31_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp31_);
			_tmp32_ = self->selected_item;
			_tmp33_ = _tmp32_->glyphs;
			if (_tmp33_ != NULL) {
				GeeArrayList* _tmp34_;
				BirdFontOverviewItem* _tmp35_;
				BirdFontGlyphCollection* _tmp36_;
				_tmp34_ = self->selected_items;
				_tmp35_ = self->selected_item;
				_tmp36_ = _tmp35_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_PG_UP:
		{
			BirdFontOverviewItem* _tmp37_;
			BirdFontOverviewItem* _tmp38_;
			BirdFontOverviewItem* _tmp41_;
			GeeArrayList* _tmp42_;
			BirdFontOverviewItem* _tmp43_;
			BirdFontGlyphCollection* _tmp44_;
			_tmp37_ = bird_font_overview_get_selected_item (self);
			_tmp38_ = _tmp37_;
			_tmp38_->selected = FALSE;
			_g_object_unref0 (_tmp38_);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp39_ = FALSE;
					_tmp39_ = TRUE;
					while (TRUE) {
						if (!_tmp39_) {
							gint _tmp40_;
							_tmp40_ = i;
							i = _tmp40_ + 1;
						}
						_tmp39_ = FALSE;
						if (!(i < self->priv->rows)) {
							break;
						}
						bird_font_overview_key_up (self);
					}
				}
			}
			_tmp41_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp41_;
			_tmp42_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp42_);
			_tmp43_ = self->selected_item;
			_tmp44_ = _tmp43_->glyphs;
			if (_tmp44_ != NULL) {
				GeeArrayList* _tmp45_;
				BirdFontOverviewItem* _tmp46_;
				BirdFontGlyphCollection* _tmp47_;
				_tmp45_ = self->selected_items;
				_tmp46_ = self->selected_item;
				_tmp47_ = _tmp46_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_PG_DOWN:
		{
			BirdFontOverviewItem* _tmp48_;
			BirdFontOverviewItem* _tmp49_;
			BirdFontOverviewItem* _tmp52_;
			GeeArrayList* _tmp53_;
			BirdFontOverviewItem* _tmp54_;
			BirdFontGlyphCollection* _tmp55_;
			_tmp48_ = bird_font_overview_get_selected_item (self);
			_tmp49_ = _tmp48_;
			_tmp49_->selected = FALSE;
			_g_object_unref0 (_tmp49_);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp50_ = FALSE;
					_tmp50_ = TRUE;
					while (TRUE) {
						if (!_tmp50_) {
							gint _tmp51_;
							_tmp51_ = i;
							i = _tmp51_ + 1;
						}
						_tmp50_ = FALSE;
						if (!(i < self->priv->rows)) {
							break;
						}
						bird_font_overview_key_down (self);
					}
				}
			}
			_tmp52_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp52_;
			_tmp53_ = self->selected_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp53_);
			_tmp54_ = self->selected_item;
			_tmp55_ = _tmp54_->glyphs;
			if (_tmp55_ != NULL) {
				GeeArrayList* _tmp56_;
				BirdFontOverviewItem* _tmp57_;
				BirdFontGlyphCollection* _tmp58_;
				_tmp56_ = self->selected_items;
				_tmp57_ = self->selected_item;
				_tmp58_ = _tmp57_->glyphs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			}
			bird_font_overview_update_scrollbar (self);
			return;
		}
		case BIRD_FONT_KEY_DEL:
		{
			BirdFontOverviewItem* _tmp59_;
			bird_font_overview_delete_selected_glyph (self);
			_tmp59_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp59_;
			return;
		}
		case BIRD_FONT_KEY_BACK_SPACE:
		{
			BirdFontOverviewItem* _tmp60_;
			bird_font_overview_delete_selected_glyph (self);
			_tmp60_ = bird_font_overview_get_selected_item (self);
			_g_object_unref0 (self->selected_item);
			self->selected_item = _tmp60_;
			return;
		}
		default:
		break;
	}
	if (!bird_font_key_bindings_has_ctrl ()) {
		_tmp61_ = !bird_font_key_bindings_has_logo ();
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		bird_font_overview_scroll_to_char (self, (gunichar) keyval);
	}
	_tmp62_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp62_;
	_tmp63_ = self->selected_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp63_);
	_tmp64_ = self->selected_item;
	_tmp65_ = _tmp64_->glyphs;
	if (_tmp65_ != NULL) {
		GeeArrayList* _tmp66_;
		BirdFontOverviewItem* _tmp67_;
		BirdFontGlyphCollection* _tmp68_;
		_tmp66_ = self->selected_items;
		_tmp67_ = self->selected_item;
		_tmp68_ = _tmp67_->glyphs;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
	}
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
}

void
bird_font_overview_delete_selected_glyph (BirdFontOverview* self)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOverviewOverviewUndoItem* undo_item = NULL;
	BirdFontOverviewOverviewUndoItem* _tmp1_;
	BirdFontOverviewOverviewUndoItem* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontAlternateSets* _tmp4_;
	BirdFontAlternateSets* _tmp5_;
	BirdFontOverviewOverviewUndoItem* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_overview_overview_undo_item_new ();
	undo_item = _tmp1_;
	_tmp2_ = undo_item;
	_tmp3_ = font;
	_tmp4_ = _tmp3_->alternates;
	_tmp5_ = bird_font_alternate_sets_copy (_tmp4_);
	_g_object_unref0 (_tmp2_->alternate_sets);
	_tmp2_->alternate_sets = _tmp5_;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp6_;
		gint _g_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _g_index = 0;
		_tmp6_ = self->selected_items;
		_g_list = _tmp6_;
		_tmp7_ = _g_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_size = _tmp9_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontOverviewOverviewUndoItem* _tmp14_;
			GeeArrayList* _tmp15_;
			BirdFontGlyphCollection* _tmp16_;
			BirdFontGlyphCollection* _tmp17_;
			BirdFontGlyphCollection* _tmp18_;
			_g_index = _g_index + 1;
			_tmp10_ = _g_index;
			_tmp11_ = _g_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _g_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp13_;
			_tmp14_ = undo_item;
			_tmp15_ = _tmp14_->glyphs;
			_tmp16_ = g;
			_tmp17_ = bird_font_glyph_collection_copy (_tmp16_);
			_tmp18_ = _tmp17_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp18_);
			_g_object_unref0 (_tmp18_);
			_g_object_unref0 (g);
		}
	}
	_tmp19_ = undo_item;
	bird_font_overview_store_undo_items (self, _tmp19_);
	{
		GeeArrayList* _glyph_collection_list = NULL;
		GeeArrayList* _tmp20_;
		gint _glyph_collection_size = 0;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _glyph_collection_index = 0;
		_tmp20_ = self->selected_items;
		_glyph_collection_list = _tmp20_;
		_tmp21_ = _glyph_collection_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_glyph_collection_size = _tmp23_;
		_glyph_collection_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			BirdFontGlyphCollection* glyph_collection = NULL;
			GeeArrayList* _tmp26_;
			gpointer _tmp27_;
			BirdFontFont* _tmp28_;
			BirdFontGlyphCollection* _tmp29_;
			gchar* name = NULL;
			BirdFontGlyphCollection* _tmp30_;
			gchar* _tmp31_;
			BirdFontTabBar* _tmp32_;
			BirdFontTabBar* _tmp33_;
			const gchar* _tmp34_;
			_glyph_collection_index = _glyph_collection_index + 1;
			_tmp24_ = _glyph_collection_index;
			_tmp25_ = _glyph_collection_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _glyph_collection_list;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _glyph_collection_index);
			glyph_collection = (BirdFontGlyphCollection*) _tmp27_;
			_tmp28_ = font;
			_tmp29_ = glyph_collection;
			bird_font_font_delete_glyph (_tmp28_, _tmp29_);
			_tmp30_ = glyph_collection;
			_tmp31_ = bird_font_glyph_collection_get_name (_tmp30_);
			name = _tmp31_;
			_tmp32_ = bird_font_main_window_get_tab_bar ();
			_tmp33_ = _tmp32_;
			_tmp34_ = name;
			bird_font_tab_bar_close_background_tab_by_name (_tmp33_, _tmp34_);
			_g_object_unref0 (_tmp33_);
			_g_free0 (name);
			_g_object_unref0 (glyph_collection);
		}
	}
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
	_bird_font_overview_overview_undo_item_unref0 (undo_item);
	_g_object_unref0 (font);
}

static void
bird_font_overview_real_undo (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOverviewOverviewUndoItem* previous_collection = NULL;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gpointer _tmp8_;
	GeeArrayList* _tmp9_;
	BirdFontOverviewOverviewUndoItem* _tmp10_;
	BirdFontOverviewOverviewUndoItem* _tmp11_;
	BirdFontOverviewOverviewUndoItem* _tmp12_;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp44_;
	BirdFontFont* _tmp45_;
	BirdFontOverviewOverviewUndoItem* _tmp46_;
	BirdFontAlternateSets* _tmp47_;
	BirdFontAlternateSets* _tmp48_;
	GeeArrayList* _tmp49_;
	GeeArrayList* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gpointer _tmp53_;
	BirdFontOverviewOverviewUndoItem* _tmp54_;
	self = (BirdFontOverview*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = self->undo_items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_bird_font_overview_overview_undo_item_unref0 (previous_collection);
		_g_object_unref0 (font);
		return;
	}
	_tmp4_ = self->undo_items;
	_tmp5_ = self->undo_items;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp7_ - 1);
	_bird_font_overview_overview_undo_item_unref0 (previous_collection);
	previous_collection = (BirdFontOverviewOverviewUndoItem*) _tmp8_;
	_tmp9_ = self->redo_items;
	_tmp10_ = previous_collection;
	_tmp11_ = bird_font_overview_get_current_state (self, _tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
	_bird_font_overview_overview_undo_item_unref0 (_tmp12_);
	{
		GeeArrayList* _g_list = NULL;
		BirdFontOverviewOverviewUndoItem* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _g_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _g_index = 0;
		_tmp13_ = previous_collection;
		_tmp14_ = _tmp13_->glyphs;
		_g_list = _tmp14_;
		_tmp15_ = _g_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_size = _tmp17_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			BirdFontFont* _tmp22_;
			BirdFontGlyphCollection* _tmp23_;
			BirdFontGlyphCollection* _tmp24_;
			BirdFontTabBar* tabs = NULL;
			BirdFontTabBar* _tmp27_;
			BirdFontTab* tab = NULL;
			BirdFontTabBar* _tmp28_;
			BirdFontGlyphCollection* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			BirdFontTab* _tmp32_;
			BirdFontTab* _tmp33_;
			BirdFontTab* _tmp34_;
			_g_index = _g_index + 1;
			_tmp18_ = _g_index;
			_tmp19_ = _g_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _g_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp21_;
			_tmp22_ = font;
			_tmp23_ = g;
			bird_font_font_delete_glyph (_tmp22_, _tmp23_);
			_tmp24_ = g;
			if (bird_font_glyph_collection_length (_tmp24_) > ((guint) 0)) {
				BirdFontFont* _tmp25_;
				BirdFontGlyphCollection* _tmp26_;
				_tmp25_ = font;
				_tmp26_ = g;
				bird_font_font_add_glyph_collection (_tmp25_, _tmp26_);
			}
			_tmp27_ = bird_font_main_window_get_tab_bar ();
			tabs = _tmp27_;
			_tmp28_ = tabs;
			_tmp29_ = g;
			_tmp30_ = bird_font_glyph_collection_get_name (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = bird_font_tab_bar_get_tab (_tmp28_, _tmp31_);
			_tmp33_ = _tmp32_;
			_g_free0 (_tmp31_);
			tab = _tmp33_;
			_tmp34_ = tab;
			if (_tmp34_ != NULL) {
				BirdFontTab* t = NULL;
				BirdFontTab* _tmp35_;
				BirdFontTab* _tmp36_;
				BirdFontGlyphCollection* _tmp37_;
				BirdFontTab* _tmp38_;
				BirdFontGlyphCollection* _tmp39_;
				BirdFontTab* _tmp40_;
				BirdFontGlyphCollection* _tmp41_;
				BirdFontGlyphTab* _tmp42_;
				BirdFontGlyphTab* _tmp43_;
				_tmp35_ = tab;
				_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, BIRD_FONT_TYPE_TAB, BirdFontTab));
				t = _tmp36_;
				_tmp37_ = g;
				bird_font_overview_set_glyph_zoom (self, _tmp37_);
				_tmp38_ = t;
				_tmp39_ = g;
				bird_font_tab_set_glyph_collection (_tmp38_, _tmp39_);
				_tmp40_ = t;
				_tmp41_ = g;
				_tmp42_ = bird_font_glyph_tab_new (_tmp41_);
				_tmp43_ = _tmp42_;
				bird_font_tab_set_display (_tmp40_, (BirdFontFontDisplay*) _tmp43_);
				_g_object_unref0 (_tmp43_);
				_g_object_unref0 (t);
			}
			_g_object_unref0 (tab);
			_g_object_unref0 (tabs);
			_g_object_unref0 (g);
		}
	}
	_tmp44_ = bird_font_bird_font_get_current_font ();
	f = _tmp44_;
	_tmp45_ = f;
	_tmp46_ = previous_collection;
	_tmp47_ = _tmp46_->alternate_sets;
	_tmp48_ = bird_font_alternate_sets_copy (_tmp47_);
	_g_object_unref0 (_tmp45_->alternates);
	_tmp45_->alternates = _tmp48_;
	_tmp49_ = self->undo_items;
	_tmp50_ = self->undo_items;
	_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp49_, _tmp52_ - 1);
	_tmp54_ = (BirdFontOverviewOverviewUndoItem*) _tmp53_;
	_bird_font_overview_overview_undo_item_unref0 (_tmp54_);
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (f);
	_bird_font_overview_overview_undo_item_unref0 (previous_collection);
	_g_object_unref0 (font);
}

static void
bird_font_overview_real_redo (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontOverviewOverviewUndoItem* previous_collection = NULL;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gpointer _tmp8_;
	GeeArrayList* _tmp9_;
	BirdFontOverviewOverviewUndoItem* _tmp10_;
	BirdFontOverviewOverviewUndoItem* _tmp11_;
	BirdFontOverviewOverviewUndoItem* _tmp12_;
	BirdFontFont* _tmp43_;
	BirdFontOverviewOverviewUndoItem* _tmp44_;
	BirdFontAlternateSets* _tmp45_;
	BirdFontAlternateSets* _tmp46_;
	GeeArrayList* _tmp47_;
	GeeArrayList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gpointer _tmp51_;
	BirdFontOverviewOverviewUndoItem* _tmp52_;
	self = (BirdFontOverview*) base;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = self->redo_items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_bird_font_overview_overview_undo_item_unref0 (previous_collection);
		_g_object_unref0 (font);
		return;
	}
	_tmp4_ = self->redo_items;
	_tmp5_ = self->redo_items;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, _tmp7_ - 1);
	_bird_font_overview_overview_undo_item_unref0 (previous_collection);
	previous_collection = (BirdFontOverviewOverviewUndoItem*) _tmp8_;
	_tmp9_ = self->undo_items;
	_tmp10_ = previous_collection;
	_tmp11_ = bird_font_overview_get_current_state (self, _tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
	_bird_font_overview_overview_undo_item_unref0 (_tmp12_);
	{
		GeeArrayList* _g_list = NULL;
		BirdFontOverviewOverviewUndoItem* _tmp13_;
		GeeArrayList* _tmp14_;
		gint _g_size = 0;
		GeeArrayList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _g_index = 0;
		_tmp13_ = previous_collection;
		_tmp14_ = _tmp13_->glyphs;
		_g_list = _tmp14_;
		_tmp15_ = _g_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_size = _tmp17_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp20_;
			gpointer _tmp21_;
			BirdFontFont* _tmp22_;
			BirdFontGlyphCollection* _tmp23_;
			BirdFontFont* _tmp24_;
			BirdFontGlyphCollection* _tmp25_;
			BirdFontTabBar* tabs = NULL;
			BirdFontTabBar* _tmp26_;
			BirdFontTab* tab = NULL;
			BirdFontTabBar* _tmp27_;
			BirdFontGlyphCollection* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			BirdFontTab* _tmp31_;
			BirdFontTab* _tmp32_;
			BirdFontTab* _tmp33_;
			_g_index = _g_index + 1;
			_tmp18_ = _g_index;
			_tmp19_ = _g_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _g_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp21_;
			_tmp22_ = font;
			_tmp23_ = g;
			bird_font_font_delete_glyph (_tmp22_, _tmp23_);
			_tmp24_ = font;
			_tmp25_ = g;
			bird_font_font_add_glyph_collection (_tmp24_, _tmp25_);
			_tmp26_ = bird_font_main_window_get_tab_bar ();
			tabs = _tmp26_;
			_tmp27_ = tabs;
			_tmp28_ = g;
			_tmp29_ = bird_font_glyph_collection_get_name (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = bird_font_tab_bar_get_tab (_tmp27_, _tmp30_);
			_tmp32_ = _tmp31_;
			_g_free0 (_tmp30_);
			tab = _tmp32_;
			_tmp33_ = tab;
			if (_tmp33_ != NULL) {
				BirdFontTab* t = NULL;
				BirdFontTab* _tmp34_;
				BirdFontTab* _tmp35_;
				BirdFontGlyphCollection* _tmp36_;
				BirdFontTab* _tmp37_;
				BirdFontGlyphCollection* _tmp38_;
				BirdFontTab* _tmp39_;
				BirdFontGlyphCollection* _tmp40_;
				BirdFontGlyphTab* _tmp41_;
				BirdFontGlyphTab* _tmp42_;
				_tmp34_ = tab;
				_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_TAB, BirdFontTab));
				t = _tmp35_;
				_tmp36_ = g;
				bird_font_overview_set_glyph_zoom (self, _tmp36_);
				_tmp37_ = t;
				_tmp38_ = g;
				bird_font_tab_set_glyph_collection (_tmp37_, _tmp38_);
				_tmp39_ = t;
				_tmp40_ = g;
				_tmp41_ = bird_font_glyph_tab_new (_tmp40_);
				_tmp42_ = _tmp41_;
				bird_font_tab_set_display (_tmp39_, (BirdFontFontDisplay*) _tmp42_);
				_g_object_unref0 (_tmp42_);
				_g_object_unref0 (t);
			}
			_g_object_unref0 (tab);
			_g_object_unref0 (tabs);
			_g_object_unref0 (g);
		}
	}
	_tmp43_ = font;
	_tmp44_ = previous_collection;
	_tmp45_ = _tmp44_->alternate_sets;
	_tmp46_ = bird_font_alternate_sets_copy (_tmp45_);
	_g_object_unref0 (_tmp43_->alternates);
	_tmp43_->alternates = _tmp46_;
	_tmp47_ = self->redo_items;
	_tmp48_ = self->redo_items;
	_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp47_, _tmp50_ - 1);
	_tmp52_ = (BirdFontOverviewOverviewUndoItem*) _tmp51_;
	_bird_font_overview_overview_undo_item_unref0 (_tmp52_);
	bird_font_glyph_canvas_redraw ();
	_bird_font_overview_overview_undo_item_unref0 (previous_collection);
	_g_object_unref0 (font);
}

BirdFontOverviewOverviewUndoItem*
bird_font_overview_get_current_state (BirdFontOverview* self,
                                      BirdFontOverviewOverviewUndoItem* previous_collection)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontOverviewOverviewUndoItem* ui = NULL;
	BirdFontOverviewOverviewUndoItem* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontOverviewOverviewUndoItem* _tmp2_;
	BirdFontFont* _tmp3_;
	BirdFontAlternateSets* _tmp4_;
	BirdFontAlternateSets* _tmp5_;
	BirdFontOverviewOverviewUndoItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (previous_collection != NULL, NULL);
	_tmp0_ = bird_font_overview_overview_undo_item_new ();
	ui = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = ui;
	_tmp3_ = font;
	_tmp4_ = _tmp3_->alternates;
	_tmp5_ = bird_font_alternate_sets_copy (_tmp4_);
	_g_object_unref0 (_tmp2_->alternate_sets);
	_tmp2_->alternate_sets = _tmp5_;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp6_;
		gint _g_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _g_index = 0;
		_tmp6_ = previous_collection->glyphs;
		_g_list = _tmp6_;
		_tmp7_ = _g_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_size = _tmp9_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			BirdFontFont* _tmp14_;
			BirdFontGlyphCollection* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			BirdFontGlyphCollection* _tmp18_;
			BirdFontGlyphCollection* _tmp19_;
			_g_index = _g_index + 1;
			_tmp10_ = _g_index;
			_tmp11_ = _g_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _g_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp13_;
			_tmp14_ = font;
			_tmp15_ = g;
			_tmp16_ = bird_font_glyph_collection_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = bird_font_font_get_glyph_collection (_tmp14_, _tmp17_);
			_g_object_unref0 (gc);
			gc = _tmp18_;
			_g_free0 (_tmp17_);
			_tmp19_ = gc;
			if (_tmp19_ != NULL) {
				BirdFontOverviewOverviewUndoItem* _tmp20_;
				GeeArrayList* _tmp21_;
				BirdFontGlyphCollection* _tmp22_;
				BirdFontGlyphCollection* _tmp23_;
				BirdFontGlyphCollection* _tmp24_;
				_tmp20_ = ui;
				_tmp21_ = _tmp20_->glyphs;
				_tmp22_ = gc;
				_tmp23_ = bird_font_glyph_collection_copy (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
				_tmp24_ = _tmp23_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp24_);
				_g_object_unref0 (_tmp24_);
			} else {
				BirdFontOverviewOverviewUndoItem* _tmp25_;
				GeeArrayList* _tmp26_;
				BirdFontGlyphCollection* _tmp27_;
				BirdFontGlyphCollection* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				BirdFontGlyphCollection* _tmp31_;
				BirdFontGlyphCollection* _tmp32_;
				_tmp25_ = ui;
				_tmp26_ = _tmp25_->glyphs;
				_tmp27_ = g;
				_tmp28_ = g;
				_tmp29_ = bird_font_glyph_collection_get_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = bird_font_glyph_collection_new (bird_font_glyph_collection_get_unicode_character (_tmp27_), _tmp30_);
				_tmp32_ = _tmp31_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp32_);
				_g_object_unref0 (_tmp32_);
				_g_free0 (_tmp30_);
			}
			_g_object_unref0 (g);
		}
	}
	result = ui;
	_g_object_unref0 (font);
	_g_object_unref0 (gc);
	return result;
}

void
bird_font_overview_store_undo_state (BirdFontOverview* self,
                                     BirdFontGlyphCollection* gc)
{
	BirdFontOverviewOverviewUndoItem* i = NULL;
	BirdFontOverviewOverviewUndoItem* _tmp0_;
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp1_;
	BirdFontAlternateSets* _tmp2_;
	BirdFontAlternateSets* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gc != NULL);
	_tmp0_ = bird_font_overview_overview_undo_item_new ();
	i = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	f = _tmp1_;
	_tmp2_ = f->alternates;
	_tmp3_ = bird_font_alternate_sets_copy (_tmp2_);
	_g_object_unref0 (i->alternate_sets);
	i->alternate_sets = _tmp3_;
	_tmp4_ = i->glyphs;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, gc);
	bird_font_overview_store_undo_items (self, i);
	_g_object_unref0 (f);
	_bird_font_overview_overview_undo_item_unref0 (i);
}

void
bird_font_overview_store_undo_items (BirdFontOverview* self,
                                     BirdFontOverviewOverviewUndoItem* i)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = self->undo_items;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, i);
	_tmp1_ = self->redo_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
}

static gboolean
bird_font_overview_select_visible_glyph (BirdFontOverview* self,
                                         const gchar* name)
{
	gint i = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	i = 0;
	{
		GeeArrayList* _o_list = NULL;
		GeeArrayList* _tmp0_;
		gint _o_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _o_index = 0;
		_tmp0_ = self->visible_items;
		_o_list = _tmp0_;
		_tmp1_ = _o_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_o_size = _tmp3_;
		_o_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontOverviewItem* o = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontOverviewItem* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			gint _tmp18_;
			_o_index = _o_index + 1;
			_tmp4_ = _o_index;
			_tmp5_ = _o_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _o_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _o_index);
			o = (BirdFontOverviewItem*) _tmp7_;
			_tmp8_ = o;
			_tmp9_ = bird_font_overview_item_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, name) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				BirdFontOverviewItem* _tmp12_;
				BirdFontOverviewItem* _tmp13_;
				BirdFontWidgetAllocation* _tmp14_;
				BirdFontOverviewItem* _tmp17_;
				self->priv->selected = i;
				_tmp12_ = bird_font_overview_get_selected_item (self);
				_g_object_unref0 (self->selected_item);
				self->selected_item = _tmp12_;
				_tmp13_ = self->selected_item;
				_tmp14_ = self->allocation;
				if (_tmp13_->y > (_tmp14_->height - bird_font_overview_item_height)) {
					BirdFontOverviewItem* _tmp15_;
					BirdFontWidgetAllocation* _tmp16_;
					_tmp15_ = self->selected_item;
					_tmp16_ = self->allocation;
					self->priv->view_offset_y = self->priv->view_offset_y - ((_tmp15_->y + bird_font_overview_item_height) - _tmp16_->height);
				}
				_tmp17_ = self->selected_item;
				if (_tmp17_->y < ((gdouble) 0)) {
					self->priv->view_offset_y = (gdouble) 0;
				}
				result = TRUE;
				_g_object_unref0 (o);
				return result;
			}
			if (i > 1000) {
				g_warning ("Overview.vala:1195: selected character not found");
				result = TRUE;
				_g_object_unref0 (o);
				return result;
			}
			_tmp18_ = i;
			i = _tmp18_ + 1;
			_g_object_unref0 (o);
		}
	}
	result = FALSE;
	return result;
}

void
bird_font_overview_scroll_to_char (BirdFontOverview* self,
                                   gunichar c)
{
	GString* s = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	s = _tmp0_;
	if (bird_font_is_modifier_key ((guint) c)) {
		_g_string_free0 (s);
		return;
	}
	_tmp1_ = s;
	g_string_append_unichar (_tmp1_, c);
	_tmp2_ = s;
	_tmp3_ = _tmp2_->str;
	bird_font_overview_scroll_to_glyph (self, _tmp3_);
	_g_string_free0 (s);
}

static gpointer
_bird_font_glyph_range_ref0 (gpointer self)
{
	return self ? bird_font_glyph_range_ref (self) : NULL;
}

void
bird_font_overview_scroll_to_glyph (BirdFontOverview* self,
                                    const gchar* name)
{
	BirdFontGlyphRange* gr = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* _tmp1_;
	BirdFontGlyphRange* _tmp2_;
	gint i = 0;
	gint r = 0;
	gint index = 0;
	gchar* ch = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp3_;
	BirdFontGlyphCollection* glyphs = NULL;
	BirdFontGlyph* glyph = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = bird_font_overview_get_glyph_range (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _bird_font_glyph_range_ref0 (_tmp1_);
	gr = _tmp2_;
	_tmp3_ = bird_font_bird_font_get_current_font ();
	font = _tmp3_;
	glyphs = NULL;
	index = -1;
	if (self->priv->items_per_row <= 0) {
		_g_object_unref0 (glyph);
		_g_object_unref0 (glyphs);
		_g_object_unref0 (font);
		_g_free0 (ch);
		_bird_font_glyph_range_unref0 (gr);
		return;
	}
	_tmp4_ = g_strdup (name);
	_g_free0 (ch);
	ch = _tmp4_;
	_tmp5_ = ch;
	if (bird_font_overview_select_visible_glyph (self, _tmp5_)) {
		_g_object_unref0 (glyph);
		_g_object_unref0 (glyphs);
		_g_object_unref0 (font);
		_g_free0 (ch);
		_bird_font_glyph_range_unref0 (gr);
		return;
	}
	_tmp6_ = bird_font_overview_get_all_available (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		BirdFontFont* _tmp8_;
		_tmp8_ = font;
		if (bird_font_font_length (_tmp8_) > ((guint) 500)) {
			r = 0;
		} else {
			{
				gboolean _tmp9_ = FALSE;
				r = 0;
				_tmp9_ = TRUE;
				while (TRUE) {
					BirdFontFont* _tmp10_;
					if (!_tmp9_) {
						r += self->priv->items_per_row;
					}
					_tmp9_ = FALSE;
					_tmp10_ = font;
					if (!(((guint) r) < bird_font_font_length (_tmp10_))) {
						break;
					}
					{
						gboolean _tmp11_ = FALSE;
						i = 0;
						_tmp11_ = TRUE;
						while (TRUE) {
							gboolean _tmp13_ = FALSE;
							BirdFontFont* _tmp15_;
							BirdFontGlyphCollection* _tmp16_;
							BirdFontGlyphCollection* _tmp17_;
							BirdFontGlyphCollection* _tmp18_;
							BirdFontGlyph* _tmp19_;
							BirdFontGlyph* _tmp20_;
							const gchar* _tmp21_;
							const gchar* _tmp22_;
							if (!_tmp11_) {
								gint _tmp12_;
								_tmp12_ = i;
								i = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							if (i < self->priv->items_per_row) {
								BirdFontFont* _tmp14_;
								_tmp14_ = font;
								_tmp13_ = ((guint) i) < bird_font_font_length (_tmp14_);
							} else {
								_tmp13_ = FALSE;
							}
							if (!_tmp13_) {
								break;
							}
							_tmp15_ = font;
							_tmp16_ = bird_font_font_get_glyph_collection_index (_tmp15_, (gunichar) (((guint32) r) + i));
							_g_object_unref0 (glyphs);
							glyphs = _tmp16_;
							_tmp17_ = glyphs;
							g_return_if_fail (_tmp17_ != NULL);
							_tmp18_ = glyphs;
							_tmp19_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
							_g_object_unref0 (glyph);
							glyph = _tmp19_;
							_tmp20_ = glyph;
							_tmp21_ = _tmp20_->name;
							_tmp22_ = ch;
							if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
								index = i;
							}
						}
					}
					if (index > -1) {
						break;
					}
				}
			}
		}
	} else {
		const gchar* _tmp23_;
		_tmp23_ = ch;
		if (g_utf8_strlen (_tmp23_, (gssize) -1) > 1) {
			g_warning ("Overview.vala:1264: Can't scroll to ligature in this view");
			_g_object_unref0 (glyph);
			_g_object_unref0 (glyphs);
			_g_object_unref0 (font);
			_g_free0 (ch);
			_bird_font_glyph_range_unref0 (gr);
			return;
		}
		{
			gboolean _tmp24_ = FALSE;
			r = 0;
			_tmp24_ = TRUE;
			while (TRUE) {
				BirdFontGlyphRange* _tmp25_;
				if (!_tmp24_) {
					r += self->priv->items_per_row;
				}
				_tmp24_ = FALSE;
				_tmp25_ = gr;
				if (!(((guint32) r) < bird_font_glyph_range_length (_tmp25_))) {
					break;
				}
				{
					gboolean _tmp26_ = FALSE;
					i = 0;
					_tmp26_ = TRUE;
					while (TRUE) {
						BirdFontGlyphRange* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						const gchar* _tmp31_;
						gboolean _tmp32_;
						if (!_tmp26_) {
							gint _tmp27_;
							_tmp27_ = i;
							i = _tmp27_ + 1;
						}
						_tmp26_ = FALSE;
						if (!(i < self->priv->items_per_row)) {
							break;
						}
						_tmp28_ = gr;
						_tmp29_ = bird_font_glyph_range_get_char (_tmp28_, (guint32) (r + i));
						_tmp30_ = _tmp29_;
						_tmp31_ = ch;
						_tmp32_ = g_strcmp0 (_tmp30_, _tmp31_) == 0;
						_g_free0 (_tmp30_);
						if (_tmp32_) {
							index = i;
						}
					}
				}
				if (index > -1) {
					break;
				}
			}
		}
	}
	if (index > -1) {
		const gchar* _tmp33_;
		self->priv->first_visible = r;
		bird_font_overview_process_item_list_update (self);
		bird_font_overview_update_item_list (self);
		_tmp33_ = ch;
		bird_font_overview_select_visible_glyph (self, _tmp33_);
	}
	_g_object_unref0 (glyph);
	_g_object_unref0 (glyphs);
	_g_object_unref0 (font);
	_g_free0 (ch);
	_bird_font_glyph_range_unref0 (gr);
}

static void
bird_font_overview_real_double_click (BirdFontFontDisplay* base,
                                      guint button,
                                      gdouble ex,
                                      gdouble ey)
{
	BirdFontOverview * self;
	GeeArrayList* _tmp0_;
	BirdFontWidgetAllocation* _tmp1_;
	self = (BirdFontOverview*) base;
	_tmp0_ = self->visible_items;
	_tmp1_ = self->allocation;
	_vala_return_if_fail ((!bird_font_is_null (_tmp0_)) && (!bird_font_is_null (_tmp1_)), "!is_null (visible_items) && !is_null (allocation)");
	g_return_if_fail (!bird_font_is_null (self));
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp2_;
		gint _i_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _i_index = 0;
		_tmp2_ = self->visible_items;
		_i_list = _tmp2_;
		_tmp3_ = _i_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_i_size = _tmp5_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontOverviewItem* i = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontOverviewItem* _tmp10_;
			_i_index = _i_index + 1;
			_tmp6_ = _i_index;
			_tmp7_ = _i_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _i_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _i_index);
			i = (BirdFontOverviewItem*) _tmp9_;
			_tmp10_ = i;
			if (bird_font_overview_item_double_click (_tmp10_, button, ex, ey)) {
				BirdFontOverviewItem* _tmp11_;
				_tmp11_ = i;
				bird_font_overview_open_overview_item (self, _tmp11_);
			}
			_g_object_unref0 (i);
		}
	}
	bird_font_glyph_canvas_redraw ();
}

void
bird_font_overview_open_overview_item (BirdFontOverview* self,
                                       BirdFontOverviewItem* i)
{
	BirdFontGlyphCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	g_return_if_fail (!bird_font_is_null (i));
	_tmp0_ = i->glyphs;
	if (_tmp0_ != NULL) {
		BirdFontGlyphCollection* _tmp1_;
		BirdFontGlyphCollection* gc = NULL;
		BirdFontGlyphCollection* _tmp2_;
		BirdFontGlyphCollection* _tmp3_;
		BirdFontGlyphCollection* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontGlyph* _tmp6_;
		_tmp1_ = i->glyphs;
		g_signal_emit (self, bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_GLYPH_SIGNAL_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_tmp2_ = i->glyphs;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		gc = _tmp3_;
		_tmp4_ = gc;
		_tmp5_ = bird_font_glyph_collection_get_current (_tmp4_);
		_tmp6_ = _tmp5_;
		bird_font_glyph_close_path (_tmp6_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (gc);
	} else {
		g_signal_emit (self, bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_NEW_GLYPH_SIGNAL_SIGNAL], 0, i->character);
	}
}

void
bird_font_overview_set_character_info (BirdFontOverview* self,
                                       BirdFontCharacterInfo* i)
{
	BirdFontCharacterInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = _g_object_ref0 (i);
	_g_object_unref0 (self->priv->character_info);
	self->priv->character_info = _tmp0_;
}

gint
bird_font_overview_get_selected_index (BirdFontOverview* self)
{
	BirdFontGlyphCollection* gc = NULL;
	gint index = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	index = 0;
	_tmp0_ = self->selected_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = 0;
		_g_object_unref0 (gc);
		return result;
	}
	_tmp3_ = self->selected_items;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	_g_object_unref0 (gc);
	gc = (BirdFontGlyphCollection*) _tmp4_;
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp5_;
		gint _i_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _i_index = 0;
		_tmp5_ = self->visible_items;
		_i_list = _tmp5_;
		_tmp6_ = _i_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_i_size = _tmp8_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontOverviewItem* i = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			BirdFontOverviewItem* _tmp14_;
			BirdFontGlyphCollection* _tmp15_;
			gint _tmp19_;
			_i_index = _i_index + 1;
			_tmp9_ = _i_index;
			_tmp10_ = _i_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _i_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _i_index);
			i = (BirdFontOverviewItem*) _tmp12_;
			_tmp14_ = i;
			_tmp15_ = _tmp14_->glyphs;
			if (_tmp15_ != NULL) {
				BirdFontGlyphCollection* _tmp16_;
				BirdFontOverviewItem* _tmp17_;
				BirdFontGlyphCollection* _tmp18_;
				_tmp16_ = gc;
				_tmp17_ = i;
				_tmp18_ = _tmp17_->glyphs;
				_tmp13_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				_g_object_unref0 (i);
				break;
			}
			_tmp19_ = index;
			index = _tmp19_ + 1;
			_g_object_unref0 (i);
		}
	}
	result = index;
	_g_object_unref0 (gc);
	return result;
}

void
bird_font_overview_hide_menu (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp0_;
		gint _i_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _i_index = 0;
		_tmp0_ = self->visible_items;
		_i_list = _tmp0_;
		_tmp1_ = _i_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_i_size = _tmp3_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontOverviewItem* i = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontOverviewItem* _tmp8_;
			_i_index = _i_index + 1;
			_tmp4_ = _i_index;
			_tmp5_ = _i_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _i_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _i_index);
			i = (BirdFontOverviewItem*) _tmp7_;
			_tmp8_ = i;
			bird_font_overview_item_hide_menu (_tmp8_);
			_g_object_unref0 (i);
		}
	}
}

static void
bird_font_overview_real_button_press (BirdFontFontDisplay* base,
                                      guint button,
                                      gdouble x,
                                      gdouble y)
{
	BirdFontOverview * self;
	BirdFontOverviewItem* i = NULL;
	gint index = 0;
	gint selected_index = 0;
	gboolean update = FALSE;
	BirdFontCharacterInfo* _tmp0_;
	self = (BirdFontOverview*) base;
	index = 0;
	selected_index = -1;
	update = FALSE;
	_tmp0_ = self->priv->character_info;
	if (_tmp0_ != NULL) {
		_g_object_unref0 (self->priv->character_info);
		self->priv->character_info = NULL;
		bird_font_glyph_canvas_redraw ();
		_g_object_unref0 (i);
		return;
	}
	if (!bird_font_key_bindings_has_shift ()) {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->selected_items;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GeeArrayList* _tmp7_;
				gpointer _tmp8_;
				BirdFontOverviewItem* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = j;
					j = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->visible_items;
				_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(j < _tmp6_)) {
					break;
				}
				_tmp7_ = self->visible_items;
				_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, j);
				_g_object_unref0 (i);
				i = (BirdFontOverviewItem*) _tmp8_;
				_tmp9_ = i;
				if (bird_font_overview_item_click_menu (_tmp9_, button, x, y)) {
					bird_font_glyph_canvas_redraw ();
					_g_object_unref0 (i);
					return;
				}
			}
		}
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GeeArrayList* _tmp15_;
				gpointer _tmp16_;
				BirdFontOverviewItem* _tmp17_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = j;
					j = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = self->visible_items;
				_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(j < _tmp14_)) {
					break;
				}
				_tmp15_ = self->visible_items;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, j);
				_g_object_unref0 (i);
				i = (BirdFontOverviewItem*) _tmp16_;
				_tmp17_ = i;
				if (bird_font_overview_item_click_info (_tmp17_, button, x, y)) {
					bird_font_glyph_canvas_redraw ();
					_g_object_unref0 (i);
					return;
				}
			}
		}
	}
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				BirdFontOverviewItem* _tmp25_;
				gint _tmp55_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = j;
					j = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = self->visible_items;
				_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				if (!(j < _tmp22_)) {
					break;
				}
				_tmp23_ = self->visible_items;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, j);
				_g_object_unref0 (i);
				i = (BirdFontOverviewItem*) _tmp24_;
				_tmp25_ = i;
				if (bird_font_overview_item_click (_tmp25_, button, x, y)) {
					BirdFontOverviewItem* _tmp26_;
					BirdFontOverviewItem* _tmp49_;
					BirdFontVersionList* _tmp50_;
					self->priv->selected = index;
					_tmp26_ = bird_font_overview_get_selected_item (self);
					_g_object_unref0 (self->selected_item);
					self->selected_item = _tmp26_;
					if (bird_font_key_bindings_has_shift ()) {
						BirdFontOverviewItem* _tmp27_;
						BirdFontGlyphCollection* _tmp28_;
						_tmp27_ = self->selected_item;
						_tmp28_ = _tmp27_->glyphs;
						if (_tmp28_ != NULL) {
							GeeArrayList* _tmp29_;
							BirdFontOverviewItem* _tmp30_;
							BirdFontGlyphCollection* _tmp31_;
							_tmp29_ = self->selected_items;
							_tmp30_ = self->selected_item;
							_tmp31_ = _tmp30_->glyphs;
							selected_index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
							if (selected_index == -1) {
								GeeArrayList* _tmp32_;
								BirdFontOverviewItem* _tmp33_;
								BirdFontGlyphCollection* _tmp34_;
								_tmp32_ = self->selected_items;
								_tmp33_ = self->selected_item;
								_tmp34_ = _tmp33_->glyphs;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
							} else {
								GeeArrayList* _tmp35_;
								gint _tmp36_;
								gint _tmp37_;
								gint _tmp38_;
								GeeArrayList* _tmp39_;
								gpointer _tmp40_;
								BirdFontGlyphCollection* _tmp41_;
								BirdFontOverviewItem* _tmp42_;
								_tmp35_ = self->selected_items;
								_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = selected_index;
								g_return_if_fail ((0 <= _tmp38_) && (_tmp38_ < _tmp37_));
								_tmp39_ = self->selected_items;
								_tmp40_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp39_, selected_index);
								_tmp41_ = (BirdFontGlyphCollection*) _tmp40_;
								_g_object_unref0 (_tmp41_);
								self->priv->selected = bird_font_overview_get_selected_index (self);
								_tmp42_ = bird_font_overview_get_selected_item (self);
								_g_object_unref0 (self->selected_item);
								self->selected_item = _tmp42_;
							}
						}
					} else {
						GeeArrayList* _tmp43_;
						BirdFontOverviewItem* _tmp44_;
						BirdFontGlyphCollection* _tmp45_;
						_tmp43_ = self->selected_items;
						gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp43_);
						_tmp44_ = self->selected_item;
						_tmp45_ = _tmp44_->glyphs;
						if (_tmp45_ != NULL) {
							GeeArrayList* _tmp46_;
							BirdFontOverviewItem* _tmp47_;
							BirdFontGlyphCollection* _tmp48_;
							_tmp46_ = self->selected_items;
							_tmp47_ = self->selected_item;
							_tmp48_ = _tmp47_->glyphs;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
						}
					}
					_tmp49_ = i;
					_tmp50_ = _tmp49_->version_menu;
					if (!bird_font_is_null (_tmp50_)) {
						BirdFontOverviewItem* _tmp51_;
						BirdFontVersionList* _tmp52_;
						gboolean _tmp53_;
						gboolean _tmp54_;
						_tmp51_ = i;
						_tmp52_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, BIRD_FONT_TYPE_OVERVIEW_ITEM, BirdFontOverviewItem)->version_menu;
						_tmp53_ = bird_font_version_list_get_menu_visible (_tmp52_);
						_tmp54_ = _tmp53_;
						update = !_tmp54_;
					} else {
						update = TRUE;
					}
				}
				_tmp55_ = index;
				index = _tmp55_ + 1;
			}
		}
	}
	if (update) {
		bird_font_overview_update_item_list (self);
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (i);
}

/** Returns true if overview shows the last character. */
static gboolean
bird_font_overview_at_bottom (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	gdouble t = 0.0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	BirdFontGlyphRange* _tmp4_;
	BirdFontGlyphRange* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	t = (gdouble) ((self->priv->rows * self->priv->items_per_row) + self->priv->first_visible);
	_tmp0_ = bird_font_overview_get_all_available (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp2_;
		_tmp3_ = f;
		result = t >= ((gdouble) (bird_font_font_length (_tmp3_) + (2 * self->priv->items_per_row)));
		_g_object_unref0 (f);
		return result;
	}
	_tmp4_ = bird_font_overview_get_glyph_range (self);
	_tmp5_ = _tmp4_;
	result = t >= ((gdouble) (bird_font_glyph_range_length (_tmp5_) + (2 * self->priv->items_per_row)));
	_g_object_unref0 (f);
	return result;
}

void
bird_font_overview_set_current_glyph_range (BirdFontOverview* self,
                                            BirdFontGlyphRange* range)
{
	BirdFontGlyphRange* current = NULL;
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* _tmp1_;
	BirdFontGlyphRange* _tmp2_;
	gchar* c = NULL;
	BirdFontGlyphRange* _tmp3_;
	BirdFontOverviewItem* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_tmp0_ = bird_font_overview_get_glyph_range (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _bird_font_glyph_range_ref0 (_tmp1_);
	current = _tmp2_;
	_tmp3_ = current;
	if (_tmp3_ != NULL) {
		BirdFontGlyphRange* _tmp4_;
		BirdFontGlyphRange* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = bird_font_overview_get_glyph_range (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = bird_font_glyph_range_get_char (_tmp5_, (guint32) self->priv->selected);
		_g_free0 (c);
		c = _tmp6_;
	}
	bird_font_overview_set_all_available (self, FALSE);
	bird_font_overview_set_glyph_range (self, range);
	bird_font_overview_scroll_top (self);
	bird_font_overview_update_item_list (self);
	_tmp7_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp7_;
	bird_font_glyph_canvas_redraw ();
	_g_free0 (c);
	_bird_font_glyph_range_unref0 (current);
}

void
bird_font_overview_select_next_glyph (BirdFontOverview* self)
{
	g_return_if_fail (self != NULL);
	bird_font_overview_key_right (self);
}

void
bird_font_overview_open_current_glyph (BirdFontOverview* self)
{
	BirdFontOverviewItem* _tmp0_;
	BirdFontOverviewItem* _tmp1_;
	BirdFontGlyphCollection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_object_ref ((GObject*) self);
	_tmp0_ = bird_font_overview_get_selected_item (self);
	_g_object_unref0 (self->selected_item);
	self->selected_item = _tmp0_;
	_tmp1_ = self->selected_item;
	_tmp2_ = _tmp1_->glyphs;
	if (_tmp2_ != NULL) {
		BirdFontOverviewItem* _tmp3_;
		BirdFontGlyphCollection* _tmp4_;
		BirdFontGlyphCollection* gc = NULL;
		BirdFontOverviewItem* _tmp5_;
		BirdFontGlyphCollection* _tmp6_;
		BirdFontGlyphCollection* _tmp7_;
		BirdFontGlyphCollection* _tmp8_;
		BirdFontGlyph* _tmp9_;
		BirdFontGlyph* _tmp10_;
		_tmp3_ = self->selected_item;
		_tmp4_ = _tmp3_->glyphs;
		g_signal_emit (self, bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_GLYPH_SIGNAL_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		_tmp5_ = self->selected_item;
		_tmp6_ = _tmp5_->glyphs;
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
		gc = _tmp7_;
		_tmp8_ = gc;
		_tmp9_ = bird_font_glyph_collection_get_current (_tmp8_);
		_tmp10_ = _tmp9_;
		bird_font_glyph_close_path (_tmp10_);
		_g_object_unref0 (_tmp10_);
		_g_object_unref0 (gc);
	} else {
		BirdFontOverviewItem* _tmp11_;
		_tmp11_ = self->selected_item;
		g_signal_emit (self, bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_NEW_GLYPH_SIGNAL_SIGNAL], 0, _tmp11_->character);
	}
	g_object_unref ((GObject*) self);
}

gdouble
bird_font_overview_update_scrollbar (BirdFontOverview* self)
{
	BirdFontFont* f = NULL;
	gdouble nrows = 0.0;
	gdouble pos = 0.0;
	gdouble size = 0.0;
	gdouble visible_rows = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	nrows = (gdouble) 0;
	pos = (gdouble) 0;
	if (self->priv->rows == 0) {
		bird_font_main_window_set_scrollbar_size ((gdouble) 0);
		bird_font_main_window_set_scrollbar_position ((gdouble) 0);
	} else {
		gboolean _tmp0_;
		gboolean _tmp1_;
		BirdFontWidgetAllocation* _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp0_ = bird_font_overview_get_all_available (self);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			BirdFontFont* _tmp2_;
			BirdFontFont* _tmp3_;
			BirdFontFont* _tmp4_;
			_tmp2_ = bird_font_bird_font_get_current_font ();
			_g_object_unref0 (f);
			f = _tmp2_;
			_tmp3_ = f;
			nrows = ceil (bird_font_font_length (_tmp3_) / ((gdouble) self->priv->rows));
			_tmp4_ = f;
			size = (gdouble) bird_font_font_length (_tmp4_);
		} else {
			BirdFontGlyphRange* _tmp5_;
			BirdFontGlyphRange* _tmp6_;
			BirdFontGlyphRange* _tmp7_;
			BirdFontGlyphRange* _tmp8_;
			_tmp5_ = bird_font_overview_get_glyph_range (self);
			_tmp6_ = _tmp5_;
			nrows = ceil (bird_font_glyph_range_length (_tmp6_) / ((gdouble) self->priv->rows));
			_tmp7_ = bird_font_overview_get_glyph_range (self);
			_tmp8_ = _tmp7_;
			size = (gdouble) bird_font_glyph_range_length (_tmp8_);
		}
		if (nrows <= ((gdouble) 0)) {
			nrows = (gdouble) 1;
		}
		_tmp9_ = self->allocation;
		visible_rows = _tmp9_->height / (bird_font_overview_item_height + bird_font_overview_item_margin);
		self->priv->scroll_size = visible_rows / nrows;
		bird_font_main_window_set_scrollbar_size (self->priv->scroll_size);
		pos = self->priv->first_visible / (size - (visible_rows * self->priv->items_per_row));
		if (pos > ((gdouble) 1)) {
			pos = (gdouble) 1;
		}
		bird_font_main_window_set_scrollbar_position (pos);
		if (bird_font_overview_at_bottom (self)) {
			_tmp10_ = self->priv->first_visible == 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			bird_font_main_window_hide_scrollbar ();
		} else {
			bird_font_main_window_show_scrollbar ();
		}
	}
	result = pos;
	_g_object_unref0 (f);
	return result;
}

/** Display one entry from the Unicode Character Database. */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
bird_font_overview_draw_character_info (BirdFontOverview* self,
                                        cairo_t* cr)
{
	BirdFontCharacterInfo* _tmp0_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gint i = 0;
	gchar* unicode_value = NULL;
	gchar* unicode_description = NULL;
	gchar** column = NULL;
	gint column_length1 = 0;
	gint _column_size_ = 0;
	gchar* entry = NULL;
	gint len = 0;
	gint length = 0;
	gboolean see_also = FALSE;
	BirdFontWidgetAllocation* allocation = NULL;
	BirdFontOverview* _tmp1_;
	BirdFontOverview* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	BirdFontWidgetAllocation* _tmp4_;
	BirdFontWidgetAllocation* _tmp5_;
	gchar* name = NULL;
	gchar** lines = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gdouble character_start = 0.0;
	gdouble character_height = 0.0;
	BirdFontCharacterInfo* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	BirdFontWidgetAllocation* _tmp16_;
	BirdFontWidgetAllocation* _tmp17_;
	BirdFontWidgetAllocation* _tmp18_;
	BirdFontWidgetAllocation* _tmp19_;
	BirdFontCharacterInfo* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->character_info;
	_vala_return_if_fail (_tmp0_ != NULL, "character_info != null");
	len = 0;
	length = 0;
	see_also = FALSE;
	_tmp1_ = bird_font_main_window_get_overview ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->allocation;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	allocation = _tmp5_;
	_tmp6_ = self->priv->character_info;
	_tmp7_ = bird_font_character_info_get_entry (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_CHARACTER_INFO, BirdFontCharacterInfo));
	_g_free0 (entry);
	entry = _tmp7_;
	_tmp8_ = entry;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	lines = _tmp10_;
	lines_length1 = _vala_array_length (_tmp9_);
	_lines_size_ = lines_length1;
	_tmp11_ = entry;
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp13_;
		line_collection_length1 = _vala_array_length (_tmp12_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp14_;
			gchar* line = NULL;
			_tmp14_ = g_strdup (line_collection[line_it]);
			line = _tmp14_;
			{
				const gchar* _tmp15_;
				_tmp15_ = line;
				len = g_utf8_strlen (_tmp15_, (gssize) -1);
				if (len > length) {
					length = len;
				}
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = allocation;
	x = _tmp16_->width * 0.1;
	_tmp17_ = allocation;
	y = _tmp17_->height * 0.1;
	_tmp18_ = allocation;
	w = (_tmp18_->width * 0.9) - x;
	_tmp19_ = allocation;
	h = (_tmp19_->height * 0.9) - y;
	if (w < ((gdouble) (8 * length))) {
		BirdFontWidgetAllocation* _tmp20_;
		w = (gdouble) (8 * length);
		_tmp20_ = allocation;
		x = (_tmp20_->width - w) / 2.0;
	}
	if (x < ((gdouble) 0)) {
		x = (gdouble) 2;
	}
	cairo_save (cr);
	bird_font_theme_color_opacity (cr, "Background 1", 0.98);
	cairo_rectangle (cr, x, y, w, h);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color_opacity (cr, "Foreground 1", 0.98);
	cairo_set_line_width (cr, (gdouble) 2);
	cairo_rectangle (cr, x, y, w, h);
	cairo_stroke (cr);
	cairo_restore (cr);
	_tmp21_ = self->priv->character_info;
	if (bird_font_character_info_is_ligature (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, BIRD_FONT_TYPE_CHARACTER_INFO, BirdFontCharacterInfo))) {
		BirdFontCharacterInfo* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = self->priv->character_info;
		_tmp23_ = bird_font_character_info_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, BIRD_FONT_TYPE_CHARACTER_INFO, BirdFontCharacterInfo));
		_g_free0 (name);
		name = _tmp23_;
		_tmp24_ = name;
		bird_font_overview_draw_info_line (self, _tmp24_, cr, x, y, 0);
	} else {
		gchar** _tmp25_;
		gint _tmp25__length1;
		i = 0;
		_tmp25_ = lines;
		_tmp25__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp25_;
			line_collection_length1 = _tmp25__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp26_;
				gchar* line = NULL;
				_tmp26_ = g_strdup (line_collection[line_it]);
				line = _tmp26_;
				{
					if (i == 0) {
						const gchar* _tmp27_;
						gchar** _tmp28_;
						gchar** _tmp29_;
						gchar** _tmp30_;
						gint _tmp30__length1;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						gchar** _tmp34_;
						gint _tmp34__length1;
						const gchar* _tmp35_;
						gchar* _tmp36_;
						const gchar* _tmp37_;
						gint _tmp38_;
						const gchar* _tmp39_;
						gint _tmp40_;
						_tmp27_ = line;
						_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "\t", 0);
						column = (_vala_array_free (column, column_length1, (GDestroyNotify) g_free), NULL);
						column = _tmp29_;
						column_length1 = _vala_array_length (_tmp28_);
						_column_size_ = column_length1;
						_tmp30_ = column;
						_tmp30__length1 = column_length1;
						g_return_if_fail (_tmp30__length1 == 2);
						_tmp31_ = column;
						_tmp31__length1 = column_length1;
						_tmp32_ = _tmp31_[0];
						_tmp33_ = g_strconcat ("U+", _tmp32_, NULL);
						_g_free0 (unicode_value);
						unicode_value = _tmp33_;
						_tmp34_ = column;
						_tmp34__length1 = column_length1;
						_tmp35_ = _tmp34_[1];
						_tmp36_ = g_strdup (_tmp35_);
						_g_free0 (unicode_description);
						unicode_description = _tmp36_;
						_tmp37_ = unicode_description;
						bird_font_overview_draw_info_line (self, _tmp37_, cr, x, y, i);
						_tmp38_ = i;
						i = _tmp38_ + 1;
						_tmp39_ = unicode_value;
						bird_font_overview_draw_info_line (self, _tmp39_, cr, x, y, i);
						_tmp40_ = i;
						i = _tmp40_ + 1;
					} else {
						const gchar* _tmp41_;
						_tmp41_ = line;
						if (g_str_has_prefix (_tmp41_, "\t*")) {
							const gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							gint _tmp45_;
							_tmp42_ = line;
							_tmp43_ = string_replace (_tmp42_, "\t*", "•");
							_tmp44_ = _tmp43_;
							bird_font_overview_draw_info_line (self, _tmp44_, cr, x, y, i);
							_g_free0 (_tmp44_);
							_tmp45_ = i;
							i = _tmp45_ + 1;
						} else {
							const gchar* _tmp46_;
							_tmp46_ = line;
							if (g_str_has_prefix (_tmp46_, "\tx (")) {
								const gchar* _tmp51_;
								gchar* _tmp52_;
								gchar* _tmp53_;
								gchar* _tmp54_;
								gchar* _tmp55_;
								gint _tmp56_;
								if (!see_also) {
									gint _tmp47_;
									gchar* _tmp48_;
									gchar* _tmp49_;
									gint _tmp50_;
									_tmp47_ = i;
									i = _tmp47_ + 1;
									_tmp48_ = bird_font_t_ ("See also:");
									_tmp49_ = _tmp48_;
									bird_font_overview_draw_info_line (self, _tmp49_, cr, x, y, i);
									_g_free0 (_tmp49_);
									_tmp50_ = i;
									i = _tmp50_ + 1;
									see_also = TRUE;
								}
								_tmp51_ = line;
								_tmp52_ = string_replace (_tmp51_, "\tx (", "•");
								_tmp53_ = _tmp52_;
								_tmp54_ = string_replace (_tmp53_, ")", "");
								_tmp55_ = _tmp54_;
								bird_font_overview_draw_info_line (self, _tmp55_, cr, x, y, i);
								_g_free0 (_tmp55_);
								_g_free0 (_tmp53_);
								_tmp56_ = i;
								i = _tmp56_ + 1;
							} else {
								gint _tmp57_;
								_tmp57_ = i;
								i = _tmp57_ + 1;
							}
						}
					}
					_g_free0 (line);
				}
			}
		}
		character_start = (y + 10) + (i * BIRD_FONT_OVERVIEW_UCD_LINE_HEIGHT);
		character_height = h - character_start;
		bird_font_overview_draw_fallback_character (self, cr, x, character_start, character_height);
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
	_g_object_unref0 (allocation);
	_g_free0 (entry);
	column = (_vala_array_free (column, column_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (unicode_description);
	_g_free0 (unicode_value);
}

/** Fallback character in UCD info. */
static void
bird_font_overview_draw_fallback_character (BirdFontOverview* self,
                                            cairo_t* cr,
                                            gdouble x,
                                            gdouble y,
                                            gdouble height)
{
	BirdFontCharacterInfo* _tmp0_;
	gunichar c = 0U;
	BirdFontCharacterInfo* _tmp1_;
	BirdFontText* character = NULL;
	BirdFontText* _tmp2_;
	BirdFontText* _tmp3_;
	BirdFontText* _tmp4_;
	BirdFontText* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	BirdFontText* _tmp8_;
	BirdFontText* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->character_info;
	_vala_return_if_fail (_tmp0_ != NULL, "character_info != null");
	_tmp1_ = self->priv->character_info;
	c = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, BIRD_FONT_TYPE_CHARACTER_INFO, BirdFontCharacterInfo)->unicode;
	if (height < ((gdouble) 0)) {
		return;
	}
	cairo_save (cr);
	_tmp2_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	character = _tmp2_;
	_tmp3_ = character;
	bird_font_text_set_use_cache (_tmp3_, FALSE);
	_tmp4_ = character;
	bird_font_theme_text_color (_tmp4_, "Foreground 1");
	_tmp5_ = character;
	_tmp6_ = g_unichar_to_string (c);
	_tmp7_ = (gchar*) _tmp6_;
	bird_font_text_set_text (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = character;
	bird_font_text_set_font_size (_tmp8_, height);
	_tmp9_ = character;
	bird_font_text_draw_at_top (_tmp9_, cr, x + 10, y, "");
	cairo_restore (cr);
	_g_object_unref0 (character);
}

static void
bird_font_overview_draw_info_line (BirdFontOverview* self,
                                   const gchar* line,
                                   cairo_t* cr,
                                   gdouble x,
                                   gdouble y,
                                   gint row)
{
	BirdFontText* ucd_entry = NULL;
	BirdFontText* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = bird_font_text_new (line, (gdouble) 17, (gdouble) 0);
	ucd_entry = _tmp0_;
	cairo_save (cr);
	bird_font_theme_text_color (ucd_entry, "Foreground 1");
	((BirdFontWidget*) ucd_entry)->widget_x = 10 + x;
	((BirdFontWidget*) ucd_entry)->widget_y = (10 + y) + (row * BIRD_FONT_OVERVIEW_UCD_LINE_HEIGHT);
	bird_font_widget_draw ((BirdFontWidget*) ucd_entry, cr);
	cairo_restore (cr);
	_g_object_unref0 (ucd_entry);
}

static gint
__lambda345_ (BirdFontOverview* self,
              BirdFontGlyphCollection* a,
              BirdFontGlyphCollection* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = ((gint) bird_font_glyph_collection_get_unicode_character (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection))) - ((gint) bird_font_glyph_collection_get_unicode_character (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection)));
	return result;
}

static gint
___lambda345__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda345_ ((BirdFontOverview*) self, (BirdFontGlyphCollection*) a, (BirdFontGlyphCollection*) b);
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

void
bird_font_overview_paste (BirdFontOverview* self)
{
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphCollection* c = NULL;
	BirdFontGlyph* glyph = NULL;
	guint32 index = 0U;
	gint i = 0;
	gint skip = 0;
	gint s = 0;
	gchar* character_string = NULL;
	GeeArrayList* glyphs = NULL;
	BirdFontFont* f = NULL;
	BirdFontOverviewOverviewUndoItem* undo_item = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyphCollection* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	BirdFontOverviewOverviewUndoItem* _tmp83_;
	BirdFontOverviewOverviewUndoItem* _tmp84_;
	BirdFontFont* _tmp85_;
	BirdFontAlternateSets* _tmp86_;
	BirdFontAlternateSets* _tmp87_;
	BirdFontOverviewOverviewUndoItem* _tmp101_;
	GeeArrayList* _tmp102_;
	gint _tmp103_;
	gint _tmp104_;
	GeeArrayList* _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	GeeArrayList* _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	BirdFontFont* _tmp143_;
	g_return_if_fail (self != NULL);
	skip = 0;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (f);
	f = _tmp0_;
	_tmp1_ = bird_font_glyph_collection_new ((gunichar) '\0', "");
	_g_object_unref0 (gc);
	gc = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (glyphs);
	glyphs = _tmp2_;
	_tmp3_ = self->copied_glyphs;
	gee_list_sort ((GeeList*) _tmp3_, ___lambda345__gcompare_data_func, g_object_ref (self), g_object_unref);
	index = ((guint32) self->priv->first_visible) + self->priv->selected;
	{
		gboolean _tmp4_ = FALSE;
		i = 0;
		_tmp4_ = TRUE;
		while (TRUE) {
			GeeArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			GeeArrayList* _tmp80_;
			BirdFontGlyphCollection* _tmp81_;
			guint32 _tmp82_;
			if (!_tmp4_) {
				gint _tmp5_;
				_tmp5_ = i;
				i = _tmp5_ + 1;
			}
			_tmp4_ = FALSE;
			_tmp6_ = self->copied_glyphs;
			_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			if (!(i < _tmp8_)) {
				break;
			}
			_tmp9_ = bird_font_overview_get_all_available (self);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				BirdFontFont* _tmp11_;
				BirdFontGlyphCollection* _tmp39_;
				BirdFontGlyphCollection* _tmp52_;
				BirdFontGlyphCollection* _tmp53_;
				BirdFontGlyphCollection* _tmp54_;
				_tmp11_ = f;
				if (bird_font_font_length (_tmp11_) == ((guint) 0)) {
					GeeArrayList* _tmp12_;
					gpointer _tmp13_;
					BirdFontGlyphCollection* _tmp14_;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					BirdFontGlyphCollection* _tmp17_;
					GeeArrayList* _tmp18_;
					gpointer _tmp19_;
					BirdFontGlyphCollection* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					BirdFontGlyphCollection* _tmp23_;
					_tmp12_ = self->copied_glyphs;
					_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, i);
					_tmp14_ = (BirdFontGlyphCollection*) _tmp13_;
					_tmp15_ = self->copied_glyphs;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
					_tmp17_ = (BirdFontGlyphCollection*) _tmp16_;
					_tmp18_ = self->copied_glyphs;
					_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, i);
					_tmp20_ = (BirdFontGlyphCollection*) _tmp19_;
					_tmp21_ = bird_font_glyph_collection_get_name (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = bird_font_overview_add_empty_character_to_font (self, bird_font_glyph_collection_get_unicode_character (_tmp14_), bird_font_glyph_collection_is_unassigned (_tmp17_), _tmp22_);
					_g_object_unref0 (c);
					c = _tmp23_;
					_g_free0 (_tmp22_);
					_g_object_unref0 (_tmp20_);
					_g_object_unref0 (_tmp17_);
					_g_object_unref0 (_tmp14_);
				} else {
					BirdFontFont* _tmp24_;
					_tmp24_ = f;
					if (index >= ((guint32) bird_font_font_length (_tmp24_))) {
						GeeArrayList* _tmp25_;
						gpointer _tmp26_;
						BirdFontGlyphCollection* _tmp27_;
						GeeArrayList* _tmp28_;
						gpointer _tmp29_;
						BirdFontGlyphCollection* _tmp30_;
						GeeArrayList* _tmp31_;
						gpointer _tmp32_;
						BirdFontGlyphCollection* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						BirdFontGlyphCollection* _tmp36_;
						_tmp25_ = self->copied_glyphs;
						_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, i);
						_tmp27_ = (BirdFontGlyphCollection*) _tmp26_;
						_tmp28_ = self->copied_glyphs;
						_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, i);
						_tmp30_ = (BirdFontGlyphCollection*) _tmp29_;
						_tmp31_ = self->copied_glyphs;
						_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, i);
						_tmp33_ = (BirdFontGlyphCollection*) _tmp32_;
						_tmp34_ = bird_font_glyph_collection_get_name (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = bird_font_overview_add_empty_character_to_font (self, bird_font_glyph_collection_get_unicode_character (_tmp27_), bird_font_glyph_collection_is_unassigned (_tmp30_), _tmp35_);
						_g_object_unref0 (c);
						c = _tmp36_;
						_g_free0 (_tmp35_);
						_g_object_unref0 (_tmp33_);
						_g_object_unref0 (_tmp30_);
						_g_object_unref0 (_tmp27_);
					} else {
						BirdFontFont* _tmp37_;
						BirdFontGlyphCollection* _tmp38_;
						_tmp37_ = f;
						_tmp38_ = bird_font_font_get_glyph_collection_index (_tmp37_, (gunichar) ((guint32) index));
						_g_object_unref0 (c);
						c = _tmp38_;
					}
				}
				_tmp39_ = c;
				if (_tmp39_ == NULL) {
					GeeArrayList* _tmp40_;
					gpointer _tmp41_;
					BirdFontGlyphCollection* _tmp42_;
					GeeArrayList* _tmp43_;
					gpointer _tmp44_;
					BirdFontGlyphCollection* _tmp45_;
					GeeArrayList* _tmp46_;
					gpointer _tmp47_;
					BirdFontGlyphCollection* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					BirdFontGlyphCollection* _tmp51_;
					_tmp40_ = self->copied_glyphs;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, i);
					_tmp42_ = (BirdFontGlyphCollection*) _tmp41_;
					_tmp43_ = self->copied_glyphs;
					_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, i);
					_tmp45_ = (BirdFontGlyphCollection*) _tmp44_;
					_tmp46_ = self->copied_glyphs;
					_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, i);
					_tmp48_ = (BirdFontGlyphCollection*) _tmp47_;
					_tmp49_ = bird_font_glyph_collection_get_name (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = bird_font_overview_add_empty_character_to_font (self, bird_font_glyph_collection_get_unicode_character (_tmp42_), bird_font_glyph_collection_is_unassigned (_tmp45_), _tmp50_);
					_g_object_unref0 (c);
					c = _tmp51_;
					_g_free0 (_tmp50_);
					_g_object_unref0 (_tmp48_);
					_g_object_unref0 (_tmp45_);
					_g_object_unref0 (_tmp42_);
				}
				_tmp52_ = c;
				g_return_if_fail (_tmp52_ != NULL);
				_tmp53_ = c;
				_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
				_g_object_unref0 (gc);
				gc = _tmp54_;
			} else {
				BirdFontGlyphRange* _tmp61_;
				BirdFontGlyphRange* _tmp62_;
				gchar* _tmp63_;
				BirdFontFont* _tmp64_;
				const gchar* _tmp65_;
				BirdFontGlyphCollection* _tmp66_;
				BirdFontGlyphCollection* _tmp67_;
				if (i != 0) {
					GeeArrayList* _tmp55_;
					gpointer _tmp56_;
					BirdFontGlyphCollection* _tmp57_;
					GeeArrayList* _tmp58_;
					gpointer _tmp59_;
					BirdFontGlyphCollection* _tmp60_;
					_tmp55_ = self->copied_glyphs;
					_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, i);
					_tmp57_ = (BirdFontGlyphCollection*) _tmp56_;
					s = (gint) bird_font_glyph_collection_get_unicode_character (_tmp57_);
					_g_object_unref0 (_tmp57_);
					_tmp58_ = self->copied_glyphs;
					_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, i - 1);
					_tmp60_ = (BirdFontGlyphCollection*) _tmp59_;
					s -= (gint) bird_font_glyph_collection_get_unicode_character (_tmp60_);
					_g_object_unref0 (_tmp60_);
					s -= 1;
					skip += s;
				}
				_tmp61_ = bird_font_overview_get_glyph_range (self);
				_tmp62_ = _tmp61_;
				_tmp63_ = bird_font_glyph_range_get_char (_tmp62_, (guint32) (index + skip));
				_g_free0 (character_string);
				character_string = _tmp63_;
				_tmp64_ = f;
				_tmp65_ = character_string;
				_tmp66_ = bird_font_font_get_glyph_collection_by_name (_tmp64_, _tmp65_);
				_g_object_unref0 (c);
				c = _tmp66_;
				_tmp67_ = c;
				if (_tmp67_ == NULL) {
					const gchar* _tmp68_;
					GeeArrayList* _tmp69_;
					gpointer _tmp70_;
					BirdFontGlyphCollection* _tmp71_;
					GeeArrayList* _tmp72_;
					gpointer _tmp73_;
					BirdFontGlyphCollection* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					BirdFontGlyphCollection* _tmp77_;
					_tmp68_ = character_string;
					_tmp69_ = self->copied_glyphs;
					_tmp70_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, i);
					_tmp71_ = (BirdFontGlyphCollection*) _tmp70_;
					_tmp72_ = self->copied_glyphs;
					_tmp73_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, i);
					_tmp74_ = (BirdFontGlyphCollection*) _tmp73_;
					_tmp75_ = bird_font_glyph_collection_get_name (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = bird_font_overview_add_empty_character_to_font (self, string_get_char (_tmp68_, (glong) 0), bird_font_glyph_collection_is_unassigned (_tmp71_), _tmp76_);
					_g_object_unref0 (gc);
					gc = _tmp77_;
					_g_free0 (_tmp76_);
					_g_object_unref0 (_tmp74_);
					_g_object_unref0 (_tmp71_);
				} else {
					BirdFontGlyphCollection* _tmp78_;
					BirdFontGlyphCollection* _tmp79_;
					_tmp78_ = c;
					_tmp79_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
					_g_object_unref0 (gc);
					gc = _tmp79_;
				}
			}
			_tmp80_ = glyphs;
			_tmp81_ = gc;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp80_, _tmp81_);
			_tmp82_ = index;
			index = _tmp82_ + 1;
		}
	}
	_tmp83_ = bird_font_overview_overview_undo_item_new ();
	_bird_font_overview_overview_undo_item_unref0 (undo_item);
	undo_item = _tmp83_;
	_tmp84_ = undo_item;
	_tmp85_ = f;
	_tmp86_ = _tmp85_->alternates;
	_tmp87_ = bird_font_alternate_sets_copy (_tmp86_);
	_g_object_unref0 (_tmp84_->alternate_sets);
	_tmp84_->alternate_sets = _tmp87_;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp88_;
		gint _g_size = 0;
		GeeArrayList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _g_index = 0;
		_tmp88_ = glyphs;
		_g_list = _tmp88_;
		_tmp89_ = _g_list;
		_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_g_size = _tmp91_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp94_;
			gpointer _tmp95_;
			BirdFontOverviewOverviewUndoItem* _tmp96_;
			GeeArrayList* _tmp97_;
			BirdFontGlyphCollection* _tmp98_;
			BirdFontGlyphCollection* _tmp99_;
			BirdFontGlyphCollection* _tmp100_;
			_g_index = _g_index + 1;
			_tmp92_ = _g_index;
			_tmp93_ = _g_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _g_list;
			_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp95_;
			_tmp96_ = undo_item;
			_tmp97_ = _tmp96_->glyphs;
			_tmp98_ = g;
			_tmp99_ = bird_font_glyph_collection_copy (_tmp98_);
			_tmp100_ = _tmp99_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp97_, _tmp100_);
			_g_object_unref0 (_tmp100_);
			_g_object_unref0 (g);
		}
	}
	_tmp101_ = undo_item;
	bird_font_overview_store_undo_items (self, _tmp101_);
	_tmp102_ = glyphs;
	_tmp103_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = self->copied_glyphs;
	_tmp106_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp105_);
	_tmp107_ = _tmp106_;
	if (_tmp104_ != _tmp107_) {
		g_warning ("Overview.vala:1729: glyphs.size != copied_glyphs.size");
		_bird_font_overview_overview_undo_item_unref0 (undo_item);
		_g_object_unref0 (f);
		_g_object_unref0 (glyphs);
		_g_free0 (character_string);
		_g_object_unref0 (glyph);
		_g_object_unref0 (c);
		_g_object_unref0 (gc);
		return;
	}
	_tmp108_ = self->copied_glyphs;
	_tmp109_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp108_);
	_tmp110_ = _tmp109_;
	if (_tmp110_ < i) {
		g_warning ("Overview.vala:1734: Array index out of bounds.");
		_bird_font_overview_overview_undo_item_unref0 (undo_item);
		_g_object_unref0 (f);
		_g_object_unref0 (glyphs);
		_g_free0 (character_string);
		_g_object_unref0 (glyph);
		_g_object_unref0 (c);
		_g_object_unref0 (gc);
		return;
	}
	i = 0;
	{
		GeeArrayList* _g_list = NULL;
		GeeArrayList* _tmp111_;
		gint _g_size = 0;
		GeeArrayList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _g_index = 0;
		_tmp111_ = glyphs;
		_g_list = _tmp111_;
		_tmp112_ = _g_list;
		_tmp113_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_g_size = _tmp114_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			BirdFontGlyphCollection* g = NULL;
			GeeArrayList* _tmp117_;
			gpointer _tmp118_;
			GeeArrayList* _tmp119_;
			gpointer _tmp120_;
			BirdFontGlyphCollection* _tmp121_;
			BirdFontGlyph* _tmp122_;
			BirdFontGlyph* _tmp123_;
			BirdFontGlyph* _tmp124_;
			gint _tmp125_ = 0;
			gboolean _tmp126_ = FALSE;
			BirdFontGlyph* _tmp127_;
			BirdFontGlyph* _tmp130_;
			BirdFontGlyph* _tmp131_;
			BirdFontGlyphCollection* _tmp132_;
			BirdFontGlyphCollection* _tmp133_;
			BirdFontGlyphCollection* _tmp140_;
			BirdFontGlyph* _tmp141_;
			gint _tmp142_;
			_g_index = _g_index + 1;
			_tmp115_ = _g_index;
			_tmp116_ = _g_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _g_list;
			_tmp118_ = gee_abstract_list_get ((GeeAbstractList*) _tmp117_, _g_index);
			g = (BirdFontGlyphCollection*) _tmp118_;
			_tmp119_ = self->copied_glyphs;
			_tmp120_ = gee_abstract_list_get ((GeeAbstractList*) _tmp119_, i);
			_tmp121_ = (BirdFontGlyphCollection*) _tmp120_;
			_tmp122_ = bird_font_glyph_collection_get_current (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = bird_font_glyph_copy (_tmp123_);
			_g_object_unref0 (glyph);
			glyph = _tmp124_;
			_g_object_unref0 (_tmp123_);
			_g_object_unref0 (_tmp121_);
			_tmp127_ = glyph;
			if (_tmp127_->version_id == -1) {
				_tmp126_ = TRUE;
			} else {
				BirdFontGlyphCollection* _tmp128_;
				_tmp128_ = g;
				_tmp126_ = bird_font_glyph_collection_length (_tmp128_) == ((guint) 0);
			}
			if (_tmp126_) {
				_tmp125_ = 1;
			} else {
				BirdFontGlyphCollection* _tmp129_;
				_tmp129_ = g;
				_tmp125_ = bird_font_glyph_collection_get_last_id (_tmp129_) + 1;
			}
			_tmp130_ = glyph;
			_tmp130_->version_id = _tmp125_;
			_tmp131_ = glyph;
			_tmp132_ = g;
			_tmp131_->unichar_code = bird_font_glyph_collection_get_unicode_character (_tmp132_);
			_tmp133_ = g;
			if (!bird_font_glyph_collection_is_unassigned (_tmp133_)) {
				BirdFontGlyph* _tmp134_;
				BirdFontGlyph* _tmp135_;
				gchar* _tmp136_;
				_tmp134_ = glyph;
				_tmp135_ = glyph;
				_tmp136_ = g_unichar_to_string (_tmp135_->unichar_code);
				_g_free0 (_tmp134_->name);
				_tmp134_->name = (gchar*) _tmp136_;
			} else {
				BirdFontGlyph* _tmp137_;
				BirdFontGlyphCollection* _tmp138_;
				gchar* _tmp139_;
				_tmp137_ = glyph;
				_tmp138_ = g;
				_tmp139_ = bird_font_glyph_collection_get_name (_tmp138_);
				_g_free0 (_tmp137_->name);
				_tmp137_->name = _tmp139_;
			}
			_tmp140_ = g;
			_tmp141_ = glyph;
			bird_font_glyph_collection_insert_glyph (_tmp140_, _tmp141_, TRUE);
			_tmp142_ = i;
			i = _tmp142_ + 1;
			_g_object_unref0 (g);
		}
	}
	_tmp143_ = f;
	bird_font_font_touch (_tmp143_);
	bird_font_overview_update_item_list (self);
	bird_font_glyph_canvas_redraw ();
	_bird_font_overview_overview_undo_item_unref0 (undo_item);
	_g_object_unref0 (f);
	_g_object_unref0 (glyphs);
	_g_free0 (character_string);
	_g_object_unref0 (glyph);
	_g_object_unref0 (c);
	_g_object_unref0 (gc);
}

static gboolean
bird_font_overview_real_needs_modifier (BirdFontFontDisplay* base)
{
	BirdFontOverview * self;
	gboolean result;
	self = (BirdFontOverview*) base;
	result = TRUE;
	return result;
}

BirdFontGlyphRange*
bird_font_overview_get_glyph_range (BirdFontOverview* self)
{
	BirdFontGlyphRange* result;
	BirdFontGlyphRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_glyph_range;
	result = _tmp0_;
	return result;
}

void
bird_font_overview_set_glyph_range (BirdFontOverview* self,
                                    BirdFontGlyphRange* value)
{
	BirdFontGlyphRange* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _bird_font_glyph_range_ref0 (value);
	_bird_font_glyph_range_unref0 (self->priv->_glyph_range);
	self->priv->_glyph_range = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, bird_font_overview_properties[BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY]);
}

gboolean
bird_font_overview_get_all_available (BirdFontOverview* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_all_available;
	return result;
}

void
bird_font_overview_set_all_available (BirdFontOverview* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_all_available = value;
	bird_font_overview_update_item_list (self);
	g_object_notify_by_pspec ((GObject *) self, bird_font_overview_properties[BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY]);
}

BirdFontOverviewOverviewUndoItem*
bird_font_overview_overview_undo_item_construct (GType object_type)
{
	BirdFontOverviewOverviewUndoItem* self = NULL;
	self = (BirdFontOverviewOverviewUndoItem*) g_type_create_instance (object_type);
	return self;
}

BirdFontOverviewOverviewUndoItem*
bird_font_overview_overview_undo_item_new (void)
{
	return bird_font_overview_overview_undo_item_construct (BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM);
}

static void
bird_font_overview_value_overview_undo_item_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_overview_value_overview_undo_item_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_overview_overview_undo_item_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_overview_value_overview_undo_item_copy_value (const GValue* src_value,
                                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_overview_overview_undo_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_overview_value_overview_undo_item_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_overview_value_overview_undo_item_collect_value (GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontOverviewOverviewUndoItem * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_overview_overview_undo_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_overview_value_overview_undo_item_lcopy_value (const GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	BirdFontOverviewOverviewUndoItem ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_overview_overview_undo_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_overview_param_spec_overview_undo_item (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags)
{
	BirdFontOverviewParamSpecOverviewUndoItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_overview_value_get_overview_undo_item (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_overview_value_set_overview_undo_item (GValue* value,
                                                 gpointer v_object)
{
	BirdFontOverviewOverviewUndoItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_overview_overview_undo_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_overview_overview_undo_item_unref (old);
	}
}

void
bird_font_overview_value_take_overview_undo_item (GValue* value,
                                                  gpointer v_object)
{
	BirdFontOverviewOverviewUndoItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_overview_overview_undo_item_unref (old);
	}
}

static void
bird_font_overview_overview_undo_item_class_init (BirdFontOverviewOverviewUndoItemClass * klass,
                                                  gpointer klass_data)
{
	bird_font_overview_overview_undo_item_parent_class = g_type_class_peek_parent (klass);
	((BirdFontOverviewOverviewUndoItemClass *) klass)->finalize = bird_font_overview_overview_undo_item_finalize;
}

static void
bird_font_overview_overview_undo_item_instance_init (BirdFontOverviewOverviewUndoItem * self,
                                                     gpointer klass)
{
	BirdFontAlternateSets* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = bird_font_alternate_sets_new ();
	self->alternate_sets = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->glyphs = _tmp1_;
	self->ref_count = 1;
}

static void
bird_font_overview_overview_undo_item_finalize (BirdFontOverviewOverviewUndoItem * obj)
{
	BirdFontOverviewOverviewUndoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM, BirdFontOverviewOverviewUndoItem);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->alternate_sets);
	_g_object_unref0 (self->glyphs);
}

static GType
bird_font_overview_overview_undo_item_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_overview_value_overview_undo_item_init, bird_font_overview_value_overview_undo_item_free_value, bird_font_overview_value_overview_undo_item_copy_value, bird_font_overview_value_overview_undo_item_peek_pointer, "p", bird_font_overview_value_overview_undo_item_collect_value, "p", bird_font_overview_value_overview_undo_item_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOverviewOverviewUndoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_overview_overview_undo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOverviewOverviewUndoItem), 0, (GInstanceInitFunc) bird_font_overview_overview_undo_item_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_overview_overview_undo_item_type_id;
	bird_font_overview_overview_undo_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontOverviewOverviewUndoItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bird_font_overview_overview_undo_item_type_id;
}

GType
bird_font_overview_overview_undo_item_get_type (void)
{
	static volatile gsize bird_font_overview_overview_undo_item_type_id__once = 0;
	if (g_once_init_enter (&bird_font_overview_overview_undo_item_type_id__once)) {
		GType bird_font_overview_overview_undo_item_type_id;
		bird_font_overview_overview_undo_item_type_id = bird_font_overview_overview_undo_item_get_type_once ();
		g_once_init_leave (&bird_font_overview_overview_undo_item_type_id__once, bird_font_overview_overview_undo_item_type_id);
	}
	return bird_font_overview_overview_undo_item_type_id__once;
}

gpointer
bird_font_overview_overview_undo_item_ref (gpointer instance)
{
	BirdFontOverviewOverviewUndoItem * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_overview_overview_undo_item_unref (gpointer instance)
{
	BirdFontOverviewOverviewUndoItem * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_OVERVIEW_OVERVIEW_UNDO_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
bird_font_overview_class_init (BirdFontOverviewClass * klass,
                               gpointer klass_data)
{
	bird_font_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontOverview_private_offset);
	((BirdFontFontDisplayClass *) klass)->has_scrollbar = (gboolean (*) (BirdFontFontDisplay*)) bird_font_overview_real_has_scrollbar;
	((BirdFontFontDisplayClass *) klass)->scroll_wheel = (void (*) (BirdFontFontDisplay*, gdouble, gdouble, gdouble, gdouble)) bird_font_overview_real_scroll_wheel;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_selected_canvas;
	((BirdFontFontDisplayClass *) klass)->zoom_min = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_zoom_min;
	((BirdFontFontDisplayClass *) klass)->reset_zoom = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_reset_zoom;
	((BirdFontFontDisplayClass *) klass)->zoom_max = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_zoom_max;
	((BirdFontFontDisplayClass *) klass)->zoom_in = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_zoom_in;
	((BirdFontFontDisplayClass *) klass)->zoom_out = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_zoom_out;
	((BirdFontFontDisplayClass *) klass)->store_current_view = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_store_current_view;
	((BirdFontFontDisplayClass *) klass)->restore_last_view = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_restore_last_view;
	((BirdFontFontDisplayClass *) klass)->next_view = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_next_view;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_overview_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_overview_real_get_name;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_overview_real_draw;
	((BirdFontFontDisplayClass *) klass)->scroll_to = (void (*) (BirdFontFontDisplay*, gdouble)) bird_font_overview_real_scroll_to;
	((BirdFontFontDisplayClass *) klass)->key_press = (void (*) (BirdFontFontDisplay*, guint)) bird_font_overview_real_key_press;
	((BirdFontFontDisplayClass *) klass)->undo = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_undo;
	((BirdFontFontDisplayClass *) klass)->redo = (void (*) (BirdFontFontDisplay*)) bird_font_overview_real_redo;
	((BirdFontFontDisplayClass *) klass)->double_click = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_overview_real_double_click;
	((BirdFontFontDisplayClass *) klass)->button_press = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_overview_real_button_press;
	((BirdFontFontDisplayClass *) klass)->needs_modifier = (gboolean (*) (BirdFontFontDisplay*)) bird_font_overview_real_needs_modifier;
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_overview_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_overview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY, bird_font_overview_properties[BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY] = bird_font_param_spec_glyph_range ("glyph-range", "glyph-range", "glyph-range", BIRD_FONT_TYPE_GLYPH_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Show all characters that has been drawn. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY, bird_font_overview_properties[BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY] = g_param_spec_boolean ("all-available", "all-available", "all-available", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_NEW_GLYPH_SIGNAL_SIGNAL] = g_signal_new ("open-new-glyph-signal", BIRD_FONT_TYPE_OVERVIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	bird_font_overview_signals[BIRD_FONT_OVERVIEW_OPEN_GLYPH_SIGNAL_SIGNAL] = g_signal_new ("open-glyph-signal", BIRD_FONT_TYPE_OVERVIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BIRD_FONT_TYPE_GLYPH_COLLECTION);
}

static void
bird_font_overview_instance_init (BirdFontOverview * self,
                                  gpointer klass)
{
	BirdFontWidgetAllocation* _tmp0_;
	BirdFontOverviewItem* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	self->priv = bird_font_overview_get_instance_private (self);
	_tmp0_ = bird_font_widget_allocation_new ();
	self->allocation = _tmp0_;
	_tmp1_ = bird_font_overview_item_new ();
	self->selected_item = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->copied_glyphs = _tmp2_;
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_COLLECTION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->selected_items = _tmp3_;
	self->priv->selected = 0;
	self->priv->first_visible = 0;
	self->priv->rows = 0;
	self->priv->items_per_row = 0;
	self->priv->view_offset_y = (gdouble) 0;
	self->priv->view_offset_x = (gdouble) 0;
	_tmp4_ = g_strdup ("");
	self->priv->search_query = _tmp4_;
	_tmp5_ = gee_array_list_new (BIRD_FONT_TYPE_OVERVIEW_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->visible_items = _tmp5_;
	_tmp6_ = gee_array_list_new (BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM, (GBoxedCopyFunc) bird_font_overview_overview_undo_item_ref, (GDestroyNotify) bird_font_overview_overview_undo_item_unref, NULL, NULL, NULL);
	self->undo_items = _tmp6_;
	_tmp7_ = gee_array_list_new (BIRD_FONT_OVERVIEW_TYPE_OVERVIEW_UNDO_ITEM, (GBoxedCopyFunc) bird_font_overview_overview_undo_item_ref, (GDestroyNotify) bird_font_overview_overview_undo_item_unref, NULL, NULL, NULL);
	self->redo_items = _tmp7_;
	self->priv->_all_available = FALSE;
	self->priv->character_info = NULL;
	self->priv->scroll_size = (gdouble) 1;
	self->priv->update_scheduled = TRUE;
}

static void
bird_font_overview_finalize (GObject * obj)
{
	BirdFontOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OVERVIEW, BirdFontOverview);
	_g_object_unref0 (self->allocation);
	_g_object_unref0 (self->selected_item);
	_g_object_unref0 (self->copied_glyphs);
	_g_object_unref0 (self->selected_items);
	_bird_font_glyph_range_unref0 (self->priv->_glyph_range);
	_g_free0 (self->priv->search_query);
	_g_object_unref0 (self->visible_items);
	_g_object_unref0 (self->undo_items);
	_g_object_unref0 (self->redo_items);
	_g_object_unref0 (self->priv->character_info);
	G_OBJECT_CLASS (bird_font_overview_parent_class)->finalize (obj);
}

/** A display with all glyphs present in this font. */
static GType
bird_font_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOverview), 0, (GInstanceInitFunc) bird_font_overview_instance_init, NULL };
	GType bird_font_overview_type_id;
	bird_font_overview_type_id = g_type_register_static (BIRD_FONT_TYPE_FONT_DISPLAY, "BirdFontOverview", &g_define_type_info, 0);
	BirdFontOverview_private_offset = g_type_add_instance_private (bird_font_overview_type_id, sizeof (BirdFontOverviewPrivate));
	return bird_font_overview_type_id;
}

GType
bird_font_overview_get_type (void)
{
	static volatile gsize bird_font_overview_type_id__once = 0;
	if (g_once_init_enter (&bird_font_overview_type_id__once)) {
		GType bird_font_overview_type_id;
		bird_font_overview_type_id = bird_font_overview_get_type_once ();
		g_once_init_leave (&bird_font_overview_type_id__once, bird_font_overview_type_id);
	}
	return bird_font_overview_type_id__once;
}

static void
_vala_bird_font_overview_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BirdFontOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_OVERVIEW, BirdFontOverview);
	switch (property_id) {
		case BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY:
		bird_font_value_set_glyph_range (value, bird_font_overview_get_glyph_range (self));
		break;
		case BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY:
		g_value_set_boolean (value, bird_font_overview_get_all_available (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_overview_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BirdFontOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_OVERVIEW, BirdFontOverview);
	switch (property_id) {
		case BIRD_FONT_OVERVIEW_GLYPH_RANGE_PROPERTY:
		bird_font_overview_set_glyph_range (self, bird_font_value_get_glyph_range (value));
		break;
		case BIRD_FONT_OVERVIEW_ALL_AVAILABLE_PROPERTY:
		bird_font_overview_set_all_available (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

