/* OtfTable.c generated by valac 0.56.16, the Vala compiler
 * generated from OtfTable.vala, do not modify */

/*
Copyright (C) 2012, 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_OTF_TABLE_0_PROPERTY,
	BIRD_FONT_OTF_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_otf_table_properties[BIRD_FONT_OTF_TABLE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer bird_font_otf_table_parent_class = NULL;

static gchar* bird_font_otf_table_real_get_id (BirdFontOtfTable* self);
static void bird_font_otf_table_real_parse (BirdFontOtfTable* self,
                                     BirdFontFontData* dis,
                                     GError** error);
static void bird_font_otf_table_finalize (GObject * obj);
static GType bird_font_otf_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar*
bird_font_otf_table_real_get_id (BirdFontOtfTable* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->id;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
bird_font_otf_table_get_id (BirdFontOtfTable* self)
{
	BirdFontOtfTableClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BIRD_FONT_OTF_TABLE_GET_CLASS (self);
	if (_klass_->get_id) {
		return _klass_->get_id (self);
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontFontData*
bird_font_otf_table_get_font_data (BirdFontOtfTable* self)
{
	BirdFontFontData* _tmp0_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->font_data;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		BirdFontFontData* _tmp5_;
		_tmp1_ = self->id;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("No font data for ", _tmp2_, ".", NULL);
		_tmp4_ = _tmp3_;
		g_warning ("OtfTable.vala:33: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = bird_font_font_data_new ((guint32) 1024);
		_g_object_unref0 (self->font_data);
		self->font_data = _tmp5_;
	}
	_tmp6_ = self->font_data;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BIRD_FONT_TYPE_FONT_DATA, BirdFontFontData));
	result = _tmp7_;
	return result;
}

gboolean
bird_font_otf_table_has_data (BirdFontOtfTable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->length > ((guint32) 0);
	return result;
}

static void
bird_font_otf_table_real_parse (BirdFontOtfTable* self,
                                BirdFontFontData* dis,
                                GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (dis != NULL);
	_tmp0_ = self->id;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Parse is not implemented for ", _tmp1_, ".", NULL);
	_tmp3_ = _tmp2_;
	g_warning ("OtfTable.vala:45: %s", _tmp3_);
	_g_free0 (_tmp3_);
}

void
bird_font_otf_table_parse (BirdFontOtfTable* self,
                           BirdFontFontData* dis,
                           GError** error)
{
	BirdFontOtfTableClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BIRD_FONT_OTF_TABLE_GET_CLASS (self);
	if (_klass_->parse) {
		_klass_->parse (self, dis, error);
	}
}

/** Validate table checksum. */
gboolean
bird_font_otf_table_validate (BirdFontOtfTable* self,
                              BirdFontFontData* dis)
{
	gboolean valid = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dis != NULL, FALSE);
	if (self->length == ((guint32) 0)) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = stderr;
		_tmp1_ = self->id;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("OtfTable ", _tmp2_, " is of zero length.\n", NULL);
		_tmp4_ = _tmp3_;
		fprintf (_tmp0_, "%s", _tmp4_);
		_g_free0 (_tmp4_);
		valid = FALSE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = self->id;
		valid = bird_font_otf_table_validate_table (dis, self->checksum, self->offset, self->length, _tmp5_);
	}
	if (!valid) {
		FILE* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = stderr;
		_tmp7_ = self->id;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("OtfTable ", _tmp8_, " is invalid.\n", NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp6_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
	}
	result = valid;
	return result;
}

gboolean
bird_font_otf_table_validate_table (BirdFontFontData* dis,
                                    guint32 checksum,
                                    guint32 offset,
                                    guint32 length,
                                    const gchar* name)
{
	guint32 ch = 0U;
	gboolean c = FALSE;
	gboolean result;
	g_return_val_if_fail (dis != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	ch = bird_font_otf_table_calculate_checksum (dis, offset, length, name);
	c = ch == checksum;
	if (!c) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		FILE* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		FILE* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp0_ = stderr;
		_tmp1_ = string_to_string (name);
		_tmp2_ = g_strconcat ("Checksum does not match data for ", _tmp1_, ".\n", NULL);
		_tmp3_ = _tmp2_;
		fprintf (_tmp0_, "%s", _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = stderr;
		_tmp5_ = string_to_string (name);
		_tmp6_ = g_strdup_printf ("%u", checksum);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%u", offset);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%u", length);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("name: ", _tmp5_, ", checksum: ", _tmp7_, ", offset: ", _tmp9_, ", length: ", _tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp4_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_tmp14_ = stderr;
		_tmp15_ = g_strdup_printf ("%u", ch);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat ("calculated checksum ", _tmp16_, "\n", NULL);
		_tmp18_ = _tmp17_;
		fprintf (_tmp14_, "%s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	result = c;
	return result;
}

guint32
bird_font_otf_table_calculate_checksum (BirdFontFontData* dis,
                                        guint32 offset,
                                        guint32 length,
                                        const gchar* name)
{
	guint32 checksum = 0U;
	guint32 l = 0U;
	guint32 _tmp0_ = 0U;
	guint32 result;
	g_return_val_if_fail (dis != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	checksum = (guint32) 0;
	bird_font_font_data_seek (dis, (guint) offset);
	if ((length % 4) > ((guint32) 0)) {
		_tmp0_ = (length / 4) + 1;
	} else {
		_tmp0_ = length / 4;
	}
	l = _tmp0_;
	{
		guint32 i = 0U;
		i = (guint32) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint32 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < l)) {
					break;
				}
				checksum += bird_font_font_data_read_ulong (dis);
			}
		}
	}
	result = checksum;
	return result;
}

guint16
bird_font_otf_table_max_pow_2_less_than_i (guint16 ind)
{
	guint16 last = 0U;
	guint16 i = 0U;
	guint16 result;
	last = (guint16) 0;
	i = (guint16) 1;
	while (TRUE) {
		i <<= (guint16) 1;
		if (!(i < ind)) {
			break;
		}
		last = i;
	}
	result = last;
	return result;
}

guint16
bird_font_otf_table_max_log_2_less_than_i (guint16 ind)
{
	guint16 result;
	result = (guint16) (log ((gdouble) ind) / log ((gdouble) 2));
	return result;
}

BirdFontOtfTable*
bird_font_otf_table_construct (GType object_type)
{
	BirdFontOtfTable * self = NULL;
	self = (BirdFontOtfTable*) g_object_new (object_type, NULL);
	return self;
}

BirdFontOtfTable*
bird_font_otf_table_new (void)
{
	return bird_font_otf_table_construct (BIRD_FONT_TYPE_OTF_TABLE);
}

static void
bird_font_otf_table_class_init (BirdFontOtfTableClass * klass,
                                gpointer klass_data)
{
	bird_font_otf_table_parent_class = g_type_class_peek_parent (klass);
	((BirdFontOtfTableClass *) klass)->get_id = (gchar* (*) (BirdFontOtfTable*)) bird_font_otf_table_real_get_id;
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_otf_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_otf_table_finalize;
}

static void
bird_font_otf_table_instance_init (BirdFontOtfTable * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("NO_ID");
	self->id = _tmp0_;
	self->checksum = (guint32) 0;
	self->offset = (guint32) 0;
	self->length = (guint32) 0;
	self->font_data = NULL;
}

static void
bird_font_otf_table_finalize (GObject * obj)
{
	BirdFontOtfTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OTF_TABLE, BirdFontOtfTable);
	_g_free0 (self->id);
	_g_object_unref0 (self->font_data);
	G_OBJECT_CLASS (bird_font_otf_table_parent_class)->finalize (obj);
}

static GType
bird_font_otf_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOtfTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_otf_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOtfTable), 0, (GInstanceInitFunc) bird_font_otf_table_instance_init, NULL };
	GType bird_font_otf_table_type_id;
	bird_font_otf_table_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontOtfTable", &g_define_type_info, 0);
	return bird_font_otf_table_type_id;
}

GType
bird_font_otf_table_get_type (void)
{
	static volatile gsize bird_font_otf_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_otf_table_type_id__once)) {
		GType bird_font_otf_table_type_id;
		bird_font_otf_table_type_id = bird_font_otf_table_get_type_once ();
		g_once_init_leave (&bird_font_otf_table_type_id__once, bird_font_otf_table_type_id);
	}
	return bird_font_otf_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

