/* OpenFontFormatReader.c generated by valac 0.56.16, the Vala compiler
 * generated from OpenFontFormatReader.vala, do not modify */

/*
Copyright (C) 2012, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _ParamSpecFontFace ParamSpecFontFace;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BIRD_FONT_TYPE_BAD_FORMAT (bird_font_bad_format_get_type ())
enum  {
	BIRD_FONT_OPEN_FONT_FORMAT_READER_0_PROPERTY,
	BIRD_FONT_OPEN_FONT_FORMAT_READER_NUM_PROPERTIES
};
static GParamSpec* bird_font_open_font_format_reader_properties[BIRD_FONT_OPEN_FONT_FORMAT_READER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ParamSpecFontFace {
	GParamSpec parent_instance;
};

typedef enum  {
	BIRD_FONT_BAD_FORMAT_PARSE
} BirdFontBadFormat;
#define BIRD_FONT_BAD_FORMAT bird_font_bad_format_quark ()

struct _BirdFontOpenFontFormatReaderPrivate {
	BirdFontOtfInputStream* dis;
	GFile* file;
};

static gpointer font_face_parent_class = NULL;
static gint BirdFontOpenFontFormatReader_private_offset;
static gpointer bird_font_open_font_format_reader_parent_class = NULL;

static void font_face_finalize (FontFace * obj);
static GType font_face_get_type_once (void);
VALA_EXTERN GQuark bird_font_bad_format_quark (void);
VALA_EXTERN GType bird_font_bad_format_get_type (void) G_GNUC_CONST ;
static void bird_font_open_font_format_reader_parse_index_tables (BirdFontOpenFontFormatReader* self,
                                                           GError** error);
static void bird_font_open_font_format_reader_add_kerning (GString* bf_kerning,
                                                    gunichar left,
                                                    gunichar right,
                                                    gdouble kerning);
VALA_EXTERN gchar* bird_font_bird_font_file_encode (const gchar* s);
static void bird_font_open_font_format_reader_finalize (GObject * obj);
static GType bird_font_open_font_format_reader_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

FontFace*
font_face_construct (GType object_type)
{
	FontFace* self = NULL;
	self = (FontFace*) g_type_create_instance (object_type);
	return self;
}

FontFace*
font_face_new (void)
{
	return font_face_construct (TYPE_FONT_FACE);
}

static void
value_font_face_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_font_face_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		font_face_unref (value->data[0].v_pointer);
	}
}

static void
value_font_face_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = font_face_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_font_face_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_font_face_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FontFace * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = font_face_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_font_face_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	FontFace ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = font_face_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_font_face (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecFontFace* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FONT_FACE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_font_face (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FONT_FACE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_font_face (GValue* value,
                     gpointer v_object)
{
	FontFace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FONT_FACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FONT_FACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		font_face_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		font_face_unref (old);
	}
}

void
value_take_font_face (GValue* value,
                      gpointer v_object)
{
	FontFace * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FONT_FACE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FONT_FACE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		font_face_unref (old);
	}
}

static void
font_face_class_init (FontFaceClass * klass,
                      gpointer klass_data)
{
	font_face_parent_class = g_type_class_peek_parent (klass);
	((FontFaceClass *) klass)->finalize = font_face_finalize;
}

static void
font_face_instance_init (FontFace * self,
                         gpointer klass)
{
	self->ref_count = 1;
}

static void
font_face_finalize (FontFace * obj)
{
	FontFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FONT_FACE, FontFace);
	g_signal_handlers_destroy (self);
}

static GType
font_face_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_font_face_init, value_font_face_free_value, value_font_face_copy_value, value_font_face_peek_pointer, "p", value_font_face_collect_value, "p", value_font_face_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FontFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontFace), 0, (GInstanceInitFunc) font_face_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType font_face_type_id;
	font_face_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FontFace", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return font_face_type_id;
}

GType
font_face_get_type (void)
{
	static volatile gsize font_face_type_id__once = 0;
	if (g_once_init_enter (&font_face_type_id__once)) {
		GType font_face_type_id;
		font_face_type_id = font_face_get_type_once ();
		g_once_init_leave (&font_face_type_id__once, font_face_type_id);
	}
	return font_face_type_id__once;
}

gpointer
font_face_ref (gpointer instance)
{
	FontFace * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
font_face_unref (gpointer instance)
{
	FontFace * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FONT_FACE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

gboolean
bird_font_fixed_equals (BirdFontFixed self,
                        guint16 upper,
                        guint16 lower)
{
	guint32 t = 0U;
	gboolean result;
	t = (guint32) ((upper << 16) + lower);
	result = t == ((guint32) self);
	return result;
}

gchar*
bird_font_fixed_get_string (BirdFontFixed self)
{
	guint a = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	a = (guint) (self >> 16);
	_tmp0_ = g_strdup_printf ("%u", a);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%u", (guint32) (self - (a << 16)));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, ".", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

GQuark
bird_font_bad_format_quark (void)
{
	return g_quark_from_static_string ("bird-font-bad-format-quark");
}

static GType
bird_font_bad_format_get_type_once (void)
{
	static const GEnumValue values[] = {{BIRD_FONT_BAD_FORMAT_PARSE, "BIRD_FONT_BAD_FORMAT_PARSE", "parse"}, {0, NULL, NULL}};
	GType bird_font_bad_format_type_id;
	bird_font_bad_format_type_id = g_enum_register_static ("BirdFontBadFormat", values);
	return bird_font_bad_format_type_id;
}

GType
bird_font_bad_format_get_type (void)
{
	static volatile gsize bird_font_bad_format_type_id__once = 0;
	if (g_once_init_enter (&bird_font_bad_format_type_id__once)) {
		GType bird_font_bad_format_type_id;
		bird_font_bad_format_type_id = bird_font_bad_format_get_type_once ();
		g_once_init_leave (&bird_font_bad_format_type_id__once, bird_font_bad_format_type_id);
	}
	return bird_font_bad_format_type_id__once;
}

static inline gpointer
bird_font_open_font_format_reader_get_instance_private (BirdFontOpenFontFormatReader* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontOpenFontFormatReader_private_offset);
}

BirdFontOpenFontFormatReader*
bird_font_open_font_format_reader_construct (GType object_type)
{
	BirdFontOpenFontFormatReader * self = NULL;
	BirdFontDirectoryTable* _tmp0_;
	self = (BirdFontOpenFontFormatReader*) g_object_new (object_type, NULL);
	_tmp0_ = bird_font_directory_table_new ();
	_g_object_unref0 (self->directory_table);
	self->directory_table = _tmp0_;
	return self;
}

BirdFontOpenFontFormatReader*
bird_font_open_font_format_reader_new (void)
{
	return bird_font_open_font_format_reader_construct (BIRD_FONT_TYPE_OPEN_FONT_FORMAT_READER);
}

void
bird_font_open_font_format_reader_close (BirdFontOpenFontFormatReader* self)
{
	BirdFontOtfInputStream* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dis;
	bird_font_otf_input_stream_close (_tmp0_);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
bird_font_open_font_format_reader_parse_index (BirdFontOpenFontFormatReader* self,
                                               const gchar* file_name,
                                               GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInputStream* _tmp10_ = NULL;
	GFile* _tmp11_;
	GFileInputStream* _tmp12_;
	BirdFontOtfInputStream* _tmp13_ = NULL;
	BirdFontOtfInputStream* _tmp14_;
	BirdFontOtfInputStream* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = g_file_new_for_path (file_name);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	_tmp1_ = self->priv->file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
		_tmp2_ = self->priv->file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = (gchar*) _tmp3_;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("OpenFontFormatReader: file does not exist. ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_EXIST, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp9_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp11_ = self->priv->file;
	_tmp12_ = g_file_read (_tmp11_, NULL, &_inner_error0_);
	_tmp10_ = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp14_ = bird_font_otf_input_stream_new (_tmp10_, &_inner_error0_);
	_tmp13_ = _tmp14_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp10_);
		return;
	}
	_tmp15_ = _tmp13_;
	_tmp13_ = NULL;
	_g_object_unref0 (self->priv->dis);
	self->priv->dis = _tmp15_;
	bird_font_open_font_format_reader_parse_index_tables (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (_tmp10_);
		return;
	}
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp10_);
}

static void
bird_font_open_font_format_reader_parse_index_tables (BirdFontOpenFontFormatReader* self,
                                                      GError** error)
{
	BirdFontOffsetTable* offset_table = NULL;
	GFileInfo* file_info = NULL;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	guint32 file_size = 0U;
	GFileInfo* _tmp2_;
	BirdFontDirectoryTable* _tmp10_;
	BirdFontOffsetTable* _tmp11_;
	BirdFontOffsetTable* _tmp12_;
	BirdFontFontData* _tmp13_;
	BirdFontDirectoryTable* _tmp14_;
	BirdFontDirectoryTable* _tmp15_;
	BirdFontOffsetTable* _tmp16_;
	BirdFontDirectoryTable* _tmp17_;
	BirdFontFontData* _tmp18_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = g_file_query_info (_tmp0_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (offset_table);
		return;
	}
	_tmp2_ = file_info;
	file_size = (guint32) g_file_info_get_size (_tmp2_);
	{
		BirdFontFontData* _tmp3_;
		BirdFontOtfInputStream* _tmp4_;
		_tmp3_ = self->font_data;
		_tmp4_ = self->priv->dis;
		bird_font_font_data_write_table (_tmp3_, _tmp4_, (guint32) 0, file_size, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Failed to read font data. ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("OpenFontFormatReader.vala:82: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (offset_table);
		return;
	}
	_tmp10_ = self->directory_table;
	_tmp11_ = bird_font_offset_table_new (_tmp10_);
	_g_object_unref0 (offset_table);
	offset_table = _tmp11_;
	_tmp12_ = offset_table;
	_tmp13_ = self->font_data;
	bird_font_otf_table_parse ((BirdFontOtfTable*) _tmp12_, _tmp13_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (offset_table);
		return;
	}
	_tmp14_ = bird_font_directory_table_new ();
	_g_object_unref0 (self->directory_table);
	self->directory_table = _tmp14_;
	_tmp15_ = self->directory_table;
	_tmp16_ = offset_table;
	bird_font_directory_table_set_offset_table (_tmp15_, _tmp16_);
	_tmp17_ = self->directory_table;
	_tmp18_ = self->font_data;
	bird_font_directory_table_parse (_tmp17_, _tmp18_, self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (offset_table);
		return;
	}
	_g_object_unref0 (file_info);
	_g_object_unref0 (offset_table);
}

void
bird_font_open_font_format_reader_parse_all_tables (BirdFontOpenFontFormatReader* self,
                                                    GError** error)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontFontData* _tmp1_;
	BirdFontDirectoryTable* _tmp2_;
	BirdFontFontData* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->directory_table;
	_tmp1_ = self->font_data;
	bird_font_directory_table_parse_all_tables (_tmp0_, _tmp1_, self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = self->directory_table;
	_tmp3_ = self->font_data;
	_tmp4_ = self->priv->file;
	if (!bird_font_directory_table_validate_tables (_tmp2_, _tmp3_, _tmp4_)) {
		g_warning ("OpenFontFormatReader.vala:97: Missing required table or bad checksum.");
	}
}

void
bird_font_open_font_format_reader_parse_kern_table (BirdFontOpenFontFormatReader* self,
                                                    GError** error)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontFontData* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->directory_table;
	_tmp1_ = self->font_data;
	bird_font_directory_table_parse_kern_table (_tmp0_, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_open_font_format_reader_parse_cmap_table (BirdFontOpenFontFormatReader* self,
                                                    GError** error)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontFontData* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->directory_table;
	_tmp1_ = self->font_data;
	bird_font_directory_table_parse_cmap_table (_tmp0_, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_open_font_format_reader_parse_head_table (BirdFontOpenFontFormatReader* self,
                                                    GError** error)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontFontData* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->directory_table;
	_tmp1_ = self->font_data;
	bird_font_directory_table_parse_head_table (_tmp0_, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
bird_font_open_font_format_reader_parse_fk_table (BirdFontOpenFontFormatReader* self,
                                                  GError** error)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontFontData* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->directory_table;
	_tmp1_ = self->font_data;
	bird_font_directory_table_parse_fk_table (_tmp0_, _tmp1_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_open_font_format_reader_set_limits (BirdFontOpenFontFormatReader* self)
{
	BirdFontFont* f = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_open_font_format_writer_font;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	f = _tmp1_;
	_tmp2_ = f;
	if (bird_font_is_null (_tmp2_)) {
		BirdFontFont* _tmp3_;
		_tmp3_ = bird_font_bird_font_get_current_font ();
		_g_object_unref0 (f);
		f = _tmp3_;
	}
	_g_object_unref0 (f);
}

guint32
bird_font_open_font_format_reader_get_head_checksum (BirdFontOpenFontFormatReader* self)
{
	BirdFontDirectoryTable* _tmp0_;
	BirdFontHeadTable* _tmp1_;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->directory_table;
	_tmp1_ = _tmp0_->head_table;
	result = bird_font_head_table_get_adjusted_checksum (_tmp1_);
	return result;
}

void
bird_font_open_font_format_reader_append_kerning (GString* bf_data,
                                                  const gchar* file_name)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	g_return_if_fail (bf_data != NULL);
	g_return_if_fail (file_name != NULL);
	_tmp0_ = bird_font_open_font_format_reader_parse_kerning (file_name);
	s = _tmp0_;
	g_string_append (bf_data, s);
	_g_free0 (s);
}

gchar*
bird_font_open_font_format_reader_parse_kerning (const gchar* file_name)
{
	BirdFontKernTable* kern_table = NULL;
	BirdFontCmapTable* cmap_table = NULL;
	BirdFontHeadTable* head_table = NULL;
	BirdFontOpenFontFormatReader* reader = NULL;
	BirdFontOpenFontFormatReader* _tmp0_;
	GString* bf_kerning = NULL;
	GString* _tmp1_;
	gunichar left = 0U;
	gunichar right = 0U;
	gdouble kerning = 0.0;
	gdouble units_per_em = 0.0;
	guint npairs = 0U;
	GString* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file_name != NULL, NULL);
	_tmp0_ = bird_font_open_font_format_reader_new ();
	reader = _tmp0_;
	_tmp1_ = g_string_new ("");
	bf_kerning = _tmp1_;
	npairs = (guint) 0;
	{
		BirdFontOpenFontFormatReader* _tmp2_;
		BirdFontOpenFontFormatReader* _tmp3_;
		BirdFontOpenFontFormatReader* _tmp4_;
		BirdFontOpenFontFormatReader* _tmp5_;
		BirdFontOpenFontFormatReader* _tmp6_;
		BirdFontOpenFontFormatReader* _tmp7_;
		BirdFontDirectoryTable* _tmp8_;
		BirdFontKernTable* _tmp9_;
		BirdFontKernTable* _tmp10_;
		BirdFontOpenFontFormatReader* _tmp11_;
		BirdFontDirectoryTable* _tmp12_;
		BirdFontCmapTable* _tmp13_;
		BirdFontCmapTable* _tmp14_;
		BirdFontOpenFontFormatReader* _tmp15_;
		BirdFontDirectoryTable* _tmp16_;
		BirdFontHeadTable* _tmp17_;
		BirdFontHeadTable* _tmp18_;
		BirdFontKernTable* _tmp19_;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		BirdFontKernTable* _tmp53_;
		GeeArrayList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp2_ = reader;
		bird_font_open_font_format_reader_parse_index (_tmp2_, file_name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = reader;
		bird_font_open_font_format_reader_parse_kern_table (_tmp3_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = reader;
		bird_font_open_font_format_reader_parse_cmap_table (_tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = reader;
		bird_font_open_font_format_reader_parse_head_table (_tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = reader;
		bird_font_open_font_format_reader_parse_fk_table (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = reader;
		_tmp8_ = _tmp7_->directory_table;
		_tmp9_ = _tmp8_->kern_table;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (kern_table);
		kern_table = _tmp10_;
		_tmp11_ = reader;
		_tmp12_ = _tmp11_->directory_table;
		_tmp13_ = _tmp12_->cmap_table;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (cmap_table);
		cmap_table = _tmp14_;
		_tmp15_ = reader;
		_tmp16_ = _tmp15_->directory_table;
		_tmp17_ = _tmp16_->head_table;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_g_object_unref0 (head_table);
		head_table = _tmp18_;
		_tmp19_ = kern_table;
		_tmp20_ = _tmp19_->kerning;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		npairs = (guint) _tmp22_;
		units_per_em = (gdouble) bird_font_head_table_units_per_em;
		{
			GeeArrayList* _k_list = NULL;
			BirdFontKernTable* _tmp23_;
			GeeArrayList* _tmp24_;
			gint _k_size = 0;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _k_index = 0;
			_tmp23_ = kern_table;
			_tmp24_ = _tmp23_->kerning;
			_k_list = _tmp24_;
			_tmp25_ = _k_list;
			_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			_k_size = _tmp27_;
			_k_index = -1;
			while (TRUE) {
				gint _tmp28_;
				gint _tmp29_;
				BirdFontKern* k = NULL;
				GeeArrayList* _tmp30_;
				gpointer _tmp31_;
				BirdFontCmapTable* _tmp32_;
				BirdFontKern* _tmp33_;
				BirdFontCmapTable* _tmp34_;
				BirdFontKern* _tmp35_;
				BirdFontKern* _tmp36_;
				GString* _tmp37_;
				_k_index = _k_index + 1;
				_tmp28_ = _k_index;
				_tmp29_ = _k_size;
				if (!(_tmp28_ < _tmp29_)) {
					break;
				}
				_tmp30_ = _k_list;
				_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _k_index);
				k = (BirdFontKern*) _tmp31_;
				_tmp32_ = cmap_table;
				_tmp33_ = k;
				left = bird_font_cmap_table_get_char (_tmp32_, (guint32) _tmp33_->left);
				_tmp34_ = cmap_table;
				_tmp35_ = k;
				right = bird_font_cmap_table_get_char (_tmp34_, (guint32) _tmp35_->right);
				_tmp36_ = k;
				kerning = 100 * (_tmp36_->kerning / units_per_em);
				_tmp37_ = bf_kerning;
				bird_font_open_font_format_reader_add_kerning (_tmp37_, left, right, kerning);
				_g_object_unref0 (k);
			}
		}
		{
			GeeArrayList* _k_list = NULL;
			BirdFontKernTable* _tmp38_;
			GeeArrayList* _tmp39_;
			gint _k_size = 0;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _k_index = 0;
			_tmp38_ = kern_table;
			_tmp39_ = _tmp38_->fk_kerning;
			_k_list = _tmp39_;
			_tmp40_ = _k_list;
			_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_k_size = _tmp42_;
			_k_index = -1;
			while (TRUE) {
				gint _tmp43_;
				gint _tmp44_;
				BirdFontFkKern* k = NULL;
				GeeArrayList* _tmp45_;
				gpointer _tmp46_;
				BirdFontCmapTable* _tmp47_;
				BirdFontFkKern* _tmp48_;
				BirdFontCmapTable* _tmp49_;
				BirdFontFkKern* _tmp50_;
				BirdFontFkKern* _tmp51_;
				GString* _tmp52_;
				_k_index = _k_index + 1;
				_tmp43_ = _k_index;
				_tmp44_ = _k_size;
				if (!(_tmp43_ < _tmp44_)) {
					break;
				}
				_tmp45_ = _k_list;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _k_index);
				k = (BirdFontFkKern*) _tmp46_;
				_tmp47_ = cmap_table;
				_tmp48_ = k;
				left = bird_font_cmap_table_get_char (_tmp47_, (guint32) _tmp48_->left);
				_tmp49_ = cmap_table;
				_tmp50_ = k;
				right = bird_font_cmap_table_get_char (_tmp49_, (guint32) _tmp50_->right);
				_tmp51_ = k;
				kerning = 100 * (_tmp51_->kerning / units_per_em);
				_tmp52_ = bf_kerning;
				bird_font_open_font_format_reader_add_kerning (_tmp52_, left, right, kerning);
				_g_object_unref0 (k);
			}
		}
		_tmp53_ = kern_table;
		_tmp54_ = _tmp53_->fk_kerning;
		_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strdup_printf ("%i", _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strconcat ("FK kerning pairs: ", _tmp58_, "\n", NULL);
		_tmp60_ = _tmp59_;
		bird_font_printd (_tmp60_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp61_;
		const gchar* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp61_ = e;
		_tmp62_ = _tmp61_->message;
		_tmp63_ = string_to_string (_tmp62_);
		_tmp64_ = g_strconcat ("Failed to parse font. ", _tmp63_, NULL);
		_tmp65_ = _tmp64_;
		g_warning ("OpenFontFormatReader.vala:179: %s", _tmp65_);
		_g_free0 (_tmp65_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (bf_kerning);
		_g_object_unref0 (reader);
		_g_object_unref0 (head_table);
		_g_object_unref0 (cmap_table);
		_g_object_unref0 (kern_table);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp66_ = bf_kerning;
	_tmp67_ = _tmp66_->str;
	_tmp68_ = g_strdup (_tmp67_);
	result = _tmp68_;
	_g_string_free0 (bf_kerning);
	_g_object_unref0 (reader);
	_g_object_unref0 (head_table);
	_g_object_unref0 (cmap_table);
	_g_object_unref0 (kern_table);
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
bird_font_open_font_format_reader_add_kerning (GString* bf_kerning,
                                               gunichar left,
                                               gunichar right,
                                               gdouble kerning)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (bf_kerning != NULL);
	if (left <= ((gunichar) 0x1F)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = right <= ((gunichar) 0x1F);
	}
	if (_tmp0_) {
		g_warning ("OpenFontFormatReader.vala:187: Ignoring kerning of control character.");
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = double_to_string (kerning);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strcmp0 (_tmp2_, "0") != 0;
		_g_free0 (_tmp2_);
		if (_tmp3_) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			g_string_append (bf_kerning, "<kerning left=\"");
			_tmp4_ = g_unichar_to_string (left);
			_tmp5_ = (gchar*) _tmp4_;
			_tmp6_ = bird_font_bird_font_file_encode (_tmp5_);
			_tmp7_ = _tmp6_;
			g_string_append (bf_kerning, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			g_string_append (bf_kerning, "\" ");
			g_string_append (bf_kerning, "right=\"");
			_tmp8_ = g_unichar_to_string (right);
			_tmp9_ = (gchar*) _tmp8_;
			_tmp10_ = bird_font_bird_font_file_encode (_tmp9_);
			_tmp11_ = _tmp10_;
			g_string_append (bf_kerning, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			g_string_append (bf_kerning, "\" ");
			g_string_append (bf_kerning, "hadjustment=\"");
			_tmp12_ = double_to_string (kerning);
			_tmp13_ = _tmp12_;
			_tmp14_ = string_replace (_tmp13_, ",", ".");
			_tmp15_ = _tmp14_;
			g_string_append (bf_kerning, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
			g_string_append (bf_kerning, "\" />\n");
		}
	}
}

static void
bird_font_open_font_format_reader_class_init (BirdFontOpenFontFormatReaderClass * klass,
                                              gpointer klass_data)
{
	bird_font_open_font_format_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontOpenFontFormatReader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_open_font_format_reader_finalize;
}

static void
bird_font_open_font_format_reader_instance_init (BirdFontOpenFontFormatReader * self,
                                                 gpointer klass)
{
	BirdFontFontData* _tmp0_;
	self->priv = bird_font_open_font_format_reader_get_instance_private (self);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	self->font_data = _tmp0_;
}

static void
bird_font_open_font_format_reader_finalize (GObject * obj)
{
	BirdFontOpenFontFormatReader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OPEN_FONT_FORMAT_READER, BirdFontOpenFontFormatReader);
	_g_object_unref0 (self->directory_table);
	_g_object_unref0 (self->font_data);
	_g_object_unref0 (self->priv->dis);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (bird_font_open_font_format_reader_parent_class)->finalize (obj);
}

static GType
bird_font_open_font_format_reader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOpenFontFormatReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_open_font_format_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOpenFontFormatReader), 0, (GInstanceInitFunc) bird_font_open_font_format_reader_instance_init, NULL };
	GType bird_font_open_font_format_reader_type_id;
	bird_font_open_font_format_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontOpenFontFormatReader", &g_define_type_info, 0);
	BirdFontOpenFontFormatReader_private_offset = g_type_add_instance_private (bird_font_open_font_format_reader_type_id, sizeof (BirdFontOpenFontFormatReaderPrivate));
	return bird_font_open_font_format_reader_type_id;
}

GType
bird_font_open_font_format_reader_get_type (void)
{
	static volatile gsize bird_font_open_font_format_reader_type_id__once = 0;
	if (g_once_init_enter (&bird_font_open_font_format_reader_type_id__once)) {
		GType bird_font_open_font_format_reader_type_id;
		bird_font_open_font_format_reader_type_id = bird_font_open_font_format_reader_get_type_once ();
		g_once_init_leave (&bird_font_open_font_format_reader_type_id__once, bird_font_open_font_format_reader_type_id);
	}
	return bird_font_open_font_format_reader_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

