/* OffsetTable.c generated by valac 0.56.16, the Vala compiler
 * generated from OffsetTable.vala, do not modify */

/*
Copyright (C) 2012, 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_OFFSET_TABLE_0_PROPERTY,
	BIRD_FONT_OFFSET_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_offset_table_properties[BIRD_FONT_OFFSET_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontOffsetTablePrivate {
	BirdFontDirectoryTable* directory_table;
	guint16 search_range;
	guint16 entry_selector;
	guint16 range_shift;
};

static gint BirdFontOffsetTable_private_offset;
static gpointer bird_font_offset_table_parent_class = NULL;

static void bird_font_offset_table_real_parse (BirdFontOtfTable* base,
                                        BirdFontFontData* dis,
                                        GError** error);
static void bird_font_offset_table_finalize (GObject * obj);
static GType bird_font_offset_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_offset_table_get_instance_private (BirdFontOffsetTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontOffsetTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontOffsetTable*
bird_font_offset_table_construct (GType object_type,
                                  BirdFontDirectoryTable* t)
{
	BirdFontOffsetTable * self = NULL;
	gchar* _tmp0_;
	BirdFontDirectoryTable* _tmp1_;
	g_return_val_if_fail (t != NULL, NULL);
	self = (BirdFontOffsetTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("Offset table");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	_tmp1_ = _g_object_ref0 (t);
	_g_object_unref0 (self->priv->directory_table);
	self->priv->directory_table = _tmp1_;
	return self;
}

BirdFontOffsetTable*
bird_font_offset_table_new (BirdFontDirectoryTable* t)
{
	return bird_font_offset_table_construct (BIRD_FONT_TYPE_OFFSET_TABLE, t);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_offset_table_real_parse (BirdFontOtfTable* base,
                                   BirdFontFontData* dis,
                                   GError** error)
{
	BirdFontOffsetTable * self;
	BirdFontFixed version = 0U;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self = (BirdFontOffsetTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	version = bird_font_font_data_read_fixed (dis);
	self->num_tables = bird_font_font_data_read_ushort (dis);
	self->priv->search_range = bird_font_font_data_read_ushort (dis);
	self->priv->entry_selector = bird_font_font_data_read_ushort (dis);
	self->priv->range_shift = bird_font_font_data_read_ushort (dis);
	_tmp0_ = bird_font_fixed_get_string (version);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("Font file version ", _tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	bird_font_printd (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
	_tmp5_ = g_strdup_printf ("%hu", self->num_tables);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("Number of tables ", _tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	bird_font_printd (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}

void
bird_font_offset_table_process (BirdFontOffsetTable* self,
                                GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFixed version = 0U;
	BirdFontDirectoryTable* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontFontData* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	version = (BirdFontFixed) 0x00010000;
	_tmp1_ = self->priv->directory_table;
	_tmp2_ = bird_font_directory_table_get_tables (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	self->num_tables = (guint16) (((guint16) _tmp5_) - 2);
	_g_object_unref0 (_tmp3_);
	self->priv->search_range = (guint16) (bird_font_otf_table_max_pow_2_less_than_i (self->num_tables) * 16);
	self->priv->entry_selector = bird_font_otf_table_max_log_2_less_than_i (self->num_tables);
	self->priv->range_shift = (guint16) ((16 * self->num_tables) - self->priv->search_range);
	bird_font_font_data_add_fixed (fd, version, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		return;
	}
	bird_font_font_data_add_u16 (fd, self->num_tables);
	bird_font_font_data_add_u16 (fd, self->priv->search_range);
	bird_font_font_data_add_u16 (fd, self->priv->entry_selector);
	bird_font_font_data_add_u16 (fd, self->priv->range_shift);
	_tmp6_ = _g_object_ref0 (fd);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp6_;
	_g_object_unref0 (fd);
}

static void
bird_font_offset_table_class_init (BirdFontOffsetTableClass * klass,
                                   gpointer klass_data)
{
	bird_font_offset_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontOffsetTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_offset_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_offset_table_finalize;
}

static void
bird_font_offset_table_instance_init (BirdFontOffsetTable * self,
                                      gpointer klass)
{
	self->priv = bird_font_offset_table_get_instance_private (self);
	self->num_tables = (guint16) 0;
	self->priv->search_range = (guint16) 0;
	self->priv->entry_selector = (guint16) 0;
	self->priv->range_shift = (guint16) 0;
}

static void
bird_font_offset_table_finalize (GObject * obj)
{
	BirdFontOffsetTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_OFFSET_TABLE, BirdFontOffsetTable);
	_g_object_unref0 (self->priv->directory_table);
	G_OBJECT_CLASS (bird_font_offset_table_parent_class)->finalize (obj);
}

static GType
bird_font_offset_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontOffsetTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_offset_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontOffsetTable), 0, (GInstanceInitFunc) bird_font_offset_table_instance_init, NULL };
	GType bird_font_offset_table_type_id;
	bird_font_offset_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontOffsetTable", &g_define_type_info, 0);
	BirdFontOffsetTable_private_offset = g_type_add_instance_private (bird_font_offset_table_type_id, sizeof (BirdFontOffsetTablePrivate));
	return bird_font_offset_table_type_id;
}

GType
bird_font_offset_table_get_type (void)
{
	static volatile gsize bird_font_offset_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_offset_table_type_id__once)) {
		GType bird_font_offset_table_type_id;
		bird_font_offset_table_type_id = bird_font_offset_table_get_type_once ();
		g_once_init_leave (&bird_font_offset_table_type_id__once, bird_font_offset_table_type_id);
	}
	return bird_font_offset_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

