/* NameTable.c generated by valac 0.56.16, the Vala compiler
 * generated from NameTable.vala, do not modify */

/*
Copyright (C) 2012 2013 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_NAME_TABLE_0_PROPERTY,
	BIRD_FONT_NAME_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_name_table_properties[BIRD_FONT_NAME_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BirdFontNameTablePrivate {
	GeeArrayList* identifiers;
	GeeArrayList* text;
};

static gint BirdFontNameTable_private_offset;
static gpointer bird_font_name_table_parent_class = NULL;

static void bird_font_name_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static gboolean bird_font_name_table_is_valid_ps_name_char (gunichar c);
static void bird_font_name_table_finalize (GObject * obj);
static GType bird_font_name_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_name_table_get_instance_private (BirdFontNameTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontNameTable_private_offset);
}

BirdFontNameTable*
bird_font_name_table_construct (GType object_type)
{
	BirdFontNameTable * self = NULL;
	gchar* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (BirdFontNameTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("name");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->text);
	self->priv->text = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->identifiers);
	self->priv->identifiers = _tmp2_;
	return self;
}

BirdFontNameTable*
bird_font_name_table_new (void)
{
	return bird_font_name_table_construct (BIRD_FONT_TYPE_NAME_TABLE);
}

gchar*
bird_font_name_table_get_name (BirdFontNameTable* self,
                               guint16 identifier)
{
	gint i = 0;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	i = 0;
	{
		GeeArrayList* _n_list = NULL;
		GeeArrayList* _tmp0_;
		gint _n_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _n_index = 0;
		_tmp0_ = self->priv->identifiers;
		_n_list = _tmp0_;
		_tmp1_ = _n_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_n_size = _tmp3_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			guint16 n = 0U;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gint _tmp10_;
			_n_index = _n_index + 1;
			_tmp4_ = _n_index;
			_tmp5_ = _n_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _n_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _n_index);
			n = (guint16) ((guintptr) _tmp7_);
			if (n == identifier) {
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				_tmp8_ = self->priv->text;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, i);
				result = (gchar*) _tmp9_;
				return result;
			}
			_tmp10_ = i;
			i = _tmp10_ + 1;
		}
	}
	_tmp11_ = g_strdup ("");
	result = _tmp11_;
	return result;
}

static void
bird_font_name_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontNameTable * self;
	guint16 format = 0U;
	GError* _inner_error0_ = NULL;
	self = (BirdFontNameTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	format = bird_font_font_data_read_ushort (dis);
	switch (format) {
		case 0:
		{
			bird_font_name_table_parse_format0 (self, dis, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			break;
		}
		case 1:
		{
			g_warning ("NameTable.vala:73: name table format 1 is not implemented yet");
			break;
		}
		default:
		{
			gchar* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = g_strdup_printf ("%hu", format);
			_tmp1_ = _tmp0_;
			_tmp2_ = g_strconcat ("unknown format ", _tmp1_, " in name table", NULL);
			_tmp3_ = _tmp2_;
			g_warning ("NameTable.vala:77: %s", _tmp3_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp1_);
			break;
		}
	}
}

void
bird_font_name_table_parse_format0 (BirdFontNameTable* self,
                                    BirdFontFontData* dis,
                                    GError** error)
{
	guint16 count = 0U;
	guint16 storage_offset = 0U;
	GeeArrayList* strlen = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* off = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* name_id = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* encoding_id = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* platform = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* lang = NULL;
	GeeArrayList* _tmp5_;
	gint plat = 0;
	GString* str = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	strlen = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	off = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	name_id = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	encoding_id = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	platform = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	lang = _tmp5_;
	count = bird_font_font_data_read_ushort (dis);
	storage_offset = bird_font_font_data_read_ushort (dis);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp8_;
				GeeArrayList* _tmp9_;
				GeeArrayList* _tmp10_;
				GeeArrayList* _tmp11_;
				GeeArrayList* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				GeeArrayList* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(i < ((gint) count))) {
					break;
				}
				_tmp8_ = platform;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp9_ = encoding_id;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp10_ = lang;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp11_ = name_id;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp12_ = strlen;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp13_ = off;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (gpointer) ((guintptr) bird_font_font_data_read_ushort (dis)));
				_tmp14_ = self->priv->identifiers;
				_tmp15_ = name_id;
				_tmp16_ = name_id;
				_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp18_ - 1);
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((guintptr) _tmp19_));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp22_;
				gpointer _tmp23_;
				GeeArrayList* _tmp24_;
				gpointer _tmp25_;
				GString* _tmp26_;
				GeeArrayList* _tmp36_;
				GString* _tmp37_;
				const gchar* _tmp38_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				if (!(i < ((gint) count))) {
					break;
				}
				_tmp22_ = platform;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, i);
				plat = (gint) ((guint16) ((guintptr) _tmp23_));
				_tmp24_ = off;
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
				bird_font_font_data_seek (dis, (guint) ((((BirdFontOtfTable*) self)->offset + storage_offset) + ((guint16) ((guintptr) _tmp25_))));
				_tmp26_ = g_string_new ("");
				_g_string_free0 (str);
				str = _tmp26_;
				switch (plat) {
					case 1:
					{
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp27_ = FALSE;
								_tmp27_ = TRUE;
								while (TRUE) {
									GeeArrayList* _tmp29_;
									gpointer _tmp30_;
									gchar c = '\0';
									GString* _tmp31_;
									if (!_tmp27_) {
										gint _tmp28_;
										_tmp28_ = j;
										j = _tmp28_ + 1;
									}
									_tmp27_ = FALSE;
									_tmp29_ = strlen;
									_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, i);
									if (!(j < ((gint) ((guint16) ((guintptr) _tmp30_))))) {
										break;
									}
									c = bird_font_font_data_read_char (dis, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										g_propagate_error (error, _inner_error0_);
										_g_string_free0 (str);
										_g_object_unref0 (lang);
										_g_object_unref0 (platform);
										_g_object_unref0 (encoding_id);
										_g_object_unref0 (name_id);
										_g_object_unref0 (off);
										_g_object_unref0 (strlen);
										return;
									}
									_tmp31_ = str;
									g_string_append_c (_tmp31_, c);
								}
							}
						}
						break;
					}
					case 3:
					{
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp32_ = FALSE;
								_tmp32_ = TRUE;
								while (TRUE) {
									GeeArrayList* _tmp33_;
									gpointer _tmp34_;
									gunichar c = 0U;
									gchar c0 = '\0';
									gchar c1 = '\0';
									GString* _tmp35_;
									if (!_tmp32_) {
										j += 2;
									}
									_tmp32_ = FALSE;
									_tmp33_ = strlen;
									_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, i);
									if (!(j < ((gint) ((guint16) ((guintptr) _tmp34_))))) {
										break;
									}
									c0 = bird_font_font_data_read_char (dis, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										g_propagate_error (error, _inner_error0_);
										_g_string_free0 (str);
										_g_object_unref0 (lang);
										_g_object_unref0 (platform);
										_g_object_unref0 (encoding_id);
										_g_object_unref0 (name_id);
										_g_object_unref0 (off);
										_g_object_unref0 (strlen);
										return;
									}
									c1 = bird_font_font_data_read_char (dis, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										g_propagate_error (error, _inner_error0_);
										_g_string_free0 (str);
										_g_object_unref0 (lang);
										_g_object_unref0 (platform);
										_g_object_unref0 (encoding_id);
										_g_object_unref0 (name_id);
										_g_object_unref0 (off);
										_g_object_unref0 (strlen);
										return;
									}
									c = (gunichar) (c0 << 8);
									c += (gunichar) c1;
									_tmp35_ = str;
									g_string_append_unichar (_tmp35_, c);
								}
							}
						}
						break;
					}
					default:
					{
						break;
					}
				}
				_tmp36_ = self->priv->text;
				_tmp37_ = str;
				_tmp38_ = _tmp37_->str;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp38_);
			}
		}
	}
	_g_string_free0 (str);
	_g_object_unref0 (lang);
	_g_object_unref0 (platform);
	_g_object_unref0 (encoding_id);
	_g_object_unref0 (name_id);
	_g_object_unref0 (off);
	_g_object_unref0 (strlen);
}

/** Create a valid PostScript name. */
gchar*
bird_font_name_table_validate_ps_name (BirdFontNameTable* self,
                                       const gchar* s)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = bird_font_name_table_name_validation (s, FALSE, 27);
	result = _tmp0_;
	return result;
}

gchar*
bird_font_name_table_validate_name (BirdFontNameTable* self,
                                    const gchar* s)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = bird_font_name_table_name_validation (s, TRUE, 27);
	result = _tmp0_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
bird_font_name_table_validate_full_name (BirdFontNameTable* self,
                                         const gchar* s)
{
	gchar* n = NULL;
	gchar* _tmp0_;
	gchar* regular_suffix = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = bird_font_name_table_name_validation (s, TRUE, 27);
	n = _tmp0_;
	_tmp1_ = g_strdup (" Regular");
	regular_suffix = _tmp1_;
	_tmp2_ = n;
	_tmp3_ = string_replace (_tmp2_, "-Regular", " Regular");
	_g_free0 (n);
	n = _tmp3_;
	_tmp4_ = n;
	_tmp5_ = string_replace (_tmp4_, "-Bold", " Bold");
	_g_free0 (n);
	n = _tmp5_;
	_tmp6_ = n;
	_tmp7_ = string_replace (_tmp6_, "-Italic", " Italic");
	_g_free0 (n);
	n = _tmp7_;
	_tmp8_ = n;
	_tmp9_ = regular_suffix;
	if (g_str_has_suffix (_tmp8_, _tmp9_)) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_;
		_tmp10_ = n;
		_tmp11_ = n;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = regular_suffix;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_substring (_tmp10_, (glong) 0, (glong) (_tmp13_ - _tmp16_));
		_g_free0 (n);
		n = _tmp17_;
	}
	result = n;
	_g_free0 (regular_suffix);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gchar*
bird_font_name_table_name_validation (const gchar* s,
                                      gboolean allow_space,
                                      gint max_length)
{
	gchar* n = NULL;
	gint ccount = 0;
	gunichar c = 0U;
	GString* name = NULL;
	GString* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = g_string_new ("");
	name = _tmp0_;
	_tmp1_ = string_strip (s);
	_g_free0 (n);
	n = _tmp1_;
	_tmp2_ = n;
	ccount = g_utf8_strlen (_tmp2_, (gssize) -1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp8_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (i < ccount) {
					_tmp5_ = i < max_length;
				} else {
					_tmp5_ = FALSE;
				}
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = n;
				_tmp7_ = n;
				c = string_get_char (_tmp6_, (glong) string_index_of_nth_char (_tmp7_, (glong) i));
				if (allow_space) {
					_tmp8_ = c == ((gunichar) ' ');
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					GString* _tmp9_;
					_tmp9_ = name;
					g_string_append_unichar (_tmp9_, (gunichar) ' ');
				} else {
					if (bird_font_name_table_is_valid_ps_name_char (c)) {
						GString* _tmp10_;
						_tmp10_ = name;
						g_string_append_unichar (_tmp10_, c);
					} else {
						GString* _tmp11_;
						_tmp11_ = name;
						g_string_append_unichar (_tmp11_, (gunichar) '_');
					}
				}
			}
		}
	}
	_tmp12_ = name;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_string_free0 (name);
	_g_free0 (n);
	return result;
}

static gboolean
bird_font_name_table_is_valid_ps_name_char (gunichar c)
{
	gunichar _tmp0_;
	gboolean result;
	switch (c) {
		case '[':
		{
			result = FALSE;
			return result;
		}
		case ']':
		{
			result = FALSE;
			return result;
		}
		case '(':
		{
			result = FALSE;
			return result;
		}
		case ')':
		{
			result = FALSE;
			return result;
		}
		case '{':
		{
			result = FALSE;
			return result;
		}
		case '}':
		{
			result = FALSE;
			return result;
		}
		case '<':
		{
			result = FALSE;
			return result;
		}
		case '>':
		{
			result = FALSE;
			return result;
		}
		case '/':
		{
			result = FALSE;
			return result;
		}
		case '%':
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp0_ = c;
	if ((((gunichar) 33) <= _tmp0_) && (_tmp0_ <= ((gunichar) 126))) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_name_table_process (BirdFontNameTable* self,
                              GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	guint16 len = 0U;
	gchar* t = NULL;
	guint16 p = 0U;
	guint16 l = 0U;
	guint16 num_records = 0U;
	GeeArrayList* type = NULL;
	GeeArrayList* _tmp2_;
	GeeArrayList* text = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	BirdFontFont* _tmp5_;
	const gchar* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	BirdFontFont* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	BirdFontFont* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	BirdFontFont* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	BirdFontFont* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	BirdFontFont* _tmp33_;
	const gchar* _tmp34_;
	GeeArrayList* _tmp35_;
	GeeArrayList* _tmp36_;
	BirdFontFont* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	BirdFontFont* _tmp43_;
	const gchar* _tmp44_;
	GeeArrayList* _tmp45_;
	GeeArrayList* _tmp46_;
	BirdFontFont* _tmp47_;
	const gchar* _tmp48_;
	GeeArrayList* _tmp49_;
	GeeArrayList* _tmp50_;
	BirdFontFont* _tmp51_;
	const gchar* _tmp52_;
	GeeArrayList* _tmp53_;
	GeeArrayList* _tmp54_;
	BirdFontFont* _tmp55_;
	const gchar* _tmp56_;
	GeeArrayList* _tmp57_;
	GeeArrayList* _tmp58_;
	BirdFontFont* _tmp59_;
	const gchar* _tmp60_;
	GeeArrayList* _tmp61_;
	GeeArrayList* _tmp62_;
	BirdFontFont* _tmp63_;
	const gchar* _tmp64_;
	GeeArrayList* _tmp65_;
	GeeArrayList* _tmp66_;
	BirdFontFont* _tmp67_;
	const gchar* _tmp68_;
	GeeArrayList* _tmp69_;
	GeeArrayList* _tmp70_;
	BirdFontFont* _tmp71_;
	const gchar* _tmp72_;
	GeeArrayList* _tmp73_;
	GeeArrayList* _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	BirdFontFontData* _tmp77_;
	BirdFontFontData* _tmp78_;
	BirdFontFontData* _tmp79_;
	BirdFontFontData* _tmp126_;
	BirdFontFontData* _tmp127_;
	BirdFontFontData* _tmp128_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_open_font_format_writer_get_current_font ();
	font = _tmp1_;
	len = (guint16) 0;
	_tmp2_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	type = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	text = _tmp3_;
	_tmp4_ = text;
	_tmp5_ = font;
	_tmp6_ = _tmp5_->copyright;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	_tmp7_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_COPYRIGHT_NOTICE));
	_tmp8_ = text;
	_tmp9_ = font;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = bird_font_name_table_validate_name (self, _tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_FONT_NAME));
	_tmp14_ = text;
	_tmp15_ = font;
	_tmp16_ = _tmp15_->subfamily;
	_tmp17_ = bird_font_name_table_validate_name (self, _tmp16_);
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_SUBFAMILY_NAME));
	_tmp20_ = text;
	_tmp21_ = font;
	_tmp22_ = _tmp21_->unique_identifier;
	_tmp23_ = bird_font_name_table_validate_name (self, _tmp22_);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_UNIQUE_IDENTIFIER));
	_tmp26_ = text;
	_tmp27_ = font;
	_tmp28_ = _tmp27_->full_name;
	_tmp29_ = bird_font_name_table_validate_full_name (self, _tmp28_);
	_tmp30_ = _tmp29_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_FULL_FONT_NAME));
	_tmp32_ = text;
	_tmp33_ = font;
	_tmp34_ = _tmp33_->version;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp34_);
	_tmp35_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_VERSION));
	_tmp36_ = text;
	_tmp37_ = font;
	_tmp38_ = _tmp37_->postscript_name;
	_tmp39_ = bird_font_name_table_validate_ps_name (self, _tmp38_);
	_tmp40_ = _tmp39_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_POSTSCRIPT_NAME));
	_tmp42_ = text;
	_tmp43_ = font;
	_tmp44_ = _tmp43_->trademark;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp44_);
	_tmp45_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_TRADE_MARK));
	_tmp46_ = text;
	_tmp47_ = font;
	_tmp48_ = _tmp47_->manufacturer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp48_);
	_tmp49_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_MANUFACTURER));
	_tmp50_ = text;
	_tmp51_ = font;
	_tmp52_ = _tmp51_->designer;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp52_);
	_tmp53_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_DESIGNER));
	_tmp54_ = text;
	_tmp55_ = font;
	_tmp56_ = _tmp55_->description;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp56_);
	_tmp57_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp57_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_DESCRIPTION));
	_tmp58_ = text;
	_tmp59_ = font;
	_tmp60_ = _tmp59_->vendor_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp60_);
	_tmp61_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_VENDOR_URL));
	_tmp62_ = text;
	_tmp63_ = font;
	_tmp64_ = _tmp63_->designer_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp64_);
	_tmp65_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_DESIGNER_URL));
	_tmp66_ = text;
	_tmp67_ = font;
	_tmp68_ = _tmp67_->license;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp68_);
	_tmp69_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_LICENSE));
	_tmp70_ = text;
	_tmp71_ = font;
	_tmp72_ = _tmp71_->license_url;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp70_, _tmp72_);
	_tmp73_ = type;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, (gpointer) ((guintptr) BIRD_FONT_NAME_TABLE_LICENSE_URL));
	_tmp74_ = text;
	_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
	_tmp76_ = _tmp75_;
	num_records = (guint16) _tmp76_;
	_tmp77_ = fd;
	bird_font_font_data_add_ushort (_tmp77_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (text);
		_g_object_unref0 (type);
		_g_free0 (t);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return;
	}
	_tmp78_ = fd;
	bird_font_font_data_add_ushort (_tmp78_, (guint16) (2 * num_records), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (text);
		_g_object_unref0 (type);
		_g_free0 (t);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return;
	}
	_tmp79_ = fd;
	bird_font_font_data_add_ushort (_tmp79_, (guint16) (6 + ((12 * 2) * num_records)), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (text);
		_g_object_unref0 (type);
		_g_free0 (t);
		_g_object_unref0 (font);
		_g_object_unref0 (fd);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp82_;
				gpointer _tmp83_;
				GeeArrayList* _tmp84_;
				gpointer _tmp85_;
				const gchar* _tmp86_;
				BirdFontFontData* _tmp87_;
				BirdFontFontData* _tmp88_;
				BirdFontFontData* _tmp89_;
				BirdFontFontData* _tmp90_;
				BirdFontFontData* _tmp91_;
				BirdFontFontData* _tmp92_;
				if (!_tmp80_) {
					gint _tmp81_;
					_tmp81_ = i;
					i = _tmp81_ + 1;
				}
				_tmp80_ = FALSE;
				if (!(i < ((gint) num_records))) {
					break;
				}
				_tmp82_ = text;
				_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, i);
				_g_free0 (t);
				t = (gchar*) ((gchar*) _tmp83_);
				_tmp84_ = type;
				_tmp85_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, i);
				p = (guint16) ((guint16) ((guintptr) _tmp85_));
				_tmp86_ = t;
				l = (guint16) bird_font_font_data_macroman_strlen (_tmp86_);
				_tmp87_ = fd;
				bird_font_font_data_add_ushort (_tmp87_, (guint16) 1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp88_ = fd;
				bird_font_font_data_add_ushort (_tmp88_, (guint16) 0, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp89_ = fd;
				bird_font_font_data_add_ushort (_tmp89_, (guint16) 0, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp90_ = fd;
				bird_font_font_data_add_ushort (_tmp90_, p, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp91_ = fd;
				bird_font_font_data_add_ushort (_tmp91_, l, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp92_ = fd;
				bird_font_font_data_add_ushort (_tmp92_, len, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				len += l;
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp93_ = FALSE;
			_tmp93_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp95_;
				gpointer _tmp96_;
				GeeArrayList* _tmp97_;
				gpointer _tmp98_;
				const gchar* _tmp99_;
				BirdFontFontData* _tmp100_;
				BirdFontFontData* _tmp101_;
				BirdFontFontData* _tmp102_;
				BirdFontFontData* _tmp103_;
				BirdFontFontData* _tmp104_;
				BirdFontFontData* _tmp105_;
				if (!_tmp93_) {
					gint _tmp94_;
					_tmp94_ = i;
					i = _tmp94_ + 1;
				}
				_tmp93_ = FALSE;
				if (!(i < ((gint) num_records))) {
					break;
				}
				_tmp95_ = text;
				_tmp96_ = gee_abstract_list_get ((GeeAbstractList*) _tmp95_, i);
				_g_free0 (t);
				t = (gchar*) ((gchar*) _tmp96_);
				_tmp97_ = type;
				_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, i);
				p = (guint16) ((guint16) ((guintptr) _tmp98_));
				_tmp99_ = t;
				l = (guint16) bird_font_font_data_utf16_strlen (_tmp99_);
				_tmp100_ = fd;
				bird_font_font_data_add_ushort (_tmp100_, (guint16) 3, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp101_ = fd;
				bird_font_font_data_add_ushort (_tmp101_, (guint16) 1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp102_ = fd;
				bird_font_font_data_add_ushort (_tmp102_, (guint16) 0x0409, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp103_ = fd;
				bird_font_font_data_add_ushort (_tmp103_, p, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp104_ = fd;
				bird_font_font_data_add_ushort (_tmp104_, l, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				_tmp105_ = fd;
				bird_font_font_data_add_ushort (_tmp105_, len, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (text);
					_g_object_unref0 (type);
					_g_free0 (t);
					_g_object_unref0 (font);
					_g_object_unref0 (fd);
					return;
				}
				len += l;
			}
		}
	}
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp106_;
		gint _s_size = 0;
		GeeArrayList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _s_index = 0;
		_tmp106_ = text;
		_s_list = _tmp106_;
		_tmp107_ = _s_list;
		_tmp108_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_s_size = _tmp109_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp110_;
			gint _tmp111_;
			gchar* s = NULL;
			GeeArrayList* _tmp112_;
			gpointer _tmp113_;
			BirdFontFontData* _tmp114_;
			const gchar* _tmp115_;
			_s_index = _s_index + 1;
			_tmp110_ = _s_index;
			_tmp111_ = _s_size;
			if (!(_tmp110_ < _tmp111_)) {
				break;
			}
			_tmp112_ = _s_list;
			_tmp113_ = gee_abstract_list_get ((GeeAbstractList*) _tmp112_, _s_index);
			s = (gchar*) _tmp113_;
			_tmp114_ = fd;
			_tmp115_ = s;
			bird_font_font_data_add_macroman_str (_tmp114_, _tmp115_);
			_g_free0 (s);
		}
	}
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp116_;
		gint _s_size = 0;
		GeeArrayList* _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		gint _s_index = 0;
		_tmp116_ = text;
		_s_list = _tmp116_;
		_tmp117_ = _s_list;
		_tmp118_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp117_);
		_tmp119_ = _tmp118_;
		_s_size = _tmp119_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp120_;
			gint _tmp121_;
			gchar* s = NULL;
			GeeArrayList* _tmp122_;
			gpointer _tmp123_;
			BirdFontFontData* _tmp124_;
			const gchar* _tmp125_;
			_s_index = _s_index + 1;
			_tmp120_ = _s_index;
			_tmp121_ = _s_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _s_list;
			_tmp123_ = gee_abstract_list_get ((GeeAbstractList*) _tmp122_, _s_index);
			s = (gchar*) _tmp123_;
			_tmp124_ = fd;
			_tmp125_ = s;
			bird_font_font_data_add_str_utf16 (_tmp124_, _tmp125_, FALSE);
			_g_free0 (s);
		}
	}
	_tmp126_ = fd;
	bird_font_font_data_pad (_tmp126_);
	_tmp127_ = fd;
	_tmp128_ = _g_object_ref0 (_tmp127_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp128_;
	_g_object_unref0 (text);
	_g_object_unref0 (type);
	_g_free0 (t);
	_g_object_unref0 (font);
	_g_object_unref0 (fd);
}

static void
bird_font_name_table_class_init (BirdFontNameTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_name_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontNameTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_name_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_name_table_finalize;
}

static void
bird_font_name_table_instance_init (BirdFontNameTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_name_table_get_instance_private (self);
}

static void
bird_font_name_table_finalize (GObject * obj)
{
	BirdFontNameTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_NAME_TABLE, BirdFontNameTable);
	_g_object_unref0 (self->priv->identifiers);
	_g_object_unref0 (self->priv->text);
	G_OBJECT_CLASS (bird_font_name_table_parent_class)->finalize (obj);
}

static GType
bird_font_name_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontNameTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_name_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontNameTable), 0, (GInstanceInitFunc) bird_font_name_table_instance_init, NULL };
	GType bird_font_name_table_type_id;
	bird_font_name_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontNameTable", &g_define_type_info, 0);
	BirdFontNameTable_private_offset = g_type_add_instance_private (bird_font_name_table_type_id, sizeof (BirdFontNameTablePrivate));
	return bird_font_name_table_type_id;
}

GType
bird_font_name_table_get_type (void)
{
	static volatile gsize bird_font_name_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_name_table_type_id__once)) {
		GType bird_font_name_table_type_id;
		bird_font_name_table_type_id = bird_font_name_table_get_type_once ();
		g_once_init_leave (&bird_font_name_table_type_id__once, bird_font_name_table_type_id);
	}
	return bird_font_name_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

