/* MoveTool.c generated by valac 0.56.16, the Vala compiler
 * generated from MoveTool.vala, do not modify */

/*
Copyright (C) 2012 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_MOVE_TOOL_0_PROPERTY,
	BIRD_FONT_MOVE_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_move_tool_properties[BIRD_FONT_MOVE_TOOL_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BIRD_FONT_MOVE_TOOL_SELECTION_CHANGED_SIGNAL,
	BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL,
	BIRD_FONT_MOVE_TOOL_OBJECTS_DESELECTED_SIGNAL,
	BIRD_FONT_MOVE_TOOL_NUM_SIGNALS
};
static guint bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_NUM_SIGNALS] = {0};

static gpointer bird_font_move_tool_parent_class = NULL;
static gboolean bird_font_move_tool_move_path;
static gboolean bird_font_move_tool_move_path = FALSE;
static gboolean bird_font_move_tool_moved;
static gboolean bird_font_move_tool_moved = FALSE;
static gdouble bird_font_move_tool_last_x;
static gdouble bird_font_move_tool_last_x = (gdouble) 0;
static gdouble bird_font_move_tool_last_y;
static gdouble bird_font_move_tool_last_y = (gdouble) 0;
static gdouble bird_font_move_tool_selection_x;
static gdouble bird_font_move_tool_selection_x = (gdouble) 0;
static gdouble bird_font_move_tool_selection_y;
static gdouble bird_font_move_tool_selection_y = (gdouble) 0;
static gboolean bird_font_move_tool_group_selection;
static gboolean bird_font_move_tool_group_selection = FALSE;
gdouble bird_font_move_tool_selection_box_width = (gdouble) 0;
gdouble bird_font_move_tool_selection_box_height = (gdouble) 0;
gdouble bird_font_move_tool_selection_box_center_x = (gdouble) 0;
gdouble bird_font_move_tool_selection_box_center_y = (gdouble) 0;

static void __lambda45_ (BirdFontMoveTool* self);
static void ___lambda45__bird_font_move_tool_selection_changed (BirdFontMoveTool* _sender,
                                                         gpointer self);
static void __lambda46_ (BirdFontMoveTool* self);
static void ___lambda46__bird_font_move_tool_objects_deselected (BirdFontMoveTool* _sender,
                                                          gpointer self);
static void __lambda47_ (BirdFontMoveTool* self,
                  BirdFontTool* _self_);
static void ___lambda47__bird_font_tool_select_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gpointer self);
static void __lambda48_ (BirdFontMoveTool* self,
                  BirdFontTool* _self_);
static void ___lambda48__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  gpointer self);
static void __lambda49_ (BirdFontMoveTool* self,
                  BirdFontTool* _self_,
                  gint b,
                  gint x,
                  gint y);
static void ___lambda49__bird_font_tool_press_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint button,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda51_ (BirdFontMoveTool* self,
                  BirdFontTool* _self_,
                  gint b,
                  gint x,
                  gint y);
static void ___lambda51__bird_font_tool_release_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gint button,
                                                 gint x,
                                                 gint y,
                                                 gpointer self);
static void __lambda351_ (BirdFontMoveTool* self,
                   BirdFontTool* _self_,
                   gint x,
                   gint y);
static void ___lambda351__bird_font_tool_move_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda352_ (BirdFontMoveTool* self,
                   BirdFontTool* _self_,
                   guint32 keyval);
static void ___lambda352__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                                    BirdFontTool* selected,
                                                    guint32 keyval,
                                                    gpointer self);
static void __lambda353_ (BirdFontMoveTool* self,
                   BirdFontTool* _self_,
                   cairo_t* cr,
                   BirdFontGlyph* glyph);
static void ___lambda353__bird_font_tool_draw_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               cairo_t* cr,
                                               BirdFontGlyph* glyph,
                                               gpointer self);
static void bird_font_move_tool_draw_selection_box (cairo_t* cr);
VALA_EXTERN gboolean bird_font_is_arrow_key (guint keyval);
static void bird_font_move_tool_move_selected_paths (BirdFontMoveTool* self,
                                              guint key);
static void bird_font_move_tool_tie_paths_to_grid (BirdFontGlyph* g);
static void bird_font_move_tool_tie_path_to_ttf_grid (BirdFontPath* p);
static void bird_font_move_tool_select_group (BirdFontMoveTool* self);
static void bird_font_move_tool_finalize (GObject * obj);
static GType bird_font_move_tool_get_type_once (void);

static void
__lambda45_ (BirdFontMoveTool* self)
{
	bird_font_move_tool_update_selection_boundaries ();
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda45__bird_font_move_tool_selection_changed (BirdFontMoveTool* _sender,
                                                    gpointer self)
{
	__lambda45_ ((BirdFontMoveTool*) self);
}

static void
__lambda46_ (BirdFontMoveTool* self)
{
	bird_font_move_tool_update_selection_boundaries ();
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
___lambda46__bird_font_move_tool_objects_deselected (BirdFontMoveTool* _sender,
                                                     gpointer self)
{
	__lambda46_ ((BirdFontMoveTool*) self);
}

static void
__lambda47_ (BirdFontMoveTool* self,
             BirdFontTool* _self_)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	g_return_if_fail (_self_ != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_tmp1_ = _tmp0_;
	bird_font_glyph_close_path (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda47__bird_font_tool_select_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gpointer self)
{
	__lambda47_ ((BirdFontMoveTool*) self, selected);
}

static void
__lambda48_ (BirdFontMoveTool* self,
             BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda48__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                             BirdFontTool* selected,
                                             gpointer self)
{
	__lambda48_ ((BirdFontMoveTool*) self, selected);
}

static void
__lambda49_ (BirdFontMoveTool* self,
             BirdFontTool* _self_,
             gint b,
             gint x,
             gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_move_tool_press (self, b, x, y);
}

static void
___lambda49__bird_font_tool_press_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint button,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda49_ ((BirdFontMoveTool*) self, selected, button, x, y);
}

static void
__lambda51_ (BirdFontMoveTool* self,
             BirdFontTool* _self_,
             gint b,
             gint x,
             gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_move_tool_release (self, b, x, y);
}

static void
___lambda51__bird_font_tool_release_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gint button,
                                            gint x,
                                            gint y,
                                            gpointer self)
{
	__lambda51_ ((BirdFontMoveTool*) self, selected, button, x, y);
}

static void
__lambda351_ (BirdFontMoveTool* self,
              BirdFontTool* _self_,
              gint x,
              gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_move_tool_move (self, x, y);
}

static void
___lambda351__bird_font_tool_move_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda351_ ((BirdFontMoveTool*) self, selected, x, y);
}

static void
__lambda352_ (BirdFontMoveTool* self,
              BirdFontTool* _self_,
              guint32 keyval)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_move_tool_key_down (self, keyval);
}

static void
___lambda352__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               guint32 keyval,
                                               gpointer self)
{
	__lambda352_ ((BirdFontMoveTool*) self, selected, keyval);
}

static void
__lambda353_ (BirdFontMoveTool* self,
              BirdFontTool* _self_,
              cairo_t* cr,
              BirdFontGlyph* glyph)
{
	g_return_if_fail (_self_ != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (glyph != NULL);
	bird_font_move_tool_draw_actions (cr);
}

static void
___lambda353__bird_font_tool_draw_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          cairo_t* cr,
                                          BirdFontGlyph* glyph,
                                          gpointer self)
{
	__lambda353_ ((BirdFontMoveTool*) self, selected, cr, glyph);
}

BirdFontMoveTool*
bird_font_move_tool_construct (GType object_type,
                               const gchar* name)
{
	BirdFontMoveTool * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = bird_font_t_ ("Move paths");
	_tmp1_ = _tmp0_;
	self = (BirdFontMoveTool*) bird_font_tool_construct (object_type, name, _tmp1_);
	_g_free0 (_tmp1_);
	g_signal_connect_object (self, "selection-changed", (GCallback) ___lambda45__bird_font_move_tool_selection_changed, self, 0);
	g_signal_connect_object (self, "objects-deselected", (GCallback) ___lambda46__bird_font_move_tool_objects_deselected, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "select-action", (GCallback) ___lambda47__bird_font_tool_select_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "deselect-action", (GCallback) ___lambda48__bird_font_tool_deselect_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "press-action", (GCallback) ___lambda49__bird_font_tool_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "release-action", (GCallback) ___lambda51__bird_font_tool_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "move-action", (GCallback) ___lambda351__bird_font_tool_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "key-press-action", (GCallback) ___lambda352__bird_font_tool_key_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "draw-action", (GCallback) ___lambda353__bird_font_tool_draw_action, self, 0);
	return self;
}

BirdFontMoveTool*
bird_font_move_tool_new (const gchar* name)
{
	return bird_font_move_tool_construct (BIRD_FONT_TYPE_MOVE_TOOL, name);
}

void
bird_font_move_tool_draw_actions (cairo_t* cr)
{
	g_return_if_fail (cr != NULL);
	if (bird_font_move_tool_group_selection) {
		bird_font_move_tool_draw_selection_box (cr);
	}
}

void
bird_font_move_tool_key_down (BirdFontMoveTool* self,
                              guint32 keyval)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	if (keyval == ((guint32) BIRD_FONT_KEY_DEL)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = keyval == ((guint32) BIRD_FONT_KEY_BACK_SPACE);
	}
	if (_tmp1_) {
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		BirdFontGlyph* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp2_ = g;
		_tmp3_ = _tmp2_->active_paths;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > 0) {
			BirdFontGlyph* _tmp6_;
			_tmp6_ = g;
			bird_font_glyph_store_undo_state (_tmp6_, FALSE);
		}
		{
			GeeArrayList* _p_list = NULL;
			BirdFontGlyph* _tmp7_;
			GeeArrayList* _tmp8_;
			gint _p_size = 0;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _p_index = 0;
			_tmp7_ = g;
			_tmp8_ = _tmp7_->active_paths;
			_p_list = _tmp8_;
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_p_size = _tmp11_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp12_;
				gint _tmp13_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp14_;
				gpointer _tmp15_;
				BirdFontGlyph* _tmp16_;
				BirdFontLayer* _tmp17_;
				BirdFontPath* _tmp18_;
				BirdFontGlyph* _tmp19_;
				_p_index = _p_index + 1;
				_tmp12_ = _p_index;
				_tmp13_ = _p_size;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = _p_list;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _p_index);
				p = (BirdFontPath*) _tmp15_;
				_tmp16_ = g;
				_tmp17_ = _tmp16_->layers;
				_tmp18_ = p;
				bird_font_layer_remove_path (_tmp17_, _tmp18_);
				_tmp19_ = g;
				bird_font_glyph_update_view (_tmp19_);
				_g_object_unref0 (p);
			}
		}
		_tmp20_ = g;
		_tmp21_ = _tmp20_->active_paths;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp21_);
	}
	if (bird_font_is_arrow_key ((guint) keyval)) {
		bird_font_move_tool_move_selected_paths (self, (guint) keyval);
	}
	_g_object_unref0 (g);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_move_tool_move (BirdFontMoveTool* self,
                          gint x,
                          gint y)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	gdouble p = 0.0;
	gdouble delta_x = 0.0;
	gdouble delta_y = 0.0;
	gboolean _tmp1_ = FALSE;
	BirdFontGlyph* _tmp35_;
	GeeArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	BirdFontFont* _tmp39_;
	BirdFontFont* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	dx = bird_font_move_tool_last_x - x;
	dy = bird_font_move_tool_last_y - y;
	p = bird_font_pen_tool_precision;
	if (!bird_font_move_tool_move_path) {
		_g_object_unref0 (glyph);
		return;
	}
	if (bird_font_move_tool_move_path) {
		gboolean _tmp2_ = FALSE;
		if (fabs (dx) > ((gdouble) 0)) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = fabs (dy) > ((gdouble) 0);
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		bird_font_move_tool_moved = TRUE;
		delta_x = (bird_font_glyph_ivz () * (-dx)) * p;
		delta_y = (bird_font_glyph_ivz () * dy) * p;
		{
			GeeArrayList* _group_list = NULL;
			BirdFontGlyph* _tmp3_;
			GeeArrayList* _tmp4_;
			gint _group_size = 0;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _group_index = 0;
			_tmp3_ = glyph;
			_tmp4_ = _tmp3_->selected_groups;
			_group_list = _tmp4_;
			_tmp5_ = _group_list;
			_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_group_size = _tmp7_;
			_group_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				BirdFontLayer* group = NULL;
				GeeArrayList* _tmp10_;
				gpointer _tmp11_;
				BirdFontLayer* _tmp12_;
				BirdFontGradient* _tmp13_;
				_group_index = _group_index + 1;
				_tmp8_ = _group_index;
				_tmp9_ = _group_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _group_list;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _group_index);
				group = (BirdFontLayer*) _tmp11_;
				_tmp12_ = group;
				_tmp13_ = _tmp12_->gradient;
				if (_tmp13_ != NULL) {
					BirdFontGradient* g = NULL;
					BirdFontLayer* _tmp14_;
					BirdFontGradient* _tmp15_;
					BirdFontGradient* _tmp16_;
					BirdFontGradient* _tmp17_;
					BirdFontGradient* _tmp18_;
					BirdFontGradient* _tmp19_;
					BirdFontGradient* _tmp20_;
					BirdFontGradient* _tmp21_;
					BirdFontGradient* _tmp22_;
					BirdFontGradient* _tmp23_;
					BirdFontGradient* _tmp24_;
					_tmp14_ = group;
					_tmp15_ = _tmp14_->gradient;
					_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, BIRD_FONT_TYPE_GRADIENT, BirdFontGradient));
					g = _tmp16_;
					_tmp17_ = g;
					_tmp18_ = g;
					_tmp18_->x1 = _tmp18_->x1 + delta_x;
					_tmp19_ = g;
					_tmp20_ = g;
					_tmp20_->x2 = _tmp20_->x2 + delta_x;
					_tmp21_ = g;
					_tmp22_ = g;
					_tmp22_->y1 = _tmp22_->y1 + delta_y;
					_tmp23_ = g;
					_tmp24_ = g;
					_tmp24_->y2 = _tmp24_->y2 + delta_y;
					_g_object_unref0 (g);
				}
				_g_object_unref0 (group);
			}
		}
		{
			GeeArrayList* _path_list = NULL;
			BirdFontGlyph* _tmp25_;
			GeeArrayList* _tmp26_;
			gint _path_size = 0;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _path_index = 0;
			_tmp25_ = glyph;
			_tmp26_ = _tmp25_->active_paths;
			_path_list = _tmp26_;
			_tmp27_ = _path_list;
			_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_path_size = _tmp29_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				BirdFontPath* path = NULL;
				GeeArrayList* _tmp32_;
				gpointer _tmp33_;
				BirdFontPath* _tmp34_;
				_path_index = _path_index + 1;
				_tmp30_ = _path_index;
				_tmp31_ = _path_size;
				if (!(_tmp30_ < _tmp31_)) {
					break;
				}
				_tmp32_ = _path_list;
				_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _path_index);
				path = (BirdFontPath*) _tmp33_;
				_tmp34_ = path;
				bird_font_path_move (_tmp34_, delta_x, delta_y);
				_g_object_unref0 (path);
			}
		}
	}
	bird_font_move_tool_last_x = (gdouble) x;
	bird_font_move_tool_last_y = (gdouble) y;
	bird_font_move_tool_update_selection_boundaries ();
	_tmp35_ = glyph;
	_tmp36_ = _tmp35_->active_paths;
	_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL], 0);
	}
	_tmp39_ = bird_font_bird_font_get_current_font ();
	_tmp40_ = _tmp39_;
	bird_font_font_touch (_tmp40_);
	_g_object_unref0 (_tmp40_);
	bird_font_glyph_canvas_redraw ();
	bird_font_pen_tool_reset_stroke ();
	_g_object_unref0 (glyph);
}

void
bird_font_move_tool_release (BirdFontMoveTool* self,
                             gint b,
                             gint x,
                             gint y)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BirdFontGlyph* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	bird_font_move_tool_move_path = FALSE;
	if (bird_font_grid_tool_is_visible ()) {
		_tmp1_ = bird_font_move_tool_moved;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontGlyph* _tmp2_;
		_tmp2_ = glyph;
		bird_font_move_tool_tie_paths_to_grid (_tmp2_);
	} else {
		if (bird_font_grid_tool_has_ttf_grid ()) {
			{
				GeeArrayList* _p_list = NULL;
				BirdFontGlyph* _tmp3_;
				GeeArrayList* _tmp4_;
				gint _p_size = 0;
				GeeArrayList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				gint _p_index = 0;
				_tmp3_ = glyph;
				_tmp4_ = _tmp3_->active_paths;
				_p_list = _tmp4_;
				_tmp5_ = _p_list;
				_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
				_tmp7_ = _tmp6_;
				_p_size = _tmp7_;
				_p_index = -1;
				while (TRUE) {
					gint _tmp8_;
					gint _tmp9_;
					BirdFontPath* p = NULL;
					GeeArrayList* _tmp10_;
					gpointer _tmp11_;
					BirdFontPath* _tmp12_;
					_p_index = _p_index + 1;
					_tmp8_ = _p_index;
					_tmp9_ = _p_size;
					if (!(_tmp8_ < _tmp9_)) {
						break;
					}
					_tmp10_ = _p_list;
					_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _p_index);
					p = (BirdFontPath*) _tmp11_;
					_tmp12_ = p;
					bird_font_move_tool_tie_path_to_ttf_grid (_tmp12_);
					_g_object_unref0 (p);
				}
			}
		}
	}
	if (bird_font_move_tool_group_selection) {
		bird_font_move_tool_select_group (self);
	}
	bird_font_move_tool_group_selection = FALSE;
	bird_font_move_tool_moved = FALSE;
	_tmp13_ = glyph;
	_tmp14_ = _tmp13_->active_paths;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		BirdFontResizeTool* _tmp17_;
		g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_SELECTION_CHANGED_SIGNAL], 0);
		g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL], 0);
		_tmp17_ = bird_font_drawing_tools_resize_tool;
		bird_font_resize_tool_signal_objects_rotated (_tmp17_);
		{
			GeeArrayList* _p_list = NULL;
			BirdFontGlyph* _tmp18_;
			GeeArrayList* _tmp19_;
			gint _p_size = 0;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _p_index = 0;
			_tmp18_ = glyph;
			_tmp19_ = _tmp18_->active_paths;
			_p_list = _tmp19_;
			_tmp20_ = _p_list;
			_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_p_size = _tmp22_;
			_p_index = -1;
			while (TRUE) {
				gint _tmp23_;
				gint _tmp24_;
				BirdFontPath* p = NULL;
				GeeArrayList* _tmp25_;
				gpointer _tmp26_;
				BirdFontPath* _tmp27_;
				_p_index = _p_index + 1;
				_tmp23_ = _p_index;
				_tmp24_ = _p_size;
				if (!(_tmp23_ < _tmp24_)) {
					break;
				}
				_tmp25_ = _p_list;
				_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _p_index);
				p = (BirdFontPath*) _tmp26_;
				_tmp27_ = p;
				bird_font_path_create_full_stroke (_tmp27_);
				_g_object_unref0 (p);
			}
		}
	} else {
		g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_DESELECTED_SIGNAL], 0);
	}
	_g_object_unref0 (glyph);
}

void
bird_font_move_tool_press (BirdFontMoveTool* self,
                           gint b,
                           gint x,
                           gint y)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontPath* p = NULL;
	gboolean selected = FALSE;
	BirdFontLayer* group = NULL;
	BirdFontLayer* g = NULL;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontLayer* _tmp3_;
	BirdFontLayer* _tmp4_;
	BirdFontGlyph* _tmp42_;
	GeeArrayList* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	selected = FALSE;
	_tmp1_ = glyph;
	bird_font_glyph_store_undo_state (_tmp1_, FALSE);
	bird_font_move_tool_group_selection = FALSE;
	_tmp2_ = glyph;
	_tmp3_ = bird_font_glyph_get_path_at (_tmp2_, (gdouble) x, (gdouble) y);
	_g_object_unref0 (group);
	group = _tmp3_;
	_tmp4_ = group;
	if (_tmp4_ != NULL) {
		BirdFontLayer* _tmp5_;
		BirdFontLayer* _tmp6_;
		BirdFontLayer* _tmp7_;
		BirdFontPathList* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		BirdFontLayer* _tmp12_;
		BirdFontPathList* _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_;
		BirdFontGlyph* _tmp16_;
		GeeArrayList* _tmp17_;
		BirdFontPath* _tmp18_;
		gboolean _tmp19_ = FALSE;
		_tmp5_ = group;
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, BIRD_FONT_TYPE_LAYER, BirdFontLayer));
		_g_object_unref0 (g);
		g = _tmp6_;
		_tmp7_ = g;
		_tmp8_ = _tmp7_->paths;
		_tmp9_ = _tmp8_->paths;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		g_return_if_fail (_tmp11_ > 0);
		_tmp12_ = g;
		_tmp13_ = _tmp12_->paths;
		_tmp14_ = _tmp13_->paths;
		_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
		_g_object_unref0 (p);
		p = (BirdFontPath*) _tmp15_;
		_tmp16_ = glyph;
		_tmp17_ = _tmp16_->active_paths;
		_tmp18_ = p;
		selected = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		if (!selected) {
			_tmp19_ = !bird_font_key_bindings_has_shift ();
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			BirdFontGlyph* _tmp20_;
			_tmp20_ = glyph;
			bird_font_glyph_clear_active_paths (_tmp20_);
		}
		{
			GeeArrayList* _lp_list = NULL;
			BirdFontLayer* _tmp21_;
			BirdFontPathList* _tmp22_;
			GeeArrayList* _tmp23_;
			gint _lp_size = 0;
			GeeArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _lp_index = 0;
			_tmp21_ = g;
			_tmp22_ = _tmp21_->paths;
			_tmp23_ = _tmp22_->paths;
			_lp_list = _tmp23_;
			_tmp24_ = _lp_list;
			_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_lp_size = _tmp26_;
			_lp_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				BirdFontPath* lp = NULL;
				GeeArrayList* _tmp29_;
				gpointer _tmp30_;
				gboolean _tmp31_ = FALSE;
				_lp_index = _lp_index + 1;
				_tmp27_ = _lp_index;
				_tmp28_ = _lp_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _lp_list;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _lp_index);
				lp = (BirdFontPath*) _tmp30_;
				if (selected) {
					_tmp31_ = bird_font_key_bindings_has_shift ();
				} else {
					_tmp31_ = FALSE;
				}
				if (_tmp31_) {
					BirdFontGlyph* _tmp32_;
					GeeArrayList* _tmp33_;
					BirdFontLayer* _tmp34_;
					BirdFontGlyph* _tmp35_;
					GeeArrayList* _tmp36_;
					BirdFontPath* _tmp37_;
					_tmp32_ = glyph;
					_tmp33_ = _tmp32_->selected_groups;
					_tmp34_ = group;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, BIRD_FONT_TYPE_LAYER, BirdFontLayer));
					_tmp35_ = glyph;
					_tmp36_ = _tmp35_->active_paths;
					_tmp37_ = lp;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp36_, _tmp37_);
				} else {
					BirdFontGlyph* _tmp38_;
					BirdFontLayer* _tmp39_;
					BirdFontPath* _tmp40_;
					_tmp38_ = glyph;
					_tmp39_ = group;
					_tmp40_ = lp;
					bird_font_glyph_add_active_path (_tmp38_, G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, BIRD_FONT_TYPE_LAYER, BirdFontLayer), _tmp40_);
				}
				_g_object_unref0 (lp);
			}
		}
	} else {
		if (!bird_font_key_bindings_has_shift ()) {
			BirdFontGlyph* _tmp41_;
			_tmp41_ = glyph;
			bird_font_glyph_clear_active_paths (_tmp41_);
		}
	}
	bird_font_move_tool_move_path = TRUE;
	bird_font_move_tool_update_selection_boundaries ();
	bird_font_move_tool_last_x = (gdouble) x;
	bird_font_move_tool_last_y = (gdouble) y;
	_tmp42_ = glyph;
	_tmp43_ = _tmp42_->active_paths;
	_tmp44_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ == 0) {
		bird_font_move_tool_group_selection = TRUE;
		bird_font_move_tool_selection_x = (gdouble) x;
		bird_font_move_tool_selection_y = (gdouble) y;
	}
	bird_font_move_tool_update_boundaries_for_selection ();
	g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_SELECTION_CHANGED_SIGNAL], 0);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (g);
	_g_object_unref0 (group);
	_g_object_unref0 (p);
	_g_object_unref0 (glyph);
}

static void
bird_font_move_tool_select_group (BirdFontMoveTool* self)
{
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	g_return_if_fail (self != NULL);
	x1 = bird_font_glyph_path_coordinate_x (fmin (bird_font_move_tool_selection_x, bird_font_move_tool_last_x));
	y1 = bird_font_glyph_path_coordinate_y (fmin (bird_font_move_tool_selection_y, bird_font_move_tool_last_y));
	x2 = bird_font_glyph_path_coordinate_x (fmax (bird_font_move_tool_selection_x, bird_font_move_tool_last_x));
	y2 = bird_font_glyph_path_coordinate_y (fmax (bird_font_move_tool_selection_y, bird_font_move_tool_last_y));
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = glyph;
	bird_font_glyph_clear_active_paths (_tmp1_);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = glyph;
		_tmp3_ = bird_font_glyph_get_paths_in_current_layer (_tmp2_);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			BirdFontPath* _tmp14_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp14_ = p;
			if (_tmp14_->xmin > x1) {
				BirdFontPath* _tmp15_;
				_tmp15_ = p;
				_tmp13_ = _tmp15_->xmax < x2;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				BirdFontPath* _tmp16_;
				_tmp16_ = p;
				_tmp12_ = _tmp16_->ymin < y1;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				BirdFontPath* _tmp17_;
				_tmp17_ = p;
				_tmp11_ = _tmp17_->ymax > y2;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				BirdFontPath* _tmp18_;
				GeeArrayList* _tmp19_;
				GeeArrayList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp18_ = p;
				_tmp19_ = bird_font_path_get_points (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ > 0) {
					BirdFontGlyph* _tmp23_;
					BirdFontPath* _tmp24_;
					_tmp23_ = glyph;
					_tmp24_ = p;
					bird_font_glyph_add_active_path (_tmp23_, NULL, _tmp24_);
				}
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_SELECTION_CHANGED_SIGNAL], 0);
	_g_object_unref0 (glyph);
}

void
bird_font_move_tool_update_selection_boundaries (void)
{
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	bird_font_move_tool_get_selection_box_boundaries (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	bird_font_move_tool_selection_box_center_x = _tmp0_;
	bird_font_move_tool_selection_box_center_y = _tmp1_;
	bird_font_move_tool_selection_box_width = _tmp2_;
	bird_font_move_tool_selection_box_height = _tmp3_;
}

void
bird_font_move_tool_move_to_baseline (BirdFontMoveTool* self)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	bird_font_move_tool_get_selection_box_boundaries (&_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp2_;
	y = _tmp3_;
	w = _tmp4_;
	h = _tmp5_;
	{
		GeeArrayList* _path_list = NULL;
		BirdFontGlyph* _tmp6_;
		GeeArrayList* _tmp7_;
		gint _path_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _path_index = 0;
		_tmp6_ = glyph;
		_tmp7_ = _tmp6_->active_paths;
		_path_list = _tmp7_;
		_tmp8_ = _path_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_path_size = _tmp10_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			BirdFontPath* _tmp15_;
			BirdFontGlyph* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			BirdFontFont* _tmp19_;
			_path_index = _path_index + 1;
			_tmp11_ = _path_index;
			_tmp12_ = _path_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _path_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _path_index);
			path = (BirdFontPath*) _tmp14_;
			_tmp15_ = path;
			_tmp16_ = glyph;
			_tmp17_ = bird_font_glyph_get_left_limit (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = font;
			bird_font_path_move (_tmp15_, (_tmp18_ - x) + (w / 2), (_tmp19_->base_line - y) + (h / 2));
			_g_object_unref0 (path);
		}
	}
	bird_font_move_tool_update_selection_boundaries ();
	g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL], 0);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (font);
	_g_object_unref0 (glyph);
}

static void
bird_font_move_tool_draw_selection_box (cairo_t* cr)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	g_return_if_fail (cr != NULL);
	x = fmin (bird_font_move_tool_selection_x, bird_font_move_tool_last_x);
	y = fmin (bird_font_move_tool_selection_y, bird_font_move_tool_last_y);
	w = fabs (bird_font_move_tool_selection_x - bird_font_move_tool_last_x);
	h = fabs (bird_font_move_tool_selection_y - bird_font_move_tool_last_y);
	cairo_save (cr);
	bird_font_theme_color (cr, "Foreground 1");
	cairo_set_line_width (cr, (gdouble) 2);
	cairo_rectangle (cr, x, y, w, h);
	cairo_stroke (cr);
	cairo_restore (cr);
}

void
bird_font_move_tool_get_selection_box_boundaries (gdouble* x,
                                                  gdouble* y,
                                                  gdouble* w,
                                                  gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gdouble px = 0.0;
	gdouble py = 0.0;
	gdouble px2 = 0.0;
	gdouble py2 = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	px = (gdouble) 10000;
	py = (gdouble) 10000;
	px2 = (gdouble) -10000;
	py2 = (gdouble) -10000;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			BirdFontPath* _tmp11_;
			BirdFontPath* _tmp13_;
			BirdFontPath* _tmp15_;
			BirdFontPath* _tmp17_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			_tmp10_ = p;
			bird_font_path_update_region_boundaries (_tmp10_);
			_tmp11_ = p;
			if (px > _tmp11_->xmin) {
				BirdFontPath* _tmp12_;
				_tmp12_ = p;
				px = _tmp12_->xmin;
			}
			_tmp13_ = p;
			if (py > _tmp13_->ymin) {
				BirdFontPath* _tmp14_;
				_tmp14_ = p;
				py = _tmp14_->ymin;
			}
			_tmp15_ = p;
			if (px2 < _tmp15_->xmax) {
				BirdFontPath* _tmp16_;
				_tmp16_ = p;
				px2 = _tmp16_->xmax;
			}
			_tmp17_ = p;
			if (py2 < _tmp17_->ymax) {
				BirdFontPath* _tmp18_;
				_tmp18_ = p;
				py2 = _tmp18_->ymax;
			}
			_g_object_unref0 (p);
		}
	}
	_vala_w = px2 - px;
	_vala_h = py2 - py;
	_vala_x = px + (_vala_w / 2);
	_vala_y = py + (_vala_h / 2);
	_g_object_unref0 (glyph);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

static void
bird_font_move_tool_move_selected_paths (BirdFontMoveTool* self,
                                         guint key)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	BirdFontFont* _tmp11_;
	BirdFontFont* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	x = (gdouble) 0;
	y = (gdouble) 0;
	switch (key) {
		case BIRD_FONT_KEY_UP:
		{
			y = (gdouble) 1;
			break;
		}
		case BIRD_FONT_KEY_DOWN:
		{
			y = (gdouble) -1;
			break;
		}
		case BIRD_FONT_KEY_LEFT:
		{
			x = (gdouble) -1;
			break;
		}
		case BIRD_FONT_KEY_RIGHT:
		{
			x = (gdouble) 1;
			break;
		}
		default:
		{
			break;
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _path_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _path_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_path_list = _tmp2_;
		_tmp3_ = _path_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_path_size = _tmp5_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* path = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_path_index = _path_index + 1;
			_tmp6_ = _path_index;
			_tmp7_ = _path_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _path_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _path_index);
			path = (BirdFontPath*) _tmp9_;
			_tmp10_ = path;
			bird_font_path_move (_tmp10_, x * bird_font_glyph_ivz (), y * bird_font_glyph_ivz ());
			_g_object_unref0 (path);
		}
	}
	_tmp11_ = bird_font_bird_font_get_current_font ();
	_tmp12_ = _tmp11_;
	bird_font_font_touch (_tmp12_);
	_g_object_unref0 (_tmp12_);
	bird_font_pen_tool_reset_stroke ();
	bird_font_move_tool_update_selection_boundaries ();
	g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL], 0);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (glyph);
}

static void
bird_font_move_tool_tie_path_to_ttf_grid (BirdFontPath* p)
{
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	gdouble qx = 0.0;
	gdouble qy = 0.0;
	g_return_if_fail (p != NULL);
	sx = p->xmax;
	sy = p->ymax;
	qx = p->xmin;
	qy = p->ymin;
	bird_font_grid_tool_ttf_grid_coordinate (&sx, &sy);
	bird_font_grid_tool_ttf_grid_coordinate (&qx, &qy);
	if (fabs (qy - p->ymin) < fabs (sy - p->ymax)) {
		bird_font_path_move (p, (gdouble) 0, qy - p->ymin);
	} else {
		bird_font_path_move (p, (gdouble) 0, sy - p->ymax);
	}
	if (fabs (qx - p->xmin) < fabs (sx - p->xmax)) {
		bird_font_path_move (p, qx - p->xmin, (gdouble) 0);
	} else {
		bird_font_path_move (p, sx - p->xmax, (gdouble) 0);
	}
}

static void
bird_font_move_tool_tie_paths_to_grid (BirdFontGlyph* g)
{
	gdouble sx = 0.0;
	gdouble sy = 0.0;
	gdouble qx = 0.0;
	gdouble qy = 0.0;
	gdouble dx_min = 0.0;
	gdouble dx_max = 0.0;
	gdouble dy_min = 0.0;
	gdouble dy_max = 0.0;
	gdouble maxx = 0.0;
	gdouble maxy = 0.0;
	gdouble minx = 0.0;
	gdouble miny = 0.0;
	g_return_if_fail (g != NULL);
	bird_font_move_tool_update_selection_boundaries ();
	maxx = bird_font_move_tool_selection_box_center_x + (bird_font_move_tool_selection_box_width / 2);
	maxy = bird_font_move_tool_selection_box_center_y + (bird_font_move_tool_selection_box_height / 2);
	minx = bird_font_move_tool_selection_box_center_x - (bird_font_move_tool_selection_box_width / 2);
	miny = bird_font_move_tool_selection_box_center_y - (bird_font_move_tool_selection_box_height / 2);
	sx = maxx;
	sy = maxy;
	qx = minx;
	qy = miny;
	bird_font_grid_tool_tie_coordinate (&sx, &sy);
	bird_font_grid_tool_tie_coordinate (&qx, &qy);
	dy_min = fabs (qy - miny);
	dy_max = fabs (sy - maxy);
	dx_min = fabs (qx - minx);
	dx_max = fabs (sx - maxx);
	{
		GeeArrayList* _p_list = NULL;
		GeeArrayList* _tmp0_;
		gint _p_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = g->active_paths;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _p_index);
			p = (BirdFontPath*) _tmp7_;
			if (dy_min < dy_max) {
				BirdFontPath* _tmp8_;
				_tmp8_ = p;
				bird_font_path_move (_tmp8_, (gdouble) 0, qy - miny);
			} else {
				BirdFontPath* _tmp9_;
				_tmp9_ = p;
				bird_font_path_move (_tmp9_, (gdouble) 0, sy - maxy);
			}
			if (dx_min < dx_max) {
				BirdFontPath* _tmp10_;
				_tmp10_ = p;
				bird_font_path_move (_tmp10_, qx - minx, (gdouble) 0);
			} else {
				BirdFontPath* _tmp11_;
				_tmp11_ = p;
				bird_font_path_move (_tmp11_, sx - maxx, (gdouble) 0);
			}
			_g_object_unref0 (p);
		}
	}
	bird_font_move_tool_update_selection_boundaries ();
}

void
bird_font_move_tool_update_boundaries_for_selection (void)
{
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp10_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			_tmp10_ = p;
			bird_font_path_update_region_boundaries (_tmp10_);
			_g_object_unref0 (p);
		}
	}
	_g_object_unref0 (glyph);
}

void
bird_font_move_tool_flip_vertical (void)
{
	bird_font_move_tool_flip (TRUE);
}

void
bird_font_move_tool_flip_horizontal (void)
{
	bird_font_move_tool_flip (FALSE);
}

void
bird_font_move_tool_flip (gboolean vertical)
{
	gdouble xc = 0.0;
	gdouble yc = 0.0;
	gdouble xc2 = 0.0;
	gdouble yc2 = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble dx = 0.0;
	gdouble dy = 0.0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	BirdFontFont* _tmp27_;
	BirdFontFont* _tmp28_;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	glyph = _tmp0_;
	bird_font_move_tool_update_selection_boundaries ();
	xc = bird_font_move_tool_selection_box_center_x;
	yc = bird_font_move_tool_selection_box_center_y;
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _p_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _p_index = 0;
		_tmp1_ = glyph;
		_tmp2_ = _tmp1_->active_paths;
		_p_list = _tmp2_;
		_tmp3_ = _p_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_p_size = _tmp5_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontPath* _tmp12_;
			_p_index = _p_index + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _p_index);
			p = (BirdFontPath*) _tmp9_;
			if (vertical) {
				BirdFontPath* _tmp10_;
				_tmp10_ = p;
				bird_font_path_flip_vertical (_tmp10_);
			} else {
				BirdFontPath* _tmp11_;
				_tmp11_ = p;
				bird_font_path_flip_horizontal (_tmp11_);
			}
			_tmp12_ = p;
			bird_font_path_reverse (_tmp12_);
			_g_object_unref0 (p);
		}
	}
	bird_font_move_tool_get_selection_box_boundaries (&_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
	xc2 = _tmp13_;
	yc2 = _tmp14_;
	w = _tmp15_;
	h = _tmp16_;
	dx = -(xc2 - xc);
	dy = -(yc2 - yc);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp17_;
		GeeArrayList* _tmp18_;
		gint _p_size = 0;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _p_index = 0;
		_tmp17_ = glyph;
		_tmp18_ = _tmp17_->active_paths;
		_p_list = _tmp18_;
		_tmp19_ = _p_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_p_size = _tmp21_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp24_;
			gpointer _tmp25_;
			BirdFontPath* _tmp26_;
			_p_index = _p_index + 1;
			_tmp22_ = _p_index;
			_tmp23_ = _p_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _p_list;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _p_index);
			p = (BirdFontPath*) _tmp25_;
			_tmp26_ = p;
			bird_font_path_move (_tmp26_, dx, dy);
			_g_object_unref0 (p);
		}
	}
	bird_font_move_tool_update_selection_boundaries ();
	bird_font_pen_tool_reset_stroke ();
	_tmp27_ = bird_font_bird_font_get_current_font ();
	_tmp28_ = _tmp27_;
	bird_font_font_touch (_tmp28_);
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (glyph);
}

void
bird_font_move_tool_select_all_paths (BirdFontMoveTool* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontGlyph* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = g;
	bird_font_glyph_clear_active_paths (_tmp1_);
	{
		GeeArrayList* _p_list = NULL;
		BirdFontGlyph* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _p_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp2_ = g;
		_tmp3_ = bird_font_glyph_get_paths_in_current_layer (_tmp2_);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			BirdFontPath* p = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			BirdFontPath* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _p_index);
			p = (BirdFontPath*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = bird_font_path_get_points (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ > 0) {
				BirdFontGlyph* _tmp16_;
				BirdFontPath* _tmp17_;
				_tmp16_ = g;
				_tmp17_ = p;
				bird_font_glyph_add_active_path (_tmp16_, NULL, _tmp17_);
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	_tmp18_ = g;
	bird_font_glyph_update_view (_tmp18_);
	bird_font_move_tool_update_selection_boundaries ();
	g_signal_emit (self, bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL], 0);
	_g_object_unref0 (g);
}

static void
bird_font_move_tool_class_init (BirdFontMoveToolClass * klass,
                                gpointer klass_data)
{
	bird_font_move_tool_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_move_tool_finalize;
	bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", BIRD_FONT_TYPE_MOVE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_MOVED_SIGNAL] = g_signal_new ("objects-moved", BIRD_FONT_TYPE_MOVE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	bird_font_move_tool_signals[BIRD_FONT_MOVE_TOOL_OBJECTS_DESELECTED_SIGNAL] = g_signal_new ("objects-deselected", BIRD_FONT_TYPE_MOVE_TOOL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bird_font_move_tool_instance_init (BirdFontMoveTool * self,
                                   gpointer klass)
{
}

static void
bird_font_move_tool_finalize (GObject * obj)
{
	BirdFontMoveTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_MOVE_TOOL, BirdFontMoveTool);
	G_OBJECT_CLASS (bird_font_move_tool_parent_class)->finalize (obj);
}

static GType
bird_font_move_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontMoveToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_move_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontMoveTool), 0, (GInstanceInitFunc) bird_font_move_tool_instance_init, NULL };
	GType bird_font_move_tool_type_id;
	bird_font_move_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontMoveTool", &g_define_type_info, 0);
	return bird_font_move_tool_type_id;
}

GType
bird_font_move_tool_get_type (void)
{
	static volatile gsize bird_font_move_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_move_tool_type_id__once)) {
		GType bird_font_move_tool_type_id;
		bird_font_move_tool_type_id = bird_font_move_tool_get_type_once ();
		g_once_init_leave (&bird_font_move_tool_type_id__once, bird_font_move_tool_type_id);
	}
	return bird_font_move_tool_type_id__once;
}

