/* Lookups.c generated by valac 0.56.16, the Vala compiler
 * generated from Lookups.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LOOKUPS_0_PROPERTY,
	BIRD_FONT_LOOKUPS_NUM_PROPERTIES
};
static GParamSpec* bird_font_lookups_properties[BIRD_FONT_LOOKUPS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer bird_font_lookups_parent_class = NULL;

static void bird_font_lookups_finalize (GObject * obj);
static GType bird_font_lookups_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

BirdFontLookups*
bird_font_lookups_construct (GType object_type)
{
	BirdFontLookups * self = NULL;
	self = (BirdFontLookups*) g_object_new (object_type, NULL);
	return self;
}

BirdFontLookups*
bird_font_lookups_new (void)
{
	return bird_font_lookups_construct (BIRD_FONT_TYPE_LOOKUPS);
}

/** Subtables added in the proirity order for the substitution or
 * spacing transformation. The first table will have highest 
 * priority.
 */
void
bird_font_lookups_add_lookup (BirdFontLookups* self,
                              BirdFontLookup* lookup)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lookup != NULL);
	_tmp0_ = self->tables;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, lookup);
}

/** Find the lookup index for a particular lookup. */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

guint16
bird_font_lookups_find (BirdFontLookups* self,
                        const gchar* token)
{
	guint16 index = 0U;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	index = (guint16) 0;
	{
		GeeArrayList* _lookup_list = NULL;
		GeeArrayList* _tmp0_;
		gint _lookup_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _lookup_index = 0;
		_tmp0_ = self->tables;
		_lookup_list = _tmp0_;
		_tmp1_ = _lookup_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_lookup_size = _tmp3_;
		_lookup_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLookup* lookup = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLookup* _tmp8_;
			const gchar* _tmp9_;
			guint16 _tmp10_;
			_lookup_index = _lookup_index + 1;
			_tmp4_ = _lookup_index;
			_tmp5_ = _lookup_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _lookup_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _lookup_index);
			lookup = (BirdFontLookup*) _tmp7_;
			_tmp8_ = lookup;
			_tmp9_ = _tmp8_->token;
			if (g_strcmp0 (_tmp9_, token) == 0) {
				result = index;
				_g_object_unref0 (lookup);
				return result;
			}
			_tmp10_ = index;
			index = _tmp10_ + 1;
			_g_object_unref0 (lookup);
		}
	}
	_tmp11_ = string_to_string (token);
	_tmp12_ = g_strconcat ("No lookup has been created with token ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	g_warning ("Lookups.vala:46: %s", _tmp13_);
	_g_free0 (_tmp13_);
	result = (guint16) 0;
	return result;
}

void
bird_font_lookups_append (BirdFontLookups* self,
                          BirdFontLookups* lookups)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (lookups != NULL);
	{
		GeeArrayList* _lookup_list = NULL;
		GeeArrayList* _tmp0_;
		gint _lookup_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _lookup_index = 0;
		_tmp0_ = lookups->tables;
		_lookup_list = _tmp0_;
		_tmp1_ = _lookup_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_lookup_size = _tmp3_;
		_lookup_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLookup* lookup = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GeeArrayList* _tmp8_;
			BirdFontLookup* _tmp9_;
			_lookup_index = _lookup_index + 1;
			_tmp4_ = _lookup_index;
			_tmp5_ = _lookup_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _lookup_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _lookup_index);
			lookup = (BirdFontLookup*) _tmp7_;
			_tmp8_ = self->tables;
			_tmp9_ = lookup;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
			_g_object_unref0 (lookup);
		}
	}
}

BirdFontFontData*
bird_font_lookups_generate_lookup_list (BirdFontLookups* self,
                                        GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFontData* entry = NULL;
	guint lookup_offset = 0U;
	BirdFontFontData* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	BirdFontFontData* _tmp35_;
	GError* _inner_error0_ = NULL;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = fd;
	_tmp2_ = self->tables;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	bird_font_font_data_add_ushort (_tmp1_, (guint16) _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (entry);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp5_ = self->tables;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	lookup_offset = (guint) (2 + (2 * _tmp7_));
	{
		GeeArrayList* _lookup_list = NULL;
		GeeArrayList* _tmp8_;
		gint _lookup_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _lookup_index = 0;
		_tmp8_ = self->tables;
		_lookup_list = _tmp8_;
		_tmp9_ = _lookup_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_lookup_size = _tmp11_;
		_lookup_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontLookup* lookup = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontFontData* _tmp16_;
			guint _tmp17_ = 0U;
			BirdFontLookup* _tmp18_;
			_lookup_index = _lookup_index + 1;
			_tmp12_ = _lookup_index;
			_tmp13_ = _lookup_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _lookup_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _lookup_index);
			lookup = (BirdFontLookup*) _tmp15_;
			_tmp16_ = fd;
			bird_font_font_data_add_ushort (_tmp16_, (guint16) lookup_offset, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (lookup);
				_g_object_unref0 (entry);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp18_ = lookup;
			_tmp17_ = bird_font_lookup_get_lookup_entry_size (_tmp18_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (lookup);
				_g_object_unref0 (entry);
				_g_object_unref0 (fd);
				return NULL;
			}
			lookup_offset += _tmp17_;
			_g_object_unref0 (lookup);
		}
	}
	{
		GeeArrayList* _lookup_list = NULL;
		GeeArrayList* _tmp19_;
		gint _lookup_size = 0;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _lookup_index = 0;
		_tmp19_ = self->tables;
		_lookup_list = _tmp19_;
		_tmp20_ = _lookup_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_lookup_size = _tmp22_;
		_lookup_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			BirdFontLookup* lookup = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			BirdFontFontData* _tmp27_ = NULL;
			BirdFontLookup* _tmp28_;
			BirdFontFontData* _tmp29_;
			BirdFontFontData* _tmp30_;
			BirdFontLookup* _tmp31_;
			BirdFontFontData* _tmp32_;
			BirdFontFontData* _tmp33_;
			BirdFontFontData* _tmp34_;
			_lookup_index = _lookup_index + 1;
			_tmp23_ = _lookup_index;
			_tmp24_ = _lookup_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _lookup_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _lookup_index);
			lookup = (BirdFontLookup*) _tmp26_;
			_tmp28_ = lookup;
			_tmp29_ = bird_font_lookup_get_lookup_entry (_tmp28_, (guint) 0, &_inner_error0_);
			_tmp27_ = _tmp29_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (lookup);
				_g_object_unref0 (entry);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp30_ = _tmp27_;
			_tmp27_ = NULL;
			_g_object_unref0 (entry);
			entry = _tmp30_;
			_tmp31_ = lookup;
			_tmp32_ = fd;
			_tmp31_->entry_offset = bird_font_font_data_length_with_padding (_tmp32_);
			_tmp33_ = fd;
			_tmp34_ = entry;
			bird_font_font_data_append (_tmp33_, _tmp34_);
			_g_object_unref0 (_tmp27_);
			_g_object_unref0 (lookup);
		}
	}
	_tmp35_ = fd;
	if (lookup_offset != bird_font_font_data_length_with_padding (_tmp35_)) {
		gchar* _tmp36_;
		gchar* _tmp37_;
		BirdFontFontData* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		g_warning ("Lookups.vala:77: Wrong lookup offset.");
		_tmp36_ = g_strdup_printf ("%u", lookup_offset);
		_tmp37_ = _tmp36_;
		_tmp38_ = fd;
		_tmp39_ = g_strdup_printf ("%u", bird_font_font_data_length_with_padding (_tmp38_));
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat (_tmp37_, " != ", _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		g_warning ("Lookups.vala:78: %s", _tmp42_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp37_);
	}
	{
		GeeArrayList* _lookup_list = NULL;
		GeeArrayList* _tmp43_;
		gint _lookup_size = 0;
		GeeArrayList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _lookup_index = 0;
		_tmp43_ = self->tables;
		_lookup_list = _tmp43_;
		_tmp44_ = _lookup_list;
		_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_lookup_size = _tmp46_;
		_lookup_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			BirdFontLookup* lookup = NULL;
			GeeArrayList* _tmp49_;
			gpointer _tmp50_;
			guint offset_pos = 0U;
			BirdFontLookup* _tmp51_;
			BirdFontFontData* _tmp52_;
			guint offset = 0U;
			BirdFontFontData* _tmp53_;
			BirdFontLookup* _tmp54_;
			BirdFontFontData* _tmp66_;
			_lookup_index = _lookup_index + 1;
			_tmp47_ = _lookup_index;
			_tmp48_ = _lookup_size;
			if (!(_tmp47_ < _tmp48_)) {
				break;
			}
			_tmp49_ = _lookup_list;
			_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _lookup_index);
			lookup = (BirdFontLookup*) _tmp50_;
			_tmp51_ = lookup;
			offset_pos = _tmp51_->entry_offset + 6;
			_tmp52_ = fd;
			bird_font_font_data_seek (_tmp52_, offset_pos);
			_tmp53_ = fd;
			_tmp54_ = lookup;
			offset = bird_font_font_data_length_with_padding (_tmp53_) - _tmp54_->entry_offset;
			{
				GeeArrayList* _f_list = NULL;
				BirdFontLookup* _tmp55_;
				GeeArrayList* _tmp56_;
				gint _f_size = 0;
				GeeArrayList* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				gint _f_index = 0;
				_tmp55_ = lookup;
				_tmp56_ = _tmp55_->subtables;
				_f_list = _tmp56_;
				_tmp57_ = _f_list;
				_tmp58_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp57_);
				_tmp59_ = _tmp58_;
				_f_size = _tmp59_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp60_;
					gint _tmp61_;
					BirdFontFontData* f = NULL;
					GeeArrayList* _tmp62_;
					gpointer _tmp63_;
					BirdFontFontData* _tmp64_;
					BirdFontFontData* _tmp65_;
					_f_index = _f_index + 1;
					_tmp60_ = _f_index;
					_tmp61_ = _f_size;
					if (!(_tmp60_ < _tmp61_)) {
						break;
					}
					_tmp62_ = _f_list;
					_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, _f_index);
					f = (BirdFontFontData*) _tmp63_;
					_tmp64_ = fd;
					bird_font_font_data_add_ushort (_tmp64_, (guint16) offset, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (f);
						_g_object_unref0 (lookup);
						_g_object_unref0 (entry);
						_g_object_unref0 (fd);
						return NULL;
					}
					_tmp65_ = f;
					offset += bird_font_font_data_length_with_padding (_tmp65_);
					_g_object_unref0 (f);
				}
			}
			_tmp66_ = fd;
			bird_font_font_data_seek_end (_tmp66_);
			{
				GeeArrayList* _subtable_list = NULL;
				BirdFontLookup* _tmp67_;
				GeeArrayList* _tmp68_;
				gint _subtable_size = 0;
				GeeArrayList* _tmp69_;
				gint _tmp70_;
				gint _tmp71_;
				gint _subtable_index = 0;
				_tmp67_ = lookup;
				_tmp68_ = _tmp67_->subtables;
				_subtable_list = _tmp68_;
				_tmp69_ = _subtable_list;
				_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp69_);
				_tmp71_ = _tmp70_;
				_subtable_size = _tmp71_;
				_subtable_index = -1;
				while (TRUE) {
					gint _tmp72_;
					gint _tmp73_;
					BirdFontFontData* subtable = NULL;
					GeeArrayList* _tmp74_;
					gpointer _tmp75_;
					BirdFontFontData* _tmp76_;
					BirdFontFontData* _tmp77_;
					_subtable_index = _subtable_index + 1;
					_tmp72_ = _subtable_index;
					_tmp73_ = _subtable_size;
					if (!(_tmp72_ < _tmp73_)) {
						break;
					}
					_tmp74_ = _subtable_list;
					_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, _subtable_index);
					subtable = (BirdFontFontData*) _tmp75_;
					_tmp76_ = fd;
					_tmp77_ = subtable;
					bird_font_font_data_append (_tmp76_, _tmp77_);
					_g_object_unref0 (subtable);
				}
			}
			_g_object_unref0 (lookup);
		}
	}
	result = fd;
	_g_object_unref0 (entry);
	return result;
}

static void
bird_font_lookups_class_init (BirdFontLookupsClass * klass,
                              gpointer klass_data)
{
	bird_font_lookups_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_lookups_finalize;
}

static void
bird_font_lookups_instance_init (BirdFontLookups * self,
                                 gpointer klass)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LOOKUP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->tables = _tmp0_;
}

static void
bird_font_lookups_finalize (GObject * obj)
{
	BirdFontLookups * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LOOKUPS, BirdFontLookups);
	_g_object_unref0 (self->tables);
	G_OBJECT_CLASS (bird_font_lookups_parent_class)->finalize (obj);
}

static GType
bird_font_lookups_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLookupsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_lookups_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLookups), 0, (GInstanceInitFunc) bird_font_lookups_instance_init, NULL };
	GType bird_font_lookups_type_id;
	bird_font_lookups_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontLookups", &g_define_type_info, 0);
	return bird_font_lookups_type_id;
}

GType
bird_font_lookups_get_type (void)
{
	static volatile gsize bird_font_lookups_type_id__once = 0;
	if (g_once_init_enter (&bird_font_lookups_type_id__once)) {
		GType bird_font_lookups_type_id;
		bird_font_lookups_type_id = bird_font_lookups_get_type_once ();
		g_once_init_leave (&bird_font_lookups_type_id__once, bird_font_lookups_type_id);
	}
	return bird_font_lookups_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

