/* LocaTable.c generated by valac 0.56.16, the Vala compiler
 * generated from LocaTable.vala, do not modify */

/*
Copyright (C) 2012, 2013 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LOCA_TABLE_0_PROPERTY,
	BIRD_FONT_LOCA_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_loca_table_properties[BIRD_FONT_LOCA_TABLE_NUM_PROPERTIES];
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BirdFontLocaTablePrivate {
	guint32* glyph_offsets;
};

static gint BirdFontLocaTable_private_offset;
static gpointer bird_font_loca_table_parent_class = NULL;

static void bird_font_loca_table_finalize (GObject * obj);
static GType bird_font_loca_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_loca_table_get_instance_private (BirdFontLocaTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLocaTable_private_offset);
}

BirdFontLocaTable*
bird_font_loca_table_construct (GType object_type)
{
	BirdFontLocaTable * self = NULL;
	gchar* _tmp0_;
	self = (BirdFontLocaTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = g_strdup ("loca");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp0_;
	return self;
}

BirdFontLocaTable*
bird_font_loca_table_new (void)
{
	return bird_font_loca_table_construct (BIRD_FONT_TYPE_LOCA_TABLE);
}

guint32
bird_font_loca_table_get_offset (BirdFontLocaTable* self,
                                 guint32 i)
{
	guint32* _tmp0_;
	guint32 _tmp1_;
	guint32* _tmp10_;
	guint32 _tmp11_;
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->glyph_offsets;
	g_return_val_if_fail (_tmp0_ != NULL, 0);
	if (self->size == ((guint32) 0)) {
		g_warning ("LocaTable.vala:36: No glyphs in loca table");
	}
	_tmp1_ = i;
	if (!((((guint32) 0) <= _tmp1_) && (_tmp1_ < (self->size + 1)))) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = g_strdup_printf ("%u", i);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%u", i);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%u", self->size + 1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("No offset for glyph ", _tmp3_, ". Requires (0 <= ", _tmp5_, " < ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("LocaTable.vala:40: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	_tmp10_ = self->priv->glyph_offsets;
	_tmp11_ = _tmp10_[i];
	result = _tmp11_;
	return result;
}

/** Returns true if glyph at index i is empty and have no body to parse. */
gboolean
bird_font_loca_table_is_empty (BirdFontLocaTable* self,
                               guint32 i)
{
	guint32* _tmp0_;
	guint32 _tmp1_;
	guint32* _tmp10_;
	guint32 _tmp11_;
	guint32* _tmp12_;
	guint32 _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->glyph_offsets;
	g_return_val_if_fail (_tmp0_ != NULL, TRUE);
	if (self->size == ((guint32) 0)) {
		g_warning ("LocaTable.vala:51: No glyphs in loca table");
	}
	_tmp1_ = i;
	if (!((((guint32) 0) <= _tmp1_) && (_tmp1_ < (self->size + 1)))) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = g_strdup_printf ("%u", i);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf ("%u", i);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%u", self->size + 1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("No offset for glyph ", _tmp3_, ". Requires (0 <= ", _tmp5_, " < ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("LocaTable.vala:55: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	_tmp10_ = self->priv->glyph_offsets;
	_tmp11_ = _tmp10_[i];
	_tmp12_ = self->priv->glyph_offsets;
	_tmp13_ = _tmp12_[i + 1];
	result = _tmp11_ == _tmp13_;
	return result;
}

void
bird_font_loca_table_parse (BirdFontLocaTable* self,
                            BirdFontFontData* dis,
                            BirdFontHeadTable* head_table,
                            BirdFontMaxpTable* maxp_table,
                            GError** error)
{
	guint32* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	g_return_if_fail (head_table != NULL);
	g_return_if_fail (maxp_table != NULL);
	self->size = (guint32) maxp_table->num_glyphs;
	_tmp0_ = g_new0 (guint32, self->size + 1);
	self->priv->glyph_offsets = _tmp0_;
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	_tmp1_ = g_strdup_printf ("%u", self->size);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("size: ", _tmp2_, "\n", NULL);
	_tmp4_ = _tmp3_;
	bird_font_printd (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = g_strdup_printf ("%u", ((BirdFontOtfTable*) self)->length);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("length: ", _tmp6_, "\n", NULL);
	_tmp8_ = _tmp7_;
	bird_font_printd (_tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = g_strdup_printf ("%u", (((BirdFontOtfTable*) self)->length / 4) - 1);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("length/4-1: ", _tmp10_, "\n", NULL);
	_tmp12_ = _tmp11_;
	bird_font_printd (_tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = g_strdup_printf ("%u", (((BirdFontOtfTable*) self)->length / 2) - 1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat ("length/2-1: ", _tmp14_, "\n", NULL);
	_tmp16_ = _tmp15_;
	bird_font_printd (_tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp17_ = g_strdup_printf ("%" G_GINT16_FORMAT, head_table->loca_offset_size);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("head_table.loca_offset_size: ", _tmp18_, "\n", NULL);
	_tmp20_ = _tmp19_;
	bird_font_printd (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	switch (head_table->loca_offset_size) {
		case 0:
		{
			{
				glong i = 0L;
				i = (glong) 0;
				{
					gboolean _tmp21_ = FALSE;
					_tmp21_ = TRUE;
					while (TRUE) {
						guint32* _tmp23_;
						gboolean _tmp24_ = FALSE;
						glong _tmp25_;
						if (!_tmp21_) {
							glong _tmp22_;
							_tmp22_ = i;
							i = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						if (!(i < ((glong) (self->size + 1)))) {
							break;
						}
						_tmp23_ = self->priv->glyph_offsets;
						_tmp23_[i] = (guint32) (2 * bird_font_font_data_read_ushort (dis));
						_tmp25_ = i;
						if ((((glong) 0) < _tmp25_) && (_tmp25_ < ((glong) self->size))) {
							guint32* _tmp26_;
							guint32 _tmp27_;
							guint32* _tmp28_;
							guint32 _tmp29_;
							_tmp26_ = self->priv->glyph_offsets;
							_tmp27_ = _tmp26_[i - 1];
							_tmp28_ = self->priv->glyph_offsets;
							_tmp29_ = _tmp28_[i];
							_tmp24_ = _tmp27_ > _tmp29_;
						} else {
							_tmp24_ = FALSE;
						}
						if (_tmp24_) {
							guint32* _tmp30_;
							guint32 _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							guint32* _tmp34_;
							guint32 _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							gchar* _tmp39_;
							_tmp30_ = self->priv->glyph_offsets;
							_tmp31_ = _tmp30_[i - 1];
							_tmp32_ = g_strdup_printf ("%u", _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = self->priv->glyph_offsets;
							_tmp35_ = _tmp34_[i];
							_tmp36_ = g_strdup_printf ("%u", _tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = g_strconcat ("Invalid loca table, it must be sorted. (", _tmp33_, " > ", _tmp37_, ")", NULL);
							_tmp39_ = _tmp38_;
							g_warning ("LocaTable.vala:79: %s", _tmp39_);
							_g_free0 (_tmp39_);
							_g_free0 (_tmp37_);
							_g_free0 (_tmp33_);
						}
					}
				}
			}
			break;
		}
		case 1:
		{
			{
				glong i = 0L;
				i = (glong) 0;
				{
					gboolean _tmp40_ = FALSE;
					_tmp40_ = TRUE;
					while (TRUE) {
						guint32* _tmp42_;
						gboolean _tmp43_ = FALSE;
						glong _tmp44_;
						if (!_tmp40_) {
							glong _tmp41_;
							_tmp41_ = i;
							i = _tmp41_ + 1;
						}
						_tmp40_ = FALSE;
						if (!(i < ((glong) (self->size + 1)))) {
							break;
						}
						_tmp42_ = self->priv->glyph_offsets;
						_tmp42_[i] = bird_font_font_data_read_ulong (dis);
						_tmp44_ = i;
						if ((((glong) 0) < _tmp44_) && (_tmp44_ < ((glong) self->size))) {
							guint32* _tmp45_;
							guint32 _tmp46_;
							guint32* _tmp47_;
							guint32 _tmp48_;
							_tmp45_ = self->priv->glyph_offsets;
							_tmp46_ = _tmp45_[i - 1];
							_tmp47_ = self->priv->glyph_offsets;
							_tmp48_ = _tmp47_[i];
							_tmp43_ = _tmp46_ > _tmp48_;
						} else {
							_tmp43_ = FALSE;
						}
						if (_tmp43_) {
							guint32* _tmp49_;
							guint32 _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							guint32* _tmp53_;
							guint32 _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							_tmp49_ = self->priv->glyph_offsets;
							_tmp50_ = _tmp49_[i - 1];
							_tmp51_ = g_strdup_printf ("%u", _tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = self->priv->glyph_offsets;
							_tmp54_ = _tmp53_[i];
							_tmp55_ = g_strdup_printf ("%u", _tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = g_strconcat ("Invalid loca table, it must be sorted. (", _tmp52_, " > ", _tmp56_, ")", NULL);
							_tmp58_ = _tmp57_;
							g_warning ("LocaTable.vala:89: %s", _tmp58_);
							_g_free0 (_tmp58_);
							_g_free0 (_tmp56_);
							_g_free0 (_tmp52_);
						}
					}
				}
			}
			break;
		}
		default:
		{
			g_warning ("LocaTable.vala:96: unknown size for offset in loca table");
			break;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_loca_table_process (BirdFontLocaTable* self,
                              BirdFontGlyfTable* glyf_table,
                              BirdFontHeadTable* head_table)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	guint32 last = 0U;
	guint32 prev = 0U;
	gint i = 0;
	GeeArrayList* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	GeeArrayList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	BirdFontFontData* _tmp51_;
	BirdFontFontData* _tmp52_;
	BirdFontFontData* _tmp53_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	g_return_if_fail (head_table != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	last = (guint32) 0;
	prev = (guint32) 0;
	i = 0;
	{
		GeeArrayList* _o_list = NULL;
		GeeArrayList* _tmp1_;
		gint _o_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _o_index = 0;
		_tmp1_ = glyf_table->location_offsets;
		_o_list = _tmp1_;
		_tmp2_ = _o_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_o_size = _tmp4_;
		_o_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			guint32 o = 0U;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			gint _tmp14_;
			_o_index = _o_index + 1;
			_tmp5_ = _o_index;
			_tmp6_ = _o_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _o_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _o_index);
			o = (guint32) ((guintptr) _tmp8_);
			if (i != 0) {
				_tmp9_ = ((o - prev) % 4) != ((guint32) 0);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = g_strdup_printf ("%i", i);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat ("glyph length is not a multiple of four in gid ", _tmp11_, NULL);
				_tmp13_ = _tmp12_;
				g_warning ("LocaTable.vala:109: %s", _tmp13_);
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
			}
			if ((o % 4) != ((guint32) 0)) {
				g_warning ("LocaTable.vala:113: glyph is not on a four byte boundary");
				g_assert_not_reached ();
			}
			prev = o;
			_tmp14_ = i;
			i = _tmp14_ + 1;
		}
	}
	if (((gint) head_table->loca_offset_size) == 0) {
		{
			GeeArrayList* _o_list = NULL;
			GeeArrayList* _tmp15_;
			gint _o_size = 0;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _o_index = 0;
			_tmp15_ = glyf_table->location_offsets;
			_o_list = _tmp15_;
			_tmp16_ = _o_list;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_o_size = _tmp18_;
			_o_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				guint32 o = 0U;
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				BirdFontFontData* _tmp23_;
				_o_index = _o_index + 1;
				_tmp19_ = _o_index;
				_tmp20_ = _o_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _o_list;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _o_index);
				o = (guint32) ((guintptr) _tmp22_);
				_tmp23_ = fd;
				bird_font_font_data_add_u16 (_tmp23_, (guint16) (o / 2));
				if (o < last) {
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp24_ = g_strdup_printf ("%u", o);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_strdup_printf ("%u", last);
					_tmp27_ = _tmp26_;
					_tmp28_ = g_strconcat ("Loca table must be sorted. (", _tmp25_, " < ", _tmp27_, ")", NULL);
					_tmp29_ = _tmp28_;
					g_warning ("LocaTable.vala:126: %s", _tmp29_);
					_g_free0 (_tmp29_);
					_g_free0 (_tmp27_);
					_g_free0 (_tmp25_);
				}
				last = o;
			}
		}
	} else {
		if (((gint) head_table->loca_offset_size) == 1) {
			{
				GeeArrayList* _o_list = NULL;
				GeeArrayList* _tmp30_;
				gint _o_size = 0;
				GeeArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _o_index = 0;
				_tmp30_ = glyf_table->location_offsets;
				_o_list = _tmp30_;
				_tmp31_ = _o_list;
				_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_o_size = _tmp33_;
				_o_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					guint32 o = 0U;
					GeeArrayList* _tmp36_;
					gpointer _tmp37_;
					BirdFontFontData* _tmp38_;
					_o_index = _o_index + 1;
					_tmp34_ = _o_index;
					_tmp35_ = _o_size;
					if (!(_tmp34_ < _tmp35_)) {
						break;
					}
					_tmp36_ = _o_list;
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _o_index);
					o = (guint32) ((guintptr) _tmp37_);
					_tmp38_ = fd;
					bird_font_font_data_add_u32 (_tmp38_, o);
					if (o < last) {
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						_tmp39_ = g_strdup_printf ("%u", o);
						_tmp40_ = _tmp39_;
						_tmp41_ = g_strdup_printf ("%u", last);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strconcat ("Loca table must be sorted. (", _tmp40_, " < ", _tmp42_, ")", NULL);
						_tmp44_ = _tmp43_;
						g_warning ("LocaTable.vala:136: %s", _tmp44_);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp42_);
						_g_free0 (_tmp40_);
					}
					last = o;
				}
			}
		} else {
			g_warn_if_reached ();
		}
	}
	_tmp45_ = glyf_table->location_offsets;
	_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = glyf_table->glyphs;
	_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	if (!(_tmp47_ == (_tmp50_ + 1))) {
		g_warning ("LocaTable.vala:146: Bad location offset.");
	}
	_tmp51_ = fd;
	bird_font_font_data_pad (_tmp51_);
	_tmp52_ = fd;
	_tmp53_ = _g_object_ref0 (_tmp52_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp53_;
	_g_object_unref0 (fd);
}

static void
bird_font_loca_table_class_init (BirdFontLocaTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_loca_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLocaTable_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_loca_table_finalize;
}

static void
bird_font_loca_table_instance_init (BirdFontLocaTable * self,
                                    gpointer klass)
{
	self->priv = bird_font_loca_table_get_instance_private (self);
	self->priv->glyph_offsets = NULL;
	self->size = (guint32) 0;
}

static void
bird_font_loca_table_finalize (GObject * obj)
{
	BirdFontLocaTable * self;
	guint32* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LOCA_TABLE, BirdFontLocaTable);
	_tmp0_ = self->priv->glyph_offsets;
	if (_tmp0_ != NULL) {
		guint32* _tmp1_;
		_tmp1_ = self->priv->glyph_offsets;
		_g_free0 (_tmp1_);
	}
	G_OBJECT_CLASS (bird_font_loca_table_parent_class)->finalize (obj);
}

static GType
bird_font_loca_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLocaTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_loca_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLocaTable), 0, (GInstanceInitFunc) bird_font_loca_table_instance_init, NULL };
	GType bird_font_loca_table_type_id;
	bird_font_loca_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontLocaTable", &g_define_type_info, 0);
	BirdFontLocaTable_private_offset = g_type_add_instance_private (bird_font_loca_table_type_id, sizeof (BirdFontLocaTablePrivate));
	return bird_font_loca_table_type_id;
}

GType
bird_font_loca_table_get_type (void)
{
	static volatile gsize bird_font_loca_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_loca_table_type_id__once)) {
		GType bird_font_loca_table_type_id;
		bird_font_loca_table_type_id = bird_font_loca_table_get_type_once ();
		g_once_init_leave (&bird_font_loca_table_type_id__once, bird_font_loca_table_type_id);
	}
	return bird_font_loca_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

