/* Line.c generated by valac 0.56.16, the Vala compiler
 * generated from Line.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LINE_0_PROPERTY,
	BIRD_FONT_LINE_DASHED_PROPERTY,
	BIRD_FONT_LINE_NUM_PROPERTIES
};
static GParamSpec* bird_font_line_properties[BIRD_FONT_LINE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_color_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_color_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	BIRD_FONT_LINE_QUEUE_DRAW_AREA_SIGNAL,
	BIRD_FONT_LINE_POSITION_UPDATED_SIGNAL,
	BIRD_FONT_LINE_NUM_SIGNALS
};
static guint bird_font_line_signals[BIRD_FONT_LINE_NUM_SIGNALS] = {0};

struct _BirdFontLinePrivate {
	gboolean _dashed;
	gboolean vertical;
	gchar* metrics;
	gboolean active;
	gboolean move;
	gdouble r;
	gdouble g;
	gdouble b;
	gdouble a;
	gboolean visible;
	gboolean moveable;
};

static gint BirdFontLine_private_offset;
static gpointer bird_font_line_parent_class = NULL;

static void ____lambda39_ (BirdFontLine* self,
                    const gchar* text);
static void _____lambda39__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                               const gchar* text,
                                                               gpointer self);
static void ____lambda40_ (BirdFontLine* self);
static void _____lambda40__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                           const gchar* text,
                                                           gpointer self);
static void bird_font_line_redraw_line (BirdFontLine* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void bird_font_line_finalize (GObject * obj);
static GType bird_font_line_get_type_once (void);
static void _vala_bird_font_line_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_bird_font_line_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
bird_font_line_get_instance_private (BirdFontLine* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLine_private_offset);
}

BirdFontLine*
bird_font_line_construct (GType object_type,
                          const gchar* label,
                          const gchar* translated_label,
                          gdouble position,
                          gboolean vertical)
{
	BirdFontLine * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (translated_label != NULL, NULL);
	self = (BirdFontLine*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (label);
	_g_free0 (self->label);
	self->label = _tmp0_;
	_tmp1_ = g_strdup (translated_label);
	_g_free0 (self->translated_label);
	self->translated_label = _tmp1_;
	self->priv->vertical = vertical;
	self->pos = position;
	bird_font_line_set_dashed (self, FALSE);
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->metrics);
	self->priv->metrics = _tmp2_;
	bird_font_line_set_color_theme (self, "Guide 1");
	return self;
}

BirdFontLine*
bird_font_line_new (const gchar* label,
                    const gchar* translated_label,
                    gdouble position,
                    gboolean vertical)
{
	return bird_font_line_construct (BIRD_FONT_TYPE_LINE, label, translated_label, position, vertical);
}

BirdFontLine*
bird_font_line_copy (BirdFontLine* self)
{
	BirdFontLine* l = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	BirdFontLine* _tmp2_;
	gboolean _tmp3_;
	BirdFontLine* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->label;
	_tmp1_ = self->translated_label;
	_tmp2_ = bird_font_line_new (_tmp0_, _tmp1_, self->pos, self->priv->vertical);
	l = _tmp2_;
	l->priv->r = self->priv->r;
	l->priv->g = self->priv->g;
	l->priv->b = self->priv->b;
	l->priv->a = self->priv->a;
	l->priv->visible = self->priv->visible;
	_tmp3_ = self->priv->_dashed;
	bird_font_line_set_dashed (l, _tmp3_);
	result = l;
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
bird_font_line_set_metrics (BirdFontLine* self,
                            gdouble m)
{
	gchar* t = NULL;
	gchar* _tmp0_;
	gchar* s = NULL;
	gchar* _tmp1_;
	gint i = 0;
	gunichar c = 0U;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = double_to_string (m);
	t = _tmp0_;
	_tmp1_ = g_strdup ("");
	s = _tmp1_;
	i = 0;
	while (TRUE) {
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = t;
		_tmp4_ = string_get_next_char (_tmp2_, &i, &_tmp3_);
		c = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = s;
		_tmp6_ = g_unichar_to_string (c);
		_tmp7_ = (gchar*) _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_g_free0 (s);
		s = _tmp8_;
		_g_free0 (_tmp7_);
		if (i >= 5) {
			break;
		}
	}
	_tmp9_ = s;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->metrics);
	self->priv->metrics = _tmp10_;
	_g_free0 (s);
	_g_free0 (t);
}

void
bird_font_line_set_visible (BirdFontLine* self,
                            gboolean v)
{
	g_return_if_fail (self != NULL);
	self->priv->visible = v;
}

gboolean
bird_font_line_is_visible (BirdFontLine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->visible;
	return result;
}

void
bird_font_line_set_moveable (BirdFontLine* self,
                             gboolean m)
{
	g_return_if_fail (self != NULL);
	self->priv->moveable = m;
}

void
bird_font_line_set_color_theme (BirdFontLine* self,
                                const gchar* color)
{
	BirdFontColor* c = NULL;
	BirdFontColor* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = bird_font_theme_get_color (color);
	c = _tmp0_;
	self->priv->r = c->r;
	self->priv->g = c->g;
	self->priv->b = c->b;
	self->priv->a = c->a;
	_bird_font_color_unref0 (c);
}

void
bird_font_line_set_color (BirdFontLine* self,
                          gdouble r,
                          gdouble g,
                          gdouble b,
                          gdouble a)
{
	g_return_if_fail (self != NULL);
	self->priv->r = r;
	self->priv->g = g;
	self->priv->b = b;
	self->priv->a = a;
}

gboolean
bird_font_line_is_moving (BirdFontLine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->move;
	return result;
}

gboolean
bird_font_line_set_move (BirdFontLine* self,
                         gboolean moving)
{
	gboolean r = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	r = self->priv->move;
	self->priv->move = moving;
	result = r == moving;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
____lambda39_ (BirdFontLine* self,
               const gchar* text)
{
	gchar* submitted_value = NULL;
	gdouble parsed_value = 0.0;
	BirdFontGlyph* glyph = NULL;
	gdouble x1 = 0.0;
	gdouble y1 = 0.0;
	gdouble x2 = 0.0;
	gdouble y2 = 0.0;
	BirdFontGlyph* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (text != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (glyph);
	glyph = _tmp0_;
	_tmp1_ = string_replace (text, ",", ".");
	_g_free0 (submitted_value);
	submitted_value = _tmp1_;
	_tmp2_ = submitted_value;
	parsed_value = double_parse (_tmp2_);
	if (self->lsb) {
		BirdFontGlyph* _tmp3_;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		gboolean _tmp8_;
		_tmp3_ = glyph;
		_tmp8_ = bird_font_glyph_get_boundaries (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
		x1 = _tmp4_;
		y1 = _tmp5_;
		x2 = _tmp6_;
		y2 = _tmp7_;
		if (_tmp8_) {
			parsed_value = x1 - parsed_value;
		} else {
			BirdFontGlyph* _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			_tmp9_ = glyph;
			_tmp10_ = bird_font_glyph_get_right_limit (_tmp9_);
			_tmp11_ = _tmp10_;
			parsed_value = _tmp11_ - parsed_value;
		}
	} else {
		if (self->rsb) {
			BirdFontGlyph* _tmp12_;
			gdouble _tmp13_ = 0.0;
			gdouble _tmp14_ = 0.0;
			gdouble _tmp15_ = 0.0;
			gdouble _tmp16_ = 0.0;
			gboolean _tmp17_;
			_tmp12_ = glyph;
			_tmp17_ = bird_font_glyph_get_boundaries (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_, &_tmp16_);
			x1 = _tmp13_;
			y1 = _tmp14_;
			x2 = _tmp15_;
			y2 = _tmp16_;
			if (_tmp17_) {
				parsed_value += x2;
			} else {
				BirdFontGlyph* _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				_tmp18_ = glyph;
				_tmp19_ = bird_font_glyph_get_left_limit (_tmp18_);
				_tmp20_ = _tmp19_;
				parsed_value = _tmp20_ - parsed_value;
			}
		}
	}
	self->pos = parsed_value;
	g_signal_emit (self, bird_font_line_signals[BIRD_FONT_LINE_POSITION_UPDATED_SIGNAL], 0, parsed_value);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (glyph);
	_g_free0 (submitted_value);
}

static void
_____lambda39__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self)
{
	____lambda39_ ((BirdFontLine*) self, text);
}

static void
____lambda40_ (BirdFontLine* self)
{
	bird_font_tab_content_hide_text_input ();
}

static void
_____lambda40__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                      const gchar* text,
                                                      gpointer self)
{
	____lambda40_ ((BirdFontLine*) self);
}

gboolean
bird_font_line_button_press (BirdFontLine* self,
                             guint button)
{
	BirdFontGlyph* g = NULL;
	BirdFontTextListener* listener = NULL;
	gchar* position = NULL;
	gboolean text_input = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	text_input = FALSE;
	if (bird_font_line_get_active (self)) {
		gboolean _tmp0_ = FALSE;
		BirdFontGlyph* _tmp16_;
		BirdFontGlyph* _tmp17_;
		if (button == ((guint) 3)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = bird_font_key_bindings_has_shift ();
		}
		if (_tmp0_) {
			BirdFontGlyph* _tmp1_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			BirdFontTextListener* _tmp12_;
			BirdFontTextListener* _tmp13_;
			BirdFontTextListener* _tmp14_;
			BirdFontTextListener* _tmp15_;
			self->priv->move = FALSE;
			text_input = TRUE;
			_tmp1_ = bird_font_main_window_get_current_glyph ();
			_g_object_unref0 (g);
			g = _tmp1_;
			if (self->lsb) {
				BirdFontGlyph* _tmp2_;
				gchar* _tmp3_;
				_tmp2_ = g;
				_tmp3_ = double_to_string (bird_font_glyph_get_left_side_bearing (_tmp2_));
				_g_free0 (position);
				position = _tmp3_;
			} else {
				if (self->rsb) {
					BirdFontGlyph* _tmp4_;
					gchar* _tmp5_;
					_tmp4_ = g;
					_tmp5_ = double_to_string (bird_font_glyph_get_right_side_bearing (_tmp4_));
					_g_free0 (position);
					position = _tmp5_;
				} else {
					gchar* _tmp6_;
					_tmp6_ = double_to_string (self->pos);
					_g_free0 (position);
					position = _tmp6_;
				}
			}
			_tmp7_ = bird_font_t_ ("Position");
			_tmp8_ = _tmp7_;
			_tmp9_ = position;
			_tmp10_ = bird_font_t_ ("Move");
			_tmp11_ = _tmp10_;
			_tmp12_ = bird_font_text_listener_new (_tmp8_, _tmp9_, _tmp11_);
			_g_object_unref0 (listener);
			listener = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp8_);
			_tmp13_ = listener;
			g_signal_connect_object (_tmp13_, "signal-text-input", (GCallback) _____lambda39__bird_font_text_listener_signal_text_input, self, 0);
			_tmp14_ = listener;
			g_signal_connect_object (_tmp14_, "signal-submit", (GCallback) _____lambda40__bird_font_text_listener_signal_submit, self, 0);
			_tmp15_ = listener;
			bird_font_tab_content_show_text_input (_tmp15_);
		} else {
			self->priv->move = TRUE;
		}
		_tmp16_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (g);
		g = _tmp16_;
		_tmp17_ = g;
		bird_font_glyph_store_undo_state (_tmp17_, FALSE);
	} else {
		self->priv->move = FALSE;
		self->priv->active = FALSE;
	}
	if (self->priv->move) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = text_input;
	}
	result = _tmp18_;
	_g_free0 (position);
	_g_object_unref0 (listener);
	_g_object_unref0 (g);
	return result;
}

static void
bird_font_line_redraw_line (BirdFontLine* self)
{
	g_return_if_fail (self != NULL);
	bird_font_glyph_canvas_redraw ();
}

gboolean
bird_font_line_event_move_to (BirdFontLine* self,
                              gint x,
                              gint y,
                              BirdFontWidgetAllocation* allocation)
{
	gdouble p = 0.0;
	gdouble c = 0.0;
	gboolean a = FALSE;
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble ivz = 0.0;
	BirdFontGlyph* _tmp1_;
	gdouble margin = 0.0;
	gdouble none = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (allocation != NULL, FALSE);
	a = FALSE;
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	_tmp1_ = g;
	ivz = 1 / _tmp1_->view_zoom;
	margin = (gdouble) 10;
	none = (gdouble) 0;
	if (!self->priv->moveable) {
		result = FALSE;
		_g_object_unref0 (g);
		return result;
	}
	if (bird_font_line_is_vertical (self)) {
		gboolean _tmp2_ = FALSE;
		BirdFontGlyph* _tmp3_;
		BirdFontWidgetAllocation* _tmp4_;
		_tmp3_ = g;
		_tmp4_ = _tmp3_->allocation;
		if (y > (_tmp4_->height - 10)) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = y < 10;
		}
		if (_tmp2_) {
			gdouble _tmp5_;
			p = self->pos;
			c = bird_font_glyph_path_coordinate_x ((gdouble) x);
			_tmp5_ = c;
			a = ((p - (margin * ivz)) <= _tmp5_) && (_tmp5_ <= (p + (margin * ivz)));
		}
		if (a != bird_font_line_get_active (self)) {
			bird_font_line_redraw_line (self);
		}
		bird_font_line_set_active (self, a);
	} else {
		gboolean _tmp6_ = FALSE;
		BirdFontGlyph* _tmp7_;
		BirdFontWidgetAllocation* _tmp8_;
		_tmp7_ = g;
		_tmp8_ = _tmp7_->allocation;
		if (x > (_tmp8_->width - 10)) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = x < 10;
		}
		if (_tmp6_) {
			gdouble _tmp9_;
			p = self->pos;
			c = bird_font_glyph_path_coordinate_y ((gdouble) y);
			_tmp9_ = c;
			a = ((p - (margin * ivz)) <= _tmp9_) && (_tmp9_ <= (p + (margin * ivz)));
		}
		if (a != bird_font_line_get_active (self)) {
			bird_font_line_redraw_line (self);
		}
		bird_font_line_set_active (self, a);
	}
	if (self->priv->move) {
		gdouble np = 0.0;
		BirdFontFont* _tmp14_;
		BirdFontFont* _tmp15_;
		np = self->pos;
		bird_font_line_redraw_line (self);
		if (bird_font_line_is_vertical (self)) {
			self->pos = bird_font_glyph_path_coordinate_x ((gdouble) x);
			if (bird_font_grid_tool_is_visible ()) {
				bird_font_grid_tool_tie_coordinate (&self->pos, &none);
			}
			bird_font_line_redraw_line (self);
		} else {
			if (!bird_font_grid_tool_lock_grid) {
				self->pos = bird_font_glyph_path_coordinate_y ((gdouble) y);
				if (bird_font_grid_tool_is_visible ()) {
					bird_font_grid_tool_tie_coordinate (&none, &self->pos);
				}
				bird_font_line_redraw_line (self);
			}
		}
		if (fabs (np - self->pos) > ((gdouble) 10)) {
			BirdFontGlyph* _tmp10_;
			BirdFontWidgetAllocation* _tmp11_;
			BirdFontGlyph* _tmp12_;
			BirdFontWidgetAllocation* _tmp13_;
			_tmp10_ = g;
			_tmp11_ = _tmp10_->allocation;
			_tmp12_ = g;
			_tmp13_ = _tmp12_->allocation;
			g_signal_emit (self, bird_font_line_signals[BIRD_FONT_LINE_QUEUE_DRAW_AREA_SIGNAL], 0, 0, 0, _tmp11_->width, _tmp13_->height);
		}
		g_signal_emit (self, bird_font_line_signals[BIRD_FONT_LINE_POSITION_UPDATED_SIGNAL], 0, self->pos);
		_tmp14_ = bird_font_bird_font_get_current_font ();
		_tmp15_ = _tmp14_;
		bird_font_font_touch (_tmp15_);
		_g_object_unref0 (_tmp15_);
	}
	if (bird_font_grid_tool_is_visible ()) {
		bird_font_grid_tool_update_lines ();
	}
	result = self->priv->move;
	_g_object_unref0 (g);
	return result;
}

gboolean
bird_font_line_get_active (BirdFontLine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->active;
	return result;
}

void
bird_font_line_set_active (BirdFontLine* self,
                           gboolean active)
{
	BirdFontGlyph* g = NULL;
	g_return_if_fail (self != NULL);
	if (active) {
		BirdFontGlyph* _tmp0_;
		_tmp0_ = bird_font_main_window_get_current_glyph ();
		_g_object_unref0 (g);
		g = _tmp0_;
		if (self->lsb) {
			BirdFontGlyph* _tmp1_;
			_tmp1_ = g;
			bird_font_line_set_metrics (self, bird_font_glyph_get_left_side_bearing (_tmp1_));
		} else {
			if (self->rsb) {
				BirdFontGlyph* _tmp2_;
				_tmp2_ = g;
				bird_font_line_set_metrics (self, bird_font_glyph_get_right_side_bearing (_tmp2_));
			}
		}
	}
	self->priv->active = active;
	_g_object_unref0 (g);
}

gchar*
bird_font_line_get_label (BirdFontLine* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->label;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
bird_font_line_is_vertical (BirdFontLine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->vertical;
	return result;
}

gint
bird_font_line_get_position_pixel (BirdFontLine* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (bird_font_line_is_vertical (self)) {
		result = bird_font_glyph_reverse_path_coordinate_x (self->pos);
		return result;
	}
	result = bird_font_glyph_reverse_path_coordinate_y (self->pos);
	return result;
}

gdouble
bird_font_line_get_pos (BirdFontLine* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->pos;
	return result;
}

void
bird_font_line_draw (BirdFontLine* self,
                     cairo_t* cr,
                     BirdFontWidgetAllocation* allocation)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble p = 0.0;
	gdouble h = 0.0;
	gdouble w = 0.0;
	gint _tmp1_ = 0;
	gdouble size = 0.0;
	BirdFontText* glyph_metrics = NULL;
	BirdFontText* line_label = NULL;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	if (self->priv->active) {
		_tmp1_ = 8;
	} else {
		_tmp1_ = 5;
	}
	size = (gdouble) _tmp1_;
	if (!self->priv->visible) {
		_g_object_unref0 (line_label);
		_g_object_unref0 (glyph_metrics);
		_g_object_unref0 (g);
		return;
	}
	cairo_save (cr);
	cairo_set_line_width (cr, (gdouble) 1);
	_tmp2_ = self->priv->_dashed;
	if (_tmp2_) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 2);
		_tmp3_[0] = (gdouble) 20;
		_tmp3_[1] = (gdouble) 20;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 2;
		cairo_set_dash (cr, _tmp4_, (gint) 2, (gdouble) 0);
		_tmp4_ = (g_free (_tmp4_), NULL);
	}
	if (self->priv->active) {
		bird_font_theme_color (cr, "Highlighted Guide");
	} else {
		cairo_set_source_rgba (cr, self->priv->r, self->priv->g, self->priv->b, self->priv->a);
	}
	if (bird_font_line_is_vertical (self)) {
		BirdFontGlyph* _tmp5_;
		BirdFontWidgetAllocation* _tmp6_;
		p = (gdouble) bird_font_glyph_reverse_path_coordinate_x (self->pos);
		_tmp5_ = g;
		_tmp6_ = _tmp5_->allocation;
		h = (gdouble) _tmp6_->height;
		cairo_move_to (cr, p, (gdouble) 0);
		cairo_line_to (cr, p, h);
		cairo_stroke (cr);
		cairo_scale (cr, (gdouble) 1, (gdouble) 1);
		if (self->priv->moveable) {
			cairo_new_path (cr);
			cairo_move_to (cr, p - size, h);
			cairo_line_to (cr, p, h - size);
			cairo_line_to (cr, p + size, h);
			cairo_close_path (cr);
			cairo_fill (cr);
			cairo_new_path (cr);
			cairo_move_to (cr, p - size, (gdouble) 0);
			cairo_line_to (cr, p, size);
			cairo_line_to (cr, p + size, (gdouble) 0);
			cairo_close_path (cr);
			cairo_fill (cr);
			if (bird_font_line_get_active (self)) {
				const gchar* _tmp7_;
				BirdFontText* _tmp8_;
				BirdFontText* _tmp9_;
				BirdFontText* _tmp10_;
				BirdFontText* _tmp11_;
				BirdFontText* _tmp12_;
				_tmp7_ = self->priv->metrics;
				_tmp8_ = bird_font_text_new (_tmp7_, (gdouble) 17, (gdouble) 0);
				_g_object_unref0 (glyph_metrics);
				glyph_metrics = _tmp8_;
				_tmp9_ = glyph_metrics;
				bird_font_theme_text_color (_tmp9_, "Highlighted Guide");
				_tmp10_ = glyph_metrics;
				((BirdFontWidget*) _tmp10_)->widget_x = p + 10;
				_tmp11_ = glyph_metrics;
				((BirdFontWidget*) _tmp11_)->widget_y = h - 25;
				_tmp12_ = glyph_metrics;
				bird_font_widget_draw ((BirdFontWidget*) _tmp12_, cr);
			}
		}
	} else {
		BirdFontGlyph* _tmp13_;
		BirdFontWidgetAllocation* _tmp14_;
		p = (gdouble) bird_font_glyph_reverse_path_coordinate_y (self->pos);
		_tmp13_ = g;
		_tmp14_ = _tmp13_->allocation;
		w = (gdouble) _tmp14_->width;
		cairo_move_to (cr, (gdouble) 0, p);
		cairo_line_to (cr, w, p);
		cairo_stroke (cr);
		if (self->priv->moveable) {
			cairo_new_path (cr);
			cairo_move_to (cr, w, p - size);
			cairo_line_to (cr, w - size, p);
			cairo_line_to (cr, w, p + size);
			cairo_close_path (cr);
			cairo_fill (cr);
			cairo_new_path (cr);
			cairo_move_to (cr, (gdouble) 0, p - size);
			cairo_line_to (cr, 0 + size, p);
			cairo_line_to (cr, (gdouble) 0, p + size);
			cairo_close_path (cr);
			cairo_fill (cr);
		}
	}
	if (bird_font_line_get_active (self)) {
		const gchar* _tmp15_;
		BirdFontText* _tmp16_;
		BirdFontText* _tmp26_;
		_tmp15_ = self->translated_label;
		_tmp16_ = bird_font_text_new (_tmp15_, (gdouble) 19, (gdouble) 0);
		_g_object_unref0 (line_label);
		line_label = _tmp16_;
		if (bird_font_line_is_vertical (self)) {
			BirdFontText* _tmp17_;
			BirdFontText* _tmp18_;
			_tmp17_ = line_label;
			((BirdFontWidget*) _tmp17_)->widget_x = p + 8;
			_tmp18_ = line_label;
			((BirdFontWidget*) _tmp18_)->widget_y = (gdouble) (allocation->height - 55);
		} else {
			BirdFontText* _tmp19_;
			BirdFontGlyph* _tmp20_;
			BirdFontWidgetAllocation* _tmp21_;
			BirdFontText* _tmp22_;
			BirdFontText* _tmp23_;
			_tmp19_ = line_label;
			_tmp20_ = g;
			_tmp21_ = _tmp20_->allocation;
			_tmp22_ = line_label;
			((BirdFontWidget*) _tmp19_)->widget_x = (_tmp21_->width - 10) - bird_font_text_get_extent (_tmp22_);
			_tmp23_ = line_label;
			((BirdFontWidget*) _tmp23_)->widget_y = p + 10;
		}
		if (self->priv->active) {
			BirdFontText* _tmp24_;
			_tmp24_ = line_label;
			bird_font_theme_text_color (_tmp24_, "Highlighted Guide");
		} else {
			BirdFontText* _tmp25_;
			_tmp25_ = line_label;
			bird_font_text_set_source_rgba (_tmp25_, self->priv->r, self->priv->g, self->priv->b, self->priv->a);
		}
		_tmp26_ = line_label;
		bird_font_widget_draw ((BirdFontWidget*) _tmp26_, cr);
	}
	cairo_restore (cr);
	_g_object_unref0 (line_label);
	_g_object_unref0 (glyph_metrics);
	_g_object_unref0 (g);
}

gboolean
bird_font_line_get_dashed (BirdFontLine* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dashed;
	return result;
}

void
bird_font_line_set_dashed (BirdFontLine* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bird_font_line_get_dashed (self);
	if (old_value != value) {
		self->priv->_dashed = value;
		g_object_notify_by_pspec ((GObject *) self, bird_font_line_properties[BIRD_FONT_LINE_DASHED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
bird_font_line_class_init (BirdFontLineClass * klass,
                           gpointer klass_data)
{
	bird_font_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLine_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bird_font_line_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bird_font_line_set_property;
	G_OBJECT_CLASS (klass)->finalize = bird_font_line_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BIRD_FONT_LINE_DASHED_PROPERTY, bird_font_line_properties[BIRD_FONT_LINE_DASHED_PROPERTY] = g_param_spec_boolean ("dashed", "dashed", "dashed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	bird_font_line_signals[BIRD_FONT_LINE_QUEUE_DRAW_AREA_SIGNAL] = g_signal_new ("queue-draw-area", BIRD_FONT_TYPE_LINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	bird_font_line_signals[BIRD_FONT_LINE_POSITION_UPDATED_SIGNAL] = g_signal_new ("position-updated", BIRD_FONT_TYPE_LINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
bird_font_line_instance_init (BirdFontLine * self,
                              gpointer klass)
{
	self->priv = bird_font_line_get_instance_private (self);
	self->priv->active = FALSE;
	self->priv->move = FALSE;
	self->priv->visible = TRUE;
	self->priv->moveable = TRUE;
	self->rsb = FALSE;
	self->lsb = FALSE;
}

static void
bird_font_line_finalize (GObject * obj)
{
	BirdFontLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LINE, BirdFontLine);
	_g_free0 (self->label);
	_g_free0 (self->translated_label);
	_g_free0 (self->priv->metrics);
	G_OBJECT_CLASS (bird_font_line_parent_class)->finalize (obj);
}

/** Guide */
static GType
bird_font_line_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLine), 0, (GInstanceInitFunc) bird_font_line_instance_init, NULL };
	GType bird_font_line_type_id;
	bird_font_line_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontLine", &g_define_type_info, 0);
	BirdFontLine_private_offset = g_type_add_instance_private (bird_font_line_type_id, sizeof (BirdFontLinePrivate));
	return bird_font_line_type_id;
}

GType
bird_font_line_get_type (void)
{
	static volatile gsize bird_font_line_type_id__once = 0;
	if (g_once_init_enter (&bird_font_line_type_id__once)) {
		GType bird_font_line_type_id;
		bird_font_line_type_id = bird_font_line_get_type_once ();
		g_once_init_leave (&bird_font_line_type_id__once, bird_font_line_type_id);
	}
	return bird_font_line_type_id__once;
}

static void
_vala_bird_font_line_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BirdFontLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LINE, BirdFontLine);
	switch (property_id) {
		case BIRD_FONT_LINE_DASHED_PROPERTY:
		g_value_set_boolean (value, bird_font_line_get_dashed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bird_font_line_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BirdFontLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BIRD_FONT_TYPE_LINE, BirdFontLine);
	switch (property_id) {
		case BIRD_FONT_LINE_DASHED_PROPERTY:
		bird_font_line_set_dashed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

