/* Ligatures.c generated by valac 0.56.16, the Vala compiler
 * generated from Ligatures.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LIGATURES_0_PROPERTY,
	BIRD_FONT_LIGATURES_NUM_PROPERTIES
};
static GParamSpec* bird_font_ligatures_properties[BIRD_FONT_LIGATURES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;

struct _BirdFontLigaturesPrivate {
	BirdFontFont* font;
};

struct _Block29Data {
	int _ref_count_;
	BirdFontLigatures* self;
	BirdFontLigaturesSingleLigatureIterator iter;
	gpointer iter_target;
};

struct _Block30Data {
	int _ref_count_;
	BirdFontLigatures* self;
	BirdFontContextualLigature* lig;
};

struct _Block31Data {
	int _ref_count_;
	BirdFontLigatures* self;
	BirdFontContextualLigature* lig;
};

struct _Block32Data {
	int _ref_count_;
	BirdFontLigatures* self;
	BirdFontContextualLigature* lig;
};

struct _Block33Data {
	int _ref_count_;
	BirdFontLigatures* self;
	BirdFontContextualLigature* lig;
};

static gint BirdFontLigatures_private_offset;
static gpointer bird_font_ligatures_parent_class = NULL;

static void __lambda512_ (BirdFontLigatures* self);
static void ___lambda512__bird_font_font_font_deleted (BirdFontFont* _sender,
                                                gpointer self);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda513_ (Block29Data* _data29_,
                   const gchar* substitution,
                   const gchar* ligature);
static void ___lambda513__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                          const gchar* ligature,
                                                          gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda398_ (Block30Data* _data30_,
                   const gchar* text);
static void ___lambda398__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda399_ (BirdFontLigatures* self);
static void ___lambda399__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda400_ (Block31Data* _data31_,
                   const gchar* text);
static void ___lambda400__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda401_ (BirdFontLigatures* self);
static void ___lambda401__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda402_ (Block32Data* _data32_,
                   const gchar* text);
static void ___lambda402__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda403_ (BirdFontLigatures* self);
static void ___lambda403__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda394_ (Block33Data* _data33_,
                   const gchar* text);
static void ___lambda394__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda395_ (BirdFontLigatures* self);
static void ___lambda395__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
static gint __lambda335_ (BirdFontLigatures* self,
                   BirdFontLigature* a,
                   BirdFontLigature* b);
static gint ___lambda335__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gint __lambda336_ (BirdFontLigatures* self,
                   BirdFontContextualLigature* a,
                   BirdFontContextualLigature* b);
static gint ___lambda336__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void bird_font_ligatures_finalize (GObject * obj);
static GType bird_font_ligatures_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_ligatures_get_instance_private (BirdFontLigatures* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLigatures_private_offset);
}

static void
__lambda512_ (BirdFontLigatures* self)
{
	BirdFontFont* _tmp0_;
	_tmp0_ = bird_font_font_empty;
	self->priv->font = _tmp0_;
}

static void
___lambda512__bird_font_font_font_deleted (BirdFontFont* _sender,
                                           gpointer self)
{
	__lambda512_ ((BirdFontLigatures*) self);
}

BirdFontLigatures*
bird_font_ligatures_construct (GType object_type,
                               BirdFontFont* font)
{
	BirdFontLigatures * self = NULL;
	g_return_val_if_fail (font != NULL, NULL);
	self = (BirdFontLigatures*) g_object_new (object_type, NULL);
	self->priv->font = font;
	g_signal_connect_object (font, "font-deleted", (GCallback) ___lambda512__bird_font_font_font_deleted, self, 0);
	return self;
}

BirdFontLigatures*
bird_font_ligatures_new (BirdFontFont* font)
{
	return bird_font_ligatures_construct (BIRD_FONT_TYPE_LIGATURES, font);
}

void
bird_font_ligatures_get_ligatures (BirdFontLigatures* self,
                                   BirdFontLigaturesLigatureIterator iter,
                                   gpointer iter_target)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp0_;
		gint _l_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _l_index = 0;
		_tmp0_ = self->ligatures;
		_l_list = _tmp0_;
		_tmp1_ = _l_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_l_size = _tmp3_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontLigature* l = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontLigature* _tmp8_;
			const gchar* _tmp9_;
			BirdFontLigature* _tmp10_;
			const gchar* _tmp11_;
			_l_index = _l_index + 1;
			_tmp4_ = _l_index;
			_tmp5_ = _l_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _l_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _l_index);
			l = (BirdFontLigature*) _tmp7_;
			_tmp8_ = l;
			_tmp9_ = _tmp8_->substitution;
			_tmp10_ = l;
			_tmp11_ = _tmp10_->ligature;
			iter (_tmp9_, _tmp11_, iter_target);
			_g_object_unref0 (l);
		}
	}
}

void
bird_font_ligatures_get_contextual_ligatures (BirdFontLigatures* self,
                                              BirdFontLigaturesContextualLigatureIterator iter,
                                              gpointer iter_target)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp0_;
		gint _l_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _l_index = 0;
		_tmp0_ = self->contextual_ligatures;
		_l_list = _tmp0_;
		_tmp1_ = _l_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_l_size = _tmp3_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontContextualLigature* l = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontContextualLigature* _tmp8_;
			_l_index = _l_index + 1;
			_tmp4_ = _l_index;
			_tmp5_ = _l_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _l_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _l_index);
			l = (BirdFontContextualLigature*) _tmp7_;
			_tmp8_ = l;
			iter (_tmp8_, iter_target);
			_g_object_unref0 (l);
		}
	}
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		BirdFontLigatures* self;
		self = _data29_->self;
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
__lambda513_ (Block29Data* _data29_,
              const gchar* substitution,
              const gchar* ligature)
{
	BirdFontLigatures* self;
	BirdFontGlyphCollection* gc = NULL;
	BirdFontGlyphSequence* lig = NULL;
	BirdFontGlyphSequence* gs = NULL;
	gchar** subst_names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint subst_names_length1;
	gint _subst_names_size_;
	BirdFontGlyphSequence* _tmp2_;
	BirdFontGlyphSequence* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	BirdFontGlyphSequence* _tmp32_;
	BirdFontGlyphSequence* _tmp33_;
	self = _data29_->self;
	g_return_if_fail (substitution != NULL);
	g_return_if_fail (ligature != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (substitution, " ", 0);
	subst_names = _tmp1_;
	subst_names_length1 = _vala_array_length (_tmp0_);
	_subst_names_size_ = subst_names_length1;
	_tmp2_ = bird_font_glyph_sequence_new ();
	_g_object_unref0 (lig);
	lig = _tmp2_;
	{
		GeeArrayList* _n_list = NULL;
		BirdFontFont* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _n_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _n_index = 0;
		_tmp3_ = self->priv->font;
		_tmp4_ = bird_font_font_get_names (_tmp3_, ligature);
		_n_list = _tmp4_;
		_tmp5_ = _n_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_n_size = _tmp7_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gchar* n = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontFont* _tmp12_;
			const gchar* _tmp13_;
			BirdFontGlyphCollection* _tmp14_;
			BirdFontGlyphCollection* _tmp15_;
			BirdFontGlyphSequence* _tmp16_;
			BirdFontGlyphCollection* _tmp17_;
			BirdFontGlyph* _tmp18_;
			BirdFontGlyph* _tmp19_;
			_n_index = _n_index + 1;
			_tmp8_ = _n_index;
			_tmp9_ = _n_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _n_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _n_index);
			n = (gchar*) _tmp11_;
			_tmp12_ = self->priv->font;
			_tmp13_ = n;
			_tmp14_ = bird_font_font_get_glyph_collection_by_name (_tmp12_, _tmp13_);
			_g_object_unref0 (gc);
			gc = _tmp14_;
			_tmp15_ = gc;
			if (_tmp15_ == NULL) {
				_g_free0 (n);
				_g_object_unref0 (_n_list);
				subst_names = (_vala_array_free (subst_names, subst_names_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (gs);
				_g_object_unref0 (lig);
				_g_object_unref0 (gc);
				return;
			}
			_tmp16_ = lig;
			_tmp17_ = gc;
			_tmp18_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
			_tmp19_ = _tmp18_;
			bird_font_glyph_sequence_add (_tmp16_, _tmp19_);
			_g_object_unref0 (_tmp19_);
			_g_free0 (n);
		}
		_g_object_unref0 (_n_list);
	}
	_tmp20_ = bird_font_glyph_sequence_new ();
	_g_object_unref0 (gs);
	gs = _tmp20_;
	_tmp21_ = subst_names;
	_tmp21__length1 = subst_names_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp21_;
		s_collection_length1 = _tmp21__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp22_;
			gchar* s = NULL;
			_tmp22_ = g_strdup (s_collection[s_it]);
			s = _tmp22_;
			{
				BirdFontFont* _tmp23_;
				const gchar* _tmp24_;
				BirdFontGlyphCollection* _tmp25_;
				BirdFontGlyphCollection* _tmp26_;
				BirdFontGlyphSequence* _tmp27_;
				GeeArrayList* _tmp28_;
				BirdFontGlyphCollection* _tmp29_;
				BirdFontGlyph* _tmp30_;
				BirdFontGlyph* _tmp31_;
				_tmp23_ = self->priv->font;
				_tmp24_ = s;
				_tmp25_ = bird_font_font_get_glyph_collection_by_name (_tmp23_, _tmp24_);
				_g_object_unref0 (gc);
				gc = _tmp25_;
				_tmp26_ = gc;
				if (_tmp26_ == NULL) {
					_g_free0 (s);
					subst_names = (_vala_array_free (subst_names, subst_names_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (gs);
					_g_object_unref0 (lig);
					_g_object_unref0 (gc);
					return;
				}
				_tmp27_ = gs;
				_tmp28_ = _tmp27_->glyph;
				_tmp29_ = gc;
				_tmp30_ = bird_font_glyph_collection_get_current (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, BIRD_FONT_TYPE_GLYPH_COLLECTION, BirdFontGlyphCollection));
				_tmp31_ = _tmp30_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp31_);
				_g_object_unref0 (_tmp31_);
				_g_free0 (s);
			}
		}
	}
	_tmp32_ = gs;
	_tmp33_ = lig;
	_data29_->iter (_tmp32_, _tmp33_, _data29_->iter_target);
	subst_names = (_vala_array_free (subst_names, subst_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (gs);
	_g_object_unref0 (lig);
	_g_object_unref0 (gc);
}

static void
___lambda513__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                     const gchar* ligature,
                                                     gpointer self)
{
	__lambda513_ (self, substitution, ligature);
}

void
bird_font_ligatures_get_single_substitution_ligatures (BirdFontLigatures* self,
                                                       BirdFontLigaturesSingleLigatureIterator iter,
                                                       gpointer iter_target)
{
	Block29Data* _data29_;
	g_return_if_fail (self != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_data29_->iter = iter;
	_data29_->iter_target = iter_target;
	bird_font_ligatures_get_ligatures (self, ___lambda513__bird_font_ligatures_ligature_iterator, _data29_);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

gint
bird_font_ligatures_count (BirdFontLigatures* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
bird_font_ligatures_count_contextual_ligatures (BirdFontLigatures* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
bird_font_ligatures_remove_at (BirdFontLigatures* self,
                               gint i)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BirdFontLigature* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = i;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->ligatures;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, i);
	_tmp6_ = (BirdFontLigature*) _tmp5_;
	_g_object_unref0 (_tmp6_);
}

void
bird_font_ligatures_remove_contextual_ligatures_at (BirdFontLigatures* self,
                                                    gint i)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BirdFontContextualLigature* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = i;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->contextual_ligatures;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, i);
	_tmp6_ = (BirdFontContextualLigature*) _tmp5_;
	_g_object_unref0 (_tmp6_);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		BirdFontLigatures* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->lig);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
__lambda398_ (Block30Data* _data30_,
              const gchar* text)
{
	BirdFontLigatures* self;
	gchar* _tmp0_;
	self = _data30_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data30_->lig->backtrack);
	_data30_->lig->backtrack = _tmp0_;
}

static void
___lambda398__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda398_ (self, text);
}

static void
__lambda399_ (BirdFontLigatures* self)
{
	BirdFontLigatureList* _tmp0_;
	BirdFontLigatureList* _tmp1_;
	bird_font_tab_content_hide_text_input ();
	_tmp0_ = bird_font_main_window_get_ligature_display ();
	_tmp1_ = _tmp0_;
	bird_font_table_update_rows ((BirdFontTable*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	bird_font_ligatures_sort_ligatures (self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda399__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda399_ ((BirdFontLigatures*) self);
}

void
bird_font_ligatures_set_beginning (BirdFontLigatures* self,
                                   gint index)
{
	Block30Data* _data30_;
	BirdFontTextListener* listener = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontTextListener* _tmp11_;
	g_return_if_fail (self != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->contextual_ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (_data30_->lig);
	_data30_->lig = (BirdFontContextualLigature*) _tmp5_;
	_tmp6_ = bird_font_t_ ("Beginning");
	_tmp7_ = _tmp6_;
	_tmp8_ = _data30_->lig->backtrack;
	_tmp9_ = bird_font_t_ ("Set");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_text_listener_new (_tmp7_, _tmp8_, _tmp10_);
	_g_object_unref0 (listener);
	listener = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	g_signal_connect_data (listener, "signal-text-input", (GCallback) ___lambda398__bird_font_text_listener_signal_text_input, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda399__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		BirdFontLigatures* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->lig);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
__lambda400_ (Block31Data* _data31_,
              const gchar* text)
{
	BirdFontLigatures* self;
	gchar* _tmp0_;
	self = _data31_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data31_->lig->input);
	_data31_->lig->input = _tmp0_;
}

static void
___lambda400__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda400_ (self, text);
}

static void
__lambda401_ (BirdFontLigatures* self)
{
	BirdFontLigatureList* _tmp0_;
	BirdFontLigatureList* _tmp1_;
	bird_font_tab_content_hide_text_input ();
	_tmp0_ = bird_font_main_window_get_ligature_display ();
	_tmp1_ = _tmp0_;
	bird_font_table_update_rows ((BirdFontTable*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	bird_font_ligatures_sort_ligatures (self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda401__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda401_ ((BirdFontLigatures*) self);
}

void
bird_font_ligatures_set_middle (BirdFontLigatures* self,
                                gint index)
{
	Block31Data* _data31_;
	BirdFontTextListener* listener = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontTextListener* _tmp11_;
	g_return_if_fail (self != NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->contextual_ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (_data31_->lig);
	_data31_->lig = (BirdFontContextualLigature*) _tmp5_;
	_tmp6_ = bird_font_t_ ("Middle");
	_tmp7_ = _tmp6_;
	_tmp8_ = _data31_->lig->input;
	_tmp9_ = bird_font_t_ ("Set");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_text_listener_new (_tmp7_, _tmp8_, _tmp10_);
	_g_object_unref0 (listener);
	listener = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	g_signal_connect_data (listener, "signal-text-input", (GCallback) ___lambda400__bird_font_text_listener_signal_text_input, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda401__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	block31_data_unref (_data31_);
	_data31_ = NULL;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		BirdFontLigatures* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->lig);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
__lambda402_ (Block32Data* _data32_,
              const gchar* text)
{
	BirdFontLigatures* self;
	gchar* _tmp0_;
	self = _data32_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data32_->lig->lookahead);
	_data32_->lig->lookahead = _tmp0_;
}

static void
___lambda402__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda402_ (self, text);
}

static void
__lambda403_ (BirdFontLigatures* self)
{
	BirdFontLigatureList* _tmp0_;
	BirdFontLigatureList* _tmp1_;
	bird_font_tab_content_hide_text_input ();
	_tmp0_ = bird_font_main_window_get_ligature_display ();
	_tmp1_ = _tmp0_;
	bird_font_table_update_rows ((BirdFontTable*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	bird_font_ligatures_sort_ligatures (self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda403__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda403_ ((BirdFontLigatures*) self);
}

void
bird_font_ligatures_set_end (BirdFontLigatures* self,
                             gint index)
{
	Block32Data* _data32_;
	BirdFontTextListener* listener = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontTextListener* _tmp11_;
	g_return_if_fail (self != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->contextual_ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (_data32_->lig);
	_data32_->lig = (BirdFontContextualLigature*) _tmp5_;
	_tmp6_ = bird_font_t_ ("End");
	_tmp7_ = _tmp6_;
	_tmp8_ = _data32_->lig->lookahead;
	_tmp9_ = bird_font_t_ ("Set");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_text_listener_new (_tmp7_, _tmp8_, _tmp10_);
	_g_object_unref0 (listener);
	listener = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	g_signal_connect_data (listener, "signal-text-input", (GCallback) ___lambda402__bird_font_text_listener_signal_text_input, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda403__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	block32_data_unref (_data32_);
	_data32_ = NULL;
}

void
bird_font_ligatures_set_ligature (BirdFontLigatures* self,
                                  gint index)
{
	BirdFontLigature* lig = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (lig);
	lig = (BirdFontLigature*) _tmp5_;
	bird_font_ligature_set_ligature (lig);
	_g_object_unref0 (lig);
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		BirdFontLigatures* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->lig);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
__lambda394_ (Block33Data* _data33_,
              const gchar* text)
{
	BirdFontLigatures* self;
	gchar* _tmp0_;
	self = _data33_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data33_->lig->ligatures);
	_data33_->lig->ligatures = _tmp0_;
}

static void
___lambda394__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda394_ (self, text);
}

static void
__lambda395_ (BirdFontLigatures* self)
{
	BirdFontLigatureList* _tmp0_;
	BirdFontLigatureList* _tmp1_;
	bird_font_tab_content_hide_text_input ();
	_tmp0_ = bird_font_main_window_get_ligature_display ();
	_tmp1_ = _tmp0_;
	bird_font_table_update_rows ((BirdFontTable*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	bird_font_ligatures_sort_ligatures (self);
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda395__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda395_ ((BirdFontLigatures*) self);
}

void
bird_font_ligatures_set_contextual_ligature (BirdFontLigatures* self,
                                             gint index)
{
	Block33Data* _data33_;
	BirdFontTextListener* listener = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontTextListener* _tmp11_;
	g_return_if_fail (self != NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = self->contextual_ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->contextual_ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (_data33_->lig);
	_data33_->lig = (BirdFontContextualLigature*) _tmp5_;
	_tmp6_ = bird_font_t_ ("Ligature");
	_tmp7_ = _tmp6_;
	_tmp8_ = _data33_->lig->ligatures;
	_tmp9_ = bird_font_t_ ("Set");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_text_listener_new (_tmp7_, _tmp8_, _tmp10_);
	_g_object_unref0 (listener);
	listener = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	g_signal_connect_data (listener, "signal-text-input", (GCallback) ___lambda394__bird_font_text_listener_signal_text_input, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	g_signal_connect_object (listener, "signal-submit", (GCallback) ___lambda395__bird_font_text_listener_signal_submit, self, 0);
	bird_font_tab_content_show_text_input (listener);
	_g_object_unref0 (listener);
	block33_data_unref (_data33_);
	_data33_ = NULL;
}

void
bird_font_ligatures_set_substitution (BirdFontLigatures* self,
                                      gint index)
{
	BirdFontLigature* lig = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_if_fail ((0 <= _tmp3_) && (_tmp3_ < _tmp2_));
	_tmp4_ = self->ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, index);
	_g_object_unref0 (lig);
	lig = (BirdFontLigature*) _tmp5_;
	bird_font_ligature_set_substitution (lig);
	_g_object_unref0 (lig);
}

void
bird_font_ligatures_add_ligature (BirdFontLigatures* self,
                                  const gchar* subst,
                                  const gchar* liga)
{
	GeeArrayList* _tmp0_;
	BirdFontLigature* _tmp1_;
	BirdFontLigature* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subst != NULL);
	g_return_if_fail (liga != NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = bird_font_ligature_new (liga, subst);
	_tmp2_ = _tmp1_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp0_, 0, _tmp2_);
	_g_object_unref0 (_tmp2_);
	bird_font_ligatures_sort_ligatures (self);
}

void
bird_font_ligatures_add_contextual_ligature (BirdFontLigatures* self,
                                             const gchar* ligature,
                                             const gchar* backtrack,
                                             const gchar* input,
                                             const gchar* lookahead)
{
	BirdFontContextualLigature* l = NULL;
	BirdFontFont* _tmp0_;
	BirdFontContextualLigature* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ligature != NULL);
	g_return_if_fail (backtrack != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (lookahead != NULL);
	_tmp0_ = self->priv->font;
	_tmp1_ = bird_font_contextual_ligature_new (_tmp0_, ligature, backtrack, input, lookahead);
	l = _tmp1_;
	_tmp2_ = self->contextual_ligatures;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp2_, 0, l);
	bird_font_ligatures_sort_ligatures (self);
	_g_object_unref0 (l);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
__lambda335_ (BirdFontLigatures* self,
              BirdFontLigature* a,
              BirdFontLigature* b)
{
	BirdFontLigature* first = NULL;
	BirdFontLigature* next = NULL;
	gint chars_first = 0;
	gint chars_next = 0;
	BirdFontLigature* _tmp0_;
	BirdFontLigature* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_LIGATURE, BirdFontLigature));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_LIGATURE, BirdFontLigature));
	_g_object_unref0 (next);
	next = _tmp1_;
	_tmp2_ = first->substitution;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	chars_first = _vala_array_length (_tmp3_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = next->substitution;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	chars_next = _vala_array_length (_tmp7_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	result = chars_next - chars_first;
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda335__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda335_ ((BirdFontLigatures*) self, (BirdFontLigature*) a, (BirdFontLigature*) b);
	return result;
}

static gint
__lambda336_ (BirdFontLigatures* self,
              BirdFontContextualLigature* a,
              BirdFontContextualLigature* b)
{
	BirdFontContextualLigature* first = NULL;
	BirdFontContextualLigature* next = NULL;
	gint chars_first = 0;
	gint chars_next = 0;
	BirdFontContextualLigature* _tmp0_;
	BirdFontContextualLigature* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_CONTEXTUAL_LIGATURE, BirdFontContextualLigature));
	_g_object_unref0 (first);
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_CONTEXTUAL_LIGATURE, BirdFontContextualLigature));
	_g_object_unref0 (next);
	next = _tmp1_;
	_tmp2_ = first->backtrack;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	chars_first = _vala_array_length (_tmp3_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_tmp6_ = first->input;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _vala_array_length (_tmp7_);
	chars_first += _vala_array_length (_tmp7_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = first->lookahead;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _vala_array_length (_tmp11_);
	chars_first += _vala_array_length (_tmp11_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = next->backtrack;
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, " ", 0);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _vala_array_length (_tmp15_);
	chars_next = _vala_array_length (_tmp15_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = next->input;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, " ", 0);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _vala_array_length (_tmp19_);
	chars_next += _vala_array_length (_tmp19_);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_free), NULL);
	_tmp22_ = next->lookahead;
	_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, " ", 0);
	_tmp25_ = _tmp24_;
	_tmp25__length1 = _vala_array_length (_tmp23_);
	chars_next += _vala_array_length (_tmp23_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	result = chars_next - chars_first;
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda336__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = __lambda336_ ((BirdFontLigatures*) self, (BirdFontContextualLigature*) a, (BirdFontContextualLigature*) b);
	return result;
}

void
bird_font_ligatures_sort_ligatures (BirdFontLigatures* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->ligatures;
	gee_list_sort ((GeeList*) _tmp0_, ___lambda335__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp1_ = self->contextual_ligatures;
	gee_list_sort ((GeeList*) _tmp1_, ___lambda336__gcompare_data_func, g_object_ref (self), g_object_unref);
}

static void
bird_font_ligatures_class_init (BirdFontLigaturesClass * klass,
                                gpointer klass_data)
{
	bird_font_ligatures_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLigatures_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_ligatures_finalize;
}

static void
bird_font_ligatures_instance_init (BirdFontLigatures * self,
                                   gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = bird_font_ligatures_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LIGATURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->ligatures = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_CONTEXTUAL_LIGATURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->contextual_ligatures = _tmp1_;
}

static void
bird_font_ligatures_finalize (GObject * obj)
{
	BirdFontLigatures * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LIGATURES, BirdFontLigatures);
	_g_object_unref0 (self->ligatures);
	_g_object_unref0 (self->contextual_ligatures);
	G_OBJECT_CLASS (bird_font_ligatures_parent_class)->finalize (obj);
}

static GType
bird_font_ligatures_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLigaturesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_ligatures_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLigatures), 0, (GInstanceInitFunc) bird_font_ligatures_instance_init, NULL };
	GType bird_font_ligatures_type_id;
	bird_font_ligatures_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontLigatures", &g_define_type_info, 0);
	BirdFontLigatures_private_offset = g_type_add_instance_private (bird_font_ligatures_type_id, sizeof (BirdFontLigaturesPrivate));
	return bird_font_ligatures_type_id;
}

GType
bird_font_ligatures_get_type (void)
{
	static volatile gsize bird_font_ligatures_type_id__once = 0;
	if (g_once_init_enter (&bird_font_ligatures_type_id__once)) {
		GType bird_font_ligatures_type_id;
		bird_font_ligatures_type_id = bird_font_ligatures_get_type_once ();
		g_once_init_leave (&bird_font_ligatures_type_id__once, bird_font_ligatures_type_id);
	}
	return bird_font_ligatures_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

