/* LigatureSet.c generated by valac 0.56.16, the Vala compiler
 * generated from LigatureSet.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LIGATURE_SET_0_PROPERTY,
	BIRD_FONT_LIGATURE_SET_NUM_PROPERTIES
};
static GParamSpec* bird_font_ligature_set_properties[BIRD_FONT_LIGATURE_SET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontLigatureSetPrivate {
	BirdFontGlyfTable* glyf_table;
};

static gint BirdFontLigatureSet_private_offset;
static gpointer bird_font_ligature_set_parent_class = NULL;

static void bird_font_ligature_set_add_ligature (BirdFontLigatureSet* self,
                                          BirdFontFontData* fd,
                                          BirdFontLigature* ligature,
                                          GError** error);
static void bird_font_ligature_set_finalize (GObject * obj);
static GType bird_font_ligature_set_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_ligature_set_get_instance_private (BirdFontLigatureSet* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLigatureSet_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontLigatureSet*
bird_font_ligature_set_construct (GType object_type,
                                  BirdFontGlyfTable* gt)
{
	BirdFontLigatureSet * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	g_return_val_if_fail (gt != NULL, NULL);
	self = (BirdFontLigatureSet*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (gt);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	return self;
}

BirdFontLigatureSet*
bird_font_ligature_set_new (BirdFontGlyfTable* gt)
{
	return bird_font_ligature_set_construct (BIRD_FONT_TYPE_LIGATURE_SET, gt);
}

void
bird_font_ligature_set_add (BirdFontLigatureSet* self,
                            BirdFontLigature* lig)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lig != NULL);
	_tmp0_ = self->ligatures;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, lig);
}

gboolean
bird_font_ligature_set_starts_with (BirdFontLigatureSet* self,
                                    const gchar* s)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	BirdFontLigature* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->ligatures;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
	_tmp5_ = (BirdFontLigature*) _tmp4_;
	_tmp6_ = _tmp5_->substitution;
	_tmp7_ = g_str_has_prefix (_tmp6_, s);
	_g_object_unref0 (_tmp5_);
	result = _tmp7_;
	return result;
}

gchar*
bird_font_ligature_set_get_coverage_char (BirdFontLigatureSet* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp4_;
	gpointer _tmp5_;
	BirdFontLigature* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->ligatures;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gchar* _tmp3_;
		g_warning ("LigatureSet.vala:39: No ligatures in set.");
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->ligatures;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, 0);
	_tmp6_ = (BirdFontLigature*) _tmp5_;
	_tmp7_ = _tmp6_->substitution;
	_tmp8_ = bird_font_ligature_get_coverage (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp6_);
	result = _tmp9_;
	return result;
}

BirdFontFontData*
bird_font_ligature_set_get_set_data (BirdFontLigatureSet* self,
                                     GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* ligature_data = NULL;
	guint16 o = 0U;
	guint16 pos = 0U;
	BirdFontFontData* _tmp0_;
	BirdFontFontData* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontFontData* _tmp21_;
	BirdFontFontData* _tmp22_;
	GError* _inner_error0_ = NULL;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	_g_object_unref0 (fd);
	fd = _tmp0_;
	_tmp1_ = fd;
	_tmp2_ = self->ligatures;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	bird_font_font_data_add_ushort (_tmp1_, (guint16) _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (ligature_data);
		_g_object_unref0 (fd);
		return NULL;
	}
	_tmp5_ = bird_font_font_data_new ((guint32) 1024);
	_g_object_unref0 (ligature_data);
	ligature_data = _tmp5_;
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp6_;
		gint _l_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _l_index = 0;
		_tmp6_ = self->ligatures;
		_l_list = _tmp6_;
		_tmp7_ = _l_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_l_size = _tmp9_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			BirdFontLigature* l = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			BirdFontFontData* _tmp17_;
			BirdFontFontData* _tmp18_;
			BirdFontFontData* _tmp19_;
			BirdFontLigature* _tmp20_;
			_l_index = _l_index + 1;
			_tmp10_ = _l_index;
			_tmp11_ = _l_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _l_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _l_index);
			l = (BirdFontLigature*) _tmp13_;
			_tmp14_ = self->ligatures;
			_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			o = (guint16) (2 + (2 * _tmp16_));
			_tmp17_ = ligature_data;
			pos = (guint16) (o + bird_font_font_data_length_with_padding (_tmp17_));
			_tmp18_ = fd;
			bird_font_font_data_add_ushort (_tmp18_, pos, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (ligature_data);
				_g_object_unref0 (fd);
				return NULL;
			}
			_tmp19_ = ligature_data;
			_tmp20_ = l;
			bird_font_ligature_set_add_ligature (self, _tmp19_, _tmp20_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (ligature_data);
				_g_object_unref0 (fd);
				return NULL;
			}
			_g_object_unref0 (l);
		}
	}
	_tmp21_ = fd;
	_tmp22_ = ligature_data;
	bird_font_font_data_append (_tmp21_, _tmp22_);
	result = fd;
	_g_object_unref0 (ligature_data);
	return result;
}

/** Add ligature to fd */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_ligature_set_add_ligature (BirdFontLigatureSet* self,
                                     BirdFontFontData* fd,
                                     BirdFontLigature* ligature,
                                     GError** error)
{
	gchar** parts = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gboolean first = FALSE;
	gint gid = 0;
	gchar* l = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	const gchar* _tmp10_;
	BirdFontGlyfTable* _tmp12_;
	const gchar* _tmp13_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fd != NULL);
	g_return_if_fail (ligature != NULL);
	_tmp0_ = ligature->substitution;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	first = TRUE;
	_tmp3_ = ligature->ligature;
	_tmp4_ = string_strip (_tmp3_);
	_g_free0 (l);
	l = _tmp4_;
	_tmp6_ = l;
	if (g_str_has_prefix (_tmp6_, "U+")) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = l;
		_tmp5_ = g_str_has_prefix (_tmp7_, "u+");
	}
	if (_tmp5_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = l;
		_tmp9_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp8_));
		_g_free0 (l);
		l = (gchar*) _tmp9_;
	}
	_tmp10_ = l;
	if (g_strcmp0 (_tmp10_, "space") == 0) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (" ");
		_g_free0 (l);
		l = _tmp11_;
	}
	_tmp12_ = self->priv->glyf_table;
	_tmp13_ = l;
	gid = bird_font_glyf_table_get_gid (_tmp12_, _tmp13_);
	if (gid == -1) {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = ligature->ligature;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("No glyph ID for ligature ", _tmp15_, ".", NULL);
		_tmp17_ = _tmp16_;
		g_warning ("LigatureSet.vala:90: %s", _tmp17_);
		_g_free0 (_tmp17_);
		gid = 0;
	}
	bird_font_font_data_add_ushort (fd, (guint16) gid, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (l);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp18_ = parts;
	_tmp18__length1 = parts_length1;
	bird_font_font_data_add_ushort (fd, (guint16) _tmp18__length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (l);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp19_ = parts;
	_tmp19__length1 = parts_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp19_;
		p_collection_length1 = _tmp19__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp20_;
			gchar* p = NULL;
			_tmp20_ = g_strdup (p_collection[p_it]);
			p = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				const gchar* _tmp26_;
				BirdFontGlyfTable* _tmp28_;
				const gchar* _tmp29_;
				_tmp22_ = p;
				if (g_str_has_prefix (_tmp22_, "U+")) {
					_tmp21_ = TRUE;
				} else {
					const gchar* _tmp23_;
					_tmp23_ = p;
					_tmp21_ = g_str_has_prefix (_tmp23_, "u+");
				}
				if (_tmp21_) {
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp24_ = p;
					_tmp25_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp24_));
					_g_free0 (p);
					p = (gchar*) _tmp25_;
				}
				_tmp26_ = p;
				if (g_strcmp0 (_tmp26_, "space") == 0) {
					gchar* _tmp27_;
					_tmp27_ = g_strdup (" ");
					_g_free0 (p);
					p = _tmp27_;
				}
				_tmp28_ = self->priv->glyf_table;
				_tmp29_ = p;
				gid = (gint) ((guint16) bird_font_glyf_table_get_gid (_tmp28_, _tmp29_));
				if (gid == -1) {
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					_tmp30_ = ligature->ligature;
					_tmp31_ = string_to_string (_tmp30_);
					_tmp32_ = g_strconcat ("No glyph ID for ligature ", _tmp31_, ".", NULL);
					_tmp33_ = _tmp32_;
					g_warning ("LigatureSet.vala:111: %s", _tmp33_);
					_g_free0 (_tmp33_);
					gid = 0;
				}
				if (!first) {
					bird_font_font_data_add_ushort (fd, (guint16) gid, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (p);
						_g_free0 (l);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
				}
				first = FALSE;
				_g_free0 (p);
			}
		}
	}
	_g_free0 (l);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}

static void
bird_font_ligature_set_class_init (BirdFontLigatureSetClass * klass,
                                   gpointer klass_data)
{
	bird_font_ligature_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLigatureSet_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_ligature_set_finalize;
}

static void
bird_font_ligature_set_instance_init (BirdFontLigatureSet * self,
                                      gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_ligature_set_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LIGATURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->ligatures = _tmp0_;
}

static void
bird_font_ligature_set_finalize (GObject * obj)
{
	BirdFontLigatureSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LIGATURE_SET, BirdFontLigatureSet);
	_g_object_unref0 (self->ligatures);
	_g_object_unref0 (self->priv->glyf_table);
	G_OBJECT_CLASS (bird_font_ligature_set_parent_class)->finalize (obj);
}

static GType
bird_font_ligature_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLigatureSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_ligature_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLigatureSet), 0, (GInstanceInitFunc) bird_font_ligature_set_instance_init, NULL };
	GType bird_font_ligature_set_type_id;
	bird_font_ligature_set_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontLigatureSet", &g_define_type_info, 0);
	BirdFontLigatureSet_private_offset = g_type_add_instance_private (bird_font_ligature_set_type_id, sizeof (BirdFontLigatureSetPrivate));
	return bird_font_ligature_set_type_id;
}

GType
bird_font_ligature_set_get_type (void)
{
	static volatile gsize bird_font_ligature_set_type_id__once = 0;
	if (g_once_init_enter (&bird_font_ligature_set_type_id__once)) {
		GType bird_font_ligature_set_type_id;
		bird_font_ligature_set_type_id = bird_font_ligature_set_get_type_once ();
		g_once_init_leave (&bird_font_ligature_set_type_id__once, bird_font_ligature_set_type_id);
	}
	return bird_font_ligature_set_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

