/* LigatureList.c generated by valac 0.56.16, the Vala compiler
 * generated from LigatureList.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LIGATURE_LIST_0_PROPERTY,
	BIRD_FONT_LIGATURE_LIST_NUM_PROPERTIES
};
static GParamSpec* bird_font_ligature_list_properties[BIRD_FONT_LIGATURE_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block28Data Block28Data;

struct _BirdFontLigatureListPrivate {
	GeeArrayList* rows;
};

struct _Block28Data {
	int _ref_count_;
	BirdFontLigatureList* self;
	gint i;
	BirdFontRow* row;
};

static gint BirdFontLigatureList_private_offset;
static gpointer bird_font_ligature_list_parent_class = NULL;

static GeeArrayList* bird_font_ligature_list_real_get_rows (BirdFontTable* base);
static void bird_font_ligature_list_add_contextual_ligature (BirdFontLigatureList* self,
                                                      const gchar* ligature,
                                                      const gchar* backtrack,
                                                      const gchar* input,
                                                      const gchar* lookahead);
static void bird_font_ligature_list_add_ligature (BirdFontLigatureList* self,
                                           const gchar* subst,
                                           const gchar* liga);
static void bird_font_ligature_list_real_selected_row (BirdFontTable* base,
                                                BirdFontRow* row,
                                                gint column,
                                                gboolean delete_button);
static void bird_font_ligature_list_real_update_rows (BirdFontTable* base);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda396_ (Block28Data* _data28_,
                   BirdFontContextualLigature* liga);
static void ___lambda396__bird_font_ligatures_contextual_ligature_iterator (BirdFontContextualLigature* lig,
                                                                     gpointer self);
static void __lambda397_ (Block28Data* _data28_,
                   const gchar* subst,
                   const gchar* liga);
static void ___lambda397__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                          const gchar* ligature,
                                                          gpointer self);
static gchar* bird_font_ligature_list_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_ligature_list_real_get_name (BirdFontFontDisplay* base);
static void bird_font_ligature_list_finalize (GObject * obj);
static GType bird_font_ligature_list_get_type_once (void);

static inline gpointer
bird_font_ligature_list_get_instance_private (BirdFontLigatureList* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLigatureList_private_offset);
}

BirdFontLigatureList*
bird_font_ligature_list_construct (GType object_type)
{
	BirdFontLigatureList * self = NULL;
	self = (BirdFontLigatureList*) bird_font_table_construct (object_type);
	return self;
}

BirdFontLigatureList*
bird_font_ligature_list_new (void)
{
	return bird_font_ligature_list_construct (BIRD_FONT_TYPE_LIGATURE_LIST);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GeeArrayList*
bird_font_ligature_list_real_get_rows (BirdFontTable* base)
{
	BirdFontLigatureList * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
	self = (BirdFontLigatureList*) base;
	_tmp0_ = self->priv->rows;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
bird_font_ligature_list_add_contextual_ligature (BirdFontLigatureList* self,
                                                 const gchar* ligature,
                                                 const gchar* backtrack,
                                                 const gchar* input,
                                                 const gchar* lookahead)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontLigatures* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ligature != NULL);
	g_return_if_fail (backtrack != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (lookahead != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_font_get_ligatures (font);
	ligatures = _tmp1_;
	bird_font_ligatures_add_contextual_ligature (ligatures, ligature, backtrack, input, lookahead);
	_g_object_unref0 (ligatures);
	_g_object_unref0 (font);
}

static void
bird_font_ligature_list_add_ligature (BirdFontLigatureList* self,
                                      const gchar* subst,
                                      const gchar* liga)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontLigatures* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subst != NULL);
	g_return_if_fail (liga != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = bird_font_font_get_ligatures (font);
	ligatures = _tmp1_;
	bird_font_ligatures_add_ligature (ligatures, subst, liga);
	_g_object_unref0 (ligatures);
	_g_object_unref0 (font);
}

static void
bird_font_ligature_list_real_selected_row (BirdFontTable* base,
                                           BirdFontRow* row,
                                           gint column,
                                           gboolean delete_button)
{
	BirdFontLigatureList * self;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontFont* _tmp1_;
	BirdFontLigatures* _tmp2_;
	gint i = 0;
	gint ncontextual = 0;
	BirdFontLigatures* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_ = FALSE;
	BirdFontFont* _tmp39_;
	self = (BirdFontLigatureList*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_ligatures (_tmp1_);
	ligatures = _tmp2_;
	_tmp3_ = ligatures;
	_tmp4_ = _tmp3_->contextual_ligatures;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	ncontextual = _tmp6_;
	if (bird_font_row_get_index (row) == BIRD_FONT_LIGATURE_LIST_NEW_LIGATURE) {
		_tmp7_ = column == 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = bird_font_t_ ("character sequence");
		_tmp9_ = _tmp8_;
		_tmp10_ = bird_font_t_ ("ligature");
		_tmp11_ = _tmp10_;
		bird_font_ligature_list_add_ligature (self, _tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		bird_font_tab_content_hide_text_input ();
	} else {
		gboolean _tmp12_ = FALSE;
		if (bird_font_row_get_index (row) == BIRD_FONT_LIGATURE_LIST_NEW_LIGATURE) {
			_tmp12_ = column == 1;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp13_ = bird_font_t_ ("substitution");
			_tmp14_ = _tmp13_;
			_tmp15_ = bird_font_t_ ("beginning");
			_tmp16_ = _tmp15_;
			_tmp17_ = bird_font_t_ ("middle");
			_tmp18_ = _tmp17_;
			_tmp19_ = bird_font_t_ ("end");
			_tmp20_ = _tmp19_;
			bird_font_ligature_list_add_contextual_ligature (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			bird_font_tab_content_hide_text_input ();
		} else {
			if (bird_font_row_get_index (row) < ncontextual) {
				BirdFontLigatures* _tmp21_;
				i = bird_font_row_get_index (row);
				_tmp21_ = ligatures;
				if (i < bird_font_ligatures_count_contextual_ligatures (_tmp21_)) {
					BirdFontLigatures* _tmp22_;
					gint _tmp23_;
					_tmp22_ = ligatures;
					_tmp23_ = i;
					g_return_if_fail ((0 <= _tmp23_) && (_tmp23_ < bird_font_ligatures_count_contextual_ligatures (_tmp22_)));
					if (delete_button) {
						BirdFontLigatures* _tmp24_;
						_tmp24_ = ligatures;
						bird_font_ligatures_remove_contextual_ligatures_at (_tmp24_, i);
						bird_font_tab_content_hide_text_input ();
					}
					if (column == 0) {
						BirdFontLigatures* _tmp25_;
						_tmp25_ = ligatures;
						bird_font_ligatures_set_contextual_ligature (_tmp25_, i);
					} else {
						if (column == 1) {
							BirdFontLigatures* _tmp26_;
							_tmp26_ = ligatures;
							bird_font_ligatures_set_beginning (_tmp26_, i);
						} else {
							if (column == 2) {
								BirdFontLigatures* _tmp27_;
								_tmp27_ = ligatures;
								bird_font_ligatures_set_middle (_tmp27_, i);
							} else {
								if (column == 3) {
									BirdFontLigatures* _tmp28_;
									_tmp28_ = ligatures;
									bird_font_ligatures_set_end (_tmp28_, i);
								}
							}
						}
					}
				}
			} else {
				if (bird_font_row_get_index (row) >= ncontextual) {
					BirdFontLigatures* _tmp29_;
					i = bird_font_row_get_index (row) - ncontextual;
					_tmp29_ = ligatures;
					if (bird_font_ligatures_count (_tmp29_) != 0) {
						if (delete_button) {
							BirdFontLigatures* _tmp30_;
							gint _tmp31_;
							BirdFontLigatures* _tmp32_;
							_tmp30_ = ligatures;
							_tmp31_ = i;
							g_return_if_fail ((0 <= _tmp31_) && (_tmp31_ < bird_font_ligatures_count (_tmp30_)));
							_tmp32_ = ligatures;
							bird_font_ligatures_remove_at (_tmp32_, i);
							bird_font_tab_content_hide_text_input ();
						} else {
							if (column == 0) {
								BirdFontLigatures* _tmp33_;
								gint _tmp34_;
								BirdFontLigatures* _tmp35_;
								_tmp33_ = ligatures;
								_tmp34_ = i;
								g_return_if_fail ((0 <= _tmp34_) && (_tmp34_ < bird_font_ligatures_count (_tmp33_)));
								_tmp35_ = ligatures;
								bird_font_ligatures_set_ligature (_tmp35_, i);
							} else {
								if (column == 2) {
									BirdFontLigatures* _tmp36_;
									gint _tmp37_;
									BirdFontLigatures* _tmp38_;
									_tmp36_ = ligatures;
									_tmp37_ = i;
									g_return_if_fail ((0 <= _tmp37_) && (_tmp37_ < bird_font_ligatures_count (_tmp36_)));
									_tmp38_ = ligatures;
									bird_font_ligatures_set_substitution (_tmp38_, i);
								}
							}
						}
					}
				}
			}
		}
	}
	bird_font_table_update_rows ((BirdFontTable*) self);
	bird_font_font_display_update_scrollbar ((BirdFontFontDisplay*) self);
	_tmp39_ = font;
	bird_font_font_touch (_tmp39_);
	_g_object_unref0 (ligatures);
	_g_object_unref0 (font);
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		BirdFontLigatureList* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->row);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda396_ (Block28Data* _data28_,
              BirdFontContextualLigature* liga)
{
	BirdFontLigatureList* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	BirdFontRow* _tmp4_;
	GeeArrayList* _tmp5_;
	BirdFontRow* _tmp6_;
	gint _tmp7_;
	self = _data28_->self;
	g_return_if_fail (liga != NULL);
	_tmp0_ = liga->ligatures;
	_tmp1_ = liga->backtrack;
	_tmp2_ = liga->input;
	_tmp3_ = liga->lookahead;
	_tmp4_ = bird_font_row_new_columns_4 (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _data28_->i, TRUE);
	_g_object_unref0 (_data28_->row);
	_data28_->row = _tmp4_;
	_tmp5_ = self->priv->rows;
	_tmp6_ = _data28_->row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
	_tmp7_ = _data28_->i;
	_data28_->i = _tmp7_ + 1;
}

static void
___lambda396__bird_font_ligatures_contextual_ligature_iterator (BirdFontContextualLigature* lig,
                                                                gpointer self)
{
	__lambda396_ (self, lig);
}

static void
__lambda397_ (Block28Data* _data28_,
              const gchar* subst,
              const gchar* liga)
{
	BirdFontLigatureList* self;
	BirdFontRow* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontRow* _tmp2_;
	gint _tmp3_;
	self = _data28_->self;
	g_return_if_fail (subst != NULL);
	g_return_if_fail (liga != NULL);
	_tmp0_ = bird_font_row_new_columns_3 (liga, "", subst, _data28_->i, TRUE);
	_g_object_unref0 (_data28_->row);
	_data28_->row = _tmp0_;
	_tmp1_ = self->priv->rows;
	_tmp2_ = _data28_->row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	_tmp3_ = _data28_->i;
	_data28_->i = _tmp3_ + 1;
}

static void
___lambda397__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                     const gchar* ligature,
                                                     gpointer self)
{
	__lambda397_ (self, substitution, ligature);
}

static void
bird_font_ligature_list_real_update_rows (BirdFontTable* base)
{
	BirdFontLigatureList * self;
	Block28Data* _data28_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontFont* _tmp1_;
	BirdFontLigatures* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontRow* _tmp6_;
	GeeArrayList* _tmp7_;
	BirdFontRow* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BirdFontRow* _tmp13_;
	GeeArrayList* _tmp14_;
	BirdFontRow* _tmp15_;
	BirdFontLigatures* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	BirdFontLigatures* _tmp25_;
	BirdFontLigatures* _tmp26_;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	BirdFontLigatures* _tmp35_;
	self = (BirdFontLigatureList*) base;
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_font_get_ligatures (_tmp1_);
	ligatures = _tmp2_;
	_tmp3_ = self->priv->rows;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp3_);
	_tmp4_ = bird_font_t_ ("Add");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_row_new_headline (_tmp5_);
	_g_object_unref0 (_data28_->row);
	_data28_->row = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp7_ = self->priv->rows;
	_tmp8_ = _data28_->row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
	_tmp9_ = bird_font_t_ ("New Ligature");
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_t_ ("New Contextual Substitution");
	_tmp12_ = _tmp11_;
	_tmp13_ = bird_font_row_new_columns_2 (_tmp10_, _tmp12_, BIRD_FONT_LIGATURE_LIST_NEW_LIGATURE, FALSE);
	_g_object_unref0 (_data28_->row);
	_data28_->row = _tmp13_;
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp14_ = self->priv->rows;
	_tmp15_ = _data28_->row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	_data28_->i = 0;
	_tmp16_ = ligatures;
	_tmp17_ = _tmp16_->contextual_ligatures;
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		gchar* _tmp20_;
		gchar* _tmp21_;
		BirdFontRow* _tmp22_;
		GeeArrayList* _tmp23_;
		BirdFontRow* _tmp24_;
		_tmp20_ = bird_font_t_ ("Contextual Substitutions");
		_tmp21_ = _tmp20_;
		_tmp22_ = bird_font_row_new_headline (_tmp21_);
		_g_object_unref0 (_data28_->row);
		_data28_->row = _tmp22_;
		_g_free0 (_tmp21_);
		_tmp23_ = self->priv->rows;
		_tmp24_ = _data28_->row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
	}
	_tmp25_ = ligatures;
	bird_font_ligatures_get_contextual_ligatures (_tmp25_, ___lambda396__bird_font_ligatures_contextual_ligature_iterator, _data28_);
	_tmp26_ = ligatures;
	_tmp27_ = _tmp26_->ligatures;
	_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ > 0) {
		gchar* _tmp30_;
		gchar* _tmp31_;
		BirdFontRow* _tmp32_;
		GeeArrayList* _tmp33_;
		BirdFontRow* _tmp34_;
		_tmp30_ = bird_font_t_ ("Ligatures");
		_tmp31_ = _tmp30_;
		_tmp32_ = bird_font_row_new_headline (_tmp31_);
		_g_object_unref0 (_data28_->row);
		_data28_->row = _tmp32_;
		_g_free0 (_tmp31_);
		_tmp33_ = self->priv->rows;
		_tmp34_ = _data28_->row;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
	}
	_tmp35_ = ligatures;
	bird_font_ligatures_get_ligatures (_tmp35_, ___lambda397__bird_font_ligatures_ligature_iterator, _data28_);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (ligatures);
	_g_object_unref0 (font);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}

static gchar*
bird_font_ligature_list_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontLigatureList * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontLigatureList*) base;
	_tmp0_ = bird_font_t_ ("Ligatures");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_ligature_list_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontLigatureList * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontLigatureList*) base;
	_tmp0_ = g_strdup ("Ligatures");
	result = _tmp0_;
	return result;
}

static void
bird_font_ligature_list_class_init (BirdFontLigatureListClass * klass,
                                    gpointer klass_data)
{
	bird_font_ligature_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLigatureList_private_offset);
	((BirdFontTableClass *) klass)->get_rows = (GeeArrayList* (*) (BirdFontTable*)) bird_font_ligature_list_real_get_rows;
	((BirdFontTableClass *) klass)->selected_row = (void (*) (BirdFontTable*, BirdFontRow*, gint, gboolean)) bird_font_ligature_list_real_selected_row;
	((BirdFontTableClass *) klass)->update_rows = (void (*) (BirdFontTable*)) bird_font_ligature_list_real_update_rows;
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_ligature_list_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_ligature_list_real_get_name;
	G_OBJECT_CLASS (klass)->finalize = bird_font_ligature_list_finalize;
}

static void
bird_font_ligature_list_instance_init (BirdFontLigatureList * self,
                                       gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_ligature_list_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->rows = _tmp0_;
}

static void
bird_font_ligature_list_finalize (GObject * obj)
{
	BirdFontLigatureList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LIGATURE_LIST, BirdFontLigatureList);
	_g_object_unref0 (self->priv->rows);
	G_OBJECT_CLASS (bird_font_ligature_list_parent_class)->finalize (obj);
}

static GType
bird_font_ligature_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLigatureListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_ligature_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLigatureList), 0, (GInstanceInitFunc) bird_font_ligature_list_instance_init, NULL };
	GType bird_font_ligature_list_type_id;
	bird_font_ligature_list_type_id = g_type_register_static (BIRD_FONT_TYPE_TABLE, "BirdFontLigatureList", &g_define_type_info, 0);
	BirdFontLigatureList_private_offset = g_type_add_instance_private (bird_font_ligature_list_type_id, sizeof (BirdFontLigatureListPrivate));
	return bird_font_ligature_list_type_id;
}

GType
bird_font_ligature_list_get_type (void)
{
	static volatile gsize bird_font_ligature_list_type_id__once = 0;
	if (g_once_init_enter (&bird_font_ligature_list_type_id__once)) {
		GType bird_font_ligature_list_type_id;
		bird_font_ligature_list_type_id = bird_font_ligature_list_get_type_once ();
		g_once_init_leave (&bird_font_ligature_list_type_id__once, bird_font_ligature_list_type_id);
	}
	return bird_font_ligature_list_type_id__once;
}

