/* LigatureCollection.c generated by valac 0.56.16, the Vala compiler
 * generated from LigatureCollection.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_LIGATURE_COLLECTION_0_PROPERTY,
	BIRD_FONT_LIGATURE_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* bird_font_ligature_collection_properties[BIRD_FONT_LIGATURE_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block82Data Block82Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BirdFontLigatureCollectionPrivate {
	BirdFontLigatureSet* lig_set;
	BirdFontLigatureSet* last_set;
};

struct _Block82Data {
	int _ref_count_;
	BirdFontLigatureCollection* self;
	BirdFontGlyfTable* glyf_table;
};

static gint BirdFontLigatureCollection_private_offset;
static gpointer bird_font_ligature_collection_parent_class = NULL;

static void bird_font_ligature_collection_add_clig_ligatures (BirdFontLigatureCollection* self,
                                                       BirdFontGlyfTable* glyf_table);
static void bird_font_ligature_collection_add_contextual_ligatures (BirdFontLigatureCollection* self,
                                                             BirdFontGlyfTable* glyf_table,
                                                             BirdFontContextualLigature* cl);
static Block82Data* block82_data_ref (Block82Data* _data82_);
static void block82_data_unref (void * _userdata_);
static void __lambda65_ (Block82Data* _data82_,
                  const gchar* parts,
                  const gchar* ligature);
static void ___lambda65__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                         const gchar* ligature,
                                                         gpointer self);
static gint __lambda66_ (BirdFontLigatureCollection* self,
                  BirdFontLigatureSet* a,
                  BirdFontLigatureSet* b);
static gint ___lambda66__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void bird_font_ligature_collection_finalize (GObject * obj);
static GType bird_font_ligature_collection_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_ligature_collection_get_instance_private (BirdFontLigatureCollection* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontLigatureCollection_private_offset);
}

BirdFontLigatureCollection*
bird_font_ligature_collection_construct_clig (GType object_type,
                                              BirdFontGlyfTable* glyf_table)
{
	BirdFontLigatureCollection * self = NULL;
	GeeArrayList* _tmp0_;
	BirdFontLigatureSet* _tmp1_;
	BirdFontLigatureSet* _tmp2_;
	g_return_val_if_fail (glyf_table != NULL, NULL);
	self = (BirdFontLigatureCollection*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LIGATURE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->ligature_sets);
	self->ligature_sets = _tmp0_;
	_tmp1_ = bird_font_ligature_set_new (glyf_table);
	_g_object_unref0 (self->priv->lig_set);
	self->priv->lig_set = _tmp1_;
	_tmp2_ = bird_font_ligature_set_new (glyf_table);
	_g_object_unref0 (self->priv->last_set);
	self->priv->last_set = _tmp2_;
	bird_font_ligature_collection_add_clig_ligatures (self, glyf_table);
	return self;
}

BirdFontLigatureCollection*
bird_font_ligature_collection_new_clig (BirdFontGlyfTable* glyf_table)
{
	return bird_font_ligature_collection_construct_clig (BIRD_FONT_TYPE_LIGATURE_COLLECTION, glyf_table);
}

BirdFontLigatureCollection*
bird_font_ligature_collection_construct_contextual (GType object_type,
                                                    BirdFontGlyfTable* glyf_table,
                                                    BirdFontContextualLigature* ligature)
{
	BirdFontLigatureCollection * self = NULL;
	GeeArrayList* _tmp0_;
	BirdFontLigatureSet* _tmp1_;
	BirdFontLigatureSet* _tmp2_;
	g_return_val_if_fail (glyf_table != NULL, NULL);
	g_return_val_if_fail (ligature != NULL, NULL);
	self = (BirdFontLigatureCollection*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_LIGATURE_SET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->ligature_sets);
	self->ligature_sets = _tmp0_;
	_tmp1_ = bird_font_ligature_set_new (glyf_table);
	_g_object_unref0 (self->priv->lig_set);
	self->priv->lig_set = _tmp1_;
	_tmp2_ = bird_font_ligature_set_new (glyf_table);
	_g_object_unref0 (self->priv->last_set);
	self->priv->last_set = _tmp2_;
	bird_font_ligature_collection_add_contextual_ligatures (self, glyf_table, ligature);
	return self;
}

BirdFontLigatureCollection*
bird_font_ligature_collection_new_contextual (BirdFontGlyfTable* glyf_table,
                                              BirdFontContextualLigature* ligature)
{
	return bird_font_ligature_collection_construct_contextual (BIRD_FONT_TYPE_LIGATURE_COLLECTION, glyf_table, ligature);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block82Data*
block82_data_ref (Block82Data* _data82_)
{
	g_atomic_int_inc (&_data82_->_ref_count_);
	return _data82_;
}

static void
block82_data_unref (void * _userdata_)
{
	Block82Data* _data82_;
	_data82_ = (Block82Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data82_->_ref_count_)) {
		BirdFontLigatureCollection* self;
		self = _data82_->self;
		_g_object_unref0 (_data82_->glyf_table);
		_g_object_unref0 (self);
		g_slice_free (Block82Data, _data82_);
	}
}

static void
__lambda65_ (Block82Data* _data82_,
             const gchar* parts,
             const gchar* ligature)
{
	BirdFontLigatureCollection* self;
	self = _data82_->self;
	g_return_if_fail (parts != NULL);
	g_return_if_fail (ligature != NULL);
	bird_font_ligature_collection_add_ligatures (self, _data82_->glyf_table, parts, ligature);
}

static void
___lambda65__bird_font_ligatures_ligature_iterator (const gchar* substitution,
                                                    const gchar* ligature,
                                                    gpointer self)
{
	__lambda65_ (self, substitution, ligature);
}

static void
bird_font_ligature_collection_add_clig_ligatures (BirdFontLigatureCollection* self,
                                                  BirdFontGlyfTable* glyf_table)
{
	Block82Data* _data82_;
	BirdFontGlyfTable* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontLigatures* ligatures = NULL;
	BirdFontLigatures* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	_data82_ = g_slice_new0 (Block82Data);
	_data82_->_ref_count_ = 1;
	_data82_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (glyf_table);
	_g_object_unref0 (_data82_->glyf_table);
	_data82_->glyf_table = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = bird_font_font_get_ligatures (font);
	ligatures = _tmp2_;
	bird_font_ligatures_get_ligatures (ligatures, ___lambda65__bird_font_ligatures_ligature_iterator, _data82_);
	_g_object_unref0 (ligatures);
	_g_object_unref0 (font);
	block82_data_unref (_data82_);
	_data82_ = NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
bird_font_ligature_collection_add_contextual_ligatures (BirdFontLigatureCollection* self,
                                                        BirdFontGlyfTable* glyf_table,
                                                        BirdFontContextualLigature* cl)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl->ligatures;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_free0 (_tmp2_);
	{
		gchar** l_collection = NULL;
		gint l_collection_length1 = 0;
		gint _l_collection_size_ = 0;
		gint l_it = 0;
		l_collection = _tmp5_;
		l_collection_length1 = _tmp5__length1;
		for (l_it = 0; l_it < l_collection_length1; l_it = l_it + 1) {
			gchar* _tmp6_;
			gchar* l = NULL;
			_tmp6_ = g_strdup (l_collection[l_it]);
			l = _tmp6_;
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = cl->input;
				_tmp8_ = l;
				bird_font_ligature_collection_add_ligatures (self, glyf_table, _tmp7_, _tmp8_);
				_g_free0 (l);
			}
		}
		l_collection = (_vala_array_free (l_collection, l_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gint
__lambda66_ (BirdFontLigatureCollection* self,
             BirdFontLigatureSet* a,
             BirdFontLigatureSet* b)
{
	BirdFontLigatureSet* la = NULL;
	BirdFontLigatureSet* _tmp0_;
	BirdFontLigatureSet* lb = NULL;
	BirdFontLigatureSet* _tmp1_;
	gchar* ca = NULL;
	gchar* cb = NULL;
	BirdFontLigatureSet* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	BirdFontLigatureSet* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	GCompareFunc _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_LIGATURE_SET, BirdFontLigatureSet));
	la = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_LIGATURE_SET, BirdFontLigatureSet));
	lb = _tmp1_;
	_tmp2_ = la;
	_tmp3_ = bird_font_ligature_set_get_coverage_char (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "space") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (" ");
		_g_free0 (ca);
		ca = _tmp6_;
	} else {
		BirdFontLigatureSet* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = la;
		_tmp8_ = bird_font_ligature_set_get_coverage_char (_tmp7_);
		_g_free0 (ca);
		ca = _tmp8_;
	}
	_tmp9_ = lb;
	_tmp10_ = bird_font_ligature_set_get_coverage_char (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "space") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup (" ");
		_g_free0 (cb);
		cb = _tmp13_;
	} else {
		BirdFontLigatureSet* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = lb;
		_tmp15_ = bird_font_ligature_set_get_coverage_char (_tmp14_);
		_g_free0 (cb);
		cb = _tmp15_;
	}
	_tmp16_ = ((GCompareFunc) g_strcmp0);
	_tmp17_ = ca;
	_tmp18_ = cb;
	result = _tmp16_ (_tmp17_, _tmp18_);
	_g_free0 (cb);
	_g_free0 (ca);
	_g_object_unref0 (lb);
	_g_object_unref0 (la);
	return result;
}

static gint
___lambda66__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda66_ ((BirdFontLigatureCollection*) self, (BirdFontLigatureSet*) a, (BirdFontLigatureSet*) b);
	return result;
}

void
bird_font_ligature_collection_add_ligatures (BirdFontLigatureCollection* self,
                                             BirdFontGlyfTable* glyf_table,
                                             const gchar* characters,
                                             const gchar* ligatures)
{
	BirdFontLigatureSet* _tmp0_;
	BirdFontLigatureSet* _tmp1_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp2_;
	gchar** parts = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint parts_length1;
	gint _parts_size_;
	gchar* l = NULL;
	gchar* _tmp8_;
	gboolean has_set = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp14_;
	BirdFontFont* _tmp16_;
	const gchar* _tmp17_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar** _tmp37_;
	gint _tmp37__length1;
	GeeArrayList* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (glyf_table != NULL);
	g_return_if_fail (characters != NULL);
	g_return_if_fail (ligatures != NULL);
	_tmp0_ = self->priv->lig_set;
	_tmp1_ = self->priv->last_set;
	_vala_return_if_fail ((!bird_font_is_null (_tmp0_)) && (!bird_font_is_null (_tmp1_)), "!is_null (lig_set) && !is_null (last_set)");
	_tmp2_ = bird_font_bird_font_get_current_font ();
	font = _tmp2_;
	_tmp3_ = string_strip (characters);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_free0 (_tmp4_);
	parts = _tmp7_;
	parts_length1 = _tmp7__length1;
	_parts_size_ = parts_length1;
	_tmp8_ = g_strdup (ligatures);
	l = _tmp8_;
	has_set = FALSE;
	_tmp10_ = l;
	if (g_str_has_prefix (_tmp10_, "U+")) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = l;
		_tmp9_ = g_str_has_prefix (_tmp11_, "u+");
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = l;
		_tmp13_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp12_));
		_g_free0 (l);
		l = (gchar*) _tmp13_;
	}
	_tmp14_ = l;
	if (g_strcmp0 (_tmp14_, "space") == 0) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (" ");
		_g_free0 (l);
		l = _tmp15_;
	}
	_tmp16_ = font;
	_tmp17_ = l;
	if (!bird_font_font_has_glyph (_tmp16_, _tmp17_)) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp18_ = l;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Ligature ", _tmp19_, " does not correspond to a glyph in this font.", NULL);
		_tmp21_ = _tmp20_;
		g_warning ("LigatureCollection.vala:73: %s", _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (l);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (font);
		return;
	}
	_tmp22_ = parts;
	_tmp22__length1 = parts_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp22_;
		p_collection_length1 = _tmp22__length1;
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			gchar* _tmp23_;
			gchar* p = NULL;
			_tmp23_ = g_strdup (p_collection[p_it]);
			p = _tmp23_;
			{
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				const gchar* _tmp29_;
				BirdFontFont* _tmp31_;
				const gchar* _tmp32_;
				_tmp25_ = p;
				if (g_str_has_prefix (_tmp25_, "U+")) {
					_tmp24_ = TRUE;
				} else {
					const gchar* _tmp26_;
					_tmp26_ = p;
					_tmp24_ = g_str_has_prefix (_tmp26_, "u+");
				}
				if (_tmp24_) {
					const gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp27_ = p;
					_tmp28_ = g_unichar_to_string (bird_font_font_to_unichar (_tmp27_));
					_g_free0 (p);
					p = (gchar*) _tmp28_;
				}
				_tmp29_ = p;
				if (g_strcmp0 (_tmp29_, "space") == 0) {
					gchar* _tmp30_;
					_tmp30_ = g_strdup (" ");
					_g_free0 (p);
					p = _tmp30_;
				}
				_tmp31_ = font;
				_tmp32_ = p;
				if (!bird_font_font_has_glyph (_tmp31_, _tmp32_)) {
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp33_ = p;
					_tmp34_ = string_to_string (_tmp33_);
					_tmp35_ = g_strconcat ("Ligature substitution of ", _tmp34_, " is not possible, the character does have a glyph.", NULL);
					_tmp36_ = _tmp35_;
					g_warning ("LigatureCollection.vala:87: %s", _tmp36_);
					_g_free0 (_tmp36_);
					_g_free0 (p);
					_g_free0 (l);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (font);
					return;
				}
				_g_free0 (p);
			}
		}
	}
	_tmp37_ = parts;
	_tmp37__length1 = parts_length1;
	if (_tmp37__length1 == 0) {
		g_warning ("LigatureCollection.vala:93: No parts.");
		_g_free0 (l);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (font);
		return;
	}
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp38_;
		gint _s_size = 0;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _s_index = 0;
		_tmp38_ = self->ligature_sets;
		_s_list = _tmp38_;
		_tmp39_ = _s_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_s_size = _tmp41_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			BirdFontLigatureSet* s = NULL;
			GeeArrayList* _tmp44_;
			gpointer _tmp45_;
			BirdFontLigatureSet* _tmp46_;
			gchar** _tmp47_;
			gint _tmp47__length1;
			const gchar* _tmp48_;
			_s_index = _s_index + 1;
			_tmp42_ = _s_index;
			_tmp43_ = _s_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _s_list;
			_tmp45_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _s_index);
			s = (BirdFontLigatureSet*) _tmp45_;
			_tmp46_ = s;
			_tmp47_ = parts;
			_tmp47__length1 = parts_length1;
			_tmp48_ = _tmp47_[0];
			if (bird_font_ligature_set_starts_with (_tmp46_, _tmp48_)) {
				BirdFontLigatureSet* _tmp49_;
				BirdFontLigatureSet* _tmp50_;
				has_set = TRUE;
				_tmp49_ = s;
				_tmp50_ = _g_object_ref0 (_tmp49_);
				_g_object_unref0 (self->priv->last_set);
				self->priv->last_set = _tmp50_;
			}
			_g_object_unref0 (s);
		}
	}
	if (has_set) {
		BirdFontLigatureSet* _tmp51_;
		const gchar* _tmp52_;
		BirdFontLigature* _tmp53_;
		BirdFontLigature* _tmp54_;
		_tmp51_ = self->priv->last_set;
		_tmp52_ = l;
		_tmp53_ = bird_font_ligature_new (_tmp52_, characters);
		_tmp54_ = _tmp53_;
		bird_font_ligature_set_add (_tmp51_, _tmp54_);
		_g_object_unref0 (_tmp54_);
	} else {
		BirdFontLigatureSet* _tmp55_;
		BirdFontLigatureSet* _tmp56_;
		const gchar* _tmp57_;
		BirdFontLigature* _tmp58_;
		BirdFontLigature* _tmp59_;
		GeeArrayList* _tmp60_;
		BirdFontLigatureSet* _tmp61_;
		_tmp55_ = bird_font_ligature_set_new (glyf_table);
		_g_object_unref0 (self->priv->lig_set);
		self->priv->lig_set = _tmp55_;
		_tmp56_ = self->priv->lig_set;
		_tmp57_ = l;
		_tmp58_ = bird_font_ligature_new (_tmp57_, characters);
		_tmp59_ = _tmp58_;
		bird_font_ligature_set_add (_tmp56_, _tmp59_);
		_g_object_unref0 (_tmp59_);
		_tmp60_ = self->ligature_sets;
		_tmp61_ = self->priv->lig_set;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp61_);
	}
	_tmp62_ = self->ligature_sets;
	gee_list_sort ((GeeList*) _tmp62_, ___lambda66__gcompare_data_func, g_object_ref (self), g_object_unref);
	_g_free0 (l);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (font);
}

BirdFontFontData*
bird_font_ligature_collection_get_font_data (BirdFontLigatureCollection* self,
                                             BirdFontGlyfTable* glyf_table,
                                             GError** error)
{
	BirdFontFontData* set_data = NULL;
	guint16 ligature_pos = 0U;
	guint16 table_start = 0U;
	gint coverage_offset = 0;
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontFontData* _tmp1_;
	BirdFontFontData* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	guint16 size = 0U;
	BirdFontFontData* _tmp26_;
	BirdFontFontData* _tmp27_;
	GeeArrayList* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	GError* _inner_error0_ = NULL;
	BirdFontFontData* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (glyf_table != NULL, NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	_g_object_unref0 (fd);
	fd = _tmp0_;
	_tmp1_ = fd;
	table_start = (guint16) bird_font_font_data_length_with_padding (_tmp1_);
	_tmp2_ = fd;
	bird_font_font_data_add_ushort (_tmp2_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		_g_object_unref0 (set_data);
		return NULL;
	}
	_tmp3_ = self->ligature_sets;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	coverage_offset = 6 + (2 * _tmp5_);
	_tmp6_ = fd;
	bird_font_font_data_add_ushort (_tmp6_, (guint16) coverage_offset, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		_g_object_unref0 (set_data);
		return NULL;
	}
	_tmp7_ = fd;
	_tmp8_ = self->ligature_sets;
	_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	bird_font_font_data_add_ushort (_tmp7_, (guint16) _tmp10_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		_g_object_unref0 (set_data);
		return NULL;
	}
	size = (guint16) 0;
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp11_;
		gint _l_size = 0;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _l_index = 0;
		_tmp11_ = self->ligature_sets;
		_l_list = _tmp11_;
		_tmp12_ = _l_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_l_size = _tmp14_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			BirdFontLigatureSet* l = NULL;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			BirdFontFontData* _tmp22_;
			BirdFontFontData* _tmp23_ = NULL;
			BirdFontLigatureSet* _tmp24_;
			BirdFontFontData* _tmp25_;
			_l_index = _l_index + 1;
			_tmp15_ = _l_index;
			_tmp16_ = _l_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _l_list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _l_index);
			l = (BirdFontLigatureSet*) _tmp18_;
			_tmp19_ = self->ligature_sets;
			_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			ligature_pos = (guint16) ((10 + (((guint16) _tmp21_) * 4)) + size);
			_tmp22_ = fd;
			bird_font_font_data_add_ushort (_tmp22_, ligature_pos, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (fd);
				_g_object_unref0 (set_data);
				return NULL;
			}
			_tmp24_ = l;
			_tmp25_ = bird_font_ligature_set_get_set_data (_tmp24_, &_inner_error0_);
			_tmp23_ = _tmp25_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (fd);
				_g_object_unref0 (set_data);
				return NULL;
			}
			size += (guint16) bird_font_font_data_length_with_padding (_tmp23_);
			_g_object_unref0 (_tmp23_);
			_g_object_unref0 (l);
		}
	}
	_tmp26_ = fd;
	bird_font_font_data_add_ushort (_tmp26_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		_g_object_unref0 (set_data);
		return NULL;
	}
	_tmp27_ = fd;
	_tmp28_ = self->ligature_sets;
	_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
	_tmp30_ = _tmp29_;
	bird_font_font_data_add_ushort (_tmp27_, (guint16) _tmp30_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (fd);
		_g_object_unref0 (set_data);
		return NULL;
	}
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp31_;
		gint _l_size = 0;
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _l_index = 0;
		_tmp31_ = self->ligature_sets;
		_l_list = _tmp31_;
		_tmp32_ = _l_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_l_size = _tmp34_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			BirdFontLigatureSet* l = NULL;
			GeeArrayList* _tmp37_;
			gpointer _tmp38_;
			BirdFontFontData* _tmp39_;
			BirdFontLigatureSet* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			_l_index = _l_index + 1;
			_tmp35_ = _l_index;
			_tmp36_ = _l_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _l_list;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _l_index);
			l = (BirdFontLigatureSet*) _tmp38_;
			_tmp39_ = fd;
			_tmp40_ = l;
			_tmp41_ = bird_font_ligature_set_get_coverage_char (_tmp40_);
			_tmp42_ = _tmp41_;
			bird_font_font_data_add_ushort (_tmp39_, (guint16) bird_font_glyf_table_get_gid (glyf_table, _tmp42_), &_inner_error0_);
			_g_free0 (_tmp42_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (fd);
				_g_object_unref0 (set_data);
				return NULL;
			}
			_g_object_unref0 (l);
		}
	}
	{
		GeeArrayList* _l_list = NULL;
		GeeArrayList* _tmp43_;
		gint _l_size = 0;
		GeeArrayList* _tmp44_;
		gint _tmp45_;
		gint _tmp46_;
		gint _l_index = 0;
		_tmp43_ = self->ligature_sets;
		_l_list = _tmp43_;
		_tmp44_ = _l_list;
		_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
		_tmp46_ = _tmp45_;
		_l_size = _tmp46_;
		_l_index = -1;
		while (TRUE) {
			gint _tmp47_;
			gint _tmp48_;
			BirdFontLigatureSet* l = NULL;
			GeeArrayList* _tmp49_;
			gpointer _tmp50_;
			BirdFontFontData* _tmp51_ = NULL;
			BirdFontLigatureSet* _tmp52_;
			BirdFontFontData* _tmp53_;
			BirdFontFontData* _tmp54_;
			BirdFontFontData* _tmp55_;
			BirdFontFontData* _tmp56_;
			_l_index = _l_index + 1;
			_tmp47_ = _l_index;
			_tmp48_ = _l_size;
			if (!(_tmp47_ < _tmp48_)) {
				break;
			}
			_tmp49_ = _l_list;
			_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _l_index);
			l = (BirdFontLigatureSet*) _tmp50_;
			_tmp52_ = l;
			_tmp53_ = bird_font_ligature_set_get_set_data (_tmp52_, &_inner_error0_);
			_tmp51_ = _tmp53_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (l);
				_g_object_unref0 (fd);
				_g_object_unref0 (set_data);
				return NULL;
			}
			_tmp54_ = _tmp51_;
			_tmp51_ = NULL;
			_g_object_unref0 (set_data);
			set_data = _tmp54_;
			_tmp55_ = fd;
			_tmp56_ = set_data;
			bird_font_font_data_append (_tmp55_, _tmp56_);
			_g_object_unref0 (_tmp51_);
			_g_object_unref0 (l);
		}
	}
	result = fd;
	_g_object_unref0 (set_data);
	return result;
}

BirdFontLigatureCollection*
bird_font_ligature_collection_construct (GType object_type)
{
	BirdFontLigatureCollection * self = NULL;
	self = (BirdFontLigatureCollection*) g_object_new (object_type, NULL);
	return self;
}

BirdFontLigatureCollection*
bird_font_ligature_collection_new (void)
{
	return bird_font_ligature_collection_construct (BIRD_FONT_TYPE_LIGATURE_COLLECTION);
}

static void
bird_font_ligature_collection_class_init (BirdFontLigatureCollectionClass * klass,
                                          gpointer klass_data)
{
	bird_font_ligature_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontLigatureCollection_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_ligature_collection_finalize;
}

static void
bird_font_ligature_collection_instance_init (BirdFontLigatureCollection * self,
                                             gpointer klass)
{
	self->priv = bird_font_ligature_collection_get_instance_private (self);
}

static void
bird_font_ligature_collection_finalize (GObject * obj)
{
	BirdFontLigatureCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_LIGATURE_COLLECTION, BirdFontLigatureCollection);
	_g_object_unref0 (self->ligature_sets);
	_g_object_unref0 (self->priv->lig_set);
	_g_object_unref0 (self->priv->last_set);
	G_OBJECT_CLASS (bird_font_ligature_collection_parent_class)->finalize (obj);
}

static GType
bird_font_ligature_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontLigatureCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_ligature_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontLigatureCollection), 0, (GInstanceInitFunc) bird_font_ligature_collection_instance_init, NULL };
	GType bird_font_ligature_collection_type_id;
	bird_font_ligature_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontLigatureCollection", &g_define_type_info, 0);
	BirdFontLigatureCollection_private_offset = g_type_add_instance_private (bird_font_ligature_collection_type_id, sizeof (BirdFontLigatureCollectionPrivate));
	return bird_font_ligature_collection_type_id;
}

GType
bird_font_ligature_collection_get_type (void)
{
	static volatile gsize bird_font_ligature_collection_type_id__once = 0;
	if (g_once_init_enter (&bird_font_ligature_collection_type_id__once)) {
		GType bird_font_ligature_collection_type_id;
		bird_font_ligature_collection_type_id = bird_font_ligature_collection_get_type_once ();
		g_once_init_leave (&bird_font_ligature_collection_type_id__once, bird_font_ligature_collection_type_id);
	}
	return bird_font_ligature_collection_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

