/* KerningDisplay.c generated by valac 0.56.16, the Vala compiler
 * generated from KerningDisplay.vala, do not modify */

/*
Copyright (C) 2012 2014 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERNING_DISPLAY_0_PROPERTY,
	BIRD_FONT_KERNING_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_display_properties[BIRD_FONT_KERNING_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bird_font_glyph_range_unref0(var) ((var == NULL) ? NULL : (var = (bird_font_glyph_range_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block22Data Block22Data;
enum  {
	BIRD_FONT_KERNING_DISPLAY_UNDO_ITEM_0_PROPERTY,
	BIRD_FONT_KERNING_DISPLAY_UNDO_ITEM_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_display_undo_item_properties[BIRD_FONT_KERNING_DISPLAY_UNDO_ITEM_NUM_PROPERTIES];

struct _BirdFontKerningDisplayPrivate {
	GeeArrayList* first_row;
	GeeArrayList* rows;
	gint active_handle;
	gint selected_handle;
	gboolean moving;
	BirdFontGlyph* left_active_glyph;
	BirdFontGlyph* right_active_glyph;
	gdouble begin_handle_x;
	gdouble begin_handle_y;
	gdouble last_handle_x;
	GeeArrayList* undo_items;
	GeeArrayList* redo_items;
	gboolean first_update;
	BirdFontText* kerning_label;
	BirdFontWidgetAllocation* allocation;
};

struct _Block22Data {
	int _ref_count_;
	BirdFontKerningDisplay* self;
	gchar* submitted_value;
};

static gint BirdFontKerningDisplay_private_offset;
static gpointer bird_font_kerning_display_parent_class = NULL;
gboolean bird_font_kerning_display_right_to_left = FALSE;
static gpointer bird_font_kerning_display_undo_item_parent_class = NULL;

static GeeArrayList* bird_font_kerning_display_get_all_rows (BirdFontKerningDisplay* self);
static gchar* bird_font_kerning_display_real_get_label (BirdFontFontDisplay* base);
static gchar* bird_font_kerning_display_real_get_name (BirdFontFontDisplay* base);
static void bird_font_kerning_display_real_draw (BirdFontFontDisplay* base,
                                          BirdFontWidgetAllocation* allocation,
                                          cairo_t* cr);
static void bird_font_kerning_display_display_kerning_value (BirdFontKerningDisplay* self,
                                                      gdouble k);
static gchar* bird_font_kerning_display_round (gdouble d);
static void bird_font_kerning_display_set_active_handle_index (BirdFontKerningDisplay* self,
                                                        gint h);
static gdouble bird_font_kerning_display_get_kerning_for_handle (BirdFontKerningDisplay* self,
                                                          gint handle);
static gboolean bird_font_kerning_display_get_kerning_pair (BirdFontKerningDisplay* self,
                                                     gint handle,
                                                     gchar** left,
                                                     gchar** right,
                                                     BirdFontGlyphRange** range_left,
                                                     BirdFontGlyphRange** range_right);
static void bird_font_kerning_display_set_space (BirdFontKerningDisplay* self,
                                          gint handle,
                                          gdouble val);
static void bird_font_kerning_display_real_selected_canvas (BirdFontFontDisplay* base);
static void bird_font_kerning_display_set_selected_handle (BirdFontKerningDisplay* self,
                                                    gint handle);
static void bird_font_kerning_display_real_key_press (BirdFontFontDisplay* base,
                                               guint keyval);
static void bird_font_kerning_display_remove_last_character (BirdFontKerningDisplay* self);
static void bird_font_kerning_display_add_character (BirdFontKerningDisplay* self,
                                              gunichar c);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static void __lambda240_ (Block22Data* _data22_,
                   const gchar* text);
static void ___lambda240__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                              const gchar* text,
                                                              gpointer self);
static void __lambda241_ (Block22Data* _data22_);
static void ___lambda241__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                          const gchar* text,
                                                          gpointer self);
VALA_EXTERN gboolean bird_font_is_modifier_key (guint i);
static void bird_font_kerning_display_real_motion_notify (BirdFontFontDisplay* base,
                                                   gdouble ex,
                                                   gdouble ey);
static void bird_font_kerning_display_real_button_release (BirdFontFontDisplay* base,
                                                    gint button,
                                                    gdouble ex,
                                                    gdouble ey);
static void __lambda97_ (BirdFontKerningDisplay* self,
                  const gchar* text);
static void ___lambda97__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                             const gchar* text,
                                                             gpointer self);
static void __lambda98_ (BirdFontKerningDisplay* self);
static void ___lambda98__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self);
static void bird_font_kerning_display_real_button_press (BirdFontFontDisplay* base,
                                                  guint button,
                                                  gdouble ex,
                                                  gdouble ey);
static void bird_font_kerning_display_real_undo (BirdFontFontDisplay* base);
static void bird_font_kerning_display_real_redo (BirdFontFontDisplay* base);
static gdouble* _double_dup (gdouble* self);
static void bird_font_kerning_display_real_zoom_in (BirdFontFontDisplay* base);
static void bird_font_kerning_display_real_zoom_out (BirdFontFontDisplay* base);
static gboolean bird_font_kerning_display_real_needs_modifier (BirdFontFontDisplay* base);
static void bird_font_kerning_display_undo_item_finalize (GObject * obj);
static GType bird_font_kerning_display_undo_item_get_type_once (void);
static void bird_font_kerning_display_finalize (GObject * obj);
static GType bird_font_kerning_display_get_type_once (void);

static inline gpointer
bird_font_kerning_display_get_instance_private (BirdFontKerningDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKerningDisplay_private_offset);
}

BirdFontKerningDisplay*
bird_font_kerning_display_construct (GType object_type)
{
	BirdFontKerningDisplay * self = NULL;
	BirdFontGlyphSequence* w = NULL;
	BirdFontGlyphSequence* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	BirdFontOtfTags* _tmp5_;
	BirdFontOtfTags* _tmp6_;
	GeeArrayList* _tmp7_;
	self = (BirdFontKerningDisplay*) bird_font_font_display_construct (object_type);
	_tmp0_ = bird_font_glyph_sequence_new ();
	w = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_SEQUENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->rows);
	self->priv->rows = _tmp1_;
	_tmp2_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_SEQUENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->first_row);
	self->priv->first_row = _tmp2_;
	_tmp3_ = gee_array_list_new (BIRD_FONT_KERNING_DISPLAY_TYPE_UNDO_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->undo_items);
	self->priv->undo_items = _tmp3_;
	_tmp4_ = gee_array_list_new (BIRD_FONT_KERNING_DISPLAY_TYPE_UNDO_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->redo_items);
	self->priv->redo_items = _tmp4_;
	_tmp5_ = bird_font_kerning_tools_get_otf_tags ();
	_tmp6_ = _tmp5_;
	bird_font_glyph_sequence_set_otf_tags (w, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->first_row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, w);
	_g_object_unref0 (w);
	return self;
}

BirdFontKerningDisplay*
bird_font_kerning_display_new (void)
{
	return bird_font_kerning_display_construct (BIRD_FONT_TYPE_KERNING_DISPLAY);
}

BirdFontGlyphSequence*
bird_font_kerning_display_get_first_row (BirdFontKerningDisplay* self)
{
	BirdFontGlyphSequence* first = NULL;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bird_font_glyph_sequence_new ();
	first = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp2_;
		gint _s_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _s_index = 0;
		_tmp2_ = self->priv->first_row;
		_s_list = _tmp2_;
		_tmp3_ = _s_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_s_size = _tmp5_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontGlyphSequence* s = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontGlyphSequence* _tmp10_;
			BirdFontGlyphSequence* _tmp11_;
			BirdFontFont* _tmp12_;
			BirdFontGlyphSequence* _tmp13_;
			BirdFontGlyphSequence* _tmp14_;
			_s_index = _s_index + 1;
			_tmp6_ = _s_index;
			_tmp7_ = _s_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _s_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _s_index);
			s = (BirdFontGlyphSequence*) _tmp9_;
			_tmp10_ = first;
			_tmp11_ = s;
			_tmp12_ = font;
			_tmp13_ = bird_font_glyph_sequence_process_ligatures (_tmp11_, _tmp12_);
			_tmp14_ = _tmp13_;
			bird_font_glyph_sequence_append (_tmp10_, _tmp14_);
			_g_object_unref0 (_tmp14_);
			_g_object_unref0 (s);
		}
	}
	result = first;
	_g_object_unref0 (font);
	return result;
}

void
bird_font_kerning_display_new_segment (BirdFontKerningDisplay* self)
{
	BirdFontGlyphSequence* s = NULL;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontOtfTags* _tmp1_;
	BirdFontOtfTags* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_glyph_sequence_new ();
	s = _tmp0_;
	_tmp1_ = bird_font_kerning_tools_get_otf_tags ();
	_tmp2_ = _tmp1_;
	bird_font_glyph_sequence_set_otf_tags (s, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->first_row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, s);
	_g_object_unref0 (s);
}

BirdFontGlyphSequence*
bird_font_kerning_display_get_last_segment (BirdFontKerningDisplay* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontGlyphSequence* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->first_row;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		bird_font_kerning_display_new_segment (self);
	}
	_tmp3_ = self->priv->first_row;
	_tmp4_ = self->priv->first_row;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	result = (BirdFontGlyphSequence*) _tmp7_;
	return result;
}

static GeeArrayList*
bird_font_kerning_display_get_all_rows (BirdFontKerningDisplay* self)
{
	GeeArrayList* r = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontGlyphSequence* _tmp2_;
	BirdFontGlyphSequence* _tmp3_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_SEQUENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (r);
	r = _tmp0_;
	_tmp1_ = r;
	_tmp2_ = bird_font_kerning_display_get_first_row (self);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		GeeArrayList* _s_list = NULL;
		GeeArrayList* _tmp4_;
		gint _s_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _s_index = 0;
		_tmp4_ = self->priv->rows;
		_s_list = _tmp4_;
		_tmp5_ = _s_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_s_size = _tmp7_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontGlyphSequence* s = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			GeeArrayList* _tmp12_;
			BirdFontGlyphSequence* _tmp13_;
			_s_index = _s_index + 1;
			_tmp8_ = _s_index;
			_tmp9_ = _s_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _s_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _s_index);
			s = (BirdFontGlyphSequence*) _tmp11_;
			_tmp12_ = r;
			_tmp13_ = s;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
			_g_object_unref0 (s);
		}
	}
	result = r;
	return result;
}

static gchar*
bird_font_kerning_display_real_get_label (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontKerningDisplay*) base;
	_tmp0_ = bird_font_t_ ("Kerning");
	result = _tmp0_;
	return result;
}

static gchar*
bird_font_kerning_display_real_get_name (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	gchar* _tmp0_;
	gchar* result;
	self = (BirdFontKerningDisplay*) base;
	_tmp0_ = g_strdup ("Kerning");
	result = _tmp0_;
	return result;
}

void
bird_font_kerning_display_show_parse_error (BirdFontKerningDisplay* self)
{
	gchar* line1 = NULL;
	gchar* _tmp0_;
	gchar* line2 = NULL;
	gchar* _tmp1_;
	gchar* line3 = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	BirdFontMessageDialog* _tmp11_;
	BirdFontMessageDialog* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_t_ ("The current kerning class is malformed.");
	line1 = _tmp0_;
	_tmp1_ = bird_font_t_ ("Add single characters separated by space and ranges on the form A-Z.");
	line2 = _tmp1_;
	_tmp2_ = bird_font_t_ ("Type “space” to kern the space character and “divis” to kern -.");
	line3 = _tmp2_;
	_tmp3_ = g_strconcat (line1, " ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, line2, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, " ", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, line3, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = bird_font_message_dialog_new (_tmp10_);
	_tmp12_ = _tmp11_;
	bird_font_main_window_show_dialog ((BirdFontDialog*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (line3);
	_g_free0 (line2);
	_g_free0 (line1);
}

static void
bird_font_kerning_display_real_draw (BirdFontFontDisplay* base,
                                     BirdFontWidgetAllocation* allocation,
                                     cairo_t* cr)
{
	BirdFontKerningDisplay * self;
	self = (BirdFontKerningDisplay*) base;
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	bird_font_kerning_display_draw_kerning_pairs (self, allocation, cr);
}

gdouble
bird_font_kerning_display_get_row_height (BirdFontKerningDisplay* self)
{
	BirdFontFont* current_font = NULL;
	BirdFontFont* _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	current_font = _tmp0_;
	result = current_font->top_limit - current_font->bottom_limit;
	_g_object_unref0 (current_font);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_kerning_display_draw_kerning_pairs (BirdFontKerningDisplay* self,
                                              BirdFontWidgetAllocation* allocation,
                                              cairo_t* cr)
{
	BirdFontGlyph* glyph = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble kern = 0.0;
	gdouble alpha = 0.0;
	gdouble x2 = 0.0;
	gdouble caret_y = 0.0;
	gint i = 0;
	gint wi = 0;
	BirdFontGlyph* prev = NULL;
	BirdFontGlyphSequence* word_with_ligatures = NULL;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	gboolean first_row = FALSE;
	gdouble row_height = 0.0;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	gdouble item_size = 0.0;
	gdouble item_size2 = 0.0;
	BirdFontWidgetAllocation* _tmp1_;
	BirdFontGlyph* _tmp2_;
	BirdFontFont* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	g_return_if_fail (cr != NULL);
	first_row = TRUE;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	item_size = 1.0 / bird_font_kerning_tools_font_size;
	item_size2 = 2.0 / bird_font_kerning_tools_font_size;
	_tmp1_ = _g_object_ref0 (allocation);
	_g_object_unref0 (self->priv->allocation);
	self->priv->allocation = _tmp1_;
	i = 0;
	cairo_save (cr);
	bird_font_theme_color (cr, "Background 1");
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) allocation->width, (gdouble) allocation->height);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	cairo_scale (cr, bird_font_kerning_tools_font_size, bird_font_kerning_tools_font_size);
	_tmp2_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (glyph);
	glyph = _tmp2_;
	row_height = bird_font_kerning_display_get_row_height (self);
	alpha = (gdouble) 1;
	_tmp3_ = font;
	y = (bird_font_kerning_display_get_row_height (self) - _tmp3_->base_line) + 20;
	x = (gdouble) 20;
	w = (gdouble) 0;
	_g_object_unref0 (prev);
	prev = NULL;
	kern = (gdouble) 0;
	if (bird_font_kerning_display_right_to_left) {
		x = (allocation->width - 20) / bird_font_kerning_tools_font_size;
	}
	{
		GeeArrayList* _word_list = NULL;
		GeeArrayList* _tmp4_;
		gint _word_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _word_index = 0;
		_tmp4_ = bird_font_kerning_display_get_all_rows (self);
		_word_list = _tmp4_;
		_tmp5_ = _word_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_word_size = _tmp7_;
		_word_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			BirdFontGlyphSequence* word = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			BirdFontGlyphSequence* _tmp12_;
			BirdFontFont* _tmp13_;
			BirdFontGlyphSequence* _tmp14_;
			_word_index = _word_index + 1;
			_tmp8_ = _word_index;
			_tmp9_ = _word_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _word_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _word_index);
			word = (BirdFontGlyphSequence*) _tmp11_;
			wi = 0;
			_tmp12_ = word;
			_tmp13_ = font;
			_tmp14_ = bird_font_glyph_sequence_process_ligatures (_tmp12_, _tmp13_);
			_g_object_unref0 (word_with_ligatures);
			word_with_ligatures = _tmp14_;
			_bird_font_glyph_range_unref0 (gr_left);
			gr_left = NULL;
			_bird_font_glyph_range_unref0 (gr_right);
			gr_right = NULL;
			{
				GeeArrayList* _g_list = NULL;
				BirdFontGlyphSequence* _tmp15_;
				GeeArrayList* _tmp16_;
				gint _g_size = 0;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _g_index = 0;
				_tmp15_ = word_with_ligatures;
				_tmp16_ = _tmp15_->glyph;
				_g_list = _tmp16_;
				_tmp17_ = _g_list;
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_g_size = _tmp19_;
				_g_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					BirdFontGlyph* g = NULL;
					GeeArrayList* _tmp22_;
					gpointer _tmp23_;
					BirdFontGlyph* _tmp24_;
					gboolean _tmp25_ = FALSE;
					BirdFontGlyph* _tmp26_;
					BirdFontGlyph* _tmp45_;
					gboolean _tmp56_ = FALSE;
					gboolean _tmp65_ = FALSE;
					BirdFontGlyph* _tmp66_;
					BirdFontGlyph* _tmp68_;
					BirdFontGlyph* _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					_g_index = _g_index + 1;
					_tmp20_ = _g_index;
					_tmp21_ = _g_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _g_list;
					_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _g_index);
					g = (BirdFontGlyph*) _tmp23_;
					_tmp24_ = g;
					if (_tmp24_ == NULL) {
						_g_object_unref0 (g);
						continue;
					}
					_tmp26_ = prev;
					if (_tmp26_ == NULL) {
						_tmp25_ = TRUE;
					} else {
						_tmp25_ = wi == 0;
					}
					if (_tmp25_) {
						kern = (gdouble) 0;
					} else {
						BirdFontGlyphSequence* _tmp27_;
						GeeArrayList* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						BirdFontGlyphSequence* _tmp31_;
						GeeArrayList* _tmp32_;
						gpointer _tmp33_;
						BirdFontGlyphSequence* _tmp34_;
						GeeArrayList* _tmp35_;
						gpointer _tmp36_;
						BirdFontGlyph* _tmp37_;
						gchar* _tmp38_;
						gchar* _tmp39_;
						BirdFontGlyph* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						BirdFontGlyphRange* _tmp43_;
						BirdFontGlyphRange* _tmp44_;
						_tmp27_ = word_with_ligatures;
						_tmp28_ = _tmp27_->ranges;
						_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
						_tmp30_ = _tmp29_;
						g_return_if_fail (wi < _tmp30_);
						g_return_if_fail ((wi - 1) >= 0);
						_tmp31_ = word_with_ligatures;
						_tmp32_ = _tmp31_->ranges;
						_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, wi - 1);
						_bird_font_glyph_range_unref0 (gr_left);
						gr_left = (BirdFontGlyphRange*) _tmp33_;
						_tmp34_ = word_with_ligatures;
						_tmp35_ = _tmp34_->ranges;
						_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, wi);
						_bird_font_glyph_range_unref0 (gr_right);
						gr_right = (BirdFontGlyphRange*) _tmp36_;
						_tmp37_ = prev;
						_tmp38_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
						_tmp39_ = _tmp38_;
						_tmp40_ = g;
						_tmp41_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
						_tmp42_ = _tmp41_;
						_tmp43_ = gr_left;
						_tmp44_ = gr_right;
						kern = bird_font_kerning_display_get_kerning_for_pair (_tmp39_, _tmp42_, _tmp43_, _tmp44_);
						_g_free0 (_tmp42_);
						_g_free0 (_tmp39_);
					}
					_tmp45_ = g;
					if (_tmp45_ == NULL) {
						w = (gdouble) 50;
						alpha = (gdouble) 1;
					} else {
						BirdFontGlyph* _tmp46_;
						BirdFontGlyph* _tmp47_;
						BirdFontGlyph* _tmp48_;
						BirdFontGlyph* _tmp54_;
						BirdFontGlyph* _tmp55_;
						alpha = (gdouble) 0;
						_tmp46_ = g;
						_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
						_g_object_unref0 (glyph);
						glyph = _tmp47_;
						cairo_save (cr);
						_tmp48_ = glyph;
						bird_font_glyph_add_help_lines (_tmp48_);
						if (bird_font_kerning_display_right_to_left) {
							BirdFontGlyph* _tmp49_;
							BirdFontGlyph* _tmp50_;
							BirdFontGlyph* _tmp51_;
							_tmp49_ = glyph;
							_tmp50_ = glyph;
							_tmp51_ = glyph;
							cairo_translate (cr, ((((-kern) + x) - bird_font_glyph_get_lsb (_tmp49_)) - bird_font_glyph_get_width (_tmp50_)) - bird_font_glyph_xc (), (bird_font_glyph_get_baseline (_tmp51_) + y) - bird_font_glyph_yc ());
						} else {
							BirdFontGlyph* _tmp52_;
							BirdFontGlyph* _tmp53_;
							_tmp52_ = glyph;
							_tmp53_ = glyph;
							cairo_translate (cr, ((kern + x) - bird_font_glyph_get_lsb (_tmp52_)) - bird_font_glyph_xc (), (bird_font_glyph_get_baseline (_tmp53_) + y) - bird_font_glyph_yc ());
						}
						_tmp54_ = glyph;
						bird_font_glyph_draw_paths (_tmp54_, cr, NULL);
						cairo_restore (cr);
						_tmp55_ = glyph;
						w = bird_font_glyph_get_width (_tmp55_);
					}
					if (first_row) {
						gboolean _tmp57_ = FALSE;
						if (self->priv->active_handle == i) {
							_tmp57_ = TRUE;
						} else {
							_tmp57_ = self->priv->selected_handle == i;
						}
						_tmp56_ = _tmp57_;
					} else {
						_tmp56_ = FALSE;
					}
					if (_tmp56_) {
						gboolean _tmp61_ = FALSE;
						if (bird_font_kerning_display_right_to_left) {
							x2 = x - (kern / 2.0);
						} else {
							x2 = x + (kern / 2.0);
						}
						cairo_save (cr);
						if (self->priv->selected_handle == i) {
							bird_font_theme_color (cr, "Foreground 1");
						} else {
							cairo_set_source_rgba (cr, 123 / 255.0, 123 / 255.0, 123 / 255.0, (gdouble) 1);
						}
						if (!self->adjust_side_bearings) {
							gboolean _tmp58_ = FALSE;
							BirdFontGlyphRange* _tmp59_;
							cairo_move_to (cr, x2 - (5 * item_size), y + (20 * item_size));
							cairo_line_to (cr, x2, (y + (20 * item_size)) - (5 * item_size));
							cairo_line_to (cr, x2 + (5 * item_size), y + (20 * item_size));
							cairo_fill (cr);
							_tmp59_ = gr_left;
							if (_tmp59_ != NULL) {
								_tmp58_ = TRUE;
							} else {
								BirdFontGlyphRange* _tmp60_;
								_tmp60_ = gr_right;
								_tmp58_ = _tmp60_ != NULL;
							}
							if (_tmp58_) {
								cairo_move_to (cr, x2 - (5 * item_size), y + (20 * item_size));
								cairo_line_to (cr, x2 + (5 * item_size), y + (20 * item_size));
								cairo_line_to (cr, x2 + (5 * item_size), y + (24 * item_size));
								cairo_line_to (cr, x2 - (5 * item_size), y + (24 * item_size));
								cairo_fill (cr);
							}
						} else {
							if (self->right_side_bearing) {
								cairo_move_to (cr, x2 - (5 * item_size2), y + (20 * item_size2));
								cairo_line_to (cr, x2, (y + (20 * item_size2)) - (5 * item_size2));
								cairo_line_to (cr, x2, y + (20 * item_size2));
								cairo_fill (cr);
							} else {
								cairo_move_to (cr, x2, y + (20 * item_size2));
								cairo_line_to (cr, x2, (y + (20 * item_size2)) - (5 * item_size2));
								cairo_line_to (cr, x2 + (5 * item_size2), y + (20 * item_size2));
								cairo_fill (cr);
							}
						}
						if (self->priv->active_handle == i) {
							_tmp61_ = !self->adjust_side_bearings;
						} else {
							_tmp61_ = FALSE;
						}
						if (_tmp61_) {
							BirdFontText* _tmp62_;
							BirdFontText* _tmp63_;
							BirdFontText* _tmp64_;
							cairo_save (cr);
							cairo_scale (cr, 1 / bird_font_kerning_tools_font_size, 1 / bird_font_kerning_tools_font_size);
							_tmp62_ = self->priv->kerning_label;
							((BirdFontWidget*) _tmp62_)->widget_x = x2 * bird_font_kerning_tools_font_size;
							_tmp63_ = self->priv->kerning_label;
							((BirdFontWidget*) _tmp63_)->widget_y = (y * bird_font_kerning_tools_font_size) + 40;
							_tmp64_ = self->priv->kerning_label;
							bird_font_widget_draw ((BirdFontWidget*) _tmp64_, cr);
							cairo_fill (cr);
							cairo_restore (cr);
						}
						cairo_restore (cr);
					}
					if (bird_font_kerning_display_right_to_left) {
						x -= w + kern;
					} else {
						x += w + kern;
					}
					_tmp66_ = g;
					if (_tmp66_ == NULL) {
						_tmp65_ = TRUE;
					} else {
						BirdFontGlyph* _tmp67_;
						_tmp67_ = g;
						_tmp65_ = bird_font_glyph_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
					}
					if (_tmp65_) {
						cairo_save (cr);
						cairo_set_source_rgba (cr, 153 / 255.0, 153 / 255.0, 153 / 255.0, alpha);
						cairo_move_to (cr, (x - (w / 2.0)) - 5, y + 20);
						cairo_set_font_size (cr, 10 * item_size);
						cairo_show_text (cr, "?");
						cairo_restore (cr);
					}
					_tmp68_ = g;
					_tmp69_ = _g_object_ref0 (_tmp68_);
					_g_object_unref0 (prev);
					prev = _tmp69_;
					_tmp70_ = wi;
					wi = _tmp70_ + 1;
					_tmp71_ = i;
					i = _tmp71_ + 1;
					_g_object_unref0 (g);
				}
			}
			if (first_row) {
				BirdFontFont* _tmp72_;
				x2 = x;
				_tmp72_ = font;
				caret_y = (bird_font_kerning_display_get_row_height (self) - _tmp72_->base_line) + 20;
				cairo_save (cr);
				cairo_set_line_width (cr, 1.0 / bird_font_kerning_tools_font_size);
				bird_font_theme_color_opacity (cr, "Foreground 1", 0.5);
				cairo_move_to (cr, x2, caret_y + 20);
				cairo_line_to (cr, x2, (gdouble) 20);
				cairo_stroke (cr);
				cairo_restore (cr);
				y += 50 / bird_font_kerning_tools_font_size;
			}
			y += row_height + 20;
			if (bird_font_kerning_display_right_to_left) {
				x = (allocation->width - 20) / bird_font_kerning_tools_font_size;
			} else {
				x = (gdouble) 20;
			}
			first_row = FALSE;
			if (y > ((gdouble) allocation->height)) {
				_g_object_unref0 (word);
				break;
			}
			_g_object_unref0 (word);
		}
		_g_object_unref0 (_word_list);
	}
	{
		gint j = 0;
		GeeArrayList* _tmp73_;
		gint _tmp74_;
		gint _tmp75_;
		_tmp73_ = self->priv->rows;
		_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
		_tmp75_ = _tmp74_;
		j = _tmp75_ - 1;
		{
			gboolean _tmp76_ = FALSE;
			_tmp76_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp78_;
				gpointer _tmp79_;
				BirdFontGlyphSequence* _tmp80_;
				if (!_tmp76_) {
					gint _tmp77_;
					_tmp77_ = j;
					j = _tmp77_ - 1;
				}
				_tmp76_ = FALSE;
				if (!(j > 30)) {
					break;
				}
				_tmp78_ = self->priv->rows;
				_tmp79_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp78_, j);
				_tmp80_ = (BirdFontGlyphSequence*) _tmp79_;
				_g_object_unref0 (_tmp80_);
			}
		}
	}
	cairo_fill (cr);
	cairo_restore (cr);
	_g_object_unref0 (font);
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_object_unref0 (word_with_ligatures);
	_g_object_unref0 (prev);
	_g_object_unref0 (glyph);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
bird_font_kerning_display_display_kerning_value (BirdFontKerningDisplay* self,
                                                 gdouble k)
{
	gchar* kerning = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	BirdFontText* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_kerning_display_round (k);
	kerning = _tmp0_;
	_tmp1_ = string_to_string (kerning);
	_tmp2_ = bird_font_text_new (_tmp1_, (gdouble) 17, (gdouble) 0);
	_g_object_unref0 (self->priv->kerning_label);
	self->priv->kerning_label = _tmp2_;
	_g_free0 (kerning);
}

static void
bird_font_kerning_display_set_active_handle_index (BirdFontKerningDisplay* self,
                                                   gint h)
{
	gdouble kern = 0.0;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	kern = bird_font_kerning_display_get_kerning_for_handle (self, h);
	self->priv->active_handle = h;
	_tmp0_ = bird_font_kerning_display_get_first_row (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->glyph;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->active_handle;
	_tmp6_ = (1 <= _tmp5_) && (_tmp5_ < _tmp4_);
	_g_object_unref0 (_tmp1_);
	if (_tmp6_) {
		bird_font_kerning_display_display_kerning_value (self, kern);
	}
}

static gdouble
bird_font_kerning_display_get_kerning_for_handle (BirdFontKerningDisplay* self,
                                                  gint handle)
{
	gchar* a = NULL;
	gchar* b = NULL;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	gboolean got_pair = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	BirdFontGlyphRange* _tmp2_ = NULL;
	BirdFontGlyphRange* _tmp3_ = NULL;
	gboolean _tmp4_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp4_ = bird_font_kerning_display_get_kerning_pair (self, handle, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_g_free0 (a);
	a = _tmp0_;
	_g_free0 (b);
	b = _tmp1_;
	_bird_font_glyph_range_unref0 (gr_left);
	gr_left = _tmp2_;
	_bird_font_glyph_range_unref0 (gr_right);
	gr_right = _tmp3_;
	got_pair = _tmp4_;
	if (got_pair) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		BirdFontGlyphRange* _tmp7_;
		BirdFontGlyphRange* _tmp8_;
		_tmp5_ = a;
		_tmp6_ = b;
		_tmp7_ = gr_left;
		_tmp8_ = gr_right;
		result = bird_font_kerning_display_get_kerning_for_pair (_tmp5_, _tmp6_, _tmp7_, _tmp8_);
		_bird_font_glyph_range_unref0 (gr_right);
		_bird_font_glyph_range_unref0 (gr_left);
		_g_free0 (b);
		_g_free0 (a);
		return result;
	}
	result = (gdouble) 0;
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_free0 (b);
	_g_free0 (a);
	return result;
}

static gpointer
_bird_font_glyph_range_ref0 (gpointer self)
{
	return self ? bird_font_glyph_range_ref (self) : NULL;
}

static gboolean
bird_font_kerning_display_get_kerning_pair (BirdFontKerningDisplay* self,
                                            gint handle,
                                            gchar** left,
                                            gchar** right,
                                            BirdFontGlyphRange** range_left,
                                            BirdFontGlyphRange** range_right)
{
	gchar* _vala_left = NULL;
	gchar* _vala_right = NULL;
	BirdFontGlyphRange* _vala_range_left = NULL;
	BirdFontGlyphRange* _vala_range_right = NULL;
	gchar* a = NULL;
	gchar* b = NULL;
	BirdFontFont* font = NULL;
	gint wi = 0;
	BirdFontGlyphSequence* word_with_ligatures = NULL;
	gint ranges_index = 0;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	gint row_index = 0;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontGlyphSequence* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	wi = 0;
	ranges_index = 0;
	row_index = 0;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = font;
	bird_font_font_touch (_tmp1_);
	_tmp2_ = g_strdup ("");
	_g_free0 (a);
	a = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (b);
	b = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (_vala_left);
	_vala_left = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (_vala_right);
	_vala_right = _tmp5_;
	_bird_font_glyph_range_unref0 (_vala_range_left);
	_vala_range_left = NULL;
	_bird_font_glyph_range_unref0 (_vala_range_right);
	_vala_range_right = NULL;
	if (handle <= 0) {
		result = FALSE;
		_bird_font_glyph_range_unref0 (gr_right);
		_bird_font_glyph_range_unref0 (gr_left);
		_g_object_unref0 (word_with_ligatures);
		_g_object_unref0 (font);
		_g_free0 (b);
		_g_free0 (a);
		if (left) {
			*left = _vala_left;
		} else {
			_g_free0 (_vala_left);
		}
		if (right) {
			*right = _vala_right;
		} else {
			_g_free0 (_vala_right);
		}
		if (range_left) {
			*range_left = _vala_range_left;
		} else {
			_bird_font_glyph_range_unref0 (_vala_range_left);
		}
		if (range_right) {
			*range_right = _vala_range_right;
		} else {
			_bird_font_glyph_range_unref0 (_vala_range_right);
		}
		return result;
	}
	_tmp6_ = bird_font_kerning_display_get_first_row (self);
	_g_object_unref0 (word_with_ligatures);
	word_with_ligatures = _tmp6_;
	ranges_index = 0;
	{
		GeeArrayList* _g_list = NULL;
		BirdFontGlyphSequence* _tmp7_;
		GeeArrayList* _tmp8_;
		gint _g_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _g_index = 0;
		_tmp7_ = word_with_ligatures;
		_tmp8_ = _tmp7_->glyph;
		_g_list = _tmp8_;
		_tmp9_ = _g_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_size = _tmp11_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			BirdFontGlyph* _tmp16_;
			BirdFontGlyph* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			gint _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			_g_index = _g_index + 1;
			_tmp12_ = _g_index;
			_tmp13_ = _g_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _g_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _g_index);
			g = (BirdFontGlyph*) _tmp15_;
			_tmp16_ = g;
			if (_tmp16_ == NULL) {
				_g_object_unref0 (g);
				continue;
			}
			_tmp17_ = g;
			_tmp18_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			_g_free0 (b);
			b = _tmp18_;
			if (handle == wi) {
				_tmp19_ = row_index == 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				BirdFontGlyphSequence* _tmp20_;
				GeeArrayList* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				BirdFontGlyphSequence* _tmp24_;
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				BirdFontGlyphSequence* _tmp28_;
				GeeArrayList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				BirdFontGlyphSequence* _tmp32_;
				GeeArrayList* _tmp33_;
				gpointer _tmp34_;
				BirdFontGlyphSequence* _tmp35_;
				GeeArrayList* _tmp36_;
				gpointer _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				BirdFontGlyphRange* _tmp42_;
				BirdFontGlyphRange* _tmp43_;
				BirdFontGlyphRange* _tmp44_;
				BirdFontGlyphRange* _tmp45_;
				_tmp20_ = word_with_ligatures;
				_tmp21_ = _tmp20_->ranges;
				_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
				_tmp23_ = _tmp22_;
				if (wi >= _tmp23_) {
					result = FALSE;
					_g_object_unref0 (g);
					_bird_font_glyph_range_unref0 (gr_right);
					_bird_font_glyph_range_unref0 (gr_left);
					_g_object_unref0 (word_with_ligatures);
					_g_object_unref0 (font);
					_g_free0 (b);
					_g_free0 (a);
					if (left) {
						*left = _vala_left;
					} else {
						_g_free0 (_vala_left);
					}
					if (right) {
						*right = _vala_right;
					} else {
						_g_free0 (_vala_right);
					}
					if (range_left) {
						*range_left = _vala_range_left;
					} else {
						_bird_font_glyph_range_unref0 (_vala_range_left);
					}
					if (range_right) {
						*range_right = _vala_range_right;
					} else {
						_bird_font_glyph_range_unref0 (_vala_range_right);
					}
					return result;
				}
				g_return_val_if_fail ((wi - 1) >= 0, FALSE);
				_tmp24_ = word_with_ligatures;
				_tmp25_ = _tmp24_->ranges;
				_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = word_with_ligatures;
				_tmp29_ = _tmp28_->glyph;
				_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp27_ != _tmp31_) {
					result = FALSE;
					_g_object_unref0 (g);
					_bird_font_glyph_range_unref0 (gr_right);
					_bird_font_glyph_range_unref0 (gr_left);
					_g_object_unref0 (word_with_ligatures);
					_g_object_unref0 (font);
					_g_free0 (b);
					_g_free0 (a);
					if (left) {
						*left = _vala_left;
					} else {
						_g_free0 (_vala_left);
					}
					if (right) {
						*right = _vala_right;
					} else {
						_g_free0 (_vala_right);
					}
					if (range_left) {
						*range_left = _vala_range_left;
					} else {
						_bird_font_glyph_range_unref0 (_vala_range_left);
					}
					if (range_right) {
						*range_right = _vala_range_right;
					} else {
						_bird_font_glyph_range_unref0 (_vala_range_right);
					}
					return result;
				}
				_tmp32_ = word_with_ligatures;
				_tmp33_ = _tmp32_->ranges;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, wi - 1);
				_bird_font_glyph_range_unref0 (gr_left);
				gr_left = (BirdFontGlyphRange*) _tmp34_;
				_tmp35_ = word_with_ligatures;
				_tmp36_ = _tmp35_->ranges;
				_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, wi);
				_bird_font_glyph_range_unref0 (gr_right);
				gr_right = (BirdFontGlyphRange*) _tmp37_;
				_tmp38_ = a;
				_tmp39_ = g_strdup (_tmp38_);
				_g_free0 (_vala_left);
				_vala_left = _tmp39_;
				_tmp40_ = b;
				_tmp41_ = g_strdup (_tmp40_);
				_g_free0 (_vala_right);
				_vala_right = _tmp41_;
				_tmp42_ = gr_left;
				_tmp43_ = _bird_font_glyph_range_ref0 (_tmp42_);
				_bird_font_glyph_range_unref0 (_vala_range_left);
				_vala_range_left = _tmp43_;
				_tmp44_ = gr_right;
				_tmp45_ = _bird_font_glyph_range_ref0 (_tmp44_);
				_bird_font_glyph_range_unref0 (_vala_range_right);
				_vala_range_right = _tmp45_;
				result = TRUE;
				_g_object_unref0 (g);
				_bird_font_glyph_range_unref0 (gr_right);
				_bird_font_glyph_range_unref0 (gr_left);
				_g_object_unref0 (word_with_ligatures);
				_g_object_unref0 (font);
				_g_free0 (b);
				_g_free0 (a);
				if (left) {
					*left = _vala_left;
				} else {
					_g_free0 (_vala_left);
				}
				if (right) {
					*right = _vala_right;
				} else {
					_g_free0 (_vala_right);
				}
				if (range_left) {
					*range_left = _vala_range_left;
				} else {
					_bird_font_glyph_range_unref0 (_vala_range_left);
				}
				if (range_right) {
					*range_right = _vala_range_right;
				} else {
					_bird_font_glyph_range_unref0 (_vala_range_right);
				}
				return result;
			}
			_tmp46_ = wi;
			wi = _tmp46_ + 1;
			_tmp47_ = b;
			_tmp48_ = g_strdup (_tmp47_);
			_g_free0 (a);
			a = _tmp48_;
			_g_object_unref0 (g);
		}
	}
	result = FALSE;
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_object_unref0 (word_with_ligatures);
	_g_object_unref0 (font);
	_g_free0 (b);
	_g_free0 (a);
	if (left) {
		*left = _vala_left;
	} else {
		_g_free0 (_vala_left);
	}
	if (right) {
		*right = _vala_right;
	} else {
		_g_free0 (_vala_right);
	}
	if (range_left) {
		*range_left = _vala_range_left;
	} else {
		_bird_font_glyph_range_unref0 (_vala_range_left);
	}
	if (range_right) {
		*range_right = _vala_range_right;
	} else {
		_bird_font_glyph_range_unref0 (_vala_range_right);
	}
	return result;
}

void
bird_font_kerning_display_set_absolute_kerning (BirdFontKerningDisplay* self,
                                                gint handle,
                                                gdouble val)
{
	gdouble kern = 0.0;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	if (!self->adjust_side_bearings) {
		kern = bird_font_kerning_display_get_kerning_for_handle (self, handle);
		bird_font_kerning_display_set_space (self, handle, val - kern);
	}
}

/** Adjust kerning or right side bearing. */
static void
bird_font_kerning_display_set_space (BirdFontKerningDisplay* self,
                                     gint handle,
                                     gdouble val)
{
	gchar* a = NULL;
	gchar* b = NULL;
	BirdFontFont* font = NULL;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = font;
	bird_font_font_touch (_tmp1_);
	if (!self->adjust_side_bearings) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		BirdFontGlyphRange* _tmp4_ = NULL;
		BirdFontGlyphRange* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		bird_font_kerning_display_get_kerning_pair (self, handle, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		_g_free0 (a);
		a = _tmp2_;
		_g_free0 (b);
		b = _tmp3_;
		_bird_font_glyph_range_unref0 (gr_left);
		gr_left = _tmp4_;
		_bird_font_glyph_range_unref0 (gr_right);
		gr_right = _tmp5_;
		_tmp6_ = a;
		_tmp7_ = b;
		bird_font_kerning_display_set_kerning_pair (self, _tmp6_, _tmp7_, &gr_left, &gr_right, val);
	} else {
		if (self->right_side_bearing) {
			BirdFontGlyph* _tmp8_;
			BirdFontGlyph* _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			BirdFontGlyph* _tmp12_;
			BirdFontGlyph* _tmp13_;
			BirdFontGlyph* _tmp14_;
			_tmp8_ = self->priv->left_active_glyph;
			_tmp9_ = self->priv->left_active_glyph;
			_tmp10_ = bird_font_glyph_get_right_limit (_tmp9_);
			_tmp11_ = _tmp10_;
			bird_font_glyph_set_right_limit (_tmp9_, _tmp11_ + val);
			_tmp12_ = self->priv->left_active_glyph;
			bird_font_glyph_remove_lines (_tmp12_);
			_tmp13_ = self->priv->left_active_glyph;
			bird_font_glyph_add_help_lines (_tmp13_);
			_tmp14_ = self->priv->left_active_glyph;
			bird_font_glyph_update_other_spacing_classes (_tmp14_);
		} else {
			BirdFontGlyph* _tmp15_;
			BirdFontGlyph* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			BirdFontGlyph* _tmp19_;
			BirdFontGlyph* _tmp20_;
			BirdFontGlyph* _tmp21_;
			_tmp15_ = self->priv->right_active_glyph;
			_tmp16_ = self->priv->right_active_glyph;
			_tmp17_ = bird_font_glyph_get_left_limit (_tmp16_);
			_tmp18_ = _tmp17_;
			bird_font_glyph_set_left_limit (_tmp16_, _tmp18_ - val);
			_tmp19_ = self->priv->right_active_glyph;
			bird_font_glyph_remove_lines (_tmp19_);
			_tmp20_ = self->priv->right_active_glyph;
			bird_font_glyph_add_help_lines (_tmp20_);
			_tmp21_ = self->priv->right_active_glyph;
			bird_font_glyph_update_other_spacing_classes (_tmp21_);
		}
	}
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_object_unref0 (font);
	_g_free0 (b);
	_g_free0 (a);
}

/** Class based gpos kerning. */
void
bird_font_kerning_display_set_kerning_pair (BirdFontKerningDisplay* self,
                                            const gchar* a,
                                            const gchar* b,
                                            BirdFontGlyphRange** gr_left,
                                            BirdFontGlyphRange** gr_right,
                                            gdouble val)
{
	gdouble kern = 0.0;
	BirdFontGlyphRange* grl = NULL;
	BirdFontGlyphRange* grr = NULL;
	BirdFontKerningClasses* classes = NULL;
	gchar* n = NULL;
	gchar* f = NULL;
	gboolean has_kerning = FALSE;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_g_object_unref0 (font);
	font = _tmp0_;
	_tmp1_ = font;
	bird_font_font_touch (_tmp1_);
	_tmp2_ = font;
	_tmp3_ = bird_font_font_get_kerning_classes (_tmp2_);
	_g_object_unref0 (classes);
	classes = _tmp3_;
	kern = bird_font_kerning_display_get_kerning_for_pair (a, b, *gr_left, *gr_right);
	{
		BirdFontKerningClasses* _tmp27_;
		BirdFontGlyphRange* _tmp28_;
		BirdFontGlyphRange* _tmp29_;
		if ((*gr_left) == NULL) {
			BirdFontGlyphRange* _tmp4_;
			BirdFontGlyphRange* _tmp5_;
			BirdFontGlyphRange* _tmp6_;
			BirdFontGlyphRange* _tmp7_;
			_tmp4_ = bird_font_glyph_range_new ();
			_bird_font_glyph_range_unref0 (grl);
			grl = _tmp4_;
			_tmp5_ = grl;
			bird_font_glyph_range_parse_ranges (_tmp5_, a, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				_g_object_unref0 (font);
				_g_free0 (f);
				_g_free0 (n);
				_g_object_unref0 (classes);
				_bird_font_glyph_range_unref0 (grr);
				_bird_font_glyph_range_unref0 (grl);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp6_ = grl;
			_tmp7_ = _bird_font_glyph_range_ref0 (_tmp6_);
			_bird_font_glyph_range_unref0 (*gr_left);
			*gr_left = _tmp7_;
		} else {
			BirdFontGlyphRange* _tmp8_;
			_tmp8_ = _bird_font_glyph_range_ref0 (G_TYPE_CHECK_INSTANCE_CAST (*gr_left, BIRD_FONT_TYPE_GLYPH_RANGE, BirdFontGlyphRange));
			_bird_font_glyph_range_unref0 (grl);
			grl = _tmp8_;
		}
		if ((*gr_right) == NULL) {
			BirdFontGlyphRange* _tmp9_;
			BirdFontGlyphRange* _tmp10_;
			BirdFontGlyphRange* _tmp11_;
			BirdFontGlyphRange* _tmp12_;
			_tmp9_ = bird_font_glyph_range_new ();
			_bird_font_glyph_range_unref0 (grr);
			grr = _tmp9_;
			_tmp10_ = grr;
			bird_font_glyph_range_parse_ranges (_tmp10_, b, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					goto __catch0_g_markup_error;
				}
				_g_object_unref0 (font);
				_g_free0 (f);
				_g_free0 (n);
				_g_object_unref0 (classes);
				_bird_font_glyph_range_unref0 (grr);
				_bird_font_glyph_range_unref0 (grl);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp11_ = grr;
			_tmp12_ = _bird_font_glyph_range_ref0 (_tmp11_);
			_bird_font_glyph_range_unref0 (*gr_right);
			*gr_right = _tmp12_;
		} else {
			BirdFontGlyphRange* _tmp13_;
			_tmp13_ = _bird_font_glyph_range_ref0 (G_TYPE_CHECK_INSTANCE_CAST (*gr_right, BIRD_FONT_TYPE_GLYPH_RANGE, BirdFontGlyphRange));
			_bird_font_glyph_range_unref0 (grr);
			grr = _tmp13_;
		}
		if (self->priv->first_update) {
			BirdFontGlyphRange* _tmp14_;
			gchar* _tmp15_;
			BirdFontGlyphRange* _tmp16_;
			gchar* _tmp17_;
			BirdFontKerningClasses* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			GeeArrayList* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			BirdFontKerningDisplayUndoItem* _tmp24_;
			BirdFontKerningDisplayUndoItem* _tmp25_;
			GeeArrayList* _tmp26_;
			_tmp14_ = grl;
			_tmp15_ = bird_font_glyph_range_get_all_ranges (_tmp14_);
			_g_free0 (f);
			f = _tmp15_;
			_tmp16_ = grr;
			_tmp17_ = bird_font_glyph_range_get_all_ranges (_tmp16_);
			_g_free0 (n);
			n = _tmp17_;
			_tmp18_ = classes;
			_tmp19_ = f;
			_tmp20_ = n;
			has_kerning = bird_font_kerning_classes_has_kerning (_tmp18_, _tmp19_, _tmp20_);
			_tmp21_ = self->priv->undo_items;
			_tmp22_ = f;
			_tmp23_ = n;
			_tmp24_ = bird_font_kerning_display_undo_item_new (_tmp22_, _tmp23_, kern, has_kerning);
			_tmp25_ = _tmp24_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp25_);
			_g_object_unref0 (_tmp25_);
			_tmp26_ = self->priv->redo_items;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp26_);
			self->priv->first_update = FALSE;
		}
		_tmp27_ = classes;
		_tmp28_ = grl;
		_tmp29_ = grr;
		bird_font_kerning_classes_set_kerning (_tmp27_, _tmp28_, _tmp29_, kern + val, -1);
		bird_font_kerning_display_display_kerning_value (self, kern + val);
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("KerningDisplay.vala:510: %s", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (font);
		_g_free0 (f);
		_g_free0 (n);
		_g_object_unref0 (classes);
		_bird_font_glyph_range_unref0 (grr);
		_bird_font_glyph_range_unref0 (grl);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (font);
	_g_free0 (f);
	_g_free0 (n);
	_g_object_unref0 (classes);
	_bird_font_glyph_range_unref0 (grr);
	_bird_font_glyph_range_unref0 (grl);
}

gdouble
bird_font_kerning_display_get_kerning_for_pair (const gchar* a,
                                                const gchar* b,
                                                BirdFontGlyphRange* gr_left,
                                                BirdFontGlyphRange* gr_right)
{
	BirdFontKerningClasses* k = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	gdouble result;
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	k = _tmp3_;
	result = bird_font_kerning_classes_get_kerning_for_pair (k, a, b, gr_left, gr_right);
	_g_object_unref0 (k);
	return result;
}

static void
bird_font_kerning_display_real_selected_canvas (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	self = (BirdFontKerningDisplay*) base;
	bird_font_key_bindings_set_require_modifier (TRUE);
}

void
bird_font_kerning_display_add_kerning_class (BirdFontKerningDisplay* self,
                                             gint index)
{
	BirdFontGlyphRange* _tmp0_;
	BirdFontGlyphRange* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_kerning_tools_get_kerning_class (index);
	_tmp1_ = _tmp0_;
	bird_font_kerning_display_add_range (self, _tmp1_);
	_bird_font_glyph_range_unref0 (_tmp1_);
}

void
bird_font_kerning_display_add_range (BirdFontKerningDisplay* self,
                                     BirdFontGlyphRange* range)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyphSequence* s = NULL;
	BirdFontFont* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BirdFontGlyph* _tmp4_;
	BirdFontGlyph* _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	BirdFontGlyphSequence* _tmp17_;
	GeeArrayList* _tmp18_;
	BirdFontGlyph* _tmp19_;
	BirdFontGlyphSequence* _tmp20_;
	GeeArrayList* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	_tmp1_ = font;
	_tmp2_ = bird_font_glyph_range_get_char (range, (guint32) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = bird_font_font_get_glyph_by_name (_tmp1_, _tmp3_);
	_g_object_unref0 (glyph);
	glyph = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = glyph;
	if (_tmp5_ == NULL) {
		g_warning ("KerningDisplay.vala:535: Kerning range is not represented by a valid g" \
"lyph.");
		_g_object_unref0 (s);
		_g_object_unref0 (glyph);
		_g_object_unref0 (font);
		return;
	}
	_tmp6_ = self->priv->first_row;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		BirdFontGlyphSequence* _tmp9_;
		GeeArrayList* _tmp10_;
		BirdFontGlyphSequence* _tmp11_;
		_tmp9_ = bird_font_glyph_sequence_new ();
		_g_object_unref0 (s);
		s = _tmp9_;
		_tmp10_ = self->priv->first_row;
		_tmp11_ = s;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	} else {
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gpointer _tmp16_;
		_tmp12_ = self->priv->first_row;
		_tmp13_ = self->priv->first_row;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_ - 1);
		_g_object_unref0 (s);
		s = (BirdFontGlyphSequence*) _tmp16_;
	}
	_tmp17_ = s;
	_tmp18_ = _tmp17_->glyph;
	_tmp19_ = glyph;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
	_tmp20_ = s;
	_tmp21_ = _tmp20_->ranges;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, range);
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (s);
	_g_object_unref0 (glyph);
	_g_object_unref0 (font);
}

static void
bird_font_kerning_display_set_selected_handle (BirdFontKerningDisplay* self,
                                               gint handle)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyphSequence* sequence_with_ligatures = NULL;
	BirdFontGlyphSequence* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontGlyphSequence* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	BirdFontGlyphSequence* _tmp20_;
	GeeArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	g_return_if_fail (self != NULL);
	self->priv->selected_handle = handle;
	_tmp0_ = bird_font_kerning_display_get_first_row (self);
	_g_object_unref0 (sequence_with_ligatures);
	sequence_with_ligatures = _tmp0_;
	if (self->priv->selected_handle <= 0) {
		self->priv->selected_handle = 1;
	}
	_tmp1_ = sequence_with_ligatures;
	_tmp2_ = _tmp1_->glyph;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (self->priv->selected_handle >= _tmp4_) {
		BirdFontGlyphSequence* _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = sequence_with_ligatures;
		_tmp6_ = _tmp5_->glyph;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		self->priv->selected_handle = ((gint) _tmp8_) - 1;
	}
	bird_font_kerning_display_set_active_handle_index (self, handle);
	_tmp9_ = sequence_with_ligatures;
	_tmp10_ = _tmp9_->glyph;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->selected_handle - 1;
	if ((0 <= _tmp13_) && (_tmp13_ < _tmp12_)) {
		BirdFontGlyphSequence* _tmp14_;
		GeeArrayList* _tmp15_;
		gpointer _tmp16_;
		BirdFontGlyph* _tmp17_;
		_tmp14_ = sequence_with_ligatures;
		_tmp15_ = _tmp14_->glyph;
		_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, self->priv->selected_handle - 1);
		_g_object_unref0 (g);
		g = (BirdFontGlyph*) _tmp16_;
		_tmp17_ = g;
		if (_tmp17_ != NULL) {
			BirdFontGlyph* _tmp18_;
			BirdFontGlyph* _tmp19_;
			_tmp18_ = g;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			_g_object_unref0 (self->priv->left_active_glyph);
			self->priv->left_active_glyph = _tmp19_;
		}
	}
	_tmp20_ = sequence_with_ligatures;
	_tmp21_ = _tmp20_->glyph;
	_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected_handle;
	if ((0 <= _tmp24_) && (_tmp24_ < _tmp23_)) {
		BirdFontGlyphSequence* _tmp25_;
		GeeArrayList* _tmp26_;
		gpointer _tmp27_;
		BirdFontGlyph* _tmp28_;
		_tmp25_ = sequence_with_ligatures;
		_tmp26_ = _tmp25_->glyph;
		_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, self->priv->selected_handle);
		_g_object_unref0 (g);
		g = (BirdFontGlyph*) _tmp27_;
		_tmp28_ = g;
		if (_tmp28_ != NULL) {
			BirdFontGlyph* _tmp29_;
			BirdFontGlyph* _tmp30_;
			_tmp29_ = g;
			_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
			_g_object_unref0 (self->priv->right_active_glyph);
			self->priv->right_active_glyph = _tmp30_;
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (sequence_with_ligatures);
	_g_object_unref0 (g);
}

void
bird_font_kerning_display_previous_pair (void)
{
	BirdFontKerningDisplay* kd = NULL;
	BirdFontFontDisplay* fd = NULL;
	BirdFontSpacingTab* st = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontFontDisplay* _tmp1_;
	_tmp0_ = bird_font_main_window_get_current_display ();
	_g_object_unref0 (fd);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (BIRD_FONT_IS_SPACING_TAB (_tmp1_)) {
		BirdFontFontDisplay* _tmp2_;
		BirdFontSpacingTab* _tmp3_;
		BirdFontSpacingTab* _tmp4_;
		_tmp2_ = fd;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_SPACING_TAB, BirdFontSpacingTab));
		_g_object_unref0 (st);
		st = _tmp3_;
		_tmp4_ = st;
		if (!((BirdFontKerningDisplay*) _tmp4_)->right_side_bearing) {
			BirdFontSpacingTab* _tmp5_;
			_tmp5_ = st;
			((BirdFontKerningDisplay*) _tmp5_)->right_side_bearing = TRUE;
		} else {
			BirdFontSpacingTab* _tmp6_;
			BirdFontSpacingTab* _tmp7_;
			BirdFontSpacingTab* _tmp8_;
			_tmp6_ = st;
			((BirdFontKerningDisplay*) _tmp6_)->right_side_bearing = FALSE;
			_tmp7_ = st;
			_tmp8_ = st;
			bird_font_kerning_display_set_selected_handle ((BirdFontKerningDisplay*) _tmp7_, ((BirdFontKerningDisplay*) _tmp8_)->priv->selected_handle - 1);
		}
	} else {
		BirdFontFontDisplay* _tmp9_;
		_tmp9_ = fd;
		if (BIRD_FONT_IS_KERNING_DISPLAY (_tmp9_)) {
			BirdFontFontDisplay* _tmp10_;
			BirdFontKerningDisplay* _tmp11_;
			BirdFontKerningDisplay* _tmp12_;
			BirdFontKerningDisplay* _tmp13_;
			_tmp10_ = fd;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay));
			_g_object_unref0 (kd);
			kd = _tmp11_;
			_tmp12_ = kd;
			_tmp13_ = kd;
			bird_font_kerning_display_set_selected_handle (_tmp12_, _tmp13_->priv->selected_handle - 1);
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (st);
	_g_object_unref0 (fd);
	_g_object_unref0 (kd);
}

void
bird_font_kerning_display_next_pair (void)
{
	BirdFontKerningDisplay* kd = NULL;
	BirdFontFontDisplay* fd = NULL;
	BirdFontSpacingTab* st = NULL;
	BirdFontFontDisplay* _tmp0_;
	BirdFontFontDisplay* _tmp1_;
	_tmp0_ = bird_font_main_window_get_current_display ();
	_g_object_unref0 (fd);
	fd = _tmp0_;
	_tmp1_ = fd;
	if (BIRD_FONT_IS_SPACING_TAB (_tmp1_)) {
		BirdFontFontDisplay* _tmp2_;
		BirdFontSpacingTab* _tmp3_;
		BirdFontSpacingTab* _tmp4_;
		_tmp2_ = fd;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BIRD_FONT_TYPE_SPACING_TAB, BirdFontSpacingTab));
		_g_object_unref0 (st);
		st = _tmp3_;
		_tmp4_ = st;
		if (((BirdFontKerningDisplay*) _tmp4_)->right_side_bearing) {
			BirdFontSpacingTab* _tmp5_;
			_tmp5_ = st;
			((BirdFontKerningDisplay*) _tmp5_)->right_side_bearing = FALSE;
		} else {
			BirdFontSpacingTab* _tmp6_;
			BirdFontSpacingTab* _tmp7_;
			BirdFontSpacingTab* _tmp8_;
			_tmp6_ = st;
			((BirdFontKerningDisplay*) _tmp6_)->right_side_bearing = TRUE;
			_tmp7_ = st;
			_tmp8_ = st;
			bird_font_kerning_display_set_selected_handle ((BirdFontKerningDisplay*) _tmp7_, ((BirdFontKerningDisplay*) _tmp8_)->priv->selected_handle + 1);
		}
	} else {
		BirdFontFontDisplay* _tmp9_;
		_tmp9_ = fd;
		if (BIRD_FONT_IS_KERNING_DISPLAY (_tmp9_)) {
			BirdFontFontDisplay* _tmp10_;
			BirdFontKerningDisplay* _tmp11_;
			BirdFontKerningDisplay* _tmp12_;
			BirdFontKerningDisplay* _tmp13_;
			_tmp10_ = fd;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay));
			_g_object_unref0 (kd);
			kd = _tmp11_;
			_tmp12_ = kd;
			_tmp13_ = kd;
			bird_font_kerning_display_set_selected_handle (_tmp12_, _tmp13_->priv->selected_handle + 1);
		}
	}
	bird_font_glyph_canvas_redraw ();
	_g_object_unref0 (st);
	_g_object_unref0 (fd);
	_g_object_unref0 (kd);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
bird_font_kerning_display_round (gdouble d)
{
	gchar* b = NULL;
	gchar* _tmp0_;
	gint b_length1;
	gint _b_size_;
	const gchar* s = NULL;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* n = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 22);
	b = _tmp0_;
	b_length1 = 22;
	_b_size_ = b_length1;
	_tmp1_ = b;
	_tmp1__length1 = b_length1;
	_tmp2_ = g_ascii_formatd (_tmp1_, (gint) _tmp1__length1, "%.2f", d);
	s = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = g_strdup (_tmp3_);
	n = _tmp4_;
	_tmp5_ = n;
	_tmp6_ = string_replace (_tmp5_, ",", ".");
	_g_free0 (n);
	n = _tmp6_;
	_tmp7_ = n;
	if (g_strcmp0 (_tmp7_, "-0.00") == 0) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("0.00");
		_g_free0 (n);
		n = _tmp8_;
	}
	result = n;
	b = (g_free (b), NULL);
	return result;
}

static void
bird_font_kerning_display_real_key_press (BirdFontFontDisplay* base,
                                          guint keyval)
{
	BirdFontKerningDisplay * self;
	gunichar c = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (BirdFontKerningDisplay*) base;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	c = (gunichar) keyval;
	if (self->suppress_input) {
		return;
	}
	if (keyval == ((guint) 'u')) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = keyval == ((guint) 'U');
	}
	if (_tmp1_) {
		_tmp0_ = bird_font_key_bindings_has_ctrl ();
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		bird_font_kerning_display_insert_unichar (self);
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		if (keyval == ((guint) BIRD_FONT_KEY_LEFT)) {
			_tmp2_ = bird_font_key_bindings_modifier == BIRD_FONT_NONE;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			self->priv->first_update = TRUE;
			bird_font_kerning_display_set_space (self, self->priv->selected_handle, -1 / bird_font_kerning_tools_font_size);
		}
		if (keyval == ((guint) BIRD_FONT_KEY_RIGHT)) {
			_tmp3_ = bird_font_key_bindings_modifier == BIRD_FONT_NONE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			self->priv->first_update = TRUE;
			bird_font_kerning_display_set_space (self, self->priv->selected_handle, 1 / bird_font_kerning_tools_font_size);
		}
		if (bird_font_key_bindings_modifier == BIRD_FONT_NONE) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = bird_font_key_bindings_modifier == BIRD_FONT_SHIFT;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = bird_font_key_bindings_modifier == BIRD_FONT_ALT;
		}
		if (_tmp4_) {
			if (keyval == ((guint) BIRD_FONT_KEY_BACK_SPACE)) {
				bird_font_kerning_display_remove_last_character (self);
			}
			if (c == ((gunichar) BIRD_FONT_KEY_ENTER)) {
				bird_font_kerning_display_new_line (self);
			}
			bird_font_kerning_display_add_character (self, c);
		}
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_kerning_display_remove_last_character (BirdFontKerningDisplay* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->first_row;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		BirdFontGlyphSequence* gs = NULL;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gpointer _tmp7_;
		BirdFontGlyphSequence* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp3_ = self->priv->first_row;
		_tmp4_ = self->priv->first_row;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
		gs = (BirdFontGlyphSequence*) _tmp7_;
		_tmp8_ = gs;
		_tmp9_ = _tmp8_->glyph;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ > 0) {
			BirdFontGlyphSequence* _tmp12_;
			GeeArrayList* _tmp13_;
			BirdFontGlyphSequence* _tmp14_;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			BirdFontGlyph* _tmp19_;
			BirdFontGlyphSequence* _tmp20_;
			GeeArrayList* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			BirdFontGlyphSequence* _tmp24_;
			GeeArrayList* _tmp25_;
			BirdFontGlyphSequence* _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			BirdFontGlyphRange* _tmp31_;
			_tmp12_ = gs;
			_tmp13_ = _tmp12_->glyph;
			_tmp14_ = gs;
			_tmp15_ = _tmp14_->glyph;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp13_, _tmp17_ - 1);
			_tmp19_ = (BirdFontGlyph*) _tmp18_;
			_g_object_unref0 (_tmp19_);
			_tmp20_ = gs;
			_tmp21_ = _tmp20_->ranges;
			_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
			_tmp23_ = _tmp22_;
			g_return_if_fail (_tmp23_ > 0);
			_tmp24_ = gs;
			_tmp25_ = _tmp24_->ranges;
			_tmp26_ = gs;
			_tmp27_ = _tmp26_->ranges;
			_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp25_, _tmp29_ - 1);
			_tmp31_ = (BirdFontGlyphRange*) _tmp30_;
			_bird_font_glyph_range_unref0 (_tmp31_);
		} else {
			GeeArrayList* _tmp32_;
			GeeArrayList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_;
			BirdFontGlyphSequence* _tmp37_;
			_tmp32_ = self->priv->first_row;
			_tmp33_ = self->priv->first_row;
			_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp32_, _tmp35_ - 1);
			_tmp37_ = (BirdFontGlyphSequence*) _tmp36_;
			_g_object_unref0 (_tmp37_);
			bird_font_kerning_display_remove_last_character (self);
		}
		_g_object_unref0 (gs);
	}
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		BirdFontKerningDisplay* self;
		self = _data22_->self;
		_g_free0 (_data22_->submitted_value);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
__lambda240_ (Block22Data* _data22_,
              const gchar* text)
{
	BirdFontKerningDisplay* self;
	gchar* _tmp0_;
	self = _data22_->self;
	g_return_if_fail (text != NULL);
	_tmp0_ = g_strdup (text);
	_g_free0 (_data22_->submitted_value);
	_data22_->submitted_value = _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	bird_font_glyph_canvas_redraw ();
}

static void
___lambda240__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                         const gchar* text,
                                                         gpointer self)
{
	__lambda240_ (self, text);
}

static void
__lambda241_ (Block22Data* _data22_)
{
	BirdFontKerningDisplay* self;
	gunichar c = 0U;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	self = _data22_->self;
	bird_font_tab_content_hide_text_input ();
	self->text_input = FALSE;
	self->suppress_input = FALSE;
	_tmp1_ = _data22_->submitted_value;
	if (g_str_has_prefix (_tmp1_, "u+")) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = _data22_->submitted_value;
		_tmp0_ = g_str_has_prefix (_tmp2_, "U+");
	}
	if (_tmp0_) {
		const gchar* _tmp3_;
		_tmp3_ = _data22_->submitted_value;
		c = bird_font_font_to_unichar (_tmp3_);
		bird_font_kerning_display_add_character (self, c);
	} else {
		const gchar* _tmp4_;
		_tmp4_ = _data22_->submitted_value;
		bird_font_kerning_display_add_text (self, _tmp4_);
	}
}

static void
___lambda241__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                     const gchar* text,
                                                     gpointer self)
{
	__lambda241_ (self);
}

void
bird_font_kerning_display_insert_unichar (BirdFontKerningDisplay* self)
{
	Block22Data* _data22_;
	BirdFontTextListener* listener = NULL;
	gchar* _tmp0_;
	gchar* unicodestart = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	BirdFontTextListener* _tmp7_;
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data22_->submitted_value = _tmp0_;
	if (bird_font_key_bindings_has_shift ()) {
		_tmp1_ = "";
	} else {
		_tmp1_ = "U+";
	}
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (unicodestart);
	unicodestart = _tmp2_;
	_tmp3_ = bird_font_t_ ("Unicode");
	_tmp4_ = _tmp3_;
	_tmp5_ = bird_font_t_ ("Insert");
	_tmp6_ = _tmp5_;
	_tmp7_ = bird_font_text_listener_new (_tmp4_, unicodestart, _tmp6_);
	_g_object_unref0 (listener);
	listener = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	g_signal_connect_data (listener, "signal-text-input", (GCallback) ___lambda240__bird_font_text_listener_signal_text_input, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	g_signal_connect_data (listener, "signal-submit", (GCallback) ___lambda241__bird_font_text_listener_signal_submit, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	self->suppress_input = TRUE;
	self->text_input = TRUE;
	bird_font_tab_content_show_text_input (listener);
	_g_free0 (unicodestart);
	_g_object_unref0 (listener);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

void
bird_font_kerning_display_new_line (BirdFontKerningDisplay* self)
{
	GeeArrayList* _tmp0_;
	BirdFontGlyphSequence* _tmp1_;
	BirdFontGlyphSequence* _tmp2_;
	GeeArrayList* _tmp3_;
	BirdFontGlyphSequence* gs = NULL;
	BirdFontGlyphSequence* _tmp4_;
	BirdFontOtfTags* _tmp5_;
	BirdFontOtfTags* _tmp6_;
	GeeArrayList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->rows;
	_tmp1_ = bird_font_kerning_display_get_first_row (self);
	_tmp2_ = _tmp1_;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp0_, 0, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gee_array_list_new (BIRD_FONT_TYPE_GLYPH_SEQUENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->first_row);
	self->priv->first_row = _tmp3_;
	_tmp4_ = bird_font_glyph_sequence_new ();
	gs = _tmp4_;
	_tmp5_ = bird_font_kerning_tools_get_otf_tags ();
	_tmp6_ = _tmp5_;
	bird_font_glyph_sequence_set_otf_tags (gs, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->first_row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, gs);
	_g_object_unref0 (gs);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static void
bird_font_kerning_display_add_character (BirdFontKerningDisplay* self,
                                         gunichar c)
{
	BirdFontGlyph* g = NULL;
	gchar* name = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_free0 (name);
		_g_object_unref0 (g);
		return;
	}
	if (!bird_font_is_modifier_key ((guint) c)) {
		_tmp0_ = g_unichar_validate (c);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		BirdFontFont* _tmp2_;
		BirdFontFont* _tmp3_;
		const gchar* _tmp4_;
		BirdFontGlyph* _tmp5_;
		BirdFontGlyph* _tmp6_;
		_tmp1_ = g_unichar_to_string (c);
		_g_free0 (name);
		name = (gchar*) _tmp1_;
		_tmp2_ = bird_font_bird_font_get_current_font ();
		_tmp3_ = _tmp2_;
		_tmp4_ = name;
		_tmp5_ = bird_font_font_get_glyph_by_name (_tmp3_, _tmp4_);
		_g_object_unref0 (g);
		g = _tmp5_;
		_g_object_unref0 (_tmp3_);
		_tmp6_ = g;
		bird_font_kerning_display_inser_glyph (self, _tmp6_);
	}
	_g_free0 (name);
	_g_object_unref0 (g);
}

void
bird_font_kerning_display_inser_glyph (BirdFontKerningDisplay* self,
                                       BirdFontGlyph* g)
{
	gint handle = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->first_row;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		BirdFontGlyphSequence* gs = NULL;
		BirdFontGlyphSequence* _tmp3_;
		BirdFontGlyphSequence* _tmp4_;
		BirdFontOtfTags* _tmp5_;
		BirdFontOtfTags* _tmp6_;
		GeeArrayList* _tmp7_;
		BirdFontGlyphSequence* _tmp8_;
		_tmp3_ = bird_font_glyph_sequence_new ();
		gs = _tmp3_;
		_tmp4_ = gs;
		_tmp5_ = bird_font_kerning_tools_get_otf_tags ();
		_tmp6_ = _tmp5_;
		bird_font_glyph_sequence_set_otf_tags (_tmp4_, _tmp6_);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->first_row;
		_tmp8_ = gs;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
		_g_object_unref0 (gs);
	}
	if (g != NULL) {
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gpointer _tmp13_;
		BirdFontGlyphSequence* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gpointer _tmp20_;
		BirdFontGlyphSequence* _tmp21_;
		GeeArrayList* _tmp22_;
		BirdFontGlyphSequence* _tmp23_;
		BirdFontGlyphSequence* _tmp24_;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp9_ = self->priv->first_row;
		_tmp10_ = self->priv->first_row;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp12_ - 1);
		_tmp14_ = (BirdFontGlyphSequence*) _tmp13_;
		_tmp15_ = _tmp14_->glyph;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, g);
		_g_object_unref0 (_tmp14_);
		_tmp16_ = self->priv->first_row;
		_tmp17_ = self->priv->first_row;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp19_ - 1);
		_tmp21_ = (BirdFontGlyphSequence*) _tmp20_;
		_tmp22_ = _tmp21_->ranges;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, NULL);
		_g_object_unref0 (_tmp21_);
		_tmp23_ = bird_font_kerning_display_get_first_row (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_->glyph;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		handle = _tmp27_ - 1;
		_g_object_unref0 (_tmp24_);
		bird_font_kerning_display_set_selected_handle (self, handle);
		bird_font_kerning_display_set_active_handle_index (self, handle);
	}
}

static void
bird_font_kerning_display_real_motion_notify (BirdFontFontDisplay* base,
                                              gdouble ex,
                                              gdouble ey)
{
	BirdFontKerningDisplay * self;
	gdouble k = 0.0;
	gdouble y = 0.0;
	self = (BirdFontKerningDisplay*) base;
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	if (!self->priv->moving) {
		bird_font_kerning_display_set_active_handle (self, ex, ey);
	} else {
		y = (gdouble) 1;
		if (fabs (ey - self->priv->begin_handle_y) > ((gdouble) 20)) {
			y = (fabs (ey - self->priv->begin_handle_y) / 100) + 1;
		}
		k = (ex - self->priv->last_handle_x) / y;
		k /= bird_font_kerning_tools_font_size;
		if (bird_font_kerning_display_right_to_left) {
			k *= (gdouble) -1;
		}
		bird_font_kerning_display_set_space (self, self->priv->selected_handle, k);
		bird_font_glyph_canvas_redraw ();
	}
	self->priv->last_handle_x = ex;
}

void
bird_font_kerning_display_set_active_handle (BirdFontKerningDisplay* self,
                                             gdouble ex,
                                             gdouble ey)
{
	gdouble w = 0.0;
	gdouble d = 0.0;
	gdouble kern = 0.0;
	gdouble min = 0.0;
	gint i = 0;
	gint row_index = 0;
	gint col_index = 0;
	BirdFontGlyph* glyph = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble fs = 0.0;
	gdouble x = 0.0;
	BirdFontGlyphRange* gr_left = NULL;
	BirdFontGlyphRange* gr_right = NULL;
	BirdFontGlyph* prev = NULL;
	gchar* gl_name = NULL;
	gchar* _tmp2_;
	BirdFontGlyphSequence* word_with_ligatures = NULL;
	BirdFontGlyphSequence* _tmp3_;
	gint _tmp56_;
	g_return_if_fail (self != NULL);
	w = (gdouble) 0;
	min = DBL_MAX;
	i = 0;
	row_index = 0;
	col_index = 0;
	_tmp0_ = bird_font_glyph_new_no_lines ("", (gunichar) 0);
	glyph = _tmp0_;
	fs = bird_font_kerning_tools_font_size;
	x = (gdouble) 20;
	if (bird_font_kerning_display_right_to_left) {
		BirdFontWidgetAllocation* _tmp1_;
		_tmp1_ = self->priv->allocation;
		x = (_tmp1_->width - 20) / bird_font_kerning_tools_font_size;
	}
	prev = NULL;
	_tmp2_ = g_strdup ("");
	gl_name = _tmp2_;
	col_index = 0;
	_tmp3_ = bird_font_kerning_display_get_first_row (self);
	_g_object_unref0 (word_with_ligatures);
	word_with_ligatures = _tmp3_;
	{
		GeeArrayList* _g_list = NULL;
		BirdFontGlyphSequence* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _g_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _g_index = 0;
		_tmp4_ = word_with_ligatures;
		_tmp5_ = _tmp4_->glyph;
		_g_list = _tmp5_;
		_tmp6_ = _g_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_size = _tmp8_;
		_g_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			BirdFontGlyph* g = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			BirdFontGlyph* _tmp13_;
			BirdFontGlyph* _tmp17_;
			gchar* _tmp18_;
			gboolean _tmp19_ = FALSE;
			BirdFontGlyph* _tmp20_;
			gboolean _tmp27_ = FALSE;
			BirdFontGlyph* _tmp28_;
			BirdFontGlyph* _tmp52_;
			BirdFontGlyph* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			_g_index = _g_index + 1;
			_tmp9_ = _g_index;
			_tmp10_ = _g_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _g_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _g_index);
			g = (BirdFontGlyph*) _tmp12_;
			_tmp13_ = g;
			if (_tmp13_ == NULL) {
				w = (gdouble) 50;
				g_warning ("KerningDisplay.vala:844: glyph does not exist");
			} else {
				BirdFontGlyph* _tmp14_;
				BirdFontGlyph* _tmp15_;
				BirdFontGlyph* _tmp16_;
				_tmp14_ = g;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
				_g_object_unref0 (glyph);
				glyph = _tmp15_;
				_tmp16_ = glyph;
				w = bird_font_glyph_get_width (_tmp16_);
			}
			_tmp17_ = glyph;
			_tmp18_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) _tmp17_);
			_g_free0 (gl_name);
			gl_name = _tmp18_;
			_tmp20_ = prev;
			if (_tmp20_ == NULL) {
				_tmp19_ = col_index != 0;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp21_ = g_strdup_printf ("%i", row_index);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%i", col_index);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat ("previous glyph does not exist row: ", _tmp22_, " column: ", _tmp24_, NULL);
				_tmp26_ = _tmp25_;
				g_warning ("KerningDisplay.vala:853: %s", _tmp26_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
			}
			_tmp28_ = prev;
			if (_tmp28_ == NULL) {
				_tmp27_ = TRUE;
			} else {
				_tmp27_ = col_index == 0;
			}
			if (_tmp27_) {
				kern = (gdouble) 0;
			} else {
				BirdFontGlyphSequence* _tmp29_;
				GeeArrayList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				BirdFontGlyphSequence* _tmp33_;
				GeeArrayList* _tmp34_;
				gpointer _tmp35_;
				BirdFontGlyphSequence* _tmp36_;
				GeeArrayList* _tmp37_;
				gpointer _tmp38_;
				BirdFontGlyph* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				BirdFontGlyph* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				BirdFontGlyphRange* _tmp45_;
				BirdFontGlyphRange* _tmp46_;
				_tmp29_ = word_with_ligatures;
				_tmp30_ = _tmp29_->ranges;
				_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				g_return_if_fail (col_index < _tmp32_);
				g_return_if_fail ((col_index - 1) >= 0);
				_tmp33_ = word_with_ligatures;
				_tmp34_ = _tmp33_->ranges;
				_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, col_index - 1);
				_bird_font_glyph_range_unref0 (gr_left);
				gr_left = (BirdFontGlyphRange*) _tmp35_;
				_tmp36_ = word_with_ligatures;
				_tmp37_ = _tmp36_->ranges;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, col_index);
				_bird_font_glyph_range_unref0 (gr_right);
				gr_right = (BirdFontGlyphRange*) _tmp38_;
				_tmp39_ = prev;
				_tmp40_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
				_tmp41_ = _tmp40_;
				_tmp42_ = g;
				_tmp43_ = bird_font_font_display_get_name ((BirdFontFontDisplay*) G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, BIRD_FONT_TYPE_GLYPH, BirdFontGlyph));
				_tmp44_ = _tmp43_;
				_tmp45_ = gr_left;
				_tmp46_ = gr_right;
				kern = bird_font_kerning_display_get_kerning_for_pair (_tmp41_, _tmp44_, _tmp45_, _tmp46_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp41_);
			}
			if (bird_font_kerning_display_right_to_left) {
				d = pow ((fs * (x - kern)) - ex, (gdouble) 2);
			} else {
				d = pow ((fs * (x + kern)) - ex, (gdouble) 2);
			}
			if (d < min) {
				gboolean _tmp47_ = FALSE;
				BirdFontGlyphSequence* _tmp48_;
				GeeArrayList* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				min = d;
				if (ex != (fs * (x + kern))) {
					self->right_side_bearing = ex < (fs * (x + kern));
				}
				if (self->priv->active_handle != (i - row_index)) {
					bird_font_kerning_display_set_active_handle_index (self, i - row_index);
					bird_font_glyph_canvas_redraw ();
				}
				_tmp48_ = word_with_ligatures;
				_tmp49_ = _tmp48_->glyph;
				_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
				_tmp51_ = _tmp50_;
				if (col_index == _tmp51_) {
					_tmp47_ = TRUE;
				} else {
					_tmp47_ = col_index == 0;
				}
				if (_tmp47_) {
					bird_font_kerning_display_set_active_handle_index (self, -1);
				} else {
					bird_font_kerning_display_set_active_handle_index (self, self->priv->active_handle + row_index);
				}
			}
			_tmp52_ = g;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			_g_object_unref0 (prev);
			prev = _tmp53_;
			if (bird_font_kerning_display_right_to_left) {
				x -= w + kern;
			} else {
				x += w + kern;
			}
			_tmp54_ = i;
			i = _tmp54_ + 1;
			_tmp55_ = col_index;
			col_index = _tmp55_ + 1;
			_g_object_unref0 (g);
		}
	}
	_tmp56_ = row_index;
	row_index = _tmp56_ + 1;
	x = (gdouble) 20;
	_g_object_unref0 (word_with_ligatures);
	_g_free0 (gl_name);
	_g_object_unref0 (prev);
	_bird_font_glyph_range_unref0 (gr_right);
	_bird_font_glyph_range_unref0 (gr_left);
	_g_object_unref0 (glyph);
}

static void
bird_font_kerning_display_real_button_release (BirdFontFontDisplay* base,
                                               gint button,
                                               gdouble ex,
                                               gdouble ey)
{
	BirdFontKerningDisplay * self;
	gboolean _tmp0_ = FALSE;
	self = (BirdFontKerningDisplay*) base;
	bird_font_kerning_display_set_active_handle (self, ex, ey);
	self->priv->moving = FALSE;
	self->priv->first_update = TRUE;
	if (button == 3) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->text_input;
	}
	if (_tmp0_) {
		bird_font_kerning_display_set_kerning_by_text (self);
	}
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
__lambda97_ (BirdFontKerningDisplay* self,
             const gchar* text)
{
	gchar* submitted_value = NULL;
	gdouble parsed_value = 0.0;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (text != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_free0 (submitted_value);
		return;
	}
	_tmp0_ = string_replace (text, ",", ".");
	_g_free0 (submitted_value);
	submitted_value = _tmp0_;
	_tmp1_ = submitted_value;
	parsed_value = double_parse (_tmp1_);
	bird_font_kerning_display_set_absolute_kerning (self, self->priv->selected_handle, parsed_value);
	bird_font_glyph_canvas_redraw ();
	_g_free0 (submitted_value);
}

static void
___lambda97__bird_font_text_listener_signal_text_input (BirdFontTextListener* _sender,
                                                        const gchar* text,
                                                        gpointer self)
{
	__lambda97_ ((BirdFontKerningDisplay*) self, text);
}

static void
__lambda98_ (BirdFontKerningDisplay* self)
{
	bird_font_tab_content_hide_text_input ();
	self->text_input = FALSE;
	self->suppress_input = FALSE;
}

static void
___lambda98__bird_font_text_listener_signal_submit (BirdFontTextListener* _sender,
                                                    const gchar* text,
                                                    gpointer self)
{
	__lambda98_ ((BirdFontKerningDisplay*) self);
}

void
bird_font_kerning_display_set_kerning_by_text (BirdFontKerningDisplay* self)
{
	BirdFontTextListener* listener = NULL;
	gchar* kerning = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	BirdFontTextListener* _tmp6_;
	BirdFontTextListener* _tmp7_;
	BirdFontTextListener* _tmp8_;
	BirdFontTextListener* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = double_to_string (bird_font_kerning_display_get_kerning_for_handle (self, self->priv->selected_handle));
	kerning = _tmp0_;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_free0 (kerning);
		_g_object_unref0 (listener);
		return;
	}
	if (self->priv->selected_handle == -1) {
		bird_font_kerning_display_set_selected_handle (self, 0);
	}
	_tmp1_ = bird_font_t_ ("Kerning");
	_tmp2_ = _tmp1_;
	_tmp3_ = kerning;
	_tmp4_ = bird_font_t_ ("Close");
	_tmp5_ = _tmp4_;
	_tmp6_ = bird_font_text_listener_new (_tmp2_, _tmp3_, _tmp5_);
	_g_object_unref0 (listener);
	listener = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	_tmp7_ = listener;
	g_signal_connect_object (_tmp7_, "signal-text-input", (GCallback) ___lambda97__bird_font_text_listener_signal_text_input, self, 0);
	_tmp8_ = listener;
	g_signal_connect_object (_tmp8_, "signal-submit", (GCallback) ___lambda98__bird_font_text_listener_signal_submit, self, 0);
	self->suppress_input = TRUE;
	self->text_input = TRUE;
	_tmp9_ = listener;
	bird_font_tab_content_show_text_input (_tmp9_);
	bird_font_glyph_canvas_redraw ();
	_g_free0 (kerning);
	_g_object_unref0 (listener);
}

static void
bird_font_kerning_display_real_button_press (BirdFontFontDisplay* base,
                                             guint button,
                                             gdouble ex,
                                             gdouble ey)
{
	BirdFontKerningDisplay * self;
	self = (BirdFontKerningDisplay*) base;
	bird_font_kerning_display_set_active_handle (self, ex, ey);
	bird_font_kerning_display_set_selected_handle (self, self->priv->active_handle);
	self->priv->begin_handle_x = ex;
	self->priv->begin_handle_y = ey;
	self->priv->last_handle_x = ex;
	self->priv->moving = TRUE;
}

/** Insert text form clipboard. */
static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

void
bird_font_kerning_display_add_text (BirdFontKerningDisplay* self,
                                    const gchar* t)
{
	gint c = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	if (bird_font_menu_tab_has_suppress_event ()) {
		return;
	}
	c = g_utf8_strlen (t, (gssize) -1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i <= c)) {
					break;
				}
				bird_font_kerning_display_add_character (self, string_get_char (t, (glong) string_index_of_nth_char (t, (glong) i)));
			}
		}
	}
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_kerning_display_real_undo (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	BirdFontKerningDisplayUndoItem* ui = NULL;
	BirdFontKerningDisplayUndoItem* redo_state = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontKerningDisplayUndoItem* _tmp8_;
	BirdFontKerningDisplayUndoItem* _tmp9_;
	GeeArrayList* _tmp10_;
	BirdFontKerningDisplayUndoItem* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gpointer _tmp16_;
	BirdFontKerningDisplayUndoItem* _tmp17_;
	self = (BirdFontKerningDisplay*) base;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_object_unref0 (redo_state);
		_g_object_unref0 (ui);
		return;
	}
	_tmp0_ = self->priv->undo_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_g_object_unref0 (redo_state);
		_g_object_unref0 (ui);
		return;
	}
	_tmp3_ = self->priv->undo_items;
	_tmp4_ = self->priv->undo_items;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	_g_object_unref0 (ui);
	ui = (BirdFontKerningDisplayUndoItem*) _tmp7_;
	_tmp8_ = ui;
	_tmp9_ = bird_font_kerning_display_apply_undo (self, _tmp8_);
	_g_object_unref0 (redo_state);
	redo_state = _tmp9_;
	_tmp10_ = self->priv->redo_items;
	_tmp11_ = redo_state;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->undo_items;
	_tmp13_ = self->priv->undo_items;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp12_, _tmp15_ - 1);
	_tmp17_ = (BirdFontKerningDisplayUndoItem*) _tmp16_;
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (redo_state);
	_g_object_unref0 (ui);
}

static void
bird_font_kerning_display_real_redo (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	BirdFontKerningDisplayUndoItem* ui = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	BirdFontKerningDisplayUndoItem* _tmp8_;
	BirdFontKerningDisplayUndoItem* _tmp9_;
	BirdFontKerningDisplayUndoItem* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	BirdFontKerningDisplayUndoItem* _tmp16_;
	self = (BirdFontKerningDisplay*) base;
	if (bird_font_menu_tab_has_suppress_event ()) {
		_g_object_unref0 (ui);
		return;
	}
	_tmp0_ = self->priv->redo_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		_g_object_unref0 (ui);
		return;
	}
	_tmp3_ = self->priv->redo_items;
	_tmp4_ = self->priv->redo_items;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp6_ - 1);
	_g_object_unref0 (ui);
	ui = (BirdFontKerningDisplayUndoItem*) _tmp7_;
	_tmp8_ = ui;
	_tmp9_ = bird_font_kerning_display_apply_undo (self, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->redo_items;
	_tmp12_ = self->priv->redo_items;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp11_, _tmp14_ - 1);
	_tmp16_ = (BirdFontKerningDisplayUndoItem*) _tmp15_;
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (ui);
}

/** @return redo state. */
static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

BirdFontKerningDisplayUndoItem*
bird_font_kerning_display_apply_undo (BirdFontKerningDisplay* self,
                                      BirdFontKerningDisplayUndoItem* ui)
{
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	BirdFontGlyphRange* glyph_range_first = NULL;
	BirdFontGlyphRange* glyph_range_next = NULL;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp4_;
	gchar* l = NULL;
	gchar* r = NULL;
	BirdFontKerningDisplayUndoItem* redo_state = NULL;
	BirdFontKerningDisplayUndoItem* _tmp5_;
	gdouble* k = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	BirdFontFont* _tmp99_;
	GError* _inner_error0_ = NULL;
	BirdFontKerningDisplayUndoItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ui != NULL, NULL);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	classes = _tmp3_;
	_tmp4_ = bird_font_bird_font_get_current_font ();
	font = _tmp4_;
	_tmp5_ = bird_font_kerning_display_undo_item_new ("", "", (gdouble) 0, FALSE);
	redo_state = _tmp5_;
	_tmp6_ = ui->first;
	_tmp7_ = bird_font_glyph_range_unserialize (_tmp6_);
	_g_free0 (l);
	l = _tmp7_;
	_tmp8_ = ui->next;
	_tmp9_ = bird_font_glyph_range_unserialize (_tmp8_);
	_g_free0 (r);
	r = _tmp9_;
	{
		BirdFontGlyphRange* _tmp10_;
		BirdFontGlyphRange* _tmp11_;
		BirdFontGlyphRange* _tmp12_;
		const gchar* _tmp13_;
		BirdFontGlyphRange* _tmp14_;
		const gchar* _tmp15_;
		_tmp10_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (glyph_range_first);
		glyph_range_first = _tmp10_;
		_tmp11_ = bird_font_glyph_range_new ();
		_bird_font_glyph_range_unref0 (glyph_range_next);
		glyph_range_next = _tmp11_;
		_tmp12_ = glyph_range_first;
		_tmp13_ = ui->first;
		bird_font_glyph_range_parse_ranges (_tmp12_, _tmp13_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (k);
			_g_object_unref0 (redo_state);
			_g_free0 (r);
			_g_free0 (l);
			_g_object_unref0 (font);
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			_g_object_unref0 (classes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp14_ = glyph_range_next;
		_tmp15_ = ui->next;
		bird_font_glyph_range_parse_ranges (_tmp14_, _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_free0 (k);
			_g_object_unref0 (redo_state);
			_g_free0 (r);
			_g_free0 (l);
			_g_object_unref0 (font);
			_bird_font_glyph_range_unref0 (glyph_range_next);
			_bird_font_glyph_range_unref0 (glyph_range_first);
			_g_object_unref0 (classes);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		if (!ui->has_kerning) {
			gboolean _tmp16_ = FALSE;
			BirdFontGlyphRange* _tmp17_;
			_tmp17_ = glyph_range_first;
			if (bird_font_glyph_range_is_class (_tmp17_)) {
				_tmp16_ = TRUE;
			} else {
				BirdFontGlyphRange* _tmp18_;
				_tmp18_ = glyph_range_next;
				_tmp16_ = bird_font_glyph_range_is_class (_tmp18_);
			}
			if (_tmp16_) {
				BirdFontKerningDisplayUndoItem* _tmp19_;
				BirdFontGlyphRange* _tmp20_;
				gchar* _tmp21_;
				BirdFontKerningDisplayUndoItem* _tmp22_;
				BirdFontGlyphRange* _tmp23_;
				gchar* _tmp24_;
				BirdFontKerningDisplayUndoItem* _tmp25_;
				BirdFontKerningDisplayUndoItem* _tmp26_;
				BirdFontKerningClasses* _tmp27_;
				BirdFontGlyphRange* _tmp28_;
				BirdFontGlyphRange* _tmp29_;
				BirdFontKerningClasses* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp19_ = redo_state;
				_tmp20_ = glyph_range_first;
				_tmp21_ = bird_font_glyph_range_get_all_ranges (_tmp20_);
				_g_free0 (_tmp19_->first);
				_tmp19_->first = _tmp21_;
				_tmp22_ = redo_state;
				_tmp23_ = glyph_range_next;
				_tmp24_ = bird_font_glyph_range_get_all_ranges (_tmp23_);
				_g_free0 (_tmp22_->next);
				_tmp22_->next = _tmp24_;
				_tmp25_ = redo_state;
				_tmp25_->has_kerning = TRUE;
				_tmp26_ = redo_state;
				_tmp27_ = classes;
				_tmp28_ = glyph_range_first;
				_tmp29_ = glyph_range_next;
				_tmp26_->kerning = bird_font_kerning_classes_get_kerning_for_range (_tmp27_, _tmp28_, _tmp29_);
				_tmp30_ = classes;
				_tmp31_ = ui->first;
				_tmp32_ = ui->next;
				bird_font_kerning_classes_delete_kerning_for_class (_tmp30_, _tmp31_, _tmp32_);
			} else {
				BirdFontKerningDisplayUndoItem* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				BirdFontKerningDisplayUndoItem* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				BirdFontKerningDisplayUndoItem* _tmp39_;
				BirdFontKerningClasses* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				gdouble* _tmp43_;
				gdouble* _tmp44_;
				BirdFontKerningClasses* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				_tmp33_ = redo_state;
				_tmp34_ = ui->first;
				_tmp35_ = g_strdup (_tmp34_);
				_g_free0 (_tmp33_->first);
				_tmp33_->first = _tmp35_;
				_tmp36_ = redo_state;
				_tmp37_ = ui->next;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (_tmp36_->next);
				_tmp36_->next = _tmp38_;
				_tmp39_ = redo_state;
				_tmp39_->has_kerning = TRUE;
				_tmp40_ = classes;
				_tmp41_ = ui->first;
				_tmp42_ = ui->next;
				_tmp43_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (_tmp40_, _tmp41_, _tmp42_);
				_g_free0 (k);
				k = _tmp43_;
				_tmp44_ = k;
				if (_tmp44_ != NULL) {
					BirdFontKerningDisplayUndoItem* _tmp45_;
					gdouble* _tmp46_;
					_tmp45_ = redo_state;
					_tmp46_ = k;
					_tmp45_->kerning = (gdouble) (*_tmp46_);
				} else {
					g_warning ("KerningDisplay.vala:1058: No kerning");
				}
				_tmp47_ = classes;
				_tmp48_ = ui->first;
				_tmp49_ = ui->next;
				bird_font_kerning_classes_delete_kerning_for_pair (_tmp47_, _tmp48_, _tmp49_);
			}
		} else {
			gboolean _tmp50_ = FALSE;
			BirdFontGlyphRange* _tmp51_;
			_tmp51_ = glyph_range_first;
			if (bird_font_glyph_range_is_class (_tmp51_)) {
				_tmp50_ = TRUE;
			} else {
				BirdFontGlyphRange* _tmp52_;
				_tmp52_ = glyph_range_next;
				_tmp50_ = bird_font_glyph_range_is_class (_tmp52_);
			}
			if (_tmp50_) {
				BirdFontGlyphRange* _tmp53_;
				BirdFontGlyphRange* _tmp54_;
				BirdFontGlyphRange* _tmp55_;
				const gchar* _tmp56_;
				BirdFontGlyphRange* _tmp57_;
				const gchar* _tmp58_;
				BirdFontKerningDisplayUndoItem* _tmp59_;
				BirdFontGlyphRange* _tmp60_;
				gchar* _tmp61_;
				BirdFontKerningDisplayUndoItem* _tmp62_;
				BirdFontGlyphRange* _tmp63_;
				gchar* _tmp64_;
				BirdFontKerningClasses* _tmp65_;
				BirdFontGlyphRange* _tmp66_;
				BirdFontGlyphRange* _tmp67_;
				gdouble _tmp68_;
				gdouble* _tmp69_;
				gdouble* _tmp70_;
				BirdFontKerningClasses* _tmp75_;
				BirdFontGlyphRange* _tmp76_;
				BirdFontGlyphRange* _tmp77_;
				_tmp53_ = bird_font_glyph_range_new ();
				_bird_font_glyph_range_unref0 (glyph_range_first);
				glyph_range_first = _tmp53_;
				_tmp54_ = bird_font_glyph_range_new ();
				_bird_font_glyph_range_unref0 (glyph_range_next);
				glyph_range_next = _tmp54_;
				_tmp55_ = glyph_range_first;
				_tmp56_ = ui->first;
				bird_font_glyph_range_parse_ranges (_tmp55_, _tmp56_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						goto __catch0_g_markup_error;
					}
					_g_free0 (k);
					_g_object_unref0 (redo_state);
					_g_free0 (r);
					_g_free0 (l);
					_g_object_unref0 (font);
					_bird_font_glyph_range_unref0 (glyph_range_next);
					_bird_font_glyph_range_unref0 (glyph_range_first);
					_g_object_unref0 (classes);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp57_ = glyph_range_next;
				_tmp58_ = ui->next;
				bird_font_glyph_range_parse_ranges (_tmp57_, _tmp58_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
						goto __catch0_g_markup_error;
					}
					_g_free0 (k);
					_g_object_unref0 (redo_state);
					_g_free0 (r);
					_g_free0 (l);
					_g_object_unref0 (font);
					_bird_font_glyph_range_unref0 (glyph_range_next);
					_bird_font_glyph_range_unref0 (glyph_range_first);
					_g_object_unref0 (classes);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp59_ = redo_state;
				_tmp60_ = glyph_range_first;
				_tmp61_ = bird_font_glyph_range_get_all_ranges (_tmp60_);
				_g_free0 (_tmp59_->first);
				_tmp59_->first = _tmp61_;
				_tmp62_ = redo_state;
				_tmp63_ = glyph_range_next;
				_tmp64_ = bird_font_glyph_range_get_all_ranges (_tmp63_);
				_g_free0 (_tmp62_->next);
				_tmp62_->next = _tmp64_;
				_tmp65_ = classes;
				_tmp66_ = glyph_range_first;
				_tmp67_ = glyph_range_next;
				_tmp68_ = bird_font_kerning_classes_get_kerning_for_range (_tmp65_, _tmp66_, _tmp67_);
				_tmp69_ = __double_dup0 (&_tmp68_);
				_g_free0 (k);
				k = _tmp69_;
				_tmp70_ = k;
				if (_tmp70_ != NULL) {
					BirdFontKerningDisplayUndoItem* _tmp71_;
					gdouble* _tmp72_;
					BirdFontKerningDisplayUndoItem* _tmp73_;
					_tmp71_ = redo_state;
					_tmp72_ = k;
					_tmp71_->kerning = (gdouble) (*_tmp72_);
					_tmp73_ = redo_state;
					_tmp73_->has_kerning = TRUE;
				} else {
					BirdFontKerningDisplayUndoItem* _tmp74_;
					_tmp74_ = redo_state;
					_tmp74_->has_kerning = FALSE;
				}
				_tmp75_ = classes;
				_tmp76_ = glyph_range_first;
				_tmp77_ = glyph_range_next;
				bird_font_kerning_classes_set_kerning (_tmp75_, _tmp76_, _tmp77_, ui->kerning, -1);
			} else {
				BirdFontKerningDisplayUndoItem* _tmp78_;
				const gchar* _tmp79_;
				gchar* _tmp80_;
				BirdFontKerningDisplayUndoItem* _tmp81_;
				const gchar* _tmp82_;
				gchar* _tmp83_;
				BirdFontKerningDisplayUndoItem* _tmp84_;
				BirdFontKerningClasses* _tmp85_;
				const gchar* _tmp86_;
				const gchar* _tmp87_;
				gdouble* _tmp88_;
				gdouble* _tmp89_;
				BirdFontKerningClasses* _tmp94_;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
				_tmp78_ = redo_state;
				_tmp79_ = ui->first;
				_tmp80_ = g_strdup (_tmp79_);
				_g_free0 (_tmp78_->first);
				_tmp78_->first = _tmp80_;
				_tmp81_ = redo_state;
				_tmp82_ = ui->next;
				_tmp83_ = g_strdup (_tmp82_);
				_g_free0 (_tmp81_->next);
				_tmp81_->next = _tmp83_;
				_tmp84_ = redo_state;
				_tmp84_->has_kerning = TRUE;
				_tmp85_ = classes;
				_tmp86_ = ui->first;
				_tmp87_ = ui->next;
				_tmp88_ = bird_font_kerning_classes_get_kerning_for_single_glyphs (_tmp85_, _tmp86_, _tmp87_);
				_g_free0 (k);
				k = _tmp88_;
				_tmp89_ = k;
				if (_tmp89_ != NULL) {
					BirdFontKerningDisplayUndoItem* _tmp90_;
					gdouble* _tmp91_;
					BirdFontKerningDisplayUndoItem* _tmp92_;
					_tmp90_ = redo_state;
					_tmp91_ = k;
					_tmp90_->kerning = (gdouble) (*_tmp91_);
					_tmp92_ = redo_state;
					_tmp92_->has_kerning = TRUE;
				} else {
					BirdFontKerningDisplayUndoItem* _tmp93_;
					_tmp93_ = redo_state;
					_tmp93_->has_kerning = FALSE;
				}
				_tmp94_ = classes;
				_tmp95_ = ui->first;
				_tmp96_ = ui->next;
				bird_font_kerning_classes_set_kerning_for_single_glyphs (_tmp94_, _tmp95_, _tmp96_, ui->kerning);
			}
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp97_;
		const gchar* _tmp98_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp97_ = e;
		_tmp98_ = _tmp97_->message;
		g_warning ("KerningDisplay.vala:1098: %s", _tmp98_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (k);
		_g_object_unref0 (redo_state);
		_g_free0 (r);
		_g_free0 (l);
		_g_object_unref0 (font);
		_bird_font_glyph_range_unref0 (glyph_range_next);
		_bird_font_glyph_range_unref0 (glyph_range_first);
		_g_object_unref0 (classes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp99_ = font;
	bird_font_font_touch (_tmp99_);
	bird_font_glyph_canvas_redraw ();
	result = redo_state;
	_g_free0 (k);
	_g_free0 (r);
	_g_free0 (l);
	_g_object_unref0 (font);
	_bird_font_glyph_range_unref0 (glyph_range_next);
	_bird_font_glyph_range_unref0 (glyph_range_first);
	_g_object_unref0 (classes);
	return result;
}

static void
bird_font_kerning_display_real_zoom_in (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	BirdFontZoomBar* _tmp0_;
	self = (BirdFontKerningDisplay*) base;
	bird_font_kerning_tools_font_size = bird_font_kerning_tools_font_size + 0.1;
	if (bird_font_kerning_tools_font_size > ((gdouble) 3)) {
		bird_font_kerning_tools_font_size = (gdouble) 3;
	}
	_tmp0_ = bird_font_kerning_tools_zoom_bar;
	bird_font_zoom_bar_set_zoom (_tmp0_, bird_font_kerning_tools_font_size / 3);
	bird_font_glyph_canvas_redraw ();
}

static void
bird_font_kerning_display_real_zoom_out (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	BirdFontZoomBar* _tmp0_;
	self = (BirdFontKerningDisplay*) base;
	bird_font_kerning_tools_font_size = bird_font_kerning_tools_font_size - 0.1;
	if (bird_font_kerning_tools_font_size < 0.3) {
		bird_font_kerning_tools_font_size = 0.3;
	}
	_tmp0_ = bird_font_kerning_tools_zoom_bar;
	bird_font_zoom_bar_set_zoom (_tmp0_, bird_font_kerning_tools_font_size / 3);
	bird_font_glyph_canvas_redraw ();
}

static gboolean
bird_font_kerning_display_real_needs_modifier (BirdFontFontDisplay* base)
{
	BirdFontKerningDisplay * self;
	gboolean result;
	self = (BirdFontKerningDisplay*) base;
	result = TRUE;
	return result;
}

BirdFontKerningDisplayUndoItem*
bird_font_kerning_display_undo_item_construct (GType object_type,
                                               const gchar* first,
                                               const gchar* next,
                                               gdouble kerning,
                                               gboolean has_kerning)
{
	BirdFontKerningDisplayUndoItem * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (first != NULL, NULL);
	g_return_val_if_fail (next != NULL, NULL);
	self = (BirdFontKerningDisplayUndoItem*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (first);
	_g_free0 (self->first);
	self->first = _tmp0_;
	_tmp1_ = g_strdup (next);
	_g_free0 (self->next);
	self->next = _tmp1_;
	self->kerning = kerning;
	self->has_kerning = has_kerning;
	return self;
}

BirdFontKerningDisplayUndoItem*
bird_font_kerning_display_undo_item_new (const gchar* first,
                                         const gchar* next,
                                         gdouble kerning,
                                         gboolean has_kerning)
{
	return bird_font_kerning_display_undo_item_construct (BIRD_FONT_KERNING_DISPLAY_TYPE_UNDO_ITEM, first, next, kerning, has_kerning);
}

static void
bird_font_kerning_display_undo_item_class_init (BirdFontKerningDisplayUndoItemClass * klass,
                                                gpointer klass_data)
{
	bird_font_kerning_display_undo_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_display_undo_item_finalize;
}

static void
bird_font_kerning_display_undo_item_instance_init (BirdFontKerningDisplayUndoItem * self,
                                                   gpointer klass)
{
}

static void
bird_font_kerning_display_undo_item_finalize (GObject * obj)
{
	BirdFontKerningDisplayUndoItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_KERNING_DISPLAY_TYPE_UNDO_ITEM, BirdFontKerningDisplayUndoItem);
	_g_free0 (self->first);
	_g_free0 (self->next);
	G_OBJECT_CLASS (bird_font_kerning_display_undo_item_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_display_undo_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningDisplayUndoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_display_undo_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningDisplayUndoItem), 0, (GInstanceInitFunc) bird_font_kerning_display_undo_item_instance_init, NULL };
	GType bird_font_kerning_display_undo_item_type_id;
	bird_font_kerning_display_undo_item_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontKerningDisplayUndoItem", &g_define_type_info, 0);
	return bird_font_kerning_display_undo_item_type_id;
}

GType
bird_font_kerning_display_undo_item_get_type (void)
{
	static volatile gsize bird_font_kerning_display_undo_item_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_display_undo_item_type_id__once)) {
		GType bird_font_kerning_display_undo_item_type_id;
		bird_font_kerning_display_undo_item_type_id = bird_font_kerning_display_undo_item_get_type_once ();
		g_once_init_leave (&bird_font_kerning_display_undo_item_type_id__once, bird_font_kerning_display_undo_item_type_id);
	}
	return bird_font_kerning_display_undo_item_type_id__once;
}

static void
bird_font_kerning_display_class_init (BirdFontKerningDisplayClass * klass,
                                      gpointer klass_data)
{
	bird_font_kerning_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKerningDisplay_private_offset);
	((BirdFontFontDisplayClass *) klass)->get_label = (gchar* (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_get_label;
	((BirdFontFontDisplayClass *) klass)->get_name = (gchar* (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_get_name;
	((BirdFontFontDisplayClass *) klass)->draw = (void (*) (BirdFontFontDisplay*, BirdFontWidgetAllocation*, cairo_t*)) bird_font_kerning_display_real_draw;
	((BirdFontFontDisplayClass *) klass)->selected_canvas = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_selected_canvas;
	((BirdFontFontDisplayClass *) klass)->key_press = (void (*) (BirdFontFontDisplay*, guint)) bird_font_kerning_display_real_key_press;
	((BirdFontFontDisplayClass *) klass)->motion_notify = (void (*) (BirdFontFontDisplay*, gdouble, gdouble)) bird_font_kerning_display_real_motion_notify;
	((BirdFontFontDisplayClass *) klass)->button_release = (void (*) (BirdFontFontDisplay*, gint, gdouble, gdouble)) bird_font_kerning_display_real_button_release;
	((BirdFontFontDisplayClass *) klass)->button_press = (void (*) (BirdFontFontDisplay*, guint, gdouble, gdouble)) bird_font_kerning_display_real_button_press;
	((BirdFontFontDisplayClass *) klass)->undo = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_undo;
	((BirdFontFontDisplayClass *) klass)->redo = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_redo;
	((BirdFontFontDisplayClass *) klass)->zoom_in = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_zoom_in;
	((BirdFontFontDisplayClass *) klass)->zoom_out = (void (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_zoom_out;
	((BirdFontFontDisplayClass *) klass)->needs_modifier = (gboolean (*) (BirdFontFontDisplay*)) bird_font_kerning_display_real_needs_modifier;
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_display_finalize;
}

static void
bird_font_kerning_display_instance_init (BirdFontKerningDisplay * self,
                                         gpointer klass)
{
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontText* _tmp2_;
	BirdFontWidgetAllocation* _tmp3_;
	self->priv = bird_font_kerning_display_get_instance_private (self);
	self->suppress_input = FALSE;
	self->priv->active_handle = -1;
	self->priv->selected_handle = -1;
	self->priv->moving = FALSE;
	_tmp0_ = bird_font_glyph_new ("null", (gunichar) '\0');
	self->priv->left_active_glyph = _tmp0_;
	_tmp1_ = bird_font_glyph_new ("null", (gunichar) '\0');
	self->priv->right_active_glyph = _tmp1_;
	self->priv->begin_handle_x = (gdouble) 0;
	self->priv->begin_handle_y = (gdouble) 0;
	self->priv->last_handle_x = (gdouble) 0;
	self->text_input = FALSE;
	self->priv->first_update = TRUE;
	_tmp2_ = bird_font_text_new ("", (gdouble) 17, (gdouble) 0);
	self->priv->kerning_label = _tmp2_;
	self->adjust_side_bearings = FALSE;
	self->right_side_bearing = TRUE;
	_tmp3_ = bird_font_widget_allocation_new ();
	self->priv->allocation = _tmp3_;
}

static void
bird_font_kerning_display_finalize (GObject * obj)
{
	BirdFontKerningDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_DISPLAY, BirdFontKerningDisplay);
	_g_object_unref0 (self->priv->first_row);
	_g_object_unref0 (self->priv->rows);
	_g_object_unref0 (self->priv->left_active_glyph);
	_g_object_unref0 (self->priv->right_active_glyph);
	_g_object_unref0 (self->priv->undo_items);
	_g_object_unref0 (self->priv->redo_items);
	_g_object_unref0 (self->priv->kerning_label);
	_g_object_unref0 (self->priv->allocation);
	G_OBJECT_CLASS (bird_font_kerning_display_parent_class)->finalize (obj);
}

/** Kerning context. */
static GType
bird_font_kerning_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningDisplay), 0, (GInstanceInitFunc) bird_font_kerning_display_instance_init, NULL };
	GType bird_font_kerning_display_type_id;
	bird_font_kerning_display_type_id = g_type_register_static (BIRD_FONT_TYPE_FONT_DISPLAY, "BirdFontKerningDisplay", &g_define_type_info, 0);
	BirdFontKerningDisplay_private_offset = g_type_add_instance_private (bird_font_kerning_display_type_id, sizeof (BirdFontKerningDisplayPrivate));
	return bird_font_kerning_display_type_id;
}

GType
bird_font_kerning_display_get_type (void)
{
	static volatile gsize bird_font_kerning_display_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_display_type_id__once)) {
		GType bird_font_kerning_display_type_id;
		bird_font_kerning_display_type_id = bird_font_kerning_display_get_type_once ();
		g_once_init_leave (&bird_font_kerning_display_type_id__once, bird_font_kerning_display_type_id);
	}
	return bird_font_kerning_display_type_id__once;
}

