/* KernTable.c generated by valac 0.56.16, the Vala compiler
 * generated from KernTable.vala, do not modify */

/*
Copyright (C) 2012, 2013, 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERN_TABLE_0_PROPERTY,
	BIRD_FONT_KERN_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_kern_table_properties[BIRD_FONT_KERN_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block81Data Block81Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontKernTablePrivate {
	BirdFontGlyfTable* glyf_table;
	BirdFontKernList* pairs;
};

struct _Block81Data {
	int _ref_count_;
	BirdFontKernTable* self;
	BirdFontFontData* fd;
	guint last_gid_left;
	guint last_gid_right;
};

static gint BirdFontKernTable_private_offset;
static gpointer bird_font_kern_table_parent_class = NULL;

static void bird_font_kern_table_real_parse (BirdFontOtfTable* base,
                                      BirdFontFontData* dis,
                                      GError** error);
static Block81Data* block81_data_ref (Block81Data* _data81_);
static void block81_data_unref (void * _userdata_);
VALA_EXTERN guint16 bird_font_largest_pow2 (guint16 max);
VALA_EXTERN guint16 bird_font_largest_pow2_exponent (guint16 max);
static void __lambda56_ (Block81Data* _data81_,
                  BirdFontKern* kr);
static void ___lambda56__bird_font_kern_list_kern_iterator (BirdFontKern* k,
                                                     gpointer self);
static void bird_font_kern_table_finalize (GObject * obj);
static GType bird_font_kern_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_kern_table_get_instance_private (BirdFontKernTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKernTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontKernTable*
bird_font_kern_table_construct (GType object_type,
                                BirdFontGlyfTable* gt)
{
	BirdFontKernTable * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	gchar* _tmp1_;
	BirdFontKernList* _tmp2_;
	g_return_val_if_fail (gt != NULL, NULL);
	self = (BirdFontKernTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (gt);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	_tmp1_ = g_strdup ("kern");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp1_;
	_tmp2_ = bird_font_kern_list_new (gt);
	_g_object_unref0 (self->priv->pairs);
	self->priv->pairs = _tmp2_;
	return self;
}

BirdFontKernTable*
bird_font_kern_table_new (BirdFontGlyfTable* gt)
{
	return bird_font_kern_table_construct (BIRD_FONT_TYPE_KERN_TABLE, gt);
}

static void
bird_font_kern_table_real_parse (BirdFontOtfTable* base,
                                 BirdFontFontData* dis,
                                 GError** error)
{
	BirdFontKernTable * self;
	guint16 version = 0U;
	guint16 sub_tables = 0U;
	guint16 subtable_version = 0U;
	guint16 subtable_length = 0U;
	guint16 subtable_flags = 0U;
	guint16 search_range = 0U;
	guint16 entry_selector = 0U;
	guint16 range_shift = 0U;
	guint16 n_pairs = 0U;
	GError* _inner_error0_ = NULL;
	self = (BirdFontKernTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	version = bird_font_font_data_read_ushort (dis);
	g_warn_if_fail (((gint) version) == 0);
	sub_tables = bird_font_font_data_read_ushort (dis);
	{
		guint16 i = 0U;
		i = (guint16) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				if (!_tmp0_) {
					guint16 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < sub_tables)) {
					break;
				}
				subtable_version = bird_font_font_data_read_ushort (dis);
				subtable_length = bird_font_font_data_read_ushort (dis);
				subtable_flags = bird_font_font_data_read_ushort (dis);
				n_pairs = bird_font_font_data_read_ushort (dis);
				search_range = bird_font_font_data_read_ushort (dis);
				entry_selector = bird_font_font_data_read_ushort (dis);
				range_shift = bird_font_font_data_read_ushort (dis);
				if (((gint) (subtable_flags & BIRD_FONT_KERN_TABLE_HORIZONTAL)) > 0) {
					_tmp3_ = ((gint) (subtable_flags & BIRD_FONT_KERN_TABLE_CROSS_STREAM)) == 0;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = ((gint) (subtable_flags & BIRD_FONT_KERN_TABLE_MINIMUM)) == 0;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					bird_font_kern_table_parse_pairs (self, dis, n_pairs, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						return;
					}
				}
			}
		}
	}
}

void
bird_font_kern_table_parse_pairs (BirdFontKernTable* self,
                                  BirdFontFontData* dis,
                                  guint16 n_pairs,
                                  GError** error)
{
	guint16 left = 0U;
	guint16 right = 0U;
	gint16 k = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dis != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint16 _tmp2_ = 0;
				GeeArrayList* _tmp3_;
				BirdFontKern* _tmp4_;
				BirdFontKern* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < ((gint) n_pairs))) {
					break;
				}
				left = bird_font_font_data_read_ushort (dis);
				right = bird_font_font_data_read_ushort (dis);
				_tmp2_ = bird_font_font_data_read_short (dis, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					return;
				}
				k = _tmp2_;
				_tmp3_ = self->kerning;
				_tmp4_ = bird_font_kern_new (left, right, k);
				_tmp5_ = _tmp4_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp5_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
}

static Block81Data*
block81_data_ref (Block81Data* _data81_)
{
	g_atomic_int_inc (&_data81_->_ref_count_);
	return _data81_;
}

static void
block81_data_unref (void * _userdata_)
{
	Block81Data* _data81_;
	_data81_ = (Block81Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data81_->_ref_count_)) {
		BirdFontKernTable* self;
		self = _data81_->self;
		_g_object_unref0 (_data81_->fd);
		_g_object_unref0 (self);
		g_slice_free (Block81Data, _data81_);
	}
}

static void
__lambda56_ (Block81Data* _data81_,
             BirdFontKern* kr)
{
	BirdFontKernTable* self;
	BirdFontKern* k = NULL;
	BirdFontKern* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data81_->self;
	g_return_if_fail (kr != NULL);
	_tmp0_ = _g_object_ref0 (kr);
	k = _tmp0_;
	{
		BirdFontKern* _tmp1_;
		BirdFontKern* _tmp2_;
		gboolean _tmp10_ = FALSE;
		BirdFontKern* _tmp11_;
		BirdFontKern* _tmp20_;
		BirdFontKern* _tmp21_;
		BirdFontFontData* _tmp22_;
		BirdFontKern* _tmp23_;
		BirdFontFontData* _tmp24_;
		BirdFontKern* _tmp25_;
		BirdFontFontData* _tmp26_;
		BirdFontKern* _tmp27_;
		_tmp1_ = k;
		if (((guint) _tmp1_->left) != _data81_->last_gid_left) {
			_data81_->last_gid_right = (guint) 0;
		}
		_tmp2_ = k;
		if (G_UNLIKELY (((guint) _tmp2_->right) < _data81_->last_gid_right)) {
			BirdFontKern* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp3_ = k;
			_tmp4_ = g_strdup_printf ("%hu", _tmp3_->right);
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("%u", _data81_->last_gid_right);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strconcat ("Kerning table is not sorted ", _tmp5_, " < ", _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			g_warning ("KernTable.vala:152: %s", _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
		}
		_tmp11_ = k;
		if (((guint) _tmp11_->left) < _data81_->last_gid_left) {
			_tmp10_ = TRUE;
		} else {
			BirdFontKern* _tmp12_;
			_tmp12_ = k;
			_tmp10_ = ((guint) _tmp12_->right) < _data81_->last_gid_right;
		}
		if (_tmp10_) {
			BirdFontKern* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp13_ = k;
			_tmp14_ = g_strdup_printf ("%hu", _tmp13_->left);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%u", _data81_->last_gid_left);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strconcat ("Kerning table is not sorted. ", _tmp15_, " < ", _tmp17_, NULL);
			_tmp19_ = _tmp18_;
			g_warning ("KernTable.vala:156: %s", _tmp19_);
			_g_free0 (_tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
		}
		_tmp20_ = k;
		_data81_->last_gid_left = (guint) _tmp20_->left;
		_tmp21_ = k;
		_data81_->last_gid_right = (guint) _tmp21_->right;
		_tmp22_ = _data81_->fd;
		_tmp23_ = k;
		bird_font_font_data_add_ushort (_tmp22_, _tmp23_->left, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp24_ = _data81_->fd;
		_tmp25_ = k;
		bird_font_font_data_add_ushort (_tmp24_, _tmp25_->right, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp26_ = _data81_->fd;
		_tmp27_ = k;
		bird_font_font_data_add_short (_tmp26_, _tmp27_->kerning, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("KernTable.vala:166: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (k);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (k);
}

static void
___lambda56__bird_font_kern_list_kern_iterator (BirdFontKern* k,
                                                gpointer self)
{
	__lambda56_ (self, k);
}

void
bird_font_kern_table_process (BirdFontKernTable* self,
                              GError** error)
{
	Block81Data* _data81_;
	BirdFontFontData* _tmp0_;
	guint16 n_pairs = 0U;
	guint16 gid_left = 0U;
	guint16 range_shift = 0U;
	guint16 entry_selector = 0U;
	guint16 search_range = 0U;
	gint i = 0;
	BirdFontKernList* _tmp1_;
	BirdFontFontData* _tmp3_;
	BirdFontFontData* _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontKernList* _tmp6_;
	BirdFontFontData* _tmp8_;
	BirdFontFontData* _tmp9_;
	BirdFontFontData* _tmp10_;
	BirdFontFontData* _tmp11_;
	BirdFontFontData* _tmp12_;
	BirdFontFontData* _tmp13_;
	BirdFontKernList* _tmp14_;
	BirdFontFontData* _tmp15_;
	BirdFontFontData* _tmp16_;
	BirdFontFontData* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data81_ = g_slice_new0 (Block81Data);
	_data81_->_ref_count_ = 1;
	_data81_->self = g_object_ref (self);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	_data81_->fd = _tmp0_;
	n_pairs = (guint16) 0;
	range_shift = (guint16) 0;
	entry_selector = (guint16) 0;
	search_range = (guint16) 0;
	_tmp1_ = self->priv->pairs;
	if (bird_font_kern_list_get_length (_tmp1_) == ((guint) 0)) {
		BirdFontKernList* _tmp2_;
		_tmp2_ = self->priv->pairs;
		bird_font_kern_list_fetch_all_pairs (_tmp2_);
	}
	_tmp3_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp3_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp4_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp4_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp5_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp5_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp6_ = self->priv->pairs;
	if (((gdouble) bird_font_kern_list_get_length (_tmp6_)) > ((G_MAXUINT16 - 14) / 6.0)) {
		g_warning ("KernTable.vala:117: Too many kerning pairs!");
		n_pairs = (guint16) ((G_MAXUINT16 - 14) / 6.0);
	} else {
		BirdFontKernList* _tmp7_;
		_tmp7_ = self->priv->pairs;
		n_pairs = (guint16) bird_font_kern_list_get_length (_tmp7_);
	}
	self->kerning_pairs = (guint) n_pairs;
	_tmp8_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp8_, (guint16) ((6 * n_pairs) + 14), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp9_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp9_, BIRD_FONT_KERN_TABLE_HORIZONTAL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp10_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp10_, n_pairs, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	search_range = (guint16) (6 * bird_font_largest_pow2 (n_pairs));
	entry_selector = bird_font_largest_pow2_exponent (n_pairs);
	range_shift = (guint16) ((6 * n_pairs) - search_range);
	_tmp11_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp11_, search_range, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp12_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp12_, entry_selector, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	_tmp13_ = _data81_->fd;
	bird_font_font_data_add_ushort (_tmp13_, range_shift, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block81_data_unref (_data81_);
		_data81_ = NULL;
		return;
	}
	gid_left = (guint16) 0;
	i = 0;
	_data81_->last_gid_left = (guint) 0;
	_data81_->last_gid_right = (guint) 0;
	_tmp14_ = self->priv->pairs;
	bird_font_kern_list_all_kern (_tmp14_, ___lambda56__bird_font_kern_list_kern_iterator, _data81_, (gint) n_pairs);
	_tmp15_ = _data81_->fd;
	bird_font_font_data_pad (_tmp15_);
	_tmp16_ = _data81_->fd;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp17_;
	block81_data_unref (_data81_);
	_data81_ = NULL;
}

static void
bird_font_kern_table_class_init (BirdFontKernTableClass * klass,
                                 gpointer klass_data)
{
	bird_font_kern_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKernTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_kern_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_kern_table_finalize;
}

static void
bird_font_kern_table_instance_init (BirdFontKernTable * self,
                                    gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = bird_font_kern_table_get_instance_private (self);
	_tmp0_ = gee_array_list_new (BIRD_FONT_TYPE_KERN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->kerning = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_FK_KERN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->fk_kerning = _tmp1_;
	self->kerning_pairs = (guint) 0;
}

static void
bird_font_kern_table_finalize (GObject * obj)
{
	BirdFontKernTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERN_TABLE, BirdFontKernTable);
	_g_object_unref0 (self->priv->glyf_table);
	_g_object_unref0 (self->priv->pairs);
	_g_object_unref0 (self->kerning);
	_g_object_unref0 (self->fk_kerning);
	G_OBJECT_CLASS (bird_font_kern_table_parent_class)->finalize (obj);
}

static GType
bird_font_kern_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKernTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kern_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKernTable), 0, (GInstanceInitFunc) bird_font_kern_table_instance_init, NULL };
	GType bird_font_kern_table_type_id;
	bird_font_kern_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontKernTable", &g_define_type_info, 0);
	BirdFontKernTable_private_offset = g_type_add_instance_private (bird_font_kern_table_type_id, sizeof (BirdFontKernTablePrivate));
	return bird_font_kern_table_type_id;
}

GType
bird_font_kern_table_get_type (void)
{
	static volatile gsize bird_font_kern_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kern_table_type_id__once)) {
		GType bird_font_kern_table_type_id;
		bird_font_kern_table_type_id = bird_font_kern_table_get_type_once ();
		g_once_init_leave (&bird_font_kern_table_type_id__once, bird_font_kern_table_type_id);
	}
	return bird_font_kern_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

